/*
 * BK Id: SCCS/s.prom.h 1.19 08/17/01 15:23:17 paulus
 */
/*
 * Definitions for talking to the Open Firmware PROM on
 * Power Macintosh computers.
 *
 * Copyright (C) 1996 Paul Mackerras.
 */
#ifdef __KERNEL__
#ifndef _PPC_PROM_H
#define _PPC_PROM_H

#include <linux/config.h>

typedef void *phandle;
typedef void *ihandle;

extern char *prom_display_paths[];
extern unsigned int prom_num_displays;

struct address_range {
	unsigned int space;
	unsigned int address;
	unsigned int size;
};

struct interrupt_info {
	int	line;
	int	sense;		/* +ve/-ve logic, edge or level, etc. */
};

struct reg_property {
	unsigned int address;
	unsigned int size;
};

struct property {
	char	*name;
	int	length;
	unsigned char *value;
	struct property *next;
};

/*
 * Note: don't change this structure for now or you'll break BootX !
 */
struct device_node {
	char	*name;
	char	*type;
	phandle	node;
	int	n_addrs;
	struct	address_range *addrs;
	int	n_intrs;
	struct	interrupt_info *intrs;
	char	*full_name;
	struct	property *properties;
	struct	device_node *parent;
	struct	device_node *child;
	struct	device_node *sibling;
	struct	device_node *next;	/* next device of same type */
	struct	device_node *allnext;	/* next in list of all nodes */
};

struct prom_args;
typedef void (*prom_entry)(struct prom_args *);

/* Prototypes */
extern void abort(void);
extern unsigned long prom_init(int, int, prom_entry);
extern void prom_print(const char *msg);
extern void relocate_nodes(void);
extern void finish_device_tree(void);
extern struct device_node *find_devices(const char *name);
extern struct device_node *find_type_devices(const char *type);
extern struct device_node *find_path_device(const char *path);
extern struct device_node *find_compatible_devices(const char *type,
						   const char *compat);
extern struct device_node *find_all_nodes(void);
extern int device_is_compatible(struct device_node *device, const char *);
extern int machine_is_compatible(const char *compat);
extern unsigned char *get_property(struct device_node *node, const char *name,
				   int *lenp);
extern void prom_add_property(struct device_node* np, struct property* prop);
extern void prom_get_irq_senses(unsigned char *, int, int);
extern int prom_n_addr_cells(struct device_node* np);
extern int prom_n_size_cells(struct device_node* np);

extern void print_properties(struct device_node *node);
extern int call_rtas(const char *service, int nargs, int nret,
		     unsigned long *outputs, ...);

/*
 * When we call back to the Open Firmware client interface, we usually
 * have to do that before the kernel is relocated to its final location
 * (this is because we can't use OF after we have overwritten the
 * exception vectors with our exception handlers).  These macros assist
 * in performing the address calculations that we need to do to access
 * data when the kernel is running at an address that is different from
 * the address that the kernel is linked at.  The reloc_offset() function
 * returns the difference between these two addresses and the macros
 * simplify the process of adding or subtracting this offset to/from
 * pointer values.  See arch/ppc/kernel/prom.c for how these are used.
 */
extern unsigned long reloc_offset(void);

#define PTRRELOC(x)	((typeof(x))((unsigned long)(x) + offset))
#define PTRUNRELOC(x)	((typeof(x))((unsigned long)(x) - offset))
#define RELOC(x)	(*PTRRELOC(&(x)))

#endif /* _PPC_PROM_H */
#endif /* __KERNEL__ */
