/*
 * Userspace Semaphores
 */
#ifndef	_USERSEM_H
#define	_USERSEM_H
#include <unistd.h> /* size_t */

/* You should never touch this structure directly! */
struct futex
{
	int count;
};

#if defined(__powerpc__)
#include "ppc.h"
#elif defined(__i386__)
#include "i386.h"
#endif

/* Down and up operations */
extern int sys_futex(struct futex *, int);

static inline int futex_down(struct futex *futx)
{
	if (__futex_down(&futx->count))
		return sys_futex(futx, -1);
	return 0;
}

/* If __up increments count from 0 -> 1, noone was waiting.
   Otherwise, others might be, so enter kernel which sets to 1 and
   wakes them up. */
static inline int futex_up(struct futex *futx)
{
	if (__futex_up(&futx->count))
		return sys_futex(futx, 1);
	return 0;
}

/* Prepare this area for futex use (returns -ve on error). */
int futex_region(void *area, size_t size);
void futex_init(struct futex *sem);
#endif /* _USERSEM_H */
