/******************************************************************************
 *
 * Name:	skqueue.c
 * Project:	SysKonnect SK-9Dxx Gigabit Ethernet
 * Version:	$Revision: 1.3 $
 * Date:	$Date: 2001/09/21 12:00:14 $
 * Purpose:	Management of an event queue.
 *
 ******************************************************************************/

/******************************************************************************
 *
 *	(C)Copyright 2001 SysKonnect GmbH.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	The information in this file is provided "AS IS" without warranty.
 *
 ******************************************************************************/

/******************************************************************************
 *
 * History:
 *
 *	$Log: skqueue.c,v $
 *	Revision 1.3  2001/09/21 12:00:14  mmoser
 *	remove debug print statement
 *	
 *	Revision 1.2  2001/08/08 13:47:40  rschmidt
 *	Replaced printk with SK_DBG_MSG
 *	
 *	Revision 1.1  2001/06/05 08:28:25  rassmann
 *	First public version.
 *	
 *
 ******************************************************************************/

/******************************************************************************
 *
 * Description:
 *
 * This module is intended to manage an event queue.
 *
 * Include File Hierarchy:
 *
 *	"skdrv1st.h"
 *	"skqueue.h"
 *	"skdrv2nd.h"
 *
 ******************************************************************************/

static const char SysKonnectFileId[] =
	"@(#) $Id: skqueue.c,v 1.3 2001/09/21 12:00:14 mmoser Exp $ (C) SysKonnect.";


#include "h/skdrv1st.h"		/* Driver-specific definitions */
#include "h/skqueue.h"		/* Queue definitions */
#include "h/skdrv2nd.h"		/* Adapter control and driver-specific defs. */



/******************************************************************************
 * init event queue management
 *
 * Must be called during init level 0.
 */
void	SkEventInit(
SK_AC	*pAC, 	/* Adapter context */
SK_IOC	IoC, 	/* IO context */
int		Level)	/* Init level */
{
	switch (Level) {
	case SK_INIT_DATA:
		pAC->Event.EvPut = pAC->Event.EvGet = pAC->Event.EvQueue;
		break;

	default:
		break;
	}
}	/* SkEventInit */


/******************************************************************************
 * add event to queue
 */
void	SkEventQueue(
SK_AC		*pAC, 	/* Adapters context */
SK_U32		Class, 	/* Event Class */
SK_U32		Event, 	/* Event to be queued */
SK_EVPARA	Para)	/* Event parameter */
{
	pAC->Event.CheckQueue = SK_TRUE;
	pAC->Event.EvPut->Class = Class;
	pAC->Event.EvPut->Event = Event;
	pAC->Event.EvPut->Para = Para;
	if (++pAC->Event.EvPut == &pAC->Event.EvQueue[SK_MAX_EVENT]) {
		pAC->Event.EvPut = pAC->Event.EvQueue;
	}

	if (pAC->Event.EvPut == pAC->Event.EvGet) {
		SK_ERR_LOG(pAC, SK_ERRCL_NORES, SKERR_Q_E001, SKERR_Q_E001MSG);
	}
}	/* SkEventQueue */


/******************************************************************************
 * event dispatcher
 *	while event queue is not empty
 *		get event from queue
 *		send command to state machine
 *	end
 *	return error reported by individual Event function
 *		0 if no error occured.
 */
int	SkEventDispatcher(
SK_AC	*pAC, 	/* Adapters Context */
SK_IOC	IoC)	/* Io context */
{
	SK_EVENTELEM	*pEv;	/* pointer into queue */
	SK_U32			Class;
	int				Rtv;

	pEv = pAC->Event.EvGet;
/*
	SK_DBG_MSG(pAC, SK_DBGMOD_PECP, SK_DBGCAT_QUEUE,
	("dispatch get %x put %x\n", (unsigned)pEv, (unsigned)pAC->Event.EvPut));
*/	
	while (pEv != pAC->Event.EvPut) {
		SK_DBG_MSG(pAC, SK_DBGMOD_PECP, SK_DBGCAT_QUEUE,
		("dispatch Class %d Event %d\n", pEv->Class, pEv->Event));
		switch(Class = pEv->Class) {
		case SKGI_DRV:		/* Driver Event */
			Rtv = SkGiDrvEvent(pAC, IoC, pEv->Event, pEv->Para);
			break;

		case SKGI_RLMT:	/* RLMT Event */
			Rtv = SkRlmtEvent(pAC, IoC, pEv->Event, pEv->Para);
			break;

		case SKGI_PNMI:
			Rtv = SkPnmiEvent(pAC, IoC, pEv->Event, pEv->Para);
			break;

		case SKGI_HWAC:
			Rtv = SkGiHwEvent(pAC, IoC, pEv->Event, pEv->Para);
			break;

#ifdef	SK_USE_CSUM
		case SKGI_CSUM:
			Rtv = SkCsEvent(pAC, IoC, pEv->Event, pEv->Para);
			break;
#endif	/* SK_USE_CSUM */

		default :
			SK_ERR_LOG(pAC, SK_ERRCL_SW, SKERR_Q_E002, SKERR_Q_E002MSG);
			Rtv = 0;
			break;
		}

		if (Rtv != 0) {
			return (Rtv);
		}

		if (++pEv == &pAC->Event.EvQueue[SK_MAX_EVENT])
			pEv = pAC->Event.EvQueue;

		/* Renew get: it is used in queue_events to detect overruns. */
		pAC->Event.EvGet = pEv;
	}

	pAC->Event.CheckQueue = SK_FALSE;
	return (0);
}	/* SkEventDispatcher */

