/* capability handling routines, (c) Brad Spengler 2002,2003 */

#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/capability.h>
#include <linux/gracl.h>
#include <linux/grsecurity.h>
#include <linux/grinternal.h>

static const char *captab_log[29] = {
	"CAP_CHOWN",
	"CAP_DAC_OVERRIDE",
	"CAP_DAC_READ_SEARCH",
	"CAP_FOWNER",
	"CAP_FSETID",
	"CAP_KILL",
	"CAP_SETGID",
	"CAP_SETUID",
	"CAP_SETPCAP",
	"CAP_LINUX_IMMUTABLE",
	"CAP_NET_BIND_SERVICE",
	"CAP_NET_BROADCAST",
	"CAP_NET_ADMIN",
	"CAP_NET_RAW",
	"CAP_IPC_LOCK",
	"CAP_IPC_OWNER",
	"CAP_SYS_MODULE",
	"CAP_SYS_RAWIO",
	"CAP_SYS_CHROOT",
	"CAP_SYS_PTRACE",
	"CAP_SYS_PACCT",
	"CAP_SYS_ADMIN",
	"CAP_SYS_BOOT",
	"CAP_SYS_NICE",
	"CAP_SYS_RESOURCE",
	"CAP_SYS_TIME",
	"CAP_SYS_TTY_CONFIG",
	"CAP_MKNOD",
	"CAP_LEASE"
};

int
gr_is_capable(const int cap)
{
	struct acl_subject_label *curracl;

	if (!gr_acl_is_enabled())
		return 1;

	curracl = current->acl;

	if (!cap_raised(curracl->cap_lower, cap))
		return 1;

	if ((curracl->mode & GR_LEARN)
	    && cap_raised(current->cap_effective, cap)) {
		security_learn(GR_LEARN_AUDIT_MSG, curracl->device,
			       curracl->inode, 0UL, 0UL, "",
			       (unsigned long) cap);
		return 1;
	}

	if ((cap >= 0) && (cap < 29) && cap_raised(current->cap_effective, cap))
		security_alert(GR_CAP_ACL_MSG, captab_log[cap], DEFAULTSECARGS);

	return 0;
}
