/*******************************************************************
 * This file is part of the Emulex Linux Device Driver for         *
 * Enterprise Fibre Channel Host Bus Adapters.                     *
 * Refer to the README file included with this package for         *
 * driver version and adapter support.                             *
 * Copyright (C) 2003 Emulex Corporation.                          *
 * www.emulex.com                                                  *
 *                                                                 *
 * This program is free software; you can redistribute it and/or   *
 * modify it under the terms of the GNU General Public License     *
 * as published by the Free Software Foundation; either version 2  *
 * of the License, or (at your option) any later version.          *
 *                                                                 *
 * This program is distributed in the hope that it will be useful, *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of  *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   *
 * GNU General Public License for more details, a copy of which    *
 * can be found in the file COPYING included with this package.    *
 *******************************************************************/
#if   !defined(_KERNEL) && !defined(__KERNEL__)
#endif 


#define _DFC_64BIT 1

#ifdef BITS_PER_LONG
#if BITS_PER_LONG < 64 
#undef _DFC_64BIT
#endif
#endif

#ifdef i386
#undef _DFC_64BIT
#endif

#ifdef powerpc
#ifndef CONFIG_PPC64
#undef _DFC_64BIT
#endif
#endif


struct dfccmdinfo {
#ifdef _DFC_64BIT
   char                 *c_datain;
   char                 *c_dataout;
   unsigned short       c_cmd;
   unsigned short       c_insz;
   uint32               c_outsz;
#else
   void                 *c_filler1;
   char                 *c_datain;
   void                 *c_filler2;
   char                 *c_dataout;
   unsigned short       c_cmd;
   unsigned short       c_insz;
   uint32               c_outsz;
#endif 
};

struct cmd_input {
#ifdef _DFC_64BIT
   short                c_brd;
   short                c_ring;
   short                c_iocb;
   short                c_flag;
   void                 *c_arg1;
   void                 *c_arg2;
   void                 *c_arg3;
   char                 c_string[16];
#else
   short                c_brd;
   short                c_ring;
   short                c_iocb;
   short                c_flag;
   void                 *c_filler1;
   void                 *c_arg1;
   void                 *c_filler2;
   void                 *c_arg2;
   void                 *c_filler3;
   void                 *c_arg3;
   char                 c_string[16];
#endif 
};



struct cmdinfo {
   int                  c_cmd;
   char                 *c_string;
   int                  (*c_routine)(struct cmdinfo *cp, void *p);
   char                 *c_datain;
   char                 *c_dataout;
   unsigned short       c_insz;
   unsigned short       c_outsz;
};

#define C_INVAL                 0x0
#define C_DISPLAY_PCI_ALL       0x1
#define C_WRITE_PCI             0x2
#define C_WRITE_HC              0x3
#define C_WRITE_HS              0x4
#define C_WRITE_HA              0x5
#define C_WRITE_CA              0x6
#define C_READ_PCI              0x7
#define C_READ_HC               0x8
#define C_READ_HS               0x9
#define C_READ_HA               0xa
#define C_READ_CA               0xb
#define C_READ_MB               0xc
#define C_EXIT                  0xd
#define C_SET                   0xe
#define C_READ_RING             0xf
#define C_READ_MEM              0x10
#define C_READ_IOCB             0x11
#define C_READ_RPILIST          0x12
#define C_READ_BPLIST           0x13
#define C_READ_MEMSEG           0x14
#define C_MBOX                  0x15
#define C_RESET                 0x16
#define C_READ_BINFO            0x17
#define C_NDD_STAT              0x18
#define C_FC_STAT               0x19
#define C_WRITE_MEM             0x1a
#define C_WRITE_CTLREG          0x1b
#define C_READ_CTLREG           0x1c
#define C_INITBRDS              0x1d
#define C_SETDIAG               0x1e
#define C_DBG                   0x1f
#define C_GET_PHYSADDR          0x20
#define C_PUT_PHYSADDR          0x21
#define C_NODE                  0x22
#define C_DEVP                  0x23
#define C_INST                  0x24
#define C_LIP                   0x25
#define C_LINKINFO              0x26
#define C_IOINFO                0x27
#define C_NODEINFO              0x28
#define C_GETCFG                0x29
#define C_SETCFG                0x2a
#define C_FAILIO                0x2b
#define C_OUTFCPIO              0x2c
#define C_RSTQDEPTH             0x2d
#define C_CT                    0x2e
#define C_HBA_ADAPTERATRIBUTES  0x33
#define C_HBA_PORTATRIBUTES 0x34
#define C_HBA_PORTSTATISTICS    0x35
#define C_HBA_DISCPORTATRIBUTES 0x36
#define C_HBA_WWPNPORTATRIBUTES 0x37
#define C_HBA_INDEXPORTATRIBUTES 0x38
#define C_HBA_FCPTARGETMAPPING  0x39
#define C_HBA_FCPBINDING    0x3a
#define C_HBA_SETMGMTINFO   0x3b
#define C_HBA_GETMGMTINFO   0x3c
#define C_HBA_RNID      0x3d
#define C_HBA_GETEVENT      0x3e
#define C_HBA_RESETSTAT     0x3f
#define C_HBA_SEND_SCSI     0x40
#define C_HBA_REFRESHINFO   0x41
#define C_SEND_ELS          0x42
#define C_LISTN                 0x45
#define C_TRACE                 0x46
#define C_HELP                  0x47
#define C_HBA_SEND_FCP          0x48
#define C_SET_EVENT             0x49
#define C_GET_EVENT             0x4a
#define C_SEND_MGMT_CMD         0x4b
#define C_SEND_MGMT_RSP         0x4c
#define C_LISTEVT               0x59
#define C_MAX_CMDS              0x5a

#define DFC_MBX_MAX_CMDS        29

/* Structure for OUTFCPIO command */
struct out_fcp_io {
   ushort  tx_count;
   ushort  txp_count;
   ushort  timeout_count;
   ushort  devp_count;
   void    * tx_head;
   void    * tx_tail;
   void    * txp_head;
   void    * txp_tail;
   void    * timeout_head;
};

struct out_fcp_devp {
   ushort       target;
   ushort       lun;
   uint32       standby_count;  
   uint32       pend_count;
   uint32       clear_count;
   void        *standby_queue_head;
   void        *standby_queue_tail;
   void        *pend_head;      
   void        *pend_tail;     
   void        *clear_head;
};

