/* 
 * $Id$
 * AES cipher wrapper for i586 optimized assembler implementation
 *
 * Copyright (C) 2002 Herbert Valerio Riedel <hvr@gnu.org>
 * 
 * This module is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This module is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this module; if not, write to the Free Software
 *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <linux/module.h>
#include <linux/init.h>
#include <linux/types.h>
#include <linux/version.h>
#include <linux/config.h>

#include "linux/crypto.h"

#ifdef MODULE_LICENSE
MODULE_LICENSE ("Dual BSD/GPL");
#endif
#ifdef MODULE_DESCRIPTION
MODULE_DESCRIPTION ("AES (Rijndael) Cipher (i586 optimized) / CryptoAPI");
#endif
#ifdef MODULE_AUTHOR
MODULE_AUTHOR ("Dr Brian Gladman <brg@gladman.uk.net>");
#endif

typedef struct {
	u32 key_len_words;
	u32 rounds;
	u32 encryption_key[4 * 16];	/* key schedule */
	u32 decryption_key[4 * 16];
} aes_key_t;

#include "cipher-aes-i586.c"

static int
aes_set_key (struct cipher_context *cx, const u8 *in_key,
	     int key_len, int atomic)
{
	extern void _aes_set_key (aes_key_t *, const u8 *in_key,
				  const int key_len, const int);

	aes_key_t *ctx = (aes_key_t *) cx->keyinfo;

	if (key_len != 16 && key_len != 24 && key_len != 32)
		return -EINVAL;	/* unsupported key length */

	cx->key_length = key_len;

	_aes_set_key (ctx, in_key, key_len, 0);

	return 0;
}

static inline int
aes_encrypt (struct cipher_context *cx,
	     const u8 *in, u8 *out, int size, int atomic)
{
	extern void _aes_encrypt (const aes_key_t *, const u8 *in, u8 *out);

	const aes_key_t *ctx = (aes_key_t *) cx->keyinfo;

	if (size != 16)
		return -EINVAL;

	_aes_encrypt (ctx, in, out);

	return 0;
}

static inline int
aes_decrypt (struct cipher_context *cx,
	     const u8 *in, u8 *out, int size, int atomic)
{
	extern void _aes_decrypt (const aes_key_t *, const u8 *in, u8 *out);

	const aes_key_t *ctx = (aes_key_t *) cx->keyinfo;

	if (size != 16)
		return -EINVAL;

	_aes_decrypt (ctx, in, out);

	return 0;
}

#define CIPHER_ID                aes
#define CIPHER_BLOCKSIZE         128
#define CIPHER_KEY_SIZE_MASK     CIPHER_KEYSIZE_128 | CIPHER_KEYSIZE_192 | \
                                 CIPHER_KEYSIZE_256
#define CIPHER_KEY_SCHEDULE_SIZE sizeof (aes_key_t)

#if !defined(CONFIG_X86)
# error Assembler code only suitable for x86 arch!
#else /* CONFIG_X86 */
# if defined(CONFIG_M386) || defined(CONFIG_M486)
#  warning ******************************************************************
#  warning kernel was configured for i386 or i486; are you sure you want to compile i586 code?
#  warning ******************************************************************
# endif
# include "gen-cipher.h"
#endif /* CONFIG_X86 */

EXPORT_NO_SYMBOLS;

/* eof */
