/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
/* 
 * Global constants and data types 
 */

#ifndef CM_TYPES_H
#define CM_TYPES_H

/* constants */

#ifdef NULLPTR
#undef NULLPTR
#endif
#define NULLPTR        ((void *) NULL)


#ifdef TRUE
#undef TRUE
#endif
#define TRUE           1


#ifdef FALSE
#undef FALUE
#endif
#define FALSE          0


#define YES            TRUE
#define NO             FALSE



/* Command type masks */
#define NCB_CMD_NO_WAIT_MASK   0x80        /* Asynchronous (NO WAIT) cmd */
#define NCB_CMD_WAIT_MASK      0x00        /* Synchronous (WAIT) cmd */


/* lsn range */
#define NCB_LSN_MIN            0x01
#define NCB_LSN_MAX            0xFE


/* Basic, generic types used throughout layers */
typedef unsigned char          us8;
typedef unsigned short         us16;
typedef unsigned long          us32;

typedef unsigned short         boolean;        /* either TRUE or FALSE */
typedef unsigned short         flag_yn;        /* either YES or NO */
typedef unsigned short         flag_on_off;    /* either ON or OFF */

typedef us32                   handle_t;       /* generic handle */


#ifdef TESTING
struct device
{
   us8 *               name;
   us16                addr_len;
   us8                 dev_addr[6];
   us8                 broadcast[6];
};
#endif /*TESTING */

#endif /* CM_TYPES_H */


