/*!
  The style for shapes and text, font, color, etc.
*/
mod color;
pub mod colors;
mod font;
mod palette;
mod shape;
mod size;
mod text;

/// Definitions of palettes of accessibility
pub use self::palette::*;
pub use color::{Color, HSLColor, PaletteColor, RGBAColor, RGBColor};
pub use colors::{BLACK, BLUE, CYAN, GREEN, MAGENTA, RED, TRANSPARENT, WHITE, YELLOW};
pub use font::{
    FontDesc, FontError, FontFamily, FontResult, FontStyle, FontTransform, IntoFont, LayoutBox,
};
pub use shape::ShapeStyle;
pub use size::{AsRelative, RelativeSize, SizeDesc};
pub use text::text_anchor;
pub use text::{IntoTextStyle, TextStyle};
