'\"
'\" Copyright (c) 1994 The Australian National University
'\" Copyright (c) 1994-1997 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" Author: Paul Mackerras (paulus@cs.anu.edu.au),
'\"	    Department of Computer Science,
'\"	    Australian National University.
'\"
.TH photo n 4.0 Tk "Tk Built-In Commands"
.so man.macros
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
photo \- Full-color images
.SH SYNOPSIS
.nf
\fBimage create photo \fR?\fIname\fR? ?\fIoptions\fR?

\fIimageName \fBblank\fR
\fIimageName \fBcget \fIoption\fR
\fIimageName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
\fIimageName \fBcopy \fIsourceImage\fR ?\fIoption value(s) ...\fR?
\fIimageName \fBdata\fR ?\fIoption value(s) ...\fR?
\fIimageName \fBget \fIx y\fR
\fIimageName \fBput \fIdata\fR ?\fIoption value(s) ...\fR?
\fIimageName \fBread \fIfilename\fR ?\fIoption value(s) ...\fR?
\fIimageName \fBredither\fR
\fIimageName \fBtransparency \fIsubcommand \fR?\fIarg arg ...\fR?
\fIimageName \fBwrite \fIfilename\fR ?\fIoption value(s) ...\fR?
.fi
.BE
.SH DESCRIPTION
.PP
A photo is an image whose pixels can display any color or be
transparent.  A photo image is stored internally in full color (32
bits per pixel), and is displayed using dithering if necessary.  Image
data for a photo image can be obtained from a file or a string, or it
can be supplied from
C code through a procedural interface.  At present, only
.VS 8.6
PNG,
.VE 8.6
GIF and PPM/PGM
formats are supported, but an interface exists to allow additional
image file formats to be added easily.  A photo image is transparent
in regions where no image data has been supplied
or where it has been set transparent by the \fBtransparency set\fR
subcommand.
.SH "CREATING PHOTOS"
.PP
Like all images, photos are created using the \fBimage create\fR
command.
Photos support the following \fIoptions\fR:
.TP
\fB\-data \fIstring\fR
.
Specifies the contents of the image as a string.  The string should
contain binary data or, for some formats, base64-encoded data (this is
currently guaranteed to be supported for PNG and GIF images). The
format of the
string must be one of those for which there is an image file format
handler that will accept string data.  If both the \fB\-data\fR
and \fB\-file\fR options are specified, the \fB\-file\fR option takes
precedence.
.TP
\fB\-format \fIformat-name\fR
.
Specifies the name of the file format for the data specified with the
\fB\-data\fR or \fB\-file\fR option.
.TP
\fB\-file \fIname\fR
.
\fIname\fR gives the name of a file that is to be read to supply data
for the photo image.  The file format must be one of those for which
there is an image file format handler that can read data.
.TP
\fB\-gamma \fIvalue\fR
.
Specifies that the colors allocated for displaying this image in a
window should be corrected for a non-linear display with the specified
gamma exponent value.  (The intensity produced by most
CRT displays is a power function of the input value, to a good
approximation; gamma is the exponent and is typically around 2).
The value specified must be greater than zero.  The default
value is one (no correction).  In general, values greater than one
will make the image lighter, and values less than one will make it
darker.
.TP
\fB\-height \fInumber\fR
.
Specifies the height of the image, in pixels.  This option is useful
primarily in situations where the user wishes to build up the contents
of the image piece by piece.  A value of zero (the default) allows the
image to expand or shrink vertically to fit the data stored in it.
.TP
\fB\-palette \fIpalette-spec\fR
.
Specifies the resolution of the color cube to be allocated for
displaying this image, and thus the number of colors used from the
colormaps of the windows where it is displayed.  The
\fIpalette-spec\fR string may be either a single decimal number,
specifying the number of shades of gray to use, or three decimal
numbers separated by slashes (/), specifying the number of shades of
red, green and blue to use, respectively.  If the first form (a single
number) is used, the image will be displayed in monochrome (i.e.,
grayscale).
.TP
\fB\-width \fInumber\fR
.
Specifies the width of the image, in pixels.    This option is useful
primarily in situations where the user wishes to build up the contents
of the image piece by piece.  A value of zero (the default) allows the
image to expand or shrink horizontally to fit the data stored in it.
.SH "IMAGE COMMAND"
.PP
When a photo image is created, Tk also creates a new command
whose name is the same as the image.
This command may be used to invoke various operations
on the image.
It has the following general form:
.CS
\fIimageName option \fR?\fIarg arg ...\fR?
.CE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.
.PP
Those options that write data to the image generally expand the size
of the image, if necessary, to accommodate the data written to the
image, unless the user has specified non-zero values for the
\fB\-width\fR and/or \fB\-height\fR configuration options, in which
case the width and/or height, respectively, of the image will not be
changed.
.PP
The following commands are possible for photo images:
.TP
\fIimageName \fBblank\fR
.
Blank the image; that is, set the entire image to have no data, so it
will be displayed as transparent, and the background of whatever
window it is displayed in will show through.
.TP
\fIimageName \fBcget\fR \fIoption\fR
.
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the
\fBimage create\fR \fBphoto\fR command.
.TP
\fIimageName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
.
Query or modify the configuration options for the image.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIimageName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the
\fBimage create\fR \fBphoto\fR command.
.TP
\fIimageName \fBcopy\fR \fIsourceImage\fR ?\fIoption value(s) ...\fR?
.
Copies a region from the image called \fIsourceImage\fR (which must
be a photo image) to the image called \fIimageName\fR, possibly with
pixel zooming and/or subsampling.  If no options are specified, this
command copies the whole of \fIsourceImage\fR into \fIimageName\fR,
starting at coordinates (0,0) in \fIimageName\fR.  The following
options may be specified:
.RS
.TP
\fB\-from \fIx1 y1 x2 y2\fR
.
Specifies a rectangular sub-region of the source image to be copied.
(\fIx1,y1\fR) and (\fIx2,y2\fR) specify diagonally opposite corners of
the rectangle.  If \fIx2\fR and \fIy2\fR are not specified, the
default value is the bottom-right corner of the source image.  The
pixels copied will include the left and top edges of the specified
rectangle but not the bottom or right edges.  If the \fB\-from\fR
option is not given, the default is the whole source image.
.TP
\fB\-to \fIx1 y1 x2 y2\fR
.
Specifies a rectangular sub-region of the destination image to be
affected.  (\fIx1,y1\fR) and (\fIx2,y2\fR) specify diagonally opposite
corners of the rectangle.  If \fIx2\fR and \fIy2\fR are not specified,
the default value is (\fIx1,y1\fR) plus the size of the source
region (after subsampling and zooming, if specified).  If \fIx2\fR and
\fIy2\fR are specified, the source region will be replicated if
necessary to fill the destination region in a tiled fashion.
.TP
\fB\-shrink\fR
.
Specifies that the size of the destination image should be reduced, if
necessary, so that the region being copied into is at the bottom-right
corner of the image.  This option will not affect the width or height
of the image if the user has specified a non-zero value for the
\fB\-width\fR or \fB\-height\fR configuration option, respectively.
.TP
\fB\-zoom \fIx y\fR
.
Specifies that the source region should be magnified by a factor of
\fIx\fR in the X direction and \fIy\fR in the Y direction.  If \fIy\fR
is not given, the default value is the same as \fIx\fR.  With this
option, each pixel in the source image will be expanded into a block
of \fIx\fR x \fIy\fR pixels in the destination image, all the same
color.  \fIx\fR and \fIy\fR must be greater than 0.
.TP
\fB\-subsample \fIx y\fR
.
Specifies that the source image should be reduced in size by using
only every \fIx\fRth pixel in the X direction and \fIy\fRth pixel in
the Y direction.  Negative values will cause the image to be flipped
about the Y or X axes, respectively.  If \fIy\fR is not given, the
default value is the same as \fIx\fR.
.TP
\fB\-compositingrule \fIrule\fR
.
Specifies how transparent pixels in the source image are combined with
the destination image.  When a compositing rule of \fIoverlay\fR is
set, the old contents of the destination image are visible, as if the
source image were printed on a piece of transparent film and placed
over the top of the destination.  When a compositing rule of \fIset\fR
is set, the old contents of the destination image are discarded and
the source image is used as-is.  The default compositing rule is
\fIoverlay\fR.
.RE
.TP
\fIimageName \fBdata\fR ?\fIoption value(s) ...\fR?
.
Returns image data in the form of a string. The following options
may be specified:
.RS
.TP
\fB\-background\fI color\fR
.
If the color is specified, the data will not contain any transparency
information. In all transparent pixels the color will be replaced by
the specified color.
.TP
\fB\-format\fI format-name\fR
.
Specifies the name of the image file format handler to be used.
Specifically, this subcommand searches
for the first handler whose name matches an initial substring of
\fIformat-name\fR and which has the capability to write a string
containing this image data.
If this option is not given, this subcommand uses a format that
consists of a list (one element per row) of lists (one element per
pixel/column) of colors in
.QW \fB#\fIrrggbb\fR
format (where \fIrr\fR is a pair of hexadecimal digits for the red
channel, \fIgg\fR for green, and \fIbb\fR for blue).
.TP
\fB\-from \fIx1 y1 x2 y2\fR
.
Specifies a rectangular region of \fIimageName\fR to be returned.
If only \fIx1\fR and \fIy1\fR are specified, the region
extends from \fI(x1,y1)\fR to the bottom-right corner of
\fIimageName\fR.  If all four coordinates are given, they specify
diagonally opposite corners of the rectangular region, including x1,y1
and excluding x2,y2.  The default, if this option is not given, is the
whole image.
.TP
\fB\-grayscale\fR
.
If this options is specified, the data will not contain color
information. All pixel data will be transformed into grayscale.
.RE
.TP
\fIimageName \fBget\fR \fIx y\fR
.
Returns the color of the pixel at coordinates (\fIx\fR,\fIy\fR) in the
image as a list of three integers between 0 and 255, representing the
red, green and blue components respectively.
.TP
\fIimageName \fBput\fR \fIdata\fR ?\fIoption value(s) ...\fR?
.
Sets pixels in \fI imageName\fR to the data specified in \fIdata\fR.
This command first searches the list of image file format handlers for
a handler that can interpret the data in \fIdata\fR, and then reads
the image encoded within into \fIimageName\fR (the destination image).
If \fIdata\fR does not match any known format, an attempt to interpret
it as a (top-to-bottom) list of scan-lines is made, with each
scan-line being a (left-to-right) list of pixel colors (see
\fBTk_GetColor\fR for a description of valid colors.)  Every scan-line
must be of the same length.  Note that when \fIdata\fR is a single
color name, you are instructing Tk to fill a rectangular region with
that color.  The following options may be specified:
.RS
.TP
\fB\-format \fIformat-name\fR
.
Specifies the format of the image data in \fIdata\fR.
Specifically, only image file format handlers whose names begin with
\fIformat-name\fR will be used while searching for an image data
format handler to read the data.
.TP
\fB\-to \fIx1 y1\fR ?\fIx2 y2\fR?
.
Specifies the coordinates of the top-left corner (\fIx1\fR,\fIy1\fR)
of the region of \fIimageName\fR into which the image data will be
copied.  The default position is (0,0).  If \fIx2\fR,\fIy2\fR is given
and \fIdata\fR is not large enough to cover the rectangle specified by
this option, the image data extracted will be tiled so it covers the
entire destination rectangle.  Note that if \fIdata\fR specifies a
single color value, then a region extending to the bottom-right corner
represented by (\fIx2\fR,\fIy2\fR) will be filled with that color.
.RE
.TP
\fIimageName \fBread\fR \fIfilename\fR ?\fIoption value(s) ...\fR?
.
Reads image data from the file named \fIfilename\fR into the image.
This command first searches the list of
image file format handlers for a handler that can interpret the data
in \fIfilename\fR, and then reads the image in \fIfilename\fR into
\fIimageName\fR (the destination image).  The following options may be
specified:
.RS
.TP
\fB\-format \fIformat-name\fR
.
Specifies the format of the image data in \fIfilename\fR.
Specifically, only image file format handlers whose names begin with
\fIformat-name\fR will be used while searching for an image data
format handler to read the data.
.TP
\fB\-from \fIx1 y1 x2 y2\fR
.
Specifies a rectangular sub-region of the image file data to be copied
to the destination image.  If only \fIx1\fR and \fIy1\fR are
specified, the region extends from (\fIx1,y1\fR) to the bottom-right
corner of the image in the image file.  If all four coordinates are
specified, they specify diagonally opposite corners or the region.
The default, if this option is not specified, is the whole of the
image in the image file.
.TP
\fB\-shrink\fR
.
If this option, the size of \fIimageName\fR will be reduced, if
necessary, so that the region into which the image file data are read
is at the bottom-right corner of the \fIimageName\fR.  This option
will not affect the width or height of the image if the user has
specified a non-zero value for the \fB\-width\fR or \fB\-height\fR
configuration option, respectively.
.TP
\fB\-to \fIx y\fR
.
Specifies the coordinates of the top-left corner of the region of
\fIimageName\fR into which data from \fIfilename\fR are to be read.
The default is (0,0).
.RE
.TP
\fIimageName \fBredither\fR
.
The dithering algorithm used in displaying photo images propagates
quantization errors from one pixel to its neighbors.
If the image data for \fIimageName\fR is supplied in pieces, the
dithered image may not be exactly correct.  Normally the difference is
not noticeable, but if it is a problem, this command can be used to
recalculate the dithered image in each window where the image is
displayed.
.TP
\fIimageName \fBtransparency \fIsubcommand \fR?\fIarg arg ...\fR?
.
Allows examination and manipulation of the transparency information in
the photo image.  Several subcommands are available:
.RS
.TP
\fIimageName \fBtransparency get \fIx y\fR
.
Returns a boolean indicating if the pixel at (\fIx\fR,\fIy\fR) is
transparent.
.TP
\fIimageName \fBtransparency set \fIx y boolean\fR
.
Makes the pixel at (\fIx\fR,\fIy\fR) transparent if \fIboolean\fR is
true, and makes that pixel opaque otherwise.
.RE
.TP
\fIimageName \fBwrite \fIfilename\fR ?\fIoption value(s) ...\fR?
.
Writes image data from \fIimageName\fR to a file named \fIfilename\fR.
The following options may be specified:
.RS
.TP
\fB\-background\fI color\fR
.
If the color is specified, the data will not contain any transparency
information. In all transparent pixels the color will be replaced by
the specified color.
.TP
\fB\-format\fI format-name\fR
.
Specifies the name of the image file format handler to be used to
write the data to the file.  Specifically, this subcommand searches
for the first handler whose name matches an initial substring of
\fIformat-name\fR and which has the capability to write an image
file.  If this option is not given, the format is guessed from
the file extension. If that cannot be determined, this subcommand
uses the first handler that has the capability to write an image file.
.TP
\fB\-from \fIx1 y1 x2 y2\fR
.
Specifies a rectangular region of \fIimageName\fR to be written to the
image file.  If only \fIx1\fR and \fIy1\fR are specified, the region
extends from \fI(x1,y1)\fR to the bottom-right corner of
\fIimageName\fR.  If all four coordinates are given, they specify
diagonally opposite corners of the rectangular region.  The default,
if this option is not given, is the whole image.
.TP
\fB\-grayscale\fR
.
If this options is specified, the data will not contain color
information. All pixel data will be transformed into grayscale.
.RE
.SH "IMAGE FORMATS"
.PP
The photo image code is structured to allow handlers for additional
image file formats to be added easily.  The photo image code maintains
a list of these handlers.  Handlers are added to the list by
registering them with a call to \fBTk_CreatePhotoImageFormat\fR.  The
standard Tk distribution comes with handlers for PPM/PGM, PNG and GIF
formats, which are automatically registered on initialization.
.PP
When reading an image file or processing
string data specified with the \fB\-data\fR configuration option, the
photo image code invokes each handler in turn until one is
found that claims to be able to read the data in the file or string.
Usually this will find the correct handler, but if it does not, the
user may give a format name with the \fB\-format\fR option to specify
which handler to use.  In fact the photo image code will try those
handlers whose names begin with the string specified for the
\fB\-format\fR option (the comparison is case-insensitive).  For
example, if the user specifies \fB\-format gif\fR, then a handler
named GIF87 or GIF89 may be invoked, but a handler
named JPEG may not (assuming that such handlers had been
registered).
.PP
When writing image data to a file, the processing of the
\fB\-format\fR option is slightly different: the string value given
for the \fB\-format\fR option must begin with the complete name of the
requested handler, and may contain additional information following
that, which the handler can use, for example, to specify which variant
to use of the formats supported by the handler.
Note that not all image handlers may support writing transparency data
to a file, even where the target image format does.
.SS "FORMAT SUBOPTIONS"
.PP
.VS 8.6
Some image formats support sub-options, which are specified at the time that
the image is loaded using additional words in the \fB\-format\fR option. At
the time of writing, the following are supported:
.TP
\fBgif \-index\fI indexValue\fR
.
When parsing a multi-part GIF image, Tk normally only accesses the first
image. By giving the \fB\-index\fR sub-option, the \fIindexValue\fR'th value
may be used instead. The \fIindexValue\fR must be an integer from 0 up to the
number of image parts in the GIF data.
.TP
\fBpng \-alpha\fI alphaValue\fR
.
An additional alpha filtering for the overall image, which allows the
background on which the image is displayed to show through. This usually also
has the effect of desaturating the image. The \fIalphaValue\fR must be between
0.0 and 1.0.
.VE 8.6
.SH "COLOR ALLOCATION"
.PP
When a photo image is displayed in a window, the photo image code
allocates colors to use to display the image and dithers the image, if
necessary, to display a reasonable approximation to the image using
the colors that are available.  The colors are allocated as a color
cube, that is, the number of colors allocated is the product of the
number of shades of red, green and blue.
.PP
Normally, the number of
colors allocated is chosen based on the depth of the window.  For
example, in an 8-bit PseudoColor window, the photo image code will
attempt to allocate seven shades of red, seven shades of green and
four shades of blue, for a total of 198 colors.  In a 1-bit StaticGray
(monochrome) window, it will allocate two colors, black and white.  In
a 24-bit DirectColor or TrueColor window, it will allocate 256 shades
each of red, green and blue.  Fortunately, because of the way that
pixel values can be combined in DirectColor and TrueColor windows,
this only requires 256 colors to be allocated.  If not all of the
colors can be allocated, the photo image code reduces the number of
shades of each primary color and tries again.
.PP
The user can exercise some control over the number of colors that a
photo image uses with the \fB\-palette\fR configuration option.  If
this option is used, it specifies the maximum number of shades of
each primary color to try to allocate.  It can also be used to force
the image to be displayed in shades of gray, even on a color display,
by giving a single number rather than three numbers separated by
slashes.
.SH CREDITS
.PP
The photo image type was designed and implemented by Paul Mackerras,
based on his earlier photo widget and some suggestions from
John Ousterhout.
.SH EXAMPLE
.PP
Load an image from a file and tile it to the size of a window, which
is useful for producing a tiled background:
.PP
.CS
# These lines should be called once
\fBimage create photo\fR untiled \-file "theFile.ppm"
\fBimage create photo\fR tiled

# These lines should be called whenever .someWidget changes
# size; a <Configure> binding is useful here
set width  [winfo width .someWidget]
set height [winfo height .someWidget]
tiled \fBcopy\fR untiled \-to 0 0 $width $height \-shrink
.CE
.PP
.VS 8.6
The PNG image loader allows the application of an additional alpha factor
during loading, which is useful for generating images suitable for disabled
buttons:
.PP
.CS
\fBimage create photo\fR icon \-file "icon.png"
\fBimage create photo\fR iconDisabled \-file "icon.png" \e
        \-format "png \-alpha 0.5"
button .b \-image icon \-disabledimage iconDisabled
.CE
.VE 8.6
.SH "SEE ALSO"
image(n)
.SH KEYWORDS
photo, image, color
'\" Local Variables:
'\" mode: nroff
'\" End:
