/*  ksim - a system monitor for kde
 *
 *  Copyright (C) 2001  Robbie Ward <linuxphreak@gmx.co.uk>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef KSIMCPU_H
#define KSIMCPU_H

#include <qptrlist.h>
#include <qpair.h>

#include <pluginmodule.h>
#include <stdio.h>

class QTextStream;
class QVBoxLayout;
class QHBoxLayout;
class QCheckBox;
class QLabel;
class QGroupBox;
class QTimer;
class KListView;
namespace KSim
{
  class Chart;
  class Progress;
}

class CpuPlugin : public KSim::PluginObject
{
  public:
    CpuPlugin(const char *name);
    ~CpuPlugin();

    virtual KSim::PluginView *createView(const char *);
    virtual KSim::PluginPage *createConfigPage(const char *);

    virtual void showAbout();
};

class CpuView : public KSim::PluginView
{
  Q_OBJECT
  public:
    CpuView(KSim::PluginObject *parent, const char *name);
    ~CpuView();

    virtual void reparseConfig();

  private slots:
    void updateView();

  private:
    class CpuData
    {
      public:
        CpuData() { user = nice = sys = idle = 0; }

        QString name;
        unsigned long user;
        unsigned long nice;
        unsigned long sys;
        unsigned long idle;

        CpuData &operator-=(const CpuData &rhs)
        {
          if (name != rhs.name)
            return *this;

          user -= rhs.user;
          nice -= rhs.nice;
          sys -= rhs.sys;
          idle -= rhs.idle;
          return *this;
        }
    };
    typedef QValueList<QPair<QString, QString> > CpuList;
    typedef QPair<KSim::Chart *, KSim::Progress *> CpuPair;

    void updateCpu(CpuData &cpu, int cpuNumber);
    void init();
    void cleanup();

    CpuList createCpuList(KConfig *);
    CpuPair *addCpu(KSim::Chart *chart, KSim::Progress *progress,
       const QString &text);

    QPtrList<CpuPair> m_chartList;
    QTimer *m_timer;
    QVBoxLayout *m_mainLayout;
    CpuData *m_oldData;
    CpuData *m_data;
    int m_firstTime;

    CpuList m_cpus;
#ifdef __linux__
    FILE *m_procFile;
    QTextStream *m_procStream;
#endif
};

class CpuConfig : public KSim::PluginPage
{
  Q_OBJECT
  public:
    CpuConfig(KSim::PluginObject *parent, const char *name);
    ~CpuConfig();

    virtual void saveConfig();
    virtual void readConfig();

  private:
    uint addCpus();

    KListView *m_listView;
    QGroupBox *m_legendBox;
    QLabel *m_totalNiceLabel;
    QLabel *m_totalLabel;
    QLabel *m_sysLabel;
    QLabel *m_userLabel;
    QLabel *m_niceLabel;
    QVBoxLayout *m_legendLayout;
};
#endif
