//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2002 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMGRAPHICALOBJECT_H
#define PMGRAPHICALOBJECT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmnamedobject.h"


/**
 * Class for povray graphical objects
 *
 * Objects in povray can be:
 * Finite Solid Primitives, Finite Patch Primitives, Infinite Solid Primitives and Constructive Solid Geometry
 */
class PMGraphicalObject : public PMNamedObject
{
   typedef PMNamedObject Base;
public:
   /** Creates an empty PMGraphicalObject */
   PMGraphicalObject( );
   /** Deletes the object and all children */
   virtual ~PMGraphicalObject( );
   /** */
   virtual bool isA( PMObjectType t ) const;

   /** */
   virtual bool canInsert( PMObjectType, const PMObject* after,
                           const PMObjectList* objectsBetween = 0 ) const;

   /** */
   virtual void serialize( PMOutputDevice& dev ) const;
   /** */
   virtual void serialize( QDomElement& e, QDomDocument& doc ) const;
   /** */
   virtual void readAttributes( const PMXMLHelper& h );

   /** Returns the state of the no_shadow flag. */
   bool noShadow( ) const { return m_noShadow; }
   /** Sets the no_shadow flag */
   void setNoShadow( bool yes );
   /** Returns the visibility level */
   int visibilityLevel( ) const { return m_visibilityLevel; }
   /** Sets the visibility level */
   void setVisibilityLevel( int level );
   /** Returns true if the visibility level is relative to the objects parent */
   bool isVisibilityLevelRelative( ) const { return m_relativeVisibility; }
   /** Sets the visibility level absolute or relative */
   void setVisibilityLevelRelative( bool relative );

   /** */
   virtual void restoreMemento( PMMemento* s );
private:
   /** IDs for @ref PMMementoData */
   enum PMGraphicalObjectMementoID { PMNoShadowID, PMVisibilityID,
                                     PMRelativeVisibilityID };
   
   bool m_noShadow;
   int m_visibilityLevel;
   bool m_relativeVisibility;
};


#endif
