import org.kde.qt.*;

public class CannonField extends QWidget {
	private int ang;
	private int f;
	
	public CannonField(QWidget parent, String name) {
		super(parent, name);
		ang = 45;
		setPalette(new QPalette(new QColor(250, 250, 200)));
	}

	public int angle() {
		return ang;
	}

	public void setAngle(int degrees) {
		if (degrees < 5)
			degrees = 5;
		if (degrees > 70)
			degrees = 70;
		if (ang == degrees)
			return;
		ang = degrees;
		repaint();
		emit("angleChanged", ang);
	}

	public int force() {
		return f;
	}

	public void setForce(int newton) {
		if (newton < 0)
			newton = 0;
		if (f == newton)
			return;
		f = newton;
		emit("forceChanged", f);
	}

	private QRect cannonRect() {
		QRect r = new QRect(0, 0, 50, 50);
		r.moveBottomLeft(rect().bottomLeft());
		return r;
	}

	public void paintEvent(QPaintEvent e) {
		if (!e.rect().intersects(cannonRect()))
			return;

		QRect cr = cannonRect();
		QPixmap pix = new QPixmap(cr.size());
		pix.fill(new QColor(250, 250, 200));

		QPainter p = new QPainter(pix);
		p.setBrush(blue());
		p.setPen(NoPen);
		p.translate(0, pix.height() - 1);
		p.drawPie(new QRect(-35,-35, 70, 70), 0, 90*16);
		p.rotate(-ang);
		p.drawRect(new QRect(33, -4, 15, 8));
		p.end();

		p.begin(this);
		p.drawPixmap(cr.topLeft(), pix);
	}

	public QSizePolicy sizePolicy() {
		return new QSizePolicy(QSizePolicy.Expanding, QSizePolicy.Expanding);
	}
}
