/***************************************************************************
                          JavaSlot.h  -  description
                             -------------------
    begin                : Tue Oct 31 2000
    copyright            : (C) 2000 by Richard Dale
    email                : Richard_Dale@tipitina.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   Lost Highway Ltd reserves the right to issue additional license types *
 *   compatible with the Trolltech AS Qt commercial license.               *
 ***************************************************************************/

#ifndef _JAVASLOT_H_
#define _JAVASLOT_H_

#include <jni.h>
#include <qobject.h>

#include <qevent.h>
#include <qlistview.h>
#include <qiconview.h>
#include <qlistbox.h>
#include <qdatetime.h>
#include <qtoolbar.h>
#include <qaction.h>
#include <qnetworkprotocol.h>
#include <qsql.h>
#include <qsqlcursor.h>
#include <qsqlrecord.h>
#include <qurlinfo.h>
#include <qlibrary.h>

class JavaSlotFactory;
class QMetaObject;

class JavaSlot: public QObject
{
    Q_OBJECT
public:
    JavaSlot(JNIEnv * env, jobject receiver, jstring slot);
    ~JavaSlot();
	
	/** Set the JavaSlot factory to create any JavaSlot instances */
	static void setJavaSlotFactory(JavaSlotFactory * factory);

    /** Return a new JavaSlot instance via the JavaSlot factory */
	static JavaSlot * createJavaSlot(JNIEnv * env, jobject receiver, jstring slot);

	/** Given a Java signal name, returns the corresponding C++ signal name.
		The QMetaObject is used to check whether the QObject instance described
		by 'smeta' implements the C++ signal. */
	const char * javaToQtSignalName(JNIEnv * env, jstring signalString, QMetaObject * smeta);
	
	/** Converts a Java type signature for a signal to the corresponding C++ Qt type signature.*/
	virtual const char * javaToQtSignalType(const char * signalName, const char * javaTypeSignature, QMetaObject * smeta);

	/** Given a Java slot name, returns the corresponding C++ slot name. The optional signalString
		parameter is the C++ signal to connect to - any C++ slot type signature must match this.
	*/
	const char * javaToQtSlotName(JNIEnv * env, jstring slotString, const char * signalString = 0);

	/** Converts a Java type signature for a slot to the corresponding C++ Qt type signature.*/
	virtual const char * javaToQtSlotType(const char * javaTypeSignature, const char * signalString);

public slots:
    void invoke();
    void invoke(bool arg);
    void invoke(char arg);
    void invoke(double arg);
    void invoke(float arg);
    void invoke(int arg);
    void invoke(jobjectArray args);
    void invoke(long arg);
    void invoke(short arg);
    void invoke(unsigned char arg);
	void invoke(Orientation arg1);
	void invoke(QAction * arg1);
//	void invoke(QDate arg1);
	void invoke(QDockWindow * arg1);
	void invoke(QDockWindow::Place arg1);
	void invoke(QDropEvent* arg1);
	void invoke(QDropEvent* arg1,QListViewItem*arg2);
	void invoke(QDropEvent* arg1,const QValueList<QIconDragItem>& arg2);
	void invoke(QDropEvent*arg1,QListViewItem*arg2,QListViewItem*arg3);
	void invoke(QIconViewItem* arg1);
	void invoke(QIconViewItem* arg1,const QPoint& arg2);
	void invoke(QIconViewItem* arg1,const QString arg2);
	void invoke(QList<QListViewItem> arg1,QList<QListViewItem> arg2,QList<QListViewItem> arg3);
	void invoke(QListBoxItem* arg1);
	void invoke(QListBoxItem* arg1,const QPoint arg2);
	void invoke(QListViewItem* arg1, int arg2, const QString arg3);
	void invoke(QListViewItem* arg1,QListViewItem*arg2,QListViewItem*arg3);
	void invoke(QListViewItem* arg1,const QPoint& arg2,int arg3);
	void invoke(QListViewItem* arg1,const QString arg2,int arg3);
	void invoke(QListViewItem* arg1,int arg2);
	void invoke(QListViewItem*arg1);
	void invoke(QNetworkOperation* arg1);
	void invoke(QObject* arg1);
	void invoke(QSql::Op arg1);
	void invoke(QSqlCursor::Mode arg1);
	void invoke(QSqlRecord* arg1);
//	void invoke(QTextCursor* arg1);
	void invoke(QToolBar* arg1);
	void invoke(QWidget* arg1);
	void invoke(const QByteArray& arg1,QNetworkOperation* arg2);
	void invoke(const QColor& arg1);
	void invoke(const QDate& arg1);
	void invoke(const QDateTime& arg1);
	void invoke(const QFont& arg1);
	void invoke(const QRect& arg1);
	void invoke(const QSize& arg1);
//	void invoke(const QPtrList<QNetworkOperation>& arg1);
	void invoke(const QSqlRecord* arg1);
	void invoke(const QString& arg1);
	void invoke(const QString& arg1,QLibrary* arg2);
	void invoke(const QStringList& arg1);
	void invoke(const QTime& arg1);
	void invoke(const QUrlInfo& arg1,QNetworkOperation* arg2);
	void invoke(const QValueList<QUrlInfo>& arg1,QNetworkOperation* arg2);
	void invoke(const QVariant& arg1);
	void invoke(const QChar arg1);
	void invoke(const QString& arg1,int arg2);
	void invoke(const QString& arg1,const QString& arg2);
	void invoke(int arg1,QPoint arg2);
	void invoke(int arg1,bool arg2);
	void invoke(int arg1,int arg2);
	void invoke(int arg1,int arg2,QNetworkOperation* arg3);
	void invoke(int arg1,int arg2,const QPoint& arg3);
	void invoke(int arg1,int arg2,int arg3);
	void invoke(int arg1,int arg2,int arg3,const QPoint& arg4);
	void invoke(int,QIconViewItem* arg1,const QPoint& arg2);
	void invoke(int,QListBoxItem* arg1,const QPoint arg2);
	void invoke(int,QListViewItem* arg1,const QPoint arg2,int arg3);
	void invoke(int arg1, const QString& arg2);
//	void invoke(const QString arg1,const QPoint arg2);
//	void invoke(const QString arg1,const QString arg2);

protected:
    jobject invocation;
private:
    static JavaSlotFactory *	_factory;
};

class JavaSlotFactory {
public:
	JavaSlotFactory();
	virtual ~JavaSlotFactory() {};
	virtual JavaSlot *	createJavaSlot(JNIEnv * env, jobject receiver, jstring slot);
};

class JavaSignal: public QObject
{
    Q_OBJECT
public:
    JavaSignal();
    ~JavaSignal();
    void emitArgs(jobjectArray args);
signals:
    void signalJava(jobjectArray);
};

#endif




