/***************************************************************************
                            QIODevice.java -  description
                             -------------------
    begin                : Sun Nov  3 10:27:27 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov  3 10:27:27 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.qt;

import java.util.*;
import java.lang.Error;

/**

 

 Definition of QPaintDevice class

 Created : 940721

 Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.

 This file is part of the kernel module of the Qt GUI Toolkit.

 This file may be distributed under the terms of the Q Public License
 as defined by Trolltech AS of Norway and appearing in the file
 LICENSE.QPL included in the packaging of this file.

 This file may be distributed and/or modified under the terms of the
 GNU General Public License version 2 as published by the Free Software
 Foundation and appearing in the file LICENSE.GPL included in the
 packaging of this file.

 Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
 licenses may use this file in accordance with the Qt Commercial License
 Agreement provided with the Software.

 This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

 See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
   information about Qt Commercial License Agreements.
 See http://www.trolltech.com/qpl/ for QPL licensing information.
 See http://www.trolltech.com/gpl/ for GPL licensing information.

 Contact info@trolltech.com if any conditions of this licensing are
 not clear to you.


 @short ***************************************************************************
* 
*
* Definition of QPaintDevice class
*
* Created : 940721
*
* Copyright (C) 1992-2000 Trolltech AS.
*/
public class  QIODevice implements QtSupport, QIODeviceInterface {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected QIODevice(Class dummy){}

	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();
	public native int flags();
	public native int mode();
	public native int state();
	public native boolean isDirectAccess();
	public native boolean isSequentialAccess();
	public native boolean isCombinedAccess();
	public native boolean isBuffered();
	public native boolean isRaw();
	public native boolean isSynchronous();
	public native boolean isAsynchronous();
	public native boolean isTranslated();
	public native boolean isReadable();
	public native boolean isWritable();
	public native boolean isReadWrite();
	public native boolean isInactive();
	public native boolean isOpen();
	public native int status();
	public native void resetStatus();
	public native boolean open( int mode);
	public native void close();
	public native void flush();
	public native int size();
	public native int at();
	public native boolean at( int arg1);
	public native boolean atEnd();
	public native boolean reset();
	public native long readBlock( StringBuffer data, long maxlen);
	public native long writeBlock( String data, long len);
	public native long readLine( StringBuffer data, long maxlen);
	public native long writeBlock( byte[] data);
	public native byte[] readAll();
	public native int getch();
	public native int putch( int arg1);
	public native int ungetch( int arg1);
	
	public static final int IO_Direct = 0x0100;		// direct access device
	public static final int IO_Sequential		= 0x0200;		// sequential access device
	public static final int IO_Combined		= 0x0300;		// combined direct/sequential
	public static final int IO_TypeMask		= 0x0f00;

// IO handling modes

	public static final int IO_Raw			= 0x0040;		// raw access (not buffered)
	public static final int IO_Async		= 0x0080;		// asynchronous mode

// IO device open modes

	public static final int IO_ReadOnly		= 0x0001;		// readable device
	public static final int IO_WriteOnly		= 0x0002;		// writable device
	public static final int IO_ReadWrite		= 0x0003;		// read+write device
	public static final int IO_Append		= 0x0004;		// append
	public static final int IO_Truncate		= 0x0008;		// truncate device
	public static final int IO_Translate		= 0x0010;		// translate CR+LF
	public static final int IO_ModeMask		= 0x00ff;

// IO device state

	public static final int IO_Open			= 0x1000;		// device is open
	public static final int IO_StateMask		= 0xf000;


// IO device status

	public static final int IO_Ok			= 0;
	public static final int IO_ReadError		= 1;		// read error
	public static final int IO_WriteError		= 2;		// write error
	public static final int IO_FatalError		= 3;		// fatal unrecoverable error
	public static final int IO_ResourceError	= 4;		// resource limitation
	public static final int IO_OpenError		= 5;		// cannot open device
	public static final int IO_ConnectError		= 5;		// cannot connect to device
	public static final int IO_AbortError		= 6;		// abort error
	public static final int IO_TimeOutError		= 7;		// time out
	public static final int IO_UnspecifiedError	= 8;		// unspecified error
}
