/***************************************************************************
                            KPrinter.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPRINTER_H
#define KPRINTER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QPaintDevice.h>

/**

 This class is the main interface to access the KDE print framework. It allows KDE
 applications to easily access the print system, through an interface that is compatible
 with @ref QPrinter. So that the porting of an existing application should be as easy as
 replacing any occurence of @ref QPrinter by KPrinter. However applications that explicitly
 used the @ref QPrintDialog class must be changed to the standard KPrinter way of accessing
 the print dialog.

 Basically, a KDE application will use the KPrinter object as a paint device, and will draw
 on it using @ref QPainter. In a standard application, the use of the KPrinter class will
 look like this:
 <pre>
  #-include <kprinter.h>
  #-include <qpainter.h>

 void -[MyClass doPrint]
 {
   KPrinter printer;

   // do some printer initialization
   printer.setFullPage( true );

   // initialize the printer using the print dialog
   if ( printer.setup( this ) )
   {
     // create a painter to paint on the printer object
     QPainter painter;

     // start painting
     painter.begin( &printer );
     <do something>
     // stop painting, this will automatically send the print data to the printer
     painter.-end;
   }
 }
 </pre>

 The KPrinter interface also allows some more advanced possibilities, like the customization
 of the print dialog to integrate application specific print options. This is done by subclassing
 @ref KPrintDialogPage and adding the page using @ref -addDialogPage.

 @author Michael Goffioul

 @short The central interface class to access the KDE print system.

*/

@class QWidget;
@class QSize;
@class QPrinter;

@class QPrinter; 

@interface KPrinter : QPaintDevice

/** 
 Constructor. This also restores/saves the state from a previous KPrinter object created within
 the same application run, if @p restore is true. Setting @p restore to false may
 be useful if you want an independant/clean KPrinter object.

*/
- initWithBOOL: (BOOL)restore m: (int)m;
//- init;

/** 
 Destructor. This also saves the current KPrinter state for future printing.
	 
*/
- (void) dealloc;

/** 
 See @ref -[QPrinter newPage].
	 
*/
- (BOOL) newPage;

/** 
 See @ref -[QPrinter abort].
	 
*/
- (BOOL) abort;

/** 
 See @ref -[QPrinter aborted](.)
	 
*/
- (BOOL) aborted;

/** 
 See @ref -[QPrinter outputToFile].
	 
*/
- (BOOL) outputToFile;

/** 
 See @ref -[QPrinter setOutputToFile].
	 
*/
- setOutputToFile: (BOOL)arg1;

/** 
 See @ref -[QPrinter outputFileName].
	 
*/
- (NSString *) outputFileName;

/** 
 See @ref -[QPrinter setOutputFileName].
	 
*/
- setOutputFileName: (NSString *)arg1;

/** 
 See @ref -[QPrinter docName].
	 
*/
- (NSString *) docName;

/** 
 See @ref -[QPrinter setDocName].
	 
*/
- setDocName: (NSString *)arg1;

/** 
 See @ref -[QPrinter creator].
	 
*/
- (NSString *) creator;

/** 
 See @ref -[QPrinter setCreator].
	 
*/
- setCreator: (NSString *)arg1;

/** 
 See @ref -[QPrinter fullPage].
	 
*/
- (BOOL) fullPage;

/** 
 See @ref -[QPrinter setFullPage].
	 
*/
- setFullPage: (BOOL)arg1;

/** 
 See @ref -[QPrinter colorMode].
	 
*/
- (int) colorMode;

/** 
 See @ref -[QPrinter setColorMode].
	 
*/
- setColorMode: (int)arg1;

/** 
 See @ref -[QPrinter numCopies].
	 
*/
- (int) numCopies;

/** 
 See @ref -[QPrinter setNumCopies].
	 
*/
- setNumCopies: (int)n;

/** 
 See @ref -[QPrinter orientation].
	 
*/
- (int) orientation;

/** 
 See @ref -[QPrinter setOrientation].
	 
*/
- setOrientation: (int)arg1;

/** 
 See @ref -[QPrinter pageOrder].
	 
*/
- (int) pageOrder;

/** 
 See @ref -[QPrinter setPageOrder].
	 
*/
- setPageOrder: (int)arg1;

/** 
 Returns the collate status of the current KPrinter.
	 
*/
- (int) collate;

/** 
 Sets the collate status for the current KPrinter to @p type.
	 
*/
- setCollate: (int)type;

/** 
 See @ref -[QPrinter minPage].
	 
*/
- (int) minPage;

/** 
 See @ref -[QPrinter maxPage].
	 
*/
- (int) maxPage;

/** 
 See @ref -[QPrinter setMinMax].
	 
*/
- setMinMax: (int)arg1 int: (int)arg2;

/** 
 Returns the first page to be printed.

 should use @ref -pageList instead, which takes into account all options: collate,
 page order, ranges, page set, ...

*/
- (int) fromPage;

/** 
 Returns the last page to be printed.

 should use @ref -pageList instead, which takes into account all options: collate,
 page order, ranges, page set, ...

*/
- (int) toPage;

/** 
 Sets the first and last page to be printed. See @ref -[QPrinter setFromTo].
	 
*/
- setFromTo: (int)arg1 int: (int)arg2;

/** 
 See @ref -[QPrinter pageSize].
	 
*/
- (int) pageSize;

/** 
 See @ref -[QPrinter setPageSize].
	 
*/
- setPageSize: (int)arg1;

/** 
 See @ref -[QPrinter printerName].
	 
*/
- (NSString *) printerName;

/** 
 See @ref -[QPrinter setPrinterName].
	 
*/
- setPrinterName: (NSString *)arg1;

/** 
 Returns the print program as set by @ref -setPrintProgram or by the print dialog
 if a special printer has been selected.

*/
- (NSString *) printProgram;

/** 
 Sets the command line to use when printing. This function is useful
 when using a KPrinter object without the print dialog, to control what
 to print and how to do it. The command line may contain the following
 tags:

   prt.setOutputToFile( true );
   prt.setOutputFileName( filename );
   prt.setPrintProgram( "gs -sDEVICE=png256 -sPAPERSIZE=%psl -sOutputFile=%out %in" );

   QPainter painter( &prt );
   doPaint( &painter );
 }
 </pre>

*/
- setPrintProgram: (NSString *)cmd;

/** 
 See @ref -[QPrinter printerSelectionOption]. Unused.
	 
*/
- (NSString *) printerSelectionOption;

/** 
 See @ref -[QPrinter setPrinterSelectionOption]. Unused
	 
*/
- setPrinterSelectionOption: (NSString *)arg1;

/** 
 Returns the current page number.

*/
- (int) currentPage;

/** 
 Sets the current page number. This page number will be used if the user
 selected "current page" in the print dialog. This option will only be
 enabled if the application does page selection itself and the application
 has called @ref -setCurrentPage before opening the print dialog:
 <pre>
 -[MyClass MyClass]
 {
   // declares my application able to do page selection
   -[KPrinter setPageSelection]( -[KPrinter ApplicationSide]);
 }

 void -[MyClass doPrint]
 {
   KPrinter printer;

   printer.setCurrentPage( mycurrentpage );
   if ( printer.setup( this ) )
   {
     QValueList<int> pages = printer.-pageList;
     // print the pages
     ...
   }
 }
 </pre>

*/
- setCurrentPage: (int)p;
- setCurrentPage;

/** 
 Returns the page set of the current KPrinter object.
	 
*/
- (int) pageSet;

/** 
 Sets up the KPrinter object using the print dialog, returns true if the user clicked OK.

*/
- (BOOL) setup: (QWidget *)parent caption: (NSString *)caption forceExpand: (BOOL)forceExpand;
- (BOOL) setup;

/** 
 See @ref -[QPrinter margins].
	 
*/
- (QSize*) margins;

/** 
 Not used yet.
	 
*/
- setMargins: (QSize *)m;

/** 
 Returns the real page size in points. Some print system (like CUPS) allows to customize the
 page size through printer description files (PPD). The size returned corresponds to this
 size.

*/
- (QSize*) realPageSize;

/** 
 Sets the real page size. For internal use only.

*/
- setRealPageSize: (QSize *)p;

/** 
 Sets the KPrinter object to preview mode if @p on is true. In this mode, nothing will be
 printed but only a preview dialog will be popped up with the single "Close" action. Using
 this mode, any application can easily implement a preview action:
 <pre>
 void MyClass:-doPreview
 {
   // use a "clean" KPrinter object (independant from previous print jobs),
   // this is not necessary, it depends on the application
   KPrinter prt( false );
   prt.setPreviewOnly( true );

   QPainter painter( &prt );
   doPrint( &painter );
 }
 </pre>

*/
- setPreviewOnly: (BOOL)on;

/** 
 Returns the preview-only state for this KPrinter object.

*/
- (BOOL) previewOnly;

/** 
 Prints the files given in argument. This will first filter the files accorsing to the filtering
 options selected by the user in the print dialog, then send the filtered files to the printer
 with the print options selected. This function is called automatically when calling
 @ref -[QPainter end] for a painter object constructed on KPrinter. In normal use, you don't need
 this use this fucntion explicitely.
	 
*/
- (BOOL) printFiles: (NSArray *)files removeafter: (BOOL)removeafter;
- (BOOL) printFiles: (NSArray *)files ;

/** 
 The KPrinter object stores all its settings in an internal @ref QMap structure on @ref
 QString. This allows to store any property. This method allows an application to access
 any print option from the KPrinter object, using the option name. For example if your
 application add a customized page to the print dialog, this page will saves its settings
 into the KPrinter object using this QMap<QString,QString> structure. After showing the
 print dialog, your application can then access these options using this method. The
 custom option name should follow the form "kde-appname-optionname".
 <pre>
 void -[MyClass doPrint]
 {
   KPrinter prt;

   // add my custom page
   prt.addDialogPage( new -MyDialogPage );

   // open print dialog
   if ( prt.setup( this ) )
   {
      QString fntname = prt.option( "kde-myapp-fontname" );
      ...
      do_something;
      ...
   }
 }
 </pre>

*/
- (NSString *) option: (NSString *)key;

/** 
 Adds or modifies an option in the KPrinter object. You probably don't need to use this function
 explicitely. This will be done implicitely for example when reimplementing @ref
 -[KPrintDialogPage getOptions].

*/
- setOption: (NSString *)key value: (NSString *)value;

/** 
 Returns the search name of the printer selected by the user. Each printer is identified by
 a unique name. This method is mainly used for state restoration. For internal use.

*/
- (NSString *) searchName;

/** 
 Sets the search name of the KPrinter object. For internal use.

*/
- setSearchName: (NSString *)n;

/** 
 Returns the last error message issued by the print system. Unimplemented yet.

*/
- (NSString *) errorMessage;

/** 
 Sets the last error message. For internal use.

*/
- setErrorMessage: (NSString *)msg;

/** 
 Configure the KPrinter object to be used with the printer named
 @p prname. After the call, the KPrinter object can be used without
 the need to call the print dialog. If @p prname is empty, then the
 KPrinter object is configured for the default printer. If @p prname
 corresponds to a pseudo-printer which needs an output file, a file
 dialog will be used. In that case, providing a parent widget for
 that dialog in @p parent may be useful.

*/
- (BOOL) autoConfigure: (NSString *)prname parent: (QWidget *)parent;
- (BOOL) autoConfigure;

/** 
 Set the default document filename. This filename will be used as the
 default basename for the output file, instead of the default "print".
 For exmaple, by using setDocFileName("my_document"), the default
 output file will be $HOME/my_document.ps.

*/
- setDocFileName: (NSString *)filename;

/** 
 Get the default document filename, that is the default basename used for
 the output file.

*/
- (NSString *) docFileName;

/** 
 Adds a customized page to the print dialog. The pages will appear in a tab widget in the
 bottom half of the dialog, along with the standard "Copies" page. The page must be created
 and added each time you want open a print dialog with @ref -setup. If you correctly
 reimplemented @ref -[KPrintDialogPage setOptions], the settings will be restored from call
 to call, you don't have to worry about state saving/restoration.

*/
//+ addDialogPage: (KPrintDialogPage*)arg1;

/** 
 Sets the page selection mode of the application. If needed, call this method somewhere at
 the beginning of your code. The default value is @p SystemSide.

*/
+ setPageSelection: (int)arg1;

/** 
 Returns the page selection mode of the current application.

*/
+ (int) pageSelection;

/** 
 Sets the application type concerning the print dialog. You probably don't want to use it.
 For internal use only.

*/
+ setApplicationType: (int)type;

/** 
 Returns the application type concerning the print dialog. For internal use only.

*/
+ (int) applicationType;

/** 
 Adds a standard page to the print dialog. This is not useful yet as there's only one
 standard page defines @p CopiesPage.

*/
+ addStandardPage: (int)p;

/** 
 Removes a standard page from the print dialog. If your application doesn't want a
 standard page in the dialog, simply call this method with the correct identifier.
 By default, the print dialog includes the @p CopiesPage page.

*/
+ removeStandardPage: (int)p;
//- (BOOL) cmd: (int)arg1 painter: (QPainter *)arg2 pdevcmdparam: (QPDevCmdParam*)arg3;
- (int) metric: (int)arg1;
- translateQtOptions;
- loadSettings;
- saveSettings;
- preparePrinting;
- finishPrinting;
- reload;
- init: (BOOL)restore m: (int)m;
//- init;
+ (int) CopiesPage;
+ (int) FilesPage;
+ (int) Custom;
+ (int) ApplicationSide;
+ (int) SystemSide;
+ (int) Dialog;
+ (int) StandAlone;
+ (int) StandAlonePersistent;
+ (int) AllPages;
+ (int) OddPages;
+ (int) EvenPages;
+ (int) Collate;
+ (int) Uncollate;
+ (int) GrayScale;
+ (int) Color;
+ (int) Portrait;
+ (int) Landscape;
+ (int) FirstPageFirst;
+ (int) LastPageFirst;
+ (int) A4;
+ (int) B5;
+ (int) Letter;
+ (int) Legal;
+ (int) Executive;
+ (int) A0;
+ (int) A1;
+ (int) A2;
+ (int) A3;
+ (int) A5;
+ (int) A6;
+ (int) A7;
+ (int) A8;
+ (int) A9;
+ (int) B0;
+ (int) B1;
+ (int) B10;
+ (int) B2;
+ (int) B3;
+ (int) B4;
+ (int) B6;
+ (int) B7;
+ (int) B8;
+ (int) B9;
+ (int) C5E;
+ (int) Comm10E;
+ (int) DLE;
+ (int) Folio;
+ (int) Ledger;
+ (int) Tabloid;
+ (int) NPageSize;
@end

#endif
