/***************************************************************************
                            KSessionManaged.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

   Provides highlevel access to session management on a per-object
   base.

   KSessionManaged makes it possible to provide implementations for
   {@link QApplication#commitData} and {@link QApplication#saveState}, without
   subclassing KApplication. KMainWindow internally makes use of this.

   You don't need to do anything with this class when using
   KMainWindow. Instead, use {@link KMainWindow#saveProperties},
   {@link KMainWindow#readProperties}, {@link KMainWindow#queryClose},
   {@link KMainWindow#queryExit} and friends.

 @author Matthias Ettrich <ettrich@kde.org>
 
 @short Highlevel access to session management.

*/
public class  KSessionManaged implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KSessionManaged(Class dummy){}

	private native void newKSessionManaged();
	public KSessionManaged() {
		newKSessionManaged();
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
       See {@link QApplication#saveState} for documentation.

       This function is just a convenience version to avoid subclassing KApplication.

       Return true to indicate a successful state save or false to
       indicate a problem and to halt the shutdown process (will
       implicitly call sm.cancel() ).
     
*/
	public native boolean saveState( QSessionManager sm);

/** 
       See {@link QApplication#commitData} for documentation.

       This function is just a convenience version to avoid subclassing KApplication.

       Return true to indicate a successful commit of data or false to
       indicate a problem and to halt the shutdown process (will
       implicitly call sm.cancel() ).
     
*/
	public native boolean commitData( QSessionManager sm);
	protected native void virtual_hook( int identifier, int data);
}
