/***************************************************************************
                            KDoubleNumInput.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 KDoubleNumInput combines a {@link QSpinBox} and optionally a {@link QSlider}
 with a label to make an easy to use control for setting some float
 parameter. This is especially nice for configuration dialogs,
 which can have many such combinated controls.

 The slider is created only when the user specifies a range
 for the control using the setRange function with the slider
 parameter set to "true".

 A special feature of KDoubleNumInput, designed specifically for
 the situation when there are several instances in a column,
 is that you can specify what portion of the control is taken by the
 QSpinBox (the remaining portion is used by the slider). This makes
 it very simple to have all the sliders in a column be the same size.

 It uses the {@link KDoubleValidator} validator class. KDoubleNumInput
 enforces the value to be in the given range, but see the class
 documentation of {@link KDoubleSpinBox} for the tricky
 interrelationship of precision and values. All of what is said
 there applies here, too.

 See {@link KDoubleNumInputSignals} for signals emitted by KDoubleNumInput.

 

 @short An input control for real numbers, consisting of a spinbox and a slider.
 
*/
public class KDoubleNumInput extends KNumInput  {
	protected KDoubleNumInput(Class dummy){super((Class) null);}

	private native void newKDoubleNumInput( QWidget parent, String name);

/** 
 Constructs an input control for double values
 with initial value 0.00.
     
*/
	public KDoubleNumInput( QWidget parent, String name) {
		super((Class) null);
		newKDoubleNumInput( parent, name);
	}
	private native void newKDoubleNumInput();
	public KDoubleNumInput() {
		super((Class) null);
		newKDoubleNumInput();
	}
	private native void newKDoubleNumInput( double value, QWidget parent, String name);

/** 

 Constructor

*/
	public KDoubleNumInput( double value, QWidget parent, String name) {
		super((Class) null);
		newKDoubleNumInput( value, parent, name);
	}
	private native void newKDoubleNumInput( double value);
	public KDoubleNumInput( double value) {
		super((Class) null);
		newKDoubleNumInput( value);
	}
	private native void newKDoubleNumInput( double lower, double upper, double value, double step, int precision, QWidget parent, String name);

/** 
 Constructor

*/
	public KDoubleNumInput( double lower, double upper, double value, double step, int precision, QWidget parent, String name) {
		super((Class) null);
		newKDoubleNumInput( lower, upper, value, step, precision, parent, name);
	}
	private native void newKDoubleNumInput( double lower, double upper, double value);
	public KDoubleNumInput( double lower, double upper, double value) {
		super((Class) null);
		newKDoubleNumInput( lower, upper, value);
	}

/** 
 destructor
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();
	private native void newKDoubleNumInput( KNumInput below, double value, QWidget parent, String name);

/** 

 Constructor

 puts it below other KNumInput

*/
	public KDoubleNumInput( KNumInput below, double value, QWidget parent, String name) {
		super((Class) null);
		newKDoubleNumInput( below, value, parent, name);
	}
	private native void newKDoubleNumInput( KNumInput below, double value);
	public KDoubleNumInput( KNumInput below, double value) {
		super((Class) null);
		newKDoubleNumInput( below, value);
	}
	private native void newKDoubleNumInput( KNumInput below, double lower, double upper, double value, double step, int precision, QWidget parent, String name);

/** 
 Constructor

 puts it below other KNumInput

*/
	public KDoubleNumInput( KNumInput below, double lower, double upper, double value, double step, int precision, QWidget parent, String name) {
		super((Class) null);
		newKDoubleNumInput( below, lower, upper, value, step, precision, parent, name);
	}
	private native void newKDoubleNumInput( KNumInput below, double lower, double upper, double value);
	public KDoubleNumInput( KNumInput below, double lower, double upper, double value) {
		super((Class) null);
		newKDoubleNumInput( below, lower, upper, value);
	}

/** 

*/
	public native double value();

/** 

*/
	public native String suffix();

/** 

*/
	public native String prefix();

/** 

*/
	public native int precision();

/** 

*/
	public native String specialValueText();

/** 

*/
	public native void setRange( double min, double max, double step, boolean slider);
	public native void setRange( double min, double max);

/** 
 Sets the minimum value.
     
*/
	public native void setMinValue( double min);

/** 

*/
	public native double minValue();

/** 
 Sets the maximum value.
     
*/
	public native void setMaxValue( double max);

/** 

*/
	public native double maxValue();

/** 
 Specifies the number of digits to use.
     
*/
	public native void setPrecision( int precision);

/** 

*/
	public native double referencePoint();

/** 

*/
	public native double relativeValue();

/** 
 Sets the special value text. If set, the spin box will display
 this text instead of the numeric value whenever the current
 value is equal to {@link #minVal}. Typically this is used for indicating
 that the choice has a special (default) meaning.
     
*/
	public native void setSpecialValueText( String text);

/** 
 Sets the value of the control.
     
*/
	public native void setValue( double arg1);

/** 
 Sets the value in units of {@link #referencePoint.}

*/
	public native void setRelativeValue( double arg1);

/** 
 Sets the reference Point to <code>ref.</code> It <code>ref</code> == 0, emitting of
 {@link #relativeValueChanged} is blocked and {@link #relativeValue}
 just returns 0.

*/
	public native void setReferencePoint( double ref);

/** 
 Sets the suffix to be displayed to <code>suffix.</code> Use String.null to disable
 this feature. Note that the suffix is attached to the value without any
 spacing. So if you prefer to display a space separator, set suffix
 to something like " cm".

*/
	public native void setSuffix( String suffix);

/** 
 Sets the prefix to be displayed to <code>prefix.</code> Use String.null to disable
 this feature. Note that the prefix is attached to the value without any
 spacing.

*/
	public native void setPrefix( String prefix);
	protected native void resetEditBox();
	protected native void virtual_hook( int identifier, int data);
}
