/***************************************************************************
                            kde_KPixmapEffect.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KPIXMAPEFFECT
#define KDE_KPIXMAPEFFECT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 This class includes various pixmap-based graphical effects.

 Everything is
 static, so there is no need to create an instance of this class. You can
 just call the static methods. They are encapsulated here merely to provide
 a common namespace.
 
 @short *
 This class includes various pixmap-based graphical effects.
*/
#define KPIXMAPEFFECT_VerticalGradient	0
#define KPIXMAPEFFECT_HorizontalGradient	1
#define KPIXMAPEFFECT_DiagonalGradient	2
#define KPIXMAPEFFECT_CrossDiagonalGradient	3
#define KPIXMAPEFFECT_PyramidGradient	4
#define KPIXMAPEFFECT_RectangleGradient	5
#define KPIXMAPEFFECT_PipeCrossGradient	6
#define KPIXMAPEFFECT_EllipticGradient	7
#define KPIXMAPEFFECT_Red	0
#define KPIXMAPEFFECT_Green	1
#define KPIXMAPEFFECT_Blue	2
#define KPIXMAPEFFECT_NorthLite	0
#define KPIXMAPEFFECT_NWLite	1
#define KPIXMAPEFFECT_WestLite	2
#define KPIXMAPEFFECT_SWLite	3
#define KPIXMAPEFFECT_SouthLite	4
#define KPIXMAPEFFECT_SELite	5
#define KPIXMAPEFFECT_EastLite	6
#define KPIXMAPEFFECT_NELite	7

/** *
 Creates a gradient from color a to color b of the specified type.

*/
kde_KPixmap* kde_KPixmapEffect_gradient( kde_KPixmap* pixmap, qt_QColor * ca, qt_QColor * cb, int type, int ncols);

/** *
 Creates an unbalanced gradient.

 An unbalanced gradient is a gradient where the transition from
 color a to color b is not linear, but in this case, exponential.

*/
kde_KPixmap* kde_KPixmapEffect_unbalancedGradient( kde_KPixmap* pixmap, qt_QColor * ca, qt_QColor * cb, int type, int xfactor, int yfactor, int ncols);

/** *
 Creates a pixmap of a given size with the given pixmap.

 if the
 given size is bigger than the size of the pixmap, the pixmap is
 tiled.

*/
kde_KPixmap* kde_KPixmapEffect_createTiled( kde_KPixmap* pixmap, qt_QSize * size);

/** *
 Either brightens or dims a pixmap by a specified ratio.

*/
kde_KPixmap* kde_KPixmapEffect_intensity( kde_KPixmap* pixmap, float ratio);

/** *
 Modifies the intensity of a pixmap's RGB channel component.

*/
kde_KPixmap* kde_KPixmapEffect_channelIntensity( kde_KPixmap* pixmap, float ratio, int channel);

/** *
 Blends the provided pixmap into a background of the indicated color.

*/
kde_KPixmap* kde_KPixmapEffect_blend( kde_KPixmap* pixmap, float initial_intensity, qt_QColor * bgnd, int eff, int anti_dir, int ncols);

/** *
 Builds a hash on any given pixmap.

*/
kde_KPixmap* kde_KPixmapEffect_hash( kde_KPixmap* pixmap, int lite, unsigned int spacing, int ncols);

/** *
 Creates a pattern from a pixmap.

 The given pixmap is "flattened"
 between color a to color b.

*/
kde_KPixmap* kde_KPixmapEffect_pattern( kde_KPixmap* pixmap, qt_QSize * size, qt_QColor * ca, qt_QColor * cb, int ncols);

/** *
 Recolors a pixmap.

 The most dark color will become color a,
 the most bright one color b, and in between.

*/
kde_KPixmap* kde_KPixmapEffect_fade( kde_KPixmap* pixmap, double val, qt_QColor * color);

/** *
 Converts a pixmap to grayscale.

*/
kde_KPixmap* kde_KPixmapEffect_toGray( kde_KPixmap* pixmap, int fast);

/** *
 Desaturates a pixmap.

*/
kde_KPixmap* kde_KPixmapEffect_desaturate( kde_KPixmap* pixmap, float desat);

/** *
 Modifies the contrast of a pixmap.

*/
kde_KPixmap* kde_KPixmapEffect_contrast( kde_KPixmap* pixmap, int c);

/** *
 Dithers a pixmap using Floyd-Steinberg dithering for low-color
 situations.

*/
kde_KPixmap* kde_KPixmapEffect_dither( kde_KPixmap* pixmap, qt_QColor* palette, int size);

/** *
 Calculate a 'selected' pixmap, for instance a selected icon
 on the desktop.

*/
kde_KPixmap* kde_KPixmapEffect_selectedPixmap( kde_KPixmap* pixmap, qt_QColor * col);

#endif
