
/* first include the system independent files ... */

#include <sys/types.h>
#include <stdlib.h>

#include <sys/param.h>
#include <sys/socket.h>
#include <sys/signal.h>
#include <sys/file.h>
#include <sys/syslog.h>
#include <sys/termios.h>
#include <sys/stat.h>

/* real old BSD's are not POSIX (from FreeBSD 1.x sliplogin) */
#if (BSD >= 199006) || defined(linux)
#define POSIX
#define _POSIX_SOURCE 1
#endif

#if defined(POSIX) || defined(linux)
#include <sys/ioctl.h>
#ifndef linux
#include <ttyent.h>
#endif
#else /* for old BSD systems, e.g. FreeBSD 1.x */
#include <sgtty.h>
#endif

#include <netinet/in.h>
#include <arpa/inet.h>
#include <net/if.h>
#ifdef linux
#include <linux/if_slip.h>
#include <linux/if_ether.h>
#else
#include <net/if_slvar.h>
#if defined(__FreeBSD__) && (BSD >= 199300)
#include <net/slip.h>
#endif
#endif

#include <stdio.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>
#include <unistd.h>
#include <rpcsvc/ypclnt.h>

#include "pathnames.h"

#ifndef N_SLIP
#define N_SLIP SLIPDISC /* slip line discipline */
#endif

/* Fatal error: log & print message, send message (wait), then exit */
#define FATAL(code) { fflush(stderr); sleep(2); exit(code); }

/* FreeBSD 2.0: configure line discipline (mode) via ifconfig option,
   otherwise it will be done via ioctl() call and the sm_value field. */
#if defined(SLIOCSFLAGS) || defined(SIOCSIFENCAP)
#define IOCTL_FLAGS
#endif

struct slipinfo
{
    int linespeed;
    int timeout;
    char sm_name[16];
#ifdef IOCTL_FLAGS
    int sm_value;
#endif    
    char *loginname;
    char loginfile[MAXPATHLEN];
    int uid;
    char raddr[16];
    char laddr[16];
    char unit[32];
    char mask[16];
    char option[3][16];
};

