/* $Id: tstIEMAImplDataInt.cpp $ */
/** @file
 * IEM Assembly Instruction Helper Testcase Data - r150722 on Intel(R) Core(TM) i9-10980XE CPU @ 3.00GHz.
 */

/*
 * Copyright (C) 2022 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#include "tstIEMAImpl.h"

BINU8_TEST_T const g_aTests_add_u8[] =
{
    { 0x366342, 0x366346, 0x00, 0x00, 0x00, 0x0 }, /* #0 */
    { 0x0d6783, 0x0d6746, 0x00, 0x00, 0x00, 0x0 }, /* #1 */
    { 0x006382, 0x006346, 0x00, 0x00, 0x00, 0x0 }, /* #2 */
    { 0x3317d3, 0x331746, 0x00, 0x00, 0x00, 0x0 }, /* #3 */
    { 0x300283, 0x300246, 0x00, 0x00, 0x00, 0x0 }, /* #4 */
    { 0x2f1147, 0x2f1146, 0x00, 0x00, 0x00, 0x0 }, /* #5 */
    { 0x2e0ec2, 0x2e0682, 0xa1, 0xa1, 0x00, 0x0 }, /* #6 */
    { 0x2d2753, 0x2d2786, 0xc9, 0xc9, 0x00, 0x0 }, /* #7 */
    { 0x2a5982, 0x2a5182, 0xb9, 0xb9, 0x00, 0x0 }, /* #8 */
    { 0x131303, 0x131302, 0x3e, 0x3e, 0x00, 0x0 }, /* #9 */
    { 0x1c0047, 0x1c0086, 0xc6, 0xc6, 0x00, 0x0 }, /* #10 */
    { 0x242247, 0x242282, 0xf4, 0xf4, 0x00, 0x0 }, /* #11 */
    { 0x2153c6, 0x215302, 0x0b, 0x7f, 0x74, 0x0 }, /* #12 */
    { 0x142842, 0x142017, 0x44, 0x12, 0xce, 0x0 }, /* #13 */
    { 0x0060d2, 0x006092, 0xa7, 0xd0, 0x29, 0x0 }, /* #14 */
    { 0x173782, 0x173786, 0x97, 0xcf, 0x38, 0x0 }, /* #15 */
    { 0x1d0ac6, 0x1d0a82, 0x4c, 0xbc, 0x70, 0x0 }, /* #16 */
    { 0x1d0e46, 0x1d0686, 0x23, 0xf9, 0xd6, 0x0 }, /* #17 */
    { 0x217447, 0x217486, 0x87, 0xbe, 0x37, 0x0 }, /* #18 */
    { 0x325752, 0x325783, 0xcc, 0xad, 0xe1, 0x0 }, /* #19 */
    { 0x195702, 0x195713, 0xf9, 0x61, 0x68, 0x0 }, /* #20 */
    { 0x202c13, 0x202487, 0x94, 0x8b, 0xf7, 0x0 }, /* #21 */
    { 0x0f0456, 0x0f0413, 0x69, 0x43, 0xda, 0x0 }, /* #22 */
    { 0x1c4ac2, 0x1c4282, 0xc0, 0xdf, 0x1f, 0x0 }, /* #23 */
    { 0x3f3142, 0x3f3196, 0xac, 0xb2, 0x06, 0x0 }, /* #24 */
    { 0x1d68c2, 0x1d6083, 0xec, 0xbf, 0xd3, 0x0 }, /* #25 */
    { 0x042407, 0x042493, 0xe7, 0xd5, 0xee, 0x0 }, /* #26 */
    { 0x305a52, 0x305a03, 0xe2, 0x7c, 0x9a, 0x0 }, /* #27 */
    { 0x0819d6, 0x081103, 0xd2, 0x1f, 0x4d, 0x0 }, /* #28 */
    { 0x2f2987, 0x2f2196, 0x03, 0xa0, 0x9d, 0x0 }, /* #29 */
    { 0x192506, 0x192506, 0x72, 0x77, 0x05, 0x0 }, /* #30 */
    { 0x350083, 0x350097, 0xec, 0xb1, 0xc5, 0x0 }, /* #31 */
    { 0x0c0ec6, 0x0c0697, 0xfc, 0xd2, 0xd6, 0x0 }, /* #32 */
    { 0x035183, 0x035186, 0x22, 0xe2, 0xc0, 0x0 }, /* #33 */
    { 0x047543, 0x047583, 0xe8, 0xdc, 0xf4, 0x0 }, /* #34 */
    { 0x217703, 0x217792, 0x85, 0xe3, 0x5e, 0x0 }, /* #35 */
    { 0x2c0b16, 0x2c0313, 0x3e, 0x1a, 0xdc, 0x0 }, /* #36 */
    { 0x3a6b47, 0x3a6312, 0x0d, 0x76, 0x69, 0x0 }, /* #37 */
    { 0x104946, 0x104103, 0x65, 0x49, 0xe4, 0x0 }, /* #38 */
    { 0x354d47, 0x354d86, 0x70, 0x9a, 0x2a, 0x0 }, /* #39 */
    { 0x1c1616, 0x1c1e96, 0x49, 0x87, 0x3e, 0x0 }, /* #40 */
    { 0x0e6517, 0x0e6586, 0x8a, 0x8b, 0x01, 0x0 }, /* #41 */
    { 0x233f53, 0x233716, 0x48, 0x60, 0x18, 0x0 }, /* #42 */
    { 0x1e11c6, 0x1e1117, 0x3b, 0x18, 0xdd, 0x0 }, /* #43 */
    { 0x2e5bc6, 0x2e5317, 0xf9, 0x55, 0x5c, 0x0 }, /* #44 */
    { 0x194a42, 0x194286, 0x4a, 0xdb, 0x91, 0x0 }, /* #45 */
    { 0x3529c7, 0x352107, 0x33, 0x06, 0xd3, 0x0 }, /* #46 */
    { 0x223d82, 0x223586, 0xb4, 0xc6, 0x12, 0x0 }, /* #47 */
    { 0x220a03, 0x220213, 0x6e, 0x15, 0xa7, 0x0 }, /* #48 */
    { 0x2e0496, 0x2e0413, 0x2e, 0x29, 0xfb, 0x0 }, /* #49 */
    { 0x3960c2, 0x396813, 0x96, 0x75, 0xdf, 0x0 }, /* #50 */
    { 0x034443, 0x034407, 0xc1, 0x2e, 0x6d, 0x0 }, /* #51 */
    { 0x380e52, 0x380e17, 0x9d, 0x22, 0x85, 0x0 }, /* #52 */
    { 0x152a03, 0x152a03, 0xf3, 0x76, 0x83, 0x0 }, /* #53 */
    { 0x3f6907, 0x3f6102, 0x08, 0x2a, 0x22, 0x0 }, /* #54 */
    { 0x395b47, 0x395396, 0xaf, 0xeb, 0x3c, 0x0 }, /* #55 */
    { 0x162d57, 0x162597, 0xee, 0xa9, 0xbb, 0x0 }, /* #56 */
    { 0x357217, 0x357207, 0xf4, 0x6c, 0x78, 0x0 }, /* #57 */
    { 0x086247, 0x086a92, 0x36, 0xb3, 0x7d, 0x0 }, /* #58 */
    { 0x381883, 0x381013, 0xee, 0x32, 0x44, 0x0 }, /* #59 */
    { 0x106fc6, 0x106f17, 0xcb, 0x65, 0x9a, 0x0 }, /* #60 */
    { 0x3468c6, 0x346013, 0xcf, 0x40, 0x71, 0x0 }, /* #61 */
    { 0x121387, 0x121317, 0x7d, 0x53, 0xd6, 0x0 }, /* #62 */
    { 0x112b93, 0x112307, 0x40, 0x17, 0xd7, 0x0 }, /* #63 */
    { 0x3f3e96, 0x3f3e03, 0xb8, 0x4c, 0x94, 0x0 }, /* #64 */
    { 0x191656, 0x191613, 0x79, 0x76, 0xfd, 0x0 }, /* #65 */
    { 0x345647, 0x345602, 0x00, 0x79, 0x79, 0x0 }, /* #66 */
    { 0x261943, 0x261113, 0x1b, 0x07, 0xec, 0x0 }, /* #67 */
    { 0x356802, 0x356092, 0x0b, 0xb9, 0xae, 0x0 }, /* #68 */
    { 0x0e5d42, 0x0e5516, 0x0f, 0x63, 0x54, 0x0 }, /* #69 */
    { 0x091253, 0x091286, 0x0d, 0xde, 0xd1, 0x0 }, /* #70 */
    { 0x234102, 0x234117, 0x66, 0x14, 0xae, 0x0 }, /* #71 */
    { 0x2f7d87, 0x2f7583, 0xb4, 0xa7, 0xf3, 0x0 }, /* #72 */
    { 0x347556, 0x347586, 0x91, 0x9a, 0x09, 0x0 }, /* #73 */
    { 0x3d4a86, 0x3d4202, 0x00, 0x7a, 0x7a, 0x0 }, /* #74 */
    { 0x1551c6, 0x155117, 0x7b, 0x27, 0xac, 0x0 }, /* #75 */
    { 0x090bd2, 0x090313, 0x54, 0x31, 0xdd, 0x0 }, /* #76 */
    { 0x0c5047, 0x0c5086, 0xd0, 0xd2, 0x02, 0x0 }, /* #77 */
    { 0x0843c2, 0x084393, 0x9b, 0x86, 0xeb, 0x0 }, /* #78 */
    { 0x276147, 0x276197, 0xa4, 0xa0, 0xfc, 0x0 }, /* #79 */
    { 0x0b0082, 0x0b0017, 0x3f, 0x09, 0xca, 0x0 }, /* #80 */
    { 0x324e97, 0x324686, 0x26, 0xd7, 0xb1, 0x0 }, /* #81 */
    { 0x1860d7, 0x186082, 0x32, 0xc2, 0x90, 0x0 }, /* #82 */
    { 0x170b43, 0x170b07, 0xe9, 0x7e, 0x95, 0x0 }, /* #83 */
    { 0x045c06, 0x045413, 0xdd, 0x54, 0x77, 0x0 }, /* #84 */
    { 0x116307, 0x116302, 0x57, 0x7c, 0x25, 0x0 }, /* #85 */
    { 0x0149d7, 0x014113, 0x5c, 0x51, 0xf5, 0x0 }, /* #86 */
    { 0x0921d6, 0x092107, 0x37, 0x18, 0xe1, 0x0 }, /* #87 */
    { 0x041f06, 0x041786, 0x5a, 0xee, 0x94, 0x0 }, /* #88 */
    { 0x1e60d6, 0x1e6082, 0x60, 0xe9, 0x89, 0x0 }, /* #89 */
    { 0x252a87, 0x252283, 0xa1, 0x85, 0xe4, 0x0 }, /* #90 */
    { 0x1170c3, 0x117093, 0x92, 0x91, 0xff, 0x0 }, /* #91 */
    { 0x3d7803, 0x3d7006, 0x39, 0x5f, 0x26, 0x0 }, /* #92 */
    { 0x346a53, 0x346a92, 0x3d, 0x8c, 0x4f, 0x0 }, /* #93 */
    { 0x160dd2, 0x160517, 0x26, 0x14, 0xee, 0x0 }, /* #94 */
    { 0x2547d7, 0x254783, 0xd7, 0x9d, 0xc6, 0x0 }, /* #95 */
};
uint32_t const g_cTests_add_u8 = RT_ELEMENTS(g_aTests_add_u8);

BINU8_TEST_T const g_aTests_add_u8_locked[] =
{
    { 0x3521c3, 0x352146, 0x00, 0x00, 0x00, 0x0 }, /* #0 */
    { 0x123b43, 0x123346, 0x00, 0x00, 0x00, 0x0 }, /* #1 */
    { 0x387583, 0x387546, 0x00, 0x00, 0x00, 0x0 }, /* #2 */
    { 0x0b4b17, 0x0b4346, 0x00, 0x00, 0x00, 0x0 }, /* #3 */
    { 0x3b7846, 0x3b7046, 0x00, 0x00, 0x00, 0x0 }, /* #4 */
    { 0x094106, 0x094146, 0x00, 0x00, 0x00, 0x0 }, /* #5 */
    { 0x146447, 0x146402, 0x64, 0x64, 0x00, 0x0 }, /* #6 */
    { 0x2a1ec3, 0x2a1686, 0x87, 0x87, 0x00, 0x0 }, /* #7 */
    { 0x384482, 0x384486, 0xca, 0xca, 0x00, 0x0 }, /* #8 */
    { 0x353352, 0x353386, 0xff, 0xff, 0x00, 0x0 }, /* #9 */
    { 0x2d4607, 0x2d4686, 0x8e, 0x8e, 0x00, 0x0 }, /* #10 */
    { 0x164206, 0x164206, 0x48, 0x48, 0x00, 0x0 }, /* #11 */
    { 0x142e96, 0x142613, 0x1a, 0x07, 0xed, 0x0 }, /* #12 */
    { 0x2e3fc7, 0x2e3706, 0x35, 0x77, 0x42, 0x0 }, /* #13 */
    { 0x0b2753, 0x0b2706, 0x4c, 0x6c, 0x20, 0x0 }, /* #14 */
    { 0x383b92, 0x383392, 0x08, 0xd0, 0xc8, 0x0 }, /* #15 */
    { 0x176a46, 0x176203, 0xf1, 0x25, 0x34, 0x0 }, /* #16 */
    { 0x066753, 0x066782, 0xb2, 0xdf, 0x2d, 0x0 }, /* #17 */
    { 0x1475d3, 0x147d03, 0x96, 0x6e, 0xd8, 0x0 }, /* #18 */
    { 0x3b2586, 0x3b2516, 0x4c, 0x5a, 0x0e, 0x0 }, /* #19 */
    { 0x0c4c52, 0x0c4c07, 0x80, 0x48, 0xc8, 0x0 }, /* #20 */
    { 0x166507, 0x166503, 0x50, 0x19, 0xc9, 0x0 }, /* #21 */
    { 0x1272d3, 0x127a92, 0x67, 0xc4, 0x5d, 0x0 }, /* #22 */
    { 0x175cd3, 0x175413, 0xd8, 0x34, 0x5c, 0x0 }, /* #23 */
    { 0x167c43, 0x167c07, 0x87, 0x5c, 0xd5, 0x0 }, /* #24 */
    { 0x2c2112, 0x2c2103, 0x74, 0x4f, 0xdb, 0x0 }, /* #25 */
    { 0x3202c3, 0x320202, 0x34, 0x37, 0x03, 0x0 }, /* #26 */
    { 0x250c96, 0x250482, 0xb4, 0xfb, 0x47, 0x0 }, /* #27 */
    { 0x111492, 0x111416, 0x04, 0x42, 0x3e, 0x0 }, /* #28 */
    { 0x0e1ad7, 0x0e1202, 0x00, 0x62, 0x62, 0x0 }, /* #29 */
    { 0x235056, 0x235017, 0xa3, 0x22, 0x7f, 0x0 }, /* #30 */
    { 0x2938c7, 0x293016, 0x0c, 0x33, 0x27, 0x0 }, /* #31 */
    { 0x2d0813, 0x2d0093, 0xae, 0xa4, 0xf6, 0x0 }, /* #32 */
    { 0x334406, 0x334c07, 0xab, 0x4e, 0xa3, 0x0 }, /* #33 */
    { 0x3c2296, 0x3c2202, 0x58, 0x5b, 0x03, 0x0 }, /* #34 */
    { 0x3529d2, 0x352992, 0x2e, 0xa2, 0x74, 0x0 }, /* #35 */
    { 0x185292, 0x185213, 0x7c, 0x02, 0x86, 0x0 }, /* #36 */
    { 0x0b49d7, 0x0b4103, 0x62, 0x26, 0xc4, 0x0 }, /* #37 */
    { 0x367d46, 0x367516, 0x49, 0x60, 0x17, 0x0 }, /* #38 */
    { 0x1f7c93, 0x1f7486, 0x24, 0xd4, 0xb0, 0x0 }, /* #39 */
    { 0x147943, 0x147107, 0xf0, 0x39, 0x49, 0x0 }, /* #40 */
    { 0x0033d7, 0x003386, 0x34, 0xb7, 0x83, 0x0 }, /* #41 */
    { 0x360602, 0x360696, 0x1e, 0xa6, 0x88, 0x0 }, /* #42 */
    { 0x2063d7, 0x206302, 0x14, 0x2f, 0x1b, 0x0 }, /* #43 */
    { 0x3c2942, 0x3c2196, 0x9e, 0xf0, 0x52, 0x0 }, /* #44 */
    { 0x2a0c12, 0x2a0c17, 0x8e, 0x72, 0xe4, 0x0 }, /* #45 */
    { 0x317f52, 0x317787, 0x9e, 0x8e, 0xf0, 0x0 }, /* #46 */
    { 0x287616, 0x287e17, 0xbd, 0x50, 0x93, 0x0 }, /* #47 */
    { 0x375e57, 0x375696, 0x9a, 0xa6, 0x0c, 0x0 }, /* #48 */
    { 0x3b7416, 0x3b7c96, 0x69, 0xb1, 0x48, 0x0 }, /* #49 */
    { 0x1b3342, 0x1b3397, 0xf3, 0x81, 0x8e, 0x0 }, /* #50 */
    { 0x0e1f47, 0x0e1f86, 0x55, 0x8e, 0x39, 0x0 }, /* #51 */
    { 0x393e86, 0x393693, 0xda, 0xc2, 0xe8, 0x0 }, /* #52 */
    { 0x2d76d6, 0x2d7682, 0x92, 0xd9, 0x47, 0x0 }, /* #53 */
    { 0x2254d3, 0x225486, 0x3d, 0xcf, 0x92, 0x0 }, /* #54 */
    { 0x0e2bc6, 0x0e2b17, 0xca, 0x63, 0x99, 0x0 }, /* #55 */
    { 0x2d7c02, 0x2d7402, 0x22, 0x5e, 0x3c, 0x0 }, /* #56 */
    { 0x2e67c2, 0x2e6f13, 0x88, 0x40, 0xb8, 0x0 }, /* #57 */
    { 0x330f82, 0x330716, 0x37, 0x60, 0x29, 0x0 }, /* #58 */
    { 0x277f12, 0x277f13, 0x9d, 0x73, 0xd6, 0x0 }, /* #59 */
    { 0x017557, 0x017517, 0x5b, 0x24, 0xc9, 0x0 }, /* #60 */
    { 0x334657, 0x334606, 0x36, 0x6f, 0x39, 0x0 }, /* #61 */
    { 0x1b53d6, 0x1b5313, 0x17, 0x04, 0xed, 0x0 }, /* #62 */
    { 0x0f1ad7, 0x0f1a96, 0x5b, 0xc6, 0x6b, 0x0 }, /* #63 */
    { 0x100f93, 0x100f03, 0x97, 0x2f, 0x98, 0x0 }, /* #64 */
    { 0x3e2446, 0x3e2486, 0x94, 0xde, 0x4a, 0x0 }, /* #65 */
    { 0x353ec2, 0x353613, 0x57, 0x45, 0xee, 0x0 }, /* #66 */
    { 0x354c47, 0x354407, 0xb4, 0x1b, 0x67, 0x0 }, /* #67 */
    { 0x142b03, 0x142b17, 0xb9, 0x78, 0xbf, 0x0 }, /* #68 */
    { 0x123586, 0x123583, 0xd1, 0xba, 0xe9, 0x0 }, /* #69 */
    { 0x135d46, 0x135516, 0x3b, 0x48, 0x0d, 0x0 }, /* #70 */
    { 0x365d86, 0x365582, 0xa2, 0xad, 0x0b, 0x0 }, /* #71 */
    { 0x294393, 0x294302, 0x52, 0x75, 0x23, 0x0 }, /* #72 */
    { 0x266616, 0x266682, 0xb6, 0xf7, 0x41, 0x0 }, /* #73 */
    { 0x303d52, 0x303597, 0xbf, 0xb1, 0xf2, 0x0 }, /* #74 */
    { 0x057a93, 0x057296, 0x03, 0xd2, 0xcf, 0x0 }, /* #75 */
    { 0x346143, 0x346182, 0x15, 0xc7, 0xb2, 0x0 }, /* #76 */
    { 0x2b11c7, 0x2b1986, 0x63, 0x84, 0x21, 0x0 }, /* #77 */
    { 0x387cd7, 0x387487, 0xd0, 0xa5, 0xd5, 0x0 }, /* #78 */
    { 0x104a13, 0x104282, 0xa5, 0xa8, 0x03, 0x0 }, /* #79 */
    { 0x0c1193, 0x0c1197, 0xf4, 0x82, 0x8e, 0x0 }, /* #80 */
    { 0x092e06, 0x092e92, 0x69, 0xd5, 0x6c, 0x0 }, /* #81 */
    { 0x3c1e93, 0x3c1607, 0xf7, 0x0c, 0x15, 0x0 }, /* #82 */
    { 0x3c7d87, 0x3c7517, 0x2b, 0x18, 0xed, 0x0 }, /* #83 */
    { 0x012713, 0x012796, 0x9f, 0xd8, 0x39, 0x0 }, /* #84 */
    { 0x291f82, 0x291717, 0x5a, 0x59, 0xff, 0x0 }, /* #85 */
    { 0x144ed2, 0x144617, 0x54, 0x30, 0xdc, 0x0 }, /* #86 */
    { 0x275ec6, 0x275617, 0xff, 0x41, 0x42, 0x0 }, /* #87 */
    { 0x1d5a53, 0x1d5287, 0xd9, 0xbb, 0xe2, 0x0 }, /* #88 */
    { 0x1f4ed7, 0x1f4e92, 0x39, 0xb3, 0x7a, 0x0 }, /* #89 */
    { 0x2c43c3, 0x2c4386, 0x28, 0xdd, 0xb5, 0x0 }, /* #90 */
    { 0x1953c2, 0x195306, 0x00, 0x41, 0x41, 0x0 }, /* #91 */
    { 0x2b1016, 0x2b1012, 0x2a, 0x57, 0x2d, 0x0 }, /* #92 */
    { 0x243a13, 0x243217, 0x67, 0x42, 0xdb, 0x0 }, /* #93 */
    { 0x2304d2, 0x230407, 0x78, 0x2b, 0xb3, 0x0 }, /* #94 */
    { 0x117ac2, 0x117287, 0xb4, 0xac, 0xf8, 0x0 }, /* #95 */
};
uint32_t const g_cTests_add_u8_locked = RT_ELEMENTS(g_aTests_add_u8_locked);

BINU8_TEST_T const g_aTests_adc_u8[] =
{
    { 0x3d3a92, 0x3d3246, 0x00, 0x00, 0x00, 0x0 }, /* #0 */
    { 0x2f0a53, 0x2f0202, 0x00, 0x01, 0x00, 0x0 }, /* #1 */
    { 0x063046, 0x063046, 0x00, 0x00, 0x00, 0x0 }, /* #2 */
    { 0x354b57, 0x354302, 0x00, 0x01, 0x00, 0x0 }, /* #3 */
    { 0x304182, 0x304146, 0x00, 0x00, 0x00, 0x0 }, /* #4 */
    { 0x0e0b06, 0x0e0346, 0x00, 0x00, 0x00, 0x0 }, /* #5 */
    { 0x001242, 0x001206, 0x7d, 0x7d, 0x00, 0x0 }, /* #6 */
    { 0x3b3642, 0x3b3686, 0xe8, 0xe8, 0x00, 0x0 }, /* #7 */
    { 0x0d5347, 0x0d5382, 0xa7, 0xa8, 0x00, 0x0 }, /* #8 */
    { 0x3f4007, 0x3f4006, 0x38, 0x39, 0x00, 0x0 }, /* #9 */
    { 0x2a4182, 0x2a4102, 0x6b, 0x6b, 0x00, 0x0 }, /* #10 */
    { 0x1461c7, 0x146182, 0xe9, 0xea, 0x00, 0x0 }, /* #11 */
    { 0x0f6217, 0x0f6297, 0xef, 0x82, 0x92, 0x0 }, /* #12 */
    { 0x167e83, 0x167682, 0xa3, 0xdf, 0x3b, 0x0 }, /* #13 */
    { 0x143d17, 0x143597, 0xfa, 0xf3, 0xf8, 0x0 }, /* #14 */
    { 0x184dc2, 0x184512, 0x3f, 0x54, 0x15, 0x0 }, /* #15 */
    { 0x116246, 0x116287, 0xf3, 0xdb, 0xe8, 0x0 }, /* #16 */
    { 0x187206, 0x187296, 0x4e, 0xd2, 0x84, 0x0 }, /* #17 */
    { 0x2d1117, 0x2d1106, 0x24, 0x59, 0x34, 0x0 }, /* #18 */
    { 0x364716, 0x364f03, 0xb4, 0x49, 0x95, 0x0 }, /* #19 */
    { 0x2b1b83, 0x2b1b03, 0x83, 0x75, 0xf1, 0x0 }, /* #20 */
    { 0x003f46, 0x003783, 0xd9, 0xcb, 0xf2, 0x0 }, /* #21 */
    { 0x3766d3, 0x376e03, 0xa7, 0x2f, 0x87, 0x0 }, /* #22 */
    { 0x2a07d7, 0x2a0783, 0xf5, 0xae, 0xb8, 0x0 }, /* #23 */
    { 0x2404d2, 0x240407, 0xf7, 0x17, 0x20, 0x0 }, /* #24 */
    { 0x053a52, 0x053286, 0x56, 0xde, 0x88, 0x0 }, /* #25 */
    { 0x1b3256, 0x1b3293, 0xdb, 0x85, 0xaa, 0x0 }, /* #26 */
    { 0x3d32c7, 0x3d3282, 0xe3, 0xec, 0x08, 0x0 }, /* #27 */
    { 0x385446, 0x385486, 0x0c, 0xed, 0xe1, 0x0 }, /* #28 */
    { 0x340f82, 0x340f17, 0x85, 0x42, 0xbd, 0x0 }, /* #29 */
    { 0x1c1486, 0x1c1c17, 0x88, 0x53, 0xcb, 0x0 }, /* #30 */
    { 0x233306, 0x233313, 0x85, 0x02, 0x7d, 0x0 }, /* #31 */
    { 0x392696, 0x392697, 0xf5, 0x82, 0x8d, 0x0 }, /* #32 */
    { 0x111ed6, 0x111617, 0x0d, 0x03, 0xf6, 0x0 }, /* #33 */
    { 0x1120d3, 0x112093, 0x8a, 0x85, 0xfa, 0x0 }, /* #34 */
    { 0x135853, 0x135017, 0xb8, 0x27, 0x6e, 0x0 }, /* #35 */
    { 0x216b92, 0x216382, 0x22, 0xf8, 0xd6, 0x0 }, /* #36 */
    { 0x0d7803, 0x0d7006, 0x04, 0x77, 0x72, 0x0 }, /* #37 */
    { 0x103942, 0x103903, 0x80, 0x43, 0xc3, 0x0 }, /* #38 */
    { 0x1a18c7, 0x1a1096, 0x18, 0xe4, 0xcb, 0x0 }, /* #39 */
    { 0x0a2e97, 0x0a2613, 0x3d, 0x08, 0xca, 0x0 }, /* #40 */
    { 0x396543, 0x396507, 0xca, 0x3c, 0x71, 0x0 }, /* #41 */
    { 0x2b5996, 0x2b5106, 0x55, 0x66, 0x11, 0x0 }, /* #42 */
    { 0x2a2947, 0x2a2113, 0x7f, 0x13, 0x93, 0x0 }, /* #43 */
    { 0x0b76d3, 0x0b7687, 0xc4, 0xa5, 0xe0, 0x0 }, /* #44 */
    { 0x293317, 0x293302, 0x46, 0x7f, 0x38, 0x0 }, /* #45 */
    { 0x2406d2, 0x240617, 0x57, 0x05, 0xae, 0x0 }, /* #46 */
    { 0x0c0982, 0x0c0117, 0x5c, 0x3a, 0xde, 0x0 }, /* #47 */
    { 0x372017, 0x372886, 0x74, 0x88, 0x13, 0x0 }, /* #48 */
    { 0x134d06, 0x134582, 0x80, 0xc8, 0x48, 0x0 }, /* #49 */
    { 0x013f86, 0x013792, 0x2f, 0xe3, 0xb4, 0x0 }, /* #50 */
    { 0x1023d6, 0x102382, 0xa1, 0xcb, 0x2a, 0x0 }, /* #51 */
    { 0x3f55c6, 0x3f5506, 0x61, 0x6f, 0x0e, 0x0 }, /* #52 */
    { 0x1f1346, 0x1f1302, 0x22, 0x49, 0x27, 0x0 }, /* #53 */
    { 0x0c5157, 0x0c5907, 0x95, 0x6f, 0xd9, 0x0 }, /* #54 */
    { 0x050b12, 0x050382, 0x89, 0xdc, 0x53, 0x0 }, /* #55 */
    { 0x2608c6, 0x260006, 0x02, 0x3a, 0x38, 0x0 }, /* #56 */
    { 0x297c52, 0x297406, 0x51, 0x6f, 0x1e, 0x0 }, /* #57 */
    { 0x386c07, 0x386496, 0xb9, 0xc0, 0x06, 0x0 }, /* #58 */
    { 0x262186, 0x262116, 0x2f, 0x71, 0x42, 0x0 }, /* #59 */
    { 0x1d3b42, 0x1d3396, 0x58, 0xe2, 0x8a, 0x0 }, /* #60 */
    { 0x2a5912, 0x2a5117, 0x5d, 0x5a, 0xfd, 0x0 }, /* #61 */
    { 0x285e07, 0x285613, 0x1a, 0x10, 0xf5, 0x0 }, /* #62 */
    { 0x016546, 0x016d03, 0xe3, 0x7a, 0x97, 0x0 }, /* #63 */
    { 0x087186, 0x087112, 0x28, 0x75, 0x4d, 0x0 }, /* #64 */
    { 0x382897, 0x382017, 0xee, 0x06, 0x17, 0x0 }, /* #65 */
    { 0x190c13, 0x190403, 0x50, 0x0d, 0xbc, 0x0 }, /* #66 */
    { 0x0f4e96, 0x0f4606, 0x32, 0x47, 0x15, 0x0 }, /* #67 */
    { 0x240916, 0x240182, 0xc7, 0xfb, 0x34, 0x0 }, /* #68 */
    { 0x071782, 0x071782, 0x22, 0xf7, 0xd5, 0x0 }, /* #69 */
    { 0x3b2856, 0x3b2003, 0xf0, 0x1a, 0x2a, 0x0 }, /* #70 */
    { 0x152bd7, 0x152306, 0x77, 0x7b, 0x03, 0x0 }, /* #71 */
    { 0x2d0a17, 0x2d0212, 0x08, 0x16, 0x0d, 0x0 }, /* #72 */
    { 0x2977c2, 0x297782, 0x2c, 0xbf, 0x93, 0x0 }, /* #73 */
    { 0x0c6153, 0x0c6196, 0xa3, 0xd1, 0x2d, 0x0 }, /* #74 */
    { 0x1d1717, 0x1d1703, 0xe0, 0x02, 0x21, 0x0 }, /* #75 */
    { 0x233a42, 0x233206, 0x43, 0x6a, 0x27, 0x0 }, /* #76 */
    { 0x0157c3, 0x015707, 0x71, 0x4d, 0xdb, 0x0 }, /* #77 */
    { 0x256486, 0x256487, 0xe5, 0xac, 0xc7, 0x0 }, /* #78 */
    { 0x242d93, 0x242503, 0x66, 0x1f, 0xb8, 0x0 }, /* #79 */
    { 0x1e5842, 0x1e5003, 0xb6, 0x26, 0x70, 0x0 }, /* #80 */
    { 0x0d6353, 0x0d6317, 0x5f, 0x42, 0xe2, 0x0 }, /* #81 */
    { 0x276793, 0x276713, 0x7f, 0x64, 0xe4, 0x0 }, /* #82 */
    { 0x256686, 0x256617, 0xdf, 0x0a, 0x2b, 0x0 }, /* #83 */
    { 0x021882, 0x021086, 0xb9, 0xed, 0x34, 0x0 }, /* #84 */
    { 0x1268c6, 0x126892, 0x4b, 0xc4, 0x79, 0x0 }, /* #85 */
    { 0x2b5383, 0x2b5317, 0xee, 0x60, 0x71, 0x0 }, /* #86 */
    { 0x012a47, 0x012a13, 0xca, 0x64, 0x99, 0x0 }, /* #87 */
    { 0x143317, 0x143302, 0x52, 0x73, 0x20, 0x0 }, /* #88 */
    { 0x207ad2, 0x207a96, 0x79, 0x87, 0x0e, 0x0 }, /* #89 */
    { 0x331d82, 0x331503, 0xd0, 0x19, 0x49, 0x0 }, /* #90 */
    { 0x143b57, 0x143b13, 0x8f, 0x70, 0xe0, 0x0 }, /* #91 */
    { 0x0d3c57, 0x0d3406, 0x3e, 0x6f, 0x30, 0x0 }, /* #92 */
    { 0x1c5596, 0x1c5596, 0x98, 0xa5, 0x0d, 0x0 }, /* #93 */
    { 0x1e6d83, 0x1e6d86, 0x33, 0x8b, 0x57, 0x0 }, /* #94 */
    { 0x056b13, 0x056317, 0xc7, 0x22, 0x5a, 0x0 }, /* #95 */
};
uint32_t const g_cTests_adc_u8 = RT_ELEMENTS(g_aTests_adc_u8);

BINU8_TEST_T const g_aTests_adc_u8_locked[] =
{
    { 0x1e1bd6, 0x1e1346, 0x00, 0x00, 0x00, 0x0 }, /* #0 */
    { 0x3b2942, 0x3b2146, 0x00, 0x00, 0x00, 0x0 }, /* #1 */
    { 0x2a4212, 0x2a4246, 0x00, 0x00, 0x00, 0x0 }, /* #2 */
    { 0x082fc7, 0x082702, 0x00, 0x01, 0x00, 0x0 }, /* #3 */
    { 0x1f6387, 0x1f6302, 0x00, 0x01, 0x00, 0x0 }, /* #4 */
    { 0x0d72d3, 0x0d7202, 0x00, 0x01, 0x00, 0x0 }, /* #5 */
    { 0x304796, 0x304786, 0x8d, 0x8d, 0x00, 0x0 }, /* #6 */
    { 0x1b1dd3, 0x1b1586, 0xb7, 0xb8, 0x00, 0x0 }, /* #7 */
    { 0x103297, 0x103206, 0x21, 0x22, 0x00, 0x0 }, /* #8 */
    { 0x090b12, 0x090306, 0x72, 0x72, 0x00, 0x0 }, /* #9 */
    { 0x2d49d7, 0x2d4186, 0xb1, 0xb2, 0x00, 0x0 }, /* #10 */
    { 0x3f79d3, 0x3f7186, 0xa4, 0xa5, 0x00, 0x0 }, /* #11 */
    { 0x1b2453, 0x1b2412, 0x29, 0x73, 0x49, 0x0 }, /* #12 */
    { 0x213b57, 0x213387, 0xd5, 0x87, 0xb1, 0x0 }, /* #13 */
    { 0x306c87, 0x306497, 0xdd, 0xd2, 0xf4, 0x0 }, /* #14 */
    { 0x066202, 0x066286, 0xa1, 0xe7, 0x46, 0x0 }, /* #15 */
    { 0x241393, 0x241392, 0xac, 0xdc, 0x2f, 0x0 }, /* #16 */
    { 0x0d6c17, 0x0d6492, 0x96, 0xa1, 0x0a, 0x0 }, /* #17 */
    { 0x2e5b97, 0x2e5386, 0x15, 0xcc, 0xb6, 0x0 }, /* #18 */
    { 0x106047, 0x106017, 0x75, 0x05, 0x8f, 0x0 }, /* #19 */
    { 0x2c5482, 0x2c5413, 0x3b, 0x26, 0xeb, 0x0 }, /* #20 */
    { 0x0b1fc3, 0x0b1796, 0xd9, 0xf0, 0x16, 0x0 }, /* #21 */
    { 0x312017, 0x312086, 0x44, 0xee, 0xa9, 0x0 }, /* #22 */
    { 0x0f7d52, 0x0f7586, 0x00, 0xca, 0xca, 0x0 }, /* #23 */
    { 0x2f7813, 0x2f7096, 0x09, 0xf5, 0xeb, 0x0 }, /* #24 */
    { 0x190f52, 0x190792, 0xea, 0xf7, 0x0d, 0x0 }, /* #25 */
    { 0x131613, 0x131682, 0x24, 0xb9, 0x94, 0x0 }, /* #26 */
    { 0x3e7f52, 0x3e7707, 0x3a, 0x1b, 0xe1, 0x0 }, /* #27 */
    { 0x194e46, 0x194603, 0xf5, 0x67, 0x72, 0x0 }, /* #28 */
    { 0x1611d7, 0x161103, 0x13, 0x07, 0xf3, 0x0 }, /* #29 */
    { 0x084003, 0x084817, 0xdc, 0x72, 0x95, 0x0 }, /* #30 */
    { 0x1a7597, 0x1a7506, 0x10, 0x12, 0x01, 0x0 }, /* #31 */
    { 0x2d5f53, 0x2d5792, 0x0d, 0xad, 0x9f, 0x0 }, /* #32 */
    { 0x3a7f07, 0x3a7f07, 0x91, 0x12, 0x80, 0x0 }, /* #33 */
    { 0x2f0d13, 0x2f0d17, 0xa7, 0x30, 0x88, 0x0 }, /* #34 */
    { 0x256f03, 0x256792, 0x09, 0xe9, 0xdf, 0x0 }, /* #35 */
    { 0x112193, 0x112102, 0x22, 0x23, 0x00, 0x0 }, /* #36 */
    { 0x280e47, 0x280e96, 0x7f, 0xe7, 0x67, 0x0 }, /* #37 */
    { 0x006597, 0x006d03, 0xc8, 0x6e, 0xa5, 0x0 }, /* #38 */
    { 0x274b43, 0x274312, 0x17, 0x70, 0x58, 0x0 }, /* #39 */
    { 0x1605d6, 0x160d86, 0x63, 0xac, 0x49, 0x0 }, /* #40 */
    { 0x083c43, 0x083417, 0x2a, 0x11, 0xe6, 0x0 }, /* #41 */
    { 0x165d02, 0x165597, 0xad, 0x96, 0xe9, 0x0 }, /* #42 */
    { 0x1e3b86, 0x1e3b03, 0xd3, 0x58, 0x85, 0x0 }, /* #43 */
    { 0x212f17, 0x212f92, 0x39, 0x85, 0x4b, 0x0 }, /* #44 */
    { 0x196dd6, 0x196d07, 0xb1, 0x35, 0x84, 0x0 }, /* #45 */
    { 0x043696, 0x043e03, 0xe5, 0x7f, 0x9a, 0x0 }, /* #46 */
    { 0x0e5cd2, 0x0e5413, 0x68, 0x37, 0xcf, 0x0 }, /* #47 */
    { 0x377196, 0x377186, 0xb0, 0xc6, 0x16, 0x0 }, /* #48 */
    { 0x120092, 0x120896, 0x2e, 0x87, 0x59, 0x0 }, /* #49 */
    { 0x3b2887, 0x3b2003, 0x91, 0x07, 0x75, 0x0 }, /* #50 */
    { 0x1068c6, 0x106896, 0x6b, 0xe2, 0x77, 0x0 }, /* #51 */
    { 0x1d1187, 0x1d1107, 0x63, 0x55, 0xf1, 0x0 }, /* #52 */
    { 0x026186, 0x026103, 0xe3, 0x49, 0x66, 0x0 }, /* #53 */
    { 0x220543, 0x220582, 0x4c, 0xdf, 0x92, 0x0 }, /* #54 */
    { 0x1b6e87, 0x1b6607, 0x20, 0x11, 0xf0, 0x0 }, /* #55 */
    { 0x255006, 0x255012, 0x2e, 0x79, 0x4b, 0x0 }, /* #56 */
    { 0x307c17, 0x307497, 0xfe, 0xb4, 0xb5, 0x0 }, /* #57 */
    { 0x3474c2, 0x347413, 0x35, 0x01, 0xcc, 0x0 }, /* #58 */
    { 0x1f01c6, 0x1f0986, 0x2f, 0x9f, 0x70, 0x0 }, /* #59 */
    { 0x223082, 0x223882, 0x72, 0xb9, 0x47, 0x0 }, /* #60 */
    { 0x196f12, 0x196f03, 0xa1, 0x62, 0xc1, 0x0 }, /* #61 */
    { 0x075493, 0x075417, 0x7c, 0x69, 0xec, 0x0 }, /* #62 */
    { 0x0f4797, 0x0f4f96, 0x4e, 0x8e, 0x3f, 0x0 }, /* #63 */
    { 0x0001d2, 0x000913, 0x9a, 0x75, 0xdb, 0x0 }, /* #64 */
    { 0x252282, 0x252286, 0x86, 0x99, 0x13, 0x0 }, /* #65 */
    { 0x2f5a42, 0x2f5296, 0x08, 0xd4, 0xcc, 0x0 }, /* #66 */
    { 0x032ad3, 0x032257, 0x79, 0x00, 0x86, 0x0 }, /* #67 */
    { 0x040606, 0x040696, 0x9e, 0xa0, 0x02, 0x0 }, /* #68 */
    { 0x105b42, 0x105306, 0x35, 0x4d, 0x18, 0x0 }, /* #69 */
    { 0x304bc3, 0x304b96, 0x48, 0xb7, 0x6e, 0x0 }, /* #70 */
    { 0x2e6f46, 0x2e6796, 0x95, 0xb1, 0x1c, 0x0 }, /* #71 */
    { 0x084a86, 0x084296, 0xae, 0xd8, 0x2a, 0x0 }, /* #72 */
    { 0x005496, 0x005c03, 0xa7, 0x6d, 0xc6, 0x0 }, /* #73 */
    { 0x190ec2, 0x190686, 0x08, 0xcc, 0xc4, 0x0 }, /* #74 */
    { 0x026487, 0x026496, 0x81, 0xc0, 0x3e, 0x0 }, /* #75 */
    { 0x032d92, 0x032d13, 0xb6, 0x73, 0xbd, 0x0 }, /* #76 */
    { 0x235703, 0x235713, 0x6b, 0x62, 0xf6, 0x0 }, /* #77 */
    { 0x106a57, 0x106292, 0x2d, 0xf8, 0xca, 0x0 }, /* #78 */
    { 0x1c0596, 0x1c0506, 0x45, 0x65, 0x20, 0x0 }, /* #79 */
    { 0x027182, 0x027907, 0xa5, 0x6c, 0xc7, 0x0 }, /* #80 */
    { 0x3f3f47, 0x3f3f17, 0xa4, 0x42, 0x9d, 0x0 }, /* #81 */
    { 0x1f6a47, 0x1f6293, 0xd3, 0xc2, 0xee, 0x0 }, /* #82 */
    { 0x361a02, 0x361a03, 0xc0, 0x75, 0xb5, 0x0 }, /* #83 */
    { 0x164592, 0x164516, 0x0e, 0x69, 0x5b, 0x0 }, /* #84 */
    { 0x1853c3, 0x185b13, 0x88, 0x73, 0xea, 0x0 }, /* #85 */
    { 0x215596, 0x215502, 0x50, 0x5d, 0x0d, 0x0 }, /* #86 */
    { 0x084707, 0x084706, 0x01, 0x3a, 0x38, 0x0 }, /* #87 */
    { 0x0d4847, 0x0d4086, 0x84, 0xaf, 0x2a, 0x0 }, /* #88 */
    { 0x024757, 0x024717, 0x2d, 0x06, 0xd8, 0x0 }, /* #89 */
    { 0x3a7dc3, 0x3a7582, 0xd9, 0xfe, 0x24, 0x0 }, /* #90 */
    { 0x0e2c92, 0x0e2c96, 0x6a, 0x87, 0x1d, 0x0 }, /* #91 */
    { 0x1c61d2, 0x1c6102, 0x54, 0x58, 0x04, 0x0 }, /* #92 */
    { 0x243912, 0x243183, 0xb7, 0x98, 0xe1, 0x0 }, /* #93 */
    { 0x294693, 0x294e96, 0x7e, 0x87, 0x08, 0x0 }, /* #94 */
    { 0x070317, 0x070313, 0x3f, 0x1f, 0xdf, 0x0 }, /* #95 */
};
uint32_t const g_cTests_adc_u8_locked = RT_ELEMENTS(g_aTests_adc_u8_locked);

BINU8_TEST_T const g_aTests_sub_u8[] =
{
    { 0x220f06, 0x220746, 0x00, 0x00, 0x00, 0x0 }, /* #0 */
    { 0x387493, 0x387446, 0x00, 0x00, 0x00, 0x0 }, /* #1 */
    { 0x2a5f53, 0x2a5746, 0x00, 0x00, 0x00, 0x0 }, /* #2 */
    { 0x1a3e97, 0x1a3646, 0x00, 0x00, 0x00, 0x0 }, /* #3 */
    { 0x194012, 0x194046, 0x00, 0x00, 0x00, 0x0 }, /* #4 */
    { 0x376f96, 0x376746, 0x00, 0x00, 0x00, 0x0 }, /* #5 */
    { 0x121bc3, 0x121306, 0x4e, 0x4e, 0x00, 0x0 }, /* #6 */
    { 0x114113, 0x114186, 0xc6, 0xc6, 0x00, 0x0 }, /* #7 */
    { 0x140e03, 0x140686, 0xf9, 0xf9, 0x00, 0x0 }, /* #8 */
    { 0x151892, 0x151086, 0xc9, 0xc9, 0x00, 0x0 }, /* #9 */
    { 0x364653, 0x364602, 0x67, 0x67, 0x00, 0x0 }, /* #10 */
    { 0x3b2687, 0x3b2682, 0xc2, 0xc2, 0x00, 0x0 }, /* #11 */
    { 0x3f4a56, 0x3f4297, 0x07, 0xeb, 0x1c, 0x0 }, /* #12 */
    { 0x123fd3, 0x123793, 0x00, 0xce, 0x32, 0x0 }, /* #13 */
    { 0x3a3d57, 0x3a3517, 0x22, 0x4d, 0xd5, 0x0 }, /* #14 */
    { 0x030f47, 0x030716, 0xc6, 0x3a, 0x8c, 0x0 }, /* #15 */
    { 0x097153, 0x097183, 0xbf, 0xe3, 0xdc, 0x0 }, /* #16 */
    { 0x002756, 0x002712, 0x51, 0x4a, 0x07, 0x0 }, /* #17 */
    { 0x1846d6, 0x184683, 0x8a, 0xa7, 0xe3, 0x0 }, /* #18 */
    { 0x291903, 0x291197, 0x12, 0xac, 0x66, 0x0 }, /* #19 */
    { 0x0b6a93, 0x0b6212, 0xd1, 0x32, 0x9f, 0x0 }, /* #20 */
    { 0x0844d7, 0x084497, 0xb2, 0xcc, 0xe6, 0x0 }, /* #21 */
    { 0x1034d7, 0x103412, 0xbc, 0x2f, 0x8d, 0x0 }, /* #22 */
    { 0x246003, 0x246096, 0xbc, 0x8e, 0x2e, 0x0 }, /* #23 */
    { 0x196407, 0x196486, 0xc6, 0xb2, 0x14, 0x0 }, /* #24 */
    { 0x134343, 0x134383, 0xcb, 0xf8, 0xd3, 0x0 }, /* #25 */
    { 0x354746, 0x354702, 0x6b, 0x10, 0x5b, 0x0 }, /* #26 */
    { 0x386d52, 0x386512, 0xd0, 0x4c, 0x84, 0x0 }, /* #27 */
    { 0x325e83, 0x325682, 0xad, 0x83, 0x2a, 0x0 }, /* #28 */
    { 0x2e2f46, 0x2e2f02, 0xb5, 0x45, 0x70, 0x0 }, /* #29 */
    { 0x3e1e17, 0x3e1602, 0xfe, 0x54, 0xaa, 0x0 }, /* #30 */
    { 0x2642d6, 0x264203, 0x3a, 0x45, 0xf5, 0x0 }, /* #31 */
    { 0x326b57, 0x326306, 0x0c, 0x03, 0x09, 0x0 }, /* #32 */
    { 0x215706, 0x215787, 0xc3, 0xf0, 0xd3, 0x0 }, /* #33 */
    { 0x316f12, 0x316702, 0x6b, 0x1a, 0x51, 0x0 }, /* #34 */
    { 0x3a2b53, 0x3a2382, 0xaa, 0x98, 0x12, 0x0 }, /* #35 */
    { 0x282853, 0x282086, 0xea, 0x88, 0x62, 0x0 }, /* #36 */
    { 0x0e7dd6, 0x0e7516, 0x72, 0x24, 0x4e, 0x0 }, /* #37 */
    { 0x1f5346, 0x1f5b06, 0xae, 0x33, 0x7b, 0x0 }, /* #38 */
    { 0x0d50c6, 0x0d5002, 0xb3, 0x02, 0xb1, 0x0 }, /* #39 */
    { 0x194107, 0x194997, 0x46, 0xac, 0x9a, 0x0 }, /* #40 */
    { 0x242a86, 0x242203, 0x42, 0x62, 0xe0, 0x0 }, /* #41 */
    { 0x2530c7, 0x253816, 0x90, 0x36, 0x5a, 0x0 }, /* #42 */
    { 0x2b2fd3, 0x2b2702, 0x6b, 0x6b, 0x00, 0x0 }, /* #43 */
    { 0x1763c2, 0x176387, 0xda, 0xf5, 0xe5, 0x0 }, /* #44 */
    { 0x0f5c56, 0x0f5483, 0x2e, 0xf4, 0x3a, 0x0 }, /* #45 */
    { 0x312c07, 0x312c83, 0x7a, 0xc7, 0xb3, 0x0 }, /* #46 */
    { 0x1d1082, 0x1d1086, 0xde, 0xca, 0x14, 0x0 }, /* #47 */
    { 0x310803, 0x310806, 0x94, 0x22, 0x72, 0x0 }, /* #48 */
    { 0x213586, 0x213583, 0x0e, 0xe3, 0x2b, 0x0 }, /* #49 */
    { 0x255416, 0x255493, 0x92, 0xc7, 0xcb, 0x0 }, /* #50 */
    { 0x2c64c2, 0x2c6c97, 0x71, 0xd7, 0x9a, 0x0 }, /* #51 */
    { 0x117543, 0x117593, 0x14, 0xe9, 0x2b, 0x0 }, /* #52 */
    { 0x1d1103, 0x1d1993, 0x22, 0x8c, 0x96, 0x0 }, /* #53 */
    { 0x030356, 0x030316, 0xe1, 0x47, 0x9a, 0x0 }, /* #54 */
    { 0x3121d2, 0x312103, 0x1f, 0x31, 0xee, 0x0 }, /* #55 */
    { 0x134d97, 0x134593, 0x41, 0xfd, 0x44, 0x0 }, /* #56 */
    { 0x225c07, 0x225417, 0x2b, 0x5c, 0xcf, 0x0 }, /* #57 */
    { 0x1e2593, 0x1e2583, 0xb7, 0xe0, 0xd7, 0x0 }, /* #58 */
    { 0x2b3f47, 0x2b3f12, 0x81, 0x19, 0x68, 0x0 }, /* #59 */
    { 0x321ac6, 0x321213, 0x36, 0x58, 0xde, 0x0 }, /* #60 */
    { 0x193382, 0x193b87, 0x68, 0xe2, 0x86, 0x0 }, /* #61 */
    { 0x192c83, 0x192407, 0x36, 0x41, 0xf5, 0x0 }, /* #62 */
    { 0x300f16, 0x300f06, 0x8e, 0x42, 0x4c, 0x0 }, /* #63 */
    { 0x130003, 0x130093, 0x10, 0xd6, 0x3a, 0x0 }, /* #64 */
    { 0x081513, 0x081592, 0xe1, 0xc2, 0x1f, 0x0 }, /* #65 */
    { 0x2612d2, 0x261a87, 0x79, 0x84, 0xf5, 0x0 }, /* #66 */
    { 0x051187, 0x051197, 0xa0, 0xac, 0xf4, 0x0 }, /* #67 */
    { 0x0e6157, 0x0e6187, 0x37, 0xd4, 0x63, 0x0 }, /* #68 */
    { 0x212083, 0x212087, 0x1e, 0xf3, 0x2b, 0x0 }, /* #69 */
    { 0x273496, 0x273413, 0x26, 0x4f, 0xd7, 0x0 }, /* #70 */
    { 0x252d42, 0x252d93, 0x56, 0xcd, 0x89, 0x0 }, /* #71 */
    { 0x206803, 0x206806, 0xb4, 0x42, 0x72, 0x0 }, /* #72 */
    { 0x210512, 0x210516, 0xb1, 0x06, 0xab, 0x0 }, /* #73 */
    { 0x3a0fc7, 0x3a0796, 0xed, 0x9f, 0x4e, 0x0 }, /* #74 */
    { 0x0a4656, 0x0a4616, 0xe2, 0x5a, 0x88, 0x0 }, /* #75 */
    { 0x095dc3, 0x095582, 0xcc, 0xb0, 0x1c, 0x0 }, /* #76 */
    { 0x2b4452, 0x2b4c87, 0x5e, 0xac, 0xb2, 0x0 }, /* #77 */
    { 0x144486, 0x144c97, 0x75, 0x96, 0xdf, 0x0 }, /* #78 */
    { 0x1b7206, 0x1b7286, 0xc0, 0xa0, 0x20, 0x0 }, /* #79 */
    { 0x2a0d96, 0x2a0597, 0xd7, 0xeb, 0xec, 0x0 }, /* #80 */
    { 0x093a16, 0x093207, 0x07, 0x72, 0x95, 0x0 }, /* #81 */
    { 0x2a7597, 0x2a7506, 0x61, 0x50, 0x11, 0x0 }, /* #82 */
    { 0x282652, 0x282607, 0x37, 0x50, 0xe7, 0x0 }, /* #83 */
    { 0x042396, 0x042302, 0xa7, 0x02, 0xa5, 0x0 }, /* #84 */
    { 0x170557, 0x170583, 0xb4, 0xe0, 0xd4, 0x0 }, /* #85 */
    { 0x390787, 0x390783, 0x08, 0xc2, 0x46, 0x0 }, /* #86 */
    { 0x0c2182, 0x0c2983, 0x76, 0xe0, 0x96, 0x0 }, /* #87 */
    { 0x222a86, 0x222a97, 0x67, 0xcf, 0x98, 0x0 }, /* #88 */
    { 0x0b6396, 0x0b6383, 0x93, 0xa2, 0xf1, 0x0 }, /* #89 */
    { 0x322b06, 0x322312, 0xd2, 0x49, 0x89, 0x0 }, /* #90 */
    { 0x324007, 0x324013, 0x17, 0x19, 0xfe, 0x0 }, /* #91 */
    { 0x225843, 0x225006, 0xd8, 0x42, 0x96, 0x0 }, /* #92 */
    { 0x3e6683, 0x3e6693, 0x94, 0x9e, 0xf6, 0x0 }, /* #93 */
    { 0x373f46, 0x373f83, 0x3e, 0x97, 0xa7, 0x0 }, /* #94 */
    { 0x196cc2, 0x196487, 0xad, 0xcc, 0xe1, 0x0 }, /* #95 */
};
uint32_t const g_cTests_sub_u8 = RT_ELEMENTS(g_aTests_sub_u8);

BINU8_TEST_T const g_aTests_sub_u8_locked[] =
{
    { 0x3b0496, 0x3b0446, 0x00, 0x00, 0x00, 0x0 }, /* #0 */
    { 0x303a97, 0x303246, 0x00, 0x00, 0x00, 0x0 }, /* #1 */
    { 0x045e56, 0x045646, 0x00, 0x00, 0x00, 0x0 }, /* #2 */
    { 0x183052, 0x183046, 0x00, 0x00, 0x00, 0x0 }, /* #3 */
    { 0x061647, 0x061646, 0x00, 0x00, 0x00, 0x0 }, /* #4 */
    { 0x3f4616, 0x3f4646, 0x00, 0x00, 0x00, 0x0 }, /* #5 */
    { 0x337617, 0x337602, 0x70, 0x70, 0x00, 0x0 }, /* #6 */
    { 0x254dc2, 0x254586, 0x95, 0x95, 0x00, 0x0 }, /* #7 */
    { 0x2458c7, 0x245082, 0x83, 0x83, 0x00, 0x0 }, /* #8 */
    { 0x384bc3, 0x384386, 0xc9, 0xc9, 0x00, 0x0 }, /* #9 */
    { 0x231a06, 0x231206, 0x7e, 0x7e, 0x00, 0x0 }, /* #10 */
    { 0x3d1b53, 0x3d1382, 0xcb, 0xcb, 0x00, 0x0 }, /* #11 */
    { 0x330397, 0x330312, 0x68, 0x3d, 0x2b, 0x0 }, /* #12 */
    { 0x1f1d82, 0x1f1517, 0x30, 0x63, 0xcd, 0x0 }, /* #13 */
    { 0x343256, 0x343a12, 0xe1, 0x79, 0x68, 0x0 }, /* #14 */
    { 0x3631d6, 0x363916, 0x99, 0x7e, 0x1b, 0x0 }, /* #15 */
    { 0x3f3382, 0x3f3312, 0xe8, 0x4a, 0x9e, 0x0 }, /* #16 */
    { 0x0a35c6, 0x0a3583, 0xb8, 0xd6, 0xe2, 0x0 }, /* #17 */
    { 0x3356c7, 0x335e93, 0x59, 0xbf, 0x9a, 0x0 }, /* #18 */
    { 0x0f0b16, 0x0f0b93, 0x58, 0xba, 0x9e, 0x0 }, /* #19 */
    { 0x1e71d2, 0x1e7993, 0x4a, 0x9d, 0xad, 0x0 }, /* #20 */
    { 0x0b4f83, 0x0b4f87, 0x78, 0x90, 0xe8, 0x0 }, /* #21 */
    { 0x3f0f92, 0x3f0f97, 0x48, 0xaf, 0x99, 0x0 }, /* #22 */
    { 0x3c6d92, 0x3c6586, 0x9e, 0x88, 0x16, 0x0 }, /* #23 */
    { 0x2b4e43, 0x2b4693, 0x14, 0xcb, 0x49, 0x0 }, /* #24 */
    { 0x320d43, 0x320592, 0xea, 0xdc, 0x0e, 0x0 }, /* #25 */
    { 0x2d0c52, 0x2d0c16, 0xd9, 0x7d, 0x5c, 0x0 }, /* #26 */
    { 0x0a7986, 0x0a7116, 0x60, 0x36, 0x2a, 0x0 }, /* #27 */
    { 0x022b97, 0x022316, 0x2a, 0x1d, 0x0d, 0x0 }, /* #28 */
    { 0x2271c6, 0x227193, 0x01, 0xfd, 0x04, 0x0 }, /* #29 */
    { 0x3c1096, 0x3c1093, 0xb5, 0xd9, 0xdc, 0x0 }, /* #30 */
    { 0x231d47, 0x231507, 0x04, 0x72, 0x92, 0x0 }, /* #31 */
    { 0x3c21d6, 0x3c2113, 0x14, 0x57, 0xbd, 0x0 }, /* #32 */
    { 0x1a1153, 0x1a1102, 0x0d, 0x08, 0x05, 0x0 }, /* #33 */
    { 0x164f02, 0x164797, 0x09, 0x8b, 0x7e, 0x0 }, /* #34 */
    { 0x1466c6, 0x146687, 0xab, 0xb1, 0xfa, 0x0 }, /* #35 */
    { 0x0e1d13, 0x0e1517, 0x67, 0x7b, 0xec, 0x0 }, /* #36 */
    { 0x124c43, 0x124c83, 0x7d, 0x89, 0xf4, 0x0 }, /* #37 */
    { 0x320992, 0x320993, 0x48, 0x8c, 0xbc, 0x0 }, /* #38 */
    { 0x1b31c7, 0x1b3912, 0xd6, 0x57, 0x7f, 0x0 }, /* #39 */
    { 0x2e2756, 0x2e2783, 0xd7, 0xe0, 0xf7, 0x0 }, /* #40 */
    { 0x1e5e12, 0x1e5687, 0xa3, 0xd2, 0xd1, 0x0 }, /* #41 */
    { 0x0f3cd6, 0x0f3c97, 0x77, 0x8d, 0xea, 0x0 }, /* #42 */
    { 0x1a7c07, 0x1a7482, 0xac, 0x97, 0x15, 0x0 }, /* #43 */
    { 0x150742, 0x150702, 0x89, 0x04, 0x85, 0x0 }, /* #44 */
    { 0x210383, 0x210b83, 0x3a, 0x86, 0xb4, 0x0 }, /* #45 */
    { 0x375fd2, 0x375706, 0xbc, 0x3c, 0x80, 0x0 }, /* #46 */
    { 0x210797, 0x210f87, 0x6c, 0xe1, 0x8b, 0x0 }, /* #47 */
    { 0x1a29c3, 0x1a2987, 0x67, 0x90, 0xd7, 0x0 }, /* #48 */
    { 0x286a96, 0x286296, 0xcc, 0x8d, 0x3f, 0x0 }, /* #49 */
    { 0x2b4582, 0x2b4586, 0xfb, 0x93, 0x68, 0x0 }, /* #50 */
    { 0x012747, 0x012713, 0x3e, 0x7f, 0xbf, 0x0 }, /* #51 */
    { 0x2108d6, 0x210816, 0xf6, 0x7d, 0x79, 0x0 }, /* #52 */
    { 0x3c5157, 0x3c5912, 0xa1, 0x2f, 0x72, 0x0 }, /* #53 */
    { 0x1f2fc7, 0x1f2782, 0xf3, 0xc1, 0x32, 0x0 }, /* #54 */
    { 0x2a0b42, 0x2a0393, 0x96, 0xdc, 0xba, 0x0 }, /* #55 */
    { 0x175c83, 0x175403, 0x07, 0x57, 0xb0, 0x0 }, /* #56 */
    { 0x300c02, 0x300487, 0x2c, 0xf3, 0x39, 0x0 }, /* #57 */
    { 0x003d02, 0x003593, 0x96, 0xa8, 0xee, 0x0 }, /* #58 */
    { 0x221093, 0x221816, 0xa0, 0x4d, 0x53, 0x0 }, /* #59 */
    { 0x1c1496, 0x1c1487, 0xbd, 0xe4, 0xd9, 0x0 }, /* #60 */
    { 0x022586, 0x022d93, 0x62, 0x85, 0xdd, 0x0 }, /* #61 */
    { 0x1e6883, 0x1e6006, 0xd5, 0x05, 0xd0, 0x0 }, /* #62 */
    { 0x214186, 0x214993, 0x31, 0x9e, 0x93, 0x0 }, /* #63 */
    { 0x131706, 0x131783, 0x6c, 0xf7, 0x75, 0x0 }, /* #64 */
    { 0x262146, 0x262146, 0xc2, 0x00, 0xc2, 0x0 }, /* #65 */
    { 0x2a2d56, 0x2a2596, 0xd0, 0xbd, 0x13, 0x0 }, /* #66 */
    { 0x326117, 0x326183, 0x37, 0xc1, 0x76, 0x0 }, /* #67 */
    { 0x0d4652, 0x0d4693, 0xad, 0xef, 0xbe, 0x0 }, /* #68 */
    { 0x0808c3, 0x080006, 0xb5, 0x12, 0xa3, 0x0 }, /* #69 */
    { 0x3548c7, 0x354083, 0x98, 0xa4, 0xf4, 0x0 }, /* #70 */
    { 0x3672c2, 0x367293, 0x91, 0xe3, 0xae, 0x0 }, /* #71 */
    { 0x277a96, 0x277a02, 0x8f, 0x52, 0x3d, 0x0 }, /* #72 */
    { 0x3b5286, 0x3b5283, 0x3d, 0xc2, 0x7b, 0x0 }, /* #73 */
    { 0x2a6906, 0x2a6192, 0xc2, 0xab, 0x17, 0x0 }, /* #74 */
    { 0x1666c6, 0x166602, 0x3b, 0x16, 0x25, 0x0 }, /* #75 */
    { 0x0e1982, 0x0e1102, 0xe2, 0x40, 0xa2, 0x0 }, /* #76 */
    { 0x324056, 0x324016, 0x5e, 0x3f, 0x1f, 0x0 }, /* #77 */
    { 0x120ed7, 0x120e83, 0x4a, 0xb3, 0x97, 0x0 }, /* #78 */
    { 0x2948c6, 0x294897, 0x61, 0xbe, 0xa3, 0x0 }, /* #79 */
    { 0x394ec7, 0x394683, 0x26, 0xe5, 0x41, 0x0 }, /* #80 */
    { 0x2e7256, 0x2e7206, 0xff, 0x74, 0x8b, 0x0 }, /* #81 */
    { 0x012bd7, 0x012397, 0x12, 0xe4, 0x2e, 0x0 }, /* #82 */
    { 0x2b1217, 0x2b1212, 0x24, 0x0e, 0x16, 0x0 }, /* #83 */
    { 0x3c5047, 0x3c5012, 0xfa, 0x3d, 0xbd, 0x0 }, /* #84 */
    { 0x1979d2, 0x197197, 0x44, 0xde, 0x66, 0x0 }, /* #85 */
    { 0x100056, 0x100893, 0x71, 0x8a, 0xe7, 0x0 }, /* #86 */
    { 0x1c73c7, 0x1c7b16, 0x85, 0x3c, 0x49, 0x0 }, /* #87 */
    { 0x320c83, 0x320c87, 0x23, 0xa3, 0x80, 0x0 }, /* #88 */
    { 0x0e0112, 0x0e0187, 0xaa, 0xe7, 0xc3, 0x0 }, /* #89 */
    { 0x1c5f52, 0x1c5703, 0x06, 0x62, 0xa4, 0x0 }, /* #90 */
    { 0x3765c3, 0x376502, 0x9e, 0x16, 0x88, 0x0 }, /* #91 */
    { 0x213e06, 0x213607, 0x16, 0x50, 0xc6, 0x0 }, /* #92 */
    { 0x0f4897, 0x0f4883, 0x6f, 0x92, 0xdd, 0x0 }, /* #93 */
    { 0x3f4cd3, 0x3f4497, 0xd1, 0xfa, 0xd7, 0x0 }, /* #94 */
    { 0x1051c7, 0x105983, 0x7d, 0xd9, 0xa4, 0x0 }, /* #95 */
};
uint32_t const g_cTests_sub_u8_locked = RT_ELEMENTS(g_aTests_sub_u8_locked);

BINU8_TEST_T const g_aTests_sbb_u8[] =
{
    { 0x303d97, 0x303597, 0x00, 0xff, 0x00, 0x0 }, /* #0 */
    { 0x1d6f57, 0x1d6797, 0x00, 0xff, 0x00, 0x0 }, /* #1 */
    { 0x242ed7, 0x242697, 0x00, 0xff, 0x00, 0x0 }, /* #2 */
    { 0x245e56, 0x245646, 0x00, 0x00, 0x00, 0x0 }, /* #3 */
    { 0x316587, 0x316597, 0x00, 0xff, 0x00, 0x0 }, /* #4 */
    { 0x1b4287, 0x1b4297, 0x00, 0xff, 0x00, 0x0 }, /* #5 */
    { 0x2a0bc3, 0x2a0382, 0x99, 0x98, 0x00, 0x0 }, /* #6 */
    { 0x325702, 0x325706, 0x65, 0x65, 0x00, 0x0 }, /* #7 */
    { 0x3e7002, 0x3e7086, 0x90, 0x90, 0x00, 0x0 }, /* #8 */
    { 0x291696, 0x291682, 0xd6, 0xd6, 0x00, 0x0 }, /* #9 */
    { 0x210342, 0x210306, 0x4b, 0x4b, 0x00, 0x0 }, /* #10 */
    { 0x3f5c16, 0x3f5402, 0x31, 0x31, 0x00, 0x0 }, /* #11 */
    { 0x167fc2, 0x167702, 0x68, 0x46, 0x22, 0x0 }, /* #12 */
    { 0x1b42c6, 0x1b4282, 0xde, 0x98, 0x46, 0x0 }, /* #13 */
    { 0x124dd3, 0x124d93, 0x55, 0xb5, 0x9f, 0x0 }, /* #14 */
    { 0x121c46, 0x121412, 0xe0, 0x13, 0xcd, 0x0 }, /* #15 */
    { 0x056243, 0x056a16, 0x95, 0x55, 0x3f, 0x0 }, /* #16 */
    { 0x157f16, 0x157786, 0xec, 0xb7, 0x35, 0x0 }, /* #17 */
    { 0x0e0c87, 0x0e0c06, 0x8d, 0x18, 0x74, 0x0 }, /* #18 */
    { 0x2a2f16, 0x2a2797, 0x97, 0xed, 0xaa, 0x0 }, /* #19 */
    { 0x1e3682, 0x1e3e93, 0x33, 0x89, 0xaa, 0x0 }, /* #20 */
    { 0x250306, 0x250303, 0x1a, 0x45, 0xd5, 0x0 }, /* #21 */
    { 0x3b3a07, 0x3b3a97, 0x52, 0xb7, 0x9a, 0x0 }, /* #22 */
    { 0x051e92, 0x051687, 0x01, 0xf0, 0x11, 0x0 }, /* #23 */
    { 0x0f5542, 0x0f5586, 0xea, 0xd1, 0x19, 0x0 }, /* #24 */
    { 0x0b0707, 0x0b0797, 0x20, 0xa6, 0x79, 0x0 }, /* #25 */
    { 0x093c17, 0x093406, 0xba, 0x36, 0x83, 0x0 }, /* #26 */
    { 0x1d2c97, 0x1d2496, 0xf3, 0xaa, 0x48, 0x0 }, /* #27 */
    { 0x2e7f03, 0x2e7706, 0xde, 0x5c, 0x81, 0x0 }, /* #28 */
    { 0x115953, 0x115103, 0x25, 0x73, 0xb1, 0x0 }, /* #29 */
    { 0x1853d3, 0x185393, 0xd1, 0xef, 0xe1, 0x0 }, /* #30 */
    { 0x237392, 0x237b02, 0x8c, 0x25, 0x67, 0x0 }, /* #31 */
    { 0x140b43, 0x140b12, 0x80, 0x25, 0x5a, 0x0 }, /* #32 */
    { 0x210a96, 0x210283, 0xba, 0xc4, 0xf6, 0x0 }, /* #33 */
    { 0x246d97, 0x246597, 0xc1, 0xf6, 0xca, 0x0 }, /* #34 */
    { 0x097407, 0x097412, 0xbd, 0x0e, 0xae, 0x0 }, /* #35 */
    { 0x040417, 0x040c97, 0x70, 0xd8, 0x97, 0x0 }, /* #36 */
    { 0x263586, 0x263597, 0xe8, 0xed, 0xfb, 0x0 }, /* #37 */
    { 0x010746, 0x010716, 0xf8, 0x1e, 0xda, 0x0 }, /* #38 */
    { 0x055087, 0x055097, 0x86, 0xb8, 0xcd, 0x0 }, /* #39 */
    { 0x0b23d2, 0x0b2302, 0x3d, 0x37, 0x06, 0x0 }, /* #40 */
    { 0x2076d6, 0x207e87, 0x46, 0x84, 0xc2, 0x0 }, /* #41 */
    { 0x322987, 0x322906, 0xb6, 0x41, 0x74, 0x0 }, /* #42 */
    { 0x0f6456, 0x0f6493, 0xe9, 0xfb, 0xee, 0x0 }, /* #43 */
    { 0x2e3696, 0x2e3686, 0x8a, 0x82, 0x08, 0x0 }, /* #44 */
    { 0x020a12, 0x020a16, 0x9a, 0x2b, 0x6f, 0x0 }, /* #45 */
    { 0x0d7657, 0x0d7686, 0xbd, 0x8b, 0x31, 0x0 }, /* #46 */
    { 0x3c6f03, 0x3c6f02, 0x98, 0x67, 0x30, 0x0 }, /* #47 */
    { 0x2e08d2, 0x2e0082, 0xef, 0x94, 0x5b, 0x0 }, /* #48 */
    { 0x154712, 0x154706, 0x5c, 0x0a, 0x52, 0x0 }, /* #49 */
    { 0x0a5847, 0x0a5006, 0xb7, 0x22, 0x94, 0x0 }, /* #50 */
    { 0x1573d7, 0x157312, 0xda, 0x4a, 0x8f, 0x0 }, /* #51 */
    { 0x180602, 0x180682, 0xd6, 0x94, 0x42, 0x0 }, /* #52 */
    { 0x216487, 0x216493, 0x35, 0xcb, 0x69, 0x0 }, /* #53 */
    { 0x222c52, 0x222416, 0xb6, 0x2d, 0x89, 0x0 }, /* #54 */
    { 0x1a5dc2, 0x1a5582, 0x9f, 0x91, 0x0e, 0x0 }, /* #55 */
    { 0x130006, 0x130013, 0x07, 0x5d, 0xaa, 0x0 }, /* #56 */
    { 0x0a2247, 0x0a2a93, 0x64, 0xb9, 0xaa, 0x0 }, /* #57 */
    { 0x030f52, 0x030786, 0xe7, 0xe4, 0x03, 0x0 }, /* #58 */
    { 0x233c96, 0x233402, 0x6f, 0x38, 0x37, 0x0 }, /* #59 */
    { 0x184552, 0x184d16, 0x85, 0x6a, 0x1b, 0x0 }, /* #60 */
    { 0x0e0396, 0x0e0396, 0xd0, 0xca, 0x06, 0x0 }, /* #61 */
    { 0x013857, 0x013003, 0x44, 0x51, 0xf2, 0x0 }, /* #62 */
    { 0x281e96, 0x281612, 0x4e, 0x2f, 0x1f, 0x0 }, /* #63 */
    { 0x247216, 0x247a16, 0x9c, 0x2d, 0x6f, 0x0 }, /* #64 */
    { 0x1b2697, 0x1b2682, 0x9c, 0x94, 0x07, 0x0 }, /* #65 */
    { 0x0761d7, 0x076183, 0x9f, 0xe5, 0xb9, 0x0 }, /* #66 */
    { 0x0d1446, 0x0d1492, 0xb3, 0x86, 0x2d, 0x0 }, /* #67 */
    { 0x311893, 0x311092, 0xea, 0xdf, 0x0a, 0x0 }, /* #68 */
    { 0x344146, 0x344112, 0x72, 0x43, 0x2f, 0x0 }, /* #69 */
    { 0x355a93, 0x355212, 0x71, 0x2c, 0x44, 0x0 }, /* #70 */
    { 0x0b1cc2, 0x0b1406, 0xb3, 0x03, 0xb0, 0x0 }, /* #71 */
    { 0x2f1b43, 0x2f1312, 0x35, 0x1c, 0x18, 0x0 }, /* #72 */
    { 0x1a1056, 0x1a1093, 0x11, 0xc4, 0x4d, 0x0 }, /* #73 */
    { 0x0f2a13, 0x0f2206, 0x46, 0x41, 0x04, 0x0 }, /* #74 */
    { 0x3740d2, 0x374897, 0x79, 0xeb, 0x8e, 0x0 }, /* #75 */
    { 0x223b07, 0x223306, 0x7e, 0x5c, 0x21, 0x0 }, /* #76 */
    { 0x3d4c53, 0x3d4406, 0xfa, 0x66, 0x93, 0x0 }, /* #77 */
    { 0x1319d6, 0x131197, 0x14, 0xc5, 0x4f, 0x0 }, /* #78 */
    { 0x080992, 0x080912, 0x91, 0x7a, 0x17, 0x0 }, /* #79 */
    { 0x323312, 0x323307, 0x2b, 0x6a, 0xc1, 0x0 }, /* #80 */
    { 0x004507, 0x004506, 0x43, 0x11, 0x31, 0x0 }, /* #81 */
    { 0x182106, 0x182916, 0xda, 0x6c, 0x6e, 0x0 }, /* #82 */
    { 0x195497, 0x195406, 0xf7, 0x21, 0xd5, 0x0 }, /* #83 */
    { 0x370b97, 0x370303, 0x0d, 0x19, 0xf3, 0x0 }, /* #84 */
    { 0x2c3a53, 0x2c3297, 0xd4, 0xe8, 0xeb, 0x0 }, /* #85 */
    { 0x2245d3, 0x224506, 0xce, 0x35, 0x98, 0x0 }, /* #86 */
    { 0x267143, 0x267103, 0x17, 0x43, 0xd3, 0x0 }, /* #87 */
    { 0x135ed3, 0x135616, 0xb0, 0x2b, 0x84, 0x0 }, /* #88 */
    { 0x0b29d7, 0x0b2116, 0xb2, 0x03, 0xae, 0x0 }, /* #89 */
    { 0x091b42, 0x091387, 0x3b, 0xe4, 0x57, 0x0 }, /* #90 */
    { 0x1d7e82, 0x1d7693, 0x91, 0xe9, 0xa8, 0x0 }, /* #91 */
    { 0x012c13, 0x012412, 0x51, 0x16, 0x3a, 0x0 }, /* #92 */
    { 0x166143, 0x166916, 0x84, 0x14, 0x6f, 0x0 }, /* #93 */
    { 0x146b16, 0x146307, 0x1d, 0x3c, 0xe1, 0x0 }, /* #94 */
    { 0x173c93, 0x173c16, 0xb1, 0x65, 0x4b, 0x0 }, /* #95 */
};
uint32_t const g_cTests_sbb_u8 = RT_ELEMENTS(g_aTests_sbb_u8);

BINU8_TEST_T const g_aTests_sbb_u8_locked[] =
{
    { 0x260e13, 0x260697, 0x00, 0xff, 0x00, 0x0 }, /* #0 */
    { 0x0d5c06, 0x0d5446, 0x00, 0x00, 0x00, 0x0 }, /* #1 */
    { 0x1d3252, 0x1d3246, 0x00, 0x00, 0x00, 0x0 }, /* #2 */
    { 0x066797, 0x066797, 0x00, 0xff, 0x00, 0x0 }, /* #3 */
    { 0x2d1e02, 0x2d1646, 0x00, 0x00, 0x00, 0x0 }, /* #4 */
    { 0x155a03, 0x155297, 0x00, 0xff, 0x00, 0x0 }, /* #5 */
    { 0x385d13, 0x385502, 0x0f, 0x0e, 0x00, 0x0 }, /* #6 */
    { 0x074502, 0x074506, 0x0c, 0x0c, 0x00, 0x0 }, /* #7 */
    { 0x2e30c7, 0x2e3086, 0xaa, 0xa9, 0x00, 0x0 }, /* #8 */
    { 0x0b3556, 0x0b3502, 0x0d, 0x0d, 0x00, 0x0 }, /* #9 */
    { 0x312492, 0x312402, 0x62, 0x62, 0x00, 0x0 }, /* #10 */
    { 0x053f02, 0x053702, 0x2c, 0x2c, 0x00, 0x0 }, /* #11 */
    { 0x366983, 0x366112, 0xfc, 0x3d, 0xbe, 0x0 }, /* #12 */
    { 0x3a76c7, 0x3a7612, 0x71, 0x25, 0x4b, 0x0 }, /* #13 */
    { 0x302992, 0x302182, 0xf8, 0xe0, 0x18, 0x0 }, /* #14 */
    { 0x040807, 0x040013, 0x19, 0x7a, 0x9e, 0x0 }, /* #15 */
    { 0x0d28c3, 0x0d2893, 0x2c, 0x9d, 0x8e, 0x0 }, /* #16 */
    { 0x121e93, 0x121e16, 0x82, 0x56, 0x2b, 0x0 }, /* #17 */
    { 0x2c7182, 0x2c7187, 0x0b, 0xb4, 0x57, 0x0 }, /* #18 */
    { 0x3e5f96, 0x3e5712, 0x70, 0x57, 0x19, 0x0 }, /* #19 */
    { 0x385f42, 0x385793, 0xa2, 0xd3, 0xcf, 0x0 }, /* #20 */
    { 0x123d56, 0x123597, 0x43, 0xc5, 0x7e, 0x0 }, /* #21 */
    { 0x2d4783, 0x2d4706, 0x7f, 0x1b, 0x63, 0x0 }, /* #22 */
    { 0x0422c2, 0x042292, 0xe4, 0xba, 0x2a, 0x0 }, /* #23 */
    { 0x1f4b07, 0x1f4393, 0x34, 0xea, 0x49, 0x0 }, /* #24 */
    { 0x2a67c7, 0x2a6797, 0xc3, 0xff, 0xc3, 0x0 }, /* #25 */
    { 0x274c93, 0x274416, 0x20, 0x0c, 0x13, 0x0 }, /* #26 */
    { 0x2e3756, 0x2e3f87, 0x65, 0x81, 0xe4, 0x0 }, /* #27 */
    { 0x3e3ad3, 0x3e3206, 0x35, 0x12, 0x22, 0x0 }, /* #28 */
    { 0x167546, 0x167516, 0x73, 0x5c, 0x17, 0x0 }, /* #29 */
    { 0x0228c2, 0x022816, 0x93, 0x74, 0x1f, 0x0 }, /* #30 */
    { 0x044e03, 0x044e83, 0x67, 0xa2, 0xc4, 0x0 }, /* #31 */
    { 0x1d59c2, 0x1d5983, 0x5a, 0x80, 0xda, 0x0 }, /* #32 */
    { 0x233957, 0x233197, 0xde, 0xff, 0xde, 0x0 }, /* #33 */
    { 0x2f3dd6, 0x2f3503, 0x0c, 0x52, 0xba, 0x0 }, /* #34 */
    { 0x0e42d3, 0x0e4a83, 0x1a, 0x89, 0x90, 0x0 }, /* #35 */
    { 0x3f4117, 0x3f4106, 0xdc, 0x11, 0xca, 0x0 }, /* #36 */
    { 0x1d6d96, 0x1d6d97, 0x25, 0x99, 0x8c, 0x0 }, /* #37 */
    { 0x371e47, 0x371e93, 0x22, 0x86, 0x9b, 0x0 }, /* #38 */
    { 0x201853, 0x201883, 0x33, 0xa2, 0x90, 0x0 }, /* #39 */
    { 0x1d48c7, 0x1d4012, 0x30, 0x1c, 0x13, 0x0 }, /* #40 */
    { 0x337cd3, 0x337402, 0x57, 0x52, 0x04, 0x0 }, /* #41 */
    { 0x222097, 0x222086, 0xdc, 0xb8, 0x23, 0x0 }, /* #42 */
    { 0x037983, 0x037916, 0xbb, 0x4b, 0x6f, 0x0 }, /* #43 */
    { 0x304a16, 0x304283, 0x8c, 0xd5, 0xb7, 0x0 }, /* #44 */
    { 0x097553, 0x097d06, 0xce, 0x69, 0x64, 0x0 }, /* #45 */
    { 0x311883, 0x311812, 0xc9, 0x5b, 0x6d, 0x0 }, /* #46 */
    { 0x036e02, 0x036612, 0x3a, 0x2c, 0x0e, 0x0 }, /* #47 */
    { 0x2c1193, 0x2c1106, 0x4d, 0x22, 0x2a, 0x0 }, /* #48 */
    { 0x351c47, 0x351413, 0x31, 0x46, 0xea, 0x0 }, /* #49 */
    { 0x0a02d2, 0x0a0a83, 0x4b, 0x8a, 0xc1, 0x0 }, /* #50 */
    { 0x1e1713, 0x1e1793, 0x81, 0xf2, 0x8e, 0x0 }, /* #51 */
    { 0x250f86, 0x250703, 0x09, 0x61, 0xa8, 0x0 }, /* #52 */
    { 0x2706c6, 0x270687, 0x49, 0xe4, 0x65, 0x0 }, /* #53 */
    { 0x3517c2, 0x351782, 0xf8, 0xd6, 0x22, 0x0 }, /* #54 */
    { 0x3c2787, 0x3c2796, 0xf2, 0xd8, 0x19, 0x0 }, /* #55 */
    { 0x1f1f83, 0x1f1717, 0x15, 0x65, 0xaf, 0x0 }, /* #56 */
    { 0x175f57, 0x175793, 0x8a, 0xef, 0x9a, 0x0 }, /* #57 */
    { 0x321b93, 0x321b93, 0x24, 0x89, 0x9a, 0x0 }, /* #58 */
    { 0x042117, 0x042916, 0x89, 0x7d, 0x0b, 0x0 }, /* #59 */
    { 0x100a86, 0x100a02, 0xbe, 0x40, 0x7e, 0x0 }, /* #60 */
    { 0x203ec6, 0x203616, 0x30, 0x11, 0x1f, 0x0 }, /* #61 */
    { 0x333bc3, 0x333b87, 0x75, 0xd4, 0xa0, 0x0 }, /* #62 */
    { 0x2c0d56, 0x2c0597, 0x30, 0xcc, 0x64, 0x0 }, /* #63 */
    { 0x2524c2, 0x252402, 0x4d, 0x0d, 0x40, 0x0 }, /* #64 */
    { 0x356b92, 0x356313, 0x27, 0x58, 0xcf, 0x0 }, /* #65 */
    { 0x3318c2, 0x331017, 0x27, 0x69, 0xbe, 0x0 }, /* #66 */
    { 0x3c0f92, 0x3c0793, 0x0e, 0x8f, 0x7f, 0x0 }, /* #67 */
    { 0x2d6506, 0x2d6d87, 0x7d, 0xfc, 0x81, 0x0 }, /* #68 */
    { 0x1a1042, 0x1a1086, 0xec, 0xac, 0x40, 0x0 }, /* #69 */
    { 0x132206, 0x132217, 0x56, 0x6c, 0xea, 0x0 }, /* #70 */
    { 0x241997, 0x241987, 0x66, 0x90, 0xd5, 0x0 }, /* #71 */
    { 0x1f1e13, 0x1f1616, 0x68, 0x18, 0x4f, 0x0 }, /* #72 */
    { 0x353f93, 0x353783, 0xaf, 0xb6, 0xf8, 0x0 }, /* #73 */
    { 0x173342, 0x173306, 0xbd, 0x09, 0xb4, 0x0 }, /* #74 */
    { 0x0e6756, 0x0e6786, 0xed, 0xd8, 0x15, 0x0 }, /* #75 */
    { 0x082007, 0x082093, 0x93, 0xa4, 0xee, 0x0 }, /* #76 */
    { 0x3043c3, 0x304387, 0x41, 0xf0, 0x50, 0x0 }, /* #77 */
    { 0x073543, 0x073502, 0xdf, 0x0b, 0xd3, 0x0 }, /* #78 */
    { 0x3142c3, 0x314a16, 0x82, 0x3f, 0x42, 0x0 }, /* #79 */
    { 0x2e0bd7, 0x2e0b93, 0x72, 0xda, 0x97, 0x0 }, /* #80 */
    { 0x115253, 0x115296, 0x95, 0x87, 0x0d, 0x0 }, /* #81 */
    { 0x0615d3, 0x061583, 0xad, 0xdc, 0xd0, 0x0 }, /* #82 */
    { 0x280607, 0x280607, 0x4f, 0x65, 0xe9, 0x0 }, /* #83 */
    { 0x261f53, 0x261702, 0x7d, 0x37, 0x45, 0x0 }, /* #84 */
    { 0x3b4b07, 0x3b4396, 0xc5, 0x87, 0x3d, 0x0 }, /* #85 */
    { 0x026a46, 0x026217, 0x1c, 0x2d, 0xef, 0x0 }, /* #86 */
    { 0x0e3dc6, 0x0e3583, 0x13, 0xe3, 0x30, 0x0 }, /* #87 */
    { 0x1d64c2, 0x1d6403, 0x1d, 0x5b, 0xc2, 0x0 }, /* #88 */
    { 0x361713, 0x361f16, 0x85, 0x36, 0x4e, 0x0 }, /* #89 */
    { 0x3f3cc7, 0x3f3493, 0x56, 0xec, 0x69, 0x0 }, /* #90 */
    { 0x224bd2, 0x224312, 0x55, 0x2c, 0x29, 0x0 }, /* #91 */
    { 0x2b2b83, 0x2b2306, 0xeb, 0x60, 0x8a, 0x0 }, /* #92 */
    { 0x3a7212, 0x3a7207, 0x4e, 0x72, 0xdc, 0x0 }, /* #93 */
    { 0x3b3117, 0x3b3197, 0xea, 0xfc, 0xed, 0x0 }, /* #94 */
    { 0x0b4792, 0x0b4797, 0x02, 0xaa, 0x58, 0x0 }, /* #95 */
};
uint32_t const g_cTests_sbb_u8_locked = RT_ELEMENTS(g_aTests_sbb_u8_locked);

BINU8_TEST_T const g_aTests_or_u8[] =
{
    { 0x341056, 0x341046, 0x00, 0x00, 0x00, 0x0 }, /* #0 */
    { 0x1c2617, 0x1c2646, 0x00, 0x00, 0x00, 0x0 }, /* #1 */
    { 0x107e83, 0x107646, 0x00, 0x00, 0x00, 0x0 }, /* #2 */
    { 0x2a7e83, 0x2a7646, 0x00, 0x00, 0x00, 0x0 }, /* #3 */
    { 0x0e1483, 0x0e1446, 0x00, 0x00, 0x00, 0x0 }, /* #4 */
    { 0x002787, 0x002746, 0x00, 0x00, 0x00, 0x0 }, /* #5 */
    { 0x1052c2, 0x105202, 0x46, 0x46, 0x00, 0x0 }, /* #6 */
    { 0x194697, 0x194682, 0xc8, 0xc8, 0x00, 0x0 }, /* #7 */
    { 0x306997, 0x306106, 0x4d, 0x4d, 0x00, 0x0 }, /* #8 */
    { 0x267517, 0x267586, 0x82, 0x82, 0x00, 0x0 }, /* #9 */
    { 0x180f02, 0x180706, 0x2d, 0x2d, 0x00, 0x0 }, /* #10 */
    { 0x1d3c57, 0x1d3402, 0x43, 0x43, 0x00, 0x0 }, /* #11 */
    { 0x1e1552, 0x1e1582, 0x75, 0xfd, 0x9d, 0x0 }, /* #12 */
    { 0x121d13, 0x121582, 0xb8, 0xfd, 0x75, 0x0 }, /* #13 */
    { 0x013f17, 0x013782, 0xc7, 0xdf, 0x19, 0x0 }, /* #14 */
    { 0x0d20d6, 0x0d2082, 0x9c, 0x9d, 0x11, 0x0 }, /* #15 */
    { 0x2e6746, 0x2e6782, 0x08, 0xec, 0xec, 0x0 }, /* #16 */
    { 0x1e3652, 0x1e3682, 0xfd, 0xfd, 0x89, 0x0 }, /* #17 */
    { 0x0277c7, 0x027782, 0x44, 0xdc, 0x9c, 0x0 }, /* #18 */
    { 0x2a7693, 0x2a7682, 0x8a, 0xcb, 0x43, 0x0 }, /* #19 */
    { 0x040c83, 0x040482, 0xcd, 0xcd, 0x45, 0x0 }, /* #20 */
    { 0x1e5246, 0x1e5282, 0x6a, 0xfe, 0xd4, 0x0 }, /* #21 */
    { 0x0f6b96, 0x0f6306, 0x7b, 0x7b, 0x53, 0x0 }, /* #22 */
    { 0x201ac3, 0x201202, 0x5d, 0x5d, 0x01, 0x0 }, /* #23 */
    { 0x3e1b02, 0x3e1382, 0x73, 0xf7, 0xd6, 0x0 }, /* #24 */
    { 0x072f57, 0x072702, 0x2a, 0x2f, 0x25, 0x0 }, /* #25 */
    { 0x032f47, 0x032786, 0x95, 0xff, 0x7b, 0x0 }, /* #26 */
    { 0x0d47d7, 0x0d4782, 0xb7, 0xf7, 0xe7, 0x0 }, /* #27 */
    { 0x0b22d7, 0x0b2286, 0x88, 0x9f, 0x17, 0x0 }, /* #28 */
    { 0x293513, 0x293506, 0x58, 0x7e, 0x2e, 0x0 }, /* #29 */
    { 0x1e6b52, 0x1e6386, 0x9a, 0xde, 0x54, 0x0 }, /* #30 */
    { 0x2c0493, 0x2c0486, 0xb0, 0xb7, 0x97, 0x0 }, /* #31 */
    { 0x2f3fc2, 0x2f3786, 0x92, 0xde, 0xcc, 0x0 }, /* #32 */
    { 0x246d93, 0x246582, 0xaf, 0xbf, 0x34, 0x0 }, /* #33 */
    { 0x354557, 0x354586, 0x47, 0xff, 0xfb, 0x0 }, /* #34 */
    { 0x077a93, 0x077286, 0x48, 0xdb, 0x93, 0x0 }, /* #35 */
    { 0x137383, 0x137306, 0x39, 0x3f, 0x07, 0x0 }, /* #36 */
    { 0x3c4e43, 0x3c4686, 0x61, 0xf3, 0x92, 0x0 }, /* #37 */
    { 0x0453d7, 0x045306, 0x64, 0x6c, 0x0c, 0x0 }, /* #38 */
    { 0x085a92, 0x085206, 0x24, 0x35, 0x31, 0x0 }, /* #39 */
    { 0x3f1ac2, 0x3f1202, 0x49, 0x4f, 0x46, 0x0 }, /* #40 */
    { 0x277712, 0x277782, 0xea, 0xef, 0x6f, 0x0 }, /* #41 */
    { 0x0a1843, 0x0a1002, 0x40, 0x76, 0x76, 0x0 }, /* #42 */
    { 0x084856, 0x084086, 0xca, 0xde, 0x54, 0x0 }, /* #43 */
    { 0x1c0f52, 0x1c0782, 0xd0, 0xf4, 0xb4, 0x0 }, /* #44 */
    { 0x2405c6, 0x240586, 0xe2, 0xe2, 0xe2, 0x0 }, /* #45 */
    { 0x1400c7, 0x140002, 0x6a, 0x6b, 0x6b, 0x0 }, /* #46 */
    { 0x3a26d6, 0x3a2686, 0xd8, 0xfc, 0xfc, 0x0 }, /* #47 */
    { 0x311f97, 0x311782, 0xb3, 0xbf, 0x2d, 0x0 }, /* #48 */
    { 0x387b06, 0x387386, 0x47, 0xe7, 0xa5, 0x0 }, /* #49 */
    { 0x0c71c6, 0x0c7186, 0xa0, 0xe1, 0xc1, 0x0 }, /* #50 */
    { 0x227f47, 0x227786, 0x84, 0xd4, 0xd0, 0x0 }, /* #51 */
    { 0x394d42, 0x394586, 0x59, 0xdd, 0x85, 0x0 }, /* #52 */
    { 0x3c6bd7, 0x3c6382, 0x8a, 0xea, 0x68, 0x0 }, /* #53 */
    { 0x156d47, 0x156582, 0xf4, 0xf4, 0x94, 0x0 }, /* #54 */
    { 0x262712, 0x262782, 0x9b, 0x9b, 0x19, 0x0 }, /* #55 */
    { 0x3c7dc2, 0x3c7506, 0x13, 0x53, 0x40, 0x0 }, /* #56 */
    { 0x3c5017, 0x3c5086, 0x28, 0xff, 0xd7, 0x0 }, /* #57 */
    { 0x050096, 0x050086, 0x25, 0xed, 0xe8, 0x0 }, /* #58 */
    { 0x110047, 0x110086, 0x41, 0xe7, 0xe6, 0x0 }, /* #59 */
    { 0x001506, 0x001582, 0xc5, 0xc7, 0x46, 0x0 }, /* #60 */
    { 0x3b65d3, 0x3b6502, 0x37, 0x7f, 0x6a, 0x0 }, /* #61 */
    { 0x2c7d53, 0x2c7586, 0x5e, 0xde, 0xd2, 0x0 }, /* #62 */
    { 0x202246, 0x202286, 0xe7, 0xff, 0x39, 0x0 }, /* #63 */
    { 0x2102c3, 0x210282, 0x22, 0xfe, 0xde, 0x0 }, /* #64 */
    { 0x1854c2, 0x185406, 0x3f, 0x3f, 0x0a, 0x0 }, /* #65 */
    { 0x262cc3, 0x262406, 0x62, 0x72, 0x10, 0x0 }, /* #66 */
    { 0x042096, 0x042086, 0x60, 0xf9, 0xd9, 0x0 }, /* #67 */
    { 0x144553, 0x144582, 0x84, 0xdc, 0x5c, 0x0 }, /* #68 */
    { 0x104887, 0x104082, 0xaa, 0xab, 0x83, 0x0 }, /* #69 */
    { 0x0c6447, 0x0c6482, 0x82, 0x83, 0x01, 0x0 }, /* #70 */
    { 0x1c3842, 0x1c3082, 0xd4, 0xfd, 0x29, 0x0 }, /* #71 */
    { 0x2758c3, 0x275006, 0x3b, 0x3f, 0x1c, 0x0 }, /* #72 */
    { 0x3a7cd7, 0x3a7486, 0xa3, 0xe7, 0x44, 0x0 }, /* #73 */
    { 0x2d34d3, 0x2d3482, 0xc7, 0xf7, 0x34, 0x0 }, /* #74 */
    { 0x1737d6, 0x173786, 0x4f, 0xff, 0xf1, 0x0 }, /* #75 */
    { 0x381706, 0x381786, 0xc6, 0xc6, 0x00, 0x0 }, /* #76 */
    { 0x2539d6, 0x253186, 0x1c, 0xbd, 0xb1, 0x0 }, /* #77 */
    { 0x110447, 0x110406, 0x59, 0x7d, 0x34, 0x0 }, /* #78 */
    { 0x266dc7, 0x266582, 0xd4, 0xd6, 0x02, 0x0 }, /* #79 */
    { 0x3b7847, 0x3b7086, 0xfa, 0xff, 0xb7, 0x0 }, /* #80 */
    { 0x0b4417, 0x0b4406, 0x60, 0x6a, 0x6a, 0x0 }, /* #81 */
    { 0x0d5087, 0x0d5086, 0xc2, 0xff, 0x3f, 0x0 }, /* #82 */
    { 0x115cd7, 0x115482, 0x32, 0xf7, 0xd7, 0x0 }, /* #83 */
    { 0x3a7c42, 0x3a7482, 0xf0, 0xf7, 0x57, 0x0 }, /* #84 */
    { 0x0165c7, 0x016582, 0x23, 0xa7, 0xa5, 0x0 }, /* #85 */
    { 0x130f03, 0x130786, 0xfb, 0xff, 0x45, 0x0 }, /* #86 */
    { 0x3e3c83, 0x3e3482, 0x67, 0xef, 0xcc, 0x0 }, /* #87 */
    { 0x236b92, 0x236382, 0x35, 0xf7, 0xe6, 0x0 }, /* #88 */
    { 0x3d50c6, 0x3d5006, 0x42, 0x42, 0x02, 0x0 }, /* #89 */
    { 0x3d7843, 0x3d7086, 0x99, 0xdd, 0xd5, 0x0 }, /* #90 */
    { 0x043b52, 0x043382, 0xa3, 0xef, 0xef, 0x0 }, /* #91 */
    { 0x2243c6, 0x224386, 0xb5, 0xbd, 0x09, 0x0 }, /* #92 */
    { 0x0a3f47, 0x0a3786, 0x30, 0xb4, 0xa4, 0x0 }, /* #93 */
    { 0x276d03, 0x276582, 0x91, 0xf1, 0x61, 0x0 }, /* #94 */
    { 0x201606, 0x201686, 0x3f, 0xff, 0xdd, 0x0 }, /* #95 */
};
uint32_t const g_cTests_or_u8 = RT_ELEMENTS(g_aTests_or_u8);

BINU8_TEST_T const g_aTests_or_u8_locked[] =
{
    { 0x0f3a16, 0x0f3246, 0x00, 0x00, 0x00, 0x0 }, /* #0 */
    { 0x252e07, 0x252646, 0x00, 0x00, 0x00, 0x0 }, /* #1 */
    { 0x361d17, 0x361546, 0x00, 0x00, 0x00, 0x0 }, /* #2 */
    { 0x071546, 0x071546, 0x00, 0x00, 0x00, 0x0 }, /* #3 */
    { 0x2a13d7, 0x2a1346, 0x00, 0x00, 0x00, 0x0 }, /* #4 */
    { 0x1a4717, 0x1a4746, 0x00, 0x00, 0x00, 0x0 }, /* #5 */
    { 0x0569d6, 0x056186, 0xa5, 0xa5, 0x00, 0x0 }, /* #6 */
    { 0x153606, 0x153602, 0x07, 0x07, 0x00, 0x0 }, /* #7 */
    { 0x1732c6, 0x173202, 0x5b, 0x5b, 0x00, 0x0 }, /* #8 */
    { 0x197fc3, 0x197782, 0xf2, 0xf2, 0x00, 0x0 }, /* #9 */
    { 0x1a1106, 0x1a1106, 0x33, 0x33, 0x00, 0x0 }, /* #10 */
    { 0x042946, 0x042102, 0x16, 0x16, 0x00, 0x0 }, /* #11 */
    { 0x386e92, 0x386682, 0xf3, 0xf7, 0x05, 0x0 }, /* #12 */
    { 0x2a7a07, 0x2a7282, 0xa8, 0xfb, 0xd3, 0x0 }, /* #13 */
    { 0x124f17, 0x124782, 0x34, 0xbc, 0x8c, 0x0 }, /* #14 */
    { 0x232007, 0x232082, 0xcb, 0xcb, 0xc0, 0x0 }, /* #15 */
    { 0x040c93, 0x040482, 0xaf, 0xbf, 0xbc, 0x0 }, /* #16 */
    { 0x382217, 0x382286, 0xda, 0xdb, 0x99, 0x0 }, /* #17 */
    { 0x1b6856, 0x1b6082, 0xd1, 0xd5, 0x94, 0x0 }, /* #18 */
    { 0x2f4752, 0x2f4702, 0x69, 0x6d, 0x6d, 0x0 }, /* #19 */
    { 0x257897, 0x257002, 0x67, 0x67, 0x02, 0x0 }, /* #20 */
    { 0x177497, 0x177402, 0x2b, 0x3b, 0x30, 0x0 }, /* #21 */
    { 0x2a6353, 0x2a6386, 0x0d, 0xcf, 0xc7, 0x0 }, /* #22 */
    { 0x1262c3, 0x126282, 0x3d, 0xfd, 0xe8, 0x0 }, /* #23 */
    { 0x1b3f42, 0x1b3782, 0xd8, 0xdc, 0x84, 0x0 }, /* #24 */
    { 0x252f47, 0x252706, 0x05, 0x17, 0x17, 0x0 }, /* #25 */
    { 0x181ac3, 0x181282, 0x9d, 0xbf, 0x2a, 0x0 }, /* #26 */
    { 0x223682, 0x223682, 0xdf, 0xdf, 0x19, 0x0 }, /* #27 */
    { 0x240702, 0x240786, 0xeb, 0xeb, 0x09, 0x0 }, /* #28 */
    { 0x011ac7, 0x011282, 0x82, 0xf2, 0x70, 0x0 }, /* #29 */
    { 0x082d56, 0x082586, 0x54, 0xf6, 0xb6, 0x0 }, /* #30 */
    { 0x023b92, 0x023302, 0x74, 0x7c, 0x3c, 0x0 }, /* #31 */
    { 0x397203, 0x397286, 0x1d, 0xbd, 0xb0, 0x0 }, /* #32 */
    { 0x185612, 0x185686, 0x18, 0xf9, 0xe9, 0x0 }, /* #33 */
    { 0x2937d7, 0x293786, 0xff, 0xff, 0x51, 0x0 }, /* #34 */
    { 0x1648d2, 0x164002, 0x64, 0x7c, 0x58, 0x0 }, /* #35 */
    { 0x1d6452, 0x1d6486, 0xff, 0xff, 0x51, 0x0 }, /* #36 */
    { 0x3663c6, 0x366306, 0x10, 0x33, 0x23, 0x0 }, /* #37 */
    { 0x013e12, 0x013682, 0x6d, 0xef, 0x8f, 0x0 }, /* #38 */
    { 0x363953, 0x363102, 0x22, 0x73, 0x53, 0x0 }, /* #39 */
    { 0x210c93, 0x210486, 0xa1, 0xb1, 0xb0, 0x0 }, /* #40 */
    { 0x061246, 0x061202, 0x02, 0x46, 0x46, 0x0 }, /* #41 */
    { 0x3a6b17, 0x3a6386, 0x96, 0x96, 0x96, 0x0 }, /* #42 */
    { 0x1909d3, 0x190182, 0xd5, 0xdf, 0x1e, 0x0 }, /* #43 */
    { 0x3c1886, 0x3c1082, 0x96, 0xbf, 0x3b, 0x0 }, /* #44 */
    { 0x133d87, 0x133582, 0x84, 0x86, 0x86, 0x0 }, /* #45 */
    { 0x1647c6, 0x164786, 0xff, 0xff, 0xca, 0x0 }, /* #46 */
    { 0x1c3c86, 0x1c3486, 0x2b, 0xeb, 0xe2, 0x0 }, /* #47 */
    { 0x324bd6, 0x324386, 0x7a, 0xff, 0xff, 0x0 }, /* #48 */
    { 0x263993, 0x263186, 0xb8, 0xff, 0xff, 0x0 }, /* #49 */
    { 0x0a5c07, 0x0a5486, 0x61, 0xe1, 0xa0, 0x0 }, /* #50 */
    { 0x2a5e53, 0x2a5682, 0xd4, 0xdc, 0x8c, 0x0 }, /* #51 */
    { 0x2e3412, 0x2e3486, 0xbe, 0xff, 0xcb, 0x0 }, /* #52 */
    { 0x147297, 0x147206, 0x33, 0x7b, 0x5b, 0x0 }, /* #53 */
    { 0x381a02, 0x381286, 0x99, 0xdd, 0x4c, 0x0 }, /* #54 */
    { 0x2e2b06, 0x2e2306, 0x58, 0x7e, 0x3e, 0x0 }, /* #55 */
    { 0x293ec7, 0x293682, 0x59, 0xfb, 0xba, 0x0 }, /* #56 */
    { 0x0d4296, 0x0d4206, 0x46, 0x5f, 0x19, 0x0 }, /* #57 */
    { 0x1947c7, 0x194782, 0xa5, 0xf7, 0xf6, 0x0 }, /* #58 */
    { 0x044882, 0x044006, 0x24, 0x6f, 0x6b, 0x0 }, /* #59 */
    { 0x392ad3, 0x392286, 0x99, 0xf9, 0xe8, 0x0 }, /* #60 */
    { 0x336f87, 0x336786, 0x6f, 0xff, 0xf8, 0x0 }, /* #61 */
    { 0x2f0b96, 0x2f0386, 0xe0, 0xfa, 0x1a, 0x0 }, /* #62 */
    { 0x262816, 0x262086, 0x85, 0xaf, 0xaf, 0x0 }, /* #63 */
    { 0x2d1f93, 0x2d1782, 0x9e, 0x9e, 0x92, 0x0 }, /* #64 */
    { 0x0d00c6, 0x0d0082, 0x98, 0x9d, 0x85, 0x0 }, /* #65 */
    { 0x357103, 0x357106, 0x00, 0x35, 0x35, 0x0 }, /* #66 */
    { 0x3e07c3, 0x3e0706, 0x6c, 0x7e, 0x76, 0x0 }, /* #67 */
    { 0x391b57, 0x391306, 0x79, 0x7d, 0x3d, 0x0 }, /* #68 */
    { 0x334656, 0x334686, 0x5a, 0xff, 0xaf, 0x0 }, /* #69 */
    { 0x154bd2, 0x154386, 0xac, 0xaf, 0x07, 0x0 }, /* #70 */
    { 0x136286, 0x136282, 0x26, 0xf7, 0xf7, 0x0 }, /* #71 */
    { 0x220f03, 0x220706, 0x2b, 0x6f, 0x47, 0x0 }, /* #72 */
    { 0x263293, 0x263286, 0xe9, 0xf9, 0xf0, 0x0 }, /* #73 */
    { 0x037096, 0x037006, 0x40, 0x53, 0x13, 0x0 }, /* #74 */
    { 0x006146, 0x006106, 0x0e, 0x3f, 0x3b, 0x0 }, /* #75 */
    { 0x365482, 0x365482, 0xea, 0xfb, 0xf1, 0x0 }, /* #76 */
    { 0x191082, 0x191086, 0x25, 0xb7, 0x92, 0x0 }, /* #77 */
    { 0x3d6cd3, 0x3d6406, 0x61, 0x77, 0x16, 0x0 }, /* #78 */
    { 0x3a65d7, 0x3a6586, 0xd8, 0xdd, 0x85, 0x0 }, /* #79 */
    { 0x2f3086, 0x2f3086, 0xe7, 0xe7, 0x04, 0x0 }, /* #80 */
    { 0x343082, 0x343086, 0x06, 0x8e, 0x88, 0x0 }, /* #81 */
    { 0x217942, 0x217182, 0xba, 0xba, 0x98, 0x0 }, /* #82 */
    { 0x297b06, 0x297302, 0x25, 0x6d, 0x49, 0x0 }, /* #83 */
    { 0x2e29c2, 0x2e2102, 0x62, 0x7f, 0x5f, 0x0 }, /* #84 */
    { 0x214f16, 0x214786, 0xdb, 0xdb, 0x0b, 0x0 }, /* #85 */
    { 0x1b6c07, 0x1b6486, 0x89, 0xdb, 0x52, 0x0 }, /* #86 */
    { 0x0e3b07, 0x0e3382, 0x30, 0xb9, 0xa9, 0x0 }, /* #87 */
    { 0x1b4797, 0x1b4786, 0xc9, 0xed, 0x2d, 0x0 }, /* #88 */
    { 0x281902, 0x281186, 0x6c, 0xfc, 0xbc, 0x0 }, /* #89 */
    { 0x033097, 0x033082, 0x5f, 0xdf, 0x9b, 0x0 }, /* #90 */
    { 0x214e93, 0x214686, 0xef, 0xff, 0x1d, 0x0 }, /* #91 */
    { 0x390747, 0x390786, 0xaf, 0xff, 0xdb, 0x0 }, /* #92 */
    { 0x182706, 0x182782, 0x8e, 0xdf, 0x5b, 0x0 }, /* #93 */
    { 0x285457, 0x285482, 0xdd, 0xdf, 0x43, 0x0 }, /* #94 */
    { 0x1b1453, 0x1b1482, 0x1c, 0xbf, 0xb3, 0x0 }, /* #95 */
};
uint32_t const g_cTests_or_u8_locked = RT_ELEMENTS(g_aTests_or_u8_locked);

BINU8_TEST_T const g_aTests_xor_u8[] =
{
    { 0x120916, 0x120146, 0x00, 0x00, 0x00, 0x0 }, /* #0 */
    { 0x006983, 0x006146, 0x00, 0x00, 0x00, 0x0 }, /* #1 */
    { 0x3d3cd3, 0x3d3446, 0x00, 0x00, 0x00, 0x0 }, /* #2 */
    { 0x020582, 0x020546, 0x00, 0x00, 0x00, 0x0 }, /* #3 */
    { 0x0c3dc3, 0x0c3546, 0x00, 0x00, 0x00, 0x0 }, /* #4 */
    { 0x1f7147, 0x1f7146, 0x00, 0x00, 0x00, 0x0 }, /* #5 */
    { 0x1e5bc7, 0x1e5306, 0x44, 0x44, 0x00, 0x0 }, /* #6 */
    { 0x102fc3, 0x102702, 0x6e, 0x6e, 0x00, 0x0 }, /* #7 */
    { 0x195147, 0x195186, 0xd1, 0xd1, 0x00, 0x0 }, /* #8 */
    { 0x2207c2, 0x220782, 0xfd, 0xfd, 0x00, 0x0 }, /* #9 */
    { 0x235c06, 0x235402, 0x6e, 0x6e, 0x00, 0x0 }, /* #10 */
    { 0x0a3347, 0x0a3386, 0xe8, 0xe8, 0x00, 0x0 }, /* #11 */
    { 0x021dc2, 0x021586, 0x35, 0xeb, 0xde, 0x0 }, /* #12 */
    { 0x3b47c6, 0x3b4786, 0xcd, 0xd4, 0x19, 0x0 }, /* #13 */
    { 0x273282, 0x273202, 0xa9, 0x45, 0xec, 0x0 }, /* #14 */
    { 0x045587, 0x045506, 0x0f, 0x65, 0x6a, 0x0 }, /* #15 */
    { 0x3a7c83, 0x3a7406, 0x97, 0x2e, 0xb9, 0x0 }, /* #16 */
    { 0x0a4817, 0x0a4006, 0x02, 0x71, 0x73, 0x0 }, /* #17 */
    { 0x1f12c6, 0x1f1202, 0x29, 0x2f, 0x06, 0x0 }, /* #18 */
    { 0x242252, 0x242206, 0xc7, 0x2b, 0xec, 0x0 }, /* #19 */
    { 0x3f5c06, 0x3f5482, 0x81, 0xa4, 0x25, 0x0 }, /* #20 */
    { 0x291913, 0x291106, 0x7a, 0x50, 0x2a, 0x0 }, /* #21 */
    { 0x235447, 0x235406, 0xd2, 0x42, 0x90, 0x0 }, /* #22 */
    { 0x181e93, 0x181682, 0x6d, 0xcd, 0xa0, 0x0 }, /* #23 */
    { 0x064147, 0x064186, 0xb4, 0xbd, 0x09, 0x0 }, /* #24 */
    { 0x2c0406, 0x2c0402, 0x92, 0x0e, 0x9c, 0x0 }, /* #25 */
    { 0x0e6156, 0x0e6182, 0x65, 0xab, 0xce, 0x0 }, /* #26 */
    { 0x0a4617, 0x0a4602, 0x44, 0x6b, 0x2f, 0x0 }, /* #27 */
    { 0x3b0693, 0x3b0602, 0x04, 0x46, 0x42, 0x0 }, /* #28 */
    { 0x0f55d7, 0x0f5506, 0xa1, 0x7e, 0xdf, 0x0 }, /* #29 */
    { 0x0f7046, 0x0f7006, 0xfa, 0x77, 0x8d, 0x0 }, /* #30 */
    { 0x163746, 0x163702, 0x8a, 0x1a, 0x90, 0x0 }, /* #31 */
    { 0x097a13, 0x097282, 0x0a, 0xbf, 0xb5, 0x0 }, /* #32 */
    { 0x150f43, 0x150702, 0xf6, 0x34, 0xc2, 0x0 }, /* #33 */
    { 0x2d62c2, 0x2d6282, 0xb4, 0xfd, 0x49, 0x0 }, /* #34 */
    { 0x190096, 0x190002, 0x66, 0x5e, 0x38, 0x0 }, /* #35 */
    { 0x374013, 0x374006, 0x30, 0x50, 0x60, 0x0 }, /* #36 */
    { 0x334dc6, 0x334582, 0x8b, 0x98, 0x13, 0x0 }, /* #37 */
    { 0x2f57d2, 0x2f5786, 0xac, 0xdd, 0x71, 0x0 }, /* #38 */
    { 0x2f1a92, 0x2f1282, 0xb1, 0xe9, 0x58, 0x0 }, /* #39 */
    { 0x122113, 0x122186, 0x5a, 0xd8, 0x82, 0x0 }, /* #40 */
    { 0x097a56, 0x097206, 0x7f, 0x0c, 0x73, 0x0 }, /* #41 */
    { 0x3c5586, 0x3c5502, 0x86, 0x29, 0xaf, 0x0 }, /* #42 */
    { 0x207a13, 0x207286, 0x97, 0xc9, 0x5e, 0x0 }, /* #43 */
    { 0x3a3803, 0x3a3086, 0xca, 0xbb, 0x71, 0x0 }, /* #44 */
    { 0x367cd2, 0x367482, 0x91, 0x92, 0x03, 0x0 }, /* #45 */
    { 0x144cd6, 0x144482, 0xed, 0xa7, 0x4a, 0x0 }, /* #46 */
    { 0x317582, 0x317582, 0x0c, 0x83, 0x8f, 0x0 }, /* #47 */
    { 0x0d2892, 0x0d2002, 0xa1, 0x4a, 0xeb, 0x0 }, /* #48 */
    { 0x1c5697, 0x1c5682, 0x5b, 0xb0, 0xeb, 0x0 }, /* #49 */
    { 0x1e1056, 0x1e1006, 0x1f, 0x66, 0x79, 0x0 }, /* #50 */
    { 0x242192, 0x242182, 0x85, 0xab, 0x2e, 0x0 }, /* #51 */
    { 0x211893, 0x211082, 0x03, 0xe9, 0xea, 0x0 }, /* #52 */
    { 0x3a3b47, 0x3a3382, 0x58, 0x9b, 0xc3, 0x0 }, /* #53 */
    { 0x2a22d2, 0x2a2282, 0xf7, 0xf8, 0x0f, 0x0 }, /* #54 */
    { 0x194157, 0x194182, 0x5b, 0xae, 0xf5, 0x0 }, /* #55 */
    { 0x3d1393, 0x3d1386, 0xd1, 0xc3, 0x12, 0x0 }, /* #56 */
    { 0x242a92, 0x242206, 0xe7, 0x7e, 0x99, 0x0 }, /* #57 */
    { 0x2d1c97, 0x2d1482, 0x85, 0xce, 0x4b, 0x0 }, /* #58 */
    { 0x341812, 0x341086, 0xb3, 0xc6, 0x75, 0x0 }, /* #59 */
    { 0x1c1ad7, 0x1c1202, 0x51, 0x0b, 0x5a, 0x0 }, /* #60 */
    { 0x287787, 0x287786, 0x7a, 0xa9, 0xd3, 0x0 }, /* #61 */
    { 0x330c42, 0x330482, 0xec, 0xce, 0x22, 0x0 }, /* #62 */
    { 0x3a2512, 0x3a2586, 0x6a, 0xa5, 0xcf, 0x0 }, /* #63 */
    { 0x150a97, 0x150286, 0x8a, 0x9c, 0x16, 0x0 }, /* #64 */
    { 0x2d4803, 0x2d4006, 0x63, 0x1d, 0x7e, 0x0 }, /* #65 */
    { 0x0b6586, 0x0b6506, 0x4f, 0x2d, 0x62, 0x0 }, /* #66 */
    { 0x213252, 0x213202, 0x4f, 0x1a, 0x55, 0x0 }, /* #67 */
    { 0x252c13, 0x252402, 0x82, 0x01, 0x83, 0x0 }, /* #68 */
    { 0x163913, 0x163182, 0x29, 0xab, 0x82, 0x0 }, /* #69 */
    { 0x3c7bc6, 0x3c7386, 0x05, 0xa3, 0xa6, 0x0 }, /* #70 */
    { 0x262247, 0x262282, 0xcd, 0xc1, 0x0c, 0x0 }, /* #71 */
    { 0x0f6bd3, 0x0f6382, 0x5e, 0xba, 0xe4, 0x0 }, /* #72 */
    { 0x371b86, 0x371386, 0x39, 0xf9, 0xc0, 0x0 }, /* #73 */
    { 0x2172c3, 0x217202, 0x7f, 0x34, 0x4b, 0x0 }, /* #74 */
    { 0x137202, 0x137286, 0x1c, 0x87, 0x9b, 0x0 }, /* #75 */
    { 0x3d6f03, 0x3d6782, 0xd1, 0x97, 0x46, 0x0 }, /* #76 */
    { 0x1e0bd7, 0x1e0382, 0xac, 0xce, 0x62, 0x0 }, /* #77 */
    { 0x0b2207, 0x0b2202, 0x64, 0x7a, 0x1e, 0x0 }, /* #78 */
    { 0x2b1b12, 0x2b1386, 0xb5, 0xb2, 0x07, 0x0 }, /* #79 */
    { 0x0c1c46, 0x0c1406, 0x5a, 0x27, 0x7d, 0x0 }, /* #80 */
    { 0x3e7d06, 0x3e7582, 0x45, 0xea, 0xaf, 0x0 }, /* #81 */
    { 0x260cd7, 0x260402, 0xf6, 0x2a, 0xdc, 0x0 }, /* #82 */
    { 0x094d52, 0x094502, 0x1e, 0x3b, 0x25, 0x0 }, /* #83 */
    { 0x1c7243, 0x1c7286, 0x77, 0xd1, 0xa6, 0x0 }, /* #84 */
    { 0x3a4917, 0x3a4182, 0x62, 0xa8, 0xca, 0x0 }, /* #85 */
    { 0x1d7646, 0x1d7606, 0x72, 0x60, 0x12, 0x0 }, /* #86 */
    { 0x072017, 0x072002, 0x03, 0x62, 0x61, 0x0 }, /* #87 */
    { 0x1352d7, 0x135282, 0x26, 0x9e, 0xb8, 0x0 }, /* #88 */
    { 0x0b7286, 0x0b7206, 0x2c, 0x11, 0x3d, 0x0 }, /* #89 */
    { 0x145403, 0x145402, 0xcc, 0x13, 0xdf, 0x0 }, /* #90 */
    { 0x261347, 0x261386, 0x49, 0xfa, 0xb3, 0x0 }, /* #91 */
    { 0x2f1906, 0x2f1186, 0x8c, 0xbe, 0x32, 0x0 }, /* #92 */
    { 0x2f7e57, 0x2f7602, 0x56, 0x5e, 0x08, 0x0 }, /* #93 */
    { 0x2e0bc2, 0x2e0382, 0x35, 0x9d, 0xa8, 0x0 }, /* #94 */
    { 0x2068c6, 0x206086, 0x2e, 0xfa, 0xd4, 0x0 }, /* #95 */
};
uint32_t const g_cTests_xor_u8 = RT_ELEMENTS(g_aTests_xor_u8);

BINU8_TEST_T const g_aTests_xor_u8_locked[] =
{
    { 0x0d79d2, 0x0d7146, 0x00, 0x00, 0x00, 0x0 }, /* #0 */
    { 0x3c0097, 0x3c0046, 0x00, 0x00, 0x00, 0x0 }, /* #1 */
    { 0x384116, 0x384146, 0x00, 0x00, 0x00, 0x0 }, /* #2 */
    { 0x321616, 0x321646, 0x00, 0x00, 0x00, 0x0 }, /* #3 */
    { 0x1954d2, 0x195446, 0x00, 0x00, 0x00, 0x0 }, /* #4 */
    { 0x332916, 0x332146, 0x00, 0x00, 0x00, 0x0 }, /* #5 */
    { 0x183283, 0x183282, 0xc1, 0xc1, 0x00, 0x0 }, /* #6 */
    { 0x0136d7, 0x013686, 0xb8, 0xb8, 0x00, 0x0 }, /* #7 */
    { 0x0911c3, 0x091106, 0x5a, 0x5a, 0x00, 0x0 }, /* #8 */
    { 0x343682, 0x343682, 0x80, 0x80, 0x00, 0x0 }, /* #9 */
    { 0x1c7582, 0x1c7506, 0x06, 0x06, 0x00, 0x0 }, /* #10 */
    { 0x0d0b16, 0x0d0302, 0x6d, 0x6d, 0x00, 0x0 }, /* #11 */
    { 0x023683, 0x023602, 0xf2, 0x6d, 0x9f, 0x0 }, /* #12 */
    { 0x2932c7, 0x293286, 0x0c, 0xbd, 0xb1, 0x0 }, /* #13 */
    { 0x3e0c83, 0x3e0482, 0x23, 0xb6, 0x95, 0x0 }, /* #14 */
    { 0x186f92, 0x186706, 0x4f, 0x5f, 0x10, 0x0 }, /* #15 */
    { 0x027456, 0x027486, 0x95, 0xa5, 0x30, 0x0 }, /* #16 */
    { 0x0012c2, 0x001282, 0xe6, 0xbf, 0x59, 0x0 }, /* #17 */
    { 0x154d13, 0x154586, 0x7a, 0xd1, 0xab, 0x0 }, /* #18 */
    { 0x365e17, 0x365682, 0xb6, 0xcd, 0x7b, 0x0 }, /* #19 */
    { 0x2c0f03, 0x2c0786, 0x36, 0xdb, 0xed, 0x0 }, /* #20 */
    { 0x077b02, 0x077302, 0x1c, 0x01, 0x1d, 0x0 }, /* #21 */
    { 0x341797, 0x341782, 0x2b, 0xd9, 0xf2, 0x0 }, /* #22 */
    { 0x3276c6, 0x327602, 0xb4, 0x01, 0xb5, 0x0 }, /* #23 */
    { 0x1c6882, 0x1c6002, 0xb3, 0x2c, 0x9f, 0x0 }, /* #24 */
    { 0x064542, 0x064506, 0x16, 0x44, 0x52, 0x0 }, /* #25 */
    { 0x3a1143, 0x3a1186, 0xb6, 0xca, 0x7c, 0x0 }, /* #26 */
    { 0x1966c6, 0x196606, 0x52, 0x72, 0x20, 0x0 }, /* #27 */
    { 0x1d0606, 0x1d0682, 0x0b, 0xad, 0xa6, 0x0 }, /* #28 */
    { 0x261107, 0x261106, 0x75, 0x56, 0x23, 0x0 }, /* #29 */
    { 0x2b7107, 0x2b7106, 0xb1, 0x39, 0x88, 0x0 }, /* #30 */
    { 0x1f42c7, 0x1f4286, 0x7d, 0x8b, 0xf6, 0x0 }, /* #31 */
    { 0x1e7dd6, 0x1e7506, 0xd7, 0x3c, 0xeb, 0x0 }, /* #32 */
    { 0x3e3606, 0x3e3686, 0xf0, 0xaf, 0x5f, 0x0 }, /* #33 */
    { 0x053f46, 0x053786, 0x23, 0x99, 0xba, 0x0 }, /* #34 */
    { 0x1d15d2, 0x1d1582, 0x71, 0xf1, 0x80, 0x0 }, /* #35 */
    { 0x1a6047, 0x1a6002, 0xda, 0x4a, 0x90, 0x0 }, /* #36 */
    { 0x3e1152, 0x3e1102, 0x33, 0x3d, 0x0e, 0x0 }, /* #37 */
    { 0x3135d6, 0x313506, 0x7c, 0x06, 0x7a, 0x0 }, /* #38 */
    { 0x1c6557, 0x1c6506, 0x44, 0x4b, 0x0f, 0x0 }, /* #39 */
    { 0x017746, 0x017786, 0x6f, 0xdb, 0xb4, 0x0 }, /* #40 */
    { 0x1b5957, 0x1b5186, 0xe7, 0xf6, 0x11, 0x0 }, /* #41 */
    { 0x0d7a13, 0x0d7206, 0x3a, 0x7d, 0x47, 0x0 }, /* #42 */
    { 0x036c07, 0x036482, 0xdd, 0xd6, 0x0b, 0x0 }, /* #43 */
    { 0x2a0e02, 0x2a0682, 0xba, 0xae, 0x14, 0x0 }, /* #44 */
    { 0x276dd6, 0x276586, 0x89, 0x87, 0x0e, 0x0 }, /* #45 */
    { 0x0540d6, 0x054002, 0x45, 0x2f, 0x6a, 0x0 }, /* #46 */
    { 0x045156, 0x045106, 0x83, 0x5a, 0xd9, 0x0 }, /* #47 */
    { 0x272456, 0x272406, 0x8d, 0x55, 0xd8, 0x0 }, /* #48 */
    { 0x2f7692, 0x2f7682, 0x87, 0xcd, 0x4a, 0x0 }, /* #49 */
    { 0x2f2e86, 0x2f2682, 0x1e, 0xfe, 0xe0, 0x0 }, /* #50 */
    { 0x031543, 0x031502, 0x68, 0x6d, 0x05, 0x0 }, /* #51 */
    { 0x3208d7, 0x320002, 0xcf, 0x25, 0xea, 0x0 }, /* #52 */
    { 0x107283, 0x107202, 0xe8, 0x51, 0xb9, 0x0 }, /* #53 */
    { 0x0d6d56, 0x0d6586, 0x70, 0x81, 0xf1, 0x0 }, /* #54 */
    { 0x3127c2, 0x312706, 0xe0, 0x2e, 0xce, 0x0 }, /* #55 */
    { 0x187e92, 0x187606, 0xda, 0x65, 0xbf, 0x0 }, /* #56 */
    { 0x091352, 0x091302, 0x14, 0x08, 0x1c, 0x0 }, /* #57 */
    { 0x081ac2, 0x081206, 0x1a, 0x47, 0x5d, 0x0 }, /* #58 */
    { 0x057983, 0x057106, 0xca, 0x7b, 0xb1, 0x0 }, /* #59 */
    { 0x2e2796, 0x2e2786, 0x04, 0xc5, 0xc1, 0x0 }, /* #60 */
    { 0x0e65d2, 0x0e6582, 0xca, 0xe5, 0x2f, 0x0 }, /* #61 */
    { 0x2e3e43, 0x2e3682, 0x19, 0xe0, 0xf9, 0x0 }, /* #62 */
    { 0x1d50d3, 0x1d5006, 0x97, 0x60, 0xf7, 0x0 }, /* #63 */
    { 0x1939c6, 0x193106, 0x0c, 0x35, 0x39, 0x0 }, /* #64 */
    { 0x114983, 0x114182, 0x77, 0xae, 0xd9, 0x0 }, /* #65 */
    { 0x050183, 0x050182, 0x68, 0xb6, 0xde, 0x0 }, /* #66 */
    { 0x146896, 0x146002, 0x79, 0x0e, 0x77, 0x0 }, /* #67 */
    { 0x034b96, 0x034382, 0x5d, 0xe0, 0xbd, 0x0 }, /* #68 */
    { 0x047313, 0x047386, 0x69, 0x87, 0xee, 0x0 }, /* #69 */
    { 0x2f6b53, 0x2f6302, 0x46, 0x5e, 0x18, 0x0 }, /* #70 */
    { 0x2156d6, 0x215686, 0x56, 0xcc, 0x9a, 0x0 }, /* #71 */
    { 0x243316, 0x243306, 0xa0, 0x44, 0xe4, 0x0 }, /* #72 */
    { 0x140387, 0x140302, 0x2f, 0x5b, 0x74, 0x0 }, /* #73 */
    { 0x1b1747, 0x1b1782, 0x96, 0xbc, 0x2a, 0x0 }, /* #74 */
    { 0x0e4856, 0x0e4082, 0xec, 0xea, 0x06, 0x0 }, /* #75 */
    { 0x3e7983, 0x3e7106, 0xf3, 0x2b, 0xd8, 0x0 }, /* #76 */
    { 0x2c1c07, 0x2c1406, 0x88, 0x55, 0xdd, 0x0 }, /* #77 */
    { 0x087602, 0x087606, 0x31, 0x12, 0x23, 0x0 }, /* #78 */
    { 0x170e47, 0x170686, 0x7a, 0x84, 0xfe, 0x0 }, /* #79 */
    { 0x0a1187, 0x0a1106, 0x45, 0x7e, 0x3b, 0x0 }, /* #80 */
    { 0x0c1592, 0x0c1502, 0x0b, 0x2f, 0x24, 0x0 }, /* #81 */
    { 0x2743c6, 0x274386, 0x47, 0xf9, 0xbe, 0x0 }, /* #82 */
    { 0x1e41d7, 0x1e4102, 0x72, 0x34, 0x46, 0x0 }, /* #83 */
    { 0x187a06, 0x187202, 0x67, 0x6d, 0x0a, 0x0 }, /* #84 */
    { 0x157c12, 0x157406, 0xd6, 0x78, 0xae, 0x0 }, /* #85 */
    { 0x0c4d46, 0x0c4582, 0x09, 0x92, 0x9b, 0x0 }, /* #86 */
    { 0x0779d2, 0x077186, 0x40, 0xd2, 0x92, 0x0 }, /* #87 */
    { 0x3720d3, 0x372082, 0xcf, 0xa7, 0x68, 0x0 }, /* #88 */
    { 0x1c28c3, 0x1c2086, 0xd5, 0xf9, 0x2c, 0x0 }, /* #89 */
    { 0x175192, 0x175186, 0x9d, 0xfa, 0x67, 0x0 }, /* #90 */
    { 0x1011c3, 0x101102, 0x9a, 0x6e, 0xf4, 0x0 }, /* #91 */
    { 0x114653, 0x114682, 0x9d, 0xba, 0x27, 0x0 }, /* #92 */
    { 0x392cd7, 0x392482, 0xf9, 0xa1, 0x58, 0x0 }, /* #93 */
    { 0x013146, 0x013102, 0x36, 0x51, 0x67, 0x0 }, /* #94 */
    { 0x3c4152, 0x3c4106, 0x2a, 0x22, 0x08, 0x0 }, /* #95 */
};
uint32_t const g_cTests_xor_u8_locked = RT_ELEMENTS(g_aTests_xor_u8_locked);

BINU8_TEST_T const g_aTests_and_u8[] =
{
    { 0x351b17, 0x351346, 0x00, 0x00, 0x00, 0x0 }, /* #0 */
    { 0x0e2106, 0x0e2146, 0x00, 0x00, 0x00, 0x0 }, /* #1 */
    { 0x323b47, 0x323346, 0x00, 0x00, 0x00, 0x0 }, /* #2 */
    { 0x3d3fd6, 0x3d3746, 0x00, 0x00, 0x00, 0x0 }, /* #3 */
    { 0x226342, 0x226346, 0x00, 0x00, 0x00, 0x0 }, /* #4 */
    { 0x3e1116, 0x3e1146, 0x00, 0x00, 0x00, 0x0 }, /* #5 */
    { 0x050147, 0x050146, 0x6f, 0x00, 0x00, 0x0 }, /* #6 */
    { 0x111812, 0x111046, 0x53, 0x00, 0x00, 0x0 }, /* #7 */
    { 0x214492, 0x214446, 0x9f, 0x00, 0x00, 0x0 }, /* #8 */
    { 0x125c87, 0x125446, 0xac, 0x00, 0x00, 0x0 }, /* #9 */
    { 0x2c2706, 0x2c2746, 0xf7, 0x00, 0x00, 0x0 }, /* #10 */
    { 0x3a0552, 0x3a0546, 0xee, 0x00, 0x00, 0x0 }, /* #11 */
    { 0x1b26d7, 0x1b2602, 0x39, 0x01, 0xc7, 0x0 }, /* #12 */
    { 0x100916, 0x100182, 0xac, 0x80, 0x81, 0x0 }, /* #13 */
    { 0x291817, 0x291006, 0x83, 0x03, 0x5f, 0x0 }, /* #14 */
    { 0x373a47, 0x373202, 0x5b, 0x58, 0xdc, 0x0 }, /* #15 */
    { 0x330e42, 0x330606, 0x68, 0x48, 0x4d, 0x0 }, /* #16 */
    { 0x152652, 0x152602, 0x05, 0x01, 0xc9, 0x0 }, /* #17 */
    { 0x095a97, 0x095206, 0xab, 0x28, 0x28, 0x0 }, /* #18 */
    { 0x1f6097, 0x1f6002, 0x28, 0x08, 0xd8, 0x0 }, /* #19 */
    { 0x352003, 0x352006, 0xda, 0x42, 0x62, 0x0 }, /* #20 */
    { 0x300042, 0x300082, 0xb4, 0xa4, 0xaf, 0x0 }, /* #21 */
    { 0x0f6082, 0x0f6002, 0x49, 0x08, 0x98, 0x0 }, /* #22 */
    { 0x135217, 0x135246, 0xd8, 0x00, 0x26, 0x0 }, /* #23 */
    { 0x1d3647, 0x1d3602, 0x38, 0x20, 0xa7, 0x0 }, /* #24 */
    { 0x196cd3, 0x196406, 0x11, 0x11, 0x51, 0x0 }, /* #25 */
    { 0x093ac2, 0x093202, 0xeb, 0x29, 0x3d, 0x0 }, /* #26 */
    { 0x2d7c12, 0x2d7402, 0x09, 0x08, 0x7c, 0x0 }, /* #27 */
    { 0x032c43, 0x032406, 0x56, 0x44, 0xed, 0x0 }, /* #28 */
    { 0x2c46d2, 0x2c4682, 0xf4, 0x80, 0x81, 0x0 }, /* #29 */
    { 0x1a5446, 0x1a5402, 0x6c, 0x40, 0xc0, 0x0 }, /* #30 */
    { 0x1e0652, 0x1e0682, 0xc2, 0x80, 0xb0, 0x0 }, /* #31 */
    { 0x134652, 0x134606, 0x9e, 0x0a, 0x6a, 0x0 }, /* #32 */
    { 0x3c0f16, 0x3c0782, 0xb4, 0xb0, 0xf9, 0x0 }, /* #33 */
    { 0x101093, 0x101086, 0xcc, 0xc0, 0xd2, 0x0 }, /* #34 */
    { 0x053a97, 0x053282, 0xfe, 0xe0, 0xe0, 0x0 }, /* #35 */
    { 0x3c59c6, 0x3c5182, 0x89, 0x80, 0xb0, 0x0 }, /* #36 */
    { 0x070053, 0x070086, 0xcf, 0xc6, 0xd6, 0x0 }, /* #37 */
    { 0x307cc7, 0x307406, 0x5e, 0x0a, 0x2b, 0x0 }, /* #38 */
    { 0x221b57, 0x221346, 0x08, 0x00, 0xe7, 0x0 }, /* #39 */
    { 0x382fc3, 0x382702, 0x11, 0x10, 0xdc, 0x0 }, /* #40 */
    { 0x127146, 0x127106, 0x3b, 0x22, 0x66, 0x0 }, /* #41 */
    { 0x2c3347, 0x2c3306, 0xf4, 0x50, 0x5b, 0x0 }, /* #42 */
    { 0x0402d2, 0x040246, 0x29, 0x00, 0xc0, 0x0 }, /* #43 */
    { 0x1d3393, 0x1d3346, 0x02, 0x00, 0x70, 0x0 }, /* #44 */
    { 0x204392, 0x204302, 0x79, 0x49, 0x4d, 0x0 }, /* #45 */
    { 0x121746, 0x121706, 0x55, 0x55, 0x55, 0x0 }, /* #46 */
    { 0x0d7c92, 0x0d7402, 0x29, 0x08, 0x5a, 0x0 }, /* #47 */
    { 0x063846, 0x063006, 0xc9, 0x48, 0x6a, 0x0 }, /* #48 */
    { 0x033793, 0x033702, 0x26, 0x04, 0x05, 0x0 }, /* #49 */
    { 0x394fd7, 0x394786, 0xcb, 0x81, 0x91, 0x0 }, /* #50 */
    { 0x0d6f53, 0x0d6786, 0xca, 0x82, 0x82, 0x0 }, /* #51 */
    { 0x3b0ad7, 0x3b0206, 0x79, 0x09, 0x89, 0x0 }, /* #52 */
    { 0x066cd7, 0x066482, 0xd4, 0xd0, 0xf1, 0x0 }, /* #53 */
    { 0x206503, 0x206586, 0xac, 0xa0, 0xa0, 0x0 }, /* #54 */
    { 0x212a03, 0x212286, 0xd6, 0x96, 0xbf, 0x0 }, /* #55 */
    { 0x152bd3, 0x152302, 0xd0, 0x10, 0x36, 0x0 }, /* #56 */
    { 0x392ac7, 0x392202, 0x3f, 0x20, 0x20, 0x0 }, /* #57 */
    { 0x0a2a53, 0x0a2246, 0x61, 0x00, 0x14, 0x0 }, /* #58 */
    { 0x1b4296, 0x1b4206, 0x7c, 0x5c, 0xdc, 0x0 }, /* #59 */
    { 0x370942, 0x370106, 0xc9, 0x09, 0x2b, 0x0 }, /* #60 */
    { 0x0a30c7, 0x0a3002, 0x53, 0x01, 0x81, 0x0 }, /* #61 */
    { 0x102386, 0x102306, 0xdd, 0x44, 0x64, 0x0 }, /* #62 */
    { 0x314883, 0x314002, 0x95, 0x04, 0x44, 0x0 }, /* #63 */
    { 0x236a96, 0x236286, 0xfd, 0xf9, 0xfb, 0x0 }, /* #64 */
    { 0x026587, 0x026502, 0xc4, 0x04, 0x3e, 0x0 }, /* #65 */
    { 0x3e6847, 0x3e6002, 0x23, 0x02, 0x5a, 0x0 }, /* #66 */
    { 0x0f0253, 0x0f0246, 0x10, 0x00, 0x83, 0x0 }, /* #67 */
    { 0x2357c2, 0x235702, 0x71, 0x40, 0xca, 0x0 }, /* #68 */
    { 0x381193, 0x381102, 0xd9, 0x49, 0x49, 0x0 }, /* #69 */
    { 0x1f0046, 0x1f0002, 0xd4, 0x40, 0x41, 0x0 }, /* #70 */
    { 0x2f3fc6, 0x2f3782, 0xaf, 0x85, 0xc5, 0x0 }, /* #71 */
    { 0x162442, 0x162402, 0x3c, 0x38, 0xfb, 0x0 }, /* #72 */
    { 0x103d06, 0x103506, 0x66, 0x66, 0xee, 0x0 }, /* #73 */
    { 0x3e5253, 0x3e5246, 0x1b, 0x00, 0x64, 0x0 }, /* #74 */
    { 0x1853d7, 0x185302, 0x0f, 0x0e, 0x5e, 0x0 }, /* #75 */
    { 0x2265d3, 0x226506, 0x5c, 0x50, 0xd1, 0x0 }, /* #76 */
    { 0x0f5997, 0x0f5102, 0x0e, 0x0e, 0x1f, 0x0 }, /* #77 */
    { 0x254c97, 0x254406, 0xc6, 0x44, 0x54, 0x0 }, /* #78 */
    { 0x3a7546, 0x3a7506, 0x35, 0x14, 0x54, 0x0 }, /* #79 */
    { 0x0534d7, 0x053482, 0xd6, 0xd6, 0xfe, 0x0 }, /* #80 */
    { 0x2140c3, 0x214046, 0x9d, 0x00, 0x22, 0x0 }, /* #81 */
    { 0x343787, 0x343706, 0x6c, 0x48, 0xca, 0x0 }, /* #82 */
    { 0x152557, 0x152502, 0xb8, 0x38, 0x7b, 0x0 }, /* #83 */
    { 0x023d47, 0x023546, 0xa8, 0x00, 0x11, 0x0 }, /* #84 */
    { 0x261e96, 0x261606, 0x73, 0x03, 0x87, 0x0 }, /* #85 */
    { 0x0d28d3, 0x0d2006, 0xbc, 0x18, 0x1b, 0x0 }, /* #86 */
    { 0x1158c6, 0x115086, 0x91, 0x81, 0xc9, 0x0 }, /* #87 */
    { 0x266387, 0x266306, 0x64, 0x24, 0xaf, 0x0 }, /* #88 */
    { 0x056752, 0x056702, 0x14, 0x10, 0xda, 0x0 }, /* #89 */
    { 0x367547, 0x367506, 0x38, 0x30, 0x35, 0x0 }, /* #90 */
    { 0x134147, 0x134106, 0x36, 0x12, 0x1a, 0x0 }, /* #91 */
    { 0x094e53, 0x094606, 0x59, 0x09, 0xad, 0x0 }, /* #92 */
    { 0x144ec3, 0x144602, 0x9c, 0x04, 0x04, 0x0 }, /* #93 */
    { 0x0f4543, 0x0f4586, 0x9c, 0x90, 0xd0, 0x0 }, /* #94 */
    { 0x261282, 0x261202, 0xda, 0x02, 0x22, 0x0 }, /* #95 */
};
uint32_t const g_cTests_and_u8 = RT_ELEMENTS(g_aTests_and_u8);

BINU8_TEST_T const g_aTests_and_u8_locked[] =
{
    { 0x086407, 0x086446, 0x00, 0x00, 0x00, 0x0 }, /* #0 */
    { 0x026796, 0x026746, 0x00, 0x00, 0x00, 0x0 }, /* #1 */
    { 0x2c5c07, 0x2c5446, 0x00, 0x00, 0x00, 0x0 }, /* #2 */
    { 0x2c5593, 0x2c5546, 0x00, 0x00, 0x00, 0x0 }, /* #3 */
    { 0x2f37d3, 0x2f3746, 0x00, 0x00, 0x00, 0x0 }, /* #4 */
    { 0x346d16, 0x346546, 0x00, 0x00, 0x00, 0x0 }, /* #5 */
    { 0x0f73c7, 0x0f7346, 0x39, 0x00, 0x00, 0x0 }, /* #6 */
    { 0x1a5592, 0x1a5546, 0x86, 0x00, 0x00, 0x0 }, /* #7 */
    { 0x2f6012, 0x2f6046, 0xeb, 0x00, 0x00, 0x0 }, /* #8 */
    { 0x0e2dc3, 0x0e2546, 0xe1, 0x00, 0x00, 0x0 }, /* #9 */
    { 0x333ed2, 0x333646, 0x90, 0x00, 0x00, 0x0 }, /* #10 */
    { 0x345fd6, 0x345746, 0xbc, 0x00, 0x00, 0x0 }, /* #11 */
    { 0x3579c2, 0x357146, 0xd7, 0x00, 0x08, 0x0 }, /* #12 */
    { 0x3c2812, 0x3c2002, 0x5d, 0x15, 0xb5, 0x0 }, /* #13 */
    { 0x085652, 0x085602, 0xc3, 0x43, 0x67, 0x0 }, /* #14 */
    { 0x167812, 0x167006, 0x29, 0x28, 0xb8, 0x0 }, /* #15 */
    { 0x137313, 0x137302, 0xe4, 0x20, 0x30, 0x0 }, /* #16 */
    { 0x0e0cd2, 0x0e0446, 0x08, 0x00, 0xb3, 0x0 }, /* #17 */
    { 0x3c4406, 0x3c4486, 0xcb, 0xc0, 0xd0, 0x0 }, /* #18 */
    { 0x036bc6, 0x036302, 0xfc, 0x34, 0x34, 0x0 }, /* #19 */
    { 0x2c2413, 0x2c2402, 0x2c, 0x20, 0xa3, 0x0 }, /* #20 */
    { 0x021803, 0x021002, 0x14, 0x10, 0x91, 0x0 }, /* #21 */
    { 0x341916, 0x341106, 0xa5, 0x05, 0x0d, 0x0 }, /* #22 */
    { 0x1a6707, 0x1a6782, 0xec, 0x80, 0x92, 0x0 }, /* #23 */
    { 0x341517, 0x341502, 0x38, 0x20, 0x26, 0x0 }, /* #24 */
    { 0x273c93, 0x273486, 0xa9, 0xa9, 0xff, 0x0 }, /* #25 */
    { 0x2a69c2, 0x2a6182, 0xa5, 0xa1, 0xe3, 0x0 }, /* #26 */
    { 0x3d3183, 0x3d3106, 0xe3, 0x60, 0x70, 0x0 }, /* #27 */
    { 0x1d03d6, 0x1d0306, 0x2c, 0x24, 0x34, 0x0 }, /* #28 */
    { 0x166596, 0x166506, 0x5c, 0x0c, 0xad, 0x0 }, /* #29 */
    { 0x141c87, 0x141446, 0x22, 0x00, 0x5c, 0x0 }, /* #30 */
    { 0x141c46, 0x141402, 0x7a, 0x20, 0xa4, 0x0 }, /* #31 */
    { 0x0f1b43, 0x0f1386, 0x9e, 0x8e, 0x8e, 0x0 }, /* #32 */
    { 0x2e4ac7, 0x2e4206, 0x6f, 0x65, 0xe5, 0x0 }, /* #33 */
    { 0x256f82, 0x256786, 0xd8, 0xd8, 0xda, 0x0 }, /* #34 */
    { 0x050b83, 0x050386, 0xc3, 0x81, 0x85, 0x0 }, /* #35 */
    { 0x064592, 0x064502, 0x6d, 0x61, 0x73, 0x0 }, /* #36 */
    { 0x081357, 0x081386, 0xb3, 0xb2, 0xfa, 0x0 }, /* #37 */
    { 0x0551c6, 0x055102, 0x83, 0x01, 0x05, 0x0 }, /* #38 */
    { 0x3d15d7, 0x3d1506, 0x9e, 0x12, 0x32, 0x0 }, /* #39 */
    { 0x306b02, 0x306382, 0x9b, 0x92, 0xd2, 0x0 }, /* #40 */
    { 0x2e63d6, 0x2e6302, 0x25, 0x25, 0xb7, 0x0 }, /* #41 */
    { 0x316156, 0x316102, 0x29, 0x01, 0xd3, 0x0 }, /* #42 */
    { 0x2938c6, 0x293002, 0xb6, 0x04, 0x44, 0x0 }, /* #43 */
    { 0x227692, 0x227602, 0xcc, 0x4c, 0x6f, 0x0 }, /* #44 */
    { 0x294c83, 0x294402, 0x86, 0x02, 0x42, 0x0 }, /* #45 */
    { 0x266693, 0x266682, 0xe0, 0x80, 0x80, 0x0 }, /* #46 */
    { 0x0c3397, 0x0c3302, 0x77, 0x16, 0x9e, 0x0 }, /* #47 */
    { 0x354a42, 0x354206, 0xf1, 0x11, 0x11, 0x0 }, /* #48 */
    { 0x196e92, 0x196646, 0x65, 0x00, 0x00, 0x0 }, /* #49 */
    { 0x0d00d6, 0x0d0006, 0x3a, 0x28, 0x28, 0x0 }, /* #50 */
    { 0x0b7047, 0x0b7006, 0x55, 0x55, 0x77, 0x0 }, /* #51 */
    { 0x220186, 0x220106, 0x13, 0x03, 0x67, 0x0 }, /* #52 */
    { 0x0b5953, 0x0b5106, 0x34, 0x30, 0x39, 0x0 }, /* #53 */
    { 0x351bd3, 0x351386, 0xe4, 0xc0, 0xd9, 0x0 }, /* #54 */
    { 0x311c13, 0x311406, 0xc2, 0x42, 0x73, 0x0 }, /* #55 */
    { 0x3f3a93, 0x3f3202, 0xac, 0x2c, 0x2e, 0x0 }, /* #56 */
    { 0x247a52, 0x247202, 0xcd, 0x0d, 0x0d, 0x0 }, /* #57 */
    { 0x367b56, 0x367302, 0x25, 0x01, 0x59, 0x0 }, /* #58 */
    { 0x1f06c7, 0x1f0602, 0x3d, 0x08, 0x0a, 0x0 }, /* #59 */
    { 0x2a04d6, 0x2a0402, 0xee, 0x62, 0x72, 0x0 }, /* #60 */
    { 0x1321c6, 0x132102, 0xe9, 0x40, 0x52, 0x0 }, /* #61 */
    { 0x1133d6, 0x113302, 0x74, 0x40, 0x48, 0x0 }, /* #62 */
    { 0x255393, 0x255382, 0x9f, 0x8f, 0xef, 0x0 }, /* #63 */
    { 0x3a6e52, 0x3a6602, 0x08, 0x08, 0x68, 0x0 }, /* #64 */
    { 0x1a7d02, 0x1a7502, 0xc7, 0x40, 0x50, 0x0 }, /* #65 */
    { 0x194452, 0x194406, 0x74, 0x74, 0x7f, 0x0 }, /* #66 */
    { 0x2a7803, 0x2a7002, 0xc3, 0x43, 0x73, 0x0 }, /* #67 */
    { 0x043a06, 0x043206, 0x3b, 0x2b, 0xef, 0x0 }, /* #68 */
    { 0x010cd2, 0x010402, 0x48, 0x08, 0x9e, 0x0 }, /* #69 */
    { 0x1d5992, 0x1d5102, 0xbe, 0x34, 0x34, 0x0 }, /* #70 */
    { 0x0c1893, 0x0c1002, 0x17, 0x02, 0xe2, 0x0 }, /* #71 */
    { 0x210d16, 0x210506, 0x2b, 0x22, 0x72, 0x0 }, /* #72 */
    { 0x2f6603, 0x2f6682, 0xd0, 0x80, 0xaa, 0x0 }, /* #73 */
    { 0x0b2193, 0x0b2186, 0xed, 0x84, 0x94, 0x0 }, /* #74 */
    { 0x332a12, 0x332282, 0xb2, 0xb0, 0xbc, 0x0 }, /* #75 */
    { 0x1b5807, 0x1b5002, 0x69, 0x20, 0x20, 0x0 }, /* #76 */
    { 0x053486, 0x053402, 0xbc, 0x08, 0x08, 0x0 }, /* #77 */
    { 0x2e69d7, 0x2e6106, 0x2b, 0x22, 0x62, 0x0 }, /* #78 */
    { 0x233cd6, 0x233486, 0xe4, 0xa0, 0xb9, 0x0 }, /* #79 */
    { 0x0d0ec6, 0x0d0602, 0x6c, 0x08, 0x8b, 0x0 }, /* #80 */
    { 0x2f7946, 0x2f7182, 0xa4, 0x80, 0x9b, 0x0 }, /* #81 */
    { 0x234fc3, 0x234786, 0x96, 0x90, 0xb9, 0x0 }, /* #82 */
    { 0x267f57, 0x267706, 0x1f, 0x1b, 0x3b, 0x0 }, /* #83 */
    { 0x3f7e17, 0x3f7606, 0x3c, 0x0c, 0x0f, 0x0 }, /* #84 */
    { 0x2a0542, 0x2a0586, 0x85, 0x84, 0xa6, 0x0 }, /* #85 */
    { 0x2b25d7, 0x2b2502, 0x33, 0x20, 0xe0, 0x0 }, /* #86 */
    { 0x2e40d7, 0x2e4002, 0xa4, 0x04, 0x1e, 0x0 }, /* #87 */
    { 0x387f46, 0x387786, 0x86, 0x82, 0xf2, 0x0 }, /* #88 */
    { 0x1e2903, 0x1e2106, 0x42, 0x42, 0xfb, 0x0 }, /* #89 */
    { 0x2c1c93, 0x2c1402, 0x9c, 0x08, 0x0a, 0x0 }, /* #90 */
    { 0x063e83, 0x063606, 0x75, 0x44, 0x4c, 0x0 }, /* #91 */
    { 0x315d42, 0x315502, 0xb8, 0x38, 0x7f, 0x0 }, /* #92 */
    { 0x1c1106, 0x1c1106, 0x45, 0x05, 0xb5, 0x0 }, /* #93 */
    { 0x3d5d87, 0x3d5502, 0x5c, 0x40, 0xc3, 0x0 }, /* #94 */
    { 0x202816, 0x202002, 0x36, 0x20, 0x28, 0x0 }, /* #95 */
};
uint32_t const g_cTests_and_u8_locked = RT_ELEMENTS(g_aTests_and_u8_locked);

BINU8_TEST_T const g_aTests_cmp_u8[] =
{
    { 0x047252, 0x047246, 0x00, 0x00, 0x00, 0x0 }, /* #0 */
    { 0x002d93, 0x002546, 0x00, 0x00, 0x00, 0x0 }, /* #1 */
    { 0x026692, 0x026646, 0x00, 0x00, 0x00, 0x0 }, /* #2 */
    { 0x1e45c6, 0x1e4546, 0x00, 0x00, 0x00, 0x0 }, /* #3 */
    { 0x2e52c6, 0x2e5246, 0x00, 0x00, 0x00, 0x0 }, /* #4 */
    { 0x271502, 0x271546, 0x00, 0x00, 0x00, 0x0 }, /* #5 */
    { 0x0c47d7, 0x0c4702, 0x23, 0x23, 0x00, 0x0 }, /* #6 */
    { 0x0a4203, 0x0a4206, 0x2e, 0x2e, 0x00, 0x0 }, /* #7 */
    { 0x052147, 0x052102, 0x40, 0x40, 0x00, 0x0 }, /* #8 */
    { 0x2544c6, 0x254402, 0x62, 0x62, 0x00, 0x0 }, /* #9 */
    { 0x261756, 0x261702, 0x3e, 0x3e, 0x00, 0x0 }, /* #10 */
    { 0x227b17, 0x227302, 0x38, 0x38, 0x00, 0x0 }, /* #11 */
    { 0x246b43, 0x246312, 0xb2, 0xb2, 0x9c, 0x0 }, /* #12 */
    { 0x201a93, 0x201202, 0xea, 0xea, 0xa1, 0x0 }, /* #13 */
    { 0x3d1393, 0x3d1303, 0x09, 0x09, 0xa7, 0x0 }, /* #14 */
    { 0x235647, 0x235603, 0x0e, 0x0e, 0xe9, 0x0 }, /* #15 */
    { 0x1a57c3, 0x1a5702, 0x72, 0x72, 0x11, 0x0 }, /* #16 */
    { 0x034742, 0x034707, 0x1f, 0x1f, 0xae, 0x0 }, /* #17 */
    { 0x0a3617, 0x0a3603, 0x54, 0x54, 0xf0, 0x0 }, /* #18 */
    { 0x241187, 0x241193, 0x59, 0x59, 0x7a, 0x0 }, /* #19 */
    { 0x0b2e52, 0x0b2693, 0xb4, 0xb4, 0xda, 0x0 }, /* #20 */
    { 0x3e2b87, 0x3e2b87, 0x2c, 0x2c, 0x80, 0x0 }, /* #21 */
    { 0x2c2713, 0x2c2706, 0xfb, 0xfb, 0xe3, 0x0 }, /* #22 */
    { 0x2c6a13, 0x2c6212, 0xec, 0xec, 0x8f, 0x0 }, /* #23 */
    { 0x3b7b47, 0x3b7307, 0x4a, 0x4a, 0xd3, 0x0 }, /* #24 */
    { 0x260ac7, 0x260206, 0xe7, 0xe7, 0x84, 0x0 }, /* #25 */
    { 0x074f93, 0x074787, 0x9b, 0x9b, 0xa6, 0x0 }, /* #26 */
    { 0x335716, 0x335793, 0x97, 0x97, 0xdb, 0x0 }, /* #27 */
    { 0x200797, 0x200703, 0x23, 0x23, 0xc1, 0x0 }, /* #28 */
    { 0x062643, 0x062687, 0x9a, 0x9a, 0xfa, 0x0 }, /* #29 */
    { 0x0c1a16, 0x0c1293, 0x90, 0x90, 0x9f, 0x0 }, /* #30 */
    { 0x1c24c2, 0x1c2417, 0x13, 0x13, 0xae, 0x0 }, /* #31 */
    { 0x1f3903, 0x1f3107, 0x2a, 0x2a, 0xd0, 0x0 }, /* #32 */
    { 0x0b3542, 0x0b3d87, 0x4a, 0x4a, 0xb5, 0x0 }, /* #33 */
    { 0x064306, 0x064b16, 0xb5, 0xb5, 0x67, 0x0 }, /* #34 */
    { 0x317b16, 0x317303, 0x63, 0x63, 0xf0, 0x0 }, /* #35 */
    { 0x2d5812, 0x2d5887, 0x3a, 0x3a, 0xb9, 0x0 }, /* #36 */
    { 0x214f57, 0x214786, 0xda, 0xda, 0x30, 0x0 }, /* #37 */
    { 0x150812, 0x150802, 0xd9, 0xd9, 0x63, 0x0 }, /* #38 */
    { 0x154103, 0x154182, 0xd8, 0xd8, 0x31, 0x0 }, /* #39 */
    { 0x0833c7, 0x083b02, 0x8d, 0x8d, 0x32, 0x0 }, /* #40 */
    { 0x383713, 0x383716, 0x63, 0x63, 0x5e, 0x0 }, /* #41 */
    { 0x1701c3, 0x170997, 0x45, 0x45, 0xab, 0x0 }, /* #42 */
    { 0x2572c7, 0x257293, 0xb1, 0xb1, 0xef, 0x0 }, /* #43 */
    { 0x0d3716, 0x0d3707, 0x0a, 0x0a, 0xa5, 0x0 }, /* #44 */
    { 0x2b6746, 0x2b6786, 0xff, 0xff, 0x28, 0x0 }, /* #45 */
    { 0x2e3317, 0x2e3316, 0xd1, 0xd1, 0xaa, 0x0 }, /* #46 */
    { 0x0b4e52, 0x0b4e12, 0x91, 0x91, 0x53, 0x0 }, /* #47 */
    { 0x2076c6, 0x207607, 0x4e, 0x4e, 0xd3, 0x0 }, /* #48 */
    { 0x112b56, 0x112312, 0xc3, 0xc3, 0x86, 0x0 }, /* #49 */
    { 0x0319d7, 0x031906, 0xb7, 0xb7, 0x64, 0x0 }, /* #50 */
    { 0x331ed2, 0x331687, 0x8d, 0x8d, 0x97, 0x0 }, /* #51 */
    { 0x351f03, 0x351782, 0xf6, 0xf6, 0x02, 0x0 }, /* #52 */
    { 0x3f2893, 0x3f2013, 0x37, 0x37, 0xeb, 0x0 }, /* #53 */
    { 0x147d56, 0x147d16, 0x92, 0x92, 0x4b, 0x0 }, /* #54 */
    { 0x044542, 0x044583, 0x87, 0x87, 0xb7, 0x0 }, /* #55 */
    { 0x120f97, 0x120702, 0xcb, 0xcb, 0x90, 0x0 }, /* #56 */
    { 0x243e87, 0x243602, 0x3e, 0x3e, 0x29, 0x0 }, /* #57 */
    { 0x3c1e53, 0x3c1e02, 0xbc, 0xbc, 0x7c, 0x0 }, /* #58 */
    { 0x293446, 0x293406, 0x6c, 0x6c, 0x48, 0x0 }, /* #59 */
    { 0x1466d3, 0x146616, 0xf5, 0xf5, 0x9f, 0x0 }, /* #60 */
    { 0x055d92, 0x055d83, 0x3d, 0x3d, 0x90, 0x0 }, /* #61 */
    { 0x350403, 0x350482, 0xb0, 0xb0, 0x00, 0x0 }, /* #62 */
    { 0x1529c3, 0x152997, 0x34, 0x34, 0x9e, 0x0 }, /* #63 */
    { 0x3d1b97, 0x3d1b16, 0x94, 0x94, 0x58, 0x0 }, /* #64 */
    { 0x255386, 0x255b87, 0x7b, 0x7b, 0xf7, 0x0 }, /* #65 */
    { 0x086ac3, 0x086212, 0xf2, 0xf2, 0xe4, 0x0 }, /* #66 */
    { 0x2242d3, 0x224202, 0xc9, 0xc9, 0xa9, 0x0 }, /* #67 */
    { 0x3e6842, 0x3e6897, 0x30, 0x30, 0x96, 0x0 }, /* #68 */
    { 0x200f52, 0x200717, 0x30, 0x30, 0xec, 0x0 }, /* #69 */
    { 0x121992, 0x121197, 0x93, 0x93, 0x9d, 0x0 }, /* #70 */
    { 0x2f4293, 0x2f4216, 0xcd, 0xcd, 0xbe, 0x0 }, /* #71 */
    { 0x3e6d02, 0x3e6d12, 0xa1, 0xa1, 0x75, 0x0 }, /* #72 */
    { 0x0f1f06, 0x0f1f87, 0x12, 0x12, 0x90, 0x0 }, /* #73 */
    { 0x3a72d3, 0x3a7206, 0x9a, 0x9a, 0x95, 0x0 }, /* #74 */
    { 0x1b6e16, 0x1b6687, 0x3c, 0x3c, 0x42, 0x0 }, /* #75 */
    { 0x2b1486, 0x2b1416, 0x40, 0x40, 0x22, 0x0 }, /* #76 */
    { 0x117296, 0x117217, 0x11, 0x11, 0xbc, 0x0 }, /* #77 */
    { 0x3e4542, 0x3e4d97, 0x79, 0x79, 0xca, 0x0 }, /* #78 */
    { 0x194393, 0x194b87, 0x2d, 0x2d, 0x91, 0x0 }, /* #79 */
    { 0x244346, 0x244313, 0x06, 0x06, 0xea, 0x0 }, /* #80 */
    { 0x1e7307, 0x1e7306, 0x60, 0x60, 0x30, 0x0 }, /* #81 */
    { 0x1561d7, 0x156112, 0x54, 0x54, 0x17, 0x0 }, /* #82 */
    { 0x3b4707, 0x3b4f02, 0xa3, 0xa3, 0x41, 0x0 }, /* #83 */
    { 0x3d1416, 0x3d1483, 0x8c, 0x8c, 0x91, 0x0 }, /* #84 */
    { 0x1e2b13, 0x1e2396, 0xc6, 0xc6, 0x2a, 0x0 }, /* #85 */
    { 0x234687, 0x234e97, 0x70, 0x70, 0xe5, 0x0 }, /* #86 */
    { 0x386cd3, 0x386413, 0x20, 0x20, 0xb8, 0x0 }, /* #87 */
    { 0x2f1046, 0x2f1806, 0x9c, 0x9c, 0x30, 0x0 }, /* #88 */
    { 0x3742c3, 0x374206, 0x69, 0x69, 0x63, 0x0 }, /* #89 */
    { 0x2b4997, 0x2b4113, 0x56, 0x56, 0xe8, 0x0 }, /* #90 */
    { 0x0179d2, 0x017902, 0x8b, 0x8b, 0x37, 0x0 }, /* #91 */
    { 0x316c97, 0x316406, 0xdf, 0xdf, 0x83, 0x0 }, /* #92 */
    { 0x3d0cd6, 0x3d0406, 0xad, 0xad, 0x82, 0x0 }, /* #93 */
    { 0x0922d3, 0x092206, 0x7f, 0x7f, 0x46, 0x0 }, /* #94 */
    { 0x120286, 0x120202, 0x7d, 0x7d, 0x1b, 0x0 }, /* #95 */
};
uint32_t const g_cTests_cmp_u8 = RT_ELEMENTS(g_aTests_cmp_u8);

BINU8_TEST_T const g_aTests_test_u8[] =
{
    { 0x0c7296, 0x0c7246, 0x00, 0x00, 0x00, 0x0 }, /* #0 */
    { 0x3b3093, 0x3b3046, 0x00, 0x00, 0x00, 0x0 }, /* #1 */
    { 0x005e56, 0x005646, 0x00, 0x00, 0x00, 0x0 }, /* #2 */
    { 0x1e3287, 0x1e3246, 0x00, 0x00, 0x00, 0x0 }, /* #3 */
    { 0x2f0213, 0x2f0246, 0x00, 0x00, 0x00, 0x0 }, /* #4 */
    { 0x206d47, 0x206546, 0x00, 0x00, 0x00, 0x0 }, /* #5 */
    { 0x2b1b87, 0x2b1346, 0x9c, 0x9c, 0x00, 0x0 }, /* #6 */
    { 0x1620c3, 0x162046, 0x90, 0x90, 0x00, 0x0 }, /* #7 */
    { 0x337ac2, 0x337246, 0xb4, 0xb4, 0x00, 0x0 }, /* #8 */
    { 0x1b6bc6, 0x1b6346, 0x39, 0x39, 0x00, 0x0 }, /* #9 */
    { 0x3e7706, 0x3e7746, 0xab, 0xab, 0x00, 0x0 }, /* #10 */
    { 0x087f86, 0x087746, 0x97, 0x97, 0x00, 0x0 }, /* #11 */
    { 0x0a4682, 0x0a4686, 0x8e, 0x8e, 0xf3, 0x0 }, /* #12 */
    { 0x0b41d6, 0x0b4182, 0xcf, 0xcf, 0xba, 0x0 }, /* #13 */
    { 0x2d20d6, 0x2d2002, 0x1d, 0x1d, 0x32, 0x0 }, /* #14 */
    { 0x291913, 0x291102, 0xb9, 0xb9, 0x37, 0x0 }, /* #15 */
    { 0x116d43, 0x116506, 0x58, 0x58, 0xcc, 0x0 }, /* #16 */
    { 0x0b6bc3, 0x0b6302, 0x89, 0x89, 0x65, 0x0 }, /* #17 */
    { 0x287203, 0x287206, 0x9d, 0x9d, 0x14, 0x0 }, /* #18 */
    { 0x1b25c2, 0x1b2506, 0xa7, 0xa7, 0x24, 0x0 }, /* #19 */
    { 0x2e7d13, 0x2e7502, 0x17, 0x17, 0x73, 0x0 }, /* #20 */
    { 0x167816, 0x167002, 0xe4, 0xe4, 0x43, 0x0 }, /* #21 */
    { 0x2f2883, 0x2f2046, 0xbc, 0xbc, 0x40, 0x0 }, /* #22 */
    { 0x273fc3, 0x273702, 0x03, 0x03, 0xe9, 0x0 }, /* #23 */
    { 0x3a1182, 0x3a1182, 0x8b, 0x8b, 0x80, 0x0 }, /* #24 */
    { 0x0563c2, 0x056306, 0x6e, 0x6e, 0x2f, 0x0 }, /* #25 */
    { 0x236357, 0x236302, 0x43, 0x43, 0x91, 0x0 }, /* #26 */
    { 0x0245c2, 0x024586, 0xca, 0xca, 0xd1, 0x0 }, /* #27 */
    { 0x375e87, 0x375602, 0x72, 0x72, 0xac, 0x0 }, /* #28 */
    { 0x184412, 0x184486, 0xd0, 0xd0, 0xec, 0x0 }, /* #29 */
    { 0x1b5d93, 0x1b5502, 0xa4, 0xa4, 0x45, 0x0 }, /* #30 */
    { 0x293d56, 0x293506, 0x57, 0x57, 0x50, 0x0 }, /* #31 */
    { 0x3246c6, 0x324646, 0x20, 0x20, 0x40, 0x0 }, /* #32 */
    { 0x134902, 0x134106, 0x74, 0x74, 0x2c, 0x0 }, /* #33 */
    { 0x1f6d02, 0x1f6506, 0xd1, 0xd1, 0x61, 0x0 }, /* #34 */
    { 0x290c06, 0x290486, 0xfc, 0xfc, 0xf0, 0x0 }, /* #35 */
    { 0x1b5f16, 0x1b5702, 0x28, 0x28, 0xf4, 0x0 }, /* #36 */
    { 0x1219c3, 0x121186, 0xe3, 0xe3, 0xb4, 0x0 }, /* #37 */
    { 0x0b3ed2, 0x0b3682, 0x93, 0x93, 0xc3, 0x0 }, /* #38 */
    { 0x071d13, 0x071502, 0x53, 0x53, 0x7e, 0x0 }, /* #39 */
    { 0x207b56, 0x207302, 0x53, 0x53, 0xf5, 0x0 }, /* #40 */
    { 0x270ec7, 0x270682, 0xf6, 0xf6, 0x88, 0x0 }, /* #41 */
    { 0x0a5e17, 0x0a5686, 0xd5, 0xd5, 0xcd, 0x0 }, /* #42 */
    { 0x1045c2, 0x104502, 0xca, 0xca, 0x6f, 0x0 }, /* #43 */
    { 0x012992, 0x012102, 0x2e, 0x2e, 0xd9, 0x0 }, /* #44 */
    { 0x2d4797, 0x2d4702, 0x43, 0x43, 0xa1, 0x0 }, /* #45 */
    { 0x2f11d3, 0x2f1182, 0xd8, 0xd8, 0xcf, 0x0 }, /* #46 */
    { 0x2c10d7, 0x2c1002, 0x2f, 0x2f, 0x51, 0x0 }, /* #47 */
    { 0x2a6a96, 0x2a6282, 0xd8, 0xd8, 0x81, 0x0 }, /* #48 */
    { 0x071152, 0x071146, 0x22, 0x22, 0xd9, 0x0 }, /* #49 */
    { 0x377fc6, 0x377706, 0x8f, 0x8f, 0x1a, 0x0 }, /* #50 */
    { 0x0a4e83, 0x0a4686, 0xca, 0xca, 0x82, 0x0 }, /* #51 */
    { 0x073383, 0x073306, 0xef, 0xef, 0x79, 0x0 }, /* #52 */
    { 0x157a13, 0x157286, 0x8f, 0x8f, 0xe1, 0x0 }, /* #53 */
    { 0x121d53, 0x121546, 0xc7, 0xc7, 0x28, 0x0 }, /* #54 */
    { 0x270616, 0x270602, 0xa4, 0xa4, 0x16, 0x0 }, /* #55 */
    { 0x325b52, 0x325306, 0xd3, 0xd3, 0x07, 0x0 }, /* #56 */
    { 0x351702, 0x351782, 0xff, 0xff, 0xfd, 0x0 }, /* #57 */
    { 0x224357, 0x224382, 0xed, 0xed, 0x97, 0x0 }, /* #58 */
    { 0x2d2793, 0x2d2706, 0x4d, 0x4d, 0x3c, 0x0 }, /* #59 */
    { 0x0232d7, 0x023246, 0x72, 0x72, 0x05, 0x0 }, /* #60 */
    { 0x300a07, 0x300202, 0x87, 0x87, 0x0a, 0x0 }, /* #61 */
    { 0x2237c3, 0x223706, 0x33, 0x33, 0x70, 0x0 }, /* #62 */
    { 0x113dc2, 0x113506, 0x77, 0x77, 0x2f, 0x0 }, /* #63 */
    { 0x000752, 0x000706, 0x28, 0x28, 0xaa, 0x0 }, /* #64 */
    { 0x3d1757, 0x3d1786, 0xef, 0xef, 0x9b, 0x0 }, /* #65 */
    { 0x2e7882, 0x2e7046, 0xa2, 0xa2, 0x0c, 0x0 }, /* #66 */
    { 0x3f0b46, 0x3f0382, 0x8f, 0x8f, 0xd6, 0x0 }, /* #67 */
    { 0x130882, 0x130002, 0xa8, 0xa8, 0x58, 0x0 }, /* #68 */
    { 0x360002, 0x360002, 0xd3, 0xd3, 0x17, 0x0 }, /* #69 */
    { 0x3b1206, 0x3b1246, 0x41, 0x41, 0x06, 0x0 }, /* #70 */
    { 0x175a92, 0x175282, 0xd5, 0xd5, 0xff, 0x0 }, /* #71 */
    { 0x2b7bd7, 0x2b7382, 0xdc, 0xdc, 0xf0, 0x0 }, /* #72 */
    { 0x083a13, 0x083202, 0x76, 0x76, 0xc8, 0x0 }, /* #73 */
    { 0x181147, 0x181102, 0xf5, 0xf5, 0x5e, 0x0 }, /* #74 */
    { 0x1b44c7, 0x1b4406, 0x3b, 0x3b, 0xe1, 0x0 }, /* #75 */
    { 0x0f7816, 0x0f7082, 0xc8, 0xc8, 0xfe, 0x0 }, /* #76 */
    { 0x130706, 0x130782, 0xfd, 0xfd, 0xeb, 0x0 }, /* #77 */
    { 0x2d3243, 0x2d3282, 0xa2, 0xa2, 0xeb, 0x0 }, /* #78 */
    { 0x1745c6, 0x174586, 0xa8, 0xa8, 0xc9, 0x0 }, /* #79 */
    { 0x1a3396, 0x1a3302, 0x55, 0x55, 0x15, 0x0 }, /* #80 */
    { 0x176003, 0x176002, 0x04, 0x04, 0x24, 0x0 }, /* #81 */
    { 0x137c07, 0x137446, 0x3c, 0x3c, 0x00, 0x0 }, /* #82 */
    { 0x1a5112, 0x1a5106, 0x6a, 0x6a, 0xe4, 0x0 }, /* #83 */
    { 0x172252, 0x172246, 0x52, 0x52, 0xa5, 0x0 }, /* #84 */
    { 0x0763c7, 0x076382, 0xb2, 0xb2, 0xaa, 0x0 }, /* #85 */
    { 0x343216, 0x343246, 0x04, 0x04, 0x03, 0x0 }, /* #86 */
    { 0x380653, 0x380646, 0x40, 0x40, 0x24, 0x0 }, /* #87 */
    { 0x2d6882, 0x2d6082, 0xed, 0xed, 0xaf, 0x0 }, /* #88 */
    { 0x117793, 0x117786, 0xe9, 0xe9, 0xd4, 0x0 }, /* #89 */
    { 0x2f2342, 0x2f2302, 0x93, 0x93, 0x21, 0x0 }, /* #90 */
    { 0x2e5a13, 0x2e5246, 0xce, 0xce, 0x21, 0x0 }, /* #91 */
    { 0x3e0087, 0x3e0082, 0xe0, 0xe0, 0x8c, 0x0 }, /* #92 */
    { 0x007393, 0x007346, 0x05, 0x05, 0xa2, 0x0 }, /* #93 */
    { 0x296546, 0x296502, 0x14, 0x14, 0xd3, 0x0 }, /* #94 */
    { 0x354d07, 0x354502, 0x29, 0x29, 0xd7, 0x0 }, /* #95 */
};
uint32_t const g_cTests_test_u8 = RT_ELEMENTS(g_aTests_test_u8);

BINU16_TEST_T const g_aTests_add_u16[] =
{
    { 0x2c1786, 0x2c1746, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x1e3f53, 0x1e3746, 0x0000, 0x0000, 0x0000, 0x0 }, /* #1 */
    { 0x050016, 0x050046, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x371986, 0x371146, 0x0000, 0x0000, 0x0000, 0x0 }, /* #3 */
    { 0x372b07, 0x372346, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x007c06, 0x007446, 0x0000, 0x0000, 0x0000, 0x0 }, /* #5 */
    { 0x0b3f52, 0x0b3702, 0x7708, 0x7708, 0x0000, 0x0 }, /* #6 */
    { 0x1d02c2, 0x1d0286, 0xffa9, 0xffa9, 0x0000, 0x0 }, /* #7 */
    { 0x3926d2, 0x392682, 0xed73, 0xed73, 0x0000, 0x0 }, /* #8 */
    { 0x131b82, 0x131302, 0x75c1, 0x75c1, 0x0000, 0x0 }, /* #9 */
    { 0x1d3ac6, 0x1d3282, 0xeb68, 0xeb68, 0x0000, 0x0 }, /* #10 */
    { 0x1f5602, 0x1f5686, 0xec65, 0xec65, 0x0000, 0x0 }, /* #11 */
    { 0x1f0e16, 0x1f0686, 0x9c1e, 0xc1de, 0x25c0, 0x0 }, /* #12 */
    { 0x052803, 0x052087, 0xf010, 0x85e2, 0x95d2, 0x0 }, /* #13 */
    { 0x212416, 0x212492, 0xee8d, 0xfeb3, 0x1026, 0x0 }, /* #14 */
    { 0x0f0a06, 0x0f0a82, 0x6688, 0xdb3e, 0x74b6, 0x0 }, /* #15 */
    { 0x195cc7, 0x195496, 0xbc28, 0xf282, 0x365a, 0x0 }, /* #16 */
    { 0x305c46, 0x305412, 0x04f8, 0x1ab6, 0x15be, 0x0 }, /* #17 */
    { 0x3c53d3, 0x3c5396, 0x50ae, 0xe265, 0x91b7, 0x0 }, /* #18 */
    { 0x284713, 0x284707, 0x5e3e, 0x1a6f, 0xbc31, 0x0 }, /* #19 */
    { 0x041953, 0x041982, 0x71c1, 0xde83, 0x6cc2, 0x0 }, /* #20 */
    { 0x321a86, 0x321a82, 0x2d76, 0xad3d, 0x7fc7, 0x0 }, /* #21 */
    { 0x3e1193, 0x3e1103, 0x7544, 0x6529, 0xefe5, 0x0 }, /* #22 */
    { 0x156a07, 0x156207, 0xba90, 0x0d88, 0x52f8, 0x0 }, /* #23 */
    { 0x082356, 0x082b03, 0x83ce, 0x22df, 0x9f11, 0x0 }, /* #24 */
    { 0x3a33d2, 0x3a3312, 0x58da, 0x6110, 0x0836, 0x0 }, /* #25 */
    { 0x186c53, 0x186497, 0xeb5c, 0xb321, 0xc7c5, 0x0 }, /* #26 */
    { 0x000543, 0x000d86, 0x25f2, 0x8339, 0x5d47, 0x0 }, /* #27 */
    { 0x2c2887, 0x2c2807, 0xf94e, 0x7f3f, 0x85f1, 0x0 }, /* #28 */
    { 0x2732c3, 0x273217, 0xb264, 0x2081, 0x6e1d, 0x0 }, /* #29 */
    { 0x226e03, 0x226683, 0xd754, 0xa14c, 0xc9f8, 0x0 }, /* #30 */
    { 0x307453, 0x307403, 0xfc1a, 0x478f, 0x4b75, 0x0 }, /* #31 */
    { 0x052006, 0x052886, 0x55a3, 0x8496, 0x2ef3, 0x0 }, /* #32 */
    { 0x037502, 0x037587, 0xfe44, 0xc417, 0xc5d3, 0x0 }, /* #33 */
    { 0x3771c2, 0x377196, 0x03ca, 0x9556, 0x918c, 0x0 }, /* #34 */
    { 0x193496, 0x193413, 0x4d0f, 0x3e43, 0xf134, 0x0 }, /* #35 */
    { 0x3d2316, 0x3d2397, 0xcea4, 0xa9b2, 0xdb0e, 0x0 }, /* #36 */
    { 0x1c04d3, 0x1c0403, 0x10ba, 0x036d, 0xf2b3, 0x0 }, /* #37 */
    { 0x0c2293, 0x0c2297, 0xba65, 0x8f63, 0xd4fe, 0x0 }, /* #38 */
    { 0x296997, 0x296183, 0xeca5, 0xd56e, 0xe8c9, 0x0 }, /* #39 */
    { 0x2b08c7, 0x2b0003, 0x7d67, 0x115e, 0x93f7, 0x0 }, /* #40 */
    { 0x333bc7, 0x333307, 0xcc90, 0x029c, 0x360c, 0x0 }, /* #41 */
    { 0x3c2c02, 0x3c2403, 0xd015, 0x2176, 0x5161, 0x0 }, /* #42 */
    { 0x3c1117, 0x3c1187, 0xf6db, 0xe96f, 0xf294, 0x0 }, /* #43 */
    { 0x071c82, 0x071403, 0x6e20, 0x64e0, 0xf6c0, 0x0 }, /* #44 */
    { 0x146402, 0x146c03, 0xa7d4, 0x4685, 0x9eb1, 0x0 }, /* #45 */
    { 0x0f0b57, 0x0f0302, 0x3c41, 0x601a, 0x23d9, 0x0 }, /* #46 */
    { 0x056387, 0x056317, 0x696e, 0x44f5, 0xdb87, 0x0 }, /* #47 */
    { 0x1412d3, 0x141212, 0x0339, 0x24d3, 0x219a, 0x0 }, /* #48 */
    { 0x294187, 0x294183, 0xfd39, 0xda3e, 0xdd05, 0x0 }, /* #49 */
    { 0x016852, 0x016013, 0x6d7b, 0x2857, 0xbadc, 0x0 }, /* #50 */
    { 0x321ed2, 0x321e07, 0xc715, 0x791d, 0xb208, 0x0 }, /* #51 */
    { 0x0e2506, 0x0e2503, 0xdb51, 0x5297, 0x7746, 0x0 }, /* #52 */
    { 0x385486, 0x385417, 0xd98d, 0x5522, 0x7b95, 0x0 }, /* #53 */
    { 0x0626c6, 0x062e86, 0x22aa, 0x8bbd, 0x6913, 0x0 }, /* #54 */
    { 0x1f2487, 0x1f2486, 0x2d27, 0xb369, 0x8642, 0x0 }, /* #55 */
    { 0x0a53d7, 0x0a5b86, 0x3826, 0xa73f, 0x6f19, 0x0 }, /* #56 */
    { 0x171a92, 0x171207, 0x6fac, 0x007e, 0x90d2, 0x0 }, /* #57 */
    { 0x311dc3, 0x311503, 0x3564, 0x048a, 0xcf26, 0x0 }, /* #58 */
    { 0x1b7e53, 0x1b7697, 0xe4bd, 0xbf30, 0xda73, 0x0 }, /* #59 */
    { 0x1a10d7, 0x1a1803, 0x9951, 0x3ae6, 0xa195, 0x0 }, /* #60 */
    { 0x2458d3, 0x245083, 0xf4da, 0xe9cb, 0xf4f1, 0x0 }, /* #61 */
    { 0x0273c3, 0x027b86, 0x2719, 0x82cf, 0x5bb6, 0x0 }, /* #62 */
    { 0x023dd3, 0x023586, 0x6ec4, 0xf1c5, 0x8301, 0x0 }, /* #63 */
    { 0x025012, 0x025007, 0xc6dd, 0x188e, 0x51b1, 0x0 }, /* #64 */
    { 0x095a97, 0x095293, 0xca1b, 0xaaa2, 0xe087, 0x0 }, /* #65 */
    { 0x043a43, 0x043213, 0xf7fd, 0x2e62, 0x3665, 0x0 }, /* #66 */
    { 0x3423d3, 0x342396, 0xca39, 0xd1e8, 0x07af, 0x0 }, /* #67 */
    { 0x1d7602, 0x1d7e86, 0x1830, 0x8800, 0x6fd0, 0x0 }, /* #68 */
    { 0x080796, 0x080786, 0xeb89, 0xf97b, 0x0df2, 0x0 }, /* #69 */
    { 0x0b2357, 0x0b2386, 0x8e6a, 0xbf2e, 0x30c4, 0x0 }, /* #70 */
    { 0x113347, 0x113393, 0xb3bd, 0x8598, 0xd1db, 0x0 }, /* #71 */
    { 0x2b1e92, 0x2b1686, 0x0210, 0x840a, 0x81fa, 0x0 }, /* #72 */
    { 0x0917d7, 0x091796, 0x067b, 0x9069, 0x89ee, 0x0 }, /* #73 */
    { 0x247ac2, 0x247a03, 0xa595, 0x69f8, 0xc463, 0x0 }, /* #74 */
    { 0x3f7452, 0x3f7417, 0xcddf, 0x286c, 0x5a8d, 0x0 }, /* #75 */
    { 0x243a82, 0x243a03, 0xa842, 0x36d6, 0x8e94, 0x0 }, /* #76 */
    { 0x2f0057, 0x2f0087, 0xe5d3, 0xe3eb, 0xfe18, 0x0 }, /* #77 */
    { 0x304243, 0x304296, 0x9fac, 0xe6c5, 0x4719, 0x0 }, /* #78 */
    { 0x344c16, 0x344c96, 0x08ae, 0x8735, 0x7e87, 0x0 }, /* #79 */
    { 0x3053d7, 0x305316, 0x346c, 0x38a3, 0x0437, 0x0 }, /* #80 */
    { 0x163d92, 0x163583, 0xf261, 0xeb2f, 0xf8ce, 0x0 }, /* #81 */
    { 0x332c42, 0x332c92, 0x6b1d, 0x9704, 0x2be7, 0x0 }, /* #82 */
    { 0x026602, 0x026692, 0x2f7d, 0xf334, 0xc3b7, 0x0 }, /* #83 */
    { 0x301a12, 0x301283, 0xd232, 0x941f, 0xc1ed, 0x0 }, /* #84 */
    { 0x214303, 0x214317, 0xe3ec, 0x3228, 0x4e3c, 0x0 }, /* #85 */
    { 0x0a1542, 0x0a1507, 0xccca, 0x41cf, 0x7505, 0x0 }, /* #86 */
    { 0x2a66c6, 0x2a6603, 0x52c0, 0x2a52, 0xd792, 0x0 }, /* #87 */
    { 0x291357, 0x291386, 0x28da, 0xadca, 0x84f0, 0x0 }, /* #88 */
    { 0x2218d3, 0x221087, 0xe3c5, 0x951b, 0xb156, 0x0 }, /* #89 */
    { 0x145f42, 0x145786, 0x8172, 0xacb2, 0x2b40, 0x0 }, /* #90 */
    { 0x3f0a13, 0x3f0a03, 0x88b8, 0x4098, 0xb7e0, 0x0 }, /* #91 */
    { 0x0c2446, 0x0c2487, 0xe585, 0xddfc, 0xf877, 0x0 }, /* #92 */
    { 0x0a7a06, 0x0a7a07, 0x872c, 0x49be, 0xc292, 0x0 }, /* #93 */
    { 0x2c2996, 0x2c2102, 0x1998, 0x235d, 0x09c5, 0x0 }, /* #94 */
    { 0x243693, 0x243692, 0x856d, 0xdf34, 0x59c7, 0x0 }, /* #95 */
};
uint32_t const g_cTests_add_u16 = RT_ELEMENTS(g_aTests_add_u16);

BINU16_TEST_T const g_aTests_add_u16_locked[] =
{
    { 0x126a87, 0x126246, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x096512, 0x096546, 0x0000, 0x0000, 0x0000, 0x0 }, /* #1 */
    { 0x3956c7, 0x395646, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x3a2192, 0x3a2146, 0x0000, 0x0000, 0x0000, 0x0 }, /* #3 */
    { 0x355953, 0x355146, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x2a5a17, 0x2a5246, 0x0000, 0x0000, 0x0000, 0x0 }, /* #5 */
    { 0x262b03, 0x262382, 0xa6b3, 0xa6b3, 0x0000, 0x0 }, /* #6 */
    { 0x024d53, 0x024506, 0x2196, 0x2196, 0x0000, 0x0 }, /* #7 */
    { 0x1b5fd3, 0x1b5786, 0xdf65, 0xdf65, 0x0000, 0x0 }, /* #8 */
    { 0x273b13, 0x273382, 0xe492, 0xe492, 0x0000, 0x0 }, /* #9 */
    { 0x174887, 0x174082, 0x9c7a, 0x9c7a, 0x0000, 0x0 }, /* #10 */
    { 0x124706, 0x124782, 0xf05d, 0xf05d, 0x0000, 0x0 }, /* #11 */
    { 0x0b1956, 0x0b1183, 0xca33, 0xb13b, 0xe708, 0x0 }, /* #12 */
    { 0x242742, 0x242f92, 0x77af, 0xa120, 0x2971, 0x0 }, /* #13 */
    { 0x2e5a92, 0x2e5213, 0x4b0e, 0x12d0, 0xc7c2, 0x0 }, /* #14 */
    { 0x1d0d83, 0x1d0517, 0xbea7, 0x0744, 0x489d, 0x0 }, /* #15 */
    { 0x3f0a02, 0x3f0a82, 0x7851, 0x928a, 0x1a39, 0x0 }, /* #16 */
    { 0x2667c6, 0x266787, 0xfb95, 0xb635, 0xbaa0, 0x0 }, /* #17 */
    { 0x1e2652, 0x1e2602, 0x123b, 0x5d9b, 0x4b60, 0x0 }, /* #18 */
    { 0x016046, 0x016096, 0x257c, 0xee66, 0xc8ea, 0x0 }, /* #19 */
    { 0x1d1503, 0x1d1506, 0x01d2, 0x3fc9, 0x3df7, 0x0 }, /* #20 */
    { 0x0e7083, 0x0e7896, 0x5e6e, 0xc1c3, 0x6355, 0x0 }, /* #21 */
    { 0x1f7a93, 0x1f7a82, 0x4637, 0x90ad, 0x4a76, 0x0 }, /* #22 */
    { 0x2c39c7, 0x2c3903, 0x90c0, 0x20ba, 0x8ffa, 0x0 }, /* #23 */
    { 0x2d5517, 0x2d5517, 0xf3ad, 0x5b47, 0x679a, 0x0 }, /* #24 */
    { 0x282383, 0x282303, 0x5f11, 0x0c43, 0xad32, 0x0 }, /* #25 */
    { 0x110902, 0x110192, 0x910e, 0xb1c4, 0x20b6, 0x0 }, /* #26 */
    { 0x0a3312, 0x0a3b82, 0x1ed2, 0x8868, 0x6996, 0x0 }, /* #27 */
    { 0x180213, 0x180282, 0xa252, 0xb91f, 0x16cd, 0x0 }, /* #28 */
    { 0x377bc7, 0x377392, 0xb3fd, 0xb5a2, 0x01a5, 0x0 }, /* #29 */
    { 0x3b10c7, 0x3b1083, 0xba53, 0x8e1f, 0xd3cc, 0x0 }, /* #30 */
    { 0x0f63d6, 0x0f6b92, 0x57af, 0x9279, 0x3aca, 0x0 }, /* #31 */
    { 0x354657, 0x354e07, 0xb740, 0x7fac, 0xc86c, 0x0 }, /* #32 */
    { 0x230016, 0x230886, 0x5c10, 0x99e4, 0x3dd4, 0x0 }, /* #33 */
    { 0x243f16, 0x243786, 0x0217, 0x987d, 0x9666, 0x0 }, /* #34 */
    { 0x2b2e03, 0x2b2686, 0xa88b, 0xf76f, 0x4ee4, 0x0 }, /* #35 */
    { 0x2d0f17, 0x2d0f07, 0x9065, 0x4da9, 0xbd44, 0x0 }, /* #36 */
    { 0x162353, 0x162392, 0xa685, 0xebe3, 0x455e, 0x0 }, /* #37 */
    { 0x393997, 0x393986, 0x5e63, 0xc4d4, 0x6671, 0x0 }, /* #38 */
    { 0x077443, 0x077417, 0xd7ea, 0x0217, 0x2a2d, 0x0 }, /* #39 */
    { 0x096f97, 0x096796, 0xba37, 0xbbb2, 0x017b, 0x0 }, /* #40 */
    { 0x0126d3, 0x012692, 0x07be, 0xa249, 0x9a8b, 0x0 }, /* #41 */
    { 0x1a5e96, 0x1a5e86, 0x7dba, 0x942d, 0x1673, 0x0 }, /* #42 */
    { 0x3326d6, 0x332696, 0x0b1f, 0xe5c6, 0xdaa7, 0x0 }, /* #43 */
    { 0x0776d2, 0x077683, 0xeb06, 0x9dcb, 0xb2c5, 0x0 }, /* #44 */
    { 0x2c7396, 0x2c7b82, 0x6456, 0xa9fe, 0x45a8, 0x0 }, /* #45 */
    { 0x135113, 0x135183, 0xf07b, 0xe99e, 0xf923, 0x0 }, /* #46 */
    { 0x3158d3, 0x315003, 0xfbe3, 0x0a97, 0x0eb4, 0x0 }, /* #47 */
    { 0x0041c6, 0x004182, 0xbb03, 0xe66b, 0x2b68, 0x0 }, /* #48 */
    { 0x3127c7, 0x312786, 0x3454, 0xb97d, 0x8529, 0x0 }, /* #49 */
    { 0x092686, 0x092617, 0x8b56, 0x01c0, 0x766a, 0x0 }, /* #50 */
    { 0x3f2496, 0x3f2c82, 0x70f0, 0x8fa1, 0x1eb1, 0x0 }, /* #51 */
    { 0x131016, 0x131807, 0xb071, 0x4095, 0x9024, 0x0 }, /* #52 */
    { 0x2422d2, 0x242283, 0xbb50, 0x8092, 0xc542, 0x0 }, /* #53 */
    { 0x1f4752, 0x1f4713, 0x51bd, 0x3fd5, 0xee18, 0x0 }, /* #54 */
    { 0x1a43c2, 0x1a4b03, 0xd6d8, 0x5b6b, 0x8493, 0x0 }, /* #55 */
    { 0x140912, 0x140103, 0x4e62, 0x3015, 0xe1b3, 0x0 }, /* #56 */
    { 0x216857, 0x216096, 0xa423, 0xf5f0, 0x51cd, 0x0 }, /* #57 */
    { 0x302683, 0x302612, 0x4c99, 0x6961, 0x1cc8, 0x0 }, /* #58 */
    { 0x001ac2, 0x001a92, 0x5568, 0x96d3, 0x416b, 0x0 }, /* #59 */
    { 0x103753, 0x103792, 0x02ff, 0xefd9, 0xecda, 0x0 }, /* #60 */
    { 0x1f5002, 0x1f5082, 0x9753, 0xd754, 0x4001, 0x0 }, /* #61 */
    { 0x342d97, 0x342513, 0xe80b, 0x3534, 0x4d29, 0x0 }, /* #62 */
    { 0x0a4703, 0x0a4f07, 0xbcb9, 0x5299, 0x95e0, 0x0 }, /* #63 */
    { 0x175253, 0x175a07, 0xa5e7, 0x5147, 0xab60, 0x0 }, /* #64 */
    { 0x1c5656, 0x1c5682, 0x5b05, 0xf8bf, 0x9dba, 0x0 }, /* #65 */
    { 0x002446, 0x002c17, 0xa114, 0x5f93, 0xbe7f, 0x0 }, /* #66 */
    { 0x2a5fc6, 0x2a5f03, 0xbee4, 0x70fd, 0xb219, 0x0 }, /* #67 */
    { 0x1a1893, 0x1a1002, 0x1437, 0x60bc, 0x4c85, 0x0 }, /* #68 */
    { 0x0c1512, 0x0c1507, 0xd722, 0x3653, 0x5f31, 0x0 }, /* #69 */
    { 0x053847, 0x053086, 0x0195, 0x8dee, 0x8c59, 0x0 }, /* #70 */
    { 0x345883, 0x345093, 0xf87e, 0xbc31, 0xc3b3, 0x0 }, /* #71 */
    { 0x100c13, 0x100407, 0xa8aa, 0x0c2b, 0x6381, 0x0 }, /* #72 */
    { 0x3e6ac2, 0x3e6282, 0x1372, 0xac32, 0x98c0, 0x0 }, /* #73 */
    { 0x1e3b47, 0x1e3382, 0x3464, 0xf33b, 0xbed7, 0x0 }, /* #74 */
    { 0x065847, 0x065007, 0x4426, 0x31d8, 0xedb2, 0x0 }, /* #75 */
    { 0x3e3156, 0x3e3102, 0x31e6, 0x467a, 0x1494, 0x0 }, /* #76 */
    { 0x1d1c43, 0x1d1403, 0x61dd, 0x46ae, 0xe4d1, 0x0 }, /* #77 */
    { 0x3448d6, 0x344886, 0x7633, 0xacb7, 0x3684, 0x0 }, /* #78 */
    { 0x2f4113, 0x2f4182, 0x89f1, 0xa63e, 0x1c4d, 0x0 }, /* #79 */
    { 0x3215d3, 0x321583, 0xffd0, 0x875d, 0x878d, 0x0 }, /* #80 */
    { 0x1a20d2, 0x1a2807, 0x9a1a, 0x2d7d, 0x9363, 0x0 }, /* #81 */
    { 0x2966c6, 0x296602, 0x0d20, 0x21dc, 0x14bc, 0x0 }, /* #82 */
    { 0x260a96, 0x260213, 0x4fac, 0x09c2, 0xba16, 0x0 }, /* #83 */
    { 0x117613, 0x117e13, 0x872a, 0x1183, 0x8a59, 0x0 }, /* #84 */
    { 0x112e06, 0x112617, 0x452c, 0x2d3a, 0xe80e, 0x0 }, /* #85 */
    { 0x0f0ed7, 0x0f0603, 0x3dd1, 0x2f5e, 0xf18d, 0x0 }, /* #86 */
    { 0x2b4142, 0x2b4106, 0x2cc3, 0x48f3, 0x1c30, 0x0 }, /* #87 */
    { 0x360443, 0x360492, 0x9b14, 0xc161, 0x264d, 0x0 }, /* #88 */
    { 0x313b82, 0x313383, 0xffe4, 0xbc58, 0xbc74, 0x0 }, /* #89 */
    { 0x0e6207, 0x0e6206, 0x1861, 0x2717, 0x0eb6, 0x0 }, /* #90 */
    { 0x023a02, 0x023217, 0xaf7e, 0x0850, 0x58d2, 0x0 }, /* #91 */
    { 0x2b1c13, 0x2b1492, 0x8d1f, 0x9df4, 0x10d5, 0x0 }, /* #92 */
    { 0x205f92, 0x205793, 0xf91c, 0xd683, 0xdd67, 0x0 }, /* #93 */
    { 0x067407, 0x067496, 0xc4de, 0xd922, 0x1444, 0x0 }, /* #94 */
    { 0x103e97, 0x103613, 0x634b, 0x0291, 0x9f46, 0x0 }, /* #95 */
};
uint32_t const g_cTests_add_u16_locked = RT_ELEMENTS(g_aTests_add_u16_locked);

BINU16_TEST_T const g_aTests_adc_u16[] =
{
    { 0x137416, 0x137446, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x227103, 0x227102, 0x0000, 0x0001, 0x0000, 0x0 }, /* #1 */
    { 0x3b7506, 0x3b7546, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x3d32d3, 0x3d3202, 0x0000, 0x0001, 0x0000, 0x0 }, /* #3 */
    { 0x1a4c96, 0x1a4446, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x125286, 0x125246, 0x0000, 0x0000, 0x0000, 0x0 }, /* #5 */
    { 0x086943, 0x086182, 0xe76a, 0xe76b, 0x0000, 0x0 }, /* #6 */
    { 0x1836c2, 0x183686, 0xa478, 0xa478, 0x0000, 0x0 }, /* #7 */
    { 0x3b5303, 0x3b5382, 0xd167, 0xd168, 0x0000, 0x0 }, /* #8 */
    { 0x155842, 0x155002, 0x095d, 0x095d, 0x0000, 0x0 }, /* #9 */
    { 0x1528d6, 0x152086, 0x99e2, 0x99e2, 0x0000, 0x0 }, /* #10 */
    { 0x1f5f57, 0x1f5706, 0x6887, 0x6888, 0x0000, 0x0 }, /* #11 */
    { 0x2f62c6, 0x2f6296, 0x9eb5, 0xe3e2, 0x452d, 0x0 }, /* #12 */
    { 0x2c79d2, 0x2c7196, 0x19ad, 0x9f90, 0x85e3, 0x0 }, /* #13 */
    { 0x0f5f92, 0x0f5786, 0x8128, 0x9e4d, 0x1d25, 0x0 }, /* #14 */
    { 0x256c06, 0x256407, 0x33e1, 0x1fe2, 0xec01, 0x0 }, /* #15 */
    { 0x2f11c7, 0x2f1182, 0x9776, 0xb63b, 0x1ec4, 0x0 }, /* #16 */
    { 0x0c2056, 0x0c2896, 0x2fbf, 0x980a, 0x684b, 0x0 }, /* #17 */
    { 0x364b42, 0x364313, 0xcd22, 0x3e80, 0x715e, 0x0 }, /* #18 */
    { 0x124716, 0x124792, 0x227c, 0xc4d3, 0xa257, 0x0 }, /* #19 */
    { 0x3c1147, 0x3c1183, 0xda22, 0xa1e6, 0xc7c3, 0x0 }, /* #20 */
    { 0x0b1742, 0x0b1787, 0xb46d, 0x983f, 0xe3d2, 0x0 }, /* #21 */
    { 0x1d2146, 0x1d2107, 0xa501, 0x0d88, 0x6887, 0x0 }, /* #22 */
    { 0x052e92, 0x052e96, 0x2c38, 0xa1b1, 0x7579, 0x0 }, /* #23 */
    { 0x117cd2, 0x117412, 0x5c0e, 0x72b0, 0x16a2, 0x0 }, /* #24 */
    { 0x3d69c2, 0x3d6192, 0x8c7f, 0xc59d, 0x391e, 0x0 }, /* #25 */
    { 0x320156, 0x320996, 0x72a6, 0xe895, 0x75ef, 0x0 }, /* #26 */
    { 0x3a6bc2, 0x3a6b92, 0x423a, 0xbbd5, 0x799b, 0x0 }, /* #27 */
    { 0x267002, 0x267807, 0xb534, 0x5ce4, 0xa7b0, 0x0 }, /* #28 */
    { 0x297056, 0x297082, 0x9e43, 0xa4ba, 0x0677, 0x0 }, /* #29 */
    { 0x344003, 0x344082, 0x7173, 0xfb08, 0x8994, 0x0 }, /* #30 */
    { 0x026dc7, 0x026517, 0x76d6, 0x4c41, 0xd56a, 0x0 }, /* #31 */
    { 0x272356, 0x272386, 0x8831, 0xc533, 0x3d02, 0x0 }, /* #32 */
    { 0x356a47, 0x356212, 0x056e, 0x6c73, 0x6704, 0x0 }, /* #33 */
    { 0x234046, 0x234093, 0xa03d, 0x9f29, 0xfeec, 0x0 }, /* #34 */
    { 0x096143, 0x096996, 0x5c7f, 0xb339, 0x56b9, 0x0 }, /* #35 */
    { 0x177a07, 0x177292, 0xa34f, 0xbc0b, 0x18bb, 0x0 }, /* #36 */
    { 0x306b07, 0x306307, 0xcf81, 0x1be7, 0x4c65, 0x0 }, /* #37 */
    { 0x3a6243, 0x3a6287, 0xcd24, 0x807d, 0xb358, 0x0 }, /* #38 */
    { 0x2f7606, 0x2f7e07, 0xf6d4, 0x79d4, 0x8300, 0x0 }, /* #39 */
    { 0x1e5502, 0x1e5582, 0xcb62, 0xeef7, 0x2395, 0x0 }, /* #40 */
    { 0x0d0ed2, 0x0d0617, 0xf9da, 0x1c03, 0x2229, 0x0 }, /* #41 */
    { 0x211a46, 0x211292, 0x88ee, 0xcb4a, 0x425c, 0x0 }, /* #42 */
    { 0x067356, 0x067306, 0x24d9, 0x2acc, 0x05f3, 0x0 }, /* #43 */
    { 0x0a4ad7, 0x0a4203, 0x5a31, 0x5479, 0xfa47, 0x0 }, /* #44 */
    { 0x073707, 0x073787, 0xe216, 0x947d, 0xb266, 0x0 }, /* #45 */
    { 0x3c6dd2, 0x3c6d03, 0x8591, 0x166b, 0x90da, 0x0 }, /* #46 */
    { 0x392d47, 0x392506, 0x0da1, 0x1f24, 0x1182, 0x0 }, /* #47 */
    { 0x2a0a53, 0x2a0202, 0x0337, 0x726b, 0x6f33, 0x0 }, /* #48 */
    { 0x2f5486, 0x2f5c96, 0x5f5a, 0xc839, 0x68df, 0x0 }, /* #49 */
    { 0x2419c6, 0x241903, 0xd390, 0x6501, 0x9171, 0x0 }, /* #50 */
    { 0x252642, 0x252612, 0x3e08, 0x51a7, 0x139f, 0x0 }, /* #51 */
    { 0x2b3786, 0x2b3792, 0xa35f, 0xe625, 0x42c6, 0x0 }, /* #52 */
    { 0x1c3002, 0x1c3003, 0xa8d9, 0x163d, 0x6d64, 0x0 }, /* #53 */
    { 0x211c83, 0x211486, 0x2aed, 0xdc4e, 0xb160, 0x0 }, /* #54 */
    { 0x001d03, 0x001582, 0x0ec0, 0x9f6b, 0x90aa, 0x0 }, /* #55 */
    { 0x043693, 0x043686, 0x9242, 0xc1eb, 0x2fa8, 0x0 }, /* #56 */
    { 0x095486, 0x095486, 0xc603, 0xf365, 0x2d62, 0x0 }, /* #57 */
    { 0x346506, 0x346d86, 0x2d60, 0x81b8, 0x5458, 0x0 }, /* #58 */
    { 0x151242, 0x151a96, 0x4ecb, 0xb9d7, 0x6b0c, 0x0 }, /* #59 */
    { 0x2d2e47, 0x2d2606, 0x12c9, 0x3fac, 0x2ce2, 0x0 }, /* #60 */
    { 0x150993, 0x150102, 0x40a5, 0x5bdf, 0x1b39, 0x0 }, /* #61 */
    { 0x021193, 0x021196, 0x9c6c, 0xf0c6, 0x5459, 0x0 }, /* #62 */
    { 0x317c57, 0x317496, 0xb6e6, 0xd072, 0x198b, 0x0 }, /* #63 */
    { 0x0b7317, 0x0b7b86, 0x7aca, 0xa99f, 0x2ed4, 0x0 }, /* #64 */
    { 0x145556, 0x145d13, 0x91a8, 0x7225, 0xe07d, 0x0 }, /* #65 */
    { 0x102716, 0x102797, 0x9e8c, 0x8ce4, 0xee58, 0x0 }, /* #66 */
    { 0x374dc6, 0x374517, 0x8fbb, 0x0eaa, 0x7eef, 0x0 }, /* #67 */
    { 0x340d92, 0x340593, 0xfb68, 0xa102, 0xa59a, 0x0 }, /* #68 */
    { 0x0d5502, 0x0d5513, 0x5fda, 0x4838, 0xe85e, 0x0 }, /* #69 */
    { 0x1943d2, 0x194303, 0xe087, 0x4e07, 0x6d80, 0x0 }, /* #70 */
    { 0x1d2e16, 0x1d2603, 0x3db4, 0x1bbc, 0xde08, 0x0 }, /* #71 */
    { 0x192047, 0x192013, 0x618a, 0x28f8, 0xc76d, 0x0 }, /* #72 */
    { 0x295a86, 0x295a82, 0x346a, 0xb2dc, 0x7e72, 0x0 }, /* #73 */
    { 0x0578c3, 0x057082, 0xa215, 0xc62a, 0x2414, 0x0 }, /* #74 */
    { 0x1a0a86, 0x1a0217, 0x6f6e, 0x6a06, 0xfa98, 0x0 }, /* #75 */
    { 0x121c83, 0x121403, 0x6984, 0x0b29, 0xa1a4, 0x0 }, /* #76 */
    { 0x264806, 0x264096, 0x8fe4, 0xd421, 0x443d, 0x0 }, /* #77 */
    { 0x2b5806, 0x2b5817, 0xb31b, 0x6300, 0xafe5, 0x0 }, /* #78 */
    { 0x193886, 0x193003, 0xf17b, 0x3c5b, 0x4ae0, 0x0 }, /* #79 */
    { 0x0f02d7, 0x0f0a03, 0xa2b8, 0x470b, 0xa452, 0x0 }, /* #80 */
    { 0x341a83, 0x341296, 0x04ba, 0xb55a, 0xb09f, 0x0 }, /* #81 */
    { 0x1d1fd6, 0x1d1707, 0xf565, 0x59e7, 0x6482, 0x0 }, /* #82 */
    { 0x132887, 0x132093, 0xbf0f, 0xa21a, 0xe30a, 0x0 }, /* #83 */
    { 0x397893, 0x397007, 0x213e, 0x120f, 0xf0d0, 0x0 }, /* #84 */
    { 0x186fd7, 0x186782, 0x30ba, 0xe39d, 0xb2e2, 0x0 }, /* #85 */
    { 0x372f82, 0x372706, 0x0f62, 0x38c9, 0x2967, 0x0 }, /* #86 */
    { 0x1417d7, 0x141707, 0xb8a4, 0x1d2d, 0x6488, 0x0 }, /* #87 */
    { 0x0a06d3, 0x0a0682, 0xcb05, 0xea29, 0x1f23, 0x0 }, /* #88 */
    { 0x365ed2, 0x365612, 0x03d1, 0x0d20, 0x094f, 0x0 }, /* #89 */
    { 0x0b6653, 0x0b6686, 0x1751, 0x991e, 0x81cc, 0x0 }, /* #90 */
    { 0x140952, 0x140103, 0xc0b3, 0x369d, 0x75ea, 0x0 }, /* #91 */
    { 0x183b53, 0x183b17, 0xa178, 0x2648, 0x84cf, 0x0 }, /* #92 */
    { 0x3e7b16, 0x3e7b03, 0xc393, 0x6189, 0x9df6, 0x0 }, /* #93 */
    { 0x2e0896, 0x2e0087, 0xbf03, 0x88c6, 0xc9c3, 0x0 }, /* #94 */
    { 0x3e7947, 0x3e7917, 0x8a4e, 0x0c2d, 0x81de, 0x0 }, /* #95 */
};
uint32_t const g_cTests_adc_u16 = RT_ELEMENTS(g_aTests_adc_u16);

BINU16_TEST_T const g_aTests_adc_u16_locked[] =
{
    { 0x2c3c52, 0x2c3446, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x3d25d6, 0x3d2546, 0x0000, 0x0000, 0x0000, 0x0 }, /* #1 */
    { 0x081c82, 0x081446, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x2d2b56, 0x2d2346, 0x0000, 0x0000, 0x0000, 0x0 }, /* #3 */
    { 0x2b4997, 0x2b4102, 0x0000, 0x0001, 0x0000, 0x0 }, /* #4 */
    { 0x264a43, 0x264202, 0x0000, 0x0001, 0x0000, 0x0 }, /* #5 */
    { 0x263652, 0x263686, 0xe9b4, 0xe9b4, 0x0000, 0x0 }, /* #6 */
    { 0x373216, 0x373282, 0x9d20, 0x9d20, 0x0000, 0x0 }, /* #7 */
    { 0x0a6387, 0x0a6382, 0x84cc, 0x84cd, 0x0000, 0x0 }, /* #8 */
    { 0x114192, 0x114186, 0xd18d, 0xd18d, 0x0000, 0x0 }, /* #9 */
    { 0x362383, 0x362312, 0x7d6f, 0x7d70, 0x0000, 0x0 }, /* #10 */
    { 0x0f5a82, 0x0f5282, 0xfcef, 0xfcef, 0x0000, 0x0 }, /* #11 */
    { 0x3f6ad2, 0x3f6a86, 0x7c36, 0x9f66, 0x2330, 0x0 }, /* #12 */
    { 0x0e2b97, 0x0e2386, 0xc0be, 0xd60f, 0x1550, 0x0 }, /* #13 */
    { 0x215247, 0x215a07, 0x9206, 0x604b, 0xce44, 0x0 }, /* #14 */
    { 0x0c0406, 0x0c0c96, 0x4f5e, 0x8b84, 0x3c26, 0x0 }, /* #15 */
    { 0x0b71d2, 0x0b7196, 0xa7fa, 0xcf93, 0x2799, 0x0 }, /* #16 */
    { 0x2a5c03, 0x2a5496, 0x12af, 0xef7d, 0xdccd, 0x0 }, /* #17 */
    { 0x2939c2, 0x293112, 0x39aa, 0x5252, 0x18a8, 0x0 }, /* #18 */
    { 0x3c6783, 0x3c6717, 0x7e9d, 0x0296, 0x83f8, 0x0 }, /* #19 */
    { 0x176182, 0x176907, 0xa0d0, 0x76d8, 0xd608, 0x0 }, /* #20 */
    { 0x0e5953, 0x0e5186, 0x5225, 0xfffa, 0xadd4, 0x0 }, /* #21 */
    { 0x3b1e47, 0x3b1617, 0xc756, 0x14c0, 0x4d69, 0x0 }, /* #22 */
    { 0x3e0c17, 0x3e0c17, 0x8e3d, 0x657d, 0xd73f, 0x0 }, /* #23 */
    { 0x0b1ad2, 0x0b1a03, 0xdd3b, 0x75dc, 0x98a1, 0x0 }, /* #24 */
    { 0x0f6c83, 0x0f6403, 0x74f9, 0x09bf, 0x94c5, 0x0 }, /* #25 */
    { 0x177c52, 0x177413, 0x46cf, 0x1e23, 0xd754, 0x0 }, /* #26 */
    { 0x3a7513, 0x3a7512, 0x7922, 0x7970, 0x004d, 0x0 }, /* #27 */
    { 0x0f4a17, 0x0f4a17, 0xbb39, 0x5f96, 0xa45c, 0x0 }, /* #28 */
    { 0x1a78c3, 0x1a7896, 0x785b, 0x8bc9, 0x136d, 0x0 }, /* #29 */
    { 0x205f53, 0x205796, 0xb78c, 0xf1b2, 0x3a25, 0x0 }, /* #30 */
    { 0x334fc6, 0x334783, 0xc1d5, 0x9c6d, 0xda98, 0x0 }, /* #31 */
    { 0x3e1807, 0x3e1096, 0x7369, 0xf433, 0x80c9, 0x0 }, /* #32 */
    { 0x1b2217, 0x1b2206, 0x4788, 0x62fa, 0x1b71, 0x0 }, /* #33 */
    { 0x041ec3, 0x041693, 0xccdb, 0xa725, 0xda49, 0x0 }, /* #34 */
    { 0x3c2787, 0x3c2782, 0xb601, 0xf464, 0x3e62, 0x0 }, /* #35 */
    { 0x222283, 0x222203, 0xae66, 0x2719, 0x78b2, 0x0 }, /* #36 */
    { 0x1d1b57, 0x1d1393, 0xe92d, 0xde9d, 0xf56f, 0x0 }, /* #37 */
    { 0x190482, 0x190492, 0xa5ba, 0xbb13, 0x1559, 0x0 }, /* #38 */
    { 0x246a92, 0x246202, 0x58dc, 0x679e, 0x0ec2, 0x0 }, /* #39 */
    { 0x1039d6, 0x103917, 0x8913, 0x54e2, 0xcbcf, 0x0 }, /* #40 */
    { 0x171807, 0x171013, 0xbed6, 0x24d0, 0x65f9, 0x0 }, /* #41 */
    { 0x227d93, 0x227d82, 0x65a3, 0x870e, 0x216a, 0x0 }, /* #42 */
    { 0x143a42, 0x143a92, 0x7b5d, 0xd67a, 0x5b1d, 0x0 }, /* #43 */
    { 0x1e1242, 0x1e1a13, 0x8beb, 0x5b23, 0xcf38, 0x0 }, /* #44 */
    { 0x016893, 0x016017, 0xae72, 0x0e12, 0x5f9f, 0x0 }, /* #45 */
    { 0x2e3446, 0x2e3492, 0x023f, 0x8d89, 0x8b4a, 0x0 }, /* #46 */
    { 0x1b2906, 0x1b2107, 0x39fb, 0x111d, 0xd722, 0x0 }, /* #47 */
    { 0x0e6c16, 0x0e6407, 0x54b3, 0x075a, 0xb2a7, 0x0 }, /* #48 */
    { 0x357a53, 0x357296, 0x87fb, 0xa65a, 0x1e5e, 0x0 }, /* #49 */
    { 0x323d56, 0x323582, 0x2451, 0xfbab, 0xd75a, 0x0 }, /* #50 */
    { 0x253542, 0x253582, 0x8c34, 0x91a8, 0x0574, 0x0 }, /* #51 */
    { 0x3e56c7, 0x3e5e03, 0x8e0b, 0x39ef, 0xabe3, 0x0 }, /* #52 */
    { 0x0a7743, 0x0a7796, 0x33bf, 0xc2ff, 0x8f3f, 0x0 }, /* #53 */
    { 0x153792, 0x153712, 0x26c6, 0x6491, 0x3dcb, 0x0 }, /* #54 */
    { 0x2e1c97, 0x2e1413, 0x256c, 0x16d6, 0xf169, 0x0 }, /* #55 */
    { 0x225182, 0x225102, 0x5a31, 0x743d, 0x1a0c, 0x0 }, /* #56 */
    { 0x265716, 0x265707, 0x5428, 0x432e, 0xef06, 0x0 }, /* #57 */
    { 0x124012, 0x124096, 0x9e4e, 0xf24d, 0x53ff, 0x0 }, /* #58 */
    { 0x0e2b42, 0x0e2303, 0x71d4, 0x37f4, 0xc620, 0x0 }, /* #59 */
    { 0x3d3fd7, 0x3d3713, 0x3e6e, 0x191c, 0xdaad, 0x0 }, /* #60 */
    { 0x3e6c17, 0x3e6416, 0x2dce, 0x6b74, 0x3da5, 0x0 }, /* #61 */
    { 0x082946, 0x082907, 0xd986, 0x62ed, 0x8967, 0x0 }, /* #62 */
    { 0x1d2f17, 0x1d2787, 0x9014, 0x8cbd, 0xfca8, 0x0 }, /* #63 */
    { 0x3e6c92, 0x3e6492, 0x4c95, 0xd3a2, 0x870d, 0x0 }, /* #64 */
    { 0x0c4ec2, 0x0c4e07, 0x9e19, 0x784b, 0xda32, 0x0 }, /* #65 */
    { 0x0a6717, 0x0a6f86, 0x6806, 0xe47e, 0x7c77, 0x0 }, /* #66 */
    { 0x020dc7, 0x020587, 0xac04, 0xa728, 0xfb23, 0x0 }, /* #67 */
    { 0x120a12, 0x120287, 0xbfc4, 0xa84e, 0xe88a, 0x0 }, /* #68 */
    { 0x321652, 0x321603, 0x68d2, 0x4808, 0xdf36, 0x0 }, /* #69 */
    { 0x117c02, 0x117c86, 0x6e73, 0xcb09, 0x5c96, 0x0 }, /* #70 */
    { 0x045f16, 0x045792, 0x02cd, 0xe768, 0xe49b, 0x0 }, /* #71 */
    { 0x172316, 0x172b17, 0x9c59, 0x3c48, 0x9fef, 0x0 }, /* #72 */
    { 0x261082, 0x261097, 0xfbbb, 0xef65, 0xf3aa, 0x0 }, /* #73 */
    { 0x381702, 0x381783, 0xcae3, 0xaa75, 0xdf92, 0x0 }, /* #74 */
    { 0x0a2783, 0x0a2f92, 0x4704, 0x8d20, 0x461b, 0x0 }, /* #75 */
    { 0x047182, 0x047117, 0xa928, 0x1ba3, 0x727b, 0x0 }, /* #76 */
    { 0x1563c7, 0x156b03, 0xce62, 0x60ef, 0x928c, 0x0 }, /* #77 */
    { 0x3176c3, 0x317e03, 0xe209, 0x737f, 0x9175, 0x0 }, /* #78 */
    { 0x310c52, 0x310403, 0xd4d3, 0x5329, 0x7e56, 0x0 }, /* #79 */
    { 0x284f12, 0x284f92, 0x689b, 0xe413, 0x7b78, 0x0 }, /* #80 */
    { 0x116a83, 0x116a82, 0x6eec, 0xc7df, 0x58f2, 0x0 }, /* #81 */
    { 0x1202c6, 0x120206, 0x1675, 0x450c, 0x2e97, 0x0 }, /* #82 */
    { 0x263d07, 0x263507, 0xfd9a, 0x508b, 0x52f0, 0x0 }, /* #83 */
    { 0x396b92, 0x396b86, 0x7c50, 0xa3eb, 0x279b, 0x0 }, /* #84 */
    { 0x2c1813, 0x2c1082, 0xa0a8, 0xc93b, 0x2892, 0x0 }, /* #85 */
    { 0x0f48c6, 0x0f4082, 0x8eb9, 0xc14a, 0x3291, 0x0 }, /* #86 */
    { 0x042883, 0x042082, 0xedc5, 0xfe7f, 0x10b9, 0x0 }, /* #87 */
    { 0x0e0302, 0x0e0b17, 0x9a2e, 0x7818, 0xddea, 0x0 }, /* #88 */
    { 0x361602, 0x361687, 0xfa41, 0xb365, 0xb924, 0x0 }, /* #89 */
    { 0x362cc6, 0x362417, 0xca6f, 0x3644, 0x6bd5, 0x0 }, /* #90 */
    { 0x0920c2, 0x092092, 0x896e, 0xbb40, 0x31d2, 0x0 }, /* #91 */
    { 0x233403, 0x233c13, 0x808f, 0x354f, 0xb4bf, 0x0 }, /* #92 */
    { 0x180453, 0x180483, 0xfea5, 0xf968, 0xfac2, 0x0 }, /* #93 */
    { 0x3623c6, 0x362302, 0x215a, 0x450b, 0x23b1, 0x0 }, /* #94 */
    { 0x150cc2, 0x150c17, 0xaba9, 0x4205, 0x965c, 0x0 }, /* #95 */
};
uint32_t const g_cTests_adc_u16_locked = RT_ELEMENTS(g_aTests_adc_u16_locked);

BINU16_TEST_T const g_aTests_sub_u16[] =
{
    { 0x2d2417, 0x2d2446, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x394007, 0x394046, 0x0000, 0x0000, 0x0000, 0x0 }, /* #1 */
    { 0x203c83, 0x203446, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x2a6943, 0x2a6146, 0x0000, 0x0000, 0x0000, 0x0 }, /* #3 */
    { 0x295882, 0x295046, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x2024c7, 0x202446, 0x0000, 0x0000, 0x0000, 0x0 }, /* #5 */
    { 0x256717, 0x256706, 0x24e2, 0x24e2, 0x0000, 0x0 }, /* #6 */
    { 0x047507, 0x047582, 0xa861, 0xa861, 0x0000, 0x0 }, /* #7 */
    { 0x0b2556, 0x0b2506, 0x34af, 0x34af, 0x0000, 0x0 }, /* #8 */
    { 0x280e83, 0x280602, 0x758a, 0x758a, 0x0000, 0x0 }, /* #9 */
    { 0x371e13, 0x371686, 0xf84d, 0xf84d, 0x0000, 0x0 }, /* #10 */
    { 0x283f06, 0x283786, 0xc2fc, 0xc2fc, 0x0000, 0x0 }, /* #11 */
    { 0x1b0542, 0x1b0516, 0x14e6, 0x0e18, 0x06ce, 0x0 }, /* #12 */
    { 0x237e92, 0x237612, 0x952b, 0x101f, 0x850c, 0x0 }, /* #13 */
    { 0x0a6b46, 0x0a6383, 0x0a6d, 0xa7c8, 0x62a5, 0x0 }, /* #14 */
    { 0x215656, 0x215683, 0x94d6, 0xb364, 0xe172, 0x0 }, /* #15 */
    { 0x320c12, 0x320487, 0x19fa, 0xfb55, 0x1ea5, 0x0 }, /* #16 */
    { 0x3123c2, 0x312316, 0x043b, 0x00af, 0x038c, 0x0 }, /* #17 */
    { 0x0008d6, 0x000006, 0x7208, 0x5848, 0x19c0, 0x0 }, /* #18 */
    { 0x2b6a46, 0x2b6212, 0x7633, 0x37bc, 0x3e77, 0x0 }, /* #19 */
    { 0x0f4003, 0x0f4097, 0xa244, 0xf048, 0xb1fc, 0x0 }, /* #20 */
    { 0x295d87, 0x295512, 0xdb0e, 0x194f, 0xc1bf, 0x0 }, /* #21 */
    { 0x221997, 0x221186, 0xc37f, 0xa7dd, 0x1ba2, 0x0 }, /* #22 */
    { 0x3a2f92, 0x3a2702, 0x40fc, 0x2483, 0x1c79, 0x0 }, /* #23 */
    { 0x367003, 0x367097, 0x2172, 0xd093, 0x50df, 0x0 }, /* #24 */
    { 0x242e02, 0x242e02, 0xa6ed, 0x4e2c, 0x58c1, 0x0 }, /* #25 */
    { 0x384853, 0x384883, 0x392e, 0x85f1, 0xb33d, 0x0 }, /* #26 */
    { 0x187307, 0x187312, 0x9b51, 0x119e, 0x89b3, 0x0 }, /* #27 */
    { 0x145c46, 0x145497, 0xa621, 0xf644, 0xafdd, 0x0 }, /* #28 */
    { 0x192603, 0x192683, 0x855e, 0xcc0e, 0xb950, 0x0 }, /* #29 */
    { 0x1f67d7, 0x1f6706, 0x660d, 0x35db, 0x3032, 0x0 }, /* #30 */
    { 0x0528c2, 0x052802, 0x8e31, 0x13f1, 0x7a40, 0x0 }, /* #31 */
    { 0x2a22d6, 0x2a2a16, 0xba36, 0x64cf, 0x5567, 0x0 }, /* #32 */
    { 0x366252, 0x366297, 0x9bd2, 0xc7be, 0xd414, 0x0 }, /* #33 */
    { 0x3e6912, 0x3e6103, 0x4e9c, 0x617a, 0xed22, 0x0 }, /* #34 */
    { 0x115f52, 0x115707, 0x3c6a, 0x5417, 0xe853, 0x0 }, /* #35 */
    { 0x060717, 0x060702, 0xf37d, 0x5dd6, 0x95a7, 0x0 }, /* #36 */
    { 0x2e4f17, 0x2e4712, 0xe0cc, 0x316e, 0xaf5e, 0x0 }, /* #37 */
    { 0x051c83, 0x051416, 0xf593, 0x349c, 0xc0f7, 0x0 }, /* #38 */
    { 0x0438c7, 0x043016, 0x7450, 0x2c0f, 0x4841, 0x0 }, /* #39 */
    { 0x2b5742, 0x2b5717, 0x0952, 0x7935, 0x901d, 0x0 }, /* #40 */
    { 0x250356, 0x250b83, 0x31e6, 0xac04, 0x85e2, 0x0 }, /* #41 */
    { 0x2b01d3, 0x2b0116, 0xe4c2, 0x0adb, 0xd9e7, 0x0 }, /* #42 */
    { 0x242193, 0x242106, 0x601f, 0x3414, 0x2c0b, 0x0 }, /* #43 */
    { 0x216852, 0x216002, 0x518c, 0x2eda, 0x22b2, 0x0 }, /* #44 */
    { 0x183d16, 0x183587, 0x3015, 0xc511, 0x6b04, 0x0 }, /* #45 */
    { 0x043493, 0x043416, 0x1b70, 0x0fed, 0x0b83, 0x0 }, /* #46 */
    { 0x0d7343, 0x0d7383, 0xdb9f, 0xe3ad, 0xf7f2, 0x0 }, /* #47 */
    { 0x326752, 0x326792, 0xb2a1, 0x8c9e, 0x2603, 0x0 }, /* #48 */
    { 0x3e25c6, 0x3e2517, 0x2a83, 0x5656, 0xd42d, 0x0 }, /* #49 */
    { 0x3b3013, 0x3b3093, 0xcf52, 0xd71c, 0xf836, 0x0 }, /* #50 */
    { 0x0c4092, 0x0c4016, 0xcd26, 0x3147, 0x9bdf, 0x0 }, /* #51 */
    { 0x030793, 0x030786, 0xbba8, 0x9f63, 0x1c45, 0x0 }, /* #52 */
    { 0x393707, 0x393783, 0x2a1d, 0xfae9, 0x2f34, 0x0 }, /* #53 */
    { 0x1e0897, 0x1e0012, 0xa881, 0x0564, 0xa31d, 0x0 }, /* #54 */
    { 0x0e3d96, 0x0e3592, 0xe621, 0xadfb, 0x3826, 0x0 }, /* #55 */
    { 0x0f2593, 0x0f2506, 0xa40f, 0x1e2b, 0x85e4, 0x0 }, /* #56 */
    { 0x2a7297, 0x2a7293, 0x37ca, 0xf35e, 0x446c, 0x0 }, /* #57 */
    { 0x230a57, 0x230297, 0xa732, 0xe265, 0xc4cd, 0x0 }, /* #58 */
    { 0x3b4fd7, 0x3b4716, 0xe4e3, 0x09a5, 0xdb3e, 0x0 }, /* #59 */
    { 0x174897, 0x174012, 0xd242, 0x19e5, 0xb85d, 0x0 }, /* #60 */
    { 0x122592, 0x122593, 0x1df4, 0xe10d, 0x3ce7, 0x0 }, /* #61 */
    { 0x1f1292, 0x1f1206, 0xf30e, 0x2822, 0xcaec, 0x0 }, /* #62 */
    { 0x2e5447, 0x2e5412, 0x6204, 0x567a, 0x0b8a, 0x0 }, /* #63 */
    { 0x055252, 0x055282, 0xed8a, 0xa920, 0x446a, 0x0 }, /* #64 */
    { 0x2d1ed7, 0x2d1617, 0x42aa, 0x7a3c, 0xc86e, 0x0 }, /* #65 */
    { 0x287906, 0x287916, 0x916a, 0x7f0f, 0x125b, 0x0 }, /* #66 */
    { 0x363703, 0x363796, 0xc245, 0xb46f, 0x0dd6, 0x0 }, /* #67 */
    { 0x1a6503, 0x1a6516, 0xe9a4, 0x316c, 0xb838, 0x0 }, /* #68 */
    { 0x0c0156, 0x0c0916, 0xb5c6, 0x6188, 0x543e, 0x0 }, /* #69 */
    { 0x2161c2, 0x216993, 0x78a6, 0xd107, 0xa79f, 0x0 }, /* #70 */
    { 0x117887, 0x117093, 0x0050, 0xbb8c, 0x44c4, 0x0 }, /* #71 */
    { 0x3a3b82, 0x3a3397, 0xc3c9, 0xe9cf, 0xd9fa, 0x0 }, /* #72 */
    { 0x322a47, 0x322a12, 0x8c61, 0x2b6d, 0x60f4, 0x0 }, /* #73 */
    { 0x1866d7, 0x186616, 0x574c, 0x136f, 0x43dd, 0x0 }, /* #74 */
    { 0x213ed7, 0x213602, 0xfd9d, 0x0c1a, 0xf183, 0x0 }, /* #75 */
    { 0x146d56, 0x146583, 0x8e0d, 0xee04, 0xa009, 0x0 }, /* #76 */
    { 0x1152c7, 0x115286, 0xbd83, 0x9c41, 0x2142, 0x0 }, /* #77 */
    { 0x0c5553, 0x0c5d93, 0x7be2, 0xa823, 0xd3bf, 0x0 }, /* #78 */
    { 0x147a92, 0x147283, 0xc43f, 0xea64, 0xd9db, 0x0 }, /* #79 */
    { 0x090c97, 0x090486, 0xee2d, 0xadf0, 0x403d, 0x0 }, /* #80 */
    { 0x393f43, 0x393786, 0xb8ff, 0xb600, 0x02ff, 0x0 }, /* #81 */
    { 0x2e1047, 0x2e1087, 0xc5b5, 0xe560, 0xe055, 0x0 }, /* #82 */
    { 0x0b1997, 0x0b1102, 0xb8ca, 0x2d89, 0x8b41, 0x0 }, /* #83 */
    { 0x0a7f03, 0x0a7782, 0xf0c9, 0x9cc4, 0x5405, 0x0 }, /* #84 */
    { 0x2514c2, 0x251412, 0x6f3e, 0x5e2f, 0x110f, 0x0 }, /* #85 */
    { 0x192152, 0x192113, 0x20f8, 0x3b8a, 0xe56e, 0x0 }, /* #86 */
    { 0x241117, 0x241183, 0xa8d6, 0xedf1, 0xbae5, 0x0 }, /* #87 */
    { 0x2f1dd7, 0x2f1d97, 0x2810, 0x8659, 0xa1b7, 0x0 }, /* #88 */
    { 0x131897, 0x131086, 0xd0ed, 0x9f9a, 0x3153, 0x0 }, /* #89 */
    { 0x1a0557, 0x1a0d97, 0x6ab7, 0xdcd8, 0x8ddf, 0x0 }, /* #90 */
    { 0x1d16c6, 0x1d1602, 0x589e, 0x0ad6, 0x4dc8, 0x0 }, /* #91 */
    { 0x105587, 0x105516, 0x78f9, 0x449f, 0x345a, 0x0 }, /* #92 */
    { 0x174f96, 0x174793, 0x6216, 0xf438, 0x6dde, 0x0 }, /* #93 */
    { 0x002ac2, 0x002283, 0xace5, 0xd991, 0xd354, 0x0 }, /* #94 */
    { 0x243482, 0x243483, 0x497d, 0xe02c, 0x6951, 0x0 }, /* #95 */
};
uint32_t const g_cTests_sub_u16 = RT_ELEMENTS(g_aTests_sub_u16);

BINU16_TEST_T const g_aTests_sub_u16_locked[] =
{
    { 0x1d7c82, 0x1d7446, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x0a1653, 0x0a1646, 0x0000, 0x0000, 0x0000, 0x0 }, /* #1 */
    { 0x0418c2, 0x041046, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x0a0ac2, 0x0a0246, 0x0000, 0x0000, 0x0000, 0x0 }, /* #3 */
    { 0x162493, 0x162446, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x0b7683, 0x0b7646, 0x0000, 0x0000, 0x0000, 0x0 }, /* #5 */
    { 0x3d1ac6, 0x3d1202, 0x7240, 0x7240, 0x0000, 0x0 }, /* #6 */
    { 0x387f56, 0x387786, 0xf24e, 0xf24e, 0x0000, 0x0 }, /* #7 */
    { 0x3d6046, 0x3d6006, 0x38f6, 0x38f6, 0x0000, 0x0 }, /* #8 */
    { 0x067106, 0x067102, 0x3de0, 0x3de0, 0x0000, 0x0 }, /* #9 */
    { 0x305507, 0x305506, 0x66a9, 0x66a9, 0x0000, 0x0 }, /* #10 */
    { 0x312553, 0x312502, 0x3e2c, 0x3e2c, 0x0000, 0x0 }, /* #11 */
    { 0x284782, 0x284702, 0x513b, 0x4d6b, 0x03d0, 0x0 }, /* #12 */
    { 0x1a0386, 0x1a0317, 0x2bd8, 0x4adb, 0xe0fd, 0x0 }, /* #13 */
    { 0x191f52, 0x191797, 0x808b, 0xdedd, 0xa1ae, 0x0 }, /* #14 */
    { 0x0e3e97, 0x0e3686, 0xef0d, 0x9a00, 0x550d, 0x0 }, /* #15 */
    { 0x011bc6, 0x011387, 0x427a, 0xc360, 0x7f1a, 0x0 }, /* #16 */
    { 0x152192, 0x152107, 0x1f4a, 0x2ca5, 0xf2a5, 0x0 }, /* #17 */
    { 0x2429c7, 0x242912, 0xa728, 0x6e4c, 0x38dc, 0x0 }, /* #18 */
    { 0x0a7953, 0x0a7106, 0x60ec, 0x1eb4, 0x4238, 0x0 }, /* #19 */
    { 0x056b43, 0x056307, 0x120e, 0x1aa0, 0xf76e, 0x0 }, /* #20 */
    { 0x211057, 0x211002, 0x4e5e, 0x4b26, 0x0338, 0x0 }, /* #21 */
    { 0x253c93, 0x253406, 0xd098, 0x1290, 0xbe08, 0x0 }, /* #22 */
    { 0x3c0a43, 0x3c0a93, 0x2be6, 0x983b, 0x93ab, 0x0 }, /* #23 */
    { 0x0c3103, 0x0c3106, 0x521d, 0x3205, 0x2018, 0x0 }, /* #24 */
    { 0x024456, 0x024416, 0x38a4, 0x2a56, 0x0e4e, 0x0 }, /* #25 */
    { 0x3565c2, 0x356d83, 0x2429, 0x8786, 0x9ca3, 0x0 }, /* #26 */
    { 0x366fc2, 0x366717, 0x0d75, 0x2dff, 0xdf76, 0x0 }, /* #27 */
    { 0x0c7712, 0x0c7783, 0x03bb, 0xc3a7, 0x4014, 0x0 }, /* #28 */
    { 0x1239c3, 0x123183, 0x17bc, 0x9a25, 0x7d97, 0x0 }, /* #29 */
    { 0x272a87, 0x272292, 0xf464, 0xeb19, 0x094b, 0x0 }, /* #30 */
    { 0x0b4b12, 0x0b4396, 0xc4b7, 0xc37b, 0x013c, 0x0 }, /* #31 */
    { 0x0d65c2, 0x0d6516, 0xe5b1, 0x3ad4, 0xaadd, 0x0 }, /* #32 */
    { 0x3044c6, 0x304c06, 0x914f, 0x361e, 0x5b31, 0x0 }, /* #33 */
    { 0x2125d3, 0x212582, 0xeebe, 0xaf29, 0x3f95, 0x0 }, /* #34 */
    { 0x1e7316, 0x1e7b06, 0xb87a, 0x6c53, 0x4c27, 0x0 }, /* #35 */
    { 0x0b7f16, 0x0b7f02, 0xb75e, 0x6d19, 0x4a45, 0x0 }, /* #36 */
    { 0x302c93, 0x302402, 0xa8cf, 0x0a15, 0x9eba, 0x0 }, /* #37 */
    { 0x324096, 0x324082, 0x9717, 0x90c4, 0x0653, 0x0 }, /* #38 */
    { 0x3a5302, 0x3a5312, 0x54f2, 0x40d3, 0x141f, 0x0 }, /* #39 */
    { 0x373a93, 0x373a12, 0xa003, 0x554c, 0x4ab7, 0x0 }, /* #40 */
    { 0x310503, 0x310597, 0xd896, 0xea2e, 0xee68, 0x0 }, /* #41 */
    { 0x1c06c2, 0x1c0e06, 0xaf19, 0x4635, 0x68e4, 0x0 }, /* #42 */
    { 0x3034d7, 0x303402, 0xf846, 0x21c1, 0xd685, 0x0 }, /* #43 */
    { 0x1776d6, 0x177693, 0xf4c7, 0xfe49, 0xf67e, 0x0 }, /* #44 */
    { 0x2f2082, 0x2f2012, 0x7b21, 0x5fdc, 0x1b45, 0x0 }, /* #45 */
    { 0x176097, 0x176012, 0x6a44, 0x4bba, 0x1e8a, 0x0 }, /* #46 */
    { 0x3f0807, 0x3f0002, 0xe956, 0x6276, 0x86e0, 0x0 }, /* #47 */
    { 0x157b92, 0x157307, 0x11b4, 0x5f30, 0xb284, 0x0 }, /* #48 */
    { 0x0e1842, 0x0e1012, 0xbadb, 0x13ce, 0xa70d, 0x0 }, /* #49 */
    { 0x1b15d2, 0x1b1d83, 0x4c8d, 0x9f7a, 0xad13, 0x0 }, /* #50 */
    { 0x0507c7, 0x050786, 0xfabf, 0xaffa, 0x4ac5, 0x0 }, /* #51 */
    { 0x0c0a03, 0x0c0286, 0xfdea, 0xcb65, 0x3285, 0x0 }, /* #52 */
    { 0x193c46, 0x193402, 0xc9ba, 0x3991, 0x9029, 0x0 }, /* #53 */
    { 0x0b1657, 0x0b1682, 0xdff4, 0x9ea2, 0x4152, 0x0 }, /* #54 */
    { 0x355d82, 0x355597, 0xc5a0, 0xfcff, 0xc8a1, 0x0 }, /* #55 */
    { 0x151613, 0x151612, 0xe7c2, 0x1cbf, 0xcb03, 0x0 }, /* #56 */
    { 0x0a6617, 0x0a6686, 0xbea7, 0xb524, 0x0983, 0x0 }, /* #57 */
    { 0x346dd6, 0x346587, 0x3ab7, 0xbb36, 0x7f81, 0x0 }, /* #58 */
    { 0x1e6502, 0x1e6517, 0x2a86, 0x3e39, 0xec4d, 0x0 }, /* #59 */
    { 0x322586, 0x322587, 0xbd8c, 0xdec5, 0xdec7, 0x0 }, /* #60 */
    { 0x110587, 0x110506, 0xc457, 0x2611, 0x9e46, 0x0 }, /* #61 */
    { 0x2b4507, 0x2b4506, 0xf80a, 0x3ac3, 0xbd47, 0x0 }, /* #62 */
    { 0x375c56, 0x375c12, 0xba62, 0x62fe, 0x5764, 0x0 }, /* #63 */
    { 0x0f0d52, 0x0f0586, 0xe9ea, 0xa963, 0x4087, 0x0 }, /* #64 */
    { 0x066817, 0x066012, 0x34b4, 0x1e0b, 0x16a9, 0x0 }, /* #65 */
    { 0x391c06, 0x391416, 0x4f33, 0x0784, 0x47af, 0x0 }, /* #66 */
    { 0x095716, 0x095707, 0x37ea, 0x38ca, 0xff20, 0x0 }, /* #67 */
    { 0x1c2982, 0x1c2193, 0x8f53, 0xd11f, 0xbe34, 0x0 }, /* #68 */
    { 0x345497, 0x345486, 0xeabc, 0xd1eb, 0x18d1, 0x0 }, /* #69 */
    { 0x0773d2, 0x077313, 0x1670, 0x72cb, 0xa3a5, 0x0 }, /* #70 */
    { 0x321903, 0x321993, 0x3e21, 0xa3dc, 0x9a45, 0x0 }, /* #71 */
    { 0x3a24c2, 0x3a2c12, 0xd300, 0x653b, 0x6dc5, 0x0 }, /* #72 */
    { 0x065a56, 0x065283, 0xed0e, 0xee89, 0xfe85, 0x0 }, /* #73 */
    { 0x1e5d06, 0x1e5593, 0xc6e7, 0xf5cd, 0xd11a, 0x0 }, /* #74 */
    { 0x2413d2, 0x241b06, 0xd47f, 0x60e1, 0x739e, 0x0 }, /* #75 */
    { 0x3c4817, 0x3c4897, 0x7bd2, 0xced8, 0xacfa, 0x0 }, /* #76 */
    { 0x097d82, 0x097513, 0x0513, 0x5349, 0xb1ca, 0x0 }, /* #77 */
    { 0x030bc3, 0x030307, 0x2dc2, 0x6bf0, 0xc1d2, 0x0 }, /* #78 */
    { 0x212a96, 0x212292, 0xea21, 0xbb08, 0x2f19, 0x0 }, /* #79 */
    { 0x2a7d16, 0x2a7502, 0x76f6, 0x2102, 0x55f4, 0x0 }, /* #80 */
    { 0x232897, 0x232897, 0x2684, 0x82bd, 0xa3c7, 0x0 }, /* #81 */
    { 0x2144c2, 0x214492, 0xf954, 0x97bf, 0x6195, 0x0 }, /* #82 */
    { 0x065653, 0x065616, 0xcf11, 0x13ff, 0xbb12, 0x0 }, /* #83 */
    { 0x006b82, 0x006386, 0xdc8e, 0xd0d8, 0x0bb6, 0x0 }, /* #84 */
    { 0x224306, 0x224b87, 0x737c, 0xe0aa, 0x92d2, 0x0 }, /* #85 */
    { 0x3e68d6, 0x3e6086, 0xb23f, 0xac95, 0x05aa, 0x0 }, /* #86 */
    { 0x2d1152, 0x2d1912, 0xa505, 0x78b9, 0x2c4c, 0x0 }, /* #87 */
    { 0x3e2153, 0x3e2102, 0x1dbc, 0x13ec, 0x09d0, 0x0 }, /* #88 */
    { 0x2003c7, 0x200307, 0x05a5, 0x2912, 0xdc93, 0x0 }, /* #89 */
    { 0x1853d3, 0x185317, 0x2d12, 0x2f03, 0xfe0f, 0x0 }, /* #90 */
    { 0x030286, 0x030206, 0x4ba8, 0x1ba5, 0x3003, 0x0 }, /* #91 */
    { 0x2e08c2, 0x2e0893, 0x4ec5, 0x962f, 0xb896, 0x0 }, /* #92 */
    { 0x2a1d83, 0x2a1d93, 0x1076, 0x81ae, 0x8ec8, 0x0 }, /* #93 */
    { 0x0b3f56, 0x0b3716, 0xe8d0, 0x481e, 0xa0b2, 0x0 }, /* #94 */
    { 0x017556, 0x017512, 0x3798, 0x1c5b, 0x1b3d, 0x0 }, /* #95 */
};
uint32_t const g_cTests_sub_u16_locked = RT_ELEMENTS(g_aTests_sub_u16_locked);

BINU16_TEST_T const g_aTests_sbb_u16[] =
{
    { 0x0319d3, 0x031197, 0x0000, 0xffff, 0x0000, 0x0 }, /* #0 */
    { 0x3a37c7, 0x3a3797, 0x0000, 0xffff, 0x0000, 0x0 }, /* #1 */
    { 0x016d42, 0x016546, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x2d3443, 0x2d3497, 0x0000, 0xffff, 0x0000, 0x0 }, /* #3 */
    { 0x371102, 0x371146, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x3a0817, 0x3a0097, 0x0000, 0xffff, 0x0000, 0x0 }, /* #5 */
    { 0x2c7717, 0x2c7702, 0x5177, 0x5176, 0x0000, 0x0 }, /* #6 */
    { 0x273207, 0x273202, 0x0f27, 0x0f26, 0x0000, 0x0 }, /* #7 */
    { 0x051a12, 0x051282, 0xd8a8, 0xd8a8, 0x0000, 0x0 }, /* #8 */
    { 0x3f2587, 0x3f2582, 0xcc59, 0xcc58, 0x0000, 0x0 }, /* #9 */
    { 0x236607, 0x236602, 0x2aa3, 0x2aa2, 0x0000, 0x0 }, /* #10 */
    { 0x0a5a93, 0x0a5206, 0x3a6a, 0x3a69, 0x0000, 0x0 }, /* #11 */
    { 0x065502, 0x065593, 0x8b69, 0xad0d, 0xde5c, 0x0 }, /* #12 */
    { 0x080206, 0x080202, 0xf9e8, 0x31f7, 0xc7f1, 0x0 }, /* #13 */
    { 0x2f6953, 0x2f6997, 0x7fc6, 0xfee7, 0x80de, 0x0 }, /* #14 */
    { 0x3408d7, 0x340017, 0x0c50, 0x5f41, 0xad0e, 0x0 }, /* #15 */
    { 0x2a69d6, 0x2a6912, 0x80d9, 0x44ce, 0x3c0b, 0x0 }, /* #16 */
    { 0x367fc2, 0x367f12, 0xbc03, 0x5746, 0x64bd, 0x0 }, /* #17 */
    { 0x2e7ad6, 0x2e7216, 0xe2a1, 0x4d4e, 0x9553, 0x0 }, /* #18 */
    { 0x292042, 0x292812, 0xacd0, 0x58c4, 0x540c, 0x0 }, /* #19 */
    { 0x3a5987, 0x3a5906, 0xc17f, 0x540a, 0x6d74, 0x0 }, /* #20 */
    { 0x3545c7, 0x354503, 0x3e6e, 0x52a7, 0xebc6, 0x0 }, /* #21 */
    { 0x300a96, 0x300206, 0x6018, 0x4c93, 0x1385, 0x0 }, /* #22 */
    { 0x0f60d7, 0x0f6097, 0x0934, 0xd896, 0x309d, 0x0 }, /* #23 */
    { 0x2a13d3, 0x2a1397, 0x46c2, 0xf36f, 0x5352, 0x0 }, /* #24 */
    { 0x241ed7, 0x241606, 0xf44f, 0x1248, 0xe206, 0x0 }, /* #25 */
    { 0x0a0783, 0x0a0713, 0x5020, 0x6362, 0xecbd, 0x0 }, /* #26 */
    { 0x2c76d2, 0x2c7607, 0x6a3f, 0x785a, 0xf1e5, 0x0 }, /* #27 */
    { 0x2b7616, 0x2b7686, 0xdf57, 0xc881, 0x16d6, 0x0 }, /* #28 */
    { 0x045e83, 0x045603, 0x0232, 0x30b0, 0xd181, 0x0 }, /* #29 */
    { 0x083f43, 0x083712, 0xb194, 0x2fae, 0x81e5, 0x0 }, /* #30 */
    { 0x0d5093, 0x0d5093, 0x4802, 0xc80e, 0x7ff3, 0x0 }, /* #31 */
    { 0x370442, 0x370412, 0x5b37, 0x150e, 0x4629, 0x0 }, /* #32 */
    { 0x0717d3, 0x071717, 0x2133, 0x4136, 0xdffc, 0x0 }, /* #33 */
    { 0x137686, 0x137616, 0xd0cb, 0x336c, 0x9d5f, 0x0 }, /* #34 */
    { 0x0c1116, 0x0c1197, 0x3257, 0xffb8, 0x329f, 0x0 }, /* #35 */
    { 0x055143, 0x055107, 0x17cd, 0x6ea9, 0xa923, 0x0 }, /* #36 */
    { 0x307e02, 0x307683, 0x8aec, 0xbaba, 0xd032, 0x0 }, /* #37 */
    { 0x124143, 0x124196, 0x8bd5, 0x8888, 0x034c, 0x0 }, /* #38 */
    { 0x2c78d2, 0x2c7082, 0xa845, 0x9785, 0x10c0, 0x0 }, /* #39 */
    { 0x1755d7, 0x175596, 0xbf43, 0x924b, 0x2cf7, 0x0 }, /* #40 */
    { 0x3e7d83, 0x3e7d87, 0x74bb, 0xa105, 0xd3b5, 0x0 }, /* #41 */
    { 0x275887, 0x275007, 0x183e, 0x60d7, 0xb766, 0x0 }, /* #42 */
    { 0x3c2212, 0x3c2202, 0xca45, 0x3431, 0x9614, 0x0 }, /* #43 */
    { 0x250812, 0x250087, 0x4137, 0xe542, 0x5bf5, 0x0 }, /* #44 */
    { 0x0a3f52, 0x0a3712, 0x478e, 0x108f, 0x36ff, 0x0 }, /* #45 */
    { 0x2c4a56, 0x2c4297, 0x3b31, 0xf203, 0x492e, 0x0 }, /* #46 */
    { 0x2f3997, 0x2f3116, 0xf87c, 0x274e, 0xd12d, 0x0 }, /* #47 */
    { 0x286146, 0x286997, 0x3738, 0xafdb, 0x875d, 0x0 }, /* #48 */
    { 0x0e1c07, 0x0e1c12, 0x9051, 0x29e9, 0x6667, 0x0 }, /* #49 */
    { 0x0c03d6, 0x0c0386, 0xd2cd, 0xabf0, 0x26dd, 0x0 }, /* #50 */
    { 0x1d7a13, 0x1d7203, 0x3b6f, 0x5ada, 0xe094, 0x0 }, /* #51 */
    { 0x262117, 0x262196, 0x99e1, 0x8e8d, 0x0b53, 0x0 }, /* #52 */
    { 0x204e96, 0x204617, 0x1264, 0x458e, 0xccd6, 0x0 }, /* #53 */
    { 0x1f0f43, 0x1f0712, 0x7dd1, 0x09ec, 0x73e4, 0x0 }, /* #54 */
    { 0x1e01d6, 0x1e0112, 0x6aa1, 0x3f04, 0x2b9d, 0x0 }, /* #55 */
    { 0x3b7496, 0x3b7492, 0xa4a3, 0x93ab, 0x10f8, 0x0 }, /* #56 */
    { 0x1d6407, 0x1d6483, 0x0de7, 0xdb54, 0x3292, 0x0 }, /* #57 */
    { 0x195713, 0x195796, 0xaead, 0x941d, 0x1a8f, 0x0 }, /* #58 */
    { 0x124246, 0x124203, 0x27fb, 0x5780, 0xd07b, 0x0 }, /* #59 */
    { 0x061692, 0x061e16, 0x9522, 0x7d06, 0x181c, 0x0 }, /* #60 */
    { 0x0378c2, 0x037002, 0xe9dc, 0x67d9, 0x8203, 0x0 }, /* #61 */
    { 0x0e30d6, 0x0e3806, 0xc73d, 0x529c, 0x74a1, 0x0 }, /* #62 */
    { 0x172546, 0x172583, 0x01af, 0x9215, 0x6f9a, 0x0 }, /* #63 */
    { 0x2622c2, 0x262a83, 0x314b, 0x9bc2, 0x9589, 0x0 }, /* #64 */
    { 0x2d2313, 0x2d2313, 0x056a, 0x334f, 0xd21a, 0x0 }, /* #65 */
    { 0x3e15c7, 0x3e1586, 0xba3c, 0xaaa9, 0x0f92, 0x0 }, /* #66 */
    { 0x110457, 0x110402, 0x875c, 0x05a7, 0x81b4, 0x0 }, /* #67 */
    { 0x3a0557, 0x3a0d87, 0x754e, 0xe4e7, 0x9066, 0x0 }, /* #68 */
    { 0x151ec2, 0x151693, 0x2287, 0xe07c, 0x420b, 0x0 }, /* #69 */
    { 0x033756, 0x033f16, 0x9c55, 0x4b8d, 0x50c8, 0x0 }, /* #70 */
    { 0x142956, 0x142103, 0x0227, 0x6c10, 0x9617, 0x0 }, /* #71 */
    { 0x374443, 0x374487, 0x8efc, 0xa678, 0xe883, 0x0 }, /* #72 */
    { 0x126253, 0x126212, 0xf5b6, 0x07ce, 0xede7, 0x0 }, /* #73 */
    { 0x3e6c83, 0x3e6483, 0x269a, 0xce58, 0x5841, 0x0 }, /* #74 */
    { 0x183d82, 0x183d16, 0xb708, 0x44af, 0x7259, 0x0 }, /* #75 */
    { 0x230316, 0x230387, 0x97af, 0xa7c9, 0xefe6, 0x0 }, /* #76 */
    { 0x3e2952, 0x3e2102, 0xff86, 0x2fb0, 0xcfd6, 0x0 }, /* #77 */
    { 0x006516, 0x006d83, 0x6bcd, 0xa204, 0xc9c9, 0x0 }, /* #78 */
    { 0x0e4c16, 0x0e4402, 0x3109, 0x0dc8, 0x2341, 0x0 }, /* #79 */
    { 0x0b05c3, 0x0b0d12, 0x9a54, 0x3375, 0x66de, 0x0 }, /* #80 */
    { 0x173d52, 0x173586, 0xae2c, 0xa317, 0x0b15, 0x0 }, /* #81 */
    { 0x1a7196, 0x1a7187, 0xd338, 0xe024, 0xf314, 0x0 }, /* #82 */
    { 0x2d2857, 0x2d2006, 0x5d87, 0x4d44, 0x1042, 0x0 }, /* #83 */
    { 0x3537d6, 0x353f06, 0xd2c0, 0x5790, 0x7b30, 0x0 }, /* #84 */
    { 0x101757, 0x101f12, 0xd232, 0x53f2, 0x7e3f, 0x0 }, /* #85 */
    { 0x092d96, 0x092d16, 0xae43, 0x4ad4, 0x636f, 0x0 }, /* #86 */
    { 0x101d53, 0x101586, 0xf519, 0xc048, 0x34d0, 0x0 }, /* #87 */
    { 0x384217, 0x384a83, 0x687d, 0xbba1, 0xacdb, 0x0 }, /* #88 */
    { 0x381916, 0x381117, 0x3023, 0x3d6f, 0xf2b4, 0x0 }, /* #89 */
    { 0x275142, 0x275916, 0xc792, 0x4c3c, 0x7b56, 0x0 }, /* #90 */
    { 0x345b86, 0x345302, 0x32ed, 0x0cf7, 0x25f6, 0x0 }, /* #91 */
    { 0x324b57, 0x324306, 0x5378, 0x3953, 0x1a24, 0x0 }, /* #92 */
    { 0x093583, 0x093583, 0x8e86, 0xf275, 0x9c10, 0x0 }, /* #93 */
    { 0x034147, 0x034192, 0xc442, 0xc02f, 0x0412, 0x0 }, /* #94 */
    { 0x0d1856, 0x0d1083, 0x62df, 0xee8a, 0x7455, 0x0 }, /* #95 */
};
uint32_t const g_cTests_sbb_u16 = RT_ELEMENTS(g_aTests_sbb_u16);

BINU16_TEST_T const g_aTests_sbb_u16_locked[] =
{
    { 0x024a43, 0x024297, 0x0000, 0xffff, 0x0000, 0x0 }, /* #0 */
    { 0x114207, 0x114297, 0x0000, 0xffff, 0x0000, 0x0 }, /* #1 */
    { 0x2a70d3, 0x2a7097, 0x0000, 0xffff, 0x0000, 0x0 }, /* #2 */
    { 0x1039d3, 0x103197, 0x0000, 0xffff, 0x0000, 0x0 }, /* #3 */
    { 0x140b53, 0x140397, 0x0000, 0xffff, 0x0000, 0x0 }, /* #4 */
    { 0x107ad3, 0x107297, 0x0000, 0xffff, 0x0000, 0x0 }, /* #5 */
    { 0x1a3d92, 0x1a3502, 0x111f, 0x111f, 0x0000, 0x0 }, /* #6 */
    { 0x0c7f57, 0x0c7702, 0x751a, 0x7519, 0x0000, 0x0 }, /* #7 */
    { 0x0973d3, 0x097382, 0xcd1d, 0xcd1c, 0x0000, 0x0 }, /* #8 */
    { 0x044cd3, 0x044402, 0x1be4, 0x1be3, 0x0000, 0x0 }, /* #9 */
    { 0x1c7a97, 0x1c7206, 0x1225, 0x1224, 0x0000, 0x0 }, /* #10 */
    { 0x000992, 0x000182, 0x9e58, 0x9e58, 0x0000, 0x0 }, /* #11 */
    { 0x3a2243, 0x3a2206, 0x6c58, 0x6372, 0x08e5, 0x0 }, /* #12 */
    { 0x0b6396, 0x0b6383, 0xa2aa, 0xaea2, 0xf408, 0x0 }, /* #13 */
    { 0x0d3896, 0x0d3092, 0xa710, 0xa038, 0x06d8, 0x0 }, /* #14 */
    { 0x256e12, 0x256e97, 0x7a69, 0xa3aa, 0xd6bf, 0x0 }, /* #15 */
    { 0x2170c2, 0x217087, 0x0eeb, 0x9287, 0x7c64, 0x0 }, /* #16 */
    { 0x145ad3, 0x145283, 0x0b4e, 0xff98, 0x0bb5, 0x0 }, /* #17 */
    { 0x2d7113, 0x2d7993, 0x7fb5, 0xbf2a, 0xc08a, 0x0 }, /* #18 */
    { 0x2931d6, 0x293997, 0x5842, 0x9d8e, 0xbab4, 0x0 }, /* #19 */
    { 0x376342, 0x376317, 0x0f21, 0x440f, 0xcb12, 0x0 }, /* #20 */
    { 0x3d32d3, 0x3d3287, 0xb1ea, 0xd1e1, 0xe008, 0x0 }, /* #21 */
    { 0x142393, 0x142312, 0xe773, 0x0b83, 0xdbef, 0x0 }, /* #22 */
    { 0x1d7a46, 0x1d7206, 0x3169, 0x28f6, 0x0873, 0x0 }, /* #23 */
    { 0x220683, 0x220616, 0x4be8, 0x165a, 0x358d, 0x0 }, /* #24 */
    { 0x001c47, 0x001416, 0xf772, 0x3339, 0xc438, 0x0 }, /* #25 */
    { 0x1837d3, 0x183796, 0xfb22, 0xb9b2, 0x416f, 0x0 }, /* #26 */
    { 0x1722c6, 0x172283, 0xb8a6, 0xc075, 0xf831, 0x0 }, /* #27 */
    { 0x1f7b47, 0x1f7383, 0x3e02, 0xf351, 0x4ab0, 0x0 }, /* #28 */
    { 0x157413, 0x157487, 0x845f, 0x8f0a, 0xf554, 0x0 }, /* #29 */
    { 0x145486, 0x145496, 0xf806, 0xcb9f, 0x2c67, 0x0 }, /* #30 */
    { 0x2a0482, 0x2a0497, 0x1bd8, 0xd0ff, 0x4ad9, 0x0 }, /* #31 */
    { 0x254897, 0x254093, 0x2838, 0xc9ad, 0x5e8a, 0x0 }, /* #32 */
    { 0x221283, 0x221206, 0xc7fc, 0x1d14, 0xaae7, 0x0 }, /* #33 */
    { 0x0e2e03, 0x0e2e97, 0x40d7, 0x8b28, 0xb5ae, 0x0 }, /* #34 */
    { 0x284c92, 0x284407, 0x6806, 0x79f3, 0xee13, 0x0 }, /* #35 */
    { 0x1d6896, 0x1d6006, 0x535a, 0x3112, 0x2248, 0x0 }, /* #36 */
    { 0x2c2202, 0x2c2213, 0x3f10, 0x43b6, 0xfb5a, 0x0 }, /* #37 */
    { 0x3a5a57, 0x3a5a12, 0x8895, 0x50fb, 0x3799, 0x0 }, /* #38 */
    { 0x3a4207, 0x3a4203, 0x357d, 0x4467, 0xf115, 0x0 }, /* #39 */
    { 0x0a68c2, 0x0a6087, 0x1724, 0xae93, 0x6891, 0x0 }, /* #40 */
    { 0x2d0686, 0x2d0693, 0xc54a, 0xcadc, 0xfa6e, 0x0 }, /* #41 */
    { 0x122e97, 0x122e02, 0x841d, 0x5f26, 0x24f6, 0x0 }, /* #42 */
    { 0x1a7e13, 0x1a7693, 0xbf91, 0xe8d3, 0xd6bd, 0x0 }, /* #43 */
    { 0x072817, 0x072016, 0x6e14, 0x3406, 0x3a0d, 0x0 }, /* #44 */
    { 0x3d02d3, 0x3d0a16, 0x8240, 0x2dd1, 0x546e, 0x0 }, /* #45 */
    { 0x2c2f82, 0x2c2783, 0xb435, 0xed75, 0xc6c0, 0x0 }, /* #46 */
    { 0x244cc7, 0x244c83, 0x45af, 0x96cd, 0xaee1, 0x0 }, /* #47 */
    { 0x174c03, 0x174412, 0x5084, 0x38fb, 0x1788, 0x0 }, /* #48 */
    { 0x3d5dc7, 0x3d5583, 0xa72b, 0xf231, 0xb4f9, 0x0 }, /* #49 */
    { 0x0d1646, 0x0d1613, 0x0e52, 0x472a, 0xc728, 0x0 }, /* #50 */
    { 0x286e96, 0x286e83, 0x493b, 0xc6c4, 0x8277, 0x0 }, /* #51 */
    { 0x0b0617, 0x0b0613, 0x0442, 0x5aa2, 0xa99f, 0x0 }, /* #52 */
    { 0x006c83, 0x006492, 0xf103, 0x8b0d, 0x65f5, 0x0 }, /* #53 */
    { 0x074957, 0x074117, 0x16f3, 0x70e7, 0xa60b, 0x0 }, /* #54 */
    { 0x1c6616, 0x1c6602, 0x7231, 0x3551, 0x3ce0, 0x0 }, /* #55 */
    { 0x2a20d6, 0x2a2006, 0xdbbc, 0x43a6, 0x9816, 0x0 }, /* #56 */
    { 0x3a5713, 0x3a5706, 0xd129, 0x23b1, 0xad77, 0x0 }, /* #57 */
    { 0x022542, 0x022d97, 0x5cb7, 0x9459, 0xc85e, 0x0 }, /* #58 */
    { 0x310286, 0x310286, 0xcda4, 0xa5d2, 0x27d2, 0x0 }, /* #59 */
    { 0x223d03, 0x223516, 0xcee1, 0x1c56, 0xb28a, 0x0 }, /* #60 */
    { 0x0635d3, 0x063513, 0x2cfd, 0x37ef, 0xf50d, 0x0 }, /* #61 */
    { 0x0e6c16, 0x0e6486, 0xf48a, 0xbc05, 0x3885, 0x0 }, /* #62 */
    { 0x3f7ec2, 0x3f7617, 0x1a57, 0x422d, 0xd82a, 0x0 }, /* #63 */
    { 0x2b6dd2, 0x2b6512, 0xff45, 0x2049, 0xdefc, 0x0 }, /* #64 */
    { 0x2127c7, 0x212f12, 0xd099, 0x6689, 0x6a0f, 0x0 }, /* #65 */
    { 0x1012d3, 0x101212, 0xa720, 0x22ad, 0x8472, 0x0 }, /* #66 */
    { 0x3318c7, 0x331806, 0x855d, 0x3b53, 0x4a09, 0x0 }, /* #67 */
    { 0x197083, 0x197897, 0x4a2c, 0xb88e, 0x919d, 0x0 }, /* #68 */
    { 0x3d7cc6, 0x3d7402, 0xeb29, 0x48a1, 0xa288, 0x0 }, /* #69 */
    { 0x1e0202, 0x1e0217, 0x7868, 0x7d9a, 0xface, 0x0 }, /* #70 */
    { 0x220983, 0x220987, 0x411d, 0xae56, 0x92c6, 0x0 }, /* #71 */
    { 0x0345d2, 0x034516, 0xc282, 0x1c03, 0xa67f, 0x0 }, /* #72 */
    { 0x3a56c3, 0x3a5692, 0xdc59, 0x9e6b, 0x3ded, 0x0 }, /* #73 */
    { 0x093487, 0x093482, 0xa73c, 0xa11a, 0x0621, 0x0 }, /* #74 */
    { 0x1f0247, 0x1f0a02, 0x9e76, 0x4a64, 0x5411, 0x0 }, /* #75 */
    { 0x1f3916, 0x1f3112, 0x2850, 0x0746, 0x210a, 0x0 }, /* #76 */
    { 0x223e52, 0x223612, 0x96d7, 0x032c, 0x93ab, 0x0 }, /* #77 */
    { 0x2e2b87, 0x2e2307, 0x1f31, 0x64a0, 0xba90, 0x0 }, /* #78 */
    { 0x0e3443, 0x0e3486, 0xe9ae, 0xd87d, 0x1130, 0x0 }, /* #79 */
    { 0x332206, 0x332217, 0x045c, 0x412e, 0xc32e, 0x0 }, /* #80 */
    { 0x161143, 0x161117, 0x1a45, 0x7a5f, 0x9fe5, 0x0 }, /* #81 */
    { 0x1d5bc2, 0x1d5303, 0x6b90, 0x6f40, 0xfc50, 0x0 }, /* #82 */
    { 0x073a52, 0x073a83, 0x6b07, 0x9420, 0xd6e7, 0x0 }, /* #83 */
    { 0x244c96, 0x244492, 0xbec1, 0xa21a, 0x1ca7, 0x0 }, /* #84 */
    { 0x0660d3, 0x066812, 0x8836, 0x22ab, 0x658a, 0x0 }, /* #85 */
    { 0x2c3e07, 0x2c3607, 0x30e2, 0x5f60, 0xd181, 0x0 }, /* #86 */
    { 0x083007, 0x083087, 0x1125, 0xce71, 0x42b3, 0x0 }, /* #87 */
    { 0x1877d3, 0x187716, 0x6fc1, 0x3566, 0x3a5a, 0x0 }, /* #88 */
    { 0x261106, 0x261906, 0xb60f, 0x6dd2, 0x483d, 0x0 }, /* #89 */
    { 0x297e47, 0x297607, 0x003d, 0x7733, 0x8909, 0x0 }, /* #90 */
    { 0x0768c3, 0x076806, 0xa92d, 0x78d4, 0x3058, 0x0 }, /* #91 */
    { 0x105fd7, 0x105783, 0x115d, 0xd545, 0x3c17, 0x0 }, /* #92 */
    { 0x1815c7, 0x181587, 0x53e3, 0xfe41, 0x55a1, 0x0 }, /* #93 */
    { 0x055606, 0x055603, 0x0a8f, 0x42bc, 0xc7d3, 0x0 }, /* #94 */
    { 0x2c0c17, 0x2c0416, 0x3574, 0x0e39, 0x273a, 0x0 }, /* #95 */
};
uint32_t const g_cTests_sbb_u16_locked = RT_ELEMENTS(g_aTests_sbb_u16_locked);

BINU16_TEST_T const g_aTests_or_u16[] =
{
    { 0x131b06, 0x131346, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x254096, 0x254046, 0x0000, 0x0000, 0x0000, 0x0 }, /* #1 */
    { 0x1b71c6, 0x1b7146, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x375903, 0x375146, 0x0000, 0x0000, 0x0000, 0x0 }, /* #3 */
    { 0x1460c3, 0x146046, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x2278c7, 0x227046, 0x0000, 0x0000, 0x0000, 0x0 }, /* #5 */
    { 0x350e87, 0x350686, 0xa76f, 0xa76f, 0x0000, 0x0 }, /* #6 */
    { 0x294b02, 0x294386, 0xa593, 0xa593, 0x0000, 0x0 }, /* #7 */
    { 0x0e1f82, 0x0e1786, 0x879a, 0x879a, 0x0000, 0x0 }, /* #8 */
    { 0x110843, 0x110082, 0xe9ab, 0xe9ab, 0x0000, 0x0 }, /* #9 */
    { 0x2807d2, 0x280786, 0x86c5, 0x86c5, 0x0000, 0x0 }, /* #10 */
    { 0x0b7657, 0x0b7686, 0xbd00, 0xbd00, 0x0000, 0x0 }, /* #11 */
    { 0x0c3e47, 0x0c3686, 0x8271, 0xdb71, 0xdb20, 0x0 }, /* #12 */
    { 0x1f7047, 0x1f7082, 0x51dc, 0xf5fd, 0xb429, 0x0 }, /* #13 */
    { 0x2e2ad2, 0x2e2202, 0x6192, 0x65f2, 0x6470, 0x0 }, /* #14 */
    { 0x0a3592, 0x0a3582, 0xb460, 0xb675, 0x0635, 0x0 }, /* #15 */
    { 0x055186, 0x055182, 0x9ea0, 0xbea2, 0x3602, 0x0 }, /* #16 */
    { 0x125ed3, 0x125682, 0x85d7, 0xa5df, 0xa14d, 0x0 }, /* #17 */
    { 0x367c02, 0x367482, 0xeee9, 0xffe9, 0x91e9, 0x0 }, /* #18 */
    { 0x1f4307, 0x1f4306, 0x2e1d, 0x2e3f, 0x0c2a, 0x0 }, /* #19 */
    { 0x345916, 0x345106, 0x0d3c, 0x7fbd, 0x7aa9, 0x0 }, /* #20 */
    { 0x295dd6, 0x295582, 0x9af4, 0xbafe, 0xb05e, 0x0 }, /* #21 */
    { 0x225087, 0x225082, 0x7917, 0xf957, 0xb952, 0x0 }, /* #22 */
    { 0x212f06, 0x212782, 0xe906, 0xebef, 0xa2eb, 0x0 }, /* #23 */
    { 0x061ad3, 0x061202, 0x536a, 0x5ffb, 0x1fb1, 0x0 }, /* #24 */
    { 0x0f5997, 0x0f5186, 0xfbc8, 0xffc9, 0x14c9, 0x0 }, /* #25 */
    { 0x187d17, 0x187586, 0xaeb2, 0xaffa, 0xa168, 0x0 }, /* #26 */
    { 0x374ad3, 0x374282, 0x0798, 0xcffe, 0xceee, 0x0 }, /* #27 */
    { 0x1d3013, 0x1d3082, 0x85ec, 0xc7ec, 0x42ec, 0x0 }, /* #28 */
    { 0x300e53, 0x300682, 0xb9ea, 0xf9fe, 0xf97e, 0x0 }, /* #29 */
    { 0x3c1906, 0x3c1186, 0x6d64, 0xef6c, 0xc70c, 0x0 }, /* #30 */
    { 0x2b5817, 0x2b5086, 0x74c3, 0xfee7, 0xba65, 0x0 }, /* #31 */
    { 0x2957c6, 0x295782, 0xe829, 0xfd6d, 0x954c, 0x0 }, /* #32 */
    { 0x147b43, 0x147302, 0x177b, 0x1ffb, 0x1bdb, 0x0 }, /* #33 */
    { 0x150d46, 0x150582, 0xe94e, 0xfdfe, 0xd5b4, 0x0 }, /* #34 */
    { 0x082d46, 0x082586, 0x4fed, 0xefff, 0xa35e, 0x0 }, /* #35 */
    { 0x2f4f02, 0x2f4782, 0xb316, 0xf316, 0xd302, 0x0 }, /* #36 */
    { 0x1c7612, 0x1c7606, 0x577a, 0x7fff, 0x2ca5, 0x0 }, /* #37 */
    { 0x005882, 0x005006, 0x72c8, 0x76fc, 0x4434, 0x0 }, /* #38 */
    { 0x192092, 0x192086, 0x017a, 0x8fff, 0x8edd, 0x0 }, /* #39 */
    { 0x2a4ed7, 0x2a4682, 0xd976, 0xfdf7, 0x35e5, 0x0 }, /* #40 */
    { 0x0d3783, 0x0d3782, 0x7e59, 0xfedf, 0xa4d7, 0x0 }, /* #41 */
    { 0x226007, 0x226006, 0x590a, 0x5daf, 0x1caf, 0x0 }, /* #42 */
    { 0x1d1197, 0x1d1182, 0x17f3, 0xd7f7, 0xd317, 0x0 }, /* #43 */
    { 0x144452, 0x144486, 0x9e2a, 0x9ebe, 0x8abc, 0x0 }, /* #44 */
    { 0x127d82, 0x127582, 0xf9df, 0xffdf, 0xde9f, 0x0 }, /* #45 */
    { 0x0623c2, 0x062302, 0x0ae4, 0x6ee6, 0x64c2, 0x0 }, /* #46 */
    { 0x062c87, 0x062482, 0x2d9b, 0xaddf, 0x88c7, 0x0 }, /* #47 */
    { 0x3e53c2, 0x3e5386, 0xeb2a, 0xfb3f, 0x9937, 0x0 }, /* #48 */
    { 0x1a2c86, 0x1a2486, 0xf012, 0xfb3a, 0xcb2a, 0x0 }, /* #49 */
    { 0x014593, 0x014586, 0xa0e1, 0xf9f3, 0xf9f3, 0x0 }, /* #50 */
    { 0x060043, 0x060002, 0x0685, 0x7fbf, 0x7d3b, 0x0 }, /* #51 */
    { 0x1e69d6, 0x1e6106, 0x5652, 0x7e5a, 0x7818, 0x0 }, /* #52 */
    { 0x221207, 0x221282, 0xba3c, 0xbb7f, 0x3143, 0x0 }, /* #53 */
    { 0x2a5ed6, 0x2a5686, 0xa89a, 0xa8bb, 0x20b1, 0x0 }, /* #54 */
    { 0x3a0c83, 0x3a0486, 0x87a5, 0xafbd, 0xa99d, 0x0 }, /* #55 */
    { 0x0971d7, 0x097106, 0x0e90, 0x7fb7, 0x7f37, 0x0 }, /* #56 */
    { 0x1d4993, 0x1d4186, 0xd7e7, 0xdfff, 0xcc5f, 0x0 }, /* #57 */
    { 0x322606, 0x322602, 0x57ab, 0x77ef, 0x33cf, 0x0 }, /* #58 */
    { 0x1622d2, 0x162282, 0x9326, 0xd776, 0x4756, 0x0 }, /* #59 */
    { 0x0371c6, 0x037102, 0x50ef, 0x71ef, 0x7160, 0x0 }, /* #60 */
    { 0x0b7c93, 0x0b7482, 0xbf36, 0xbf3e, 0xab2e, 0x0 }, /* #61 */
    { 0x226883, 0x226086, 0x7a1a, 0xfa3f, 0x9a2f, 0x0 }, /* #62 */
    { 0x1369c2, 0x136182, 0xf2da, 0xfbdf, 0xa9d5, 0x0 }, /* #63 */
    { 0x101f82, 0x101706, 0x240c, 0x3f8e, 0x3b8e, 0x0 }, /* #64 */
    { 0x096f17, 0x096702, 0x1b92, 0x7bda, 0x63ca, 0x0 }, /* #65 */
    { 0x013807, 0x013006, 0x7e74, 0x7ff5, 0x57f1, 0x0 }, /* #66 */
    { 0x295602, 0x295686, 0x87f2, 0xa7fa, 0x2088, 0x0 }, /* #67 */
    { 0x3d2c92, 0x3d2482, 0x063b, 0x963b, 0x922b, 0x0 }, /* #68 */
    { 0x067956, 0x067182, 0x8184, 0xb3dc, 0x32d8, 0x0 }, /* #69 */
    { 0x102743, 0x102782, 0xf4d0, 0xf4f2, 0x74f2, 0x0 }, /* #70 */
    { 0x267b83, 0x267382, 0xc60e, 0xdece, 0x18c8, 0x0 }, /* #71 */
    { 0x3010c3, 0x301082, 0x83df, 0xbfdf, 0x3f87, 0x0 }, /* #72 */
    { 0x343846, 0x343086, 0x94e5, 0xd6ff, 0x525e, 0x0 }, /* #73 */
    { 0x3e4803, 0x3e4002, 0x0a21, 0x1bfd, 0x13fc, 0x0 }, /* #74 */
    { 0x374653, 0x374682, 0x9cef, 0xbfef, 0x37ae, 0x0 }, /* #75 */
    { 0x270803, 0x270082, 0x9cf3, 0xfdf7, 0xedf7, 0x0 }, /* #76 */
    { 0x160846, 0x160086, 0x3f3e, 0xff7e, 0xd65a, 0x0 }, /* #77 */
    { 0x291a46, 0x291206, 0x0c96, 0x3cbe, 0x383c, 0x0 }, /* #78 */
    { 0x3a1e42, 0x3a1682, 0xc76d, 0xffef, 0xbfe3, 0x0 }, /* #79 */
    { 0x1271d2, 0x127106, 0x5ba5, 0x5be7, 0x1343, 0x0 }, /* #80 */
    { 0x0d7916, 0x0d7102, 0x1ef4, 0x5ffd, 0x433d, 0x0 }, /* #81 */
    { 0x1e2652, 0x1e2682, 0x00c0, 0xc0c4, 0xc004, 0x0 }, /* #82 */
    { 0x3c0387, 0x3c0386, 0x395c, 0xf95f, 0xf91b, 0x0 }, /* #83 */
    { 0x2a6ec3, 0x2a6682, 0x91d0, 0xbff4, 0x2f74, 0x0 }, /* #84 */
    { 0x066cc6, 0x066486, 0xa989, 0xb9c9, 0x1040, 0x0 }, /* #85 */
    { 0x2b7483, 0x2b7486, 0xd9d9, 0xffff, 0xaeaf, 0x0 }, /* #86 */
    { 0x1633d6, 0x163382, 0xdad6, 0xdff7, 0x5737, 0x0 }, /* #87 */
    { 0x2a3243, 0x2a3282, 0xc135, 0xc3fd, 0xc2cd, 0x0 }, /* #88 */
    { 0x3d7382, 0x3d7386, 0x5e6e, 0xffff, 0xb5b3, 0x0 }, /* #89 */
    { 0x0b1206, 0x0b1282, 0x38e6, 0xbffe, 0x9fda, 0x0 }, /* #90 */
    { 0x3f0883, 0x3f0002, 0x6383, 0x678f, 0x048e, 0x0 }, /* #91 */
    { 0x2e5883, 0x2e5082, 0xab22, 0xabe3, 0x28c3, 0x0 }, /* #92 */
    { 0x3b26d2, 0x3b2686, 0xe294, 0xeeff, 0xacff, 0x0 }, /* #93 */
    { 0x097f47, 0x097782, 0x7a4c, 0xfadf, 0xaa93, 0x0 }, /* #94 */
    { 0x0f2e46, 0x0f2682, 0xc29f, 0xeedf, 0xee58, 0x0 }, /* #95 */
};
uint32_t const g_cTests_or_u16 = RT_ELEMENTS(g_aTests_or_u16);

BINU16_TEST_T const g_aTests_or_u16_locked[] =
{
    { 0x0576d7, 0x057646, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x201b47, 0x201346, 0x0000, 0x0000, 0x0000, 0x0 }, /* #1 */
    { 0x2b7707, 0x2b7746, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x321ac6, 0x321246, 0x0000, 0x0000, 0x0000, 0x0 }, /* #3 */
    { 0x303193, 0x303146, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x276c46, 0x276446, 0x0000, 0x0000, 0x0000, 0x0 }, /* #5 */
    { 0x277a56, 0x277282, 0xbbea, 0xbbea, 0x0000, 0x0 }, /* #6 */
    { 0x320d07, 0x320502, 0x394f, 0x394f, 0x0000, 0x0 }, /* #7 */
    { 0x3762d6, 0x376202, 0x21fd, 0x21fd, 0x0000, 0x0 }, /* #8 */
    { 0x176296, 0x176206, 0x429a, 0x429a, 0x0000, 0x0 }, /* #9 */
    { 0x154706, 0x154706, 0x46b1, 0x46b1, 0x0000, 0x0 }, /* #10 */
    { 0x146352, 0x146302, 0x5058, 0x5058, 0x0000, 0x0 }, /* #11 */
    { 0x2d2102, 0x2d2182, 0x476a, 0xc77f, 0x843f, 0x0 }, /* #12 */
    { 0x3705c6, 0x370582, 0x88a8, 0x9cab, 0x1c23, 0x0 }, /* #13 */
    { 0x076696, 0x076606, 0x5659, 0x77dd, 0x73c5, 0x0 }, /* #14 */
    { 0x2601d2, 0x260186, 0x606d, 0xf2ff, 0xb2b7, 0x0 }, /* #15 */
    { 0x093213, 0x093282, 0xa5cb, 0xf7ef, 0xf3af, 0x0 }, /* #16 */
    { 0x090f93, 0x090706, 0x6d14, 0x7f36, 0x7726, 0x0 }, /* #17 */
    { 0x0a6096, 0x0a6082, 0x64ec, 0xe6ef, 0x826f, 0x0 }, /* #18 */
    { 0x306a87, 0x306286, 0xbd8c, 0xbded, 0x0469, 0x0 }, /* #19 */
    { 0x016707, 0x016706, 0x3ca6, 0x3ce7, 0x1cc5, 0x0 }, /* #20 */
    { 0x275846, 0x275082, 0x51ba, 0xf7ba, 0xe622, 0x0 }, /* #21 */
    { 0x2443d2, 0x244386, 0xbe3c, 0xfe7e, 0x7c72, 0x0 }, /* #22 */
    { 0x0942d6, 0x094206, 0x6883, 0x6e9f, 0x061e, 0x0 }, /* #23 */
    { 0x3756c6, 0x375606, 0x59f9, 0x7dff, 0x7d9f, 0x0 }, /* #24 */
    { 0x227807, 0x227086, 0x67da, 0xe7fa, 0xc030, 0x0 }, /* #25 */
    { 0x083b47, 0x083386, 0x39ff, 0xbdff, 0x95dd, 0x0 }, /* #26 */
    { 0x137992, 0x137186, 0xa8d8, 0xaffc, 0x8764, 0x0 }, /* #27 */
    { 0x1801c7, 0x180186, 0xd7a6, 0xffbe, 0xfc9c, 0x0 }, /* #28 */
    { 0x2963d7, 0x296382, 0x47cf, 0xf7df, 0xb4d7, 0x0 }, /* #29 */
    { 0x1c7bc7, 0x1c7306, 0x6bd9, 0x7fdd, 0x7e4c, 0x0 }, /* #30 */
    { 0x3208d7, 0x320086, 0x8371, 0xa771, 0x2651, 0x0 }, /* #31 */
    { 0x3b5456, 0x3b5482, 0x7992, 0xffbf, 0xbfbf, 0x0 }, /* #32 */
    { 0x262307, 0x262386, 0x8ede, 0x9ede, 0x1204, 0x0 }, /* #33 */
    { 0x3f7357, 0x3f7306, 0x5146, 0x7dee, 0x7ca8, 0x0 }, /* #34 */
    { 0x3466d7, 0x346606, 0x31a1, 0x37af, 0x368e, 0x0 }, /* #35 */
    { 0x0937d2, 0x093786, 0x5d45, 0xdd47, 0x9846, 0x0 }, /* #36 */
    { 0x2d3682, 0x2d3686, 0xdc56, 0xfed7, 0xb2d1, 0x0 }, /* #37 */
    { 0x082986, 0x082182, 0xf15c, 0xf5fe, 0xf4a2, 0x0 }, /* #38 */
    { 0x0f1e17, 0x0f1686, 0x5ae0, 0xfbfc, 0xb15c, 0x0 }, /* #39 */
    { 0x082092, 0x082086, 0xa7e9, 0xbfed, 0x9ec4, 0x0 }, /* #40 */
    { 0x3833c7, 0x383386, 0xf452, 0xfdff, 0x69ef, 0x0 }, /* #41 */
    { 0x0231d2, 0x023186, 0x7414, 0xf4d7, 0x80c7, 0x0 }, /* #42 */
    { 0x2622d2, 0x262282, 0x422b, 0xfafb, 0xf8d9, 0x0 }, /* #43 */
    { 0x1b7b57, 0x1b7386, 0x0bea, 0xdffa, 0xd7d8, 0x0 }, /* #44 */
    { 0x146253, 0x146282, 0x7f62, 0xff62, 0xf120, 0x0 }, /* #45 */
    { 0x0c1193, 0x0c1106, 0x1b4d, 0x3f7d, 0x2f30, 0x0 }, /* #46 */
    { 0x360286, 0x360286, 0x22f9, 0xb6f9, 0xb4e1, 0x0 }, /* #47 */
    { 0x1c2a43, 0x1c2286, 0x87f5, 0xcfff, 0xcbee, 0x0 }, /* #48 */
    { 0x187653, 0x187602, 0x192a, 0x193b, 0x1839, 0x0 }, /* #49 */
    { 0x166e83, 0x166682, 0xbe8d, 0xffcd, 0x6fc5, 0x0 }, /* #50 */
    { 0x051896, 0x051082, 0xac65, 0xedfd, 0xc9bd, 0x0 }, /* #51 */
    { 0x2d7f46, 0x2d7786, 0x0f1b, 0xdf3f, 0xd83e, 0x0 }, /* #52 */
    { 0x3a4516, 0x3a4582, 0xfcb7, 0xfef7, 0x8e61, 0x0 }, /* #53 */
    { 0x243a12, 0x243286, 0x1b19, 0xfb3f, 0xf336, 0x0 }, /* #54 */
    { 0x3d4143, 0x3d4186, 0x8bbc, 0xdbfc, 0xd16c, 0x0 }, /* #55 */
    { 0x155e56, 0x155686, 0xd548, 0xddfc, 0x49f4, 0x0 }, /* #56 */
    { 0x131c87, 0x131402, 0x6b76, 0x6ffe, 0x6cae, 0x0 }, /* #57 */
    { 0x2d0993, 0x2d0182, 0xca77, 0xfef7, 0xb4e3, 0x0 }, /* #58 */
    { 0x3135c7, 0x313506, 0x524d, 0x764d, 0x2641, 0x0 }, /* #59 */
    { 0x2e1486, 0x2e1406, 0x0761, 0x5ff9, 0x5fd8, 0x0 }, /* #60 */
    { 0x2608d6, 0x260082, 0x9fa0, 0xbfad, 0x290d, 0x0 }, /* #61 */
    { 0x325986, 0x325186, 0xc725, 0xd7ed, 0xd7c8, 0x0 }, /* #62 */
    { 0x340642, 0x340682, 0x91ae, 0x93fe, 0x9352, 0x0 }, /* #63 */
    { 0x186f03, 0x186782, 0xa9bb, 0xbdfb, 0xb5eb, 0x0 }, /* #64 */
    { 0x332992, 0x332106, 0x6964, 0x7de4, 0x7cc0, 0x0 }, /* #65 */
    { 0x394586, 0x394506, 0x2c3d, 0x7c7d, 0x5c74, 0x0 }, /* #66 */
    { 0x1b46c2, 0x1b4686, 0xbd48, 0xffcc, 0x778c, 0x0 }, /* #67 */
    { 0x3f3406, 0x3f3482, 0xeebe, 0xfffe, 0x1d48, 0x0 }, /* #68 */
    { 0x3a0f12, 0x3a0782, 0xda80, 0xfbc1, 0xa1c1, 0x0 }, /* #69 */
    { 0x3e6d86, 0x3e6502, 0x4a8c, 0x5fef, 0x1fe7, 0x0 }, /* #70 */
    { 0x2c63c7, 0x2c6386, 0xb1f5, 0xbfff, 0x2fee, 0x0 }, /* #71 */
    { 0x2312d7, 0x231282, 0x27a8, 0xe7e9, 0xc6e9, 0x0 }, /* #72 */
    { 0x0013c2, 0x001386, 0xf1eb, 0xf9ff, 0xa89f, 0x0 }, /* #73 */
    { 0x172453, 0x172402, 0x6fa2, 0x7fa7, 0x1127, 0x0 }, /* #74 */
    { 0x0f3e52, 0x0f3686, 0x8117, 0x8977, 0x0967, 0x0 }, /* #75 */
    { 0x1c2a46, 0x1c2282, 0xcbf0, 0xeffb, 0x257b, 0x0 }, /* #76 */
    { 0x1a2607, 0x1a2686, 0xe75f, 0xe75f, 0x4416, 0x0 }, /* #77 */
    { 0x314082, 0x314082, 0xd1af, 0xddef, 0x4c6a, 0x0 }, /* #78 */
    { 0x331b06, 0x331382, 0xc22e, 0xdf3e, 0x9d1a, 0x0 }, /* #79 */
    { 0x2c7a42, 0x2c7282, 0x8573, 0xad7f, 0xa83c, 0x0 }, /* #80 */
    { 0x240192, 0x240182, 0x816d, 0xdffd, 0xdef4, 0x0 }, /* #81 */
    { 0x2e4147, 0x2e4182, 0x7abe, 0xfabf, 0xe291, 0x0 }, /* #82 */
    { 0x375296, 0x375282, 0x8a30, 0xdff1, 0xddc1, 0x0 }, /* #83 */
    { 0x081412, 0x081486, 0x2461, 0xe5f5, 0xc1f4, 0x0 }, /* #84 */
    { 0x1e63c6, 0x1e6386, 0x8981, 0x8b8d, 0x0a0d, 0x0 }, /* #85 */
    { 0x300696, 0x300682, 0xc352, 0xffd3, 0x7c93, 0x0 }, /* #86 */
    { 0x3f08d2, 0x3f0086, 0x8085, 0xb3af, 0xb3af, 0x0 }, /* #87 */
    { 0x083047, 0x083086, 0x9644, 0x97fc, 0x85bc, 0x0 }, /* #88 */
    { 0x112107, 0x112102, 0x2692, 0x3fbf, 0x1f2d, 0x0 }, /* #89 */
    { 0x197c56, 0x197482, 0xd088, 0xd1e9, 0x41e1, 0x0 }, /* #90 */
    { 0x382406, 0x382482, 0x7a1c, 0xfa1c, 0xc814, 0x0 }, /* #91 */
    { 0x2657c7, 0x265782, 0xd6d3, 0xf6df, 0x60cd, 0x0 }, /* #92 */
    { 0x0f63c6, 0x0f6382, 0xd97b, 0xdffb, 0xcedb, 0x0 }, /* #93 */
    { 0x227487, 0x227486, 0xf82d, 0xfbed, 0xf3c9, 0x0 }, /* #94 */
    { 0x2c0e57, 0x2c0686, 0xc0d8, 0xe5d8, 0xa518, 0x0 }, /* #95 */
};
uint32_t const g_cTests_or_u16_locked = RT_ELEMENTS(g_aTests_or_u16_locked);

BINU16_TEST_T const g_aTests_xor_u16[] =
{
    { 0x3d4793, 0x3d4746, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x2d7a03, 0x2d7246, 0x0000, 0x0000, 0x0000, 0x0 }, /* #1 */
    { 0x0b5fc6, 0x0b5746, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x3766d6, 0x376646, 0x0000, 0x0000, 0x0000, 0x0 }, /* #3 */
    { 0x054757, 0x054746, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x3616d3, 0x361646, 0x0000, 0x0000, 0x0000, 0x0 }, /* #5 */
    { 0x387096, 0x387006, 0x17dd, 0x17dd, 0x0000, 0x0 }, /* #6 */
    { 0x380147, 0x380106, 0x5ade, 0x5ade, 0x0000, 0x0 }, /* #7 */
    { 0x1908d6, 0x190082, 0x8ba7, 0x8ba7, 0x0000, 0x0 }, /* #8 */
    { 0x2c6183, 0x2c6182, 0xf4e6, 0xf4e6, 0x0000, 0x0 }, /* #9 */
    { 0x203196, 0x203106, 0x4d7b, 0x4d7b, 0x0000, 0x0 }, /* #10 */
    { 0x0a7c83, 0x0a7486, 0x8b8e, 0x8b8e, 0x0000, 0x0 }, /* #11 */
    { 0x106c06, 0x106482, 0xf622, 0xedf2, 0x1bd0, 0x0 }, /* #12 */
    { 0x3c7ad2, 0x3c7286, 0x624e, 0x81c9, 0xe387, 0x0 }, /* #13 */
    { 0x0c7497, 0x0c7406, 0x0271, 0x3409, 0x3678, 0x0 }, /* #14 */
    { 0x152196, 0x152186, 0x3a57, 0xdd12, 0xe745, 0x0 }, /* #15 */
    { 0x037cd6, 0x037482, 0xdd09, 0xc879, 0x1570, 0x0 }, /* #16 */
    { 0x391143, 0x391186, 0x2586, 0xce12, 0xeb94, 0x0 }, /* #17 */
    { 0x107ed3, 0x107686, 0x222f, 0xa969, 0x8b46, 0x0 }, /* #18 */
    { 0x193896, 0x193002, 0xf854, 0x64ce, 0x9c9a, 0x0 }, /* #19 */
    { 0x3710d2, 0x371082, 0x6224, 0x944a, 0xf66e, 0x0 }, /* #20 */
    { 0x037706, 0x037786, 0xad4e, 0x8648, 0x2b06, 0x0 }, /* #21 */
    { 0x262b06, 0x262386, 0x7bac, 0x8578, 0xfed4, 0x0 }, /* #22 */
    { 0x253ec2, 0x253602, 0x850f, 0x6cbc, 0xe9b3, 0x0 }, /* #23 */
    { 0x017306, 0x017306, 0x2da3, 0x68fa, 0x4559, 0x0 }, /* #24 */
    { 0x3c7dc6, 0x3c7586, 0x45a5, 0xa82b, 0xed8e, 0x0 }, /* #25 */
    { 0x255a03, 0x255202, 0x123f, 0x34b9, 0x2686, 0x0 }, /* #26 */
    { 0x187016, 0x187006, 0x8078, 0x672b, 0xe753, 0x0 }, /* #27 */
    { 0x012092, 0x012006, 0x495c, 0x2d2d, 0x6471, 0x0 }, /* #28 */
    { 0x385f16, 0x385706, 0xa581, 0x2d50, 0x88d1, 0x0 }, /* #29 */
    { 0x263552, 0x263582, 0x7c72, 0xe59b, 0x99e9, 0x0 }, /* #30 */
    { 0x235842, 0x235006, 0xcf0b, 0x5e72, 0x9179, 0x0 }, /* #31 */
    { 0x062d97, 0x062506, 0x7491, 0x7f7b, 0x0bea, 0x0 }, /* #32 */
    { 0x1b4047, 0x1b4006, 0x5561, 0x20f5, 0x7594, 0x0 }, /* #33 */
    { 0x297413, 0x297486, 0xad45, 0xf5c3, 0x5886, 0x0 }, /* #34 */
    { 0x225097, 0x225086, 0x3727, 0xde7b, 0xe95c, 0x0 }, /* #35 */
    { 0x104083, 0x104086, 0xfa6e, 0x880f, 0x7261, 0x0 }, /* #36 */
    { 0x291952, 0x291102, 0x4ba2, 0x3d2a, 0x7688, 0x0 }, /* #37 */
    { 0x314dc2, 0x314582, 0x534f, 0xd00e, 0x8341, 0x0 }, /* #38 */
    { 0x251257, 0x251282, 0x63d2, 0xbea8, 0xdd7a, 0x0 }, /* #39 */
    { 0x075f93, 0x075782, 0xcfe4, 0x86ea, 0x490e, 0x0 }, /* #40 */
    { 0x1904c3, 0x190482, 0x0952, 0x83e6, 0x8ab4, 0x0 }, /* #41 */
    { 0x102d52, 0x102582, 0xe13d, 0xb002, 0x513f, 0x0 }, /* #42 */
    { 0x341a93, 0x341206, 0x175e, 0x2f48, 0x3816, 0x0 }, /* #43 */
    { 0x1b5cc3, 0x1b5482, 0x2508, 0x894c, 0xac44, 0x0 }, /* #44 */
    { 0x166493, 0x166402, 0x126b, 0x6ed9, 0x7cb2, 0x0 }, /* #45 */
    { 0x0e0542, 0x0e0586, 0x52bc, 0x9d11, 0xcfad, 0x0 }, /* #46 */
    { 0x1c0906, 0x1c0106, 0x8241, 0x0995, 0x8bd4, 0x0 }, /* #47 */
    { 0x2e0a53, 0x2e0202, 0x5a68, 0x63e3, 0x398b, 0x0 }, /* #48 */
    { 0x194283, 0x194206, 0x5f51, 0x06c5, 0x5994, 0x0 }, /* #49 */
    { 0x362cc6, 0x362482, 0x8ad7, 0xadb6, 0x2761, 0x0 }, /* #50 */
    { 0x012a46, 0x012286, 0x2781, 0xde17, 0xf996, 0x0 }, /* #51 */
    { 0x103357, 0x103382, 0x1f23, 0x845b, 0x9b78, 0x0 }, /* #52 */
    { 0x253547, 0x253586, 0x37ec, 0x8dee, 0xba02, 0x0 }, /* #53 */
    { 0x2e57c6, 0x2e5702, 0x64d1, 0x7551, 0x1180, 0x0 }, /* #54 */
    { 0x205b52, 0x205386, 0x86b2, 0x820c, 0x04be, 0x0 }, /* #55 */
    { 0x263882, 0x263002, 0x0028, 0x65fe, 0x65d6, 0x0 }, /* #56 */
    { 0x260983, 0x260102, 0xcbe4, 0x032a, 0xc8ce, 0x0 }, /* #57 */
    { 0x283a47, 0x283202, 0xef5d, 0x7951, 0x960c, 0x0 }, /* #58 */
    { 0x007203, 0x007202, 0x8596, 0x0b89, 0x8e1f, 0x0 }, /* #59 */
    { 0x311dd6, 0x311506, 0xb3b6, 0x3905, 0x8ab3, 0x0 }, /* #60 */
    { 0x214dd2, 0x214586, 0xfced, 0xce22, 0x32cf, 0x0 }, /* #61 */
    { 0x2057c3, 0x205782, 0xb87e, 0xcb26, 0x7358, 0x0 }, /* #62 */
    { 0x171a13, 0x171202, 0x11ae, 0x6976, 0x78d8, 0x0 }, /* #63 */
    { 0x287653, 0x287686, 0x6685, 0xe8b8, 0x8e3d, 0x0 }, /* #64 */
    { 0x2e5fd6, 0x2e5702, 0x1c3d, 0x7c1c, 0x6021, 0x0 }, /* #65 */
    { 0x1f7392, 0x1f7302, 0xde6b, 0x004c, 0xde27, 0x0 }, /* #66 */
    { 0x297b92, 0x297382, 0x0d3f, 0xf1f7, 0xfcc8, 0x0 }, /* #67 */
    { 0x2b0452, 0x2b0486, 0x3b38, 0xbac6, 0x81fe, 0x0 }, /* #68 */
    { 0x110286, 0x110282, 0xe26a, 0x88ad, 0x6ac7, 0x0 }, /* #69 */
    { 0x032792, 0x032782, 0x1a81, 0xb2d5, 0xa854, 0x0 }, /* #70 */
    { 0x2903c7, 0x290306, 0xb682, 0x4c1b, 0xfa99, 0x0 }, /* #71 */
    { 0x3e3282, 0x3e3282, 0xd3f2, 0x9385, 0x4077, 0x0 }, /* #72 */
    { 0x2f38d3, 0x2f3002, 0x7119, 0x39fb, 0x48e2, 0x0 }, /* #73 */
    { 0x112f06, 0x112786, 0xbf4c, 0xfaf6, 0x45ba, 0x0 }, /* #74 */
    { 0x327353, 0x327306, 0xfb8a, 0x5f2e, 0xa4a4, 0x0 }, /* #75 */
    { 0x0e2f53, 0x0e2786, 0x625c, 0xb5a0, 0xd7fc, 0x0 }, /* #76 */
    { 0x3c7f13, 0x3c7782, 0xfffa, 0xa1ba, 0x5e40, 0x0 }, /* #77 */
    { 0x0625c7, 0x062506, 0x8676, 0x5cd7, 0xdaa1, 0x0 }, /* #78 */
    { 0x326e86, 0x326602, 0x63ca, 0x2567, 0x46ad, 0x0 }, /* #79 */
    { 0x1837c7, 0x183786, 0x86f6, 0xd690, 0x5066, 0x0 }, /* #80 */
    { 0x2220d2, 0x222006, 0x2e74, 0x4714, 0x6960, 0x0 }, /* #81 */
    { 0x0c6497, 0x0c6402, 0xb9f6, 0x6b89, 0xd27f, 0x0 }, /* #82 */
    { 0x325f12, 0x325786, 0x859d, 0xde9f, 0x5b02, 0x0 }, /* #83 */
    { 0x1e1917, 0x1e1106, 0x88ea, 0x5250, 0xdaba, 0x0 }, /* #84 */
    { 0x1416d7, 0x141686, 0x1786, 0x957e, 0x82f8, 0x0 }, /* #85 */
    { 0x395d82, 0x395502, 0x4b84, 0x2e62, 0x65e6, 0x0 }, /* #86 */
    { 0x0f6dd3, 0x0f6506, 0x226e, 0x7a74, 0x581a, 0x0 }, /* #87 */
    { 0x011307, 0x011302, 0x0cdc, 0x1875, 0x14a9, 0x0 }, /* #88 */
    { 0x2a0ec2, 0x2a0686, 0x5018, 0xba4e, 0xea56, 0x0 }, /* #89 */
    { 0x023d53, 0x023502, 0x5d53, 0x127a, 0x4f29, 0x0 }, /* #90 */
    { 0x315b92, 0x315382, 0x8e62, 0x9183, 0x1fe1, 0x0 }, /* #91 */
    { 0x165497, 0x165482, 0x7b2f, 0x8004, 0xfb2b, 0x0 }, /* #92 */
    { 0x1c4583, 0x1c4502, 0x1991, 0x148f, 0x0d1e, 0x0 }, /* #93 */
    { 0x1f24c6, 0x1f2482, 0x8331, 0xf8a8, 0x7b99, 0x0 }, /* #94 */
    { 0x0f0843, 0x0f0006, 0xcf65, 0x32f5, 0xfd90, 0x0 }, /* #95 */
};
uint32_t const g_cTests_xor_u16 = RT_ELEMENTS(g_aTests_xor_u16);

BINU16_TEST_T const g_aTests_xor_u16_locked[] =
{
    { 0x295a06, 0x295246, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x396a87, 0x396246, 0x0000, 0x0000, 0x0000, 0x0 }, /* #1 */
    { 0x0d5a92, 0x0d5246, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x373702, 0x373746, 0x0000, 0x0000, 0x0000, 0x0 }, /* #3 */
    { 0x271556, 0x271546, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x2a7956, 0x2a7146, 0x0000, 0x0000, 0x0000, 0x0 }, /* #5 */
    { 0x3877d3, 0x387706, 0x4f21, 0x4f21, 0x0000, 0x0 }, /* #6 */
    { 0x2e1c46, 0x2e1402, 0x5b9e, 0x5b9e, 0x0000, 0x0 }, /* #7 */
    { 0x3b4582, 0x3b4586, 0xbd9c, 0xbd9c, 0x0000, 0x0 }, /* #8 */
    { 0x201393, 0x201382, 0xb140, 0xb140, 0x0000, 0x0 }, /* #9 */
    { 0x1801c2, 0x180182, 0xf27c, 0xf27c, 0x0000, 0x0 }, /* #10 */
    { 0x2231c7, 0x223106, 0x116f, 0x116f, 0x0000, 0x0 }, /* #11 */
    { 0x1d45d6, 0x1d4582, 0x8226, 0xdc97, 0x5eb1, 0x0 }, /* #12 */
    { 0x161892, 0x161082, 0x773d, 0xe9fb, 0x9ec6, 0x0 }, /* #13 */
    { 0x1e0443, 0x1e0486, 0xd7f0, 0xc76c, 0x109c, 0x0 }, /* #14 */
    { 0x3e2416, 0x3e2482, 0xf27f, 0x9e13, 0x6c6c, 0x0 }, /* #15 */
    { 0x3e2983, 0x3e2106, 0xc844, 0x0603, 0xce47, 0x0 }, /* #16 */
    { 0x162d96, 0x162506, 0x7c8d, 0x73d1, 0x0f5c, 0x0 }, /* #17 */
    { 0x140c92, 0x140486, 0x23eb, 0xec56, 0xcfbd, 0x0 }, /* #18 */
    { 0x281783, 0x281782, 0x3c11, 0xca13, 0xf602, 0x0 }, /* #19 */
    { 0x370496, 0x370482, 0x47e6, 0xc398, 0x847e, 0x0 }, /* #20 */
    { 0x3b7d13, 0x3b7506, 0x7a3f, 0x1577, 0x6f48, 0x0 }, /* #21 */
    { 0x221f96, 0x221702, 0x6e9b, 0x185b, 0x76c0, 0x0 }, /* #22 */
    { 0x3b34c2, 0x3b3406, 0x0cbb, 0x7d05, 0x71be, 0x0 }, /* #23 */
    { 0x396502, 0x396586, 0x5dd0, 0xa8af, 0xf57f, 0x0 }, /* #24 */
    { 0x283742, 0x283786, 0x9a62, 0x9cc6, 0x06a4, 0x0 }, /* #25 */
    { 0x170c82, 0x170486, 0xff88, 0xb184, 0x4e0c, 0x0 }, /* #26 */
    { 0x125543, 0x125582, 0x25bc, 0xbc34, 0x9988, 0x0 }, /* #27 */
    { 0x144406, 0x144406, 0x0f05, 0x6ba5, 0x64a0, 0x0 }, /* #28 */
    { 0x0d1216, 0x0d1202, 0x8374, 0x1b4c, 0x9838, 0x0 }, /* #29 */
    { 0x2a3717, 0x2a3706, 0xe192, 0x5459, 0xb5cb, 0x0 }, /* #30 */
    { 0x222892, 0x222002, 0x7bce, 0x27fb, 0x5c35, 0x0 }, /* #31 */
    { 0x314853, 0x314082, 0xeb50, 0xa16b, 0x4a3b, 0x0 }, /* #32 */
    { 0x150713, 0x150706, 0x1be2, 0x6d71, 0x7693, 0x0 }, /* #33 */
    { 0x0f18c6, 0x0f1082, 0x5a1c, 0x8925, 0xd339, 0x0 }, /* #34 */
    { 0x305706, 0x305706, 0x568f, 0x6bcc, 0x3d43, 0x0 }, /* #35 */
    { 0x0250c7, 0x025086, 0x4285, 0xbe69, 0xfcec, 0x0 }, /* #36 */
    { 0x372393, 0x372386, 0xf2e7, 0xa896, 0x5a71, 0x0 }, /* #37 */
    { 0x392b46, 0x392306, 0x7264, 0x5814, 0x2a70, 0x0 }, /* #38 */
    { 0x134282, 0x134206, 0x54eb, 0x75e1, 0x210a, 0x0 }, /* #39 */
    { 0x3868c3, 0x386082, 0xe14a, 0xf302, 0x1248, 0x0 }, /* #40 */
    { 0x3d2547, 0x3d2502, 0x346e, 0x6604, 0x526a, 0x0 }, /* #41 */
    { 0x193083, 0x193082, 0xce3e, 0xa4b6, 0x6a88, 0x0 }, /* #42 */
    { 0x306c43, 0x306486, 0x690d, 0xa0b2, 0xc9bf, 0x0 }, /* #43 */
    { 0x340e43, 0x340606, 0x0d50, 0x1253, 0x1f03, 0x0 }, /* #44 */
    { 0x2b4043, 0x2b4006, 0x73f5, 0x13ee, 0x601b, 0x0 }, /* #45 */
    { 0x352603, 0x352606, 0x4ded, 0x3f06, 0x72eb, 0x0 }, /* #46 */
    { 0x3a6d07, 0x3a6586, 0x44cc, 0xd863, 0x9caf, 0x0 }, /* #47 */
    { 0x3e4317, 0x3e4386, 0x7148, 0xa0a0, 0xd1e8, 0x0 }, /* #48 */
    { 0x383ad6, 0x383202, 0xe4e4, 0x7d0e, 0x99ea, 0x0 }, /* #49 */
    { 0x2647d7, 0x264702, 0x494f, 0x1f51, 0x561e, 0x0 }, /* #50 */
    { 0x2e28d2, 0x2e2006, 0xd8af, 0x141e, 0xccb1, 0x0 }, /* #51 */
    { 0x2a6b82, 0x2a6386, 0x7770, 0xf55c, 0x822c, 0x0 }, /* #52 */
    { 0x172ac3, 0x172286, 0x8d10, 0xb9de, 0x34ce, 0x0 }, /* #53 */
    { 0x1339d7, 0x133102, 0xe337, 0x27a7, 0xc490, 0x0 }, /* #54 */
    { 0x2d4f12, 0x2d4702, 0x02a9, 0x589b, 0x5a32, 0x0 }, /* #55 */
    { 0x3f7a16, 0x3f7202, 0xfbfc, 0x4ff7, 0xb40b, 0x0 }, /* #56 */
    { 0x3f5312, 0x3f5382, 0x3153, 0xba16, 0x8b45, 0x0 }, /* #57 */
    { 0x233297, 0x233202, 0xa001, 0x0d20, 0xad21, 0x0 }, /* #58 */
    { 0x006146, 0x006102, 0x5830, 0x5cb5, 0x0485, 0x0 }, /* #59 */
    { 0x1b1f83, 0x1b1786, 0x0339, 0xc727, 0xc41e, 0x0 }, /* #60 */
    { 0x2d0f53, 0x2d0786, 0x40d0, 0xf063, 0xb0b3, 0x0 }, /* #61 */
    { 0x096816, 0x096086, 0xba16, 0xa2a5, 0x18b3, 0x0 }, /* #62 */
    { 0x170f42, 0x170786, 0xa468, 0xa9f3, 0x0d9b, 0x0 }, /* #63 */
    { 0x2d1e47, 0x2d1606, 0xa222, 0x5dfa, 0xffd8, 0x0 }, /* #64 */
    { 0x011082, 0x011006, 0x0c02, 0x3050, 0x3c52, 0x0 }, /* #65 */
    { 0x227402, 0x227402, 0x7ef4, 0x2e4a, 0x50be, 0x0 }, /* #66 */
    { 0x1a1b47, 0x1a1382, 0x44e1, 0x8149, 0xc5a8, 0x0 }, /* #67 */
    { 0x113b97, 0x113382, 0xa236, 0xd1a8, 0x739e, 0x0 }, /* #68 */
    { 0x245d12, 0x245502, 0xccd7, 0x4b49, 0x879e, 0x0 }, /* #69 */
    { 0x247407, 0x247486, 0x4854, 0xa7f6, 0xefa2, 0x0 }, /* #70 */
    { 0x1c6447, 0x1c6406, 0xabb5, 0x106c, 0xbbd9, 0x0 }, /* #71 */
    { 0x1d3b56, 0x1d3386, 0x59af, 0xbee2, 0xe74d, 0x0 }, /* #72 */
    { 0x0c6d92, 0x0c6506, 0x5ba0, 0x285f, 0x73ff, 0x0 }, /* #73 */
    { 0x0c1d46, 0x0c1586, 0xa5a0, 0xc6b1, 0x6311, 0x0 }, /* #74 */
    { 0x0606c2, 0x060602, 0xb85a, 0x145e, 0xac04, 0x0 }, /* #75 */
    { 0x1d71c2, 0x1d7106, 0xefcd, 0x34f0, 0xdb3d, 0x0 }, /* #76 */
    { 0x0d5893, 0x0d5086, 0x9fa1, 0xee93, 0x7132, 0x0 }, /* #77 */
    { 0x152146, 0x152102, 0xa571, 0x1ce9, 0xb998, 0x0 }, /* #78 */
    { 0x074513, 0x074582, 0x4785, 0xb726, 0xf0a3, 0x0 }, /* #79 */
    { 0x1029c7, 0x102106, 0xa686, 0x6d27, 0xcba1, 0x0 }, /* #80 */
    { 0x087c96, 0x087486, 0x304f, 0x920f, 0xa240, 0x0 }, /* #81 */
    { 0x2409c2, 0x240186, 0x2097, 0xf795, 0xd702, 0x0 }, /* #82 */
    { 0x213553, 0x213506, 0xf199, 0x6371, 0x92e8, 0x0 }, /* #83 */
    { 0x371e97, 0x371682, 0x8a6e, 0xc6b3, 0x4cdd, 0x0 }, /* #84 */
    { 0x196497, 0x196402, 0x38ec, 0x3110, 0x09fc, 0x0 }, /* #85 */
    { 0x071a46, 0x071282, 0xd6be, 0xb0c8, 0x6676, 0x0 }, /* #86 */
    { 0x2a52d6, 0x2a5206, 0x33b4, 0x2382, 0x1036, 0x0 }, /* #87 */
    { 0x145c16, 0x145406, 0x7a3c, 0x50e8, 0x2ad4, 0x0 }, /* #88 */
    { 0x020753, 0x020782, 0x34b2, 0xf03e, 0xc48c, 0x0 }, /* #89 */
    { 0x047607, 0x047682, 0x5de3, 0xc2ce, 0x9f2d, 0x0 }, /* #90 */
    { 0x0c4803, 0x0c4002, 0x08e1, 0x20a4, 0x2845, 0x0 }, /* #91 */
    { 0x382a87, 0x382282, 0xcb28, 0xc0cd, 0x0be5, 0x0 }, /* #92 */
    { 0x2b2953, 0x2b2106, 0x3202, 0x738b, 0x4189, 0x0 }, /* #93 */
    { 0x102d53, 0x102502, 0xe308, 0x0bc7, 0xe8cf, 0x0 }, /* #94 */
    { 0x112dc7, 0x112506, 0xfa00, 0x3c06, 0xc606, 0x0 }, /* #95 */
};
uint32_t const g_cTests_xor_u16_locked = RT_ELEMENTS(g_aTests_xor_u16_locked);

BINU16_TEST_T const g_aTests_and_u16[] =
{
    { 0x201482, 0x201446, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x006617, 0x006646, 0x0000, 0x0000, 0x0000, 0x0 }, /* #1 */
    { 0x357696, 0x357646, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x3d6647, 0x3d6646, 0x0000, 0x0000, 0x0000, 0x0 }, /* #3 */
    { 0x3268c7, 0x326046, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x1d5607, 0x1d5646, 0x0000, 0x0000, 0x0000, 0x0 }, /* #5 */
    { 0x2b7712, 0x2b7746, 0xfac5, 0x0000, 0x0000, 0x0 }, /* #6 */
    { 0x2d0317, 0x2d0346, 0xa267, 0x0000, 0x0000, 0x0 }, /* #7 */
    { 0x0817c7, 0x081746, 0x4053, 0x0000, 0x0000, 0x0 }, /* #8 */
    { 0x2b13d7, 0x2b1346, 0x3a9d, 0x0000, 0x0000, 0x0 }, /* #9 */
    { 0x3c2a17, 0x3c2246, 0xbec4, 0x0000, 0x0000, 0x0 }, /* #10 */
    { 0x1d3256, 0x1d3246, 0x9066, 0x0000, 0x0000, 0x0 }, /* #11 */
    { 0x0c7907, 0x0c7102, 0xdbbb, 0x581a, 0x581a, 0x0 }, /* #12 */
    { 0x015dc3, 0x015502, 0xc9f6, 0x4834, 0x483d, 0x0 }, /* #13 */
    { 0x280c57, 0x280402, 0x7fd0, 0x6d10, 0xed1a, 0x0 }, /* #14 */
    { 0x367583, 0x367502, 0x94e1, 0x1020, 0x7128, 0x0 }, /* #15 */
    { 0x097952, 0x097102, 0x6c3c, 0x681c, 0x795e, 0x0 }, /* #16 */
    { 0x387f92, 0x387702, 0x3e05, 0x3204, 0x327c, 0x0 }, /* #17 */
    { 0x372296, 0x372206, 0x1b1b, 0x1018, 0x7478, 0x0 }, /* #18 */
    { 0x137ed7, 0x137602, 0x04bd, 0x0480, 0xf6c0, 0x0 }, /* #19 */
    { 0x102196, 0x102102, 0xcb7f, 0x0a58, 0x3a58, 0x0 }, /* #20 */
    { 0x3c3742, 0x3c3706, 0xb679, 0x1200, 0x1304, 0x0 }, /* #21 */
    { 0x221f96, 0x221706, 0x60cb, 0x40c3, 0xd5e3, 0x0 }, /* #22 */
    { 0x220842, 0x220082, 0x97df, 0x838a, 0xa3aa, 0x0 }, /* #23 */
    { 0x201cc6, 0x201482, 0xe50c, 0xa108, 0xb3aa, 0x0 }, /* #24 */
    { 0x320146, 0x320102, 0x0d1b, 0x081a, 0xe83a, 0x0 }, /* #25 */
    { 0x242397, 0x242306, 0x1c87, 0x0884, 0x28a4, 0x0 }, /* #26 */
    { 0x0f2ed3, 0x0f2602, 0x6c60, 0x6c40, 0x7fc8, 0x0 }, /* #27 */
    { 0x316107, 0x316102, 0xfc28, 0x4c08, 0x4c1c, 0x0 }, /* #28 */
    { 0x152296, 0x152202, 0x7482, 0x1402, 0x9e1a, 0x0 }, /* #29 */
    { 0x303dd2, 0x303502, 0x16af, 0x102f, 0x117f, 0x0 }, /* #30 */
    { 0x0c6446, 0x0c6482, 0x86fb, 0x8438, 0xec38, 0x0 }, /* #31 */
    { 0x2b0d86, 0x2b0502, 0x20f9, 0x0051, 0xdc55, 0x0 }, /* #32 */
    { 0x1e4882, 0x1e4082, 0xe1db, 0xe002, 0xec02, 0x0 }, /* #33 */
    { 0x175596, 0x175506, 0x4b7c, 0x486c, 0x6cef, 0x0 }, /* #34 */
    { 0x0d2ed3, 0x0d2602, 0x4e29, 0x4a20, 0xfb74, 0x0 }, /* #35 */
    { 0x203456, 0x203406, 0x07ea, 0x02aa, 0xeaae, 0x0 }, /* #36 */
    { 0x0c3bc2, 0x0c3306, 0xbddc, 0x0d84, 0x4fa7, 0x0 }, /* #37 */
    { 0x2f1113, 0x2f1186, 0x98ed, 0x88cc, 0xcede, 0x0 }, /* #38 */
    { 0x033812, 0x033006, 0xf076, 0x6012, 0x6e9b, 0x0 }, /* #39 */
    { 0x052e93, 0x052602, 0xc7cf, 0x4301, 0x4331, 0x0 }, /* #40 */
    { 0x3a3582, 0x3a3586, 0x849b, 0x808b, 0x988b, 0x0 }, /* #41 */
    { 0x3537c3, 0x353706, 0x4dbc, 0x01ac, 0xb3ae, 0x0 }, /* #42 */
    { 0x0f1753, 0x0f1786, 0xd56a, 0xd428, 0xfcb9, 0x0 }, /* #43 */
    { 0x3e6fc7, 0x3e6706, 0xec4b, 0x0842, 0x1bf2, 0x0 }, /* #44 */
    { 0x2c2ed7, 0x2c2602, 0x0a27, 0x0a04, 0x9f1c, 0x0 }, /* #45 */
    { 0x1c3ed6, 0x1c3602, 0x770a, 0x3108, 0xb96d, 0x0 }, /* #46 */
    { 0x017152, 0x017102, 0x74e1, 0x6001, 0xe911, 0x0 }, /* #47 */
    { 0x1f0103, 0x1f0106, 0x13e6, 0x1384, 0x7785, 0x0 }, /* #48 */
    { 0x3538c7, 0x353002, 0xff83, 0x7f80, 0x7fdc, 0x0 }, /* #49 */
    { 0x3d1816, 0x3d1002, 0x75b7, 0x2532, 0xaf3a, 0x0 }, /* #50 */
    { 0x0f2457, 0x0f2486, 0x95d6, 0x95d2, 0xfff3, 0x0 }, /* #51 */
    { 0x2d4c06, 0x2d4402, 0xeae4, 0x22e0, 0x23e1, 0x0 }, /* #52 */
    { 0x271303, 0x271306, 0x59e4, 0x11c0, 0x13c8, 0x0 }, /* #53 */
    { 0x1f2757, 0x1f2706, 0xca2f, 0x480c, 0x4ddc, 0x0 }, /* #54 */
    { 0x327e83, 0x327686, 0xe257, 0xc050, 0xd4d8, 0x0 }, /* #55 */
    { 0x367a03, 0x367286, 0xf93b, 0xe833, 0xe837, 0x0 }, /* #56 */
    { 0x3360c7, 0x336086, 0xf522, 0xa400, 0xa480, 0x0 }, /* #57 */
    { 0x252dc3, 0x252586, 0xd0e3, 0xd081, 0xdc8d, 0x0 }, /* #58 */
    { 0x163bc2, 0x163302, 0xe027, 0x4023, 0x52eb, 0x0 }, /* #59 */
    { 0x0d1486, 0x0d1402, 0xf9dc, 0x29dc, 0x2bdf, 0x0 }, /* #60 */
    { 0x2b0d46, 0x2b0502, 0x7473, 0x2001, 0xaa0d, 0x0 }, /* #61 */
    { 0x1b2dc7, 0x1b2586, 0xb199, 0x9088, 0xda8a, 0x0 }, /* #62 */
    { 0x065996, 0x065106, 0x64ce, 0x60c0, 0xf1f0, 0x0 }, /* #63 */
    { 0x390982, 0x390102, 0xc753, 0x0713, 0x17b7, 0x0 }, /* #64 */
    { 0x380113, 0x380106, 0x5cd9, 0x0841, 0x0845, 0x0 }, /* #65 */
    { 0x3e0b53, 0x3e0302, 0x0912, 0x0802, 0x984e, 0x0 }, /* #66 */
    { 0x0c7a53, 0x0c7206, 0x71f0, 0x4100, 0xcf0f, 0x0 }, /* #67 */
    { 0x195e82, 0x195686, 0xc906, 0xc906, 0xff06, 0x0 }, /* #68 */
    { 0x1c2703, 0x1c2702, 0x4636, 0x0002, 0x1802, 0x0 }, /* #69 */
    { 0x084c82, 0x084402, 0x700f, 0x600b, 0x668b, 0x0 }, /* #70 */
    { 0x171183, 0x171186, 0xba46, 0xaa44, 0xef6d, 0x0 }, /* #71 */
    { 0x2e73c6, 0x2e7306, 0x7886, 0x5884, 0x5d9d, 0x0 }, /* #72 */
    { 0x0e0f06, 0x0e0706, 0x486c, 0x0048, 0xb059, 0x0 }, /* #73 */
    { 0x112182, 0x112102, 0x1d90, 0x1c80, 0x7ea3, 0x0 }, /* #74 */
    { 0x385b42, 0x385302, 0x23c9, 0x02c1, 0x1ae7, 0x0 }, /* #75 */
    { 0x117206, 0x117202, 0x6846, 0x0040, 0x97e1, 0x0 }, /* #76 */
    { 0x381e42, 0x381686, 0x9256, 0x9050, 0x98f9, 0x0 }, /* #77 */
    { 0x0b6313, 0x0b6306, 0xb7da, 0x050a, 0x0d2a, 0x0 }, /* #78 */
    { 0x043792, 0x043786, 0x83e6, 0x8024, 0xd42d, 0x0 }, /* #79 */
    { 0x395bd3, 0x395386, 0xe74a, 0xc742, 0xcff3, 0x0 }, /* #80 */
    { 0x374286, 0x374206, 0x0054, 0x0044, 0x7bcf, 0x0 }, /* #81 */
    { 0x321b93, 0x321386, 0x83f2, 0x8212, 0xc61a, 0x0 }, /* #82 */
    { 0x3612c3, 0x361286, 0xbd89, 0x9800, 0xda34, 0x0 }, /* #83 */
    { 0x383f86, 0x383702, 0x7d83, 0x7983, 0xfb93, 0x0 }, /* #84 */
    { 0x227452, 0x227482, 0x89ff, 0x8037, 0xd037, 0x0 }, /* #85 */
    { 0x250843, 0x250002, 0xc652, 0x4040, 0x6044, 0x0 }, /* #86 */
    { 0x3b5206, 0x3b5202, 0x2b4a, 0x2108, 0x21bd, 0x0 }, /* #87 */
    { 0x324406, 0x324486, 0x89d5, 0x8800, 0xfa00, 0x0 }, /* #88 */
    { 0x383c06, 0x383406, 0x047a, 0x0442, 0x4f47, 0x0 }, /* #89 */
    { 0x032f06, 0x032706, 0x1176, 0x0144, 0x0fc4, 0x0 }, /* #90 */
    { 0x142d17, 0x142506, 0x5a90, 0x5000, 0x5541, 0x0 }, /* #91 */
    { 0x217e86, 0x217606, 0x0e0b, 0x000a, 0xd04e, 0x0 }, /* #92 */
    { 0x2c2a43, 0x2c2282, 0xffa3, 0xf9a1, 0xf9ed, 0x0 }, /* #93 */
    { 0x2f1442, 0x2f1402, 0x6910, 0x4910, 0x4bd5, 0x0 }, /* #94 */
    { 0x135e57, 0x135602, 0x4ad1, 0x4840, 0x7940, 0x0 }, /* #95 */
};
uint32_t const g_cTests_and_u16 = RT_ELEMENTS(g_aTests_and_u16);

BINU16_TEST_T const g_aTests_and_u16_locked[] =
{
    { 0x2c31c7, 0x2c3146, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x0577d6, 0x057746, 0x0000, 0x0000, 0x0000, 0x0 }, /* #1 */
    { 0x2c6053, 0x2c6046, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x092a12, 0x092246, 0x0000, 0x0000, 0x0000, 0x0 }, /* #3 */
    { 0x0b6a42, 0x0b6246, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x366156, 0x366146, 0x0000, 0x0000, 0x0000, 0x0 }, /* #5 */
    { 0x0324d3, 0x032446, 0x5871, 0x0000, 0x0000, 0x0 }, /* #6 */
    { 0x340707, 0x340746, 0xe7bf, 0x0000, 0x0000, 0x0 }, /* #7 */
    { 0x391c02, 0x391446, 0xb607, 0x0000, 0x0000, 0x0 }, /* #8 */
    { 0x180706, 0x180746, 0xa5e4, 0x0000, 0x0000, 0x0 }, /* #9 */
    { 0x247fc7, 0x247746, 0xa34c, 0x0000, 0x0000, 0x0 }, /* #10 */
    { 0x015dd6, 0x015546, 0x5bdd, 0x0000, 0x0000, 0x0 }, /* #11 */
    { 0x131d52, 0x131506, 0x9ff2, 0x1800, 0x1801, 0x0 }, /* #12 */
    { 0x0a5192, 0x0a5102, 0x2e51, 0x0a01, 0x0b2d, 0x0 }, /* #13 */
    { 0x036247, 0x036286, 0xfd06, 0x8906, 0x8b37, 0x0 }, /* #14 */
    { 0x320052, 0x320082, 0xba90, 0x8210, 0xc254, 0x0 }, /* #15 */
    { 0x356716, 0x356786, 0xe2ca, 0xc2c0, 0xc2c5, 0x0 }, /* #16 */
    { 0x0d3ad3, 0x0d3206, 0x03c8, 0x0200, 0xd204, 0x0 }, /* #17 */
    { 0x046cd6, 0x046406, 0x2992, 0x2112, 0xb553, 0x0 }, /* #18 */
    { 0x231492, 0x231402, 0xa19b, 0x2091, 0x2af5, 0x0 }, /* #19 */
    { 0x102d92, 0x102586, 0x944a, 0x9042, 0xd0f7, 0x0 }, /* #20 */
    { 0x1b68c6, 0x1b6002, 0x66b4, 0x2004, 0x300c, 0x0 }, /* #21 */
    { 0x004197, 0x004106, 0xc7a2, 0x40a0, 0x70f8, 0x0 }, /* #22 */
    { 0x166bc6, 0x166382, 0xbee9, 0xa689, 0xe78f, 0x0 }, /* #23 */
    { 0x0d4317, 0x0d4382, 0xed69, 0xe868, 0xeaf8, 0x0 }, /* #24 */
    { 0x3751d3, 0x375182, 0xa7ee, 0x8662, 0x9e62, 0x0 }, /* #25 */
    { 0x0c0083, 0x0c0006, 0x5416, 0x5412, 0x7c9a, 0x0 }, /* #26 */
    { 0x064a93, 0x064202, 0x602b, 0x2029, 0xbb2d, 0x0 }, /* #27 */
    { 0x114a82, 0x114202, 0x59d6, 0x10d0, 0x34d0, 0x0 }, /* #28 */
    { 0x023a16, 0x023282, 0xa8dd, 0xa091, 0xe2b1, 0x0 }, /* #29 */
    { 0x075853, 0x075002, 0x403c, 0x4010, 0x5991, 0x0 }, /* #30 */
    { 0x192bc2, 0x192302, 0xd2bd, 0x5091, 0x78d3, 0x0 }, /* #31 */
    { 0x130843, 0x130002, 0x40d8, 0x0058, 0x185f, 0x0 }, /* #32 */
    { 0x210ec2, 0x210682, 0x95e9, 0x8401, 0xec15, 0x0 }, /* #33 */
    { 0x230bc6, 0x230382, 0xc81f, 0xc01f, 0xf7ff, 0x0 }, /* #34 */
    { 0x3469d6, 0x346106, 0x8885, 0x0800, 0x3b72, 0x0 }, /* #35 */
    { 0x375f06, 0x375702, 0x8c82, 0x0c02, 0x4f6e, 0x0 }, /* #36 */
    { 0x1e0d53, 0x1e0506, 0x2c75, 0x0844, 0x49ce, 0x0 }, /* #37 */
    { 0x2b4452, 0x2b4482, 0xc74e, 0xc546, 0xd566, 0x0 }, /* #38 */
    { 0x224003, 0x224006, 0x6beb, 0x0baa, 0x1bbe, 0x0 }, /* #39 */
    { 0x0b3cd3, 0x0b3402, 0x337c, 0x211c, 0x251d, 0x0 }, /* #40 */
    { 0x322382, 0x322382, 0x9045, 0x9045, 0xfdf5, 0x0 }, /* #41 */
    { 0x091586, 0x091502, 0x46ad, 0x002c, 0x887e, 0x0 }, /* #42 */
    { 0x1b5c83, 0x1b5406, 0x4c34, 0x0c00, 0x8fc3, 0x0 }, /* #43 */
    { 0x2c4cd6, 0x2c4406, 0xbb28, 0x3100, 0x7546, 0x0 }, /* #44 */
    { 0x292386, 0x292386, 0xbf5b, 0x8c03, 0x8ca7, 0x0 }, /* #45 */
    { 0x054dc7, 0x054582, 0xd9bf, 0x9831, 0x9e31, 0x0 }, /* #46 */
    { 0x037107, 0x037102, 0xc9bd, 0x001c, 0x365c, 0x0 }, /* #47 */
    { 0x0f3a56, 0x0f3206, 0xd296, 0x4082, 0x40eb, 0x0 }, /* #48 */
    { 0x0b6cc6, 0x0b6406, 0xfcbe, 0x783a, 0x793a, 0x0 }, /* #49 */
    { 0x121b17, 0x121302, 0x6ff1, 0x6031, 0x6031, 0x0 }, /* #50 */
    { 0x3920c7, 0x392006, 0x32df, 0x3293, 0x3bb3, 0x0 }, /* #51 */
    { 0x1f2f07, 0x1f2706, 0x0097, 0x0087, 0x49e7, 0x0 }, /* #52 */
    { 0x3c3dc2, 0x3c3582, 0x86be, 0x8620, 0xef61, 0x0 }, /* #53 */
    { 0x273782, 0x273702, 0x07a8, 0x0280, 0x4ac0, 0x0 }, /* #54 */
    { 0x0544d7, 0x054486, 0xbe42, 0xbe42, 0xbfde, 0x0 }, /* #55 */
    { 0x214553, 0x214502, 0x12d0, 0x02d0, 0xe2fc, 0x0 }, /* #56 */
    { 0x1e6a83, 0x1e6206, 0x7066, 0x6060, 0x6ee0, 0x0 }, /* #57 */
    { 0x1b0f12, 0x1b0706, 0x5890, 0x5000, 0xf145, 0x0 }, /* #58 */
    { 0x003a16, 0x003202, 0x6f8a, 0x018a, 0x119e, 0x0 }, /* #59 */
    { 0x1c36c7, 0x1c3606, 0x59c3, 0x4841, 0xc849, 0x0 }, /* #60 */
    { 0x100586, 0x100506, 0x476e, 0x040a, 0x240b, 0x0 }, /* #61 */
    { 0x384bd2, 0x384306, 0x3c37, 0x0412, 0x07da, 0x0 }, /* #62 */
    { 0x106183, 0x106102, 0xe958, 0x4010, 0x5694, 0x0 }, /* #63 */
    { 0x382687, 0x382686, 0xefd5, 0xea41, 0xea41, 0x0 }, /* #64 */
    { 0x386e83, 0x386686, 0xa0a8, 0x8028, 0xcf3e, 0x0 }, /* #65 */
    { 0x2c3d17, 0x2c3506, 0x0e0f, 0x0006, 0xb016, 0x0 }, /* #66 */
    { 0x3e1146, 0x3e1186, 0xa5ca, 0x8500, 0x8f04, 0x0 }, /* #67 */
    { 0x365797, 0x365702, 0x058b, 0x0402, 0xfc06, 0x0 }, /* #68 */
    { 0x2607c6, 0x260702, 0x9903, 0x1802, 0x7ae2, 0x0 }, /* #69 */
    { 0x120657, 0x120602, 0x5554, 0x1504, 0x37a7, 0x0 }, /* #70 */
    { 0x1d5407, 0x1d5402, 0x7a19, 0x1208, 0x924a, 0x0 }, /* #71 */
    { 0x1066c7, 0x106606, 0xb898, 0x1818, 0x1b7f, 0x0 }, /* #72 */
    { 0x2753d3, 0x275382, 0xe556, 0x8054, 0x8a5d, 0x0 }, /* #73 */
    { 0x331053, 0x331002, 0x2497, 0x0407, 0xdc07, 0x0 }, /* #74 */
    { 0x116f06, 0x116702, 0x3202, 0x3202, 0xbbb2, 0x0 }, /* #75 */
    { 0x0b6087, 0x0b6006, 0x24fa, 0x205a, 0x225e, 0x0 }, /* #76 */
    { 0x2e7606, 0x2e7682, 0xca79, 0x8079, 0x85f9, 0x0 }, /* #77 */
    { 0x153817, 0x153006, 0x1e5c, 0x0814, 0x68b7, 0x0 }, /* #78 */
    { 0x371f06, 0x371782, 0xa98a, 0x8880, 0xc8f5, 0x0 }, /* #79 */
    { 0x182147, 0x182102, 0x3c81, 0x1801, 0x1813, 0x0 }, /* #80 */
    { 0x3f0657, 0x3f0602, 0x03f6, 0x0270, 0x7670, 0x0 }, /* #81 */
    { 0x071157, 0x071102, 0x5250, 0x5210, 0x779f, 0x0 }, /* #82 */
    { 0x3c3253, 0x3c3202, 0xa6de, 0x224a, 0x3b6a, 0x0 }, /* #83 */
    { 0x212d17, 0x212506, 0x74ff, 0x0017, 0x8817, 0x0 }, /* #84 */
    { 0x0a77c7, 0x0a7702, 0x071d, 0x0008, 0x680a, 0x0 }, /* #85 */
    { 0x3c7997, 0x3c7182, 0x8b36, 0x8816, 0xdc5e, 0x0 }, /* #86 */
    { 0x056a06, 0x056202, 0x7f7b, 0x6c2a, 0x6cae, 0x0 }, /* #87 */
    { 0x3e3157, 0x3e3106, 0x772a, 0x3122, 0xb173, 0x0 }, /* #88 */
    { 0x3c7843, 0x3c7002, 0x2189, 0x2001, 0xa873, 0x0 }, /* #89 */
    { 0x304bc7, 0x304306, 0x1aef, 0x1882, 0x3d92, 0x0 }, /* #90 */
    { 0x101b93, 0x101302, 0x5e0f, 0x1807, 0x3917, 0x0 }, /* #91 */
    { 0x3a0ec6, 0x3a0646, 0x0044, 0x0000, 0x152b, 0x0 }, /* #92 */
    { 0x3d2907, 0x3d2182, 0xdf93, 0x8d01, 0xad69, 0x0 }, /* #93 */
    { 0x003a03, 0x003282, 0xd7c6, 0x81c4, 0x81cd, 0x0 }, /* #94 */
    { 0x3d77c7, 0x3d7782, 0xf951, 0x9840, 0x9ee0, 0x0 }, /* #95 */
};
uint32_t const g_cTests_and_u16_locked = RT_ELEMENTS(g_aTests_and_u16_locked);

BINU16_TEST_T const g_aTests_cmp_u16[] =
{
    { 0x060406, 0x060446, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x216a83, 0x216246, 0x0000, 0x0000, 0x0000, 0x0 }, /* #1 */
    { 0x2007d6, 0x200746, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x1a0b13, 0x1a0346, 0x0000, 0x0000, 0x0000, 0x0 }, /* #3 */
    { 0x023043, 0x023046, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x245c03, 0x245446, 0x0000, 0x0000, 0x0000, 0x0 }, /* #5 */
    { 0x3f6e03, 0x3f6606, 0x3dde, 0x3dde, 0x0000, 0x0 }, /* #6 */
    { 0x016816, 0x016002, 0x706e, 0x706e, 0x0000, 0x0 }, /* #7 */
    { 0x311806, 0x311002, 0x26c1, 0x26c1, 0x0000, 0x0 }, /* #8 */
    { 0x321396, 0x321382, 0xce3b, 0xce3b, 0x0000, 0x0 }, /* #9 */
    { 0x3c31c7, 0x3c3182, 0xfb01, 0xfb01, 0x0000, 0x0 }, /* #10 */
    { 0x192dc7, 0x192506, 0x79d7, 0x79d7, 0x0000, 0x0 }, /* #11 */
    { 0x123e57, 0x123e97, 0x6242, 0x6242, 0xdc0d, 0x0 }, /* #12 */
    { 0x157252, 0x157297, 0x9dd1, 0x9dd1, 0xefb4, 0x0 }, /* #13 */
    { 0x286012, 0x286093, 0x2552, 0x2552, 0x39aa, 0x0 }, /* #14 */
    { 0x0b0303, 0x0b0316, 0x0ee7, 0x0ee7, 0x023d, 0x0 }, /* #15 */
    { 0x153dc7, 0x153587, 0xde26, 0xde26, 0xf593, 0x0 }, /* #16 */
    { 0x280a16, 0x280a97, 0x6f32, 0x6f32, 0xe65b, 0x0 }, /* #17 */
    { 0x2c6c97, 0x2c6402, 0x5c0e, 0x5c0e, 0x315b, 0x0 }, /* #18 */
    { 0x046e83, 0x046e97, 0x2e82, 0x2e82, 0x87b8, 0x0 }, /* #19 */
    { 0x050a53, 0x050212, 0x0f76, 0x0f76, 0x043e, 0x0 }, /* #20 */
    { 0x333c93, 0x333483, 0x5e8b, 0x5e8b, 0x6ec7, 0x0 }, /* #21 */
    { 0x116583, 0x116597, 0xab2b, 0xab2b, 0xffde, 0x0 }, /* #22 */
    { 0x2a2d96, 0x2a2596, 0xed59, 0xed59, 0x3e0c, 0x0 }, /* #23 */
    { 0x1478d6, 0x147007, 0x3749, 0x3749, 0xd4a6, 0x0 }, /* #24 */
    { 0x0e5653, 0x0e5687, 0xe858, 0xe858, 0xf9e4, 0x0 }, /* #25 */
    { 0x0d7382, 0x0d7303, 0x2b9a, 0x2b9a, 0xe481, 0x0 }, /* #26 */
    { 0x216906, 0x216912, 0x91c5, 0x91c5, 0x5da6, 0x0 }, /* #27 */
    { 0x3a5a13, 0x3a5a06, 0x8bdf, 0x8bdf, 0x1ca9, 0x0 }, /* #28 */
    { 0x1e6413, 0x1e6497, 0x9f96, 0x9f96, 0xcd9a, 0x0 }, /* #29 */
    { 0x3e0e46, 0x3e0683, 0x5c6c, 0x5c6c, 0x6a01, 0x0 }, /* #30 */
    { 0x366997, 0x366196, 0x9c57, 0x9c57, 0x1918, 0x0 }, /* #31 */
    { 0x1e5ec3, 0x1e5692, 0x9fd9, 0x9fd9, 0x026e, 0x0 }, /* #32 */
    { 0x2319d7, 0x231106, 0xcfc4, 0xcfc4, 0xc934, 0x0 }, /* #33 */
    { 0x024112, 0x024196, 0xbc42, 0xbc42, 0x0eaf, 0x0 }, /* #34 */
    { 0x214b52, 0x214b93, 0x5bc5, 0x5bc5, 0xa0cd, 0x0 }, /* #35 */
    { 0x060092, 0x060097, 0x9ee5, 0x9ee5, 0xe068, 0x0 }, /* #36 */
    { 0x074583, 0x074597, 0xb0e3, 0xb0e3, 0xb52f, 0x0 }, /* #37 */
    { 0x0c0b82, 0x0c0306, 0x657c, 0x657c, 0x2408, 0x0 }, /* #38 */
    { 0x147ac7, 0x147297, 0x3bf6, 0x3bf6, 0x6b97, 0x0 }, /* #39 */
    { 0x1c5306, 0x1c5386, 0xeaa3, 0xeaa3, 0x0a53, 0x0 }, /* #40 */
    { 0x3f6d86, 0x3f6596, 0xe9dd, 0xe9dd, 0x527e, 0x0 }, /* #41 */
    { 0x0d3307, 0x0d3392, 0xb5bb, 0xb5bb, 0x1a9c, 0x0 }, /* #42 */
    { 0x3d7392, 0x3d7316, 0x2008, 0x2008, 0x15cc, 0x0 }, /* #43 */
    { 0x095552, 0x095516, 0x4271, 0x4271, 0x3bab, 0x0 }, /* #44 */
    { 0x3b6397, 0x3b6382, 0xf8a7, 0xf8a7, 0x14b5, 0x0 }, /* #45 */
    { 0x246282, 0x246a02, 0x85c8, 0x85c8, 0x5a58, 0x0 }, /* #46 */
    { 0x0b3f06, 0x0b3703, 0x13e3, 0x13e3, 0xa003, 0x0 }, /* #47 */
    { 0x1f7813, 0x1f7016, 0x6c85, 0x6c85, 0x20fa, 0x0 }, /* #48 */
    { 0x104c56, 0x104483, 0x900f, 0x900f, 0xfad1, 0x0 }, /* #49 */
    { 0x287813, 0x287006, 0xf7f8, 0xf7f8, 0xe9b1, 0x0 }, /* #50 */
    { 0x032e47, 0x032e93, 0x14a0, 0x14a0, 0x89d5, 0x0 }, /* #51 */
    { 0x097783, 0x097706, 0x7af7, 0x7af7, 0x2c20, 0x0 }, /* #52 */
    { 0x0173d3, 0x017383, 0x900f, 0x900f, 0x9199, 0x0 }, /* #53 */
    { 0x163607, 0x163603, 0x021f, 0x021f, 0xe48d, 0x0 }, /* #54 */
    { 0x346a47, 0x346296, 0xb8f1, 0xb8f1, 0x30ca, 0x0 }, /* #55 */
    { 0x1b2b17, 0x1b2382, 0xec55, 0xec55, 0x4c53, 0x0 }, /* #56 */
    { 0x036c87, 0x036483, 0x04e9, 0x04e9, 0x29b7, 0x0 }, /* #57 */
    { 0x1e1cc2, 0x1e1416, 0x6058, 0x6058, 0x48da, 0x0 }, /* #58 */
    { 0x0c0896, 0x0c0016, 0x643a, 0x643a, 0x5efb, 0x0 }, /* #59 */
    { 0x186d52, 0x186502, 0x6c08, 0x6c08, 0x6182, 0x0 }, /* #60 */
    { 0x045e46, 0x045683, 0x8ab8, 0x8ab8, 0xef02, 0x0 }, /* #61 */
    { 0x311fc3, 0x311797, 0x7e81, 0x7e81, 0x7fe8, 0x0 }, /* #62 */
    { 0x3f6b87, 0x3f6307, 0x1726, 0x1726, 0xab12, 0x0 }, /* #63 */
    { 0x375dc6, 0x375597, 0xd3b6, 0xd3b6, 0xfb98, 0x0 }, /* #64 */
    { 0x151cd6, 0x151402, 0x33ef, 0x33ef, 0x25e1, 0x0 }, /* #65 */
    { 0x1c4cc6, 0x1c4497, 0xad86, 0xad86, 0xdd9e, 0x0 }, /* #66 */
    { 0x236d43, 0x236d06, 0xcb19, 0xcb19, 0x7779, 0x0 }, /* #67 */
    { 0x1a0002, 0x1a0883, 0x44fe, 0x44fe, 0x8dac, 0x0 }, /* #68 */
    { 0x346892, 0x346002, 0x62f9, 0x62f9, 0x0483, 0x0 }, /* #69 */
    { 0x3c0893, 0x3c0092, 0xa097, 0xa097, 0x07a8, 0x0 }, /* #70 */
    { 0x385cd2, 0x385407, 0x1d8a, 0x1d8a, 0xaf49, 0x0 }, /* #71 */
    { 0x110313, 0x110b06, 0xe7bf, 0xe7bf, 0x6e19, 0x0 }, /* #72 */
    { 0x1e2483, 0x1e2c83, 0x2abb, 0x2abb, 0xa7d5, 0x0 }, /* #73 */
    { 0x2e1847, 0x2e1003, 0x2fd3, 0x2fd3, 0xc681, 0x0 }, /* #74 */
    { 0x2c5b02, 0x2c5317, 0x2383, 0x2383, 0xd43b, 0x0 }, /* #75 */
    { 0x341753, 0x341787, 0x443e, 0x443e, 0x6e53, 0x0 }, /* #76 */
    { 0x273f42, 0x273f02, 0x9c07, 0x9c07, 0x4291, 0x0 }, /* #77 */
    { 0x246b13, 0x246393, 0xbeca, 0xbeca, 0xd66d, 0x0 }, /* #78 */
    { 0x384c43, 0x384407, 0x2632, 0x2632, 0xac81, 0x0 }, /* #79 */
    { 0x152e96, 0x152e83, 0x395e, 0x395e, 0x8038, 0x0 }, /* #80 */
    { 0x211a03, 0x211206, 0x712c, 0x712c, 0x22eb, 0x0 }, /* #81 */
    { 0x136f16, 0x136783, 0x83e9, 0x83e9, 0x8f27, 0x0 }, /* #82 */
    { 0x234206, 0x234217, 0x3f42, 0x3f42, 0xe417, 0x0 }, /* #83 */
    { 0x3d6387, 0x3d6386, 0xed71, 0xed71, 0x5000, 0x0 }, /* #84 */
    { 0x1d1d02, 0x1d1507, 0x3753, 0x3753, 0xf150, 0x0 }, /* #85 */
    { 0x0a14c2, 0x0a1496, 0xc6b4, 0xc6b4, 0x0b18, 0x0 }, /* #86 */
    { 0x3154c6, 0x315406, 0x49c3, 0x49c3, 0x0ed3, 0x0 }, /* #87 */
    { 0x0929d3, 0x092997, 0x6584, 0x6584, 0xb497, 0x0 }, /* #88 */
    { 0x0c5953, 0x0c5193, 0x2bec, 0x2bec, 0x628f, 0x0 }, /* #89 */
    { 0x2f5416, 0x2f5493, 0x5423, 0x5423, 0x5a28, 0x0 }, /* #90 */
    { 0x164216, 0x164287, 0x35d7, 0x35d7, 0x7105, 0x0 }, /* #91 */
    { 0x0421c7, 0x042997, 0x6960, 0x6960, 0x8f49, 0x0 }, /* #92 */
    { 0x033fd6, 0x033796, 0xa2c8, 0xa2c8, 0x1eaa, 0x0 }, /* #93 */
    { 0x314c47, 0x314413, 0x4cd9, 0x4cd9, 0xf21a, 0x0 }, /* #94 */
    { 0x222b06, 0x222313, 0x0a5a, 0x0a5a, 0xfcad, 0x0 }, /* #95 */
};
uint32_t const g_cTests_cmp_u16 = RT_ELEMENTS(g_aTests_cmp_u16);

BINU16_TEST_T const g_aTests_test_u16[] =
{
    { 0x2a2802, 0x2a2046, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x2e5c57, 0x2e5446, 0x0000, 0x0000, 0x0000, 0x0 }, /* #1 */
    { 0x3f6a13, 0x3f6246, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x352403, 0x352446, 0x0000, 0x0000, 0x0000, 0x0 }, /* #3 */
    { 0x1e65c2, 0x1e6546, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x2a2b87, 0x2a2346, 0x0000, 0x0000, 0x0000, 0x0 }, /* #5 */
    { 0x373183, 0x373146, 0xf551, 0xf551, 0x0000, 0x0 }, /* #6 */
    { 0x2b49d6, 0x2b4146, 0x377b, 0x377b, 0x0000, 0x0 }, /* #7 */
    { 0x364e12, 0x364646, 0xe5b2, 0xe5b2, 0x0000, 0x0 }, /* #8 */
    { 0x103792, 0x103746, 0x1370, 0x1370, 0x0000, 0x0 }, /* #9 */
    { 0x0875d6, 0x087546, 0x407f, 0x407f, 0x0000, 0x0 }, /* #10 */
    { 0x281602, 0x281646, 0xd4f2, 0xd4f2, 0x0000, 0x0 }, /* #11 */
    { 0x2c2803, 0x2c2002, 0x1fbe, 0x1fbe, 0x928c, 0x0 }, /* #12 */
    { 0x170603, 0x170602, 0xc107, 0xc107, 0x17fc, 0x0 }, /* #13 */
    { 0x0a2ec3, 0x0a2682, 0xddf9, 0xddf9, 0xbc37, 0x0 }, /* #14 */
    { 0x2a0ad3, 0x2a0206, 0x12f1, 0x12f1, 0xf2c2, 0x0 }, /* #15 */
    { 0x2f7257, 0x2f7206, 0xa242, 0xa242, 0x6cef, 0x0 }, /* #16 */
    { 0x0948d6, 0x094082, 0xfb51, 0xfb51, 0xa1e0, 0x0 }, /* #17 */
    { 0x086dc7, 0x086502, 0xdebb, 0xdebb, 0x55f4, 0x0 }, /* #18 */
    { 0x082956, 0x082186, 0xee0a, 0xee0a, 0xb5b1, 0x0 }, /* #19 */
    { 0x002913, 0x002102, 0x7288, 0x7288, 0x0e3d, 0x0 }, /* #20 */
    { 0x332e53, 0x332606, 0x1237, 0x1237, 0x119a, 0x0 }, /* #21 */
    { 0x3e4017, 0x3e4006, 0xb7c9, 0xb7c9, 0x5ee6, 0x0 }, /* #22 */
    { 0x050212, 0x050202, 0xf60b, 0xf60b, 0x085b, 0x0 }, /* #23 */
    { 0x124846, 0x124086, 0xce9a, 0xce9a, 0xc8be, 0x0 }, /* #24 */
    { 0x306e47, 0x306682, 0x98e6, 0x98e6, 0xefb4, 0x0 }, /* #25 */
    { 0x1d5503, 0x1d5506, 0x972d, 0x972d, 0x1e4c, 0x0 }, /* #26 */
    { 0x067f83, 0x067702, 0x8de8, 0x8de8, 0x6b32, 0x0 }, /* #27 */
    { 0x285f12, 0x285706, 0x0b8a, 0x0b8a, 0x25c7, 0x0 }, /* #28 */
    { 0x311483, 0x311406, 0x5fd1, 0x5fd1, 0xbe69, 0x0 }, /* #29 */
    { 0x3309d3, 0x330186, 0xfc25, 0xfc25, 0x8aa6, 0x0 }, /* #30 */
    { 0x371f42, 0x371702, 0xf31c, 0xf31c, 0x185f, 0x0 }, /* #31 */
    { 0x3c3286, 0x3c3206, 0x34f4, 0x34f4, 0x91fb, 0x0 }, /* #32 */
    { 0x320383, 0x320382, 0xa17b, 0xa17b, 0xff51, 0x0 }, /* #33 */
    { 0x003083, 0x003002, 0x5e7c, 0x5e7c, 0xd841, 0x0 }, /* #34 */
    { 0x1577c6, 0x157706, 0x5679, 0x5679, 0x4e91, 0x0 }, /* #35 */
    { 0x213a12, 0x213202, 0x6dee, 0x6dee, 0x3a31, 0x0 }, /* #36 */
    { 0x270a13, 0x270282, 0xfd47, 0xfd47, 0x9353, 0x0 }, /* #37 */
    { 0x0261c6, 0x026106, 0x6a57, 0x6a57, 0x5bea, 0x0 }, /* #38 */
    { 0x066206, 0x066206, 0xd16a, 0xd16a, 0x7501, 0x0 }, /* #39 */
    { 0x2f7b02, 0x2f7302, 0x057e, 0x057e, 0x264b, 0x0 }, /* #40 */
    { 0x303356, 0x303306, 0x72be, 0x72be, 0x1837, 0x0 }, /* #41 */
    { 0x070b83, 0x070386, 0xc962, 0xc962, 0xc8fc, 0x0 }, /* #42 */
    { 0x161253, 0x161206, 0x09ba, 0x09ba, 0x5219, 0x0 }, /* #43 */
    { 0x262192, 0x262102, 0x1815, 0x1815, 0x31ae, 0x0 }, /* #44 */
    { 0x1e7292, 0x1e7202, 0x4e67, 0x4e67, 0x0d6a, 0x0 }, /* #45 */
    { 0x390986, 0x390106, 0x28df, 0x28df, 0x78f4, 0x0 }, /* #46 */
    { 0x120716, 0x120786, 0xd659, 0xd659, 0x8931, 0x0 }, /* #47 */
    { 0x2102d7, 0x210246, 0xe028, 0xe028, 0x0597, 0x0 }, /* #48 */
    { 0x1330c3, 0x133082, 0xede1, 0xede1, 0xc84c, 0x0 }, /* #49 */
    { 0x352257, 0x352202, 0x3b9c, 0x3b9c, 0xd980, 0x0 }, /* #50 */
    { 0x1f1f17, 0x1f1706, 0x6cba, 0x6cba, 0x36db, 0x0 }, /* #51 */
    { 0x016442, 0x016406, 0x36df, 0x36df, 0x94ec, 0x0 }, /* #52 */
    { 0x131852, 0x131002, 0x3c2b, 0x3c2b, 0xb3ad, 0x0 }, /* #53 */
    { 0x2443d2, 0x244306, 0x09aa, 0x09aa, 0x3c33, 0x0 }, /* #54 */
    { 0x206447, 0x206406, 0xff81, 0xff81, 0x76e7, 0x0 }, /* #55 */
    { 0x2f4c46, 0x2f4406, 0x7202, 0x7202, 0x5105, 0x0 }, /* #56 */
    { 0x0c57d2, 0x0c5706, 0xa996, 0xa996, 0x13e2, 0x0 }, /* #57 */
    { 0x3b6c82, 0x3b6406, 0x0df9, 0x0df9, 0x819d, 0x0 }, /* #58 */
    { 0x076507, 0x076506, 0x0e9f, 0x0e9f, 0xda37, 0x0 }, /* #59 */
    { 0x125b46, 0x125306, 0x0759, 0x0759, 0xedc5, 0x0 }, /* #60 */
    { 0x294a52, 0x294202, 0x4897, 0x4897, 0x4113, 0x0 }, /* #61 */
    { 0x1f1b83, 0x1f1382, 0xc1db, 0xc1db, 0xf24d, 0x0 }, /* #62 */
    { 0x111692, 0x111602, 0x41f5, 0x41f5, 0xb075, 0x0 }, /* #63 */
    { 0x1c0057, 0x1c0002, 0xa712, 0xa712, 0x4298, 0x0 }, /* #64 */
    { 0x2e6943, 0x2e6106, 0xe485, 0xe485, 0x6c5d, 0x0 }, /* #65 */
    { 0x145c46, 0x145402, 0x9070, 0x9070, 0x03a0, 0x0 }, /* #66 */
    { 0x203152, 0x203106, 0x9c00, 0x9c00, 0x38b4, 0x0 }, /* #67 */
    { 0x074e12, 0x074602, 0x435d, 0x435d, 0xe8b0, 0x0 }, /* #68 */
    { 0x3a1c16, 0x3a1406, 0x73e2, 0x73e2, 0xe71c, 0x0 }, /* #69 */
    { 0x3a5217, 0x3a5206, 0x471c, 0x471c, 0xec41, 0x0 }, /* #70 */
    { 0x1c6483, 0x1c6406, 0xcb82, 0xcb82, 0x4c49, 0x0 }, /* #71 */
    { 0x1f10c2, 0x1f1006, 0x2f0b, 0x2f0b, 0x17be, 0x0 }, /* #72 */
    { 0x142c87, 0x142402, 0x1fd0, 0x1fd0, 0x7dac, 0x0 }, /* #73 */
    { 0x391a56, 0x391206, 0x0e12, 0x0e12, 0xbeda, 0x0 }, /* #74 */
    { 0x137903, 0x137102, 0x403d, 0x403d, 0x62a0, 0x0 }, /* #75 */
    { 0x186f13, 0x186706, 0x9f26, 0x9f26, 0x1c0f, 0x0 }, /* #76 */
    { 0x0c7c06, 0x0c7402, 0x7853, 0x7853, 0x6729, 0x0 }, /* #77 */
    { 0x0332d3, 0x033202, 0x5a58, 0x5a58, 0x4210, 0x0 }, /* #78 */
    { 0x3f4a87, 0x3f4202, 0x7f12, 0x7f12, 0xf96a, 0x0 }, /* #79 */
    { 0x343fd3, 0x343702, 0x1131, 0x1131, 0xfffd, 0x0 }, /* #80 */
    { 0x2b62d2, 0x2b6202, 0x7f0b, 0x7f0b, 0xd86b, 0x0 }, /* #81 */
    { 0x2a1b96, 0x2a1386, 0xc6af, 0xc6af, 0xd6ac, 0x0 }, /* #82 */
    { 0x152986, 0x152186, 0x9590, 0x9590, 0x940a, 0x0 }, /* #83 */
    { 0x391592, 0x391502, 0xf95a, 0xf95a, 0x1b35, 0x0 }, /* #84 */
    { 0x2f5687, 0x2f5686, 0x8640, 0x8640, 0xcc1e, 0x0 }, /* #85 */
    { 0x3f0a13, 0x3f0206, 0x547e, 0x547e, 0x7f0c, 0x0 }, /* #86 */
    { 0x341112, 0x341182, 0xed30, 0xed30, 0xce52, 0x0 }, /* #87 */
    { 0x3f4b47, 0x3f4302, 0xef84, 0xef84, 0x678b, 0x0 }, /* #88 */
    { 0x3b4113, 0x3b4182, 0xbff2, 0xbff2, 0x8393, 0x0 }, /* #89 */
    { 0x191452, 0x191402, 0x555a, 0x555a, 0x9ca9, 0x0 }, /* #90 */
    { 0x3a4187, 0x3a4102, 0xc1a2, 0xc1a2, 0x161a, 0x0 }, /* #91 */
    { 0x101916, 0x101106, 0x8975, 0x8975, 0x1d73, 0x0 }, /* #92 */
    { 0x2a5113, 0x2a5102, 0x0f35, 0x0f35, 0x57cc, 0x0 }, /* #93 */
    { 0x265f87, 0x265702, 0x23a7, 0x23a7, 0x8ea7, 0x0 }, /* #94 */
    { 0x175f97, 0x175786, 0xa228, 0xa228, 0x9012, 0x0 }, /* #95 */
};
uint32_t const g_cTests_test_u16 = RT_ELEMENTS(g_aTests_test_u16);

BINU16_TEST_T const g_aTests_bt_u16[] =
{
    { 0x380d52, 0x380d52, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x0b3a52, 0x0b3a52, 0x0000, 0x0000, 0x0000, 0x0 }, /* #1 */
    { 0x076257, 0x076256, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x271757, 0x271756, 0x0000, 0x0000, 0x0000, 0x0 }, /* #3 */
    { 0x3c5993, 0x3c5992, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x0361d6, 0x0361d6, 0x0000, 0x0000, 0x0000, 0x0 }, /* #5 */
    { 0x176383, 0x176383, 0x806f, 0x806f, 0x0000, 0x0 }, /* #6 */
    { 0x1e7312, 0x1e7312, 0x0e98, 0x0e98, 0x0000, 0x0 }, /* #7 */
    { 0x1e6b13, 0x1e6b12, 0xfe72, 0xfe72, 0x0000, 0x0 }, /* #8 */
    { 0x360497, 0x360497, 0x81df, 0x81df, 0x0000, 0x0 }, /* #9 */
    { 0x080d53, 0x080d52, 0x046c, 0x046c, 0x0000, 0x0 }, /* #10 */
    { 0x3a2443, 0x3a2442, 0x0a40, 0x0a40, 0x0000, 0x0 }, /* #11 */
    { 0x184bd6, 0x184bd6, 0x9399, 0x9399, 0x000e, 0x0 }, /* #12 */
    { 0x2e6dc3, 0x2e6dc3, 0x78ad, 0x78ad, 0x0002, 0x0 }, /* #13 */
    { 0x365503, 0x365503, 0xfe2f, 0xfe2f, 0x000d, 0x0 }, /* #14 */
    { 0x0a0f42, 0x0a0f42, 0x982e, 0x982e, 0x000d, 0x0 }, /* #15 */
    { 0x3641c3, 0x3641c2, 0x9926, 0x9926, 0x0003, 0x0 }, /* #16 */
    { 0x115657, 0x115657, 0x669f, 0x669f, 0x000a, 0x0 }, /* #17 */
    { 0x284302, 0x284303, 0x25e5, 0x25e5, 0x0008, 0x0 }, /* #18 */
    { 0x0d3b02, 0x0d3b02, 0x4c53, 0x4c53, 0x000d, 0x0 }, /* #19 */
    { 0x0c7d16, 0x0c7d17, 0x9513, 0x9513, 0x000f, 0x0 }, /* #20 */
    { 0x3b0dd3, 0x3b0dd3, 0xa3bb, 0xa3bb, 0x000f, 0x0 }, /* #21 */
    { 0x1d3697, 0x1d3696, 0x1473, 0x1473, 0x000b, 0x0 }, /* #22 */
    { 0x351347, 0x351346, 0xa113, 0xa113, 0x0006, 0x0 }, /* #23 */
    { 0x0d2f92, 0x0d2f92, 0x6dc2, 0x6dc2, 0x0005, 0x0 }, /* #24 */
    { 0x2750d3, 0x2750d2, 0xc958, 0xc958, 0x0007, 0x0 }, /* #25 */
    { 0x331b97, 0x331b97, 0xfa1d, 0xfa1d, 0x000c, 0x0 }, /* #26 */
    { 0x392b07, 0x392b06, 0xafad, 0xafad, 0x0004, 0x0 }, /* #27 */
    { 0x0f2dd6, 0x0f2dd6, 0x8440, 0x8440, 0x0007, 0x0 }, /* #28 */
    { 0x360542, 0x360542, 0x02cf, 0x02cf, 0x000e, 0x0 }, /* #29 */
    { 0x337cd2, 0x337cd2, 0x6b73, 0x6b73, 0x0003, 0x0 }, /* #30 */
    { 0x007ac2, 0x007ac3, 0x8eab, 0x8eab, 0x0009, 0x0 }, /* #31 */
    { 0x207386, 0x207386, 0x6d23, 0x6d23, 0x000c, 0x0 }, /* #32 */
    { 0x1121c7, 0x1121c6, 0x28dc, 0x28dc, 0x000f, 0x0 }, /* #33 */
    { 0x1f0ec3, 0x1f0ec3, 0x2727, 0x2727, 0x0009, 0x0 }, /* #34 */
    { 0x201143, 0x201142, 0x9dc1, 0x9dc1, 0x0002, 0x0 }, /* #35 */
    { 0x017cd2, 0x017cd3, 0x0acd, 0x0acd, 0x0003, 0x0 }, /* #36 */
    { 0x0e5517, 0x0e5516, 0x2e5c, 0x2e5c, 0x0005, 0x0 }, /* #37 */
    { 0x3b1b12, 0x3b1b12, 0x4068, 0x4068, 0x000d, 0x0 }, /* #38 */
    { 0x253fc7, 0x253fc7, 0xad12, 0xad12, 0x0004, 0x0 }, /* #39 */
    { 0x0c0d57, 0x0c0d56, 0xc008, 0xc008, 0x0007, 0x0 }, /* #40 */
    { 0x370553, 0x370553, 0x0fce, 0x0fce, 0x0003, 0x0 }, /* #41 */
    { 0x0c0756, 0x0c0757, 0xd8de, 0xd8de, 0x0006, 0x0 }, /* #42 */
    { 0x240086, 0x240086, 0x1498, 0x1498, 0x000d, 0x0 }, /* #43 */
    { 0x354097, 0x354096, 0xa1c4, 0xa1c4, 0x000b, 0x0 }, /* #44 */
    { 0x154e57, 0x154e57, 0x70c4, 0x70c4, 0x000c, 0x0 }, /* #45 */
    { 0x3744c2, 0x3744c3, 0xf148, 0xf148, 0x0003, 0x0 }, /* #46 */
    { 0x336a82, 0x336a82, 0x390d, 0x390d, 0x0004, 0x0 }, /* #47 */
    { 0x0d61c6, 0x0d61c7, 0x7b1e, 0x7b1e, 0x000c, 0x0 }, /* #48 */
    { 0x1c1117, 0x1c1117, 0x69af, 0x69af, 0x0007, 0x0 }, /* #49 */
    { 0x373ec6, 0x373ec7, 0xebf2, 0xebf2, 0x0006, 0x0 }, /* #50 */
    { 0x204293, 0x204292, 0x7f29, 0x7f29, 0x000f, 0x0 }, /* #51 */
    { 0x024a56, 0x024a56, 0x24f9, 0x24f9, 0x0009, 0x0 }, /* #52 */
    { 0x3c7397, 0x3c7397, 0x36db, 0x36db, 0x0007, 0x0 }, /* #53 */
    { 0x126ac3, 0x126ac3, 0xeb74, 0xeb74, 0x0006, 0x0 }, /* #54 */
    { 0x2f6f43, 0x2f6f42, 0xa63c, 0xa63c, 0x000c, 0x0 }, /* #55 */
    { 0x0a4a07, 0x0a4a07, 0x72f5, 0x72f5, 0x0009, 0x0 }, /* #56 */
    { 0x0a3802, 0x0a3803, 0xe3cc, 0xe3cc, 0x000e, 0x0 }, /* #57 */
    { 0x1740d2, 0x1740d3, 0x6d57, 0x6d57, 0x000e, 0x0 }, /* #58 */
    { 0x080f47, 0x080f47, 0xca44, 0xca44, 0x000f, 0x0 }, /* #59 */
    { 0x0b3c43, 0x0b3c42, 0x1fb5, 0x1fb5, 0x000d, 0x0 }, /* #60 */
    { 0x0f6e12, 0x0f6e12, 0x40a8, 0x40a8, 0x0009, 0x0 }, /* #61 */
    { 0x0c4f53, 0x0c4f52, 0x5c19, 0x5c19, 0x000d, 0x0 }, /* #62 */
    { 0x380e03, 0x380e03, 0xe187, 0xe187, 0x0000, 0x0 }, /* #63 */
    { 0x3416c7, 0x3416c6, 0xcca0, 0xcca0, 0x0006, 0x0 }, /* #64 */
    { 0x164282, 0x164283, 0x3b6c, 0x3b6c, 0x000c, 0x0 }, /* #65 */
    { 0x0f21c2, 0x0f21c2, 0xc33c, 0xc33c, 0x000d, 0x0 }, /* #66 */
    { 0x1e6b83, 0x1e6b83, 0x25e5, 0x25e5, 0x000a, 0x0 }, /* #67 */
    { 0x131186, 0x131187, 0xed2b, 0xed2b, 0x000d, 0x0 }, /* #68 */
    { 0x1558d2, 0x1558d2, 0x2bcb, 0x2bcb, 0x0002, 0x0 }, /* #69 */
    { 0x261697, 0x261696, 0x1268, 0x1268, 0x0001, 0x0 }, /* #70 */
    { 0x032796, 0x032797, 0x07bc, 0x07bc, 0x0007, 0x0 }, /* #71 */
    { 0x354693, 0x354692, 0xaac2, 0xaac2, 0x0008, 0x0 }, /* #72 */
    { 0x005747, 0x005746, 0xd701, 0xd701, 0x0006, 0x0 }, /* #73 */
    { 0x1822d2, 0x1822d2, 0xd351, 0xd351, 0x0005, 0x0 }, /* #74 */
    { 0x3d5382, 0x3d5382, 0xe900, 0xe900, 0x000a, 0x0 }, /* #75 */
    { 0x120d93, 0x120d93, 0xfc7c, 0xfc7c, 0x000e, 0x0 }, /* #76 */
    { 0x2f7d87, 0x2f7d87, 0x07af, 0x07af, 0x000a, 0x0 }, /* #77 */
    { 0x0e3b92, 0x0e3b92, 0x84f1, 0x84f1, 0x0002, 0x0 }, /* #78 */
    { 0x1671c3, 0x1671c2, 0x1ab3, 0x1ab3, 0x000a, 0x0 }, /* #79 */
    { 0x073502, 0x073503, 0x7329, 0x7329, 0x0008, 0x0 }, /* #80 */
    { 0x096297, 0x096296, 0x0a4e, 0x0a4e, 0x0008, 0x0 }, /* #81 */
    { 0x3f6452, 0x3f6453, 0x0e89, 0x0e89, 0x0007, 0x0 }, /* #82 */
    { 0x284402, 0x284403, 0x42bb, 0x42bb, 0x0009, 0x0 }, /* #83 */
    { 0x2b7403, 0x2b7403, 0xb27f, 0xb27f, 0x0000, 0x0 }, /* #84 */
    { 0x3c2b03, 0x3c2b03, 0xd06e, 0xd06e, 0x0006, 0x0 }, /* #85 */
    { 0x2553c7, 0x2553c7, 0xe81c, 0xe81c, 0x000d, 0x0 }, /* #86 */
    { 0x2647d3, 0x2647d3, 0xfd17, 0xfd17, 0x000b, 0x0 }, /* #87 */
    { 0x3d5687, 0x3d5686, 0x11d7, 0x11d7, 0x000d, 0x0 }, /* #88 */
    { 0x0b47c2, 0x0b47c3, 0x9c5c, 0x9c5c, 0x0003, 0x0 }, /* #89 */
    { 0x1b6ad2, 0x1b6ad3, 0x78e5, 0x78e5, 0x000b, 0x0 }, /* #90 */
    { 0x333bd6, 0x333bd7, 0x2688, 0x2688, 0x0007, 0x0 }, /* #91 */
    { 0x3c4046, 0x3c4046, 0x63df, 0x63df, 0x000a, 0x0 }, /* #92 */
    { 0x3d6993, 0x3d6993, 0xfcff, 0xfcff, 0x000a, 0x0 }, /* #93 */
    { 0x0f0e02, 0x0f0e02, 0x28ca, 0x28ca, 0x0000, 0x0 }, /* #94 */
    { 0x1c2402, 0x1c2403, 0x27c7, 0x27c7, 0x0001, 0x0 }, /* #95 */
};
uint32_t const g_cTests_bt_u16 = RT_ELEMENTS(g_aTests_bt_u16);

BINU16_TEST_T const g_aTests_btc_u16[] =
{
    { 0x200996, 0x200996, 0x0000, 0x0001, 0x0000, 0x0 }, /* #0 */
    { 0x066543, 0x066542, 0x0000, 0x0001, 0x0000, 0x0 }, /* #1 */
    { 0x356e02, 0x356e02, 0x0000, 0x0001, 0x0000, 0x0 }, /* #2 */
    { 0x1c2002, 0x1c2002, 0x0000, 0x0001, 0x0000, 0x0 }, /* #3 */
    { 0x2358c2, 0x2358c2, 0x0000, 0x0001, 0x0000, 0x0 }, /* #4 */
    { 0x0a4a42, 0x0a4a42, 0x0000, 0x0001, 0x0000, 0x0 }, /* #5 */
    { 0x274a46, 0x274a46, 0x999e, 0x999f, 0x0000, 0x0 }, /* #6 */
    { 0x1a6fc6, 0x1a6fc7, 0x17a3, 0x17a2, 0x0000, 0x0 }, /* #7 */
    { 0x1264c2, 0x1264c3, 0x6e19, 0x6e18, 0x0000, 0x0 }, /* #8 */
    { 0x021512, 0x021513, 0x5e3d, 0x5e3c, 0x0000, 0x0 }, /* #9 */
    { 0x350117, 0x350117, 0xcd73, 0xcd72, 0x0000, 0x0 }, /* #10 */
    { 0x002382, 0x002383, 0x8a11, 0x8a10, 0x0000, 0x0 }, /* #11 */
    { 0x0e5812, 0x0e5813, 0x6d05, 0x4d05, 0x000d, 0x0 }, /* #12 */
    { 0x2a61d6, 0x2a61d7, 0x070c, 0x050c, 0x0009, 0x0 }, /* #13 */
    { 0x312452, 0x312453, 0xff9a, 0xff98, 0x0001, 0x0 }, /* #14 */
    { 0x0b4a53, 0x0b4a52, 0x83f3, 0x8bf3, 0x000b, 0x0 }, /* #15 */
    { 0x013b13, 0x013b12, 0xd411, 0xd511, 0x0008, 0x0 }, /* #16 */
    { 0x2723c7, 0x2723c6, 0x8070, 0x8078, 0x0003, 0x0 }, /* #17 */
    { 0x3a0dd2, 0x3a0dd3, 0x998e, 0x988e, 0x0008, 0x0 }, /* #18 */
    { 0x3647d2, 0x3647d3, 0xfd87, 0xfc87, 0x0008, 0x0 }, /* #19 */
    { 0x2e55c3, 0x2e55c3, 0x957b, 0x956b, 0x0004, 0x0 }, /* #20 */
    { 0x395716, 0x395716, 0x8128, 0x812c, 0x0002, 0x0 }, /* #21 */
    { 0x3f2d52, 0x3f2d53, 0x3b2b, 0x3b2a, 0x0000, 0x0 }, /* #22 */
    { 0x2943c3, 0x2943c3, 0x6846, 0x4846, 0x000d, 0x0 }, /* #23 */
    { 0x310397, 0x310397, 0xaaca, 0xaac2, 0x0003, 0x0 }, /* #24 */
    { 0x070f92, 0x070f93, 0xe2b9, 0xe299, 0x0005, 0x0 }, /* #25 */
    { 0x222e86, 0x222e86, 0xe66a, 0xe66b, 0x0000, 0x0 }, /* #26 */
    { 0x1b0983, 0x1b0982, 0xd839, 0xd83b, 0x0001, 0x0 }, /* #27 */
    { 0x302907, 0x302906, 0x5db3, 0x7db3, 0x000d, 0x0 }, /* #28 */
    { 0x076907, 0x076906, 0x97de, 0x97fe, 0x0005, 0x0 }, /* #29 */
    { 0x271617, 0x271617, 0xe7b9, 0xe7a9, 0x0004, 0x0 }, /* #30 */
    { 0x1a1346, 0x1a1346, 0xf3c8, 0xfbc8, 0x000b, 0x0 }, /* #31 */
    { 0x2d3d87, 0x2d3d86, 0x1d20, 0x9d20, 0x000f, 0x0 }, /* #32 */
    { 0x3d4c02, 0x3d4c03, 0x87f0, 0x87e0, 0x0004, 0x0 }, /* #33 */
    { 0x140597, 0x140597, 0xad7d, 0x8d7d, 0x000d, 0x0 }, /* #34 */
    { 0x1f0902, 0x1f0903, 0xd7c5, 0xd785, 0x0006, 0x0 }, /* #35 */
    { 0x226086, 0x226087, 0x7bf8, 0x7bd8, 0x0005, 0x0 }, /* #36 */
    { 0x0f52c7, 0x0f52c6, 0x50e1, 0x52e1, 0x0009, 0x0 }, /* #37 */
    { 0x1321c6, 0x1321c7, 0xb7f0, 0xb7d0, 0x0005, 0x0 }, /* #38 */
    { 0x2b1a07, 0x2b1a06, 0x2958, 0x2978, 0x0005, 0x0 }, /* #39 */
    { 0x3901d6, 0x3901d7, 0xfdb9, 0x7db9, 0x000f, 0x0 }, /* #40 */
    { 0x375197, 0x375196, 0xa7b0, 0xa7b1, 0x0000, 0x0 }, /* #41 */
    { 0x3a0416, 0x3a0417, 0xbbb7, 0xbb37, 0x0007, 0x0 }, /* #42 */
    { 0x3e0c42, 0x3e0c43, 0xfaaf, 0xdaaf, 0x000d, 0x0 }, /* #43 */
    { 0x2c3316, 0x2c3317, 0x8f12, 0x8712, 0x000b, 0x0 }, /* #44 */
    { 0x0b6407, 0x0b6406, 0x11b3, 0x11bb, 0x0003, 0x0 }, /* #45 */
    { 0x3d12c6, 0x3d12c6, 0x19dd, 0x59dd, 0x000e, 0x0 }, /* #46 */
    { 0x267212, 0x267212, 0xdb0e, 0xdf0e, 0x000a, 0x0 }, /* #47 */
    { 0x1571d7, 0x1571d6, 0xe64c, 0xe66c, 0x0005, 0x0 }, /* #48 */
    { 0x1b6717, 0x1b6716, 0x7a21, 0xfa21, 0x000f, 0x0 }, /* #49 */
    { 0x106056, 0x106057, 0xb477, 0xb457, 0x0005, 0x0 }, /* #50 */
    { 0x164217, 0x164216, 0xefd6, 0xffd6, 0x000c, 0x0 }, /* #51 */
    { 0x111b53, 0x111b52, 0xc64c, 0xc65c, 0x0004, 0x0 }, /* #52 */
    { 0x335c93, 0x335c93, 0x6c37, 0x6437, 0x000b, 0x0 }, /* #53 */
    { 0x0d0dc7, 0x0d0dc7, 0xf4bb, 0xf43b, 0x0007, 0x0 }, /* #54 */
    { 0x345c13, 0x345c13, 0xd017, 0x9017, 0x000e, 0x0 }, /* #55 */
    { 0x082716, 0x082717, 0x8914, 0x8814, 0x0008, 0x0 }, /* #56 */
    { 0x211916, 0x211916, 0x7351, 0x7751, 0x000a, 0x0 }, /* #57 */
    { 0x2b4207, 0x2b4206, 0xeac4, 0xeac5, 0x0000, 0x0 }, /* #58 */
    { 0x2a2793, 0x2a2793, 0x4474, 0x4454, 0x0005, 0x0 }, /* #59 */
    { 0x1e2f42, 0x1e2f43, 0xe4da, 0xe45a, 0x0007, 0x0 }, /* #60 */
    { 0x2125d6, 0x2125d6, 0x09f7, 0x89f7, 0x000f, 0x0 }, /* #61 */
    { 0x392d83, 0x392d83, 0x1645, 0x1445, 0x0009, 0x0 }, /* #62 */
    { 0x3d07d2, 0x3d07d2, 0xebc0, 0xfbc0, 0x000c, 0x0 }, /* #63 */
    { 0x390842, 0x390843, 0xcb1f, 0x8b1f, 0x000e, 0x0 }, /* #64 */
    { 0x066456, 0x066457, 0x6f74, 0x6b74, 0x000a, 0x0 }, /* #65 */
    { 0x3b2996, 0x3b2997, 0x6783, 0x6703, 0x0007, 0x0 }, /* #66 */
    { 0x1a4687, 0x1a4687, 0x98f4, 0x98e4, 0x0004, 0x0 }, /* #67 */
    { 0x064b16, 0x064b16, 0x349f, 0x359f, 0x0008, 0x0 }, /* #68 */
    { 0x1300c6, 0x1300c7, 0x9b19, 0x9b09, 0x0004, 0x0 }, /* #69 */
    { 0x164642, 0x164642, 0xdf54, 0xdf5c, 0x0003, 0x0 }, /* #70 */
    { 0x2f4702, 0x2f4702, 0x27b7, 0x27f7, 0x0006, 0x0 }, /* #71 */
    { 0x387c46, 0x387c47, 0x0f38, 0x0738, 0x000b, 0x0 }, /* #72 */
    { 0x122253, 0x122252, 0xe00b, 0xe08b, 0x0007, 0x0 }, /* #73 */
    { 0x344987, 0x344986, 0xf8cc, 0xfccc, 0x000a, 0x0 }, /* #74 */
    { 0x237256, 0x237257, 0xbf72, 0xbb72, 0x000a, 0x0 }, /* #75 */
    { 0x302457, 0x302456, 0xb047, 0xb847, 0x000b, 0x0 }, /* #76 */
    { 0x3728c7, 0x3728c7, 0xdb75, 0xdb71, 0x0002, 0x0 }, /* #77 */
    { 0x173042, 0x173043, 0x836b, 0x834b, 0x0005, 0x0 }, /* #78 */
    { 0x3b5347, 0x3b5347, 0x2126, 0x0126, 0x000d, 0x0 }, /* #79 */
    { 0x252543, 0x252542, 0xda05, 0xda45, 0x0006, 0x0 }, /* #80 */
    { 0x3f2203, 0x3f2203, 0x97fd, 0x93fd, 0x000a, 0x0 }, /* #81 */
    { 0x313a86, 0x313a87, 0xcbb6, 0xcb36, 0x0007, 0x0 }, /* #82 */
    { 0x182e06, 0x182e07, 0x5e73, 0x5e63, 0x0004, 0x0 }, /* #83 */
    { 0x166ad6, 0x166ad7, 0x6ded, 0x2ded, 0x000e, 0x0 }, /* #84 */
    { 0x2c6042, 0x2c6042, 0x2c07, 0x2c0f, 0x0003, 0x0 }, /* #85 */
    { 0x2c5317, 0x2c5317, 0xa271, 0xa261, 0x0004, 0x0 }, /* #86 */
    { 0x097607, 0x097607, 0x75c0, 0x71c0, 0x000a, 0x0 }, /* #87 */
    { 0x007507, 0x007506, 0xd679, 0xd6f9, 0x0007, 0x0 }, /* #88 */
    { 0x3b0c53, 0x3b0c53, 0x8e71, 0x8e31, 0x0006, 0x0 }, /* #89 */
    { 0x175903, 0x175903, 0x4981, 0x0981, 0x000e, 0x0 }, /* #90 */
    { 0x1740c6, 0x1740c7, 0xfe31, 0xee31, 0x000c, 0x0 }, /* #91 */
    { 0x301042, 0x301042, 0xc353, 0xc753, 0x000a, 0x0 }, /* #92 */
    { 0x3f5a96, 0x3f5a96, 0x6ee9, 0xeee9, 0x000f, 0x0 }, /* #93 */
    { 0x3670c3, 0x3670c3, 0x9795, 0x9785, 0x0004, 0x0 }, /* #94 */
    { 0x041843, 0x041842, 0x155e, 0x555e, 0x000e, 0x0 }, /* #95 */
};
uint32_t const g_cTests_btc_u16 = RT_ELEMENTS(g_aTests_btc_u16);

BINU16_TEST_T const g_aTests_btc_u16_locked[] =
{
    { 0x0d5f12, 0x0d5f12, 0x0000, 0x0001, 0x0000, 0x0 }, /* #0 */
    { 0x1e31c2, 0x1e31c2, 0x0000, 0x0001, 0x0000, 0x0 }, /* #1 */
    { 0x392013, 0x392012, 0x0000, 0x0001, 0x0000, 0x0 }, /* #2 */
    { 0x1c7996, 0x1c7996, 0x0000, 0x0001, 0x0000, 0x0 }, /* #3 */
    { 0x194386, 0x194386, 0x0000, 0x0001, 0x0000, 0x0 }, /* #4 */
    { 0x2b0cd7, 0x2b0cd6, 0x0000, 0x0001, 0x0000, 0x0 }, /* #5 */
    { 0x375903, 0x375903, 0x143f, 0x143e, 0x0000, 0x0 }, /* #6 */
    { 0x356ad2, 0x356ad3, 0xb7a3, 0xb7a2, 0x0000, 0x0 }, /* #7 */
    { 0x0d4b57, 0x0d4b57, 0xd355, 0xd354, 0x0000, 0x0 }, /* #8 */
    { 0x2c4517, 0x2c4517, 0x217d, 0x217c, 0x0000, 0x0 }, /* #9 */
    { 0x2a3bd6, 0x2a3bd7, 0x7625, 0x7624, 0x0000, 0x0 }, /* #10 */
    { 0x3507d3, 0x3507d2, 0x78ca, 0x78cb, 0x0000, 0x0 }, /* #11 */
    { 0x203dd6, 0x203dd7, 0xc289, 0x8289, 0x000e, 0x0 }, /* #12 */
    { 0x0b3bd3, 0x0b3bd2, 0x13fe, 0x1bfe, 0x000b, 0x0 }, /* #13 */
    { 0x130fd3, 0x130fd2, 0x2002, 0x2202, 0x0009, 0x0 }, /* #14 */
    { 0x177a83, 0x177a83, 0x1a65, 0x1a64, 0x0000, 0x0 }, /* #15 */
    { 0x1c5997, 0x1c5997, 0x3fb8, 0x3fa8, 0x0004, 0x0 }, /* #16 */
    { 0x2c6996, 0x2c6996, 0xb90d, 0xb94d, 0x0006, 0x0 }, /* #17 */
    { 0x1b7907, 0x1b7906, 0xf831, 0xf833, 0x0001, 0x0 }, /* #18 */
    { 0x083e96, 0x083e96, 0x4c39, 0x4cb9, 0x0007, 0x0 }, /* #19 */
    { 0x043712, 0x043713, 0x39f4, 0x31f4, 0x000b, 0x0 }, /* #20 */
    { 0x0254c6, 0x0254c7, 0xfd17, 0x7d17, 0x000f, 0x0 }, /* #21 */
    { 0x3224c7, 0x3224c7, 0x50d8, 0x40d8, 0x000c, 0x0 }, /* #22 */
    { 0x3b1bc3, 0x3b1bc3, 0xef6b, 0xaf6b, 0x000e, 0x0 }, /* #23 */
    { 0x015dc6, 0x015dc6, 0xf811, 0xf851, 0x0006, 0x0 }, /* #24 */
    { 0x3e08c3, 0x3e08c3, 0x71ea, 0x51ea, 0x000d, 0x0 }, /* #25 */
    { 0x1a4e52, 0x1a4e52, 0x7620, 0x7628, 0x0003, 0x0 }, /* #26 */
    { 0x341a43, 0x341a43, 0xabb5, 0xab35, 0x0007, 0x0 }, /* #27 */
    { 0x0a5257, 0x0a5257, 0x8712, 0x0712, 0x000f, 0x0 }, /* #28 */
    { 0x313953, 0x313953, 0xccf2, 0xccf0, 0x0001, 0x0 }, /* #29 */
    { 0x291ad7, 0x291ad7, 0x8f0e, 0x8d0e, 0x0009, 0x0 }, /* #30 */
    { 0x1c7287, 0x1c7286, 0x2836, 0x283e, 0x0003, 0x0 }, /* #31 */
    { 0x2b31c6, 0x2b31c7, 0xd061, 0xd041, 0x0005, 0x0 }, /* #32 */
    { 0x1c3f43, 0x1c3f42, 0xdf3e, 0xdf3f, 0x0000, 0x0 }, /* #33 */
    { 0x3573c6, 0x3573c6, 0x2fcd, 0xafcd, 0x000f, 0x0 }, /* #34 */
    { 0x340283, 0x340283, 0x8b0a, 0x0b0a, 0x000f, 0x0 }, /* #35 */
    { 0x2d79c3, 0x2d79c2, 0xe3ee, 0xe3ef, 0x0000, 0x0 }, /* #36 */
    { 0x125792, 0x125793, 0x28a5, 0x28a4, 0x0000, 0x0 }, /* #37 */
    { 0x183693, 0x183692, 0xe510, 0xe511, 0x0000, 0x0 }, /* #38 */
    { 0x101cc7, 0x101cc6, 0x615c, 0x615d, 0x0000, 0x0 }, /* #39 */
    { 0x126352, 0x126352, 0x9b40, 0x9b50, 0x0004, 0x0 }, /* #40 */
    { 0x2f3943, 0x2f3942, 0x8894, 0x9894, 0x000c, 0x0 }, /* #41 */
    { 0x196147, 0x196146, 0xc804, 0xc824, 0x0005, 0x0 }, /* #42 */
    { 0x127f52, 0x127f53, 0x1229, 0x1221, 0x0003, 0x0 }, /* #43 */
    { 0x337b52, 0x337b53, 0x938a, 0x9382, 0x0003, 0x0 }, /* #44 */
    { 0x007c56, 0x007c56, 0xd9d3, 0xdbd3, 0x0009, 0x0 }, /* #45 */
    { 0x390b52, 0x390b52, 0xcc3a, 0xce3a, 0x0009, 0x0 }, /* #46 */
    { 0x260093, 0x260092, 0x1927, 0x1d27, 0x000a, 0x0 }, /* #47 */
    { 0x135412, 0x135412, 0x162a, 0x172a, 0x0008, 0x0 }, /* #48 */
    { 0x025a46, 0x025a46, 0xc22b, 0xc2ab, 0x0007, 0x0 }, /* #49 */
    { 0x1e0cc2, 0x1e0cc2, 0xcaa0, 0xcea0, 0x000a, 0x0 }, /* #50 */
    { 0x3668d3, 0x3668d3, 0x40fe, 0x40fa, 0x0002, 0x0 }, /* #51 */
    { 0x1e2492, 0x1e2493, 0x5fdb, 0x5f5b, 0x0007, 0x0 }, /* #52 */
    { 0x116a52, 0x116a53, 0xb90e, 0xb80e, 0x0008, 0x0 }, /* #53 */
    { 0x3b45c2, 0x3b45c3, 0x08b3, 0x00b3, 0x000b, 0x0 }, /* #54 */
    { 0x343556, 0x343556, 0xd943, 0xd953, 0x0004, 0x0 }, /* #55 */
    { 0x051817, 0x051816, 0xf6c7, 0xf6d7, 0x0004, 0x0 }, /* #56 */
    { 0x343253, 0x343252, 0xbe44, 0xbe46, 0x0001, 0x0 }, /* #57 */
    { 0x0750c7, 0x0750c6, 0xe4ce, 0xf4ce, 0x000c, 0x0 }, /* #58 */
    { 0x3f3e13, 0x3f3e12, 0x128c, 0x12ac, 0x0005, 0x0 }, /* #59 */
    { 0x0561d3, 0x0561d2, 0x284c, 0x294c, 0x0008, 0x0 }, /* #60 */
    { 0x2f41d7, 0x2f41d7, 0xe8ae, 0x68ae, 0x000f, 0x0 }, /* #61 */
    { 0x273c83, 0x273c82, 0x5a3b, 0x7a3b, 0x000d, 0x0 }, /* #62 */
    { 0x0d1dd2, 0x0d1dd3, 0x4757, 0x4557, 0x0009, 0x0 }, /* #63 */
    { 0x066c07, 0x066c06, 0xfda7, 0xfdaf, 0x0003, 0x0 }, /* #64 */
    { 0x135147, 0x135146, 0x331b, 0x731b, 0x000e, 0x0 }, /* #65 */
    { 0x1448c6, 0x1448c7, 0xdcd1, 0xdc51, 0x0007, 0x0 }, /* #66 */
    { 0x3a5107, 0x3a5106, 0xe022, 0xe222, 0x0009, 0x0 }, /* #67 */
    { 0x2f7896, 0x2f7897, 0x5baa, 0x5ba2, 0x0003, 0x0 }, /* #68 */
    { 0x096412, 0x096412, 0xcdfc, 0xddfc, 0x000c, 0x0 }, /* #69 */
    { 0x184f03, 0x184f03, 0xe749, 0xe349, 0x000a, 0x0 }, /* #70 */
    { 0x3e0893, 0x3e0892, 0x1352, 0x1372, 0x0005, 0x0 }, /* #71 */
    { 0x383046, 0x383047, 0x2d35, 0x2d25, 0x0004, 0x0 }, /* #72 */
    { 0x317fd2, 0x317fd3, 0x33d0, 0x31d0, 0x0009, 0x0 }, /* #73 */
    { 0x3b6712, 0x3b6712, 0x1980, 0x5980, 0x000e, 0x0 }, /* #74 */
    { 0x1e5e56, 0x1e5e56, 0xe647, 0xe64f, 0x0003, 0x0 }, /* #75 */
    { 0x003356, 0x003357, 0xdd85, 0xcd85, 0x000c, 0x0 }, /* #76 */
    { 0x0f69d3, 0x0f69d2, 0xb6c1, 0xb6c3, 0x0001, 0x0 }, /* #77 */
    { 0x395bc6, 0x395bc6, 0x12c0, 0x13c0, 0x0008, 0x0 }, /* #78 */
    { 0x1f2593, 0x1f2593, 0x5933, 0x5833, 0x0008, 0x0 }, /* #79 */
    { 0x1b3b93, 0x1b3b92, 0xcf8b, 0xef8b, 0x000d, 0x0 }, /* #80 */
    { 0x242197, 0x242196, 0x70a2, 0x74a2, 0x000a, 0x0 }, /* #81 */
    { 0x346102, 0x346103, 0xb8a4, 0x98a4, 0x000d, 0x0 }, /* #82 */
    { 0x160d13, 0x160d12, 0x506c, 0x546c, 0x000a, 0x0 }, /* #83 */
    { 0x295242, 0x295243, 0x9d91, 0x9991, 0x000a, 0x0 }, /* #84 */
    { 0x313e47, 0x313e47, 0x067e, 0x0676, 0x0003, 0x0 }, /* #85 */
    { 0x295a07, 0x295a07, 0xf0cc, 0xf08c, 0x0006, 0x0 }, /* #86 */
    { 0x1c34c3, 0x1c34c3, 0x49b3, 0x49b1, 0x0001, 0x0 }, /* #87 */
    { 0x081393, 0x081392, 0x1566, 0x15e6, 0x0007, 0x0 }, /* #88 */
    { 0x290012, 0x290013, 0x08cf, 0x08cd, 0x0001, 0x0 }, /* #89 */
    { 0x1e4557, 0x1e4557, 0xb255, 0x9255, 0x000d, 0x0 }, /* #90 */
    { 0x1957d3, 0x1957d3, 0x9988, 0x9888, 0x0008, 0x0 }, /* #91 */
    { 0x2e7482, 0x2e7482, 0xe784, 0xe785, 0x0000, 0x0 }, /* #92 */
    { 0x275c87, 0x275c86, 0xdaa0, 0xdba0, 0x0008, 0x0 }, /* #93 */
    { 0x3f1c56, 0x3f1c56, 0x5adb, 0xdadb, 0x000f, 0x0 }, /* #94 */
    { 0x056206, 0x056207, 0xe17a, 0xe13a, 0x0006, 0x0 }, /* #95 */
};
uint32_t const g_cTests_btc_u16_locked = RT_ELEMENTS(g_aTests_btc_u16_locked);

BINU16_TEST_T const g_aTests_btr_u16[] =
{
    { 0x372d52, 0x372d52, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x283c56, 0x283c56, 0x0000, 0x0000, 0x0000, 0x0 }, /* #1 */
    { 0x151817, 0x151816, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x3867d7, 0x3867d6, 0x0000, 0x0000, 0x0000, 0x0 }, /* #3 */
    { 0x000b82, 0x000b82, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x0c5582, 0x0c5582, 0x0000, 0x0000, 0x0000, 0x0 }, /* #5 */
    { 0x1d78d6, 0x1d78d7, 0x8463, 0x8462, 0x0000, 0x0 }, /* #6 */
    { 0x2f7547, 0x2f7546, 0xfd6c, 0xfd6c, 0x0000, 0x0 }, /* #7 */
    { 0x251453, 0x251453, 0xa259, 0xa258, 0x0000, 0x0 }, /* #8 */
    { 0x0e5a17, 0x0e5a16, 0xc5de, 0xc5de, 0x0000, 0x0 }, /* #9 */
    { 0x004dc7, 0x004dc7, 0x3c3d, 0x3c3c, 0x0000, 0x0 }, /* #10 */
    { 0x0a6f93, 0x0a6f92, 0xa5c2, 0xa5c2, 0x0000, 0x0 }, /* #11 */
    { 0x160657, 0x160657, 0xf7ef, 0xd7ef, 0x000d, 0x0 }, /* #12 */
    { 0x3d0687, 0x3d0687, 0x4dcc, 0x4d8c, 0x0006, 0x0 }, /* #13 */
    { 0x3c48c3, 0x3c48c2, 0x3dfa, 0x3dfa, 0x0002, 0x0 }, /* #14 */
    { 0x183903, 0x183902, 0x0ee3, 0x0ee3, 0x0008, 0x0 }, /* #15 */
    { 0x0b0017, 0x0b0017, 0xd5ed, 0xd5cd, 0x0005, 0x0 }, /* #16 */
    { 0x173117, 0x173116, 0x6560, 0x6560, 0x0004, 0x0 }, /* #17 */
    { 0x013e47, 0x013e47, 0x0247, 0x0245, 0x0001, 0x0 }, /* #18 */
    { 0x254982, 0x254982, 0xba19, 0xba19, 0x000e, 0x0 }, /* #19 */
    { 0x3e2a93, 0x3e2a93, 0x0ed6, 0x0ad6, 0x000a, 0x0 }, /* #20 */
    { 0x3a1683, 0x3a1683, 0x1891, 0x1881, 0x0004, 0x0 }, /* #21 */
    { 0x294513, 0x294513, 0x76dd, 0x56dd, 0x000d, 0x0 }, /* #22 */
    { 0x0c4646, 0x0c4647, 0x75f5, 0x75e5, 0x0004, 0x0 }, /* #23 */
    { 0x0f2d87, 0x0f2d86, 0x9126, 0x9126, 0x000a, 0x0 }, /* #24 */
    { 0x2c1543, 0x2c1542, 0x3291, 0x3291, 0x0002, 0x0 }, /* #25 */
    { 0x003616, 0x003616, 0x5bc4, 0x5bc4, 0x0000, 0x0 }, /* #26 */
    { 0x141d06, 0x141d07, 0xcb42, 0x8b42, 0x000e, 0x0 }, /* #27 */
    { 0x0e0006, 0x0e0007, 0x2d1b, 0x2d0b, 0x0004, 0x0 }, /* #28 */
    { 0x302103, 0x302102, 0x2da4, 0x2da4, 0x000f, 0x0 }, /* #29 */
    { 0x115393, 0x115392, 0x21cc, 0x21cc, 0x0001, 0x0 }, /* #30 */
    { 0x331c02, 0x331c03, 0x6fab, 0x6faa, 0x0000, 0x0 }, /* #31 */
    { 0x060986, 0x060987, 0x417f, 0x017f, 0x000e, 0x0 }, /* #32 */
    { 0x0503c7, 0x0503c7, 0x4e52, 0x4e50, 0x0001, 0x0 }, /* #33 */
    { 0x367b96, 0x367b96, 0x7c42, 0x7c42, 0x0003, 0x0 }, /* #34 */
    { 0x2e7213, 0x2e7212, 0x763a, 0x763a, 0x0008, 0x0 }, /* #35 */
    { 0x332213, 0x332212, 0x20a0, 0x20a0, 0x0008, 0x0 }, /* #36 */
    { 0x2b3086, 0x2b3087, 0xfe8c, 0xfa8c, 0x000a, 0x0 }, /* #37 */
    { 0x146a46, 0x146a47, 0x796e, 0x794e, 0x0005, 0x0 }, /* #38 */
    { 0x3f7547, 0x3f7547, 0xdfc5, 0xddc5, 0x0009, 0x0 }, /* #39 */
    { 0x216943, 0x216943, 0xd5ef, 0xd5ee, 0x0000, 0x0 }, /* #40 */
    { 0x046a12, 0x046a13, 0x3771, 0x3751, 0x0005, 0x0 }, /* #41 */
    { 0x3457d7, 0x3457d6, 0x2f75, 0x2f75, 0x0007, 0x0 }, /* #42 */
    { 0x132b16, 0x132b17, 0x2a75, 0x2a35, 0x0006, 0x0 }, /* #43 */
    { 0x126e02, 0x126e02, 0x3c91, 0x3c91, 0x0006, 0x0 }, /* #44 */
    { 0x1b1f96, 0x1b1f96, 0xb7fa, 0xb7fa, 0x000b, 0x0 }, /* #45 */
    { 0x0c3f92, 0x0c3f92, 0xa5b0, 0xa5b0, 0x0009, 0x0 }, /* #46 */
    { 0x2e33c2, 0x2e33c3, 0x9b49, 0x8b49, 0x000c, 0x0 }, /* #47 */
    { 0x180d42, 0x180d42, 0x469e, 0x469e, 0x000c, 0x0 }, /* #48 */
    { 0x3d2507, 0x3d2507, 0x76fa, 0x56fa, 0x000d, 0x0 }, /* #49 */
    { 0x0e6d43, 0x0e6d42, 0x465d, 0x465d, 0x0008, 0x0 }, /* #50 */
    { 0x362c92, 0x362c93, 0xdf06, 0x5f06, 0x000f, 0x0 }, /* #51 */
    { 0x3d4c87, 0x3d4c86, 0xec1e, 0xec1e, 0x0005, 0x0 }, /* #52 */
    { 0x2a7a57, 0x2a7a56, 0x0116, 0x0116, 0x000d, 0x0 }, /* #53 */
    { 0x012287, 0x012286, 0x58bb, 0x58bb, 0x0009, 0x0 }, /* #54 */
    { 0x220dd2, 0x220dd2, 0xed82, 0xed82, 0x000c, 0x0 }, /* #55 */
    { 0x0e7b96, 0x0e7b96, 0x0479, 0x0479, 0x000b, 0x0 }, /* #56 */
    { 0x351016, 0x351017, 0xd6fe, 0xd6ee, 0x0004, 0x0 }, /* #57 */
    { 0x1078c7, 0x1078c6, 0x06cc, 0x06cc, 0x0001, 0x0 }, /* #58 */
    { 0x0c6657, 0x0c6656, 0xbb6c, 0xbb6c, 0x0001, 0x0 }, /* #59 */
    { 0x146e87, 0x146e86, 0x9cc1, 0x9cc1, 0x0008, 0x0 }, /* #60 */
    { 0x1a78c7, 0x1a78c6, 0xd174, 0xd174, 0x0001, 0x0 }, /* #61 */
    { 0x301316, 0x301317, 0x61d2, 0x41d2, 0x000d, 0x0 }, /* #62 */
    { 0x306482, 0x306482, 0xa755, 0xa755, 0x000b, 0x0 }, /* #63 */
    { 0x0b1816, 0x0b1817, 0x7231, 0x7031, 0x0009, 0x0 }, /* #64 */
    { 0x3a2307, 0x3a2307, 0xc713, 0xc711, 0x0001, 0x0 }, /* #65 */
    { 0x275f17, 0x275f16, 0x88c9, 0x88c9, 0x000a, 0x0 }, /* #66 */
    { 0x193b97, 0x193b97, 0x07d9, 0x07d1, 0x0003, 0x0 }, /* #67 */
    { 0x243d06, 0x243d06, 0x0147, 0x0147, 0x0009, 0x0 }, /* #68 */
    { 0x3d1782, 0x3d1783, 0xc7ae, 0xc7ac, 0x0001, 0x0 }, /* #69 */
    { 0x306c53, 0x306c53, 0x1af8, 0x1ad8, 0x0005, 0x0 }, /* #70 */
    { 0x2f7057, 0x2f7056, 0xe98e, 0xe98e, 0x000c, 0x0 }, /* #71 */
    { 0x215612, 0x215613, 0x9e53, 0x9e43, 0x0004, 0x0 }, /* #72 */
    { 0x042792, 0x042792, 0x527a, 0x527a, 0x0002, 0x0 }, /* #73 */
    { 0x0e4a97, 0x0e4a96, 0x962e, 0x962e, 0x000b, 0x0 }, /* #74 */
    { 0x024242, 0x024243, 0x3788, 0x2788, 0x000c, 0x0 }, /* #75 */
    { 0x203b16, 0x203b17, 0xf9f2, 0xd9f2, 0x000d, 0x0 }, /* #76 */
    { 0x150e86, 0x150e87, 0xbe65, 0xbe25, 0x0006, 0x0 }, /* #77 */
    { 0x1823c3, 0x1823c2, 0x65f7, 0x65f7, 0x000f, 0x0 }, /* #78 */
    { 0x061d83, 0x061d83, 0x02b7, 0x02b3, 0x0002, 0x0 }, /* #79 */
    { 0x101b17, 0x101b17, 0xd4e4, 0xd4e0, 0x0002, 0x0 }, /* #80 */
    { 0x304403, 0x304403, 0x7dca, 0x75ca, 0x000b, 0x0 }, /* #81 */
    { 0x232a13, 0x232a13, 0x1867, 0x1865, 0x0001, 0x0 }, /* #82 */
    { 0x142787, 0x142786, 0xeaa7, 0xeaa7, 0x0003, 0x0 }, /* #83 */
    { 0x287f46, 0x287f46, 0xc576, 0xc576, 0x0003, 0x0 }, /* #84 */
    { 0x1d5b93, 0x1d5b93, 0x3bcd, 0x3b8d, 0x0006, 0x0 }, /* #85 */
    { 0x0a3cc7, 0x0a3cc6, 0xcd00, 0xcd00, 0x0007, 0x0 }, /* #86 */
    { 0x350e92, 0x350e92, 0x0ce0, 0x0ce0, 0x0002, 0x0 }, /* #87 */
    { 0x275212, 0x275213, 0xbbdb, 0x9bdb, 0x000d, 0x0 }, /* #88 */
    { 0x1f7b02, 0x1f7b02, 0x324f, 0x324f, 0x000e, 0x0 }, /* #89 */
    { 0x033d42, 0x033d42, 0x65bd, 0x65bd, 0x000c, 0x0 }, /* #90 */
    { 0x352713, 0x352712, 0xe3c8, 0xe3c8, 0x000b, 0x0 }, /* #91 */
    { 0x2b3653, 0x2b3653, 0x3ffb, 0x3fbb, 0x0006, 0x0 }, /* #92 */
    { 0x325e82, 0x325e83, 0x8e48, 0x8c48, 0x0009, 0x0 }, /* #93 */
    { 0x067802, 0x067802, 0x6703, 0x6703, 0x0007, 0x0 }, /* #94 */
    { 0x3e1d92, 0x3e1d93, 0x3f71, 0x3f51, 0x0005, 0x0 }, /* #95 */
};
uint32_t const g_cTests_btr_u16 = RT_ELEMENTS(g_aTests_btr_u16);

BINU16_TEST_T const g_aTests_btr_u16_locked[] =
{
    { 0x193952, 0x193952, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x1a6d53, 0x1a6d52, 0x0000, 0x0000, 0x0000, 0x0 }, /* #1 */
    { 0x266392, 0x266392, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x314607, 0x314606, 0x0000, 0x0000, 0x0000, 0x0 }, /* #3 */
    { 0x3c4292, 0x3c4292, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x382f16, 0x382f16, 0x0000, 0x0000, 0x0000, 0x0 }, /* #5 */
    { 0x2b0047, 0x2b0047, 0xa617, 0xa616, 0x0000, 0x0 }, /* #6 */
    { 0x2a1842, 0x2a1843, 0x46bd, 0x46bc, 0x0000, 0x0 }, /* #7 */
    { 0x2a7213, 0x2a7213, 0xda07, 0xda06, 0x0000, 0x0 }, /* #8 */
    { 0x1041d6, 0x1041d6, 0x1274, 0x1274, 0x0000, 0x0 }, /* #9 */
    { 0x3a6e97, 0x3a6e97, 0x17a7, 0x17a6, 0x0000, 0x0 }, /* #10 */
    { 0x225ad6, 0x225ad7, 0x3ae9, 0x3ae8, 0x0000, 0x0 }, /* #11 */
    { 0x1343d3, 0x1343d2, 0x3473, 0x3473, 0x000b, 0x0 }, /* #12 */
    { 0x0c5203, 0x0c5203, 0xb293, 0xa293, 0x000c, 0x0 }, /* #13 */
    { 0x082593, 0x082593, 0x3ab4, 0x3aa4, 0x0004, 0x0 }, /* #14 */
    { 0x120fc6, 0x120fc6, 0x1e84, 0x1e84, 0x0001, 0x0 }, /* #15 */
    { 0x2934d7, 0x2934d7, 0xc67f, 0xc677, 0x0003, 0x0 }, /* #16 */
    { 0x272352, 0x272353, 0x6565, 0x6525, 0x0006, 0x0 }, /* #17 */
    { 0x2e5ed7, 0x2e5ed6, 0x6899, 0x6899, 0x000f, 0x0 }, /* #18 */
    { 0x004743, 0x004743, 0xd4e7, 0x94e7, 0x000e, 0x0 }, /* #19 */
    { 0x015cc2, 0x015cc3, 0x5781, 0x5780, 0x0000, 0x0 }, /* #20 */
    { 0x357e97, 0x357e96, 0xc3a6, 0xc3a6, 0x0006, 0x0 }, /* #21 */
    { 0x0b4706, 0x0b4706, 0x9669, 0x9669, 0x000e, 0x0 }, /* #22 */
    { 0x1c6213, 0x1c6212, 0x4167, 0x4167, 0x0007, 0x0 }, /* #23 */
    { 0x073b06, 0x073b07, 0x2ad4, 0x22d4, 0x000b, 0x0 }, /* #24 */
    { 0x305c87, 0x305c86, 0x5b93, 0x5b93, 0x0003, 0x0 }, /* #25 */
    { 0x2a3382, 0x2a3382, 0xab75, 0xab75, 0x000c, 0x0 }, /* #26 */
    { 0x294243, 0x294242, 0xd6be, 0xd6be, 0x0008, 0x0 }, /* #27 */
    { 0x1057d6, 0x1057d7, 0x6e5c, 0x6e1c, 0x0006, 0x0 }, /* #28 */
    { 0x067e16, 0x067e17, 0xcd9e, 0xc59e, 0x000b, 0x0 }, /* #29 */
    { 0x0b13c7, 0x0b13c6, 0xbcf1, 0xbcf1, 0x0001, 0x0 }, /* #30 */
    { 0x3f3b03, 0x3f3b03, 0xf6f9, 0xf679, 0x0007, 0x0 }, /* #31 */
    { 0x140152, 0x140152, 0x4176, 0x4176, 0x0000, 0x0 }, /* #32 */
    { 0x264f13, 0x264f13, 0xb660, 0x3660, 0x000f, 0x0 }, /* #33 */
    { 0x261692, 0x261692, 0x8d16, 0x8d16, 0x000d, 0x0 }, /* #34 */
    { 0x101d82, 0x101d82, 0xa1e6, 0xa1e6, 0x0004, 0x0 }, /* #35 */
    { 0x0e3b07, 0x0e3b07, 0xac57, 0xac56, 0x0000, 0x0 }, /* #36 */
    { 0x020dc7, 0x020dc6, 0xcd74, 0xcd74, 0x0000, 0x0 }, /* #37 */
    { 0x0c4a87, 0x0c4a87, 0xf251, 0xe251, 0x000c, 0x0 }, /* #38 */
    { 0x0f5dd3, 0x0f5dd2, 0x1935, 0x1935, 0x0003, 0x0 }, /* #39 */
    { 0x0361d7, 0x0361d6, 0x59c4, 0x59c4, 0x0000, 0x0 }, /* #40 */
    { 0x3b0517, 0x3b0516, 0x1a1d, 0x1a1d, 0x000a, 0x0 }, /* #41 */
    { 0x0b4852, 0x0b4853, 0x7fb4, 0x5fb4, 0x000d, 0x0 }, /* #42 */
    { 0x371212, 0x371212, 0xdd24, 0xdd24, 0x0001, 0x0 }, /* #43 */
    { 0x280e03, 0x280e02, 0xea91, 0xea91, 0x0006, 0x0 }, /* #44 */
    { 0x094086, 0x094087, 0x3d65, 0x3965, 0x000a, 0x0 }, /* #45 */
    { 0x156457, 0x156456, 0x381f, 0x381f, 0x0008, 0x0 }, /* #46 */
    { 0x314ac2, 0x314ac3, 0x20e8, 0x20c8, 0x0005, 0x0 }, /* #47 */
    { 0x3b5f93, 0x3b5f92, 0x8fa2, 0x8fa2, 0x0002, 0x0 }, /* #48 */
    { 0x161446, 0x161446, 0x3d61, 0x3d61, 0x0003, 0x0 }, /* #49 */
    { 0x102f02, 0x102f02, 0x5919, 0x5919, 0x0009, 0x0 }, /* #50 */
    { 0x312e03, 0x312e03, 0x8def, 0x0def, 0x000f, 0x0 }, /* #51 */
    { 0x1b1407, 0x1b1406, 0xe1e6, 0xe1e6, 0x000c, 0x0 }, /* #52 */
    { 0x081547, 0x081547, 0x5617, 0x5615, 0x0001, 0x0 }, /* #53 */
    { 0x0f0293, 0x0f0292, 0x7902, 0x7902, 0x0009, 0x0 }, /* #54 */
    { 0x216206, 0x216206, 0xd536, 0xd536, 0x0007, 0x0 }, /* #55 */
    { 0x3c2c52, 0x3c2c52, 0x8aff, 0x8aff, 0x000e, 0x0 }, /* #56 */
    { 0x0f1d43, 0x0f1d43, 0x68f8, 0x68e8, 0x0004, 0x0 }, /* #57 */
    { 0x2c60d7, 0x2c60d7, 0x68ed, 0x28ed, 0x000e, 0x0 }, /* #58 */
    { 0x356b02, 0x356b02, 0xd683, 0xd683, 0x000b, 0x0 }, /* #59 */
    { 0x2f1092, 0x2f1093, 0xe0e4, 0xe0e0, 0x0002, 0x0 }, /* #60 */
    { 0x243ad2, 0x243ad2, 0x7bf6, 0x7bf6, 0x000a, 0x0 }, /* #61 */
    { 0x171007, 0x171006, 0xccd4, 0xccd4, 0x0000, 0x0 }, /* #62 */
    { 0x065b47, 0x065b46, 0xc203, 0xc203, 0x0003, 0x0 }, /* #63 */
    { 0x2b7f42, 0x2b7f43, 0x9ef5, 0x9ed5, 0x0005, 0x0 }, /* #64 */
    { 0x390f07, 0x390f07, 0xa3ae, 0xa1ae, 0x0009, 0x0 }, /* #65 */
    { 0x031483, 0x031483, 0x5f04, 0x4f04, 0x000c, 0x0 }, /* #66 */
    { 0x136343, 0x136343, 0x98b4, 0x9894, 0x0005, 0x0 }, /* #67 */
    { 0x2609c3, 0x2609c3, 0x0c33, 0x0433, 0x000b, 0x0 }, /* #68 */
    { 0x252d42, 0x252d43, 0xbbdd, 0xbb5d, 0x0007, 0x0 }, /* #69 */
    { 0x2811d7, 0x2811d7, 0x797d, 0x793d, 0x0006, 0x0 }, /* #70 */
    { 0x1f42c7, 0x1f42c6, 0x3b81, 0x3b81, 0x0005, 0x0 }, /* #71 */
    { 0x2f42d3, 0x2f42d3, 0xbb68, 0x3b68, 0x000f, 0x0 }, /* #72 */
    { 0x341542, 0x341542, 0xd521, 0xd521, 0x0007, 0x0 }, /* #73 */
    { 0x0d2712, 0x0d2712, 0xa232, 0xa232, 0x000c, 0x0 }, /* #74 */
    { 0x174347, 0x174346, 0x3bc9, 0x3bc9, 0x0002, 0x0 }, /* #75 */
    { 0x2c1b03, 0x2c1b02, 0x8686, 0x8686, 0x000e, 0x0 }, /* #76 */
    { 0x1e2e96, 0x1e2e97, 0x147f, 0x147d, 0x0001, 0x0 }, /* #77 */
    { 0x311546, 0x311547, 0x82d8, 0x82c8, 0x0004, 0x0 }, /* #78 */
    { 0x0062d2, 0x0062d3, 0x58ec, 0x58e8, 0x0002, 0x0 }, /* #79 */
    { 0x1a3d57, 0x1a3d57, 0x80c7, 0x8047, 0x0007, 0x0 }, /* #80 */
    { 0x1237c7, 0x1237c6, 0x2e85, 0x2e85, 0x0006, 0x0 }, /* #81 */
    { 0x3c5e03, 0x3c5e03, 0x7b82, 0x3b82, 0x000e, 0x0 }, /* #82 */
    { 0x393153, 0x393152, 0x5398, 0x5398, 0x000b, 0x0 }, /* #83 */
    { 0x0978d2, 0x0978d2, 0xe8b4, 0xe8b4, 0x0000, 0x0 }, /* #84 */
    { 0x281187, 0x281186, 0x53ca, 0x53ca, 0x000a, 0x0 }, /* #85 */
    { 0x1f0146, 0x1f0147, 0xbfc7, 0xbf87, 0x0006, 0x0 }, /* #86 */
    { 0x150e93, 0x150e92, 0xf314, 0xf314, 0x0000, 0x0 }, /* #87 */
    { 0x031812, 0x031813, 0x4aa9, 0x0aa9, 0x000e, 0x0 }, /* #88 */
    { 0x3d67c7, 0x3d67c6, 0xc9b4, 0xc9b4, 0x0003, 0x0 }, /* #89 */
    { 0x2f0fd2, 0x2f0fd2, 0x2dae, 0x2dae, 0x000f, 0x0 }, /* #90 */
    { 0x1c2602, 0x1c2603, 0xa1ab, 0x21ab, 0x000f, 0x0 }, /* #91 */
    { 0x292b87, 0x292b87, 0x7145, 0x7144, 0x0000, 0x0 }, /* #92 */
    { 0x374b57, 0x374b56, 0x475a, 0x475a, 0x000c, 0x0 }, /* #93 */
    { 0x3d3cc2, 0x3d3cc3, 0xebc3, 0xeb83, 0x0006, 0x0 }, /* #94 */
    { 0x050d17, 0x050d16, 0xb1c3, 0xb1c3, 0x0002, 0x0 }, /* #95 */
};
uint32_t const g_cTests_btr_u16_locked = RT_ELEMENTS(g_aTests_btr_u16_locked);

BINU16_TEST_T const g_aTests_bts_u16[] =
{
    { 0x1b3c86, 0x1b3c86, 0x0000, 0x0001, 0x0000, 0x0 }, /* #0 */
    { 0x304597, 0x304596, 0x0000, 0x0001, 0x0000, 0x0 }, /* #1 */
    { 0x2a0ec7, 0x2a0ec6, 0x0000, 0x0001, 0x0000, 0x0 }, /* #2 */
    { 0x1a3606, 0x1a3606, 0x0000, 0x0001, 0x0000, 0x0 }, /* #3 */
    { 0x327842, 0x327842, 0x0000, 0x0001, 0x0000, 0x0 }, /* #4 */
    { 0x0a5693, 0x0a5692, 0x0000, 0x0001, 0x0000, 0x0 }, /* #5 */
    { 0x2745d2, 0x2745d2, 0x7c1a, 0x7c1b, 0x0000, 0x0 }, /* #6 */
    { 0x3d2f93, 0x3d2f93, 0xc293, 0xc293, 0x0000, 0x0 }, /* #7 */
    { 0x1360c6, 0x1360c7, 0xdd4d, 0xdd4d, 0x0000, 0x0 }, /* #8 */
    { 0x3a5742, 0x3a5742, 0x07c8, 0x07c9, 0x0000, 0x0 }, /* #9 */
    { 0x1d5946, 0x1d5946, 0xae60, 0xae61, 0x0000, 0x0 }, /* #10 */
    { 0x2c0cc2, 0x2c0cc3, 0xe201, 0xe201, 0x0000, 0x0 }, /* #11 */
    { 0x1e6303, 0x1e6302, 0xf1c1, 0xf1c3, 0x0001, 0x0 }, /* #12 */
    { 0x1458c7, 0x1458c7, 0x33a8, 0x33a8, 0x0005, 0x0 }, /* #13 */
    { 0x3018d2, 0x3018d3, 0xe373, 0xe373, 0x0004, 0x0 }, /* #14 */
    { 0x1f6d03, 0x1f6d03, 0xe0ce, 0xe0ce, 0x0002, 0x0 }, /* #15 */
    { 0x2d1a03, 0x2d1a02, 0x979c, 0x979d, 0x0000, 0x0 }, /* #16 */
    { 0x2f6bd3, 0x2f6bd2, 0x740b, 0x750b, 0x0008, 0x0 }, /* #17 */
    { 0x3e3782, 0x3e3782, 0xe880, 0xec80, 0x000a, 0x0 }, /* #18 */
    { 0x0c4807, 0x0c4806, 0xe825, 0xe925, 0x0008, 0x0 }, /* #19 */
    { 0x246607, 0x246606, 0x5fe5, 0x5fe7, 0x0001, 0x0 }, /* #20 */
    { 0x313112, 0x313112, 0xceec, 0xcefc, 0x0004, 0x0 }, /* #21 */
    { 0x3a3917, 0x3a3916, 0xb8aa, 0xbaaa, 0x0009, 0x0 }, /* #22 */
    { 0x1e5e13, 0x1e5e12, 0xfae9, 0xfaed, 0x0002, 0x0 }, /* #23 */
    { 0x0e5c02, 0x0e5c03, 0x2c5c, 0x2c5c, 0x000a, 0x0 }, /* #24 */
    { 0x0078c7, 0x0078c6, 0x1b95, 0x1bd5, 0x0006, 0x0 }, /* #25 */
    { 0x016287, 0x016286, 0xd258, 0xd25a, 0x0001, 0x0 }, /* #26 */
    { 0x0b4487, 0x0b4487, 0xfab7, 0xfab7, 0x000d, 0x0 }, /* #27 */
    { 0x3c3c56, 0x3c3c56, 0xb876, 0xb877, 0x0000, 0x0 }, /* #28 */
    { 0x112407, 0x112406, 0xdd85, 0xdda5, 0x0005, 0x0 }, /* #29 */
    { 0x1b5983, 0x1b5983, 0x2295, 0x2295, 0x000d, 0x0 }, /* #30 */
    { 0x303fd2, 0x303fd3, 0x1e5d, 0x1e5d, 0x0000, 0x0 }, /* #31 */
    { 0x0e2113, 0x0e2112, 0xab87, 0xaba7, 0x0005, 0x0 }, /* #32 */
    { 0x0d5247, 0x0d5247, 0x91a6, 0x91a6, 0x000c, 0x0 }, /* #33 */
    { 0x1d31d6, 0x1d31d6, 0xb98f, 0xb9cf, 0x0006, 0x0 }, /* #34 */
    { 0x336857, 0x336856, 0x7f6c, 0x7fec, 0x0007, 0x0 }, /* #35 */
    { 0x3177c3, 0x3177c2, 0x098b, 0x898b, 0x000f, 0x0 }, /* #36 */
    { 0x2e2156, 0x2e2157, 0xce1e, 0xce1e, 0x0004, 0x0 }, /* #37 */
    { 0x2b0f42, 0x2b0f42, 0x7579, 0x7779, 0x0009, 0x0 }, /* #38 */
    { 0x1e5503, 0x1e5503, 0xffc2, 0xffc2, 0x0009, 0x0 }, /* #39 */
    { 0x2a31d7, 0x2a31d6, 0x5a6c, 0x7a6c, 0x000d, 0x0 }, /* #40 */
    { 0x2d5907, 0x2d5906, 0x1fa8, 0x5fa8, 0x000e, 0x0 }, /* #41 */
    { 0x3805d6, 0x3805d6, 0xc19f, 0xd19f, 0x000c, 0x0 }, /* #42 */
    { 0x3b5093, 0x3b5092, 0xb94c, 0xb9cc, 0x0007, 0x0 }, /* #43 */
    { 0x183ed6, 0x183ed7, 0xe3b1, 0xe3b1, 0x000e, 0x0 }, /* #44 */
    { 0x043dd6, 0x043dd7, 0x6b9a, 0x6b9a, 0x0001, 0x0 }, /* #45 */
    { 0x233e42, 0x233e43, 0x3db9, 0x3db9, 0x0000, 0x0 }, /* #46 */
    { 0x046f87, 0x046f86, 0x4f8c, 0xcf8c, 0x000f, 0x0 }, /* #47 */
    { 0x3b67c6, 0x3b67c6, 0x0480, 0x0488, 0x0003, 0x0 }, /* #48 */
    { 0x2b1143, 0x2b1143, 0x6765, 0x6765, 0x000d, 0x0 }, /* #49 */
    { 0x076ad2, 0x076ad2, 0xd318, 0xf318, 0x000d, 0x0 }, /* #50 */
    { 0x0a5dd2, 0x0a5dd3, 0x4adf, 0x4adf, 0x0002, 0x0 }, /* #51 */
    { 0x3c1d16, 0x3c1d16, 0x5c4e, 0x5c5e, 0x0004, 0x0 }, /* #52 */
    { 0x002507, 0x002507, 0x684d, 0x684d, 0x0003, 0x0 }, /* #53 */
    { 0x132812, 0x132812, 0x40c8, 0x40e8, 0x0005, 0x0 }, /* #54 */
    { 0x071f17, 0x071f16, 0x8af9, 0x8afd, 0x0002, 0x0 }, /* #55 */
    { 0x141e87, 0x141e87, 0xc822, 0xc822, 0x000b, 0x0 }, /* #56 */
    { 0x123e96, 0x123e96, 0x7826, 0x7926, 0x0008, 0x0 }, /* #57 */
    { 0x254a17, 0x254a16, 0xf714, 0xf754, 0x0006, 0x0 }, /* #58 */
    { 0x142557, 0x142557, 0x476f, 0x476f, 0x0001, 0x0 }, /* #59 */
    { 0x146902, 0x146902, 0xab9b, 0xbb9b, 0x000c, 0x0 }, /* #60 */
    { 0x002c06, 0x002c06, 0x4ec6, 0x4ece, 0x0003, 0x0 }, /* #61 */
    { 0x291cd2, 0x291cd3, 0x3c43, 0x3c43, 0x000d, 0x0 }, /* #62 */
    { 0x222947, 0x222947, 0x2bc9, 0x2bc9, 0x0003, 0x0 }, /* #63 */
    { 0x3d2806, 0x3d2806, 0x0596, 0x1596, 0x000c, 0x0 }, /* #64 */
    { 0x300a06, 0x300a07, 0x9f3c, 0x9f3c, 0x0003, 0x0 }, /* #65 */
    { 0x330286, 0x330286, 0xbbd2, 0xbbda, 0x0003, 0x0 }, /* #66 */
    { 0x086f56, 0x086f57, 0xa4a3, 0xa4a3, 0x000f, 0x0 }, /* #67 */
    { 0x1c0103, 0x1c0103, 0xc3d7, 0xc3d7, 0x0007, 0x0 }, /* #68 */
    { 0x1564c2, 0x1564c2, 0x0dcf, 0x1dcf, 0x000c, 0x0 }, /* #69 */
    { 0x1d0c53, 0x1d0c52, 0xaef8, 0xbef8, 0x000c, 0x0 }, /* #70 */
    { 0x174cd3, 0x174cd3, 0x67c7, 0x67c7, 0x0002, 0x0 }, /* #71 */
    { 0x2150d7, 0x2150d7, 0x21dd, 0x21dd, 0x0002, 0x0 }, /* #72 */
    { 0x1760d6, 0x1760d6, 0x4d21, 0x4da1, 0x0007, 0x0 }, /* #73 */
    { 0x0c5012, 0x0c5012, 0xbe34, 0xfe34, 0x000e, 0x0 }, /* #74 */
    { 0x0432c3, 0x0432c3, 0xfd78, 0xfd78, 0x0004, 0x0 }, /* #75 */
    { 0x350f96, 0x350f97, 0x9256, 0x9256, 0x0004, 0x0 }, /* #76 */
    { 0x194d47, 0x194d47, 0x5da0, 0x5da0, 0x0007, 0x0 }, /* #77 */
    { 0x2b2052, 0x2b2053, 0x43e6, 0x43e6, 0x0008, 0x0 }, /* #78 */
    { 0x0a1657, 0x0a1657, 0xfe08, 0xfe08, 0x000a, 0x0 }, /* #79 */
    { 0x3a7147, 0x3a7146, 0x0263, 0x4263, 0x000e, 0x0 }, /* #80 */
    { 0x371807, 0x371807, 0xcd76, 0xcd76, 0x0008, 0x0 }, /* #81 */
    { 0x3141d2, 0x3141d2, 0x30ae, 0x30be, 0x0004, 0x0 }, /* #82 */
    { 0x1234d3, 0x1234d2, 0xbadf, 0xbbdf, 0x0008, 0x0 }, /* #83 */
    { 0x347896, 0x347897, 0x0add, 0x0add, 0x000b, 0x0 }, /* #84 */
    { 0x3c7d92, 0x3c7d93, 0x7bde, 0x7bde, 0x000e, 0x0 }, /* #85 */
    { 0x393d12, 0x393d13, 0xa090, 0xa090, 0x000f, 0x0 }, /* #86 */
    { 0x2b1513, 0x2b1512, 0x12ca, 0x12da, 0x0004, 0x0 }, /* #87 */
    { 0x102503, 0x102502, 0x42ec, 0x42ed, 0x0000, 0x0 }, /* #88 */
    { 0x277d82, 0x277d83, 0x67d7, 0x67d7, 0x0008, 0x0 }, /* #89 */
    { 0x256207, 0x256207, 0x4faf, 0x4faf, 0x0000, 0x0 }, /* #90 */
    { 0x064117, 0x064116, 0xcdb6, 0xddb6, 0x000c, 0x0 }, /* #91 */
    { 0x045057, 0x045056, 0x53c5, 0x53d5, 0x0004, 0x0 }, /* #92 */
    { 0x040c87, 0x040c87, 0x254e, 0x254e, 0x0001, 0x0 }, /* #93 */
    { 0x2a6c56, 0x2a6c56, 0xbe68, 0xbe78, 0x0004, 0x0 }, /* #94 */
    { 0x147a46, 0x147a46, 0xfe49, 0xfe59, 0x0004, 0x0 }, /* #95 */
};
uint32_t const g_cTests_bts_u16 = RT_ELEMENTS(g_aTests_bts_u16);

BINU16_TEST_T const g_aTests_bts_u16_locked[] =
{
    { 0x396847, 0x396846, 0x0000, 0x0001, 0x0000, 0x0 }, /* #0 */
    { 0x1e64c3, 0x1e64c2, 0x0000, 0x0001, 0x0000, 0x0 }, /* #1 */
    { 0x196697, 0x196696, 0x0000, 0x0001, 0x0000, 0x0 }, /* #2 */
    { 0x136dd2, 0x136dd2, 0x0000, 0x0001, 0x0000, 0x0 }, /* #3 */
    { 0x1d1092, 0x1d1092, 0x0000, 0x0001, 0x0000, 0x0 }, /* #4 */
    { 0x352e96, 0x352e96, 0x0000, 0x0001, 0x0000, 0x0 }, /* #5 */
    { 0x3804c2, 0x3804c2, 0x8e40, 0x8e41, 0x0000, 0x0 }, /* #6 */
    { 0x0c48d6, 0x0c48d6, 0xa234, 0xa235, 0x0000, 0x0 }, /* #7 */
    { 0x317d92, 0x317d92, 0x8d3e, 0x8d3f, 0x0000, 0x0 }, /* #8 */
    { 0x355f42, 0x355f43, 0xe59b, 0xe59b, 0x0000, 0x0 }, /* #9 */
    { 0x094a96, 0x094a96, 0xcbda, 0xcbdb, 0x0000, 0x0 }, /* #10 */
    { 0x335142, 0x335143, 0x6233, 0x6233, 0x0000, 0x0 }, /* #11 */
    { 0x3a4fc7, 0x3a4fc7, 0xf433, 0xf433, 0x000a, 0x0 }, /* #12 */
    { 0x3c2e13, 0x3c2e12, 0x412c, 0x41ac, 0x0007, 0x0 }, /* #13 */
    { 0x1948c6, 0x1948c6, 0xa96b, 0xa96f, 0x0002, 0x0 }, /* #14 */
    { 0x004a52, 0x004a52, 0xd6e5, 0xd6f5, 0x0004, 0x0 }, /* #15 */
    { 0x2150d7, 0x2150d6, 0xdaa8, 0xdaa9, 0x0000, 0x0 }, /* #16 */
    { 0x1c14d3, 0x1c14d3, 0xcb1b, 0xcb1b, 0x0008, 0x0 }, /* #17 */
    { 0x2c2c07, 0x2c2c07, 0x9dea, 0x9dea, 0x000c, 0x0 }, /* #18 */
    { 0x0d1543, 0x0d1542, 0x004a, 0x024a, 0x0009, 0x0 }, /* #19 */
    { 0x3529c2, 0x3529c3, 0x2fb3, 0x2fb3, 0x0005, 0x0 }, /* #20 */
    { 0x3a6646, 0x3a6646, 0xfd7e, 0xff7e, 0x0009, 0x0 }, /* #21 */
    { 0x0e00c3, 0x0e00c3, 0xd8ae, 0xd8ae, 0x000f, 0x0 }, /* #22 */
    { 0x2d2782, 0x2d2783, 0x74bf, 0x74bf, 0x0007, 0x0 }, /* #23 */
    { 0x000ac3, 0x000ac3, 0x8bf2, 0x8bf2, 0x0004, 0x0 }, /* #24 */
    { 0x3b10d7, 0x3b10d7, 0xeb06, 0xeb06, 0x0009, 0x0 }, /* #25 */
    { 0x0f7d46, 0x0f7d47, 0xe2f3, 0xe2f3, 0x0009, 0x0 }, /* #26 */
    { 0x245442, 0x245442, 0x3297, 0x7297, 0x000e, 0x0 }, /* #27 */
    { 0x3a2006, 0x3a2006, 0x1a13, 0x1a53, 0x0006, 0x0 }, /* #28 */
    { 0x195a57, 0x195a57, 0x6773, 0x6773, 0x0008, 0x0 }, /* #29 */
    { 0x1403c2, 0x1403c2, 0x2189, 0x21c9, 0x0006, 0x0 }, /* #30 */
    { 0x051ac2, 0x051ac2, 0x7610, 0xf610, 0x000f, 0x0 }, /* #31 */
    { 0x263542, 0x263542, 0x0342, 0x4342, 0x000e, 0x0 }, /* #32 */
    { 0x1371d7, 0x1371d6, 0x96b8, 0x96bc, 0x0002, 0x0 }, /* #33 */
    { 0x015747, 0x015747, 0x779f, 0x779f, 0x000d, 0x0 }, /* #34 */
    { 0x1c2513, 0x1c2512, 0x48d6, 0x49d6, 0x0008, 0x0 }, /* #35 */
    { 0x3a68d2, 0x3a68d2, 0x635a, 0x635b, 0x0000, 0x0 }, /* #36 */
    { 0x1a1cc2, 0x1a1cc2, 0xda3b, 0xdabb, 0x0007, 0x0 }, /* #37 */
    { 0x0e26d6, 0x0e26d6, 0xc38f, 0xc3cf, 0x0006, 0x0 }, /* #38 */
    { 0x394c13, 0x394c13, 0x9617, 0x9617, 0x000f, 0x0 }, /* #39 */
    { 0x312897, 0x312896, 0x5aab, 0x5bab, 0x0008, 0x0 }, /* #40 */
    { 0x0a1217, 0x0a1216, 0x7940, 0x79c0, 0x0007, 0x0 }, /* #41 */
    { 0x0c22d6, 0x0c22d7, 0xf0ea, 0xf0ea, 0x0003, 0x0 }, /* #42 */
    { 0x024f42, 0x024f42, 0x0ae5, 0x0ae7, 0x0001, 0x0 }, /* #43 */
    { 0x080f97, 0x080f96, 0x65ab, 0x75ab, 0x000c, 0x0 }, /* #44 */
    { 0x157897, 0x157896, 0x84d0, 0x94d0, 0x000c, 0x0 }, /* #45 */
    { 0x1d4c96, 0x1d4c96, 0xc5d9, 0xc5db, 0x0001, 0x0 }, /* #46 */
    { 0x0d4ed7, 0x0d4ed6, 0x9647, 0xb647, 0x000d, 0x0 }, /* #47 */
    { 0x2f0882, 0x2f0882, 0xd302, 0xd30a, 0x0003, 0x0 }, /* #48 */
    { 0x112a03, 0x112a02, 0x9f36, 0xbf36, 0x000d, 0x0 }, /* #49 */
    { 0x252a87, 0x252a86, 0x0a46, 0x0a4e, 0x0003, 0x0 }, /* #50 */
    { 0x201b07, 0x201b06, 0x004a, 0x00ca, 0x0007, 0x0 }, /* #51 */
    { 0x0f4d83, 0x0f4d83, 0x29ec, 0x29ec, 0x000d, 0x0 }, /* #52 */
    { 0x220043, 0x220042, 0x3110, 0x3118, 0x0003, 0x0 }, /* #53 */
    { 0x032617, 0x032616, 0x4d0b, 0x4d0f, 0x0002, 0x0 }, /* #54 */
    { 0x133597, 0x133597, 0x13ae, 0x13ae, 0x000c, 0x0 }, /* #55 */
    { 0x190e52, 0x190e52, 0x190e, 0x590e, 0x000e, 0x0 }, /* #56 */
    { 0x3d07c2, 0x3d07c3, 0x5ffe, 0x5ffe, 0x000c, 0x0 }, /* #57 */
    { 0x164b56, 0x164b57, 0xa7ce, 0xa7ce, 0x0006, 0x0 }, /* #58 */
    { 0x213a93, 0x213a92, 0x4ac2, 0x6ac2, 0x000d, 0x0 }, /* #59 */
    { 0x090f97, 0x090f96, 0xa30d, 0xb30d, 0x000c, 0x0 }, /* #60 */
    { 0x3c36c6, 0x3c36c7, 0xefe1, 0xefe1, 0x0000, 0x0 }, /* #61 */
    { 0x156a03, 0x156a03, 0x945d, 0x945d, 0x0000, 0x0 }, /* #62 */
    { 0x0e1706, 0x0e1706, 0x7142, 0x7942, 0x000b, 0x0 }, /* #63 */
    { 0x0b10d7, 0x0b10d6, 0x24aa, 0x34aa, 0x000c, 0x0 }, /* #64 */
    { 0x032b92, 0x032b92, 0xc597, 0xc59f, 0x0003, 0x0 }, /* #65 */
    { 0x1c75c6, 0x1c75c7, 0xeeb6, 0xeeb6, 0x0002, 0x0 }, /* #66 */
    { 0x342556, 0x342557, 0x4df1, 0x4df1, 0x0000, 0x0 }, /* #67 */
    { 0x391a47, 0x391a46, 0xe33e, 0xe37e, 0x0006, 0x0 }, /* #68 */
    { 0x132047, 0x132046, 0x7ff0, 0x7ff2, 0x0001, 0x0 }, /* #69 */
    { 0x0a1213, 0x0a1212, 0x9c38, 0x9c39, 0x0000, 0x0 }, /* #70 */
    { 0x334316, 0x334317, 0xcf34, 0xcf34, 0x000a, 0x0 }, /* #71 */
    { 0x290e86, 0x290e86, 0x0ca8, 0x0ce8, 0x0006, 0x0 }, /* #72 */
    { 0x361303, 0x361303, 0x042e, 0x042e, 0x0003, 0x0 }, /* #73 */
    { 0x391b97, 0x391b96, 0xa8de, 0xa9de, 0x0008, 0x0 }, /* #74 */
    { 0x376d12, 0x376d13, 0x57a5, 0x57a5, 0x0005, 0x0 }, /* #75 */
    { 0x277d07, 0x277d06, 0x3428, 0x3628, 0x0009, 0x0 }, /* #76 */
    { 0x310dc2, 0x310dc3, 0x196f, 0x196f, 0x000b, 0x0 }, /* #77 */
    { 0x027cc7, 0x027cc7, 0x6d8c, 0x6d8c, 0x000a, 0x0 }, /* #78 */
    { 0x0c50d7, 0x0c50d7, 0xf538, 0xf538, 0x0005, 0x0 }, /* #79 */
    { 0x1f4602, 0x1f4603, 0xf845, 0xf845, 0x000b, 0x0 }, /* #80 */
    { 0x2d3812, 0x2d3813, 0xcc6d, 0xcc6d, 0x000e, 0x0 }, /* #81 */
    { 0x181d47, 0x181d46, 0x1286, 0x1686, 0x000a, 0x0 }, /* #82 */
    { 0x2a5b57, 0x2a5b56, 0xca69, 0xcb69, 0x0008, 0x0 }, /* #83 */
    { 0x222907, 0x222907, 0x15d3, 0x15d3, 0x0008, 0x0 }, /* #84 */
    { 0x1c5bd6, 0x1c5bd7, 0x387a, 0x387a, 0x0003, 0x0 }, /* #85 */
    { 0x183b53, 0x183b52, 0x68b4, 0x69b4, 0x0008, 0x0 }, /* #86 */
    { 0x191583, 0x191582, 0x83ff, 0x93ff, 0x000c, 0x0 }, /* #87 */
    { 0x292512, 0x292512, 0x610a, 0x618a, 0x0007, 0x0 }, /* #88 */
    { 0x347457, 0x347456, 0x82f9, 0x92f9, 0x000c, 0x0 }, /* #89 */
    { 0x085842, 0x085842, 0xb209, 0xb20d, 0x0002, 0x0 }, /* #90 */
    { 0x2f6307, 0x2f6306, 0xa608, 0xa688, 0x0007, 0x0 }, /* #91 */
    { 0x1b2ac2, 0x1b2ac3, 0x94a3, 0x94a3, 0x0000, 0x0 }, /* #92 */
    { 0x0d0612, 0x0d0612, 0x3004, 0xb004, 0x000f, 0x0 }, /* #93 */
    { 0x382492, 0x382492, 0x44f7, 0x45f7, 0x0008, 0x0 }, /* #94 */
    { 0x1f3e02, 0x1f3e03, 0x6d63, 0x6d63, 0x0006, 0x0 }, /* #95 */
};
uint32_t const g_cTests_bts_u16_locked = RT_ELEMENTS(g_aTests_bts_u16_locked);

BINU16_TEST_T const g_aTests_arpl[] =
{
    { 0x2d0d52, 0x2d0d12, 0x0000, 0x0000, 0x0000, 0x0 }, /* #0 */
    { 0x154f03, 0x154f03, 0x0000, 0x0000, 0x0000, 0x0 }, /* #1 */
    { 0x390e97, 0x390e97, 0x0000, 0x0000, 0x0000, 0x0 }, /* #2 */
    { 0x293fd6, 0x293f96, 0x0000, 0x0000, 0x0000, 0x0 }, /* #3 */
    { 0x202813, 0x202813, 0x0000, 0x0000, 0x0000, 0x0 }, /* #4 */
    { 0x0656c7, 0x065687, 0x0000, 0x0000, 0x0000, 0x0 }, /* #5 */
    { 0x0c5b53, 0x0c5b13, 0x7d36, 0x7d36, 0x0000, 0x0 }, /* #6 */
    { 0x361407, 0x361407, 0xe2b1, 0xe2b1, 0x0000, 0x0 }, /* #7 */
    { 0x074257, 0x074217, 0xfbf4, 0xfbf4, 0x0000, 0x0 }, /* #8 */
    { 0x306903, 0x306903, 0x6141, 0x6141, 0x0000, 0x0 }, /* #9 */
    { 0x291f03, 0x291f03, 0x830d, 0x830d, 0x0000, 0x0 }, /* #10 */
    { 0x3b3557, 0x3b3517, 0x8be1, 0x8be1, 0x0000, 0x0 }, /* #11 */
    { 0x114e97, 0x114e97, 0x6f63, 0x6f63, 0x17f5, 0x0 }, /* #12 */
    { 0x1205c2, 0x120582, 0x0a95, 0x0a95, 0x4194, 0x0 }, /* #13 */
    { 0x0c7992, 0x0c7992, 0x1ca4, 0x1ca4, 0x3798, 0x0 }, /* #14 */
    { 0x1502d3, 0x150293, 0xd7fc, 0xd7fc, 0x95f8, 0x0 }, /* #15 */
    { 0x3b7e47, 0x3b7e47, 0x69ba, 0x69bb, 0x13e7, 0x0 }, /* #16 */
    { 0x014846, 0x014806, 0xd78b, 0xd78b, 0xa75f, 0x0 }, /* #17 */
    { 0x215a86, 0x215a86, 0x54ec, 0x54ec, 0xb2a4, 0x0 }, /* #18 */
    { 0x0b1892, 0x0b18d2, 0x94bc, 0x94bd, 0x61bd, 0x0 }, /* #19 */
    { 0x290146, 0x290106, 0x71bf, 0x71bf, 0xfe3e, 0x0 }, /* #20 */
    { 0x1328d2, 0x132892, 0x5a0f, 0x5a0f, 0x129a, 0x0 }, /* #21 */
    { 0x0d7846, 0x0d7806, 0xc10a, 0xc10a, 0x2c94, 0x0 }, /* #22 */
    { 0x250616, 0x250656, 0x513d, 0x513e, 0xa2e6, 0x0 }, /* #23 */
    { 0x322a53, 0x322a13, 0xd037, 0xd037, 0xc9e0, 0x0 }, /* #24 */
    { 0x0617c2, 0x061782, 0x7f15, 0x7f15, 0x3d68, 0x0 }, /* #25 */
    { 0x1369c7, 0x136987, 0x00f6, 0x00f6, 0x5da9, 0x0 }, /* #26 */
    { 0x3f61d2, 0x3f6192, 0x749f, 0x749f, 0xc6f9, 0x0 }, /* #27 */
    { 0x2e2b87, 0x2e2b87, 0xf5ad, 0xf5ad, 0x3380, 0x0 }, /* #28 */
    { 0x3a4d12, 0x3a4d52, 0x3d24, 0x3d25, 0x1a49, 0x0 }, /* #29 */
    { 0x0e0fc2, 0x0e0fc2, 0xb0a0, 0xb0a2, 0xa65e, 0x0 }, /* #30 */
    { 0x067996, 0x067996, 0x5ea0, 0x5ea0, 0x5e50, 0x0 }, /* #31 */
    { 0x142a12, 0x142a52, 0xd630, 0xd632, 0xa372, 0x0 }, /* #32 */
    { 0x102fc3, 0x102f83, 0x2e81, 0x2e81, 0x7bb5, 0x0 }, /* #33 */
    { 0x140bc7, 0x140b87, 0xeafa, 0xeafa, 0x2719, 0x0 }, /* #34 */
    { 0x073692, 0x073692, 0xbae7, 0xbae7, 0x3239, 0x0 }, /* #35 */
    { 0x2e5003, 0x2e5003, 0x6776, 0x6776, 0x96ee, 0x0 }, /* #36 */
    { 0x042292, 0x0422d2, 0xd322, 0xd323, 0xec5b, 0x0 }, /* #37 */
    { 0x0b7c12, 0x0b7c12, 0x7eab, 0x7eab, 0x225a, 0x0 }, /* #38 */
    { 0x087156, 0x087156, 0x20d0, 0x20d2, 0x57ca, 0x0 }, /* #39 */
    { 0x0319d7, 0x0319d7, 0x966e, 0x966f, 0x1f1f, 0x0 }, /* #40 */
    { 0x0238c3, 0x023883, 0x948a, 0x948a, 0x972e, 0x0 }, /* #41 */
    { 0x003813, 0x003853, 0x6e7c, 0x6e7d, 0x5345, 0x0 }, /* #42 */
    { 0x1e0583, 0x1e05c3, 0x0515, 0x0517, 0x9c37, 0x0 }, /* #43 */
    { 0x1203c7, 0x120387, 0x017a, 0x017a, 0xe8a8, 0x0 }, /* #44 */
    { 0x386006, 0x386006, 0x4922, 0x4922, 0x3d99, 0x0 }, /* #45 */
    { 0x0f4996, 0x0f4996, 0x0313, 0x0313, 0x2e8c, 0x0 }, /* #46 */
    { 0x076b02, 0x076b42, 0xa45c, 0xa45f, 0xc0f7, 0x0 }, /* #47 */
    { 0x327cd6, 0x327c96, 0x9c07, 0x9c07, 0x9293, 0x0 }, /* #48 */
    { 0x011353, 0x011313, 0x922e, 0x922e, 0xab6a, 0x0 }, /* #49 */
    { 0x1b0cc3, 0x1b0cc3, 0x41f5, 0x41f7, 0x16fb, 0x0 }, /* #50 */
    { 0x1e72d2, 0x1e7292, 0x4a6b, 0x4a6b, 0x2d01, 0x0 }, /* #51 */
    { 0x182b03, 0x182b03, 0x81fa, 0x81fa, 0xea50, 0x0 }, /* #52 */
    { 0x213813, 0x213853, 0x4f7d, 0x4f7e, 0x2f8e, 0x0 }, /* #53 */
    { 0x3d4506, 0x3d4546, 0x4646, 0x4647, 0xe8cb, 0x0 }, /* #54 */
    { 0x0a6947, 0x0a6907, 0xcf68, 0xcf68, 0x6110, 0x0 }, /* #55 */
    { 0x163a13, 0x163a53, 0x32d8, 0x32da, 0xab5a, 0x0 }, /* #56 */
    { 0x256293, 0x256293, 0x778d, 0x778d, 0x3779, 0x0 }, /* #57 */
    { 0x010282, 0x010282, 0xa8b9, 0xa8b9, 0xb5d0, 0x0 }, /* #58 */
    { 0x0f7646, 0x0f7646, 0x4bd8, 0x4bda, 0x8ebe, 0x0 }, /* #59 */
    { 0x191c46, 0x191c06, 0x738b, 0x738b, 0x3312, 0x0 }, /* #60 */
    { 0x0e7493, 0x0e7493, 0x8a86, 0x8a86, 0x006e, 0x0 }, /* #61 */
    { 0x3623c2, 0x362382, 0x672b, 0x672b, 0x6854, 0x0 }, /* #62 */
    { 0x216d86, 0x216d86, 0x25d7, 0x25d7, 0x06ae, 0x0 }, /* #63 */
    { 0x396053, 0x396013, 0x8ce3, 0x8ce3, 0xa14e, 0x0 }, /* #64 */
    { 0x2d4ac7, 0x2d4a87, 0xd442, 0xd442, 0x92f0, 0x0 }, /* #65 */
    { 0x1832d3, 0x183293, 0x4f7f, 0x4f7f, 0x220d, 0x0 }, /* #66 */
    { 0x347506, 0x347546, 0xbb44, 0xbb47, 0x37bf, 0x0 }, /* #67 */
    { 0x026947, 0x026907, 0x1087, 0x1087, 0x1732, 0x0 }, /* #68 */
    { 0x3a5c17, 0x3a5c57, 0xa3a0, 0xa3a1, 0xf715, 0x0 }, /* #69 */
    { 0x006583, 0x0065c3, 0x1498, 0x149b, 0x3b3b, 0x0 }, /* #70 */
    { 0x2c6d02, 0x2c6d02, 0x61ae, 0x61ae, 0xcd48, 0x0 }, /* #71 */
    { 0x2b5243, 0x2b5203, 0x9d5a, 0x9d5a, 0x9cd5, 0x0 }, /* #72 */
    { 0x0303c6, 0x0303c6, 0x0620, 0x0621, 0x99d9, 0x0 }, /* #73 */
    { 0x2867c6, 0x286786, 0xc885, 0xc885, 0xe241, 0x0 }, /* #74 */
    { 0x3c2807, 0x3c2807, 0x6e3e, 0x6e3e, 0x7341, 0x0 }, /* #75 */
    { 0x0e7883, 0x0e7883, 0x9cc2, 0x9cc2, 0x7c30, 0x0 }, /* #76 */
    { 0x141f97, 0x141f97, 0x4c8f, 0x4c8f, 0xe9cf, 0x0 }, /* #77 */
    { 0x1d4583, 0x1d45c3, 0x53d6, 0x53d7, 0x2267, 0x0 }, /* #78 */
    { 0x377846, 0x377846, 0xb70d, 0xb70f, 0x0333, 0x0 }, /* #79 */
    { 0x2a02d6, 0x2a0296, 0x2cbf, 0x2cbf, 0x7096, 0x0 }, /* #80 */
    { 0x0c13c3, 0x0c13c3, 0x1021, 0x1023, 0x690b, 0x0 }, /* #81 */
    { 0x0e63c3, 0x0e63c3, 0x9930, 0x9931, 0x1219, 0x0 }, /* #82 */
    { 0x011d12, 0x011d52, 0x756c, 0x756e, 0x8882, 0x0 }, /* #83 */
    { 0x3a09c2, 0x3a0982, 0xf34d, 0xf34d, 0x3b80, 0x0 }, /* #84 */
    { 0x080397, 0x080397, 0x6fee, 0x6fee, 0x74f8, 0x0 }, /* #85 */
    { 0x0d6f92, 0x0d6fd2, 0x60ec, 0x60ed, 0xda0d, 0x0 }, /* #86 */
    { 0x2021d7, 0x202197, 0x2d57, 0x2d57, 0x0458, 0x0 }, /* #87 */
    { 0x113612, 0x113652, 0x5b3a, 0x5b3b, 0x483b, 0x0 }, /* #88 */
    { 0x157d93, 0x157dd3, 0x8872, 0x8873, 0xa69b, 0x0 }, /* #89 */
    { 0x1f2a92, 0x1f2a92, 0xb43e, 0xb43e, 0xde80, 0x0 }, /* #90 */
    { 0x1e54c3, 0x1e5483, 0xa977, 0xa977, 0xdb4c, 0x0 }, /* #91 */
    { 0x286c56, 0x286c56, 0xe16d, 0xe16e, 0x3c6a, 0x0 }, /* #92 */
    { 0x1c60c7, 0x1c60c7, 0xdbe9, 0xdbeb, 0x293f, 0x0 }, /* #93 */
    { 0x0e5f02, 0x0e5f02, 0xfc07, 0xfc07, 0xe509, 0x0 }, /* #94 */
    { 0x0e41d6, 0x0e4196, 0x92f4, 0x92f4, 0xc458, 0x0 }, /* #95 */
};
uint32_t const g_cTests_arpl = RT_ELEMENTS(g_aTests_arpl);

BINU32_TEST_T const g_aTests_add_u32[] =
{
    { 0x1679d7, 0x167146, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #0 */
    { 0x2f50c3, 0x2f5046, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x066117, 0x066146, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #2 */
    { 0x001793, 0x001746, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #3 */
    { 0x054446, 0x054446, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #4 */
    { 0x1c1857, 0x1c1046, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x174513, 0x174502, 0x44b40826, 0x44b40826, 0x00000000, 0x0 }, /* #6 */
    { 0x005847, 0x005006, 0x03c9edca, 0x03c9edca, 0x00000000, 0x0 }, /* #7 */
    { 0x3a6cc7, 0x3a6482, 0xacd56862, 0xacd56862, 0x00000000, 0x0 }, /* #8 */
    { 0x254552, 0x254502, 0x6b53c025, 0x6b53c025, 0x00000000, 0x0 }, /* #9 */
    { 0x3979c6, 0x397186, 0xd9be60e1, 0xd9be60e1, 0x00000000, 0x0 }, /* #10 */
    { 0x140e46, 0x140686, 0x852ecc8e, 0x852ecc8e, 0x00000000, 0x0 }, /* #11 */
    { 0x1d3c86, 0x1d3492, 0x3afc47cf, 0xcea4ee38, 0x93a8a669, 0x0 }, /* #12 */
    { 0x2e1087, 0x2e1882, 0x50da3809, 0xcbff21b9, 0x7b24e9b0, 0x0 }, /* #13 */
    { 0x3b4a06, 0x3b4216, 0x3e2efe3e, 0x63da6b1d, 0x25ab6cdf, 0x0 }, /* #14 */
    { 0x0b2d16, 0x0b2d92, 0x2e8d5708, 0xae842b07, 0x7ff6d3ff, 0x0 }, /* #15 */
    { 0x1c73c6, 0x1c7b86, 0x7c102a69, 0x8203d8fc, 0x05f3ae93, 0x0 }, /* #16 */
    { 0x1535c2, 0x153593, 0xd2eadd68, 0xafc5c792, 0xdcdaea2a, 0x0 }, /* #17 */
    { 0x391f13, 0x391786, 0xa51bc042, 0xfee2ae05, 0x59c6edc3, 0x0 }, /* #18 */
    { 0x020f02, 0x020796, 0xa746b459, 0xf5af7777, 0x4e68c31e, 0x0 }, /* #19 */
    { 0x120bd3, 0x120317, 0x1fa9bdfe, 0x0c423ba9, 0xec987dab, 0x0 }, /* #20 */
    { 0x283ad2, 0x283a96, 0x52fae934, 0x8d2d3d22, 0x3a3253ee, 0x0 }, /* #21 */
    { 0x0b6b83, 0x0b6382, 0x6143f5b4, 0xefd53358, 0x8e913da4, 0x0 }, /* #22 */
    { 0x207856, 0x207092, 0xb5ae5aae, 0xc5b221b3, 0x1003c705, 0x0 }, /* #23 */
    { 0x302d06, 0x302d17, 0x979466d9, 0x53c1e742, 0xbc2d8069, 0x0 }, /* #24 */
    { 0x1d1107, 0x1d1113, 0xca173e2f, 0x11a93c62, 0x4791fe33, 0x0 }, /* #25 */
    { 0x134653, 0x134683, 0xe75b3d33, 0xa8156bec, 0xc0ba2eb9, 0x0 }, /* #26 */
    { 0x3272c6, 0x327203, 0xfbafe52e, 0x053b170e, 0x098b31e0, 0x0 }, /* #27 */
    { 0x1962d6, 0x196282, 0x0a9b6167, 0xc8a48eab, 0xbe092d44, 0x0 }, /* #28 */
    { 0x3d4016, 0x3d4087, 0xa83cac2a, 0xa494b10c, 0xfc5804e2, 0x0 }, /* #29 */
    { 0x107647, 0x107692, 0x22731acb, 0xe064d268, 0xbdf1b79d, 0x0 }, /* #30 */
    { 0x2a30d6, 0x2a3093, 0x8ab7e5d9, 0x83d34de3, 0xf91b680a, 0x0 }, /* #31 */
    { 0x3d5183, 0x3d5182, 0x60f45756, 0xebec8b38, 0x8af833e2, 0x0 }, /* #32 */
    { 0x2b4842, 0x2b4087, 0xeeb90344, 0x9caf61b4, 0xadf65e70, 0x0 }, /* #33 */
    { 0x114607, 0x114686, 0x1cdcc516, 0xa0d9f506, 0x83fd2ff0, 0x0 }, /* #34 */
    { 0x3f5713, 0x3f5707, 0xd752c2e0, 0x18779011, 0x4124cd31, 0x0 }, /* #35 */
    { 0x0930c7, 0x093896, 0x62226099, 0x87355071, 0x2512efd8, 0x0 }, /* #36 */
    { 0x1779c2, 0x177196, 0xa6ffe17e, 0xd20a8690, 0x2b0aa512, 0x0 }, /* #37 */
    { 0x1e1c83, 0x1e1c13, 0x8e0c6405, 0x7b4f2fd0, 0xed42cbcb, 0x0 }, /* #38 */
    { 0x2a7dc2, 0x2a7d07, 0x9bbb2870, 0x3aa0e127, 0x9ee5b8b7, 0x0 }, /* #39 */
    { 0x397ac6, 0x397a03, 0x9401db70, 0x505f46ec, 0xbc5d6b7c, 0x0 }, /* #40 */
    { 0x386b52, 0x386b07, 0x808b54ca, 0x30e6999f, 0xb05b44d5, 0x0 }, /* #41 */
    { 0x1d5452, 0x1d5413, 0x6e9ff3de, 0x5ea6df19, 0xf006eb3b, 0x0 }, /* #42 */
    { 0x2c5156, 0x2c5107, 0x3c493b2a, 0x085a2efa, 0xcc10f3d0, 0x0 }, /* #43 */
    { 0x271e13, 0x271692, 0x17bd1e74, 0x9cd629f2, 0x85190b7e, 0x0 }, /* #44 */
    { 0x2a3ad7, 0x2a3207, 0x7dc1a729, 0x6a621bed, 0xeca074c4, 0x0 }, /* #45 */
    { 0x3d7a17, 0x3d7292, 0xd716e44f, 0xf38cac1c, 0x1c75c7cd, 0x0 }, /* #46 */
    { 0x3f3603, 0x3f3683, 0xd3aa87c3, 0xc6bac9a8, 0xf31041e5, 0x0 }, /* #47 */
    { 0x350893, 0x350017, 0x738cd1c7, 0x105399f6, 0x9cc6c82f, 0x0 }, /* #48 */
    { 0x247cc6, 0x247c17, 0x9241d7f4, 0x1a236171, 0x87e1897d, 0x0 }, /* #49 */
    { 0x2356d3, 0x235693, 0xefecd4f6, 0x88c9f843, 0x98dd234d, 0x0 }, /* #50 */
    { 0x3e7803, 0x3e7083, 0xf2ac87c0, 0xb36715b5, 0xc0ba8df5, 0x0 }, /* #51 */
    { 0x0d2113, 0x0d2107, 0xb845e706, 0x3572d7fc, 0x7d2cf0f6, 0x0 }, /* #52 */
    { 0x174097, 0x174817, 0x8096b82c, 0x6fb9b8db, 0xef2300af, 0x0 }, /* #53 */
    { 0x204a42, 0x204a82, 0x66801c4b, 0x9c748e7f, 0x35f47234, 0x0 }, /* #54 */
    { 0x1237d3, 0x123706, 0x68cb3740, 0x751de95a, 0x0c52b21a, 0x0 }, /* #55 */
    { 0x373992, 0x373112, 0x6067a9ad, 0x6a3ed080, 0x09d726d3, 0x0 }, /* #56 */
    { 0x1513d7, 0x151396, 0x2a98b20b, 0xbef762ca, 0x945eb0bf, 0x0 }, /* #57 */
    { 0x086a12, 0x086a07, 0x89406e79, 0x72b9341e, 0xe978c5a5, 0x0 }, /* #58 */
    { 0x320e02, 0x320692, 0x753c2b88, 0xf58ca015, 0x8050748d, 0x0 }, /* #59 */
    { 0x385806, 0x385013, 0xcbc4b7c8, 0x0c77bf26, 0x40b3075e, 0x0 }, /* #60 */
    { 0x1e67c2, 0x1e6792, 0x43e3fea8, 0xf26a0510, 0xae860668, 0x0 }, /* #61 */
    { 0x3f2712, 0x3f2713, 0x4e0241f5, 0x2b8496f1, 0xdd8254fc, 0x0 }, /* #62 */
    { 0x341856, 0x341093, 0xf2c64446, 0xe9216e92, 0xf65b2a4c, 0x0 }, /* #63 */
    { 0x234297, 0x234282, 0xac0d82a7, 0xb43fdcb9, 0x08325a12, 0x0 }, /* #64 */
    { 0x094fd6, 0x094703, 0xd66e6513, 0x4348b843, 0x6cda5330, 0x0 }, /* #65 */
    { 0x011442, 0x011497, 0xfe7a8c3f, 0xda076a1d, 0xdb8cddde, 0x0 }, /* #66 */
    { 0x114797, 0x114713, 0xd56cc188, 0x054caa51, 0x2fdfe8c9, 0x0 }, /* #67 */
    { 0x3c1cd6, 0x3c1486, 0x8752c241, 0xf17456c3, 0x6a219482, 0x0 }, /* #68 */
    { 0x2a4cc6, 0x2a4407, 0x554e8566, 0x4b0f0d1b, 0xf5c087b5, 0x0 }, /* #69 */
    { 0x221f12, 0x221787, 0xfbb080f4, 0xd643f21b, 0xda937127, 0x0 }, /* #70 */
    { 0x3b2a93, 0x3b2202, 0x38b3df81, 0x6760d592, 0x2eacf611, 0x0 }, /* #71 */
    { 0x1d3dd2, 0x1d3597, 0xd5bc1e05, 0x8574afa3, 0xafb8919e, 0x0 }, /* #72 */
    { 0x356e97, 0x356603, 0xd54a1b9c, 0x280b0cae, 0x52c0f112, 0x0 }, /* #73 */
    { 0x274097, 0x274003, 0x6cc86fe6, 0x2687bdb9, 0xb9bf4dd3, 0x0 }, /* #74 */
    { 0x191483, 0x191c13, 0x9e3a3b9a, 0x33261619, 0x94ebda7f, 0x0 }, /* #75 */
    { 0x2001c2, 0x200196, 0x8d7403ac, 0xa06ce3b4, 0x12f8e008, 0x0 }, /* #76 */
    { 0x367fc3, 0x367713, 0x72a574ee, 0x2e1cae7a, 0xbb77398c, 0x0 }, /* #77 */
    { 0x1f5183, 0x1f5113, 0x2fc74376, 0x2b2d6e51, 0xfb662adb, 0x0 }, /* #78 */
    { 0x066207, 0x066203, 0xdaabb789, 0x0c7ccc6b, 0x31d114e2, 0x0 }, /* #79 */
    { 0x245712, 0x245716, 0x15a97e4f, 0x4b7a8011, 0x35d101c2, 0x0 }, /* #80 */
    { 0x1b7f83, 0x1b7713, 0x4284ff4b, 0x06f3fc26, 0xc46efcdb, 0x0 }, /* #81 */
    { 0x305f92, 0x305703, 0x6ef40713, 0x64442da7, 0xf5502694, 0x0 }, /* #82 */
    { 0x017f93, 0x017703, 0xce892a80, 0x39ebc4d9, 0x6b629a59, 0x0 }, /* #83 */
    { 0x2128d7, 0x212003, 0x67e75953, 0x4e5b9826, 0xe6743ed3, 0x0 }, /* #84 */
    { 0x332997, 0x332107, 0x55bf2d4a, 0x4771a5be, 0xf1b27874, 0x0 }, /* #85 */
    { 0x056317, 0x056386, 0x1dfd413f, 0xce7abc0f, 0xb07d7ad0, 0x0 }, /* #86 */
    { 0x341d52, 0x341503, 0x70333fc2, 0x3df9c008, 0xcdc68046, 0x0 }, /* #87 */
    { 0x277fc6, 0x277712, 0x3e7c3935, 0x40afced0, 0x0233959b, 0x0 }, /* #88 */
    { 0x1b0f82, 0x1b0797, 0xfcc17194, 0xe33094f0, 0xe66f235c, 0x0 }, /* #89 */
    { 0x3f1742, 0x3f1f86, 0x7df32088, 0xb6fa656c, 0x390744e4, 0x0 }, /* #90 */
    { 0x2407d2, 0x240787, 0xfd9b1849, 0xd31cffed, 0xd581e7a4, 0x0 }, /* #91 */
    { 0x2a6d06, 0x2a6503, 0xc0d69ac4, 0x044f1e0d, 0x43788349, 0x0 }, /* #92 */
    { 0x0e5996, 0x0e5117, 0x13f3e5ed, 0x04cc0aeb, 0xf0d824fe, 0x0 }, /* #93 */
    { 0x3c6797, 0x3c6713, 0xef3b3335, 0x00e98a70, 0x11ae573b, 0x0 }, /* #94 */
    { 0x1d25c2, 0x1d2d17, 0x9b63be35, 0x6a05fba3, 0xcea23d6e, 0x0 }, /* #95 */
};
uint32_t const g_cTests_add_u32 = RT_ELEMENTS(g_aTests_add_u32);

BINU32_TEST_T const g_aTests_add_u32_locked[] =
{
    { 0x273b96, 0x273346, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #0 */
    { 0x264717, 0x264746, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x055c52, 0x055446, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #2 */
    { 0x0d0e02, 0x0d0646, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #3 */
    { 0x2e2d86, 0x2e2546, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #4 */
    { 0x091983, 0x091146, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x265b03, 0x265306, 0x51055595, 0x51055595, 0x00000000, 0x0 }, /* #6 */
    { 0x352c96, 0x352486, 0xd652db39, 0xd652db39, 0x00000000, 0x0 }, /* #7 */
    { 0x211107, 0x211186, 0xd91632cf, 0xd91632cf, 0x00000000, 0x0 }, /* #8 */
    { 0x2f6553, 0x2f6582, 0xcd3b6e4f, 0xcd3b6e4f, 0x00000000, 0x0 }, /* #9 */
    { 0x1a7a47, 0x1a7202, 0x603b1049, 0x603b1049, 0x00000000, 0x0 }, /* #10 */
    { 0x251f42, 0x251786, 0xb5aba5b7, 0xb5aba5b7, 0x00000000, 0x0 }, /* #11 */
    { 0x051c83, 0x051416, 0x1e5cd296, 0x574898b4, 0x38ebc61e, 0x0 }, /* #12 */
    { 0x260982, 0x260982, 0x6c3861a3, 0xb3e66b04, 0x47ae0961, 0x0 }, /* #13 */
    { 0x381ad2, 0x381207, 0xe52d9f70, 0x4b7adbc3, 0x664d3c53, 0x0 }, /* #14 */
    { 0x202242, 0x202297, 0xb704b93d, 0xb5306ae2, 0xfe2bb1a5, 0x0 }, /* #15 */
    { 0x364482, 0x364406, 0x10f932a9, 0x7f9bb2f9, 0x6ea28050, 0x0 }, /* #16 */
    { 0x2f4fd7, 0x2f4786, 0xbdb70005, 0xd12015f5, 0x136915f0, 0x0 }, /* #17 */
    { 0x380593, 0x380513, 0xf4099eb7, 0x4de59ee3, 0x59dc002c, 0x0 }, /* #18 */
    { 0x311102, 0x311107, 0x91dbafc0, 0x06c1e3a0, 0x74e633e0, 0x0 }, /* #19 */
    { 0x266b02, 0x266383, 0x96b01828, 0x829be3fd, 0xebebcbd5, 0x0 }, /* #20 */
    { 0x142c02, 0x142c07, 0xb1b05383, 0x3f6cff18, 0x8dbcab95, 0x0 }, /* #21 */
    { 0x0f4793, 0x0f4782, 0x1fc668f0, 0xc3b65e37, 0xa3eff547, 0x0 }, /* #22 */
    { 0x010ac6, 0x010293, 0xff754f8e, 0xdab2fd4a, 0xdb3dadbc, 0x0 }, /* #23 */
    { 0x050b53, 0x050b03, 0xcb5e7f4d, 0x4c1d5aef, 0x80bedba2, 0x0 }, /* #24 */
    { 0x2b6753, 0x2b6782, 0x83f4647b, 0xd0498f3e, 0x4c552ac3, 0x0 }, /* #25 */
    { 0x262197, 0x262197, 0xffd52de7, 0xdf9add00, 0xdfc5af19, 0x0 }, /* #26 */
    { 0x260e52, 0x260617, 0x7cb617c3, 0x613ac611, 0xe484ae4e, 0x0 }, /* #27 */
    { 0x1d4943, 0x1d4107, 0xc2cb3479, 0x12daa34b, 0x500f6ed2, 0x0 }, /* #28 */
    { 0x1026c3, 0x102606, 0x060c2f71, 0x3cd17435, 0x36c544c4, 0x0 }, /* #29 */
    { 0x3a6886, 0x3a6086, 0x0bfd1896, 0xf85a77fa, 0xec5d5f64, 0x0 }, /* #30 */
    { 0x332c83, 0x332482, 0xddd51767, 0xe3654e8f, 0x05903728, 0x0 }, /* #31 */
    { 0x216e42, 0x216682, 0x84f2878a, 0x973f6dab, 0x124ce621, 0x0 }, /* #32 */
    { 0x1b6a52, 0x1b6217, 0xf974b4c6, 0x3f482cb1, 0x45d377eb, 0x0 }, /* #33 */
    { 0x3d3443, 0x3d3403, 0xaf32a990, 0x2eca813d, 0x7f97d7ad, 0x0 }, /* #34 */
    { 0x0936c2, 0x093e03, 0xb23405c3, 0x43662a3b, 0x91322478, 0x0 }, /* #35 */
    { 0x3a2152, 0x3a2903, 0x81417e26, 0x4073dd9b, 0xbf325f75, 0x0 }, /* #36 */
    { 0x056942, 0x056107, 0x73299088, 0x24d4649a, 0xb1aad412, 0x0 }, /* #37 */
    { 0x3c5c06, 0x3c5407, 0xa4a10b4e, 0x12c822be, 0x6e271770, 0x0 }, /* #38 */
    { 0x1c0447, 0x1c0417, 0x70145ea5, 0x33e786f3, 0xc3d3284e, 0x0 }, /* #39 */
    { 0x360047, 0x360007, 0x7c037ee3, 0x28d5727b, 0xacd1f398, 0x0 }, /* #40 */
    { 0x0d5717, 0x0d5f03, 0xa26cd764, 0x4b3f5519, 0xa8d27db5, 0x0 }, /* #41 */
    { 0x242d53, 0x242506, 0x48057c87, 0x5ca175de, 0x149bf957, 0x0 }, /* #42 */
    { 0x106402, 0x106486, 0x96ce994a, 0x9b90061d, 0x04c16cd3, 0x0 }, /* #43 */
    { 0x0755c3, 0x075506, 0x18f55b69, 0x5de5350a, 0x44efd9a1, 0x0 }, /* #44 */
    { 0x2d0057, 0x2d0003, 0xc6f311a2, 0x1b08aa97, 0x541598f5, 0x0 }, /* #45 */
    { 0x2e1dd3, 0x2e1517, 0x443d684d, 0x3d77bfd1, 0xf93a5784, 0x0 }, /* #46 */
    { 0x1a3246, 0x1a3a96, 0x1bd2fa8f, 0x85c65c95, 0x69f36206, 0x0 }, /* #47 */
    { 0x0b1692, 0x0b1687, 0xf202dfc4, 0xcee88c3f, 0xdce5ac7b, 0x0 }, /* #48 */
    { 0x0e4183, 0x0e4907, 0x965ca89e, 0x54d17eaf, 0xbe74d611, 0x0 }, /* #49 */
    { 0x115c03, 0x115486, 0x9c401c75, 0xcbf119af, 0x2fb0fd3a, 0x0 }, /* #50 */
    { 0x0d3f56, 0x0d3783, 0xf2c951f3, 0xa415da3b, 0xb14c8848, 0x0 }, /* #51 */
    { 0x1d7982, 0x1d7192, 0x09e8ee1c, 0xa3729334, 0x9989a518, 0x0 }, /* #52 */
    { 0x306fd3, 0x306702, 0x142c9e81, 0x27232ca1, 0x12f68e20, 0x0 }, /* #53 */
    { 0x0a2547, 0x0a2d03, 0x8da156b2, 0x24f01c7f, 0x974ec5cd, 0x0 }, /* #54 */
    { 0x317646, 0x317693, 0xe72446bd, 0xa8a12854, 0xc17ce197, 0x0 }, /* #55 */
    { 0x013ed2, 0x013e07, 0xcd959057, 0x7c82f31d, 0xaeed62c6, 0x0 }, /* #56 */
    { 0x112006, 0x112807, 0x88e82f1a, 0x6d8d4bff, 0xe4a51ce5, 0x0 }, /* #57 */
    { 0x074712, 0x074797, 0xdf2cf529, 0x820a79b8, 0xa2dd848f, 0x0 }, /* #58 */
    { 0x3b6d93, 0x3b6597, 0xb119d9cc, 0x841856e8, 0xd2fe7d1c, 0x0 }, /* #59 */
    { 0x321553, 0x321512, 0x1eca84e6, 0x38b4dbc2, 0x19ea56dc, 0x0 }, /* #60 */
    { 0x067687, 0x067613, 0x5916b3ff, 0x3cb5d77a, 0xe39f237b, 0x0 }, /* #61 */
    { 0x2f4c97, 0x2f4417, 0xc33a12f7, 0x0ae47dc6, 0x47aa6acf, 0x0 }, /* #62 */
    { 0x046507, 0x046507, 0x6d911304, 0x6139598e, 0xf3a8468a, 0x0 }, /* #63 */
    { 0x233286, 0x233207, 0x63036a79, 0x02152bdd, 0x9f11c164, 0x0 }, /* #64 */
    { 0x366e93, 0x366687, 0xd3d60452, 0xc6e21105, 0xf30c0cb3, 0x0 }, /* #65 */
    { 0x263c46, 0x263416, 0x257fbf67, 0x2f2b9bc6, 0x09abdc5f, 0x0 }, /* #66 */
    { 0x267b97, 0x267393, 0xf79e6e7e, 0xb14cc670, 0xb9ae57f2, 0x0 }, /* #67 */
    { 0x1c3b43, 0x1c3382, 0xb6b976a0, 0xbcc23254, 0x0608bbb4, 0x0 }, /* #68 */
    { 0x1069d6, 0x106113, 0xda2b73bd, 0x157a4e3b, 0x3b4eda7e, 0x0 }, /* #69 */
    { 0x376e57, 0x376e17, 0xd617eedc, 0x6926cef6, 0x930ee01a, 0x0 }, /* #70 */
    { 0x2d4646, 0x2d4696, 0x88d2e81d, 0xea25f136, 0x61530919, 0x0 }, /* #71 */
    { 0x216386, 0x216b82, 0x61a56011, 0x95a11fcb, 0x33fbbfba, 0x0 }, /* #72 */
    { 0x3173c2, 0x317316, 0x15d88158, 0x3f9c6ff5, 0x29c3ee9d, 0x0 }, /* #73 */
    { 0x124852, 0x124087, 0xaf5278c4, 0x99db3e59, 0xea88c595, 0x0 }, /* #74 */
    { 0x0f1986, 0x0f1186, 0x13d71cd7, 0xfc9b3deb, 0xe8c42114, 0x0 }, /* #75 */
    { 0x2b51d7, 0x2b5197, 0xf53c627c, 0x90c321e4, 0x9b86bf68, 0x0 }, /* #76 */
    { 0x192a42, 0x192296, 0xddfd6367, 0xf70ee2e4, 0x19117f7d, 0x0 }, /* #77 */
    { 0x3e3f47, 0x3e3f17, 0x9f845d8d, 0x606afb9c, 0xc0e69e0f, 0x0 }, /* #78 */
    { 0x1e5ec6, 0x1e5682, 0x44155d86, 0xd4cfb479, 0x90ba56f3, 0x0 }, /* #79 */
    { 0x222892, 0x222092, 0x95fdb83c, 0xa4087c54, 0x0e0ac418, 0x0 }, /* #80 */
    { 0x075986, 0x075903, 0xd7e41f57, 0x5a50c83d, 0x826ca8e6, 0x0 }, /* #81 */
    { 0x0313d2, 0x031382, 0x978c9a16, 0xdcfd0f4f, 0x45707539, 0x0 }, /* #82 */
    { 0x1d1042, 0x1d1082, 0x8911cf7b, 0xee9258ab, 0x65808930, 0x0 }, /* #83 */
    { 0x2f2383, 0x2f2316, 0x0bfa9668, 0x53b43706, 0x47b9a09e, 0x0 }, /* #84 */
    { 0x2a0b47, 0x2a0386, 0x19bfb5b1, 0xef9adadb, 0xd5db252a, 0x0 }, /* #85 */
    { 0x2c1303, 0x2c1b03, 0x8e9d594a, 0x6e30b45e, 0xdf935b14, 0x0 }, /* #86 */
    { 0x307f02, 0x307792, 0x8b8a1414, 0xf2c893b3, 0x673e7f9f, 0x0 }, /* #87 */
    { 0x2f40c2, 0x2f4003, 0x4fb6ed47, 0x4df2dab9, 0xfe3bed72, 0x0 }, /* #88 */
    { 0x2f5f16, 0x2f5792, 0x8fbe1df5, 0xe35076e0, 0x539258eb, 0x0 }, /* #89 */
    { 0x0a7156, 0x0a7192, 0x3d944d44, 0xf182d2d0, 0xb3ee858c, 0x0 }, /* #90 */
    { 0x213fd3, 0x213787, 0xd49c1192, 0xb50ffcf9, 0xe073eb67, 0x0 }, /* #91 */
    { 0x1c1b42, 0x1c1397, 0xefba0bae, 0xc1fe9021, 0xd2448473, 0x0 }, /* #92 */
    { 0x062592, 0x062592, 0x590e411d, 0xf8041d4a, 0x9ef5dc2d, 0x0 }, /* #93 */
    { 0x0d3007, 0x0d3083, 0xf566e2ac, 0xeb9d3e1f, 0xf6365b73, 0x0 }, /* #94 */
    { 0x3e4093, 0x3e4007, 0xffcf5337, 0x0b18dd0c, 0x0b4989d5, 0x0 }, /* #95 */
};
uint32_t const g_cTests_add_u32_locked = RT_ELEMENTS(g_aTests_add_u32_locked);

BINU32_TEST_T const g_aTests_adc_u32[] =
{
    { 0x161c06, 0x161446, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #0 */
    { 0x1e0d16, 0x1e0546, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x1b5c83, 0x1b5402, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #2 */
    { 0x1414d2, 0x141446, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #3 */
    { 0x211653, 0x211602, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #4 */
    { 0x284d16, 0x284546, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x344907, 0x344182, 0xdfc239d9, 0xdfc239da, 0x00000000, 0x0 }, /* #6 */
    { 0x155242, 0x155202, 0x16c38d0d, 0x16c38d0d, 0x00000000, 0x0 }, /* #7 */
    { 0x162a17, 0x162282, 0x8c702393, 0x8c702394, 0x00000000, 0x0 }, /* #8 */
    { 0x1865d6, 0x186586, 0xbb10a5b2, 0xbb10a5b2, 0x00000000, 0x0 }, /* #9 */
    { 0x3a5347, 0x3a5302, 0x4c32c891, 0x4c32c892, 0x00000000, 0x0 }, /* #10 */
    { 0x3f00d2, 0x3f0082, 0xe53823dc, 0xe53823dc, 0x00000000, 0x0 }, /* #11 */
    { 0x093142, 0x093106, 0x1947f2f6, 0x5a4bb9bd, 0x4103c6c7, 0x0 }, /* #12 */
    { 0x153ec2, 0x153696, 0xb5ecbb4c, 0xcf598af0, 0x196ccfa4, 0x0 }, /* #13 */
    { 0x290a83, 0x290217, 0x38451ceb, 0x151d0b24, 0xdcd7ee38, 0x0 }, /* #14 */
    { 0x1d3886, 0x1d3017, 0xf2027023, 0x321d4c71, 0x401adc4e, 0x0 }, /* #15 */
    { 0x012487, 0x012417, 0xd75462fe, 0x4ca06d03, 0x754c0a04, 0x0 }, /* #16 */
    { 0x092d47, 0x092507, 0x37c81888, 0x133cbbac, 0xdb74a323, 0x0 }, /* #17 */
    { 0x1f6597, 0x1f6d13, 0xbdccc69c, 0x58c961bc, 0x9afc9b1f, 0x0 }, /* #18 */
    { 0x290dd6, 0x290d07, 0x92e95ed5, 0x7e81cb0f, 0xeb986c3a, 0x0 }, /* #19 */
    { 0x033a57, 0x033296, 0x13e14159, 0xb749dfe7, 0xa3689e8d, 0x0 }, /* #20 */
    { 0x195343, 0x195312, 0x47729fea, 0x7e939476, 0x3720f48b, 0x0 }, /* #21 */
    { 0x0f0543, 0x0f0506, 0x61f8dd71, 0x7a723f5c, 0x187961ea, 0x0 }, /* #22 */
    { 0x125a83, 0x125206, 0x606e5ae1, 0x6696ef06, 0x06289424, 0x0 }, /* #23 */
    { 0x0e6b42, 0x0e6b96, 0x74851114, 0x8da00f72, 0x191afe5e, 0x0 }, /* #24 */
    { 0x3e2d13, 0x3e2587, 0xc673b94d, 0x8a81ab6f, 0xc40df221, 0x0 }, /* #25 */
    { 0x3923d6, 0x392396, 0xc116fda9, 0xe9946e03, 0x287d705a, 0x0 }, /* #26 */
    { 0x0449c2, 0x044107, 0xfd23f971, 0x773d7877, 0x7a197f06, 0x0 }, /* #27 */
    { 0x1b0ec2, 0x1b0e92, 0x770391ab, 0xb3b51051, 0x3cb17ea6, 0x0 }, /* #28 */
    { 0x2e0893, 0x2e0017, 0xffbce025, 0x1b747030, 0x1bb7900a, 0x0 }, /* #29 */
    { 0x213353, 0x213307, 0x2b4a50b5, 0x16a51a5c, 0xeb5ac9a6, 0x0 }, /* #30 */
    { 0x285bc6, 0x285b13, 0xbdc853ad, 0x3dccb2c2, 0x80045f15, 0x0 }, /* #31 */
    { 0x097fd2, 0x097792, 0x43a7f646, 0xdcb344a4, 0x990b4e5e, 0x0 }, /* #32 */
    { 0x0d2d12, 0x0d2d03, 0x9140f870, 0x5091318f, 0xbf50391f, 0x0 }, /* #33 */
    { 0x390b92, 0x390303, 0x5af0be33, 0x2ab1b6e3, 0xcfc0f8b0, 0x0 }, /* #34 */
    { 0x312b52, 0x312307, 0x7a6529f5, 0x1c022b1d, 0xa19d0128, 0x0 }, /* #35 */
    { 0x004357, 0x004392, 0x3b9f36bb, 0xe5d18cc1, 0xaa325605, 0x0 }, /* #36 */
    { 0x055487, 0x055c82, 0x2d63f913, 0x84a9e1a8, 0x5745e894, 0x0 }, /* #37 */
    { 0x017352, 0x017b92, 0x51c04552, 0xb1f28180, 0x60323c2e, 0x0 }, /* #38 */
    { 0x031a87, 0x031292, 0x000a7ace, 0xf36909a1, 0xf35e8ed2, 0x0 }, /* #39 */
    { 0x111517, 0x111507, 0x611989a7, 0x10666378, 0xaf4cd9d0, 0x0 }, /* #40 */
    { 0x3d0246, 0x3d0217, 0x858c4d56, 0x004be230, 0x7abf94da, 0x0 }, /* #41 */
    { 0x2e4c57, 0x2e4c03, 0xb9ff6e44, 0x547690fb, 0x9a7722b6, 0x0 }, /* #42 */
    { 0x2a58d6, 0x2a5006, 0x22ff124b, 0x78c4a67e, 0x55c59433, 0x0 }, /* #43 */
    { 0x173953, 0x173106, 0x394607a2, 0x5e75a2db, 0x252f9b38, 0x0 }, /* #44 */
    { 0x211513, 0x211d13, 0x8046d1bf, 0x5eb6f997, 0xde7027d7, 0x0 }, /* #45 */
    { 0x0f7107, 0x0f7917, 0xe1ded5d5, 0x6f4607d1, 0x8d6731fb, 0x0 }, /* #46 */
    { 0x0c7f97, 0x0c7713, 0xb4df856d, 0x27dde6f8, 0x72fe618a, 0x0 }, /* #47 */
    { 0x0e7c93, 0x0e7c17, 0x81f98be3, 0x383fab53, 0xb6461f6f, 0x0 }, /* #48 */
    { 0x1e5f93, 0x1e5713, 0x7676301a, 0x6ca948f4, 0xf63318d9, 0x0 }, /* #49 */
    { 0x383a43, 0x383a13, 0x88c538cd, 0x6fe83067, 0xe722f799, 0x0 }, /* #50 */
    { 0x253a12, 0x253296, 0x8769f67f, 0xbdd80d9c, 0x366e171d, 0x0 }, /* #51 */
    { 0x2a2f93, 0x2a2782, 0x963adeb0, 0xa47ca49d, 0x0e41c5ec, 0x0 }, /* #52 */
    { 0x3f5157, 0x3f5193, 0xc6fcd851, 0x812fdfc1, 0xba33076f, 0x0 }, /* #53 */
    { 0x2077d6, 0x207f17, 0xa45cd3b4, 0x25902333, 0x81334f7f, 0x0 }, /* #54 */
    { 0x3b7092, 0x3b7082, 0xe20c39a2, 0xf94d8d9d, 0x174153fb, 0x0 }, /* #55 */
    { 0x3317d2, 0x331f17, 0x88649b4c, 0x094b95ca, 0x80e6fa7e, 0x0 }, /* #56 */
    { 0x165153, 0x165913, 0xdbfbedda, 0x758641b9, 0x998a53de, 0x0 }, /* #57 */
    { 0x2429c3, 0x242196, 0x19d607cb, 0xbb34ae11, 0xa15ea645, 0x0 }, /* #58 */
    { 0x1f7cd7, 0x1f7497, 0xe9eeac33, 0x9ec264e1, 0xb4d3b8ad, 0x0 }, /* #59 */
    { 0x290387, 0x290396, 0x132a3aaf, 0xa38ebd66, 0x906482b6, 0x0 }, /* #60 */
    { 0x0f3c97, 0x0f3492, 0x1e0db9f7, 0xf4204f52, 0xd612955a, 0x0 }, /* #61 */
    { 0x2b2093, 0x2b2017, 0xf4faca5a, 0x216b77c6, 0x2c70ad6b, 0x0 }, /* #62 */
    { 0x132053, 0x132096, 0x8062827b, 0xb59c9599, 0x353a131d, 0x0 }, /* #63 */
    { 0x0e2c83, 0x0e2417, 0x7f13030a, 0x7ba93572, 0xfc963267, 0x0 }, /* #64 */
    { 0x2b2a02, 0x2b2283, 0xffa80dd5, 0xd972abcd, 0xd9ca9df8, 0x0 }, /* #65 */
    { 0x1f4c56, 0x1f4403, 0xf779ecdb, 0x3ca52e5d, 0x452b4182, 0x0 }, /* #66 */
    { 0x2e6747, 0x2e6793, 0xa21b1cfb, 0x9f1fcc40, 0xfd04af44, 0x0 }, /* #67 */
    { 0x113007, 0x113892, 0x4281438c, 0xc11e7873, 0x7e9d34e6, 0x0 }, /* #68 */
    { 0x144596, 0x144d13, 0x88920e6a, 0x09085179, 0x8076430f, 0x0 }, /* #69 */
    { 0x015a17, 0x015a82, 0x2ff64250, 0xaa61a268, 0x7a6b6017, 0x0 }, /* #70 */
    { 0x3746d3, 0x374682, 0x103714e2, 0xc931ce34, 0xb8fab951, 0x0 }, /* #71 */
    { 0x3e4506, 0x3e4503, 0xbd855851, 0x121b662f, 0x54960dde, 0x0 }, /* #72 */
    { 0x150b52, 0x150b82, 0x5d3407f0, 0x9920db4f, 0x3becd35f, 0x0 }, /* #73 */
    { 0x236c53, 0x236482, 0xb8bf4bfd, 0xfb23f6ce, 0x4264aad0, 0x0 }, /* #74 */
    { 0x2153c2, 0x215303, 0x5b0e6589, 0x1c2f0cbf, 0xc120a736, 0x0 }, /* #75 */
    { 0x297c12, 0x297413, 0x282c257e, 0x19cee370, 0xf1a2bdf2, 0x0 }, /* #76 */
    { 0x056d46, 0x056512, 0x07fb25ea, 0x62694a02, 0x5a6e2418, 0x0 }, /* #77 */
    { 0x393116, 0x393107, 0x35dbeb5d, 0x2833dcbe, 0xf257f161, 0x0 }, /* #78 */
    { 0x015c12, 0x015403, 0x76efc791, 0x703abc15, 0xf94af484, 0x0 }, /* #79 */
    { 0x1966d2, 0x196e96, 0x73388cc9, 0xee8befd1, 0x7b536308, 0x0 }, /* #80 */
    { 0x3d17c2, 0x3d1f13, 0xad27bf7c, 0x50d07837, 0xa3a8b8bb, 0x0 }, /* #81 */
    { 0x316313, 0x316302, 0x4e95b6f3, 0x793e9a15, 0x2aa8e321, 0x0 }, /* #82 */
    { 0x006943, 0x006907, 0xaa7be070, 0x5b4b0459, 0xb0cf23e8, 0x0 }, /* #83 */
    { 0x3975d7, 0x397d92, 0x67fdc1c7, 0x82bb0fe0, 0x1abd4e18, 0x0 }, /* #84 */
    { 0x0c2f13, 0x0c2796, 0x246c6a97, 0xb5752df5, 0x9108c35d, 0x0 }, /* #85 */
    { 0x165c16, 0x165482, 0x1219edb2, 0xb636f90b, 0xa41d0b59, 0x0 }, /* #86 */
    { 0x046e92, 0x046e07, 0x845a9311, 0x4be25dc6, 0xc787cab5, 0x0 }, /* #87 */
    { 0x1d79d6, 0x1d7196, 0x3d5a33a5, 0xcdc2ded2, 0x9068ab2d, 0x0 }, /* #88 */
    { 0x3f0317, 0x3f0397, 0xd8c820db, 0xcbede759, 0xf325c67d, 0x0 }, /* #89 */
    { 0x0511c7, 0x051187, 0xea8e8f22, 0xa9231cfa, 0xbe948dd7, 0x0 }, /* #90 */
    { 0x1d3a57, 0x1d3293, 0x9ecc81e3, 0x95bff2e0, 0xf6f370fc, 0x0 }, /* #91 */
    { 0x093b97, 0x093397, 0xc370b09c, 0xa32b6cc6, 0xdfbabc29, 0x0 }, /* #92 */
    { 0x343057, 0x343092, 0xacf4e2cb, 0xb20f64e9, 0x051a821d, 0x0 }, /* #93 */
    { 0x191893, 0x191882, 0x683912a3, 0xba37f01c, 0x51fedd78, 0x0 }, /* #94 */
    { 0x0f2d02, 0x0f2503, 0xd3590be1, 0x3b3a76f4, 0x67e16b13, 0x0 }, /* #95 */
};
uint32_t const g_cTests_adc_u32 = RT_ELEMENTS(g_aTests_adc_u32);

BINU32_TEST_T const g_aTests_adc_u32_locked[] =
{
    { 0x040f93, 0x040702, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #0 */
    { 0x291957, 0x291102, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #1 */
    { 0x0a4106, 0x0a4146, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #2 */
    { 0x2c4902, 0x2c4146, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #3 */
    { 0x130b57, 0x130302, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #4 */
    { 0x3d4746, 0x3d4746, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x153517, 0x153586, 0xb7c1074c, 0xb7c1074d, 0x00000000, 0x0 }, /* #6 */
    { 0x1c6592, 0x1c6586, 0xc0d8b1c6, 0xc0d8b1c6, 0x00000000, 0x0 }, /* #7 */
    { 0x147b52, 0x147302, 0x06c31275, 0x06c31275, 0x00000000, 0x0 }, /* #8 */
    { 0x2b4297, 0x2b4202, 0x1bab3dde, 0x1bab3ddf, 0x00000000, 0x0 }, /* #9 */
    { 0x1a5356, 0x1a5386, 0x9f88072e, 0x9f88072e, 0x00000000, 0x0 }, /* #10 */
    { 0x331513, 0x331582, 0xacf1f66d, 0xacf1f66e, 0x00000000, 0x0 }, /* #11 */
    { 0x121357, 0x121397, 0x88226add, 0x86842699, 0xfe61bbbb, 0x0 }, /* #12 */
    { 0x3e4516, 0x3e4596, 0xfa15de2a, 0xfe43a9b7, 0x042dcb8d, 0x0 }, /* #13 */
    { 0x004293, 0x004a96, 0x55ba866c, 0x92bf3474, 0x3d04ae07, 0x0 }, /* #14 */
    { 0x0a6c82, 0x0a6496, 0x155bf80f, 0xd66c9a48, 0xc110a239, 0x0 }, /* #15 */
    { 0x074d06, 0x074d07, 0xd0806fc2, 0x75aca335, 0xa52c3373, 0x0 }, /* #16 */
    { 0x035b97, 0x035396, 0x1423685e, 0xea6fada0, 0xd64c4541, 0x0 }, /* #17 */
    { 0x344a47, 0x344a03, 0xc03deb00, 0x48b712e9, 0x887927e8, 0x0 }, /* #18 */
    { 0x1c5c57, 0x1c5487, 0xfb38f330, 0x88bbbeed, 0x8d82cbbc, 0x0 }, /* #19 */
    { 0x082b13, 0x082317, 0x21b18345, 0x08d02b33, 0xe71ea7ed, 0x0 }, /* #20 */
    { 0x3953c6, 0x395396, 0x29e1fa89, 0xe646b681, 0xbc64bbf8, 0x0 }, /* #21 */
    { 0x1d1516, 0x1d1d03, 0x9382a6f1, 0x46f1cbce, 0xb36f24dd, 0x0 }, /* #22 */
    { 0x0a63c3, 0x0a6396, 0x850b13e8, 0xa85d43d8, 0x23522fef, 0x0 }, /* #23 */
    { 0x375747, 0x375792, 0x95204d98, 0x9ac1a462, 0x05a156c9, 0x0 }, /* #24 */
    { 0x272387, 0x272312, 0x423b513e, 0x50a07686, 0x0e652547, 0x0 }, /* #25 */
    { 0x027e87, 0x027613, 0x493bca99, 0x45be0c67, 0xfc8241cd, 0x0 }, /* #26 */
    { 0x232b97, 0x232316, 0x2268e8fa, 0x37b7a328, 0x154eba2d, 0x0 }, /* #27 */
    { 0x2a5c93, 0x2a5c03, 0xc1abcd39, 0x722a616b, 0xb07e9431, 0x0 }, /* #28 */
    { 0x297243, 0x297a17, 0x8087660d, 0x09c78999, 0x8940238b, 0x0 }, /* #29 */
    { 0x0e1cc6, 0x0e1c17, 0xb04e009c, 0x71cb26e8, 0xc17d264c, 0x0 }, /* #30 */
    { 0x283956, 0x283907, 0xa892002f, 0x4004120f, 0x977211e0, 0x0 }, /* #31 */
    { 0x374553, 0x374503, 0x7f41f6c5, 0x5dd76058, 0xde956992, 0x0 }, /* #32 */
    { 0x3409c6, 0x340186, 0x716a49d8, 0xf5a6aacf, 0x843c60f7, 0x0 }, /* #33 */
    { 0x257887, 0x257086, 0x3d568811, 0xc501f1ac, 0x87ab699a, 0x0 }, /* #34 */
    { 0x1c6853, 0x1c6017, 0xeb43ea06, 0x465b8e53, 0x5b17a44c, 0x0 }, /* #35 */
    { 0x223812, 0x223083, 0xdd267e3a, 0xdb7b19ab, 0xfe549b71, 0x0 }, /* #36 */
    { 0x176112, 0x176996, 0x6c8a751b, 0xb2a4e971, 0x461a7456, 0x0 }, /* #37 */
    { 0x300e97, 0x300602, 0x2a681421, 0x65a867f2, 0x3b4053d0, 0x0 }, /* #38 */
    { 0x256a42, 0x256292, 0xd066859e, 0xd440ee4a, 0x03da68ac, 0x0 }, /* #39 */
    { 0x2e6006, 0x2e6003, 0x7e196f57, 0x70823fdc, 0xf268d085, 0x0 }, /* #40 */
    { 0x375186, 0x375186, 0x9953e490, 0xef516930, 0x55fd84a0, 0x0 }, /* #41 */
    { 0x0d7347, 0x0d7397, 0xf114291d, 0xc33205c9, 0xd21ddcab, 0x0 }, /* #42 */
    { 0x074d86, 0x074506, 0x35c1ba7a, 0x53477d6f, 0x1d85c2f5, 0x0 }, /* #43 */
    { 0x282a86, 0x282a82, 0x3ba6852b, 0x9a3dd1cd, 0x5e974ca2, 0x0 }, /* #44 */
    { 0x193a03, 0x193213, 0x582f954c, 0x2d17e61a, 0xd4e850cd, 0x0 }, /* #45 */
    { 0x0607d7, 0x060707, 0x37048e57, 0x2d60b718, 0xf65c28c0, 0x0 }, /* #46 */
    { 0x2371c3, 0x237992, 0x51219c7b, 0x9766c210, 0x46452594, 0x0 }, /* #47 */
    { 0x316897, 0x316813, 0x8ffc100a, 0x6fc48e7a, 0xdfc87e6f, 0x0 }, /* #48 */
    { 0x0845c7, 0x084512, 0x3cd7ba9d, 0x74ba7fcb, 0x37e2c52d, 0x0 }, /* #49 */
    { 0x2b4657, 0x2b4e03, 0x86d5a7d0, 0x769b78fb, 0xefc5d12a, 0x0 }, /* #50 */
    { 0x042512, 0x042d82, 0x56818ff8, 0x9fbaf77f, 0x49396787, 0x0 }, /* #51 */
    { 0x183a87, 0x183293, 0xf05cc816, 0x8f5a1d86, 0x9efd556f, 0x0 }, /* #52 */
    { 0x304303, 0x304b82, 0x407fefe0, 0x8ad74afe, 0x4a575b1d, 0x0 }, /* #53 */
    { 0x0f3857, 0x0f3092, 0x8a52cd0e, 0xf62e8a07, 0x6bdbbcf8, 0x0 }, /* #54 */
    { 0x3b1893, 0x3b1093, 0x94b0ceeb, 0x89cb67a1, 0xf51a98b5, 0x0 }, /* #55 */
    { 0x212296, 0x212283, 0xbf9f2da9, 0xbef9859b, 0xff5a57f2, 0x0 }, /* #56 */
    { 0x252707, 0x252782, 0x39b5aa71, 0xcb13703d, 0x915dc5cb, 0x0 }, /* #57 */
    { 0x197d92, 0x197583, 0xcb27e393, 0xa6e72649, 0xdbbf42b6, 0x0 }, /* #58 */
    { 0x2534d2, 0x253412, 0x163beafa, 0x66f96270, 0x50bd7776, 0x0 }, /* #59 */
    { 0x102b42, 0x102317, 0x631248fc, 0x4c5ed5c6, 0xe94c8cca, 0x0 }, /* #60 */
    { 0x040242, 0x040282, 0xb3a4c8f0, 0xbdf8f351, 0x0a542a61, 0x0 }, /* #61 */
    { 0x1105c3, 0x110d17, 0xa169f3fb, 0x4db9264b, 0xac4f324f, 0x0 }, /* #62 */
    { 0x1f3403, 0x1f3407, 0x218aa513, 0x0eeaab28, 0xed600614, 0x0 }, /* #63 */
    { 0x0b2682, 0x0b2e07, 0x88513388, 0x2d571509, 0xa505e181, 0x0 }, /* #64 */
    { 0x031f02, 0x031787, 0xc4229c3a, 0x8bf391dd, 0xc7d0f5a3, 0x0 }, /* #65 */
    { 0x0c3b53, 0x0c3b13, 0xb014e855, 0x66fc2280, 0xb6e73a2a, 0x0 }, /* #66 */
    { 0x230f47, 0x230782, 0x367a55c6, 0xdfdf1f3b, 0xa964c974, 0x0 }, /* #67 */
    { 0x2e4f42, 0x2e4f96, 0x3d45ba6a, 0x97e2d156, 0x5a9d16ec, 0x0 }, /* #68 */
    { 0x321116, 0x321186, 0xadd50563, 0xb3e335f9, 0x060e3096, 0x0 }, /* #69 */
    { 0x3b0416, 0x3b0c86, 0x68fdaec5, 0x8d2a11f5, 0x242c6330, 0x0 }, /* #70 */
    { 0x3036c6, 0x303e17, 0xb8bfceec, 0x76978b95, 0xbdd7bca9, 0x0 }, /* #71 */
    { 0x116c46, 0x116c96, 0x768cfd82, 0xe99c5e30, 0x730f60ae, 0x0 }, /* #72 */
    { 0x093a57, 0x093282, 0x90c1f737, 0xcba546ae, 0x3ae34f76, 0x0 }, /* #73 */
    { 0x222986, 0x222903, 0xcb2109c0, 0x72ce660e, 0xa7ad5c4e, 0x0 }, /* #74 */
    { 0x0c3ed3, 0x0c3e07, 0x8fdcb544, 0x1db3ff9f, 0x8dd74a5a, 0x0 }, /* #75 */
    { 0x395a82, 0x395212, 0x4c83d2b7, 0x7cb08034, 0x302cad7d, 0x0 }, /* #76 */
    { 0x0d1517, 0x0d1507, 0xb2aa7f61, 0x0b869aeb, 0x58dc1b89, 0x0 }, /* #77 */
    { 0x2731d6, 0x273186, 0x4799ddf3, 0xd51a1a5a, 0x8d803c67, 0x0 }, /* #78 */
    { 0x3f2002, 0x3f2097, 0x9a2dbb5c, 0x95c0dc78, 0xfb93211c, 0x0 }, /* #79 */
    { 0x160982, 0x160196, 0x6cabe154, 0xf80486f0, 0x8b58a59c, 0x0 }, /* #80 */
    { 0x297686, 0x297696, 0xb3ff868e, 0xb6681cac, 0x0268961e, 0x0 }, /* #81 */
    { 0x0d2406, 0x0d2486, 0x3bbc9594, 0xf7d3d948, 0xbc1743b4, 0x0 }, /* #82 */
    { 0x0d3fd6, 0x0d3706, 0x347b44b4, 0x4223213a, 0x0da7dc86, 0x0 }, /* #83 */
    { 0x073a42, 0x073286, 0x6b6d94f1, 0xfbe37e72, 0x9075e981, 0x0 }, /* #84 */
    { 0x143a96, 0x143a17, 0xc6d7c1f5, 0x78200090, 0xb1483e9b, 0x0 }, /* #85 */
    { 0x0224d3, 0x022483, 0xd1e24182, 0x8898642f, 0xb6b622ac, 0x0 }, /* #86 */
    { 0x1f12d3, 0x1f1282, 0xc8209460, 0xdb67c892, 0x13473431, 0x0 }, /* #87 */
    { 0x1e1302, 0x1e1396, 0xd1a49957, 0xf78c6371, 0x25e7ca1a, 0x0 }, /* #88 */
    { 0x2f2fc6, 0x2f2706, 0x0adfd2f3, 0x29ebc89c, 0x1f0bf5a9, 0x0 }, /* #89 */
    { 0x077383, 0x077396, 0xb1e7ecca, 0xb95be912, 0x0773fc47, 0x0 }, /* #90 */
    { 0x3d4692, 0x3d4e92, 0x254820c3, 0x9bf59ec2, 0x76ad7dff, 0x0 }, /* #91 */
    { 0x0b5b82, 0x0b5387, 0xfa133531, 0xee06aca9, 0xf3f37778, 0x0 }, /* #92 */
    { 0x335407, 0x335413, 0x73be8005, 0x139789a1, 0x9fd9099b, 0x0 }, /* #93 */
    { 0x352286, 0x352203, 0x59f8c7fb, 0x43151a0b, 0xe91c5210, 0x0 }, /* #94 */
    { 0x161117, 0x161192, 0x2d4be959, 0xeddaa894, 0xc08ebf3a, 0x0 }, /* #95 */
};
uint32_t const g_cTests_adc_u32_locked = RT_ELEMENTS(g_aTests_adc_u32_locked);

BINU32_TEST_T const g_aTests_sub_u32[] =
{
    { 0x145cd2, 0x145446, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #0 */
    { 0x1e3796, 0x1e3746, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x110917, 0x110146, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #2 */
    { 0x2f40c7, 0x2f4046, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #3 */
    { 0x2c3103, 0x2c3146, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #4 */
    { 0x3a3f17, 0x3a3746, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x061b42, 0x061386, 0xe6617827, 0xe6617827, 0x00000000, 0x0 }, /* #6 */
    { 0x1028d7, 0x102002, 0x7c4393ef, 0x7c4393ef, 0x00000000, 0x0 }, /* #7 */
    { 0x096d87, 0x096506, 0x4357c263, 0x4357c263, 0x00000000, 0x0 }, /* #8 */
    { 0x110942, 0x110102, 0x185ae02a, 0x185ae02a, 0x00000000, 0x0 }, /* #9 */
    { 0x3b4386, 0x3b4306, 0x266f12bb, 0x266f12bb, 0x00000000, 0x0 }, /* #10 */
    { 0x073157, 0x073102, 0x29f4b32f, 0x29f4b32f, 0x00000000, 0x0 }, /* #11 */
    { 0x2b1d06, 0x2b1586, 0xaf243e5f, 0x9654fff3, 0x18cf3e6c, 0x0 }, /* #12 */
    { 0x105cd3, 0x105406, 0xe8689e58, 0x4d11d1c3, 0x9b56cc95, 0x0 }, /* #13 */
    { 0x2255d6, 0x225593, 0x369a8d17, 0xbe3de0c8, 0x785cac4f, 0x0 }, /* #14 */
    { 0x0123d6, 0x012b93, 0x7e1cd3d0, 0x8690cd1a, 0xf78c06b6, 0x0 }, /* #15 */
    { 0x145e42, 0x145687, 0x1c42fe8d, 0xe3196fbb, 0x39298ed2, 0x0 }, /* #16 */
    { 0x3d4642, 0x3d4e87, 0x4797bc9d, 0xa4ad2a3c, 0xa2ea9261, 0x0 }, /* #17 */
    { 0x322147, 0x322983, 0x2d469c0b, 0x90079c61, 0x9d3effaa, 0x0 }, /* #18 */
    { 0x1b5587, 0x1b5506, 0x64de0a27, 0x37a1be30, 0x2d3c4bf7, 0x0 }, /* #19 */
    { 0x1e2c92, 0x1e2416, 0xd633acf0, 0x20b1cc7e, 0xb581e072, 0x0 }, /* #20 */
    { 0x0e2212, 0x0e2a16, 0xb3820237, 0x66a5717d, 0x4cdc90ba, 0x0 }, /* #21 */
    { 0x2534d7, 0x253416, 0x264986a2, 0x1c53ac5a, 0x09f5da48, 0x0 }, /* #22 */
    { 0x0b78d7, 0x0b7097, 0xb5d20353, 0xbad51fde, 0xfafce375, 0x0 }, /* #23 */
    { 0x2f5346, 0x2f5313, 0x19656c85, 0x5ccdbbc7, 0xbc97b0be, 0x0 }, /* #24 */
    { 0x343a02, 0x343293, 0x5b4ac813, 0xf4ecfb67, 0x665dccac, 0x0 }, /* #25 */
    { 0x1b3283, 0x1b3203, 0x425cb586, 0x475c4c43, 0xfb006943, 0x0 }, /* #26 */
    { 0x2152d6, 0x215a16, 0x8e15f880, 0x1f24e181, 0x6ef116ff, 0x0 }, /* #27 */
    { 0x3a7652, 0x3a7683, 0x19558dcf, 0xe3eec28a, 0x3566cb45, 0x0 }, /* #28 */
    { 0x391a43, 0x391212, 0x56b537d1, 0x2d8068cb, 0x2934cf06, 0x0 }, /* #29 */
    { 0x3d7ed3, 0x3d7613, 0x0cc90c41, 0x33980886, 0xd93103bb, 0x0 }, /* #30 */
    { 0x2f1f93, 0x2f1702, 0xe79ca7dd, 0x2cd8b05d, 0xbac3f780, 0x0 }, /* #31 */
    { 0x2c0d06, 0x2c0d97, 0x74632b70, 0xcff6bfb1, 0xa46c6bbf, 0x0 }, /* #32 */
    { 0x287a87, 0x287207, 0x4817a32d, 0x581173e4, 0xf0062f49, 0x0 }, /* #33 */
    { 0x1b5b83, 0x1b5316, 0xeb998915, 0x2940cf2b, 0xc258b9ea, 0x0 }, /* #34 */
    { 0x391d46, 0x391516, 0xe29071e8, 0x61c92969, 0x80c7487f, 0x0 }, /* #35 */
    { 0x3c1a02, 0x3c1216, 0x60fb5681, 0x204536c9, 0x40b61fb8, 0x0 }, /* #36 */
    { 0x0432c2, 0x043292, 0xf4864901, 0xecf1afce, 0x07949933, 0x0 }, /* #37 */
    { 0x200dd2, 0x200506, 0xc46b5ca2, 0x257cacc0, 0x9eeeafe2, 0x0 }, /* #38 */
    { 0x0b3952, 0x0b3183, 0x144e5e4d, 0xa49d59fd, 0x6fb10450, 0x0 }, /* #39 */
    { 0x3c3586, 0x3c3587, 0x802098bf, 0xcee28414, 0xb13e14ab, 0x0 }, /* #40 */
    { 0x3a2807, 0x3a2897, 0x5df0f244, 0xb56e8495, 0xa8826daf, 0x0 }, /* #41 */
    { 0x0171d3, 0x017117, 0x202f94d2, 0x42a67e06, 0xdd8916cc, 0x0 }, /* #42 */
    { 0x2115c2, 0x211d87, 0x68188cf3, 0x9a3181a0, 0xcde70b53, 0x0 }, /* #43 */
    { 0x3d0b03, 0x3d0b97, 0x430a6e48, 0x990552fa, 0xaa051b4e, 0x0 }, /* #44 */
    { 0x341e86, 0x341682, 0xb749277e, 0x870f0af4, 0x303a1c8a, 0x0 }, /* #45 */
    { 0x1c7b07, 0x1c7383, 0xb23729d7, 0xf04d3232, 0xc1e9f7a5, 0x0 }, /* #46 */
    { 0x111f03, 0x111796, 0xb0258ccb, 0xa619551d, 0x0a0c37ae, 0x0 }, /* #47 */
    { 0x295c52, 0x295c83, 0x352d1b5c, 0x8674397c, 0xaeb8e1e0, 0x0 }, /* #48 */
    { 0x384743, 0x384783, 0x81f48afc, 0xe496f598, 0x9d5d9564, 0x0 }, /* #49 */
    { 0x0702d7, 0x070a87, 0x731f5566, 0xbbc6ad21, 0xb758a845, 0x0 }, /* #50 */
    { 0x0e0ed2, 0x0e0612, 0xe8e8f9b6, 0x114b3b6b, 0xd79dbe4b, 0x0 }, /* #51 */
    { 0x250603, 0x250e06, 0xab3aab0d, 0x4249f035, 0x68f0bad8, 0x0 }, /* #52 */
    { 0x084c12, 0x084c93, 0x7113d526, 0xa778d18c, 0xc99b039a, 0x0 }, /* #53 */
    { 0x3e2d57, 0x3e2597, 0x19200162, 0xdf56f6ca, 0x39c90a98, 0x0 }, /* #54 */
    { 0x2c5b96, 0x2c5b93, 0x3fa4dfd9, 0x85d4b52f, 0xb9d02aaa, 0x0 }, /* #55 */
    { 0x2b0607, 0x2b0606, 0x5192434e, 0x404d8893, 0x1144babb, 0x0 }, /* #56 */
    { 0x357713, 0x357783, 0x2bd3d858, 0xf6879a83, 0x354c3dd5, 0x0 }, /* #57 */
    { 0x2f0b16, 0x2f0387, 0x99abe566, 0xb6e14382, 0xe2caa1e4, 0x0 }, /* #58 */
    { 0x150996, 0x150116, 0x369b0ad6, 0x2b3ab62d, 0x0b6054a9, 0x0 }, /* #59 */
    { 0x184d83, 0x184517, 0x090ef148, 0x7f91382d, 0x897db91b, 0x0 }, /* #60 */
    { 0x172696, 0x172692, 0x936b8fd7, 0x84195bfd, 0x0f5233da, 0x0 }, /* #61 */
    { 0x110e07, 0x110612, 0x5de72fa1, 0x3a91065e, 0x23562943, 0x0 }, /* #62 */
    { 0x005e42, 0x005687, 0x933813b4, 0xbe17f5e4, 0xd5201dd0, 0x0 }, /* #63 */
    { 0x017f02, 0x017f02, 0xa1ce10ee, 0x6c654d8c, 0x3568c362, 0x0 }, /* #64 */
    { 0x0b2a47, 0x0b2292, 0xe908e496, 0xbd78712c, 0x2b90736a, 0x0 }, /* #65 */
    { 0x055146, 0x055113, 0x032a602c, 0x31e31fcd, 0xd147405f, 0x0 }, /* #66 */
    { 0x0f46d3, 0x0f4613, 0x46e768b4, 0x5acc1a08, 0xec1b4eac, 0x0 }, /* #67 */
    { 0x3171d7, 0x317197, 0x11d2ca0c, 0xe08587cf, 0x314d423d, 0x0 }, /* #68 */
    { 0x3f4416, 0x3f4c83, 0x448e254d, 0xb88c8fea, 0x8c019563, 0x0 }, /* #69 */
    { 0x0a7d52, 0x0a7507, 0x0ab03850, 0x3642ce30, 0xd46d6a20, 0x0 }, /* #70 */
    { 0x332fd7, 0x332793, 0xc5d38ebd, 0xc6148ece, 0xffbeffef, 0x0 }, /* #71 */
    { 0x3a40c7, 0x3a4082, 0xfca38d2b, 0xf790f385, 0x051299a6, 0x0 }, /* #72 */
    { 0x0f1d03, 0x0f1592, 0xb72a5b0b, 0xb40b48ec, 0x031f121f, 0x0 }, /* #73 */
    { 0x0330d7, 0x033092, 0xe4758c87, 0x828b398a, 0x61ea52fd, 0x0 }, /* #74 */
    { 0x067996, 0x067197, 0xf153392a, 0xf433d74d, 0xfd1f61dd, 0x0 }, /* #75 */
    { 0x0b2b92, 0x0b2387, 0x44e645af, 0xee139c3a, 0x56d2a975, 0x0 }, /* #76 */
    { 0x130ec2, 0x130e87, 0x536920f7, 0x872e5a11, 0xcc3ac6e6, 0x0 }, /* #77 */
    { 0x1b3456, 0x1b3497, 0x00e8f014, 0xb43619db, 0x4cb2d639, 0x0 }, /* #78 */
    { 0x023452, 0x023493, 0xc80db913, 0xf21bd657, 0xd5f1e2bc, 0x0 }, /* #79 */
    { 0x1c0813, 0x1c0083, 0x296c79ad, 0xbcae9857, 0x6cbde156, 0x0 }, /* #80 */
    { 0x156c56, 0x156c12, 0xa376b125, 0x55f7fa0d, 0x4d7eb718, 0x0 }, /* #81 */
    { 0x377c93, 0x377493, 0x217e3559, 0xb3268a1c, 0x6e57ab3d, 0x0 }, /* #82 */
    { 0x3f1046, 0x3f1017, 0x50f4078a, 0x5ca14fbd, 0xf452b7cd, 0x0 }, /* #83 */
    { 0x0a4f52, 0x0a4782, 0xcbf8250b, 0xcae8b954, 0x010f6bb7, 0x0 }, /* #84 */
    { 0x300c16, 0x300c87, 0x53368d3b, 0xa33a5cf5, 0xaffc3046, 0x0 }, /* #85 */
    { 0x2e40c2, 0x2e4002, 0x614566b9, 0x58bed297, 0x08869422, 0x0 }, /* #86 */
    { 0x0d1203, 0x0d1292, 0xe0bc726a, 0x941be29b, 0x4ca08fcf, 0x0 }, /* #87 */
    { 0x241447, 0x241492, 0xd551faa9, 0x93ee301a, 0x4163ca8f, 0x0 }, /* #88 */
    { 0x071007, 0x071083, 0x32bee7ad, 0xc46bd734, 0x6e531079, 0x0 }, /* #89 */
    { 0x300b06, 0x300302, 0xd107232d, 0x14c4d3d6, 0xbc424f57, 0x0 }, /* #90 */
    { 0x2616c2, 0x261e87, 0x72f7f34a, 0xb61e98e2, 0xbcd95a68, 0x0 }, /* #91 */
    { 0x0e4587, 0x0e4d93, 0x63fe7965, 0x905200dc, 0xd3ac7889, 0x0 }, /* #92 */
    { 0x022e07, 0x022e87, 0x5c4f7c0d, 0xa471951d, 0xb7dde6f0, 0x0 }, /* #93 */
    { 0x2f5187, 0x2f5186, 0xfc2dd737, 0xd7e6a271, 0x244734c6, 0x0 }, /* #94 */
    { 0x025916, 0x025183, 0x444e7ccb, 0xe5e9e076, 0x5e649c55, 0x0 }, /* #95 */
};
uint32_t const g_cTests_sub_u32 = RT_ELEMENTS(g_aTests_sub_u32);

BINU32_TEST_T const g_aTests_sub_u32_locked[] =
{
    { 0x240256, 0x240246, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #0 */
    { 0x371202, 0x371246, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x033a93, 0x033246, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #2 */
    { 0x393296, 0x393246, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #3 */
    { 0x1a2ed3, 0x1a2646, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #4 */
    { 0x065587, 0x065546, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x2967d2, 0x296786, 0xc950fb11, 0xc950fb11, 0x00000000, 0x0 }, /* #6 */
    { 0x1f5847, 0x1f5002, 0x5fd7c58a, 0x5fd7c58a, 0x00000000, 0x0 }, /* #7 */
    { 0x1c5c87, 0x1c5402, 0x3e828716, 0x3e828716, 0x00000000, 0x0 }, /* #8 */
    { 0x1a6a93, 0x1a6286, 0xa53c94d1, 0xa53c94d1, 0x00000000, 0x0 }, /* #9 */
    { 0x271bc7, 0x271386, 0x98d30b50, 0x98d30b50, 0x00000000, 0x0 }, /* #10 */
    { 0x122106, 0x122102, 0x71185546, 0x71185546, 0x00000000, 0x0 }, /* #11 */
    { 0x397787, 0x397796, 0x99c99d20, 0x81154ebb, 0x18b44e65, 0x0 }, /* #12 */
    { 0x2d41d2, 0x2d4117, 0x187243cc, 0x1cd3fcaf, 0xfb9e471d, 0x0 }, /* #13 */
    { 0x271603, 0x271e87, 0x322d5e85, 0x91e9fd71, 0xa0436114, 0x0 }, /* #14 */
    { 0x3f7692, 0x3f7612, 0x5f3ae417, 0x0b1436d9, 0x5426ad3e, 0x0 }, /* #15 */
    { 0x100897, 0x100893, 0x7619718b, 0xac546bcd, 0xc9c505be, 0x0 }, /* #16 */
    { 0x3f4156, 0x3f4102, 0x79531015, 0x37718d34, 0x41e182e1, 0x0 }, /* #17 */
    { 0x1019d6, 0x101102, 0xd38c8c79, 0x3a676a08, 0x99252271, 0x0 }, /* #18 */
    { 0x1271d2, 0x127983, 0x7f7ebd39, 0x9284d1e5, 0xecf9eb54, 0x0 }, /* #19 */
    { 0x322fd7, 0x322702, 0xf9ebe653, 0x4dd5b710, 0xac162f43, 0x0 }, /* #20 */
    { 0x072dc2, 0x072506, 0x2671f63b, 0x135aee00, 0x1317083b, 0x0 }, /* #21 */
    { 0x2f3052, 0x2f3893, 0x355555e1, 0xb4a86c9b, 0x80ace946, 0x0 }, /* #22 */
    { 0x395513, 0x395512, 0xf3aeb3a1, 0x4855feef, 0xab58b4b2, 0x0 }, /* #23 */
    { 0x377686, 0x377612, 0x754e47f6, 0x4bddc72a, 0x297080cc, 0x0 }, /* #24 */
    { 0x327dc2, 0x327582, 0xeaf261f2, 0x93ca4662, 0x57281b90, 0x0 }, /* #25 */
    { 0x321a17, 0x321202, 0x5051befd, 0x3c4bbf70, 0x1405ff8d, 0x0 }, /* #26 */
    { 0x0a7787, 0x0a7706, 0x1889b12f, 0x0b43f717, 0x0d45ba18, 0x0 }, /* #27 */
    { 0x3165d2, 0x316587, 0x9c8519af, 0xebfa1eb7, 0xb08afaf8, 0x0 }, /* #28 */
    { 0x055f86, 0x055797, 0xcace0883, 0xdacaa5f9, 0xf003628a, 0x0 }, /* #29 */
    { 0x0f2617, 0x0f2e87, 0x4e41bc5e, 0xcd7da26a, 0x80c419f4, 0x0 }, /* #30 */
    { 0x0b66c2, 0x0b6682, 0xe0462e2f, 0xc756ae1a, 0x18ef8015, 0x0 }, /* #31 */
    { 0x305842, 0x305007, 0x096f2c69, 0x2ea42311, 0xdacb0958, 0x0 }, /* #32 */
    { 0x316e43, 0x316612, 0x53ab9a74, 0x200df645, 0x339da42f, 0x0 }, /* #33 */
    { 0x3e7b16, 0x3e7383, 0xd96de78f, 0xf293b846, 0xe6da2f49, 0x0 }, /* #34 */
    { 0x371786, 0x371713, 0x126b2430, 0x62d7b6f1, 0xaf936d3f, 0x0 }, /* #35 */
    { 0x205e12, 0x205e16, 0xb85d0695, 0x785a59de, 0x4002acb7, 0x0 }, /* #36 */
    { 0x1007c3, 0x100f87, 0x5f450e1c, 0xd2edc5a3, 0x8c574879, 0x0 }, /* #37 */
    { 0x083997, 0x083112, 0x58720bca, 0x4b4565dc, 0x0d2ca5ee, 0x0 }, /* #38 */
    { 0x1c3dc2, 0x1c3513, 0x01bd7191, 0x447edc64, 0xbd3e952d, 0x0 }, /* #39 */
    { 0x322242, 0x322287, 0xa598b8e3, 0xfc6068c0, 0xa9385023, 0x0 }, /* #40 */
    { 0x2f2652, 0x2f2606, 0xfdcb9965, 0x4027aa41, 0xbda3ef24, 0x0 }, /* #41 */
    { 0x181e93, 0x181606, 0x7cbac9ff, 0x6036f0a3, 0x1c83d95c, 0x0 }, /* #42 */
    { 0x101cd3, 0x101412, 0xae3565b0, 0x21a83858, 0x8c8d2d58, 0x0 }, /* #43 */
    { 0x2a7217, 0x2a7297, 0x1e769178, 0xe50950cf, 0x396d40a9, 0x0 }, /* #44 */
    { 0x164cd6, 0x164416, 0x71a583e5, 0x394a9ae7, 0x385ae8fe, 0x0 }, /* #45 */
    { 0x055b16, 0x055303, 0x42ec753e, 0x7f5b86ad, 0xc390ee91, 0x0 }, /* #46 */
    { 0x351193, 0x351112, 0x49671406, 0x37a737ad, 0x11bfdc59, 0x0 }, /* #47 */
    { 0x1e2a52, 0x1e2293, 0x3741ea18, 0xcc1c05ab, 0x6b25e46d, 0x0 }, /* #48 */
    { 0x097882, 0x097802, 0x82e54c8e, 0x0a1faa68, 0x78c5a226, 0x0 }, /* #49 */
    { 0x3564c2, 0x356c97, 0x563603d0, 0x8646ea17, 0xcfef19b9, 0x0 }, /* #50 */
    { 0x041843, 0x041006, 0xc78315f4, 0x066d56f0, 0xc115bf04, 0x0 }, /* #51 */
    { 0x020b57, 0x020302, 0xecc7086a, 0x5a094515, 0x92bdc355, 0x0 }, /* #52 */
    { 0x087a47, 0x087293, 0xbb66cc93, 0xcbf17ea7, 0xef754dec, 0x0 }, /* #53 */
    { 0x211a52, 0x211206, 0x1936172d, 0x17c48b3c, 0x01718bf1, 0x0 }, /* #54 */
    { 0x383913, 0x383183, 0xe9021116, 0xe9877ad0, 0xff7a9646, 0x0 }, /* #55 */
    { 0x3046c2, 0x304687, 0x2e8425a7, 0xdd6a49e7, 0x5119dbc0, 0x0 }, /* #56 */
    { 0x3e6452, 0x3e6493, 0x92bcf1b0, 0xaea6abc7, 0xe41645e9, 0x0 }, /* #57 */
    { 0x0a1d17, 0x0a1502, 0xf8046202, 0x60d93be0, 0x972b2622, 0x0 }, /* #58 */
    { 0x292d43, 0x292d12, 0x8f62ec12, 0x4891e258, 0x46d109ba, 0x0 }, /* #59 */
    { 0x081013, 0x081812, 0x81342213, 0x1d1856a8, 0x641bcb6b, 0x0 }, /* #60 */
    { 0x3e5497, 0x3e5407, 0x1f41b5de, 0x2d4e06f0, 0xf1f3aeee, 0x0 }, /* #61 */
    { 0x285ac7, 0x285217, 0x0df08e54, 0x76ccee1b, 0x9723a039, 0x0 }, /* #62 */
    { 0x2b4893, 0x2b4086, 0xefa1c6cc, 0xdc4219a0, 0x135fad2c, 0x0 }, /* #63 */
    { 0x0a28d2, 0x0a2097, 0xb7331458, 0xcde0255c, 0xe952eefc, 0x0 }, /* #64 */
    { 0x0d4787, 0x0d4716, 0x56f2c310, 0x562fb0d8, 0x00c31238, 0x0 }, /* #65 */
    { 0x010d42, 0x010587, 0xa2b4c7c9, 0xa690ba44, 0xfc240d85, 0x0 }, /* #66 */
    { 0x174386, 0x174307, 0x2d6b06ee, 0x63d53d99, 0xc995c955, 0x0 }, /* #67 */
    { 0x220cc3, 0x220487, 0x636db5a9, 0xfb989c95, 0x67d51914, 0x0 }, /* #68 */
    { 0x233313, 0x233387, 0x3b2ea813, 0xf7799921, 0x43b50ef2, 0x0 }, /* #69 */
    { 0x0c5f16, 0x0c5712, 0x7d6fac79, 0x4778221c, 0x35f78a5d, 0x0 }, /* #70 */
    { 0x0e4dc6, 0x0e4596, 0xcc592704, 0x9ff60e27, 0x2c6318dd, 0x0 }, /* #71 */
    { 0x085046, 0x085097, 0x56c2e673, 0xf14b4ede, 0x65779795, 0x0 }, /* #72 */
    { 0x2e5352, 0x2e5302, 0xd3cbdb61, 0x0e8b0de0, 0xc540cd81, 0x0 }, /* #73 */
    { 0x144982, 0x144116, 0x728fa754, 0x6c810b4d, 0x060e9c07, 0x0 }, /* #74 */
    { 0x037192, 0x037183, 0x9a756a4f, 0xf120ec5d, 0xa9547df2, 0x0 }, /* #75 */
    { 0x1c6d42, 0x1c6597, 0xc2b62f0a, 0xe36039de, 0xdf55f52c, 0x0 }, /* #76 */
    { 0x0d3942, 0x0d3192, 0xe445685a, 0xb8960f0d, 0x2baf594d, 0x0 }, /* #77 */
    { 0x1519c2, 0x151183, 0x05c4a19d, 0xfde4bdc4, 0x07dfe3d9, 0x0 }, /* #78 */
    { 0x2a4f47, 0x2a4797, 0x461abec8, 0xcac3759c, 0x7b57492c, 0x0 }, /* #79 */
    { 0x2d1207, 0x2d1a16, 0x90b9b349, 0x6f2a389a, 0x218f7aaf, 0x0 }, /* #80 */
    { 0x045082, 0x045812, 0x85b0a935, 0x5537899b, 0x30791f9a, 0x0 }, /* #81 */
    { 0x214382, 0x214382, 0xd0b6e46c, 0x913d5fcb, 0x3f7984a1, 0x0 }, /* #82 */
    { 0x1b5592, 0x1b5583, 0x35b09a60, 0xbf767ce0, 0x763a1d80, 0x0 }, /* #83 */
    { 0x0e0253, 0x0e0292, 0xc3f701f6, 0xa6b8818c, 0x1d3e806a, 0x0 }, /* #84 */
    { 0x0d4887, 0x0d4816, 0x94512ad1, 0x4e3c7ec5, 0x4614ac0c, 0x0 }, /* #85 */
    { 0x132203, 0x132292, 0xea6638a7, 0x9ce9f20d, 0x4d7c469a, 0x0 }, /* #86 */
    { 0x215692, 0x215602, 0x5b59047f, 0x5597631f, 0x05c1a160, 0x0 }, /* #87 */
    { 0x1963c7, 0x196b83, 0x4f23b23d, 0xa12f08b6, 0xadf4a987, 0x0 }, /* #88 */
    { 0x2d4fd6, 0x2d4787, 0x6f61bccf, 0xf6452a36, 0x791c9299, 0x0 }, /* #89 */
    { 0x191392, 0x191386, 0x8d00469f, 0x81df7a93, 0x0b20cc0c, 0x0 }, /* #90 */
    { 0x223ad7, 0x223a87, 0x12a0e30e, 0x8d20b733, 0x85802bdb, 0x0 }, /* #91 */
    { 0x096983, 0x096183, 0x17f4e298, 0xfe782598, 0x197cbd00, 0x0 }, /* #92 */
    { 0x022a56, 0x022206, 0xff0db4db, 0x4ab189d8, 0xb45c2b03, 0x0 }, /* #93 */
    { 0x3e7792, 0x3e7f97, 0x60e49bb6, 0xb22fa387, 0xaeb4f82f, 0x0 }, /* #94 */
    { 0x010c02, 0x010483, 0x06c98d2b, 0xdaa06c75, 0x2c2920b6, 0x0 }, /* #95 */
};
uint32_t const g_cTests_sub_u32_locked = RT_ELEMENTS(g_aTests_sub_u32_locked);

BINU32_TEST_T const g_aTests_sbb_u32[] =
{
    { 0x024b43, 0x024397, 0x00000000, 0xffffffff, 0x00000000, 0x0 }, /* #0 */
    { 0x2c4006, 0x2c4046, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x1e3982, 0x1e3146, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #2 */
    { 0x300fd3, 0x300797, 0x00000000, 0xffffffff, 0x00000000, 0x0 }, /* #3 */
    { 0x014312, 0x014346, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #4 */
    { 0x013c12, 0x013446, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x395f92, 0x395706, 0x4a78a65f, 0x4a78a65f, 0x00000000, 0x0 }, /* #6 */
    { 0x163a56, 0x163286, 0x81c1ec2b, 0x81c1ec2b, 0x00000000, 0x0 }, /* #7 */
    { 0x3840c3, 0x384086, 0x8f615648, 0x8f615647, 0x00000000, 0x0 }, /* #8 */
    { 0x0e6a47, 0x0e6202, 0x56a81f62, 0x56a81f61, 0x00000000, 0x0 }, /* #9 */
    { 0x3c6083, 0x3c6092, 0xc574c980, 0xc574c97f, 0x00000000, 0x0 }, /* #10 */
    { 0x195882, 0x195086, 0x96360b22, 0x96360b22, 0x00000000, 0x0 }, /* #11 */
    { 0x331d87, 0x331507, 0x2e77e06d, 0x3a2f08aa, 0xf448d7c2, 0x0 }, /* #12 */
    { 0x002843, 0x002883, 0x1448c718, 0x8e64f591, 0x85e3d186, 0x0 }, /* #13 */
    { 0x297517, 0x297587, 0x71b020f7, 0xf4ff18a3, 0x7cb10853, 0x0 }, /* #14 */
    { 0x187e12, 0x187e06, 0xa899fd8d, 0x65a022ed, 0x42f9daa0, 0x0 }, /* #15 */
    { 0x3f2d97, 0x3f2d06, 0xb42ddd28, 0x65d2af56, 0x4e5b2dd1, 0x0 }, /* #16 */
    { 0x2a1b07, 0x2a1383, 0xa6a5a173, 0xb21d5762, 0xf4884a10, 0x0 }, /* #17 */
    { 0x2117d7, 0x211796, 0xf8d9b606, 0xf03df7eb, 0x089bbe1a, 0x0 }, /* #18 */
    { 0x390817, 0x390093, 0x25931cf1, 0xe30b8298, 0x42879a58, 0x0 }, /* #19 */
    { 0x192dc6, 0x192513, 0x5ede7787, 0x64eb290b, 0xf9f34e7c, 0x0 }, /* #20 */
    { 0x294d87, 0x294586, 0xe27231a7, 0x8a3c9c84, 0x58359522, 0x0 }, /* #21 */
    { 0x3b4703, 0x3b4787, 0xb6b0a022, 0xf23c8f41, 0xc47410e0, 0x0 }, /* #22 */
    { 0x154146, 0x154117, 0x10cf17d2, 0x235a427d, 0xed74d555, 0x0 }, /* #23 */
    { 0x0533d3, 0x053306, 0xd709d31f, 0x2c5973f3, 0xaab05f2b, 0x0 }, /* #24 */
    { 0x3c1a06, 0x3c1216, 0xe3b37ef6, 0x03e2356f, 0xdfd14987, 0x0 }, /* #25 */
    { 0x1d0a97, 0x1d0297, 0x8051dc58, 0x8660ba7d, 0xf9f121da, 0x0 }, /* #26 */
    { 0x265086, 0x265806, 0xc10ac6ff, 0x5e5c5d11, 0x62ae69ee, 0x0 }, /* #27 */
    { 0x3a68c7, 0x3a6006, 0x65231daf, 0x28df168e, 0x3c440720, 0x0 }, /* #28 */
    { 0x3d4e02, 0x3d4693, 0x10349319, 0xdadf5a8c, 0x3555388d, 0x0 }, /* #29 */
    { 0x291dc2, 0x291593, 0xab034787, 0xe53efb68, 0xc5c44c1f, 0x0 }, /* #30 */
    { 0x0c3a16, 0x0c3283, 0x5383ddbc, 0xdf59d1b0, 0x742a0c0c, 0x0 }, /* #31 */
    { 0x051946, 0x051987, 0x475bc7bd, 0xbd5e3865, 0x89fd8f58, 0x0 }, /* #32 */
    { 0x290413, 0x290413, 0x23eebe85, 0x39cdd146, 0xea20ed3e, 0x0 }, /* #33 */
    { 0x285656, 0x285696, 0xbfcb0bb2, 0xb3235cd4, 0x0ca7aede, 0x0 }, /* #34 */
    { 0x0b48c6, 0x0b4007, 0x453f1edd, 0x5774ad00, 0xedca71dd, 0x0 }, /* #35 */
    { 0x017607, 0x017602, 0x59b4c03a, 0x344dfe31, 0x2566c208, 0x0 }, /* #36 */
    { 0x071652, 0x071613, 0x0193bd91, 0x48d64cba, 0xb8bd70d7, 0x0 }, /* #37 */
    { 0x330447, 0x330c12, 0xbddb2913, 0x76c33676, 0x4717f29c, 0x0 }, /* #38 */
    { 0x1c6a16, 0x1c6207, 0x21e14a9e, 0x3b096d93, 0xe6d7dd0b, 0x0 }, /* #39 */
    { 0x3d7052, 0x3d7097, 0x10d7c830, 0xf4e856e8, 0x1bef7148, 0x0 }, /* #40 */
    { 0x0213d7, 0x021397, 0x03c087e0, 0xa1987dc9, 0x62280a16, 0x0 }, /* #41 */
    { 0x077493, 0x077496, 0xd8c51cc8, 0x9392d669, 0x4532465e, 0x0 }, /* #42 */
    { 0x133d92, 0x133517, 0x28ff4935, 0x305a44cf, 0xf8a50466, 0x0 }, /* #43 */
    { 0x384f12, 0x384797, 0x1be4f9e9, 0xce5c609a, 0x4d88994f, 0x0 }, /* #44 */
    { 0x1f5243, 0x1f5a06, 0x87142755, 0x587d23c0, 0x2e970394, 0x0 }, /* #45 */
    { 0x1e5286, 0x1e5212, 0x5809b929, 0x13704cce, 0x44996c5b, 0x0 }, /* #46 */
    { 0x267c82, 0x267493, 0xaa31d085, 0xba2e57f7, 0xf003788e, 0x0 }, /* #47 */
    { 0x2d1686, 0x2d1e83, 0x657cda1c, 0xc6e99116, 0x9e934906, 0x0 }, /* #48 */
    { 0x361096, 0x361806, 0x92d310b6, 0x35d91953, 0x5cf9f763, 0x0 }, /* #49 */
    { 0x2c7896, 0x2c7087, 0xaae1cfaa, 0xe65b5a53, 0xc4867557, 0x0 }, /* #50 */
    { 0x0e5b13, 0x0e5316, 0x6da52d27, 0x2a11ce17, 0x43935f0f, 0x0 }, /* #51 */
    { 0x2864d3, 0x286c06, 0xed3af0dd, 0x70a75e74, 0x7c939268, 0x0 }, /* #52 */
    { 0x114796, 0x114f87, 0x2ba343c9, 0x84202827, 0xa7831ba2, 0x0 }, /* #53 */
    { 0x3377c2, 0x337707, 0x5db7a6a4, 0x6f923ce4, 0xee2569c0, 0x0 }, /* #54 */
    { 0x341507, 0x341503, 0x0b6219de, 0x3ea4e523, 0xccbd34ba, 0x0 }, /* #55 */
    { 0x235992, 0x235906, 0xd077e94c, 0x5da34042, 0x72d4a90a, 0x0 }, /* #56 */
    { 0x171492, 0x171c02, 0xbd2bc81a, 0x7188f986, 0x4ba2ce94, 0x0 }, /* #57 */
    { 0x026d07, 0x026d02, 0xdf2b8887, 0x7b22b731, 0x6408d155, 0x0 }, /* #58 */
    { 0x3c0196, 0x3c0183, 0x09d3236b, 0xb871d952, 0x51614a19, 0x0 }, /* #59 */
    { 0x1d2813, 0x1d2016, 0x17db44c4, 0x1103a29f, 0x06d7a224, 0x0 }, /* #60 */
    { 0x3b5d12, 0x3b5583, 0x29826103, 0xd4c224f2, 0x54c03c11, 0x0 }, /* #61 */
    { 0x3a4082, 0x3a4087, 0xace6ef25, 0xf0d6c8e2, 0xbc102643, 0x0 }, /* #62 */
    { 0x0e5686, 0x0e5682, 0xe76ee465, 0x981f0cb5, 0x4f4fd7b0, 0x0 }, /* #63 */
    { 0x280152, 0x280906, 0xa2a4670d, 0x2791ac17, 0x7b12baf6, 0x0 }, /* #64 */
    { 0x0e6fc7, 0x0e6787, 0x08f42d1f, 0xb517cef9, 0x53dc5e25, 0x0 }, /* #65 */
    { 0x1f5292, 0x1f5a93, 0x425f53a7, 0xaec407ba, 0x939b4bed, 0x0 }, /* #66 */
    { 0x163546, 0x163516, 0xbf086b06, 0x2cdd3f9a, 0x922b2b6c, 0x0 }, /* #67 */
    { 0x351257, 0x351a06, 0x981bc7f7, 0x5521cf41, 0x42f9f8b5, 0x0 }, /* #68 */
    { 0x1e1602, 0x1e1e02, 0x9e3cfbed, 0x29d2f6e5, 0x746a0508, 0x0 }, /* #69 */
    { 0x0a11d7, 0x0a1993, 0x3760aa62, 0x95ac235d, 0xa1b48704, 0x0 }, /* #70 */
    { 0x185852, 0x185812, 0x82be40a9, 0x269ae21f, 0x5c235e8a, 0x0 }, /* #71 */
    { 0x032393, 0x032b16, 0x934c95fc, 0x45a6e22d, 0x4da5b3ce, 0x0 }, /* #72 */
    { 0x0e0fd2, 0x0e0f83, 0x78c1f8bd, 0x965bb651, 0xe266426c, 0x0 }, /* #73 */
    { 0x0f5756, 0x0f5783, 0x92ee098b, 0xdbeb4f73, 0xb702ba18, 0x0 }, /* #74 */
    { 0x0567c3, 0x056783, 0xade29d4c, 0xc128390b, 0xecba6440, 0x0 }, /* #75 */
    { 0x356e56, 0x356602, 0xf13a9e77, 0x13b84745, 0xdd825732, 0x0 }, /* #76 */
    { 0x386446, 0x386483, 0x94d81d69, 0xde163580, 0xb6c1e7e9, 0x0 }, /* #77 */
    { 0x1f0b46, 0x1f0303, 0x038af0f7, 0x35ec2be3, 0xcd9ec514, 0x0 }, /* #78 */
    { 0x037b82, 0x037387, 0xaaacad49, 0xbdfd0635, 0xecafa714, 0x0 }, /* #79 */
    { 0x190ac6, 0x190287, 0x3fcfdefe, 0xe61d5c12, 0x59b282ec, 0x0 }, /* #80 */
    { 0x050f86, 0x050f87, 0x5389cbfe, 0xce06eaa5, 0x8582e159, 0x0 }, /* #81 */
    { 0x2e3213, 0x2e3202, 0x6095bcd3, 0x5f44bda2, 0x0150ff30, 0x0 }, /* #82 */
    { 0x1c2c97, 0x1c2416, 0xca732097, 0x382ef9bd, 0x924426d9, 0x0 }, /* #83 */
    { 0x371f02, 0x371783, 0x3e39d096, 0xf036c134, 0x4e030f62, 0x0 }, /* #84 */
    { 0x292913, 0x292182, 0xf1a56b36, 0xb2dd3a91, 0x3ec830a4, 0x0 }, /* #85 */
    { 0x2f6dc7, 0x2f6d83, 0x206a434d, 0x97b5cb20, 0x88b4782c, 0x0 }, /* #86 */
    { 0x0a1bd3, 0x0a1b83, 0x77a8470e, 0x9c8a35e5, 0xdb1e1128, 0x0 }, /* #87 */
    { 0x326553, 0x326597, 0xe24efe33, 0xf5b1df0a, 0xec9d1f28, 0x0 }, /* #88 */
    { 0x345e12, 0x345606, 0x5e8d378d, 0x0a46d959, 0x54465e34, 0x0 }, /* #89 */
    { 0x1a7d17, 0x1a7d93, 0x6b2baa03, 0xa62af0c7, 0xc500b93b, 0x0 }, /* #90 */
    { 0x344092, 0x344083, 0x8c0954c9, 0xd223f3f4, 0xb9e560d5, 0x0 }, /* #91 */
    { 0x350006, 0x350006, 0xae032555, 0x143f7011, 0x99c3b544, 0x0 }, /* #92 */
    { 0x1c02d6, 0x1c0203, 0x005a2c2e, 0x7795e7c7, 0x88c44467, 0x0 }, /* #93 */
    { 0x2651d6, 0x265112, 0xbda71055, 0x02d24b1f, 0xbad4c536, 0x0 }, /* #94 */
    { 0x3c1b42, 0x3c1382, 0xd036fd6b, 0xcd4b29b6, 0x02ebd3b5, 0x0 }, /* #95 */
};
uint32_t const g_cTests_sbb_u32 = RT_ELEMENTS(g_aTests_sbb_u32);

BINU32_TEST_T const g_aTests_sbb_u32_locked[] =
{
    { 0x1676c7, 0x167697, 0x00000000, 0xffffffff, 0x00000000, 0x0 }, /* #0 */
    { 0x0b6382, 0x0b6346, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x251d47, 0x251597, 0x00000000, 0xffffffff, 0x00000000, 0x0 }, /* #2 */
    { 0x354343, 0x354397, 0x00000000, 0xffffffff, 0x00000000, 0x0 }, /* #3 */
    { 0x0e7156, 0x0e7146, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #4 */
    { 0x036152, 0x036146, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x043c03, 0x043406, 0x5a61239b, 0x5a61239a, 0x00000000, 0x0 }, /* #6 */
    { 0x3e2b97, 0x3e2316, 0x7b4dbab0, 0x7b4dbaaf, 0x00000000, 0x0 }, /* #7 */
    { 0x1b0906, 0x1b0182, 0x9ce4725d, 0x9ce4725d, 0x00000000, 0x0 }, /* #8 */
    { 0x2e0a07, 0x2e0282, 0xeaddf176, 0xeaddf175, 0x00000000, 0x0 }, /* #9 */
    { 0x2c5d16, 0x2c5586, 0xc9224295, 0xc9224295, 0x00000000, 0x0 }, /* #10 */
    { 0x005817, 0x005006, 0x798c67cd, 0x798c67cc, 0x00000000, 0x0 }, /* #11 */
    { 0x103407, 0x103493, 0x268e8083, 0xe3193f8a, 0x437540f8, 0x0 }, /* #12 */
    { 0x076d02, 0x076503, 0x1c9e5138, 0x68b03902, 0xb3ee1836, 0x0 }, /* #13 */
    { 0x0e7d86, 0x0e7592, 0xcef1b535, 0xc48c3a67, 0x0a657ace, 0x0 }, /* #14 */
    { 0x1a5cd7, 0x1a5406, 0xb64ce54e, 0x139f4022, 0xa2ada52b, 0x0 }, /* #15 */
    { 0x023bd2, 0x023b06, 0x9a05ae09, 0x3cc126e8, 0x5d448721, 0x0 }, /* #16 */
    { 0x177ed2, 0x177e87, 0x5189c70f, 0xbcbfe8fa, 0x94c9de15, 0x0 }, /* #17 */
    { 0x016e56, 0x016606, 0xccea6458, 0x41289bc0, 0x8bc1c898, 0x0 }, /* #18 */
    { 0x252946, 0x252916, 0xc10de305, 0x76829be7, 0x4a8b471e, 0x0 }, /* #19 */
    { 0x234a93, 0x234296, 0xac28eb98, 0x8b4b528d, 0x20dd990a, 0x0 }, /* #20 */
    { 0x3417c6, 0x341717, 0x3d41bea1, 0x425dad9f, 0xfae41102, 0x0 }, /* #21 */
    { 0x125707, 0x125793, 0xc8757fd2, 0xdab23c46, 0xedc3438b, 0x0 }, /* #22 */
    { 0x1c2fc2, 0x1c2703, 0x18d3eb8e, 0x4e222c19, 0xcab1bf75, 0x0 }, /* #23 */
    { 0x295d46, 0x295507, 0x341bc896, 0x6706aab2, 0xcd151de4, 0x0 }, /* #24 */
    { 0x1f2c57, 0x1f2412, 0x7e6e1110, 0x6b067545, 0x13679bca, 0x0 }, /* #25 */
    { 0x150842, 0x150806, 0x816d540f, 0x3fe5458e, 0x41880e81, 0x0 }, /* #26 */
    { 0x0a1e16, 0x0a1687, 0xb56a1bfb, 0xe3638674, 0xd2069587, 0x0 }, /* #27 */
    { 0x232cd7, 0x232413, 0x00cb7503, 0x49072337, 0xb7c451cb, 0x0 }, /* #28 */
    { 0x134382, 0x134307, 0x2c44f19f, 0x3cc9911d, 0xef7b6082, 0x0 }, /* #29 */
    { 0x111f53, 0x111787, 0x165dcf4b, 0xd63c9788, 0x402137c2, 0x0 }, /* #30 */
    { 0x3230c6, 0x323003, 0x45e9fa7d, 0x6399ab5d, 0xe2504f20, 0x0 }, /* #31 */
    { 0x2b3397, 0x2b3393, 0xecf8e14b, 0xfc74bbab, 0xf084259f, 0x0 }, /* #32 */
    { 0x141b16, 0x141b12, 0x822a4e40, 0x67d1561a, 0x1a58f826, 0x0 }, /* #33 */
    { 0x255882, 0x255017, 0x32de6b60, 0x4ce6739c, 0xe5f7f7c4, 0x0 }, /* #34 */
    { 0x006103, 0x006997, 0x22744092, 0x89ca3122, 0x98aa0f6f, 0x0 }, /* #35 */
    { 0x133097, 0x133086, 0xcd055e68, 0xa18e0bf5, 0x2b775272, 0x0 }, /* #36 */
    { 0x142e97, 0x142616, 0x6cb059f0, 0x67f201a5, 0x04be584a, 0x0 }, /* #37 */
    { 0x2c7c42, 0x2c7c83, 0x4b21db7a, 0xc0145e62, 0x8b0d7d18, 0x0 }, /* #38 */
    { 0x355b03, 0x355383, 0x2edf262e, 0xfb40042c, 0x339f2201, 0x0 }, /* #39 */
    { 0x0b4712, 0x0b4f87, 0x3cb22836, 0x8856c324, 0xb45b6512, 0x0 }, /* #40 */
    { 0x1f1686, 0x1f1617, 0x0ffe3d64, 0x532b66e8, 0xbcd2d67c, 0x0 }, /* #41 */
    { 0x045bc7, 0x045396, 0xccd949f4, 0x98c35a28, 0x3415efcb, 0x0 }, /* #42 */
    { 0x011293, 0x011216, 0xb4505c25, 0x1506b706, 0x9f49a51e, 0x0 }, /* #43 */
    { 0x1e4852, 0x1e4093, 0x6bc9d4f2, 0xec3112fe, 0x7f98c1f4, 0x0 }, /* #44 */
    { 0x131a97, 0x131206, 0xe4fece9f, 0x284aba55, 0xbcb41449, 0x0 }, /* #45 */
    { 0x226d43, 0x226512, 0xc551ab85, 0x00482c7c, 0xc5097f08, 0x0 }, /* #46 */
    { 0x0825c2, 0x082597, 0x88ebc872, 0xe500eb8e, 0xa3eadce4, 0x0 }, /* #47 */
    { 0x206257, 0x206202, 0xec7c392e, 0x2ad80949, 0xc1a42fe4, 0x0 }, /* #48 */
    { 0x132c42, 0x132487, 0x91d4599b, 0xc7e5132b, 0xc9ef4670, 0x0 }, /* #49 */
    { 0x1f1d57, 0x1f1d02, 0xb5a7723f, 0x7cf2b59d, 0x38b4bca1, 0x0 }, /* #50 */
    { 0x165346, 0x165b02, 0xafbf3a3e, 0x3049d001, 0x7f756a3d, 0x0 }, /* #51 */
    { 0x161d87, 0x161d12, 0xa153f762, 0x2d75f386, 0x73de03db, 0x0 }, /* #52 */
    { 0x062046, 0x062816, 0xdef8d8b0, 0x66a37d06, 0x78555baa, 0x0 }, /* #53 */
    { 0x3b5197, 0x3b5987, 0x568b6bdf, 0x91b7a66c, 0xc4d3c572, 0x0 }, /* #54 */
    { 0x2758d6, 0x275016, 0x3ae2a4f6, 0x080b27cc, 0x32d77d2a, 0x0 }, /* #55 */
    { 0x257a82, 0x257217, 0x04c2c981, 0x20fd1e8b, 0xe3c5aaf6, 0x0 }, /* #56 */
    { 0x171053, 0x171012, 0x4663a1b1, 0x132d71f2, 0x33362fbe, 0x0 }, /* #57 */
    { 0x162c53, 0x162413, 0x28fed2c9, 0x5b3ac90d, 0xcdc409bb, 0x0 }, /* #58 */
    { 0x0866d3, 0x086607, 0x52f4568b, 0x5532da74, 0xfdc17c16, 0x0 }, /* #59 */
    { 0x370382, 0x370312, 0xf5edb972, 0x57d679d6, 0x9e173f9c, 0x0 }, /* #60 */
    { 0x0b21c3, 0x0b2186, 0xce7266fa, 0xa3b9df30, 0x2ab887c9, 0x0 }, /* #61 */
    { 0x245e92, 0x245692, 0xc4992cd8, 0xbb4e6eef, 0x094abde9, 0x0 }, /* #62 */
    { 0x1215d3, 0x121507, 0x59c333a8, 0x602a3344, 0xf9990063, 0x0 }, /* #63 */
    { 0x320e17, 0x320612, 0xfb868667, 0x3731d39d, 0xc454b2c9, 0x0 }, /* #64 */
    { 0x361257, 0x361217, 0x5da5f132, 0x5eafea24, 0xfef6070d, 0x0 }, /* #65 */
    { 0x165713, 0x165702, 0xbaf4190d, 0x20b9ce89, 0x9a3a4a83, 0x0 }, /* #66 */
    { 0x3a1903, 0x3a1902, 0xcaa716da, 0x6de2f0e5, 0x5cc425f4, 0x0 }, /* #67 */
    { 0x154f02, 0x154787, 0xc6c2cedb, 0xd195da03, 0xf52cf4d8, 0x0 }, /* #68 */
    { 0x1073c3, 0x107393, 0x8acde351, 0xbba2fe16, 0xcf2ae53a, 0x0 }, /* #69 */
    { 0x3819d3, 0x381112, 0xcc19f880, 0x2d67fd79, 0x9eb1fb06, 0x0 }, /* #70 */
    { 0x273e47, 0x273606, 0x7d2411c3, 0x511b0e42, 0x2c090380, 0x0 }, /* #71 */
    { 0x1e5852, 0x1e5802, 0xcb155ab9, 0x6afdcae5, 0x60178fd4, 0x0 }, /* #72 */
    { 0x244886, 0x244812, 0x812bb144, 0x0e0a0d68, 0x7321a3dc, 0x0 }, /* #73 */
    { 0x193513, 0x193593, 0x926fcf40, 0xcbb28a57, 0xc6bd44e8, 0x0 }, /* #74 */
    { 0x282e57, 0x282612, 0xae9e7730, 0x028d061c, 0xac117113, 0x0 }, /* #75 */
    { 0x2445c2, 0x244502, 0x6dbf33f9, 0x4a0d9915, 0x23b19ae4, 0x0 }, /* #76 */
    { 0x204f57, 0x204707, 0x2bd1cc97, 0x47a698d4, 0xe42b33c2, 0x0 }, /* #77 */
    { 0x124e43, 0x124616, 0xf98f941b, 0x6000801e, 0x998f13fc, 0x0 }, /* #78 */
    { 0x1b7747, 0x1b7797, 0x35fb5070, 0xbd6cb384, 0x788e9ceb, 0x0 }, /* #79 */
    { 0x347f56, 0x347783, 0x4e8773f0, 0xf7974420, 0x56f02fd0, 0x0 }, /* #80 */
    { 0x2d16d6, 0x2d1612, 0xbee50c69, 0x03ad67ba, 0xbb37a4af, 0x0 }, /* #81 */
    { 0x315816, 0x315083, 0x03ebe06f, 0x93ef8d1c, 0x6ffc5353, 0x0 }, /* #82 */
    { 0x3a7942, 0x3a7183, 0xbecbde3e, 0xdf621775, 0xdf69c6c9, 0x0 }, /* #83 */
    { 0x2e3587, 0x2e3587, 0x893daeee, 0xc73ff203, 0xc1fdbcea, 0x0 }, /* #84 */
    { 0x3376d7, 0x337e12, 0x982225f2, 0x24bff1e5, 0x7362340c, 0x0 }, /* #85 */
    { 0x3f19c7, 0x3f1113, 0x53aeef42, 0x5f78302c, 0xf436bf15, 0x0 }, /* #86 */
    { 0x302196, 0x302103, 0x1c29eb4a, 0x2e1a8e83, 0xee0f5cc7, 0x0 }, /* #87 */
    { 0x2d1fc7, 0x2d1713, 0x044a7e92, 0x40807aba, 0xc3ca03d7, 0x0 }, /* #88 */
    { 0x186e43, 0x186e12, 0xa29f114c, 0x2819871f, 0x7a858a2c, 0x0 }, /* #89 */
    { 0x3b6fc7, 0x3b6702, 0x4f54d3cd, 0x3fded06b, 0x0f760361, 0x0 }, /* #90 */
    { 0x003703, 0x003792, 0xeb392e6d, 0x9bc894ae, 0x4f7099be, 0x0 }, /* #91 */
    { 0x276f86, 0x276712, 0x4103d694, 0x2164af0e, 0x1f9f2786, 0x0 }, /* #92 */
    { 0x292bc2, 0x292382, 0xc81ed64e, 0x84ab08d0, 0x4373cd7e, 0x0 }, /* #93 */
    { 0x210507, 0x210506, 0x44b19bce, 0x4334c54d, 0x017cd680, 0x0 }, /* #94 */
    { 0x385282, 0x385212, 0x5bea4c08, 0x014a29ad, 0x5aa0225b, 0x0 }, /* #95 */
};
uint32_t const g_cTests_sbb_u32_locked = RT_ELEMENTS(g_aTests_sbb_u32_locked);

BINU32_TEST_T const g_aTests_or_u32[] =
{
    { 0x0f0343, 0x0f0346, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #0 */
    { 0x2d3643, 0x2d3646, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x191096, 0x191046, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #2 */
    { 0x1b7552, 0x1b7546, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #3 */
    { 0x2a7406, 0x2a7446, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #4 */
    { 0x0f5d83, 0x0f5546, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x2e5952, 0x2e5186, 0xf29a5633, 0xf29a5633, 0x00000000, 0x0 }, /* #6 */
    { 0x3e43c3, 0x3e4382, 0xf4be9c1a, 0xf4be9c1a, 0x00000000, 0x0 }, /* #7 */
    { 0x3b3987, 0x3b3102, 0x5ece8b1a, 0x5ece8b1a, 0x00000000, 0x0 }, /* #8 */
    { 0x096213, 0x096286, 0xe521ef2d, 0xe521ef2d, 0x00000000, 0x0 }, /* #9 */
    { 0x1d23d7, 0x1d2302, 0x49825d6e, 0x49825d6e, 0x00000000, 0x0 }, /* #10 */
    { 0x143b52, 0x143302, 0x0a38eb4f, 0x0a38eb4f, 0x00000000, 0x0 }, /* #11 */
    { 0x332307, 0x332382, 0x5c22169a, 0xffa377fb, 0xef8161e1, 0x0 }, /* #12 */
    { 0x035497, 0x035406, 0x3592f38b, 0x75d7f39f, 0x70c7b01c, 0x0 }, /* #13 */
    { 0x0e7306, 0x0e7306, 0x6cadc1f2, 0x7dfff7fa, 0x115e362a, 0x0 }, /* #14 */
    { 0x346e02, 0x346682, 0x4565147a, 0xff6dbe7a, 0xfa69be52, 0x0 }, /* #15 */
    { 0x2a7302, 0x2a7382, 0xcb63aef7, 0xefe3eef7, 0xee83c8d2, 0x0 }, /* #16 */
    { 0x331006, 0x331082, 0x9a0fccaf, 0xff0fcebf, 0x67014211, 0x0 }, /* #17 */
    { 0x3306d6, 0x330686, 0x878730cd, 0x978ff9ed, 0x1109c96d, 0x0 }, /* #18 */
    { 0x154147, 0x154102, 0x494025ef, 0x4bd6adef, 0x03968c43, 0x0 }, /* #19 */
    { 0x2f4b56, 0x2f4386, 0xb42ac0a0, 0xf42af6b1, 0xc008b631, 0x0 }, /* #20 */
    { 0x2e2846, 0x2e2086, 0x7bd2ce94, 0xffdeff96, 0x865c3706, 0x0 }, /* #21 */
    { 0x117313, 0x117382, 0xb1746f68, 0xbd7dffec, 0xbc1dbcec, 0x0 }, /* #22 */
    { 0x297b57, 0x297382, 0x4c0f2ceb, 0xcd1f2fef, 0xc516074d, 0x0 }, /* #23 */
    { 0x3c0d07, 0x3c0502, 0x094f1440, 0x5bfff470, 0x5bbef030, 0x0 }, /* #24 */
    { 0x104447, 0x104482, 0x20f46170, 0xa5fd6b75, 0xa5c94b25, 0x0 }, /* #25 */
    { 0x377217, 0x377282, 0x24916969, 0xa6d16bfd, 0xa2c042dd, 0x0 }, /* #26 */
    { 0x0d1dc6, 0x0d1586, 0x82d016b2, 0xb6fc9efa, 0x363c98f8, 0x0 }, /* #27 */
    { 0x374a87, 0x374286, 0x8a8ea116, 0xdfefed56, 0x57eb6c50, 0x0 }, /* #28 */
    { 0x1c5912, 0x1c5186, 0xec112255, 0xef117f55, 0x8f007d40, 0x0 }, /* #29 */
    { 0x1a2e56, 0x1a2686, 0x953d80ae, 0xb77d85be, 0xb7510510, 0x0 }, /* #30 */
    { 0x045556, 0x045502, 0x7b4e3357, 0x7bdebf7f, 0x4bd0ad78, 0x0 }, /* #31 */
    { 0x2d6946, 0x2d6186, 0x25da7b8e, 0xbdffffff, 0x99758c7b, 0x0 }, /* #32 */
    { 0x3b54d3, 0x3b5482, 0x0dc5a2cf, 0xedd5faef, 0xe1d078e8, 0x0 }, /* #33 */
    { 0x2d4f83, 0x2d4706, 0x177d15c1, 0x577ffdc5, 0x515aec84, 0x0 }, /* #34 */
    { 0x0b7383, 0x0b7382, 0xed5471eb, 0xffd7f7ef, 0x5a87f644, 0x0 }, /* #35 */
    { 0x325052, 0x325006, 0x02cd53f8, 0x4affdbfc, 0x4a3f8bac, 0x0 }, /* #36 */
    { 0x2a3e96, 0x2a3606, 0x30d18aaf, 0x31d9cbaf, 0x1198c985, 0x0 }, /* #37 */
    { 0x193a93, 0x193286, 0x979f1203, 0xbfff7a2b, 0x2c61782a, 0x0 }, /* #38 */
    { 0x243116, 0x243102, 0x3681e341, 0x3fb1e7fb, 0x0931a7fa, 0x0 }, /* #39 */
    { 0x0d7bc3, 0x0d7302, 0x2aa6c958, 0x7aafd9f8, 0x722d58e8, 0x0 }, /* #40 */
    { 0x1368c3, 0x136086, 0xa167ffb8, 0xafefffbe, 0x0fadd6b6, 0x0 }, /* #41 */
    { 0x197646, 0x197606, 0x213425d8, 0x79b577d8, 0x59a17640, 0x0 }, /* #42 */
    { 0x0e1116, 0x0e1186, 0x6a8b51f9, 0xfeef51ff, 0xde67413f, 0x0 }, /* #43 */
    { 0x3650c2, 0x365082, 0xd32a9ec0, 0xf7fa9fdf, 0xf7d81b1f, 0x0 }, /* #44 */
    { 0x332202, 0x332282, 0x3bd202c4, 0xffff2fdf, 0xd73f2f1f, 0x0 }, /* #45 */
    { 0x224492, 0x224402, 0x63a0c09c, 0x63e5e49d, 0x43456495, 0x0 }, /* #46 */
    { 0x150ec7, 0x150682, 0x49870a55, 0xcdcffef7, 0xcd49fef3, 0x0 }, /* #47 */
    { 0x392b02, 0x392382, 0xae9af69a, 0xae9bf7fe, 0x009301fc, 0x0 }, /* #48 */
    { 0x1c7dd3, 0x1c7506, 0x0e81087e, 0x0fb75d7e, 0x01375d44, 0x0 }, /* #49 */
    { 0x3c6716, 0x3c6782, 0x2e8f071e, 0xeedfff3e, 0xe8d0fc2a, 0x0 }, /* #50 */
    { 0x307493, 0x307402, 0x3c99c94a, 0x7dd9df5b, 0x7dd8161b, 0x0 }, /* #51 */
    { 0x147943, 0x147102, 0x220d6b87, 0x3fddefc7, 0x1fd5cd46, 0x0 }, /* #52 */
    { 0x052e97, 0x052686, 0xb84a1ce7, 0xbd6a9eff, 0x3d628a3e, 0x0 }, /* #53 */
    { 0x103f57, 0x103786, 0x9f051d0e, 0xdfefbd7e, 0xd4eabc7c, 0x0 }, /* #54 */
    { 0x1c04c2, 0x1c0486, 0x9756c2df, 0xfff6f3ff, 0x69f473f7, 0x0 }, /* #55 */
    { 0x2a4a46, 0x2a4282, 0xf81a1ba0, 0xfe1a9bf4, 0xce029954, 0x0 }, /* #56 */
    { 0x155c12, 0x155486, 0x329fa3bd, 0xf6bfffff, 0xf6235c4a, 0x0 }, /* #57 */
    { 0x273556, 0x273582, 0x619654e2, 0xf1b67ffe, 0xd1327f3e, 0x0 }, /* #58 */
    { 0x294212, 0x294282, 0xfe9fdcda, 0xffdfffdf, 0x9d4b6345, 0x0 }, /* #59 */
    { 0x312d57, 0x312586, 0x04c49e8f, 0xf4d4ff9f, 0xf450e510, 0x0 }, /* #60 */
    { 0x283393, 0x283306, 0x5edf6c01, 0x5edf7e69, 0x0a9e3668, 0x0 }, /* #61 */
    { 0x1d4517, 0x1d4506, 0x44d79fe6, 0x5fdf9fe7, 0x5b0b15e3, 0x0 }, /* #62 */
    { 0x1d2082, 0x1d2086, 0x44de278f, 0xcefe27af, 0xce3021a7, 0x0 }, /* #63 */
    { 0x280092, 0x280082, 0x8b9baad5, 0xbf9ffed5, 0xb4075cc1, 0x0 }, /* #64 */
    { 0x2e6847, 0x2e6082, 0xc283c93b, 0xeedfcdbf, 0x6e5d8597, 0x0 }, /* #65 */
    { 0x1a4912, 0x1a4102, 0x3a06875b, 0x3b069f5b, 0x21001e49, 0x0 }, /* #66 */
    { 0x206583, 0x206586, 0xed3426ba, 0xeffdffbe, 0x62dddf16, 0x0 }, /* #67 */
    { 0x0c5892, 0x0c5086, 0xe7cd97db, 0xefddb7ff, 0x8cdd2567, 0x0 }, /* #68 */
    { 0x0b3357, 0x0b3386, 0xf8f79dd9, 0xf8f7bfff, 0x3052a33e, 0x0 }, /* #69 */
    { 0x1f6743, 0x1f6782, 0xe361d861, 0xef71dcf1, 0xad508491, 0x0 }, /* #70 */
    { 0x2801c2, 0x280186, 0xf42fd81d, 0xffbfdfff, 0x4bbd47f3, 0x0 }, /* #71 */
    { 0x0d7ad7, 0x0d7202, 0x70a1c475, 0x7fabd475, 0x7faa1014, 0x0 }, /* #72 */
    { 0x325d56, 0x325502, 0x4b5c7775, 0x7f7e7f7f, 0x353e0e0b, 0x0 }, /* #73 */
    { 0x277c92, 0x277482, 0x1ae8b878, 0xbef9b8fe, 0xa43980de, 0x0 }, /* #74 */
    { 0x1b3fd2, 0x1b3702, 0x0ad771e0, 0x5ed7f7f2, 0x5685b692, 0x0 }, /* #75 */
    { 0x0c0f82, 0x0c0702, 0x5200b196, 0x5f31bfbf, 0x5d311f39, 0x0 }, /* #76 */
    { 0x363e53, 0x363682, 0x3771c1cc, 0xf7f9dbce, 0xc4f99b0e, 0x0 }, /* #77 */
    { 0x376602, 0x376682, 0x163b4cdf, 0xbfffffdf, 0xabfebb8a, 0x0 }, /* #78 */
    { 0x3d64c3, 0x3d6482, 0xd1ef6027, 0xf5ff7467, 0x349e7465, 0x0 }, /* #79 */
    { 0x1d3f57, 0x1d3782, 0x9702571a, 0x9f6f775e, 0x0a6d3744, 0x0 }, /* #80 */
    { 0x0a48c6, 0x0a4086, 0xe9e29e86, 0xeffbbecf, 0x6e99b2cf, 0x0 }, /* #81 */
    { 0x012c97, 0x012486, 0x839bee00, 0x93bfef03, 0x92ac6503, 0x0 }, /* #82 */
    { 0x0f3e83, 0x0f3686, 0x9635bd91, 0xdefdbfd7, 0x58f9a3d7, 0x0 }, /* #83 */
    { 0x1b3792, 0x1b3702, 0x6e72a8d9, 0x7fffb8d9, 0x3b8fb098, 0x0 }, /* #84 */
    { 0x046c92, 0x046482, 0xa3dbbe2d, 0xabfffe3d, 0xaa7c5c39, 0x0 }, /* #85 */
    { 0x271786, 0x271786, 0x79b9cdd8, 0xfdb9cdde, 0xf4b90806, 0x0 }, /* #86 */
    { 0x163087, 0x163002, 0x6f31575f, 0x7f7fd77f, 0x734e932b, 0x0 }, /* #87 */
    { 0x0b7846, 0x0b7082, 0x2e673355, 0xfee73b7f, 0xf8a60a6f, 0x0 }, /* #88 */
    { 0x236e56, 0x236682, 0x854db5a2, 0x8dfdbfb6, 0x0cb18f36, 0x0 }, /* #89 */
    { 0x201d16, 0x201582, 0x96726487, 0xd777fda7, 0x5725dda6, 0x0 }, /* #90 */
    { 0x2015c2, 0x201582, 0x568e7323, 0xf7eff3fb, 0xf3eb90d9, 0x0 }, /* #91 */
    { 0x3e7a56, 0x3e7202, 0x59ea042f, 0x7dfa2f2f, 0x6cf02f01, 0x0 }, /* #92 */
    { 0x3d0c82, 0x3d0482, 0xf04145d9, 0xfcd567d9, 0xac956289, 0x0 }, /* #93 */
    { 0x2759c3, 0x275106, 0x34b6a4d3, 0x3ff6eeff, 0x2fc4ee7f, 0x0 }, /* #94 */
    { 0x213c57, 0x213406, 0x25db58c1, 0x27fbfbcf, 0x03e0bbce, 0x0 }, /* #95 */
};
uint32_t const g_cTests_or_u32 = RT_ELEMENTS(g_aTests_or_u32);

BINU32_TEST_T const g_aTests_or_u32_locked[] =
{
    { 0x0d6592, 0x0d6546, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #0 */
    { 0x315697, 0x315646, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x1b29d3, 0x1b2146, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #2 */
    { 0x0e76d7, 0x0e7646, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #3 */
    { 0x177912, 0x177146, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #4 */
    { 0x056906, 0x056146, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x244203, 0x244206, 0x1c6f41f6, 0x1c6f41f6, 0x00000000, 0x0 }, /* #6 */
    { 0x276c13, 0x276406, 0x23d05299, 0x23d05299, 0x00000000, 0x0 }, /* #7 */
    { 0x2c6013, 0x2c6082, 0xc9154ca8, 0xc9154ca8, 0x00000000, 0x0 }, /* #8 */
    { 0x024447, 0x024486, 0x9bb05b50, 0x9bb05b50, 0x00000000, 0x0 }, /* #9 */
    { 0x0c7f03, 0x0c7786, 0x8369be72, 0x8369be72, 0x00000000, 0x0 }, /* #10 */
    { 0x0c4253, 0x0c4286, 0xb45feff0, 0xb45feff0, 0x00000000, 0x0 }, /* #11 */
    { 0x1540d7, 0x154086, 0xbb37ac0c, 0xbf7fadfc, 0x9d7e25f4, 0x0 }, /* #12 */
    { 0x2968c3, 0x296006, 0x7a095724, 0x7ebff7ac, 0x3cbeb18c, 0x0 }, /* #13 */
    { 0x331687, 0x331682, 0xb67ebf8a, 0xff7eff9b, 0xf902f913, 0x0 }, /* #14 */
    { 0x0f2416, 0x0f2486, 0x0e9eaf97, 0xaedfff9f, 0xa0dfd38b, 0x0 }, /* #15 */
    { 0x015902, 0x015186, 0x16c9224e, 0xbfeba66f, 0xbf2ba46b, 0x0 }, /* #16 */
    { 0x1d3c57, 0x1d3486, 0x55b66212, 0xf5bf7af3, 0xb50b5af3, 0x0 }, /* #17 */
    { 0x327292, 0x327202, 0x0b8692dc, 0x4b9ffffe, 0x419b6dae, 0x0 }, /* #18 */
    { 0x343a07, 0x343202, 0x321d92ea, 0x723fd6ef, 0x402f464d, 0x0 }, /* #19 */
    { 0x145403, 0x145482, 0x8a08661c, 0xae7d76df, 0x2e7d32df, 0x0 }, /* #20 */
    { 0x194ec7, 0x194602, 0x5eb19ffb, 0x7ff99ffb, 0x3d498fc2, 0x0 }, /* #21 */
    { 0x104d07, 0x104586, 0x30493a5d, 0xbaefba5f, 0x9aa68053, 0x0 }, /* #22 */
    { 0x212fd7, 0x212782, 0xbc4a0805, 0xbcfbdcad, 0xb4f9dca8, 0x0 }, /* #23 */
    { 0x275482, 0x275486, 0xa7b4d455, 0xffb5de55, 0x7b954e01, 0x0 }, /* #24 */
    { 0x151912, 0x151182, 0x3729bfc2, 0xb7bfbfc7, 0x85bf1045, 0x0 }, /* #25 */
    { 0x2e4297, 0x2e4282, 0xb524c40e, 0xb764ec8f, 0x12446c8f, 0x0 }, /* #26 */
    { 0x107e02, 0x107682, 0x06f4b1de, 0xcff7f7df, 0xcb83c753, 0x0 }, /* #27 */
    { 0x206d46, 0x206586, 0xa09bb90e, 0xb9bbbfee, 0x19bb06e6, 0x0 }, /* #28 */
    { 0x202cd7, 0x202482, 0x24dbdeb9, 0xeddffeb9, 0xc98d2890, 0x0 }, /* #29 */
    { 0x307e56, 0x307682, 0x843bcc05, 0xb4fbfdef, 0xb0d3b9ee, 0x0 }, /* #30 */
    { 0x3c0f16, 0x3c0706, 0x4432c2a7, 0x7c3ec7b7, 0x7c1e45b4, 0x0 }, /* #31 */
    { 0x2f3787, 0x2f3786, 0xd30663d1, 0xdbcf6ff9, 0x5bc90de9, 0x0 }, /* #32 */
    { 0x2e72d2, 0x2e7286, 0x6fb45dd0, 0xefbc5df6, 0xabac5066, 0x0 }, /* #33 */
    { 0x383916, 0x383186, 0x60642e37, 0xe8662eb7, 0xa8422094, 0x0 }, /* #34 */
    { 0x081d03, 0x081582, 0xa0bb8e0a, 0xe0bffe5b, 0x602d7859, 0x0 }, /* #35 */
    { 0x1d0e87, 0x1d0682, 0xdd9383c0, 0xfd93a7e5, 0x6c92a6e5, 0x0 }, /* #36 */
    { 0x0d6b97, 0x0d6386, 0xdaa39ae6, 0xfbabdbf6, 0x7b0acb90, 0x0 }, /* #37 */
    { 0x1e4097, 0x1e4006, 0x4981d544, 0x7fe3f7cc, 0x76e36688, 0x0 }, /* #38 */
    { 0x2f4b12, 0x2f4386, 0xdf02c061, 0xdfe3f969, 0xdae1f949, 0x0 }, /* #39 */
    { 0x1d0693, 0x1d0682, 0x086e938d, 0xc96f9fad, 0xc1019d29, 0x0 }, /* #40 */
    { 0x2c55c6, 0x2c5582, 0xc1212102, 0xcd233507, 0xcd221407, 0x0 }, /* #41 */
    { 0x304a96, 0x304286, 0x4538af22, 0xff7cafa3, 0xbb4c83a1, 0x0 }, /* #42 */
    { 0x2307c6, 0x230782, 0xa989d155, 0xbbafd1df, 0x9a2f518b, 0x0 }, /* #43 */
    { 0x292e97, 0x292682, 0x85c1e284, 0x97edfac4, 0x16ec7ac0, 0x0 }, /* #44 */
    { 0x332a07, 0x332282, 0xfdaa4e67, 0xffefde7f, 0x876fd05c, 0x0 }, /* #45 */
    { 0x201d52, 0x201582, 0xc7489f87, 0xef49bff7, 0x6e0136f6, 0x0 }, /* #46 */
    { 0x1f1ec7, 0x1f1606, 0x761f0cba, 0x7e5fdfff, 0x5e57d365, 0x0 }, /* #47 */
    { 0x2610c2, 0x261082, 0xde48dc47, 0xde4fdec7, 0xc807c684, 0x0 }, /* #48 */
    { 0x346897, 0x346086, 0xa5f70a3a, 0xedf77a3f, 0xe836721f, 0x0 }, /* #49 */
    { 0x182c07, 0x182482, 0x6856703c, 0xeb57707c, 0xeb11104c, 0x0 }, /* #50 */
    { 0x3314d7, 0x331406, 0x42bf8531, 0x7abfe57b, 0x7a38e56b, 0x0 }, /* #51 */
    { 0x3c3993, 0x3c3186, 0xfd236a6d, 0xff337e6f, 0x12327c6a, 0x0 }, /* #52 */
    { 0x3505c2, 0x350506, 0x29590254, 0x697dc2d4, 0x4174c290, 0x0 }, /* #53 */
    { 0x105a42, 0x105202, 0x04b72ff5, 0x4fb76ff7, 0x4f104446, 0x0 }, /* #54 */
    { 0x070753, 0x070786, 0x948c094e, 0xf4ac196f, 0x74201161, 0x0 }, /* #55 */
    { 0x332803, 0x332086, 0x3fae3a2c, 0xbfaffb2e, 0x9f01d10e, 0x0 }, /* #56 */
    { 0x2b0853, 0x2b0006, 0x444ce078, 0x74dcebfa, 0x749cab9a, 0x0 }, /* #57 */
    { 0x1425c7, 0x142586, 0xb1fcd135, 0xfdffd535, 0x5d8fd421, 0x0 }, /* #58 */
    { 0x212117, 0x212182, 0xe0a49d68, 0xfae69def, 0x7a628ccf, 0x0 }, /* #59 */
    { 0x2164c6, 0x216482, 0xe636248f, 0xfefeaedf, 0x7cfcaed3, 0x0 }, /* #60 */
    { 0x064e83, 0x064682, 0x37d20de6, 0xbff6bfe6, 0xbab4b7a0, 0x0 }, /* #61 */
    { 0x3d5646, 0x3d5686, 0x189d8f0a, 0x9fbdaf4b, 0x9fa1a84b, 0x0 }, /* #62 */
    { 0x1c3d83, 0x1c3582, 0x07f88ab4, 0xd7facfbc, 0xd40acf1c, 0x0 }, /* #63 */
    { 0x0e4ec7, 0x0e4682, 0xa1d828df, 0xe7f93ddf, 0xc6b9358c, 0x0 }, /* #64 */
    { 0x3c6112, 0x3c6182, 0x8c2e204f, 0x8c2ff4df, 0x080bf490, 0x0 }, /* #65 */
    { 0x086c03, 0x086482, 0x123d8308, 0x97fdd35b, 0x97d5d053, 0x0 }, /* #66 */
    { 0x0d7e43, 0x0d7682, 0xc5c13742, 0xf5c5bf4a, 0xf1c4ba08, 0x0 }, /* #67 */
    { 0x334286, 0x334282, 0xc5c1386f, 0xcfc1387f, 0x8fc01079, 0x0 }, /* #68 */
    { 0x3a5dd7, 0x3a5582, 0x6fb118f7, 0xeffbbdf7, 0xaffbad36, 0x0 }, /* #69 */
    { 0x2d5e42, 0x2d5686, 0x42953257, 0xd7dd7fff, 0x97596fb9, 0x0 }, /* #70 */
    { 0x2a2b16, 0x2a2386, 0xb5982cc9, 0xbffa6fdb, 0x8efa4b9a, 0x0 }, /* #71 */
    { 0x342c56, 0x342402, 0x6211c531, 0x62d7e773, 0x60d62343, 0x0 }, /* #72 */
    { 0x350497, 0x350486, 0xe59bf921, 0xf59bfdf3, 0x919a54d3, 0x0 }, /* #73 */
    { 0x301c47, 0x301402, 0x0b4f4b51, 0x3fff6ffb, 0x36f76fab, 0x0 }, /* #74 */
    { 0x231416, 0x231482, 0x6472c9a4, 0xec7ffdec, 0x8c4dfdcc, 0x0 }, /* #75 */
    { 0x335103, 0x335102, 0x1b83aa4a, 0x3bababdf, 0x39a9239f, 0x0 }, /* #76 */
    { 0x262c56, 0x262486, 0xce71b107, 0xfffffd5f, 0xf1aeec5c, 0x0 }, /* #77 */
    { 0x233142, 0x233186, 0xfa8b89b6, 0xfbcfcdb7, 0xd1cecc01, 0x0 }, /* #78 */
    { 0x220c93, 0x220486, 0xd1833951, 0xf5933977, 0xa5123976, 0x0 }, /* #79 */
    { 0x036816, 0x036082, 0xe352bfb9, 0xe3feffbf, 0xa2ecf6ae, 0x0 }, /* #80 */
    { 0x0003d7, 0x000302, 0x6e5450a9, 0x6f7579bf, 0x2131793f, 0x0 }, /* #81 */
    { 0x272b87, 0x272306, 0x141c3da0, 0x359dbfb1, 0x2185ba11, 0x0 }, /* #82 */
    { 0x314457, 0x314486, 0xe1c70a02, 0xf7ef9a3f, 0x36ae903f, 0x0 }, /* #83 */
    { 0x045192, 0x045182, 0xc1c84ce3, 0xd1ccdff7, 0x918cd7b6, 0x0 }, /* #84 */
    { 0x1e7742, 0x1e7782, 0x97574f30, 0xf7f74f73, 0x62e74353, 0x0 }, /* #85 */
    { 0x1c4216, 0x1c4286, 0x7ef79cd6, 0xfff7fcde, 0xa9b0f81e, 0x0 }, /* #86 */
    { 0x147f56, 0x147706, 0x11cf3217, 0x33ff3b9f, 0x23b3398a, 0x0 }, /* #87 */
    { 0x375712, 0x375706, 0x45e3eff3, 0x6fffffff, 0x2e9f7c3e, 0x0 }, /* #88 */
    { 0x121f42, 0x121786, 0xc0a27429, 0xfee2752b, 0x7ec0052a, 0x0 }, /* #89 */
    { 0x1074d6, 0x107482, 0xda044b91, 0xfe976bd5, 0x7e936344, 0x0 }, /* #90 */
    { 0x3778c6, 0x377082, 0x25fe81ed, 0xa7fea5ef, 0xa646a44f, 0x0 }, /* #91 */
    { 0x2a1396, 0x2a1382, 0xd3446889, 0xfbdf68d9, 0x38df48d1, 0x0 }, /* #92 */
    { 0x0f7383, 0x0f7302, 0x601e3af7, 0x679f3af7, 0x07812226, 0x0 }, /* #93 */
    { 0x212f02, 0x212786, 0xa49805e4, 0xaede85ed, 0x8ece8489, 0x0 }, /* #94 */
    { 0x2e2996, 0x2e2186, 0xee893ed2, 0xefab7ef6, 0x6ba370b6, 0x0 }, /* #95 */
};
uint32_t const g_cTests_or_u32_locked = RT_ELEMENTS(g_aTests_or_u32_locked);

BINU32_TEST_T const g_aTests_xor_u32[] =
{
    { 0x044897, 0x044046, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #0 */
    { 0x3f4697, 0x3f4646, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x0858d3, 0x085046, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #2 */
    { 0x3b1643, 0x3b1646, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #3 */
    { 0x2f1f93, 0x2f1746, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #4 */
    { 0x2e4bc3, 0x2e4346, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x190d87, 0x190506, 0x1f50d9ff, 0x1f50d9ff, 0x00000000, 0x0 }, /* #6 */
    { 0x372047, 0x372002, 0x3c8af78f, 0x3c8af78f, 0x00000000, 0x0 }, /* #7 */
    { 0x120b12, 0x120306, 0x715544ff, 0x715544ff, 0x00000000, 0x0 }, /* #8 */
    { 0x330a43, 0x330282, 0xfbcfc516, 0xfbcfc516, 0x00000000, 0x0 }, /* #9 */
    { 0x0b0203, 0x0b0286, 0xbcb2aa93, 0xbcb2aa93, 0x00000000, 0x0 }, /* #10 */
    { 0x080d87, 0x080502, 0x23bffa40, 0x23bffa40, 0x00000000, 0x0 }, /* #11 */
    { 0x253e12, 0x253606, 0x8bb6d403, 0x76d5ac6f, 0xfd63786c, 0x0 }, /* #12 */
    { 0x2a7a03, 0x2a7202, 0x159b698d, 0x17ca4bfe, 0x02512273, 0x0 }, /* #13 */
    { 0x127816, 0x127002, 0x444b34ca, 0x25b97de9, 0x61f24923, 0x0 }, /* #14 */
    { 0x214717, 0x214782, 0x05d4a302, 0xc4093308, 0xc1dd900a, 0x0 }, /* #15 */
    { 0x397a92, 0x397282, 0x2bcc8da6, 0xa49d7a2f, 0x8f51f789, 0x0 }, /* #16 */
    { 0x0e7613, 0x0e7686, 0xac08a00a, 0xce0d25db, 0x620585d1, 0x0 }, /* #17 */
    { 0x107b92, 0x107302, 0xebface55, 0x20c1d76d, 0xcb3b1938, 0x0 }, /* #18 */
    { 0x200c07, 0x200482, 0x962ec8c3, 0xcbdfdf79, 0x5df117ba, 0x0 }, /* #19 */
    { 0x2d6692, 0x2d6602, 0xd3664b49, 0x64b971b9, 0xb7df3af0, 0x0 }, /* #20 */
    { 0x395196, 0x395182, 0x2e95aa3f, 0x8b0b3a26, 0xa59e9019, 0x0 }, /* #21 */
    { 0x083c16, 0x083482, 0x34b27ae2, 0xa2339670, 0x9681ec92, 0x0 }, /* #22 */
    { 0x2068d6, 0x206002, 0xa632b3c3, 0x6704ac83, 0xc1361f40, 0x0 }, /* #23 */
    { 0x2a72d7, 0x2a7206, 0xfa617d35, 0x4f28488e, 0xb54935bb, 0x0 }, /* #24 */
    { 0x065a53, 0x065202, 0x5a77acb4, 0x4aae1731, 0x10d9bb85, 0x0 }, /* #25 */
    { 0x3c3192, 0x3c3102, 0xd64bff49, 0x29564b4f, 0xff1db406, 0x0 }, /* #26 */
    { 0x101153, 0x101186, 0x0a902add, 0x8278e28d, 0x88e8c850, 0x0 }, /* #27 */
    { 0x0753d2, 0x075302, 0x9dcb4055, 0x67d62e16, 0xfa1d6e43, 0x0 }, /* #28 */
    { 0x3c67d3, 0x3c6706, 0xe317d950, 0x60454082, 0x835299d2, 0x0 }, /* #29 */
    { 0x132303, 0x132306, 0x0ac04904, 0x4b712387, 0x41b16a83, 0x0 }, /* #30 */
    { 0x234a07, 0x234286, 0xf05cb426, 0xbb8e5b71, 0x4bd2ef57, 0x0 }, /* #31 */
    { 0x017603, 0x017602, 0x76daacb6, 0x27d54004, 0x510fecb2, 0x0 }, /* #32 */
    { 0x345f17, 0x345702, 0x6aa77c22, 0x6f185183, 0x05bf2da1, 0x0 }, /* #33 */
    { 0x1a4497, 0x1a4482, 0x5f95f976, 0xfdce06a2, 0xa25bffd4, 0x0 }, /* #34 */
    { 0x236957, 0x236186, 0x67a4c45f, 0xcf4b12ff, 0xa8efd6a0, 0x0 }, /* #35 */
    { 0x2a5913, 0x2a5102, 0xbcf0bdcc, 0x77648583, 0xcb94384f, 0x0 }, /* #36 */
    { 0x2d4a17, 0x2d4202, 0x015bbb70, 0x75408bb9, 0x741b30c9, 0x0 }, /* #37 */
    { 0x094c16, 0x094482, 0xaf9791cf, 0xd84073e5, 0x77d7e22a, 0x0 }, /* #38 */
    { 0x1e48d3, 0x1e4086, 0x6090ed30, 0xa544b7ac, 0xc5d45a9c, 0x0 }, /* #39 */
    { 0x303343, 0x303302, 0x47a4f218, 0x752aa7b3, 0x328e55ab, 0x0 }, /* #40 */
    { 0x111252, 0x111206, 0x77d63b42, 0x1a5c3105, 0x6d8a0a47, 0x0 }, /* #41 */
    { 0x124ad6, 0x124206, 0x7ee4f326, 0x02792f99, 0x7c9ddcbf, 0x0 }, /* #42 */
    { 0x016ec7, 0x016606, 0x05bb0613, 0x283c1bbd, 0x2d871dae, 0x0 }, /* #43 */
    { 0x295242, 0x295202, 0x17d9c1b8, 0x36a8be16, 0x21717fae, 0x0 }, /* #44 */
    { 0x2d1547, 0x2d1502, 0x4e9f71ab, 0x6dc1b61a, 0x235ec7b1, 0x0 }, /* #45 */
    { 0x2b1816, 0x2b1086, 0xbc02ec56, 0x9e1a56c3, 0x2218ba95, 0x0 }, /* #46 */
    { 0x3c7f83, 0x3c7702, 0x9657a87b, 0x7cec3fb6, 0xeabb97cd, 0x0 }, /* #47 */
    { 0x053b12, 0x053306, 0xaf49b621, 0x7f24c744, 0xd06d7165, 0x0 }, /* #48 */
    { 0x2d1e96, 0x2d1602, 0x794d0cca, 0x073e6068, 0x7e736ca2, 0x0 }, /* #49 */
    { 0x137d46, 0x137502, 0xb3e74a47, 0x2c6258b6, 0x9f8512f1, 0x0 }, /* #50 */
    { 0x0e3113, 0x0e3102, 0x391042dc, 0x0cbcc370, 0x35ac81ac, 0x0 }, /* #51 */
    { 0x0d3716, 0x0d3702, 0x18983105, 0x5062db2f, 0x48faea2a, 0x0 }, /* #52 */
    { 0x0e5642, 0x0e5606, 0x21d6af97, 0x1bb8780f, 0x3a6ed798, 0x0 }, /* #53 */
    { 0x390446, 0x390402, 0xecdd6748, 0x7239e8d9, 0x9ee48f91, 0x0 }, /* #54 */
    { 0x3a3396, 0x3a3382, 0xdaa9e2cc, 0xcbfd06cb, 0x1154e407, 0x0 }, /* #55 */
    { 0x251056, 0x251082, 0xc23883c0, 0xb8bbcbd6, 0x7a834816, 0x0 }, /* #56 */
    { 0x232093, 0x232006, 0x37e5767d, 0x4d25209c, 0x7ac056e1, 0x0 }, /* #57 */
    { 0x1f5607, 0x1f5602, 0x8ce69396, 0x509ebb43, 0xdc7828d5, 0x0 }, /* #58 */
    { 0x211bd6, 0x211302, 0x63d61c07, 0x76d216b0, 0x15040ab7, 0x0 }, /* #59 */
    { 0x041a47, 0x041202, 0x66e05d28, 0x1b5358cd, 0x7db305e5, 0x0 }, /* #60 */
    { 0x1d64d2, 0x1d6482, 0xcacdc88a, 0x983bd8c1, 0x52f6104b, 0x0 }, /* #61 */
    { 0x374cd6, 0x374486, 0xe73b9f9d, 0x9f031614, 0x78388989, 0x0 }, /* #62 */
    { 0x383b12, 0x383302, 0x3209264a, 0x0194b3c2, 0x339d9588, 0x0 }, /* #63 */
    { 0x256087, 0x256086, 0x7ef042ff, 0xe531b13c, 0x9bc1f3c3, 0x0 }, /* #64 */
    { 0x035293, 0x035206, 0xaa309608, 0x2feacb88, 0x85da5d80, 0x0 }, /* #65 */
    { 0x022e56, 0x022682, 0x484a0eee, 0xbf9ecff8, 0xf7d4c116, 0x0 }, /* #66 */
    { 0x0803c3, 0x080382, 0x97cf60dc, 0x971d8857, 0x00d2e88b, 0x0 }, /* #67 */
    { 0x007a43, 0x007202, 0x07ada8f3, 0x472278ae, 0x408fd05d, 0x0 }, /* #68 */
    { 0x3377c7, 0x337702, 0xc1314301, 0x586a7e91, 0x995b3d90, 0x0 }, /* #69 */
    { 0x2972d2, 0x297282, 0x8d9c623c, 0x9b579bfe, 0x16cbf9c2, 0x0 }, /* #70 */
    { 0x203896, 0x203086, 0x0bdc34b9, 0xfe9cb4b1, 0xf5408008, 0x0 }, /* #71 */
    { 0x2955d3, 0x295502, 0x216c3428, 0x002f3f4f, 0x21430b67, 0x0 }, /* #72 */
    { 0x011f57, 0x011706, 0xbdbb319a, 0x558362a0, 0xe838533a, 0x0 }, /* #73 */
    { 0x3a4dc6, 0x3a4586, 0x57d557ae, 0xbb782918, 0xecad7eb6, 0x0 }, /* #74 */
    { 0x385196, 0x385102, 0x5bfe0c9b, 0x7c3f5738, 0x27c15ba3, 0x0 }, /* #75 */
    { 0x194403, 0x194402, 0xecabf6bf, 0x4c80bc07, 0xa02b4ab8, 0x0 }, /* #76 */
    { 0x1260c6, 0x126086, 0x3623326b, 0xcab112b2, 0xfc9220d9, 0x0 }, /* #77 */
    { 0x140ac2, 0x140202, 0x6f773a29, 0x60dfad8f, 0x0fa897a6, 0x0 }, /* #78 */
    { 0x3c2f03, 0x3c2786, 0xfef506d6, 0x8093c03c, 0x7e66c6ea, 0x0 }, /* #79 */
    { 0x2341d2, 0x234106, 0xd6b572b0, 0x6b68c530, 0xbdddb780, 0x0 }, /* #80 */
    { 0x382896, 0x382082, 0x9c73e1b8, 0x84aea7ec, 0x18dd4654, 0x0 }, /* #81 */
    { 0x2e51c2, 0x2e5186, 0x4f31f146, 0xab06eb8b, 0xe4371acd, 0x0 }, /* #82 */
    { 0x361903, 0x361182, 0xec15e220, 0xb287c943, 0x5e922b63, 0x0 }, /* #83 */
    { 0x246957, 0x246102, 0x1f227b1c, 0x4c7f0208, 0x535d7914, 0x0 }, /* #84 */
    { 0x1a7116, 0x1a7182, 0x2555c1ab, 0xe4edd351, 0xc1b812fa, 0x0 }, /* #85 */
    { 0x120343, 0x120306, 0x945ad8b2, 0x76f81baf, 0xe2a2c31d, 0x0 }, /* #86 */
    { 0x3d3713, 0x3d3702, 0xf450fbe8, 0x077bd943, 0xf32b22ab, 0x0 }, /* #87 */
    { 0x306a17, 0x306202, 0x1bf73e3b, 0x2415e14c, 0x3fe2df77, 0x0 }, /* #88 */
    { 0x033d46, 0x033502, 0x3de0073e, 0x52cacb0b, 0x6f2acc35, 0x0 }, /* #89 */
    { 0x3d7047, 0x3d7006, 0x592ee15e, 0x5381189a, 0x0aaff9c4, 0x0 }, /* #90 */
    { 0x3843c3, 0x384306, 0xf9edbd61, 0x26f4982b, 0xdf19254a, 0x0 }, /* #91 */
    { 0x320717, 0x320706, 0x7439df6c, 0x330edc63, 0x4737030f, 0x0 }, /* #92 */
    { 0x2e4b56, 0x2e4302, 0x0a25e87f, 0x5f454ee3, 0x5560a69c, 0x0 }, /* #93 */
    { 0x1665d3, 0x166586, 0xa243e8ed, 0xa8d94463, 0x0a9aac8e, 0x0 }, /* #94 */
    { 0x2c5f86, 0x2c5702, 0x3e52e346, 0x22065276, 0x1c54b130, 0x0 }, /* #95 */
};
uint32_t const g_cTests_xor_u32 = RT_ELEMENTS(g_aTests_xor_u32);

BINU32_TEST_T const g_aTests_xor_u32_locked[] =
{
    { 0x007416, 0x007446, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #0 */
    { 0x0b5493, 0x0b5446, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x050c52, 0x050446, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #2 */
    { 0x074752, 0x074746, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #3 */
    { 0x300246, 0x300246, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #4 */
    { 0x2a53c7, 0x2a5346, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x053a42, 0x053282, 0x8c26548c, 0x8c26548c, 0x00000000, 0x0 }, /* #6 */
    { 0x2b4dd2, 0x2b4582, 0xd7cbb434, 0xd7cbb434, 0x00000000, 0x0 }, /* #7 */
    { 0x2a69d7, 0x2a6186, 0x946b8505, 0x946b8505, 0x00000000, 0x0 }, /* #8 */
    { 0x124a57, 0x124286, 0x9d5d87cc, 0x9d5d87cc, 0x00000000, 0x0 }, /* #9 */
    { 0x303393, 0x303386, 0xcb6b02e7, 0xcb6b02e7, 0x00000000, 0x0 }, /* #10 */
    { 0x0d5582, 0x0d5506, 0x185babf6, 0x185babf6, 0x00000000, 0x0 }, /* #11 */
    { 0x220643, 0x220602, 0xa9e51a94, 0x6dffd56b, 0xc41acfff, 0x0 }, /* #12 */
    { 0x185483, 0x185482, 0x7c7303f0, 0xcdd56229, 0xb1a661d9, 0x0 }, /* #13 */
    { 0x1545c3, 0x154586, 0x56506eec, 0xd6c8547d, 0x80983a91, 0x0 }, /* #14 */
    { 0x2116c3, 0x211606, 0x4782fcc2, 0x19df0877, 0x5e5df4b5, 0x0 }, /* #15 */
    { 0x204897, 0x204086, 0x54e404bb, 0x91e1f460, 0xc505f0db, 0x0 }, /* #16 */
    { 0x232ed2, 0x232602, 0x13c2c1a5, 0x2c9032fe, 0x3f52f35b, 0x0 }, /* #17 */
    { 0x284c03, 0x284402, 0x3616d204, 0x5adc51d6, 0x6cca83d2, 0x0 }, /* #18 */
    { 0x126743, 0x126786, 0x9871a223, 0xbb53c096, 0x232262b5, 0x0 }, /* #19 */
    { 0x085002, 0x085086, 0x21fc619a, 0xc29e8a3c, 0xe362eba6, 0x0 }, /* #20 */
    { 0x0c5446, 0x0c5406, 0x7b14db12, 0x36b55981, 0x4da18293, 0x0 }, /* #21 */
    { 0x166bc7, 0x166382, 0xe486d4a7, 0xde8006d5, 0x3a06d272, 0x0 }, /* #22 */
    { 0x2c7bc6, 0x2c7386, 0xb3ba7235, 0x85bd8e28, 0x3607fc1d, 0x0 }, /* #23 */
    { 0x164743, 0x164702, 0xc9ef25f1, 0x524b1062, 0x9ba43593, 0x0 }, /* #24 */
    { 0x3916c6, 0x391682, 0x6e872eb9, 0xa09f6b34, 0xce18458d, 0x0 }, /* #25 */
    { 0x3943c7, 0x394306, 0x5d49b0d0, 0x1b78a29a, 0x4631124a, 0x0 }, /* #26 */
    { 0x0a67c2, 0x0a6782, 0x78b67ae5, 0xa0f3d5d6, 0xd845af33, 0x0 }, /* #27 */
    { 0x002b07, 0x002386, 0xff673606, 0x8b22fb6c, 0x7445cd6a, 0x0 }, /* #28 */
    { 0x091916, 0x091106, 0x03d43d69, 0x63b27bfc, 0x60664695, 0x0 }, /* #29 */
    { 0x1b7382, 0x1b7382, 0x1b1b8992, 0x9711e7f1, 0x8c0a6e63, 0x0 }, /* #30 */
    { 0x280113, 0x280186, 0xc56f868a, 0xfe6a1cf9, 0x3b059a73, 0x0 }, /* #31 */
    { 0x273c56, 0x273406, 0xcb798615, 0x48def40a, 0x83a7721f, 0x0 }, /* #32 */
    { 0x170197, 0x170102, 0x86c0d2b6, 0x703041ea, 0xf6f0935c, 0x0 }, /* #33 */
    { 0x1e2f97, 0x1e2786, 0x7752677d, 0xcc207d42, 0xbb721a3f, 0x0 }, /* #34 */
    { 0x014842, 0x014002, 0x8c4b9d22, 0x29240161, 0xa56f9c43, 0x0 }, /* #35 */
    { 0x3149c6, 0x314102, 0x9c7b813e, 0x7d1244e5, 0xe169c5db, 0x0 }, /* #36 */
    { 0x315803, 0x315006, 0x39906483, 0x5398c084, 0x6a08a407, 0x0 }, /* #37 */
    { 0x000742, 0x000782, 0x27447b6b, 0xd3d91c0e, 0xf49d6765, 0x0 }, /* #38 */
    { 0x2a7442, 0x2a7486, 0x575ac080, 0x99820f93, 0xced8cf13, 0x0 }, /* #39 */
    { 0x3f1f42, 0x3f1702, 0xbcf9f9d1, 0x208f9164, 0x9c7668b5, 0x0 }, /* #40 */
    { 0x072f06, 0x072706, 0x31a42974, 0x4fbe66c9, 0x7e1a4fbd, 0x0 }, /* #41 */
    { 0x265086, 0x265002, 0xaf3165d7, 0x27710c92, 0x88406945, 0x0 }, /* #42 */
    { 0x3d4ec6, 0x3d4606, 0x6be737da, 0x6cbf46e8, 0x07587132, 0x0 }, /* #43 */
    { 0x3e4313, 0x3e4306, 0x8e2bde4d, 0x46a97647, 0xc882a80a, 0x0 }, /* #44 */
    { 0x335fc7, 0x335702, 0xa71faa45, 0x39f449ba, 0x9eebe3ff, 0x0 }, /* #45 */
    { 0x055396, 0x055386, 0x32ba8627, 0x9ec07bcc, 0xac7afdeb, 0x0 }, /* #46 */
    { 0x3c6896, 0x3c6086, 0x56edae3e, 0x8c8a7c3f, 0xda67d201, 0x0 }, /* #47 */
    { 0x0036c3, 0x003686, 0x4e9323c9, 0x9a6c9909, 0xd4ffbac0, 0x0 }, /* #48 */
    { 0x1a0042, 0x1a0006, 0x199d8459, 0x54206d09, 0x4dbde950, 0x0 }, /* #49 */
    { 0x080ed6, 0x080606, 0xadeb46e0, 0x1eaec1b1, 0xb3458751, 0x0 }, /* #50 */
    { 0x0a1657, 0x0a1682, 0xd33151dd, 0x8a1eb343, 0x592fe29e, 0x0 }, /* #51 */
    { 0x204486, 0x204486, 0x7ac58eef, 0xc7573555, 0xbd92bbba, 0x0 }, /* #52 */
    { 0x1d7486, 0x1d7402, 0xcdf9fd14, 0x171f3289, 0xdae6cf9d, 0x0 }, /* #53 */
    { 0x3e6a17, 0x3e6206, 0xbd6cc7c4, 0x5f74dd6c, 0xe2181aa8, 0x0 }, /* #54 */
    { 0x043a43, 0x043282, 0x88c42308, 0x9713d8fd, 0x1fd7fbf5, 0x0 }, /* #55 */
    { 0x246086, 0x246002, 0xf57c5126, 0x595d62d5, 0xac2133f3, 0x0 }, /* #56 */
    { 0x061a43, 0x061202, 0xeec684d2, 0x601fceec, 0x8ed94a3e, 0x0 }, /* #57 */
    { 0x0b3302, 0x0b3382, 0x7782e5d6, 0xb72463f7, 0xc0a68621, 0x0 }, /* #58 */
    { 0x251a93, 0x251286, 0x576e4ad2, 0xdbed71c5, 0x8c833b17, 0x0 }, /* #59 */
    { 0x2d3b07, 0x2d3386, 0x03022c4c, 0x9a7682e7, 0x9974aeab, 0x0 }, /* #60 */
    { 0x082d97, 0x082582, 0x0673021e, 0x9dc56bba, 0x9bb669a4, 0x0 }, /* #61 */
    { 0x2367d6, 0x236786, 0xb2015d64, 0xe7bb6ea6, 0x55ba33c2, 0x0 }, /* #62 */
    { 0x0b7b13, 0x0b7302, 0x929efcb1, 0x4ced9229, 0xde736e98, 0x0 }, /* #63 */
    { 0x275dc2, 0x275582, 0xa96e761f, 0xdfb14a9e, 0x76df3c81, 0x0 }, /* #64 */
    { 0x3875c2, 0x387586, 0xa2858a1c, 0x8e7e2fa3, 0x2cfba5bf, 0x0 }, /* #65 */
    { 0x2c0556, 0x2c0586, 0x29903a66, 0x8ba243f9, 0xa232799f, 0x0 }, /* #66 */
    { 0x1b5f96, 0x1b5706, 0x7a006cc5, 0x17b2e782, 0x6db28b47, 0x0 }, /* #67 */
    { 0x0b3d52, 0x0b3502, 0x62d1afee, 0x3a811a32, 0x5850b5dc, 0x0 }, /* #68 */
    { 0x115d17, 0x115506, 0x7dbb3b81, 0x71074eaf, 0x0cbc752e, 0x0 }, /* #69 */
    { 0x312792, 0x312706, 0x305769e6, 0x74aeab33, 0x44f9c2d5, 0x0 }, /* #70 */
    { 0x3f7f12, 0x3f7706, 0x2b9f4641, 0x67618774, 0x4cfec135, 0x0 }, /* #71 */
    { 0x2d0387, 0x2d0302, 0x911f21c8, 0x65cc396b, 0xf4d318a3, 0x0 }, /* #72 */
    { 0x396f57, 0x396782, 0xc3612545, 0xb756581c, 0x74377d59, 0x0 }, /* #73 */
    { 0x1a1846, 0x1a1006, 0x5c630c1c, 0x6f301dcc, 0x335311d0, 0x0 }, /* #74 */
    { 0x253496, 0x253402, 0xd77628eb, 0x0888ab75, 0xdffe839e, 0x0 }, /* #75 */
    { 0x2f3fc7, 0x2f3786, 0xe3b22fa3, 0xea7479c9, 0x09c6566a, 0x0 }, /* #76 */
    { 0x0b4256, 0x0b4282, 0x55c198b8, 0xa8166357, 0xfdd7fbef, 0x0 }, /* #77 */
    { 0x320f47, 0x320782, 0x97e28d15, 0xb271aba8, 0x259326bd, 0x0 }, /* #78 */
    { 0x066883, 0x066006, 0x078f7e98, 0x7df8637b, 0x7a771de3, 0x0 }, /* #79 */
    { 0x1c78c2, 0x1c7082, 0xa57c02d2, 0xe34a3aec, 0x4636383e, 0x0 }, /* #80 */
    { 0x2c1946, 0x2c1182, 0xf288b357, 0xfc2de29b, 0x0ea551cc, 0x0 }, /* #81 */
    { 0x1e1c52, 0x1e1402, 0x91fb015b, 0x5c0e8707, 0xcdf5865c, 0x0 }, /* #82 */
    { 0x381bc3, 0x381306, 0xb0f7d4e1, 0x0b93dd12, 0xbb6409f3, 0x0 }, /* #83 */
    { 0x217c06, 0x217482, 0x4b64c776, 0xf5a81bb6, 0xbeccdcc0, 0x0 }, /* #84 */
    { 0x321c86, 0x321482, 0x3d4c867f, 0xa6e88bcd, 0x9ba40db2, 0x0 }, /* #85 */
    { 0x304c42, 0x304482, 0xa63aff66, 0x83225204, 0x2518ad62, 0x0 }, /* #86 */
    { 0x0b5ac6, 0x0b5286, 0x8e7e5281, 0xf34a8069, 0x7d34d2e8, 0x0 }, /* #87 */
    { 0x2a20d6, 0x2a2086, 0xbdc89a0e, 0x8a6a3905, 0x37a2a30b, 0x0 }, /* #88 */
    { 0x375b83, 0x375386, 0x55599e08, 0xce6530ca, 0x9b3caec2, 0x0 }, /* #89 */
    { 0x354182, 0x354182, 0x91e30663, 0xbc5495cd, 0x2db793ae, 0x0 }, /* #90 */
    { 0x170a43, 0x170286, 0x09579e1c, 0xfed40541, 0xf7839b5d, 0x0 }, /* #91 */
    { 0x2b4b46, 0x2b4382, 0xfde4ed93, 0xbfc4b9ce, 0x4220545d, 0x0 }, /* #92 */
    { 0x1c0f83, 0x1c0786, 0xfb1a682a, 0xf3db1133, 0x08c17919, 0x0 }, /* #93 */
    { 0x157e97, 0x157682, 0xa4390c2d, 0xd0b7054f, 0x748e0962, 0x0 }, /* #94 */
    { 0x217482, 0x217402, 0x8b64eccc, 0x0386f66b, 0x88e21aa7, 0x0 }, /* #95 */
};
uint32_t const g_cTests_xor_u32_locked = RT_ELEMENTS(g_aTests_xor_u32_locked);

BINU32_TEST_T const g_aTests_and_u32[] =
{
    { 0x300296, 0x300246, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #0 */
    { 0x2b3c47, 0x2b3446, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x352802, 0x352046, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #2 */
    { 0x180e43, 0x180646, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #3 */
    { 0x3e7656, 0x3e7646, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #4 */
    { 0x3231c6, 0x323146, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x2005d7, 0x200546, 0xb4472f84, 0x00000000, 0x00000000, 0x0 }, /* #6 */
    { 0x265612, 0x265646, 0xc6d414eb, 0x00000000, 0x00000000, 0x0 }, /* #7 */
    { 0x211757, 0x211746, 0x90790141, 0x00000000, 0x00000000, 0x0 }, /* #8 */
    { 0x3b7b53, 0x3b7346, 0xe7d2c6dc, 0x00000000, 0x00000000, 0x0 }, /* #9 */
    { 0x292b52, 0x292346, 0x927cc133, 0x00000000, 0x00000000, 0x0 }, /* #10 */
    { 0x291c43, 0x291446, 0x5a215ff1, 0x00000000, 0x00000000, 0x0 }, /* #11 */
    { 0x1e0693, 0x1e0602, 0x4f44a6a0, 0x06408220, 0x26fadb78, 0x0 }, /* #12 */
    { 0x3a0f53, 0x3a0702, 0xa77547e5, 0x054107a1, 0x5d49afa9, 0x0 }, /* #13 */
    { 0x1769d2, 0x176106, 0x0750b739, 0x0040a230, 0xd849a270, 0x0 }, /* #14 */
    { 0x210fc3, 0x210702, 0x3218cfdc, 0x02180298, 0x877c12bb, 0x0 }, /* #15 */
    { 0x3a0512, 0x3a0506, 0xa541461e, 0x0440000a, 0x16de29aa, 0x0 }, /* #16 */
    { 0x2a1e93, 0x2a1602, 0x2c1b8c47, 0x08090804, 0x99c90b2c, 0x0 }, /* #17 */
    { 0x256916, 0x256102, 0xaff9c7b8, 0x0f48c4a8, 0x0f48c4ae, 0x0 }, /* #18 */
    { 0x315e87, 0x315606, 0xeb1e9435, 0x220e9030, 0x22aeb27a, 0x0 }, /* #19 */
    { 0x3a3c57, 0x3a3406, 0x5ec08255, 0x04408005, 0x8473e82f, 0x0 }, /* #20 */
    { 0x342dd7, 0x342502, 0x45ba4453, 0x04180001, 0x26592aa9, 0x0 }, /* #21 */
    { 0x0279d6, 0x027102, 0x35c4ba23, 0x05001a23, 0xcd385a33, 0x0 }, /* #22 */
    { 0x3b7802, 0x3b7006, 0x31d0e0e5, 0x11c04044, 0x9dca5646, 0x0 }, /* #23 */
    { 0x0e6bd2, 0x0e6306, 0x4322b6ba, 0x4302b4b2, 0xdf93fcf6, 0x0 }, /* #24 */
    { 0x1b1946, 0x1b1182, 0xd49437b6, 0xd0943302, 0xf2df334a, 0x0 }, /* #25 */
    { 0x3104d6, 0x310402, 0x4618fdd3, 0x0210cd43, 0x9a15cf67, 0x0 }, /* #26 */
    { 0x2a4047, 0x2a4002, 0x36822e66, 0x14800640, 0xddc0d648, 0x0 }, /* #27 */
    { 0x177052, 0x177006, 0xad074797, 0x25034190, 0x27cbf9d0, 0x0 }, /* #28 */
    { 0x072047, 0x072002, 0x7e1b0a05, 0x4a1b0001, 0x4b3b11a9, 0x0 }, /* #29 */
    { 0x0f1f06, 0x0f1786, 0xf8f8ead8, 0x9060ca00, 0x9362cb05, 0x0 }, /* #30 */
    { 0x392797, 0x392706, 0x471057e2, 0x42005122, 0x5a48592b, 0x0 }, /* #31 */
    { 0x297d03, 0x297502, 0x23fb1b16, 0x20211a04, 0x6c211a44, 0x0 }, /* #32 */
    { 0x330f87, 0x330782, 0xef2a3042, 0xeb083002, 0xeb5d7f12, 0x0 }, /* #33 */
    { 0x3b0943, 0x3b0106, 0x36d2d511, 0x10100100, 0xd91023e8, 0x0 }, /* #34 */
    { 0x281082, 0x281006, 0x6b6b8bb5, 0x436b0911, 0x53ef195b, 0x0 }, /* #35 */
    { 0x020ed3, 0x020606, 0x3c752b71, 0x28342830, 0xe83e7cba, 0x0 }, /* #36 */
    { 0x1a7b92, 0x1a7302, 0x8eeddc6f, 0x0e8d882f, 0x5f8dabaf, 0x0 }, /* #37 */
    { 0x3777c2, 0x377706, 0xca5e1cd5, 0x00080c44, 0x05286c4e, 0x0 }, /* #38 */
    { 0x2f03c6, 0x2f0302, 0xc31d73f1, 0x031961e0, 0x0399ede6, 0x0 }, /* #39 */
    { 0x0b4852, 0x0b4086, 0xd3c85255, 0x91400041, 0x9d65a1e1, 0x0 }, /* #40 */
    { 0x171dc2, 0x171582, 0x88495378, 0x88080010, 0xdcaea891, 0x0 }, /* #41 */
    { 0x390f47, 0x390702, 0x9f3d1449, 0x01311440, 0x41715f70, 0x0 }, /* #42 */
    { 0x2f6d46, 0x2f6506, 0x7d5367c7, 0x4d1161c3, 0x4dbd61db, 0x0 }, /* #43 */
    { 0x3b5d42, 0x3b5502, 0xa785b7db, 0x2385b708, 0x63bfb708, 0x0 }, /* #44 */
    { 0x146597, 0x146506, 0x514cb4d1, 0x114c0000, 0x9bcc0b06, 0x0 }, /* #45 */
    { 0x296703, 0x296706, 0x9cc24562, 0x0cc04022, 0x4ee8da33, 0x0 }, /* #46 */
    { 0x116bd7, 0x116306, 0x7b31a790, 0x50200400, 0xd02e1460, 0x0 }, /* #47 */
    { 0x2a22c3, 0x2a2202, 0xf0a45927, 0x10201107, 0x12233707, 0x0 }, /* #48 */
    { 0x160f02, 0x160706, 0x760aae47, 0x20082844, 0x20d83844, 0x0 }, /* #49 */
    { 0x3464c7, 0x346486, 0xa968b27c, 0xa9282228, 0xafab62aa, 0x0 }, /* #50 */
    { 0x060d87, 0x060586, 0xe84697a7, 0xe0409784, 0xe068ffdc, 0x0 }, /* #51 */
    { 0x186153, 0x186102, 0x996dfaad, 0x1049288c, 0x345b29de, 0x0 }, /* #52 */
    { 0x1671c6, 0x167106, 0xe60fa0ba, 0x2202a090, 0x2242e5d5, 0x0 }, /* #53 */
    { 0x1e3f53, 0x1e3702, 0xfb4e773d, 0x50482608, 0x5068aec8, 0x0 }, /* #54 */
    { 0x092703, 0x092786, 0xf4d77726, 0x94402500, 0x9568ad98, 0x0 }, /* #55 */
    { 0x182a03, 0x182206, 0x747d9aa2, 0x244d9282, 0xa54df792, 0x0 }, /* #56 */
    { 0x1b29c7, 0x1b2102, 0xc63ab2f3, 0x041a3223, 0x0d1b332f, 0x0 }, /* #57 */
    { 0x241c93, 0x241406, 0xbf021911, 0x11020811, 0x5123cc99, 0x0 }, /* #58 */
    { 0x073f92, 0x073702, 0x909b505f, 0x10114054, 0x1531e2f4, 0x0 }, /* #59 */
    { 0x215cc3, 0x215486, 0xc9e81fce, 0xc8281200, 0xee3cb201, 0x0 }, /* #60 */
    { 0x0d3e97, 0x0d3682, 0x9bf27b7d, 0x91e06b79, 0xb1e1eb7b, 0x0 }, /* #61 */
    { 0x2f3ec3, 0x2f3602, 0xea988b13, 0x4a800913, 0x5ee259ff, 0x0 }, /* #62 */
    { 0x2904d6, 0x290482, 0xb41324df, 0x900304cd, 0x91c7cded, 0x0 }, /* #63 */
    { 0x2f0007, 0x2f0086, 0xe8f8915a, 0x88e09012, 0x9ee1f612, 0x0 }, /* #64 */
    { 0x1a73c7, 0x1a7302, 0xfc83b192, 0x54023102, 0x566e3347, 0x0 }, /* #65 */
    { 0x3e0586, 0x3e0502, 0xdc981184, 0x58900080, 0x7a902280, 0x0 }, /* #66 */
    { 0x265dd3, 0x265506, 0xfcad87a4, 0x54010284, 0x55431a84, 0x0 }, /* #67 */
    { 0x160552, 0x160502, 0xd20aadff, 0x020a292f, 0x0aba792f, 0x0 }, /* #68 */
    { 0x1d58c3, 0x1d5006, 0x29de5072, 0x080e5022, 0x5e2e73a6, 0x0 }, /* #69 */
    { 0x2f73c3, 0x2f7306, 0x95134f8c, 0x14134084, 0x361f70a7, 0x0 }, /* #70 */
    { 0x0d34c7, 0x0d3406, 0xc72f9043, 0x02299003, 0x1a29fa87, 0x0 }, /* #71 */
    { 0x0714d6, 0x071406, 0x1a4cf08b, 0x08488088, 0x6dc984b8, 0x0 }, /* #72 */
    { 0x2c6257, 0x2c6202, 0x0217c6c8, 0x0217c480, 0x423fddb5, 0x0 }, /* #73 */
    { 0x3c0092, 0x3c0086, 0xb6cc02c8, 0xb44800c0, 0xbd7920d3, 0x0 }, /* #74 */
    { 0x101d07, 0x101502, 0x6b077446, 0x29035004, 0x3933db15, 0x0 }, /* #75 */
    { 0x1c4713, 0x1c4706, 0x5293683c, 0x40834830, 0x4987ccf0, 0x0 }, /* #76 */
    { 0x175892, 0x175086, 0x811e70d4, 0x811000d4, 0xab100cf5, 0x0 }, /* #77 */
    { 0x206e43, 0x206686, 0x80e7daba, 0x80e61830, 0xd3fe3c74, 0x0 }, /* #78 */
    { 0x362357, 0x362306, 0x5c0f5aa2, 0x08040200, 0xaa648341, 0x0 }, /* #79 */
    { 0x1e3996, 0x1e3182, 0xfcb6d977, 0xcc361876, 0xcd773cfe, 0x0 }, /* #80 */
    { 0x2115d7, 0x211582, 0xcf76c6a0, 0x85060620, 0xa5073e79, 0x0 }, /* #81 */
    { 0x267547, 0x267506, 0x3291e114, 0x20800014, 0xa8e81e5d, 0x0 }, /* #82 */
    { 0x012046, 0x012006, 0x6184f16b, 0x61808022, 0x6b8b80a6, 0x0 }, /* #83 */
    { 0x210316, 0x210306, 0x92b9fe08, 0x1020f800, 0x1024f801, 0x0 }, /* #84 */
    { 0x117bd2, 0x117306, 0x7c5bb9f8, 0x10428850, 0x11c2c854, 0x0 }, /* #85 */
    { 0x3f0a02, 0x3f0202, 0x403b5f0f, 0x00111002, 0x19959012, 0x0 }, /* #86 */
    { 0x211b92, 0x211302, 0x2392de4c, 0x21800a40, 0x39e82ac2, 0x0 }, /* #87 */
    { 0x3a2d47, 0x3a2502, 0x0fea87c9, 0x05688289, 0x1569829f, 0x0 }, /* #88 */
    { 0x282dd6, 0x282506, 0xde4160ba, 0x02416012, 0x2255f256, 0x0 }, /* #89 */
    { 0x0432d3, 0x043282, 0xb1664f01, 0x91004b01, 0xdd184bc9, 0x0 }, /* #90 */
    { 0x324d02, 0x324506, 0x19567056, 0x10564044, 0x7677c865, 0x0 }, /* #91 */
    { 0x2e4392, 0x2e4306, 0x65cb67ac, 0x618060a0, 0x6b9478b0, 0x0 }, /* #92 */
    { 0x0c2687, 0x0c2682, 0xdca1f07a, 0x9481304a, 0xb78b30cf, 0x0 }, /* #93 */
    { 0x2b7d83, 0x2b7502, 0x34c68831, 0x14040831, 0x9e2c6cb9, 0x0 }, /* #94 */
    { 0x323447, 0x323486, 0xdc9baed3, 0xcc832a12, 0xcfa36a12, 0x0 }, /* #95 */
};
uint32_t const g_cTests_and_u32 = RT_ELEMENTS(g_aTests_and_u32);

BINU32_TEST_T const g_aTests_and_u32_locked[] =
{
    { 0x146b53, 0x146346, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #0 */
    { 0x104103, 0x104146, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x2e3012, 0x2e3046, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #2 */
    { 0x3a75c2, 0x3a7546, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #3 */
    { 0x0d3ad7, 0x0d3246, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #4 */
    { 0x1e1242, 0x1e1246, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x2b6313, 0x2b6346, 0x05000067, 0x00000000, 0x00000000, 0x0 }, /* #6 */
    { 0x250e57, 0x250646, 0x2921afe7, 0x00000000, 0x00000000, 0x0 }, /* #7 */
    { 0x1512c6, 0x151246, 0x98168faa, 0x00000000, 0x00000000, 0x0 }, /* #8 */
    { 0x0e6602, 0x0e6646, 0xcdbf794a, 0x00000000, 0x00000000, 0x0 }, /* #9 */
    { 0x3f5f07, 0x3f5746, 0x607f60f3, 0x00000000, 0x00000000, 0x0 }, /* #10 */
    { 0x081cc6, 0x081446, 0xea8990e0, 0x00000000, 0x00000000, 0x0 }, /* #11 */
    { 0x224053, 0x224082, 0xdf691f27, 0xd8490702, 0xf8c94792, 0x0 }, /* #12 */
    { 0x136392, 0x136386, 0xf80c15f2, 0xd00415c0, 0xd065b5c5, 0x0 }, /* #13 */
    { 0x116607, 0x116602, 0x2214b336, 0x22042232, 0xe20722f3, 0x0 }, /* #14 */
    { 0x3a08d2, 0x3a0002, 0x1995df0c, 0x00805204, 0xc0e25286, 0x0 }, /* #15 */
    { 0x3f6116, 0x3f6186, 0x94875ed5, 0x94075444, 0x9c1ff44e, 0x0 }, /* #16 */
    { 0x1e6053, 0x1e6006, 0x001a2d9c, 0x001a0484, 0x417e5487, 0x0 }, /* #17 */
    { 0x082642, 0x082606, 0x9155d6c5, 0x11509484, 0x73f8bd8c, 0x0 }, /* #18 */
    { 0x0a66c3, 0x0a6686, 0xbbf7fc03, 0x90122c03, 0xd41a2f8f, 0x0 }, /* #19 */
    { 0x0c3796, 0x0c3706, 0xdc991472, 0x1c001042, 0x1e20dacb, 0x0 }, /* #20 */
    { 0x3f2247, 0x3f2206, 0xd0c68df4, 0x10c08514, 0x3fc9f514, 0x0 }, /* #21 */
    { 0x3447c2, 0x344706, 0x295630d4, 0x00121090, 0xd29357b8, 0x0 }, /* #22 */
    { 0x1b4092, 0x1b4002, 0xa2692b47, 0x22080140, 0x769c4148, 0x0 }, /* #23 */
    { 0x1b10d2, 0x1b1002, 0x3cc07798, 0x34407780, 0x376d7fc5, 0x0 }, /* #24 */
    { 0x1e2bd3, 0x1e2302, 0xca48f162, 0x00488120, 0x30498125, 0x0 }, /* #25 */
    { 0x277942, 0x277106, 0x3b9b6747, 0x139b6042, 0x97bff8da, 0x0 }, /* #26 */
    { 0x374683, 0x374606, 0x3dbd9840, 0x25181000, 0xa55816b1, 0x0 }, /* #27 */
    { 0x2d2206, 0x2d2206, 0x08cfa845, 0x08482000, 0x7978338a, 0x0 }, /* #28 */
    { 0x1f1813, 0x1f1006, 0xb4dc8d98, 0x34908c18, 0x7693bc1e, 0x0 }, /* #29 */
    { 0x2a3192, 0x2a3182, 0xa4166d9d, 0xa4166d19, 0xf497ff79, 0x0 }, /* #30 */
    { 0x0e3843, 0x0e3006, 0x5b677d1d, 0x1a010414, 0xbe0186d6, 0x0 }, /* #31 */
    { 0x042e06, 0x042606, 0xc85ca0ea, 0x080c00c0, 0x198f5fd1, 0x0 }, /* #32 */
    { 0x346bd6, 0x346302, 0x12eeb8b6, 0x126038a2, 0xb3717eeb, 0x0 }, /* #33 */
    { 0x0d2e57, 0x0d2606, 0x49009117, 0x49008100, 0xdd8ea1a8, 0x0 }, /* #34 */
    { 0x121ec3, 0x121606, 0x3b4f3c0e, 0x03421406, 0x03c21406, 0x0 }, /* #35 */
    { 0x3a5b96, 0x3a5382, 0xb6654ec0, 0x86200040, 0x8638b179, 0x0 }, /* #36 */
    { 0x251a96, 0x251202, 0xedcde94f, 0x488c8146, 0x5abe8166, 0x0 }, /* #37 */
    { 0x224d56, 0x224506, 0xa4ced3bf, 0x24cc039f, 0x34ec039f, 0x0 }, /* #38 */
    { 0x3945d3, 0x394506, 0x38d09eef, 0x18809827, 0x188af927, 0x0 }, /* #39 */
    { 0x240a06, 0x240202, 0x5b8328e5, 0x53010801, 0x53110a09, 0x0 }, /* #40 */
    { 0x2c0047, 0x2c0002, 0x45393899, 0x44011810, 0x6c015976, 0x0 }, /* #41 */
    { 0x244a96, 0x244286, 0x99ab7560, 0x91212100, 0x9325a10a, 0x0 }, /* #42 */
    { 0x260a83, 0x260202, 0x430d926f, 0x43008064, 0xc302ec64, 0x0 }, /* #43 */
    { 0x143247, 0x143202, 0x10f409a5, 0x00600820, 0xab690868, 0x0 }, /* #44 */
    { 0x3c1d52, 0x3c1506, 0x2c5a25a4, 0x28520084, 0xbbd688c5, 0x0 }, /* #45 */
    { 0x342a57, 0x342286, 0xefb242b1, 0xe4b00211, 0xe4b9bb11, 0x0 }, /* #46 */
    { 0x2c4112, 0x2c4102, 0x63bdb36b, 0x00843061, 0x948638e5, 0x0 }, /* #47 */
    { 0x0d1d93, 0x0d1506, 0xab29c73a, 0x20204622, 0x34e45e26, 0x0 }, /* #48 */
    { 0x107b13, 0x107382, 0xe238e7c2, 0xc2104280, 0xc2d74aa8, 0x0 }, /* #49 */
    { 0x1406c6, 0x140606, 0xce8ea7e1, 0x448aa7c0, 0x64abafde, 0x0 }, /* #50 */
    { 0x1d1f53, 0x1d1706, 0x1e4565da, 0x02056042, 0x4215e047, 0x0 }, /* #51 */
    { 0x3375c7, 0x337586, 0xadc6e189, 0x89c0a009, 0xcbd0ae3d, 0x0 }, /* #52 */
    { 0x272112, 0x272106, 0x2b572288, 0x00130200, 0x90bb1f75, 0x0 }, /* #53 */
    { 0x3a6d83, 0x3a6502, 0x3a225f8b, 0x38220d80, 0xbcee0de0, 0x0 }, /* #54 */
    { 0x293547, 0x293506, 0xc3cf1706, 0x008b0300, 0x309b2338, 0x0 }, /* #55 */
    { 0x0a1242, 0x0a1286, 0xe6c79611, 0xa6429611, 0xaf52def7, 0x0 }, /* #56 */
    { 0x322792, 0x322706, 0x6754a38f, 0x44440288, 0xc4e65ac8, 0x0 }, /* #57 */
    { 0x141e13, 0x141602, 0x711650ff, 0x700410e9, 0x7a04b1e9, 0x0 }, /* #58 */
    { 0x227253, 0x227206, 0xe5acbdcc, 0x65009188, 0x7743d1a8, 0x0 }, /* #59 */
    { 0x297807, 0x297006, 0x58e8d94a, 0x4868c948, 0x4e6acdfd, 0x0 }, /* #60 */
    { 0x2b1f56, 0x2b1782, 0xb08c8e68, 0x808c0408, 0x84ef449d, 0x0 }, /* #61 */
    { 0x2958d3, 0x295082, 0xe7d69f2c, 0x86c49104, 0x8ee4f157, 0x0 }, /* #62 */
    { 0x2d1f12, 0x2d1706, 0xbe5c9e62, 0x04088c42, 0x0489ed43, 0x0 }, /* #63 */
    { 0x1206c7, 0x120606, 0x819d0db3, 0x01840cb1, 0x05e48ef1, 0x0 }, /* #64 */
    { 0x0a14c2, 0x0a1402, 0x3ba3bafd, 0x2b0382a1, 0xab4782a3, 0x0 }, /* #65 */
    { 0x260c82, 0x260486, 0xfba6816b, 0xf0a20048, 0xf0bb0458, 0x0 }, /* #66 */
    { 0x097dd6, 0x097502, 0x952240b6, 0x04204086, 0x4cb1728f, 0x0 }, /* #67 */
    { 0x184c82, 0x184406, 0xff737f14, 0x37037b14, 0x370b7bd4, 0x0 }, /* #68 */
    { 0x322b02, 0x322306, 0x73510123, 0x23510122, 0x2b5149a2, 0x0 }, /* #69 */
    { 0x3c2747, 0x3c2702, 0x86e528cb, 0x04c00802, 0x7dc29f26, 0x0 }, /* #70 */
    { 0x273ad7, 0x273206, 0x4dd9f665, 0x40900021, 0x52b601b3, 0x0 }, /* #71 */
    { 0x143c02, 0x143402, 0x61a32e17, 0x21032213, 0xa74362b3, 0x0 }, /* #72 */
    { 0x2e7106, 0x2e7106, 0x80d9d793, 0x00999611, 0x5e99be1d, 0x0 }, /* #73 */
    { 0x194c52, 0x194406, 0x05a3151f, 0x05021412, 0x875a9ed2, 0x0 }, /* #74 */
    { 0x1e01d2, 0x1e0182, 0x8ea790cb, 0x828710c2, 0xe28f55d6, 0x0 }, /* #75 */
    { 0x367293, 0x367202, 0xdaf1637d, 0x48914131, 0x69975531, 0x0 }, /* #76 */
    { 0x283943, 0x283182, 0x83ce242e, 0x838e0426, 0x979f9437, 0x0 }, /* #77 */
    { 0x397897, 0x397006, 0x3b41d565, 0x1a018065, 0x5ebf8aef, 0x0 }, /* #78 */
    { 0x007802, 0x007086, 0x9068fb69, 0x9060f041, 0xf0f6f445, 0x0 }, /* #79 */
    { 0x294782, 0x294782, 0x86015ab4, 0x82000010, 0xfbc20510, 0x0 }, /* #80 */
    { 0x0b3302, 0x0b3386, 0xeeffd1f6, 0xc8e58066, 0xd8e5ae6f, 0x0 }, /* #81 */
    { 0x000712, 0x000706, 0x0ac22b52, 0x00820b12, 0x30b79f32, 0x0 }, /* #82 */
    { 0x265e03, 0x265602, 0x44079ba4, 0x00011980, 0x0af95dc8, 0x0 }, /* #83 */
    { 0x0e6dd3, 0x0e6506, 0x169adfd0, 0x00901100, 0x21951122, 0x0 }, /* #84 */
    { 0x340e82, 0x340602, 0x83f2b0a7, 0x01709025, 0x6571df65, 0x0 }, /* #85 */
    { 0x1130d7, 0x113002, 0x47e12a39, 0x00212810, 0x383ffd92, 0x0 }, /* #86 */
    { 0x3f35c3, 0x3f3506, 0xa61db923, 0x061db122, 0x57bfb732, 0x0 }, /* #87 */
    { 0x281c13, 0x281482, 0xa01c8b91, 0xa0088801, 0xa189fc01, 0x0 }, /* #88 */
    { 0x1f7353, 0x1f7382, 0x8ecb1b11, 0x84830910, 0xc5978932, 0x0 }, /* #89 */
    { 0x123cd2, 0x123406, 0x9350fb16, 0x0040a114, 0x286ca1fc, 0x0 }, /* #90 */
    { 0x0706d7, 0x070606, 0x34617d6f, 0x34412841, 0x37dfaad1, 0x0 }, /* #91 */
    { 0x0e1f82, 0x0e1786, 0xedc1178c, 0xe180060c, 0xe386666c, 0x0 }, /* #92 */
    { 0x2c10d6, 0x2c1082, 0x8c3c5b74, 0x800c1154, 0x904e31d5, 0x0 }, /* #93 */
    { 0x246316, 0x246302, 0x9a238604, 0x18038204, 0x391bf275, 0x0 }, /* #94 */
    { 0x3e4557, 0x3e4502, 0x46b1944b, 0x00310001, 0xb9350815, 0x0 }, /* #95 */
};
uint32_t const g_cTests_and_u32_locked = RT_ELEMENTS(g_aTests_and_u32_locked);

BINU32_TEST_T const g_aTests_cmp_u32[] =
{
    { 0x196016, 0x196046, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #0 */
    { 0x3d5e96, 0x3d5646, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x2d7793, 0x2d7746, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #2 */
    { 0x2f2282, 0x2f2246, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #3 */
    { 0x052a57, 0x052246, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #4 */
    { 0x326f97, 0x326746, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x2d0a06, 0x2d0202, 0x15d8b65e, 0x15d8b65e, 0x00000000, 0x0 }, /* #6 */
    { 0x1a1393, 0x1a1302, 0x7abbd9ce, 0x7abbd9ce, 0x00000000, 0x0 }, /* #7 */
    { 0x0a6142, 0x0a6102, 0x307840ea, 0x307840ea, 0x00000000, 0x0 }, /* #8 */
    { 0x145503, 0x145586, 0x8a0064ca, 0x8a0064ca, 0x00000000, 0x0 }, /* #9 */
    { 0x220396, 0x220306, 0x30666112, 0x30666112, 0x00000000, 0x0 }, /* #10 */
    { 0x1e5a46, 0x1e5286, 0xe79c965c, 0xe79c965c, 0x00000000, 0x0 }, /* #11 */
    { 0x0c2556, 0x0c2502, 0x7a3468e5, 0x7a3468e5, 0x0d616943, 0x0 }, /* #12 */
    { 0x3c7193, 0x3c7912, 0x93779107, 0x93779107, 0x4e050f3c, 0x0 }, /* #13 */
    { 0x381d13, 0x381d93, 0x2ef29c64, 0x2ef29c64, 0x9a7579ee, 0x0 }, /* #14 */
    { 0x133553, 0x133512, 0xbeb993e5, 0xbeb993e5, 0x86c75aad, 0x0 }, /* #15 */
    { 0x215897, 0x215816, 0xa035b4e2, 0xa035b4e2, 0x3ffefa88, 0x0 }, /* #16 */
    { 0x2f6507, 0x2f6506, 0xe99bc9e9, 0xe99bc9e9, 0x86298931, 0x0 }, /* #17 */
    { 0x3f1b87, 0x3f1387, 0xacf732c6, 0xacf732c6, 0xce2d1cd1, 0x0 }, /* #18 */
    { 0x0b0383, 0x0b0b02, 0x99365acf, 0x99365acf, 0x6850ea78, 0x0 }, /* #19 */
    { 0x202f93, 0x202f93, 0x6ac2c144, 0x6ac2c144, 0x9bd6e4bb, 0x0 }, /* #20 */
    { 0x3f54d2, 0x3f5416, 0x3db1d056, 0x3db1d056, 0x1cd22aac, 0x0 }, /* #21 */
    { 0x0a4987, 0x0a4997, 0x725f6a81, 0x725f6a81, 0xc9bf1815, 0x0 }, /* #22 */
    { 0x0b2893, 0x0b2087, 0xa813c44a, 0xa813c44a, 0xcb3797d8, 0x0 }, /* #23 */
    { 0x3d2e07, 0x3d2686, 0xf32dfa9b, 0xf32dfa9b, 0x687a6161, 0x0 }, /* #24 */
    { 0x1b0703, 0x1b0793, 0x699bfaf3, 0x699bfaf3, 0x6bc90ba4, 0x0 }, /* #25 */
    { 0x0b3d96, 0x0b3512, 0xf63e8063, 0xf63e8063, 0xd5c4edff, 0x0 }, /* #26 */
    { 0x1319d7, 0x131997, 0x53b643f1, 0x53b643f1, 0xbbe1438c, 0x0 }, /* #27 */
    { 0x0d1fd7, 0x0d1783, 0x04a10d2f, 0x04a10d2f, 0x309a3045, 0x0 }, /* #28 */
    { 0x256586, 0x256506, 0xbee63c7d, 0xbee63c7d, 0xab46ed73, 0x0 }, /* #29 */
    { 0x0a22d3, 0x0a2207, 0x5e397660, 0x5e397660, 0xf8b9efd0, 0x0 }, /* #30 */
    { 0x002496, 0x002402, 0xeab9261f, 0xeab9261f, 0xd5be4278, 0x0 }, /* #31 */
    { 0x2572c6, 0x257292, 0xa5c24ec3, 0xa5c24ec3, 0x23470d2f, 0x0 }, /* #32 */
    { 0x1418d3, 0x141016, 0x7b60dc01, 0x7b60dc01, 0x2cbe8567, 0x0 }, /* #33 */
    { 0x3355c7, 0x335586, 0xf1a1f95f, 0xf1a1f95f, 0x6ab5c732, 0x0 }, /* #34 */
    { 0x054c17, 0x054402, 0xcb24d237, 0xcb24d237, 0xb2485aa5, 0x0 }, /* #35 */
    { 0x2d4a52, 0x2d4207, 0x252d011e, 0x252d011e, 0xac625f43, 0x0 }, /* #36 */
    { 0x287bc6, 0x287317, 0x196802bb, 0x196802bb, 0xdad5b4bc, 0x0 }, /* #37 */
    { 0x1b03d3, 0x1b0383, 0x95fc3efd, 0x95fc3efd, 0xa7aa647d, 0x0 }, /* #38 */
    { 0x3917d3, 0x391703, 0x5eeb2563, 0x5eeb2563, 0xe3032f50, 0x0 }, /* #39 */
    { 0x3b6c03, 0x3b6487, 0x14c462f5, 0x14c462f5, 0x7e31e590, 0x0 }, /* #40 */
    { 0x157ec3, 0x157e06, 0xe15eb55a, 0xe15eb55a, 0x7d76df12, 0x0 }, /* #41 */
    { 0x2d6a56, 0x2d6287, 0xdc4d73ce, 0xdc4d73ce, 0xeb7b5768, 0x0 }, /* #42 */
    { 0x362f56, 0x362f83, 0x5c088989, 0x5c088989, 0x89e06b37, 0x0 }, /* #43 */
    { 0x374347, 0x374302, 0x7506e543, 0x7506e543, 0x71ce3811, 0x0 }, /* #44 */
    { 0x242402, 0x242403, 0x3de0a90c, 0x3de0a90c, 0xbfb9bf96, 0x0 }, /* #45 */
    { 0x324e86, 0x324606, 0xe73d0e6b, 0xe73d0e6b, 0xba480589, 0x0 }, /* #46 */
    { 0x0e5e56, 0x0e5e02, 0xbd5e4c83, 0xbd5e4c83, 0x738c67e1, 0x0 }, /* #47 */
    { 0x1b38d3, 0x1b3097, 0x066a2cc7, 0x066a2cc7, 0x1e311efe, 0x0 }, /* #48 */
    { 0x383586, 0x383d06, 0x822e35f9, 0x822e35f9, 0x0c7311b7, 0x0 }, /* #49 */
    { 0x353947, 0x353193, 0x515f3ec8, 0x515f3ec8, 0x76e097cd, 0x0 }, /* #50 */
    { 0x102e16, 0x102616, 0x455fffb4, 0x455fffb4, 0x29335c55, 0x0 }, /* #51 */
    { 0x1b6e06, 0x1b6e83, 0x49f417e9, 0x49f417e9, 0x985a1fa6, 0x0 }, /* #52 */
    { 0x071c03, 0x071497, 0x260e2904, 0x260e2904, 0x581f925b, 0x0 }, /* #53 */
    { 0x222103, 0x222112, 0xee57c800, 0xee57c800, 0xaaeaec24, 0x0 }, /* #54 */
    { 0x2e7817, 0x2e7083, 0x0661c299, 0x0661c299, 0x76fc1235, 0x0 }, /* #55 */
    { 0x166583, 0x166597, 0xc293aef0, 0xc293aef0, 0xce37c2c8, 0x0 }, /* #56 */
    { 0x1960d3, 0x196802, 0xa037de3d, 0xa037de3d, 0x6e3e4827, 0x0 }, /* #57 */
    { 0x382e46, 0x382612, 0x1147c363, 0x1147c363, 0x0bd2b1ff, 0x0 }, /* #58 */
    { 0x163bc3, 0x163393, 0x19192028, 0x19192028, 0x1e54777d, 0x0 }, /* #59 */
    { 0x223582, 0x223516, 0xf6354721, 0xf6354721, 0x8b3d3ebc, 0x0 }, /* #60 */
    { 0x324396, 0x324306, 0x2a27fb23, 0x2a27fb23, 0x27dd9c30, 0x0 }, /* #61 */
    { 0x2845d3, 0x284507, 0x06ef169d, 0x06ef169d, 0xf366c8a3, 0x0 }, /* #62 */
    { 0x356d02, 0x356506, 0x352399ef, 0x352399ef, 0x22853b34, 0x0 }, /* #63 */
    { 0x1d32c6, 0x1d3a12, 0x8c2dba26, 0x8c2dba26, 0x47904567, 0x0 }, /* #64 */
    { 0x1c2c97, 0x1c2483, 0x26071c86, 0x26071c86, 0x41675246, 0x0 }, /* #65 */
    { 0x323997, 0x323197, 0x923e64c0, 0x923e64c0, 0xd1e0ead5, 0x0 }, /* #66 */
    { 0x220613, 0x220e87, 0x6590f834, 0x6590f834, 0xbd248044, 0x0 }, /* #67 */
    { 0x3d6dc2, 0x3d6512, 0x3804e345, 0x3804e345, 0x1ce6446b, 0x0 }, /* #68 */
    { 0x3f1203, 0x3f1292, 0xb91c2fb7, 0xb91c2fb7, 0x0906cdb9, 0x0 }, /* #69 */
    { 0x042b86, 0x042b83, 0x1b799c3f, 0x1b799c3f, 0x8d201f5f, 0x0 }, /* #70 */
    { 0x360456, 0x360496, 0xe9d60511, 0xe9d60511, 0x09fb017b, 0x0 }, /* #71 */
    { 0x3e0543, 0x3e0593, 0xbcb28b19, 0xbcb28b19, 0xf06a434b, 0x0 }, /* #72 */
    { 0x1a74d3, 0x1a7406, 0x49b883b1, 0x49b883b1, 0x22c8dbe0, 0x0 }, /* #73 */
    { 0x2a1706, 0x2a1712, 0xa8d09303, 0xa8d09303, 0x9c148dcc, 0x0 }, /* #74 */
    { 0x222183, 0x222106, 0xe03c90cd, 0xe03c90cd, 0xc5a3aa7d, 0x0 }, /* #75 */
    { 0x155bd2, 0x155396, 0xd2b27d59, 0xd2b27d59, 0x20d54d3c, 0x0 }, /* #76 */
    { 0x2a6056, 0x2a6007, 0x609aa8cd, 0x609aa8cd, 0xfdede6dd, 0x0 }, /* #77 */
    { 0x292983, 0x292102, 0x5f2c4387, 0x5f2c4387, 0x48f889d2, 0x0 }, /* #78 */
    { 0x207a17, 0x207293, 0xcd6154b0, 0xcd6154b0, 0xeaa38a05, 0x0 }, /* #79 */
    { 0x324846, 0x324812, 0xcb8670c3, 0xcb8670c3, 0x5abda70e, 0x0 }, /* #80 */
    { 0x225087, 0x225092, 0xc2b491e1, 0xc2b491e1, 0x03c9495e, 0x0 }, /* #81 */
    { 0x061e93, 0x061e06, 0xc234c9fc, 0xc234c9fc, 0x5956da4a, 0x0 }, /* #82 */
    { 0x2f4892, 0x2f4007, 0x5b4cceaf, 0x5b4cceaf, 0xe3e5db49, 0x0 }, /* #83 */
    { 0x260712, 0x260702, 0xdc1892df, 0xdc1892df, 0xae89189a, 0x0 }, /* #84 */
    { 0x011bc3, 0x011312, 0xa876518c, 0xa876518c, 0x9c43bbcd, 0x0 }, /* #85 */
    { 0x1c38d6, 0x1c3816, 0xbb8c1301, 0xbb8c1301, 0x50f99eab, 0x0 }, /* #86 */
    { 0x070283, 0x070203, 0x1d76a18a, 0x1d76a18a, 0xa244ed6a, 0x0 }, /* #87 */
    { 0x235746, 0x235712, 0xafbd3e23, 0xafbd3e23, 0x8bdf2e7f, 0x0 }, /* #88 */
    { 0x117f86, 0x117787, 0x9ca2f617, 0x9ca2f617, 0xb79f4a96, 0x0 }, /* #89 */
    { 0x1b3506, 0x1b3597, 0x8306cc4c, 0x8306cc4c, 0xabfc076f, 0x0 }, /* #90 */
    { 0x111496, 0x111c87, 0x68b7ddea, 0x68b7ddea, 0xe5738581, 0x0 }, /* #91 */
    { 0x386bd7, 0x386383, 0xaea22f4f, 0xaea22f4f, 0xf1fea881, 0x0 }, /* #92 */
    { 0x260006, 0x260093, 0xb6ee4f30, 0xb6ee4f30, 0xd2f9988c, 0x0 }, /* #93 */
    { 0x260fd7, 0x260707, 0x1c8f2e8e, 0x1c8f2e8e, 0x9f27f8d3, 0x0 }, /* #94 */
    { 0x143e97, 0x143697, 0x1ed7aee5, 0x1ed7aee5, 0x53fe8dbe, 0x0 }, /* #95 */
};
uint32_t const g_cTests_cmp_u32 = RT_ELEMENTS(g_aTests_cmp_u32);

BINU32_TEST_T const g_aTests_test_u32[] =
{
    { 0x117642, 0x117646, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #0 */
    { 0x1e3b47, 0x1e3346, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x186a87, 0x186246, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #2 */
    { 0x3d4013, 0x3d4046, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #3 */
    { 0x327683, 0x327646, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #4 */
    { 0x3541d2, 0x354146, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x0a2247, 0x0a2246, 0x893c6426, 0x893c6426, 0x00000000, 0x0 }, /* #6 */
    { 0x111e03, 0x111646, 0x64407f1a, 0x64407f1a, 0x00000000, 0x0 }, /* #7 */
    { 0x2534c7, 0x253446, 0x3f2077ca, 0x3f2077ca, 0x00000000, 0x0 }, /* #8 */
    { 0x213fd2, 0x213746, 0x825e83ed, 0x825e83ed, 0x00000000, 0x0 }, /* #9 */
    { 0x0d5546, 0x0d5546, 0xa76e3934, 0xa76e3934, 0x00000000, 0x0 }, /* #10 */
    { 0x255106, 0x255146, 0xe7326e54, 0xe7326e54, 0x00000000, 0x0 }, /* #11 */
    { 0x231106, 0x231106, 0x273ad9cb, 0x273ad9cb, 0xe876f2ee, 0x0 }, /* #12 */
    { 0x3f5807, 0x3f5006, 0x94cbf34d, 0x94cbf34d, 0x2fe8a60b, 0x0 }, /* #13 */
    { 0x377c13, 0x377406, 0xa94bd6c8, 0xa94bd6c8, 0x58abf948, 0x0 }, /* #14 */
    { 0x3d38d3, 0x3d3002, 0x7384b306, 0x7384b306, 0xf91684bb, 0x0 }, /* #15 */
    { 0x323dc2, 0x323506, 0x355f04c6, 0x355f04c6, 0x5e72f2b3, 0x0 }, /* #16 */
    { 0x0b4356, 0x0b4382, 0xd0ca2364, 0xd0ca2364, 0x9a1fcb9c, 0x0 }, /* #17 */
    { 0x373786, 0x373786, 0xfd323203, 0xfd323203, 0xc5c3414f, 0x0 }, /* #18 */
    { 0x274c96, 0x274406, 0x13635b41, 0x13635b41, 0xee9115fd, 0x0 }, /* #19 */
    { 0x382696, 0x382602, 0x3584b795, 0x3584b795, 0x3fa8ad69, 0x0 }, /* #20 */
    { 0x3c46c2, 0x3c4606, 0x62ce8125, 0x62ce8125, 0xac1dd163, 0x0 }, /* #21 */
    { 0x2d35d3, 0x2d3506, 0x9f571f15, 0x9f571f15, 0x06b89122, 0x0 }, /* #22 */
    { 0x205f16, 0x205706, 0x47659eb8, 0x47659eb8, 0x8b4ee4f9, 0x0 }, /* #23 */
    { 0x306943, 0x306182, 0x8777c86d, 0x8777c86d, 0xde9123e4, 0x0 }, /* #24 */
    { 0x0e56c2, 0x0e5602, 0x1dee009c, 0x1dee009c, 0xadaf4799, 0x0 }, /* #25 */
    { 0x090c02, 0x090406, 0x2630b459, 0x2630b459, 0x42a24b3e, 0x0 }, /* #26 */
    { 0x096b47, 0x096302, 0x6a5021c0, 0x6a5021c0, 0xdebfe570, 0x0 }, /* #27 */
    { 0x0e29c3, 0x0e2102, 0x50324a42, 0x50324a42, 0x60a11d44, 0x0 }, /* #28 */
    { 0x2b7bc2, 0x2b7382, 0xd21d0c9e, 0xd21d0c9e, 0xa4970023, 0x0 }, /* #29 */
    { 0x123a02, 0x123206, 0xf22e43d8, 0xf22e43d8, 0x75286c27, 0x0 }, /* #30 */
    { 0x1f6f16, 0x1f6782, 0xed555c98, 0xed555c98, 0xd7003380, 0x0 }, /* #31 */
    { 0x167096, 0x167002, 0x874982f2, 0x874982f2, 0x2604700e, 0x0 }, /* #32 */
    { 0x031a12, 0x031202, 0x0b31a92c, 0x0b31a92c, 0x7b14fd2f, 0x0 }, /* #33 */
    { 0x3b0642, 0x3b0602, 0xacadcb77, 0xacadcb77, 0x60371f02, 0x0 }, /* #34 */
    { 0x292a43, 0x292202, 0x4da82a67, 0x4da82a67, 0x553de184, 0x0 }, /* #35 */
    { 0x1817c7, 0x181706, 0x65f4418f, 0x65f4418f, 0xb3d51526, 0x0 }, /* #36 */
    { 0x145f82, 0x145782, 0xd67cbe21, 0xd67cbe21, 0xe894c69d, 0x0 }, /* #37 */
    { 0x2061d6, 0x206182, 0xd8eea76b, 0xd8eea76b, 0xbe53c3ba, 0x0 }, /* #38 */
    { 0x071e03, 0x071602, 0x525f76d4, 0x525f76d4, 0x2ea32d31, 0x0 }, /* #39 */
    { 0x3a1447, 0x3a1402, 0x221f977f, 0x221f977f, 0x02d7c270, 0x0 }, /* #40 */
    { 0x2b4207, 0x2b4206, 0x20869b0a, 0x20869b0a, 0x49e1618b, 0x0 }, /* #41 */
    { 0x053847, 0x053002, 0x43470c8a, 0x43470c8a, 0xc00e41e4, 0x0 }, /* #42 */
    { 0x0b27d7, 0x0b2702, 0x1d336eb5, 0x1d336eb5, 0xae9b8c68, 0x0 }, /* #43 */
    { 0x066417, 0x066406, 0x420c0648, 0x420c0648, 0x2982c232, 0x0 }, /* #44 */
    { 0x143dc7, 0x143502, 0xd898c57f, 0xd898c57f, 0x1ab3bd7a, 0x0 }, /* #45 */
    { 0x010886, 0x010002, 0x206b4575, 0x206b4575, 0x70590fc8, 0x0 }, /* #46 */
    { 0x3c25d2, 0x3c2502, 0x8ee1fa6a, 0x8ee1fa6a, 0x475aa7cf, 0x0 }, /* #47 */
    { 0x325ec7, 0x325602, 0x1d9466f3, 0x1d9466f3, 0x4a9acc06, 0x0 }, /* #48 */
    { 0x0f5847, 0x0f5006, 0x61c77891, 0x61c77891, 0x9ba372bc, 0x0 }, /* #49 */
    { 0x021743, 0x021782, 0xd80aa48d, 0xd80aa48d, 0xf262df24, 0x0 }, /* #50 */
    { 0x265d47, 0x265506, 0x20351ce7, 0x20351ce7, 0xecec55b8, 0x0 }, /* #51 */
    { 0x277782, 0x277706, 0x4d63418b, 0x4d63418b, 0x9d535be1, 0x0 }, /* #52 */
    { 0x193186, 0x193102, 0xa8defed6, 0xa8defed6, 0x1829211f, 0x0 }, /* #53 */
    { 0x3b2b17, 0x3b2302, 0x06dad824, 0x06dad824, 0x66558a3b, 0x0 }, /* #54 */
    { 0x151396, 0x151302, 0x49aa37b0, 0x49aa37b0, 0x41b86c58, 0x0 }, /* #55 */
    { 0x273607, 0x273606, 0xc8eb79a9, 0xc8eb79a9, 0x49b2db33, 0x0 }, /* #56 */
    { 0x361382, 0x361302, 0xa760836f, 0xa760836f, 0x159a9546, 0x0 }, /* #57 */
    { 0x160f17, 0x160706, 0x37432ce0, 0x37432ce0, 0x76d641c1, 0x0 }, /* #58 */
    { 0x022fd6, 0x022706, 0x2912a04c, 0x2912a04c, 0x4092e958, 0x0 }, /* #59 */
    { 0x1a6803, 0x1a6082, 0xad6120bc, 0xad6120bc, 0xfab85c37, 0x0 }, /* #60 */
    { 0x1d0e87, 0x1d0602, 0xb7e7cb24, 0xb7e7cb24, 0x5c630da2, 0x0 }, /* #61 */
    { 0x213786, 0x213706, 0x74860d5b, 0x74860d5b, 0x9064830a, 0x0 }, /* #62 */
    { 0x2c23d3, 0x2c2386, 0xb901c20b, 0xb901c20b, 0xad736f50, 0x0 }, /* #63 */
    { 0x122c03, 0x122402, 0x930561b3, 0x930561b3, 0x0336c791, 0x0 }, /* #64 */
    { 0x2c69c7, 0x2c6102, 0x44decf5d, 0x44decf5d, 0xf30d131e, 0x0 }, /* #65 */
    { 0x367c42, 0x367482, 0xeb049ee7, 0xeb049ee7, 0x84914dcc, 0x0 }, /* #66 */
    { 0x1f32d2, 0x1f3206, 0xa50bb1d2, 0xa50bb1d2, 0x6fe169bc, 0x0 }, /* #67 */
    { 0x0a6346, 0x0a6302, 0x7689519b, 0x7689519b, 0x9943b7ce, 0x0 }, /* #68 */
    { 0x2763d3, 0x276302, 0x218200a4, 0x218200a4, 0x7b8f69c0, 0x0 }, /* #69 */
    { 0x3b5e87, 0x3b5686, 0x9c9086a6, 0x9c9086a6, 0xf5bea6be, 0x0 }, /* #70 */
    { 0x0e4f96, 0x0e4702, 0xac2a8f79, 0xac2a8f79, 0x64636a83, 0x0 }, /* #71 */
    { 0x0f6617, 0x0f6606, 0x691d08af, 0x691d08af, 0x3e74e7c7, 0x0 }, /* #72 */
    { 0x0c1013, 0x0c1002, 0x071ff7fe, 0x071ff7fe, 0xbb750ebc, 0x0 }, /* #73 */
    { 0x052b02, 0x052302, 0xbf062caf, 0xbf062caf, 0x6e2d0799, 0x0 }, /* #74 */
    { 0x2f4156, 0x2f4106, 0x143e7ea4, 0x143e7ea4, 0x8ed06511, 0x0 }, /* #75 */
    { 0x264316, 0x264306, 0x5165b36f, 0x5165b36f, 0x45bbdf3d, 0x0 }, /* #76 */
    { 0x113b13, 0x113302, 0x6d001d3f, 0x6d001d3f, 0x70123334, 0x0 }, /* #77 */
    { 0x317d46, 0x317506, 0x42867ad1, 0x42867ad1, 0x4cc0c94f, 0x0 }, /* #78 */
    { 0x2033c2, 0x203302, 0x0b6c770c, 0x0b6c770c, 0x574b5d55, 0x0 }, /* #79 */
    { 0x0c38c3, 0x0c3086, 0xab614515, 0xab614515, 0x867ca85e, 0x0 }, /* #80 */
    { 0x066d16, 0x066502, 0x44b89c01, 0x44b89c01, 0x4fb136d7, 0x0 }, /* #81 */
    { 0x2f0ec2, 0x2f0602, 0x5c3823e3, 0x5c3823e3, 0x92b99b12, 0x0 }, /* #82 */
    { 0x236782, 0x236702, 0xd8f717db, 0xd8f717db, 0x1eafebc6, 0x0 }, /* #83 */
    { 0x222cd3, 0x222486, 0x9a358cb7, 0x9a358cb7, 0xaa3c58ed, 0x0 }, /* #84 */
    { 0x1a2082, 0x1a2006, 0x81d3bb74, 0x81d3bb74, 0x7fb3768b, 0x0 }, /* #85 */
    { 0x2d4183, 0x2d4106, 0x76a2700a, 0x76a2700a, 0x07deae5e, 0x0 }, /* #86 */
    { 0x3d62d3, 0x3d6206, 0x5f4cfdfb, 0x5f4cfdfb, 0xb682f9fd, 0x0 }, /* #87 */
    { 0x0f1492, 0x0f1402, 0x5ca568a1, 0x5ca568a1, 0xc8566903, 0x0 }, /* #88 */
    { 0x1f4fc3, 0x1f4782, 0x8cf27a4d, 0x8cf27a4d, 0x9cf32649, 0x0 }, /* #89 */
    { 0x2860c2, 0x286002, 0xf018e871, 0xf018e871, 0x4220698b, 0x0 }, /* #90 */
    { 0x316413, 0x316402, 0x0fdc3927, 0x0fdc3927, 0x08e77c01, 0x0 }, /* #91 */
    { 0x2a4096, 0x2a4086, 0x9ae068e8, 0x9ae068e8, 0x998bae29, 0x0 }, /* #92 */
    { 0x2d7f93, 0x2d7786, 0xf6a9fe9f, 0xf6a9fe9f, 0xeae62978, 0x0 }, /* #93 */
    { 0x3c0903, 0x3c0102, 0x8e529dc6, 0x8e529dc6, 0x2270c566, 0x0 }, /* #94 */
    { 0x231e97, 0x231606, 0x087afd27, 0x087afd27, 0x39207de1, 0x0 }, /* #95 */
};
uint32_t const g_cTests_test_u32 = RT_ELEMENTS(g_aTests_test_u32);

BINU32_TEST_T const g_aTests_bt_u32[] =
{
    { 0x126802, 0x126802, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #0 */
    { 0x351687, 0x351686, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x226f97, 0x226f96, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #2 */
    { 0x033f97, 0x033f96, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #3 */
    { 0x1454c3, 0x1454c2, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #4 */
    { 0x184f57, 0x184f56, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x185a17, 0x185a17, 0x4baaebf9, 0x4baaebf9, 0x00000000, 0x0 }, /* #6 */
    { 0x2714c3, 0x2714c2, 0xccfbb80e, 0xccfbb80e, 0x00000000, 0x0 }, /* #7 */
    { 0x100c17, 0x100c17, 0x92f61593, 0x92f61593, 0x00000000, 0x0 }, /* #8 */
    { 0x1f0c52, 0x1f0c52, 0x4f5c42b8, 0x4f5c42b8, 0x00000000, 0x0 }, /* #9 */
    { 0x044602, 0x044603, 0x812c56af, 0x812c56af, 0x00000000, 0x0 }, /* #10 */
    { 0x366a02, 0x366a02, 0x521f6480, 0x521f6480, 0x00000000, 0x0 }, /* #11 */
    { 0x390e17, 0x390e17, 0x754806f1, 0x754806f1, 0x00000004, 0x0 }, /* #12 */
    { 0x1d6e03, 0x1d6e02, 0xca60b2c3, 0xca60b2c3, 0x00000005, 0x0 }, /* #13 */
    { 0x187d13, 0x187d13, 0xd4d8d261, 0xd4d8d261, 0x00000017, 0x0 }, /* #14 */
    { 0x346b87, 0x346b87, 0x3e3c4d81, 0x3e3c4d81, 0x00000019, 0x0 }, /* #15 */
    { 0x202947, 0x202947, 0x6c6b4aeb, 0x6c6b4aeb, 0x0000001e, 0x0 }, /* #16 */
    { 0x201ad7, 0x201ad7, 0x846c6225, 0x846c6225, 0x00000015, 0x0 }, /* #17 */
    { 0x0e65c2, 0x0e65c3, 0x3f925c1f, 0x3f925c1f, 0x0000001a, 0x0 }, /* #18 */
    { 0x274192, 0x274193, 0xfeb3fc04, 0xfeb3fc04, 0x00000015, 0x0 }, /* #19 */
    { 0x2e1016, 0x2e1017, 0x80f8c3b2, 0x80f8c3b2, 0x00000004, 0x0 }, /* #20 */
    { 0x0d7b06, 0x0d7b06, 0x47499502, 0x47499502, 0x00000005, 0x0 }, /* #21 */
    { 0x393a12, 0x393a12, 0x87f3ba47, 0x87f3ba47, 0x00000007, 0x0 }, /* #22 */
    { 0x187c46, 0x187c47, 0x513add98, 0x513add98, 0x00000014, 0x0 }, /* #23 */
    { 0x212ed7, 0x212ed6, 0x956ff8cc, 0x956ff8cc, 0x00000017, 0x0 }, /* #24 */
    { 0x216553, 0x216552, 0xf4ec1b7a, 0xf4ec1b7a, 0x00000018, 0x0 }, /* #25 */
    { 0x1019d2, 0x1019d3, 0x14b1906a, 0x14b1906a, 0x00000006, 0x0 }, /* #26 */
    { 0x3d7002, 0x3d7002, 0x5aba6071, 0x5aba6071, 0x00000009, 0x0 }, /* #27 */
    { 0x2c3c92, 0x2c3c93, 0x0a0f72ca, 0x0a0f72ca, 0x00000013, 0x0 }, /* #28 */
    { 0x0f5846, 0x0f5846, 0x9bdba563, 0x9bdba563, 0x0000001a, 0x0 }, /* #29 */
    { 0x317897, 0x317896, 0x7ad60edb, 0x7ad60edb, 0x00000010, 0x0 }, /* #30 */
    { 0x3e2402, 0x3e2403, 0x0a013718, 0x0a013718, 0x0000001b, 0x0 }, /* #31 */
    { 0x1f0492, 0x1f0492, 0x693929be, 0x693929be, 0x00000012, 0x0 }, /* #32 */
    { 0x3454d6, 0x3454d7, 0x6b089a6a, 0x6b089a6a, 0x00000009, 0x0 }, /* #33 */
    { 0x332217, 0x332217, 0xa432c2fe, 0xa432c2fe, 0x0000000f, 0x0 }, /* #34 */
    { 0x095956, 0x095957, 0xd7ae7576, 0xd7ae7576, 0x00000005, 0x0 }, /* #35 */
    { 0x303103, 0x303102, 0x01a0ac32, 0x01a0ac32, 0x00000009, 0x0 }, /* #36 */
    { 0x3b6a82, 0x3b6a82, 0x7031bfe0, 0x7031bfe0, 0x00000017, 0x0 }, /* #37 */
    { 0x052902, 0x052903, 0x1791535b, 0x1791535b, 0x00000014, 0x0 }, /* #38 */
    { 0x1942d3, 0x1942d2, 0xc5f16686, 0xc5f16686, 0x00000013, 0x0 }, /* #39 */
    { 0x0a0e93, 0x0a0e92, 0x9d6c17d6, 0x9d6c17d6, 0x0000000b, 0x0 }, /* #40 */
    { 0x254117, 0x254116, 0xc41812af, 0xc41812af, 0x0000001c, 0x0 }, /* #41 */
    { 0x2d2f92, 0x2d2f93, 0x50a69ce6, 0x50a69ce6, 0x0000000c, 0x0 }, /* #42 */
    { 0x1c5e96, 0x1c5e97, 0x1b68d390, 0x1b68d390, 0x00000007, 0x0 }, /* #43 */
    { 0x3c1b06, 0x3c1b07, 0x7194b477, 0x7194b477, 0x0000000a, 0x0 }, /* #44 */
    { 0x1c7d96, 0x1c7d97, 0xa248fb6e, 0xa248fb6e, 0x0000000d, 0x0 }, /* #45 */
    { 0x074602, 0x074603, 0x0df7986f, 0x0df7986f, 0x00000018, 0x0 }, /* #46 */
    { 0x1d2642, 0x1d2642, 0x02369f09, 0x02369f09, 0x00000007, 0x0 }, /* #47 */
    { 0x2d5483, 0x2d5483, 0x33a391af, 0x33a391af, 0x00000008, 0x0 }, /* #48 */
    { 0x2f3943, 0x2f3942, 0x18a604eb, 0x18a604eb, 0x00000016, 0x0 }, /* #49 */
    { 0x2e07d3, 0x2e07d2, 0x96a028b9, 0x96a028b9, 0x00000009, 0x0 }, /* #50 */
    { 0x1b5a82, 0x1b5a83, 0x795618a2, 0x795618a2, 0x0000000c, 0x0 }, /* #51 */
    { 0x014993, 0x014992, 0x158bf82e, 0x158bf82e, 0x00000000, 0x0 }, /* #52 */
    { 0x0b0c06, 0x0b0c06, 0x2ec35277, 0x2ec35277, 0x0000000d, 0x0 }, /* #53 */
    { 0x372e86, 0x372e86, 0x4947cba0, 0x4947cba0, 0x0000000d, 0x0 }, /* #54 */
    { 0x1d4806, 0x1d4807, 0xa3eaed5b, 0xa3eaed5b, 0x00000016, 0x0 }, /* #55 */
    { 0x3c2cc2, 0x3c2cc2, 0x442f1f90, 0x442f1f90, 0x0000000d, 0x0 }, /* #56 */
    { 0x323c57, 0x323c56, 0xf245a7d8, 0xf245a7d8, 0x0000001b, 0x0 }, /* #57 */
    { 0x3736c3, 0x3736c2, 0xd1498950, 0xd1498950, 0x00000009, 0x0 }, /* #58 */
    { 0x245653, 0x245653, 0xaf869a1b, 0xaf869a1b, 0x0000001b, 0x0 }, /* #59 */
    { 0x2f6f92, 0x2f6f93, 0xc5c5918f, 0xc5c5918f, 0x00000008, 0x0 }, /* #60 */
    { 0x294c17, 0x294c17, 0x10b1db2c, 0x10b1db2c, 0x00000015, 0x0 }, /* #61 */
    { 0x2c23d2, 0x2c23d3, 0xba0a49d2, 0xba0a49d2, 0x00000007, 0x0 }, /* #62 */
    { 0x045e96, 0x045e97, 0xa9edd402, 0xa9edd402, 0x0000001d, 0x0 }, /* #63 */
    { 0x1a0a16, 0x1a0a16, 0x2ab328f4, 0x2ab328f4, 0x00000012, 0x0 }, /* #64 */
    { 0x122b82, 0x122b82, 0x20aca132, 0x20aca132, 0x0000001f, 0x0 }, /* #65 */
    { 0x1c4613, 0x1c4612, 0x0411840f, 0x0411840f, 0x00000015, 0x0 }, /* #66 */
    { 0x092486, 0x092487, 0x7b5de4be, 0x7b5de4be, 0x00000019, 0x0 }, /* #67 */
    { 0x024ad3, 0x024ad3, 0x2841f186, 0x2841f186, 0x0000000d, 0x0 }, /* #68 */
    { 0x2a0217, 0x2a0217, 0xda277ff5, 0xda277ff5, 0x00000006, 0x0 }, /* #69 */
    { 0x304d17, 0x304d16, 0x05359e90, 0x05359e90, 0x0000001c, 0x0 }, /* #70 */
    { 0x0e2c43, 0x0e2c43, 0xe0978734, 0xe0978734, 0x00000004, 0x0 }, /* #71 */
    { 0x314c57, 0x314c56, 0xb94b7bc9, 0xb94b7bc9, 0x0000000f, 0x0 }, /* #72 */
    { 0x190e07, 0x190e07, 0x8093c738, 0x8093c738, 0x0000000e, 0x0 }, /* #73 */
    { 0x2f0b96, 0x2f0b96, 0xbd40fd3c, 0xbd40fd3c, 0x00000013, 0x0 }, /* #74 */
    { 0x0e5313, 0x0e5313, 0x28f7534b, 0x28f7534b, 0x00000012, 0x0 }, /* #75 */
    { 0x1973c7, 0x1973c7, 0xeba37b3d, 0xeba37b3d, 0x00000015, 0x0 }, /* #76 */
    { 0x2f5b82, 0x2f5b82, 0xce01a573, 0xce01a573, 0x00000011, 0x0 }, /* #77 */
    { 0x363492, 0x363493, 0x974a623c, 0x974a623c, 0x0000001c, 0x0 }, /* #78 */
    { 0x0a3092, 0x0a3092, 0x6ebdb250, 0x6ebdb250, 0x0000000b, 0x0 }, /* #79 */
    { 0x3b1902, 0x3b1902, 0x4bd40894, 0x4bd40894, 0x00000003, 0x0 }, /* #80 */
    { 0x1f3846, 0x1f3846, 0xa4c1ad6c, 0xa4c1ad6c, 0x00000018, 0x0 }, /* #81 */
    { 0x226986, 0x226987, 0x76ed4bd1, 0x76ed4bd1, 0x00000009, 0x0 }, /* #82 */
    { 0x2742d3, 0x2742d2, 0x24c7cc0b, 0x24c7cc0b, 0x00000008, 0x0 }, /* #83 */
    { 0x224746, 0x224747, 0x0ab7de91, 0x0ab7de91, 0x0000000f, 0x0 }, /* #84 */
    { 0x1e66d7, 0x1e66d7, 0xd420f093, 0xd420f093, 0x0000000e, 0x0 }, /* #85 */
    { 0x2d1a57, 0x2d1a57, 0xf6445e27, 0xf6445e27, 0x00000002, 0x0 }, /* #86 */
    { 0x251842, 0x251842, 0xd82091cb, 0xd82091cb, 0x00000010, 0x0 }, /* #87 */
    { 0x186f82, 0x186f82, 0x7b9bc071, 0x7b9bc071, 0x0000001a, 0x0 }, /* #88 */
    { 0x2c3dd6, 0x2c3dd7, 0x7fdc6d43, 0x7fdc6d43, 0x0000000d, 0x0 }, /* #89 */
    { 0x3e6496, 0x3e6497, 0x3bdea6fb, 0x3bdea6fb, 0x00000016, 0x0 }, /* #90 */
    { 0x3f4c17, 0x3f4c17, 0xa9e6e4f1, 0xa9e6e4f1, 0x0000001f, 0x0 }, /* #91 */
    { 0x292dc6, 0x292dc7, 0xc5535546, 0xc5535546, 0x00000016, 0x0 }, /* #92 */
    { 0x0b6793, 0x0b6793, 0xd871031c, 0xd871031c, 0x00000003, 0x0 }, /* #93 */
    { 0x291d42, 0x291d43, 0x4adda1c5, 0x4adda1c5, 0x00000007, 0x0 }, /* #94 */
    { 0x000d13, 0x000d12, 0x4f428eba, 0x4f428eba, 0x00000017, 0x0 }, /* #95 */
};
uint32_t const g_cTests_bt_u32 = RT_ELEMENTS(g_aTests_bt_u32);

BINU32_TEST_T const g_aTests_btc_u32[] =
{
    { 0x1845d2, 0x1845d2, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #0 */
    { 0x1e4a43, 0x1e4a42, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #1 */
    { 0x2c6643, 0x2c6642, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #2 */
    { 0x1f4617, 0x1f4616, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #3 */
    { 0x314796, 0x314796, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #4 */
    { 0x0a4182, 0x0a4182, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #5 */
    { 0x392ad2, 0x392ad2, 0xce1d6f04, 0xce1d6f05, 0x00000000, 0x0 }, /* #6 */
    { 0x105f92, 0x105f92, 0x2f4dbf98, 0x2f4dbf99, 0x00000000, 0x0 }, /* #7 */
    { 0x3b4746, 0x3b4747, 0x37c4410d, 0x37c4410c, 0x00000000, 0x0 }, /* #8 */
    { 0x145216, 0x145216, 0x54417a98, 0x54417a99, 0x00000000, 0x0 }, /* #9 */
    { 0x3d6753, 0x3d6753, 0x8475e5af, 0x8475e5ae, 0x00000000, 0x0 }, /* #10 */
    { 0x200343, 0x200342, 0x063376f6, 0x063376f7, 0x00000000, 0x0 }, /* #11 */
    { 0x3d1f17, 0x3d1f16, 0xdc05f4a1, 0xdc05fca1, 0x0000000b, 0x0 }, /* #12 */
    { 0x356297, 0x356296, 0x43d2d0d1, 0x43d2d2d1, 0x00000009, 0x0 }, /* #13 */
    { 0x061812, 0x061812, 0x7631eaca, 0x76b1eaca, 0x00000017, 0x0 }, /* #14 */
    { 0x223186, 0x223186, 0x09c7ab76, 0x09c7abf6, 0x00000007, 0x0 }, /* #15 */
    { 0x0d4d43, 0x0d4d42, 0xe04bf6ab, 0xe06bf6ab, 0x00000015, 0x0 }, /* #16 */
    { 0x0f67d2, 0x0f67d2, 0xcf300f00, 0xcf300f01, 0x00000000, 0x0 }, /* #17 */
    { 0x0265d7, 0x0265d6, 0x61fbaab6, 0x65fbaab6, 0x0000001a, 0x0 }, /* #18 */
    { 0x3f0cd7, 0x3f0cd6, 0xf7c50a40, 0xffc50a40, 0x0000001b, 0x0 }, /* #19 */
    { 0x044902, 0x044903, 0x1c1a6ffa, 0x1c1a6ff8, 0x00000001, 0x0 }, /* #20 */
    { 0x171292, 0x171292, 0x5684a82a, 0x5784a82a, 0x00000018, 0x0 }, /* #21 */
    { 0x346ed2, 0x346ed2, 0x030aafab, 0x030aafeb, 0x00000006, 0x0 }, /* #22 */
    { 0x045996, 0x045996, 0x1931485a, 0x3931485a, 0x0000001d, 0x0 }, /* #23 */
    { 0x352bd7, 0x352bd7, 0x173df09b, 0x073df09b, 0x0000001c, 0x0 }, /* #24 */
    { 0x3341c2, 0x3341c3, 0xfaebecfb, 0xf8ebecfb, 0x00000019, 0x0 }, /* #25 */
    { 0x1e6357, 0x1e6357, 0x1afeb66e, 0x1af6b66e, 0x00000013, 0x0 }, /* #26 */
    { 0x176b53, 0x176b52, 0x0f0a6510, 0x0f0a6512, 0x00000001, 0x0 }, /* #27 */
    { 0x0966c7, 0x0966c6, 0xc25a9b5c, 0xc25a9f5c, 0x0000000a, 0x0 }, /* #28 */
    { 0x325883, 0x325882, 0x627d6ae8, 0x627d6ae9, 0x00000000, 0x0 }, /* #29 */
    { 0x356ad7, 0x356ad7, 0xd563f03e, 0x5563f03e, 0x0000001f, 0x0 }, /* #30 */
    { 0x131117, 0x131117, 0x5c7e9d12, 0x5c7e9d10, 0x00000001, 0x0 }, /* #31 */
    { 0x315a52, 0x315a53, 0x5df74de6, 0x5df74de2, 0x00000002, 0x0 }, /* #32 */
    { 0x140907, 0x140907, 0x07e92cad, 0x05e92cad, 0x00000019, 0x0 }, /* #33 */
    { 0x3a6196, 0x3a6196, 0xecae63a6, 0xecaee3a6, 0x0000000f, 0x0 }, /* #34 */
    { 0x082382, 0x082383, 0xafe1d919, 0xafe1d918, 0x00000000, 0x0 }, /* #35 */
    { 0x1d4042, 0x1d4042, 0xac2f9632, 0xacaf9632, 0x00000017, 0x0 }, /* #36 */
    { 0x062212, 0x062213, 0x5ccb2051, 0x1ccb2051, 0x0000001e, 0x0 }, /* #37 */
    { 0x1c1043, 0x1c1042, 0x2dec2019, 0x2dfc2019, 0x00000014, 0x0 }, /* #38 */
    { 0x033957, 0x033956, 0x035727de, 0x0357a7de, 0x0000000f, 0x0 }, /* #39 */
    { 0x2d4d02, 0x2d4d02, 0x469a1757, 0x469a175f, 0x00000003, 0x0 }, /* #40 */
    { 0x2b3246, 0x2b3247, 0x0ad34557, 0x0ad34555, 0x00000001, 0x0 }, /* #41 */
    { 0x3d1c93, 0x3d1c92, 0x38450fee, 0x39450fee, 0x00000018, 0x0 }, /* #42 */
    { 0x031ad6, 0x031ad6, 0x91519ccb, 0x93519ccb, 0x00000019, 0x0 }, /* #43 */
    { 0x3019d7, 0x3019d7, 0x33d7e548, 0x3357e548, 0x00000017, 0x0 }, /* #44 */
    { 0x380242, 0x380243, 0xca27fba5, 0xc827fba5, 0x00000019, 0x0 }, /* #45 */
    { 0x3d7a87, 0x3d7a87, 0xbdb559ec, 0xbdb551ec, 0x0000000b, 0x0 }, /* #46 */
    { 0x1c6dd3, 0x1c6dd2, 0xcec9641e, 0xcec9643e, 0x00000005, 0x0 }, /* #47 */
    { 0x3a1017, 0x3a1017, 0xc1099ec4, 0xc10996c4, 0x0000000b, 0x0 }, /* #48 */
    { 0x0a6207, 0x0a6206, 0xdb75e268, 0xdb75e278, 0x00000004, 0x0 }, /* #49 */
    { 0x0c5293, 0x0c5293, 0x6626ccaa, 0x6626c8aa, 0x0000000a, 0x0 }, /* #50 */
    { 0x093a57, 0x093a56, 0xf6e7c2b7, 0xf7e7c2b7, 0x00000018, 0x0 }, /* #51 */
    { 0x114447, 0x114446, 0xd0137ae3, 0xd0137ae7, 0x00000002, 0x0 }, /* #52 */
    { 0x0b3393, 0x0b3392, 0x6f29424e, 0x6f29424f, 0x00000000, 0x0 }, /* #53 */
    { 0x032e82, 0x032e82, 0x2b401f0b, 0x2b401f0f, 0x00000002, 0x0 }, /* #54 */
    { 0x0c4c56, 0x0c4c57, 0xe9bcd861, 0xe99cd861, 0x00000015, 0x0 }, /* #55 */
    { 0x3670c2, 0x3670c2, 0xa0885104, 0xa8885104, 0x0000001b, 0x0 }, /* #56 */
    { 0x3a7e42, 0x3a7e43, 0xccf6ef34, 0xccf6ed34, 0x00000009, 0x0 }, /* #57 */
    { 0x394546, 0x394547, 0xde3c03da, 0xde3c03d8, 0x00000001, 0x0 }, /* #58 */
    { 0x0e3fc7, 0x0e3fc6, 0xc9b98d04, 0xc9b98d44, 0x00000006, 0x0 }, /* #59 */
    { 0x154e96, 0x154e97, 0xf8143c96, 0xb8143c96, 0x0000001e, 0x0 }, /* #60 */
    { 0x1844d2, 0x1844d3, 0x2af7ad3f, 0x2a77ad3f, 0x00000017, 0x0 }, /* #61 */
    { 0x0b3597, 0x0b3597, 0x506f744c, 0x506e744c, 0x00000010, 0x0 }, /* #62 */
    { 0x020e46, 0x020e46, 0x31090b3d, 0x31490b3d, 0x00000016, 0x0 }, /* #63 */
    { 0x123086, 0x123086, 0x9dc537c3, 0xbdc537c3, 0x0000001d, 0x0 }, /* #64 */
    { 0x012e97, 0x012e97, 0x567326c3, 0x56732683, 0x00000006, 0x0 }, /* #65 */
    { 0x1d1fd7, 0x1d1fd6, 0x1bae5af6, 0x1bee5af6, 0x00000016, 0x0 }, /* #66 */
    { 0x0e5503, 0x0e5503, 0xc45ef380, 0x845ef380, 0x0000001e, 0x0 }, /* #67 */
    { 0x266ec6, 0x266ec7, 0x997b73eb, 0x997b73e3, 0x00000003, 0x0 }, /* #68 */
    { 0x3a2b86, 0x3a2b87, 0xff86eba0, 0xff06eba0, 0x00000017, 0x0 }, /* #69 */
    { 0x192142, 0x192142, 0xddc3ba45, 0xddc3ba55, 0x00000004, 0x0 }, /* #70 */
    { 0x1973c7, 0x1973c7, 0x642eb899, 0x642eb099, 0x0000000b, 0x0 }, /* #71 */
    { 0x2e6442, 0x2e6442, 0x25f28105, 0x25fa8105, 0x00000013, 0x0 }, /* #72 */
    { 0x3c36d2, 0x3c36d3, 0x8ce4ccbf, 0x8ce4ccbe, 0x00000000, 0x0 }, /* #73 */
    { 0x2c0c97, 0x2c0c96, 0x21eff129, 0x21eff529, 0x0000000a, 0x0 }, /* #74 */
    { 0x247257, 0x247257, 0xd477f9ec, 0xd477f8ec, 0x00000008, 0x0 }, /* #75 */
    { 0x105216, 0x105217, 0x581d3c83, 0x58153c83, 0x00000013, 0x0 }, /* #76 */
    { 0x317216, 0x317216, 0x0f82b7cd, 0x0fc2b7cd, 0x00000016, 0x0 }, /* #77 */
    { 0x1f78d6, 0x1f78d6, 0x543f9e2f, 0x743f9e2f, 0x0000001d, 0x0 }, /* #78 */
    { 0x0b11c3, 0x0b11c3, 0xf20dae43, 0xb20dae43, 0x0000001e, 0x0 }, /* #79 */
    { 0x1b7706, 0x1b7706, 0xcdcd1300, 0xcdcd5300, 0x0000000e, 0x0 }, /* #80 */
    { 0x3f0b93, 0x3f0b93, 0x38b20e9c, 0x38b00e9c, 0x00000011, 0x0 }, /* #81 */
    { 0x094e87, 0x094e87, 0x6642f1eb, 0x6642f1cb, 0x00000005, 0x0 }, /* #82 */
    { 0x0d7a17, 0x0d7a17, 0xda3b5b56, 0xda3b5b16, 0x00000006, 0x0 }, /* #83 */
    { 0x174b17, 0x174b17, 0x9f1617d6, 0x9f1607d6, 0x0000000c, 0x0 }, /* #84 */
    { 0x347996, 0x347996, 0x64858aa9, 0x64859aa9, 0x0000000c, 0x0 }, /* #85 */
    { 0x202e92, 0x202e92, 0x235282ae, 0x235282af, 0x00000000, 0x0 }, /* #86 */
    { 0x1422d2, 0x1422d2, 0xe45f757c, 0xf45f757c, 0x0000001c, 0x0 }, /* #87 */
    { 0x3e0512, 0x3e0512, 0x95018ab3, 0x95018eb3, 0x0000000a, 0x0 }, /* #88 */
    { 0x2562c7, 0x2562c7, 0x9b2c53af, 0x9b2c53a7, 0x00000003, 0x0 }, /* #89 */
    { 0x114c02, 0x114c02, 0xf128fdf6, 0xf138fdf6, 0x00000014, 0x0 }, /* #90 */
    { 0x223256, 0x223257, 0x3a6565d2, 0x386565d2, 0x00000019, 0x0 }, /* #91 */
    { 0x216087, 0x216087, 0x4a9ae26b, 0x4a9a626b, 0x0000000f, 0x0 }, /* #92 */
    { 0x2a0713, 0x2a0713, 0x855c6344, 0x85546344, 0x00000013, 0x0 }, /* #93 */
    { 0x373396, 0x373397, 0x2dbc78bf, 0x2db878bf, 0x00000012, 0x0 }, /* #94 */
    { 0x210a16, 0x210a16, 0x3e001322, 0x7e001322, 0x0000001e, 0x0 }, /* #95 */
};
uint32_t const g_cTests_btc_u32 = RT_ELEMENTS(g_aTests_btc_u32);

BINU32_TEST_T const g_aTests_btc_u32_locked[] =
{
    { 0x140a03, 0x140a02, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #0 */
    { 0x0d2ad3, 0x0d2ad2, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #1 */
    { 0x357b87, 0x357b86, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #2 */
    { 0x1f5953, 0x1f5952, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #3 */
    { 0x1d7603, 0x1d7602, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #4 */
    { 0x0652d2, 0x0652d2, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #5 */
    { 0x2f1282, 0x2f1282, 0x95eee834, 0x95eee835, 0x00000000, 0x0 }, /* #6 */
    { 0x136c82, 0x136c82, 0xb413d0d2, 0xb413d0d3, 0x00000000, 0x0 }, /* #7 */
    { 0x1b6c06, 0x1b6c07, 0x10744639, 0x10744638, 0x00000000, 0x0 }, /* #8 */
    { 0x0f0b46, 0x0f0b47, 0x45587d81, 0x45587d80, 0x00000000, 0x0 }, /* #9 */
    { 0x386842, 0x386842, 0xc137cfe4, 0xc137cfe5, 0x00000000, 0x0 }, /* #10 */
    { 0x072e16, 0x072e16, 0x68ed733e, 0x68ed733f, 0x00000000, 0x0 }, /* #11 */
    { 0x1c5b02, 0x1c5b02, 0x1238f508, 0x1238f509, 0x00000000, 0x0 }, /* #12 */
    { 0x1a17c3, 0x1a17c3, 0x7358a451, 0x73588451, 0x0000000d, 0x0 }, /* #13 */
    { 0x263ec3, 0x263ec2, 0x68008cfb, 0x68408cfb, 0x00000016, 0x0 }, /* #14 */
    { 0x081006, 0x081007, 0x6afec7a6, 0x62fec7a6, 0x0000001b, 0x0 }, /* #15 */
    { 0x265743, 0x265743, 0xfd0f13ea, 0xfd0f12ea, 0x00000008, 0x0 }, /* #16 */
    { 0x261612, 0x261612, 0xdb7cf0ee, 0xdb7cf8ee, 0x0000000b, 0x0 }, /* #17 */
    { 0x2038d7, 0x2038d7, 0xbc9bcf94, 0xbc9b4f94, 0x0000000f, 0x0 }, /* #18 */
    { 0x260e93, 0x260e92, 0x47cf31e3, 0x47cf31e7, 0x00000002, 0x0 }, /* #19 */
    { 0x011607, 0x011606, 0xccd682ee, 0xced682ee, 0x00000019, 0x0 }, /* #20 */
    { 0x0a5a42, 0x0a5a43, 0x5e3d75b0, 0x5c3d75b0, 0x00000019, 0x0 }, /* #21 */
    { 0x260453, 0x260453, 0xc9c1db35, 0xc9c1db34, 0x00000000, 0x0 }, /* #22 */
    { 0x3940c2, 0x3940c3, 0x819ff3a9, 0x019ff3a9, 0x0000001f, 0x0 }, /* #23 */
    { 0x305143, 0x305142, 0x574998d5, 0x57499ad5, 0x00000009, 0x0 }, /* #24 */
    { 0x0e4b43, 0x0e4b42, 0x98c22f7e, 0xd8c22f7e, 0x0000001e, 0x0 }, /* #25 */
    { 0x151846, 0x151846, 0x42d5e1c8, 0x42d5e5c8, 0x0000000a, 0x0 }, /* #26 */
    { 0x0b6016, 0x0b6016, 0x1375195c, 0x9375195c, 0x0000001f, 0x0 }, /* #27 */
    { 0x0c45d3, 0x0c45d3, 0x48a5a6c7, 0x48a1a6c7, 0x00000012, 0x0 }, /* #28 */
    { 0x170296, 0x170296, 0xaca6a47c, 0xacb6a47c, 0x00000014, 0x0 }, /* #29 */
    { 0x0d0a07, 0x0d0a06, 0x37b590c5, 0x37b590c7, 0x00000001, 0x0 }, /* #30 */
    { 0x081903, 0x081903, 0xcad5779b, 0xcad5379b, 0x0000000e, 0x0 }, /* #31 */
    { 0x357e17, 0x357e16, 0x61634eaa, 0x61634faa, 0x00000008, 0x0 }, /* #32 */
    { 0x0b4457, 0x0b4456, 0xfbb02193, 0xfbf02193, 0x00000016, 0x0 }, /* #33 */
    { 0x2e0e12, 0x2e0e13, 0xf33854e3, 0xf33054e3, 0x00000013, 0x0 }, /* #34 */
    { 0x180097, 0x180097, 0x6e966a9e, 0x6c966a9e, 0x00000019, 0x0 }, /* #35 */
    { 0x1e5543, 0x1e5542, 0x3ce921c8, 0x3ceb21c8, 0x00000011, 0x0 }, /* #36 */
    { 0x216792, 0x216793, 0x0283a3b4, 0x0281a3b4, 0x00000011, 0x0 }, /* #37 */
    { 0x100ac3, 0x100ac2, 0x7ffe4e1a, 0xfffe4e1a, 0x0000001f, 0x0 }, /* #38 */
    { 0x223182, 0x223182, 0xc3e64580, 0xc3e65580, 0x0000000c, 0x0 }, /* #39 */
    { 0x261f87, 0x261f86, 0xe7666b02, 0xe7666b82, 0x00000007, 0x0 }, /* #40 */
    { 0x133083, 0x133083, 0x9104df1a, 0x9104db1a, 0x0000000a, 0x0 }, /* #41 */
    { 0x3d3b17, 0x3d3b17, 0x46e3677d, 0x46a3677d, 0x00000016, 0x0 }, /* #42 */
    { 0x346443, 0x346443, 0x52191ba2, 0x50191ba2, 0x00000019, 0x0 }, /* #43 */
    { 0x037107, 0x037107, 0xe86eeaa4, 0xe86eaaa4, 0x0000000e, 0x0 }, /* #44 */
    { 0x276993, 0x276993, 0x41e2fd8b, 0x41e0fd8b, 0x00000011, 0x0 }, /* #45 */
    { 0x373583, 0x373582, 0x1eb9370f, 0x1eb9b70f, 0x0000000f, 0x0 }, /* #46 */
    { 0x232853, 0x232852, 0xbe060212, 0xbe060312, 0x00000008, 0x0 }, /* #47 */
    { 0x206e56, 0x206e57, 0x5a772da7, 0x52772da7, 0x0000001b, 0x0 }, /* #48 */
    { 0x2c0797, 0x2c0797, 0x6a0cef6d, 0x2a0cef6d, 0x0000001e, 0x0 }, /* #49 */
    { 0x2a0953, 0x2a0953, 0x8aa349b5, 0x88a349b5, 0x00000019, 0x0 }, /* #50 */
    { 0x3d3e43, 0x3d3e43, 0xd485b1a0, 0xd485a1a0, 0x0000000c, 0x0 }, /* #51 */
    { 0x136b47, 0x136b47, 0x68102087, 0x68102086, 0x00000000, 0x0 }, /* #52 */
    { 0x0d5056, 0x0d5057, 0x3cc4e16d, 0x3cc4e14d, 0x00000005, 0x0 }, /* #53 */
    { 0x196382, 0x196382, 0xb7abc683, 0xb7abc6a3, 0x00000005, 0x0 }, /* #54 */
    { 0x033ec2, 0x033ec2, 0x195637e3, 0x195737e3, 0x00000010, 0x0 }, /* #55 */
    { 0x034a97, 0x034a96, 0xbe15c4ac, 0xbf15c4ac, 0x00000018, 0x0 }, /* #56 */
    { 0x197a87, 0x197a86, 0xaa034379, 0xaa034b79, 0x0000000b, 0x0 }, /* #57 */
    { 0x1c7013, 0x1c7012, 0xa3a24962, 0xa3e24962, 0x00000016, 0x0 }, /* #58 */
    { 0x3412c2, 0x3412c3, 0x5c7f4cbb, 0x5c7d4cbb, 0x00000011, 0x0 }, /* #59 */
    { 0x237713, 0x237712, 0xfc01cffa, 0xfc01cffb, 0x00000000, 0x0 }, /* #60 */
    { 0x013593, 0x013593, 0x83b0ecad, 0x83a0ecad, 0x00000014, 0x0 }, /* #61 */
    { 0x123fd3, 0x123fd2, 0x5e9d834f, 0x7e9d834f, 0x0000001d, 0x0 }, /* #62 */
    { 0x194413, 0x194413, 0x68667390, 0x48667390, 0x0000001d, 0x0 }, /* #63 */
    { 0x083316, 0x083316, 0xca5e5648, 0xca5e7648, 0x0000000d, 0x0 }, /* #64 */
    { 0x1b3116, 0x1b3116, 0xa3539412, 0xab539412, 0x0000001b, 0x0 }, /* #65 */
    { 0x174157, 0x174157, 0xf34adef9, 0xf34adef8, 0x00000000, 0x0 }, /* #66 */
    { 0x161e82, 0x161e83, 0x6e8b5b1f, 0x6e8b5b1e, 0x00000000, 0x0 }, /* #67 */
    { 0x1b0882, 0x1b0883, 0xd7ee9d59, 0x57ee9d59, 0x0000001f, 0x0 }, /* #68 */
    { 0x317f02, 0x317f03, 0xb90e3554, 0xb10e3554, 0x0000001b, 0x0 }, /* #69 */
    { 0x113187, 0x113187, 0xbcb77329, 0xbc377329, 0x00000017, 0x0 }, /* #70 */
    { 0x3f2382, 0x3f2382, 0xb10c1b94, 0xb14c1b94, 0x00000016, 0x0 }, /* #71 */
    { 0x390d56, 0x390d57, 0xf14d6010, 0xf14d2010, 0x0000000e, 0x0 }, /* #72 */
    { 0x3b2497, 0x3b2497, 0xf23a8b60, 0xf23a8960, 0x00000009, 0x0 }, /* #73 */
    { 0x074496, 0x074497, 0x241e3ece, 0x241e3ecc, 0x00000001, 0x0 }, /* #74 */
    { 0x0068c3, 0x0068c2, 0x474ac23b, 0x474ad23b, 0x0000000c, 0x0 }, /* #75 */
    { 0x036342, 0x036342, 0x403d9b17, 0x413d9b17, 0x00000018, 0x0 }, /* #76 */
    { 0x3721d7, 0x3721d7, 0x1cddead8, 0x1cddaad8, 0x0000000e, 0x0 }, /* #77 */
    { 0x396e03, 0x396e03, 0x992e2de9, 0x992e2de8, 0x00000000, 0x0 }, /* #78 */
    { 0x3a1f16, 0x3a1f17, 0x7099d93e, 0x7099d93c, 0x00000001, 0x0 }, /* #79 */
    { 0x085302, 0x085303, 0x2c1c82ea, 0x2c1c82aa, 0x00000006, 0x0 }, /* #80 */
    { 0x377c03, 0x377c03, 0x76a6af3b, 0x7686af3b, 0x00000015, 0x0 }, /* #81 */
    { 0x265d52, 0x265d52, 0x9a2cc4a4, 0xba2cc4a4, 0x0000001d, 0x0 }, /* #82 */
    { 0x3918c6, 0x3918c6, 0x56ba20c5, 0x5eba20c5, 0x0000001b, 0x0 }, /* #83 */
    { 0x276d82, 0x276d83, 0x99db82c5, 0x99db02c5, 0x0000000f, 0x0 }, /* #84 */
    { 0x364e12, 0x364e12, 0x35b9b1c8, 0x35bbb1c8, 0x00000011, 0x0 }, /* #85 */
    { 0x363c17, 0x363c17, 0xf11dda75, 0xf11d9a75, 0x0000000e, 0x0 }, /* #86 */
    { 0x1c6c82, 0x1c6c83, 0x6dc4fa94, 0x6dc4ea94, 0x0000000c, 0x0 }, /* #87 */
    { 0x3a5582, 0x3a5582, 0x35084ac0, 0x35084ec0, 0x0000000a, 0x0 }, /* #88 */
    { 0x310402, 0x310402, 0x16e6a55f, 0x16e7a55f, 0x00000010, 0x0 }, /* #89 */
    { 0x383543, 0x383543, 0xf0bc7274, 0xe0bc7274, 0x0000001c, 0x0 }, /* #90 */
    { 0x366486, 0x366486, 0xa1764b32, 0xa1774b32, 0x00000010, 0x0 }, /* #91 */
    { 0x376bc3, 0x376bc3, 0xe4e81734, 0xe4e01734, 0x00000013, 0x0 }, /* #92 */
    { 0x2a0b87, 0x2a0b86, 0xef5f5052, 0xef5fd052, 0x0000000f, 0x0 }, /* #93 */
    { 0x3523c7, 0x3523c6, 0xb60c8a3a, 0xb60c8a7a, 0x00000006, 0x0 }, /* #94 */
    { 0x030512, 0x030512, 0x0104b3db, 0x1104b3db, 0x0000001c, 0x0 }, /* #95 */
};
uint32_t const g_cTests_btc_u32_locked = RT_ELEMENTS(g_aTests_btc_u32_locked);

BINU32_TEST_T const g_aTests_btr_u32[] =
{
    { 0x1e69d7, 0x1e69d6, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #0 */
    { 0x2847c3, 0x2847c2, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x2a12d2, 0x2a12d2, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #2 */
    { 0x036892, 0x036892, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #3 */
    { 0x0b68c2, 0x0b68c2, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #4 */
    { 0x2c3307, 0x2c3306, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x153652, 0x153653, 0xee43b08f, 0xee43b08e, 0x00000000, 0x0 }, /* #6 */
    { 0x1277c6, 0x1277c7, 0x92917e8f, 0x92917e8e, 0x00000000, 0x0 }, /* #7 */
    { 0x002816, 0x002816, 0xd0ef91c4, 0xd0ef91c4, 0x00000000, 0x0 }, /* #8 */
    { 0x1a7647, 0x1a7647, 0x0d310bcb, 0x0d310bca, 0x00000000, 0x0 }, /* #9 */
    { 0x315686, 0x315686, 0xbd4ebd0e, 0xbd4ebd0e, 0x00000000, 0x0 }, /* #10 */
    { 0x163502, 0x163503, 0x4bbaf185, 0x4bbaf184, 0x00000000, 0x0 }, /* #11 */
    { 0x090fc6, 0x090fc7, 0xfd578fb7, 0xfd478fb7, 0x00000014, 0x0 }, /* #12 */
    { 0x3743c2, 0x3743c2, 0x680241e8, 0x680241e8, 0x00000009, 0x0 }, /* #13 */
    { 0x3e1146, 0x3e1146, 0xe395da0c, 0xe395da0c, 0x00000006, 0x0 }, /* #14 */
    { 0x2e6c12, 0x2e6c13, 0xad8932fc, 0x8d8932fc, 0x0000001d, 0x0 }, /* #15 */
    { 0x0c1ac7, 0x0c1ac7, 0x2a5972cc, 0x2a59724c, 0x00000007, 0x0 }, /* #16 */
    { 0x036646, 0x036646, 0x1eb21988, 0x1eb21988, 0x0000001e, 0x0 }, /* #17 */
    { 0x310487, 0x310487, 0x4c70a05c, 0x4c70205c, 0x0000000f, 0x0 }, /* #18 */
    { 0x395212, 0x395213, 0xe14e4a7f, 0xe14e4a5f, 0x00000005, 0x0 }, /* #19 */
    { 0x376197, 0x376196, 0x0603d295, 0x0603d295, 0x0000001b, 0x0 }, /* #20 */
    { 0x142806, 0x142807, 0x7837c77a, 0x7037c77a, 0x0000001b, 0x0 }, /* #21 */
    { 0x277347, 0x277346, 0x2229ff7b, 0x2229ff7b, 0x00000014, 0x0 }, /* #22 */
    { 0x021092, 0x021092, 0x09f610ee, 0x09f610ee, 0x0000000a, 0x0 }, /* #23 */
    { 0x382856, 0x382856, 0x822f977d, 0x822f977d, 0x00000001, 0x0 }, /* #24 */
    { 0x3b0392, 0x3b0392, 0x371dd15a, 0x371dd15a, 0x00000007, 0x0 }, /* #25 */
    { 0x247012, 0x247012, 0x41c205d7, 0x41c205d7, 0x0000000c, 0x0 }, /* #26 */
    { 0x373e96, 0x373e96, 0x308417ca, 0x308417ca, 0x00000013, 0x0 }, /* #27 */
    { 0x1b2343, 0x1b2343, 0x3183ba24, 0x1183ba24, 0x0000001d, 0x0 }, /* #28 */
    { 0x3b5543, 0x3b5542, 0x3d0b9741, 0x3d0b9741, 0x00000002, 0x0 }, /* #29 */
    { 0x2d3d87, 0x2d3d87, 0x9561e939, 0x9560e939, 0x00000010, 0x0 }, /* #30 */
    { 0x172182, 0x172182, 0x636d5022, 0x636d5022, 0x0000000d, 0x0 }, /* #31 */
    { 0x0e2956, 0x0e2957, 0x55272d83, 0x55272d03, 0x00000007, 0x0 }, /* #32 */
    { 0x1e63d2, 0x1e63d2, 0x901dfee5, 0x901dfee5, 0x00000001, 0x0 }, /* #33 */
    { 0x084d03, 0x084d02, 0x91615960, 0x91615960, 0x0000001e, 0x0 }, /* #34 */
    { 0x120e86, 0x120e87, 0x07b03875, 0x07b03075, 0x0000000b, 0x0 }, /* #35 */
    { 0x386256, 0x386257, 0xc1dbaa54, 0xc0dbaa54, 0x00000018, 0x0 }, /* #36 */
    { 0x283186, 0x283187, 0xe5491195, 0xe5481195, 0x00000010, 0x0 }, /* #37 */
    { 0x0b2d96, 0x0b2d96, 0xe6b4c79d, 0xe6b4c79d, 0x00000011, 0x0 }, /* #38 */
    { 0x257cc3, 0x257cc2, 0x4a906342, 0x4a906342, 0x00000000, 0x0 }, /* #39 */
    { 0x0d4c52, 0x0d4c53, 0xa1f6ffd9, 0xa1f6ff59, 0x00000007, 0x0 }, /* #40 */
    { 0x0c0c87, 0x0c0c87, 0xc3a48635, 0x83a48635, 0x0000001e, 0x0 }, /* #41 */
    { 0x015842, 0x015842, 0x024bf6a6, 0x024bf6a6, 0x00000003, 0x0 }, /* #42 */
    { 0x114d43, 0x114d42, 0x4f53ffca, 0x4f53ffca, 0x00000000, 0x0 }, /* #43 */
    { 0x376657, 0x376657, 0x932c02ae, 0x912c02ae, 0x00000019, 0x0 }, /* #44 */
    { 0x0422d3, 0x0422d2, 0x67a1f21e, 0x67a1f21e, 0x00000007, 0x0 }, /* #45 */
    { 0x1d14d2, 0x1d14d2, 0x4622118d, 0x4622118d, 0x0000000b, 0x0 }, /* #46 */
    { 0x331d07, 0x331d07, 0xcf6cd654, 0x4f6cd654, 0x0000001f, 0x0 }, /* #47 */
    { 0x1e2e06, 0x1e2e06, 0x315a59c7, 0x315a59c7, 0x00000019, 0x0 }, /* #48 */
    { 0x026607, 0x026606, 0x3b16aa39, 0x3b16aa39, 0x00000002, 0x0 }, /* #49 */
    { 0x217a83, 0x217a83, 0xd92833a7, 0xd92833a3, 0x00000002, 0x0 }, /* #50 */
    { 0x171fd2, 0x171fd3, 0x71413ef1, 0x71013ef1, 0x00000016, 0x0 }, /* #51 */
    { 0x2213d7, 0x2213d6, 0x573aa7e7, 0x573aa7e7, 0x00000017, 0x0 }, /* #52 */
    { 0x0e2a07, 0x0e2a06, 0x10c75ec1, 0x10c75ec1, 0x00000014, 0x0 }, /* #53 */
    { 0x1a2017, 0x1a2016, 0xf1cac29a, 0xf1cac29a, 0x0000001b, 0x0 }, /* #54 */
    { 0x115402, 0x115403, 0xedb61935, 0xed361935, 0x00000017, 0x0 }, /* #55 */
    { 0x195b52, 0x195b53, 0xa3d13b5b, 0xa3d03b5b, 0x00000010, 0x0 }, /* #56 */
    { 0x202c96, 0x202c97, 0x574a0163, 0x570a0163, 0x00000016, 0x0 }, /* #57 */
    { 0x2f0442, 0x2f0443, 0x8a05e0da, 0x8a05e05a, 0x00000007, 0x0 }, /* #58 */
    { 0x215143, 0x215142, 0x3fab6504, 0x3fab6504, 0x00000007, 0x0 }, /* #59 */
    { 0x3c1d87, 0x3c1d87, 0x05dbe5ab, 0x01dbe5ab, 0x0000001a, 0x0 }, /* #60 */
    { 0x362353, 0x362353, 0x6337953e, 0x6337913e, 0x0000000a, 0x0 }, /* #61 */
    { 0x265782, 0x265783, 0x483c2639, 0x483c2619, 0x00000005, 0x0 }, /* #62 */
    { 0x193152, 0x193153, 0x4a4ed018, 0x4a4ed010, 0x00000003, 0x0 }, /* #63 */
    { 0x333483, 0x333483, 0x09bac997, 0x093ac997, 0x00000017, 0x0 }, /* #64 */
    { 0x291fc2, 0x291fc3, 0x401a7b93, 0x401a7b92, 0x00000000, 0x0 }, /* #65 */
    { 0x241ec2, 0x241ec2, 0x182339e9, 0x182339e9, 0x0000000f, 0x0 }, /* #66 */
    { 0x346f02, 0x346f02, 0x0a8cff50, 0x0a8cff50, 0x00000014, 0x0 }, /* #67 */
    { 0x2117d6, 0x2117d6, 0x627a3936, 0x627a3936, 0x00000009, 0x0 }, /* #68 */
    { 0x046603, 0x046602, 0x7195441e, 0x7195441e, 0x00000000, 0x0 }, /* #69 */
    { 0x0c5447, 0x0c5446, 0x78645677, 0x78645677, 0x00000008, 0x0 }, /* #70 */
    { 0x251dd2, 0x251dd3, 0xbf1896a7, 0xbb1896a7, 0x0000001a, 0x0 }, /* #71 */
    { 0x332046, 0x332046, 0xea5cdea2, 0xea5cdea2, 0x0000000d, 0x0 }, /* #72 */
    { 0x3a5943, 0x3a5943, 0x0efd189b, 0x0eed189b, 0x00000014, 0x0 }, /* #73 */
    { 0x064102, 0x064102, 0x6e19a775, 0x6e19a775, 0x00000007, 0x0 }, /* #74 */
    { 0x277c13, 0x277c13, 0xa350b9f7, 0x2350b9f7, 0x0000001f, 0x0 }, /* #75 */
    { 0x0f2bc2, 0x0f2bc2, 0xa91e02d7, 0xa91e02d7, 0x0000000b, 0x0 }, /* #76 */
    { 0x352e47, 0x352e46, 0x6abe83d9, 0x6abe83d9, 0x0000000c, 0x0 }, /* #77 */
    { 0x2114d6, 0x2114d7, 0xf147f527, 0xf1477527, 0x0000000f, 0x0 }, /* #78 */
    { 0x3d56c7, 0x3d56c7, 0xa18c881c, 0xa18c8818, 0x00000002, 0x0 }, /* #79 */
    { 0x227ad2, 0x227ad3, 0xafc74606, 0xafc70606, 0x0000000e, 0x0 }, /* #80 */
    { 0x0e6047, 0x0e6046, 0x6a4c2cbb, 0x6a4c2cbb, 0x0000001a, 0x0 }, /* #81 */
    { 0x2301d3, 0x2301d3, 0x90686d98, 0x90684d98, 0x0000000d, 0x0 }, /* #82 */
    { 0x032353, 0x032352, 0xb05c4dec, 0xb05c4dec, 0x00000017, 0x0 }, /* #83 */
    { 0x195992, 0x195992, 0x1ba1eb0b, 0x1ba1eb0b, 0x00000004, 0x0 }, /* #84 */
    { 0x2f1f57, 0x2f1f57, 0x3f40f614, 0x3f40e614, 0x0000000c, 0x0 }, /* #85 */
    { 0x0907c2, 0x0907c2, 0x5b317738, 0x5b317738, 0x00000002, 0x0 }, /* #86 */
    { 0x1f74d6, 0x1f74d6, 0x1e0ae7d9, 0x1e0ae7d9, 0x00000018, 0x0 }, /* #87 */
    { 0x2f3516, 0x2f3516, 0x6caf9dc4, 0x6caf9dc4, 0x00000005, 0x0 }, /* #88 */
    { 0x264e93, 0x264e92, 0x092965b3, 0x092965b3, 0x00000002, 0x0 }, /* #89 */
    { 0x315283, 0x315282, 0x1b12635a, 0x1b12635a, 0x00000000, 0x0 }, /* #90 */
    { 0x184ec3, 0x184ec3, 0x02537cb5, 0x02537cb1, 0x00000002, 0x0 }, /* #91 */
    { 0x083947, 0x083947, 0xfbec6e35, 0xfb6c6e35, 0x00000017, 0x0 }, /* #92 */
    { 0x3830d2, 0x3830d3, 0x683cd2ce, 0x681cd2ce, 0x00000015, 0x0 }, /* #93 */
    { 0x037642, 0x037643, 0xa4f68e45, 0xa0f68e45, 0x0000001a, 0x0 }, /* #94 */
    { 0x364d42, 0x364d43, 0x18aa8bb0, 0x18aa89b0, 0x00000009, 0x0 }, /* #95 */
};
uint32_t const g_cTests_btr_u32 = RT_ELEMENTS(g_aTests_btr_u32);

BINU32_TEST_T const g_aTests_btr_u32_locked[] =
{
    { 0x1e2c93, 0x1e2c92, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #0 */
    { 0x0b6086, 0x0b6086, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #1 */
    { 0x1349d6, 0x1349d6, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #2 */
    { 0x1e5d47, 0x1e5d46, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #3 */
    { 0x363b12, 0x363b12, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #4 */
    { 0x171957, 0x171956, 0x00000000, 0x00000000, 0x00000000, 0x0 }, /* #5 */
    { 0x182d17, 0x182d16, 0xad67dca4, 0xad67dca4, 0x00000000, 0x0 }, /* #6 */
    { 0x1e6946, 0x1e6947, 0xa0b81ba7, 0xa0b81ba6, 0x00000000, 0x0 }, /* #7 */
    { 0x121853, 0x121853, 0x5599a5a1, 0x5599a5a0, 0x00000000, 0x0 }, /* #8 */
    { 0x092007, 0x092006, 0x959fc498, 0x959fc498, 0x00000000, 0x0 }, /* #9 */
    { 0x226fc7, 0x226fc7, 0xfa2a69df, 0xfa2a69de, 0x00000000, 0x0 }, /* #10 */
    { 0x0d1946, 0x0d1947, 0xc20b1d6f, 0xc20b1d6e, 0x00000000, 0x0 }, /* #11 */
    { 0x031507, 0x031506, 0x0c50e0cf, 0x0c50e0cf, 0x00000005, 0x0 }, /* #12 */
    { 0x2927c7, 0x2927c7, 0x8caabf3f, 0x8c8abf3f, 0x00000015, 0x0 }, /* #13 */
    { 0x3a4383, 0x3a4382, 0xd9f88089, 0xd9f88089, 0x00000005, 0x0 }, /* #14 */
    { 0x085dd6, 0x085dd7, 0x66c7f025, 0x64c7f025, 0x00000019, 0x0 }, /* #15 */
    { 0x3e6047, 0x3e6047, 0xa4b1ccbf, 0xa4b1ccbb, 0x00000002, 0x0 }, /* #16 */
    { 0x1e1d47, 0x1e1d46, 0xb5149725, 0xb5149725, 0x0000000b, 0x0 }, /* #17 */
    { 0x263413, 0x263413, 0x697f4fbb, 0x693f4fbb, 0x00000016, 0x0 }, /* #18 */
    { 0x3b1183, 0x3b1182, 0x57bb8dfc, 0x57bb8dfc, 0x0000000e, 0x0 }, /* #19 */
    { 0x0d73c3, 0x0d73c2, 0x4295c055, 0x4295c055, 0x00000015, 0x0 }, /* #20 */
    { 0x215616, 0x215616, 0xf04624f5, 0xf04624f5, 0x00000014, 0x0 }, /* #21 */
    { 0x2b0602, 0x2b0602, 0x83b1f041, 0x83b1f041, 0x00000016, 0x0 }, /* #22 */
    { 0x061c16, 0x061c17, 0xfff4bb87, 0xfef4bb87, 0x00000018, 0x0 }, /* #23 */
    { 0x363847, 0x363846, 0x6994abd5, 0x6994abd5, 0x0000000a, 0x0 }, /* #24 */
    { 0x1c1dc2, 0x1c1dc2, 0x21cecc22, 0x21cecc22, 0x0000000d, 0x0 }, /* #25 */
    { 0x254892, 0x254893, 0xb0ba9777, 0x90ba9777, 0x0000001d, 0x0 }, /* #26 */
    { 0x165b42, 0x165b42, 0x3fa5de3c, 0x3fa5de3c, 0x00000013, 0x0 }, /* #27 */
    { 0x133157, 0x133157, 0x93152341, 0x83152341, 0x0000001c, 0x0 }, /* #28 */
    { 0x232dd6, 0x232dd6, 0xbf6751ac, 0xbf6751ac, 0x00000013, 0x0 }, /* #29 */
    { 0x061c93, 0x061c93, 0x5fc2bb36, 0x5f82bb36, 0x00000016, 0x0 }, /* #30 */
    { 0x317212, 0x317213, 0xd732ba8a, 0xd732b88a, 0x00000009, 0x0 }, /* #31 */
    { 0x2b4116, 0x2b4117, 0xf9b964e9, 0xf9b964e8, 0x00000000, 0x0 }, /* #32 */
    { 0x205f17, 0x205f17, 0x0e6b4221, 0x0e634221, 0x00000013, 0x0 }, /* #33 */
    { 0x3b3496, 0x3b3496, 0x6a82e8a0, 0x6a82e8a0, 0x00000003, 0x0 }, /* #34 */
    { 0x106cd2, 0x106cd3, 0x41b7af05, 0x41b7af04, 0x00000000, 0x0 }, /* #35 */
    { 0x270bc6, 0x270bc7, 0x559f41f2, 0x559f41e2, 0x00000004, 0x0 }, /* #36 */
    { 0x2440c2, 0x2440c3, 0xbfaf2e51, 0xbf2f2e51, 0x00000017, 0x0 }, /* #37 */
    { 0x275c82, 0x275c82, 0xb79f2935, 0xb79f2935, 0x0000000f, 0x0 }, /* #38 */
    { 0x3c5847, 0x3c5847, 0x1f1dbfb3, 0x1e1dbfb3, 0x00000018, 0x0 }, /* #39 */
    { 0x3b3803, 0x3b3802, 0x46970a19, 0x46970a19, 0x0000000d, 0x0 }, /* #40 */
    { 0x3f6086, 0x3f6087, 0x0a72ad7b, 0x0872ad7b, 0x00000019, 0x0 }, /* #41 */
    { 0x397186, 0x397187, 0x9fb9a8a7, 0x9fb8a8a7, 0x00000010, 0x0 }, /* #42 */
    { 0x163413, 0x163412, 0x53754b53, 0x53754b53, 0x0000000d, 0x0 }, /* #43 */
    { 0x0d2516, 0x0d2516, 0x4f30667c, 0x4f30667c, 0x00000017, 0x0 }, /* #44 */
    { 0x1a2b56, 0x1a2b56, 0x8dd57304, 0x8dd57304, 0x00000001, 0x0 }, /* #45 */
    { 0x1131c6, 0x1131c7, 0x247894e6, 0x247814e6, 0x0000000f, 0x0 }, /* #46 */
    { 0x1a7dd7, 0x1a7dd6, 0xf810f51a, 0xf810f51a, 0x00000000, 0x0 }, /* #47 */
    { 0x174886, 0x174886, 0x12593ffc, 0x12593ffc, 0x00000001, 0x0 }, /* #48 */
    { 0x074c47, 0x074c47, 0xd7cbc432, 0xd74bc432, 0x00000017, 0x0 }, /* #49 */
    { 0x0279c6, 0x0279c6, 0x27c323ba, 0x27c323ba, 0x0000001c, 0x0 }, /* #50 */
    { 0x1e7a42, 0x1e7a42, 0xffa8acfe, 0xffa8acfe, 0x0000000c, 0x0 }, /* #51 */
    { 0x2f4246, 0x2f4246, 0x3fe8b4e6, 0x3fe8b4e6, 0x00000004, 0x0 }, /* #52 */
    { 0x1701d3, 0x1701d3, 0x728294b2, 0x728214b2, 0x0000000f, 0x0 }, /* #53 */
    { 0x093196, 0x093197, 0x2644373e, 0x2644353e, 0x00000009, 0x0 }, /* #54 */
    { 0x0d2002, 0x0d2003, 0x215c764b, 0x215c760b, 0x00000006, 0x0 }, /* #55 */
    { 0x3d4747, 0x3d4746, 0x8caefdd5, 0x8caefdd5, 0x00000019, 0x0 }, /* #56 */
    { 0x1161c7, 0x1161c6, 0x6b9e2eda, 0x6b9e2eda, 0x0000001f, 0x0 }, /* #57 */
    { 0x227116, 0x227117, 0xa58cbeb0, 0xa584beb0, 0x00000013, 0x0 }, /* #58 */
    { 0x2c7e92, 0x2c7e93, 0x14d7f2d9, 0x14d7b2d9, 0x0000000e, 0x0 }, /* #59 */
    { 0x2e2a17, 0x2e2a17, 0xb8cad962, 0xb8cad862, 0x00000008, 0x0 }, /* #60 */
    { 0x372e96, 0x372e97, 0x3eb6ee9d, 0x3eb6e69d, 0x0000000b, 0x0 }, /* #61 */
    { 0x176596, 0x176596, 0xae1ef31c, 0xae1ef31c, 0x0000001c, 0x0 }, /* #62 */
    { 0x124952, 0x124952, 0x4c17da05, 0x4c17da05, 0x00000015, 0x0 }, /* #63 */
    { 0x2b4a03, 0x2b4a02, 0x5b21c217, 0x5b21c217, 0x0000001d, 0x0 }, /* #64 */
    { 0x0e64d3, 0x0e64d3, 0x3b275df7, 0x3b275cf7, 0x00000008, 0x0 }, /* #65 */
    { 0x2532c3, 0x2532c2, 0x4e9df818, 0x4e9df818, 0x00000011, 0x0 }, /* #66 */
    { 0x2d16d3, 0x2d16d2, 0xc9e2afe4, 0xc9e2afe4, 0x00000001, 0x0 }, /* #67 */
    { 0x007c02, 0x007c02, 0x4516210e, 0x4516210e, 0x00000010, 0x0 }, /* #68 */
    { 0x357907, 0x357906, 0xcf37b31f, 0xcf37b31f, 0x00000016, 0x0 }, /* #69 */
    { 0x342e56, 0x342e56, 0x5647f4b4, 0x5647f4b4, 0x00000014, 0x0 }, /* #70 */
    { 0x171b53, 0x171b52, 0x412afd10, 0x412afd10, 0x0000001d, 0x0 }, /* #71 */
    { 0x3003d7, 0x3003d6, 0x44e208c3, 0x44e208c3, 0x00000008, 0x0 }, /* #72 */
    { 0x1f2a47, 0x1f2a47, 0x63ab33b6, 0x63ab32b6, 0x00000008, 0x0 }, /* #73 */
    { 0x005a92, 0x005a92, 0xa0be72d2, 0xa0be72d2, 0x0000000a, 0x0 }, /* #74 */
    { 0x3e1703, 0x3e1703, 0x95052dc9, 0x95012dc9, 0x00000012, 0x0 }, /* #75 */
    { 0x317f03, 0x317f03, 0x6c216a09, 0x6c216a08, 0x00000000, 0x0 }, /* #76 */
    { 0x3425c6, 0x3425c7, 0x93acb26d, 0x92acb26d, 0x00000018, 0x0 }, /* #77 */
    { 0x284c83, 0x284c83, 0x3a38fc1b, 0x3a38fc19, 0x00000001, 0x0 }, /* #78 */
    { 0x1f0ed6, 0x1f0ed7, 0x9ce4fc43, 0x9cc4fc43, 0x00000015, 0x0 }, /* #79 */
    { 0x161912, 0x161912, 0x28445f29, 0x28445f29, 0x0000001c, 0x0 }, /* #80 */
    { 0x355546, 0x355546, 0xdec1fd0c, 0xdec1fd0c, 0x00000013, 0x0 }, /* #81 */
    { 0x225a96, 0x225a96, 0x5231ca8d, 0x5231ca8d, 0x00000004, 0x0 }, /* #82 */
    { 0x262642, 0x262642, 0xc4cc893f, 0xc4cc893f, 0x0000001c, 0x0 }, /* #83 */
    { 0x324346, 0x324347, 0xf43c11f1, 0xf41c11f1, 0x00000015, 0x0 }, /* #84 */
    { 0x3a61d2, 0x3a61d2, 0x3f88d347, 0x3f88d347, 0x0000001f, 0x0 }, /* #85 */
    { 0x2543d3, 0x2543d2, 0xc83a7b85, 0xc83a7b85, 0x00000006, 0x0 }, /* #86 */
    { 0x1b17d6, 0x1b17d6, 0x04748e86, 0x04748e86, 0x00000011, 0x0 }, /* #87 */
    { 0x0750c3, 0x0750c2, 0x99ceaaf5, 0x99ceaaf5, 0x0000000e, 0x0 }, /* #88 */
    { 0x323183, 0x323183, 0x2eb1acfc, 0x2eb18cfc, 0x0000000d, 0x0 }, /* #89 */
    { 0x3376c6, 0x3376c6, 0xddf99ed1, 0xddf99ed1, 0x00000002, 0x0 }, /* #90 */
    { 0x355587, 0x355586, 0xe35b11f9, 0xe35b11f9, 0x00000015, 0x0 }, /* #91 */
    { 0x245a06, 0x245a07, 0xd44cb922, 0xd04cb922, 0x0000001a, 0x0 }, /* #92 */
    { 0x010483, 0x010482, 0x4640babe, 0x4640babe, 0x00000011, 0x0 }, /* #93 */
    { 0x282402, 0x282403, 0xb3f4e30c, 0x93f4e30c, 0x0000001d, 0x0 }, /* #94 */
    { 0x350a47, 0x350a46, 0x30cdcd17, 0x30cdcd17, 0x00000011, 0x0 }, /* #95 */
};
uint32_t const g_cTests_btr_u32_locked = RT_ELEMENTS(g_aTests_btr_u32_locked);

BINU32_TEST_T const g_aTests_bts_u32[] =
{
    { 0x0720d7, 0x0720d6, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #0 */
    { 0x0e01d6, 0x0e01d6, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #1 */
    { 0x2a5302, 0x2a5302, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #2 */
    { 0x095ac2, 0x095ac2, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #3 */
    { 0x0626d7, 0x0626d6, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #4 */
    { 0x382d86, 0x382d86, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #5 */
    { 0x050d43, 0x050d42, 0xca6dd348, 0xca6dd349, 0x00000000, 0x0 }, /* #6 */
    { 0x3333c2, 0x3333c2, 0x271776fe, 0x271776ff, 0x00000000, 0x0 }, /* #7 */
    { 0x103117, 0x103117, 0xf69c1027, 0xf69c1027, 0x00000000, 0x0 }, /* #8 */
    { 0x2a6846, 0x2a6846, 0x3fb8dd9c, 0x3fb8dd9d, 0x00000000, 0x0 }, /* #9 */
    { 0x317f07, 0x317f07, 0xe4fb125d, 0xe4fb125d, 0x00000000, 0x0 }, /* #10 */
    { 0x3e5b86, 0x3e5b87, 0x773b6487, 0x773b6487, 0x00000000, 0x0 }, /* #11 */
    { 0x310fd2, 0x310fd2, 0x682a8c9b, 0x682b8c9b, 0x00000010, 0x0 }, /* #12 */
    { 0x350842, 0x350843, 0x4dc814ba, 0x4dc814ba, 0x00000018, 0x0 }, /* #13 */
    { 0x1b2d06, 0x1b2d07, 0x0b014f14, 0x0b014f14, 0x0000000e, 0x0 }, /* #14 */
    { 0x080d83, 0x080d82, 0x3add37c9, 0x7add37c9, 0x0000001e, 0x0 }, /* #15 */
    { 0x252106, 0x252107, 0xc6fd7bbb, 0xc6fd7bbb, 0x00000004, 0x0 }, /* #16 */
    { 0x312a52, 0x312a53, 0x511525d6, 0x511525d6, 0x00000008, 0x0 }, /* #17 */
    { 0x176f13, 0x176f13, 0xb77c9d02, 0xb77c9d02, 0x00000015, 0x0 }, /* #18 */
    { 0x252bc6, 0x252bc7, 0xcda017ab, 0xcda017ab, 0x00000000, 0x0 }, /* #19 */
    { 0x2f7b56, 0x2f7b57, 0x11016d3d, 0x11016d3d, 0x0000000e, 0x0 }, /* #20 */
    { 0x240003, 0x240003, 0x6a7badca, 0x6a7badca, 0x0000001e, 0x0 }, /* #21 */
    { 0x092f42, 0x092f43, 0x2aba8379, 0x2aba8379, 0x00000013, 0x0 }, /* #22 */
    { 0x174c52, 0x174c52, 0x79124c60, 0x79134c60, 0x00000010, 0x0 }, /* #23 */
    { 0x0f7c83, 0x0f7c83, 0x09febe9c, 0x09febe9c, 0x00000003, 0x0 }, /* #24 */
    { 0x377c53, 0x377c52, 0x576816d7, 0x776816d7, 0x0000001d, 0x0 }, /* #25 */
    { 0x101916, 0x101917, 0x3a5e841b, 0x3a5e841b, 0x00000003, 0x0 }, /* #26 */
    { 0x3c07c6, 0x3c07c7, 0x291965ed, 0x291965ed, 0x00000006, 0x0 }, /* #27 */
    { 0x155fc6, 0x155fc7, 0x9493f2a6, 0x9493f2a6, 0x0000001a, 0x0 }, /* #28 */
    { 0x252013, 0x252012, 0x189d372e, 0x189db72e, 0x0000000f, 0x0 }, /* #29 */
    { 0x262042, 0x262042, 0x5f053bc1, 0xdf053bc1, 0x0000001f, 0x0 }, /* #30 */
    { 0x2e6bd7, 0x2e6bd7, 0xc6846e04, 0xc6846e04, 0x00000019, 0x0 }, /* #31 */
    { 0x1e0e03, 0x1e0e02, 0x13826f0b, 0x13826f2b, 0x00000005, 0x0 }, /* #32 */
    { 0x270016, 0x270016, 0xa9d83c96, 0xadd83c96, 0x0000001a, 0x0 }, /* #33 */
    { 0x380156, 0x380157, 0xb62a1b09, 0xb62a1b09, 0x00000000, 0x0 }, /* #34 */
    { 0x272d86, 0x272d86, 0x355c9120, 0x355e9120, 0x00000011, 0x0 }, /* #35 */
    { 0x343d92, 0x343d93, 0x3fcbcabc, 0x3fcbcabc, 0x00000004, 0x0 }, /* #36 */
    { 0x133f96, 0x133f97, 0xcaad47e6, 0xcaad47e6, 0x00000019, 0x0 }, /* #37 */
    { 0x302b96, 0x302b96, 0x9db51010, 0x9df51010, 0x00000016, 0x0 }, /* #38 */
    { 0x0d2b06, 0x0d2b07, 0x7cd2f8bd, 0x7cd2f8bd, 0x0000001b, 0x0 }, /* #39 */
    { 0x1b6a93, 0x1b6a92, 0xd6a5fb6f, 0xf6a5fb6f, 0x0000001d, 0x0 }, /* #40 */
    { 0x240ed2, 0x240ed2, 0x9db9f51a, 0x9db9f59a, 0x00000007, 0x0 }, /* #41 */
    { 0x175543, 0x175542, 0xe4314340, 0xe6314340, 0x00000019, 0x0 }, /* #42 */
    { 0x1c3a83, 0x1c3a83, 0xc2f27197, 0xc2f27197, 0x00000001, 0x0 }, /* #43 */
    { 0x3320d3, 0x3320d2, 0xb6b42642, 0xb6b62642, 0x00000011, 0x0 }, /* #44 */
    { 0x3324d6, 0x3324d6, 0x36616191, 0x36616195, 0x00000002, 0x0 }, /* #45 */
    { 0x265756, 0x265756, 0xaa284c81, 0xaa384c81, 0x00000014, 0x0 }, /* #46 */
    { 0x2765c3, 0x2765c2, 0x2f2f7cbc, 0x2faf7cbc, 0x00000017, 0x0 }, /* #47 */
    { 0x096e96, 0x096e97, 0xbfc1327e, 0xbfc1327e, 0x00000016, 0x0 }, /* #48 */
    { 0x226693, 0x226693, 0x00159bb1, 0x00159bb1, 0x0000000b, 0x0 }, /* #49 */
    { 0x2b0883, 0x2b0883, 0x5cd8d5b4, 0x5cd8d5b4, 0x00000005, 0x0 }, /* #50 */
    { 0x2b7906, 0x2b7907, 0xc2bfdb8f, 0xc2bfdb8f, 0x0000000b, 0x0 }, /* #51 */
    { 0x1b7256, 0x1b7256, 0xcc41b76d, 0xcc41b7ed, 0x00000007, 0x0 }, /* #52 */
    { 0x134016, 0x134017, 0x11edcc7c, 0x11edcc7c, 0x00000016, 0x0 }, /* #53 */
    { 0x2a6303, 0x2a6303, 0x4a2bdbb5, 0x4a2bdbb5, 0x0000000c, 0x0 }, /* #54 */
    { 0x104252, 0x104252, 0x8613baf0, 0x8613baf2, 0x00000001, 0x0 }, /* #55 */
    { 0x035356, 0x035357, 0x2c6d83bc, 0x2c6d83bc, 0x00000007, 0x0 }, /* #56 */
    { 0x1071d6, 0x1071d7, 0xfde5d6e6, 0xfde5d6e6, 0x0000001d, 0x0 }, /* #57 */
    { 0x046412, 0x046413, 0xf711f57c, 0xf711f57c, 0x00000008, 0x0 }, /* #58 */
    { 0x024683, 0x024682, 0xe78d1238, 0xe78d9238, 0x0000000f, 0x0 }, /* #59 */
    { 0x3042d2, 0x3042d3, 0xfc586db7, 0xfc586db7, 0x00000014, 0x0 }, /* #60 */
    { 0x081743, 0x081743, 0xfd7fc3a8, 0xfd7fc3a8, 0x00000013, 0x0 }, /* #61 */
    { 0x171287, 0x171286, 0x76ad517a, 0x76bd517a, 0x00000014, 0x0 }, /* #62 */
    { 0x226312, 0x226313, 0x45eaf642, 0x45eaf642, 0x0000001a, 0x0 }, /* #63 */
    { 0x135a93, 0x135a93, 0xc8dd348b, 0xc8dd348b, 0x00000012, 0x0 }, /* #64 */
    { 0x323d87, 0x323d86, 0x9902ac67, 0x9902ace7, 0x00000007, 0x0 }, /* #65 */
    { 0x0f1083, 0x0f1082, 0x12dff42b, 0x92dff42b, 0x0000001f, 0x0 }, /* #66 */
    { 0x1d05d6, 0x1d05d6, 0x925c8126, 0x9a5c8126, 0x0000001b, 0x0 }, /* #67 */
    { 0x0863d6, 0x0863d7, 0xd460cba6, 0xd460cba6, 0x0000001e, 0x0 }, /* #68 */
    { 0x212cc3, 0x212cc2, 0x11e4fdbe, 0x11e4ffbe, 0x00000009, 0x0 }, /* #69 */
    { 0x1667d3, 0x1667d3, 0x8fefc89a, 0x8fefc89a, 0x00000003, 0x0 }, /* #70 */
    { 0x3261c6, 0x3261c7, 0xd45fb108, 0xd45fb108, 0x00000014, 0x0 }, /* #71 */
    { 0x0c59d3, 0x0c59d2, 0x02d33fd6, 0x02d73fd6, 0x00000012, 0x0 }, /* #72 */
    { 0x386853, 0x386853, 0x409ac381, 0x409ac381, 0x00000014, 0x0 }, /* #73 */
    { 0x127e02, 0x127e03, 0x27dffc19, 0x27dffc19, 0x00000012, 0x0 }, /* #74 */
    { 0x030442, 0x030443, 0x1061792d, 0x1061792d, 0x0000000c, 0x0 }, /* #75 */
    { 0x274f47, 0x274f46, 0xb745f061, 0xb745f065, 0x00000002, 0x0 }, /* #76 */
    { 0x104092, 0x104092, 0xa6fe3dae, 0xa6fe3fae, 0x00000009, 0x0 }, /* #77 */
    { 0x265317, 0x265317, 0x7db34fcf, 0x7db34fcf, 0x00000017, 0x0 }, /* #78 */
    { 0x393503, 0x393503, 0xa919f917, 0xa919f917, 0x00000000, 0x0 }, /* #79 */
    { 0x166497, 0x166497, 0xc54c4d7b, 0xc54c4d7b, 0x00000001, 0x0 }, /* #80 */
    { 0x390e82, 0x390e82, 0x34795869, 0x74795869, 0x0000001e, 0x0 }, /* #81 */
    { 0x364e93, 0x364e92, 0x728b2b36, 0x72ab2b36, 0x00000015, 0x0 }, /* #82 */
    { 0x297a43, 0x297a42, 0xdc7a0e20, 0xdc7a8e20, 0x0000000f, 0x0 }, /* #83 */
    { 0x332713, 0x332712, 0x064c12e7, 0x064c12ef, 0x00000003, 0x0 }, /* #84 */
    { 0x123696, 0x123697, 0xf8f56442, 0xf8f56442, 0x00000001, 0x0 }, /* #85 */
    { 0x1d5457, 0x1d5457, 0x3475e4dc, 0x3475e4dc, 0x00000003, 0x0 }, /* #86 */
    { 0x0e7bd6, 0x0e7bd7, 0x80ec4432, 0x80ec4432, 0x00000012, 0x0 }, /* #87 */
    { 0x037656, 0x037656, 0x2b80caf1, 0x2b90caf1, 0x00000014, 0x0 }, /* #88 */
    { 0x3f7587, 0x3f7587, 0x77124ea4, 0x77124ea4, 0x00000005, 0x0 }, /* #89 */
    { 0x062bd2, 0x062bd2, 0x42d59a33, 0x52d59a33, 0x0000001c, 0x0 }, /* #90 */
    { 0x0f41c7, 0x0f41c7, 0xa66e614b, 0xa66e614b, 0x00000012, 0x0 }, /* #91 */
    { 0x300957, 0x300956, 0x31e67858, 0x31e6f858, 0x0000000f, 0x0 }, /* #92 */
    { 0x3a6e56, 0x3a6e56, 0x7614356a, 0x7614756a, 0x0000000e, 0x0 }, /* #93 */
    { 0x060797, 0x060797, 0x773f7f25, 0x773f7f25, 0x0000001e, 0x0 }, /* #94 */
    { 0x3f3352, 0x3f3353, 0x2de00f45, 0x2de00f45, 0x00000006, 0x0 }, /* #95 */
};
uint32_t const g_cTests_bts_u32 = RT_ELEMENTS(g_aTests_bts_u32);

BINU32_TEST_T const g_aTests_bts_u32_locked[] =
{
    { 0x2b4117, 0x2b4116, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #0 */
    { 0x1d14d7, 0x1d14d6, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #1 */
    { 0x293453, 0x293452, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #2 */
    { 0x060296, 0x060296, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #3 */
    { 0x0a7542, 0x0a7542, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #4 */
    { 0x056b87, 0x056b86, 0x00000000, 0x00000001, 0x00000000, 0x0 }, /* #5 */
    { 0x1c0197, 0x1c0197, 0x2b578163, 0x2b578163, 0x00000000, 0x0 }, /* #6 */
    { 0x0a7212, 0x0a7213, 0xb0dedd9b, 0xb0dedd9b, 0x00000000, 0x0 }, /* #7 */
    { 0x062a42, 0x062a42, 0x9415226e, 0x9415226f, 0x00000000, 0x0 }, /* #8 */
    { 0x3d2957, 0x3d2956, 0x4dcb4954, 0x4dcb4955, 0x00000000, 0x0 }, /* #9 */
    { 0x042393, 0x042392, 0x8a757982, 0x8a757983, 0x00000000, 0x0 }, /* #10 */
    { 0x3b0ed2, 0x3b0ed2, 0x7e1a787c, 0x7e1a787d, 0x00000000, 0x0 }, /* #11 */
    { 0x0b2ec2, 0x0b2ec2, 0x950b4430, 0x950bc430, 0x0000000f, 0x0 }, /* #12 */
    { 0x312f02, 0x312f02, 0x08ecb640, 0x88ecb640, 0x0000001f, 0x0 }, /* #13 */
    { 0x3e1ac2, 0x3e1ac2, 0xa514c1bc, 0xa514c3bc, 0x00000009, 0x0 }, /* #14 */
    { 0x222606, 0x222606, 0x65f9ac75, 0x65f9bc75, 0x0000000c, 0x0 }, /* #15 */
    { 0x1a4c06, 0x1a4c07, 0x9063bdf6, 0x9063bdf6, 0x0000001f, 0x0 }, /* #16 */
    { 0x3418c3, 0x3418c2, 0x01c13789, 0x21c13789, 0x0000001d, 0x0 }, /* #17 */
    { 0x2a7302, 0x2a7303, 0xd78f0d6b, 0xd78f0d6b, 0x00000000, 0x0 }, /* #18 */
    { 0x391ac6, 0x391ac6, 0x2f274cdf, 0x2f27ccdf, 0x0000000f, 0x0 }, /* #19 */
    { 0x271f86, 0x271f86, 0x1ec18f5e, 0x5ec18f5e, 0x0000001e, 0x0 }, /* #20 */
    { 0x0c0046, 0x0c0047, 0x83f62fc7, 0x83f62fc7, 0x00000016, 0x0 }, /* #21 */
    { 0x2050d2, 0x2050d3, 0xaf22ff2c, 0xaf22ff2c, 0x00000009, 0x0 }, /* #22 */
    { 0x325957, 0x325956, 0x8ccf6ebd, 0x8ecf6ebd, 0x00000019, 0x0 }, /* #23 */
    { 0x142e47, 0x142e46, 0xdd9706ce, 0xdd9707ce, 0x00000008, 0x0 }, /* #24 */
    { 0x334103, 0x334103, 0xec90aa2d, 0xec90aa2d, 0x0000001e, 0x0 }, /* #25 */
    { 0x2d67d6, 0x2d67d6, 0xcadf3992, 0xcadf399a, 0x00000003, 0x0 }, /* #26 */
    { 0x2a39c3, 0x2a39c2, 0x9abb8f6a, 0x9ebb8f6a, 0x0000001a, 0x0 }, /* #27 */
    { 0x296f12, 0x296f13, 0xfc9e6b52, 0xfc9e6b52, 0x0000000e, 0x0 }, /* #28 */
    { 0x2b2416, 0x2b2416, 0xd2e8c799, 0xd2e8c79b, 0x00000001, 0x0 }, /* #29 */
    { 0x050346, 0x050346, 0x4f3c213c, 0x4f3c213d, 0x00000000, 0x0 }, /* #30 */
    { 0x222e83, 0x222e83, 0x0b6ac04b, 0x0b6ac04b, 0x00000018, 0x0 }, /* #31 */
    { 0x1c7992, 0x1c7992, 0x1f9a608c, 0x1fda608c, 0x00000016, 0x0 }, /* #32 */
    { 0x0e5817, 0x0e5817, 0x3283a7f4, 0x3283a7f4, 0x00000009, 0x0 }, /* #33 */
    { 0x3b4487, 0x3b4486, 0xd99ee9dc, 0xd99ef9dc, 0x0000000c, 0x0 }, /* #34 */
    { 0x3a2702, 0x3a2703, 0xf4f16f17, 0xf4f16f17, 0x00000014, 0x0 }, /* #35 */
    { 0x3424c2, 0x3424c3, 0xfdc41608, 0xfdc41608, 0x0000001f, 0x0 }, /* #36 */
    { 0x0a07d6, 0x0a07d7, 0x22d486bd, 0x22d486bd, 0x00000004, 0x0 }, /* #37 */
    { 0x2a4892, 0x2a4893, 0x52803d29, 0x52803d29, 0x00000008, 0x0 }, /* #38 */
    { 0x3d0146, 0x3d0147, 0x3329683c, 0x3329683c, 0x0000000d, 0x0 }, /* #39 */
    { 0x146fd7, 0x146fd6, 0x955615e4, 0x975615e4, 0x00000019, 0x0 }, /* #40 */
    { 0x392b47, 0x392b47, 0x6542b47a, 0x6542b47a, 0x0000000a, 0x0 }, /* #41 */
    { 0x093813, 0x093812, 0xecb86f4c, 0xecf86f4c, 0x00000016, 0x0 }, /* #42 */
    { 0x3b5b46, 0x3b5b47, 0x5bac4cce, 0x5bac4cce, 0x0000000e, 0x0 }, /* #43 */
    { 0x2f6d97, 0x2f6d96, 0x756d676e, 0x757d676e, 0x00000014, 0x0 }, /* #44 */
    { 0x2878c6, 0x2878c6, 0x8793c97e, 0x8793d97e, 0x0000000c, 0x0 }, /* #45 */
    { 0x2c4b87, 0x2c4b87, 0xd2cbfc46, 0xd2cbfc46, 0x00000016, 0x0 }, /* #46 */
    { 0x125746, 0x125746, 0x9aff08be, 0x9aff0cbe, 0x0000000a, 0x0 }, /* #47 */
    { 0x0c6742, 0x0c6742, 0x1ea58ae5, 0x5ea58ae5, 0x0000001e, 0x0 }, /* #48 */
    { 0x3f0083, 0x3f0082, 0x3a93359e, 0x3a93b59e, 0x0000000f, 0x0 }, /* #49 */
    { 0x096cd6, 0x096cd6, 0xda8bfe2b, 0xfa8bfe2b, 0x0000001d, 0x0 }, /* #50 */
    { 0x353b03, 0x353b03, 0xacc209f3, 0xacc209f3, 0x00000011, 0x0 }, /* #51 */
    { 0x390552, 0x390553, 0x5c34bae4, 0x5c34bae4, 0x00000012, 0x0 }, /* #52 */
    { 0x223c13, 0x223c13, 0x781ca434, 0x781ca434, 0x0000000a, 0x0 }, /* #53 */
    { 0x3e02d6, 0x3e02d6, 0x8682f746, 0xc682f746, 0x0000001e, 0x0 }, /* #54 */
    { 0x1522c7, 0x1522c6, 0x661277c4, 0xe61277c4, 0x0000001f, 0x0 }, /* #55 */
    { 0x102e42, 0x102e42, 0xaa0c5968, 0xaa1c5968, 0x00000014, 0x0 }, /* #56 */
    { 0x381d12, 0x381d13, 0x7ae8a41f, 0x7ae8a41f, 0x00000015, 0x0 }, /* #57 */
    { 0x305097, 0x305096, 0x4d48f7fa, 0xcd48f7fa, 0x0000001f, 0x0 }, /* #58 */
    { 0x237417, 0x237417, 0x0049ed25, 0x0049ed25, 0x0000000d, 0x0 }, /* #59 */
    { 0x086292, 0x086292, 0xcd559082, 0xcd579082, 0x00000011, 0x0 }, /* #60 */
    { 0x047013, 0x047013, 0xb4ed60ca, 0xb4ed60ca, 0x0000001d, 0x0 }, /* #61 */
    { 0x291bc3, 0x291bc3, 0x7ed88972, 0x7ed88972, 0x00000006, 0x0 }, /* #62 */
    { 0x390457, 0x390456, 0x06838fdb, 0x46838fdb, 0x0000001e, 0x0 }, /* #63 */
    { 0x3408c6, 0x3408c7, 0xa3e03944, 0xa3e03944, 0x00000019, 0x0 }, /* #64 */
    { 0x3429c2, 0x3429c3, 0x49a31ef4, 0x49a31ef4, 0x00000002, 0x0 }, /* #65 */
    { 0x384d03, 0x384d03, 0x49762151, 0x49762151, 0x0000001b, 0x0 }, /* #66 */
    { 0x263402, 0x263403, 0x41d71eaf, 0x41d71eaf, 0x00000002, 0x0 }, /* #67 */
    { 0x137742, 0x137743, 0x5349c4a5, 0x5349c4a5, 0x00000007, 0x0 }, /* #68 */
    { 0x3b2dc2, 0x3b2dc2, 0xdce98de6, 0xdceb8de6, 0x00000011, 0x0 }, /* #69 */
    { 0x186442, 0x186443, 0xb8db1fcc, 0xb8db1fcc, 0x0000000c, 0x0 }, /* #70 */
    { 0x365cc3, 0x365cc2, 0xe0752560, 0xe1752560, 0x00000018, 0x0 }, /* #71 */
    { 0x372653, 0x372652, 0x6e1e2bb5, 0x6e3e2bb5, 0x00000015, 0x0 }, /* #72 */
    { 0x2a5013, 0x2a5012, 0xae87e47b, 0xae87e67b, 0x00000009, 0x0 }, /* #73 */
    { 0x085dd6, 0x085dd7, 0x6dfb428e, 0x6dfb428e, 0x00000013, 0x0 }, /* #74 */
    { 0x096d12, 0x096d12, 0xa5e6d70f, 0xa5e6d74f, 0x00000006, 0x0 }, /* #75 */
    { 0x1c5342, 0x1c5342, 0x914ea005, 0x914ea405, 0x0000000a, 0x0 }, /* #76 */
    { 0x0b5bc3, 0x0b5bc3, 0x5a7ebb6e, 0x5a7ebb6e, 0x0000001c, 0x0 }, /* #77 */
    { 0x0a0457, 0x0a0457, 0x061cfe97, 0x061cfe97, 0x0000000b, 0x0 }, /* #78 */
    { 0x227797, 0x227796, 0xa41c87f1, 0xa45c87f1, 0x00000016, 0x0 }, /* #79 */
    { 0x1075c6, 0x1075c7, 0xc8554430, 0xc8554430, 0x00000010, 0x0 }, /* #80 */
    { 0x060d16, 0x060d17, 0xae2d58a4, 0xae2d58a4, 0x00000013, 0x0 }, /* #81 */
    { 0x3003c7, 0x3003c7, 0x35b89b86, 0x35b89b86, 0x00000017, 0x0 }, /* #82 */
    { 0x215053, 0x215052, 0xbbc7eedf, 0xfbc7eedf, 0x0000001e, 0x0 }, /* #83 */
    { 0x2731c2, 0x2731c2, 0xe48a0a58, 0xf48a0a58, 0x0000001c, 0x0 }, /* #84 */
    { 0x292397, 0x292396, 0x519f013c, 0x519f017c, 0x00000006, 0x0 }, /* #85 */
    { 0x184056, 0x184057, 0xf36f62c4, 0xf36f62c4, 0x0000001c, 0x0 }, /* #86 */
    { 0x103f52, 0x103f53, 0x52ae8c9c, 0x52ae8c9c, 0x00000015, 0x0 }, /* #87 */
    { 0x1f70c3, 0x1f70c2, 0xb12a5449, 0xf12a5449, 0x0000001e, 0x0 }, /* #88 */
    { 0x296043, 0x296043, 0x1aae8773, 0x1aae8773, 0x00000012, 0x0 }, /* #89 */
    { 0x356ed2, 0x356ed3, 0xac6231d6, 0xac6231d6, 0x00000011, 0x0 }, /* #90 */
    { 0x024212, 0x024212, 0x006e7b3f, 0x006e7b7f, 0x00000006, 0x0 }, /* #91 */
    { 0x1476c6, 0x1476c7, 0x5dd10798, 0x5dd10798, 0x00000008, 0x0 }, /* #92 */
    { 0x1b2557, 0x1b2557, 0x1ccb231e, 0x1ccb231e, 0x00000009, 0x0 }, /* #93 */
    { 0x367b57, 0x367b57, 0x5285a6cf, 0x5285a6cf, 0x0000000a, 0x0 }, /* #94 */
    { 0x3c4106, 0x3c4106, 0x37a99516, 0x37a99d16, 0x0000000b, 0x0 }, /* #95 */
};
uint32_t const g_cTests_bts_u32_locked = RT_ELEMENTS(g_aTests_bts_u32_locked);

BINU64_TEST_T const g_aTests_add_u64[] =
{
    { 0x2e0997, 0x2e0146, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x304983, 0x304146, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x351b13, 0x351346, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x185582, 0x185546, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x036c52, 0x036446, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x2b0d93, 0x2b0546, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x1b0756, 0x1b0706, 0x26b0914f84ae886a, 0x26b0914f84ae886a, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x394793, 0x394706, 0x6dc481594f76049a, 0x6dc481594f76049a, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x3c3896, 0x3c3006, 0x16ed1478ad23c869, 0x16ed1478ad23c869, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x376a52, 0x376282, 0xbf6fd8f974a63ca1, 0xbf6fd8f974a63ca1, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x2c36c7, 0x2c3682, 0xaf732acdd08de531, 0xaf732acdd08de531, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x301d16, 0x301582, 0xf1e858b7182655a2, 0xf1e858b7182655a2, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x317ad3, 0x317207, 0x58ec7d24a3379300, 0x0dfecb4472cde73a, 0xb5124e1fcf96543a, 0x0 }, /* #12 */
    { 0x3e1952, 0x3e1112, 0x67d4c20d714add8b, 0x6e685b347a3b7d10, 0x0693992708f09f85, 0x0 }, /* #13 */
    { 0x146052, 0x146007, 0xdf7aa18fb14cc270, 0x0d5d1d6a1f7d3c65, 0x2de27bda6e3079f5, 0x0 }, /* #14 */
    { 0x015b52, 0x015b82, 0x108c97c690e8f0c8, 0x89e46f2ead868f3e, 0x7957d7681c9d9e76, 0x0 }, /* #15 */
    { 0x006093, 0x006086, 0xaf0d860c2a239be0, 0xf8d3fec9649a9042, 0x49c678bd3a76f462, 0x0 }, /* #16 */
    { 0x1d6c42, 0x1d6403, 0x6b66141c569f8b26, 0x15368ce8f87fe9e9, 0xa9d078cca1e05ec3, 0x0 }, /* #17 */
    { 0x3044c3, 0x304406, 0x22241cc91ea8e10d, 0x4b14b37b7a5ce3cf, 0x28f096b25bb402c2, 0x0 }, /* #18 */
    { 0x1a0a07, 0x1a0287, 0xed5e8394c79b5cd0, 0xb92e107638778012, 0xcbcf8ce170dc2342, 0x0 }, /* #19 */
    { 0x1f2486, 0x1f2486, 0xc132651493105fa6, 0xe4c7e4532337b8dd, 0x23957f3e90275937, 0x0 }, /* #20 */
    { 0x2b4c42, 0x2b4496, 0xe3f237a6c0fe2ddd, 0xf4f69dae85ce0205, 0x11046607c4cfd428, 0x0 }, /* #21 */
    { 0x120093, 0x120013, 0x3cd30c0487e105db, 0x14cd98bea8057943, 0xd7fa8cba20247368, 0x0 }, /* #22 */
    { 0x0c5686, 0x0c5607, 0xf218f333308f32cc, 0x37cc08ae387bb84d, 0x45b3157b07ec8581, 0x0 }, /* #23 */
    { 0x3475c2, 0x347592, 0xb3005b0227d06cce, 0xf329e3a4e4f11729, 0x402988a2bd20aa5b, 0x0 }, /* #24 */
    { 0x3f3896, 0x3f3012, 0x1e0babc83bd68256, 0x6f0e09ac90986151, 0x51025de454c1defb, 0x0 }, /* #25 */
    { 0x0c2b13, 0x0c2302, 0x02c51b5dff18dad0, 0x6694be816c04aec4, 0x63cfa3236cebd3f4, 0x0 }, /* #26 */
    { 0x286493, 0x286413, 0x99b7703913c2ff82, 0x005201b1538e2bb0, 0x669a91783fcb2c2e, 0x0 }, /* #27 */
    { 0x1d4bc3, 0x1d4b92, 0x3278ffe567628637, 0xa496ddd2f78d0651, 0x721ddded902a801a, 0x0 }, /* #28 */
    { 0x201e87, 0x201e92, 0x7e8bf44d30a9fee7, 0xcc710c5effc4bea2, 0x4de51811cf1abfbb, 0x0 }, /* #29 */
    { 0x3c0dd2, 0x3c0d82, 0x1ed113748b84d4f6, 0x85de22f7356cbe26, 0x670d0f82a9e7e930, 0x0 }, /* #30 */
    { 0x001a43, 0x001a07, 0xc9796876ee7b50d7, 0x5f0afa4ef25cd26f, 0x959191d803e18198, 0x0 }, /* #31 */
    { 0x3d5006, 0x3d5003, 0xddca8ee2fee71e3b, 0x3df80887c7670cdc, 0x602d79a4c87feea1, 0x0 }, /* #32 */
    { 0x333397, 0x333313, 0xf88e1f5392c7e038, 0x2c8d2ec97651a210, 0x33ff0f75e389c1d8, 0x0 }, /* #33 */
    { 0x396896, 0x396082, 0x80c63e8da9e90c9d, 0xb9d38432f0feae9e, 0x390d45a54715a201, 0x0 }, /* #34 */
    { 0x144387, 0x144386, 0x6589c4a43abfa4b9, 0xed77c4306c4084be, 0x87edff8c3180e005, 0x0 }, /* #35 */
    { 0x217996, 0x217107, 0x571b391ed736f373, 0x0c6ba10848f343cc, 0xb55067e971bc5059, 0x0 }, /* #36 */
    { 0x3e7647, 0x3e7687, 0xcbac63807549c69c, 0xc4eece0462fa375f, 0xf9426a83edb070c3, 0x0 }, /* #37 */
    { 0x140792, 0x140786, 0x3d85a90da58b9076, 0xcb4c0bb3481a677e, 0x8dc662a5a28ed708, 0x0 }, /* #38 */
    { 0x097106, 0x097196, 0xab1ce13e7e40cbaf, 0xd4c9dc0f469048f0, 0x29acfad0c84f7d41, 0x0 }, /* #39 */
    { 0x0256c7, 0x025e82, 0x7752abd111201436, 0xca19f77782f06ace, 0x52c74ba671d05698, 0x0 }, /* #40 */
    { 0x1d2a47, 0x1d2296, 0xdc96ee910024e5fd, 0xdd76682fe5e7c212, 0x00df799ee5c2dc15, 0x0 }, /* #41 */
    { 0x250352, 0x250383, 0xb6402b0b8f3a4174, 0xb2ed1ad2e88da3d5, 0xfcacefc759536261, 0x0 }, /* #42 */
    { 0x0f4852, 0x0f4012, 0x46179d664dc0740a, 0x46cef2c21c280f46, 0x00b7555bce679b3c, 0x0 }, /* #43 */
    { 0x062712, 0x062f92, 0x64e08e1bb85e3a45, 0xe43633243e20ba01, 0x7f55a50885c27fbc, 0x0 }, /* #44 */
    { 0x0621d7, 0x062907, 0x8b46ef5c330cb523, 0x4c589af9ca46a77d, 0xc111ab9d9739f25a, 0x0 }, /* #45 */
    { 0x195d52, 0x195d13, 0x91caff18fcb23cd8, 0x59376340706ff291, 0xc76c642773bdb5b9, 0x0 }, /* #46 */
    { 0x223c52, 0x223492, 0x2902110237e3a23e, 0xb12f563972601832, 0x882d45373a7c75f4, 0x0 }, /* #47 */
    { 0x0c6052, 0x0c6087, 0xb627d573278d6050, 0x8584dc7665aeb4af, 0xcf5d07033e21545f, 0x0 }, /* #48 */
    { 0x2e6702, 0x2e6796, 0x1653ae1e63f5565f, 0xab2478fe00e8db5c, 0x94d0cadf9cf384fd, 0x0 }, /* #49 */
    { 0x1a3416, 0x1a3407, 0x68b533491c90fd63, 0x36653be4b99be6ac, 0xcdb0089b9d0ae949, 0x0 }, /* #50 */
    { 0x0e0287, 0x0e0a82, 0x7b06330a7fa9d023, 0xd7baf79f8c5523c7, 0x5cb4c4950cab53a4, 0x0 }, /* #51 */
    { 0x077e16, 0x077686, 0x65d057931dc32fd8, 0xf523105d9a32c9a9, 0x8f52b8ca7c6f99d1, 0x0 }, /* #52 */
    { 0x074e86, 0x074606, 0x330d6759064148f7, 0x504e099ea014d52b, 0x1d40a24599d38c34, 0x0 }, /* #53 */
    { 0x330153, 0x330117, 0x73200b7444bbc0ac, 0x01503acd8e457cf0, 0x8e302f594989bc44, 0x0 }, /* #54 */
    { 0x342b12, 0x342313, 0xdf7bfb0ceccb15ee, 0x210e58b3f29950f7, 0x41925da705ce3b09, 0x0 }, /* #55 */
    { 0x097047, 0x097092, 0x467781020412cc72, 0xfd4ecc8aabb11761, 0xb6d74b88a79e4aef, 0x0 }, /* #56 */
    { 0x305687, 0x305696, 0x1b5fcc3067db5d34, 0xc60a85dd2c8e4981, 0xaaaab9acc4b2ec4d, 0x0 }, /* #57 */
    { 0x2359c6, 0x235182, 0x00e1ae66efa50e24, 0xb03b2befe11ae2bf, 0xaf597d88f175d49b, 0x0 }, /* #58 */
    { 0x292992, 0x292103, 0x3b62154558669750, 0x2740f8f6b4f77dcd, 0xebdee3b15c90e67d, 0x0 }, /* #59 */
    { 0x100787, 0x100717, 0x7e41db0347d4d143, 0x77d8d7003749b5d2, 0xf996fbfcef74e48f, 0x0 }, /* #60 */
    { 0x080507, 0x080587, 0xeeed1b1f4a1d51d1, 0x98f47229e35f5903, 0xaa07570a99420732, 0x0 }, /* #61 */
    { 0x1d7642, 0x1d7e92, 0x32c417e8f02f070a, 0x90edbd5b36119802, 0x5e29a57245e290f8, 0x0 }, /* #62 */
    { 0x300792, 0x300707, 0xee35f76f05075dd0, 0x5185807800aa51b8, 0x634f8908fba2f3e8, 0x0 }, /* #63 */
    { 0x3b6286, 0x3b6a96, 0x67bda7bfed22aea2, 0xa03edb700fd95e81, 0x388133b022b6afdf, 0x0 }, /* #64 */
    { 0x3848d7, 0x384087, 0xdaf5a11281ae6051, 0x95d1a168110d880f, 0xbadc00558f5f27be, 0x0 }, /* #65 */
    { 0x056cd6, 0x056c86, 0x77f9200847342e91, 0xac62b5d24858dab4, 0x346995ca0124ac23, 0x0 }, /* #66 */
    { 0x396a12, 0x396217, 0x2ba1b6bc8e2cc9b6, 0x21773505054d2822, 0xf5d57e4877205e6c, 0x0 }, /* #67 */
    { 0x033dd6, 0x033d07, 0x81763247f2e7d2e3, 0x272984e254bdd31e, 0xa5b3529a61d6003b, 0x0 }, /* #68 */
    { 0x335e46, 0x335e96, 0x7a0cc1846a37fa12, 0xa96eab082c0168a0, 0x2f61e983c1c96e8e, 0x0 }, /* #69 */
    { 0x215117, 0x215116, 0x0ec4d512c75441d7, 0x1bf4ec76dab6f203, 0x0d3017641362b02c, 0x0 }, /* #70 */
    { 0x0e7616, 0x0e7687, 0xeab4553d85802165, 0xa92ba0e056dbed8e, 0xbe774ba2d15bcc29, 0x0 }, /* #71 */
    { 0x257bc6, 0x257312, 0x13767c995f301cbe, 0x706dac32c74fc2e9, 0x5cf72f99681fa62b, 0x0 }, /* #72 */
    { 0x003bd3, 0x003302, 0x000c56db12507cc2, 0x32b8e0022c46f864, 0x32ac892719f67ba2, 0x0 }, /* #73 */
    { 0x1771c6, 0x177913, 0x935b9b43ff8e54dc, 0x6e1bff2128e6b531, 0xdac063dd29586055, 0x0 }, /* #74 */
    { 0x2a0496, 0x2a0407, 0xefd2c8cbe72fbdef, 0x197bd199aba6d2cf, 0x29a908cdc47714e0, 0x0 }, /* #75 */
    { 0x013d96, 0x013507, 0xbac5870ef323efd8, 0x21359e7103f34c39, 0x6670176210cf5c61, 0x0 }, /* #76 */
    { 0x1d4382, 0x1d4b13, 0xb1aed0954c479a9a, 0x6db2ad86227b9313, 0xbc03dcf0d633f879, 0x0 }, /* #77 */
    { 0x1d0d83, 0x1d0d86, 0x48909b977fb6977b, 0xb953a8b3953b851b, 0x70c30d1c1584eda0, 0x0 }, /* #78 */
    { 0x1e3c07, 0x1e3407, 0xdcf7387bac775906, 0x478d9b44b0920466, 0x6a9662c9041aab60, 0x0 }, /* #79 */
    { 0x151747, 0x151786, 0xc636033e8b7ff8b5, 0xe065d90dbdcd6828, 0x1a2fd5cf324d6f73, 0x0 }, /* #80 */
    { 0x114ad6, 0x114283, 0xf067ad437247e4c0, 0xee1e6aea1eee31ae, 0xfdb6bda6aca64cee, 0x0 }, /* #81 */
    { 0x3562c6, 0x356a07, 0x8041cec68ce15a3d, 0x02f954fde452a59f, 0x82b7863757714b62, 0x0 }, /* #82 */
    { 0x0e1587, 0x0e1512, 0x0183492d5d24560f, 0x769a132ca01f4bba, 0x7516c9ff42faf5ab, 0x0 }, /* #83 */
    { 0x366407, 0x366417, 0xd84c18191f83fa5d, 0x171caa86831440db, 0x3ed0926d6390467e, 0x0 }, /* #84 */
    { 0x0813d7, 0x081392, 0xbce3e2bd0a4d730d, 0xc14448c96bf4eda4, 0x0460660c61a77a97, 0x0 }, /* #85 */
    { 0x205657, 0x205612, 0x6900dd2b6ba9fbec, 0x7e7e10db52a48ca2, 0x157d33afe6fa90b6, 0x0 }, /* #86 */
    { 0x3527d2, 0x352782, 0xbb86172623c9c43f, 0xececf577ca44b3bf, 0x3166de51a67aef80, 0x0 }, /* #87 */
    { 0x007a87, 0x007282, 0x98e6c1239e0100d0, 0xa90f45555bbc219e, 0x10288431bdbb20ce, 0x0 }, /* #88 */
    { 0x297006, 0x297002, 0x02c4d1d80a07a5f1, 0x2fe6d592d4a23f13, 0x2d2203baca9a9922, 0x0 }, /* #89 */
    { 0x0a7157, 0x0a7103, 0x294d6e4dd02d3351, 0x0cff270dd2d6f82a, 0xe3b1b8c002a9c4d9, 0x0 }, /* #90 */
    { 0x2f3fd7, 0x2f3f86, 0x338ce682d8c49736, 0x8b276989f441a13a, 0x579a83071b7d0a04, 0x0 }, /* #91 */
    { 0x256102, 0x256992, 0x7e6c288b906b48df, 0xcbbd569f007565f8, 0x4d512e13700a1d19, 0x0 }, /* #92 */
    { 0x236992, 0x236917, 0x847c950ba0c893ed, 0x73c726b352b2b60c, 0xef4a91a7b1ea221f, 0x0 }, /* #93 */
    { 0x2127d2, 0x212716, 0x06123275ebb29605, 0x68aa28438f7de393, 0x6297f5cda3cb4d8e, 0x0 }, /* #94 */
    { 0x153dc7, 0x153d92, 0x442b1e1b04a2cec5, 0xc01c12167f0ecb32, 0x7bf0f3fb7a6bfc6d, 0x0 }, /* #95 */
};
uint32_t const g_cTests_add_u64 = RT_ELEMENTS(g_aTests_add_u64);

BINU64_TEST_T const g_aTests_add_u64_locked[] =
{
    { 0x340d12, 0x340546, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x176ec2, 0x176646, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x175187, 0x175146, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x382d82, 0x382546, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x010a07, 0x010246, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x3c3453, 0x3c3446, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x1a4d42, 0x1a4502, 0x2db623047907690d, 0x2db623047907690d, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x196b43, 0x196386, 0xbb14d8d9024bbf7e, 0xbb14d8d9024bbf7e, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x2058d7, 0x205002, 0x75c727fe8972e5fb, 0x75c727fe8972e5fb, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x2e3946, 0x2e3182, 0xbe19dab931e9fc57, 0xbe19dab931e9fc57, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x186d43, 0x186502, 0x2ef9ed5de8fb76f8, 0x2ef9ed5de8fb76f8, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x085647, 0x085602, 0x2d189c164f1b08f1, 0x2d189c164f1b08f1, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x234787, 0x234717, 0x6ac7b4e798cce1fd, 0x3c958bdd1dfab865, 0xd1cdd6f5852dd668, 0x0 }, /* #12 */
    { 0x037452, 0x037412, 0x644efb8d67901b09, 0x656f005e203d5ff8, 0x012004d0b8ad44ef, 0x0 }, /* #13 */
    { 0x2c55c7, 0x2c5582, 0x44b27ada60bbd4c0, 0xc7c62745cc5f6373, 0x8313ac6b6ba38eb3, 0x0 }, /* #14 */
    { 0x2028d2, 0x202002, 0x3ff5e0fb1b6a6f55, 0x77249803dcc688fb, 0x372eb708c15c19a6, 0x0 }, /* #15 */
    { 0x112e13, 0x112686, 0xa199bedd24ae91b3, 0xd93564d8c16813a9, 0x379ba5fb9cb981f6, 0x0 }, /* #16 */
    { 0x2b4f42, 0x2b4717, 0x1432e53c93858aeb, 0x0c86b76951a44518, 0xf853d22cbe1eba2d, 0x0 }, /* #17 */
    { 0x355956, 0x355996, 0x63071c708edebebf, 0xb7f142e6c5d331bd, 0x54ea267636f472fe, 0x0 }, /* #18 */
    { 0x2b4547, 0x2b4d17, 0xd084cf697a3ac798, 0x754b112194627eb2, 0xa4c641b81a27b71a, 0x0 }, /* #19 */
    { 0x363807, 0x363892, 0x398cf6e45757fe29, 0x8ea1b2f4872c6ab5, 0x5514bc102fd46c8c, 0x0 }, /* #20 */
    { 0x2e53c6, 0x2e5b17, 0xa40fd8d84485ef2c, 0x4aab8156fdb1a9a6, 0xa69ba87eb92bba7a, 0x0 }, /* #21 */
    { 0x023306, 0x023306, 0x48f4bf5a4a947921, 0x7e37ef8515f83617, 0x3543302acb63bcf6, 0x0 }, /* #22 */
    { 0x287d56, 0x287583, 0xdb36289bc17e14b2, 0xb2d636c4ec1f45ae, 0xd7a00e292aa130fc, 0x0 }, /* #23 */
    { 0x0c7303, 0x0c7397, 0xe242c9e7dccc1e9b, 0xd57f8435411f6795, 0xf33cba4d645348fa, 0x0 }, /* #24 */
    { 0x3d3a83, 0x3d3297, 0x96e5e327d4aa355a, 0x88f72cc8fabde587, 0xf21149a12613b02d, 0x0 }, /* #25 */
    { 0x016986, 0x016183, 0xa19c2eba01eb0082, 0x95fc5ea959c200d9, 0xf4602fef57d70057, 0x0 }, /* #26 */
    { 0x2b3c96, 0x2b3482, 0x04d359d94e1ca640, 0xa500a98e59efe273, 0xa02d4fb50bd33c33, 0x0 }, /* #27 */
    { 0x372993, 0x372117, 0xd1a048f2161dc62d, 0x052f6f582e531814, 0x338f2666183551e7, 0x0 }, /* #28 */
    { 0x074f17, 0x074f13, 0xde37a16136ca1604, 0x73be391f121c8270, 0x958697bddb526c6c, 0x0 }, /* #29 */
    { 0x0a3857, 0x0a3017, 0xf653b207f99af93e, 0x4b2ba4428bf5e1f6, 0x54d7f23a925ae8b8, 0x0 }, /* #30 */
    { 0x2706d7, 0x270686, 0xcaad72091a6e341d, 0xe15e1052dabaa2ee, 0x16b09e49c04c6ed1, 0x0 }, /* #31 */
    { 0x2d0d07, 0x2d0503, 0x5d6ac5a1aabe638b, 0x0259afef080abf0d, 0xa4eeea4d5d4c5b82, 0x0 }, /* #32 */
    { 0x007853, 0x007087, 0xb85a26dcbd49133e, 0x99c2313b5101594e, 0xe1680a5e93b84610, 0x0 }, /* #33 */
    { 0x2c7586, 0x2c7596, 0x232e87f4ba20d31e, 0xcfd03d8b35f85569, 0xaca1b5967bd7824b, 0x0 }, /* #34 */
    { 0x3d6652, 0x3d6683, 0xac7d5d2e31e24be2, 0x85b0e2c372606a9d, 0xd9338595407e1ebb, 0x0 }, /* #35 */
    { 0x047a82, 0x047a86, 0x708814d4c3605971, 0xede5b93fc98dbdc9, 0x7d5da46b062d6458, 0x0 }, /* #36 */
    { 0x163bd6, 0x163316, 0x28808070f994ebcf, 0x2ee21a5bbb6f7ade, 0x066199eac1da8f0f, 0x0 }, /* #37 */
    { 0x0533d2, 0x053386, 0xc5f9067fb8a7e17b, 0xcf6ca191260ea42d, 0x09739b116d66c2b2, 0x0 }, /* #38 */
    { 0x3c1a56, 0x3c1212, 0x26ed043d187cfe9a, 0x3b16379a98360373, 0x1429335d7fb904d9, 0x0 }, /* #39 */
    { 0x067d86, 0x067d07, 0x87d0b8406c30eaf1, 0x2743ebe6fbb7eefa, 0x9f7333a68f870409, 0x0 }, /* #40 */
    { 0x154c13, 0x154c07, 0x980b9d2289a33fa8, 0x6bf6b86e23477d69, 0xd3eb1b4b99a43dc1, 0x0 }, /* #41 */
    { 0x1d5e06, 0x1d5697, 0xd35bbdee6c1f78fd, 0xc5d724fcdbeb69b4, 0xf27b670e6fcbf0b7, 0x0 }, /* #42 */
    { 0x342f53, 0x342f86, 0x59f1b25841bdef52, 0xb9b20f16dac25303, 0x5fc05cbe990463b1, 0x0 }, /* #43 */
    { 0x037993, 0x037903, 0x9149c1abb0ebf29d, 0x3dfec1cc9ea9c09e, 0xacb50020edbdce01, 0x0 }, /* #44 */
    { 0x0609c2, 0x060113, 0xf4f66e5650efcc3c, 0x1ed3792cb62817ba, 0x29dd0ad665384b7e, 0x0 }, /* #45 */
    { 0x2910d3, 0x291013, 0xe3fce7b550d01e9f, 0x212f8b80407c7ed9, 0x3d32a3caefac603a, 0x0 }, /* #46 */
    { 0x002ec3, 0x002687, 0xf2866c1aa3203a31, 0xe9faf00b9686b1b1, 0xf77483f0f3667780, 0x0 }, /* #47 */
    { 0x115cd2, 0x115492, 0x0f17f6d6378ba56e, 0xb4e50741e31dce8c, 0xa5cd106bab92291e, 0x0 }, /* #48 */
    { 0x155f46, 0x155792, 0x26897659332962ba, 0xec5f7e10627c0851, 0xc5d607b72f52a597, 0x0 }, /* #49 */
    { 0x3c7452, 0x3c7482, 0x093b6fa35eb9d8f0, 0x908c40fce46b017a, 0x8750d15985b1288a, 0x0 }, /* #50 */
    { 0x2b5c93, 0x2b5487, 0xb817706f2a1d40ca, 0xa309f6233f63491e, 0xeaf285b415460854, 0x0 }, /* #51 */
    { 0x2c3f42, 0x2c3706, 0x08bec0b81ba34e36, 0x79b62dc8b300a9db, 0x70f76d10975d5ba5, 0x0 }, /* #52 */
    { 0x096d46, 0x096512, 0x384b586acbbf45ed, 0x7a41fe946965f651, 0x41f6a6299da6b064, 0x0 }, /* #53 */
    { 0x3d4f96, 0x3d4703, 0xda7953137aa8c6f6, 0x240c69d4df59752c, 0x499316c164b0ae36, 0x0 }, /* #54 */
    { 0x170f82, 0x170782, 0x89b4cae0a5ee7acb, 0xf3cd925b1326f5bf, 0x6a18c77a6d387af4, 0x0 }, /* #55 */
    { 0x1f24c2, 0x1f2c82, 0x0fa90ca9ac3a2c20, 0x86eab49b9e053fc1, 0x7741a7f1f1cb13a1, 0x0 }, /* #56 */
    { 0x0f1882, 0x0f1002, 0x165491636c5b3ca7, 0x198c46255dc81868, 0x0337b4c1f16cdbc1, 0x0 }, /* #57 */
    { 0x012d87, 0x012507, 0xff5eb75440a991a4, 0x05bbf0a8df0d73fa, 0x065d39549e63e256, 0x0 }, /* #58 */
    { 0x1a0a47, 0x1a0207, 0x0fe6ed92838afec4, 0x0bca8856bb755ca6, 0xfbe39ac437ea5de2, 0x0 }, /* #59 */
    { 0x392213, 0x392a86, 0x6d689c912376bf15, 0x92e6fe633c2bd1ff, 0x257e61d218b512ea, 0x0 }, /* #60 */
    { 0x075986, 0x075192, 0x27aea62d460103f9, 0xbc0fb250ad7372c4, 0x94610c2367726ecb, 0x0 }, /* #61 */
    { 0x383692, 0x383693, 0xe3531c727ee17d0d, 0xe1bb0eaad529c852, 0xfe67f23856484b45, 0x0 }, /* #62 */
    { 0x027312, 0x027396, 0xafdbd527a2b1ff0f, 0xc9b0e7f3fd419959, 0x19d512cc5a8f9a4a, 0x0 }, /* #63 */
    { 0x145b43, 0x145387, 0xb3c9b22ff1222d40, 0x9417d283cee63fc5, 0xe04e2053ddc41285, 0x0 }, /* #64 */
    { 0x1867c6, 0x186782, 0x26fbd215d1de54dc, 0xb5fc0a23e94bf48c, 0x8f00380e176d9fb0, 0x0 }, /* #65 */
    { 0x114492, 0x114417, 0xe9a3c6c066ef87ae, 0x130fadb139940784, 0x296be6f0d2a47fd6, 0x0 }, /* #66 */
    { 0x066597, 0x066506, 0x506a2cb69a6aba43, 0x673509a565d34417, 0x16cadceecb6889d4, 0x0 }, /* #67 */
    { 0x3126d7, 0x312e92, 0x46e674f1a9480baa, 0x9cdf31136dac0a34, 0x55f8bc21c463fe8a, 0x0 }, /* #68 */
    { 0x202092, 0x202087, 0xcb65e0ba57c82ef5, 0x89eadeb22f6643be, 0xbe84fdf7d79e14c9, 0x0 }, /* #69 */
    { 0x255f93, 0x255797, 0xdda0376146134ade, 0xb8b88544a531e427, 0xdb184de35f1e9949, 0x0 }, /* #70 */
    { 0x0965d3, 0x096507, 0xe3834bdbf5572947, 0x168e935e65dfd7de, 0x330b47827088ae97, 0x0 }, /* #71 */
    { 0x186d53, 0x186516, 0x5a324d1aca00993d, 0x5d931f5a12686333, 0x0360d23f4867c9f6, 0x0 }, /* #72 */
    { 0x1105d3, 0x110d13, 0x8a936c28c06fdf0f, 0x4e4e20e31a35f8c7, 0xc3bab4ba59c619b8, 0x0 }, /* #73 */
    { 0x325793, 0x325f86, 0x39fc72e69a9f8190, 0xadee7dacd409e18b, 0x73f20ac6396a5ffb, 0x0 }, /* #74 */
    { 0x307486, 0x307492, 0xa3e310aa191dd02a, 0xa54cc2050a0f26e6, 0x0169b15af0f156bc, 0x0 }, /* #75 */
    { 0x2c59c6, 0x2c5102, 0x33040601b9cafd45, 0x46f790bc02c6d949, 0x13f38aba48fbdc04, 0x0 }, /* #76 */
    { 0x0d4103, 0x0d4196, 0x0ab87224ee8e064d, 0x9269a9de36eb1f21, 0x87b137b9485d18d4, 0x0 }, /* #77 */
    { 0x336b83, 0x336307, 0xb567512db5c66b80, 0x042abec468edd624, 0x4ec36d96b3276aa4, 0x0 }, /* #78 */
    { 0x0b0fc3, 0x0b0792, 0x876168fc1adee2f6, 0xb9585f1b4dad8380, 0x31f6f61f32cea08a, 0x0 }, /* #79 */
    { 0x2941c2, 0x294917, 0x9692f369ecfd556a, 0x219174f3f2898dd8, 0x8afe818a058c386e, 0x0 }, /* #80 */
    { 0x0a7202, 0x0a7a82, 0x3c1bd97cc79f4ce5, 0x93e1bc3dd1a66cd9, 0x57c5e2c10a071ff4, 0x0 }, /* #81 */
    { 0x0d7e12, 0x0d7696, 0x4c9e17257f5542af, 0xe096f3df4b623941, 0x93f8dcb9cc0cf692, 0x0 }, /* #82 */
    { 0x1d1297, 0x1d1216, 0x42cc51ee988245ac, 0x676c2ddcae849218, 0x249fdbee16024c6c, 0x0 }, /* #83 */
    { 0x234582, 0x234d13, 0xbd6f694b8ebab5c8, 0x59cb2b4e129869f2, 0x9c5bc20283ddb42a, 0x0 }, /* #84 */
    { 0x1a7593, 0x1a7d82, 0x7f596968040ab189, 0x880f1609c283023b, 0x08b5aca1be7850b2, 0x0 }, /* #85 */
    { 0x1369c7, 0x136186, 0xb63b6bc49c03b0ba, 0xc0a6ded2f43f9fdd, 0x0a6b730e583bef23, 0x0 }, /* #86 */
    { 0x340817, 0x340082, 0x8b3234afcf70993d, 0x96cd1ceb018c9e4f, 0x0b9ae83b321c0512, 0x0 }, /* #87 */
    { 0x095c96, 0x095482, 0x856db0c57046a378, 0xe825363c3f87c7dc, 0x62b78576cf412464, 0x0 }, /* #88 */
    { 0x2c06c2, 0x2c0696, 0x8cf97f9d232e0f1d, 0xab4bab5241ced1b2, 0x1e522bb51ea0c295, 0x0 }, /* #89 */
    { 0x0259d2, 0x025197, 0xe1c83ee91f49e974, 0x9c2fc1b4486e5230, 0xba6782cb292468bc, 0x0 }, /* #90 */
    { 0x1427d3, 0x142f13, 0x891d2e101f80696e, 0x51ed9cc0280d51ad, 0xc8d06eb0088ce83f, 0x0 }, /* #91 */
    { 0x224286, 0x224a07, 0xdf7db8718f877397, 0x76500263eac7f26c, 0x96d249f25b407ed5, 0x0 }, /* #92 */
    { 0x391dc6, 0x391586, 0xb5eb2c76436fbe82, 0xf79cd39fe770f606, 0x41b1a729a4013784, 0x0 }, /* #93 */
    { 0x3655d6, 0x365513, 0xa61cb95ab9b0cd5c, 0x1b74f33365d2988a, 0x755839d8ac21cb2e, 0x0 }, /* #94 */
    { 0x0e3d52, 0x0e3597, 0xa17f11d5fe7a609a, 0xa1717aaf91944ef3, 0xfff268d99319ee59, 0x0 }, /* #95 */
};
uint32_t const g_cTests_add_u64_locked = RT_ELEMENTS(g_aTests_add_u64_locked);

BINU64_TEST_T const g_aTests_adc_u64[] =
{
    { 0x140e82, 0x140646, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x3a18d3, 0x3a1002, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x371f52, 0x371746, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x2c7893, 0x2c7002, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x355353, 0x355302, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x2a0453, 0x2a0402, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x0a3542, 0x0a3502, 0x5423c3acd2032380, 0x5423c3acd2032380, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x1d7012, 0x1d7006, 0x5f92febb629a785f, 0x5f92febb629a785f, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x254313, 0x254306, 0x281d5c009c928316, 0x281d5c009c928317, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x297057, 0x297006, 0x392d1ee3016b80e7, 0x392d1ee3016b80e8, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x104a86, 0x104286, 0xcf07c7a3273a6f88, 0xcf07c7a3273a6f88, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x2743d2, 0x274302, 0x4875ae8f1e90f2c8, 0x4875ae8f1e90f2c8, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x227413, 0x227496, 0x4aa7f5fa3df69a0a, 0xdd4c820449637103, 0x92a48c0a0b6cd6f8, 0x0 }, /* #12 */
    { 0x3c7213, 0x3c7293, 0xf451c14acd36f43f, 0xdaf8f931b3056df4, 0xe6a737e6e5ce79b4, 0x0 }, /* #13 */
    { 0x3f1593, 0x3f1512, 0x074e163b457bd46d, 0x481d385f94a96de0, 0x40cf22244f2d9972, 0x0 }, /* #14 */
    { 0x376ac2, 0x376207, 0xe61952233fd260bb, 0x500fb3fc6e7eafbb, 0x69f661d92eac4f00, 0x0 }, /* #15 */
    { 0x192017, 0x192087, 0xe5dfa45f53994bc3, 0x8162c9a39ac6e32e, 0x9b832544472d976a, 0x0 }, /* #16 */
    { 0x372083, 0x372082, 0x1f9d656e7edc92c0, 0xa6f3280688cc6d98, 0x8755c29809efdad7, 0x0 }, /* #17 */
    { 0x272dd2, 0x272503, 0xfc5ae938bed18f15, 0x764a93b36ae71b9d, 0x79efaa7aac158c88, 0x0 }, /* #18 */
    { 0x054f06, 0x054783, 0xcf8abf682f20c4b5, 0x928a428cbbc0ccc7, 0xc2ff83248ca00812, 0x0 }, /* #19 */
    { 0x2d3656, 0x2d3e07, 0x976614d01eebf940, 0x17c5d248d7a94d65, 0x805fbd78b8bd5425, 0x0 }, /* #20 */
    { 0x1f4f56, 0x1f4f92, 0x7527cc6d05fef3bd, 0xef6ca28c2367dc7c, 0x7a44d61f1d68e8bf, 0x0 }, /* #21 */
    { 0x0d71d2, 0x0d7903, 0xc15409071898dfe8, 0x53e3a2d8853a63ad, 0x928f99d16ca183c5, 0x0 }, /* #22 */
    { 0x097d53, 0x097503, 0x709d12ba7a09ec11, 0x61de7d29e7e43ea4, 0xf1416a6f6dda5292, 0x0 }, /* #23 */
    { 0x187946, 0x187186, 0xabecdba617013f97, 0xb49b5a3a8241c72d, 0x08ae7e946b408796, 0x0 }, /* #24 */
    { 0x104903, 0x104107, 0xd9b824126e3fbf70, 0x027ea84fad2f0a39, 0x28c6843d3eef4ac8, 0x0 }, /* #25 */
    { 0x3133d3, 0x313316, 0x5060113eba042239, 0x507662fd01a90d53, 0x001651be47a4eb19, 0x0 }, /* #26 */
    { 0x003fd6, 0x003707, 0x67ad5c6c8e9f19c4, 0x27489aa6fa1eddd4, 0xbf9b3e3a6b7fc410, 0x0 }, /* #27 */
    { 0x357883, 0x357817, 0x957e95574e6a3ba4, 0x5db2ac96c4cacc00, 0xc834173f7660905b, 0x0 }, /* #28 */
    { 0x1f5d13, 0x1f5d86, 0x33ae9ccad4f469e4, 0xa3939f3295bb108e, 0x6fe50267c0c6a6a9, 0x0 }, /* #29 */
    { 0x286f93, 0x286f96, 0x7bd84ddc86d30eba, 0xca88cc2bf7095b0a, 0x4eb07e4f70364c4f, 0x0 }, /* #30 */
    { 0x0d5ed6, 0x0d5e96, 0x7f5c90a8187c4d5f, 0xd4c4f7d67d7092a9, 0x5568672e64f4454a, 0x0 }, /* #31 */
    { 0x2e6f42, 0x2e6793, 0xf4ab54f991d25fa6, 0xb621f7ee79bc3d80, 0xc176a2f4e7e9ddda, 0x0 }, /* #32 */
    { 0x0a6387, 0x0a6392, 0x0e8c6ed7ea28e7a8, 0xc7468b27dbadaef7, 0xb8ba1c4ff184c74e, 0x0 }, /* #33 */
    { 0x081546, 0x081d96, 0x56920c6e9c2ac705, 0xc4cfcb143279c0f3, 0x6e3dbea5964ef9ee, 0x0 }, /* #34 */
    { 0x027dc3, 0x027592, 0x1b8b66db0bfd50f6, 0xbf5271106b86be46, 0xa3c70a355f896d4f, 0x0 }, /* #35 */
    { 0x143412, 0x143493, 0xba814e47a59140ce, 0xb81ca13612c44404, 0xfd9b52ee6d330336, 0x0 }, /* #36 */
    { 0x3836d3, 0x383682, 0xdef53c7dfec7af61, 0xed277bffbc4656b5, 0x0e323f81bd7ea753, 0x0 }, /* #37 */
    { 0x3434c7, 0x343487, 0xdc97866b03f60681, 0xc5b4ec6e40db2b27, 0xe91d66033ce524a5, 0x0 }, /* #38 */
    { 0x1804c7, 0x180c13, 0x86486a64530dfd6f, 0x7cc9d2dd488aa53d, 0xf6816878f57ca7cd, 0x0 }, /* #39 */
    { 0x3a6f17, 0x3a6713, 0xb98c79771ccd2988, 0x3346e94031557570, 0x79ba6fc914884be7, 0x0 }, /* #40 */
    { 0x0470d3, 0x047012, 0x4c6284d7a6b997d5, 0x77b4dec5e595c204, 0x2b5259ee3edc2a2e, 0x0 }, /* #41 */
    { 0x2067c3, 0x206787, 0xae08d8c8da032824, 0x84c489c130e1699c, 0xd6bbb0f856de4177, 0x0 }, /* #42 */
    { 0x317747, 0x317f92, 0x75a20ab134bd4835, 0x89263a2233f4f2d5, 0x13842f70ff37aa9f, 0x0 }, /* #43 */
    { 0x1f7f83, 0x1f7783, 0xe98e7beb97a8cc82, 0x9e541ba679a44973, 0xb4c59fbae1fb7cf0, 0x0 }, /* #44 */
    { 0x070b57, 0x070396, 0x0de36c15b549d22a, 0x9ef10e433a3e1333, 0x910da22d84f44108, 0x0 }, /* #45 */
    { 0x0930c7, 0x093807, 0xc0dc49bd198a1ed9, 0x4bde24d480b6e31d, 0x8b01db17672cc443, 0x0 }, /* #46 */
    { 0x2b4682, 0x2b4607, 0xae9a3e89676a1de8, 0x1c82bd1efc860a0c, 0x6de87e95951bec24, 0x0 }, /* #47 */
    { 0x2745d6, 0x274516, 0x73aef352d2fb804a, 0x798bd4c01a4f11d4, 0x05dce16d4753918a, 0x0 }, /* #48 */
    { 0x1a5853, 0x1a5896, 0x78156c2f4932ddab, 0xcd354d5ce2dd381b, 0x551fe12d99aa5a6f, 0x0 }, /* #49 */
    { 0x147513, 0x147507, 0x39ad67e703ae68fa, 0x3544ce22f36bd58d, 0xfb97663befbd6c92, 0x0 }, /* #50 */
    { 0x184352, 0x184307, 0xe5703665bca96d62, 0x1c6f0de80708b15c, 0x36fed7824a5f43fa, 0x0 }, /* #51 */
    { 0x275513, 0x275507, 0x7de788df24055e6b, 0x4930fbdece4f326c, 0xcb4972ffaa49d400, 0x0 }, /* #52 */
    { 0x1e4ec6, 0x1e4e86, 0x7b969c9ab4327c72, 0x83f4aa8fac424503, 0x085e0df4f80fc891, 0x0 }, /* #53 */
    { 0x335302, 0x335393, 0x8c20fde5e0ae8f49, 0x84c33d7980b93e01, 0xf8a23f93a00aaeb8, 0x0 }, /* #54 */
    { 0x342b92, 0x342382, 0x8533da320d8929c4, 0xf721251576dfa9c7, 0x71ed4ae369568003, 0x0 }, /* #55 */
    { 0x2b1957, 0x2b1186, 0x2bbe9f9bb2dbb5f0, 0xf3e4118ca053a46c, 0xc82571f0ed77ee7b, 0x0 }, /* #56 */
    { 0x003e87, 0x003686, 0x58b27e5a6a5bb480, 0xe2649f278a07add7, 0x89b220cd1fabf956, 0x0 }, /* #57 */
    { 0x215c92, 0x215407, 0x55f335e0fb2b74cc, 0x0a68f4fabd40bbdd, 0xb475bf19c2154711, 0x0 }, /* #58 */
    { 0x0c05d3, 0x0c0516, 0x0ba3642aa774ba46, 0x71ed7d18df012636, 0x664a18ee378c6bef, 0x0 }, /* #59 */
    { 0x205192, 0x205982, 0x547c7b2e3de838ec, 0x8d5b94f1f1981b9d, 0x38df19c3b3afe2b1, 0x0 }, /* #60 */
    { 0x1b43c2, 0x1b4b03, 0xc7c991d7dcafbde2, 0x7a22de9b76a8e5c4, 0xb2594cc399f927e2, 0x0 }, /* #61 */
    { 0x312e92, 0x312612, 0x5190e9656bd64394, 0x65ea23b4607e7332, 0x14593a4ef4a82f9e, 0x0 }, /* #62 */
    { 0x0d7982, 0x0d7182, 0xdf1eeba0a47df048, 0xfaf9ec9d259c34bc, 0x1bdb00fc811e4474, 0x0 }, /* #63 */
    { 0x2007d6, 0x200f96, 0x1ba425d7cbcdb579, 0x8751940e87d5cc60, 0x6bad6e36bc0816e7, 0x0 }, /* #64 */
    { 0x206d03, 0x206596, 0x151b5c08aca82766, 0xa55f35c8b6dcee22, 0x9043d9c00a34c6bb, 0x0 }, /* #65 */
    { 0x0a2ec3, 0x0a2686, 0x390b6ac6f08dee25, 0xeb5f16cb06a616f9, 0xb253ac04161828d3, 0x0 }, /* #66 */
    { 0x2d1c52, 0x2d1492, 0xca5aed8f948f61a8, 0xeab4fd5dd38458b3, 0x205a0fce3ef4f70b, 0x0 }, /* #67 */
    { 0x183a13, 0x183292, 0x13e60f417eaef967, 0xfb224eea9bc96d46, 0xe73c3fa91d1a73de, 0x0 }, /* #68 */
    { 0x1d7f82, 0x1d7786, 0xae582ff87eb706f0, 0xfdeceb765bde1eff, 0x4f94bb7ddd27180f, 0x0 }, /* #69 */
    { 0x0f2b42, 0x0f2b82, 0x76477def12d30430, 0x8cfce9dc8e2bf123, 0x16b56bed7b58ecf3, 0x0 }, /* #70 */
    { 0x2b7a03, 0x2b7a13, 0xa3b528cef407a3f3, 0x573161a26d769562, 0xb37c38d3796ef16e, 0x0 }, /* #71 */
    { 0x041a07, 0x041287, 0xce1f7d8c136c94a3, 0x9326836df1f1b8f6, 0xc50705e1de852452, 0x0 }, /* #72 */
    { 0x262093, 0x262096, 0xc13bc13ab17e8725, 0xf6c0517385239cf3, 0x35849038d3a515cd, 0x0 }, /* #73 */
    { 0x024a17, 0x024a82, 0x7e0ac4843e50550b, 0xc86fa153a58ef5ef, 0x4a64dccf673ea0e3, 0x0 }, /* #74 */
    { 0x0463d3, 0x046387, 0xc2cf961d83314680, 0xa7215ac7a7ae4d12, 0xe451c4aa247d0691, 0x0 }, /* #75 */
    { 0x111a46, 0x111286, 0xa5ec7ffe9c58de96, 0xe088008a43fc0e47, 0x3a9b808ba7a32fb1, 0x0 }, /* #76 */
    { 0x266352, 0x266313, 0x5dec17a3723b87d8, 0x42ce71a7a4f00792, 0xe4e25a0432b47fba, 0x0 }, /* #77 */
    { 0x044003, 0x044017, 0xcdb0d86762e53462, 0x3bee2e4055b3dbb1, 0x6e3d55d8f2cea74e, 0x0 }, /* #78 */
    { 0x3e0b56, 0x3e0313, 0x7ab13a8bb41185bb, 0x699d23ed4a1f7ab6, 0xeeebe961960df4fb, 0x0 }, /* #79 */
    { 0x234ac3, 0x234207, 0x9a7660a44174a5b8, 0x18f52ce6d6ef854e, 0x7e7ecc42957adf95, 0x0 }, /* #80 */
    { 0x142fd2, 0x142717, 0x5d37c715eb306e06, 0x12c69af1695f3650, 0xb58ed3db7e2ec84a, 0x0 }, /* #81 */
    { 0x354283, 0x354207, 0xd93abfd2ecb8f4db, 0x3e6c9f363404db8e, 0x6531df63474be6b2, 0x0 }, /* #82 */
    { 0x087fd2, 0x087783, 0xd3f4a0ea14413092, 0xcb460cfabc36d54f, 0xf7516c10a7f5a4bd, 0x0 }, /* #83 */
    { 0x113747, 0x113786, 0x1a6d3231d2cd2e15, 0xd868f2b60db6d888, 0xbdfbc0843ae9aa72, 0x0 }, /* #84 */
    { 0x3b6b42, 0x3b6307, 0x6e234a4fd61edc6b, 0x4483c2e0511c482e, 0xd66078907afd6bc3, 0x0 }, /* #85 */
    { 0x212402, 0x212483, 0xf982484f5f29a965, 0x9bd99988258c39ec, 0xa2575138c6629087, 0x0 }, /* #86 */
    { 0x0c2056, 0x0c2082, 0x8f899aef6797c400, 0xa61774204085a070, 0x168dd930d8eddc70, 0x0 }, /* #87 */
    { 0x1f6702, 0x1f6792, 0x979a795a6974a7ca, 0xfca6ad1dfb71c5c8, 0x650c33c391fd1dfe, 0x0 }, /* #88 */
    { 0x254852, 0x254007, 0x627ad37d5e855b59, 0x4286700834950c6f, 0xe00b9c8ad60fb116, 0x0 }, /* #89 */
    { 0x053407, 0x053407, 0x5eb17e062ea6ae35, 0x1a337f58f81a1ebd, 0xbb820152c9737087, 0x0 }, /* #90 */
    { 0x137656, 0x137686, 0x2bf3ab46f0fbe091, 0xd7ba3c2d7a88a7be, 0xabc690e6898cc72d, 0x0 }, /* #91 */
    { 0x2e0c47, 0x2e0496, 0x2d0a58d85f007ccb, 0xb17310b233023a06, 0x8468b7d9d401bd3a, 0x0 }, /* #92 */
    { 0x305a56, 0x305282, 0xc68cf27ddb92cac3, 0xd96cb8783c5f12ec, 0x12dfc5fa60cc4829, 0x0 }, /* #93 */
    { 0x1c4ad3, 0x1c4296, 0xa5d202532b2116be, 0xdf29233f34278fa0, 0x395720ec090678e1, 0x0 }, /* #94 */
    { 0x061152, 0x061196, 0xcfa5d77884c4a2bd, 0xdc61a3d378ea6a74, 0x0cbbcc5af425c7b7, 0x0 }, /* #95 */
};
uint32_t const g_cTests_adc_u64 = RT_ELEMENTS(g_aTests_adc_u64);

BINU64_TEST_T const g_aTests_adc_u64_locked[] =
{
    { 0x2f6042, 0x2f6046, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x0a2947, 0x0a2102, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x291cd6, 0x291446, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x2b6213, 0x2b6202, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x0b0843, 0x0b0002, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x386e03, 0x386602, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x253b86, 0x253386, 0xa2e8dbadcb4e7074, 0xa2e8dbadcb4e7074, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x390097, 0x390006, 0x62fa1b1cae5a72b1, 0x62fa1b1cae5a72b2, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x2d6a86, 0x2d6286, 0xf31ade4d58fbfe56, 0xf31ade4d58fbfe56, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x131943, 0x131106, 0x66eb7bd70c09929e, 0x66eb7bd70c09929f, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x123507, 0x123586, 0x89e26a1af9ecf2fe, 0x89e26a1af9ecf2ff, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x1b0387, 0x1b0306, 0x5fc1b349d2187623, 0x5fc1b349d2187624, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x394d06, 0x394512, 0x37aff3d2d7d8aa5f, 0x7886a7f665009d46, 0x40d6b4238d27f2e7, 0x0 }, /* #12 */
    { 0x0e4c86, 0x0e4486, 0x08a13d1e48dfd9b3, 0xe10b2f991a91f469, 0xd869f27ad1b21ab6, 0x0 }, /* #13 */
    { 0x135b83, 0x135b96, 0x5f39500a6e06c25c, 0xb50c24b9eaeb9b93, 0x55d2d4af7ce4d936, 0x0 }, /* #14 */
    { 0x230cd6, 0x230406, 0x0774266aad29ba89, 0x5b1ba34a9b8d32ff, 0x53a77cdfee637876, 0x0 }, /* #15 */
    { 0x010e07, 0x010612, 0x0d8a8c2c246015eb, 0x4d83b7dbb080957a, 0x3ff92baf8c207f8e, 0x0 }, /* #16 */
    { 0x2e2b06, 0x2e2306, 0x5a56f8c5ff8ce380, 0x713fcd83ede8f977, 0x16e8d4bdee5c15f7, 0x0 }, /* #17 */
    { 0x2a49c7, 0x2a4107, 0xbe7050c9d116c0e9, 0x2ac61a6945bb8a5a, 0x6c55c99f74a4c970, 0x0 }, /* #18 */
    { 0x030357, 0x030316, 0x4862bfd18f45a6ed, 0x643bf8c1ec6d947b, 0x1bd938f05d27ed8d, 0x0 }, /* #19 */
    { 0x111992, 0x111117, 0xc8ce02577503c367, 0x011b1b649f243872, 0x384d190d2a20750b, 0x0 }, /* #20 */
    { 0x0d6fd6, 0x0d6782, 0x28fd36337561e672, 0xbc7385e8af941285, 0x93764fb53a322c13, 0x0 }, /* #21 */
    { 0x2c4187, 0x2c4103, 0xb435445af1bc0a70, 0x2d7e8c37a99cfd62, 0x794947dcb7e0f2f1, 0x0 }, /* #22 */
    { 0x037c43, 0x037406, 0x2cb53e17385599a7, 0x7cce480799bdb11b, 0x501909f061681773, 0x0 }, /* #23 */
    { 0x085b97, 0x085392, 0xf25e69dc2dc7e908, 0xfc869a8e534122c2, 0x0a2830b2257939b9, 0x0 }, /* #24 */
    { 0x3f7952, 0x3f7106, 0x146f8e64071876c3, 0x69807a688d76a4bd, 0x5510ec04865e2dfa, 0x0 }, /* #25 */
    { 0x2c2b57, 0x2c2386, 0x38bdac0051847696, 0xef83465e2c32b6b8, 0xb6c59a5ddaae4021, 0x0 }, /* #26 */
    { 0x355e06, 0x355606, 0x00a6b81fa42dcd8a, 0x06d326d4bfbb32de, 0x062c6eb51b8d6554, 0x0 }, /* #27 */
    { 0x346882, 0x346007, 0xd9144b763ed92521, 0x3a0d585cd95b3095, 0x60f90ce69a820b74, 0x0 }, /* #28 */
    { 0x322852, 0x322003, 0xee2fe087d83ca56a, 0x69637a0357446e4a, 0x7b33997b7f07c8e0, 0x0 }, /* #29 */
    { 0x391342, 0x391b07, 0xa0038a1cdfd00540, 0x2a3cd9833e5dcf4b, 0x8a394f665e8dca0b, 0x0 }, /* #30 */
    { 0x3d3e13, 0x3d3692, 0x8aba9232cbe2cb46, 0xb667d0bb86322016, 0x2bad3e88ba4f54cf, 0x0 }, /* #31 */
    { 0x064a53, 0x064282, 0x0ed13a9dd948db95, 0xc7ab66a99df3664c, 0xb8da2c0bc4aa8ab6, 0x0 }, /* #32 */
    { 0x0d6847, 0x0d6013, 0x36b663b1efea5ccf, 0x0995f74f936d399b, 0xd2df939da382dccb, 0x0 }, /* #33 */
    { 0x2c2703, 0x2c2713, 0xee51832ced3995ed, 0x4c1b92f5301003f2, 0x5dca0fc842d66e04, 0x0 }, /* #34 */
    { 0x251d86, 0x251506, 0x21401462e3691124, 0x510e2bfc16aa7be4, 0x2fce179933416ac0, 0x0 }, /* #35 */
    { 0x3d0d92, 0x3d0597, 0xe4db0599cfcfe6d5, 0xd565da290d721860, 0xf08ad48f3da2318b, 0x0 }, /* #36 */
    { 0x0f3d07, 0x0f3517, 0xedf00094617ec22b, 0x37a0a75088e45869, 0x49b0a6bc2765963d, 0x0 }, /* #37 */
    { 0x3f2753, 0x3f2712, 0x7040e904897d5682, 0x7abe91e724502761, 0x0a7da8e29ad2d0de, 0x0 }, /* #38 */
    { 0x1d5a03, 0x1d5207, 0x732de8930bef3e42, 0x5ff26cd2a8010f95, 0xecc4843f9c11d152, 0x0 }, /* #39 */
    { 0x342bd6, 0x342382, 0xb4633b44d391591b, 0xeea9d879cb01a39b, 0x3a469d34f7704a80, 0x0 }, /* #40 */
    { 0x244802, 0x244006, 0x2abbbd926aff75b9, 0x357962bcb4d5db2b, 0x0abda52a49d66572, 0x0 }, /* #41 */
    { 0x353e82, 0x353e96, 0x706e4e762588449b, 0xd8f044ebab0151b7, 0x6881f67585790d1c, 0x0 }, /* #42 */
    { 0x3936d3, 0x393606, 0x72b66edbb2d176c7, 0x7f97517ecb693a8b, 0x0ce0e2a31897c3c3, 0x0 }, /* #43 */
    { 0x030dd2, 0x030592, 0x6aedaa4f4cc7368d, 0xf7c8ed24f8239370, 0x8cdb42d5ab5c5ce3, 0x0 }, /* #44 */
    { 0x185f83, 0x185796, 0x29789114bcfe8ecb, 0xeb5a7c4e0ecbd947, 0xc1e1eb3951cd4a7b, 0x0 }, /* #45 */
    { 0x1e7fc6, 0x1e7792, 0x93c92feeb5a240a4, 0xbc3da0041a181a83, 0x287470156475d9df, 0x0 }, /* #46 */
    { 0x005886, 0x005093, 0xb6cfa94b6c0d89de, 0xb35708710bb893bc, 0xfc875f259fab09de, 0x0 }, /* #47 */
    { 0x322cc7, 0x322402, 0x2dd75151fc5f6104, 0x739b80d86778d2c7, 0x45c42f866b1971c2, 0x0 }, /* #48 */
    { 0x036187, 0x036182, 0xc231216a6a34de23, 0xcc1607985f500d1c, 0x09e4e62df51b2ef8, 0x0 }, /* #49 */
    { 0x140903, 0x140187, 0xc078f3a151ce9eb7, 0xbe7fb3e8dd1bf8ca, 0xfe06c0478b4d5a12, 0x0 }, /* #50 */
    { 0x1d3082, 0x1d3892, 0x7e76c5a64660022b, 0xa03d3715bda57ef8, 0x21c6716f77457ccd, 0x0 }, /* #51 */
    { 0x0a4752, 0x0a4707, 0x609666ef60a55354, 0x193b39707ebf0c2b, 0xb8a4d2811e19b8d7, 0x0 }, /* #52 */
    { 0x0d65d2, 0x0d6507, 0x78f609d4de941e98, 0x73a3754f4f1a90e8, 0xfaad6b7a70867250, 0x0 }, /* #53 */
    { 0x322d83, 0x322d17, 0x9cc066c9baf231a6, 0x7bb8b078e26a2493, 0xdef849af2777f2ec, 0x0 }, /* #54 */
    { 0x180046, 0x180082, 0x32c0dbbd6d64ec78, 0xda65f66be333638a, 0xa7a51aae75ce7712, 0x0 }, /* #55 */
    { 0x3b3193, 0x3b3986, 0x75c14491cd395544, 0x8be7f27c621a578b, 0x1626adea94e10246, 0x0 }, /* #56 */
    { 0x1102d7, 0x110203, 0x2e469b20d7500a00, 0x06f6db9d07c0ebf2, 0xd8b0407c3070e1f1, 0x0 }, /* #57 */
    { 0x2a2783, 0x2a2713, 0xd4a53e0a1c6eb656, 0x4a7c4fea75da3e85, 0x75d711e0596b882e, 0x0 }, /* #58 */
    { 0x0d1c13, 0x0d1482, 0xac686e4dc47ffdb3, 0xda9479cc85133429, 0x2e2c0b7ec0933675, 0x0 }, /* #59 */
    { 0x3c1753, 0x3c1706, 0x118251a71028f154, 0x55eec4856069fa99, 0x446c72de50410944, 0x0 }, /* #60 */
    { 0x1f0246, 0x1f0a96, 0x372e0ab77446ac8d, 0x8030e6f57d714263, 0x4902dc3e092a95d6, 0x0 }, /* #61 */
    { 0x2b3082, 0x2b3017, 0xb82696a5a291f99b, 0x116e5333d19cbe42, 0x5947bc8e2f0ac4a7, 0x0 }, /* #62 */
    { 0x017e46, 0x017e13, 0xb393d53ee71fba8f, 0x7058f61a45d5e65d, 0xbcc520db5eb62bce, 0x0 }, /* #63 */
    { 0x2c1f43, 0x2c1786, 0x18ea6ab39d177426, 0xb0988e25e2676ce7, 0x97ae2372454ff8c0, 0x0 }, /* #64 */
    { 0x070f02, 0x070703, 0x3b86b267c589b3f6, 0x1aa71efb4791d02f, 0xdf206c9382081c39, 0x0 }, /* #65 */
    { 0x3b5e06, 0x3b5693, 0xc74fc7fc1a124cde, 0xac85ebfb630bf0a1, 0xe53623ff48f9a3c3, 0x0 }, /* #66 */
    { 0x367e17, 0x367e96, 0x4ba48db2185d06f9, 0x9087acd08ac72111, 0x44e31f1e726a1a17, 0x0 }, /* #67 */
    { 0x207243, 0x207282, 0x14f8292015289134, 0xceff7979f033debf, 0xba075059db0b4d8a, 0x0 }, /* #68 */
    { 0x3d5ed2, 0x3d5603, 0xc270f7d123ac3513, 0x397151cc9554325d, 0x770059fb71a7fd4a, 0x0 }, /* #69 */
    { 0x2f38d7, 0x2f3892, 0x6f3fb31274ea85c5, 0x8998f2f80c9b43f4, 0x1a593fe597b0be2e, 0x0 }, /* #70 */
    { 0x027117, 0x027186, 0x32b1f3d58ad3fe58, 0xf24453be7b91b45c, 0xbf925fe8f0bdb603, 0x0 }, /* #71 */
    { 0x1f0756, 0x1f0783, 0xcac468bc5b0a0ed0, 0x8168c07161a86f02, 0xb6a457b5069e6032, 0x0 }, /* #72 */
    { 0x031152, 0x031196, 0x1ae83175476187c9, 0xa0feb19acae226b2, 0x8616802583809ee9, 0x0 }, /* #73 */
    { 0x2837c6, 0x283716, 0x30ffed0aa01423be, 0x45701805292832b1, 0x14702afa89140ef3, 0x0 }, /* #74 */
    { 0x042f43, 0x042717, 0x3b863a093f73128c, 0x1e5aeecc1a55646c, 0xe2d4b4c2dae251df, 0x0 }, /* #75 */
    { 0x1e2456, 0x1e2486, 0x97f1bf6c8c137aa0, 0xe3c92242bd8717ed, 0x4bd762d631739d4d, 0x0 }, /* #76 */
    { 0x1648c7, 0x164002, 0x348d54672ab009c5, 0x36a579b52248963b, 0x0218254df7988c75, 0x0 }, /* #77 */
    { 0x207747, 0x207f82, 0x7228b620902f81f9, 0x9974299bf8d0f97f, 0x274b737b68a17785, 0x0 }, /* #78 */
    { 0x1b0706, 0x1b0782, 0x89461b9e1e5ca5cc, 0xc7b0f69f9a6c84bf, 0x3e6adb017c0fdef3, 0x0 }, /* #79 */
    { 0x0e5f47, 0x0e5786, 0xd8357937daba7bb3, 0xdf5f330c597aafdb, 0x0729b9d47ec03427, 0x0 }, /* #80 */
    { 0x2a6093, 0x2a6013, 0xd1aa6d047f8f3a27, 0x35e1aff60501e8d0, 0x643742f18572aea8, 0x0 }, /* #81 */
    { 0x276682, 0x276696, 0x387c843ab7ed6546, 0xb8fd1616037b1e74, 0x808091db4b8db92e, 0x0 }, /* #82 */
    { 0x324993, 0x324196, 0x1d8d27b2209aeb5f, 0xc025a045c4802965, 0xa2987893a3e53e05, 0x0 }, /* #83 */
    { 0x141e17, 0x141686, 0x3cda279a0e4ef0b6, 0xc11eb27bd6e2c38d, 0x84448ae1c893d2d6, 0x0 }, /* #84 */
    { 0x3f6a87, 0x3f6217, 0x5447705e86bb15a7, 0x17ef2d7b479911c0, 0xc3a7bd1cc0ddfc18, 0x0 }, /* #85 */
    { 0x075f06, 0x075787, 0xd4f9828dec983a43, 0x8568b55b8e3bc978, 0xb06f32cda1a38f35, 0x0 }, /* #86 */
    { 0x2e3652, 0x2e3603, 0xfa625e13448719ca, 0x06857222440f407f, 0x0c23140eff8826b5, 0x0 }, /* #87 */
    { 0x2d5003, 0x2d5007, 0xcf84a046266e8757, 0x207d3a9a3e1dfbfc, 0x50f89a5417af74a4, 0x0 }, /* #88 */
    { 0x3025d6, 0x302d03, 0x8f39d5854fb55b18, 0x221db1af3a1056ec, 0x92e3dc29ea5afbd4, 0x0 }, /* #89 */
    { 0x1d7196, 0x1d7187, 0xd41a850378c85556, 0x8f1cf11d21c26dcf, 0xbb026c19a8fa1879, 0x0 }, /* #90 */
    { 0x1a6353, 0x1a6307, 0xe7621dedeeaacbe3, 0x3424ee450aceb2ca, 0x4cc2d0571c23e6e6, 0x0 }, /* #91 */
    { 0x296092, 0x296017, 0x6f05981a4b7f9ccf, 0x007f9006721f1bd8, 0x9179f7ec269f7f09, 0x0 }, /* #92 */
    { 0x0c3b82, 0x0c3392, 0x03f8ac67849e178b, 0xc2dd13c48d711467, 0xbee4675d08d2fcdc, 0x0 }, /* #93 */
    { 0x2d3cd6, 0x2d3483, 0xd17eef49c0afa5e5, 0xac0d3a9aaa741d46, 0xda8e4b50e9c47761, 0x0 }, /* #94 */
    { 0x057b53, 0x057306, 0x0040e297e9e80791, 0x32f97227c7ced02b, 0x32b88f8fdde6c899, 0x0 }, /* #95 */
};
uint32_t const g_cTests_adc_u64_locked = RT_ELEMENTS(g_aTests_adc_u64_locked);

BINU64_TEST_T const g_aTests_sub_u64[] =
{
    { 0x191582, 0x191546, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x1d3a12, 0x1d3246, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x3b17c2, 0x3b1746, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x030d53, 0x030546, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x0a28c3, 0x0a2046, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x086702, 0x086746, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x230902, 0x230186, 0xb7cb4ec3290b77e2, 0xb7cb4ec3290b77e2, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x244587, 0x244506, 0x3d775e6dc5c94ec5, 0x3d775e6dc5c94ec5, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x171b56, 0x171302, 0x30adc8d40ee882df, 0x30adc8d40ee882df, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x087953, 0x087102, 0x163fa2420cb97d52, 0x163fa2420cb97d52, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x3c5a16, 0x3c5286, 0xcf31c5e4847e419a, 0xcf31c5e4847e419a, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x325006, 0x325086, 0xfb38cfcd83d1c981, 0xfb38cfcd83d1c981, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x342492, 0x342483, 0xbf33a71a75001a51, 0xfc1e7dc6e3629451, 0xc3152953919d8600, 0x0 }, /* #12 */
    { 0x0451d7, 0x045187, 0xa527dcc05f759cd8, 0xa618343ba40424f3, 0xff0fa884bb7177e5, 0x0 }, /* #13 */
    { 0x072547, 0x072512, 0xe35d9f2cbc27dba2, 0x371175e99e00dbef, 0xac4c29431e26ffb3, 0x0 }, /* #14 */
    { 0x1a6357, 0x1a6383, 0x71b616c3d0d1afcd, 0xfa621b1f129061cb, 0x7753fba4be414e02, 0x0 }, /* #15 */
    { 0x236607, 0x236606, 0xff492963f62d13aa, 0x1de0f81b142703f6, 0xe1683148e2060fb4, 0x0 }, /* #16 */
    { 0x3c1493, 0x3c1486, 0xf597c640e6532aad, 0xf53f4894ab9d8be2, 0x00587dac3ab59ecb, 0x0 }, /* #17 */
    { 0x3d6403, 0x3d6486, 0xc920ce0a1d61239f, 0xbacc674d36627c0f, 0x0e5466bce6fea790, 0x0 }, /* #18 */
    { 0x030b97, 0x030397, 0x962ff707b3d22344, 0xcd32658081f8676f, 0xc8fd918731d9bbd5, 0x0 }, /* #19 */
    { 0x177f93, 0x177f02, 0xbb5f587530a11eec, 0x7a552fc7e6e6ee1c, 0x410a28ad49ba30d0, 0x0 }, /* #20 */
    { 0x1b1882, 0x1b1093, 0xb49e242823eef745, 0xdc0b2546737a384f, 0xd892fee1b074bef6, 0x0 }, /* #21 */
    { 0x3755c2, 0x375586, 0xfa0a3ac517721d7e, 0xa5ba4842c5fc8d7e, 0x544ff28251759000, 0x0 }, /* #22 */
    { 0x253197, 0x253197, 0x9ef82e72f714d568, 0xb142783f52181939, 0xedb5b633a4fcbc2f, 0x0 }, /* #23 */
    { 0x3b4602, 0x3b4612, 0xa1bb82622fe66539, 0x04e467662804175d, 0x9cd71afc07e24ddc, 0x0 }, /* #24 */
    { 0x3928d6, 0x392012, 0xb83d095bbf9e4f3e, 0x143010e3ffe2252f, 0xa40cf877bfbc2a0f, 0x0 }, /* #25 */
    { 0x0c72d6, 0x0c7297, 0xabf1040e40afed62, 0xec710d46c82ade17, 0xbf7ff6c778850f4b, 0x0 }, /* #26 */
    { 0x1a2802, 0x1a2802, 0x95c58de5f1ba230d, 0x6dcb84ef0367b4f7, 0x27fa08f6ee526e16, 0x0 }, /* #27 */
    { 0x112946, 0x112912, 0xc145225714e351c8, 0x76632e6f804a07bc, 0x4ae1f3e794994a0c, 0x0 }, /* #28 */
    { 0x085ed3, 0x085602, 0x477dd2a277aa4b52, 0x05d9fa48427b9a31, 0x41a3d85a352eb121, 0x0 }, /* #29 */
    { 0x237752, 0x237f06, 0x9f153e79b55d1809, 0x327559c001f79df9, 0x6c9fe4b9b3657a10, 0x0 }, /* #30 */
    { 0x072c17, 0x072403, 0x22eaeb70d589571f, 0x69a69147f6f8a4c2, 0xb9445a28de90b25d, 0x0 }, /* #31 */
    { 0x384d53, 0x384587, 0x92e46cbd1b0362ff, 0x983cf6516ccc2cdb, 0xfaa7766bae373624, 0x0 }, /* #32 */
    { 0x280d57, 0x280512, 0xee605442d8dbb080, 0x2261e823fa724adc, 0xcbfe6c1ede6965a4, 0x0 }, /* #33 */
    { 0x1232c3, 0x123286, 0xde3916199651c0fa, 0x8ca5d7ebda7f6247, 0x51933e2dbbd25eb3, 0x0 }, /* #34 */
    { 0x273602, 0x273683, 0xaac88ed3e85a9f7f, 0xd3dbf788ce86c0d0, 0xd6ec974b19d3deaf, 0x0 }, /* #35 */
    { 0x345b53, 0x345b93, 0x21c7dd004bb59ca6, 0x889189294dc49c6e, 0x993653d6fdf10038, 0x0 }, /* #36 */
    { 0x3f0553, 0x3f0502, 0x65539910f28f842a, 0x2cafd5ed96a636c2, 0x38a3c3235be94d68, 0x0 }, /* #37 */
    { 0x283ac2, 0x283206, 0xe1880e15035c7d33, 0x384529e5f711ddb1, 0xa942e42f0c4a9f82, 0x0 }, /* #38 */
    { 0x2a7197, 0x2a7197, 0x48759130aa574511, 0xe6586d5e19780f14, 0x621d23d290df35fd, 0x0 }, /* #39 */
    { 0x3e1346, 0x3e1392, 0xbbf58e51040e133b, 0xb52579c65a9a50bf, 0x06d0148aa973c27c, 0x0 }, /* #40 */
    { 0x3326d6, 0x332617, 0x33d4f01b95082546, 0x45c3e12e4a84339a, 0xee110eed4a83f1ac, 0x0 }, /* #41 */
    { 0x1973d3, 0x197b83, 0x6bd69d75f3cb850c, 0xcfecbd40d5238132, 0x9be9e0351ea803da, 0x0 }, /* #42 */
    { 0x372502, 0x372d02, 0x8773ca140c158c5d, 0x2ac3aa68320e7a8c, 0x5cb01fabda0711d1, 0x0 }, /* #43 */
    { 0x0a01d6, 0x0a0116, 0x5906261c6d767913, 0x15515e90d98fc7d4, 0x43b4c78b93e6b13f, 0x0 }, /* #44 */
    { 0x2f53d3, 0x2f5387, 0xeda554dba2f715e4, 0xf2f535d99e10b871, 0xfab01f0204e65d73, 0x0 }, /* #45 */
    { 0x2348d3, 0x234006, 0xdd07f1c4d909cede, 0x1e2eb6e5ce4d1f9a, 0xbed93adf0abcaf44, 0x0 }, /* #46 */
    { 0x3e6d87, 0x3e6592, 0xf3e0ffa09a36c4d3, 0x97dfa2d06f8fb2a4, 0x5c015cd02aa7122f, 0x0 }, /* #47 */
    { 0x292416, 0x292413, 0x39abf968ec265dc2, 0x6be4492c0c3d53c4, 0xcdc7b03cdfe909fe, 0x0 }, /* #48 */
    { 0x3137d3, 0x313716, 0xfcaddb26d0fe4961, 0x29dff6d66f53b5e4, 0xd2cde45061aa937d, 0x0 }, /* #49 */
    { 0x214bd6, 0x214302, 0x66bbb9778a09164b, 0x2fe81d564b5958c1, 0x36d39c213eafbd8a, 0x0 }, /* #50 */
    { 0x143d57, 0x143502, 0x566797e5fab62994, 0x31290fa96ef151b0, 0x253e883c8bc4d7e4, 0x0 }, /* #51 */
    { 0x303cd6, 0x303493, 0x51a8570d5d0bd196, 0xfa6d9a648b6fc90e, 0x573abca8d19c0888, 0x0 }, /* #52 */
    { 0x146302, 0x146382, 0xa41975735fb9556e, 0x9ee41eb56b782fae, 0x053556bdf44125c0, 0x0 }, /* #53 */
    { 0x1b5643, 0x1b5617, 0x548c4f57c4f3a6c6, 0x70c14b879dab4577, 0xe3cb03d02748614f, 0x0 }, /* #54 */
    { 0x076853, 0x076097, 0x221efd913ecac271, 0xfcad83da9cfde0e7, 0x257179b6a1cce18a, 0x0 }, /* #55 */
    { 0x3a3086, 0x3a3006, 0xe2a2ec27dd4b30d6, 0x33740938822ee944, 0xaf2ee2ef5b1c4792, 0x0 }, /* #56 */
    { 0x151c82, 0x151412, 0x5ab81575b1681354, 0x50de9d1ce43b661f, 0x09d97858cd2cad35, 0x0 }, /* #57 */
    { 0x366117, 0x366106, 0x2616236a324beacd, 0x0078bdebf90d26d8, 0x259d657e393ec3f5, 0x0 }, /* #58 */
    { 0x264f02, 0x264792, 0xe607a7af7f982246, 0xd5e90615d633e40d, 0x101ea199a9643e39, 0x0 }, /* #59 */
    { 0x1906d6, 0x190697, 0xd56c028592542df5, 0xd7eb15b15008526f, 0xfd80ecd4424bdb86, 0x0 }, /* #60 */
    { 0x2f5dc6, 0x2f5d12, 0x8126342f9f089b73, 0x53382ff103de1e37, 0x2dee043e9b2a7d3c, 0x0 }, /* #61 */
    { 0x043e92, 0x043616, 0x2a07e853bd1f0f50, 0x296e4a5f6e78dc3a, 0x00999df44ea63316, 0x0 }, /* #62 */
    { 0x336252, 0x336297, 0xa0f7104e4b9d8e91, 0xee395d49815233f3, 0xb2bdb304ca4b5a9e, 0x0 }, /* #63 */
    { 0x031f42, 0x031786, 0xc2df644e44c8f5f4, 0xb107d7b19ed69ab4, 0x11d78c9ca5f25b40, 0x0 }, /* #64 */
    { 0x1f2943, 0x1f2906, 0xb7e7ab57e5c8a27b, 0x4f1c3ff612a23327, 0x68cb6b61d3266f54, 0x0 }, /* #65 */
    { 0x222b93, 0x222383, 0xb877ecc70168d63d, 0xd03e153e9c17b7ad, 0xe839d78865511e90, 0x0 }, /* #66 */
    { 0x274596, 0x274587, 0x2401a35d84a76456, 0xcd10b58d435d4b44, 0x56f0edd0414a1912, 0x0 }, /* #67 */
    { 0x0d0bc6, 0x0d0b93, 0x5c67af5459c3c120, 0xc95ff037392442ce, 0x9307bf1d209f7e52, 0x0 }, /* #68 */
    { 0x0e3912, 0x0e3102, 0x78c84b92c7be47a7, 0x0efe5a6e09636ed5, 0x69c9f124be5ad8d2, 0x0 }, /* #69 */
    { 0x2b0212, 0x2b0a83, 0x4c4441deff20bb66, 0xcb1e641c61444785, 0x8125ddc29ddc73e1, 0x0 }, /* #70 */
    { 0x0c6093, 0x0c6893, 0x59e2cdc3b194c7f9, 0x8b42a96d1d3719da, 0xcea02456945dae1f, 0x0 }, /* #71 */
    { 0x151382, 0x151b87, 0x7d6db3da8a2c719c, 0xf960ad5ec61308bb, 0x840d067bc41968e1, 0x0 }, /* #72 */
    { 0x3c6492, 0x3c6c83, 0x774c6259efdd4712, 0xbfee27f2c9040ff1, 0xb75e3a6726d93721, 0x0 }, /* #73 */
    { 0x091f46, 0x091783, 0x0a9f2d7764850cbd, 0xf19f52fc0cfb1c4c, 0x18ffda7b5789f071, 0x0 }, /* #74 */
    { 0x3b2d86, 0x3b2d93, 0x43c71c851bfe5cf4, 0xad89be0bb5f4a5e9, 0x963d5e796609b70b, 0x0 }, /* #75 */
    { 0x266852, 0x266003, 0x264408e180f73013, 0x612f9debd61349e3, 0xc5146af5aae3e630, 0x0 }, /* #76 */
    { 0x326592, 0x326592, 0xdf7783c892e7e591, 0xca3c23f28c529a4a, 0x153b5fd606954b47, 0x0 }, /* #77 */
    { 0x0b7e96, 0x0b7612, 0xad6c968b440a2321, 0x121a66b546177f08, 0x9b522fd5fdf2a419, 0x0 }, /* #78 */
    { 0x2c7a82, 0x2c7202, 0x6387c05e7045fe19, 0x45dfd4c81af954b5, 0x1da7eb96554ca964, 0x0 }, /* #79 */
    { 0x3e3302, 0x3e3302, 0x62cc91140a136359, 0x284b356a1f91aa79, 0x3a815ba9ea81b8e0, 0x0 }, /* #80 */
    { 0x3e6fd3, 0x3e6787, 0x99d7c474d0a65f18, 0xc25e4a97bcfb3463, 0xd77979dd13ab2ab5, 0x0 }, /* #81 */
    { 0x0c2ed6, 0x0c2e83, 0x71866fc88765e1d4, 0x947509dd15762401, 0xdd1165eb71efbdd3, 0x0 }, /* #82 */
    { 0x096652, 0x096606, 0x6f8520750dd07d8a, 0x6a5970b080ad8d06, 0x052bafc48d22f084, 0x0 }, /* #83 */
    { 0x0634c3, 0x063487, 0x1ddba27768007d8e, 0xeb26810b6b5bfd87, 0x32b5216bfca48007, 0x0 }, /* #84 */
    { 0x057b52, 0x057312, 0x355a29df3eddf612, 0x2ea2f9bfedfc0e8c, 0x06b7301f50e1e786, 0x0 }, /* #85 */
    { 0x2b2f06, 0x2b2f87, 0x79dc40500657c8da, 0xe2ab78886e3ab8c3, 0x9730c7c7981d1017, 0x0 }, /* #86 */
    { 0x196943, 0x196912, 0x817e8ee60e7bef05, 0x7e8d9de91ef715a7, 0x02f0f0fcef84d95e, 0x0 }, /* #87 */
    { 0x2833d6, 0x283397, 0xb32d5398a13ed4f1, 0xc3e2aba4ead72678, 0xef4aa7f3b667ae79, 0x0 }, /* #88 */
    { 0x225052, 0x225016, 0xf485dd6cb0e723b6, 0x19eccb2f2ce841a9, 0xda99123d83fee20d, 0x0 }, /* #89 */
    { 0x3a3a96, 0x3a3213, 0x5a56eb02f5cfe694, 0x7b66b670da01dd57, 0xdef034921bce093d, 0x0 }, /* #90 */
    { 0x2874d6, 0x287483, 0x1e567407917936f2, 0xdc87b17f372d82f1, 0x41cec2885a4bb401, 0x0 }, /* #91 */
    { 0x0d5687, 0x0d5612, 0x799c1870f4995748, 0x4b4e8df6e8e5ea0d, 0x2e4d8a7a0bb36d3b, 0x0 }, /* #92 */
    { 0x2e7f17, 0x2e7796, 0xf9403490f82be277, 0xb1538af7659e916f, 0x47eca999928d5108, 0x0 }, /* #93 */
    { 0x290a13, 0x290212, 0x66c3ece3ad576113, 0x0314b95c6afd001c, 0x63af3387425a60f7, 0x0 }, /* #94 */
    { 0x243e43, 0x243606, 0xec32e3b57690be59, 0x13cdf3387bbed5c9, 0xd864f07cfad1e890, 0x0 }, /* #95 */
};
uint32_t const g_cTests_sub_u64 = RT_ELEMENTS(g_aTests_sub_u64);

BINU64_TEST_T const g_aTests_sub_u64_locked[] =
{
    { 0x3a33c6, 0x3a3346, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x2173d6, 0x217346, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x1a4d12, 0x1a4546, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x126b17, 0x126346, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x145046, 0x145046, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x307b42, 0x307346, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x201a02, 0x201202, 0x2bb6a3aa4b9e90d6, 0x2bb6a3aa4b9e90d6, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x394796, 0x394706, 0x209e4aa73f58fa69, 0x209e4aa73f58fa69, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x050702, 0x050702, 0x0c826a489051a831, 0x0c826a489051a831, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x1e60c2, 0x1e6086, 0xc0c09ace8d41a271, 0xc0c09ace8d41a271, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x054dd7, 0x054502, 0x4b7fa48f14de130d, 0x4b7fa48f14de130d, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x137093, 0x137002, 0x70e32ff9eb24785e, 0x70e32ff9eb24785e, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x307007, 0x307086, 0x985c02e7beb1271a, 0x80a81e6dccf57514, 0x17b3e479f1bbb206, 0x0 }, /* #12 */
    { 0x190bd2, 0x190386, 0xfe2693e9b9d347c5, 0xc6b1e2d43873f424, 0x3774b115815f53a1, 0x0 }, /* #13 */
    { 0x1a6547, 0x1a6587, 0x1e93f3c8fc3632f8, 0xb719194da5fcc6b1, 0x677ada7b56396c47, 0x0 }, /* #14 */
    { 0x2c0cc6, 0x2c0483, 0xafbf13dbdc1e829d, 0xf6858d0fa6abe638, 0xb93986cc35729c65, 0x0 }, /* #15 */
    { 0x0d2ec6, 0x0d2606, 0x50a6040eba2a7ecc, 0x02e0cfc4a5ddeaf3, 0x4dc5344a144c93d9, 0x0 }, /* #16 */
    { 0x264e46, 0x264617, 0x0181e22416a66d25, 0x55e00bbfb3175127, 0xaba1d664638f1bfe, 0x0 }, /* #17 */
    { 0x107d47, 0x107502, 0xdfcaa531d87e88d3, 0x23805f5cc2ad37e3, 0xbc4a45d515d150f0, 0x0 }, /* #18 */
    { 0x3a4e57, 0x3a4602, 0xedbcd1fb381e2dda, 0x3ad58b6f2da2abf2, 0xb2e7468c0a7b81e8, 0x0 }, /* #19 */
    { 0x005412, 0x005496, 0xbdcd465063d47c80, 0x85539ebdfcb5ec66, 0x3879a792671e901a, 0x0 }, /* #20 */
    { 0x2e2f92, 0x2e2712, 0xdae1e2097557b382, 0x13446383960e0b98, 0xc79d7e85df49a7ea, 0x0 }, /* #21 */
    { 0x126e87, 0x126e16, 0x9497ef4efe2e45c9, 0x719d5c7d9b81862b, 0x22fa92d162acbf9e, 0x0 }, /* #22 */
    { 0x182c17, 0x182417, 0x22ce1e8a82685ff5, 0x30a6699ed9ed61f9, 0xf227b4eba87afdfc, 0x0 }, /* #23 */
    { 0x2a4296, 0x2a4212, 0xd35ac04196053fe4, 0x3b2180f3e9cf040e, 0x98393f4dac363bd6, 0x0 }, /* #24 */
    { 0x275a86, 0x275292, 0xfe4622a48a0c77ba, 0x9aafa8b621eedd4c, 0x639679ee681d9a6e, 0x0 }, /* #25 */
    { 0x037902, 0x037103, 0x0d6bbb8e4755fc0b, 0x3e633f85f951e304, 0xcf087c084e041907, 0x0 }, /* #26 */
    { 0x0b5313, 0x0b5312, 0xeb80e46c02b902e3, 0x05287143f7bd72bf, 0xe65873280afb9024, 0x0 }, /* #27 */
    { 0x2d4d03, 0x2d4592, 0xb2dbd317fd6917a2, 0x8629eb16ca1d538a, 0x2cb1e801334bc418, 0x0 }, /* #28 */
    { 0x0a75d2, 0x0a7512, 0xaae57cae2a4768c4, 0x0d1a64ed92f9a6c7, 0x9dcb17c0974dc1fd, 0x0 }, /* #29 */
    { 0x1a1e43, 0x1a1e06, 0xb7d9038bb48fc969, 0x5f648e12637e4e33, 0x5874757951117b36, 0x0 }, /* #30 */
    { 0x1c6883, 0x1c6092, 0xc65b7e0a591eea51, 0xb2a67762f67fc06d, 0x13b506a7629f29e4, 0x0 }, /* #31 */
    { 0x067d43, 0x067516, 0x72c67e459e6b5d10, 0x6151329de4e80118, 0x11754ba7b9835bf8, 0x0 }, /* #32 */
    { 0x0f6107, 0x0f6112, 0xde5da7c4df84829b, 0x3171ba26195be47c, 0xacebed9ec6289e1f, 0x0 }, /* #33 */
    { 0x0b1407, 0x0b1416, 0x6d5b5661ff609251, 0x1e16a5825651aa4e, 0x4f44b0dfa90ee803, 0x0 }, /* #34 */
    { 0x227ec6, 0x227e06, 0xc9b81dcc696cf904, 0x5c803dbaf7c375d4, 0x6d37e01171a98330, 0x0 }, /* #35 */
    { 0x2030c7, 0x203883, 0x65daafd8bdf9a1cc, 0xaab06a08d02a7bb0, 0xbb2a45cfedcf261c, 0x0 }, /* #36 */
    { 0x111c87, 0x111402, 0x5c01f3a6132072dc, 0x390c771051071f97, 0x22f57c95c2195345, 0x0 }, /* #37 */
    { 0x1f6fc7, 0x1f6787, 0x1238c7bd6124dd3e, 0xa1a2e8dd8cfaf582, 0x7095dedfd429e7bc, 0x0 }, /* #38 */
    { 0x033402, 0x033482, 0xe321f061cf36572d, 0xc3d74e6bd67c1238, 0x1f4aa1f5f8ba44f5, 0x0 }, /* #39 */
    { 0x3a3283, 0x3a3a12, 0x80a253a78585c18e, 0x2f573b6066ffa48f, 0x514b18471e861cff, 0x0 }, /* #40 */
    { 0x3e6982, 0x3e6193, 0x4ce24463be838a94, 0xf52b8afe0ae31c79, 0x57b6b965b3a06e1b, 0x0 }, /* #41 */
    { 0x116cc2, 0x116493, 0xce422aae399978f8, 0xdba1d755bb2fa089, 0xf2a053587e69d86f, 0x0 }, /* #42 */
    { 0x354bd2, 0x354b87, 0x7410223665058448, 0xe0818ee94d3309e4, 0x938e934d17d27a64, 0x0 }, /* #43 */
    { 0x034a07, 0x034a93, 0x52944047b3305314, 0xc7d4b31748ec965e, 0x8abf8d306a43bcb6, 0x0 }, /* #44 */
    { 0x197983, 0x197182, 0xe5ea416ee67ad8f3, 0xba7aaaa50945f3c1, 0x2b6f96c9dd34e532, 0x0 }, /* #45 */
    { 0x305e03, 0x305e02, 0xb724f5fe1d5de053, 0x41ca8d6a6e197373, 0x755a6893af446ce0, 0x0 }, /* #46 */
    { 0x393346, 0x393316, 0x599318d02587e352, 0x08d60b41af336217, 0x50bd0d8e7654813b, 0x0 }, /* #47 */
    { 0x0d3407, 0x0d3493, 0x0360c2bb3b7a0931, 0x9194dbad58fcabb5, 0x71cbe70de27d5d7c, 0x0 }, /* #48 */
    { 0x1f1cd7, 0x1f1c06, 0xbd52512635f9f3d3, 0x557170f821875603, 0x67e0e02e14729dd0, 0x0 }, /* #49 */
    { 0x1a6ad3, 0x1a6213, 0x22b0a3a3682da634, 0x47ff18b1ea64f6ec, 0xdab18af17dc8af48, 0x0 }, /* #50 */
    { 0x3f5717, 0x3f5f12, 0xcc731b7efdc00750, 0x7460272a52f1eba7, 0x5812f454aace1ba9, 0x0 }, /* #51 */
    { 0x011846, 0x011006, 0x4f03c03c6063c8aa, 0x0fc2b232bf059272, 0x3f410e09a15e3638, 0x0 }, /* #52 */
    { 0x391193, 0x391197, 0x8ad511ea2dcbcec2, 0xeee1f04e027e88cc, 0x9bf3219c2b4d45f6, 0x0 }, /* #53 */
    { 0x0e0856, 0x0e0812, 0x8c92f031591c39e5, 0x5e302a01b4a94e5b, 0x2e62c62fa472eb8a, 0x0 }, /* #54 */
    { 0x235307, 0x235b97, 0x4e0e0b533742ded2, 0x84bd70961a5c493a, 0xc9509abd1ce69598, 0x0 }, /* #55 */
    { 0x193642, 0x193606, 0xd43d114e899d5f2a, 0x2c43c3ec7577c3a0, 0xa7f94d6214259b8a, 0x0 }, /* #56 */
    { 0x075352, 0x075397, 0x02abfda5d4238835, 0xd6625dd6a236b5de, 0x2c499fcf31ecd257, 0x0 }, /* #57 */
    { 0x057e52, 0x057616, 0xddd8638873ab9bb4, 0x1ef30d4cf46967c9, 0xbee5563b7f4233eb, 0x0 }, /* #58 */
    { 0x1302c6, 0x130282, 0xed663e73165d4da4, 0xe9db5eacdd568501, 0x038adfc63906c8a3, 0x0 }, /* #59 */
    { 0x067012, 0x067087, 0x22636c48293f6fbd, 0xd15a4b6156b03222, 0x510920e6d28f3d9b, 0x0 }, /* #60 */
    { 0x351553, 0x351587, 0x0eab2e989c6b236f, 0xee2b6097515dbb03, 0x207fce014b0d686c, 0x0 }, /* #61 */
    { 0x323e96, 0x323e93, 0x6db84502c7c8bd1a, 0xa971bc8f04a1227c, 0xc4468873c3279a9e, 0x0 }, /* #62 */
    { 0x0b3ec3, 0x0b3612, 0xdbb137bdb1fec3e4, 0x1e4c00fb6eff87df, 0xbd6536c242ff3c05, 0x0 }, /* #63 */
    { 0x271592, 0x271592, 0xa65d3a96a841c491, 0x99719a233e24bad6, 0x0ceba0736a1d09bb, 0x0 }, /* #64 */
    { 0x062046, 0x062016, 0x7891157740e91ea2, 0x43e92a2e2de5555a, 0x34a7eb491303c948, 0x0 }, /* #65 */
    { 0x2a2cc6, 0x2a2497, 0x3f074150f4325782, 0xee92ab7be33904fc, 0x507495d510f95286, 0x0 }, /* #66 */
    { 0x3a2f43, 0x3a2717, 0x3d29b26e26cebf05, 0x4d0efed69d2e77cf, 0xf01ab39789a04736, 0x0 }, /* #67 */
    { 0x133c46, 0x133483, 0xbc16b62e835eb36e, 0xda369330e8f32d04, 0xe1e022fd9a6b866a, 0x0 }, /* #68 */
    { 0x3512d3, 0x351a16, 0x91774b1823361dd5, 0x17f724a1009c319c, 0x798026772299ec39, 0x0 }, /* #69 */
    { 0x310c43, 0x310412, 0x456c1a6f04e0fc15, 0x393d8b2ba86fe2ce, 0x0c2e8f435c711947, 0x0 }, /* #70 */
    { 0x3d4c93, 0x3d4487, 0x9c016a691267e67a, 0xb383634eb1950de1, 0xe87e071a60d2d899, 0x0 }, /* #71 */
    { 0x2d1dc2, 0x2d1593, 0x90b6c90212d17a60, 0xd47e10f6b4d354f1, 0xbc38b80b5dfe256f, 0x0 }, /* #72 */
    { 0x322d97, 0x322503, 0x53177be3e2708d6a, 0x602a10bd2081fc25, 0xf2ed6b26c1ee9145, 0x0 }, /* #73 */
    { 0x333b12, 0x333392, 0xb7eca175d153ee44, 0xb64b4e4672aa53bc, 0x01a1532f5ea99a88, 0x0 }, /* #74 */
    { 0x2a5d02, 0x2a5586, 0xee91c92f49130b0b, 0x9fba8902b79b840a, 0x4ed7402c91778701, 0x0 }, /* #75 */
    { 0x225bc3, 0x225383, 0x09ac28c0d0fd5fb4, 0xd871557ea94f5e73, 0x313ad34227ae0141, 0x0 }, /* #76 */
    { 0x2b7883, 0x2b7887, 0x5af60bb5ac7d30af, 0xc1a56886f65efc1e, 0x9950a32eb61e3491, 0x0 }, /* #77 */
    { 0x133d82, 0x133593, 0xdb5fcc0631ca149b, 0xe0010f3cf354ca6e, 0xfb5ebcc93e754a2d, 0x0 }, /* #78 */
    { 0x293d97, 0x293517, 0x102f321fc5f47223, 0x2cc08be0ad6b6e9f, 0xe36ea63f18890384, 0x0 }, /* #79 */
    { 0x336892, 0x336802, 0xef048fdc00b7cf4b, 0x74e3f5e4ed10e807, 0x7a2099f713a6e744, 0x0 }, /* #80 */
    { 0x1e6213, 0x1e6207, 0x0ec4a5adb74efa16, 0x66782b0b0a123d03, 0xa84c7aa2ad3cbd13, 0x0 }, /* #81 */
    { 0x057e17, 0x057612, 0x95181c99e29b9171, 0x02780798ed69e27f, 0x92a01500f531aef2, 0x0 }, /* #82 */
    { 0x2c5a07, 0x2c5286, 0xb73fe11e5d3784c8, 0x99113d6eef43c7a6, 0x1e2ea3af6df3bd22, 0x0 }, /* #83 */
    { 0x1024c6, 0x102c87, 0x6ed683a697aa4186, 0x84a509f14d9fe856, 0xea3179b54a0a5930, 0x0 }, /* #84 */
    { 0x2d5c07, 0x2d5496, 0xed3820eebbbfa152, 0xc21dceb6f3937887, 0x2b1a5237c82c28cb, 0x0 }, /* #85 */
    { 0x115dd2, 0x115502, 0x432cc37fab6dd05e, 0x3355f8780a7a6f1a, 0x0fd6cb07a0f36144, 0x0 }, /* #86 */
    { 0x052357, 0x052303, 0x4936466f446e3b7a, 0x52a8d51b4c1f7613, 0xf68d7153f84ec567, 0x0 }, /* #87 */
    { 0x024693, 0x024697, 0x1b6f4fbe5ea075e4, 0xcd58059ae900597d, 0x4e174a2375a01c67, 0x0 }, /* #88 */
    { 0x017cd3, 0x017483, 0x113e744e52a5ab2e, 0x99b675d6a7a57f9b, 0x7787fe77ab002b93, 0x0 }, /* #89 */
    { 0x0b3902, 0x0b3193, 0xc2e91fe04889153a, 0xe86401c44d63897f, 0xda851e1bfb258bbb, 0x0 }, /* #90 */
    { 0x135983, 0x135186, 0xb700d38194df05b7, 0x8b7cba9dca393512, 0x2b8418e3caa5d0a5, 0x0 }, /* #91 */
    { 0x3951d2, 0x395906, 0x89776252c817adf5, 0x0ca33030732c84f5, 0x7cd4322254eb2900, 0x0 }, /* #92 */
    { 0x116906, 0x116106, 0xc63d0e8720f5b0b8, 0x115517f6a44522b7, 0xb4e7f6907cb08e01, 0x0 }, /* #93 */
    { 0x2e6643, 0x2e6682, 0xdfc9930a150bec8e, 0xb497020c99e04192, 0x2b3290fd7b2baafc, 0x0 }, /* #94 */
    { 0x106006, 0x106016, 0x3282d45ea7e43f76, 0x240685c53ac5fd3f, 0x0e7c4e996d1e4237, 0x0 }, /* #95 */
};
uint32_t const g_cTests_sub_u64_locked = RT_ELEMENTS(g_aTests_sub_u64_locked);

BINU64_TEST_T const g_aTests_sbb_u64[] =
{
    { 0x221086, 0x221046, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x1c7492, 0x1c7446, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x153a57, 0x153297, 0x0000000000000000, 0xffffffffffffffff, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x2874d6, 0x287446, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x282557, 0x282597, 0x0000000000000000, 0xffffffffffffffff, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x1c7fd3, 0x1c7797, 0x0000000000000000, 0xffffffffffffffff, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x252e82, 0x252686, 0x9c6076c4667e7db4, 0x9c6076c4667e7db4, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x055557, 0x055506, 0x70fda6462d5b9423, 0x70fda6462d5b9422, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x161287, 0x161282, 0xec46dfb5bc53a058, 0xec46dfb5bc53a057, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x2155c3, 0x215506, 0x63aa2772a59699ab, 0x63aa2772a59699aa, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x145c52, 0x145406, 0x6e4cc6c5b198dd12, 0x6e4cc6c5b198dd12, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x131553, 0x131586, 0xc59dca82d845fb43, 0xc59dca82d845fb42, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x147407, 0x147c93, 0x339f3e06db6a9125, 0x9ae544c59c6a10ba, 0x98b9f9413f00806a, 0x0 }, /* #12 */
    { 0x0f1457, 0x0f1497, 0xa606c94d99128972, 0xb80dfda638519b4e, 0xedf8cba760c0ee23, 0x0 }, /* #13 */
    { 0x086e03, 0x086697, 0x9d7e8b6269681850, 0xec2c174f3491b44d, 0xb152741334d66402, 0x0 }, /* #14 */
    { 0x163a42, 0x163a06, 0xc2bf6d8dc8c76436, 0x5dd598a36e1fb1f6, 0x64e9d4ea5aa7b240, 0x0 }, /* #15 */
    { 0x023d13, 0x023586, 0xf7e2adcc0ed54e58, 0x8512d4cd26a85721, 0x72cfd8fee82cf736, 0x0 }, /* #16 */
    { 0x396b52, 0x396b02, 0xa81bc1b6afa1abc4, 0x7873b14cb1584bd3, 0x2fa81069fe495ff1, 0x0 }, /* #17 */
    { 0x191f92, 0x191797, 0x1471853f4e44a500, 0xcbd8b2de0955aef3, 0x4898d26144eef60d, 0x0 }, /* #18 */
    { 0x223083, 0x223897, 0x762ab9bc83b74779, 0xc074d0b37d30501b, 0xb5b5e9090686f75d, 0x0 }, /* #19 */
    { 0x292393, 0x292396, 0xfb28fb636c6eb5a3, 0xda63961801a22499, 0x20c5654b6acc9109, 0x0 }, /* #20 */
    { 0x287fc7, 0x287f02, 0xb8a7df7bad92a8bd, 0x787ff7b3a0f91061, 0x4027e7c80c99985b, 0x0 }, /* #21 */
    { 0x0e2e17, 0x0e2693, 0x0713132b22b8c571, 0xb57fc0360eb9330b, 0x519352f513ff9265, 0x0 }, /* #22 */
    { 0x3606d3, 0x360617, 0x14a4cbf6f0bea1e4, 0x35b82bb5942bdd99, 0xdeeca0415c92c44a, 0x0 }, /* #23 */
    { 0x0b0146, 0x0b0106, 0x2bc8cc2dc9d9007f, 0x0ca7648333aaf027, 0x1f2167aa962e1058, 0x0 }, /* #24 */
    { 0x2c7386, 0x2c7b93, 0x053bb3624bba07e2, 0x812da4743e2ee208, 0x840e0eee0d8b25da, 0x0 }, /* #25 */
    { 0x3f5406, 0x3f5486, 0xf119214bd22508f8, 0xeaff6632b7a802e1, 0x0619bb191a7d0617, 0x0 }, /* #26 */
    { 0x310903, 0x310916, 0x87ea0f51d68d00a0, 0x373254e94f52aaaf, 0x50b7ba68873a55f0, 0x0 }, /* #27 */
    { 0x036187, 0x036912, 0xe43ad1f3c1dc54e1, 0x79b8e94c881607fe, 0x6a81e8a739c64ce2, 0x0 }, /* #28 */
    { 0x070d83, 0x070512, 0xf7cf2610c5f3b9e5, 0x70ed54cd0ccffb7c, 0x86e1d143b923be68, 0x0 }, /* #29 */
    { 0x2e1c87, 0x2e1412, 0x350e1b01ce80ead1, 0x1c78074be1f0ec1a, 0x189613b5ec8ffeb6, 0x0 }, /* #30 */
    { 0x394457, 0x394412, 0xeebd011c5c44f076, 0x038f1486249443ad, 0xeb2dec9637b0acc8, 0x0 }, /* #31 */
    { 0x1a2056, 0x1a2017, 0x116b43a870117487, 0x51e26048f3f38e09, 0xbf88e35f7c1de67e, 0x0 }, /* #32 */
    { 0x3c48c2, 0x3c4083, 0x244f8752c904cfa1, 0xc741a5270907a6b0, 0x5d0de22bbffd28f1, 0x0 }, /* #33 */
    { 0x2d62c7, 0x2d6a02, 0x8159c3a33fe7c678, 0x7bc66e8b011e8ad5, 0x059355183ec93ba2, 0x0 }, /* #34 */
    { 0x293a82, 0x293282, 0xaaa8e43569417377, 0x8de7d018b19f2d26, 0x1cc1141cb7a24651, 0x0 }, /* #35 */
    { 0x220153, 0x220193, 0x2aac4ff20f96c007, 0xcdcc3be836e64058, 0x5ce01409d8b07fae, 0x0 }, /* #36 */
    { 0x2936c2, 0x293e06, 0xd00e8e82d23bbf5f, 0x53cd65e55becfecf, 0x7c41289d764ec090, 0x0 }, /* #37 */
    { 0x3e5202, 0x3e5213, 0x00be4a7827a7a9c8, 0x31cc546713745a8a, 0xcef1f61114334f3e, 0x0 }, /* #38 */
    { 0x0f7346, 0x0f7302, 0x6a2069fa063e892d, 0x68d99540e11e7dea, 0x0146d4b925200b43, 0x0 }, /* #39 */
    { 0x097c06, 0x097486, 0xee7364da2af29da0, 0x9192ad5ac9c313a0, 0x5ce0b77f612f8a00, 0x0 }, /* #40 */
    { 0x2466d7, 0x246693, 0x13e140dbc48a15e4, 0xcd9e45e4931b7e86, 0x4642faf7316e975d, 0x0 }, /* #41 */
    { 0x394a06, 0x394283, 0x258e8d575b116e9d, 0xd78b6f4e457ea107, 0x4e031e091592cd96, 0x0 }, /* #42 */
    { 0x3c2b93, 0x3c2b12, 0x8b6ddade1689aaf9, 0x2dd73ce6240a8e2a, 0x5d969df7f27f1cce, 0x0 }, /* #43 */
    { 0x2a55d7, 0x2a5507, 0x622e348f89099acd, 0x738599d66e813241, 0xeea89ab91a88688b, 0x0 }, /* #44 */
    { 0x135d47, 0x135d93, 0x79d46a71f8d13a70, 0xe4c8ad9194aa8db9, 0x950bbce06426acb6, 0x0 }, /* #45 */
    { 0x014c56, 0x014483, 0xa4dd35f1520df42e, 0xad63d375d6db47dc, 0xf779627b7b32ac52, 0x0 }, /* #46 */
    { 0x335b83, 0x335b97, 0x6a4ac5b5d44f1932, 0xd880152d3eb16653, 0x91cab088959db2de, 0x0 }, /* #47 */
    { 0x3c4713, 0x3c4786, 0xd3f941492d754ebf, 0xaeb653feb2d0cf71, 0x2542ed4a7aa47f4d, 0x0 }, /* #48 */
    { 0x2f7957, 0x2f7112, 0xd7eb9eb8bc705574, 0x1b1ae88b6d1bfdcb, 0xbcd0b62d4f5457a8, 0x0 }, /* #49 */
    { 0x0a0bc2, 0x0a0382, 0xb36d5c6b4f265684, 0x844761fa4f2856d0, 0x2f25fa70fffdffb4, 0x0 }, /* #50 */
    { 0x0e2a96, 0x0e2283, 0x8ab7d759e459c92e, 0xe943b22b167ef09d, 0xa174252ecddad891, 0x0 }, /* #51 */
    { 0x001007, 0x001883, 0x6d8618150b378538, 0xe5fa7ead7b077583, 0x878b996790300fb4, 0x0 }, /* #52 */
    { 0x226957, 0x226183, 0x2ee312c323187d6b, 0xfb9126ad2063a1b3, 0x3351ec1602b4dbb7, 0x0 }, /* #53 */
    { 0x3a1a87, 0x3a1a12, 0xa334e524e735bd12, 0x6e1de8e42a810289, 0x3516fc40bcb4ba88, 0x0 }, /* #54 */
    { 0x150e83, 0x150687, 0x22884e8a76472d69, 0xd55f7557cb5b4fd8, 0x4d28d932aaebdd90, 0x0 }, /* #55 */
    { 0x0724c7, 0x072482, 0xf6e2abb0283da61d, 0x849ed0f8033122b6, 0x7243dab8250c8366, 0x0 }, /* #56 */
    { 0x353697, 0x353613, 0x01d51d190b088fe4, 0x4f7d0dcb67e4bf6b, 0xb2580f4da323d078, 0x0 }, /* #57 */
    { 0x1f35d6, 0x1f3597, 0x8e5dce88b49e8d46, 0xed0aea987fed374e, 0xa152e3f034b155f8, 0x0 }, /* #58 */
    { 0x132612, 0x132e12, 0xa0ff5b4cde26c574, 0x5c2765824a524e3d, 0x44d7f5ca93d47737, 0x0 }, /* #59 */
    { 0x3c3942, 0x3c3987, 0x4010a024db121a3d, 0xb9e83c740a587090, 0x862863b0d0b9a9ad, 0x0 }, /* #60 */
    { 0x182e12, 0x182697, 0xc7f86f33dbed29bb, 0xd7e59062704be4be, 0xf012ded16ba144fd, 0x0 }, /* #61 */
    { 0x130806, 0x130887, 0x3f58fcb548b01a1e, 0xb1cffba4760b9d84, 0x8d890110d2a47c9a, 0x0 }, /* #62 */
    { 0x364187, 0x364102, 0xd212aec53a6dac1e, 0x4f5ce2fa1d421c38, 0x82b5cbcb1d2b8fe5, 0x0 }, /* #63 */
    { 0x3c0412, 0x3c0486, 0xe0793c9d4a406f9c, 0xb42139dbebd2930a, 0x2c5802c15e6ddc92, 0x0 }, /* #64 */
    { 0x130ec3, 0x130687, 0x2da4234b6c810c87, 0xf6baf769f870f293, 0x36e92be1741019f3, 0x0 }, /* #65 */
    { 0x0348d7, 0x034013, 0x4484e400f26e1538, 0x4dc07d54eb01fcf8, 0xf6c466ac076c183f, 0x0 }, /* #66 */
    { 0x1f0256, 0x1f0286, 0xf7c3efd1ed098747, 0xe58e7aa29be69cc6, 0x1235752f5122ea81, 0x0 }, /* #67 */
    { 0x106f46, 0x106f16, 0xbb63b34d72d86266, 0x61187f096a06af77, 0x5a4b344408d1b2ef, 0x0 }, /* #68 */
    { 0x240507, 0x240587, 0xa9057147eaea46ff, 0xedec46100960a1d4, 0xbb192b37e189a52a, 0x0 }, /* #69 */
    { 0x3f1853, 0x3f1816, 0xbe50d556d9063676, 0x562c21604a116688, 0x6824b3f68ef4cfed, 0x0 }, /* #70 */
    { 0x2e0dc2, 0x2e0506, 0x778d481beff75a85, 0x3bdb903aaa600ac5, 0x3bb1b7e145974fc0, 0x0 }, /* #71 */
    { 0x242f96, 0x242f16, 0xce164fcf89fcb059, 0x6032b98cf0ea351d, 0x6de3964299127b3c, 0x0 }, /* #72 */
    { 0x1639d7, 0x163197, 0x2eadd12111dce7e4, 0xdc0a79d7787769cc, 0x52a3574999657e17, 0x0 }, /* #73 */
    { 0x384406, 0x384403, 0x4b5f619699bee6a8, 0x4fa5b5ad97d8af15, 0xfbb9abe901e63793, 0x0 }, /* #74 */
    { 0x2167c7, 0x216782, 0xea221d3c2258de1d, 0xaf44b59ee6637552, 0x3add679d3bf568ca, 0x0 }, /* #75 */
    { 0x100cd7, 0x100c83, 0x724d2e570ec49eac, 0xeb66f6b6ac2e35b6, 0x86e637a0629668f5, 0x0 }, /* #76 */
    { 0x0f6513, 0x0f6582, 0xf75a03487f6b5a8b, 0xe9dbecac52b28be0, 0x0d7e169c2cb8ceaa, 0x0 }, /* #77 */
    { 0x307f83, 0x307f83, 0x58f30579b9a6a033, 0x969a0cd069291da1, 0xc258f8a9507d8291, 0x0 }, /* #78 */
    { 0x1a3383, 0x1a3397, 0x81f9c7bf6e0b4e56, 0xf5a3ff0da50b9db8, 0x8c55c8b1c8ffb09d, 0x0 }, /* #79 */
    { 0x020b82, 0x020b93, 0x676591c2823f9ea6, 0xcb191439bab48fce, 0x9c4c7d88c78b0ed8, 0x0 }, /* #80 */
    { 0x2b7993, 0x2b7112, 0x492df18653e28072, 0x1f1df417d6f4a5e6, 0x2a0ffd6e7cedda8b, 0x0 }, /* #81 */
    { 0x2b3bd2, 0x2b3b97, 0x4b0b90592cb03f05, 0xa22a2d51973011d8, 0xa8e1630795802d2d, 0x0 }, /* #82 */
    { 0x2e5886, 0x2e5093, 0x03b3febdd84e3809, 0xf165a9f62dbe6a3e, 0x124e54c7aa8fcdcb, 0x0 }, /* #83 */
    { 0x152ed7, 0x152697, 0x9216582c3674ff20, 0x9b75605b6ef0d33c, 0xf6a0f7d0c7842be3, 0x0 }, /* #84 */
    { 0x146fc6, 0x146f16, 0xa53e5d812f030542, 0x5f037c741fb0e0be, 0x463ae10d0f522484, 0x0 }, /* #85 */
    { 0x353302, 0x353b87, 0x6bd0021c1ae3021f, 0x9178513e49d4019c, 0xda57b0ddd10f0083, 0x0 }, /* #86 */
    { 0x2802c7, 0x280212, 0x676a01877436c277, 0x3f9badfed4414c98, 0x27ce53889ff575de, 0x0 }, /* #87 */
    { 0x0d3a12, 0x0d3216, 0x433c9d410cc2b4b2, 0x013759a0eb7f6493, 0x420543a02143501f, 0x0 }, /* #88 */
    { 0x185252, 0x185286, 0xe1bb93fd070dfbf3, 0x97b4a31e233eeef3, 0x4a06f0dee3cf0d00, 0x0 }, /* #89 */
    { 0x350156, 0x350183, 0xb27a13e402749325, 0xf0fd5158e5b4fda4, 0xc17cc28b1cbf9581, 0x0 }, /* #90 */
    { 0x1648d6, 0x164887, 0x32c09bf20e89d3cc, 0x967c73d29625a147, 0x9c44281f78643285, 0x0 }, /* #91 */
    { 0x3a7a03, 0x3a7206, 0x3c992fcc5f4acbfd, 0x3360b8377b2e493a, 0x09387794e41c82c2, 0x0 }, /* #92 */
    { 0x0c49c2, 0x0c4107, 0x279f5024133f535c, 0x4ec1d7228ccfb18b, 0xd8dd7901866fa1d1, 0x0 }, /* #93 */
    { 0x1d5752, 0x1d5792, 0xf4bdc18af3b719d0, 0x84aac94ee3bb6a5e, 0x7012f83c0ffbaf72, 0x0 }, /* #94 */
    { 0x260447, 0x260c06, 0xb852611f31722637, 0x56eb99db05d73553, 0x6166c7442b9af0e3, 0x0 }, /* #95 */
};
uint32_t const g_cTests_sbb_u64 = RT_ELEMENTS(g_aTests_sbb_u64);

BINU64_TEST_T const g_aTests_sbb_u64_locked[] =
{
    { 0x124752, 0x124746, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x244416, 0x244446, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x113456, 0x113446, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x0d2182, 0x0d2146, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x0e3d42, 0x0e3546, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x1e5d57, 0x1e5597, 0x0000000000000000, 0xffffffffffffffff, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x383747, 0x383782, 0x90685e350dc73fb1, 0x90685e350dc73fb0, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x301d97, 0x301506, 0x6165ffa165d2029d, 0x6165ffa165d2029c, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x312f07, 0x312786, 0xe982e0bc438ed719, 0xe982e0bc438ed718, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x0d0682, 0x0d0602, 0x4eed9e746d108fea, 0x4eed9e746d108fea, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x187c17, 0x187482, 0x8c7d10451683cd7b, 0x8c7d10451683cd7a, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x121417, 0x121406, 0x752eb7ca74de92c6, 0x752eb7ca74de92c5, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x357282, 0x357293, 0x10c8b93dd5d388d4, 0xca3788bd38c161c8, 0x469130809d12270c, 0x0 }, /* #12 */
    { 0x071857, 0x071893, 0x61f4a7289123ba49, 0xc5ff92bff732857f, 0x9bf5146899f134c9, 0x0 }, /* #13 */
    { 0x2f52d2, 0x2f5282, 0x8cd93c9a4fa8641b, 0x8a0f612ac2a87ce3, 0x02c9db6f8cffe738, 0x0 }, /* #14 */
    { 0x241bc6, 0x241b12, 0x81da719b1c33c084, 0x5b8dd6833157ef07, 0x264c9b17eadbd17d, 0x0 }, /* #15 */
    { 0x1a7486, 0x1a7c93, 0x738a647a40d24cee, 0xd5de05713e27914f, 0x9dac5f0902aabb9f, 0x0 }, /* #16 */
    { 0x373a53, 0x373287, 0xa8b21651f5dece6d, 0xd93c9f80daa8320a, 0xcf7576d11b369c62, 0x0 }, /* #17 */
    { 0x0d2496, 0x0d2417, 0x15883d6b21d6e795, 0x719954fe208f1c5c, 0xa3eee86d0147cb39, 0x0 }, /* #18 */
    { 0x287c16, 0x287497, 0x4ad621239a890ea2, 0xfdd06779f2e165ac, 0x4d05b9a9a7a7a8f6, 0x0 }, /* #19 */
    { 0x1b23d6, 0x1b2b93, 0x38fae11c24484770, 0xaa377ce7db0bc60b, 0x8ec36434493c8165, 0x0 }, /* #20 */
    { 0x190152, 0x190196, 0xe4f63ef1c2f3376b, 0xcfdde62e1a43059c, 0x151858c3a8b031cf, 0x0 }, /* #21 */
    { 0x144757, 0x144793, 0x2efcba764181c347, 0xc38d2b360b794998, 0x6b6f8f40360879ae, 0x0 }, /* #22 */
    { 0x1f4f86, 0x1f4702, 0x4dd77d254127e0ef, 0x0814f31bbc861357, 0x45c28a0984a1cd98, 0x0 }, /* #23 */
    { 0x360783, 0x360797, 0x811989588cb1cc35, 0xe9ef5b2ff169029a, 0x972a2e289b48c99a, 0x0 }, /* #24 */
    { 0x035d17, 0x035502, 0x6dd621a43da33c2b, 0x35344da297a82a62, 0x38a1d401a5fb11c8, 0x0 }, /* #25 */
    { 0x382e57, 0x382e93, 0x7997198241a95060, 0xaa8d3922763bca7f, 0xcf09e05fcb6d85e0, 0x0 }, /* #26 */
    { 0x0021c6, 0x002106, 0xc3009b3b8c0bac46, 0x03049f8e6954f993, 0xbffbfbad22b6b2b3, 0x0 }, /* #27 */
    { 0x307317, 0x307302, 0x894550d0a02451b8, 0x00c55798b1737397, 0x887ff937eeb0de20, 0x0 }, /* #28 */
    { 0x3d3e82, 0x3d3617, 0x088ef923fe951091, 0x4466121ad0320993, 0xc428e7092e6306fe, 0x0 }, /* #29 */
    { 0x341107, 0x341103, 0x169d4a745404a50e, 0x430867ddfc2152c7, 0xd394e29657e35246, 0x0 }, /* #30 */
    { 0x350647, 0x350697, 0x291753499a658df2, 0xab8e157f17b44874, 0x7d893dca82b1457d, 0x0 }, /* #31 */
    { 0x095406, 0x095413, 0x162d7d0ef9e4a683, 0x63630a6d9e85338c, 0xb2ca72a15b5f72f7, 0x0 }, /* #32 */
    { 0x396bc6, 0x396307, 0x223b52aab6c176f6, 0x474189722a925cf0, 0xdaf9c9388c2f1a06, 0x0 }, /* #33 */
    { 0x304e56, 0x304602, 0x7e8db137e97bdbcc, 0x4c4db33b4dacf0c4, 0x323ffdfc9bceeb08, 0x0 }, /* #34 */
    { 0x083403, 0x083c12, 0x86136b346c478793, 0x2f81b0d2ea3a3043, 0x5691ba61820d574f, 0x0 }, /* #35 */
    { 0x396116, 0x396103, 0x0add1aaf38a3b85d, 0x1af938d88fc0549d, 0xefe3e1d6a8e363c0, 0x0 }, /* #36 */
    { 0x3f6897, 0x3f6016, 0x7e4984900d495a52, 0x70cb9ad2586ed2e8, 0x0d7de9bdb4da8769, 0x0 }, /* #37 */
    { 0x046453, 0x046c16, 0xb456bf63e91ebf15, 0x7f07426b5fd08b0f, 0x354f7cf8894e3405, 0x0 }, /* #38 */
    { 0x346196, 0x346983, 0x4f3b7b2e8cb9e409, 0x8f9c7cbcf06207f7, 0xbf9efe719c57dc12, 0x0 }, /* #39 */
    { 0x233543, 0x233d06, 0xc0e9cff92ed0bd93, 0x43376797f5a3ccd1, 0x7db26861392cf0c1, 0x0 }, /* #40 */
    { 0x0f6f42, 0x0f6713, 0x3c0d9085933ff863, 0x4dfd4fd68211077c, 0xee1040af112ef0e7, 0x0 }, /* #41 */
    { 0x272a83, 0x272287, 0xdad687863a70bb9c, 0xf950513f0e718fa3, 0xe18636472bff2bf8, 0x0 }, /* #42 */
    { 0x202dc3, 0x202582, 0xc827b2302123db5f, 0x86f9f753bc723b49, 0x412dbadc64b1a015, 0x0 }, /* #43 */
    { 0x2a2797, 0x2a2f06, 0x8412f394a4ea82d4, 0x36f9006b52b6ba63, 0x4d19f3295233c870, 0x0 }, /* #44 */
    { 0x3f0357, 0x3f0b16, 0xbf5dceecad342ef0, 0x667ee5e7e2b13706, 0x58dee904ca82f7e9, 0x0 }, /* #45 */
    { 0x0b1c02, 0x0b1492, 0xc53abe686a493534, 0x8133da1ebbb02cd6, 0x4406e449ae99085e, 0x0 }, /* #46 */
    { 0x375307, 0x375b06, 0x924a543ba55ac38e, 0x33f5c54442a0af2b, 0x5e548ef762ba1462, 0x0 }, /* #47 */
    { 0x2b2657, 0x2b2682, 0xc66dcf62a89700bb, 0x8f4fdb402307c152, 0x371df422858f3f68, 0x0 }, /* #48 */
    { 0x156bd7, 0x156b87, 0x5be7e2729b58cfff, 0xacef3337031a3f63, 0xaef8af3b983e909b, 0x0 }, /* #49 */
    { 0x3e3802, 0x3e3087, 0x4d670caf48132af3, 0xe4532311bec76621, 0x6913e99d894bc4d2, 0x0 }, /* #50 */
    { 0x372006, 0x372012, 0x6af30ac4ddbdffc2, 0x303c13fa83841af7, 0x3ab6f6ca5a39e4cb, 0x0 }, /* #51 */
    { 0x007147, 0x007112, 0xddec823be04886e7, 0x5c1a2d91fb3a52ab, 0x81d254a9e50e343b, 0x0 }, /* #52 */
    { 0x3271c2, 0x327912, 0x94fcf88e50d2d880, 0x612ef9c17cdf62c4, 0x33cdfeccd3f375bc, 0x0 }, /* #53 */
    { 0x287792, 0x287712, 0xe09263b67280fdd8, 0x25f572401f76fb29, 0xba9cf176530a02af, 0x0 }, /* #54 */
    { 0x144ad6, 0x144216, 0xba174dd0e0702c55, 0x214bbae708a174f9, 0x98cb92e9d7ceb75c, 0x0 }, /* #55 */
    { 0x2f1b92, 0x2f1b12, 0xd987955ae8198eb8, 0x6cc91cd007b8344f, 0x6cbe788ae0615a69, 0x0 }, /* #56 */
    { 0x284287, 0x284292, 0xce3edef76bdac1c6, 0x80ba9ad909f9c9c7, 0x4d84441e61e0f7fe, 0x0 }, /* #57 */
    { 0x076c97, 0x076407, 0x22c77985343886d9, 0x71f3a9cb6a293e81, 0xb0d3cfb9ca0f4857, 0x0 }, /* #58 */
    { 0x367702, 0x367f12, 0xa42d759bf3119dc3, 0x6fdd2c731d2d89f8, 0x34504928d5e413cb, 0x0 }, /* #59 */
    { 0x365a46, 0x365206, 0x7970ec32cf2b62c8, 0x6d1836012310bc90, 0x0c58b631ac1aa638, 0x0 }, /* #60 */
    { 0x155082, 0x155082, 0xc4291c5e95b891b5, 0xbd03efd9349ee823, 0x07252c856119a992, 0x0 }, /* #61 */
    { 0x156d82, 0x156587, 0x9c1494457c1c12dc, 0xd616111749c01522, 0xc5fe832e325bfdba, 0x0 }, /* #62 */
    { 0x2d21d2, 0x2d2102, 0x6b20a50e9869b1ad, 0x2f4a6c756daf124c, 0x3bd638992aba9f61, 0x0 }, /* #63 */
    { 0x144883, 0x144087, 0xb8b8173f03ee3785, 0xdf540cbe9f41e922, 0xd9640a8064ac4e62, 0x0 }, /* #64 */
    { 0x2879d2, 0x287993, 0x76fa198dbe420b1c, 0xc3b53f427653755e, 0xb344da4b47ee95be, 0x0 }, /* #65 */
    { 0x1d1257, 0x1d1287, 0xa5e704e2a9b7c6e9, 0xf0b1ae03a8a56d66, 0xb53556df01125982, 0x0 }, /* #66 */
    { 0x3f54d6, 0x3f5406, 0xf4cb25597698f083, 0x2041974b960f73f0, 0xd4898e0de0897c93, 0x0 }, /* #67 */
    { 0x0702d6, 0x070297, 0x41f584860f335f15, 0xda0707710a00986c, 0x67ee7d150532c6a9, 0x0 }, /* #68 */
    { 0x1d5a53, 0x1d5a06, 0x844fad1acf9ad87b, 0x1de5e4b5681718aa, 0x6669c8656783bfd0, 0x0 }, /* #69 */
    { 0x254ac7, 0x254a06, 0x809233756ac3459c, 0x20fae69de6cf551b, 0x5f974cd783f3f080, 0x0 }, /* #70 */
    { 0x322542, 0x322d02, 0x9edd1a3f237567f6, 0x762e934f3d129232, 0x28ae86efe662d5c4, 0x0 }, /* #71 */
    { 0x2d1ed7, 0x2d1606, 0x5e6e59f8dcedeed6, 0x3cabdde3a1698511, 0x21c27c153b8469c4, 0x0 }, /* #72 */
    { 0x0515d6, 0x051512, 0x7d62148423a48ed8, 0x0012c4fc26f15b1c, 0x7d4f4f87fcb333bc, 0x0 }, /* #73 */
    { 0x275316, 0x275302, 0xcd06d5a505bc37df, 0x3f9169c126cc2901, 0x8d756be3def00ede, 0x0 }, /* #74 */
    { 0x353403, 0x353407, 0x169e90168f725ec7, 0x5f24eff39c832324, 0xb779a022f2ef3ba2, 0x0 }, /* #75 */
    { 0x1d3102, 0x1d3193, 0xd0c167bf0486cac7, 0xf1d5ff16b94f04e9, 0xdeeb68a84b37c5de, 0x0 }, /* #76 */
    { 0x3d2fc3, 0x3d2706, 0xf30cfb1f7936fd3d, 0x05afce40f083c918, 0xed5d2cde88b33424, 0x0 }, /* #77 */
    { 0x1c3d87, 0x1c3583, 0x93972c5cfa4cf3bd, 0xb1c2f1d99c1c5a08, 0xe1d43a835e3099b4, 0x0 }, /* #78 */
    { 0x3733d6, 0x373b06, 0xc1fd7d45aa634216, 0x5e8f3b9ca6ac5114, 0x636e41a903b6f102, 0x0 }, /* #79 */
    { 0x186657, 0x186606, 0x630664a621f1bd14, 0x2be7f66d41275db2, 0x371e6e38e0ca5f61, 0x0 }, /* #80 */
    { 0x3d2bd7, 0x3d2383, 0x9877b1ca7db5647f, 0xf86befd114c9ae49, 0xa00bc1f968ebb635, 0x0 }, /* #81 */
    { 0x0a6513, 0x0a6597, 0x80a5319da06e5c5e, 0xee5e830f7797f6ee, 0x9246ae8e28d6656f, 0x0 }, /* #82 */
    { 0x010282, 0x010293, 0x9119fbd8d8efc4f1, 0xdf43497af77b5fe3, 0xb1d6b25de174650e, 0x0 }, /* #83 */
    { 0x0151c3, 0x015983, 0x1dd7ed8bf5f64b0d, 0x8a8dbfd078080dd9, 0x934a2dbb7dee3d33, 0x0 }, /* #84 */
    { 0x083c87, 0x083c87, 0x4043bbaeef368896, 0xa6bd8646fce6bf00, 0x99863567f24fc995, 0x0 }, /* #85 */
    { 0x265e16, 0x265692, 0xcd357198a01b6a62, 0xa3ceefa860c4509d, 0x296681f03f5719c5, 0x0 }, /* #86 */
    { 0x0c7fd2, 0x0c7702, 0xc2da5b2ca0331d84, 0x2c0c125be04a7ac1, 0x96ce48d0bfe8a2c3, 0x0 }, /* #87 */
    { 0x1e78c7, 0x1e7092, 0xb16994a3f6a96eb1, 0x95cf3188247e2e76, 0x1b9a631bd22b403a, 0x0 }, /* #88 */
    { 0x164953, 0x164112, 0x09de8ef176aae0d0, 0x093f5107af507d10, 0x009f3de9c75a63bf, 0x0 }, /* #89 */
    { 0x2f4816, 0x2f4883, 0x771c767dde00a67d, 0xbcc93f026efc1cb9, 0xba53377b6f0489c4, 0x0 }, /* #90 */
    { 0x2404d3, 0x240487, 0x9dc14f9f179caa8d, 0x9e49e77a7d88825a, 0xff7768249a142832, 0x0 }, /* #91 */
    { 0x0a7152, 0x0a7906, 0xabb40e92f99a6ee9, 0x35122ce6dc187f18, 0x76a1e1ac1d81efd1, 0x0 }, /* #92 */
    { 0x0f7603, 0x0f7692, 0xe6e330f5382848d2, 0xbc263ac76786bebc, 0x2abcf62dd0a18a15, 0x0 }, /* #93 */
    { 0x2f1893, 0x2f1087, 0x36a7c695d4b14849, 0xc4b0c427101e9f33, 0x71f7026ec492a915, 0x0 }, /* #94 */
    { 0x156842, 0x156812, 0xa02e61ebee19c873, 0x64836a19e10bdd46, 0x3baaf7d20d0deb2d, 0x0 }, /* #95 */
};
uint32_t const g_cTests_sbb_u64_locked = RT_ELEMENTS(g_aTests_sbb_u64_locked);

BINU64_TEST_T const g_aTests_or_u64[] =
{
    { 0x046556, 0x046546, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x0f46c6, 0x0f4646, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x1770d7, 0x177046, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x101bc6, 0x101346, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x030717, 0x030746, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x0961c7, 0x096146, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x0a7393, 0x0a7306, 0x6a3fbcce392b46f3, 0x6a3fbcce392b46f3, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x3d1b47, 0x3d1386, 0x807bd18431f2dda9, 0x807bd18431f2dda9, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x2b7542, 0x2b7506, 0x56309ed513a19669, 0x56309ed513a19669, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x0a3cd6, 0x0a3486, 0x83c471832e30af0c, 0x83c471832e30af0c, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x0c5fd2, 0x0c5782, 0xfdc10e8cdbd61f2c, 0xfdc10e8cdbd61f2c, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x0c0892, 0x0c0002, 0x62e90e088e992aab, 0x62e90e088e992aab, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x0e4e93, 0x0e4682, 0xc891c33944a92c73, 0xddffeb3f7ca96d7f, 0x156fa8277800653d, 0x0 }, /* #12 */
    { 0x342642, 0x342602, 0x7bf0c35ef3aff4b6, 0x7ff3e7dffffff5b6, 0x2d1326d77dfb01b2, 0x0 }, /* #13 */
    { 0x1a3f86, 0x1a3786, 0xbbb0fd1aff7ea767, 0xbff1ff9eff7fbf6f, 0x0f51aa86dc193b0e, 0x0 }, /* #14 */
    { 0x3d74d7, 0x3d7482, 0x33c92cfe1d53fd68, 0xb3fd6dffdfdffff8, 0xb27c41bbc6dcb398, 0x0 }, /* #15 */
    { 0x0f7c93, 0x0f7482, 0xfc3a3e4eb22c3bb8, 0xfcbbbf5ff7ec3fba, 0x1cb98915e7e807b2, 0x0 }, /* #16 */
    { 0x2811c6, 0x281182, 0xde1eed190d4a6bb1, 0xfe1fedbbbd4befb3, 0xa01d60bbb941ee02, 0x0 }, /* #17 */
    { 0x2673c2, 0x267382, 0x0f818ecb6acede83, 0xdf87dfeb6fdffea7, 0xdf07d1ea6d5d2c27, 0x0 }, /* #18 */
    { 0x3e2d07, 0x3e2582, 0xaa8e3a7cc9a9ecce, 0xae9f3f7cede9fece, 0xa6172f582ce8da08, 0x0 }, /* #19 */
    { 0x1034d2, 0x103486, 0xdfac83d9aae99f65, 0xdfffa7ffffffdfff, 0x97d724bfffbed4bb, 0x0 }, /* #20 */
    { 0x1a4f12, 0x1a4706, 0x1fdc80ffb34bd273, 0x5fdfc5fff7dbfb77, 0x49874517e7d12b47, 0x0 }, /* #21 */
    { 0x2b77c6, 0x2b7782, 0xef46a7057486ebb2, 0xfff7f705f7b7fffb, 0x51f5d100c33576eb, 0x0 }, /* #22 */
    { 0x387187, 0x387182, 0xb08fdce90f7602b6, 0xfdafddef3ff7c2fe, 0xcda1c5af3085c2fa, 0x0 }, /* #23 */
    { 0x312cd6, 0x312482, 0x9289bb6e275a963e, 0xba9ffb7fef5edf7f, 0xaa1e615dee045973, 0x0 }, /* #24 */
    { 0x2a3017, 0x2a3006, 0x23ba89ecb6b3ebbf, 0x3bfefbedbfffebff, 0x19c6fbad2ddca34e, 0x0 }, /* #25 */
    { 0x131b12, 0x131382, 0x97d6e734e923e2fb, 0x97f6e77df977eefb, 0x02a2604971766ec8, 0x0 }, /* #26 */
    { 0x1535d3, 0x153502, 0x2eb8d2d52631ee09, 0x6efbdeffe77ffeef, 0x465b8e3ae17f50e6, 0x0 }, /* #27 */
    { 0x070ec3, 0x070602, 0x4ebf3b867f853df1, 0x6eff3bb67ffd7dfd, 0x66e223302d7c60dd, 0x0 }, /* #28 */
    { 0x013c12, 0x013482, 0x1d62c1e27ecc40a7, 0xffffcdf3feefdaf7, 0xf29dcdb1fe2f9ad1, 0x0 }, /* #29 */
    { 0x2a7202, 0x2a7282, 0x60746c8efc527da6, 0xe577ffaffcd6ffb6, 0xa52793ad1896a6b2, 0x0 }, /* #30 */
    { 0x0c1e97, 0x0c1602, 0x45b241ff5cfece7d, 0x75bed3ff5ffede7f, 0x302ed3b64b1c9e6a, 0x0 }, /* #31 */
    { 0x173b12, 0x173306, 0x2c9494f1a0de8cfc, 0x3dbff6fbe2fe8ffc, 0x31ab665ac2ac0b74, 0x0 }, /* #32 */
    { 0x1c3a07, 0x1c3202, 0x7097fdf534c194d1, 0x71bffff57ed9dfd3, 0x21ab66616e595b02, 0x0 }, /* #33 */
    { 0x3f02d2, 0x3f0202, 0x0fd5e3cf6f93a075, 0x6fd7f7dfff93e3f7, 0x65c77690b590e3b7, 0x0 }, /* #34 */
    { 0x095052, 0x095002, 0x31dfc7aa5ce62167, 0x73dfdfbe7ce72f67, 0x725659be28812e24, 0x0 }, /* #35 */
    { 0x0f5146, 0x0f5182, 0x32070e96890786d6, 0xbf771e97adaf86df, 0xbd701e95aca8841d, 0x0 }, /* #36 */
    { 0x3b0043, 0x3b0086, 0x41e9e4d131aa2210, 0xebfbfefd73ef6ab2, 0xea5aba7d53c748a2, 0x0 }, /* #37 */
    { 0x282fc7, 0x282706, 0x70fd627ab59bce13, 0x75fdef7ff5fbdf17, 0x75508f05f1715105, 0x0 }, /* #38 */
    { 0x254d86, 0x254582, 0xcf2fb227aee54506, 0xdf6ff237beef6707, 0xdb4ae2103aaa6307, 0x0 }, /* #39 */
    { 0x2a4d53, 0x2a4582, 0xfb6ff5bcf158714d, 0xfbfff5fef15e7bdf, 0x9097b572b0166ad7, 0x0 }, /* #40 */
    { 0x2c0193, 0x2c0182, 0x8cce09af5b03125d, 0xceee0baf5f7b935d, 0x4e6c0aa3167b9340, 0x0 }, /* #41 */
    { 0x1c4582, 0x1c4582, 0x21a47b62665f8924, 0xa9b57bef765feb64, 0x899560cd320e6b60, 0x0 }, /* #42 */
    { 0x3b7dd6, 0x3b7582, 0x6fd37ef64cde3f76, 0xefd3fffe5dff3f76, 0xef809ffc19313e24, 0x0 }, /* #43 */
    { 0x314d12, 0x314506, 0x2e53f71a072babce, 0x3f7fff5ab7abefff, 0x1b3f895ab48be735, 0x0 }, /* #44 */
    { 0x306c07, 0x306486, 0x5392e96de1bbcdca, 0xd79ee9effdffedcf, 0xc78ca1eefd76e04f, 0x0 }, /* #45 */
    { 0x297d07, 0x297582, 0x2d1df59074b67157, 0xbfdff7f1fffefbf7, 0xb2def7618fcabae1, 0x0 }, /* #46 */
    { 0x204ec7, 0x204602, 0x7fc75ad1b79b7414, 0x7fef7fd1ffff7efd, 0x0ae975c06dfd2ae9, 0x0 }, /* #47 */
    { 0x081393, 0x081302, 0x6dadc911337a2604, 0x6dbffb13737aa715, 0x291eb302503a8515, 0x0 }, /* #48 */
    { 0x0a6492, 0x0a6486, 0xb192d10a008a2855, 0xbbbfd77b3e8aab7d, 0x8abf867b3e8a837c, 0x0 }, /* #49 */
    { 0x1c1cd7, 0x1c1482, 0xb09ecca29dc2b7de, 0xf4fffefaffc3b7df, 0xc477be7a7381b55d, 0x0 }, /* #50 */
    { 0x1068c6, 0x106002, 0x08982f3fef7027cd, 0x6dff3fffef73a7ef, 0x65e71afde643a4ef, 0x0 }, /* #51 */
    { 0x3d5f93, 0x3d5702, 0x6c4f83ad70d823bc, 0x6c4f87adf9defffd, 0x280485a9d99edefd, 0x0 }, /* #52 */
    { 0x094746, 0x094786, 0xe157fa282c5edecc, 0xfb5fff3e6e7effdd, 0x5b08071e6e2e6d5d, 0x0 }, /* #53 */
    { 0x1e7746, 0x1e7706, 0x1a6879a0f2dc72c4, 0x7aea7db2f7fe7ee4, 0x728a1412472a0c60, 0x0 }, /* #54 */
    { 0x273393, 0x273302, 0x33d28c1ad4e04746, 0x3bdfcf7bdcefc7e6, 0x2bdd43798c4fc1a0, 0x0 }, /* #55 */
    { 0x0c6616, 0x0c6686, 0x1bd21ce1a70cb7eb, 0xbfdafce9a71eb7ff, 0xb4cafc29241604be, 0x0 }, /* #56 */
    { 0x210692, 0x210686, 0x19e5103c9f7c4615, 0xdbfd913c9ffe4fb7, 0xc2b9812c95a24fa6, 0x0 }, /* #57 */
    { 0x251286, 0x251202, 0x10eeb728aa12cd47, 0x38fff76aef9bef67, 0x38f7724a6789a226, 0x0 }, /* #58 */
    { 0x163283, 0x163282, 0xcee97b9a49338f03, 0xcff97ffef937cf67, 0xc5f875ecf927cf65, 0x0 }, /* #59 */
    { 0x3c30c6, 0x3c3086, 0xb599bbd980bcfaa1, 0xff9bffdbefbffbf5, 0xfa1a57daefb711d4, 0x0 }, /* #60 */
    { 0x313c46, 0x313486, 0xee402c3ab32091da, 0xeefb7cbfbb38d3ff, 0x02bb70a51b18d2b7, 0x0 }, /* #61 */
    { 0x356487, 0x356486, 0xa6dc24ef5a689bd8, 0xa7de6feffaefdfdd, 0xa7926fe5ba87dcd5, 0x0 }, /* #62 */
    { 0x0f7a82, 0x0f7286, 0x8488adf072bb561d, 0xfecfadfefbff57dd, 0x7a47851ee9ee03d0, 0x0 }, /* #63 */
    { 0x394046, 0x394082, 0x1f3f4f751643bab7, 0xdf7f7ff5fef7bbbf, 0xcb5179e5f8f499ad, 0x0 }, /* #64 */
    { 0x285842, 0x285086, 0xa2855baced563495, 0xb6cfdbadef7ff4dd, 0x364ad109426fe0cd, 0x0 }, /* #65 */
    { 0x0d2e86, 0x0d2606, 0x3756e828461f100b, 0x7f5eeffa56bf7faf, 0x4c4eefd212af6fa7, 0x0 }, /* #66 */
    { 0x191b52, 0x191386, 0x453969e7d82999bb, 0xf5f9f9e7ff3ffbbb, 0xb4d0b8633f3f62b3, 0x0 }, /* #67 */
    { 0x0240d7, 0x024086, 0xf1a0e378e8d470e6, 0xf9a2e77fecff7aee, 0x180287078caf1a2e, 0x0 }, /* #68 */
    { 0x163896, 0x163086, 0x8c6d39acdbc53d18, 0xef6d3bbedbc73f59, 0xe74422ba13832f41, 0x0 }, /* #69 */
    { 0x082d82, 0x082586, 0xf146916c68cdc831, 0xf1c6d3fcfbcfcaf9, 0xd0c6d398d38b8ac9, 0x0 }, /* #70 */
    { 0x115897, 0x115002, 0x0808503138614533, 0x2acf7fbbf96b4737, 0x22c73faaf90b0624, 0x0 }, /* #71 */
    { 0x1b1482, 0x1b1482, 0x65f11612b5e989e5, 0xe5f51e7afffdf9f7, 0xa4751878ffd47037, 0x0 }, /* #72 */
    { 0x225617, 0x225686, 0x99a4638f4e0cb7ae, 0xfffd639f6fecb7af, 0x77dd601369e80685, 0x0 }, /* #73 */
    { 0x0d5206, 0x0d5286, 0xb9fc955996040c7c, 0xbbfcb5ffb756bdfc, 0x02d425e6b756b1f8, 0x0 }, /* #74 */
    { 0x0d2906, 0x0d2182, 0xed177e67e7b8e6a1, 0xff377e6fe7bfe6f1, 0xba374069018720f1, 0x0 }, /* #75 */
    { 0x0e49d3, 0x0e4182, 0xe31787b338acfe08, 0xff97b7bbfceeff0b, 0xde84323adc4ebf03, 0x0 }, /* #76 */
    { 0x3f5ed7, 0x3f5682, 0xd8cd76214027d769, 0xfdcd7e75ef67f76b, 0xb5c41854ef40644b, 0x0 }, /* #77 */
    { 0x1d2d53, 0x1d2586, 0x1c9dd0ad611a80fd, 0x9ffdf8bd7dfac6ff, 0x8374e8bc5ce0462a, 0x0 }, /* #78 */
    { 0x007f47, 0x007782, 0x4a9572f68fd2fe80, 0xcbbffffebfdefec8, 0x812ecf6c31ce1248, 0x0 }, /* #79 */
    { 0x2f7016, 0x2f7082, 0x894ed0f3ad623e38, 0xef6fd8f3bfeabef8, 0xe62508b0b788b4d8, 0x0 }, /* #80 */
    { 0x264697, 0x264682, 0x2021dc329e40d623, 0xf9abddbede66d6ef, 0xf98a59bc5e2680ed, 0x0 }, /* #81 */
    { 0x306452, 0x306482, 0xf2d6fd24a7560d31, 0xfffffd7dffdf0df1, 0xdffffd79d9df0de1, 0x0 }, /* #82 */
    { 0x0f7f02, 0x0f7786, 0xd09fcae8b016b5c4, 0xd3ffdeeabefff7fc, 0x13efdc029eebf2fc, 0x0 }, /* #83 */
    { 0x1366c2, 0x136686, 0x23974a965d6089e6, 0xeb975ff7fd659bff, 0xeb005f73f8051bdf, 0x0 }, /* #84 */
    { 0x053952, 0x053182, 0xa3952b3f1e99f31f, 0xb7f7ffff7effff1f, 0x35f6feec7876ad1d, 0x0 }, /* #85 */
    { 0x394787, 0x394782, 0xfea642d113a039a2, 0xfeb6f2f1f3ac3da2, 0x5a32b2a0f3ac0522, 0x0 }, /* #86 */
    { 0x136ad3, 0x136282, 0x16456a90a6e2d6fa, 0x96f5ffd6bfe6fefb, 0x84b0b7469d243ac9, 0x0 }, /* #87 */
    { 0x1e13d6, 0x1e1382, 0x5f33ce2a11c9f094, 0xffb7dfbe5bf9f3d6, 0xe7a65b965b30e346, 0x0 }, /* #88 */
    { 0x083d03, 0x083582, 0xb3770f0e30b2c9ad, 0xb3ff4f6fbcfae9ad, 0xa1d8476dbceaa80c, 0x0 }, /* #89 */
    { 0x057012, 0x057086, 0xa87e48a5cb57ef2b, 0xba7fe8e7df7fefeb, 0x125fe066de7a20ca, 0x0 }, /* #90 */
    { 0x181716, 0x181786, 0x364b527ef5b1195e, 0xff6fdb7efdfb3f5f, 0xfd6ccb4019eb3f11, 0x0 }, /* #91 */
    { 0x0b50c6, 0x0b5086, 0xf303b0fccea8aa60, 0xf773fdffeebefff6, 0xa673dd7fa816f7d6, 0x0 }, /* #92 */
    { 0x386f82, 0x386782, 0x8bdda806ab53d3ea, 0xcbffa8b6fbd7ffef, 0x423600b673c42ca5, 0x0 }, /* #93 */
    { 0x107e93, 0x107602, 0x30fa0e8fd7a173c2, 0x77fb7fefdffdf7c7, 0x673379e98f7da687, 0x0 }, /* #94 */
    { 0x136e06, 0x136686, 0x81e83934c9992bf7, 0x83fef97cfbb97bff, 0x0296e05c7bb85849, 0x0 }, /* #95 */
};
uint32_t const g_cTests_or_u64 = RT_ELEMENTS(g_aTests_or_u64);

BINU64_TEST_T const g_aTests_or_u64_locked[] =
{
    { 0x1b3292, 0x1b3246, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x161f96, 0x161746, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x3934c3, 0x393446, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x202d47, 0x202546, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x0a1947, 0x0a1146, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x1e2d87, 0x1e2546, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x0b5cc7, 0x0b5402, 0x5ab5f2a4ad6d966b, 0x5ab5f2a4ad6d966b, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x230293, 0x230206, 0x14d87d9a613c86a0, 0x14d87d9a613c86a0, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x010d57, 0x010586, 0xd222db0b7eb7ca50, 0xd222db0b7eb7ca50, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x2e79d3, 0x2e7102, 0x311940ecd0f83f52, 0x311940ecd0f83f52, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x1f65d6, 0x1f6586, 0xc195443b0b800987, 0xc195443b0b800987, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x3a1e12, 0x3a1602, 0x4d7247ad16337a07, 0x4d7247ad16337a07, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x170d93, 0x170506, 0x1ca4069bea89b830, 0x1eef569ffafff9bb, 0x0e4f529eb2f759bb, 0x0 }, /* #12 */
    { 0x086992, 0x086182, 0xa8a2fd76975f428a, 0xbdaefdfe975f6bcb, 0x3dae51ba02132b41, 0x0 }, /* #13 */
    { 0x1b35d7, 0x1b3586, 0x149ceb65126a8cfa, 0x95bfffff1fefcefa, 0x852f34fa1dcf42c2, 0x0 }, /* #14 */
    { 0x194cd7, 0x194482, 0xd15bc5c674e7ab14, 0xd9dbcde6fdffff7f, 0x99d10ce6a91b7f7f, 0x0 }, /* #15 */
    { 0x1b7743, 0x1b7782, 0xf3238cad8c928065, 0xf3739faddd93877f, 0x72539b255d01871b, 0x0 }, /* #16 */
    { 0x322547, 0x322582, 0x46497afc27fc76d4, 0xd7f9fbfe6fffffdc, 0xd7f8c1b64ce789cc, 0x0 }, /* #17 */
    { 0x316712, 0x316782, 0xf6ef25c4826d1dc8, 0xf7ff2defdeefdff8, 0xf19c2deb5eefd3b8, 0x0 }, /* #18 */
    { 0x0b2143, 0x0b2182, 0x145a4d452ed2b5b5, 0xf7da5f7dfffbb7bf, 0xf3981e3dd3bb879e, 0x0 }, /* #19 */
    { 0x287517, 0x287582, 0x7d25235a90ef1455, 0xfffd3f7ab4ef5f5d, 0xbfd83f60a4004b0c, 0x0 }, /* #20 */
    { 0x336b16, 0x336382, 0xe2792ca520b02d64, 0xe67ffeedb8fd3dec, 0xc40eda49b87d118c, 0x0 }, /* #21 */
    { 0x384c46, 0x384406, 0x1cf988d1bf9bb291, 0x7fff8afbffbff699, 0x6b16827bfa345499, 0x0 }, /* #22 */
    { 0x240843, 0x240086, 0x293ee94afb204f62, 0xbffee97aff34cfe2, 0xb7f0807086148780, 0x0 }, /* #23 */
    { 0x0b6003, 0x0b6002, 0x4a6c9e15cc27efdf, 0x4ffdff35fdbfffdf, 0x05f97324719c7253, 0x0 }, /* #24 */
    { 0x2e7782, 0x2e7786, 0xb828079fcd14db3e, 0xf9e96fffff55df7e, 0xc9c16e64bb419c7c, 0x0 }, /* #25 */
    { 0x102756, 0x102706, 0x4ae3c5846d53f7f9, 0x6eefe5e46f7bf7f9, 0x248e64642b68f4d9, 0x0 }, /* #26 */
    { 0x332206, 0x332286, 0xfa406a48feced7d1, 0xfb65fffefecfd7dd, 0x39259fb6d8c582cc, 0x0 }, /* #27 */
    { 0x0678d7, 0x067082, 0x8bcf799222fbdf01, 0xebef79debefbff89, 0x61e051cebe186f88, 0x0 }, /* #28 */
    { 0x2f5a03, 0x2f5206, 0x4e949cebe77ced4c, 0x7fdf9fffef7ffd7d, 0x774b17ff6a4b7d71, 0x0 }, /* #29 */
    { 0x172213, 0x172282, 0xf1578dbb17a60ca8, 0xfddfffbb17b7feae, 0x3d9dfe111317f286, 0x0 }, /* #30 */
    { 0x166307, 0x166382, 0xe57d2546f6893d76, 0xe57f67f7ffabfff7, 0x847f43f1bfa3e7a7, 0x0 }, /* #31 */
    { 0x186516, 0x186506, 0x25367cf85f9df273, 0x6dbefefb5fddfef3, 0x6998ce0b1b507c82, 0x0 }, /* #32 */
    { 0x1f4997, 0x1f4186, 0xdaf1cfe42fb32937, 0xfef9eff5efffe93f, 0x3cf9e511c54ce92e, 0x0 }, /* #33 */
    { 0x0b0957, 0x0b0182, 0xb3883b6fb2b7e185, 0xf7ea7f6ffaf7f585, 0xe5ea462a4870f584, 0x0 }, /* #34 */
    { 0x017783, 0x017786, 0xce5ffd41af94b8cd, 0xfefffffdff96fbdd, 0xf2abd2bcf2065b5c, 0x0 }, /* #35 */
    { 0x137c13, 0x137482, 0x2d52ca504ce9ea95, 0xfddaffdccee9ffd5, 0xf0d83fccce0855c1, 0x0 }, /* #36 */
    { 0x361297, 0x361286, 0xbd7e4f5b7ebb20b2, 0xbf7fdfdb7fbb35f3, 0x3b4b95c333aa3553, 0x0 }, /* #37 */
    { 0x3b0452, 0x3b0486, 0xfaa32f5193f5718f, 0xffefaf5597fffbaf, 0x2d4fac15054bea2e, 0x0 }, /* #38 */
    { 0x2f6782, 0x2f6706, 0x39ee5ca790b64bbd, 0x7bef5cefb1b65bff, 0x53e9084a31801a5a, 0x0 }, /* #39 */
    { 0x2839c2, 0x283186, 0x12cb28c4c8fd9661, 0xdadf6aecfaffb7eb, 0xd81d4ae8324aa3aa, 0x0 }, /* #40 */
    { 0x104bc7, 0x104386, 0xeff8ca9433c7a03a, 0xeffaca97b7cfb73f, 0xc4fa8007958c171d, 0x0 }, /* #41 */
    { 0x1f0696, 0x1f0686, 0xdf141e17b1d5adc4, 0xfff6bef7bdd5bdf6, 0xfff2b8f2bd843532, 0x0 }, /* #42 */
    { 0x103a43, 0x103202, 0x59b561123b753998, 0x5db5ebfbbbff7bbf, 0x44a0abeb82ef7ab7, 0x0 }, /* #43 */
    { 0x3178d2, 0x317082, 0xac6b59d44cb52e85, 0xee6b7bdcfffdaee5, 0x66622298b7fc8065, 0x0 }, /* #44 */
    { 0x191053, 0x191082, 0x5f73a133bfdd9b4f, 0xff7fa77fffdfbfdf, 0xf63c865f5396bddb, 0x0 }, /* #45 */
    { 0x301042, 0x301082, 0x5b500035c3e5dd8a, 0xfb55f875dbffffcb, 0xe115f850983e664b, 0x0 }, /* #46 */
    { 0x1b0783, 0x1b0786, 0xd8e1eed18010329b, 0xf8fbeef991fcb79f, 0x28fa6ea811fca50d, 0x0 }, /* #47 */
    { 0x2c7a87, 0x2c7202, 0x12fe661867afe1ca, 0x1eff6e7867aff1fb, 0x0cf16c60410d90f1, 0x0 }, /* #48 */
    { 0x084ad7, 0x084202, 0x3faacb1562b10674, 0x3feadf37ebbb1e76, 0x2f629f32eb3a1c46, 0x0 }, /* #49 */
    { 0x3a7807, 0x3a7082, 0xd0a76df11ab4e720, 0xd4e77df11fbce725, 0x046635c115b8c005, 0x0 }, /* #50 */
    { 0x340716, 0x340786, 0xade08714b84c5511, 0xbdebc7b7beef7571, 0x30eb47a326eb6071, 0x0 }, /* #51 */
    { 0x2e4d56, 0x2e4506, 0x0d699c65d7890a8e, 0x7d6bdd6ddfefbfee, 0x744ac54889efbd62, 0x0 }, /* #52 */
    { 0x224ad2, 0x224282, 0xe190486d0effc43f, 0xefdbfa7f2efff4bf, 0x6f5bf27a2011349e, 0x0 }, /* #53 */
    { 0x0d5783, 0x0d5702, 0x12b9f7ea7b84dabf, 0x32bdf7ff7b9dfbbf, 0x223c6757289df393, 0x0 }, /* #54 */
    { 0x3d06c2, 0x3d0686, 0x947a14af94cb53c3, 0xbfff1ebfd4fbdbff, 0xbbef1e18c07099be, 0x0 }, /* #55 */
    { 0x020487, 0x020486, 0xb157889d2b4a0445, 0xbb7fe9df2fce1c47, 0x1b2be9c3078e1807, 0x0 }, /* #56 */
    { 0x1a6ad7, 0x1a6286, 0xd3e5177d62d772d2, 0xfff73f7f7bd7f6d7, 0x3e1639273b4584c7, 0x0 }, /* #57 */
    { 0x3b7083, 0x3b7082, 0xeede1d002375ffeb, 0xeffe5ffb27f5fffb, 0x856053fb07f4d3f3, 0x0 }, /* #58 */
    { 0x3e6ac7, 0x3e6282, 0x8bb7d08275765c5f, 0xfbbff48277fefd7f, 0x7b3ca40247b8b135, 0x0 }, /* #59 */
    { 0x1f3bd6, 0x1f3382, 0xc2e2f38a2188d63e, 0xfaf7fbee3d98febf, 0x7a1568e61d18be83, 0x0 }, /* #60 */
    { 0x207d12, 0x207506, 0x3d586644dbede103, 0x7d5f67e7fbfff5db, 0x6c1747e73372b5d9, 0x0 }, /* #61 */
    { 0x3f6097, 0x3f6082, 0xb80149b7af9f2c9f, 0xfa3fdfffbf9f7cbf, 0xf23f9fcd3e1f5035, 0x0 }, /* #62 */
    { 0x0a03d2, 0x0a0386, 0x25f386adc64017e0, 0xbdf7c6afeff957e7, 0x9db6c20f2bb94467, 0x0 }, /* #63 */
    { 0x2a5dd2, 0x2a5582, 0xa23c6b745e18e37c, 0xa7fffbf67fbfe77f, 0x85d7dab677b76647, 0x0 }, /* #64 */
    { 0x3c3d42, 0x3c3582, 0x6ae735c6fd34bbba, 0xfbf777c7fdf7fbbf, 0xd1f366c748d3518d, 0x0 }, /* #65 */
    { 0x0444d3, 0x044482, 0xf9c1e84dabed1f2e, 0xffd5f95dabffbfbf, 0xa6949118a01baf9f, 0x0 }, /* #66 */
    { 0x247283, 0x247206, 0x1d16989bb11fb58b, 0x1f96bf9fbfdfbfbb, 0x0a802f9d3ec62a3b, 0x0 }, /* #67 */
    { 0x3558c2, 0x355002, 0x1fd0ccd3ad8e16c5, 0x3ffbffffbfffb7cd, 0x3a7b7f3d32f1a5cc, 0x0 }, /* #68 */
    { 0x2255c7, 0x225506, 0x3dcc24fac5480ea4, 0x3fccedffdfef4ef6, 0x2bc8e9cfdeef42d6, 0x0 }, /* #69 */
    { 0x154282, 0x154286, 0x2d7bf89a1133bf8f, 0xed7bf99f933fffcf, 0xec32f107933cfa4b, 0x0 }, /* #70 */
    { 0x220042, 0x220082, 0xdad8d2b567479288, 0xfafcd2bd7f57f7e9, 0xaaf4c09c5e5765e1, 0x0 }, /* #71 */
    { 0x1f3a87, 0x1f3282, 0xdd0bb0d398df2d6e, 0xdf4fb2f79ddfff7f, 0x83469265051bdb1b, 0x0 }, /* #72 */
    { 0x3e7402, 0x3e7482, 0xd85c58461d14b058, 0xdaff7f7e9d95f07a, 0xd2e33f3c8991406a, 0x0 }, /* #73 */
    { 0x1a4b87, 0x1a4382, 0x2cd8b8e2c11d3185, 0xacd9b8f6d3ddffcd, 0xa00180f4d2d8efcc, 0x0 }, /* #74 */
    { 0x1b06c2, 0x1b0602, 0x50d729c9e6e8dfec, 0x57ffabf9f7fcdfef, 0x1769a2f013b44323, 0x0 }, /* #75 */
    { 0x0525c3, 0x052586, 0xb3e3bcdb76c9d572, 0xb3fbfcdb76ebdf77, 0x823be84a202b5e15, 0x0 }, /* #76 */
    { 0x016b06, 0x016386, 0x3d42975ea6e68d06, 0xbfd7d75effffcd1e, 0xa3d75044fd1dc018, 0x0 }, /* #77 */
    { 0x120f53, 0x120786, 0x541bafe5d6f3c903, 0xfd1faff5def7ddd7, 0xb9048b151c67d5d5, 0x0 }, /* #78 */
    { 0x100b53, 0x100386, 0xc4a775bc523834ca, 0xe5e775bf53fa36ff, 0xa5c5548b03da22b7, 0x0 }, /* #79 */
    { 0x132556, 0x132586, 0x201b7ac2a84fef23, 0xe3dbfefaef5fff27, 0xe3c3ecbacf129307, 0x0 }, /* #80 */
    { 0x1e2e83, 0x1e2602, 0x39159ddef8fe7129, 0x3bb79fdff9fff3ef, 0x3bb31b8901f3c2c6, 0x0 }, /* #81 */
    { 0x224907, 0x224186, 0x3d949f8f2a6e62c0, 0xbfbfffaf7a6e62c6, 0xab2b7b2358066046, 0x0 }, /* #82 */
    { 0x2b5802, 0x2b5086, 0xe356bd960e56aa5f, 0xe357bddeded6fbff, 0x224111dcde94d1f3, 0x0 }, /* #83 */
    { 0x3e0487, 0x3e0482, 0x9d4ddc5209a4e9f0, 0xbfdddf5b8db6e9f8, 0x23d0035b8d16c1b8, 0x0 }, /* #84 */
    { 0x232707, 0x232782, 0xd0c087d70745949d, 0xd9c8cfd7aff797df, 0xc988c947a8f6974f, 0x0 }, /* #85 */
    { 0x3828d3, 0x382082, 0x9020022981f1e111, 0xfc248fb995f1f9b9, 0x7c248fb994a058b9, 0x0 }, /* #86 */
    { 0x165946, 0x165106, 0x78e09bcceb7cf588, 0x7efb9ffcef7df7f9, 0x669b0f78242db7f1, 0x0 }, /* #87 */
    { 0x091f42, 0x091782, 0xfa900bc77d51bc7d, 0xfeb15bcf7df3ff7f, 0xb4a1528e11e3db47, 0x0 }, /* #88 */
    { 0x3d0a43, 0x3d0282, 0xd31425ad7ae9fce6, 0xfb96b5fffeebfdfe, 0x799290f29402f59a, 0x0 }, /* #89 */
    { 0x3e2a83, 0x3e2282, 0x532a9ec3ca7b32be, 0xd72e9fcbeb7ff7fe, 0x950e910a2164f5c0, 0x0 }, /* #90 */
    { 0x0b0216, 0x0b0282, 0xb4f349e424196782, 0xbdfbcfe4247bef9b, 0xad39c6e02473ab19, 0x0 }, /* #91 */
    { 0x3f6dd6, 0x3f6582, 0xf3a3b89454b0e76f, 0xfbf7b8fcd5b6ffef, 0xa8758868d1a6bbe2, 0x0 }, /* #92 */
    { 0x295153, 0x295102, 0x0225d93b1a406488, 0x5225fd3b3edff5fe, 0x52003c333e9f917e, 0x0 }, /* #93 */
    { 0x2e6f82, 0x2e6786, 0x926fe2eb0322cb5d, 0x97effaefeb7edb7d, 0x97ed186eeb5ed078, 0x0 }, /* #94 */
    { 0x240453, 0x240402, 0x1ae9159f00da0ba4, 0x5effff9f52fadffd, 0x4eb6fa1d5238d779, 0x0 }, /* #95 */
};
uint32_t const g_cTests_or_u64_locked = RT_ELEMENTS(g_aTests_or_u64_locked);

BINU64_TEST_T const g_aTests_xor_u64[] =
{
    { 0x243f56, 0x243746, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x376bc6, 0x376346, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x020393, 0x020346, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x3e5d43, 0x3e5546, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x330817, 0x330046, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x385593, 0x385546, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x0f0ed6, 0x0f0602, 0x076d7e1457d146d3, 0x076d7e1457d146d3, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x0959c7, 0x095102, 0x33ca45eb8d5f9367, 0x33ca45eb8d5f9367, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x266896, 0x266006, 0x019391dc7b7eeb72, 0x019391dc7b7eeb72, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x0b2ac2, 0x0b2286, 0xa6762ef8bdcb7b4e, 0xa6762ef8bdcb7b4e, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x3210d3, 0x321082, 0xc1844f9586985e9d, 0xc1844f9586985e9d, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x1b7683, 0x1b7682, 0xcd3e82b0b902aff8, 0xcd3e82b0b902aff8, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x335296, 0x335206, 0xffd26eba8068a2b3, 0x78e1222fc3ab1847, 0x87334c9543c3baf4, 0x0 }, /* #12 */
    { 0x304e92, 0x304606, 0xabdce3f7897f1b74, 0x4c147f7f51c97e82, 0xe7c89c88d8b665f6, 0x0 }, /* #13 */
    { 0x020f13, 0x020702, 0xd2e96f5b6ea1ddfd, 0x50a8af28ab7aeab6, 0x8241c073c5db374b, 0x0 }, /* #14 */
    { 0x396f82, 0x396702, 0xbb9c681d88849a55, 0x2dd37e49a98c905b, 0x964f165421080a0e, 0x0 }, /* #15 */
    { 0x372b06, 0x372382, 0xd0999c700720315e, 0xcb01d9d44cb488d0, 0x1b9845a44b94b98e, 0x0 }, /* #16 */
    { 0x373ec7, 0x373682, 0xdc54211a95de5871, 0x8994124620d9bf1c, 0x55c0335cb507e76d, 0x0 }, /* #17 */
    { 0x126446, 0x126482, 0x273a19dfd2dafb25, 0xec686f716c055119, 0xcb5276aebedfaa3c, 0x0 }, /* #18 */
    { 0x286903, 0x286186, 0xa004c10252ddae24, 0xff855aad7452f38e, 0x5f819baf268f5daa, 0x0 }, /* #19 */
    { 0x290296, 0x290202, 0xa2cf20a84f416aa8, 0x76a29cc298313b23, 0xd46dbc6ad770518b, 0x0 }, /* #20 */
    { 0x3b61c2, 0x3b6182, 0x4bc77851adedf40e, 0xb12a9365e4e486e6, 0xfaedeb34490972e8, 0x0 }, /* #21 */
    { 0x097a96, 0x097202, 0xde9a11308809377e, 0x5739e74b831d62cb, 0x89a3f67b0b1455b5, 0x0 }, /* #22 */
    { 0x1b3dd6, 0x1b3506, 0x1fbe8bbbf9b60ee7, 0x6e63b2a23097efe1, 0x71dd3919c921e106, 0x0 }, /* #23 */
    { 0x2a24c3, 0x2a2482, 0xa4cccb72be3a4bcd, 0xfdf96437b1ff7b49, 0x5935af450fc53084, 0x0 }, /* #24 */
    { 0x0c44c7, 0x0c4406, 0xdc2097168f391dad, 0x4d0a2d0cbe3eda39, 0x912aba1a3107c794, 0x0 }, /* #25 */
    { 0x1d1712, 0x1d1786, 0x0824bc0525a43485, 0xe9eeea164d1b903c, 0xe1ca561368bfa4b9, 0x0 }, /* #26 */
    { 0x0b2a16, 0x0b2202, 0x1578efa5f39c1146, 0x5b0eebdde312d7f4, 0x4e760478108ec6b2, 0x0 }, /* #27 */
    { 0x3b33d2, 0x3b3302, 0xb8b8c2c29ef6fbae, 0x6f9d158d29ad58dc, 0xd725d74fb75ba372, 0x0 }, /* #28 */
    { 0x2a2553, 0x2a2582, 0xeacfa7ce75dbe352, 0xf98573c4912396c7, 0x134ad40ae4f87595, 0x0 }, /* #29 */
    { 0x300517, 0x300502, 0x16f9953c40c4eed8, 0x0ce567cded521368, 0x1a1cf2f1ad96fdb0, 0x0 }, /* #30 */
    { 0x115846, 0x115082, 0x68b88a528670fc06, 0xff5c6eca868fa991, 0x97e4e49800ff5597, 0x0 }, /* #31 */
    { 0x153917, 0x153102, 0x556cd3aaaf3084d6, 0x4c687d552cf5da29, 0x1904aeff83c55eff, 0x0 }, /* #32 */
    { 0x3d2dc2, 0x3d2586, 0xb071c0cd67b3ab53, 0x8a275e863004e7b1, 0x3a569e4b57b74ce2, 0x0 }, /* #33 */
    { 0x046113, 0x046102, 0x222db83cc7372725, 0x63820ab9f052fa19, 0x41afb2853765dd3c, 0x0 }, /* #34 */
    { 0x110b92, 0x110306, 0xdf29c832c45d01fd, 0x191c3e463745ef4d, 0xc635f674f318eeb0, 0x0 }, /* #35 */
    { 0x340287, 0x340206, 0x5cc52e39a329d5b4, 0x798b2c0a3355a203, 0x254e0233907c77b7, 0x0 }, /* #36 */
    { 0x1e4fd7, 0x1e4706, 0x2cd7a8086f0cb159, 0x6e35842711385d17, 0x42e22c2f7e34ec4e, 0x0 }, /* #37 */
    { 0x090853, 0x090006, 0x2a73c29906e8619f, 0x0895d6b406d80682, 0x22e6142d0030671d, 0x0 }, /* #38 */
    { 0x081143, 0x081186, 0x323c097d9b8991f1, 0xbb5165dab996d766, 0x896d6ca7221f4697, 0x0 }, /* #39 */
    { 0x021743, 0x021706, 0x46f0bc3d12189ceb, 0x277eacc1c714bcd1, 0x618e10fcd50c203a, 0x0 }, /* #40 */
    { 0x086302, 0x086382, 0x5c4c7a7c738f5127, 0xe3ec5b8c5468da29, 0xbfa021f027e78b0e, 0x0 }, /* #41 */
    { 0x162bd3, 0x162386, 0x1a65e0f45591f1c5, 0x8c2508c7adafbcf6, 0x9640e833f83e4d33, 0x0 }, /* #42 */
    { 0x092742, 0x092782, 0x70812b43e8828181, 0xc8b6e231834c172f, 0xb837c9726bce96ae, 0x0 }, /* #43 */
    { 0x1a7717, 0x1a7702, 0xd8b4055ab9cbc5b7, 0x376d9e8d1a9de615, 0xefd99bd7a35623a2, 0x0 }, /* #44 */
    { 0x327bc7, 0x327382, 0x723f9bcbb9c827bc, 0xab77def6b02128f2, 0xd948453d09e90f4e, 0x0 }, /* #45 */
    { 0x190306, 0x190382, 0xf81ef4f4f363eb8a, 0x8ef5c5144d73ca4c, 0x76eb31e0be1021c6, 0x0 }, /* #46 */
    { 0x192107, 0x192182, 0xba6f7d27f4045490, 0xf9970cf90139e9d3, 0x43f871def53dbd43, 0x0 }, /* #47 */
    { 0x1f2fc2, 0x1f2782, 0xd83b281b4ea85187, 0xecb295cc51b7fac8, 0x3489bdd71f1fab4f, 0x0 }, /* #48 */
    { 0x2b31c2, 0x2b3186, 0xd3b4c75242a03a2d, 0xd4753c63920b3ce4, 0x07c1fb31d0ab06c9, 0x0 }, /* #49 */
    { 0x1a5553, 0x1a5586, 0xa1b997f8d9f81291, 0x837e2d9849b84b8b, 0x22c7ba609040591a, 0x0 }, /* #50 */
    { 0x1a05c7, 0x1a0502, 0x933afcdecab86f11, 0x452cb20e35fc86f1, 0xd6164ed0ff44e9e0, 0x0 }, /* #51 */
    { 0x0a3c82, 0x0a3402, 0x0f9b64396a2fd90c, 0x5baee3624e5fb42c, 0x5435875b24706d20, 0x0 }, /* #52 */
    { 0x033d17, 0x033502, 0xcdba25d7d6178eee, 0x7c6599b7c7ba9d68, 0xb1dfbc6011ad1386, 0x0 }, /* #53 */
    { 0x002083, 0x002082, 0x82b5512b4ab59e59, 0xd65bbcf0b8970567, 0x54eeeddbf2229b3e, 0x0 }, /* #54 */
    { 0x1d70d7, 0x1d7006, 0xf6f6e1c1c27b5150, 0x6534fb2273bdb369, 0x93c21ae3b1c6e239, 0x0 }, /* #55 */
    { 0x0d1303, 0x0d1386, 0xbc663ff76cc9d890, 0x8e7bbbfbda127895, 0x321d840cb6dba005, 0x0 }, /* #56 */
    { 0x2850d6, 0x285002, 0xb87a23776ad52328, 0x56646d2b070c7fba, 0xee1e4e5c6dd95c92, 0x0 }, /* #57 */
    { 0x292193, 0x292102, 0x3df4589a5e01d450, 0x5f0a00b2b0c9c776, 0x62fe5828eec81326, 0x0 }, /* #58 */
    { 0x212946, 0x212106, 0xa12f8838f81e55bd, 0x581b2a29a37b886a, 0xf934a2115b65ddd7, 0x0 }, /* #59 */
    { 0x075592, 0x075506, 0xff3963e2a8f0cd1e, 0x377370aa3b2aac36, 0xc84a134893da6128, 0x0 }, /* #60 */
    { 0x2923d3, 0x292306, 0x0f714d9b26bb7096, 0x4c9f4d3be2b5879c, 0x43ee00a0c40ef70a, 0x0 }, /* #61 */
    { 0x050cc2, 0x050406, 0xdd3a7a9c0fb294a0, 0x0f61f343bab909d7, 0xd25b89dfb50b9d77, 0x0 }, /* #62 */
    { 0x1459d2, 0x145102, 0x362168a5f7c86e0d, 0x50383afcd7edbcc7, 0x661952592025d2ca, 0x0 }, /* #63 */
    { 0x382117, 0x382182, 0x055b4f5b769350ec, 0x80b7692365e4c529, 0x85ec2678137795c5, 0x0 }, /* #64 */
    { 0x3a06d6, 0x3a0682, 0xda3efb38599a51b6, 0x9bf6bb2381f45b5b, 0x41c8401bd86e0aed, 0x0 }, /* #65 */
    { 0x0f3a92, 0x0f3206, 0x484c27f3b0852345, 0x5181b78cc42a2c4e, 0x19cd907f74af0f0b, 0x0 }, /* #66 */
    { 0x367513, 0x367506, 0x80bb979542fdfe65, 0x0d53cc51d62d53d8, 0x8de85bc494d0adbd, 0x0 }, /* #67 */
    { 0x123892, 0x123086, 0xf98b65026ce928eb, 0x8030ee8bfa14332e, 0x79bb8b8996fd1bc5, 0x0 }, /* #68 */
    { 0x2a2617, 0x2a2686, 0x3bc51f0e0bbbd529, 0xad6fe923781f120f, 0x96aaf62d73a4c726, 0x0 }, /* #69 */
    { 0x310613, 0x310682, 0x9722a7760d57fc87, 0xfb6b20f904cd2340, 0x6c49878f099adfc7, 0x0 }, /* #70 */
    { 0x263643, 0x263606, 0x1c21a7dc26d153bc, 0x6ff937f515961553, 0x73d89029334746ef, 0x0 }, /* #71 */
    { 0x140992, 0x140102, 0xc1db53e701510c24, 0x3fbb8b2f45876aad, 0xfe60d8c844d66689, 0x0 }, /* #72 */
    { 0x2e6cc3, 0x2e6402, 0x79bd70f2f69fb86d, 0x4f509db199d6acfe, 0x36eded436f491493, 0x0 }, /* #73 */
    { 0x104f43, 0x104706, 0x3b3dcf09bd5c5d99, 0x0a5d823643f649db, 0x31604d3ffeaa1442, 0x0 }, /* #74 */
    { 0x3e3cc3, 0x3e3402, 0x8af2c9303a362c0d, 0x05bef61521e44161, 0x8f4c3f251bd26d6c, 0x0 }, /* #75 */
    { 0x175b92, 0x175382, 0x19e7149a3466ba10, 0xbefd4cf8e380e7ce, 0xa71a5862d7e65dde, 0x0 }, /* #76 */
    { 0x027d12, 0x027502, 0x2bddf68bcadc0f1f, 0x662279da762cded3, 0x4dff8f51bcf0d1cc, 0x0 }, /* #77 */
    { 0x1b2792, 0x1b2782, 0xbda29ba58053a02d, 0x889b1b32608590ce, 0x35398097e0d630e3, 0x0 }, /* #78 */
    { 0x3c4656, 0x3c4602, 0x47d99717280eab57, 0x08a6faaf43c7973b, 0x4f7f6db86bc93c6c, 0x0 }, /* #79 */
    { 0x1f38c3, 0x1f3006, 0x0dcc733da9087f20, 0x2a7934e3a9e6d922, 0x27b547de00eea602, 0x0 }, /* #80 */
    { 0x0b0e86, 0x0b0606, 0x3638245fe8e51a0c, 0x34a77a5511a5cee1, 0x029f5e0af940d4ed, 0x0 }, /* #81 */
    { 0x374987, 0x374102, 0xf470c3611c863f58, 0x0c47f17bd67a39fe, 0xf837321acafc06a6, 0x0 }, /* #82 */
    { 0x095d03, 0x095586, 0x8c30718259c391d2, 0xce9b319315dcbd71, 0x42ab40114c1f2ca3, 0x0 }, /* #83 */
    { 0x1c2797, 0x1c2706, 0x67d79e4abf0a6bc6, 0x1dee951cf8b7b117, 0x7a390b5647bddad1, 0x0 }, /* #84 */
    { 0x332c06, 0x332406, 0x93d7fff804e10a46, 0x5eae8592daea2fb2, 0xcd797a6ade0b25f4, 0x0 }, /* #85 */
    { 0x060c06, 0x060402, 0x2c2ba73d50648f1e, 0x4e07536447e78554, 0x622cf45917830a4a, 0x0 }, /* #86 */
    { 0x374642, 0x374686, 0xf41f2d15098f1ae4, 0x884ff89b855057ff, 0x7c50d58e8cdf4d1b, 0x0 }, /* #87 */
    { 0x247003, 0x247086, 0xaecb17d607434d85, 0xf40ccf2179f6bfcc, 0x5ac7d8f77eb5f249, 0x0 }, /* #88 */
    { 0x3b3792, 0x3b3782, 0x4d124dcc1e169574, 0x9a610315f2969cb3, 0xd7734ed9ec8009c7, 0x0 }, /* #89 */
    { 0x160bd2, 0x160306, 0x8e5b0c76502001e6, 0x115870a7c974c40a, 0x9f037cd19954c5ec, 0x0 }, /* #90 */
    { 0x2e7d52, 0x2e7506, 0x05d1fbf1a6f2a3ad, 0x13ea80efdf3bb2dd, 0x163b7b1e79c91170, 0x0 }, /* #91 */
    { 0x041317, 0x041302, 0xe70867186ad4ad60, 0x56498f70c929c816, 0xb141e868a3fd6576, 0x0 }, /* #92 */
    { 0x287fd7, 0x287706, 0x855d32595855666a, 0x3abcccab98b4fee8, 0xbfe1fef2c0e19882, 0x0 }, /* #93 */
    { 0x3c5e03, 0x3c5602, 0x6a61774753a7d804, 0x2dabde98ac1be592, 0x47caa9dfffbc3d96, 0x0 }, /* #94 */
    { 0x3916d2, 0x391686, 0xe4143bbb4c9eb7db, 0x97232315fc60ea12, 0x733718aeb0fe5dc9, 0x0 }, /* #95 */
};
uint32_t const g_cTests_xor_u64 = RT_ELEMENTS(g_aTests_xor_u64);

BINU64_TEST_T const g_aTests_xor_u64_locked[] =
{
    { 0x021182, 0x021146, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x210e13, 0x210646, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x1e5e56, 0x1e5646, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x1e05c2, 0x1e0546, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x2b7916, 0x2b7146, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x0f1f46, 0x0f1746, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x1b0297, 0x1b0282, 0x8dc0177f531385fe, 0x8dc0177f531385fe, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x3c3cc2, 0x3c3486, 0xed4235ddbf0dc769, 0xed4235ddbf0dc769, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x1f2856, 0x1f2006, 0x4ab0a0eb61eaba50, 0x4ab0a0eb61eaba50, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x3a4193, 0x3a4102, 0x2c16ce24436ab567, 0x2c16ce24436ab567, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x283483, 0x283406, 0x1cb7940208b7bc56, 0x1cb7940208b7bc56, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x171817, 0x171002, 0x667a94cc0ad81aea, 0x667a94cc0ad81aea, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x230412, 0x230402, 0xb00e9ad78209414f, 0x1d88c4965bdc2f23, 0xad865e41d9d56e6c, 0x0 }, /* #12 */
    { 0x0149c3, 0x014182, 0xe920d35261936e17, 0xcefb891ed1a58da8, 0x27db5a4cb036e3bf, 0x0 }, /* #13 */
    { 0x0c6a47, 0x0c6206, 0x785e228347343607, 0x6e6b0f429c968711, 0x16352dc1dba2b116, 0x0 }, /* #14 */
    { 0x1e3a16, 0x1e3286, 0xf77176bf18cc42c8, 0xe6fbdf1c77aff584, 0x118aa9a36f63b74c, 0x0 }, /* #15 */
    { 0x062606, 0x062602, 0xb2210154fb21f8bc, 0x5eeceae5f7989386, 0xeccdebb10cb96b3a, 0x0 }, /* #16 */
    { 0x014a87, 0x014202, 0x083ba526226a88a6, 0x0b9f3161e0ba97fe, 0x03a49447c2d01f58, 0x0 }, /* #17 */
    { 0x1122d7, 0x112206, 0x04da3bed024883c7, 0x7bd2e4fde13f6282, 0x7f08df10e377e145, 0x0 }, /* #18 */
    { 0x3634d6, 0x363482, 0x37d6a5c8478997c3, 0xbc9c646b34ee4c83, 0x8b4ac1a37367db40, 0x0 }, /* #19 */
    { 0x130d07, 0x130502, 0xe97897958807eb0c, 0x664678ed08359394, 0x8f3eef7880327898, 0x0 }, /* #20 */
    { 0x265a56, 0x265286, 0x8878eb3eff35b709, 0xa1fc063eb2d6478d, 0x2984ed004de3f084, 0x0 }, /* #21 */
    { 0x167b87, 0x167386, 0x0987d425586ae0b0, 0xc7e209bc1a6786c6, 0xce65dd99420d6676, 0x0 }, /* #22 */
    { 0x153553, 0x153586, 0x2365cb2b32e56efb, 0xb867566fa6571ce1, 0x9b029d4494b2721a, 0x0 }, /* #23 */
    { 0x1b4543, 0x1b4506, 0x190d32e7427fc3b8, 0x686d2a636bb6b14d, 0x7160188429c972f5, 0x0 }, /* #24 */
    { 0x2b0c97, 0x2b0406, 0xc77373d52120aa97, 0x7090ed1b0fc0f4b7, 0xb7e39ece2ee05e20, 0x0 }, /* #25 */
    { 0x020892, 0x020006, 0xb0999e55e145660d, 0x61ad5b52a07343ff, 0xd134c507413625f2, 0x0 }, /* #26 */
    { 0x166ec7, 0x166602, 0x40f64303865db310, 0x74d18e9ec684eea1, 0x3427cd9d40d95db1, 0x0 }, /* #27 */
    { 0x217f92, 0x217702, 0x40d485c0265b4309, 0x40bc4ad6ecf46c02, 0x0068cf16caaf2f0b, 0x0 }, /* #28 */
    { 0x020216, 0x020286, 0xdac1d7c06837010c, 0xe815275d8888bbf0, 0x32d4f09de0bfbafc, 0x0 }, /* #29 */
    { 0x096942, 0x096186, 0x41883befd6869ba5, 0x9d05c9095b2fcb1b, 0xdc8df2e68da950be, 0x0 }, /* #30 */
    { 0x084682, 0x084686, 0x99b82565e01fef3f, 0xe19c9826e25893e7, 0x7824bd4302477cd8, 0x0 }, /* #31 */
    { 0x2f4353, 0x2f4306, 0xd497f17032506fd3, 0x143cc66520d3fc66, 0xc0ab3715128393b5, 0x0 }, /* #32 */
    { 0x2f7852, 0x2f7002, 0x7679b2f8ea34d6ae, 0x3d5785775f0ba0b6, 0x4b2e378fb53f7618, 0x0 }, /* #33 */
    { 0x3062c2, 0x306206, 0x790c3a04db96eba6, 0x6b98a922f08f2f6a, 0x129493262b19c4cc, 0x0 }, /* #34 */
    { 0x1357d7, 0x135782, 0x596224eb23c2469a, 0xd4f66ee1047b318c, 0x8d944a0a27b97716, 0x0 }, /* #35 */
    { 0x3b2357, 0x3b2382, 0x6ed30ac0cd702355, 0xdc39e96ecdded702, 0xb2eae3ae00aef457, 0x0 }, /* #36 */
    { 0x382013, 0x382082, 0x88048222048df976, 0xd55f7c91d03b38f1, 0x5d5bfeb3d4b6c187, 0x0 }, /* #37 */
    { 0x1d2f56, 0x1d2706, 0xb1eaeb737289cb7b, 0x5ac61dbbd12cd255, 0xeb2cf6c8a3a5192e, 0x0 }, /* #38 */
    { 0x2a3d06, 0x2a3502, 0x328efe2beeac103a, 0x1a3a0da0506867a1, 0x28b4f38bbec4779b, 0x0 }, /* #39 */
    { 0x2f2a96, 0x2f2286, 0x412ce8e68b217edf, 0xd5c355367674205a, 0x94efbdd0fd555e85, 0x0 }, /* #40 */
    { 0x074917, 0x074106, 0xb5818117c20662c1, 0x5380405e51786bf3, 0xe601c149937e0932, 0x0 }, /* #41 */
    { 0x274453, 0x274482, 0x2ec9e72251a4ca6c, 0xdb7f8205becd19dc, 0xf5b66527ef69d3b0, 0x0 }, /* #42 */
    { 0x0b1b93, 0x0b1302, 0x5bb8cfc5e64fe95c, 0x51d5b1a0d69a996b, 0x0a6d7e6530d57037, 0x0 }, /* #43 */
    { 0x397082, 0x397002, 0x71ec1823c932c34f, 0x179476dc93a21aa8, 0x66786eff5a90d9e7, 0x0 }, /* #44 */
    { 0x1d63c2, 0x1d6386, 0x40a75c8267b843b4, 0xdc676bac4618db0c, 0x9cc0372e21a098b8, 0x0 }, /* #45 */
    { 0x0a6a86, 0x0a6206, 0x88e909f0f19f2e59, 0x299e0ccec2b51950, 0xa177053e332a3709, 0x0 }, /* #46 */
    { 0x3a04c6, 0x3a0406, 0x0ef94eda5c4906cd, 0x5279dff4a55a0218, 0x5c80912ef91304d5, 0x0 }, /* #47 */
    { 0x045e57, 0x045606, 0xacb75067d0fd70de, 0x36e382d1e4dd623f, 0x9a54d2b6342012e1, 0x0 }, /* #48 */
    { 0x0b2252, 0x0b2202, 0x9c330f0fbd32e8fa, 0x571b4db810c239f4, 0xcb2842b7adf0d10e, 0x0 }, /* #49 */
    { 0x003dd6, 0x003582, 0xb80903624771d046, 0x8a09d1c54186fc9b, 0x3200d2a706f72cdd, 0x0 }, /* #50 */
    { 0x2e2d92, 0x2e2582, 0x032ba7fb012ca3bc, 0xaa7883ba48f29ac7, 0xa953244149de397b, 0x0 }, /* #51 */
    { 0x325a92, 0x325282, 0xff05d5c6fc7c2d01, 0xafc0210541360307, 0x50c5f4c3bd4a2e06, 0x0 }, /* #52 */
    { 0x2a1406, 0x2a1482, 0x4982c825dcf479c1, 0xcc3b4944c68532ec, 0x85b981611a714b2d, 0x0 }, /* #53 */
    { 0x2e4ec6, 0x2e4602, 0x69208695fd4cacbd, 0x2c5a82cfc499015b, 0x457a045a39d5ade6, 0x0 }, /* #54 */
    { 0x1e7e07, 0x1e7602, 0xb0e3382555aa9880, 0x35cb887158f552b6, 0x8528b0540d5fca36, 0x0 }, /* #55 */
    { 0x240517, 0x240502, 0xa7bd8fca8097d505, 0x0492b6e34722458a, 0xa32f3929c7b5908f, 0x0 }, /* #56 */
    { 0x2f2c12, 0x2f2402, 0x3155a34ae95a106e, 0x46d25fe3e96a1ecd, 0x7787fca900300ea3, 0x0 }, /* #57 */
    { 0x211106, 0x211186, 0x0ad4b01a81eecd45, 0xc9065745eca59cf0, 0xc3d2e75f6d4b51b5, 0x0 }, /* #58 */
    { 0x3f3156, 0x3f3106, 0x7a645bddb1ab691d, 0x49a7483a970c0dc3, 0x33c313e726a764de, 0x0 }, /* #59 */
    { 0x375b57, 0x375386, 0x12b60485266e846e, 0xd547101bcead52d4, 0xc7f1149ee8c3d6ba, 0x0 }, /* #60 */
    { 0x255313, 0x255306, 0x429724f3f704e292, 0x6e63ee3e01d9fb42, 0x2cf4cacdf6dd19d0, 0x0 }, /* #61 */
    { 0x0a5902, 0x0a5182, 0x5784002d2185f4f8, 0x922daf65e7a857d0, 0xc5a9af48c62da328, 0x0 }, /* #62 */
    { 0x004507, 0x004506, 0x423534a196f8e331, 0x3925a505c08d1d2d, 0x7b1091a45675fe1c, 0x0 }, /* #63 */
    { 0x2a3113, 0x2a3182, 0x106af5eb2e5bf694, 0x95ad330af285383d, 0x85c7c6e1dcdecea9, 0x0 }, /* #64 */
    { 0x2131d3, 0x213186, 0x6c025c8f066f042c, 0xb21d65111722880c, 0xde1f399e114d8c20, 0x0 }, /* #65 */
    { 0x2423c2, 0x242306, 0x3398e53378e5a8d2, 0x3f7db868b76b3d0f, 0x0ce55d5bcf8e95dd, 0x0 }, /* #66 */
    { 0x344ed2, 0x344686, 0xf3018a92927bf087, 0x97fa29438c57a090, 0x64fba3d11e2c5017, 0x0 }, /* #67 */
    { 0x196a97, 0x196286, 0x81e1a80ba1a210ae, 0xa30de3e328c569a5, 0x22ec4be88967790b, 0x0 }, /* #68 */
    { 0x313713, 0x313706, 0xd1a54ca7116c9237, 0x233d86945e9a97ed, 0xf298ca334ff605da, 0x0 }, /* #69 */
    { 0x314ec3, 0x314686, 0x3c53492b2955e527, 0xc017ff6ed42505b1, 0xfc44b645fd70e096, 0x0 }, /* #70 */
    { 0x3351c2, 0x335106, 0xaf183dda6ea8298d, 0x49dff1af62805e3a, 0xe6c7cc750c2877b7, 0x0 }, /* #71 */
    { 0x1f7d96, 0x1f7582, 0x7d96773b0e9b5630, 0xd9698f896190211c, 0xa4fff8b26f0b772c, 0x0 }, /* #72 */
    { 0x3a42c7, 0x3a4282, 0xa55d57f652561eb4, 0xcf65226371c56ee9, 0x6a3875952393705d, 0x0 }, /* #73 */
    { 0x1c7202, 0x1c7202, 0xd7b492f8ca1d3edf, 0x6683ab8a2e5a400b, 0xb1373972e4477ed4, 0x0 }, /* #74 */
    { 0x1f2982, 0x1f2186, 0x355bd59c6a9142bb, 0x882c193886a402c3, 0xbd77cca4ec354078, 0x0 }, /* #75 */
    { 0x053b17, 0x053386, 0x21f42c06a4845df6, 0xeed3dcc663e6aa3c, 0xcf27f0c0c762f7ca, 0x0 }, /* #76 */
    { 0x0a1602, 0x0a1606, 0x2e83bbe6875fd769, 0x0312c59a961e1555, 0x2d917e7c1141c23c, 0x0 }, /* #77 */
    { 0x023787, 0x023782, 0x430f11c174f2eb51, 0xcb11f24b7559a7e6, 0x881ee38a01ab4cb7, 0x0 }, /* #78 */
    { 0x2378c3, 0x237006, 0x809f01d4fbd2ee64, 0x5437f29237181c74, 0xd4a8f346cccaf210, 0x0 }, /* #79 */
    { 0x380752, 0x380702, 0x15bc82372362ab92, 0x2d3dc6537df4b713, 0x388144645e961c81, 0x0 }, /* #80 */
    { 0x3a7487, 0x3a7402, 0xe6582ccbc179c430, 0x3f968df886f72ffb, 0xd9cea133478eebcb, 0x0 }, /* #81 */
    { 0x246b17, 0x246302, 0xb0771d2a40cff9f5, 0x12b9f969b0e64dfe, 0xa2cee443f029b40b, 0x0 }, /* #82 */
    { 0x2a6f56, 0x2a6702, 0xad57354385de9ff7, 0x2a0af55879a86523, 0x875dc01bfc76fad4, 0x0 }, /* #83 */
    { 0x2f4992, 0x2f4186, 0x6d0333de9650e0cd, 0xc3eb65bd7d6ddf50, 0xaee85663eb3d3f9d, 0x0 }, /* #84 */
    { 0x2e2a42, 0x2e2286, 0xe8739c339428d81e, 0x8c7f8c6591603987, 0x640c10560548e199, 0x0 }, /* #85 */
    { 0x0321c3, 0x032102, 0x7a18ba3ce84b16b9, 0x6108c83115e3b54c, 0x1b10720dfda8a3f5, 0x0 }, /* #86 */
    { 0x122f06, 0x122706, 0x1a5784c92ecc14b1, 0x04381f1316cdff14, 0x1e6f9bda3801eba5, 0x0 }, /* #87 */
    { 0x090396, 0x090302, 0x6361e91fada45069, 0x104510f16c54340b, 0x7324f9eec1f06462, 0x0 }, /* #88 */
    { 0x244283, 0x244282, 0xc37290780737eb16, 0xaaf1614ce2eb91c4, 0x6983f134e5dc7ad2, 0x0 }, /* #89 */
    { 0x026dd3, 0x026506, 0x7fb08641f7e8e5c5, 0x1f59927e17aa367b, 0x60e9143fe042d3be, 0x0 }, /* #90 */
    { 0x127ed3, 0x127682, 0x86d08f3cf8568b93, 0xe44f5578712082fe, 0x629fda448976096d, 0x0 }, /* #91 */
    { 0x184316, 0x184302, 0xbe4bae013caa6c2c, 0x47aa6d4257205acd, 0xf9e1c3436b8a36e1, 0x0 }, /* #92 */
    { 0x313f12, 0x313706, 0x534cf2f1734d3b26, 0x198f3a61b6271371, 0x4ac3c890c56a2857, 0x0 }, /* #93 */
    { 0x1e0016, 0x1e0002, 0xfad8e06c03390fe2, 0x499da9202cf33ad0, 0xb345494c2fca3532, 0x0 }, /* #94 */
    { 0x116bc7, 0x116302, 0xaf9d7b126f3cab70, 0x28dc594ad3662083, 0x87412258bc5a8bf3, 0x0 }, /* #95 */
};
uint32_t const g_cTests_xor_u64_locked = RT_ELEMENTS(g_aTests_xor_u64_locked);

BINU64_TEST_T const g_aTests_and_u64[] =
{
    { 0x070b42, 0x070346, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x2d2157, 0x2d2146, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x236cd2, 0x236446, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x0751d6, 0x075146, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x274456, 0x274446, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x0a2906, 0x0a2146, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x252547, 0x252546, 0x63aba6dcc92c02b5, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x172bd2, 0x172346, 0x7247ed3129bc5003, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x1062c7, 0x106246, 0xe99003837cfd6429, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x2360d6, 0x236046, 0xffb9a060b528eb0c, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x0e5dc6, 0x0e5546, 0x047565f3f469ff1d, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x301987, 0x301146, 0x5f432e4e9899edf9, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x1228d7, 0x122006, 0x2bf37bc0ecb4f6b0, 0x0a324100ac00c000, 0x0e3ac10cbf0bc80d, 0x0 }, /* #12 */
    { 0x2516c7, 0x251686, 0xb4f574389cc086c0, 0x94942418980000c0, 0x9e94271adb0e49e4, 0x0 }, /* #13 */
    { 0x1740d6, 0x174002, 0x71272e99b29ebe57, 0x21220801109aa216, 0x213288655cdba2be, 0x0 }, /* #14 */
    { 0x110c82, 0x110406, 0x3e00d57805fc486a, 0x1600513804dc006a, 0x57117bbeccdc937b, 0x0 }, /* #15 */
    { 0x014257, 0x014202, 0xeee20077285f18b8, 0x0ce2006128061010, 0x1def5a69ef267017, 0x0 }, /* #16 */
    { 0x384057, 0x384006, 0x4fc9030883ba1369, 0x0d080000823a1141, 0x1d3a4cc6ea7eb943, 0x0 }, /* #17 */
    { 0x162092, 0x162002, 0x58da56aec4bca6c5, 0x489242acc0240685, 0xef9762adfb240e9f, 0x0 }, /* #18 */
    { 0x320203, 0x320202, 0xa9d164350838bab6, 0x085040010818ba92, 0x4c7e51c36ddeffdb, 0x0 }, /* #19 */
    { 0x055596, 0x055502, 0x2403c942651375ce, 0x2402c94025120180, 0xa48ec9743dd20ba0, 0x0 }, /* #20 */
    { 0x3104d3, 0x310402, 0x611ad502fa95e59f, 0x60184502b2814185, 0xfc1d45c2b2e94185, 0x0 }, /* #21 */
    { 0x194e92, 0x194606, 0x6bccdb6c86ac7b7c, 0x4284006480a46b44, 0x5696207488e6ebc6, 0x0 }, /* #22 */
    { 0x2b0812, 0x2b0002, 0x1a6a4b6f4d4bce2e, 0x020a41260d090e02, 0x631fd1260fad2e92, 0x0 }, /* #23 */
    { 0x1f1ac6, 0x1f1286, 0xa79b0dfac103462f, 0xa2080c388003420f, 0xba284e399cebc20f, 0x0 }, /* #24 */
    { 0x3717c2, 0x371702, 0x40cfb292ddc354c8, 0x40c8a012000304c8, 0xc9f8e456023387ed, 0x0 }, /* #25 */
    { 0x2774c6, 0x277406, 0x568bb7b45f63aeb4, 0x5680b0a41e012c84, 0x76e4b0a6be956ccc, 0x0 }, /* #26 */
    { 0x312e83, 0x312606, 0x3802bcf8e89f8270, 0x30000c10601c8230, 0xb2844d14675ccbb8, 0x0 }, /* #27 */
    { 0x2a5783, 0x2a5706, 0x63f51cbda04ce066, 0x61810ca580082006, 0xe9838fe78a1a3d1f, 0x0 }, /* #28 */
    { 0x0b2a16, 0x0b2202, 0xd93857203813e1f8, 0x5928022030022180, 0x59e88a3c32863584, 0x0 }, /* #29 */
    { 0x3867c2, 0x386702, 0xd13cd3964b16d721, 0x1100410601068020, 0x3f404d4635e7a062, 0x0 }, /* #30 */
    { 0x333e43, 0x333602, 0x11a1c1eaff21204f, 0x1000c0009b010043, 0xd04cda109b4d4fe3, 0x0 }, /* #31 */
    { 0x2b0ad3, 0x2b0206, 0x685a26adb3a229eb, 0x4000040923822088, 0x56a51d59679f649c, 0x0 }, /* #32 */
    { 0x3a2817, 0x3a2006, 0x0c89bbca07215533, 0x08003aca01210000, 0x78743effe1ad0004, 0x0 }, /* #33 */
    { 0x1122d3, 0x112206, 0x875341e67956e87b, 0x055141e05104c059, 0x3dd5e9e8d785d05d, 0x0 }, /* #34 */
    { 0x3f5703, 0x3f5702, 0x6cc453686029e6f0, 0x44004320000860b0, 0x56386fb4864c69b2, 0x0 }, /* #35 */
    { 0x1b4c02, 0x1b4406, 0x0b6310e511d2dea1, 0x01620084119084a0, 0x51ee259eb5b9a4a2, 0x0 }, /* #36 */
    { 0x346983, 0x346106, 0x2ee23104b8d13b6f, 0x2c42100008c03b2d, 0x6d46d4330fca3f2d, 0x0 }, /* #37 */
    { 0x357387, 0x357382, 0xd5680d153f46132f, 0xc160001103401107, 0xc3f1025b43f91dd7, 0x0 }, /* #38 */
    { 0x2f4497, 0x2f4406, 0x496fb631cb24c8a8, 0x41261421432400a0, 0xc32655af63af34e0, 0x0 }, /* #39 */
    { 0x192fc6, 0x192782, 0xe9a8b013a1db4a5d, 0x81a0b01021914810, 0x93a3b97079b15d92, 0x0 }, /* #40 */
    { 0x0f0a16, 0x0f0206, 0x4418a19975a05f33, 0x4000811904805500, 0xf840c9198c98f504, 0x0 }, /* #41 */
    { 0x310942, 0x310186, 0xafcdec8c285cf503, 0x81c16c04000c8503, 0xd1c36d64452e87f3, 0x0 }, /* #42 */
    { 0x243987, 0x243102, 0x152ba6bfce176750, 0x0428228888060640, 0x0e3c6b88b9061e68, 0x0 }, /* #43 */
    { 0x303f97, 0x303702, 0xaa1c011c794a620c, 0x0a0c000448400204, 0x1fefaac64e5193f5, 0x0 }, /* #44 */
    { 0x1c63c2, 0x1c6306, 0x6fb83e9913db0bd0, 0x4730140803500bc0, 0x5736950e63543fc7, 0x0 }, /* #45 */
    { 0x356242, 0x356206, 0xe3cfc3a1ed1488f2, 0x020081a068048072, 0x1a00b5a0682ce47b, 0x0 }, /* #46 */
    { 0x144352, 0x144386, 0x9b188913ccc46cc3, 0x81080901c8040842, 0x852a7dc9db06097a, 0x0 }, /* #47 */
    { 0x2e0413, 0x2e0406, 0xd3cd8d1a0bbb1a8b, 0x13048d0203b21a03, 0x3b26ed63f3b25f37, 0x0 }, /* #48 */
    { 0x2c1143, 0x2c1186, 0xd591966253f4a4ad, 0x8411124240a08405, 0x8e7d125acca89747, 0x0 }, /* #49 */
    { 0x224642, 0x224602, 0x8b6284fbc3e5e481, 0x0a4080ab03e16401, 0x3ecce9ab33f37643, 0x0 }, /* #50 */
    { 0x0d6e16, 0x0d6682, 0xcc3a2395bdebbf1c, 0xcc12219089e3101c, 0xee56f99889e7507d, 0x0 }, /* #51 */
    { 0x151602, 0x151602, 0xe4b101f075dc56fd, 0x002000f070c0504c, 0x03622cff72e0594c, 0x0 }, /* #52 */
    { 0x2b0953, 0x2b0102, 0x3f9ab4090256c4ce, 0x2218140902404408, 0xe21c1ef98ec16c19, 0x0 }, /* #53 */
    { 0x367852, 0x367006, 0x9b3628e281f36f64, 0x0212006081834524, 0x02d31079d38755ac, 0x0 }, /* #54 */
    { 0x3d3056, 0x3d3002, 0xba5c15574f63e09b, 0x321400044b42e092, 0x76162224db56e8f6, 0x0 }, /* #55 */
    { 0x3c6d82, 0x3c6586, 0xa6e96efbec594f86, 0xa08804d364010300, 0xf88c14d776238369, 0x0 }, /* #56 */
    { 0x2f7387, 0x2f7302, 0x3b58d0e6c5e56c8f, 0x1900100401202c01, 0x9984100c31223f01, 0x0 }, /* #57 */
    { 0x0b0c47, 0x0b0406, 0xf71878a8a2696ff6, 0x4108200002206c36, 0x418a21165ea4ec37, 0x0 }, /* #58 */
    { 0x152503, 0x152506, 0xdf5f1f8e92293926, 0x515b130e90282100, 0x715b734eb9faa180, 0x0 }, /* #59 */
    { 0x0f3c53, 0x0f3402, 0x8dec0c9a4a3eec53, 0x058c0c080a3c2c02, 0x079d3c08be3c3e26, 0x0 }, /* #60 */
    { 0x3a5442, 0x3a5482, 0xcd0b9b01153e276a, 0x81090b010438042a, 0xb32d2f274cf804ae, 0x0 }, /* #61 */
    { 0x051ed3, 0x051682, 0xc26cfe629cb6afdc, 0x822c4c020c108480, 0xa2ac4d9b6e1184a1, 0x0 }, /* #62 */
    { 0x320ed6, 0x320602, 0x2bf307806c87bb91, 0x2183070068021291, 0x2187770a6a7252b9, 0x0 }, /* #63 */
    { 0x392597, 0x392502, 0xf79e975c72b38e44, 0x4408040032b38a40, 0x44684c22bab7eac1, 0x0 }, /* #64 */
    { 0x0b0203, 0x0b0202, 0x0e19f07654456e26, 0x0409703644400202, 0x944b7eb74f7a120b, 0x0 }, /* #65 */
    { 0x322216, 0x322286, 0x9a74b60c087d03ee, 0x922080040861036c, 0xd62b88d61ee1bf7d, 0x0 }, /* #66 */
    { 0x0e4306, 0x0e4302, 0x3c8fb6778c6eeb84, 0x0c88b67208264b04, 0x4ec8f67a5ab65b5d, 0x0 }, /* #67 */
    { 0x205d43, 0x205502, 0x3e68faa308a83c02, 0x1448180308283802, 0x94df1c43ae7c3ba2, 0x0 }, /* #68 */
    { 0x331c42, 0x331402, 0x11a43e8073d7443a, 0x10201e8020960408, 0xd42a9eeca4be8f08, 0x0 }, /* #69 */
    { 0x275fd6, 0x275782, 0x83c81671de2e7753, 0x8008062018002302, 0xe40ee62e39002b82, 0x0 }, /* #70 */
    { 0x250c03, 0x250486, 0xd66b488f7d3e6c3b, 0xd6010003002c6c12, 0xdf95150300ad6cd2, 0x0 }, /* #71 */
    { 0x3c3b13, 0x3c3302, 0x645d39c073675dd5, 0x244121c063001910, 0xa763a3f26f101938, 0x0 }, /* #72 */
    { 0x393c47, 0x393486, 0xdf6fad541dab6600, 0xcd6d290415a36600, 0xedfd3b27f5b36e32, 0x0 }, /* #73 */
    { 0x0411d3, 0x041102, 0x4cd31588471cf59d, 0x400010080618a494, 0xe02c5a2a96faa6d4, 0x0 }, /* #74 */
    { 0x0e0903, 0x0e0102, 0x9ce217ba1d57293a, 0x1c6215300047201a, 0x1e6ab5742047b6df, 0x0 }, /* #75 */
    { 0x156b43, 0x156302, 0x62ffe2e55d4f53a5, 0x6294a280500e0185, 0x6394b380720e2187, 0x0 }, /* #76 */
    { 0x3966c2, 0x396602, 0xf4cd978ea3a6d0c4, 0x04c4158002865080, 0x07d47de04adf73a9, 0x0 }, /* #77 */
    { 0x2c3dc2, 0x2c3506, 0x007200a109efa685, 0x006000a001a48681, 0xa1602fea67b4cfbb, 0x0 }, /* #78 */
    { 0x055152, 0x055106, 0x4b44ebf9333fff13, 0x0944c34820026600, 0x3dccc74e60026660, 0x0 }, /* #79 */
    { 0x382652, 0x382686, 0x85a1314bc68afa66, 0x842111024402a200, 0xdc2d91027d33a309, 0x0 }, /* #80 */
    { 0x0505c7, 0x050586, 0xa55debb131c070db, 0xa409a11031c0704b, 0xe40ba516f3e6796b, 0x0 }, /* #81 */
    { 0x1e3987, 0x1e3106, 0x3290c0643717ec4f, 0x200080241311c442, 0xad00bb3cdbf1c662, 0x0 }, /* #82 */
    { 0x1a7292, 0x1a7206, 0x3fae9bac9d36a893, 0x2b82032c90308082, 0x6bc2437f92f897e6, 0x0 }, /* #83 */
    { 0x3642d2, 0x364206, 0xadd94fd4e576adfb, 0x24004754847024a3, 0x7422f77e96f124a3, 0x0 }, /* #84 */
    { 0x0f2116, 0x0f2106, 0x58c36ab4167ac229, 0x08c2629414500000, 0x8fe2729cb4513d94, 0x0 }, /* #85 */
    { 0x266203, 0x266286, 0x8d82d3eec982e5fc, 0x8800c0c600006478, 0xda35e4d632446c79, 0x0 }, /* #86 */
    { 0x3023d2, 0x302306, 0xbfadada0087e4360, 0x3a898c8008780160, 0x7acb8ec46878a17e, 0x0 }, /* #87 */
    { 0x240c16, 0x240406, 0x973bbafb20b77749, 0x03301ab100917409, 0x43f45fb5c1917499, 0x0 }, /* #88 */
    { 0x021d96, 0x021502, 0xcd5b7408592ec637, 0x0412640851208016, 0x3416e54cd730b0de, 0x0 }, /* #89 */
    { 0x1e6f42, 0x1e6702, 0x1daf75cf5966d62a, 0x110f64c908469208, 0xf35f6cf908ceba9c, 0x0 }, /* #90 */
    { 0x1e3386, 0x1e3302, 0x8e57b27d48ec33a7, 0x0203800140e82002, 0x62238181e7fa2412, 0x0 }, /* #91 */
    { 0x190a83, 0x190202, 0x56fdd4e004c7bb4a, 0x02c1d0a00045b04a, 0x22c3daa58b55f0ce, 0x0 }, /* #92 */
    { 0x254a17, 0x254206, 0x15c76ab7d0f36b1a, 0x004240009031410a, 0xa26ad4409e39556f, 0x0 }, /* #93 */
    { 0x0a3553, 0x0a3506, 0x82f3032ad6a16b37, 0x02e2002084810b27, 0x5aea94e08dd38baf, 0x0 }, /* #94 */
    { 0x203b92, 0x203306, 0x326487f15088588a, 0x020481300008500a, 0xca0e9938224dd54b, 0x0 }, /* #95 */
};
uint32_t const g_cTests_and_u64 = RT_ELEMENTS(g_aTests_and_u64);

BINU64_TEST_T const g_aTests_and_u64_locked[] =
{
    { 0x173702, 0x173746, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x167e56, 0x167646, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x110016, 0x110046, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x256613, 0x256646, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x023786, 0x023746, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x084956, 0x084146, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x074652, 0x074646, 0xf9377030dd1ba061, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x0065d3, 0x006546, 0xdf0ba8df2afcbd7e, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x127b47, 0x127346, 0xd1cfe77d94d2a512, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x3e4a07, 0x3e4246, 0x4d98a5f74ce496c5, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x2e6202, 0x2e6246, 0xeea67639b5e8c443, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x2f7293, 0x2f7246, 0x6d5e50f807956b87, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x055bd3, 0x055306, 0x2929760442e902a6, 0x2808100040a10200, 0x389a10c3e1a16a09, 0x0 }, /* #12 */
    { 0x2b0a57, 0x2b0206, 0x86ad239879214b10, 0x002d220048204000, 0x016f3662c8e6e440, 0x0 }, /* #13 */
    { 0x177f97, 0x177706, 0x76b28cecfbaa512d, 0x50808844480a5124, 0x588cc857485a7b64, 0x0 }, /* #14 */
    { 0x2f5246, 0x2f5202, 0x63bed8a760c92401, 0x4284900340c90001, 0x4e85b60b46cfd88d, 0x0 }, /* #15 */
    { 0x0f42c7, 0x0f4206, 0x5a3d343f538927fd, 0x10352038410926a5, 0x15f52838695d2ea5, 0x0 }, /* #16 */
    { 0x261c52, 0x261482, 0xb6992901e9fd2a16, 0x8689010109ec2216, 0x8fcf53651dece736, 0x0 }, /* #17 */
    { 0x1b0707, 0x1b0702, 0x74752764c8ef6904, 0x40010744800f2004, 0x4309575c800f30e7, 0x0 }, /* #18 */
    { 0x1849c7, 0x184182, 0x974ea004af5ecabd, 0x964400048b168219, 0xde5517de9b17b719, 0x0 }, /* #19 */
    { 0x3d7657, 0x3d7606, 0x27f303f944756a1f, 0x20a202804405681e, 0xa0a65e80e48dedbe, 0x0 }, /* #20 */
    { 0x222d83, 0x222582, 0xeb866263a51aa80a, 0x8106224184028008, 0x914fafd9ce8691e9, 0x0 }, /* #21 */
    { 0x1f1453, 0x1f1402, 0xec2a76af5356cd74, 0x4028100301400810, 0x4369195385c83893, 0x0 }, /* #22 */
    { 0x2b2c07, 0x2b2486, 0xf1e232ed0e3b399b, 0xc02022680023191b, 0xc23def7a51e75b1b, 0x0 }, /* #23 */
    { 0x323b57, 0x323302, 0x85be620c3ec8b6c2, 0x0506220c26c01640, 0x5507b7bee6d51648, 0x0 }, /* #24 */
    { 0x1d5217, 0x1d5206, 0x0999e681fee637c4, 0x0898048002641784, 0xbada1d8e03645f9f, 0x0 }, /* #25 */
    { 0x0f3b13, 0x0f3382, 0xae28cd192ed801ff, 0x8c000d1822580176, 0x9dc12dd8e35f6176, 0x0 }, /* #26 */
    { 0x202506, 0x202586, 0xee9ad09224c26f40, 0xe212409220026400, 0xf35647d7b233e49a, 0x0 }, /* #27 */
    { 0x303d87, 0x303506, 0x4018e95101edbe56, 0x0018005100c08600, 0x88fb167bdad28689, 0x0 }, /* #28 */
    { 0x284743, 0x284706, 0x83d01f20af24e63c, 0x03d016202700a018, 0x17f0b6ab3719b15a, 0x0 }, /* #29 */
    { 0x0923c2, 0x092302, 0x3002a212a85f245a, 0x3002200028090408, 0xbfe639ed2aa905a8, 0x0 }, /* #30 */
    { 0x0a0a87, 0x0a0206, 0x11ae675fec78e50d, 0x002a61560840010c, 0x8c7bf1d618c10b1e, 0x0 }, /* #31 */
    { 0x3d2a97, 0x3d2286, 0xa667265aae05bd31, 0xa6410008a2010121, 0xa7d951aca3130165, 0x0 }, /* #32 */
    { 0x306a87, 0x306206, 0x89e2015a12057588, 0x08c2014012040500, 0x4ecae1455abe0f64, 0x0 }, /* #33 */
    { 0x060cd6, 0x060482, 0xaa25ceaeed1b8aea, 0x8220408489028220, 0xd67270c489e69624, 0x0 }, /* #34 */
    { 0x0c4586, 0x0c4586, 0x9b5ea611bcec2516, 0x8b06220098282400, 0xefa62becd938ee89, 0x0 }, /* #35 */
    { 0x0e3ad7, 0x0e3286, 0x95e2cefce2ce5340, 0x81a286ac00ce1200, 0xaba7a7ae05ee1a12, 0x0 }, /* #36 */
    { 0x017e92, 0x017682, 0xb04bc4dd05f4201a, 0xb04a84d501200002, 0xf7eebfd561204962, 0x0 }, /* #37 */
    { 0x381082, 0x381002, 0x40f35406e5db6bd1, 0x0023400244894991, 0xab23c2d256adcd99, 0x0 }, /* #38 */
    { 0x1e2303, 0x1e2302, 0x38e6def29b7cdb17, 0x18a2980082685904, 0x5faa9804c6e8594c, 0x0 }, /* #39 */
    { 0x344196, 0x344102, 0x4e1f1afda2dcc30f, 0x4c111af1a2540202, 0x7d51def1ba573a82, 0x0 }, /* #40 */
    { 0x3d6cc6, 0x3d6402, 0x7b81b9cde1971d15, 0x3181008d61860d15, 0xb183028f7bee2f15, 0x0 }, /* #41 */
    { 0x127547, 0x127502, 0xf63c6ad35d9dc825, 0x1208425211098020, 0x1b8a435a914b81e2, 0x0 }, /* #42 */
    { 0x312902, 0x312102, 0xa57f98a6d0109d50, 0x017c180400101c10, 0x0b7c5a040c5f5c12, 0x0 }, /* #43 */
    { 0x2f7d13, 0x2f7582, 0xe7ea558b7e71b5df, 0x82a8418a32009451, 0x92accbae330ede71, 0x0 }, /* #44 */
    { 0x030c42, 0x030402, 0x6f2c45bd4e3b479c, 0x612004084203478c, 0xe173064a7343d7ce, 0x0 }, /* #45 */
    { 0x3d36d6, 0x3d3602, 0x51c95e83e2050def, 0x11880881c00100c8, 0x338c09d5cca1e2d8, 0x0 }, /* #46 */
    { 0x272316, 0x272306, 0x44769ce5c18cda64, 0x44421081c0881224, 0x7c4b139bec891726, 0x0 }, /* #47 */
    { 0x3d7657, 0x3d7682, 0x81c60ded84070adf, 0x80c4084980050283, 0xd2e42a59b065f783, 0x0 }, /* #48 */
    { 0x271297, 0x271206, 0x97d6ee0f8d3ec8f2, 0x17068401012e4060, 0x1f068451036e6360, 0x0 }, /* #49 */
    { 0x053757, 0x053782, 0xdd40200859ba7a01, 0xd800200018105801, 0xfa153a831a15d943, 0x0 }, /* #50 */
    { 0x0c7293, 0x0c7206, 0x7885595f6e2637cb, 0x1884011c4e02358b, 0x98c6a39c4e1bfdaf, 0x0 }, /* #51 */
    { 0x0e5353, 0x0e5302, 0x892740b907e1a417, 0x002700a907800013, 0x323701ad97984a93, 0x0 }, /* #52 */
    { 0x0f0113, 0x0f0106, 0x38a08d3880473a82, 0x30a0893880040a82, 0x37f7d9ffe58c8ab6, 0x0 }, /* #53 */
    { 0x093fd6, 0x093786, 0xc03cea60bf329a31, 0xc0300a608c108821, 0xc9b00eeb8c10a96f, 0x0 }, /* #54 */
    { 0x2a5a96, 0x2a5202, 0x011d3b20ad720325, 0x0000312085400004, 0xac82b52197405496, 0x0 }, /* #55 */
    { 0x245d12, 0x245502, 0x31b1a590b9221b6f, 0x00b1818020201a6b, 0x8eb98b8a60a0fa6b, 0x0 }, /* #56 */
    { 0x387ad7, 0x387202, 0x376544351e162202, 0x0141002116040202, 0xc1c91a6397acda86, 0x0 }, /* #57 */
    { 0x3953d7, 0x395302, 0x4a506dc0f0dba53a, 0x42404c8050110532, 0xf6c84c925d355737, 0x0 }, /* #58 */
    { 0x0d65c6, 0x0d6586, 0xfeb3999451a0a9a0, 0xb411818401008900, 0xb459a5a403199d48, 0x0 }, /* #59 */
    { 0x180c43, 0x180482, 0xb1a33f304dd73641, 0xa1a2022001551640, 0xa3be0222a17556dc, 0x0 }, /* #60 */
    { 0x0f5b57, 0x0f5302, 0x0d9018a01043283b, 0x0d90182000022023, 0x1df4fe22893a31e3, 0x0 }, /* #61 */
    { 0x0b6fd3, 0x0b6702, 0x7c86b3f1e1c9a4fa, 0x68842171a0c02020, 0x68c56977a8f23a20, 0x0 }, /* #62 */
    { 0x2763d3, 0x276306, 0x8c63299015dcdb40, 0x04612910101c1a00, 0x07fdeb39781e1ea9, 0x0 }, /* #63 */
    { 0x2378c7, 0x237006, 0x539d3c0cd99ba9b7, 0x12183c0c5110a190, 0x365abfae7750e1d0, 0x0 }, /* #64 */
    { 0x371497, 0x371402, 0x137f18a9233ed2a0, 0x10190820210c4220, 0xd419cc64754c4f22, 0x0 }, /* #65 */
    { 0x2451c2, 0x245182, 0xa9d8643bd2aadc94, 0xa908001a42884494, 0xad09825e6e9d4496, 0x0 }, /* #66 */
    { 0x241917, 0x241102, 0x3747285aa4563c6e, 0x130300522456282c, 0x9bbb05f23f562a2d, 0x0 }, /* #67 */
    { 0x0e47d7, 0x0e4782, 0xcd88c8ab4ce8a3f5, 0xc00808880428a0d5, 0xd06e0d8c852ff4d7, 0x0 }, /* #68 */
    { 0x0d7316, 0x0d7386, 0x93cf5025d0bea8f6, 0x9087002490362084, 0xf8b7a6fcb1372685, 0x0 }, /* #69 */
    { 0x1d71d7, 0x1d7102, 0x18fa600339330840, 0x18aa600011100040, 0x3dae7ce4d31847fa, 0x0 }, /* #70 */
    { 0x191cd6, 0x191406, 0x98fcecbd8ebf2f50, 0x103c243d043b2250, 0x373d353d457b32f8, 0x0 }, /* #71 */
    { 0x123582, 0x123502, 0x1c0e104b16b9dae1, 0x1c0000010610ca20, 0xffb0ca812f14ef24, 0x0 }, /* #72 */
    { 0x3b4f47, 0x3b4702, 0xa9c73984faf3e50d, 0x2006190040d08101, 0x7616995b45d08b53, 0x0 }, /* #73 */
    { 0x0f6a47, 0x0f6202, 0xc372037a246ebccf, 0x4200024004288404, 0x7601aac1ce38c424, 0x0 }, /* #74 */
    { 0x164c13, 0x164406, 0xeb0419d225d96acb, 0x2100011200c0000a, 0x3148831348e4141e, 0x0 }, /* #75 */
    { 0x3c7157, 0x3c7106, 0xf1215f7163fb0add, 0x6120175143590090, 0x69e6b75ddf5dc4b0, 0x0 }, /* #76 */
    { 0x3e1fc6, 0x3e1706, 0x048d737a6454cf1d, 0x040c631004048e11, 0xf73c6f15850f8ef3, 0x0 }, /* #77 */
    { 0x2137c6, 0x213782, 0xc41daea1e8246734, 0x840d208168240734, 0x8ead31cd7c7f8ff5, 0x0 }, /* #78 */
    { 0x184b06, 0x184386, 0x977dab525edb712c, 0x826429104c130024, 0xe2666db46c1708e4, 0x0 }, /* #79 */
    { 0x252e06, 0x252602, 0xf0216c0b86b7035d, 0x1001280204120010, 0x1145b9a62c127c90, 0x0 }, /* #80 */
    { 0x1a3086, 0x1a3002, 0x89375c1cca4f797f, 0x08244c0c42003845, 0x1a64ef6c47303ac5, 0x0 }, /* #81 */
    { 0x2236c6, 0x223606, 0xdfe597315b14c13f, 0x5084111151104112, 0x508e311551987552, 0x0 }, /* #82 */
    { 0x351c52, 0x351406, 0x15e1981739d30a31, 0x01a0881639130011, 0x49b4aade7f1b14d7, 0x0 }, /* #83 */
    { 0x2a2297, 0x2a2206, 0x6c2f113591357b56, 0x6028113101153850, 0xf2f813b1611db879, 0x0 }, /* #84 */
    { 0x0c6ac2, 0x0c6286, 0x9d1d07cc4647d2eb, 0x89050744464710eb, 0xcbe7a7674ff718fb, 0x0 }, /* #85 */
    { 0x3a4482, 0x3a4402, 0x4e55b4260bdaea3f, 0x4200000001184825, 0x63880bc8e5385c65, 0x0 }, /* #86 */
    { 0x145ac6, 0x145286, 0xa6a83320941ad161, 0xa000030004004121, 0xe1528bc804c46b23, 0x0 }, /* #87 */
    { 0x157bc7, 0x157306, 0xdb776bf7c5a7324b, 0x5865233101a4000a, 0x7c65b73139f4c99e, 0x0 }, /* #88 */
    { 0x333393, 0x333306, 0x2b7983ce7ca8dcbd, 0x0a01830c54a008bd, 0x8e87c70c57b609bf, 0x0 }, /* #89 */
    { 0x3166d6, 0x316686, 0x91ecdaa0e7402aed, 0x91000aa065000a0c, 0xbb110fae7d060e1c, 0x0 }, /* #90 */
    { 0x212597, 0x212502, 0x7c55f9ecb8c2f217, 0x2841282480003202, 0x284b2834c5043a02, 0x0 }, /* #91 */
    { 0x1b5282, 0x1b5206, 0x0632547e01b1bcd3, 0x0010006a0000ac12, 0xa094a1eb9646af36, 0x0 }, /* #92 */
    { 0x2231c3, 0x223102, 0x058ad8c4195d2f3c, 0x010258c010450b1c, 0x5b7279c312c7cb1c, 0x0 }, /* #93 */
    { 0x2e4f82, 0x2e4786, 0xabf74f4561c2320f, 0xa92200454142200a, 0xe922804fd5632c8a, 0x0 }, /* #94 */
    { 0x294ad6, 0x294282, 0xbcfcf539a6ee21c9, 0x94f07110a20a0089, 0x97f17b96f30b4a9b, 0x0 }, /* #95 */
};
uint32_t const g_cTests_and_u64_locked = RT_ELEMENTS(g_aTests_and_u64_locked);

BINU64_TEST_T const g_aTests_cmp_u64[] =
{
    { 0x1059c3, 0x105146, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x002a46, 0x002246, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x0f2907, 0x0f2146, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x1e7bd7, 0x1e7346, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x0139c6, 0x013146, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x140c93, 0x140446, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x287f17, 0x287782, 0xf024fefd9874eada, 0xf024fefd9874eada, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x3a6d07, 0x3a6582, 0xaceaeca84d73da73, 0xaceaeca84d73da73, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x300c06, 0x300406, 0x1b0ce20c810714fc, 0x1b0ce20c810714fc, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x3b2d93, 0x3b2582, 0xa61e27795628ea64, 0xa61e27795628ea64, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x1c7fc3, 0x1c7786, 0xa4591fff9e5545bd, 0xa4591fff9e5545bd, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x335593, 0x335502, 0x0c7a5263ce992b8f, 0x0c7a5263ce992b8f, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x2d0496, 0x2d0486, 0xaf6e61085f79ed9e, 0xaf6e61085f79ed9e, 0x2d492b758d167639, 0x0 }, /* #12 */
    { 0x0d7107, 0x0d7912, 0x91ee3b7a1561bcf3, 0x91ee3b7a1561bcf3, 0x40cb4e92ed3b2fde, 0x0 }, /* #13 */
    { 0x1c2807, 0x1c2012, 0x524b9c1201a8bf31, 0x524b9c1201a8bf31, 0x41db46e5c768e2a2, 0x0 }, /* #14 */
    { 0x265552, 0x265502, 0x4340692c70340288, 0x4340692c70340288, 0x1d8067ff03baa781, 0x0 }, /* #15 */
    { 0x211293, 0x211a02, 0xb5999dd3f0c0619e, 0xb5999dd3f0c0619e, 0x6064dea0a669c174, 0x0 }, /* #16 */
    { 0x031bc3, 0x031397, 0x23d15141a157f2e3, 0x23d15141a157f2e3, 0x5c2acc4672b63805, 0x0 }, /* #17 */
    { 0x013797, 0x013712, 0xc043904bf3159395, 0xc043904bf3159395, 0xb02775b57f1ae687, 0x0 }, /* #18 */
    { 0x137753, 0x137717, 0x1b8520c14d1c5e63, 0x1b8520c14d1c5e63, 0xcce03eb12cc00aac, 0x0 }, /* #19 */
    { 0x2d7d97, 0x2d7d83, 0x463aa048f5b64d4a, 0x463aa048f5b64d4a, 0xabb01914ce8faae8, 0x0 }, /* #20 */
    { 0x2e37c7, 0x2e3f02, 0x9cc013986a100208, 0x9cc013986a100208, 0x2b2991de96c159f2, 0x0 }, /* #21 */
    { 0x302542, 0x302583, 0xa134b548a608269a, 0xa134b548a608269a, 0xf826f322711e6ef3, 0x0 }, /* #22 */
    { 0x194593, 0x194512, 0x64dbda4985168af9, 0x64dbda4985168af9, 0x3a1e562664335e0a, 0x0 }, /* #23 */
    { 0x220456, 0x220403, 0x46c2583483c90d6c, 0x46c2583483c90d6c, 0xce7e32d15403daab, 0x0 }, /* #24 */
    { 0x0f2313, 0x0f2316, 0x7767f863d0b0eda5, 0x7767f863d0b0eda5, 0x0e2e5854d9c5492a, 0x0 }, /* #25 */
    { 0x005b56, 0x005317, 0x20bd97dc0bb151f2, 0x20bd97dc0bb151f2, 0xf14e9324f3c86575, 0x0 }, /* #26 */
    { 0x2f2643, 0x2f2683, 0x324434323ea180e9, 0x324434323ea180e9, 0x3feff933a5798b51, 0x0 }, /* #27 */
    { 0x3f5a13, 0x3f5283, 0xdb2ab5cc04f752ed, 0xdb2ab5cc04f752ed, 0xf0f75bf2d8cfb311, 0x0 }, /* #28 */
    { 0x2f7a06, 0x2f7283, 0xb7052dc3244ce588, 0xb7052dc3244ce588, 0xca5dfe3bda7c78c6, 0x0 }, /* #29 */
    { 0x136642, 0x136697, 0x28000fb2e38fa6d2, 0x28000fb2e38fa6d2, 0x61a8948b9e0aa0c8, 0x0 }, /* #30 */
    { 0x397d12, 0x397597, 0x065aefe38ce61db1, 0x065aefe38ce61db1, 0x4304759b0e892a23, 0x0 }, /* #31 */
    { 0x0f11c7, 0x0f1987, 0x623d8a5fa1f028eb, 0x623d8a5fa1f028eb, 0xcdcb5f67e2ebe0b6, 0x0 }, /* #32 */
    { 0x1c2c02, 0x1c2492, 0xd336d6b42eff5da1, 0xd336d6b42eff5da1, 0x2a5f5b18d0f2a178, 0x0 }, /* #33 */
    { 0x212843, 0x212003, 0x15cba799ec8cede7, 0x15cba799ec8cede7, 0xd4c48fb714db2d90, 0x0 }, /* #34 */
    { 0x3e6356, 0x3e6316, 0x75d1bee5b0d0e540, 0x75d1bee5b0d0e540, 0x067757261adfcfea, 0x0 }, /* #35 */
    { 0x323316, 0x323393, 0x94e1ec34588fdc84, 0x94e1ec34588fdc84, 0xe4dbbca3f24cbd5e, 0x0 }, /* #36 */
    { 0x0b3386, 0x0b3397, 0xb996a7d25b3359a3, 0xb996a7d25b3359a3, 0xc53637ba4a3122f9, 0x0 }, /* #37 */
    { 0x1f75c7, 0x1f7582, 0xff5876d3c9a73527, 0xff5876d3c9a73527, 0x33525c20ab22e1c6, 0x0 }, /* #38 */
    { 0x3b3413, 0x3b3c06, 0xacd72be4a26e3a18, 0xacd72be4a26e3a18, 0x3eb7e8e66f690ea7, 0x0 }, /* #39 */
    { 0x024717, 0x024f87, 0x083a723da13cff18, 0x083a723da13cff18, 0x8680020c901c3a40, 0x0 }, /* #40 */
    { 0x237402, 0x237402, 0xa780f7c3615e001b, 0xa780f7c3615e001b, 0x8c1198d001aa936b, 0x0 }, /* #41 */
    { 0x0f1d03, 0x0f1503, 0x0ed3651a663622ee, 0x0ed3651a663622ee, 0xb90175b61ea9ee8c, 0x0 }, /* #42 */
    { 0x2d2a97, 0x2d2283, 0x9e692a406afdfc0d, 0x9e692a406afdfc0d, 0xa255f0875bb2187c, 0x0 }, /* #43 */
    { 0x051806, 0x051093, 0xc041a1bc88ba4c75, 0xc041a1bc88ba4c75, 0xf1ab9da7bdc2754f, 0x0 }, /* #44 */
    { 0x0c1b43, 0x0c1382, 0xea4987ef4d0a3ffe, 0xea4987ef4d0a3ffe, 0x31e07e7f158099fd, 0x0 }, /* #45 */
    { 0x0f4196, 0x0f4102, 0x36d8061da5daf418, 0x36d8061da5daf418, 0x302513de67a987c4, 0x0 }, /* #46 */
    { 0x015c92, 0x015c02, 0x85f7fca02d7b56da, 0x85f7fca02d7b56da, 0x64bd2498323141e3, 0x0 }, /* #47 */
    { 0x1d4917, 0x1d4987, 0x60f8bc19955bb8cd, 0x60f8bc19955bb8cd, 0x90a1ab388a4c52eb, 0x0 }, /* #48 */
    { 0x343c17, 0x343487, 0x235218d1707519ba, 0x235218d1707519ba, 0x787c719cfaca4779, 0x0 }, /* #49 */
    { 0x255e82, 0x255616, 0x7154f9d38bd4a4a5, 0x7154f9d38bd4a4a5, 0x399c2e913510e89b, 0x0 }, /* #50 */
    { 0x322556, 0x322d83, 0x7538b14386c9520c, 0x7538b14386c9520c, 0xbe2d13a39625a98c, 0x0 }, /* #51 */
    { 0x3b6e47, 0x3b6687, 0x40c6a655d0c1af7d, 0x40c6a655d0c1af7d, 0x769e5112e82f5cfb, 0x0 }, /* #52 */
    { 0x1d6b96, 0x1d6316, 0xade6b73a33b895b1, 0xade6b73a33b895b1, 0xa232d74933b3546d, 0x0 }, /* #53 */
    { 0x356917, 0x356196, 0xe5d5790ea198c4d2, 0xe5d5790ea198c4d2, 0x0b4bdc517a9dbc55, 0x0 }, /* #54 */
    { 0x2a70c7, 0x2a7897, 0x74424835ce55a6e1, 0x74424835ce55a6e1, 0xdda3718e20d03237, 0x0 }, /* #55 */
    { 0x152f43, 0x152783, 0x37d859157a50b40e, 0x37d859157a50b40e, 0x78f94ebc86dbb099, 0x0 }, /* #56 */
    { 0x0d2e86, 0x0d2602, 0x0a4c1c36d545947d, 0x0a4c1c36d545947d, 0x08a5ab1ba74fa138, 0x0 }, /* #57 */
    { 0x1c5c57, 0x1c5407, 0x2a7968a423290b1e, 0x2a7968a423290b1e, 0xb869770c51c0044d, 0x0 }, /* #58 */
    { 0x105bd2, 0x105b93, 0x706112b864337f19, 0x706112b864337f19, 0xddbaeb3e07debe5d, 0x0 }, /* #59 */
    { 0x070717, 0x070782, 0xb51c29a919df14c5, 0xb51c29a919df14c5, 0x25b3d7802f50fee5, 0x0 }, /* #60 */
    { 0x171bc3, 0x171397, 0x04080b9b723e3fb5, 0x04080b9b723e3fb5, 0x3a7ceb1245f88719, 0x0 }, /* #61 */
    { 0x357217, 0x357a87, 0x5df34f809943b18d, 0x5df34f809943b18d, 0xaab7e6acdf97b223, 0x0 }, /* #62 */
    { 0x3b6957, 0x3b6187, 0x9eeaf7de0e73d1ab, 0x9eeaf7de0e73d1ab, 0xb493505603350975, 0x0 }, /* #63 */
    { 0x292557, 0x292593, 0xd78a141a90eeada4, 0xd78a141a90eeada4, 0xe3056dc87311712f, 0x0 }, /* #64 */
    { 0x1b5e96, 0x1b5602, 0xd62e60b698204497, 0xd62e60b698204497, 0xce3d05f0744cde14, 0x0 }, /* #65 */
    { 0x041153, 0x041906, 0x9264f16146a40def, 0x9264f16146a40def, 0x6c778a7a306aeb99, 0x0 }, /* #66 */
    { 0x241592, 0x241593, 0xacd3435047166bbd, 0xacd3435047166bbd, 0xbb10944c195c7e7f, 0x0 }, /* #67 */
    { 0x225396, 0x225306, 0x5635176dc097645d, 0x5635176dc097645d, 0x18a0a06e9513c54c, 0x0 }, /* #68 */
    { 0x386543, 0x386506, 0xbc1024f1646d9377, 0xbc1024f1646d9377, 0x858615f1c178e753, 0x0 }, /* #69 */
    { 0x3c3d06, 0x3c3583, 0xb0a677c1cc9d04b5, 0xb0a677c1cc9d04b5, 0xf0776b35f3323424, 0x0 }, /* #70 */
    { 0x006d57, 0x006593, 0x3ee7150db21f5665, 0x3ee7150db21f5665, 0x5f2e448c170102a9, 0x0 }, /* #71 */
    { 0x020307, 0x020387, 0xb6a8a35a44f41b76, 0xb6a8a35a44f41b76, 0xef8d9a4b350dcf23, 0x0 }, /* #72 */
    { 0x3e2402, 0x3e2416, 0xd8629419a33711f3, 0xd8629419a33711f3, 0x92e02f8610780f16, 0x0 }, /* #73 */
    { 0x257dd7, 0x257596, 0xeab0abc3980908ce, 0xeab0abc3980908ce, 0x25125f3a26f5ae8f, 0x0 }, /* #74 */
    { 0x2125c6, 0x212d12, 0xcd1730d504103737, 0xcd1730d504103737, 0x61afa4fab002d52a, 0x0 }, /* #75 */
    { 0x233557, 0x233506, 0xdf698fb2e5e3bbd2, 0xdf698fb2e5e3bbd2, 0xb9c094f897fb1d50, 0x0 }, /* #76 */
    { 0x0c4c92, 0x0c4416, 0x3363227021884dc2, 0x3363227021884dc2, 0x0f7da0fad5fdcc4a, 0x0 }, /* #77 */
    { 0x1b1d42, 0x1b1586, 0xf6e8c0e2c6c7a4cc, 0xf6e8c0e2c6c7a4cc, 0x5ce5c57c6adae6a5, 0x0 }, /* #78 */
    { 0x2d1653, 0x2d1606, 0xda286d8cee322b46, 0xda286d8cee322b46, 0xb8708d2e9cdea535, 0x0 }, /* #79 */
    { 0x044843, 0x044006, 0xd5761b08ac4e9859, 0xd5761b08ac4e9859, 0xb26705e234a67863, 0x0 }, /* #80 */
    { 0x151283, 0x151212, 0x792531041eaf9137, 0x792531041eaf9137, 0x1518b7d68b8a997b, 0x0 }, /* #81 */
    { 0x1d3d82, 0x1d3593, 0xeba2488ddc8563e6, 0xeba2488ddc8563e6, 0xf613f37cde6b26eb, 0x0 }, /* #82 */
    { 0x305243, 0x305213, 0x5b38acc454a7cd29, 0x5b38acc454a7cd29, 0xfc1a639d18125f2b, 0x0 }, /* #83 */
    { 0x106c57, 0x106406, 0xbfdd3ff2da4a2e9f, 0xbfdd3ff2da4a2e9f, 0x97d2de3f49037405, 0x0 }, /* #84 */
    { 0x2b06d3, 0x2b0696, 0xee9996c1151356ea, 0xee9996c1151356ea, 0x5b826b53cf2972bc, 0x0 }, /* #85 */
    { 0x136296, 0x136216, 0x3aafca63aa921f74, 0x3aafca63aa921f74, 0x13ec0f16dc67cc46, 0x0 }, /* #86 */
    { 0x2349d3, 0x234102, 0x7cc2b5906178565e, 0x7cc2b5906178565e, 0x225a4033e88409d2, 0x0 }, /* #87 */
    { 0x0c4913, 0x0c4117, 0x158e65d28092047a, 0x158e65d28092047a, 0xbff2a7c0c9ad1ddb, 0x0 }, /* #88 */
    { 0x045b87, 0x045303, 0x0649244c001372c9, 0x0649244c001372c9, 0xc9b92563baf80144, 0x0 }, /* #89 */
    { 0x291bd7, 0x291303, 0x00aa5afc08c691cb, 0x00aa5afc08c691cb, 0xd76be17299f78ab1, 0x0 }, /* #90 */
    { 0x176913, 0x176183, 0xc54ea58386c8b0ad, 0xc54ea58386c8b0ad, 0xe6c96e3f058688ab, 0x0 }, /* #91 */
    { 0x1763c6, 0x176383, 0x32b1c23844b6fde5, 0x32b1c23844b6fde5, 0x7bf9efec1c825cf3, 0x0 }, /* #92 */
    { 0x112ac3, 0x112296, 0xf0035ed580c48a91, 0xf0035ed580c48a91, 0x02eed724ac937b49, 0x0 }, /* #93 */
    { 0x074d53, 0x074513, 0x0b545d9b07c0e2a2, 0x0b545d9b07c0e2a2, 0xbc66194db3652c1f, 0x0 }, /* #94 */
    { 0x286302, 0x286383, 0x30ce7ce5066026ec, 0x30ce7ce5066026ec, 0x5d0f2c4bbee8f495, 0x0 }, /* #95 */
};
uint32_t const g_cTests_cmp_u64 = RT_ELEMENTS(g_aTests_cmp_u64);

BINU64_TEST_T const g_aTests_test_u64[] =
{
    { 0x1a3a12, 0x1a3246, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x135d16, 0x135546, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x1b0f92, 0x1b0746, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x024d13, 0x024546, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x235a83, 0x235246, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x3804d7, 0x380446, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x214fd2, 0x214746, 0x520fe8d698132d78, 0x520fe8d698132d78, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x000dd3, 0x000546, 0x55b7fb124c741cd6, 0x55b7fb124c741cd6, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x025512, 0x025546, 0xfc2ade7bf14f8315, 0xfc2ade7bf14f8315, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x114906, 0x114146, 0x1d3c27065ff08544, 0x1d3c27065ff08544, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x1a4546, 0x1a4546, 0xd3007510a322c430, 0xd3007510a322c430, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x3b2446, 0x3b2446, 0xe33c2c1b6a839c6b, 0xe33c2c1b6a839c6b, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x080dd3, 0x080506, 0x5437120b25aa91d4, 0x5437120b25aa91d4, 0xd33a2bdd1ac0afca, 0x0 }, /* #12 */
    { 0x171486, 0x171406, 0x8a3f5d5ae79a99f9, 0x8a3f5d5ae79a99f9, 0x05519581a7cd32c0, 0x0 }, /* #13 */
    { 0x3127d6, 0x312706, 0xc7005c0e067f21bb, 0xc7005c0e067f21bb, 0x36a7f89a7f667d74, 0x0 }, /* #14 */
    { 0x305442, 0x305402, 0xa4154233509b2571, 0xa4154233509b2571, 0x2dfa3f00a0861f07, 0x0 }, /* #15 */
    { 0x314d46, 0x314502, 0x1c76dc5761df7946, 0x1c76dc5761df7946, 0xe26375346a64fc60, 0x0 }, /* #16 */
    { 0x3a0312, 0x3a0302, 0x1eb142369cb095da, 0x1eb142369cb095da, 0x8c403669f1ba5772, 0x0 }, /* #17 */
    { 0x011c52, 0x011486, 0xee141e1c3ed964d7, 0xee141e1c3ed964d7, 0xd9e8bb73bb55f0bd, 0x0 }, /* #18 */
    { 0x135356, 0x135302, 0x58a6b3c3e2227356, 0x58a6b3c3e2227356, 0x01fe91c5c049a598, 0x0 }, /* #19 */
    { 0x382ad6, 0x382206, 0x08a3d1d3fd908081, 0x08a3d1d3fd908081, 0xef50d3a8114a7eb7, 0x0 }, /* #20 */
    { 0x0b6fc6, 0x0b6782, 0x9ab7d8d9ae678c74, 0x9ab7d8d9ae678c74, 0xbd64be41c5be42b7, 0x0 }, /* #21 */
    { 0x383216, 0x383286, 0xf3adda5498cfe9ee, 0xf3adda5498cfe9ee, 0xfd2d50ff078be2dd, 0x0 }, /* #22 */
    { 0x032a93, 0x032282, 0xc43320a60f51cbfe, 0xc43320a60f51cbfe, 0x9285691083b0f2f4, 0x0 }, /* #23 */
    { 0x236783, 0x236706, 0x1a05f4628997cd4c, 0x1a05f4628997cd4c, 0xdfd550bc48be819c, 0x0 }, /* #24 */
    { 0x184783, 0x184706, 0x0bd7102d9337bfd5, 0x0bd7102d9337bfd5, 0x726697f4e950826e, 0x0 }, /* #25 */
    { 0x157006, 0x157006, 0x69838e0092f4bd89, 0x69838e0092f4bd89, 0xefd73f55fa184a97, 0x0 }, /* #26 */
    { 0x206d92, 0x206586, 0xa4b1533f7293a020, 0xa4b1533f7293a020, 0x98459a031b4ec415, 0x0 }, /* #27 */
    { 0x077582, 0x077502, 0xb478795b02bbf5a9, 0xb478795b02bbf5a9, 0x074bf82c9b2d7ccb, 0x0 }, /* #28 */
    { 0x116d43, 0x116502, 0xbb551e950e866fed, 0xbb551e950e866fed, 0x60ad3cdae368754b, 0x0 }, /* #29 */
    { 0x2d0b92, 0x2d0386, 0x9174d3b728f8ef8f, 0x9174d3b728f8ef8f, 0xe962860eba039ffe, 0x0 }, /* #30 */
    { 0x272b42, 0x272306, 0x0d1ef84f326a8a09, 0x0d1ef84f326a8a09, 0x4693d38ce5888ae0, 0x0 }, /* #31 */
    { 0x2b3382, 0x2b3306, 0xcb380ef611142109, 0xcb380ef611142109, 0x275e08f518deb700, 0x0 }, /* #32 */
    { 0x0101c2, 0x010102, 0x9a5a0409b6ddff72, 0x9a5a0409b6ddff72, 0x73d1fbd674d4b667, 0x0 }, /* #33 */
    { 0x0f7c12, 0x0f7486, 0xfd35c92bae2a4a5f, 0xfd35c92bae2a4a5f, 0xb04d3d9b5d9c8c14, 0x0 }, /* #34 */
    { 0x113c13, 0x113406, 0xc41fadcde27d961c, 0xc41fadcde27d961c, 0x6a756ab219eb4ed8, 0x0 }, /* #35 */
    { 0x170f96, 0x170706, 0x368c75f0bdc85360, 0x368c75f0bdc85360, 0x543347b41dfd2e76, 0x0 }, /* #36 */
    { 0x314b86, 0x314302, 0xed1aa0f6081a5803, 0xed1aa0f6081a5803, 0x0398507343d19add, 0x0 }, /* #37 */
    { 0x171a52, 0x171202, 0x72e38516bd91d190, 0x72e38516bd91d190, 0xeb7245e088f572cb, 0x0 }, /* #38 */
    { 0x3e7c93, 0x3e7402, 0x577ed4de3f39822b, 0x577ed4de3f39822b, 0xe80b71d2adfad66d, 0x0 }, /* #39 */
    { 0x1b64d3, 0x1b6482, 0xfcac64fa5e053822, 0xfcac64fa5e053822, 0x8011df77f4590af1, 0x0 }, /* #40 */
    { 0x080cd3, 0x080402, 0x835c58c9dda34ed6, 0x835c58c9dda34ed6, 0x4e3cb9cff5f6b636, 0x0 }, /* #41 */
    { 0x015756, 0x015702, 0x4aba2ef378b994cc, 0x4aba2ef378b994cc, 0x36930276e52e7071, 0x0 }, /* #42 */
    { 0x0c25c3, 0x0c2586, 0xb21aab54989ac6bb, 0xb21aab54989ac6bb, 0xf38474eebedf1373, 0x0 }, /* #43 */
    { 0x1b7747, 0x1b7782, 0xc32df55eb316efca, 0xc32df55eb316efca, 0xbe0e3872df5423e6, 0x0 }, /* #44 */
    { 0x1f3553, 0x1f3586, 0xcf117e4c2603ed52, 0xcf117e4c2603ed52, 0xa694c660e3311008, 0x0 }, /* #45 */
    { 0x1a59d2, 0x1a5106, 0x5c7e1db66a42cf35, 0x5c7e1db66a42cf35, 0xf17f26cab0f8bebf, 0x0 }, /* #46 */
    { 0x1b11d3, 0x1b1106, 0x5379dd24d616e949, 0x5379dd24d616e949, 0xf79492259972c706, 0x0 }, /* #47 */
    { 0x385846, 0x385002, 0x6874c094f7c725a6, 0x6874c094f7c725a6, 0x6261d0beec67f13f, 0x0 }, /* #48 */
    { 0x092013, 0x092002, 0xf50912a86598f386, 0xf50912a86598f386, 0x2f2b97b9ef6ba5be, 0x0 }, /* #49 */
    { 0x0f2812, 0x0f2002, 0xffbe9005ffb47a1f, 0xffbe9005ffb47a1f, 0x4da10d9502cac893, 0x0 }, /* #50 */
    { 0x2d7f42, 0x2d7706, 0x5cc35be9098106d7, 0x5cc35be9098106d7, 0x9b9c97482f85f6e8, 0x0 }, /* #51 */
    { 0x0f2b86, 0x0f2302, 0xda8cb3c44fe6720c, 0xda8cb3c44fe6720c, 0x26c4eef4bc818418, 0x0 }, /* #52 */
    { 0x1c2a93, 0x1c2206, 0x4634a32bad3c89ea, 0x4634a32bad3c89ea, 0x309ef76795932c29, 0x0 }, /* #53 */
    { 0x1504d2, 0x150482, 0xe13afb6e3b101cc6, 0xe13afb6e3b101cc6, 0xf830566be9e4942a, 0x0 }, /* #54 */
    { 0x3c5193, 0x3c5102, 0x4019b32864534d73, 0x4019b32864534d73, 0x657d430c3125d674, 0x0 }, /* #55 */
    { 0x135d17, 0x135506, 0x32c62562a720624a, 0x32c62562a720624a, 0xc642166f51536273, 0x0 }, /* #56 */
    { 0x2d7316, 0x2d7386, 0xd008ff577759a6b4, 0xd008ff577759a6b4, 0xf414e390d660c998, 0x0 }, /* #57 */
    { 0x213c82, 0x213402, 0xe6bf95cb1a5c4868, 0xe6bf95cb1a5c4868, 0x66f6c0b46086c155, 0x0 }, /* #58 */
    { 0x155f06, 0x155782, 0xb6bba61c0adb9e61, 0xb6bba61c0adb9e61, 0xf10dd40ab1309d67, 0x0 }, /* #59 */
    { 0x3b5e87, 0x3b5602, 0x138882f96adbbb18, 0x138882f96adbbb18, 0x6f6aed28b3781709, 0x0 }, /* #60 */
    { 0x0c59d2, 0x0c5106, 0xcc6f5910b45a0b9c, 0xcc6f5910b45a0b9c, 0x7d1806df1fcd8dbd, 0x0 }, /* #61 */
    { 0x020186, 0x020106, 0x2908a07630c1352e, 0x2908a07630c1352e, 0xbd02d3ac80a962ff, 0x0 }, /* #62 */
    { 0x3f6892, 0x3f6002, 0x7f0e75a5f99f5ba4, 0x7f0e75a5f99f5ba4, 0x87efd1b56f24775e, 0x0 }, /* #63 */
    { 0x346586, 0x346502, 0x52dbec8d358aa477, 0x52dbec8d358aa477, 0x16ba59037bc593ab, 0x0 }, /* #64 */
    { 0x260687, 0x260606, 0x9ce655ec70139f7f, 0x9ce655ec70139f7f, 0x5577d6abf8a597a4, 0x0 }, /* #65 */
    { 0x362f42, 0x362702, 0x14b6da55201139a3, 0x14b6da55201139a3, 0x4dfd69710afef463, 0x0 }, /* #66 */
    { 0x206993, 0x206102, 0xfdb56b1b9a4cdbfd, 0xfdb56b1b9a4cdbfd, 0x0f4b62d3ec781caa, 0x0 }, /* #67 */
    { 0x003fd2, 0x003782, 0xa0b23ca3711b452a, 0xa0b23ca3711b452a, 0xc5c77b20f9d017e5, 0x0 }, /* #68 */
    { 0x013716, 0x013706, 0x03d22b2bf60d0442, 0x03d22b2bf60d0442, 0x67eabaed3cfa6be3, 0x0 }, /* #69 */
    { 0x0a3652, 0x0a3682, 0xeebb17e3c09a76f9, 0xeebb17e3c09a76f9, 0xce084d9ed07ad224, 0x0 }, /* #70 */
    { 0x2f6283, 0x2f6206, 0x7a414fa553a8b2cc, 0x7a414fa553a8b2cc, 0xcc4693ceb07aa4f0, 0x0 }, /* #71 */
    { 0x2e0386, 0x2e0302, 0x7ad543a186072a9b, 0x7ad543a186072a9b, 0xaf756f67cd0e3f21, 0x0 }, /* #72 */
    { 0x3b0d03, 0x3b0502, 0x2b239d84dd595598, 0x2b239d84dd595598, 0x1782964773fd8c09, 0x0 }, /* #73 */
    { 0x0d1dc6, 0x0d1502, 0x76c44308d5750707, 0x76c44308d5750707, 0x5be534a8534c69d9, 0x0 }, /* #74 */
    { 0x325f07, 0x325706, 0xc7d3cb80b52c267b, 0xc7d3cb80b52c267b, 0x1d83f291903c82f6, 0x0 }, /* #75 */
    { 0x321cc7, 0x321486, 0xf87553902359dbfb, 0xf87553902359dbfb, 0xe47866d2fb1272c9, 0x0 }, /* #76 */
    { 0x362116, 0x362102, 0x6afb474c651c92bc, 0x6afb474c651c92bc, 0x77e8f9410f84cc23, 0x0 }, /* #77 */
    { 0x0741d3, 0x074106, 0x11089ab9b356f0c5, 0x11089ab9b356f0c5, 0x436a26663e79c6b9, 0x0 }, /* #78 */
    { 0x132e92, 0x132686, 0xfd0d78400db474a5, 0xfd0d78400db474a5, 0xbe9c28a9647e466e, 0x0 }, /* #79 */
    { 0x322a12, 0x322286, 0xfc0945f3f53c90fc, 0xfc0945f3f53c90fc, 0x9bfddbb7038ae95e, 0x0 }, /* #80 */
    { 0x3d7693, 0x3d7602, 0x5ba1acd0e84b9465, 0x5ba1acd0e84b9465, 0x52133d2a18914206, 0x0 }, /* #81 */
    { 0x270456, 0x270406, 0x429a779d50838844, 0x429a779d50838844, 0xe8ea95b4896b9e45, 0x0 }, /* #82 */
    { 0x1235c7, 0x123582, 0x88bf3eee6927b425, 0x88bf3eee6927b425, 0xc59b845b26a7d1b8, 0x0 }, /* #83 */
    { 0x036856, 0x036006, 0x2fbb1e92b9865fd1, 0x2fbb1e92b9865fd1, 0x847aee87ee469347, 0x0 }, /* #84 */
    { 0x374183, 0x374102, 0x951bd1c68ef463bd, 0x951bd1c68ef463bd, 0x6702d1a469e52720, 0x0 }, /* #85 */
    { 0x0f6586, 0x0f6582, 0xa74ca70da3c23eda, 0xa74ca70da3c23eda, 0x995575559b269440, 0x0 }, /* #86 */
    { 0x1e3dd6, 0x1e3502, 0xbf247d0a6ea64474, 0xbf247d0a6ea64474, 0x0b881b20d7c27a34, 0x0 }, /* #87 */
    { 0x0359c2, 0x035182, 0xf79692a7ced61562, 0xf79692a7ced61562, 0x93f05c988beb6135, 0x0 }, /* #88 */
    { 0x362917, 0x362102, 0x3feebc70f320f5e0, 0x3feebc70f320f5e0, 0x32fb3b48446de297, 0x0 }, /* #89 */
    { 0x2d28c2, 0x2d2086, 0xbd4e35421b3870a4, 0xbd4e35421b3870a4, 0x87ae79554a1698a9, 0x0 }, /* #90 */
    { 0x231f57, 0x231702, 0x0cd1c64d55ca9824, 0x0cd1c64d55ca9824, 0xd885eeb9be43c29e, 0x0 }, /* #91 */
    { 0x131886, 0x131002, 0x42e9226b65a7aea7, 0x42e9226b65a7aea7, 0x38c77d7b703a2307, 0x0 }, /* #92 */
    { 0x0967d3, 0x096782, 0xc4d77db8322f7fa0, 0xc4d77db8322f7fa0, 0xb434be50d5e2a183, 0x0 }, /* #93 */
    { 0x201a86, 0x201282, 0xffd6f47c749fa255, 0xffd6f47c749fa255, 0xb6534aee3d51db97, 0x0 }, /* #94 */
    { 0x2e63d7, 0x2e6306, 0x73347915e29ed876, 0x73347915e29ed876, 0xa9d7ce5c882796d9, 0x0 }, /* #95 */
};
uint32_t const g_cTests_test_u64 = RT_ELEMENTS(g_aTests_test_u64);

BINU64_TEST_T const g_aTests_bt_u64[] =
{
    { 0x263e56, 0x263e56, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x117d83, 0x117d82, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x0e2d06, 0x0e2d06, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x3169c7, 0x3169c6, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x1200c6, 0x1200c6, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x0141d7, 0x0141d6, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x0f70d2, 0x0f70d3, 0x98860bbbe0eca213, 0x98860bbbe0eca213, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x041153, 0x041153, 0x4273b5c89ea0a4bb, 0x4273b5c89ea0a4bb, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x1817d2, 0x1817d3, 0x796dc57c149b276f, 0x796dc57c149b276f, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x192542, 0x192543, 0x76e8e7bb8d971201, 0x76e8e7bb8d971201, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x105b97, 0x105b97, 0xe24458abbf6032b9, 0xe24458abbf6032b9, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x1e6582, 0x1e6582, 0xb844617ca8f4e826, 0xb844617ca8f4e826, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x183257, 0x183256, 0xb9439bc1e4cb156a, 0xb9439bc1e4cb156a, 0x0000000000000024, 0x0 }, /* #12 */
    { 0x063bc6, 0x063bc6, 0x06e070bb16454afd, 0x06e070bb16454afd, 0x000000000000001f, 0x0 }, /* #13 */
    { 0x2927c3, 0x2927c3, 0x5a79bc76980bfa0a, 0x5a79bc76980bfa0a, 0x0000000000000021, 0x0 }, /* #14 */
    { 0x157dd6, 0x157dd7, 0xe6a600c9b76f4e9e, 0xe6a600c9b76f4e9e, 0x0000000000000037, 0x0 }, /* #15 */
    { 0x242b53, 0x242b53, 0x5286060931d7d5e7, 0x5286060931d7d5e7, 0x0000000000000020, 0x0 }, /* #16 */
    { 0x2d7353, 0x2d7352, 0x849eb3e52cb976a0, 0x849eb3e52cb976a0, 0x0000000000000003, 0x0 }, /* #17 */
    { 0x382793, 0x382792, 0x83ee7258e19ecc50, 0x83ee7258e19ecc50, 0x0000000000000015, 0x0 }, /* #18 */
    { 0x2805d6, 0x2805d7, 0x5d353d0bd12687f2, 0x5d353d0bd12687f2, 0x0000000000000008, 0x0 }, /* #19 */
    { 0x3c0a86, 0x3c0a86, 0xc991273e4180df99, 0xc991273e4180df99, 0x000000000000001c, 0x0 }, /* #20 */
    { 0x0c28c3, 0x0c28c3, 0xdc3f892a334ad366, 0xdc3f892a334ad366, 0x000000000000000f, 0x0 }, /* #21 */
    { 0x250017, 0x250016, 0xb551d054c8df7a83, 0xb551d054c8df7a83, 0x0000000000000003, 0x0 }, /* #22 */
    { 0x0951d2, 0x0951d2, 0x219f0a15002bd9f1, 0x219f0a15002bd9f1, 0x0000000000000016, 0x0 }, /* #23 */
    { 0x1f2e16, 0x1f2e17, 0xb0c59b7d7cf4096b, 0xb0c59b7d7cf4096b, 0x000000000000002b, 0x0 }, /* #24 */
    { 0x216e17, 0x216e17, 0x68ace18f67ad51d3, 0x68ace18f67ad51d3, 0x0000000000000020, 0x0 }, /* #25 */
    { 0x225547, 0x225546, 0x7d8941933b8cfc27, 0x7d8941933b8cfc27, 0x0000000000000029, 0x0 }, /* #26 */
    { 0x0064d3, 0x0064d2, 0x6610f7d353d99bf0, 0x6610f7d353d99bf0, 0x0000000000000036, 0x0 }, /* #27 */
    { 0x181f43, 0x181f42, 0xde09cb5a59fee3a3, 0xde09cb5a59fee3a3, 0x000000000000000b, 0x0 }, /* #28 */
    { 0x367a57, 0x367a56, 0xf42ec5db3f82cd7e, 0xf42ec5db3f82cd7e, 0x0000000000000013, 0x0 }, /* #29 */
    { 0x167986, 0x167987, 0xcf49179a458d207c, 0xcf49179a458d207c, 0x0000000000000006, 0x0 }, /* #30 */
    { 0x3b15d3, 0x3b15d2, 0xf24bac4f901fd276, 0xf24bac4f901fd276, 0x000000000000001a, 0x0 }, /* #31 */
    { 0x1624c6, 0x1624c6, 0x7b4bbb417975de53, 0x7b4bbb417975de53, 0x0000000000000025, 0x0 }, /* #32 */
    { 0x014846, 0x014846, 0xe30ffd2218cd3213, 0xe30ffd2218cd3213, 0x0000000000000007, 0x0 }, /* #33 */
    { 0x2f0ad3, 0x2f0ad3, 0xee6641517e8c9e71, 0xee6641517e8c9e71, 0x000000000000001d, 0x0 }, /* #34 */
    { 0x060597, 0x060596, 0x2383f09e1c0628b1, 0x2383f09e1c0628b1, 0x0000000000000025, 0x0 }, /* #35 */
    { 0x2b6b83, 0x2b6b82, 0x21e8b6b616f9ed29, 0x21e8b6b616f9ed29, 0x000000000000000c, 0x0 }, /* #36 */
    { 0x3a6042, 0x3a6043, 0x5bb135dcccc627fe, 0x5bb135dcccc627fe, 0x0000000000000016, 0x0 }, /* #37 */
    { 0x0b5517, 0x0b5516, 0x9a8b8259bcb5b76b, 0x9a8b8259bcb5b76b, 0x0000000000000004, 0x0 }, /* #38 */
    { 0x063597, 0x063596, 0xc63d058cd4d9588f, 0xc63d058cd4d9588f, 0x0000000000000021, 0x0 }, /* #39 */
    { 0x1e6b03, 0x1e6b02, 0x1c76b19c4c93a9fc, 0x1c76b19c4c93a9fc, 0x000000000000000a, 0x0 }, /* #40 */
    { 0x146483, 0x146482, 0x25de6c31c7148a2e, 0x25de6c31c7148a2e, 0x0000000000000015, 0x0 }, /* #41 */
    { 0x292096, 0x292096, 0x38bcfd7b6affd26c, 0x38bcfd7b6affd26c, 0x0000000000000027, 0x0 }, /* #42 */
    { 0x1c6dc3, 0x1c6dc2, 0x6d49c634373d863a, 0x6d49c634373d863a, 0x0000000000000016, 0x0 }, /* #43 */
    { 0x244603, 0x244603, 0x091c8315912028c1, 0x091c8315912028c1, 0x000000000000000d, 0x0 }, /* #44 */
    { 0x077b93, 0x077b93, 0x6027602af82e1ac7, 0x6027602af82e1ac7, 0x000000000000003d, 0x0 }, /* #45 */
    { 0x222e42, 0x222e43, 0xc3d9248ac9527e6d, 0xc3d9248ac9527e6d, 0x0000000000000036, 0x0 }, /* #46 */
    { 0x3a1512, 0x3a1512, 0x7f1321ac8fa40c18, 0x7f1321ac8fa40c18, 0x0000000000000037, 0x0 }, /* #47 */
    { 0x315707, 0x315706, 0xb0ba6af76d3a9298, 0xb0ba6af76d3a9298, 0x000000000000000d, 0x0 }, /* #48 */
    { 0x3120c3, 0x3120c3, 0x73ad2f1794bf806b, 0x73ad2f1794bf806b, 0x0000000000000001, 0x0 }, /* #49 */
    { 0x1e20d3, 0x1e20d2, 0xdcb3026e0a51cc07, 0xdcb3026e0a51cc07, 0x0000000000000036, 0x0 }, /* #50 */
    { 0x077bc2, 0x077bc2, 0xb8160afe4ff68b7e, 0xb8160afe4ff68b7e, 0x000000000000002c, 0x0 }, /* #51 */
    { 0x027797, 0x027796, 0x13334bbda453e2fd, 0x13334bbda453e2fd, 0x0000000000000018, 0x0 }, /* #52 */
    { 0x302912, 0x302913, 0x2fe9fc49dfdd5d63, 0x2fe9fc49dfdd5d63, 0x0000000000000023, 0x0 }, /* #53 */
    { 0x087d52, 0x087d53, 0xca6d9aedb3975953, 0xca6d9aedb3975953, 0x0000000000000011, 0x0 }, /* #54 */
    { 0x0b07d3, 0x0b07d3, 0x8a6bf0b6f59c02fe, 0x8a6bf0b6f59c02fe, 0x000000000000002e, 0x0 }, /* #55 */
    { 0x351f46, 0x351f46, 0xba1510e72284bdd6, 0xba1510e72284bdd6, 0x0000000000000013, 0x0 }, /* #56 */
    { 0x2811c3, 0x2811c3, 0x05b7ad17ed12ea4d, 0x05b7ad17ed12ea4d, 0x0000000000000002, 0x0 }, /* #57 */
    { 0x375c16, 0x375c16, 0xce8b783918e8c25d, 0xce8b783918e8c25d, 0x0000000000000027, 0x0 }, /* #58 */
    { 0x071702, 0x071703, 0xc7add0e8acb49b83, 0xc7add0e8acb49b83, 0x000000000000002e, 0x0 }, /* #59 */
    { 0x082496, 0x082496, 0xb32af463b866f32e, 0xb32af463b866f32e, 0x0000000000000029, 0x0 }, /* #60 */
    { 0x3428d2, 0x3428d2, 0xafef8a68921b46ec, 0xafef8a68921b46ec, 0x0000000000000028, 0x0 }, /* #61 */
    { 0x397dd6, 0x397dd7, 0xb289e3036def0461, 0xb289e3036def0461, 0x0000000000000006, 0x0 }, /* #62 */
    { 0x2e7417, 0x2e7417, 0x5a96962cef4ff2e8, 0x5a96962cef4ff2e8, 0x0000000000000010, 0x0 }, /* #63 */
    { 0x3a65c3, 0x3a65c3, 0xad40792ac1003e4d, 0xad40792ac1003e4d, 0x000000000000002b, 0x0 }, /* #64 */
    { 0x1e5d46, 0x1e5d47, 0x9abb35217a04dafa, 0x9abb35217a04dafa, 0x0000000000000003, 0x0 }, /* #65 */
    { 0x1d0702, 0x1d0703, 0x108cfc036af4a6a3, 0x108cfc036af4a6a3, 0x000000000000000d, 0x0 }, /* #66 */
    { 0x311506, 0x311506, 0xf58a9fba4aae6ed7, 0xf58a9fba4aae6ed7, 0x000000000000003b, 0x0 }, /* #67 */
    { 0x0b6216, 0x0b6217, 0x503ac5b49b9b5c38, 0x503ac5b49b9b5c38, 0x0000000000000031, 0x0 }, /* #68 */
    { 0x191f83, 0x191f83, 0x599d250c292d5e38, 0x599d250c292d5e38, 0x0000000000000030, 0x0 }, /* #69 */
    { 0x2e0712, 0x2e0712, 0x37dd02dfd579c8b7, 0x37dd02dfd579c8b7, 0x000000000000002e, 0x0 }, /* #70 */
    { 0x355457, 0x355456, 0xf211c5ed8e1dd6ff, 0xf211c5ed8e1dd6ff, 0x000000000000001d, 0x0 }, /* #71 */
    { 0x250187, 0x250187, 0x8ff29a1242968541, 0x8ff29a1242968541, 0x0000000000000039, 0x0 }, /* #72 */
    { 0x370457, 0x370456, 0xa0246978e0726a92, 0xa0246978e0726a92, 0x000000000000001a, 0x0 }, /* #73 */
    { 0x050506, 0x050507, 0xc605f92b6e178552, 0xc605f92b6e178552, 0x000000000000002e, 0x0 }, /* #74 */
    { 0x385d42, 0x385d43, 0x62154feb71a7f9a6, 0x62154feb71a7f9a6, 0x000000000000000d, 0x0 }, /* #75 */
    { 0x2b6282, 0x2b6283, 0xb334b63e0a472674, 0xb334b63e0a472674, 0x0000000000000021, 0x0 }, /* #76 */
    { 0x171a52, 0x171a52, 0x049a13590a4590b8, 0x049a13590a4590b8, 0x000000000000001d, 0x0 }, /* #77 */
    { 0x320ac3, 0x320ac3, 0x409ee4bc8cb74a27, 0x409ee4bc8cb74a27, 0x0000000000000015, 0x0 }, /* #78 */
    { 0x393b03, 0x393b03, 0x85d0c2abad1c7691, 0x85d0c2abad1c7691, 0x0000000000000000, 0x0 }, /* #79 */
    { 0x3d3a86, 0x3d3a86, 0xfe461aa7da40867c, 0xfe461aa7da40867c, 0x0000000000000015, 0x0 }, /* #80 */
    { 0x054ac6, 0x054ac7, 0xa0578dd6fab66a79, 0xa0578dd6fab66a79, 0x0000000000000014, 0x0 }, /* #81 */
    { 0x156186, 0x156186, 0x6ccd6a5f92a03a78, 0x6ccd6a5f92a03a78, 0x000000000000002c, 0x0 }, /* #82 */
    { 0x364dc3, 0x364dc2, 0x747802532c5cf492, 0x747802532c5cf492, 0x0000000000000009, 0x0 }, /* #83 */
    { 0x3f5d87, 0x3f5d86, 0x05b25c401c6e1db5, 0x05b25c401c6e1db5, 0x0000000000000032, 0x0 }, /* #84 */
    { 0x2b6057, 0x2b6057, 0xa5b1c3fc07eb7cbc, 0xa5b1c3fc07eb7cbc, 0x000000000000002e, 0x0 }, /* #85 */
    { 0x1b7d16, 0x1b7d16, 0x009c482da1961adb, 0x009c482da1961adb, 0x0000000000000015, 0x0 }, /* #86 */
    { 0x156ac2, 0x156ac3, 0x0b4a2432dd6f5daa, 0x0b4a2432dd6f5daa, 0x0000000000000013, 0x0 }, /* #87 */
    { 0x1d3dd2, 0x1d3dd2, 0xc506370599cc4538, 0xc506370599cc4538, 0x0000000000000007, 0x0 }, /* #88 */
    { 0x2e28d3, 0x2e28d3, 0x74fa819186795154, 0x74fa819186795154, 0x000000000000002f, 0x0 }, /* #89 */
    { 0x231617, 0x231616, 0x329101e2a184e583, 0x329101e2a184e583, 0x0000000000000022, 0x0 }, /* #90 */
    { 0x1600c2, 0x1600c3, 0x828eee514758a00c, 0x828eee514758a00c, 0x0000000000000018, 0x0 }, /* #91 */
    { 0x1d2507, 0x1d2507, 0xb5c61a7f0cd1c789, 0xb5c61a7f0cd1c789, 0x000000000000003a, 0x0 }, /* #92 */
    { 0x161256, 0x161256, 0x4ca988c3ccd11435, 0x4ca988c3ccd11435, 0x000000000000001d, 0x0 }, /* #93 */
    { 0x2d3112, 0x2d3112, 0x72ac222e422b949b, 0x72ac222e422b949b, 0x0000000000000026, 0x0 }, /* #94 */
    { 0x0a3506, 0x0a3506, 0x6c6db7f9b741c094, 0x6c6db7f9b741c094, 0x0000000000000034, 0x0 }, /* #95 */
};
uint32_t const g_cTests_bt_u64 = RT_ELEMENTS(g_aTests_bt_u64);

BINU64_TEST_T const g_aTests_btc_u64[] =
{
    { 0x0c5817, 0x0c5816, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x092ed2, 0x092ed2, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x0828d2, 0x0828d2, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x0d09c2, 0x0d09c2, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x350452, 0x350452, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x364ad7, 0x364ad6, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x205596, 0x205596, 0x0ea7995c30219fb2, 0x0ea7995c30219fb3, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x122a57, 0x122a57, 0x9b37e141060df8ed, 0x9b37e141060df8ec, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x283e13, 0x283e12, 0x789e4c64e5fab1c4, 0x789e4c64e5fab1c5, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x3122d3, 0x3122d3, 0x3086833110ca43cf, 0x3086833110ca43ce, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x132f97, 0x132f97, 0xff3138f4f2ac6b8d, 0xff3138f4f2ac6b8c, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x391d82, 0x391d83, 0xea6106fc1701fbfb, 0xea6106fc1701fbfa, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x216702, 0x216703, 0x67d5c6c9a4cd8fb9, 0x65d5c6c9a4cd8fb9, 0x0000000000000039, 0x0 }, /* #12 */
    { 0x374546, 0x374546, 0x6ebf8826804a1514, 0x6ebf8826904a1514, 0x000000000000001c, 0x0 }, /* #13 */
    { 0x1c6612, 0x1c6612, 0x3faa714ea69ed855, 0x3faa714ea6ded855, 0x0000000000000016, 0x0 }, /* #14 */
    { 0x372212, 0x372212, 0x7df89fc2445b5a4f, 0x7df89fc2445b5acf, 0x0000000000000007, 0x0 }, /* #15 */
    { 0x046292, 0x046292, 0x4c92958b6ad3ba6c, 0x4c92959b6ad3ba6c, 0x0000000000000024, 0x0 }, /* #16 */
    { 0x072a93, 0x072a93, 0x1c6a713bb8c8ac34, 0x146a713bb8c8ac34, 0x000000000000003b, 0x0 }, /* #17 */
    { 0x0e6a83, 0x0e6a82, 0xe90d5e062db756a7, 0xe90d5e062db757a7, 0x0000000000000008, 0x0 }, /* #18 */
    { 0x217102, 0x217103, 0x7d44eb14c3a78a46, 0x7d44eb14c3a78a06, 0x0000000000000006, 0x0 }, /* #19 */
    { 0x104f97, 0x104f96, 0x9093790842fdb707, 0x9093790842fdb727, 0x0000000000000005, 0x0 }, /* #20 */
    { 0x273e53, 0x273e53, 0x14cb49e4981edf11, 0x14cb49e4981edf01, 0x0000000000000004, 0x0 }, /* #21 */
    { 0x084d52, 0x084d52, 0x16c49785117bdc60, 0x16c49785117bdce0, 0x0000000000000007, 0x0 }, /* #22 */
    { 0x2b5ad2, 0x2b5ad2, 0x34b4ae7127c5c145, 0x34b4ae7127c5c155, 0x0000000000000004, 0x0 }, /* #23 */
    { 0x0a56d6, 0x0a56d6, 0xeab479077b4fc874, 0xeab479077b4fca74, 0x0000000000000009, 0x0 }, /* #24 */
    { 0x067602, 0x067602, 0x89edfd14c0d519e4, 0x89edfd14c1d519e4, 0x0000000000000018, 0x0 }, /* #25 */
    { 0x3f3187, 0x3f3187, 0xc11cb7a9e1db4cc3, 0xc11cb7a9e1db48c3, 0x000000000000000a, 0x0 }, /* #26 */
    { 0x3b1197, 0x3b1196, 0x84a0461d5821c287, 0x84a0461d5861c287, 0x0000000000000016, 0x0 }, /* #27 */
    { 0x1673d7, 0x1673d7, 0xd56022faff235ec6, 0xd56022faff235e86, 0x0000000000000006, 0x0 }, /* #28 */
    { 0x3928d2, 0x3928d2, 0x711aeb61fa51e016, 0x711aebe1fa51e016, 0x0000000000000027, 0x0 }, /* #29 */
    { 0x0115d2, 0x0115d2, 0x1511d95237df889a, 0x1711d95237df889a, 0x0000000000000039, 0x0 }, /* #30 */
    { 0x2c06c3, 0x2c06c3, 0xa1cc47ac7af27f05, 0xa1cc47ac7af27b05, 0x000000000000000a, 0x0 }, /* #31 */
    { 0x1e2bc7, 0x1e2bc7, 0x8b81f10c745bd46f, 0x8b81f10c745b946f, 0x000000000000000e, 0x0 }, /* #32 */
    { 0x303012, 0x303013, 0xc7906111c33f5c30, 0xc7906111c33f5c20, 0x0000000000000004, 0x0 }, /* #33 */
    { 0x212dc6, 0x212dc6, 0xe321c9cc4f483864, 0xe321c9cc4f583864, 0x0000000000000014, 0x0 }, /* #34 */
    { 0x2a1fd2, 0x2a1fd2, 0x8a5f14049a73eb07, 0x8adf14049a73eb07, 0x0000000000000037, 0x0 }, /* #35 */
    { 0x296fd2, 0x296fd3, 0xa753dcf852d2678d, 0xa753dcf852d0678d, 0x0000000000000011, 0x0 }, /* #36 */
    { 0x2b69d6, 0x2b69d7, 0xc88f2515449f48e2, 0x488f2515449f48e2, 0x000000000000003f, 0x0 }, /* #37 */
    { 0x146543, 0x146542, 0xa0f33cbf4aa47a3c, 0xa0f37cbf4aa47a3c, 0x000000000000002e, 0x0 }, /* #38 */
    { 0x3513c7, 0x3513c6, 0x1169ad713f678c00, 0x1169adf13f678c00, 0x0000000000000027, 0x0 }, /* #39 */
    { 0x2557c6, 0x2557c6, 0x834e5389bcb9bf16, 0x834e5789bcb9bf16, 0x000000000000002a, 0x0 }, /* #40 */
    { 0x012693, 0x012692, 0x231b2a6bfc27597e, 0x231b2a6bfd27597e, 0x0000000000000018, 0x0 }, /* #41 */
    { 0x362312, 0x362313, 0xa9089122f5622ddf, 0xa9089122f5622d9f, 0x0000000000000006, 0x0 }, /* #42 */
    { 0x212217, 0x212216, 0x0f94c905cd45faee, 0x0f94d905cd45faee, 0x000000000000002c, 0x0 }, /* #43 */
    { 0x3a5bc3, 0x3a5bc3, 0xd4e95a6eeaaf277c, 0xd4e95a2eeaaf277c, 0x0000000000000026, 0x0 }, /* #44 */
    { 0x210256, 0x210256, 0x5cf4874efc2b7ce9, 0x5cf4874efe2b7ce9, 0x0000000000000019, 0x0 }, /* #45 */
    { 0x3b5113, 0x3b5113, 0x0dedc76d4f0eaeba, 0x0dedc76d4e0eaeba, 0x0000000000000018, 0x0 }, /* #46 */
    { 0x1b6646, 0x1b6646, 0x6e843894e58a7f98, 0x6e843894e58aff98, 0x000000000000000f, 0x0 }, /* #47 */
    { 0x1d6047, 0x1d6047, 0x53da13a2bcd294e9, 0x53da13a2bcd214e9, 0x000000000000000f, 0x0 }, /* #48 */
    { 0x284ad6, 0x284ad6, 0x14d1a664f38a46ae, 0x16d1a664f38a46ae, 0x0000000000000039, 0x0 }, /* #49 */
    { 0x1c3b86, 0x1c3b87, 0x069bc59cc88a769a, 0x069bc598c88a769a, 0x0000000000000022, 0x0 }, /* #50 */
    { 0x2c5c47, 0x2c5c47, 0x86aa9a18b558f9e5, 0x84aa9a18b558f9e5, 0x0000000000000039, 0x0 }, /* #51 */
    { 0x227597, 0x227597, 0x7e8756e23f6489b8, 0x7e8356e23f6489b8, 0x0000000000000032, 0x0 }, /* #52 */
    { 0x347dc3, 0x347dc2, 0xf31f74c725acc46f, 0xf31f74d725acc46f, 0x0000000000000024, 0x0 }, /* #53 */
    { 0x1e4d12, 0x1e4d12, 0x6705a34aa64a756e, 0x6715a34aa64a756e, 0x0000000000000034, 0x0 }, /* #54 */
    { 0x332597, 0x332596, 0x8264d4df895e054b, 0x8264d6df895e054b, 0x0000000000000029, 0x0 }, /* #55 */
    { 0x0b1803, 0x0b1802, 0x3e21dbbcd8bf4c34, 0x3e25dbbcd8bf4c34, 0x0000000000000032, 0x0 }, /* #56 */
    { 0x1e5296, 0x1e5297, 0x1f3407c1150b715d, 0x1b3407c1150b715d, 0x000000000000003a, 0x0 }, /* #57 */
    { 0x110bd3, 0x110bd2, 0x0c94cd1c0594f3fb, 0x0c94cd3c0594f3fb, 0x0000000000000025, 0x0 }, /* #58 */
    { 0x3f2c43, 0x3f2c42, 0x51f7c7ab654f91c5, 0x71f7c7ab654f91c5, 0x000000000000003d, 0x0 }, /* #59 */
    { 0x0d2a43, 0x0d2a42, 0x19453c23ddef64a8, 0x19453c23ddff64a8, 0x0000000000000014, 0x0 }, /* #60 */
    { 0x1050c6, 0x1050c7, 0xb9bf6cf7dff1c109, 0xb9bf6cf5dff1c109, 0x0000000000000021, 0x0 }, /* #61 */
    { 0x360353, 0x360352, 0xf1d5112e6d04262d, 0xf1d5152e6d04262d, 0x000000000000002a, 0x0 }, /* #62 */
    { 0x255c97, 0x255c96, 0xc9eb448b7494cdbe, 0xc9eb448b7494cfbe, 0x0000000000000009, 0x0 }, /* #63 */
    { 0x030bd7, 0x030bd7, 0xe768cd2cbc90b6b1, 0xe768cd2cbc80b6b1, 0x0000000000000014, 0x0 }, /* #64 */
    { 0x3f0ac2, 0x3f0ac3, 0xefcaece6d60409c3, 0xefcaece6d60401c3, 0x000000000000000b, 0x0 }, /* #65 */
    { 0x113a03, 0x113a03, 0x64f84f1bb465f059, 0x64f84b1bb465f059, 0x000000000000002a, 0x0 }, /* #66 */
    { 0x257203, 0x257203, 0xf82b47c68c71ebf4, 0xf82b47c68c71ebf0, 0x0000000000000002, 0x0 }, /* #67 */
    { 0x146ed3, 0x146ed3, 0x95ae5d120d0859d4, 0x91ae5d120d0859d4, 0x000000000000003a, 0x0 }, /* #68 */
    { 0x327347, 0x327347, 0xeb55f78bf02848bd, 0xeb55f78bf02848b5, 0x0000000000000003, 0x0 }, /* #69 */
    { 0x177112, 0x177112, 0x6754b327aeca4dfd, 0x6754b367aeca4dfd, 0x0000000000000026, 0x0 }, /* #70 */
    { 0x136106, 0x136106, 0x24cb4af84474e9e2, 0x26cb4af84474e9e2, 0x0000000000000039, 0x0 }, /* #71 */
    { 0x142b42, 0x142b42, 0x933a28102f70cdf9, 0x933a28102f70ddf9, 0x000000000000000c, 0x0 }, /* #72 */
    { 0x0422d3, 0x0422d2, 0xf740f493cf29ede3, 0xf740f493df29ede3, 0x000000000000001c, 0x0 }, /* #73 */
    { 0x1e0056, 0x1e0056, 0x72cec8f54ec04214, 0x72cec8f5cec04214, 0x000000000000001f, 0x0 }, /* #74 */
    { 0x3c6947, 0x3c6946, 0x03e90a41718c1938, 0x03e90a4171ac1938, 0x0000000000000015, 0x0 }, /* #75 */
    { 0x207542, 0x207542, 0x1e368bcb9dde241b, 0x1e36cbcb9dde241b, 0x000000000000002e, 0x0 }, /* #76 */
    { 0x1e3617, 0x1e3617, 0xc0bfe47ff55419d1, 0xc0bfe47ff55409d1, 0x000000000000000c, 0x0 }, /* #77 */
    { 0x2771c6, 0x2771c7, 0xae58a6e861ba49f6, 0xae58a6e841ba49f6, 0x000000000000001d, 0x0 }, /* #78 */
    { 0x2f2cd6, 0x2f2cd7, 0x029887442dd1fa07, 0x029887440dd1fa07, 0x000000000000001d, 0x0 }, /* #79 */
    { 0x030a43, 0x030a43, 0xae2814af7e9c160f, 0xae2814a77e9c160f, 0x0000000000000023, 0x0 }, /* #80 */
    { 0x1e0652, 0x1e0653, 0x01d7c7ac66d23a81, 0x01d7c7ac66523a81, 0x0000000000000017, 0x0 }, /* #81 */
    { 0x040357, 0x040356, 0x0599b7d041e58a56, 0x0599b7d041ed8a56, 0x0000000000000013, 0x0 }, /* #82 */
    { 0x0f0243, 0x0f0243, 0xb72922ae3c3d9017, 0xb72922aa3c3d9017, 0x0000000000000022, 0x0 }, /* #83 */
    { 0x3f5916, 0x3f5916, 0x07ac324c45ac39a5, 0x07ac32cc45ac39a5, 0x0000000000000027, 0x0 }, /* #84 */
    { 0x092e97, 0x092e97, 0x487349dc7d1040b5, 0x487349dc7d104035, 0x0000000000000007, 0x0 }, /* #85 */
    { 0x0c0803, 0x0c0803, 0xa83447cb68c7a171, 0xa83445cb68c7a171, 0x0000000000000029, 0x0 }, /* #86 */
    { 0x0139c3, 0x0139c3, 0x1b2c370c45f9fd31, 0x1b2c370845f9fd31, 0x0000000000000022, 0x0 }, /* #87 */
    { 0x157806, 0x157806, 0xf3aabebf3506c444, 0xf3aabebf3526c444, 0x0000000000000015, 0x0 }, /* #88 */
    { 0x1063c7, 0x1063c6, 0xa9c5ddc7bd526865, 0xb9c5ddc7bd526865, 0x000000000000003c, 0x0 }, /* #89 */
    { 0x015d86, 0x015d87, 0x401fbdcfd9b79a8c, 0x401fbdcfd9b7988c, 0x0000000000000009, 0x0 }, /* #90 */
    { 0x0c06c6, 0x0c06c6, 0xc1aa478870b47517, 0xc5aa478870b47517, 0x000000000000003a, 0x0 }, /* #91 */
    { 0x267052, 0x267053, 0x0987a75ebd290f32, 0x0987a75eb9290f32, 0x000000000000001a, 0x0 }, /* #92 */
    { 0x2121c2, 0x2121c2, 0x84f17dc760afd0f2, 0x84f17dc762afd0f2, 0x0000000000000019, 0x0 }, /* #93 */
    { 0x141f56, 0x141f57, 0x27b51d1cebeed9b0, 0x27b51d1cabeed9b0, 0x000000000000001e, 0x0 }, /* #94 */
    { 0x333703, 0x333703, 0xdbb995c08e0af17e, 0xdbb995c08c0af17e, 0x0000000000000019, 0x0 }, /* #95 */
};
uint32_t const g_cTests_btc_u64 = RT_ELEMENTS(g_aTests_btc_u64);

BINU64_TEST_T const g_aTests_btc_u64_locked[] =
{
    { 0x081413, 0x081412, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x092c87, 0x092c86, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x1f2783, 0x1f2782, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x235f53, 0x235f52, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x2e0056, 0x2e0056, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x3b5456, 0x3b5456, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x076a53, 0x076a53, 0x1695411f0f1ae683, 0x1695411f0f1ae682, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x2f0f17, 0x2f0f16, 0x6999d5a5d34eda2c, 0x6999d5a5d34eda2d, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x222693, 0x222692, 0x83a3c5a9fb817f70, 0x83a3c5a9fb817f71, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x395ad3, 0x395ad2, 0xf566839619b206cc, 0xf566839619b206cd, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x1d1292, 0x1d1293, 0x56fa877527db3e09, 0x56fa877527db3e08, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x392317, 0x392316, 0x6d9cac8b88b4f1f2, 0x6d9cac8b88b4f1f3, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x321b06, 0x321b06, 0x488b884bd7c6f09d, 0x498b884bd7c6f09d, 0x0000000000000038, 0x0 }, /* #12 */
    { 0x040bc3, 0x040bc2, 0xd54f9b0cf743e874, 0xd54f9b0cf743e974, 0x0000000000000008, 0x0 }, /* #13 */
    { 0x2a1412, 0x2a1412, 0x928a209739ef72ca, 0xb28a209739ef72ca, 0x000000000000003d, 0x0 }, /* #14 */
    { 0x3f2186, 0x3f2187, 0x348558dc87daf461, 0x348558dc875af461, 0x0000000000000017, 0x0 }, /* #15 */
    { 0x2a5702, 0x2a5702, 0x0802ebde49ec8020, 0x0802ebde49eca020, 0x000000000000000d, 0x0 }, /* #16 */
    { 0x251487, 0x251486, 0x69787cc9c04d26f0, 0x69787dc9c04d26f0, 0x0000000000000028, 0x0 }, /* #17 */
    { 0x3309c6, 0x3309c7, 0x7a3be4c81857ff8b, 0x7a33e4c81857ff8b, 0x0000000000000033, 0x0 }, /* #18 */
    { 0x3162d2, 0x3162d2, 0x3ca63de5ab23c352, 0x3ca63de5ab23c372, 0x0000000000000005, 0x0 }, /* #19 */
    { 0x3907c2, 0x3907c3, 0x95d0f65be1799ee1, 0x95d0f65ae1799ee1, 0x0000000000000020, 0x0 }, /* #20 */
    { 0x243596, 0x243596, 0xaa9c9aaf68d7f055, 0xaa9c9abf68d7f055, 0x0000000000000024, 0x0 }, /* #21 */
    { 0x2f1787, 0x2f1787, 0x2fa8d278716197ea, 0x2fa8d278716117ea, 0x000000000000000f, 0x0 }, /* #22 */
    { 0x1e32d2, 0x1e32d2, 0x9be08d470a24ce85, 0x9bf08d470a24ce85, 0x0000000000000034, 0x0 }, /* #23 */
    { 0x1844c3, 0x1844c3, 0xffe85b87e76b9e9d, 0xffe85b87e76b8e9d, 0x000000000000000c, 0x0 }, /* #24 */
    { 0x195316, 0x195316, 0x48a8e570f74352a6, 0x48a8e571f74352a6, 0x0000000000000020, 0x0 }, /* #25 */
    { 0x311c92, 0x311c92, 0x54afb7bc9d524174, 0x54afb7bc9d564174, 0x0000000000000012, 0x0 }, /* #26 */
    { 0x370b97, 0x370b96, 0xe43551413ba433b1, 0xe43551413ba433b3, 0x0000000000000001, 0x0 }, /* #27 */
    { 0x3d7856, 0x3d7856, 0x30dd08b9ac0d2a63, 0x30dd08b9ac0daa63, 0x000000000000000f, 0x0 }, /* #28 */
    { 0x234d57, 0x234d56, 0x829b5f8372dd0657, 0x829b5f83f2dd0657, 0x000000000000001f, 0x0 }, /* #29 */
    { 0x2d2d06, 0x2d2d06, 0xea5ce60165562cc0, 0xea5ce60165562dc0, 0x0000000000000008, 0x0 }, /* #30 */
    { 0x377382, 0x377383, 0x912b52b96faeb6d6, 0x912352b96faeb6d6, 0x0000000000000033, 0x0 }, /* #31 */
    { 0x335887, 0x335886, 0xe407750c757f8e28, 0xe407770c757f8e28, 0x0000000000000029, 0x0 }, /* #32 */
    { 0x303286, 0x303286, 0x3721a02e5cfd9c28, 0x3721a82e5cfd9c28, 0x000000000000002b, 0x0 }, /* #33 */
    { 0x3e3d97, 0x3e3d97, 0x6af69e50840ba0a6, 0x4af69e50840ba0a6, 0x000000000000003d, 0x0 }, /* #34 */
    { 0x172387, 0x172386, 0x33352a0e97e01961, 0x3335aa0e97e01961, 0x000000000000002f, 0x0 }, /* #35 */
    { 0x136a12, 0x136a12, 0x694689055923b9a9, 0x694689055923bda9, 0x000000000000000a, 0x0 }, /* #36 */
    { 0x106046, 0x106046, 0x5991f4cb6061d73a, 0x5991f4cb6071d73a, 0x0000000000000014, 0x0 }, /* #37 */
    { 0x3e0b93, 0x3e0b92, 0xaf16db5316533f60, 0xaf36db5316533f60, 0x0000000000000035, 0x0 }, /* #38 */
    { 0x333e87, 0x333e87, 0xeb495af2e7b3d398, 0xeb495af2e7b3d198, 0x0000000000000009, 0x0 }, /* #39 */
    { 0x3f1216, 0x3f1216, 0x594bc6326efa1323, 0x594fc6326efa1323, 0x0000000000000032, 0x0 }, /* #40 */
    { 0x197fc6, 0x197fc6, 0x3afeef685d354e4b, 0x3bfeef685d354e4b, 0x0000000000000038, 0x0 }, /* #41 */
    { 0x3f6087, 0x3f6087, 0xf9bf7003cc935b0a, 0xf9bf7003cc935b02, 0x0000000000000003, 0x0 }, /* #42 */
    { 0x385f42, 0x385f42, 0x2648a5419d9fcdd6, 0x2648a7419d9fcdd6, 0x0000000000000029, 0x0 }, /* #43 */
    { 0x352e42, 0x352e43, 0x6d057555a16aca62, 0x6d057545a16aca62, 0x0000000000000024, 0x0 }, /* #44 */
    { 0x227d12, 0x227d12, 0xd1d041bf83e7fdbe, 0xd1d241bf83e7fdbe, 0x0000000000000031, 0x0 }, /* #45 */
    { 0x300d47, 0x300d47, 0x11d22ab38fc58075, 0x11d22ab38fc58065, 0x0000000000000004, 0x0 }, /* #46 */
    { 0x2076d6, 0x2076d7, 0x72be845d0e9e511f, 0x72be805d0e9e511f, 0x000000000000002a, 0x0 }, /* #47 */
    { 0x031916, 0x031916, 0xc5507b79fbcecde1, 0xc5507b79fbeecde1, 0x0000000000000015, 0x0 }, /* #48 */
    { 0x203f82, 0x203f82, 0xb30949df016af9ab, 0xb30949df017af9ab, 0x0000000000000014, 0x0 }, /* #49 */
    { 0x192c53, 0x192c52, 0x28161ebff8d8dc90, 0x28161ebff8d8dcb0, 0x0000000000000005, 0x0 }, /* #50 */
    { 0x040ec3, 0x040ec3, 0xdc3442856aa9779a, 0xdc3442856aa8779a, 0x0000000000000010, 0x0 }, /* #51 */
    { 0x3d6117, 0x3d6117, 0xf63da79bfa9f053e, 0xf63da79bfa9f051e, 0x0000000000000005, 0x0 }, /* #52 */
    { 0x317652, 0x317653, 0xadacb95475583ee3, 0xadacb95475183ee3, 0x0000000000000016, 0x0 }, /* #53 */
    { 0x3d3212, 0x3d3212, 0xd1cb71988741b590, 0xd1cb7198a741b590, 0x000000000000001d, 0x0 }, /* #54 */
    { 0x3d6047, 0x3d6047, 0x0679861b526662ae, 0x0679861b524662ae, 0x0000000000000015, 0x0 }, /* #55 */
    { 0x056412, 0x056412, 0x5a2ff4b30befbe4b, 0xda2ff4b30befbe4b, 0x000000000000003f, 0x0 }, /* #56 */
    { 0x101a46, 0x101a46, 0x6703aec95d929e0e, 0x6703aec9dd929e0e, 0x000000000000001f, 0x0 }, /* #57 */
    { 0x0874d3, 0x0874d2, 0x7c5a0e898adf33b7, 0x7d5a0e898adf33b7, 0x0000000000000038, 0x0 }, /* #58 */
    { 0x097e53, 0x097e53, 0xd604a6130227ff1e, 0xd604a6130227ff1c, 0x0000000000000001, 0x0 }, /* #59 */
    { 0x346c93, 0x346c93, 0x92bd01a2d396869b, 0x90bd01a2d396869b, 0x0000000000000039, 0x0 }, /* #60 */
    { 0x2a6ad3, 0x2a6ad2, 0xe620f522c652dd73, 0xe720f522c652dd73, 0x0000000000000038, 0x0 }, /* #61 */
    { 0x3c5c83, 0x3c5c82, 0x8b4138a64798eff1, 0x8b4138a64799eff1, 0x0000000000000010, 0x0 }, /* #62 */
    { 0x102283, 0x102283, 0xdda563fe4b5a2930, 0xdca563fe4b5a2930, 0x0000000000000038, 0x0 }, /* #63 */
    { 0x053046, 0x053047, 0x878931c85b3ecfa5, 0x878931c85b3ecea5, 0x0000000000000008, 0x0 }, /* #64 */
    { 0x2e1793, 0x2e1792, 0x6c26f09bdc3a04ec, 0x6c36f09bdc3a04ec, 0x0000000000000034, 0x0 }, /* #65 */
    { 0x046a06, 0x046a06, 0x9f11bca48d031289, 0x9f11bca48d033289, 0x000000000000000d, 0x0 }, /* #66 */
    { 0x0e0403, 0x0e0403, 0x0f0d6f8d78dc4815, 0x0f0d4f8d78dc4815, 0x000000000000002d, 0x0 }, /* #67 */
    { 0x232916, 0x232917, 0xbc4c416572d61108, 0xbc4c416572c61108, 0x0000000000000014, 0x0 }, /* #68 */
    { 0x187703, 0x187703, 0xcd67135ef627f59d, 0xcd67135ef627d59d, 0x000000000000000d, 0x0 }, /* #69 */
    { 0x390d07, 0x390d07, 0x929dd79654cb46f1, 0x929d579654cb46f1, 0x000000000000002f, 0x0 }, /* #70 */
    { 0x054cc2, 0x054cc3, 0xecd403d1a73d79d2, 0xecd403d1a73c79d2, 0x0000000000000010, 0x0 }, /* #71 */
    { 0x256a96, 0x256a97, 0x4c19dd46b36e0d63, 0x4c19dd46b36e0d62, 0x0000000000000000, 0x0 }, /* #72 */
    { 0x131e02, 0x131e02, 0xb1028dff87a9660a, 0xb1428dff87a9660a, 0x0000000000000036, 0x0 }, /* #73 */
    { 0x1c7846, 0x1c7846, 0xab4067eb94164e18, 0xab4067eb9c164e18, 0x000000000000001b, 0x0 }, /* #74 */
    { 0x061e56, 0x061e56, 0xbb849552647b78db, 0xbf849552647b78db, 0x000000000000003a, 0x0 }, /* #75 */
    { 0x0267c7, 0x0267c7, 0x8f512b632c9b605c, 0x8f512b632c8b605c, 0x0000000000000014, 0x0 }, /* #76 */
    { 0x280e82, 0x280e83, 0xa0fca453b3f5c417, 0xa0fca413b3f5c417, 0x0000000000000026, 0x0 }, /* #77 */
    { 0x315a16, 0x315a17, 0xb9f0e3f6fed6fd62, 0xb9f0e3f4fed6fd62, 0x0000000000000021, 0x0 }, /* #78 */
    { 0x174086, 0x174086, 0x4d742b181f6faa31, 0x4d742b181f6fba31, 0x000000000000000c, 0x0 }, /* #79 */
    { 0x3009c6, 0x3009c7, 0x23a163147e383e5a, 0x22a163147e383e5a, 0x0000000000000038, 0x0 }, /* #80 */
    { 0x135153, 0x135153, 0x553de3d2115a4fa7, 0x553de3d2111a4fa7, 0x0000000000000016, 0x0 }, /* #81 */
    { 0x120943, 0x120942, 0x14120a8863e526d5, 0x14122a8863e526d5, 0x000000000000002d, 0x0 }, /* #82 */
    { 0x2b0b03, 0x2b0b02, 0x1cff3a81f6608c66, 0x1cff3ac1f6608c66, 0x0000000000000026, 0x0 }, /* #83 */
    { 0x012892, 0x012893, 0x0375c664e5fb0123, 0x0375c664e5fb0121, 0x0000000000000001, 0x0 }, /* #84 */
    { 0x0d3206, 0x0d3206, 0x82ab98a5ef9cf8c3, 0x82abb8a5ef9cf8c3, 0x000000000000002d, 0x0 }, /* #85 */
    { 0x2a46d3, 0x2a46d3, 0x6aede5e6172f4ffc, 0x6aede5e6172d4ffc, 0x0000000000000011, 0x0 }, /* #86 */
    { 0x0e0e47, 0x0e0e47, 0x40ae974b2ceb693c, 0x40ae974b0ceb693c, 0x000000000000001d, 0x0 }, /* #87 */
    { 0x363bc3, 0x363bc3, 0xf1f42a8dce67b6d4, 0xf1d42a8dce67b6d4, 0x0000000000000035, 0x0 }, /* #88 */
    { 0x3a3e02, 0x3a3e02, 0x839a2c861863d5fe, 0x839a2c861863d5ff, 0x0000000000000000, 0x0 }, /* #89 */
    { 0x335447, 0x335447, 0xea0b42c63b581e0e, 0xea0942c63b581e0e, 0x0000000000000031, 0x0 }, /* #90 */
    { 0x131c87, 0x131c87, 0x6a4e4d41568fd5e4, 0x6a4e4d40568fd5e4, 0x0000000000000020, 0x0 }, /* #91 */
    { 0x171157, 0x171156, 0xf5da56e019db026c, 0xf5da5ee019db026c, 0x000000000000002b, 0x0 }, /* #92 */
    { 0x0d0797, 0x0d0796, 0x4c96d742f07fdf47, 0x4c96d742f0ffdf47, 0x0000000000000017, 0x0 }, /* #93 */
    { 0x104ec6, 0x104ec6, 0xed28b1707c2a7fdb, 0xed28b9707c2a7fdb, 0x000000000000002b, 0x0 }, /* #94 */
    { 0x176d43, 0x176d43, 0x87d9fd03f0bfdd49, 0x87d9fd03f0bddd49, 0x0000000000000011, 0x0 }, /* #95 */
};
uint32_t const g_cTests_btc_u64_locked = RT_ELEMENTS(g_aTests_btc_u64_locked);

BINU64_TEST_T const g_aTests_btr_u64[] =
{
    { 0x370c06, 0x370c06, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x004302, 0x004302, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x2340d6, 0x2340d6, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x3f5a82, 0x3f5a82, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x147c16, 0x147c16, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x132457, 0x132456, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x236597, 0x236597, 0xfce9d977bcb4644f, 0xfce9d977bcb4644e, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x366886, 0x366886, 0x076f3958b7b1d696, 0x076f3958b7b1d696, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x2e4386, 0x2e4386, 0x3f0fa0756a1aa344, 0x3f0fa0756a1aa344, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x0170c7, 0x0170c6, 0xfe7626c52a7e41ae, 0xfe7626c52a7e41ae, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x2d5dd3, 0x2d5dd3, 0x8bea387f1264cbb9, 0x8bea387f1264cbb8, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x384206, 0x384206, 0xccf80e56e9216262, 0xccf80e56e9216262, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x026583, 0x026583, 0x3015bd5355eaf4d5, 0x3015bd5355eaf455, 0x0000000000000007, 0x0 }, /* #12 */
    { 0x206256, 0x206257, 0x59659cce33405f49, 0x59659cce33405f48, 0x0000000000000000, 0x0 }, /* #13 */
    { 0x2e2b56, 0x2e2b56, 0x4909c266b8fc4879, 0x4909c266b8fc4879, 0x000000000000002d, 0x0 }, /* #14 */
    { 0x302e52, 0x302e53, 0xfcf5c40f24d94a3b, 0xfcf5c40f24d94a39, 0x0000000000000001, 0x0 }, /* #15 */
    { 0x1c5d13, 0x1c5d12, 0x6191092c39cbcdb2, 0x6191092c39cbcdb2, 0x000000000000002a, 0x0 }, /* #16 */
    { 0x2e2742, 0x2e2742, 0x55f6f7b0e53f5969, 0x55f6f7b0e53f5969, 0x000000000000003f, 0x0 }, /* #17 */
    { 0x1377c6, 0x1377c7, 0x97b179e5c2d51846, 0x97b179e5c0d51846, 0x0000000000000019, 0x0 }, /* #18 */
    { 0x236fc6, 0x236fc6, 0xc47fcb30785f2859, 0xc47fcb30785f2859, 0x000000000000001a, 0x0 }, /* #19 */
    { 0x383203, 0x383203, 0xe7c4ede363a3cc40, 0x67c4ede363a3cc40, 0x000000000000003f, 0x0 }, /* #20 */
    { 0x3055c6, 0x3055c7, 0x8b587964c7d2f891, 0x8b58796487d2f891, 0x000000000000001e, 0x0 }, /* #21 */
    { 0x160b87, 0x160b87, 0xc70b142baea979a6, 0xc70b142baea97926, 0x0000000000000007, 0x0 }, /* #22 */
    { 0x362cd6, 0x362cd6, 0x81c54ad5219e3e40, 0x81c54ad5219e3e40, 0x0000000000000021, 0x0 }, /* #23 */
    { 0x324d07, 0x324d06, 0x29d4997fbf86b7e2, 0x29d4997fbf86b7e2, 0x0000000000000027, 0x0 }, /* #24 */
    { 0x3e5412, 0x3e5412, 0xd5f745e7de0aa04b, 0xd5f745e7de0aa04b, 0x000000000000002b, 0x0 }, /* #25 */
    { 0x1b0617, 0x1b0616, 0xd76a5e4c3ff504ab, 0xd76a5e4c3ff504ab, 0x000000000000000f, 0x0 }, /* #26 */
    { 0x305356, 0x305357, 0xcb4fe98061f0466e, 0x4b4fe98061f0466e, 0x000000000000003f, 0x0 }, /* #27 */
    { 0x0e7d07, 0x0e7d06, 0xdd200953eee2693b, 0xdd200953eee2693b, 0x0000000000000031, 0x0 }, /* #28 */
    { 0x2429c3, 0x2429c2, 0xf81b71f8717e1725, 0xf81b71f8717e1725, 0x0000000000000037, 0x0 }, /* #29 */
    { 0x266f13, 0x266f13, 0x75d8deeeae35cb75, 0x75d8deeeae15cb75, 0x0000000000000015, 0x0 }, /* #30 */
    { 0x272753, 0x272752, 0xbd503391661af260, 0xbd503391661af260, 0x0000000000000002, 0x0 }, /* #31 */
    { 0x2a4252, 0x2a4253, 0xdfc16a08e26be68d, 0xdfc16a08e26be68c, 0x0000000000000000, 0x0 }, /* #32 */
    { 0x267dd7, 0x267dd7, 0x5b04fb319572864d, 0x5b04fa319572864d, 0x0000000000000028, 0x0 }, /* #33 */
    { 0x1b7856, 0x1b7857, 0xf553d2c39d77318f, 0xf55392c39d77318f, 0x000000000000002e, 0x0 }, /* #34 */
    { 0x0a12c3, 0x0a12c3, 0x4fd46d968b3d7ad6, 0x4fd46d960b3d7ad6, 0x000000000000001f, 0x0 }, /* #35 */
    { 0x235f93, 0x235f92, 0xa7d295abfee7c46a, 0xa7d295abfee7c46a, 0x0000000000000024, 0x0 }, /* #36 */
    { 0x050743, 0x050743, 0xaf552733e356c51d, 0xaf552733c356c51d, 0x000000000000001d, 0x0 }, /* #37 */
    { 0x150cc2, 0x150cc3, 0xf9591e80eba146ab, 0xf9591e80eba142ab, 0x000000000000000a, 0x0 }, /* #38 */
    { 0x162ac2, 0x162ac3, 0xb1fe03e4b3439c6f, 0xb17e03e4b3439c6f, 0x0000000000000037, 0x0 }, /* #39 */
    { 0x1a5517, 0x1a5516, 0xd3bc921ec78e64f2, 0xd3bc921ec78e64f2, 0x000000000000001d, 0x0 }, /* #40 */
    { 0x2a3c46, 0x2a3c47, 0x569f18aca67bc3ce, 0x569f18ac267bc3ce, 0x000000000000001f, 0x0 }, /* #41 */
    { 0x0a1516, 0x0a1516, 0x11bf6ce671952d29, 0x11bf6ce671952d29, 0x0000000000000029, 0x0 }, /* #42 */
    { 0x012882, 0x012882, 0x4d6f099034aa6a1b, 0x4d6f099034aa6a1b, 0x0000000000000019, 0x0 }, /* #43 */
    { 0x015c13, 0x015c13, 0xbd7295618456247d, 0xb97295618456247d, 0x000000000000003a, 0x0 }, /* #44 */
    { 0x277bd7, 0x277bd7, 0x0ab6fd52ebaffe32, 0x0ab6fd52ebadfe32, 0x0000000000000011, 0x0 }, /* #45 */
    { 0x0f5497, 0x0f5497, 0xfed13d7fd25d8ec7, 0xfed13d7fd21d8ec7, 0x0000000000000016, 0x0 }, /* #46 */
    { 0x150a97, 0x150a96, 0xdd5c25fc9d6adfaa, 0xdd5c25fc9d6adfaa, 0x0000000000000029, 0x0 }, /* #47 */
    { 0x221f82, 0x221f82, 0xbd06e6340b576db5, 0xbd06e6340b576db5, 0x0000000000000028, 0x0 }, /* #48 */
    { 0x243d56, 0x243d57, 0x2af3759bd23d5ddf, 0x2af3759ad23d5ddf, 0x0000000000000020, 0x0 }, /* #49 */
    { 0x3567c7, 0x3567c6, 0x485c16efa4083f4e, 0x485c16efa4083f4e, 0x0000000000000014, 0x0 }, /* #50 */
    { 0x2a1393, 0x2a1392, 0x1db5ccda5048c7ef, 0x1db5ccda5048c7ef, 0x0000000000000015, 0x0 }, /* #51 */
    { 0x3165c6, 0x3165c7, 0x806fcb1b2ee07b93, 0x806fcb1b2ea07b93, 0x0000000000000016, 0x0 }, /* #52 */
    { 0x0f1092, 0x0f1092, 0xa9bf149ac862ae52, 0xa9bf149ac862ae52, 0x0000000000000019, 0x0 }, /* #53 */
    { 0x1f7392, 0x1f7392, 0x37e4c764d09713f1, 0x37e4c764d09713f1, 0x0000000000000016, 0x0 }, /* #54 */
    { 0x353e16, 0x353e16, 0xa0aea8f2feef1576, 0xa0aea8f2feef1576, 0x000000000000003b, 0x0 }, /* #55 */
    { 0x1010d6, 0x1010d7, 0x322cc6818d066ccf, 0x3224c6818d066ccf, 0x0000000000000033, 0x0 }, /* #56 */
    { 0x1d2d12, 0x1d2d12, 0xf9875507502eb633, 0xf9875507502eb633, 0x000000000000000e, 0x0 }, /* #57 */
    { 0x3e5912, 0x3e5913, 0x708d6cbf588adf81, 0x708d4cbf588adf81, 0x000000000000002d, 0x0 }, /* #58 */
    { 0x351e47, 0x351e47, 0xa8d2d52bb3af6ad9, 0xa8d2d50bb3af6ad9, 0x0000000000000025, 0x0 }, /* #59 */
    { 0x2230c7, 0x2230c6, 0x73c502471d92884d, 0x73c502471d92884d, 0x0000000000000012, 0x0 }, /* #60 */
    { 0x2b2087, 0x2b2087, 0xc867be518d62bdd9, 0xc067be518d62bdd9, 0x000000000000003b, 0x0 }, /* #61 */
    { 0x1b1016, 0x1b1016, 0xe232aa0b091e727e, 0xe232aa0b091e727e, 0x000000000000001e, 0x0 }, /* #62 */
    { 0x2e4083, 0x2e4083, 0x68b67c2cafae1098, 0x68b47c2cafae1098, 0x0000000000000031, 0x0 }, /* #63 */
    { 0x032942, 0x032942, 0xdaf2aeb052895cfa, 0xdaf2aeb052895cfa, 0x000000000000002e, 0x0 }, /* #64 */
    { 0x2c4dc6, 0x2c4dc7, 0x9a84db7b7cc606bf, 0x9a84db7b7cc6069f, 0x0000000000000005, 0x0 }, /* #65 */
    { 0x2228d3, 0x2228d2, 0x92463e4787e6b1ad, 0x92463e4787e6b1ad, 0x000000000000001e, 0x0 }, /* #66 */
    { 0x151c86, 0x151c87, 0x25b162769fc70477, 0x25b162749fc70477, 0x0000000000000021, 0x0 }, /* #67 */
    { 0x315807, 0x315807, 0x72fcacd64d5f900e, 0x72fcacd64d5f800e, 0x000000000000000c, 0x0 }, /* #68 */
    { 0x372e52, 0x372e52, 0x5823523d011a6c61, 0x5823523d011a6c61, 0x0000000000000012, 0x0 }, /* #69 */
    { 0x303617, 0x303616, 0x0bd0a264b4504921, 0x0bd0a264b4504921, 0x000000000000001e, 0x0 }, /* #70 */
    { 0x140247, 0x140247, 0x793ea0796e126c8d, 0x793ca0796e126c8d, 0x0000000000000031, 0x0 }, /* #71 */
    { 0x1104c3, 0x1104c3, 0xea8e10e685d482b2, 0xea8e10e685d480b2, 0x0000000000000009, 0x0 }, /* #72 */
    { 0x151d46, 0x151d46, 0x045aea4e0416699c, 0x045aea4e0416699c, 0x0000000000000015, 0x0 }, /* #73 */
    { 0x091f02, 0x091f02, 0xfb5b89e5acf7d8e6, 0xfb5b89e5acf7d8e6, 0x000000000000001c, 0x0 }, /* #74 */
    { 0x235416, 0x235416, 0x82068fb2afa263ac, 0x82068fb2afa263ac, 0x0000000000000023, 0x0 }, /* #75 */
    { 0x246113, 0x246112, 0xb745ae88a23c1d67, 0xb745ae88a23c1d67, 0x0000000000000024, 0x0 }, /* #76 */
    { 0x1f2e87, 0x1f2e87, 0xf8662af7074998c0, 0xf8662af7074918c0, 0x000000000000000f, 0x0 }, /* #77 */
    { 0x274087, 0x274086, 0x3ddd8d8d316cfb14, 0x3ddd8d8d316cfb14, 0x0000000000000014, 0x0 }, /* #78 */
    { 0x246403, 0x246402, 0x5619383f9dec6009, 0x5619383f9dec6009, 0x0000000000000014, 0x0 }, /* #79 */
    { 0x3d3497, 0x3d3496, 0xef767ec9d2389c3a, 0xef767ec9d2389c3a, 0x000000000000000d, 0x0 }, /* #80 */
    { 0x271016, 0x271017, 0xadd3a8f6fb3116cf, 0xadd3a8f2fb3116cf, 0x0000000000000022, 0x0 }, /* #81 */
    { 0x2145c3, 0x2145c3, 0x1ade41cf4e20b3a8, 0x12de41cf4e20b3a8, 0x000000000000003b, 0x0 }, /* #82 */
    { 0x155307, 0x155306, 0xd2d09e3fafb7ff67, 0xd2d09e3fafb7ff67, 0x0000000000000007, 0x0 }, /* #83 */
    { 0x345107, 0x345107, 0x69aa87acbbcf1598, 0x69aa87acb9cf1598, 0x0000000000000019, 0x0 }, /* #84 */
    { 0x200c16, 0x200c16, 0x93dd182800e0028e, 0x93dd182800e0028e, 0x0000000000000004, 0x0 }, /* #85 */
    { 0x356017, 0x356017, 0x1dd58804e2d8505b, 0x1dd58804e2d8504b, 0x0000000000000004, 0x0 }, /* #86 */
    { 0x204606, 0x204607, 0xd1c067111e474e23, 0xd1c067111c474e23, 0x0000000000000019, 0x0 }, /* #87 */
    { 0x134716, 0x134717, 0xcdb8d5e524701f6c, 0xcdb8d5e524301f6c, 0x0000000000000016, 0x0 }, /* #88 */
    { 0x3f1e06, 0x3f1e06, 0xae172de93b96e9c8, 0xae172de93b96e9c8, 0x0000000000000015, 0x0 }, /* #89 */
    { 0x3b5fc3, 0x3b5fc3, 0x7e0c4b3dd2f12b91, 0x7e0c4b3cd2f12b91, 0x0000000000000020, 0x0 }, /* #90 */
    { 0x160046, 0x160046, 0xb6aa030d4721a797, 0xb6aa030d4721a797, 0x000000000000000e, 0x0 }, /* #91 */
    { 0x3b1882, 0x3b1882, 0x645830e7fb15b43b, 0x645830e7fb15b43b, 0x0000000000000029, 0x0 }, /* #92 */
    { 0x1268c2, 0x1268c2, 0x8e1edf7598806cb0, 0x8e1edf7598806cb0, 0x0000000000000037, 0x0 }, /* #93 */
    { 0x1e6613, 0x1e6612, 0xc4820d8d807f8b9d, 0xc4820d8d807f8b9d, 0x000000000000001e, 0x0 }, /* #94 */
    { 0x3b46c7, 0x3b46c6, 0x9da4758566a68d3c, 0x9da4758566a68d3c, 0x0000000000000031, 0x0 }, /* #95 */
};
uint32_t const g_cTests_btr_u64 = RT_ELEMENTS(g_aTests_btr_u64);

BINU64_TEST_T const g_aTests_btr_u64_locked[] =
{
    { 0x1d0e42, 0x1d0e42, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x326016, 0x326016, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x0a7492, 0x0a7492, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x247c96, 0x247c96, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x1c2b12, 0x1c2b12, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x380e57, 0x380e56, 0x0000000000000000, 0x0000000000000000, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x175703, 0x175702, 0x4b8cad899d7a254c, 0x4b8cad899d7a254c, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x3970c7, 0x3970c6, 0xf9b4506a192713fc, 0xf9b4506a192713fc, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x073ac3, 0x073ac2, 0x9dfce2bcbf048bf8, 0x9dfce2bcbf048bf8, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x0a4557, 0x0a4556, 0x1fa57f013475e7b6, 0x1fa57f013475e7b6, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x302612, 0x302612, 0x28bbb0cd2a456226, 0x28bbb0cd2a456226, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x176b82, 0x176b83, 0x88979a32b252e1f7, 0x88979a32b252e1f6, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x0250d7, 0x0250d7, 0xae7226698281c06a, 0xae7226298281c06a, 0x0000000000000026, 0x0 }, /* #12 */
    { 0x0813d6, 0x0813d6, 0xe915b9aaa19dce0a, 0xe915b9aaa19dce0a, 0x0000000000000011, 0x0 }, /* #13 */
    { 0x137116, 0x137116, 0xceba4be5df5f907c, 0xceba4be5df5f907c, 0x0000000000000001, 0x0 }, /* #14 */
    { 0x284e83, 0x284e82, 0x0cfb468ea77286e2, 0x0cfb468ea77286e2, 0x000000000000001c, 0x0 }, /* #15 */
    { 0x260ad3, 0x260ad3, 0xbbea188002efe76d, 0xbbea188002ef676d, 0x000000000000000f, 0x0 }, /* #16 */
    { 0x033316, 0x033317, 0xde50fe18fe710186, 0xde10fe18fe710186, 0x0000000000000036, 0x0 }, /* #17 */
    { 0x015c02, 0x015c03, 0xde2055b832d3478e, 0xde2055b032d3478e, 0x0000000000000023, 0x0 }, /* #18 */
    { 0x0c0ec2, 0x0c0ec2, 0x6351dea3a2b85e0e, 0x6351dea3a2b85e0e, 0x0000000000000033, 0x0 }, /* #19 */
    { 0x2c1c07, 0x2c1c06, 0xd114591b38f28fd3, 0xd114591b38f28fd3, 0x000000000000003a, 0x0 }, /* #20 */
    { 0x1f1e46, 0x1f1e47, 0x27d9cb699d11db32, 0x27d9c3699d11db32, 0x000000000000002b, 0x0 }, /* #21 */
    { 0x1b4012, 0x1b4013, 0x9b6ca6f5dac869e6, 0x9b6ca6f5dac829e6, 0x000000000000000e, 0x0 }, /* #22 */
    { 0x1a7906, 0x1a7906, 0x7eac71e84ebdfe0b, 0x7eac71e84ebdfe0b, 0x000000000000001d, 0x0 }, /* #23 */
    { 0x3f5c83, 0x3f5c82, 0xd76e721414ef3d74, 0xd76e721414ef3d74, 0x0000000000000030, 0x0 }, /* #24 */
    { 0x0a5b06, 0x0a5b07, 0x5d99292c06cd4db1, 0x5d99292c06cd4db0, 0x0000000000000000, 0x0 }, /* #25 */
    { 0x235b97, 0x235b96, 0x904d2c6c95bfef58, 0x904d2c6c95bfef58, 0x0000000000000027, 0x0 }, /* #26 */
    { 0x240952, 0x240953, 0x188daca4ce3d0d15, 0x188daca4ca3d0d15, 0x000000000000001a, 0x0 }, /* #27 */
    { 0x2537d2, 0x2537d3, 0xe28e8953c80e9f8d, 0xe28e0953c80e9f8d, 0x000000000000002f, 0x0 }, /* #28 */
    { 0x2049c6, 0x2049c6, 0x5880b6f3f2037c34, 0x5880b6f3f2037c34, 0x000000000000002b, 0x0 }, /* #29 */
    { 0x266e86, 0x266e87, 0xe8349ea99411d7bb, 0xe8349e299411d7bb, 0x0000000000000027, 0x0 }, /* #30 */
    { 0x3d3e86, 0x3d3e87, 0xecf60e92039989a9, 0xecf60e82039989a9, 0x0000000000000024, 0x0 }, /* #31 */
    { 0x3f6957, 0x3f6957, 0xadc17168296f20dd, 0x8dc17168296f20dd, 0x000000000000003d, 0x0 }, /* #32 */
    { 0x152a86, 0x152a86, 0x020fd0f7745431c6, 0x020fd0f7745431c6, 0x000000000000001b, 0x0 }, /* #33 */
    { 0x131f57, 0x131f57, 0xc4e88e25a9322dfe, 0xc4e88e25a9322dbe, 0x0000000000000006, 0x0 }, /* #34 */
    { 0x1d5553, 0x1d5552, 0x180f1eea10004dfc, 0x180f1eea10004dfc, 0x000000000000003d, 0x0 }, /* #35 */
    { 0x055646, 0x055647, 0x87fffd90a426b4b4, 0x87fffd90a42634b4, 0x000000000000000f, 0x0 }, /* #36 */
    { 0x206ad2, 0x206ad3, 0x24040138822e28a4, 0x24040138822e28a0, 0x0000000000000002, 0x0 }, /* #37 */
    { 0x313dc7, 0x313dc7, 0xb96140ed7081100a, 0xb96140ed7080100a, 0x0000000000000010, 0x0 }, /* #38 */
    { 0x373f97, 0x373f97, 0x1847e0fbeeddb196, 0x1047e0fbeeddb196, 0x000000000000003b, 0x0 }, /* #39 */
    { 0x275e43, 0x275e43, 0x210243fc1575f06f, 0x210243f81575f06f, 0x0000000000000022, 0x0 }, /* #40 */
    { 0x0c3207, 0x0c3206, 0x81c4fb3df6ad7d64, 0x81c4fb3df6ad7d64, 0x0000000000000004, 0x0 }, /* #41 */
    { 0x1e5947, 0x1e5946, 0x218b963669c97de5, 0x218b963669c97de5, 0x0000000000000004, 0x0 }, /* #42 */
    { 0x374616, 0x374616, 0x8690c4ef57950fdd, 0x8690c4ef57950fdd, 0x000000000000002b, 0x0 }, /* #43 */
    { 0x113ad3, 0x113ad2, 0x51ce1b1c42dc3e77, 0x51ce1b1c42dc3e77, 0x000000000000001b, 0x0 }, /* #44 */
    { 0x161f16, 0x161f16, 0x71b2594d228b97ac, 0x71b2594d228b97ac, 0x0000000000000021, 0x0 }, /* #45 */
    { 0x2e2e02, 0x2e2e02, 0xc42376a67ed3fdac, 0xc42376a67ed3fdac, 0x0000000000000015, 0x0 }, /* #46 */
    { 0x217e87, 0x217e87, 0xa4636ddc4eb2894b, 0xa4636ddc4eb28949, 0x0000000000000001, 0x0 }, /* #47 */
    { 0x343286, 0x343287, 0xdd4dc55d6c665962, 0xdd4dc55d64665962, 0x000000000000001b, 0x0 }, /* #48 */
    { 0x152986, 0x152986, 0x2673a605dfe1c95c, 0x2673a605dfe1c95c, 0x000000000000000d, 0x0 }, /* #49 */
    { 0x374e57, 0x374e56, 0x4db38abccca1be59, 0x4db38abccca1be59, 0x0000000000000018, 0x0 }, /* #50 */
    { 0x3e0e57, 0x3e0e56, 0x67034644fa083b2e, 0x67034644fa083b2e, 0x000000000000000e, 0x0 }, /* #51 */
    { 0x1b5457, 0x1b5457, 0xa958e79478a38a9e, 0xa958e79478a28a9e, 0x0000000000000010, 0x0 }, /* #52 */
    { 0x1e0343, 0x1e0342, 0xf384c90c0cb728ae, 0xf384c90c0cb728ae, 0x000000000000000a, 0x0 }, /* #53 */
    { 0x184fd7, 0x184fd7, 0xbf3d93c794e98f3f, 0xbf3d93c794e90f3f, 0x000000000000000f, 0x0 }, /* #54 */
    { 0x0f5d03, 0x0f5d03, 0x9992990b6569635b, 0x9992990b2569635b, 0x000000000000001e, 0x0 }, /* #55 */
    { 0x192793, 0x192793, 0xd62bd31d875f43df, 0xd62bd31d875f41df, 0x0000000000000009, 0x0 }, /* #56 */
    { 0x3d4987, 0x3d4986, 0x050cd026df5c83e1, 0x050cd026df5c83e1, 0x000000000000003d, 0x0 }, /* #57 */
    { 0x151112, 0x151113, 0xe07e58d4aa448947, 0xe07a58d4aa448947, 0x0000000000000032, 0x0 }, /* #58 */
    { 0x1b47c7, 0x1b47c7, 0x2cd85009589d7c40, 0x28d85009589d7c40, 0x000000000000003a, 0x0 }, /* #59 */
    { 0x247983, 0x247982, 0x9e5fbf7745dee9f5, 0x9e5fbf7745dee9f5, 0x000000000000003d, 0x0 }, /* #60 */
    { 0x273913, 0x273912, 0x35fad42df85405c9, 0x35fad42df85405c9, 0x000000000000000b, 0x0 }, /* #61 */
    { 0x033992, 0x033992, 0xdd642f61c9e506ea, 0xdd642f61c9e506ea, 0x000000000000001a, 0x0 }, /* #62 */
    { 0x066447, 0x066446, 0xaffa70c27566f725, 0xaffa70c27566f725, 0x000000000000001b, 0x0 }, /* #63 */
    { 0x172bd2, 0x172bd3, 0x1777bda712e12300, 0x1777bda312e12300, 0x0000000000000022, 0x0 }, /* #64 */
    { 0x0b6182, 0x0b6183, 0xd16129f06a3a7731, 0xd16129f04a3a7731, 0x000000000000001d, 0x0 }, /* #65 */
    { 0x1405d2, 0x1405d2, 0x5e2bf4c50bc25eb8, 0x5e2bf4c50bc25eb8, 0x0000000000000025, 0x0 }, /* #66 */
    { 0x2b48c3, 0x2b48c2, 0x48e1c004a2bef2f3, 0x48e1c004a2bef2f3, 0x000000000000003f, 0x0 }, /* #67 */
    { 0x2c2752, 0x2c2752, 0x0922d40d9a7eed86, 0x0922d40d9a7eed86, 0x0000000000000034, 0x0 }, /* #68 */
    { 0x2365c2, 0x2365c3, 0x98f8bd9baf187f2c, 0x98f8bd9aaf187f2c, 0x0000000000000020, 0x0 }, /* #69 */
    { 0x3d7c92, 0x3d7c93, 0xcd8bfaeff4b258d0, 0xcd83faeff4b258d0, 0x0000000000000033, 0x0 }, /* #70 */
    { 0x381f92, 0x381f93, 0xd02213d2e06ae81a, 0xd02212d2e06ae81a, 0x0000000000000028, 0x0 }, /* #71 */
    { 0x0e70d6, 0x0e70d6, 0xbd1d0089682db54c, 0xbd1d0089682db54c, 0x0000000000000036, 0x0 }, /* #72 */
    { 0x0c4a06, 0x0c4a07, 0xe5e2cbfe7b44493e, 0xe5e28bfe7b44493e, 0x000000000000002e, 0x0 }, /* #73 */
    { 0x0b7007, 0x0b7006, 0xb71aea8faf64ac78, 0xb71aea8faf64ac78, 0x0000000000000011, 0x0 }, /* #74 */
    { 0x3b40c6, 0x3b40c7, 0xbad5a7da9c187393, 0xbad5a7da98187393, 0x000000000000001a, 0x0 }, /* #75 */
    { 0x371682, 0x371683, 0xbf78032db8701403, 0xbf78022db8701403, 0x0000000000000028, 0x0 }, /* #76 */
    { 0x0a34d7, 0x0a34d6, 0x13ca01cfad0a3ac8, 0x13ca01cfad0a3ac8, 0x0000000000000032, 0x0 }, /* #77 */
    { 0x304512, 0x304512, 0x7bb9c7057f2ae2bb, 0x7bb9c7057f2ae2bb, 0x0000000000000016, 0x0 }, /* #78 */
    { 0x111ec3, 0x111ec2, 0xa0f0c1e76e8e4e64, 0xa0f0c1e76e8e4e64, 0x0000000000000038, 0x0 }, /* #79 */
    { 0x176f12, 0x176f12, 0xc38759210abdca2d, 0xc38759210abdca2d, 0x0000000000000034, 0x0 }, /* #80 */
    { 0x227e86, 0x227e86, 0x168276c4ea397bcb, 0x168276c4ea397bcb, 0x000000000000003d, 0x0 }, /* #81 */
    { 0x071603, 0x071602, 0xf942441444f76417, 0xf942441444f76417, 0x0000000000000026, 0x0 }, /* #82 */
    { 0x2079c7, 0x2079c6, 0x348d465ad8650062, 0x348d465ad8650062, 0x0000000000000031, 0x0 }, /* #83 */
    { 0x114393, 0x114392, 0xedfe7b2f45c358cf, 0xedfe7b2f45c358cf, 0x0000000000000005, 0x0 }, /* #84 */
    { 0x0719d7, 0x0719d7, 0x638f8697abd3557d, 0x638f8697abd3157d, 0x000000000000000e, 0x0 }, /* #85 */
    { 0x287d86, 0x287d86, 0x8fa2759d6b0138a2, 0x8fa2759d6b0138a2, 0x0000000000000009, 0x0 }, /* #86 */
    { 0x1c7ec6, 0x1c7ec7, 0x6296aa03f54ad86d, 0x6296aa01f54ad86d, 0x0000000000000021, 0x0 }, /* #87 */
    { 0x041a86, 0x041a87, 0x67949dc8b5794861, 0x67949dc8b5784861, 0x0000000000000010, 0x0 }, /* #88 */
    { 0x3a5d02, 0x3a5d03, 0x4d785094e3c8f4a5, 0x45785094e3c8f4a5, 0x000000000000003b, 0x0 }, /* #89 */
    { 0x216217, 0x216217, 0xcf84e6a7c2940573, 0x4f84e6a7c2940573, 0x000000000000003f, 0x0 }, /* #90 */
    { 0x1e0002, 0x1e0003, 0x45c22515e5a441db, 0x45c22515e5a441cb, 0x0000000000000004, 0x0 }, /* #91 */
    { 0x3b4e42, 0x3b4e43, 0xdf007ba853f30059, 0xdf007b2853f30059, 0x0000000000000027, 0x0 }, /* #92 */
    { 0x2b70d3, 0x2b70d2, 0x17da0d85f04816b1, 0x17da0d85f04816b1, 0x0000000000000032, 0x0 }, /* #93 */
    { 0x3f4913, 0x3f4912, 0x0eec81c83d0b4efd, 0x0eec81c83d0b4efd, 0x0000000000000034, 0x0 }, /* #94 */
    { 0x3b6992, 0x3b6993, 0x4d35e8912c6efedb, 0x4d35e8912c6afedb, 0x0000000000000012, 0x0 }, /* #95 */
};
uint32_t const g_cTests_btr_u64_locked = RT_ELEMENTS(g_aTests_btr_u64_locked);

BINU64_TEST_T const g_aTests_bts_u64[] =
{
    { 0x3a1893, 0x3a1892, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x0d0912, 0x0d0912, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x132f93, 0x132f92, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x3646c3, 0x3646c2, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x372e83, 0x372e82, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x035897, 0x035896, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x282612, 0x282612, 0x13c44fefa61d8106, 0x13c44fefa61d8107, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x340886, 0x340887, 0xc7a037f9efed1233, 0xc7a037f9efed1233, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x073c42, 0x073c42, 0x994f19f0df3b5410, 0x994f19f0df3b5411, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x171b43, 0x171b43, 0x2d333620a8c2e031, 0x2d333620a8c2e031, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x367ad6, 0x367ad7, 0x0a689b257486564b, 0x0a689b257486564b, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x0e31c3, 0x0e31c2, 0xe5e950b53a5fd280, 0xe5e950b53a5fd281, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x3842d6, 0x3842d6, 0xd972fbf4612e01a9, 0xd972fbf4692e01a9, 0x000000000000001b, 0x0 }, /* #12 */
    { 0x0d2c13, 0x0d2c13, 0xc2d4ce4fe09337c3, 0xc2d4ce4fe09337c3, 0x000000000000003f, 0x0 }, /* #13 */
    { 0x364396, 0x364397, 0x6d3a8a1b9f1bd3af, 0x6d3a8a1b9f1bd3af, 0x000000000000001b, 0x0 }, /* #14 */
    { 0x187116, 0x187117, 0x98744ed718960bf0, 0x98744ed718960bf0, 0x0000000000000012, 0x0 }, /* #15 */
    { 0x380153, 0x380152, 0x4e16ec73f7a1e782, 0x4e56ec73f7a1e782, 0x0000000000000036, 0x0 }, /* #16 */
    { 0x1136d3, 0x1136d3, 0x37141f453bcf5145, 0x37141f453bcf5145, 0x000000000000001d, 0x0 }, /* #17 */
    { 0x190607, 0x190606, 0xdad33daad1a21fc1, 0xdad33daad1a23fc1, 0x000000000000000d, 0x0 }, /* #18 */
    { 0x290742, 0x290742, 0x382cb67e19210768, 0x382cb67e1d210768, 0x000000000000001a, 0x0 }, /* #19 */
    { 0x0d3587, 0x0d3586, 0x758710f1c8091487, 0x758710f1c8291487, 0x0000000000000015, 0x0 }, /* #20 */
    { 0x036e96, 0x036e97, 0xbfa47234d178b3ff, 0xbfa47234d178b3ff, 0x0000000000000024, 0x0 }, /* #21 */
    { 0x334407, 0x334407, 0x6f6c1f8d20c0f846, 0x6f6c1f8d20c0f846, 0x0000000000000022, 0x0 }, /* #22 */
    { 0x000706, 0x000707, 0xcf51e8dcbe66fcb2, 0xcf51e8dcbe66fcb2, 0x000000000000002e, 0x0 }, /* #23 */
    { 0x3c1017, 0x3c1017, 0xfdd8ee2e060a5b67, 0xfdd8ee2e060a5b67, 0x000000000000000e, 0x0 }, /* #24 */
    { 0x171a53, 0x171a52, 0x3b59f8b018239ba7, 0x3b59f8b018239bb7, 0x0000000000000004, 0x0 }, /* #25 */
    { 0x074683, 0x074682, 0x168d044d6c982aaa, 0x168d044d6c992aaa, 0x0000000000000010, 0x0 }, /* #26 */
    { 0x0d3c57, 0x0d3c57, 0x7d274e6d2502c6bf, 0x7d274e6d2502c6bf, 0x0000000000000035, 0x0 }, /* #27 */
    { 0x266a52, 0x266a52, 0xe4be57903ee0a72f, 0xe4be57903ee0af2f, 0x000000000000000b, 0x0 }, /* #28 */
    { 0x291017, 0x291017, 0x1f71d67c93a7c4d8, 0x1f71d67c93a7c4d8, 0x0000000000000003, 0x0 }, /* #29 */
    { 0x102ed3, 0x102ed3, 0x8dbeb0cb15b4c669, 0x8dbeb0cb15b4c669, 0x0000000000000023, 0x0 }, /* #30 */
    { 0x1973c3, 0x1973c2, 0x436917a6f1d8beda, 0x43e917a6f1d8beda, 0x0000000000000037, 0x0 }, /* #31 */
    { 0x1e6b16, 0x1e6b17, 0x65f0b0c1a544cc26, 0x65f0b0c1a544cc26, 0x0000000000000026, 0x0 }, /* #32 */
    { 0x253017, 0x253016, 0x02bc186b3872f54b, 0x02fc186b3872f54b, 0x0000000000000036, 0x0 }, /* #33 */
    { 0x341392, 0x341392, 0x93c36283b52034ac, 0xd3c36283b52034ac, 0x000000000000003e, 0x0 }, /* #34 */
    { 0x0f4097, 0x0f4096, 0x45c6bbe56b7a8c4a, 0x45c6bbe56b7a8c4b, 0x0000000000000000, 0x0 }, /* #35 */
    { 0x381493, 0x381493, 0xb60b32f7f5934ffc, 0xb60b32f7f5934ffc, 0x0000000000000004, 0x0 }, /* #36 */
    { 0x395382, 0x395382, 0xd4daf85f29785550, 0xd4daf85f29785554, 0x0000000000000002, 0x0 }, /* #37 */
    { 0x2b4087, 0x2b4086, 0xb36ae3f867386a10, 0xb36ae3f867386e10, 0x000000000000000a, 0x0 }, /* #38 */
    { 0x283ec2, 0x283ec3, 0x96707bd3fa50de7f, 0x96707bd3fa50de7f, 0x000000000000000c, 0x0 }, /* #39 */
    { 0x082a52, 0x082a52, 0xf076b566a906cd9a, 0xf076b566a946cd9a, 0x0000000000000016, 0x0 }, /* #40 */
    { 0x1b7d42, 0x1b7d42, 0xf8929a6801e802a6, 0xf8929a6801e802ae, 0x0000000000000003, 0x0 }, /* #41 */
    { 0x2128d7, 0x2128d6, 0xaf0510fd40358fa6, 0xaf0510fd48358fa6, 0x000000000000001b, 0x0 }, /* #42 */
    { 0x1d1c56, 0x1d1c56, 0x02b987be7ddb93a4, 0x02b987be7ddbb3a4, 0x000000000000000d, 0x0 }, /* #43 */
    { 0x291d17, 0x291d17, 0x24bd9658a18f1dc9, 0x24bd9658a18f1dc9, 0x0000000000000026, 0x0 }, /* #44 */
    { 0x3531c7, 0x3531c7, 0x0c43a448b7026b93, 0x0c43a448b7026b93, 0x0000000000000031, 0x0 }, /* #45 */
    { 0x061fc3, 0x061fc2, 0x018f728e351bba56, 0x018ff28e351bba56, 0x000000000000002f, 0x0 }, /* #46 */
    { 0x2b5b56, 0x2b5b57, 0x0b333798f203d09b, 0x0b333798f203d09b, 0x000000000000001c, 0x0 }, /* #47 */
    { 0x0e5e83, 0x0e5e83, 0x6ed9237e29a790eb, 0x6ed9237e29a790eb, 0x0000000000000025, 0x0 }, /* #48 */
    { 0x2e3942, 0x2e3943, 0xd519b0ffdb95dc26, 0xd519b0ffdb95dc26, 0x000000000000001c, 0x0 }, /* #49 */
    { 0x0a2b92, 0x0a2b93, 0x53b9dbf0f93f7190, 0x53b9dbf0f93f7190, 0x0000000000000033, 0x0 }, /* #50 */
    { 0x0d7496, 0x0d7496, 0x8e72c5a2b8b17b2a, 0x8ef2c5a2b8b17b2a, 0x0000000000000037, 0x0 }, /* #51 */
    { 0x1f7bd6, 0x1f7bd6, 0x9efa6b026843c888, 0x9efe6b026843c888, 0x0000000000000032, 0x0 }, /* #52 */
    { 0x2113d3, 0x2113d3, 0xe68667e1a77d3c1d, 0xe68667e1a77d3c1d, 0x0000000000000002, 0x0 }, /* #53 */
    { 0x162317, 0x162316, 0xfac7443b7aeb4890, 0xfac7443b7afb4890, 0x0000000000000014, 0x0 }, /* #54 */
    { 0x095fd6, 0x095fd7, 0x82976c73d234d6a8, 0x82976c73d234d6a8, 0x0000000000000021, 0x0 }, /* #55 */
    { 0x237ec7, 0x237ec7, 0x0494c7b27d30eacf, 0x0494c7b27d30eacf, 0x000000000000003a, 0x0 }, /* #56 */
    { 0x2931c2, 0x2931c3, 0x60e1f7f7412964c0, 0x60e1f7f7412964c0, 0x0000000000000015, 0x0 }, /* #57 */
    { 0x386746, 0x386747, 0x424750c78a470e3a, 0x424750c78a470e3a, 0x0000000000000031, 0x0 }, /* #58 */
    { 0x217ed6, 0x217ed6, 0x6e127b0621f523e7, 0x6e927b0621f523e7, 0x0000000000000037, 0x0 }, /* #59 */
    { 0x3a78c6, 0x3a78c6, 0x3c0c752a70aa801d, 0x3c0c752a70aa805d, 0x0000000000000006, 0x0 }, /* #60 */
    { 0x0f1003, 0x0f1002, 0x89e80f294bf6ea67, 0x89ea0f294bf6ea67, 0x0000000000000031, 0x0 }, /* #61 */
    { 0x384306, 0x384306, 0x91bf88ba53c8931d, 0x91bf88ba53c8939d, 0x0000000000000007, 0x0 }, /* #62 */
    { 0x394993, 0x394993, 0xacf4bd14e95b43c0, 0xacf4bd14e95b43c0, 0x000000000000001d, 0x0 }, /* #63 */
    { 0x1169c2, 0x1169c3, 0x14f9747d520cf5f2, 0x14f9747d520cf5f2, 0x000000000000000c, 0x0 }, /* #64 */
    { 0x257287, 0x257287, 0x17ba83e44cc9aab8, 0x17ba83e44cc9aab8, 0x000000000000002f, 0x0 }, /* #65 */
    { 0x015a93, 0x015a92, 0xf2bfc124a814d255, 0xf6bfc124a814d255, 0x000000000000003a, 0x0 }, /* #66 */
    { 0x007c93, 0x007c93, 0xd688d7437530ff20, 0xd688d7437530ff20, 0x0000000000000026, 0x0 }, /* #67 */
    { 0x1f5483, 0x1f5482, 0xb7e7af489fed37ae, 0xb7e7af489fed37be, 0x0000000000000004, 0x0 }, /* #68 */
    { 0x241796, 0x241797, 0x4b7cb2abb86a2fae, 0x4b7cb2abb86a2fae, 0x0000000000000029, 0x0 }, /* #69 */
    { 0x307fd3, 0x307fd3, 0x7a3cddf553388faf, 0x7a3cddf553388faf, 0x000000000000002c, 0x0 }, /* #70 */
    { 0x3e32d3, 0x3e32d3, 0xf6adef99bbfc2da7, 0xf6adef99bbfc2da7, 0x000000000000003d, 0x0 }, /* #71 */
    { 0x297ac6, 0x297ac7, 0xa463da1b49fd4fbd, 0xa463da1b49fd4fbd, 0x0000000000000036, 0x0 }, /* #72 */
    { 0x327983, 0x327982, 0x87473b2aaf3133b4, 0x87473b2eaf3133b4, 0x0000000000000022, 0x0 }, /* #73 */
    { 0x2e5956, 0x2e5957, 0x3ef9a15a5b94f1fb, 0x3ef9a15a5b94f1fb, 0x000000000000000c, 0x0 }, /* #74 */
    { 0x060743, 0x060743, 0x659ba84a6242e5e7, 0x659ba84a6242e5e7, 0x0000000000000016, 0x0 }, /* #75 */
    { 0x180313, 0x180312, 0x1951856c094b7457, 0x1951856c094b7557, 0x0000000000000008, 0x0 }, /* #76 */
    { 0x026593, 0x026592, 0x1fef9e27a0b40589, 0x1fef9f27a0b40589, 0x0000000000000028, 0x0 }, /* #77 */
    { 0x322443, 0x322442, 0xe993d009c709adb3, 0xe993d009c70dadb3, 0x0000000000000012, 0x0 }, /* #78 */
    { 0x190887, 0x190886, 0xd43fe00043146c71, 0xd43fe00143146c71, 0x0000000000000020, 0x0 }, /* #79 */
    { 0x2a7487, 0x2a7486, 0x32b29034c4a7e0cc, 0x32b29034c4afe0cc, 0x0000000000000013, 0x0 }, /* #80 */
    { 0x053bd7, 0x053bd6, 0x87d73aaa3ef9853a, 0x87d73aaa3ef98d3a, 0x000000000000000b, 0x0 }, /* #81 */
    { 0x3149d7, 0x3149d6, 0xd3609b7394f2c680, 0xd3609b7394f6c680, 0x0000000000000012, 0x0 }, /* #82 */
    { 0x3f2b96, 0x3f2b96, 0x509a6fa9e066a928, 0x509a6fa9e066ab28, 0x0000000000000009, 0x0 }, /* #83 */
    { 0x112fd3, 0x112fd3, 0x841802d8fe1d9861, 0x841802d8fe1d9861, 0x000000000000001e, 0x0 }, /* #84 */
    { 0x2343d6, 0x2343d6, 0x5c5979d2d1ba9813, 0x5e5979d2d1ba9813, 0x0000000000000039, 0x0 }, /* #85 */
    { 0x2c3517, 0x2c3517, 0xabae39db73249b09, 0xabae39db73249b09, 0x000000000000003b, 0x0 }, /* #86 */
    { 0x1f3396, 0x1f3396, 0x993a5d53a953e282, 0xd93a5d53a953e282, 0x000000000000003e, 0x0 }, /* #87 */
    { 0x0222d2, 0x0222d2, 0x46185a0ce720c638, 0x46185a0ce724c638, 0x0000000000000012, 0x0 }, /* #88 */
    { 0x276f06, 0x276f06, 0x019cb36b620d5fa1, 0x019db36b620d5fa1, 0x0000000000000030, 0x0 }, /* #89 */
    { 0x1f5a92, 0x1f5a93, 0x168263032d9ff58f, 0x168263032d9ff58f, 0x0000000000000028, 0x0 }, /* #90 */
    { 0x221602, 0x221603, 0x53613af8930ac983, 0x53613af8930ac983, 0x000000000000002c, 0x0 }, /* #91 */
    { 0x0a7d17, 0x0a7d17, 0x416802b839c88e3e, 0x416802b839c88e3e, 0x0000000000000004, 0x0 }, /* #92 */
    { 0x3e4c82, 0x3e4c82, 0x0d3932832da73145, 0x0d3932836da73145, 0x000000000000001e, 0x0 }, /* #93 */
    { 0x271a12, 0x271a13, 0x456b0f81a21b4754, 0x456b0f81a21b4754, 0x000000000000002a, 0x0 }, /* #94 */
    { 0x170492, 0x170492, 0x0dfed7b80cc9c302, 0x0dfed7b90cc9c302, 0x0000000000000020, 0x0 }, /* #95 */
};
uint32_t const g_cTests_bts_u64 = RT_ELEMENTS(g_aTests_bts_u64);

BINU64_TEST_T const g_aTests_bts_u64_locked[] =
{
    { 0x330a06, 0x330a06, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #0 */
    { 0x3d6397, 0x3d6396, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #1 */
    { 0x195192, 0x195192, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #2 */
    { 0x2e2dd2, 0x2e2dd2, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #3 */
    { 0x364c12, 0x364c12, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #4 */
    { 0x1f4503, 0x1f4502, 0x0000000000000000, 0x0000000000000001, 0x0000000000000000, 0x0 }, /* #5 */
    { 0x223646, 0x223646, 0x556569ecfef46a9a, 0x556569ecfef46a9b, 0x0000000000000000, 0x0 }, /* #6 */
    { 0x2b4b87, 0x2b4b86, 0x19d076b4c6e53ff0, 0x19d076b4c6e53ff1, 0x0000000000000000, 0x0 }, /* #7 */
    { 0x124986, 0x124986, 0x81bc1aee5994db3e, 0x81bc1aee5994db3f, 0x0000000000000000, 0x0 }, /* #8 */
    { 0x0b7752, 0x0b7752, 0x93ebdc5f82acf62a, 0x93ebdc5f82acf62b, 0x0000000000000000, 0x0 }, /* #9 */
    { 0x070a13, 0x070a13, 0xed7664e8d412290d, 0xed7664e8d412290d, 0x0000000000000000, 0x0 }, /* #10 */
    { 0x137002, 0x137003, 0x08852f26eef88403, 0x08852f26eef88403, 0x0000000000000000, 0x0 }, /* #11 */
    { 0x1a0816, 0x1a0816, 0x3bedc791090977e7, 0x3bedc791090b77e7, 0x0000000000000011, 0x0 }, /* #12 */
    { 0x301283, 0x301283, 0x664a5f13b5902aab, 0x664a5f13b5902aab, 0x0000000000000018, 0x0 }, /* #13 */
    { 0x390d92, 0x390d92, 0x5e8055faa5185478, 0xde8055faa5185478, 0x000000000000003f, 0x0 }, /* #14 */
    { 0x397a03, 0x397a02, 0x1a399b74debb40f6, 0x5a399b74debb40f6, 0x000000000000003e, 0x0 }, /* #15 */
    { 0x1c47c7, 0x1c47c6, 0x25252dcf2574e7ba, 0x25252dcf25f4e7ba, 0x0000000000000017, 0x0 }, /* #16 */
    { 0x283387, 0x283386, 0x5a6888e0a0df746f, 0x5a6888e0a2df746f, 0x0000000000000019, 0x0 }, /* #17 */
    { 0x081e52, 0x081e53, 0x0d91cce61cf0f6e3, 0x0d91cce61cf0f6e3, 0x000000000000000a, 0x0 }, /* #18 */
    { 0x2a26c2, 0x2a26c3, 0xbee504ca0fd1b3b2, 0xbee504ca0fd1b3b2, 0x000000000000003c, 0x0 }, /* #19 */
    { 0x0e7e57, 0x0e7e57, 0x6237674fff3a96fa, 0x6237674fff3a96fa, 0x0000000000000029, 0x0 }, /* #20 */
    { 0x062002, 0x062002, 0x94fc821d66c42cd3, 0x94fc821de6c42cd3, 0x000000000000001f, 0x0 }, /* #21 */
    { 0x0b0346, 0x0b0346, 0x396b13574258377c, 0x3d6b13574258377c, 0x000000000000003a, 0x0 }, /* #22 */
    { 0x225b06, 0x225b06, 0xf27d02ad73f84f0d, 0xf27d02adf3f84f0d, 0x000000000000001f, 0x0 }, /* #23 */
    { 0x1a6943, 0x1a6942, 0x377989a766935136, 0x377989a766935336, 0x0000000000000009, 0x0 }, /* #24 */
    { 0x3106c2, 0x3106c3, 0x8ec2d519e25d7fb9, 0x8ec2d519e25d7fb9, 0x0000000000000013, 0x0 }, /* #25 */
    { 0x0d3c46, 0x0d3c47, 0xcf3c0c12a5881650, 0xcf3c0c12a5881650, 0x000000000000003e, 0x0 }, /* #26 */
    { 0x0a6b03, 0x0a6b02, 0xe98a4691d636f528, 0xe98a4691d636f728, 0x0000000000000009, 0x0 }, /* #27 */
    { 0x0e0f13, 0x0e0f12, 0x585bed26a5325f68, 0x585bed26a532df68, 0x000000000000000f, 0x0 }, /* #28 */
    { 0x386752, 0x386753, 0x04ee6bcc3d6875a9, 0x04ee6bcc3d6875a9, 0x0000000000000031, 0x0 }, /* #29 */
    { 0x312d16, 0x312d17, 0x1a3df5b42eedda36, 0x1a3df5b42eedda36, 0x000000000000002c, 0x0 }, /* #30 */
    { 0x340617, 0x340617, 0xf1c6fc25680f03ac, 0xf1c6fc25680f03ac, 0x000000000000002a, 0x0 }, /* #31 */
    { 0x3800d6, 0x3800d7, 0x14fb6f126d23baa8, 0x14fb6f126d23baa8, 0x0000000000000005, 0x0 }, /* #32 */
    { 0x1a6f92, 0x1a6f92, 0x0bc241a93a89399a, 0x0bc241a9ba89399a, 0x000000000000001f, 0x0 }, /* #33 */
    { 0x124d53, 0x124d52, 0x30f581a342c87c98, 0x30f581a742c87c98, 0x0000000000000022, 0x0 }, /* #34 */
    { 0x1e1a16, 0x1e1a17, 0x639622a450b69500, 0x639622a450b69500, 0x0000000000000014, 0x0 }, /* #35 */
    { 0x285082, 0x285083, 0x288e8f507ec0ade9, 0x288e8f507ec0ade9, 0x000000000000001a, 0x0 }, /* #36 */
    { 0x0d0a82, 0x0d0a82, 0x3f3e42e910e59c22, 0x3f3e42e914e59c22, 0x000000000000001a, 0x0 }, /* #37 */
    { 0x3b5503, 0x3b5503, 0x6e82efa2c2519509, 0x6e82efa2c2519509, 0x0000000000000037, 0x0 }, /* #38 */
    { 0x1409c3, 0x1409c2, 0x7443a434b3710853, 0x7443a434b3710c53, 0x000000000000000a, 0x0 }, /* #39 */
    { 0x362d57, 0x362d57, 0xd6baada211330636, 0xd6baada211330636, 0x0000000000000005, 0x0 }, /* #40 */
    { 0x276297, 0x276296, 0xbed09c379a8d445b, 0xbed19c379a8d445b, 0x0000000000000030, 0x0 }, /* #41 */
    { 0x330b86, 0x330b86, 0x2023e40bcebc4221, 0x2023e40bcebc42a1, 0x0000000000000007, 0x0 }, /* #42 */
    { 0x1e21c2, 0x1e21c3, 0x52ef754f550c000a, 0x52ef754f550c000a, 0x0000000000000028, 0x0 }, /* #43 */
    { 0x205293, 0x205292, 0x46944d66c7017c86, 0x46946d66c7017c86, 0x000000000000002d, 0x0 }, /* #44 */
    { 0x2c3d12, 0x2c3d13, 0xb1bfc1724a4bf430, 0xb1bfc1724a4bf430, 0x000000000000003d, 0x0 }, /* #45 */
    { 0x1b5d82, 0x1b5d82, 0x15f4953cd5288f5e, 0x15f4953cd52a8f5e, 0x0000000000000011, 0x0 }, /* #46 */
    { 0x2d4cd3, 0x2d4cd3, 0x52340171ab64519c, 0x52340171ab64519c, 0x0000000000000025, 0x0 }, /* #47 */
    { 0x163f56, 0x163f57, 0x33adc79164e19452, 0x33adc79164e19452, 0x000000000000003c, 0x0 }, /* #48 */
    { 0x1f3083, 0x1f3083, 0xc230f3c23ab847e6, 0xc230f3c23ab847e6, 0x0000000000000021, 0x0 }, /* #49 */
    { 0x2b1313, 0x2b1312, 0xf085780979b6e666, 0xf085780d79b6e666, 0x0000000000000022, 0x0 }, /* #50 */
    { 0x392ed2, 0x392ed3, 0xf03fce9e100d1173, 0xf03fce9e100d1173, 0x0000000000000032, 0x0 }, /* #51 */
    { 0x383397, 0x383396, 0xc548dc6a8aede24e, 0xc548dc6acaede24e, 0x000000000000001e, 0x0 }, /* #52 */
    { 0x257257, 0x257257, 0xa1de95593a7c208c, 0xa1de95593a7c208c, 0x0000000000000014, 0x0 }, /* #53 */
    { 0x105512, 0x105512, 0x4a1ee2692b59912c, 0x4a1ee2692b59992c, 0x000000000000000b, 0x0 }, /* #54 */
    { 0x2842c6, 0x2842c6, 0x166360c3f0bdc532, 0x166360c3f1bdc532, 0x0000000000000018, 0x0 }, /* #55 */
    { 0x040543, 0x040543, 0xb98b9e6681558c8a, 0xb98b9e6681558c8a, 0x0000000000000038, 0x0 }, /* #56 */
    { 0x0006d3, 0x0006d2, 0x5e859e398e6c7e3d, 0x5e859e3d8e6c7e3d, 0x0000000000000022, 0x0 }, /* #57 */
    { 0x3704d3, 0x3704d2, 0xf19a837480ac2ca3, 0xf19a837480ac2da3, 0x0000000000000008, 0x0 }, /* #58 */
    { 0x2d4d12, 0x2d4d12, 0x6e38482367b3dee2, 0x6eb8482367b3dee2, 0x0000000000000037, 0x0 }, /* #59 */
    { 0x0c24d7, 0x0c24d7, 0xdb2f62452e698e07, 0xdb2f62452e698e07, 0x000000000000003b, 0x0 }, /* #60 */
    { 0x3a5643, 0x3a5643, 0x237733cd669ff7a9, 0x237733cd669ff7a9, 0x0000000000000000, 0x0 }, /* #61 */
    { 0x147053, 0x147052, 0x5121032b68dfceb0, 0x5125032b68dfceb0, 0x0000000000000032, 0x0 }, /* #62 */
    { 0x3715d7, 0x3715d6, 0x2085074791682f79, 0x2087074791682f79, 0x0000000000000031, 0x0 }, /* #63 */
    { 0x134e92, 0x134e92, 0xc8ffb7cb76d2d0e3, 0xc8ffb7cbf6d2d0e3, 0x000000000000001f, 0x0 }, /* #64 */
    { 0x266743, 0x266743, 0x5ae4407cb019fe5a, 0x5ae4407cb019fe5a, 0x000000000000000d, 0x0 }, /* #65 */
    { 0x2e4496, 0x2e4497, 0x7dea97cc70ad3be2, 0x7dea97cc70ad3be2, 0x000000000000003d, 0x0 }, /* #66 */
    { 0x045c97, 0x045c97, 0x2e02f763e73269ad, 0x2e02f763e73269ad, 0x000000000000002a, 0x0 }, /* #67 */
    { 0x282796, 0x282797, 0x92a1f5bdb9e1cf67, 0x92a1f5bdb9e1cf67, 0x0000000000000039, 0x0 }, /* #68 */
    { 0x304517, 0x304516, 0x1c6c236b31b6e534, 0x1c6c236b33b6e534, 0x0000000000000019, 0x0 }, /* #69 */
    { 0x2105c6, 0x2105c6, 0xa30b556828698fe1, 0xab0b556828698fe1, 0x000000000000003b, 0x0 }, /* #70 */
    { 0x140252, 0x140252, 0xbc9e84123391b385, 0xbc9e84323391b385, 0x0000000000000025, 0x0 }, /* #71 */
    { 0x305356, 0x305357, 0x6b7ad1c8a159dabe, 0x6b7ad1c8a159dabe, 0x000000000000003e, 0x0 }, /* #72 */
    { 0x3d6997, 0x3d6997, 0x4c945eea2b4f39fc, 0x4c945eea2b4f39fc, 0x000000000000000c, 0x0 }, /* #73 */
    { 0x212557, 0x212557, 0xab1450b9ff7f0043, 0xab1450b9ff7f0043, 0x0000000000000023, 0x0 }, /* #74 */
    { 0x121ac6, 0x121ac6, 0x6328e15293784bb9, 0x6328e15297784bb9, 0x000000000000001a, 0x0 }, /* #75 */
    { 0x1e5846, 0x1e5847, 0xa51efe36a563892e, 0xa51efe36a563892e, 0x000000000000000b, 0x0 }, /* #76 */
    { 0x2f6547, 0x2f6546, 0x1b04760c2cd4b15e, 0x1b04760c2cd4b95e, 0x000000000000000b, 0x0 }, /* #77 */
    { 0x142b86, 0x142b86, 0xd1bef1a114fd7c68, 0xd1bef3a114fd7c68, 0x0000000000000029, 0x0 }, /* #78 */
    { 0x394b83, 0x394b82, 0x8a70784a91e1bb1f, 0x8a74784a91e1bb1f, 0x0000000000000032, 0x0 }, /* #79 */
    { 0x261993, 0x261992, 0x7ae04515c737bf40, 0x7ae04515cf37bf40, 0x000000000000001b, 0x0 }, /* #80 */
    { 0x355f93, 0x355f93, 0x95125aa540c1fb5e, 0x95125aa540c1fb5e, 0x0000000000000017, 0x0 }, /* #81 */
    { 0x1b0447, 0x1b0447, 0x802b5aa972e2ed15, 0x802b5aa972e2ed15, 0x0000000000000002, 0x0 }, /* #82 */
    { 0x1e3896, 0x1e3896, 0x0838f78f1f362b23, 0x0838f78f1f762b23, 0x0000000000000016, 0x0 }, /* #83 */
    { 0x3b1f93, 0x3b1f92, 0x4f44ec86a063ac15, 0x4f44ee86a063ac15, 0x0000000000000029, 0x0 }, /* #84 */
    { 0x2c4207, 0x2c4207, 0xfabb2dafbf1e6f3a, 0xfabb2dafbf1e6f3a, 0x000000000000000a, 0x0 }, /* #85 */
    { 0x2d2803, 0x2d2802, 0x98a7d7bedc5f269b, 0x98a7f7bedc5f269b, 0x000000000000002d, 0x0 }, /* #86 */
    { 0x0b14d6, 0x0b14d6, 0x8ec33a119f698e84, 0x8ec3ba119f698e84, 0x000000000000002f, 0x0 }, /* #87 */
    { 0x314e17, 0x314e17, 0x82cdf442245f0418, 0x82cdf442245f0418, 0x0000000000000032, 0x0 }, /* #88 */
    { 0x215a17, 0x215a17, 0xd5fdda579e1127ad, 0xd5fdda579e1127ad, 0x000000000000002c, 0x0 }, /* #89 */
    { 0x1b2d57, 0x1b2d56, 0x4417fe7b62ee97e9, 0xc417fe7b62ee97e9, 0x000000000000003f, 0x0 }, /* #90 */
    { 0x0825c3, 0x0825c3, 0x3ca01456c70e92b4, 0x3ca01456c70e92b4, 0x000000000000001e, 0x0 }, /* #91 */
    { 0x321317, 0x321316, 0xb10bfb5fdf40cf25, 0xb10bfb5fdf41cf25, 0x0000000000000010, 0x0 }, /* #92 */
    { 0x014b17, 0x014b16, 0x1ae25545f4e656a8, 0x1ee25545f4e656a8, 0x000000000000003a, 0x0 }, /* #93 */
    { 0x0e7813, 0x0e7812, 0x13f637abc866c05a, 0x13f637abc966c05a, 0x0000000000000018, 0x0 }, /* #94 */
    { 0x087ec3, 0x087ec3, 0x0bad07bb92fb565b, 0x0bad07bb92fb565b, 0x000000000000000a, 0x0 }, /* #95 */
};
uint32_t const g_cTests_bts_u64_locked = RT_ELEMENTS(g_aTests_bts_u64_locked);

BINU8_TEST_T const g_aTests_inc_u8[] =
{
    { 0x221bc3, 0x221383, 0xf3, 0xf4, 0, 0 }, /* #0 */
    { 0x283dd3, 0x283507, 0x0e, 0x0f, 0, 0 }, /* #1 */
    { 0x081452, 0x081406, 0x55, 0x56, 0, 0 }, /* #2 */
    { 0x375903, 0x375187, 0xf8, 0xf9, 0, 0 }, /* #3 */
    { 0x2070c2, 0x207006, 0x5b, 0x5c, 0, 0 }, /* #4 */
    { 0x282842, 0x282002, 0x72, 0x73, 0, 0 }, /* #5 */
    { 0x351a56, 0x351282, 0xbe, 0xbf, 0, 0 }, /* #6 */
    { 0x1e4087, 0x1e4007, 0x7a, 0x7b, 0, 0 }, /* #7 */
    { 0x0f5a96, 0x0f5282, 0xb2, 0xb3, 0, 0 }, /* #8 */
    { 0x053d93, 0x053583, 0xe2, 0xe3, 0, 0 }, /* #9 */
    { 0x1c09c2, 0x1c0116, 0x5f, 0x60, 0, 0 }, /* #10 */
    { 0x0e1643, 0x0e1607, 0x3b, 0x3c, 0, 0 }, /* #11 */
    { 0x374392, 0x374306, 0x2d, 0x2e, 0, 0 }, /* #12 */
    { 0x2b6b16, 0x2b6302, 0x7e, 0x7f, 0, 0 }, /* #13 */
    { 0x263b06, 0x263306, 0x76, 0x77, 0, 0 }, /* #14 */
    { 0x037716, 0x037786, 0x8a, 0x8b, 0, 0 }, /* #15 */
    { 0x2e0602, 0x2e0686, 0x92, 0x93, 0, 0 }, /* #16 */
    { 0x3766c3, 0x376687, 0xc9, 0xca, 0, 0 }, /* #17 */
    { 0x124856, 0x124086, 0x8a, 0x8b, 0, 0 }, /* #18 */
    { 0x0c0f17, 0x0c0703, 0x25, 0x26, 0, 0 }, /* #19 */
    { 0x281147, 0x281107, 0x3b, 0x3c, 0, 0 }, /* #20 */
    { 0x0e3703, 0x0e3787, 0xd1, 0xd2, 0, 0 }, /* #21 */
    { 0x1e2c46, 0x1e2406, 0x46, 0x47, 0, 0 }, /* #22 */
    { 0x1608c7, 0x160007, 0x70, 0x71, 0, 0 }, /* #23 */
    { 0x2502d3, 0x250283, 0xa0, 0xa1, 0, 0 }, /* #24 */
    { 0x253543, 0x253587, 0xae, 0xaf, 0, 0 }, /* #25 */
    { 0x2b7606, 0x2b7606, 0x64, 0x65, 0, 0 }, /* #26 */
    { 0x243997, 0x243187, 0x99, 0x9a, 0, 0 }, /* #27 */
    { 0x031a57, 0x031203, 0x6c, 0x6d, 0, 0 }, /* #28 */
    { 0x0209d3, 0x020103, 0x3a, 0x3b, 0, 0 }, /* #29 */
    { 0x3a6e86, 0x3a6602, 0x3c, 0x3d, 0, 0 }, /* #30 */
    { 0x291713, 0x291703, 0x74, 0x75, 0, 0 }, /* #31 */
    { 0x212656, 0x212606, 0x13, 0x14, 0, 0 }, /* #32 */
    { 0x0a3093, 0x0a3003, 0x6d, 0x6e, 0, 0 }, /* #33 */
    { 0x2d1d83, 0x2d1503, 0x18, 0x19, 0, 0 }, /* #34 */
    { 0x343997, 0x343107, 0x3e, 0x3f, 0, 0 }, /* #35 */
    { 0x387912, 0x387102, 0x15, 0x16, 0, 0 }, /* #36 */
    { 0x1752d2, 0x175206, 0x69, 0x6a, 0, 0 }, /* #37 */
    { 0x3a1157, 0x3a1103, 0x78, 0x79, 0, 0 }, /* #38 */
    { 0x016612, 0x016606, 0x5b, 0x5c, 0, 0 }, /* #39 */
    { 0x1b6753, 0x1b6783, 0xd8, 0xd9, 0, 0 }, /* #40 */
    { 0x0d5992, 0x0d5186, 0xe7, 0xe8, 0, 0 }, /* #41 */
    { 0x1f2202, 0x1f2282, 0xbb, 0xbc, 0, 0 }, /* #42 */
    { 0x1a6397, 0x1a6387, 0xf2, 0xf3, 0, 0 }, /* #43 */
    { 0x1d2802, 0x1d2086, 0xcb, 0xcc, 0, 0 }, /* #44 */
    { 0x0e0702, 0x0e0782, 0x89, 0x8a, 0, 0 }, /* #45 */
    { 0x262e16, 0x262602, 0x7b, 0x7c, 0, 0 }, /* #46 */
    { 0x3877d7, 0x387707, 0x62, 0x63, 0, 0 }, /* #47 */
    { 0x072183, 0x072183, 0xbb, 0xbc, 0, 0 }, /* #48 */
    { 0x1b3f07, 0x1b3707, 0x34, 0x35, 0, 0 }, /* #49 */
    { 0x3b2fd7, 0x3b2783, 0xb4, 0xb5, 0, 0 }, /* #50 */
    { 0x1c48c2, 0x1c4086, 0xe0, 0xe1, 0, 0 }, /* #51 */
    { 0x025ed2, 0x025606, 0x38, 0x39, 0, 0 }, /* #52 */
    { 0x125ec7, 0x125687, 0xa9, 0xaa, 0, 0 }, /* #53 */
    { 0x236913, 0x236187, 0xfe, 0xff, 0, 0 }, /* #54 */
    { 0x120b16, 0x120386, 0xbd, 0xbe, 0, 0 }, /* #55 */
    { 0x0f7612, 0x0f7682, 0x9a, 0x9b, 0, 0 }, /* #56 */
    { 0x300cd7, 0x300403, 0x3a, 0x3b, 0, 0 }, /* #57 */
    { 0x3d71c6, 0x3d7106, 0x3e, 0x3f, 0, 0 }, /* #58 */
    { 0x3f1202, 0x3f1202, 0x5c, 0x5d, 0, 0 }, /* #59 */
    { 0x2c02d3, 0x2c0287, 0xcb, 0xcc, 0, 0 }, /* #60 */
    { 0x0d5047, 0x0d5003, 0x67, 0x68, 0, 0 }, /* #61 */
    { 0x1c1f53, 0x1c1793, 0xcf, 0xd0, 0, 0 }, /* #62 */
    { 0x010002, 0x010006, 0x47, 0x48, 0, 0 }, /* #63 */
    { 0x302a02, 0x302206, 0x3e, 0x3f, 0, 0 }, /* #64 */
    { 0x050097, 0x050007, 0x39, 0x3a, 0, 0 }, /* #65 */
    { 0x367d07, 0x367583, 0xfc, 0xfd, 0, 0 }, /* #66 */
    { 0x395992, 0x395186, 0xed, 0xee, 0, 0 }, /* #67 */
    { 0x344693, 0x344683, 0xa1, 0xa2, 0, 0 }, /* #68 */
    { 0x0924c2, 0x092402, 0x6a, 0x6b, 0, 0 }, /* #69 */
    { 0x1a0ad7, 0x1a0207, 0x20, 0x21, 0, 0 }, /* #70 */
    { 0x080ed3, 0x080607, 0x52, 0x53, 0, 0 }, /* #71 */
    { 0x255dd3, 0x255587, 0xae, 0xaf, 0, 0 }, /* #72 */
    { 0x041512, 0x041582, 0xaa, 0xab, 0, 0 }, /* #73 */
    { 0x1731c7, 0x173103, 0x28, 0x29, 0, 0 }, /* #74 */
    { 0x161143, 0x161187, 0x98, 0x99, 0, 0 }, /* #75 */
    { 0x004296, 0x004286, 0xed, 0xee, 0, 0 }, /* #76 */
    { 0x130ac6, 0x130282, 0x84, 0x85, 0, 0 }, /* #77 */
    { 0x052dd3, 0x052507, 0x13, 0x14, 0, 0 }, /* #78 */
    { 0x371ad2, 0x371282, 0xbb, 0xbc, 0, 0 }, /* #79 */
    { 0x136557, 0x136507, 0x0b, 0x0c, 0, 0 }, /* #80 */
    { 0x294e42, 0x294686, 0x95, 0x96, 0, 0 }, /* #81 */
    { 0x3146d3, 0x314683, 0xf0, 0xf1, 0, 0 }, /* #82 */
    { 0x387987, 0x387103, 0x22, 0x23, 0, 0 }, /* #83 */
    { 0x2f61d7, 0x2f6113, 0x3f, 0x40, 0, 0 }, /* #84 */
    { 0x112107, 0x112107, 0x69, 0x6a, 0, 0 }, /* #85 */
    { 0x345496, 0x345482, 0xe2, 0xe3, 0, 0 }, /* #86 */
    { 0x074e93, 0x074603, 0x24, 0x25, 0, 0 }, /* #87 */
    { 0x0d45c6, 0x0d4506, 0x38, 0x39, 0, 0 }, /* #88 */
    { 0x3c3692, 0x3c3606, 0x52, 0x53, 0, 0 }, /* #89 */
    { 0x3108c3, 0x310083, 0xb9, 0xba, 0, 0 }, /* #90 */
    { 0x161c43, 0x161487, 0xd7, 0xd8, 0, 0 }, /* #91 */
    { 0x0b4ad3, 0x0b4203, 0x0c, 0x0d, 0, 0 }, /* #92 */
    { 0x312187, 0x312103, 0x7b, 0x7c, 0, 0 }, /* #93 */
    { 0x034382, 0x034382, 0xb9, 0xba, 0, 0 }, /* #94 */
    { 0x2a6a86, 0x2a6202, 0x74, 0x75, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_inc_u8 = RT_ELEMENTS(g_aTests_inc_u8);

BINU8_TEST_T const g_aTests_inc_u8_locked[] =
{
    { 0x186003, 0x186087, 0xd1, 0xd2, 0, 0 }, /* #0 */
    { 0x174a92, 0x174202, 0x25, 0x26, 0, 0 }, /* #1 */
    { 0x031ac6, 0x031282, 0xb8, 0xb9, 0, 0 }, /* #2 */
    { 0x300f03, 0x300703, 0x25, 0x26, 0, 0 }, /* #3 */
    { 0x397f02, 0x397782, 0x91, 0x92, 0, 0 }, /* #4 */
    { 0x3a0d96, 0x3a0506, 0x73, 0x74, 0, 0 }, /* #5 */
    { 0x160cc6, 0x160486, 0xc8, 0xc9, 0, 0 }, /* #6 */
    { 0x0a6742, 0x0a6782, 0xfd, 0xfe, 0, 0 }, /* #7 */
    { 0x076557, 0x076587, 0xf5, 0xf6, 0, 0 }, /* #8 */
    { 0x360a47, 0x360287, 0xba, 0xbb, 0, 0 }, /* #9 */
    { 0x091f12, 0x091786, 0xcb, 0xcc, 0, 0 }, /* #10 */
    { 0x0a4152, 0x0a4186, 0xd6, 0xd7, 0, 0 }, /* #11 */
    { 0x2e7bc3, 0x2e7383, 0x90, 0x91, 0, 0 }, /* #12 */
    { 0x2d4b12, 0x2d4302, 0x12, 0x13, 0, 0 }, /* #13 */
    { 0x2a1883, 0x2a1083, 0xfa, 0xfb, 0, 0 }, /* #14 */
    { 0x062b13, 0x062387, 0x8a, 0x8b, 0, 0 }, /* #15 */
    { 0x0c2117, 0x0c2187, 0xc8, 0xc9, 0, 0 }, /* #16 */
    { 0x0f4d17, 0x0f4507, 0x0e, 0x0f, 0, 0 }, /* #17 */
    { 0x1e3b52, 0x1e3306, 0x3e, 0x3f, 0, 0 }, /* #18 */
    { 0x201757, 0x201783, 0xac, 0xad, 0, 0 }, /* #19 */
    { 0x347016, 0x347082, 0xd8, 0xd9, 0, 0 }, /* #20 */
    { 0x016b43, 0x016317, 0x4f, 0x50, 0, 0 }, /* #21 */
    { 0x3d5d02, 0x3d5582, 0xbe, 0xbf, 0, 0 }, /* #22 */
    { 0x3b7493, 0x3b7487, 0xe0, 0xe1, 0, 0 }, /* #23 */
    { 0x112b53, 0x112383, 0x8b, 0x8c, 0, 0 }, /* #24 */
    { 0x335097, 0x335087, 0xa2, 0xa3, 0, 0 }, /* #25 */
    { 0x3000c3, 0x300003, 0x7e, 0x7f, 0, 0 }, /* #26 */
    { 0x114757, 0x114713, 0x0f, 0x10, 0, 0 }, /* #27 */
    { 0x2d3e47, 0x2d3607, 0x08, 0x09, 0, 0 }, /* #28 */
    { 0x0a5707, 0x0a5783, 0xd5, 0xd6, 0, 0 }, /* #29 */
    { 0x005ed3, 0x005683, 0xbe, 0xbf, 0, 0 }, /* #30 */
    { 0x0a4616, 0x0a4682, 0xc7, 0xc8, 0, 0 }, /* #31 */
    { 0x394443, 0x394417, 0x5f, 0x60, 0, 0 }, /* #32 */
    { 0x1c2f46, 0x1c2706, 0x71, 0x72, 0, 0 }, /* #33 */
    { 0x0b5187, 0x0b5103, 0x07, 0x08, 0, 0 }, /* #34 */
    { 0x1e7e02, 0x1e7686, 0xc4, 0xc5, 0, 0 }, /* #35 */
    { 0x363612, 0x363602, 0x36, 0x37, 0, 0 }, /* #36 */
    { 0x2058d3, 0x205083, 0xb8, 0xb9, 0, 0 }, /* #37 */
    { 0x017a06, 0x017202, 0x30, 0x31, 0, 0 }, /* #38 */
    { 0x092c07, 0x092c93, 0x7f, 0x80, 0, 0 }, /* #39 */
    { 0x321397, 0x321303, 0x3d, 0x3e, 0, 0 }, /* #40 */
    { 0x354c42, 0x354482, 0xd4, 0xd5, 0, 0 }, /* #41 */
    { 0x117dc2, 0x117586, 0xba, 0xbb, 0, 0 }, /* #42 */
    { 0x1e0513, 0x1e0583, 0x89, 0x8a, 0, 0 }, /* #43 */
    { 0x186286, 0x186216, 0x5f, 0x60, 0, 0 }, /* #44 */
    { 0x096686, 0x096606, 0x76, 0x77, 0, 0 }, /* #45 */
    { 0x106bc3, 0x106387, 0xbc, 0xbd, 0, 0 }, /* #46 */
    { 0x333016, 0x333002, 0x42, 0x43, 0, 0 }, /* #47 */
    { 0x113746, 0x113706, 0x09, 0x0a, 0, 0 }, /* #48 */
    { 0x354cc2, 0x354402, 0x79, 0x7a, 0, 0 }, /* #49 */
    { 0x2d7d13, 0x2d7507, 0x46, 0x47, 0, 0 }, /* #50 */
    { 0x040b86, 0x040302, 0x18, 0x19, 0, 0 }, /* #51 */
    { 0x2e29d2, 0x2e2182, 0xad, 0xae, 0, 0 }, /* #52 */
    { 0x155943, 0x155187, 0x9e, 0x9f, 0, 0 }, /* #53 */
    { 0x132583, 0x132583, 0xfc, 0xfd, 0, 0 }, /* #54 */
    { 0x206c03, 0x206407, 0x55, 0x56, 0, 0 }, /* #55 */
    { 0x001606, 0x001602, 0x72, 0x73, 0, 0 }, /* #56 */
    { 0x126197, 0x126103, 0x0c, 0x0d, 0, 0 }, /* #57 */
    { 0x147397, 0x147307, 0x35, 0x36, 0, 0 }, /* #58 */
    { 0x3e7606, 0x3e7606, 0x2c, 0x2d, 0, 0 }, /* #59 */
    { 0x046f93, 0x046783, 0xf0, 0xf1, 0, 0 }, /* #60 */
    { 0x0d7206, 0x0d7282, 0x96, 0x97, 0, 0 }, /* #61 */
    { 0x071742, 0x071786, 0x95, 0x96, 0, 0 }, /* #62 */
    { 0x206e82, 0x206602, 0x33, 0x34, 0, 0 }, /* #63 */
    { 0x277286, 0x277206, 0x32, 0x33, 0, 0 }, /* #64 */
    { 0x322946, 0x322102, 0x78, 0x79, 0, 0 }, /* #65 */
    { 0x056a06, 0x056202, 0x5d, 0x5e, 0, 0 }, /* #66 */
    { 0x014482, 0x014402, 0x07, 0x08, 0, 0 }, /* #67 */
    { 0x1a7656, 0x1a7686, 0xc2, 0xc3, 0, 0 }, /* #68 */
    { 0x102b13, 0x102383, 0xd5, 0xd6, 0, 0 }, /* #69 */
    { 0x075c83, 0x075483, 0xac, 0xad, 0, 0 }, /* #70 */
    { 0x235ed3, 0x235603, 0x36, 0x37, 0, 0 }, /* #71 */
    { 0x3c05c7, 0x3c0503, 0x5c, 0x5d, 0, 0 }, /* #72 */
    { 0x022442, 0x022486, 0xf8, 0xf9, 0, 0 }, /* #73 */
    { 0x1f5557, 0x1f5583, 0x8e, 0x8f, 0, 0 }, /* #74 */
    { 0x3f1d57, 0x3f1587, 0x8d, 0x8e, 0, 0 }, /* #75 */
    { 0x196942, 0x196182, 0xbe, 0xbf, 0, 0 }, /* #76 */
    { 0x1d1683, 0x1d1683, 0xcc, 0xcd, 0, 0 }, /* #77 */
    { 0x1e2f86, 0x1e2702, 0x15, 0x16, 0, 0 }, /* #78 */
    { 0x390216, 0x390202, 0x6c, 0x6d, 0, 0 }, /* #79 */
    { 0x1175d3, 0x117507, 0x39, 0x3a, 0, 0 }, /* #80 */
    { 0x120402, 0x120402, 0x44, 0x45, 0, 0 }, /* #81 */
    { 0x0e0846, 0x0e0002, 0x5d, 0x5e, 0, 0 }, /* #82 */
    { 0x0548c3, 0x054087, 0xfb, 0xfc, 0, 0 }, /* #83 */
    { 0x091183, 0x091117, 0x4f, 0x50, 0, 0 }, /* #84 */
    { 0x110313, 0x110387, 0xba, 0xbb, 0, 0 }, /* #85 */
    { 0x0c2102, 0x0c2186, 0x8d, 0x8e, 0, 0 }, /* #86 */
    { 0x2b4886, 0x2b4082, 0xde, 0xdf, 0, 0 }, /* #87 */
    { 0x2b15d2, 0x2b1502, 0x2e, 0x2f, 0, 0 }, /* #88 */
    { 0x397dd3, 0x397507, 0x68, 0x69, 0, 0 }, /* #89 */
    { 0x2629d6, 0x262102, 0x07, 0x08, 0, 0 }, /* #90 */
    { 0x005482, 0x005486, 0xea, 0xeb, 0, 0 }, /* #91 */
    { 0x264743, 0x264703, 0x2e, 0x2f, 0, 0 }, /* #92 */
    { 0x211486, 0x211486, 0x81, 0x82, 0, 0 }, /* #93 */
    { 0x272fd6, 0x272702, 0x01, 0x02, 0, 0 }, /* #94 */
    { 0x2a65c3, 0x2a6507, 0x13, 0x14, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_inc_u8_locked = RT_ELEMENTS(g_aTests_inc_u8_locked);

BINU8_TEST_T const g_aTests_dec_u8[] =
{
    { 0x097c46, 0x097446, 0x01, 0x00, 0, 0 }, /* #0 */
    { 0x0d1b46, 0x0d1392, 0xf0, 0xef, 0, 0 }, /* #1 */
    { 0x1044c3, 0x104487, 0xaa, 0xa9, 0, 0 }, /* #2 */
    { 0x3454d2, 0x345486, 0xe3, 0xe2, 0, 0 }, /* #3 */
    { 0x0f0657, 0x0f0603, 0x1d, 0x1c, 0, 0 }, /* #4 */
    { 0x011d82, 0x011502, 0x35, 0x34, 0, 0 }, /* #5 */
    { 0x1508c3, 0x150003, 0x26, 0x25, 0, 0 }, /* #6 */
    { 0x287c12, 0x287402, 0x11, 0x10, 0, 0 }, /* #7 */
    { 0x065257, 0x065287, 0xa6, 0xa5, 0, 0 }, /* #8 */
    { 0x167dc6, 0x167586, 0xcd, 0xcc, 0, 0 }, /* #9 */
    { 0x2d7957, 0x2d7117, 0x70, 0x6f, 0, 0 }, /* #10 */
    { 0x285116, 0x285186, 0xdc, 0xdb, 0, 0 }, /* #11 */
    { 0x247ad6, 0x247286, 0xbc, 0xbb, 0, 0 }, /* #12 */
    { 0x076c86, 0x076402, 0x52, 0x51, 0, 0 }, /* #13 */
    { 0x0f06c6, 0x0f0602, 0x0c, 0x0b, 0, 0 }, /* #14 */
    { 0x022a86, 0x022282, 0xb7, 0xb6, 0, 0 }, /* #15 */
    { 0x327593, 0x327583, 0x99, 0x98, 0, 0 }, /* #16 */
    { 0x3303c7, 0x330393, 0xf0, 0xef, 0, 0 }, /* #17 */
    { 0x170913, 0x170107, 0x34, 0x33, 0, 0 }, /* #18 */
    { 0x060ec7, 0x060607, 0x49, 0x48, 0, 0 }, /* #19 */
    { 0x315413, 0x315483, 0xae, 0xad, 0, 0 }, /* #20 */
    { 0x3a3382, 0x3a3306, 0x66, 0x65, 0, 0 }, /* #21 */
    { 0x107297, 0x107287, 0xf1, 0xf0, 0, 0 }, /* #22 */
    { 0x140493, 0x140487, 0xbc, 0xbb, 0, 0 }, /* #23 */
    { 0x3702d3, 0x370283, 0xc8, 0xc7, 0, 0 }, /* #24 */
    { 0x226147, 0x226183, 0xc2, 0xc1, 0, 0 }, /* #25 */
    { 0x0a0bd6, 0x0a0382, 0xaf, 0xae, 0, 0 }, /* #26 */
    { 0x203c56, 0x203482, 0xac, 0xab, 0, 0 }, /* #27 */
    { 0x317cd6, 0x317402, 0x2d, 0x2c, 0, 0 }, /* #28 */
    { 0x176086, 0x176082, 0xd6, 0xd5, 0, 0 }, /* #29 */
    { 0x083a82, 0x083286, 0x91, 0x90, 0, 0 }, /* #30 */
    { 0x3c6697, 0x3c6603, 0x68, 0x67, 0, 0 }, /* #31 */
    { 0x054f53, 0x054707, 0x78, 0x77, 0, 0 }, /* #32 */
    { 0x1b5a96, 0x1b5202, 0x1d, 0x1c, 0, 0 }, /* #33 */
    { 0x3f7413, 0x3f7493, 0xf0, 0xef, 0, 0 }, /* #34 */
    { 0x2533c6, 0x253306, 0x66, 0x65, 0, 0 }, /* #35 */
    { 0x3d22d7, 0x3d2207, 0x78, 0x77, 0, 0 }, /* #36 */
    { 0x386542, 0x386586, 0xb5, 0xb4, 0, 0 }, /* #37 */
    { 0x1811d2, 0x181106, 0x78, 0x77, 0, 0 }, /* #38 */
    { 0x371e86, 0x371682, 0xe6, 0xe5, 0, 0 }, /* #39 */
    { 0x174086, 0x174082, 0xa9, 0xa8, 0, 0 }, /* #40 */
    { 0x3a3a42, 0x3a3a12, 0x80, 0x7f, 0, 0 }, /* #41 */
    { 0x036317, 0x036383, 0x98, 0x97, 0, 0 }, /* #42 */
    { 0x3647d6, 0x364706, 0x45, 0x44, 0, 0 }, /* #43 */
    { 0x0f2947, 0x0f2107, 0x79, 0x78, 0, 0 }, /* #44 */
    { 0x231697, 0x231687, 0xbf, 0xbe, 0, 0 }, /* #45 */
    { 0x265e03, 0x265687, 0xd8, 0xd7, 0, 0 }, /* #46 */
    { 0x321553, 0x321503, 0x71, 0x70, 0, 0 }, /* #47 */
    { 0x006543, 0x006507, 0x75, 0x74, 0, 0 }, /* #48 */
    { 0x0444c7, 0x044403, 0x02, 0x01, 0, 0 }, /* #49 */
    { 0x1e5906, 0x1e5186, 0xaa, 0xa9, 0, 0 }, /* #50 */
    { 0x216617, 0x216687, 0x8c, 0x8b, 0, 0 }, /* #51 */
    { 0x001042, 0x001006, 0x1e, 0x1d, 0, 0 }, /* #52 */
    { 0x3c2517, 0x3c2587, 0x85, 0x84, 0, 0 }, /* #53 */
    { 0x0c1e16, 0x0c1686, 0xab, 0xaa, 0, 0 }, /* #54 */
    { 0x060a92, 0x060206, 0x3a, 0x39, 0, 0 }, /* #55 */
    { 0x1a2682, 0x1a2682, 0xbb, 0xba, 0, 0 }, /* #56 */
    { 0x166947, 0x166103, 0x03, 0x02, 0, 0 }, /* #57 */
    { 0x125102, 0x125106, 0x67, 0x66, 0, 0 }, /* #58 */
    { 0x216583, 0x216583, 0xb4, 0xb3, 0, 0 }, /* #59 */
    { 0x2802c6, 0x280282, 0x87, 0x86, 0, 0 }, /* #60 */
    { 0x133f06, 0x133786, 0xcb, 0xca, 0, 0 }, /* #61 */
    { 0x0e1e43, 0x0e1683, 0xb4, 0xb3, 0, 0 }, /* #62 */
    { 0x1a7a82, 0x1a7206, 0x4f, 0x4e, 0, 0 }, /* #63 */
    { 0x031e56, 0x031602, 0x38, 0x37, 0, 0 }, /* #64 */
    { 0x072b47, 0x072307, 0x7f, 0x7e, 0, 0 }, /* #65 */
    { 0x024b57, 0x024387, 0xb5, 0xb4, 0, 0 }, /* #66 */
    { 0x1201c2, 0x120186, 0xdf, 0xde, 0, 0 }, /* #67 */
    { 0x2b6bd2, 0x2b6302, 0x77, 0x76, 0, 0 }, /* #68 */
    { 0x173247, 0x173203, 0x7a, 0x79, 0, 0 }, /* #69 */
    { 0x230053, 0x230003, 0x26, 0x25, 0, 0 }, /* #70 */
    { 0x311a12, 0x311206, 0x67, 0x66, 0, 0 }, /* #71 */
    { 0x0c0043, 0x0c0087, 0xc7, 0xc6, 0, 0 }, /* #72 */
    { 0x155ac6, 0x155206, 0x49, 0x48, 0, 0 }, /* #73 */
    { 0x202f57, 0x202783, 0xce, 0xcd, 0, 0 }, /* #74 */
    { 0x0b2cc6, 0x0b2402, 0x4d, 0x4c, 0, 0 }, /* #75 */
    { 0x392b47, 0x392307, 0x66, 0x65, 0, 0 }, /* #76 */
    { 0x0a4757, 0x0a4703, 0x6f, 0x6e, 0, 0 }, /* #77 */
    { 0x372b13, 0x372383, 0xaf, 0xae, 0, 0 }, /* #78 */
    { 0x1f1e87, 0x1f1607, 0x31, 0x30, 0, 0 }, /* #79 */
    { 0x364656, 0x364606, 0x6a, 0x69, 0, 0 }, /* #80 */
    { 0x192a02, 0x192292, 0x90, 0x8f, 0, 0 }, /* #81 */
    { 0x1d0b46, 0x1d0306, 0x49, 0x48, 0, 0 }, /* #82 */
    { 0x295f02, 0x295786, 0x96, 0x95, 0, 0 }, /* #83 */
    { 0x070492, 0x070406, 0x73, 0x72, 0, 0 }, /* #84 */
    { 0x2b2d93, 0x2b2507, 0x64, 0x63, 0, 0 }, /* #85 */
    { 0x1e56c3, 0x1e5603, 0x16, 0x15, 0, 0 }, /* #86 */
    { 0x1f6607, 0x1f6607, 0x64, 0x63, 0, 0 }, /* #87 */
    { 0x001e57, 0x001687, 0x83, 0x82, 0, 0 }, /* #88 */
    { 0x312557, 0x312587, 0xde, 0xdd, 0, 0 }, /* #89 */
    { 0x2172c6, 0x217206, 0x5a, 0x59, 0, 0 }, /* #90 */
    { 0x370492, 0x370486, 0x82, 0x81, 0, 0 }, /* #91 */
    { 0x334f97, 0x334787, 0xbe, 0xbd, 0, 0 }, /* #92 */
    { 0x3665c6, 0x366586, 0x83, 0x82, 0, 0 }, /* #93 */
    { 0x242e53, 0x242687, 0x85, 0x84, 0, 0 }, /* #94 */
    { 0x020747, 0x020707, 0x54, 0x53, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_dec_u8 = RT_ELEMENTS(g_aTests_dec_u8);

BINU8_TEST_T const g_aTests_dec_u8_locked[] =
{
    { 0x272156, 0x272112, 0x20, 0x1f, 0, 0 }, /* #0 */
    { 0x2e4396, 0x2e4306, 0x3b, 0x3a, 0, 0 }, /* #1 */
    { 0x1538d7, 0x153003, 0x7a, 0x79, 0, 0 }, /* #2 */
    { 0x2742c2, 0x274282, 0xea, 0xe9, 0, 0 }, /* #3 */
    { 0x220ac6, 0x220206, 0x28, 0x27, 0, 0 }, /* #4 */
    { 0x287fd6, 0x287786, 0x85, 0x84, 0, 0 }, /* #5 */
    { 0x126083, 0x126003, 0x14, 0x13, 0, 0 }, /* #6 */
    { 0x240482, 0x240482, 0xa2, 0xa1, 0, 0 }, /* #7 */
    { 0x066fd7, 0x066787, 0xaa, 0xa9, 0, 0 }, /* #8 */
    { 0x172d43, 0x172593, 0x90, 0x8f, 0, 0 }, /* #9 */
    { 0x3c69c3, 0x3c6187, 0xef, 0xee, 0, 0 }, /* #10 */
    { 0x202ed2, 0x202686, 0xa4, 0xa3, 0, 0 }, /* #11 */
    { 0x081f83, 0x081787, 0xa4, 0xa3, 0, 0 }, /* #12 */
    { 0x160bc6, 0x160386, 0xc7, 0xc6, 0, 0 }, /* #13 */
    { 0x0a1882, 0x0a1002, 0x6c, 0x6b, 0, 0 }, /* #14 */
    { 0x1c1cd7, 0x1c1403, 0x5f, 0x5e, 0, 0 }, /* #15 */
    { 0x050b57, 0x050303, 0x05, 0x04, 0, 0 }, /* #16 */
    { 0x0e0702, 0x0e0786, 0xf6, 0xf5, 0, 0 }, /* #17 */
    { 0x286613, 0x286603, 0x5c, 0x5b, 0, 0 }, /* #18 */
    { 0x207117, 0x207107, 0x1e, 0x1d, 0, 0 }, /* #19 */
    { 0x2f5516, 0x2f5502, 0x21, 0x20, 0, 0 }, /* #20 */
    { 0x200a57, 0x200213, 0x30, 0x2f, 0, 0 }, /* #21 */
    { 0x102857, 0x102097, 0xb0, 0xaf, 0, 0 }, /* #22 */
    { 0x265192, 0x265182, 0x98, 0x97, 0, 0 }, /* #23 */
    { 0x3f4313, 0x3f4303, 0x38, 0x37, 0, 0 }, /* #24 */
    { 0x363157, 0x363183, 0x84, 0x83, 0, 0 }, /* #25 */
    { 0x0f4d93, 0x0f4503, 0x46, 0x45, 0, 0 }, /* #26 */
    { 0x277b56, 0x277302, 0x47, 0x46, 0, 0 }, /* #27 */
    { 0x386343, 0x386313, 0x50, 0x4f, 0, 0 }, /* #28 */
    { 0x1d1503, 0x1d1503, 0x4b, 0x4a, 0, 0 }, /* #29 */
    { 0x003f42, 0x003702, 0x02, 0x01, 0, 0 }, /* #30 */
    { 0x072e42, 0x072686, 0xe2, 0xe1, 0, 0 }, /* #31 */
    { 0x1969c2, 0x196106, 0x5a, 0x59, 0, 0 }, /* #32 */
    { 0x265516, 0x265502, 0x68, 0x67, 0, 0 }, /* #33 */
    { 0x282f93, 0x282787, 0xcd, 0xcc, 0, 0 }, /* #34 */
    { 0x2a56c2, 0x2a5682, 0xe7, 0xe6, 0, 0 }, /* #35 */
    { 0x182cd3, 0x182493, 0x90, 0x8f, 0, 0 }, /* #36 */
    { 0x322ac2, 0x322202, 0x38, 0x37, 0, 0 }, /* #37 */
    { 0x264316, 0x264386, 0x9a, 0x99, 0, 0 }, /* #38 */
    { 0x1029d2, 0x102182, 0xfe, 0xfd, 0, 0 }, /* #39 */
    { 0x124087, 0x124003, 0x4b, 0x4a, 0, 0 }, /* #40 */
    { 0x112ec7, 0x112603, 0x53, 0x52, 0, 0 }, /* #41 */
    { 0x315547, 0x315507, 0x78, 0x77, 0, 0 }, /* #42 */
    { 0x1b58c2, 0x1b5096, 0x00, 0xff, 0, 0 }, /* #43 */
    { 0x1c2fd3, 0x1c2783, 0xcf, 0xce, 0, 0 }, /* #44 */
    { 0x030896, 0x030086, 0x83, 0x82, 0, 0 }, /* #45 */
    { 0x176206, 0x176286, 0x8f, 0x8e, 0, 0 }, /* #46 */
    { 0x134606, 0x134612, 0x20, 0x1f, 0, 0 }, /* #47 */
    { 0x1c5e87, 0x1c5683, 0xd7, 0xd6, 0, 0 }, /* #48 */
    { 0x0e3cd2, 0x0e3482, 0xf8, 0xf7, 0, 0 }, /* #49 */
    { 0x3a3b13, 0x3a3307, 0x3b, 0x3a, 0, 0 }, /* #50 */
    { 0x1d5fd2, 0x1d5706, 0x28, 0x27, 0, 0 }, /* #51 */
    { 0x2f2613, 0x2f2603, 0x3f, 0x3e, 0, 0 }, /* #52 */
    { 0x2a1fd2, 0x2a1786, 0xd8, 0xd7, 0, 0 }, /* #53 */
    { 0x136b57, 0x136313, 0x50, 0x4f, 0, 0 }, /* #54 */
    { 0x3e40d3, 0x3e4007, 0x45, 0x44, 0, 0 }, /* #55 */
    { 0x0d0882, 0x0d0086, 0xb9, 0xb8, 0, 0 }, /* #56 */
    { 0x387546, 0x387582, 0xda, 0xd9, 0, 0 }, /* #57 */
    { 0x3b5a13, 0x3b5283, 0xc5, 0xc4, 0, 0 }, /* #58 */
    { 0x371a02, 0x371206, 0x36, 0x35, 0, 0 }, /* #59 */
    { 0x3b0e06, 0x3b0602, 0x46, 0x45, 0, 0 }, /* #60 */
    { 0x1b6592, 0x1b6586, 0xdf, 0xde, 0, 0 }, /* #61 */
    { 0x1747c2, 0x174796, 0x00, 0xff, 0, 0 }, /* #62 */
    { 0x1e6497, 0x1e6403, 0x38, 0x37, 0, 0 }, /* #63 */
    { 0x0c6d03, 0x0c6587, 0xdc, 0xdb, 0, 0 }, /* #64 */
    { 0x250f06, 0x250786, 0xe3, 0xe2, 0, 0 }, /* #65 */
    { 0x1b7f57, 0x1b7797, 0xb0, 0xaf, 0, 0 }, /* #66 */
    { 0x2f2e83, 0x2f2683, 0x87, 0x86, 0, 0 }, /* #67 */
    { 0x237a47, 0x237207, 0x4f, 0x4e, 0, 0 }, /* #68 */
    { 0x3d0857, 0x3d0087, 0x85, 0x84, 0, 0 }, /* #69 */
    { 0x2c29d7, 0x2c2183, 0xe4, 0xe3, 0, 0 }, /* #70 */
    { 0x376483, 0x376483, 0xcc, 0xcb, 0, 0 }, /* #71 */
    { 0x2a3746, 0x2a3786, 0x9b, 0x9a, 0, 0 }, /* #72 */
    { 0x331a13, 0x331207, 0x72, 0x71, 0, 0 }, /* #73 */
    { 0x212bd6, 0x212382, 0xc9, 0xc8, 0, 0 }, /* #74 */
    { 0x2d2c42, 0x2d2482, 0x93, 0x92, 0, 0 }, /* #75 */
    { 0x2f5147, 0x2f5107, 0x49, 0x48, 0, 0 }, /* #76 */
    { 0x1859c7, 0x185187, 0xcb, 0xca, 0, 0 }, /* #77 */
    { 0x3c1a93, 0x3c1217, 0x40, 0x3f, 0, 0 }, /* #78 */
    { 0x1e47d2, 0x1e4702, 0x3c, 0x3b, 0, 0 }, /* #79 */
    { 0x382b97, 0x382303, 0x21, 0x20, 0, 0 }, /* #80 */
    { 0x1b6b07, 0x1b6383, 0xc3, 0xc2, 0, 0 }, /* #81 */
    { 0x304b06, 0x304306, 0x29, 0x28, 0, 0 }, /* #82 */
    { 0x046ec7, 0x046683, 0xae, 0xad, 0, 0 }, /* #83 */
    { 0x240d53, 0x240583, 0x9c, 0x9b, 0, 0 }, /* #84 */
    { 0x394517, 0x394583, 0xe6, 0xe5, 0, 0 }, /* #85 */
    { 0x032a87, 0x032287, 0x96, 0x95, 0, 0 }, /* #86 */
    { 0x393ad3, 0x393283, 0xd7, 0xd6, 0, 0 }, /* #87 */
    { 0x001d06, 0x001582, 0xcc, 0xcb, 0, 0 }, /* #88 */
    { 0x387f16, 0x387786, 0xf4, 0xf3, 0, 0 }, /* #89 */
    { 0x071652, 0x071606, 0x22, 0x21, 0, 0 }, /* #90 */
    { 0x3a4593, 0x3a4583, 0xc9, 0xc8, 0, 0 }, /* #91 */
    { 0x396a97, 0x396207, 0x31, 0x30, 0, 0 }, /* #92 */
    { 0x2d5782, 0x2d5f12, 0x80, 0x7f, 0, 0 }, /* #93 */
    { 0x251256, 0x251282, 0x8b, 0x8a, 0, 0 }, /* #94 */
    { 0x1c3e97, 0x1c3603, 0x7d, 0x7c, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_dec_u8_locked = RT_ELEMENTS(g_aTests_dec_u8_locked);

BINU8_TEST_T const g_aTests_not_u8[] =
{
    { 0x3a7306, 0x3a7306, 0x99, 0x66, 0, 0 }, /* #0 */
    { 0x082987, 0x082987, 0xbb, 0x44, 0, 0 }, /* #1 */
    { 0x293b02, 0x293b02, 0x80, 0x7f, 0, 0 }, /* #2 */
    { 0x1e7d57, 0x1e7d57, 0x1c, 0xe3, 0, 0 }, /* #3 */
    { 0x281e52, 0x281e52, 0x49, 0xb6, 0, 0 }, /* #4 */
    { 0x036716, 0x036716, 0xee, 0x11, 0, 0 }, /* #5 */
    { 0x1e0dc2, 0x1e0dc2, 0x4a, 0xb5, 0, 0 }, /* #6 */
    { 0x360917, 0x360917, 0x17, 0xe8, 0, 0 }, /* #7 */
    { 0x117997, 0x117997, 0x4d, 0xb2, 0, 0 }, /* #8 */
    { 0x306957, 0x306957, 0x43, 0xbc, 0, 0 }, /* #9 */
    { 0x130d06, 0x130d06, 0xa4, 0x5b, 0, 0 }, /* #10 */
    { 0x024487, 0x024487, 0x20, 0xdf, 0, 0 }, /* #11 */
    { 0x3571d6, 0x3571d6, 0xd0, 0x2f, 0, 0 }, /* #12 */
    { 0x0b13d2, 0x0b13d2, 0x74, 0x8b, 0, 0 }, /* #13 */
    { 0x067083, 0x067083, 0x70, 0x8f, 0, 0 }, /* #14 */
    { 0x3b4cc3, 0x3b4cc3, 0x21, 0xde, 0, 0 }, /* #15 */
    { 0x275807, 0x275807, 0x47, 0xb8, 0, 0 }, /* #16 */
    { 0x3c0816, 0x3c0816, 0x90, 0x6f, 0, 0 }, /* #17 */
    { 0x024fd3, 0x024fd3, 0x43, 0xbc, 0, 0 }, /* #18 */
    { 0x0a0a57, 0x0a0a57, 0xc9, 0x36, 0, 0 }, /* #19 */
    { 0x1a16c7, 0x1a16c7, 0x59, 0xa6, 0, 0 }, /* #20 */
    { 0x260396, 0x260396, 0xae, 0x51, 0, 0 }, /* #21 */
    { 0x092617, 0x092617, 0xf2, 0x0d, 0, 0 }, /* #22 */
    { 0x0850c7, 0x0850c7, 0xb3, 0x4c, 0, 0 }, /* #23 */
    { 0x2c6012, 0x2c6012, 0x6f, 0x90, 0, 0 }, /* #24 */
    { 0x3f2412, 0x3f2412, 0x39, 0xc6, 0, 0 }, /* #25 */
    { 0x2a3b86, 0x2a3b86, 0x02, 0xfd, 0, 0 }, /* #26 */
    { 0x1160d3, 0x1160d3, 0x5e, 0xa1, 0, 0 }, /* #27 */
    { 0x0d0707, 0x0d0707, 0xe2, 0x1d, 0, 0 }, /* #28 */
    { 0x0e21c2, 0x0e21c2, 0x9d, 0x62, 0, 0 }, /* #29 */
    { 0x347b57, 0x347b57, 0x51, 0xae, 0, 0 }, /* #30 */
    { 0x3c69c7, 0x3c69c7, 0x5f, 0xa0, 0, 0 }, /* #31 */
    { 0x194612, 0x194612, 0xfb, 0x04, 0, 0 }, /* #32 */
    { 0x3e4e82, 0x3e4e82, 0xc8, 0x37, 0, 0 }, /* #33 */
    { 0x332196, 0x332196, 0x7d, 0x82, 0, 0 }, /* #34 */
    { 0x3f6d57, 0x3f6d57, 0xa6, 0x59, 0, 0 }, /* #35 */
    { 0x064bd3, 0x064bd3, 0x16, 0xe9, 0, 0 }, /* #36 */
    { 0x2b45d3, 0x2b45d3, 0x7c, 0x83, 0, 0 }, /* #37 */
    { 0x290357, 0x290357, 0xde, 0x21, 0, 0 }, /* #38 */
    { 0x300082, 0x300082, 0x7e, 0x81, 0, 0 }, /* #39 */
    { 0x365807, 0x365807, 0xa5, 0x5a, 0, 0 }, /* #40 */
    { 0x056d07, 0x056d07, 0x5a, 0xa5, 0, 0 }, /* #41 */
    { 0x084f03, 0x084f03, 0x93, 0x6c, 0, 0 }, /* #42 */
    { 0x1857c3, 0x1857c3, 0xc9, 0x36, 0, 0 }, /* #43 */
    { 0x226e52, 0x226e52, 0x51, 0xae, 0, 0 }, /* #44 */
    { 0x130a87, 0x130a87, 0x8f, 0x70, 0, 0 }, /* #45 */
    { 0x374102, 0x374102, 0x99, 0x66, 0, 0 }, /* #46 */
    { 0x1a1292, 0x1a1292, 0xbf, 0x40, 0, 0 }, /* #47 */
    { 0x3752c2, 0x3752c2, 0x3c, 0xc3, 0, 0 }, /* #48 */
    { 0x126ed3, 0x126ed3, 0x5e, 0xa1, 0, 0 }, /* #49 */
    { 0x165bc6, 0x165bc6, 0x5b, 0xa4, 0, 0 }, /* #50 */
    { 0x067c43, 0x067c43, 0x59, 0xa6, 0, 0 }, /* #51 */
    { 0x0547d2, 0x0547d2, 0x8e, 0x71, 0, 0 }, /* #52 */
    { 0x3d4c56, 0x3d4c56, 0x0d, 0xf2, 0, 0 }, /* #53 */
    { 0x1d0182, 0x1d0182, 0xbb, 0x44, 0, 0 }, /* #54 */
    { 0x395147, 0x395147, 0x7e, 0x81, 0, 0 }, /* #55 */
    { 0x3c1a57, 0x3c1a57, 0x77, 0x88, 0, 0 }, /* #56 */
    { 0x036f82, 0x036f82, 0xb9, 0x46, 0, 0 }, /* #57 */
    { 0x206413, 0x206413, 0x05, 0xfa, 0, 0 }, /* #58 */
    { 0x374812, 0x374812, 0x68, 0x97, 0, 0 }, /* #59 */
    { 0x0c3057, 0x0c3057, 0xfe, 0x01, 0, 0 }, /* #60 */
    { 0x1c37c3, 0x1c37c3, 0x39, 0xc6, 0, 0 }, /* #61 */
    { 0x043812, 0x043812, 0x08, 0xf7, 0, 0 }, /* #62 */
    { 0x0516d6, 0x0516d6, 0x4b, 0xb4, 0, 0 }, /* #63 */
    { 0x2b7613, 0x2b7613, 0x6a, 0x95, 0, 0 }, /* #64 */
    { 0x225892, 0x225892, 0x44, 0xbb, 0, 0 }, /* #65 */
    { 0x391602, 0x391602, 0x49, 0xb6, 0, 0 }, /* #66 */
    { 0x2c3b06, 0x2c3b06, 0x9a, 0x65, 0, 0 }, /* #67 */
    { 0x086352, 0x086352, 0x34, 0xcb, 0, 0 }, /* #68 */
    { 0x114e06, 0x114e06, 0xd6, 0x29, 0, 0 }, /* #69 */
    { 0x384f16, 0x384f16, 0xe5, 0x1a, 0, 0 }, /* #70 */
    { 0x2b18d7, 0x2b18d7, 0x2a, 0xd5, 0, 0 }, /* #71 */
    { 0x1c7c46, 0x1c7c46, 0xab, 0x54, 0, 0 }, /* #72 */
    { 0x2e2cd2, 0x2e2cd2, 0xe5, 0x1a, 0, 0 }, /* #73 */
    { 0x2c6a46, 0x2c6a46, 0x2b, 0xd4, 0, 0 }, /* #74 */
    { 0x214d42, 0x214d42, 0x14, 0xeb, 0, 0 }, /* #75 */
    { 0x232b92, 0x232b92, 0x97, 0x68, 0, 0 }, /* #76 */
    { 0x2d2a17, 0x2d2a17, 0x2e, 0xd1, 0, 0 }, /* #77 */
    { 0x0d2dd7, 0x0d2dd7, 0x62, 0x9d, 0, 0 }, /* #78 */
    { 0x0b3cc7, 0x0b3cc7, 0x5f, 0xa0, 0, 0 }, /* #79 */
    { 0x3b1357, 0x3b1357, 0x41, 0xbe, 0, 0 }, /* #80 */
    { 0x222c56, 0x222c56, 0xa5, 0x5a, 0, 0 }, /* #81 */
    { 0x244397, 0x244397, 0x64, 0x9b, 0, 0 }, /* #82 */
    { 0x056157, 0x056157, 0x46, 0xb9, 0, 0 }, /* #83 */
    { 0x105dd7, 0x105dd7, 0x72, 0x8d, 0, 0 }, /* #84 */
    { 0x375a46, 0x375a46, 0x98, 0x67, 0, 0 }, /* #85 */
    { 0x315116, 0x315116, 0x3d, 0xc2, 0, 0 }, /* #86 */
    { 0x1d1d12, 0x1d1d12, 0x91, 0x6e, 0, 0 }, /* #87 */
    { 0x355546, 0x355546, 0xba, 0x45, 0, 0 }, /* #88 */
    { 0x274853, 0x274853, 0x3a, 0xc5, 0, 0 }, /* #89 */
    { 0x133816, 0x133816, 0xdb, 0x24, 0, 0 }, /* #90 */
    { 0x187e82, 0x187e82, 0xa4, 0x5b, 0, 0 }, /* #91 */
    { 0x095703, 0x095703, 0x96, 0x69, 0, 0 }, /* #92 */
    { 0x266f53, 0x266f53, 0x16, 0xe9, 0, 0 }, /* #93 */
    { 0x290896, 0x290896, 0x03, 0xfc, 0, 0 }, /* #94 */
    { 0x144dc3, 0x144dc3, 0x44, 0xbb, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_not_u8 = RT_ELEMENTS(g_aTests_not_u8);

BINU8_TEST_T const g_aTests_not_u8_locked[] =
{
    { 0x092197, 0x092197, 0x1d, 0xe2, 0, 0 }, /* #0 */
    { 0x2b0452, 0x2b0452, 0x62, 0x9d, 0, 0 }, /* #1 */
    { 0x3d7813, 0x3d7813, 0xa7, 0x58, 0, 0 }, /* #2 */
    { 0x3542c7, 0x3542c7, 0xb3, 0x4c, 0, 0 }, /* #3 */
    { 0x017b06, 0x017b06, 0x3d, 0xc2, 0, 0 }, /* #4 */
    { 0x3731c3, 0x3731c3, 0x81, 0x7e, 0, 0 }, /* #5 */
    { 0x3611d6, 0x3611d6, 0x69, 0x96, 0, 0 }, /* #6 */
    { 0x3d5607, 0x3d5607, 0x61, 0x9e, 0, 0 }, /* #7 */
    { 0x1a5187, 0x1a5187, 0x62, 0x9d, 0, 0 }, /* #8 */
    { 0x156b83, 0x156b83, 0xab, 0x54, 0, 0 }, /* #9 */
    { 0x0a4442, 0x0a4442, 0xfa, 0x05, 0, 0 }, /* #10 */
    { 0x340553, 0x340553, 0x9a, 0x65, 0, 0 }, /* #11 */
    { 0x047446, 0x047446, 0x33, 0xcc, 0, 0 }, /* #12 */
    { 0x0b7f07, 0x0b7f07, 0x48, 0xb7, 0, 0 }, /* #13 */
    { 0x387047, 0x387047, 0x6a, 0x95, 0, 0 }, /* #14 */
    { 0x2b7f96, 0x2b7f96, 0x69, 0x96, 0, 0 }, /* #15 */
    { 0x3c4b07, 0x3c4b07, 0xfc, 0x03, 0, 0 }, /* #16 */
    { 0x2a1382, 0x2a1382, 0xc2, 0x3d, 0, 0 }, /* #17 */
    { 0x2860d3, 0x2860d3, 0x68, 0x97, 0, 0 }, /* #18 */
    { 0x2b7152, 0x2b7152, 0x06, 0xf9, 0, 0 }, /* #19 */
    { 0x394853, 0x394853, 0x26, 0xd9, 0, 0 }, /* #20 */
    { 0x177ac2, 0x177ac2, 0x43, 0xbc, 0, 0 }, /* #21 */
    { 0x1067c2, 0x1067c2, 0x2c, 0xd3, 0, 0 }, /* #22 */
    { 0x025f57, 0x025f57, 0xe7, 0x18, 0, 0 }, /* #23 */
    { 0x2b4687, 0x2b4687, 0xe1, 0x1e, 0, 0 }, /* #24 */
    { 0x3a2857, 0x3a2857, 0x01, 0xfe, 0, 0 }, /* #25 */
    { 0x385103, 0x385103, 0x9e, 0x61, 0, 0 }, /* #26 */
    { 0x104cd6, 0x104cd6, 0xb1, 0x4e, 0, 0 }, /* #27 */
    { 0x1d5256, 0x1d5256, 0x8e, 0x71, 0, 0 }, /* #28 */
    { 0x2d53d2, 0x2d53d2, 0xef, 0x10, 0, 0 }, /* #29 */
    { 0x020213, 0x020213, 0xe8, 0x17, 0, 0 }, /* #30 */
    { 0x2a7ad6, 0x2a7ad6, 0x04, 0xfb, 0, 0 }, /* #31 */
    { 0x0a17d6, 0x0a17d6, 0xb9, 0x46, 0, 0 }, /* #32 */
    { 0x3f5986, 0x3f5986, 0xc4, 0x3b, 0, 0 }, /* #33 */
    { 0x327a16, 0x327a16, 0xbd, 0x42, 0, 0 }, /* #34 */
    { 0x3115c6, 0x3115c6, 0x8f, 0x70, 0, 0 }, /* #35 */
    { 0x2f3156, 0x2f3156, 0xf8, 0x07, 0, 0 }, /* #36 */
    { 0x397003, 0x397003, 0x7e, 0x81, 0, 0 }, /* #37 */
    { 0x371e02, 0x371e02, 0xa6, 0x59, 0, 0 }, /* #38 */
    { 0x195206, 0x195206, 0xf4, 0x0b, 0, 0 }, /* #39 */
    { 0x3579d2, 0x3579d2, 0x94, 0x6b, 0, 0 }, /* #40 */
    { 0x2a4312, 0x2a4312, 0x52, 0xad, 0, 0 }, /* #41 */
    { 0x2c33c2, 0x2c33c2, 0xdd, 0x22, 0, 0 }, /* #42 */
    { 0x2f0556, 0x2f0556, 0x8e, 0x71, 0, 0 }, /* #43 */
    { 0x023613, 0x023613, 0xbb, 0x44, 0, 0 }, /* #44 */
    { 0x290d13, 0x290d13, 0xdb, 0x24, 0, 0 }, /* #45 */
    { 0x1d29c6, 0x1d29c6, 0x0c, 0xf3, 0, 0 }, /* #46 */
    { 0x292a03, 0x292a03, 0x65, 0x9a, 0, 0 }, /* #47 */
    { 0x3620c3, 0x3620c3, 0xc2, 0x3d, 0, 0 }, /* #48 */
    { 0x005797, 0x005797, 0x9a, 0x65, 0, 0 }, /* #49 */
    { 0x003f03, 0x003f03, 0xf5, 0x0a, 0, 0 }, /* #50 */
    { 0x367306, 0x367306, 0x1f, 0xe0, 0, 0 }, /* #51 */
    { 0x3d7682, 0x3d7682, 0xf1, 0x0e, 0, 0 }, /* #52 */
    { 0x0d2597, 0x0d2597, 0xdc, 0x23, 0, 0 }, /* #53 */
    { 0x001117, 0x001117, 0x18, 0xe7, 0, 0 }, /* #54 */
    { 0x326a52, 0x326a52, 0xa3, 0x5c, 0, 0 }, /* #55 */
    { 0x3264c7, 0x3264c7, 0x8c, 0x73, 0, 0 }, /* #56 */
    { 0x170e57, 0x170e57, 0x48, 0xb7, 0, 0 }, /* #57 */
    { 0x2d7943, 0x2d7943, 0xd6, 0x29, 0, 0 }, /* #58 */
    { 0x3a5e97, 0x3a5e97, 0xbd, 0x42, 0, 0 }, /* #59 */
    { 0x0b28c3, 0x0b28c3, 0x97, 0x68, 0, 0 }, /* #60 */
    { 0x1a62d6, 0x1a62d6, 0xfe, 0x01, 0, 0 }, /* #61 */
    { 0x083ad3, 0x083ad3, 0xc3, 0x3c, 0, 0 }, /* #62 */
    { 0x375cc2, 0x375cc2, 0xce, 0x31, 0, 0 }, /* #63 */
    { 0x102442, 0x102442, 0x71, 0x8e, 0, 0 }, /* #64 */
    { 0x296e83, 0x296e83, 0xe2, 0x1d, 0, 0 }, /* #65 */
    { 0x0d3413, 0x0d3413, 0x3a, 0xc5, 0, 0 }, /* #66 */
    { 0x0b7446, 0x0b7446, 0x5e, 0xa1, 0, 0 }, /* #67 */
    { 0x1116d7, 0x1116d7, 0x67, 0x98, 0, 0 }, /* #68 */
    { 0x337957, 0x337957, 0x35, 0xca, 0, 0 }, /* #69 */
    { 0x382857, 0x382857, 0xd4, 0x2b, 0, 0 }, /* #70 */
    { 0x072052, 0x072052, 0xb7, 0x48, 0, 0 }, /* #71 */
    { 0x1463d3, 0x1463d3, 0x36, 0xc9, 0, 0 }, /* #72 */
    { 0x142b13, 0x142b13, 0x58, 0xa7, 0, 0 }, /* #73 */
    { 0x0238c7, 0x0238c7, 0x1d, 0xe2, 0, 0 }, /* #74 */
    { 0x223e46, 0x223e46, 0x78, 0x87, 0, 0 }, /* #75 */
    { 0x3d5712, 0x3d5712, 0xdf, 0x20, 0, 0 }, /* #76 */
    { 0x210802, 0x210802, 0xd9, 0x26, 0, 0 }, /* #77 */
    { 0x1f5947, 0x1f5947, 0x10, 0xef, 0, 0 }, /* #78 */
    { 0x3b6d97, 0x3b6d97, 0x44, 0xbb, 0, 0 }, /* #79 */
    { 0x060a83, 0x060a83, 0x91, 0x6e, 0, 0 }, /* #80 */
    { 0x0c6093, 0x0c6093, 0x07, 0xf8, 0, 0 }, /* #81 */
    { 0x2a42d3, 0x2a42d3, 0x6f, 0x90, 0, 0 }, /* #82 */
    { 0x200506, 0x200506, 0xd2, 0x2d, 0, 0 }, /* #83 */
    { 0x203803, 0x203803, 0xa4, 0x5b, 0, 0 }, /* #84 */
    { 0x344752, 0x344752, 0x95, 0x6a, 0, 0 }, /* #85 */
    { 0x095446, 0x095446, 0x99, 0x66, 0, 0 }, /* #86 */
    { 0x0d2293, 0x0d2293, 0x89, 0x76, 0, 0 }, /* #87 */
    { 0x262212, 0x262212, 0x55, 0xaa, 0, 0 }, /* #88 */
    { 0x2e7486, 0x2e7486, 0xbd, 0x42, 0, 0 }, /* #89 */
    { 0x0340d6, 0x0340d6, 0x0f, 0xf0, 0, 0 }, /* #90 */
    { 0x111f16, 0x111f16, 0x0a, 0xf5, 0, 0 }, /* #91 */
    { 0x353146, 0x353146, 0x83, 0x7c, 0, 0 }, /* #92 */
    { 0x395a97, 0x395a97, 0x74, 0x8b, 0, 0 }, /* #93 */
    { 0x150202, 0x150202, 0x06, 0xf9, 0, 0 }, /* #94 */
    { 0x110053, 0x110053, 0x69, 0x96, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_not_u8_locked = RT_ELEMENTS(g_aTests_not_u8_locked);

BINU8_TEST_T const g_aTests_neg_u8[] =
{
    { 0x066993, 0x066197, 0x4c, 0xb4, 0, 0 }, /* #0 */
    { 0x190197, 0x190113, 0x98, 0x68, 0, 0 }, /* #1 */
    { 0x094c93, 0x094493, 0x7d, 0x83, 0, 0 }, /* #2 */
    { 0x263413, 0x263413, 0x86, 0x7a, 0, 0 }, /* #3 */
    { 0x012c12, 0x012493, 0x76, 0x8a, 0, 0 }, /* #4 */
    { 0x0d4d03, 0x0d4513, 0xda, 0x26, 0, 0 }, /* #5 */
    { 0x1849d6, 0x184117, 0xd3, 0x2d, 0, 0 }, /* #6 */
    { 0x3a0403, 0x3a0497, 0x1c, 0xe4, 0, 0 }, /* #7 */
    { 0x203596, 0x203513, 0xc9, 0x37, 0, 0 }, /* #8 */
    { 0x343412, 0x343417, 0xe2, 0x1e, 0, 0 }, /* #9 */
    { 0x120e56, 0x120617, 0xe2, 0x1e, 0, 0 }, /* #10 */
    { 0x2423d7, 0x242317, 0xde, 0x22, 0, 0 }, /* #11 */
    { 0x0a1c03, 0x0a1413, 0xc8, 0x38, 0, 0 }, /* #12 */
    { 0x364643, 0x364693, 0x4b, 0xb5, 0, 0 }, /* #13 */
    { 0x314942, 0x314113, 0xa8, 0x58, 0, 0 }, /* #14 */
    { 0x0800d6, 0x080097, 0x36, 0xca, 0, 0 }, /* #15 */
    { 0x1051c6, 0x105193, 0x03, 0xfd, 0, 0 }, /* #16 */
    { 0x3d0956, 0x3d0113, 0xdd, 0x23, 0, 0 }, /* #17 */
    { 0x0d2253, 0x0d2297, 0x1e, 0xe2, 0, 0 }, /* #18 */
    { 0x3808d3, 0x380013, 0xa5, 0x5b, 0, 0 }, /* #19 */
    { 0x0c72c3, 0x0c7213, 0xed, 0x13, 0, 0 }, /* #20 */
    { 0x167682, 0x167693, 0x5c, 0xa4, 0, 0 }, /* #21 */
    { 0x120c87, 0x120497, 0x79, 0x87, 0, 0 }, /* #22 */
    { 0x3e32d6, 0x3e3297, 0x29, 0xd7, 0, 0 }, /* #23 */
    { 0x2b5117, 0x2b5193, 0x58, 0xa8, 0, 0 }, /* #24 */
    { 0x024453, 0x024497, 0x22, 0xde, 0, 0 }, /* #25 */
    { 0x097a17, 0x097213, 0x9e, 0x62, 0, 0 }, /* #26 */
    { 0x035002, 0x035097, 0x75, 0x8b, 0, 0 }, /* #27 */
    { 0x1c1f12, 0x1c1797, 0x0d, 0xf3, 0, 0 }, /* #28 */
    { 0x274186, 0x274113, 0xa3, 0x5d, 0, 0 }, /* #29 */
    { 0x3b6dc6, 0x3b6517, 0xe9, 0x17, 0, 0 }, /* #30 */
    { 0x3816c7, 0x381613, 0xba, 0x46, 0, 0 }, /* #31 */
    { 0x3e42c2, 0x3e4297, 0x6a, 0x96, 0, 0 }, /* #32 */
    { 0x116ac2, 0x116213, 0x8d, 0x73, 0, 0 }, /* #33 */
    { 0x3d2413, 0x3d2493, 0x0c, 0xf4, 0, 0 }, /* #34 */
    { 0x386383, 0x386317, 0xe9, 0x17, 0, 0 }, /* #35 */
    { 0x396982, 0x396113, 0xa3, 0x5d, 0, 0 }, /* #36 */
    { 0x1e1f83, 0x1e1746, 0x00, 0x00, 0, 0 }, /* #37 */
    { 0x213287, 0x213217, 0xa4, 0x5c, 0, 0 }, /* #38 */
    { 0x157cd7, 0x157403, 0xe0, 0x20, 0, 0 }, /* #39 */
    { 0x3a2293, 0x3a2217, 0x9a, 0x66, 0, 0 }, /* #40 */
    { 0x373146, 0x373117, 0xb8, 0x48, 0, 0 }, /* #41 */
    { 0x223847, 0x223097, 0x6a, 0x96, 0, 0 }, /* #42 */
    { 0x0a5356, 0x0a5397, 0x51, 0xaf, 0, 0 }, /* #43 */
    { 0x217c13, 0x217497, 0x12, 0xee, 0, 0 }, /* #44 */
    { 0x1d27d2, 0x1d2797, 0x23, 0xdd, 0, 0 }, /* #45 */
    { 0x152fc3, 0x152717, 0xcd, 0x33, 0, 0 }, /* #46 */
    { 0x287702, 0x287717, 0xa7, 0x59, 0, 0 }, /* #47 */
    { 0x1f7f52, 0x1f7713, 0xd1, 0x2f, 0, 0 }, /* #48 */
    { 0x0a1ad3, 0x0a1217, 0xc1, 0x3f, 0, 0 }, /* #49 */
    { 0x235143, 0x235197, 0x6a, 0x96, 0, 0 }, /* #50 */
    { 0x251643, 0x251693, 0x4b, 0xb5, 0, 0 }, /* #51 */
    { 0x1766d7, 0x176693, 0x1a, 0xe6, 0, 0 }, /* #52 */
    { 0x197f57, 0x197717, 0xf7, 0x09, 0, 0 }, /* #53 */
    { 0x3a00d7, 0x3a0017, 0x97, 0x69, 0, 0 }, /* #54 */
    { 0x024313, 0x024317, 0x8e, 0x72, 0, 0 }, /* #55 */
    { 0x340692, 0x340613, 0xb4, 0x4c, 0, 0 }, /* #56 */
    { 0x304ec3, 0x304617, 0xbf, 0x41, 0, 0 }, /* #57 */
    { 0x2a6886, 0x2a6017, 0x8f, 0x71, 0, 0 }, /* #58 */
    { 0x210cc2, 0x210417, 0xc4, 0x3c, 0, 0 }, /* #59 */
    { 0x286e93, 0x286613, 0x84, 0x7c, 0, 0 }, /* #60 */
    { 0x185747, 0x185797, 0x7f, 0x81, 0, 0 }, /* #61 */
    { 0x2e6456, 0x2e6417, 0x91, 0x6f, 0, 0 }, /* #62 */
    { 0x3e32d2, 0x3e3217, 0xd8, 0x28, 0, 0 }, /* #63 */
    { 0x0b5582, 0x0b5593, 0x63, 0x9d, 0, 0 }, /* #64 */
    { 0x152013, 0x152013, 0x84, 0x7c, 0, 0 }, /* #65 */
    { 0x2a7747, 0x2a7717, 0xa4, 0x5c, 0, 0 }, /* #66 */
    { 0x282c87, 0x282417, 0xb3, 0x4d, 0, 0 }, /* #67 */
    { 0x0a7fc2, 0x0a7713, 0xd7, 0x29, 0, 0 }, /* #68 */
    { 0x172682, 0x172697, 0x22, 0xde, 0, 0 }, /* #69 */
    { 0x050287, 0x050213, 0x92, 0x6e, 0, 0 }, /* #70 */
    { 0x1e2b47, 0x1e2317, 0x91, 0x6f, 0, 0 }, /* #71 */
    { 0x007902, 0x007193, 0x69, 0x97, 0, 0 }, /* #72 */
    { 0x225b17, 0x225313, 0xd7, 0x29, 0, 0 }, /* #73 */
    { 0x0e3053, 0x0e3093, 0x63, 0x9d, 0, 0 }, /* #74 */
    { 0x2b7f47, 0x2b7717, 0xbf, 0x41, 0, 0 }, /* #75 */
    { 0x0402c7, 0x040293, 0x14, 0xec, 0, 0 }, /* #76 */
    { 0x0e7cc3, 0x0e7417, 0xf6, 0x0a, 0, 0 }, /* #77 */
    { 0x381946, 0x381113, 0xe7, 0x19, 0, 0 }, /* #78 */
    { 0x2435d6, 0x243513, 0xd1, 0x2f, 0, 0 }, /* #79 */
    { 0x292c52, 0x292493, 0x58, 0xa8, 0, 0 }, /* #80 */
    { 0x137353, 0x137397, 0x2e, 0xd2, 0, 0 }, /* #81 */
    { 0x296b57, 0x296313, 0x95, 0x6b, 0, 0 }, /* #82 */
    { 0x165d06, 0x165513, 0xf5, 0x0b, 0, 0 }, /* #83 */
    { 0x295c92, 0x295417, 0x97, 0x69, 0, 0 }, /* #84 */
    { 0x312b43, 0x312393, 0x6e, 0x92, 0, 0 }, /* #85 */
    { 0x2545c7, 0x254517, 0xec, 0x14, 0, 0 }, /* #86 */
    { 0x305b87, 0x305393, 0x6e, 0x92, 0, 0 }, /* #87 */
    { 0x356f17, 0x356793, 0x4b, 0xb5, 0, 0 }, /* #88 */
    { 0x253297, 0x253297, 0x37, 0xc9, 0, 0 }, /* #89 */
    { 0x3e3c57, 0x3e3497, 0x5a, 0xa6, 0, 0 }, /* #90 */
    { 0x3f6dd6, 0x3f6513, 0x98, 0x68, 0, 0 }, /* #91 */
    { 0x395252, 0x395207, 0xb0, 0x50, 0, 0 }, /* #92 */
    { 0x2d5a87, 0x2d5213, 0xfe, 0x02, 0, 0 }, /* #93 */
    { 0x2f1246, 0x2f1293, 0x58, 0xa8, 0, 0 }, /* #94 */
    { 0x2f54d2, 0x2f5493, 0x05, 0xfb, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_neg_u8 = RT_ELEMENTS(g_aTests_neg_u8);

BINU8_TEST_T const g_aTests_neg_u8_locked[] =
{
    { 0x2e4383, 0x2e4317, 0xa1, 0x5f, 0, 0 }, /* #0 */
    { 0x1306c6, 0x130693, 0x11, 0xef, 0, 0 }, /* #1 */
    { 0x3e5406, 0x3e5413, 0xba, 0x46, 0, 0 }, /* #2 */
    { 0x3c4ec3, 0x3c4617, 0xe8, 0x18, 0, 0 }, /* #3 */
    { 0x0440d2, 0x044013, 0xda, 0x26, 0, 0 }, /* #4 */
    { 0x2d1387, 0x2d1317, 0x9d, 0x63, 0, 0 }, /* #5 */
    { 0x2941c7, 0x294197, 0x06, 0xfa, 0, 0 }, /* #6 */
    { 0x201796, 0x201713, 0x9e, 0x62, 0, 0 }, /* #7 */
    { 0x077712, 0x077717, 0xdf, 0x21, 0, 0 }, /* #8 */
    { 0x100407, 0x100413, 0xbd, 0x43, 0, 0 }, /* #9 */
    { 0x3b7403, 0x3b7497, 0x36, 0xca, 0, 0 }, /* #10 */
    { 0x187703, 0x187797, 0x67, 0x99, 0, 0 }, /* #11 */
    { 0x186f56, 0x186717, 0xe9, 0x17, 0, 0 }, /* #12 */
    { 0x163b43, 0x163397, 0x19, 0xe7, 0, 0 }, /* #13 */
    { 0x271143, 0x271117, 0xd8, 0x28, 0, 0 }, /* #14 */
    { 0x133e46, 0x133617, 0xef, 0x11, 0, 0 }, /* #15 */
    { 0x0a7bd2, 0x0a7313, 0xbb, 0x45, 0, 0 }, /* #16 */
    { 0x116d87, 0x116513, 0xc9, 0x37, 0, 0 }, /* #17 */
    { 0x1b3557, 0x1b3597, 0x3a, 0xc6, 0, 0 }, /* #18 */
    { 0x284e16, 0x284697, 0x19, 0xe7, 0, 0 }, /* #19 */
    { 0x2f2943, 0x2f2117, 0xec, 0x14, 0, 0 }, /* #20 */
    { 0x080b47, 0x080317, 0x88, 0x78, 0, 0 }, /* #21 */
    { 0x233987, 0x233113, 0xf2, 0x0e, 0, 0 }, /* #22 */
    { 0x0e7e97, 0x0e7697, 0x42, 0xbe, 0, 0 }, /* #23 */
    { 0x300cc3, 0x300417, 0x97, 0x69, 0, 0 }, /* #24 */
    { 0x334bc7, 0x334303, 0xf0, 0x10, 0, 0 }, /* #25 */
    { 0x2c1843, 0x2c1093, 0x0c, 0xf4, 0, 0 }, /* #26 */
    { 0x070303, 0x070393, 0x69, 0x97, 0, 0 }, /* #27 */
    { 0x245286, 0x245297, 0x01, 0xff, 0, 0 }, /* #28 */
    { 0x177342, 0x177317, 0xf6, 0x0a, 0, 0 }, /* #29 */
    { 0x3a7a13, 0x3a7213, 0x99, 0x67, 0, 0 }, /* #30 */
    { 0x0f3e13, 0x0f3613, 0xeb, 0x15, 0, 0 }, /* #31 */
    { 0x072c83, 0x072493, 0x05, 0xfb, 0, 0 }, /* #32 */
    { 0x0f7a97, 0x0f7293, 0x1d, 0xe3, 0, 0 }, /* #33 */
    { 0x0a6e13, 0x0a6617, 0xdf, 0x21, 0, 0 }, /* #34 */
    { 0x375682, 0x375697, 0x2f, 0xd1, 0, 0 }, /* #35 */
    { 0x220202, 0x220293, 0x58, 0xa8, 0, 0 }, /* #36 */
    { 0x386ac7, 0x386217, 0xa6, 0x5a, 0, 0 }, /* #37 */
    { 0x334987, 0x334117, 0xb9, 0x47, 0, 0 }, /* #38 */
    { 0x131f16, 0x131797, 0x23, 0xdd, 0, 0 }, /* #39 */
    { 0x2b6f16, 0x2b6797, 0x04, 0xfc, 0, 0 }, /* #40 */
    { 0x143c02, 0x143497, 0x64, 0x9c, 0, 0 }, /* #41 */
    { 0x296052, 0x296097, 0x06, 0xfa, 0, 0 }, /* #42 */
    { 0x1842c6, 0x184213, 0xfc, 0x04, 0, 0 }, /* #43 */
    { 0x251193, 0x251193, 0x02, 0xfe, 0, 0 }, /* #44 */
    { 0x3b7d57, 0x3b7513, 0xb1, 0x4f, 0, 0 }, /* #45 */
    { 0x034903, 0x034117, 0xf6, 0x0a, 0, 0 }, /* #46 */
    { 0x392c46, 0x392493, 0x32, 0xce, 0, 0 }, /* #47 */
    { 0x0b3452, 0x0b3493, 0x0c, 0xf4, 0, 0 }, /* #48 */
    { 0x1c2516, 0x1c2593, 0x77, 0x89, 0, 0 }, /* #49 */
    { 0x296002, 0x296097, 0x54, 0xac, 0, 0 }, /* #50 */
    { 0x330507, 0x330593, 0x47, 0xb9, 0, 0 }, /* #51 */
    { 0x3468c7, 0x346097, 0x75, 0x8b, 0, 0 }, /* #52 */
    { 0x3740d3, 0x374083, 0x20, 0xe0, 0, 0 }, /* #53 */
    { 0x1d7256, 0x1d7297, 0x66, 0x9a, 0, 0 }, /* #54 */
    { 0x3c3d06, 0x3c3597, 0x73, 0x8d, 0, 0 }, /* #55 */
    { 0x122b06, 0x122393, 0x68, 0x98, 0, 0 }, /* #56 */
    { 0x3c24d3, 0x3c2493, 0x24, 0xdc, 0, 0 }, /* #57 */
    { 0x3d7187, 0x3d7117, 0xb9, 0x47, 0, 0 }, /* #58 */
    { 0x124513, 0x124517, 0x82, 0x7e, 0, 0 }, /* #59 */
    { 0x340783, 0x340797, 0x51, 0xaf, 0, 0 }, /* #60 */
    { 0x347d06, 0x347597, 0x18, 0xe8, 0, 0 }, /* #61 */
    { 0x3d0ad6, 0x3d0297, 0x1f, 0xe1, 0, 0 }, /* #62 */
    { 0x093fd7, 0x093717, 0xde, 0x22, 0, 0 }, /* #63 */
    { 0x304082, 0x304093, 0x17, 0xe9, 0, 0 }, /* #64 */
    { 0x0d1f12, 0x0d1797, 0x2c, 0xd4, 0, 0 }, /* #65 */
    { 0x1457d6, 0x145713, 0x87, 0x79, 0, 0 }, /* #66 */
    { 0x2e5046, 0x2e5013, 0x81, 0x7f, 0, 0 }, /* #67 */
    { 0x3b6697, 0x3b6697, 0x3b, 0xc5, 0, 0 }, /* #68 */
    { 0x260646, 0x260693, 0x4a, 0xb6, 0, 0 }, /* #69 */
    { 0x310e42, 0x310617, 0xc6, 0x3a, 0, 0 }, /* #70 */
    { 0x3224c7, 0x322403, 0xe0, 0x20, 0, 0 }, /* #71 */
    { 0x111f02, 0x111797, 0x2f, 0xd1, 0, 0 }, /* #72 */
    { 0x381706, 0x381797, 0x07, 0xf9, 0, 0 }, /* #73 */
    { 0x3605c6, 0x360597, 0x72, 0x8e, 0, 0 }, /* #74 */
    { 0x3b65c6, 0x3b6597, 0x3b, 0xc5, 0, 0 }, /* #75 */
    { 0x246502, 0x246513, 0xfe, 0x02, 0, 0 }, /* #76 */
    { 0x1d7752, 0x1d7797, 0x04, 0xfc, 0, 0 }, /* #77 */
    { 0x210a97, 0x210213, 0xb1, 0x4f, 0, 0 }, /* #78 */
    { 0x144247, 0x144217, 0xd8, 0x28, 0, 0 }, /* #79 */
    { 0x003ed2, 0x003613, 0xd6, 0x2a, 0, 0 }, /* #80 */
    { 0x295512, 0x295597, 0x7f, 0x81, 0, 0 }, /* #81 */
    { 0x1c1b47, 0x1c1317, 0xb5, 0x4b, 0, 0 }, /* #82 */
    { 0x052503, 0x052513, 0x81, 0x7f, 0, 0 }, /* #83 */
    { 0x3a2702, 0x3a2713, 0xac, 0x54, 0, 0 }, /* #84 */
    { 0x1f3443, 0x1f3413, 0xeb, 0x15, 0, 0 }, /* #85 */
    { 0x307042, 0x307093, 0x47, 0xb9, 0, 0 }, /* #86 */
    { 0x187056, 0x187093, 0x62, 0x9e, 0, 0 }, /* #87 */
    { 0x014a12, 0x014293, 0x02, 0xfe, 0, 0 }, /* #88 */
    { 0x137dd3, 0x137593, 0x2d, 0xd3, 0, 0 }, /* #89 */
    { 0x3d6917, 0x3d6117, 0xe5, 0x1b, 0, 0 }, /* #90 */
    { 0x047392, 0x047313, 0xfe, 0x02, 0, 0 }, /* #91 */
    { 0x360c42, 0x360413, 0xd7, 0x29, 0, 0 }, /* #92 */
    { 0x0c2292, 0x0c2217, 0x91, 0x6f, 0, 0 }, /* #93 */
    { 0x197042, 0x197013, 0x86, 0x7a, 0, 0 }, /* #94 */
    { 0x0976d2, 0x097617, 0xd3, 0x2d, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_neg_u8_locked = RT_ELEMENTS(g_aTests_neg_u8_locked);

BINU16_TEST_T const g_aTests_inc_u16[] =
{
    { 0x196b46, 0x196382, 0x8824, 0x8825, 0, 0 }, /* #0 */
    { 0x1537c3, 0x153787, 0xad47, 0xad48, 0, 0 }, /* #1 */
    { 0x280d96, 0x280586, 0xf468, 0xf469, 0, 0 }, /* #2 */
    { 0x0942d7, 0x094287, 0xb913, 0xb914, 0, 0 }, /* #3 */
    { 0x3b6612, 0x3b6682, 0xf503, 0xf504, 0, 0 }, /* #4 */
    { 0x322a46, 0x322286, 0xff5b, 0xff5c, 0, 0 }, /* #5 */
    { 0x114f17, 0x114707, 0x077c, 0x077d, 0, 0 }, /* #6 */
    { 0x144ec7, 0x144683, 0xca15, 0xca16, 0, 0 }, /* #7 */
    { 0x305917, 0x305107, 0x210e, 0x210f, 0, 0 }, /* #8 */
    { 0x0c71c7, 0x0c7103, 0x179d, 0x179e, 0, 0 }, /* #9 */
    { 0x370842, 0x370002, 0x3060, 0x3061, 0, 0 }, /* #10 */
    { 0x3b3ed3, 0x3b3683, 0xab50, 0xab51, 0, 0 }, /* #11 */
    { 0x081697, 0x081607, 0x1f1a, 0x1f1b, 0, 0 }, /* #12 */
    { 0x172f47, 0x172783, 0xa263, 0xa264, 0, 0 }, /* #13 */
    { 0x134bd2, 0x134386, 0xbe16, 0xbe17, 0, 0 }, /* #14 */
    { 0x266342, 0x266382, 0xe563, 0xe564, 0, 0 }, /* #15 */
    { 0x320f16, 0x320702, 0x5c85, 0x5c86, 0, 0 }, /* #16 */
    { 0x0a5283, 0x0a5287, 0x829e, 0x829f, 0, 0 }, /* #17 */
    { 0x2f26d3, 0x2f2603, 0x3d5d, 0x3d5e, 0, 0 }, /* #18 */
    { 0x3741c3, 0x374187, 0x9e6e, 0x9e6f, 0, 0 }, /* #19 */
    { 0x354d92, 0x354502, 0x0ed8, 0x0ed9, 0, 0 }, /* #20 */
    { 0x3f5bc3, 0x3f5387, 0xbce6, 0xbce7, 0, 0 }, /* #21 */
    { 0x032717, 0x032707, 0x1c7c, 0x1c7d, 0, 0 }, /* #22 */
    { 0x367f52, 0x367706, 0x63c5, 0x63c6, 0, 0 }, /* #23 */
    { 0x383286, 0x383286, 0x8887, 0x8888, 0, 0 }, /* #24 */
    { 0x1e3dd2, 0x1e3586, 0x82dd, 0x82de, 0, 0 }, /* #25 */
    { 0x307a13, 0x307283, 0xfb9c, 0xfb9d, 0, 0 }, /* #26 */
    { 0x380552, 0x380506, 0x7721, 0x7722, 0, 0 }, /* #27 */
    { 0x2a40c2, 0x2a4082, 0x944b, 0x944c, 0, 0 }, /* #28 */
    { 0x2b23c2, 0x2b2302, 0x78f0, 0x78f1, 0, 0 }, /* #29 */
    { 0x134692, 0x134606, 0x1680, 0x1681, 0, 0 }, /* #30 */
    { 0x226906, 0x226106, 0x7d52, 0x7d53, 0, 0 }, /* #31 */
    { 0x212657, 0x212603, 0x24eb, 0x24ec, 0, 0 }, /* #32 */
    { 0x2b3693, 0x2b3603, 0x5e25, 0x5e26, 0, 0 }, /* #33 */
    { 0x0e2056, 0x0e2002, 0x4fe5, 0x4fe6, 0, 0 }, /* #34 */
    { 0x2e1e53, 0x2e1607, 0x3265, 0x3266, 0, 0 }, /* #35 */
    { 0x177d02, 0x177582, 0xf324, 0xf325, 0, 0 }, /* #36 */
    { 0x323cc7, 0x323403, 0x4afd, 0x4afe, 0, 0 }, /* #37 */
    { 0x025113, 0x025107, 0x4f83, 0x4f84, 0, 0 }, /* #38 */
    { 0x1e4152, 0x1e4196, 0xf4ef, 0xf4f0, 0, 0 }, /* #39 */
    { 0x320116, 0x320182, 0xc2e4, 0xc2e5, 0, 0 }, /* #40 */
    { 0x187ad3, 0x187203, 0x4842, 0x4843, 0, 0 }, /* #41 */
    { 0x310402, 0x310482, 0xd9f7, 0xd9f8, 0, 0 }, /* #42 */
    { 0x085993, 0x085103, 0x7fe2, 0x7fe3, 0, 0 }, /* #43 */
    { 0x011753, 0x011793, 0x90df, 0x90e0, 0, 0 }, /* #44 */
    { 0x2e0217, 0x2e0203, 0x1aa7, 0x1aa8, 0, 0 }, /* #45 */
    { 0x1c52d7, 0x1c5207, 0x3c68, 0x3c69, 0, 0 }, /* #46 */
    { 0x075f96, 0x075782, 0x80a7, 0x80a8, 0, 0 }, /* #47 */
    { 0x340196, 0x340186, 0xe454, 0xe455, 0, 0 }, /* #48 */
    { 0x306f06, 0x306702, 0x19cd, 0x19ce, 0, 0 }, /* #49 */
    { 0x2f1957, 0x2f1183, 0x9385, 0x9386, 0, 0 }, /* #50 */
    { 0x281d43, 0x281587, 0x8a80, 0x8a81, 0, 0 }, /* #51 */
    { 0x1c3757, 0x1c3783, 0x8991, 0x8992, 0, 0 }, /* #52 */
    { 0x080006, 0x080086, 0xc03b, 0xc03c, 0, 0 }, /* #53 */
    { 0x262d47, 0x262503, 0x3f00, 0x3f01, 0, 0 }, /* #54 */
    { 0x034247, 0x034203, 0x6051, 0x6052, 0, 0 }, /* #55 */
    { 0x300302, 0x300386, 0xe073, 0xe074, 0, 0 }, /* #56 */
    { 0x323f16, 0x323782, 0xac5a, 0xac5b, 0, 0 }, /* #57 */
    { 0x190e87, 0x190607, 0x636b, 0x636c, 0, 0 }, /* #58 */
    { 0x2a36d6, 0x2a3606, 0x5d2d, 0x5d2e, 0, 0 }, /* #59 */
    { 0x111b46, 0x111306, 0x7a27, 0x7a28, 0, 0 }, /* #60 */
    { 0x047042, 0x047086, 0xbed7, 0xbed8, 0, 0 }, /* #61 */
    { 0x0f54c2, 0x0f5482, 0xe4ad, 0xe4ae, 0, 0 }, /* #62 */
    { 0x0e6f43, 0x0e6703, 0x671b, 0x671c, 0, 0 }, /* #63 */
    { 0x271246, 0x271282, 0x9389, 0x938a, 0, 0 }, /* #64 */
    { 0x120ed6, 0x120682, 0xa025, 0xa026, 0, 0 }, /* #65 */
    { 0x3a5083, 0x3a5017, 0x2b9f, 0x2ba0, 0, 0 }, /* #66 */
    { 0x183383, 0x183307, 0x13d7, 0x13d8, 0, 0 }, /* #67 */
    { 0x095252, 0x095202, 0x6530, 0x6531, 0, 0 }, /* #68 */
    { 0x0102d3, 0x010203, 0x15b5, 0x15b6, 0, 0 }, /* #69 */
    { 0x0756c3, 0x075613, 0x2fcf, 0x2fd0, 0, 0 }, /* #70 */
    { 0x0f0d47, 0x0f0503, 0x0ba1, 0x0ba2, 0, 0 }, /* #71 */
    { 0x006c07, 0x006407, 0x3558, 0x3559, 0, 0 }, /* #72 */
    { 0x305186, 0x305106, 0x00f5, 0x00f6, 0, 0 }, /* #73 */
    { 0x015d86, 0x015586, 0xe868, 0xe869, 0, 0 }, /* #74 */
    { 0x205e42, 0x205606, 0x67d3, 0x67d4, 0, 0 }, /* #75 */
    { 0x056312, 0x056382, 0xddeb, 0xddec, 0, 0 }, /* #76 */
    { 0x2143d3, 0x214303, 0x750d, 0x750e, 0, 0 }, /* #77 */
    { 0x0c5bd2, 0x0c5302, 0x4044, 0x4045, 0, 0 }, /* #78 */
    { 0x360552, 0x360582, 0xa328, 0xa329, 0, 0 }, /* #79 */
    { 0x0763c6, 0x076382, 0xa4db, 0xa4dc, 0, 0 }, /* #80 */
    { 0x366587, 0x366503, 0x270c, 0x270d, 0, 0 }, /* #81 */
    { 0x2357c2, 0x235786, 0xdcbc, 0xdcbd, 0, 0 }, /* #82 */
    { 0x150253, 0x150207, 0x784d, 0x784e, 0, 0 }, /* #83 */
    { 0x1d3cd6, 0x1d3482, 0x9042, 0x9043, 0, 0 }, /* #84 */
    { 0x285cd6, 0x285486, 0xe817, 0xe818, 0, 0 }, /* #85 */
    { 0x3f1142, 0x3f1186, 0xb0ae, 0xb0af, 0, 0 }, /* #86 */
    { 0x063083, 0x063083, 0xa81e, 0xa81f, 0, 0 }, /* #87 */
    { 0x0f2b17, 0x0f2383, 0xe97e, 0xe97f, 0, 0 }, /* #88 */
    { 0x305dc2, 0x305506, 0x2521, 0x2522, 0, 0 }, /* #89 */
    { 0x282742, 0x282782, 0xc1b2, 0xc1b3, 0, 0 }, /* #90 */
    { 0x363847, 0x363093, 0xd01f, 0xd020, 0, 0 }, /* #91 */
    { 0x0c67c7, 0x0c6783, 0xd2a6, 0xd2a7, 0, 0 }, /* #92 */
    { 0x0f3a56, 0x0f3206, 0x2004, 0x2005, 0, 0 }, /* #93 */
    { 0x351796, 0x351702, 0x7693, 0x7694, 0, 0 }, /* #94 */
    { 0x3429c7, 0x342103, 0x3553, 0x3554, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_inc_u16 = RT_ELEMENTS(g_aTests_inc_u16);

BINU16_TEST_T const g_aTests_inc_u16_locked[] =
{
    { 0x0e3f57, 0x0e3787, 0x9839, 0x983a, 0, 0 }, /* #0 */
    { 0x116ed3, 0x116607, 0x1aed, 0x1aee, 0, 0 }, /* #1 */
    { 0x034ed2, 0x034602, 0x1797, 0x1798, 0, 0 }, /* #2 */
    { 0x133382, 0x133302, 0x1cf0, 0x1cf1, 0, 0 }, /* #3 */
    { 0x010e46, 0x010602, 0x7e01, 0x7e02, 0, 0 }, /* #4 */
    { 0x0601c7, 0x060107, 0x0c47, 0x0c48, 0, 0 }, /* #5 */
    { 0x234987, 0x234183, 0x9831, 0x9832, 0, 0 }, /* #6 */
    { 0x283693, 0x283687, 0xe58d, 0xe58e, 0, 0 }, /* #7 */
    { 0x207696, 0x207692, 0xc53f, 0xc540, 0, 0 }, /* #8 */
    { 0x312c87, 0x312483, 0xcd1e, 0xcd1f, 0, 0 }, /* #9 */
    { 0x221907, 0x221107, 0x1a9e, 0x1a9f, 0, 0 }, /* #10 */
    { 0x135082, 0x135002, 0x0c50, 0x0c51, 0, 0 }, /* #11 */
    { 0x106543, 0x106587, 0x9f2d, 0x9f2e, 0, 0 }, /* #12 */
    { 0x3a6292, 0x3a6286, 0xa27c, 0xa27d, 0, 0 }, /* #13 */
    { 0x297896, 0x297002, 0x1996, 0x1997, 0, 0 }, /* #14 */
    { 0x276196, 0x276106, 0x70c2, 0x70c3, 0, 0 }, /* #15 */
    { 0x325212, 0x325286, 0xa3d7, 0xa3d8, 0, 0 }, /* #16 */
    { 0x1f03d6, 0x1f0302, 0x6290, 0x6291, 0, 0 }, /* #17 */
    { 0x3f7313, 0x3f7303, 0x10c0, 0x10c1, 0, 0 }, /* #18 */
    { 0x273b96, 0x273306, 0x7270, 0x7271, 0, 0 }, /* #19 */
    { 0x1b4653, 0x1b4603, 0x2b06, 0x2b07, 0, 0 }, /* #20 */
    { 0x2a2456, 0x2a2486, 0xd486, 0xd487, 0, 0 }, /* #21 */
    { 0x015b07, 0x015383, 0x8a56, 0x8a57, 0, 0 }, /* #22 */
    { 0x340f86, 0x340702, 0x0be4, 0x0be5, 0, 0 }, /* #23 */
    { 0x0e0847, 0x0e0083, 0xceb5, 0xceb6, 0, 0 }, /* #24 */
    { 0x0c30c2, 0x0c3016, 0x7fef, 0x7ff0, 0, 0 }, /* #25 */
    { 0x180212, 0x180286, 0xa402, 0xa403, 0, 0 }, /* #26 */
    { 0x205397, 0x205387, 0xbb32, 0xbb33, 0, 0 }, /* #27 */
    { 0x0d3812, 0x0d3006, 0x1735, 0x1736, 0, 0 }, /* #28 */
    { 0x2c6292, 0x2c6206, 0x14b6, 0x14b7, 0, 0 }, /* #29 */
    { 0x2e63c2, 0x2e6382, 0xcd0d, 0xcd0e, 0, 0 }, /* #30 */
    { 0x2e1d16, 0x2e1506, 0x01b3, 0x01b4, 0, 0 }, /* #31 */
    { 0x3a2e46, 0x3a2686, 0xf36e, 0xf36f, 0, 0 }, /* #32 */
    { 0x352092, 0x352082, 0xbee2, 0xbee3, 0, 0 }, /* #33 */
    { 0x070c12, 0x070486, 0xed4a, 0xed4b, 0, 0 }, /* #34 */
    { 0x3e1c43, 0x3e1407, 0x7355, 0x7356, 0, 0 }, /* #35 */
    { 0x1c3f47, 0x1c3707, 0x7e1d, 0x7e1e, 0, 0 }, /* #36 */
    { 0x177093, 0x177087, 0xc87a, 0xc87b, 0, 0 }, /* #37 */
    { 0x0b5803, 0x0b5087, 0xb994, 0xb995, 0, 0 }, /* #38 */
    { 0x095986, 0x095186, 0x9af5, 0x9af6, 0, 0 }, /* #39 */
    { 0x332ac3, 0x332203, 0x3550, 0x3551, 0, 0 }, /* #40 */
    { 0x000b02, 0x000302, 0x52f6, 0x52f7, 0, 0 }, /* #41 */
    { 0x0b3f92, 0x0b3702, 0x0dca, 0x0dcb, 0, 0 }, /* #42 */
    { 0x3b3907, 0x3b3183, 0xc67b, 0xc67c, 0, 0 }, /* #43 */
    { 0x0b4717, 0x0b4703, 0x3e9c, 0x3e9d, 0, 0 }, /* #44 */
    { 0x202e13, 0x202607, 0x2234, 0x2235, 0, 0 }, /* #45 */
    { 0x2e6303, 0x2e6387, 0xd7dc, 0xd7dd, 0, 0 }, /* #46 */
    { 0x081092, 0x081002, 0x6753, 0x6754, 0, 0 }, /* #47 */
    { 0x2074c3, 0x207483, 0xa6b4, 0xa6b5, 0, 0 }, /* #48 */
    { 0x0a6456, 0x0a6406, 0x6f62, 0x6f63, 0, 0 }, /* #49 */
    { 0x231616, 0x231606, 0x7658, 0x7659, 0, 0 }, /* #50 */
    { 0x067843, 0x067007, 0x4971, 0x4972, 0, 0 }, /* #51 */
    { 0x050687, 0x050603, 0x250d, 0x250e, 0, 0 }, /* #52 */
    { 0x352297, 0x352283, 0xa61e, 0xa61f, 0, 0 }, /* #53 */
    { 0x3f0992, 0x3f0102, 0x0245, 0x0246, 0, 0 }, /* #54 */
    { 0x146983, 0x146193, 0xaa6f, 0xaa70, 0, 0 }, /* #55 */
    { 0x152613, 0x152603, 0x3067, 0x3068, 0, 0 }, /* #56 */
    { 0x2b2a02, 0x2b2282, 0xb697, 0xb698, 0, 0 }, /* #57 */
    { 0x3e0f07, 0x3e0787, 0xe8ce, 0xe8cf, 0, 0 }, /* #58 */
    { 0x030053, 0x030097, 0xb9bf, 0xb9c0, 0, 0 }, /* #59 */
    { 0x341443, 0x341403, 0x7c2b, 0x7c2c, 0, 0 }, /* #60 */
    { 0x171f02, 0x171782, 0xf001, 0xf002, 0, 0 }, /* #61 */
    { 0x276202, 0x276202, 0x087e, 0x087f, 0, 0 }, /* #62 */
    { 0x0f7a86, 0x0f7282, 0xe4d5, 0xe4d6, 0, 0 }, /* #63 */
    { 0x154616, 0x154686, 0xc7b0, 0xc7b1, 0, 0 }, /* #64 */
    { 0x041fc7, 0x041783, 0xad91, 0xad92, 0, 0 }, /* #65 */
    { 0x073683, 0x073683, 0xfb79, 0xfb7a, 0, 0 }, /* #66 */
    { 0x1e53c2, 0x1e5302, 0x170c, 0x170d, 0, 0 }, /* #67 */
    { 0x1f6647, 0x1f6607, 0x5277, 0x5278, 0, 0 }, /* #68 */
    { 0x095f83, 0x095783, 0x9dd9, 0x9dda, 0, 0 }, /* #69 */
    { 0x331016, 0x331002, 0x74ca, 0x74cb, 0, 0 }, /* #70 */
    { 0x2044d7, 0x204407, 0x6808, 0x6809, 0, 0 }, /* #71 */
    { 0x1d73c2, 0x1d7306, 0x662a, 0x662b, 0, 0 }, /* #72 */
    { 0x050593, 0x050583, 0x9cfd, 0x9cfe, 0, 0 }, /* #73 */
    { 0x116992, 0x116186, 0xdafe, 0xdaff, 0, 0 }, /* #74 */
    { 0x014342, 0x014306, 0x4927, 0x4928, 0, 0 }, /* #75 */
    { 0x115fc3, 0x115703, 0x1896, 0x1897, 0, 0 }, /* #76 */
    { 0x150102, 0x150102, 0x38a0, 0x38a1, 0, 0 }, /* #77 */
    { 0x003206, 0x003286, 0x82c9, 0x82ca, 0, 0 }, /* #78 */
    { 0x2a5247, 0x2a5287, 0xcb23, 0xcb24, 0, 0 }, /* #79 */
    { 0x166547, 0x166583, 0xaf66, 0xaf67, 0, 0 }, /* #80 */
    { 0x2932c3, 0x293283, 0x81b2, 0x81b3, 0, 0 }, /* #81 */
    { 0x3e0912, 0x3e0186, 0xa9a5, 0xa9a6, 0, 0 }, /* #82 */
    { 0x1d54c3, 0x1d5487, 0xb9d0, 0xb9d1, 0, 0 }, /* #83 */
    { 0x270807, 0x270083, 0xe24b, 0xe24c, 0, 0 }, /* #84 */
    { 0x3f02c2, 0x3f0206, 0x139b, 0x139c, 0, 0 }, /* #85 */
    { 0x032952, 0x032186, 0xe75b, 0xe75c, 0, 0 }, /* #86 */
    { 0x1b4c16, 0x1b4486, 0x9e0b, 0x9e0c, 0, 0 }, /* #87 */
    { 0x2759c2, 0x275186, 0xed77, 0xed78, 0, 0 }, /* #88 */
    { 0x2b2fd6, 0x2b2706, 0x6c8c, 0x6c8d, 0, 0 }, /* #89 */
    { 0x1b7c42, 0x1b7406, 0x2d2c, 0x2d2d, 0, 0 }, /* #90 */
    { 0x220f12, 0x220782, 0xc188, 0xc189, 0, 0 }, /* #91 */
    { 0x235642, 0x235606, 0x2e9e, 0x2e9f, 0, 0 }, /* #92 */
    { 0x137f16, 0x137782, 0x97b5, 0x97b6, 0, 0 }, /* #93 */
    { 0x0139c2, 0x013106, 0x1b77, 0x1b78, 0, 0 }, /* #94 */
    { 0x0d1996, 0x0d1106, 0x6c65, 0x6c66, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_inc_u16_locked = RT_ELEMENTS(g_aTests_inc_u16_locked);

BINU16_TEST_T const g_aTests_dec_u16[] =
{
    { 0x244857, 0x244003, 0x316f, 0x316e, 0, 0 }, /* #0 */
    { 0x1a0c82, 0x1a0496, 0xb770, 0xb76f, 0, 0 }, /* #1 */
    { 0x1a0003, 0x1a0007, 0x0a9a, 0x0a99, 0, 0 }, /* #2 */
    { 0x0a4696, 0x0a4606, 0x0b57, 0x0b56, 0, 0 }, /* #3 */
    { 0x3f2883, 0x3f2083, 0x879e, 0x879d, 0, 0 }, /* #4 */
    { 0x085c43, 0x085487, 0xa26a, 0xa269, 0, 0 }, /* #5 */
    { 0x3d66d7, 0x3d6683, 0x846f, 0x846e, 0, 0 }, /* #6 */
    { 0x291f17, 0x291783, 0x80ac, 0x80ab, 0, 0 }, /* #7 */
    { 0x0a56d7, 0x0a5687, 0xf012, 0xf011, 0, 0 }, /* #8 */
    { 0x123092, 0x123082, 0xc717, 0xc716, 0, 0 }, /* #9 */
    { 0x2a0552, 0x2a0586, 0xe7c1, 0xe7c0, 0, 0 }, /* #10 */
    { 0x3f0a96, 0x3f0282, 0xecf3, 0xecf2, 0, 0 }, /* #11 */
    { 0x255956, 0x255106, 0x5448, 0x5447, 0, 0 }, /* #12 */
    { 0x1c52d6, 0x1c5202, 0x65e6, 0x65e5, 0, 0 }, /* #13 */
    { 0x294d93, 0x294507, 0x79aa, 0x79a9, 0, 0 }, /* #14 */
    { 0x0a4687, 0x0a4607, 0x161e, 0x161d, 0, 0 }, /* #15 */
    { 0x372057, 0x372003, 0x0dfc, 0x0dfb, 0, 0 }, /* #16 */
    { 0x1315c3, 0x131507, 0x15a1, 0x15a0, 0, 0 }, /* #17 */
    { 0x322ad7, 0x322287, 0xf96b, 0xf96a, 0, 0 }, /* #18 */
    { 0x153613, 0x153687, 0xcc5b, 0xcc5a, 0, 0 }, /* #19 */
    { 0x1c7992, 0x1c7182, 0xb695, 0xb694, 0, 0 }, /* #20 */
    { 0x0129d6, 0x012102, 0x1099, 0x1098, 0, 0 }, /* #21 */
    { 0x0c41d3, 0x0c4187, 0xea6d, 0xea6c, 0, 0 }, /* #22 */
    { 0x132146, 0x132182, 0x937b, 0x937a, 0, 0 }, /* #23 */
    { 0x2972d3, 0x297203, 0x35d1, 0x35d0, 0, 0 }, /* #24 */
    { 0x0c6517, 0x0c6587, 0xb1a6, 0xb1a5, 0, 0 }, /* #25 */
    { 0x3a2783, 0x3a2703, 0x0b2d, 0x0b2c, 0, 0 }, /* #26 */
    { 0x142693, 0x142603, 0x792b, 0x792a, 0, 0 }, /* #27 */
    { 0x2b6c87, 0x2b6487, 0x85d8, 0x85d7, 0, 0 }, /* #28 */
    { 0x282d53, 0x282503, 0x4717, 0x4716, 0, 0 }, /* #29 */
    { 0x161f07, 0x161707, 0x1472, 0x1471, 0, 0 }, /* #30 */
    { 0x156d03, 0x156503, 0x58cf, 0x58ce, 0, 0 }, /* #31 */
    { 0x1a1c93, 0x1a1403, 0x01cf, 0x01ce, 0, 0 }, /* #32 */
    { 0x2520d7, 0x252087, 0x8b88, 0x8b87, 0, 0 }, /* #33 */
    { 0x1a0986, 0x1a0106, 0x4783, 0x4782, 0, 0 }, /* #34 */
    { 0x267fd2, 0x267706, 0x2578, 0x2577, 0, 0 }, /* #35 */
    { 0x193cd6, 0x193402, 0x379c, 0x379b, 0, 0 }, /* #36 */
    { 0x215793, 0x215797, 0xb040, 0xb03f, 0, 0 }, /* #37 */
    { 0x223a87, 0x223283, 0xa8c2, 0xa8c1, 0, 0 }, /* #38 */
    { 0x1a6ec3, 0x1a6683, 0x8e2b, 0x8e2a, 0, 0 }, /* #39 */
    { 0x1f7257, 0x1f7203, 0x42a8, 0x42a7, 0, 0 }, /* #40 */
    { 0x3c3203, 0x3c3287, 0xe237, 0xe236, 0, 0 }, /* #41 */
    { 0x1a4682, 0x1a4682, 0xae53, 0xae52, 0, 0 }, /* #42 */
    { 0x080b93, 0x080303, 0x5541, 0x5540, 0, 0 }, /* #43 */
    { 0x046153, 0x046187, 0x8249, 0x8248, 0, 0 }, /* #44 */
    { 0x1d44c2, 0x1d4492, 0xbcf0, 0xbcef, 0, 0 }, /* #45 */
    { 0x385412, 0x385486, 0xecf4, 0xecf3, 0, 0 }, /* #46 */
    { 0x173257, 0x173203, 0x6321, 0x6320, 0, 0 }, /* #47 */
    { 0x3a7c02, 0x3a7402, 0x51c2, 0x51c1, 0, 0 }, /* #48 */
    { 0x3d6e92, 0x3d6686, 0xa8a7, 0xa8a6, 0, 0 }, /* #49 */
    { 0x0b41c2, 0x0b4182, 0xb708, 0xb707, 0, 0 }, /* #50 */
    { 0x387456, 0x387402, 0x63ae, 0x63ad, 0, 0 }, /* #51 */
    { 0x0b7407, 0x0b7487, 0x975d, 0x975c, 0, 0 }, /* #52 */
    { 0x146a17, 0x146203, 0x5ceb, 0x5cea, 0, 0 }, /* #53 */
    { 0x0b76d3, 0x0b7683, 0xb4bd, 0xb4bc, 0, 0 }, /* #54 */
    { 0x081f86, 0x081782, 0xeef2, 0xeef1, 0, 0 }, /* #55 */
    { 0x2e7dd2, 0x2e7586, 0x959b, 0x959a, 0, 0 }, /* #56 */
    { 0x004193, 0x004107, 0x3f37, 0x3f36, 0, 0 }, /* #57 */
    { 0x1d5c42, 0x1d5482, 0x95ae, 0x95ad, 0, 0 }, /* #58 */
    { 0x041993, 0x041107, 0x0c7f, 0x0c7e, 0, 0 }, /* #59 */
    { 0x1429c6, 0x142102, 0x56e4, 0x56e3, 0, 0 }, /* #60 */
    { 0x3c3542, 0x3c3506, 0x493d, 0x493c, 0, 0 }, /* #61 */
    { 0x1248c7, 0x124083, 0x847b, 0x847a, 0, 0 }, /* #62 */
    { 0x235d87, 0x235587, 0xcfcd, 0xcfcc, 0, 0 }, /* #63 */
    { 0x185497, 0x185487, 0x81f4, 0x81f3, 0, 0 }, /* #64 */
    { 0x3229d6, 0x322196, 0x8b60, 0x8b5f, 0, 0 }, /* #65 */
    { 0x017d92, 0x017586, 0x88e8, 0x88e7, 0, 0 }, /* #66 */
    { 0x283617, 0x283613, 0x0630, 0x062f, 0, 0 }, /* #67 */
    { 0x3b0182, 0x3b0106, 0x0588, 0x0587, 0, 0 }, /* #68 */
    { 0x265ec6, 0x265612, 0x7d20, 0x7d1f, 0, 0 }, /* #69 */
    { 0x364806, 0x364096, 0x8640, 0x863f, 0, 0 }, /* #70 */
    { 0x1a5c13, 0x1a5407, 0x621f, 0x621e, 0, 0 }, /* #71 */
    { 0x2a5096, 0x2a5002, 0x27ce, 0x27cd, 0, 0 }, /* #72 */
    { 0x3e6697, 0x3e6603, 0x7e5f, 0x7e5e, 0, 0 }, /* #73 */
    { 0x356886, 0x356006, 0x730b, 0x730a, 0, 0 }, /* #74 */
    { 0x344b92, 0x344306, 0x2a9a, 0x2a99, 0, 0 }, /* #75 */
    { 0x375b02, 0x375386, 0xeae5, 0xeae4, 0, 0 }, /* #76 */
    { 0x077097, 0x077087, 0xc0b9, 0xc0b8, 0, 0 }, /* #77 */
    { 0x022a57, 0x022287, 0xb456, 0xb455, 0, 0 }, /* #78 */
    { 0x194902, 0x194106, 0x412f, 0x412e, 0, 0 }, /* #79 */
    { 0x2b4306, 0x2b4306, 0x4078, 0x4077, 0, 0 }, /* #80 */
    { 0x367682, 0x367602, 0x1c86, 0x1c85, 0, 0 }, /* #81 */
    { 0x125902, 0x125102, 0x39eb, 0x39ea, 0, 0 }, /* #82 */
    { 0x0e5546, 0x0e5582, 0xddfe, 0xddfd, 0, 0 }, /* #83 */
    { 0x2c0897, 0x2c0003, 0x1f93, 0x1f92, 0, 0 }, /* #84 */
    { 0x136247, 0x136203, 0x711a, 0x7119, 0, 0 }, /* #85 */
    { 0x013316, 0x013382, 0xf124, 0xf123, 0, 0 }, /* #86 */
    { 0x3b4053, 0x3b4007, 0x7fe2, 0x7fe1, 0, 0 }, /* #87 */
    { 0x082417, 0x082403, 0x1cc5, 0x1cc4, 0, 0 }, /* #88 */
    { 0x3e5416, 0x3e5406, 0x1d83, 0x1d82, 0, 0 }, /* #89 */
    { 0x3c0c92, 0x3c0496, 0xb210, 0xb20f, 0, 0 }, /* #90 */
    { 0x3f7453, 0x3f7487, 0xc87e, 0xc87d, 0, 0 }, /* #91 */
    { 0x3f3312, 0x3f3306, 0x50b9, 0x50b8, 0, 0 }, /* #92 */
    { 0x2649d3, 0x264107, 0x0828, 0x0827, 0, 0 }, /* #93 */
    { 0x1d62c6, 0x1d6286, 0xeb4e, 0xeb4d, 0, 0 }, /* #94 */
    { 0x332992, 0x332192, 0x8d80, 0x8d7f, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_dec_u16 = RT_ELEMENTS(g_aTests_dec_u16);

BINU16_TEST_T const g_aTests_dec_u16_locked[] =
{
    { 0x056e57, 0x056603, 0x64e6, 0x64e5, 0, 0 }, /* #0 */
    { 0x1c1193, 0x1c1103, 0x3e8b, 0x3e8a, 0, 0 }, /* #1 */
    { 0x2a3d96, 0x2a3586, 0x9385, 0x9384, 0, 0 }, /* #2 */
    { 0x365693, 0x365687, 0xd78e, 0xd78d, 0, 0 }, /* #3 */
    { 0x327886, 0x327082, 0xae17, 0xae16, 0, 0 }, /* #4 */
    { 0x066652, 0x066606, 0x6f18, 0x6f17, 0, 0 }, /* #5 */
    { 0x035e56, 0x035682, 0xaeeb, 0xaeea, 0, 0 }, /* #6 */
    { 0x2c6b02, 0x2c6392, 0xb380, 0xb37f, 0, 0 }, /* #7 */
    { 0x090916, 0x090106, 0x515b, 0x515a, 0, 0 }, /* #8 */
    { 0x136756, 0x136702, 0x33d1, 0x33d0, 0, 0 }, /* #9 */
    { 0x355482, 0x355406, 0x2237, 0x2236, 0, 0 }, /* #10 */
    { 0x1f6356, 0x1f6386, 0xc445, 0xc444, 0, 0 }, /* #11 */
    { 0x147513, 0x147583, 0xd23e, 0xd23d, 0, 0 }, /* #12 */
    { 0x106b13, 0x106307, 0x7142, 0x7141, 0, 0 }, /* #13 */
    { 0x183a93, 0x183207, 0x212c, 0x212b, 0, 0 }, /* #14 */
    { 0x1b7f93, 0x1b7703, 0x1287, 0x1286, 0, 0 }, /* #15 */
    { 0x157b52, 0x157386, 0xaa8f, 0xaa8e, 0, 0 }, /* #16 */
    { 0x104e87, 0x104607, 0x5779, 0x5778, 0, 0 }, /* #17 */
    { 0x3a7182, 0x3a7102, 0x6d46, 0x6d45, 0, 0 }, /* #18 */
    { 0x1a7fc7, 0x1a7707, 0x634e, 0x634d, 0, 0 }, /* #19 */
    { 0x3c2483, 0x3c2487, 0xdf18, 0xdf17, 0, 0 }, /* #20 */
    { 0x063507, 0x063503, 0x58cf, 0x58ce, 0, 0 }, /* #21 */
    { 0x211d13, 0x211583, 0xa541, 0xa540, 0, 0 }, /* #22 */
    { 0x032c52, 0x032482, 0xe10f, 0xe10e, 0, 0 }, /* #23 */
    { 0x322b43, 0x322383, 0xbbf2, 0xbbf1, 0, 0 }, /* #24 */
    { 0x2e18d3, 0x2e1087, 0x9272, 0x9271, 0, 0 }, /* #25 */
    { 0x3629c6, 0x362182, 0xe258, 0xe257, 0, 0 }, /* #26 */
    { 0x301c96, 0x301492, 0xe250, 0xe24f, 0, 0 }, /* #27 */
    { 0x281083, 0x281083, 0xbeea, 0xbee9, 0, 0 }, /* #28 */
    { 0x324346, 0x324312, 0x28f0, 0x28ef, 0, 0 }, /* #29 */
    { 0x367e83, 0x367607, 0x5f37, 0x5f36, 0, 0 }, /* #30 */
    { 0x307a56, 0x307202, 0x7b7b, 0x7b7a, 0, 0 }, /* #31 */
    { 0x0d4452, 0x0d4486, 0xdcfd, 0xdcfc, 0, 0 }, /* #32 */
    { 0x254682, 0x254606, 0x271f, 0x271e, 0, 0 }, /* #33 */
    { 0x2f2ad3, 0x2f2207, 0x6b49, 0x6b48, 0, 0 }, /* #34 */
    { 0x262986, 0x262106, 0x6561, 0x6560, 0, 0 }, /* #35 */
    { 0x000847, 0x000087, 0x875d, 0x875c, 0, 0 }, /* #36 */
    { 0x186497, 0x186487, 0x864e, 0x864d, 0, 0 }, /* #37 */
    { 0x3442d3, 0x344207, 0x6188, 0x6187, 0, 0 }, /* #38 */
    { 0x125c47, 0x125483, 0xd7f9, 0xd7f8, 0, 0 }, /* #39 */
    { 0x315c86, 0x315406, 0x55aa, 0x55a9, 0, 0 }, /* #40 */
    { 0x236c07, 0x236487, 0xf801, 0xf800, 0, 0 }, /* #41 */
    { 0x384382, 0x384306, 0x0c49, 0x0c48, 0, 0 }, /* #42 */
    { 0x396a46, 0x396286, 0xaa28, 0xaa27, 0, 0 }, /* #43 */
    { 0x112692, 0x112602, 0x0758, 0x0757, 0, 0 }, /* #44 */
    { 0x2d1412, 0x2d1406, 0x1df6, 0x1df5, 0, 0 }, /* #45 */
    { 0x3e5903, 0x3e5107, 0x3743, 0x3742, 0, 0 }, /* #46 */
    { 0x1f0813, 0x1f0003, 0x02e7, 0x02e6, 0, 0 }, /* #47 */
    { 0x0d3847, 0x0d3007, 0x1b1f, 0x1b1e, 0, 0 }, /* #48 */
    { 0x143fd6, 0x143706, 0x7b3a, 0x7b39, 0, 0 }, /* #49 */
    { 0x2a0a97, 0x2a0203, 0x00fe, 0x00fd, 0, 0 }, /* #50 */
    { 0x1f4852, 0x1f4006, 0x7856, 0x7855, 0, 0 }, /* #51 */
    { 0x172306, 0x172316, 0x4ed0, 0x4ecf, 0, 0 }, /* #52 */
    { 0x176a52, 0x176212, 0x0730, 0x072f, 0, 0 }, /* #53 */
    { 0x045f03, 0x045707, 0x2251, 0x2250, 0, 0 }, /* #54 */
    { 0x0a1596, 0x0a1582, 0x8171, 0x8170, 0, 0 }, /* #55 */
    { 0x0973c3, 0x097383, 0x9e4d, 0x9e4c, 0, 0 }, /* #56 */
    { 0x260812, 0x260006, 0x57e8, 0x57e7, 0, 0 }, /* #57 */
    { 0x133186, 0x133102, 0x54d1, 0x54d0, 0, 0 }, /* #58 */
    { 0x2518c2, 0x251006, 0x64bc, 0x64bb, 0, 0 }, /* #59 */
    { 0x3845d3, 0x384587, 0x9ae2, 0x9ae1, 0, 0 }, /* #60 */
    { 0x076716, 0x076786, 0xaa23, 0xaa22, 0, 0 }, /* #61 */
    { 0x0b1356, 0x0b1386, 0x9c61, 0x9c60, 0, 0 }, /* #62 */
    { 0x342302, 0x342302, 0x404a, 0x4049, 0, 0 }, /* #63 */
    { 0x2f6757, 0x2f6703, 0x2f84, 0x2f83, 0, 0 }, /* #64 */
    { 0x3b3c96, 0x3b3486, 0xed91, 0xed90, 0, 0 }, /* #65 */
    { 0x062c93, 0x062403, 0x534a, 0x5349, 0, 0 }, /* #66 */
    { 0x247316, 0x247306, 0x52bf, 0x52be, 0, 0 }, /* #67 */
    { 0x0950c2, 0x095086, 0xabf1, 0xabf0, 0, 0 }, /* #68 */
    { 0x053cc3, 0x053403, 0x2eb7, 0x2eb6, 0, 0 }, /* #69 */
    { 0x0220d6, 0x022006, 0x4a13, 0x4a12, 0, 0 }, /* #70 */
    { 0x0b34d6, 0x0b3482, 0xd09f, 0xd09e, 0, 0 }, /* #71 */
    { 0x0f4953, 0x0f4187, 0xca61, 0xca60, 0, 0 }, /* #72 */
    { 0x321e47, 0x321603, 0x5dc9, 0x5dc8, 0, 0 }, /* #73 */
    { 0x3e5212, 0x3e5286, 0x813d, 0x813c, 0, 0 }, /* #74 */
    { 0x127802, 0x127002, 0x67d4, 0x67d3, 0, 0 }, /* #75 */
    { 0x370c93, 0x370403, 0x7986, 0x7985, 0, 0 }, /* #76 */
    { 0x2b7486, 0x2b7486, 0xedc4, 0xedc3, 0, 0 }, /* #77 */
    { 0x193146, 0x193102, 0x7892, 0x7891, 0, 0 }, /* #78 */
    { 0x1400c7, 0x140007, 0x54bc, 0x54bb, 0, 0 }, /* #79 */
    { 0x092e82, 0x092606, 0x26c1, 0x26c0, 0, 0 }, /* #80 */
    { 0x235c52, 0x235486, 0xd657, 0xd656, 0, 0 }, /* #81 */
    { 0x2f4602, 0x2f4606, 0x16b9, 0x16b8, 0, 0 }, /* #82 */
    { 0x0d53c6, 0x0d5302, 0x66fe, 0x66fd, 0, 0 }, /* #83 */
    { 0x007ed7, 0x007683, 0xaa65, 0xaa64, 0, 0 }, /* #84 */
    { 0x1a6652, 0x1a6606, 0x151c, 0x151b, 0, 0 }, /* #85 */
    { 0x2e2b82, 0x2e2386, 0x9856, 0x9855, 0, 0 }, /* #86 */
    { 0x104056, 0x104086, 0xfedc, 0xfedb, 0, 0 }, /* #87 */
    { 0x3541c6, 0x354102, 0x4ec3, 0x4ec2, 0, 0 }, /* #88 */
    { 0x354d96, 0x354586, 0xe554, 0xe553, 0, 0 }, /* #89 */
    { 0x2746c7, 0x274603, 0x249f, 0x249e, 0, 0 }, /* #90 */
    { 0x0d0802, 0x0d0082, 0x8665, 0x8664, 0, 0 }, /* #91 */
    { 0x1a4a16, 0x1a4202, 0x2902, 0x2901, 0, 0 }, /* #92 */
    { 0x0e3e52, 0x0e3606, 0x0cec, 0x0ceb, 0, 0 }, /* #93 */
    { 0x226383, 0x226307, 0x2312, 0x2311, 0, 0 }, /* #94 */
    { 0x323d87, 0x323587, 0xf823, 0xf822, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_dec_u16_locked = RT_ELEMENTS(g_aTests_dec_u16_locked);

BINU16_TEST_T const g_aTests_not_u16[] =
{
    { 0x002ec7, 0x002ec7, 0xee31, 0x11ce, 0, 0 }, /* #0 */
    { 0x0e2b86, 0x0e2b86, 0xf539, 0x0ac6, 0, 0 }, /* #1 */
    { 0x140942, 0x140942, 0x2871, 0xd78e, 0, 0 }, /* #2 */
    { 0x271ed3, 0x271ed3, 0xc589, 0x3a76, 0, 0 }, /* #3 */
    { 0x202652, 0x202652, 0x1dd8, 0xe227, 0, 0 }, /* #4 */
    { 0x3757c6, 0x3757c6, 0xc7b4, 0x384b, 0, 0 }, /* #5 */
    { 0x257bc7, 0x257bc7, 0xdd52, 0x22ad, 0, 0 }, /* #6 */
    { 0x0e03d6, 0x0e03d6, 0xb8af, 0x4750, 0, 0 }, /* #7 */
    { 0x3a5a16, 0x3a5a16, 0xbbe2, 0x441d, 0, 0 }, /* #8 */
    { 0x1d4f87, 0x1d4f87, 0x3946, 0xc6b9, 0, 0 }, /* #9 */
    { 0x092b52, 0x092b52, 0x8e0e, 0x71f1, 0, 0 }, /* #10 */
    { 0x345586, 0x345586, 0x9d96, 0x6269, 0, 0 }, /* #11 */
    { 0x141143, 0x141143, 0x4ee7, 0xb118, 0, 0 }, /* #12 */
    { 0x1b56c6, 0x1b56c6, 0xb188, 0x4e77, 0, 0 }, /* #13 */
    { 0x156e12, 0x156e12, 0x2ee1, 0xd11e, 0, 0 }, /* #14 */
    { 0x1e1987, 0x1e1987, 0x06c7, 0xf938, 0, 0 }, /* #15 */
    { 0x102b96, 0x102b96, 0x53e5, 0xac1a, 0, 0 }, /* #16 */
    { 0x067e46, 0x067e46, 0x7beb, 0x8414, 0, 0 }, /* #17 */
    { 0x3e0317, 0x3e0317, 0x1f71, 0xe08e, 0, 0 }, /* #18 */
    { 0x361856, 0x361856, 0x7dc3, 0x823c, 0, 0 }, /* #19 */
    { 0x0f7f92, 0x0f7f92, 0x3948, 0xc6b7, 0, 0 }, /* #20 */
    { 0x0d28c7, 0x0d28c7, 0xb7e2, 0x481d, 0, 0 }, /* #21 */
    { 0x015a46, 0x015a46, 0xcf8f, 0x3070, 0, 0 }, /* #22 */
    { 0x3a7f02, 0x3a7f02, 0x34cf, 0xcb30, 0, 0 }, /* #23 */
    { 0x326342, 0x326342, 0x42aa, 0xbd55, 0, 0 }, /* #24 */
    { 0x2c5953, 0x2c5953, 0x80fd, 0x7f02, 0, 0 }, /* #25 */
    { 0x042412, 0x042412, 0xb737, 0x48c8, 0, 0 }, /* #26 */
    { 0x161843, 0x161843, 0x58df, 0xa720, 0, 0 }, /* #27 */
    { 0x090197, 0x090197, 0x203f, 0xdfc0, 0, 0 }, /* #28 */
    { 0x3106d6, 0x3106d6, 0x16c1, 0xe93e, 0, 0 }, /* #29 */
    { 0x1b3896, 0x1b3896, 0xbeb2, 0x414d, 0, 0 }, /* #30 */
    { 0x3c24d2, 0x3c24d2, 0x69b3, 0x964c, 0, 0 }, /* #31 */
    { 0x227446, 0x227446, 0x1e06, 0xe1f9, 0, 0 }, /* #32 */
    { 0x143193, 0x143193, 0x37d0, 0xc82f, 0, 0 }, /* #33 */
    { 0x291442, 0x291442, 0xac38, 0x53c7, 0, 0 }, /* #34 */
    { 0x2a6f96, 0x2a6f96, 0xa450, 0x5baf, 0, 0 }, /* #35 */
    { 0x1c7716, 0x1c7716, 0x9986, 0x6679, 0, 0 }, /* #36 */
    { 0x133783, 0x133783, 0x6346, 0x9cb9, 0, 0 }, /* #37 */
    { 0x3f2557, 0x3f2557, 0xb02c, 0x4fd3, 0, 0 }, /* #38 */
    { 0x0309c7, 0x0309c7, 0xd835, 0x27ca, 0, 0 }, /* #39 */
    { 0x063716, 0x063716, 0xde68, 0x2197, 0, 0 }, /* #40 */
    { 0x102853, 0x102853, 0x67b7, 0x9848, 0, 0 }, /* #41 */
    { 0x365e02, 0x365e02, 0x3e8b, 0xc174, 0, 0 }, /* #42 */
    { 0x043416, 0x043416, 0x475b, 0xb8a4, 0, 0 }, /* #43 */
    { 0x0378c6, 0x0378c6, 0x04e8, 0xfb17, 0, 0 }, /* #44 */
    { 0x214296, 0x214296, 0xf55d, 0x0aa2, 0, 0 }, /* #45 */
    { 0x0f2043, 0x0f2043, 0xe238, 0x1dc7, 0, 0 }, /* #46 */
    { 0x206d52, 0x206d52, 0x8fc1, 0x703e, 0, 0 }, /* #47 */
    { 0x1b1003, 0x1b1003, 0x73b6, 0x8c49, 0, 0 }, /* #48 */
    { 0x000e53, 0x000e53, 0x2d63, 0xd29c, 0, 0 }, /* #49 */
    { 0x130683, 0x130683, 0x4e4d, 0xb1b2, 0, 0 }, /* #50 */
    { 0x2a2207, 0x2a2207, 0x7bb9, 0x8446, 0, 0 }, /* #51 */
    { 0x186a87, 0x186a87, 0x9ac3, 0x653c, 0, 0 }, /* #52 */
    { 0x303c96, 0x303c96, 0xe082, 0x1f7d, 0, 0 }, /* #53 */
    { 0x0e5283, 0x0e5283, 0xa8a5, 0x575a, 0, 0 }, /* #54 */
    { 0x362d02, 0x362d02, 0x6ea1, 0x915e, 0, 0 }, /* #55 */
    { 0x0d4dd2, 0x0d4dd2, 0x82a5, 0x7d5a, 0, 0 }, /* #56 */
    { 0x365c96, 0x365c96, 0xc99f, 0x3660, 0, 0 }, /* #57 */
    { 0x1c4dc7, 0x1c4dc7, 0x1d55, 0xe2aa, 0, 0 }, /* #58 */
    { 0x3763d6, 0x3763d6, 0x59a8, 0xa657, 0, 0 }, /* #59 */
    { 0x0a45c2, 0x0a45c2, 0x6bda, 0x9425, 0, 0 }, /* #60 */
    { 0x280b96, 0x280b96, 0xc473, 0x3b8c, 0, 0 }, /* #61 */
    { 0x0f5406, 0x0f5406, 0x15a4, 0xea5b, 0, 0 }, /* #62 */
    { 0x203b92, 0x203b92, 0xf996, 0x0669, 0, 0 }, /* #63 */
    { 0x3a3047, 0x3a3047, 0x718e, 0x8e71, 0, 0 }, /* #64 */
    { 0x0528c6, 0x0528c6, 0xb418, 0x4be7, 0, 0 }, /* #65 */
    { 0x081b03, 0x081b03, 0x3531, 0xcace, 0, 0 }, /* #66 */
    { 0x014b17, 0x014b17, 0x1e18, 0xe1e7, 0, 0 }, /* #67 */
    { 0x1c2f92, 0x1c2f92, 0x79f0, 0x860f, 0, 0 }, /* #68 */
    { 0x231fc2, 0x231fc2, 0x5a22, 0xa5dd, 0, 0 }, /* #69 */
    { 0x181703, 0x181703, 0x6342, 0x9cbd, 0, 0 }, /* #70 */
    { 0x311b97, 0x311b97, 0x5436, 0xabc9, 0, 0 }, /* #71 */
    { 0x0f2616, 0x0f2616, 0x0e4d, 0xf1b2, 0, 0 }, /* #72 */
    { 0x316803, 0x316803, 0x3df6, 0xc209, 0, 0 }, /* #73 */
    { 0x3b3456, 0x3b3456, 0x4518, 0xbae7, 0, 0 }, /* #74 */
    { 0x133e97, 0x133e97, 0xebe3, 0x141c, 0, 0 }, /* #75 */
    { 0x272707, 0x272707, 0x7862, 0x879d, 0, 0 }, /* #76 */
    { 0x1105d3, 0x1105d3, 0x1113, 0xeeec, 0, 0 }, /* #77 */
    { 0x120807, 0x120807, 0x58e4, 0xa71b, 0, 0 }, /* #78 */
    { 0x1a6907, 0x1a6907, 0x29cf, 0xd630, 0, 0 }, /* #79 */
    { 0x1401d7, 0x1401d7, 0x5d6f, 0xa290, 0, 0 }, /* #80 */
    { 0x3d5286, 0x3d5286, 0x7b1b, 0x84e4, 0, 0 }, /* #81 */
    { 0x216e82, 0x216e82, 0x0c38, 0xf3c7, 0, 0 }, /* #82 */
    { 0x265247, 0x265247, 0x7809, 0x87f6, 0, 0 }, /* #83 */
    { 0x2c09c7, 0x2c09c7, 0xa50d, 0x5af2, 0, 0 }, /* #84 */
    { 0x3963d3, 0x3963d3, 0x2a8d, 0xd572, 0, 0 }, /* #85 */
    { 0x315d42, 0x315d42, 0x5a75, 0xa58a, 0, 0 }, /* #86 */
    { 0x183603, 0x183603, 0x4e93, 0xb16c, 0, 0 }, /* #87 */
    { 0x3b7bc2, 0x3b7bc2, 0x9c0d, 0x63f2, 0, 0 }, /* #88 */
    { 0x1b1912, 0x1b1912, 0x713d, 0x8ec2, 0, 0 }, /* #89 */
    { 0x3f6587, 0x3f6587, 0x3c71, 0xc38e, 0, 0 }, /* #90 */
    { 0x002757, 0x002757, 0xb361, 0x4c9e, 0, 0 }, /* #91 */
    { 0x2e3717, 0x2e3717, 0x6346, 0x9cb9, 0, 0 }, /* #92 */
    { 0x111dc6, 0x111dc6, 0x94a5, 0x6b5a, 0, 0 }, /* #93 */
    { 0x0e6346, 0x0e6346, 0x2c11, 0xd3ee, 0, 0 }, /* #94 */
    { 0x170186, 0x170186, 0xaa8f, 0x5570, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_not_u16 = RT_ELEMENTS(g_aTests_not_u16);

BINU16_TEST_T const g_aTests_not_u16_locked[] =
{
    { 0x111147, 0x111147, 0x35ac, 0xca53, 0, 0 }, /* #0 */
    { 0x336e53, 0x336e53, 0xe908, 0x16f7, 0, 0 }, /* #1 */
    { 0x391416, 0x391416, 0x836f, 0x7c90, 0, 0 }, /* #2 */
    { 0x110182, 0x110182, 0xac69, 0x5396, 0, 0 }, /* #3 */
    { 0x0f5b12, 0x0f5b12, 0x4846, 0xb7b9, 0, 0 }, /* #4 */
    { 0x3f4687, 0x3f4687, 0x9047, 0x6fb8, 0, 0 }, /* #5 */
    { 0x1f7207, 0x1f7207, 0x2825, 0xd7da, 0, 0 }, /* #6 */
    { 0x2b2057, 0x2b2057, 0xf5d5, 0x0a2a, 0, 0 }, /* #7 */
    { 0x003f17, 0x003f17, 0x344e, 0xcbb1, 0, 0 }, /* #8 */
    { 0x250893, 0x250893, 0xd4dc, 0x2b23, 0, 0 }, /* #9 */
    { 0x236017, 0x236017, 0x1a34, 0xe5cb, 0, 0 }, /* #10 */
    { 0x271783, 0x271783, 0xa7d1, 0x582e, 0, 0 }, /* #11 */
    { 0x391dd3, 0x391dd3, 0x3535, 0xcaca, 0, 0 }, /* #12 */
    { 0x120707, 0x120707, 0x4066, 0xbf99, 0, 0 }, /* #13 */
    { 0x1346d7, 0x1346d7, 0x542f, 0xabd0, 0, 0 }, /* #14 */
    { 0x0e1b97, 0x0e1b97, 0x9d58, 0x62a7, 0, 0 }, /* #15 */
    { 0x185c93, 0x185c93, 0x9e08, 0x61f7, 0, 0 }, /* #16 */
    { 0x202f02, 0x202f02, 0x432d, 0xbcd2, 0, 0 }, /* #17 */
    { 0x0f0f13, 0x0f0f13, 0x0479, 0xfb86, 0, 0 }, /* #18 */
    { 0x293f96, 0x293f96, 0x6cb9, 0x9346, 0, 0 }, /* #19 */
    { 0x021806, 0x021806, 0x9011, 0x6fee, 0, 0 }, /* #20 */
    { 0x293453, 0x293453, 0x802c, 0x7fd3, 0, 0 }, /* #21 */
    { 0x226046, 0x226046, 0xb53c, 0x4ac3, 0, 0 }, /* #22 */
    { 0x250557, 0x250557, 0x4efd, 0xb102, 0, 0 }, /* #23 */
    { 0x2d3e46, 0x2d3e46, 0x1794, 0xe86b, 0, 0 }, /* #24 */
    { 0x0c2dd2, 0x0c2dd2, 0x3793, 0xc86c, 0, 0 }, /* #25 */
    { 0x126d03, 0x126d03, 0x44cd, 0xbb32, 0, 0 }, /* #26 */
    { 0x304712, 0x304712, 0xbbff, 0x4400, 0, 0 }, /* #27 */
    { 0x1e4752, 0x1e4752, 0x962a, 0x69d5, 0, 0 }, /* #28 */
    { 0x1d2857, 0x1d2857, 0x6732, 0x98cd, 0, 0 }, /* #29 */
    { 0x2465c6, 0x2465c6, 0x1e6d, 0xe192, 0, 0 }, /* #30 */
    { 0x186686, 0x186686, 0x6415, 0x9bea, 0, 0 }, /* #31 */
    { 0x0d1593, 0x0d1593, 0xb071, 0x4f8e, 0, 0 }, /* #32 */
    { 0x2f0b92, 0x2f0b92, 0x0c35, 0xf3ca, 0, 0 }, /* #33 */
    { 0x364c82, 0x364c82, 0x08d2, 0xf72d, 0, 0 }, /* #34 */
    { 0x0736c7, 0x0736c7, 0x2c52, 0xd3ad, 0, 0 }, /* #35 */
    { 0x391d13, 0x391d13, 0x23c9, 0xdc36, 0, 0 }, /* #36 */
    { 0x173712, 0x173712, 0x46f9, 0xb906, 0, 0 }, /* #37 */
    { 0x334c16, 0x334c16, 0xd104, 0x2efb, 0, 0 }, /* #38 */
    { 0x1f5916, 0x1f5916, 0xb2e9, 0x4d16, 0, 0 }, /* #39 */
    { 0x3c4b56, 0x3c4b56, 0xf87f, 0x0780, 0, 0 }, /* #40 */
    { 0x344512, 0x344512, 0x5c31, 0xa3ce, 0, 0 }, /* #41 */
    { 0x200186, 0x200186, 0xc256, 0x3da9, 0, 0 }, /* #42 */
    { 0x075587, 0x075587, 0x0d25, 0xf2da, 0, 0 }, /* #43 */
    { 0x272a47, 0x272a47, 0xaf05, 0x50fa, 0, 0 }, /* #44 */
    { 0x0b3583, 0x0b3583, 0x17aa, 0xe855, 0, 0 }, /* #45 */
    { 0x0c63d6, 0x0c63d6, 0x4523, 0xbadc, 0, 0 }, /* #46 */
    { 0x256d03, 0x256d03, 0x6362, 0x9c9d, 0, 0 }, /* #47 */
    { 0x222f56, 0x222f56, 0x091e, 0xf6e1, 0, 0 }, /* #48 */
    { 0x104113, 0x104113, 0xa037, 0x5fc8, 0, 0 }, /* #49 */
    { 0x061797, 0x061797, 0xa1c1, 0x5e3e, 0, 0 }, /* #50 */
    { 0x3d1502, 0x3d1502, 0x231a, 0xdce5, 0, 0 }, /* #51 */
    { 0x1a4a56, 0x1a4a56, 0xf97a, 0x0685, 0, 0 }, /* #52 */
    { 0x1c07d6, 0x1c07d6, 0x4cf7, 0xb308, 0, 0 }, /* #53 */
    { 0x2e5386, 0x2e5386, 0xd44e, 0x2bb1, 0, 0 }, /* #54 */
    { 0x3335c2, 0x3335c2, 0xb6a9, 0x4956, 0, 0 }, /* #55 */
    { 0x2336d6, 0x2336d6, 0xbaa5, 0x455a, 0, 0 }, /* #56 */
    { 0x005f87, 0x005f87, 0xec2c, 0x13d3, 0, 0 }, /* #57 */
    { 0x3328d7, 0x3328d7, 0x930b, 0x6cf4, 0, 0 }, /* #58 */
    { 0x121683, 0x121683, 0x0d11, 0xf2ee, 0, 0 }, /* #59 */
    { 0x3526c2, 0x3526c2, 0xc570, 0x3a8f, 0, 0 }, /* #60 */
    { 0x0b5a06, 0x0b5a06, 0xdc25, 0x23da, 0, 0 }, /* #61 */
    { 0x2b4ac2, 0x2b4ac2, 0x5831, 0xa7ce, 0, 0 }, /* #62 */
    { 0x0c7b12, 0x0c7b12, 0x0947, 0xf6b8, 0, 0 }, /* #63 */
    { 0x165156, 0x165156, 0xe8b2, 0x174d, 0, 0 }, /* #64 */
    { 0x184687, 0x184687, 0xc51c, 0x3ae3, 0, 0 }, /* #65 */
    { 0x294417, 0x294417, 0xde93, 0x216c, 0, 0 }, /* #66 */
    { 0x136e83, 0x136e83, 0x4660, 0xb99f, 0, 0 }, /* #67 */
    { 0x072202, 0x072202, 0x01ee, 0xfe11, 0, 0 }, /* #68 */
    { 0x012156, 0x012156, 0x86c8, 0x7937, 0, 0 }, /* #69 */
    { 0x195006, 0x195006, 0x5715, 0xa8ea, 0, 0 }, /* #70 */
    { 0x393993, 0x393993, 0x5fee, 0xa011, 0, 0 }, /* #71 */
    { 0x3443c7, 0x3443c7, 0x37a9, 0xc856, 0, 0 }, /* #72 */
    { 0x0e3507, 0x0e3507, 0x264d, 0xd9b2, 0, 0 }, /* #73 */
    { 0x276306, 0x276306, 0x2d43, 0xd2bc, 0, 0 }, /* #74 */
    { 0x2d1992, 0x2d1992, 0x9626, 0x69d9, 0, 0 }, /* #75 */
    { 0x014052, 0x014052, 0x9a41, 0x65be, 0, 0 }, /* #76 */
    { 0x3c2a52, 0x3c2a52, 0x4d0d, 0xb2f2, 0, 0 }, /* #77 */
    { 0x3b4d97, 0x3b4d97, 0xe86c, 0x1793, 0, 0 }, /* #78 */
    { 0x387cd3, 0x387cd3, 0x3c1c, 0xc3e3, 0, 0 }, /* #79 */
    { 0x383552, 0x383552, 0x7fb5, 0x804a, 0, 0 }, /* #80 */
    { 0x3820d7, 0x3820d7, 0x9632, 0x69cd, 0, 0 }, /* #81 */
    { 0x0c5f92, 0x0c5f92, 0xfcba, 0x0345, 0, 0 }, /* #82 */
    { 0x1356c2, 0x1356c2, 0x5454, 0xabab, 0, 0 }, /* #83 */
    { 0x232013, 0x232013, 0x8141, 0x7ebe, 0, 0 }, /* #84 */
    { 0x2c4cd7, 0x2c4cd7, 0xde48, 0x21b7, 0, 0 }, /* #85 */
    { 0x014946, 0x014946, 0x0da2, 0xf25d, 0, 0 }, /* #86 */
    { 0x0b2fd6, 0x0b2fd6, 0xab3f, 0x54c0, 0, 0 }, /* #87 */
    { 0x3b1912, 0x3b1912, 0xc254, 0x3dab, 0, 0 }, /* #88 */
    { 0x3d1702, 0x3d1702, 0x1ec7, 0xe138, 0, 0 }, /* #89 */
    { 0x3e0393, 0x3e0393, 0x66a5, 0x995a, 0, 0 }, /* #90 */
    { 0x382043, 0x382043, 0xf66e, 0x0991, 0, 0 }, /* #91 */
    { 0x266607, 0x266607, 0x8c89, 0x7376, 0, 0 }, /* #92 */
    { 0x2a3d82, 0x2a3d82, 0xf77d, 0x0882, 0, 0 }, /* #93 */
    { 0x0b6397, 0x0b6397, 0xb6d3, 0x492c, 0, 0 }, /* #94 */
    { 0x175416, 0x175416, 0x019a, 0xfe65, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_not_u16_locked = RT_ELEMENTS(g_aTests_not_u16_locked);

BINU16_TEST_T const g_aTests_neg_u16[] =
{
    { 0x3863c2, 0x386313, 0xb97d, 0x4683, 0, 0 }, /* #0 */
    { 0x363d52, 0x363517, 0xe1c7, 0x1e39, 0, 0 }, /* #1 */
    { 0x0d44d2, 0x0d4497, 0x0a9d, 0xf563, 0, 0 }, /* #2 */
    { 0x007793, 0x007717, 0xf472, 0x0b8e, 0, 0 }, /* #3 */
    { 0x362206, 0x362293, 0x2da5, 0xd25b, 0, 0 }, /* #4 */
    { 0x113893, 0x113097, 0x716a, 0x8e96, 0, 0 }, /* #5 */
    { 0x0d0957, 0x0d0193, 0x12fc, 0xed04, 0, 0 }, /* #6 */
    { 0x321e16, 0x321617, 0xb657, 0x49a9, 0, 0 }, /* #7 */
    { 0x360006, 0x360093, 0x50fe, 0xaf02, 0, 0 }, /* #8 */
    { 0x205882, 0x205097, 0x4742, 0xb8be, 0, 0 }, /* #9 */
    { 0x352e03, 0x352693, 0x07f9, 0xf807, 0, 0 }, /* #10 */
    { 0x2b7502, 0x2b7593, 0x0ec5, 0xf13b, 0, 0 }, /* #11 */
    { 0x2d13d7, 0x2d1397, 0x4b73, 0xb48d, 0, 0 }, /* #12 */
    { 0x392cc7, 0x392497, 0x3179, 0xce87, 0, 0 }, /* #13 */
    { 0x0f2e52, 0x0f2617, 0x8567, 0x7a99, 0, 0 }, /* #14 */
    { 0x347c06, 0x347493, 0x6d6f, 0x9291, 0, 0 }, /* #15 */
    { 0x1d7893, 0x1d7093, 0x30ed, 0xcf13, 0, 0 }, /* #16 */
    { 0x0540d6, 0x054013, 0xd08d, 0x2f73, 0, 0 }, /* #17 */
    { 0x0a5386, 0x0a5317, 0xf145, 0x0ebb, 0, 0 }, /* #18 */
    { 0x1b0257, 0x1b0213, 0xf89e, 0x0762, 0, 0 }, /* #19 */
    { 0x1b09c3, 0x1b0197, 0x0248, 0xfdb8, 0, 0 }, /* #20 */
    { 0x330e86, 0x330613, 0x8eae, 0x7152, 0, 0 }, /* #21 */
    { 0x1d5116, 0x1d5113, 0xd02b, 0x2fd5, 0, 0 }, /* #22 */
    { 0x114c86, 0x114493, 0x3327, 0xccd9, 0, 0 }, /* #23 */
    { 0x395312, 0x395313, 0xcc16, 0x33ea, 0, 0 }, /* #24 */
    { 0x1d00c7, 0x1d0017, 0xb222, 0x4dde, 0, 0 }, /* #25 */
    { 0x1f3b12, 0x1f3313, 0xb4e6, 0x4b1a, 0, 0 }, /* #26 */
    { 0x386957, 0x386197, 0x7aa7, 0x8559, 0, 0 }, /* #27 */
    { 0x176e13, 0x176617, 0xc0aa, 0x3f56, 0, 0 }, /* #28 */
    { 0x1b58c2, 0x1b5093, 0x4276, 0xbd8a, 0, 0 }, /* #29 */
    { 0x352787, 0x352717, 0xc2b5, 0x3d4b, 0, 0 }, /* #30 */
    { 0x297482, 0x297493, 0x369f, 0xc961, 0, 0 }, /* #31 */
    { 0x3776c2, 0x377617, 0xd5d9, 0x2a27, 0, 0 }, /* #32 */
    { 0x1a4d17, 0x1a4513, 0xf9ce, 0x0632, 0, 0 }, /* #33 */
    { 0x127846, 0x127013, 0xa592, 0x5a6e, 0, 0 }, /* #34 */
    { 0x387ad2, 0x387217, 0xe7d3, 0x182d, 0, 0 }, /* #35 */
    { 0x2d7943, 0x2d7193, 0x1ceb, 0xe315, 0, 0 }, /* #36 */
    { 0x073787, 0x073703, 0xad30, 0x52d0, 0, 0 }, /* #37 */
    { 0x116a07, 0x116297, 0x09ef, 0xf611, 0, 0 }, /* #38 */
    { 0x1e3793, 0x1e3793, 0x0acf, 0xf531, 0, 0 }, /* #39 */
    { 0x0c7583, 0x0c7593, 0x42dd, 0xbd23, 0, 0 }, /* #40 */
    { 0x3f5483, 0x3f5413, 0xa8da, 0x5726, 0, 0 }, /* #41 */
    { 0x124987, 0x124117, 0xe661, 0x199f, 0, 0 }, /* #42 */
    { 0x3e3512, 0x3e3517, 0xd642, 0x29be, 0, 0 }, /* #43 */
    { 0x0c4042, 0x0c4017, 0xda82, 0x257e, 0, 0 }, /* #44 */
    { 0x1e1b52, 0x1e1313, 0xffc9, 0x0037, 0, 0 }, /* #45 */
    { 0x1e0486, 0x1e0417, 0xc2be, 0x3d42, 0, 0 }, /* #46 */
    { 0x0c5902, 0x0c5113, 0xc1a3, 0x3e5d, 0, 0 }, /* #47 */
    { 0x3d15c7, 0x3d1597, 0x1c88, 0xe378, 0, 0 }, /* #48 */
    { 0x051f06, 0x051793, 0x58ac, 0xa754, 0, 0 }, /* #49 */
    { 0x2c09c6, 0x2c0193, 0x5ac8, 0xa538, 0, 0 }, /* #50 */
    { 0x237a43, 0x237217, 0x8d85, 0x727b, 0, 0 }, /* #51 */
    { 0x1c1687, 0x1c1697, 0x7845, 0x87bb, 0, 0 }, /* #52 */
    { 0x163ec6, 0x163613, 0xd96e, 0x2692, 0, 0 }, /* #53 */
    { 0x094503, 0x094593, 0x711d, 0x8ee3, 0, 0 }, /* #54 */
    { 0x1d2d87, 0x1d2597, 0x648f, 0x9b71, 0, 0 }, /* #55 */
    { 0x1a5b52, 0x1a5317, 0xd9c7, 0x2639, 0, 0 }, /* #56 */
    { 0x321f57, 0x321717, 0x91e8, 0x6e18, 0, 0 }, /* #57 */
    { 0x3c3a93, 0x3c3217, 0xd845, 0x27bb, 0, 0 }, /* #58 */
    { 0x2739d7, 0x273193, 0x7e99, 0x8167, 0, 0 }, /* #59 */
    { 0x137286, 0x137213, 0x9aba, 0x6546, 0, 0 }, /* #60 */
    { 0x0d1287, 0x0d1213, 0xa087, 0x5f79, 0, 0 }, /* #61 */
    { 0x086013, 0x086013, 0xddaf, 0x2251, 0, 0 }, /* #62 */
    { 0x333e17, 0x333693, 0x0d65, 0xf29b, 0, 0 }, /* #63 */
    { 0x221313, 0x221393, 0x5e69, 0xa197, 0, 0 }, /* #64 */
    { 0x335246, 0x335213, 0x9a1a, 0x65e6, 0, 0 }, /* #65 */
    { 0x2c0ad7, 0x2c0217, 0xea79, 0x1587, 0, 0 }, /* #66 */
    { 0x381907, 0x381193, 0x79d4, 0x862c, 0, 0 }, /* #67 */
    { 0x0c3fd3, 0x0c3717, 0x94c4, 0x6b3c, 0, 0 }, /* #68 */
    { 0x0549d2, 0x054197, 0x69e5, 0x961b, 0, 0 }, /* #69 */
    { 0x251dc7, 0x251517, 0xf56b, 0x0a95, 0, 0 }, /* #70 */
    { 0x0760c3, 0x076017, 0xdfe5, 0x201b, 0, 0 }, /* #71 */
    { 0x242d83, 0x242593, 0x4de4, 0xb21c, 0, 0 }, /* #72 */
    { 0x3c2b52, 0x3c2313, 0xe35e, 0x1ca2, 0, 0 }, /* #73 */
    { 0x3a75d6, 0x3a7597, 0x7ebf, 0x8141, 0, 0 }, /* #74 */
    { 0x1b4006, 0x1b4013, 0xe46c, 0x1b94, 0, 0 }, /* #75 */
    { 0x1c3b42, 0x1c3317, 0xffd5, 0x002b, 0, 0 }, /* #76 */
    { 0x0438c2, 0x043093, 0x0e84, 0xf17c, 0, 0 }, /* #77 */
    { 0x1e1853, 0x1e1093, 0x0469, 0xfb97, 0, 0 }, /* #78 */
    { 0x1042c2, 0x104297, 0x0b25, 0xf4db, 0, 0 }, /* #79 */
    { 0x280f57, 0x280797, 0x5ee9, 0xa117, 0, 0 }, /* #80 */
    { 0x0f3c97, 0x0f3413, 0x9717, 0x68e9, 0, 0 }, /* #81 */
    { 0x345812, 0x345013, 0xa152, 0x5eae, 0, 0 }, /* #82 */
    { 0x3e2b42, 0x3e2383, 0x7b50, 0x84b0, 0, 0 }, /* #83 */
    { 0x260896, 0x260013, 0xdca3, 0x235d, 0, 0 }, /* #84 */
    { 0x3d7717, 0x3d7797, 0x7eb8, 0x8148, 0, 0 }, /* #85 */
    { 0x206b06, 0x206393, 0x4062, 0xbf9e, 0, 0 }, /* #86 */
    { 0x181852, 0x181097, 0x095d, 0xf6a3, 0, 0 }, /* #87 */
    { 0x2f0d97, 0x2f0513, 0xbbf2, 0x440e, 0, 0 }, /* #88 */
    { 0x3d3e93, 0x3d3617, 0xd472, 0x2b8e, 0, 0 }, /* #89 */
    { 0x0751d6, 0x075193, 0x4e14, 0xb1ec, 0, 0 }, /* #90 */
    { 0x171512, 0x171597, 0x2acb, 0xd535, 0, 0 }, /* #91 */
    { 0x345883, 0x345097, 0x71e3, 0x8e1d, 0, 0 }, /* #92 */
    { 0x3f0f92, 0x3f0787, 0x3a10, 0xc5f0, 0, 0 }, /* #93 */
    { 0x210016, 0x210013, 0xf477, 0x0b89, 0, 0 }, /* #94 */
    { 0x112016, 0x112017, 0x966b, 0x6995, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_neg_u16 = RT_ELEMENTS(g_aTests_neg_u16);

BINU16_TEST_T const g_aTests_neg_u16_locked[] =
{
    { 0x374e43, 0x374613, 0xcb5e, 0x34a2, 0, 0 }, /* #0 */
    { 0x320752, 0x320793, 0x3816, 0xc7ea, 0, 0 }, /* #1 */
    { 0x0c0a46, 0x0c0217, 0xcde2, 0x321e, 0, 0 }, /* #2 */
    { 0x060f87, 0x060713, 0x80f5, 0x7f0b, 0, 0 }, /* #3 */
    { 0x0f5606, 0x0f5693, 0x0924, 0xf6dc, 0, 0 }, /* #4 */
    { 0x251b97, 0x251317, 0xd813, 0x27ed, 0, 0 }, /* #5 */
    { 0x027ad6, 0x027213, 0xfd84, 0x027c, 0, 0 }, /* #6 */
    { 0x3c4f06, 0x3c4713, 0xcf74, 0x308c, 0, 0 }, /* #7 */
    { 0x082182, 0x082193, 0x6edb, 0x9125, 0, 0 }, /* #8 */
    { 0x133983, 0x133197, 0x1fbf, 0xe041, 0, 0 }, /* #9 */
    { 0x360687, 0x360613, 0x9962, 0x669e, 0, 0 }, /* #10 */
    { 0x351447, 0x351413, 0xc94d, 0x36b3, 0, 0 }, /* #11 */
    { 0x0c1453, 0x0c1417, 0xfbef, 0x0411, 0, 0 }, /* #12 */
    { 0x054a42, 0x054217, 0x8657, 0x79a9, 0, 0 }, /* #13 */
    { 0x046197, 0x046193, 0x40e4, 0xbf1c, 0, 0 }, /* #14 */
    { 0x1a53c6, 0x1a5313, 0xd459, 0x2ba7, 0, 0 }, /* #15 */
    { 0x142b17, 0x142313, 0xeebd, 0x1143, 0, 0 }, /* #16 */
    { 0x185a56, 0x185293, 0x61f2, 0x9e0e, 0, 0 }, /* #17 */
    { 0x3d3443, 0x3d3413, 0xfb8b, 0x0475, 0, 0 }, /* #18 */
    { 0x216b17, 0x216317, 0xffa7, 0x0059, 0, 0 }, /* #19 */
    { 0x3f4616, 0x3f4697, 0x6985, 0x967b, 0, 0 }, /* #20 */
    { 0x346b06, 0x346397, 0x0c28, 0xf3d8, 0, 0 }, /* #21 */
    { 0x0c0ed2, 0x0c0617, 0xb443, 0x4bbd, 0, 0 }, /* #22 */
    { 0x1c1886, 0x1c1017, 0xda9d, 0x2563, 0, 0 }, /* #23 */
    { 0x253b87, 0x253397, 0x2589, 0xda77, 0, 0 }, /* #24 */
    { 0x2d1903, 0x2d1197, 0x27b9, 0xd847, 0, 0 }, /* #25 */
    { 0x3c7d07, 0x3c7513, 0x94db, 0x6b25, 0, 0 }, /* #26 */
    { 0x2a4517, 0x2a4513, 0xde9c, 0x2164, 0, 0 }, /* #27 */
    { 0x3f0017, 0x3f0017, 0xa46a, 0x5b96, 0, 0 }, /* #28 */
    { 0x2e5157, 0x2e5113, 0xf4c8, 0x0b38, 0, 0 }, /* #29 */
    { 0x172d57, 0x172517, 0xa4ef, 0x5b11, 0, 0 }, /* #30 */
    { 0x0f5a57, 0x0f5217, 0xaaf6, 0x550a, 0, 0 }, /* #31 */
    { 0x031a02, 0x031217, 0xa985, 0x567b, 0, 0 }, /* #32 */
    { 0x1f5f46, 0x1f5797, 0x507c, 0xaf84, 0, 0 }, /* #33 */
    { 0x043206, 0x043293, 0x4586, 0xba7a, 0, 0 }, /* #34 */
    { 0x1405d6, 0x140517, 0xc09b, 0x3f65, 0, 0 }, /* #35 */
    { 0x334692, 0x334603, 0xb7e0, 0x4820, 0, 0 }, /* #36 */
    { 0x1f7082, 0x1f7013, 0xe45c, 0x1ba4, 0, 0 }, /* #37 */
    { 0x2c7306, 0x2c7317, 0x96cd, 0x6933, 0, 0 }, /* #38 */
    { 0x0229c7, 0x022193, 0x1174, 0xee8c, 0, 0 }, /* #39 */
    { 0x125492, 0x125497, 0x7243, 0x8dbd, 0, 0 }, /* #40 */
    { 0x184ec7, 0x184693, 0x7459, 0x8ba7, 0, 0 }, /* #41 */
    { 0x0c3386, 0x0c3313, 0xd38d, 0x2c73, 0, 0 }, /* #42 */
    { 0x360a16, 0x360293, 0x436c, 0xbc94, 0, 0 }, /* #43 */
    { 0x2c2383, 0x2c2317, 0xfe6a, 0x0196, 0, 0 }, /* #44 */
    { 0x213016, 0x213097, 0x3607, 0xc9f9, 0, 0 }, /* #45 */
    { 0x3b1582, 0x3b1517, 0xbd6a, 0x4296, 0, 0 }, /* #46 */
    { 0x344216, 0x344213, 0xae76, 0x518a, 0, 0 }, /* #47 */
    { 0x0d30c2, 0x0d3017, 0x9f91, 0x606f, 0, 0 }, /* #48 */
    { 0x293093, 0x293097, 0x5c22, 0xa3de, 0, 0 }, /* #49 */
    { 0x3d5d07, 0x3d5597, 0x150d, 0xeaf3, 0, 0 }, /* #50 */
    { 0x1e7596, 0x1e7593, 0x4f5c, 0xb0a4, 0, 0 }, /* #51 */
    { 0x2d7e46, 0x2d7697, 0x5685, 0xa97b, 0, 0 }, /* #52 */
    { 0x341c07, 0x341413, 0xf7ed, 0x0813, 0, 0 }, /* #53 */
    { 0x0b7717, 0x0b7797, 0x1761, 0xe89f, 0, 0 }, /* #54 */
    { 0x113c12, 0x113497, 0x0348, 0xfcb8, 0, 0 }, /* #55 */
    { 0x3b2197, 0x3b2197, 0x5b04, 0xa4fc, 0, 0 }, /* #56 */
    { 0x2770c6, 0x277093, 0x6465, 0x9b9b, 0, 0 }, /* #57 */
    { 0x351a87, 0x351297, 0x725b, 0x8da5, 0, 0 }, /* #58 */
    { 0x195b43, 0x195387, 0x65d0, 0x9a30, 0, 0 }, /* #59 */
    { 0x2d27d2, 0x2d2713, 0xa8e4, 0x571c, 0, 0 }, /* #60 */
    { 0x0a3907, 0x0a3117, 0xd501, 0x2aff, 0, 0 }, /* #61 */
    { 0x026a16, 0x026213, 0x9ee6, 0x611a, 0, 0 }, /* #62 */
    { 0x300dd6, 0x300593, 0x6dd1, 0x922f, 0, 0 }, /* #63 */
    { 0x213817, 0x213013, 0x8986, 0x767a, 0, 0 }, /* #64 */
    { 0x267686, 0x267697, 0x0d0a, 0xf2f6, 0, 0 }, /* #65 */
    { 0x381f16, 0x381703, 0x8d90, 0x7270, 0, 0 }, /* #66 */
    { 0x375a13, 0x375213, 0xe055, 0x1fab, 0, 0 }, /* #67 */
    { 0x3707c2, 0x370783, 0x44c0, 0xbb40, 0, 0 }, /* #68 */
    { 0x1b1a96, 0x1b1293, 0x009f, 0xff61, 0, 0 }, /* #69 */
    { 0x2d5b42, 0x2d5393, 0x720c, 0x8df4, 0, 0 }, /* #70 */
    { 0x391646, 0x391693, 0x7c24, 0x83dc, 0, 0 }, /* #71 */
    { 0x154b43, 0x154393, 0x05ea, 0xfa16, 0, 0 }, /* #72 */
    { 0x307713, 0x307793, 0x1981, 0xe67f, 0, 0 }, /* #73 */
    { 0x254e47, 0x254613, 0xa87d, 0x5783, 0, 0 }, /* #74 */
    { 0x2105c3, 0x210513, 0xa44d, 0x5bb3, 0, 0 }, /* #75 */
    { 0x3a6e82, 0x3a6613, 0xe5fc, 0x1a04, 0, 0 }, /* #76 */
    { 0x213dd2, 0x213517, 0xf906, 0x06fa, 0, 0 }, /* #77 */
    { 0x2a5886, 0x2a5093, 0x1ceb, 0xe315, 0, 0 }, /* #78 */
    { 0x0f7e57, 0x0f7617, 0x802f, 0x7fd1, 0, 0 }, /* #79 */
    { 0x163416, 0x163497, 0x7c5a, 0x83a6, 0, 0 }, /* #80 */
    { 0x2a26d7, 0x2a2693, 0x3726, 0xc8da, 0, 0 }, /* #81 */
    { 0x3a5092, 0x3a5093, 0x583c, 0xa7c4, 0, 0 }, /* #82 */
    { 0x1a3042, 0x1a3017, 0x9ec6, 0x613a, 0, 0 }, /* #83 */
    { 0x2f7c57, 0x2f7413, 0xa3fc, 0x5c04, 0, 0 }, /* #84 */
    { 0x144983, 0x144197, 0x1a48, 0xe5b8, 0, 0 }, /* #85 */
    { 0x2d2a92, 0x2d2293, 0x3565, 0xca9b, 0, 0 }, /* #86 */
    { 0x274487, 0x274497, 0x21c1, 0xde3f, 0, 0 }, /* #87 */
    { 0x147953, 0x147113, 0xb82d, 0x47d3, 0, 0 }, /* #88 */
    { 0x113b52, 0x113397, 0x0e66, 0xf19a, 0, 0 }, /* #89 */
    { 0x2a3a82, 0x2a3293, 0x71c2, 0x8e3e, 0, 0 }, /* #90 */
    { 0x3167c3, 0x316717, 0xfd25, 0x02db, 0, 0 }, /* #91 */
    { 0x042393, 0x042317, 0xa573, 0x5a8d, 0, 0 }, /* #92 */
    { 0x2c1183, 0x2c1117, 0xdf73, 0x208d, 0, 0 }, /* #93 */
    { 0x095016, 0x095093, 0x211a, 0xdee6, 0, 0 }, /* #94 */
    { 0x0d53c7, 0x0d5317, 0xf7b2, 0x084e, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_neg_u16_locked = RT_ELEMENTS(g_aTests_neg_u16_locked);

BINU32_TEST_T const g_aTests_inc_u32[] =
{
    { 0x362dd7, 0x362587, 0x8a3f5902, 0x8a3f5903, 0, 0 }, /* #0 */
    { 0x3a1b07, 0x3a1303, 0x23aef89c, 0x23aef89d, 0, 0 }, /* #1 */
    { 0x003b83, 0x003303, 0x4e7b7545, 0x4e7b7546, 0, 0 }, /* #2 */
    { 0x245657, 0x245687, 0xd06374b7, 0xd06374b8, 0, 0 }, /* #3 */
    { 0x2b6f13, 0x2b6707, 0x7cef9532, 0x7cef9533, 0, 0 }, /* #4 */
    { 0x081f16, 0x081702, 0x7fcd4cc1, 0x7fcd4cc2, 0, 0 }, /* #5 */
    { 0x396352, 0x396382, 0xe1ab0e85, 0xe1ab0e86, 0, 0 }, /* #6 */
    { 0x011147, 0x011113, 0x063efc1f, 0x063efc20, 0, 0 }, /* #7 */
    { 0x173393, 0x173387, 0xe300991d, 0xe300991e, 0, 0 }, /* #8 */
    { 0x2f52c7, 0x2f5207, 0x33472362, 0x33472363, 0, 0 }, /* #9 */
    { 0x2b6c17, 0x2b6407, 0x351da581, 0x351da582, 0, 0 }, /* #10 */
    { 0x012d06, 0x012506, 0x06fd5e9b, 0x06fd5e9c, 0, 0 }, /* #11 */
    { 0x197443, 0x197407, 0x07c9faba, 0x07c9fabb, 0, 0 }, /* #12 */
    { 0x015053, 0x015083, 0xcf75603a, 0xcf75603b, 0, 0 }, /* #13 */
    { 0x130417, 0x130403, 0x207110e9, 0x207110ea, 0, 0 }, /* #14 */
    { 0x2f48c7, 0x2f4083, 0xfdfe1557, 0xfdfe1558, 0, 0 }, /* #15 */
    { 0x2f61d6, 0x2f6102, 0x566c6624, 0x566c6625, 0, 0 }, /* #16 */
    { 0x106196, 0x106182, 0xd96361fd, 0xd96361fe, 0, 0 }, /* #17 */
    { 0x2b3187, 0x2b3107, 0x33f2c0c8, 0x33f2c0c9, 0, 0 }, /* #18 */
    { 0x3e4507, 0x3e4583, 0xd5d1b95d, 0xd5d1b95e, 0, 0 }, /* #19 */
    { 0x1a3286, 0x1a3282, 0xda40bbb2, 0xda40bbb3, 0, 0 }, /* #20 */
    { 0x0a5dd2, 0x0a5592, 0xc8c1821f, 0xc8c18220, 0, 0 }, /* #21 */
    { 0x306482, 0x306402, 0x765f756a, 0x765f756b, 0, 0 }, /* #22 */
    { 0x131b12, 0x131386, 0xd8bb0c54, 0xd8bb0c55, 0, 0 }, /* #23 */
    { 0x071747, 0x071787, 0xcacefeab, 0xcacefeac, 0, 0 }, /* #24 */
    { 0x007857, 0x007087, 0xbb87a8b7, 0xbb87a8b8, 0, 0 }, /* #25 */
    { 0x2f55c6, 0x2f5502, 0x24f8bf48, 0x24f8bf49, 0, 0 }, /* #26 */
    { 0x334887, 0x334083, 0xf015f6fa, 0xf015f6fb, 0, 0 }, /* #27 */
    { 0x1610d3, 0x161087, 0xcf3e0a2a, 0xcf3e0a2b, 0, 0 }, /* #28 */
    { 0x341243, 0x341207, 0x520484e0, 0x520484e1, 0, 0 }, /* #29 */
    { 0x2a4f46, 0x2a4702, 0x17a225f0, 0x17a225f1, 0, 0 }, /* #30 */
    { 0x371992, 0x371192, 0xab63077f, 0xab630780, 0, 0 }, /* #31 */
    { 0x223402, 0x223482, 0xdf0fdd14, 0xdf0fdd15, 0, 0 }, /* #32 */
    { 0x3b1b52, 0x3b1306, 0x11499881, 0x11499882, 0, 0 }, /* #33 */
    { 0x0f5fc2, 0x0f5782, 0xbd79f145, 0xbd79f146, 0, 0 }, /* #34 */
    { 0x1c1946, 0x1c1182, 0xd62ec3de, 0xd62ec3df, 0, 0 }, /* #35 */
    { 0x1911d6, 0x191196, 0xa375d7ef, 0xa375d7f0, 0, 0 }, /* #36 */
    { 0x2d6902, 0x2d6182, 0xf1a89af0, 0xf1a89af1, 0, 0 }, /* #37 */
    { 0x1b6c43, 0x1b6407, 0x21dff571, 0x21dff572, 0, 0 }, /* #38 */
    { 0x3a08c3, 0x3a0087, 0xbb4eb33b, 0xbb4eb33c, 0, 0 }, /* #39 */
    { 0x327d03, 0x327507, 0x2a87afa2, 0x2a87afa3, 0, 0 }, /* #40 */
    { 0x127997, 0x127183, 0xaaf7fa63, 0xaaf7fa64, 0, 0 }, /* #41 */
    { 0x1a4282, 0x1a4202, 0x010bb542, 0x010bb543, 0, 0 }, /* #42 */
    { 0x381992, 0x381182, 0xe66635cd, 0xe66635ce, 0, 0 }, /* #43 */
    { 0x2603d2, 0x260306, 0x158e34f9, 0x158e34fa, 0, 0 }, /* #44 */
    { 0x2d1513, 0x2d1507, 0x36397c0b, 0x36397c0c, 0, 0 }, /* #45 */
    { 0x1770c3, 0x177007, 0x73d34186, 0x73d34187, 0, 0 }, /* #46 */
    { 0x1a67c2, 0x1a6786, 0xafb16ded, 0xafb16dee, 0, 0 }, /* #47 */
    { 0x217216, 0x217296, 0xe14e87bf, 0xe14e87c0, 0, 0 }, /* #48 */
    { 0x203a97, 0x203283, 0xaa8e6978, 0xaa8e6979, 0, 0 }, /* #49 */
    { 0x226207, 0x226207, 0x78fb51fe, 0x78fb51ff, 0, 0 }, /* #50 */
    { 0x135702, 0x135706, 0x72502d21, 0x72502d22, 0, 0 }, /* #51 */
    { 0x0b42c7, 0x0b4207, 0x49e36981, 0x49e36982, 0, 0 }, /* #52 */
    { 0x2f28d6, 0x2f2002, 0x7c751791, 0x7c751792, 0, 0 }, /* #53 */
    { 0x252047, 0x252087, 0x97db83d3, 0x97db83d4, 0, 0 }, /* #54 */
    { 0x2b4f87, 0x2b4713, 0x71eefd6f, 0x71eefd70, 0, 0 }, /* #55 */
    { 0x103186, 0x103182, 0x967af714, 0x967af715, 0, 0 }, /* #56 */
    { 0x052682, 0x052682, 0xea69363d, 0xea69363e, 0, 0 }, /* #57 */
    { 0x117fc6, 0x117786, 0x860c0fed, 0x860c0fee, 0, 0 }, /* #58 */
    { 0x243b06, 0x243382, 0x88af611e, 0x88af611f, 0, 0 }, /* #59 */
    { 0x286e86, 0x286686, 0xfaf38b43, 0xfaf38b44, 0, 0 }, /* #60 */
    { 0x025383, 0x025387, 0xd8f09dae, 0xd8f09daf, 0, 0 }, /* #61 */
    { 0x204d96, 0x204586, 0xc5cecb05, 0xc5cecb06, 0, 0 }, /* #62 */
    { 0x2b6f16, 0x2b6786, 0xc5e84d16, 0xc5e84d17, 0, 0 }, /* #63 */
    { 0x234456, 0x234482, 0xa4f03fe2, 0xa4f03fe3, 0, 0 }, /* #64 */
    { 0x192a07, 0x192203, 0x38d602a1, 0x38d602a2, 0, 0 }, /* #65 */
    { 0x0d1f57, 0x0d1783, 0xf4825961, 0xf4825962, 0, 0 }, /* #66 */
    { 0x116e97, 0x116683, 0x8243c736, 0x8243c737, 0, 0 }, /* #67 */
    { 0x0a6952, 0x0a6182, 0xdb5370c6, 0xdb5370c7, 0, 0 }, /* #68 */
    { 0x280f07, 0x280717, 0x61e06b9f, 0x61e06ba0, 0, 0 }, /* #69 */
    { 0x050f56, 0x050786, 0xe27f1d9e, 0xe27f1d9f, 0, 0 }, /* #70 */
    { 0x3879c6, 0x387182, 0xfa296ce4, 0xfa296ce5, 0, 0 }, /* #71 */
    { 0x3c25c2, 0x3c2582, 0xd69c9901, 0xd69c9902, 0, 0 }, /* #72 */
    { 0x236413, 0x236483, 0xc2bcd412, 0xc2bcd413, 0, 0 }, /* #73 */
    { 0x2966d2, 0x296682, 0xc3767d51, 0xc3767d52, 0, 0 }, /* #74 */
    { 0x3a1903, 0x3a1187, 0xea37d720, 0xea37d721, 0, 0 }, /* #75 */
    { 0x125d07, 0x125503, 0x7f240118, 0x7f240119, 0, 0 }, /* #76 */
    { 0x152e86, 0x152682, 0xf06fbc9d, 0xf06fbc9e, 0, 0 }, /* #77 */
    { 0x3b3e47, 0x3b3683, 0xa02ad3fa, 0xa02ad3fb, 0, 0 }, /* #78 */
    { 0x1a4cd3, 0x1a4407, 0x118c2a9e, 0x118c2a9f, 0, 0 }, /* #79 */
    { 0x3d4d07, 0x3d4587, 0xb4c5aae3, 0xb4c5aae4, 0, 0 }, /* #80 */
    { 0x227e86, 0x227606, 0x5796c3ec, 0x5796c3ed, 0, 0 }, /* #81 */
    { 0x105b42, 0x105382, 0xc79e4529, 0xc79e452a, 0, 0 }, /* #82 */
    { 0x181517, 0x181503, 0x775217c1, 0x775217c2, 0, 0 }, /* #83 */
    { 0x133e53, 0x133607, 0x245ec799, 0x245ec79a, 0, 0 }, /* #84 */
    { 0x031892, 0x031006, 0x357b3880, 0x357b3881, 0, 0 }, /* #85 */
    { 0x3967d2, 0x396702, 0x78f65fde, 0x78f65fdf, 0, 0 }, /* #86 */
    { 0x170116, 0x170102, 0x50d147a7, 0x50d147a8, 0, 0 }, /* #87 */
    { 0x382207, 0x382203, 0x017783a0, 0x017783a1, 0, 0 }, /* #88 */
    { 0x3944c6, 0x394482, 0xace14d49, 0xace14d4a, 0, 0 }, /* #89 */
    { 0x041b13, 0x041387, 0xce18e12d, 0xce18e12e, 0, 0 }, /* #90 */
    { 0x3e4ad2, 0x3e4286, 0xc938bdcb, 0xc938bdcc, 0, 0 }, /* #91 */
    { 0x0666d3, 0x066693, 0xc9863d3f, 0xc9863d40, 0, 0 }, /* #92 */
    { 0x185847, 0x185007, 0x4a1f3c41, 0x4a1f3c42, 0, 0 }, /* #93 */
    { 0x0a6186, 0x0a6196, 0xad471bff, 0xad471c00, 0, 0 }, /* #94 */
    { 0x025453, 0x025487, 0xf73ab099, 0xf73ab09a, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_inc_u32 = RT_ELEMENTS(g_aTests_inc_u32);

BINU32_TEST_T const g_aTests_inc_u32_locked[] =
{
    { 0x036317, 0x036307, 0x1a048eb1, 0x1a048eb2, 0, 0 }, /* #0 */
    { 0x284753, 0x284703, 0x6c8c67fa, 0x6c8c67fb, 0, 0 }, /* #1 */
    { 0x2f51c2, 0x2f5182, 0xbe2706c7, 0xbe2706c8, 0, 0 }, /* #2 */
    { 0x3a2003, 0x3a2087, 0xc9be6dfb, 0xc9be6dfc, 0, 0 }, /* #3 */
    { 0x3943c3, 0x394303, 0x030e5c6c, 0x030e5c6d, 0, 0 }, /* #4 */
    { 0x1022c2, 0x102286, 0xe7fbbce0, 0xe7fbbce1, 0, 0 }, /* #5 */
    { 0x2c2503, 0x2c2507, 0x74dfc6dd, 0x74dfc6de, 0, 0 }, /* #6 */
    { 0x117383, 0x117387, 0xdea50498, 0xdea50499, 0, 0 }, /* #7 */
    { 0x3b7b07, 0x3b7307, 0x36fb6c8c, 0x36fb6c8d, 0, 0 }, /* #8 */
    { 0x0d5386, 0x0d5306, 0x7e1d767c, 0x7e1d767d, 0, 0 }, /* #9 */
    { 0x217c86, 0x217482, 0x88f0da63, 0x88f0da64, 0, 0 }, /* #10 */
    { 0x005507, 0x005507, 0x090e1499, 0x090e149a, 0, 0 }, /* #11 */
    { 0x062807, 0x062007, 0x7ea12204, 0x7ea12205, 0, 0 }, /* #12 */
    { 0x3b6fc6, 0x3b6706, 0x6bf65e32, 0x6bf65e33, 0, 0 }, /* #13 */
    { 0x1d0dc7, 0x1d0583, 0xb008bdc6, 0xb008bdc7, 0, 0 }, /* #14 */
    { 0x336293, 0x336287, 0xb2864ff8, 0xb2864ff9, 0, 0 }, /* #15 */
    { 0x334513, 0x334507, 0x54fb99a8, 0x54fb99a9, 0, 0 }, /* #16 */
    { 0x1f5b52, 0x1f5386, 0xfe19ad5b, 0xfe19ad5c, 0, 0 }, /* #17 */
    { 0x1c0657, 0x1c0683, 0xd7a7fa9a, 0xd7a7fa9b, 0, 0 }, /* #18 */
    { 0x396897, 0x396083, 0xe6d54329, 0xe6d5432a, 0, 0 }, /* #19 */
    { 0x296c97, 0x296403, 0x652dcdfa, 0x652dcdfb, 0, 0 }, /* #20 */
    { 0x1652c7, 0x165207, 0x0db5ade7, 0x0db5ade8, 0, 0 }, /* #21 */
    { 0x2d5216, 0x2d5202, 0x5d467f5d, 0x5d467f5e, 0, 0 }, /* #22 */
    { 0x3d6606, 0x3d6606, 0x7e90134d, 0x7e90134e, 0, 0 }, /* #23 */
    { 0x125e06, 0x125692, 0x8880947f, 0x88809480, 0, 0 }, /* #24 */
    { 0x2e2fd7, 0x2e2707, 0x78014934, 0x78014935, 0, 0 }, /* #25 */
    { 0x015e07, 0x015607, 0x2450c605, 0x2450c606, 0, 0 }, /* #26 */
    { 0x3e1dd7, 0x3e1507, 0x5a6af1da, 0x5a6af1db, 0, 0 }, /* #27 */
    { 0x2d6696, 0x2d6602, 0x73db720c, 0x73db720d, 0, 0 }, /* #28 */
    { 0x1257d2, 0x125786, 0xe1d87532, 0xe1d87533, 0, 0 }, /* #29 */
    { 0x215447, 0x215483, 0xd30df463, 0xd30df464, 0, 0 }, /* #30 */
    { 0x3022c7, 0x302287, 0xd4ddb44a, 0xd4ddb44b, 0, 0 }, /* #31 */
    { 0x1044c3, 0x104487, 0xb45f5438, 0xb45f5439, 0, 0 }, /* #32 */
    { 0x2e3647, 0x2e3607, 0x65be4be7, 0x65be4be8, 0, 0 }, /* #33 */
    { 0x2b0052, 0x2b0002, 0x306fd3fd, 0x306fd3fe, 0, 0 }, /* #34 */
    { 0x172117, 0x172103, 0x6a90663a, 0x6a90663b, 0, 0 }, /* #35 */
    { 0x254952, 0x254186, 0x8ced140e, 0x8ced140f, 0, 0 }, /* #36 */
    { 0x046107, 0x046183, 0xafda5f3c, 0xafda5f3d, 0, 0 }, /* #37 */
    { 0x235503, 0x235503, 0x55f69ce8, 0x55f69ce9, 0, 0 }, /* #38 */
    { 0x365613, 0x365603, 0x69ab864e, 0x69ab864f, 0, 0 }, /* #39 */
    { 0x1e6e87, 0x1e6683, 0xa4c6f574, 0xa4c6f575, 0, 0 }, /* #40 */
    { 0x367412, 0x367402, 0x67334c15, 0x67334c16, 0, 0 }, /* #41 */
    { 0x084412, 0x084486, 0xf4f87409, 0xf4f8740a, 0, 0 }, /* #42 */
    { 0x0b2442, 0x0b2482, 0xfe499a56, 0xfe499a57, 0, 0 }, /* #43 */
    { 0x205d06, 0x205586, 0x803d9d80, 0x803d9d81, 0, 0 }, /* #44 */
    { 0x1024c6, 0x102482, 0xbd7adff6, 0xbd7adff7, 0, 0 }, /* #45 */
    { 0x1d1892, 0x1d1086, 0x8304550b, 0x8304550c, 0, 0 }, /* #46 */
    { 0x211803, 0x211003, 0x0f0a8874, 0x0f0a8875, 0, 0 }, /* #47 */
    { 0x021512, 0x021502, 0x114c56f1, 0x114c56f2, 0, 0 }, /* #48 */
    { 0x1e6ed3, 0x1e6607, 0x16f27ff5, 0x16f27ff6, 0, 0 }, /* #49 */
    { 0x2f14c2, 0x2f1402, 0x1a7ab2d5, 0x1a7ab2d6, 0, 0 }, /* #50 */
    { 0x387087, 0x387007, 0x1cf5e664, 0x1cf5e665, 0, 0 }, /* #51 */
    { 0x1b7fc3, 0x1b7787, 0x93005411, 0x93005412, 0, 0 }, /* #52 */
    { 0x1d3ac3, 0x1d3203, 0x45b75f78, 0x45b75f79, 0, 0 }, /* #53 */
    { 0x360ec3, 0x360613, 0x61bb5b1f, 0x61bb5b20, 0, 0 }, /* #54 */
    { 0x1f7397, 0x1f7303, 0x2f2a7b75, 0x2f2a7b76, 0, 0 }, /* #55 */
    { 0x197a43, 0x197203, 0x29e17082, 0x29e17083, 0, 0 }, /* #56 */
    { 0x210192, 0x210182, 0x8f9adf0c, 0x8f9adf0d, 0, 0 }, /* #57 */
    { 0x096e82, 0x096682, 0xcfeb19f3, 0xcfeb19f4, 0, 0 }, /* #58 */
    { 0x206612, 0x206602, 0x1faa6060, 0x1faa6061, 0, 0 }, /* #59 */
    { 0x267a52, 0x267206, 0x474a9de1, 0x474a9de2, 0, 0 }, /* #60 */
    { 0x1b1f92, 0x1b1782, 0xfc00f2b2, 0xfc00f2b3, 0, 0 }, /* #61 */
    { 0x2b1943, 0x2b1117, 0x76166e4f, 0x76166e50, 0, 0 }, /* #62 */
    { 0x052a52, 0x052206, 0x76d1684a, 0x76d1684b, 0, 0 }, /* #63 */
    { 0x1a1883, 0x1a1083, 0xa66304c7, 0xa66304c8, 0, 0 }, /* #64 */
    { 0x356e52, 0x356682, 0xfa28fd63, 0xfa28fd64, 0, 0 }, /* #65 */
    { 0x1f7ec6, 0x1f7696, 0xfc1651ef, 0xfc1651f0, 0, 0 }, /* #66 */
    { 0x176886, 0x176002, 0x69bb8ce4, 0x69bb8ce5, 0, 0 }, /* #67 */
    { 0x3c6f43, 0x3c6707, 0x7aef5a7c, 0x7aef5a7d, 0, 0 }, /* #68 */
    { 0x3302c2, 0x330206, 0x5673757a, 0x5673757b, 0, 0 }, /* #69 */
    { 0x1873d7, 0x187383, 0xebcf7cb5, 0xebcf7cb6, 0, 0 }, /* #70 */
    { 0x103746, 0x103782, 0xb8a12aac, 0xb8a12aad, 0, 0 }, /* #71 */
    { 0x3f66d3, 0x3f6607, 0x4a14c673, 0x4a14c674, 0, 0 }, /* #72 */
    { 0x3f4843, 0x3f4007, 0x54bc8ba2, 0x54bc8ba3, 0, 0 }, /* #73 */
    { 0x1158c2, 0x115016, 0x1d3787bf, 0x1d3787c0, 0, 0 }, /* #74 */
    { 0x260a87, 0x260287, 0xe18a9498, 0xe18a9499, 0, 0 }, /* #75 */
    { 0x2b4d97, 0x2b4507, 0x0a58898a, 0x0a58898b, 0, 0 }, /* #76 */
    { 0x0f4dc3, 0x0f4587, 0xddf21583, 0xddf21584, 0, 0 }, /* #77 */
    { 0x1a4ec2, 0x1a4602, 0x75581bf6, 0x75581bf7, 0, 0 }, /* #78 */
    { 0x037457, 0x037497, 0x89fab88f, 0x89fab890, 0, 0 }, /* #79 */
    { 0x1b38d6, 0x1b3086, 0xf6878455, 0xf6878456, 0, 0 }, /* #80 */
    { 0x3079d7, 0x307183, 0xa82ff351, 0xa82ff352, 0, 0 }, /* #81 */
    { 0x290e56, 0x290606, 0x748c9599, 0x748c959a, 0, 0 }, /* #82 */
    { 0x1416c7, 0x141607, 0x44ade898, 0x44ade899, 0, 0 }, /* #83 */
    { 0x0d0593, 0x0d0507, 0x3649c3d6, 0x3649c3d7, 0, 0 }, /* #84 */
    { 0x2c2547, 0x2c2587, 0xd1aa204c, 0xd1aa204d, 0, 0 }, /* #85 */
    { 0x3f6442, 0x3f6402, 0x182efa0c, 0x182efa0d, 0, 0 }, /* #86 */
    { 0x0d2d52, 0x0d2502, 0x45ef5da7, 0x45ef5da8, 0, 0 }, /* #87 */
    { 0x232812, 0x232086, 0xcfc46905, 0xcfc46906, 0, 0 }, /* #88 */
    { 0x2c2f86, 0x2c2702, 0x1ab1c682, 0x1ab1c683, 0, 0 }, /* #89 */
    { 0x231446, 0x231402, 0x55882403, 0x55882404, 0, 0 }, /* #90 */
    { 0x3918c2, 0x391006, 0x35480b7d, 0x35480b7e, 0, 0 }, /* #91 */
    { 0x337f07, 0x337783, 0xddd61c72, 0xddd61c73, 0, 0 }, /* #92 */
    { 0x1e7692, 0x1e7686, 0x968f29c5, 0x968f29c6, 0, 0 }, /* #93 */
    { 0x2f0506, 0x2f0502, 0x0e22c112, 0x0e22c113, 0, 0 }, /* #94 */
    { 0x325996, 0x325106, 0x1d57470b, 0x1d57470c, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_inc_u32_locked = RT_ELEMENTS(g_aTests_inc_u32_locked);

BINU32_TEST_T const g_aTests_dec_u32[] =
{
    { 0x2e31d2, 0x2e3186, 0xe6ae5b4f, 0xe6ae5b4e, 0, 0 }, /* #0 */
    { 0x365a17, 0x365207, 0x1f8c0e5d, 0x1f8c0e5c, 0, 0 }, /* #1 */
    { 0x0b5cd2, 0x0b5486, 0xc2a2f2f1, 0xc2a2f2f0, 0, 0 }, /* #2 */
    { 0x011056, 0x011092, 0xa65256e0, 0xa65256df, 0, 0 }, /* #3 */
    { 0x143192, 0x143186, 0xf38011a6, 0xf38011a5, 0, 0 }, /* #4 */
    { 0x3f3396, 0x3f3386, 0xfb2f4c2c, 0xfb2f4c2b, 0, 0 }, /* #5 */
    { 0x160b52, 0x160302, 0x54ca88ac, 0x54ca88ab, 0, 0 }, /* #6 */
    { 0x146847, 0x146087, 0xefbcd667, 0xefbcd666, 0, 0 }, /* #7 */
    { 0x0b0e13, 0x0b0603, 0x55463ec3, 0x55463ec2, 0, 0 }, /* #8 */
    { 0x3f6482, 0x3f6406, 0x76ec5407, 0x76ec5406, 0, 0 }, /* #9 */
    { 0x393646, 0x393602, 0x6b381a63, 0x6b381a62, 0, 0 }, /* #10 */
    { 0x144e53, 0x144687, 0x81a2674e, 0x81a2674d, 0, 0 }, /* #11 */
    { 0x246647, 0x246687, 0xc5e8d291, 0xc5e8d290, 0, 0 }, /* #12 */
    { 0x344407, 0x344487, 0xb1b04479, 0xb1b04478, 0, 0 }, /* #13 */
    { 0x1a0e87, 0x1a0687, 0x9191f907, 0x9191f906, 0, 0 }, /* #14 */
    { 0x1c4856, 0x1c4006, 0x4fda2828, 0x4fda2827, 0, 0 }, /* #15 */
    { 0x3740d7, 0x374003, 0x21654c16, 0x21654c15, 0, 0 }, /* #16 */
    { 0x127216, 0x127282, 0xa9b6bd27, 0xa9b6bd26, 0, 0 }, /* #17 */
    { 0x022292, 0x022286, 0x96bc6d94, 0x96bc6d93, 0, 0 }, /* #18 */
    { 0x3b4b43, 0x3b4387, 0xd2d14201, 0xd2d14200, 0, 0 }, /* #19 */
    { 0x271a47, 0x271283, 0xf5ee63eb, 0xf5ee63ea, 0, 0 }, /* #20 */
    { 0x3d4703, 0x3d4787, 0xdf82ca23, 0xdf82ca22, 0, 0 }, /* #21 */
    { 0x113743, 0x113783, 0xf12cdd3e, 0xf12cdd3d, 0, 0 }, /* #22 */
    { 0x311ed3, 0x311607, 0x7c1d10cb, 0x7c1d10ca, 0, 0 }, /* #23 */
    { 0x247913, 0x247107, 0x18a61bd2, 0x18a61bd1, 0, 0 }, /* #24 */
    { 0x221b86, 0x221306, 0x3ff40e3a, 0x3ff40e39, 0, 0 }, /* #25 */
    { 0x2c1517, 0x2c1503, 0x32abb09c, 0x32abb09b, 0, 0 }, /* #26 */
    { 0x356a93, 0x356207, 0x4e22ca82, 0x4e22ca81, 0, 0 }, /* #27 */
    { 0x3372d3, 0x337217, 0x2d067260, 0x2d06725f, 0, 0 }, /* #28 */
    { 0x3b4a97, 0x3b4283, 0xd30a7408, 0xd30a7407, 0, 0 }, /* #29 */
    { 0x297957, 0x297187, 0xd18891fd, 0xd18891fc, 0, 0 }, /* #30 */
    { 0x3b2dd6, 0x3b2506, 0x1c557956, 0x1c557955, 0, 0 }, /* #31 */
    { 0x113202, 0x113206, 0x0ede035b, 0x0ede035a, 0, 0 }, /* #32 */
    { 0x2d1187, 0x2d1183, 0xec032117, 0xec032116, 0, 0 }, /* #33 */
    { 0x340353, 0x340387, 0xd8de3ac6, 0xd8de3ac5, 0, 0 }, /* #34 */
    { 0x3d3416, 0x3d3482, 0xe0e1bb02, 0xe0e1bb01, 0, 0 }, /* #35 */
    { 0x047ec7, 0x047607, 0x1daf41e5, 0x1daf41e4, 0, 0 }, /* #36 */
    { 0x2b0003, 0x2b0083, 0xcf0daf2d, 0xcf0daf2c, 0, 0 }, /* #37 */
    { 0x282b13, 0x282307, 0x2ebe6907, 0x2ebe6906, 0, 0 }, /* #38 */
    { 0x200dd2, 0x200502, 0x7c5a238b, 0x7c5a238a, 0, 0 }, /* #39 */
    { 0x1b5f16, 0x1b5706, 0x265b197f, 0x265b197e, 0, 0 }, /* #40 */
    { 0x244106, 0x244182, 0xb6c7919c, 0xb6c7919b, 0, 0 }, /* #41 */
    { 0x333596, 0x333506, 0x7b988ff7, 0x7b988ff6, 0, 0 }, /* #42 */
    { 0x3f43c2, 0x3f4386, 0xca1c7ca7, 0xca1c7ca6, 0, 0 }, /* #43 */
    { 0x3d1c97, 0x3d1483, 0xfba8c46c, 0xfba8c46b, 0, 0 }, /* #44 */
    { 0x3f0ed6, 0x3f0686, 0xebbe400b, 0xebbe400a, 0, 0 }, /* #45 */
    { 0x0a0942, 0x0a0186, 0xfbe9223a, 0xfbe92239, 0, 0 }, /* #46 */
    { 0x097c56, 0x097402, 0x34d89ec9, 0x34d89ec8, 0, 0 }, /* #47 */
    { 0x127d87, 0x127507, 0x0c37f166, 0x0c37f165, 0, 0 }, /* #48 */
    { 0x303483, 0x303407, 0x42da8251, 0x42da8250, 0, 0 }, /* #49 */
    { 0x0f1097, 0x0f1083, 0x916e2586, 0x916e2585, 0, 0 }, /* #50 */
    { 0x3368d2, 0x336002, 0x371e5a71, 0x371e5a70, 0, 0 }, /* #51 */
    { 0x147297, 0x147283, 0xa62f9276, 0xa62f9275, 0, 0 }, /* #52 */
    { 0x266397, 0x266307, 0x1d7fbd07, 0x1d7fbd06, 0, 0 }, /* #53 */
    { 0x2149c7, 0x214107, 0x305fc1dc, 0x305fc1db, 0, 0 }, /* #54 */
    { 0x017592, 0x017506, 0x0597ccf4, 0x0597ccf3, 0, 0 }, /* #55 */
    { 0x1a4797, 0x1a4703, 0x4ef6fc0c, 0x4ef6fc0b, 0, 0 }, /* #56 */
    { 0x134dd6, 0x134506, 0x0b77ea25, 0x0b77ea24, 0, 0 }, /* #57 */
    { 0x117442, 0x117492, 0x97d5f590, 0x97d5f58f, 0, 0 }, /* #58 */
    { 0x2a4387, 0x2a4383, 0x95dbdd35, 0x95dbdd34, 0, 0 }, /* #59 */
    { 0x2c30d3, 0x2c3017, 0x00656970, 0x0065696f, 0, 0 }, /* #60 */
    { 0x0c5057, 0x0c5003, 0x6344048b, 0x6344048a, 0, 0 }, /* #61 */
    { 0x2441c2, 0x244186, 0xed6eb642, 0xed6eb641, 0, 0 }, /* #62 */
    { 0x176996, 0x176182, 0xf765aaba, 0xf765aab9, 0, 0 }, /* #63 */
    { 0x197b07, 0x197387, 0x9cf45efd, 0x9cf45efc, 0, 0 }, /* #64 */
    { 0x2a0a03, 0x2a0207, 0x56233cbc, 0x56233cbb, 0, 0 }, /* #65 */
    { 0x2a70d2, 0x2a7086, 0xce6cfe3b, 0xce6cfe3a, 0, 0 }, /* #66 */
    { 0x3761c2, 0x376182, 0xad8fe8f2, 0xad8fe8f1, 0, 0 }, /* #67 */
    { 0x2a4f53, 0x2a4783, 0xa38a9902, 0xa38a9901, 0, 0 }, /* #68 */
    { 0x3313d7, 0x331307, 0x4b4cb7a6, 0x4b4cb7a5, 0, 0 }, /* #69 */
    { 0x363e56, 0x363686, 0xd9804243, 0xd9804242, 0, 0 }, /* #70 */
    { 0x381113, 0x381187, 0xfbd9e66a, 0xfbd9e669, 0, 0 }, /* #71 */
    { 0x1a44c3, 0x1a4483, 0xc9b33d35, 0xc9b33d34, 0, 0 }, /* #72 */
    { 0x196016, 0x196006, 0x298ab5ca, 0x298ab5c9, 0, 0 }, /* #73 */
    { 0x0e0ad3, 0x0e0207, 0x2769bfe5, 0x2769bfe4, 0, 0 }, /* #74 */
    { 0x1b27d2, 0x1b2706, 0x100f6319, 0x100f6318, 0, 0 }, /* #75 */
    { 0x2745c2, 0x274506, 0x57f02e7e, 0x57f02e7d, 0, 0 }, /* #76 */
    { 0x267d46, 0x267506, 0x48508519, 0x48508518, 0, 0 }, /* #77 */
    { 0x1d6397, 0x1d6317, 0x0997c000, 0x0997bfff, 0, 0 }, /* #78 */
    { 0x232593, 0x232503, 0x5b077f3c, 0x5b077f3b, 0, 0 }, /* #79 */
    { 0x3f3dc2, 0x3f3586, 0x892d1449, 0x892d1448, 0, 0 }, /* #80 */
    { 0x0e4e46, 0x0e4602, 0x6391e326, 0x6391e325, 0, 0 }, /* #81 */
    { 0x240447, 0x240407, 0x279c8df7, 0x279c8df6, 0, 0 }, /* #82 */
    { 0x033003, 0x033087, 0xdbf82273, 0xdbf82272, 0, 0 }, /* #83 */
    { 0x057cd2, 0x057402, 0x0cd175db, 0x0cd175da, 0, 0 }, /* #84 */
    { 0x193a16, 0x193202, 0x099f5a3c, 0x099f5a3b, 0, 0 }, /* #85 */
    { 0x3c1896, 0x3c1082, 0xb351d365, 0xb351d364, 0, 0 }, /* #86 */
    { 0x3d45d7, 0x3d4587, 0xd0e1ed18, 0xd0e1ed17, 0, 0 }, /* #87 */
    { 0x155352, 0x155386, 0xc35b62b2, 0xc35b62b1, 0, 0 }, /* #88 */
    { 0x2e5102, 0x2e5182, 0xb186d117, 0xb186d116, 0, 0 }, /* #89 */
    { 0x0218c3, 0x021003, 0x77fe6744, 0x77fe6743, 0, 0 }, /* #90 */
    { 0x326d82, 0x326506, 0x71dfc461, 0x71dfc460, 0, 0 }, /* #91 */
    { 0x016916, 0x016106, 0x7c913445, 0x7c913444, 0, 0 }, /* #92 */
    { 0x280913, 0x280103, 0x1e553169, 0x1e553168, 0, 0 }, /* #93 */
    { 0x1e5ad6, 0x1e5202, 0x6a0e7dae, 0x6a0e7dad, 0, 0 }, /* #94 */
    { 0x112217, 0x112207, 0x2f1effa6, 0x2f1effa5, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_dec_u32 = RT_ELEMENTS(g_aTests_dec_u32);

BINU32_TEST_T const g_aTests_dec_u32_locked[] =
{
    { 0x3c3513, 0x3c3587, 0xead33b19, 0xead33b18, 0, 0 }, /* #0 */
    { 0x381343, 0x381303, 0x383f4fcc, 0x383f4fcb, 0, 0 }, /* #1 */
    { 0x3b5713, 0x3b5703, 0x32b4f57d, 0x32b4f57c, 0, 0 }, /* #2 */
    { 0x325816, 0x325086, 0x98652a22, 0x98652a21, 0, 0 }, /* #3 */
    { 0x364957, 0x364183, 0xe75b0c62, 0xe75b0c61, 0, 0 }, /* #4 */
    { 0x027393, 0x027303, 0x2263b402, 0x2263b401, 0, 0 }, /* #5 */
    { 0x351547, 0x351583, 0xd20ad58d, 0xd20ad58c, 0, 0 }, /* #6 */
    { 0x383242, 0x383286, 0xdfa10a15, 0xdfa10a14, 0, 0 }, /* #7 */
    { 0x007e06, 0x007606, 0x76e795a1, 0x76e795a0, 0, 0 }, /* #8 */
    { 0x1d0d43, 0x1d0503, 0x0b1f222b, 0x0b1f222a, 0, 0 }, /* #9 */
    { 0x2300d3, 0x230003, 0x43cf2469, 0x43cf2468, 0, 0 }, /* #10 */
    { 0x2f6616, 0x2f6616, 0x7e724c60, 0x7e724c5f, 0, 0 }, /* #11 */
    { 0x287217, 0x287203, 0x1d45b632, 0x1d45b631, 0, 0 }, /* #12 */
    { 0x243d07, 0x243503, 0x3a68f7fe, 0x3a68f7fd, 0, 0 }, /* #13 */
    { 0x2d1386, 0x2d1382, 0x90536703, 0x90536702, 0, 0 }, /* #14 */
    { 0x163147, 0x163183, 0xbb4e1052, 0xbb4e1051, 0, 0 }, /* #15 */
    { 0x201d57, 0x201587, 0xcdce6b23, 0xcdce6b22, 0, 0 }, /* #16 */
    { 0x163c56, 0x163482, 0xe2d07e55, 0xe2d07e54, 0, 0 }, /* #17 */
    { 0x190407, 0x190407, 0x11be080a, 0x11be0809, 0, 0 }, /* #18 */
    { 0x1b13c3, 0x1b1303, 0x6f4f31fc, 0x6f4f31fb, 0, 0 }, /* #19 */
    { 0x3b1ed7, 0x3b1603, 0x7ffc309c, 0x7ffc309b, 0, 0 }, /* #20 */
    { 0x3c2fd3, 0x3c2783, 0xfdca2bc3, 0xfdca2bc2, 0, 0 }, /* #21 */
    { 0x391dc6, 0x391506, 0x374b207c, 0x374b207b, 0, 0 }, /* #22 */
    { 0x1d3b96, 0x1d3386, 0xfb945382, 0xfb945381, 0, 0 }, /* #23 */
    { 0x2d5716, 0x2d5786, 0xab6c5c43, 0xab6c5c42, 0, 0 }, /* #24 */
    { 0x204486, 0x204486, 0xb132b082, 0xb132b081, 0, 0 }, /* #25 */
    { 0x2f6917, 0x2f6103, 0x154e5059, 0x154e5058, 0, 0 }, /* #26 */
    { 0x233e42, 0x233682, 0xbc2aaf68, 0xbc2aaf67, 0, 0 }, /* #27 */
    { 0x285813, 0x285007, 0x2181241c, 0x2181241b, 0, 0 }, /* #28 */
    { 0x1a5b02, 0x1a5382, 0xf7878c86, 0xf7878c85, 0, 0 }, /* #29 */
    { 0x3b7907, 0x3b7187, 0xb513d6c1, 0xb513d6c0, 0, 0 }, /* #30 */
    { 0x3f6882, 0x3f6086, 0xb79ede6d, 0xb79ede6c, 0, 0 }, /* #31 */
    { 0x033f96, 0x033706, 0x5c7bbac7, 0x5c7bbac6, 0, 0 }, /* #32 */
    { 0x3c01c3, 0x3c0187, 0xd2df9a2f, 0xd2df9a2e, 0, 0 }, /* #33 */
    { 0x2b38d7, 0x2b3003, 0x54d2b633, 0x54d2b632, 0, 0 }, /* #34 */
    { 0x1a5352, 0x1a5382, 0xdb11df17, 0xdb11df16, 0, 0 }, /* #35 */
    { 0x355f53, 0x355793, 0xdc0e9480, 0xdc0e947f, 0, 0 }, /* #36 */
    { 0x2d0902, 0x2d0196, 0xd38802d0, 0xd38802cf, 0, 0 }, /* #37 */
    { 0x351e47, 0x351683, 0x893e93cc, 0x893e93cb, 0, 0 }, /* #38 */
    { 0x0f4803, 0x0f4003, 0x7f940d8a, 0x7f940d89, 0, 0 }, /* #39 */
    { 0x1d2f46, 0x1d2706, 0x219d0ad2, 0x219d0ad1, 0, 0 }, /* #40 */
    { 0x342f13, 0x342783, 0x917cc7cc, 0x917cc7cb, 0, 0 }, /* #41 */
    { 0x3f0147, 0x3f0103, 0x475a0ccf, 0x475a0cce, 0, 0 }, /* #42 */
    { 0x051943, 0x051103, 0x01b5ba6c, 0x01b5ba6b, 0, 0 }, /* #43 */
    { 0x025346, 0x025302, 0x4d733b44, 0x4d733b43, 0, 0 }, /* #44 */
    { 0x297893, 0x297083, 0xa9358e1a, 0xa9358e19, 0, 0 }, /* #45 */
    { 0x286316, 0x286382, 0xe94a20e6, 0xe94a20e5, 0, 0 }, /* #46 */
    { 0x2452d2, 0x245202, 0x2967e603, 0x2967e602, 0, 0 }, /* #47 */
    { 0x275e02, 0x275602, 0x58e402f3, 0x58e402f2, 0, 0 }, /* #48 */
    { 0x183f13, 0x183783, 0x852b7a38, 0x852b7a37, 0, 0 }, /* #49 */
    { 0x347e86, 0x347682, 0xedcc0f55, 0xedcc0f54, 0, 0 }, /* #50 */
    { 0x0c3d83, 0x0c3587, 0xa0e98c12, 0xa0e98c11, 0, 0 }, /* #51 */
    { 0x0d4143, 0x0d4183, 0xbda17293, 0xbda17292, 0, 0 }, /* #52 */
    { 0x081786, 0x081706, 0x1a10e4bf, 0x1a10e4be, 0, 0 }, /* #53 */
    { 0x3171c2, 0x317186, 0xce820c13, 0xce820c12, 0, 0 }, /* #54 */
    { 0x245d86, 0x245586, 0xd97e7b54, 0xd97e7b53, 0, 0 }, /* #55 */
    { 0x395b97, 0x395387, 0xa53278b3, 0xa53278b2, 0, 0 }, /* #56 */
    { 0x2665c7, 0x266583, 0xaa79b417, 0xaa79b416, 0, 0 }, /* #57 */
    { 0x226052, 0x226006, 0x7ab51822, 0x7ab51821, 0, 0 }, /* #58 */
    { 0x3b4707, 0x3b4783, 0x9d2b2eb7, 0x9d2b2eb6, 0, 0 }, /* #59 */
    { 0x3056c3, 0x305693, 0x96edad50, 0x96edad4f, 0, 0 }, /* #60 */
    { 0x0c24c7, 0x0c2483, 0xe5610195, 0xe5610194, 0, 0 }, /* #61 */
    { 0x146bc2, 0x146392, 0xfaf677f0, 0xfaf677ef, 0, 0 }, /* #62 */
    { 0x1b4bc3, 0x1b4303, 0x63e06e0e, 0x63e06e0d, 0, 0 }, /* #63 */
    { 0x2d23d2, 0x2d2382, 0xc6a41977, 0xc6a41976, 0, 0 }, /* #64 */
    { 0x2e7203, 0x2e7297, 0x9ca7f4d0, 0x9ca7f4cf, 0, 0 }, /* #65 */
    { 0x113446, 0x113482, 0x8539ea16, 0x8539ea15, 0, 0 }, /* #66 */
    { 0x2e17c7, 0x2e1703, 0x3d6f32a8, 0x3d6f32a7, 0, 0 }, /* #67 */
    { 0x3a5b42, 0x3a5306, 0x3999fb22, 0x3999fb21, 0, 0 }, /* #68 */
    { 0x304346, 0x304386, 0xe0015c37, 0xe0015c36, 0, 0 }, /* #69 */
    { 0x0e1853, 0x0e1083, 0xdc5861c9, 0xdc5861c8, 0, 0 }, /* #70 */
    { 0x2414d6, 0x241402, 0x22cd5e92, 0x22cd5e91, 0, 0 }, /* #71 */
    { 0x2c42c2, 0x2c4206, 0x182dc925, 0x182dc924, 0, 0 }, /* #72 */
    { 0x012a06, 0x012282, 0xbfeea79e, 0xbfeea79d, 0, 0 }, /* #73 */
    { 0x0e17c3, 0x0e1703, 0x6e571c92, 0x6e571c91, 0, 0 }, /* #74 */
    { 0x1d1856, 0x1d1006, 0x63aed6e9, 0x63aed6e8, 0, 0 }, /* #75 */
    { 0x2650c7, 0x265087, 0xfaea7851, 0xfaea7850, 0, 0 }, /* #76 */
    { 0x3b3a13, 0x3b3203, 0x33a32e59, 0x33a32e58, 0, 0 }, /* #77 */
    { 0x042217, 0x042283, 0x8ed28a7b, 0x8ed28a7a, 0, 0 }, /* #78 */
    { 0x097207, 0x097207, 0x7d644c7c, 0x7d644c7b, 0, 0 }, /* #79 */
    { 0x0c3e02, 0x0c3686, 0x8df4095d, 0x8df4095c, 0, 0 }, /* #80 */
    { 0x302f46, 0x302706, 0x714e20dc, 0x714e20db, 0, 0 }, /* #81 */
    { 0x1f2503, 0x1f2503, 0x12b32b2a, 0x12b32b29, 0, 0 }, /* #82 */
    { 0x3d7dc3, 0x3d7503, 0x2d651e68, 0x2d651e67, 0, 0 }, /* #83 */
    { 0x0e0397, 0x0e0307, 0x749e3a9d, 0x749e3a9c, 0, 0 }, /* #84 */
    { 0x1374c6, 0x137402, 0x0470f639, 0x0470f638, 0, 0 }, /* #85 */
    { 0x1b7bc6, 0x1b7382, 0xedab16a3, 0xedab16a2, 0, 0 }, /* #86 */
    { 0x2b25d6, 0x2b2582, 0xb60c7968, 0xb60c7967, 0, 0 }, /* #87 */
    { 0x221912, 0x221106, 0x65498454, 0x65498453, 0, 0 }, /* #88 */
    { 0x0e0a13, 0x0e0287, 0x87ecbd5b, 0x87ecbd5a, 0, 0 }, /* #89 */
    { 0x0060d3, 0x006087, 0xf692e923, 0xf692e922, 0, 0 }, /* #90 */
    { 0x3910c3, 0x391087, 0xb36ce92e, 0xb36ce92d, 0, 0 }, /* #91 */
    { 0x2e7657, 0x2e7603, 0x53404f5e, 0x53404f5d, 0, 0 }, /* #92 */
    { 0x380287, 0x380283, 0xbc113921, 0xbc113920, 0, 0 }, /* #93 */
    { 0x2c6392, 0x2c6386, 0xb70e53ef, 0xb70e53ee, 0, 0 }, /* #94 */
    { 0x202593, 0x202587, 0xffeaa7a7, 0xffeaa7a6, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_dec_u32_locked = RT_ELEMENTS(g_aTests_dec_u32_locked);

BINU32_TEST_T const g_aTests_not_u32[] =
{
    { 0x3e1c96, 0x3e1c96, 0xf341ca73, 0x0cbe358c, 0, 0 }, /* #0 */
    { 0x1a5b13, 0x1a5b13, 0x486ec38a, 0xb7913c75, 0, 0 }, /* #1 */
    { 0x384043, 0x384043, 0x0b3a30e0, 0xf4c5cf1f, 0, 0 }, /* #2 */
    { 0x103c83, 0x103c83, 0x17db8fa9, 0xe8247056, 0, 0 }, /* #3 */
    { 0x091917, 0x091917, 0x29f375bc, 0xd60c8a43, 0, 0 }, /* #4 */
    { 0x075186, 0x075186, 0x9302e134, 0x6cfd1ecb, 0, 0 }, /* #5 */
    { 0x044d52, 0x044d52, 0xd78cb2bb, 0x28734d44, 0, 0 }, /* #6 */
    { 0x0f3647, 0x0f3647, 0xeab87305, 0x15478cfa, 0, 0 }, /* #7 */
    { 0x340b86, 0x340b86, 0x42c37596, 0xbd3c8a69, 0, 0 }, /* #8 */
    { 0x250046, 0x250046, 0x388fc31c, 0xc7703ce3, 0, 0 }, /* #9 */
    { 0x333fc7, 0x333fc7, 0xb25b492d, 0x4da4b6d2, 0, 0 }, /* #10 */
    { 0x307a46, 0x307a46, 0x21b2801b, 0xde4d7fe4, 0, 0 }, /* #11 */
    { 0x1d3383, 0x1d3383, 0x927117f2, 0x6d8ee80d, 0, 0 }, /* #12 */
    { 0x097147, 0x097147, 0x45a05d9a, 0xba5fa265, 0, 0 }, /* #13 */
    { 0x1a2992, 0x1a2992, 0x203b3ce3, 0xdfc4c31c, 0, 0 }, /* #14 */
    { 0x2c0607, 0x2c0607, 0xd232cc1b, 0x2dcd33e4, 0, 0 }, /* #15 */
    { 0x2b4a07, 0x2b4a07, 0x4e82a9a8, 0xb17d5657, 0, 0 }, /* #16 */
    { 0x314b53, 0x314b53, 0x8bd0a23a, 0x742f5dc5, 0, 0 }, /* #17 */
    { 0x2a2007, 0x2a2007, 0x248531dc, 0xdb7ace23, 0, 0 }, /* #18 */
    { 0x0b2e53, 0x0b2e53, 0x4c7dcd56, 0xb38232a9, 0, 0 }, /* #19 */
    { 0x3b1c46, 0x3b1c46, 0xe7d2de99, 0x182d2166, 0, 0 }, /* #20 */
    { 0x320902, 0x320902, 0x7624fbe4, 0x89db041b, 0, 0 }, /* #21 */
    { 0x3e3986, 0x3e3986, 0xa23c308a, 0x5dc3cf75, 0, 0 }, /* #22 */
    { 0x016446, 0x016446, 0x1a5b265e, 0xe5a4d9a1, 0, 0 }, /* #23 */
    { 0x026fc2, 0x026fc2, 0x818732fb, 0x7e78cd04, 0, 0 }, /* #24 */
    { 0x3d6e17, 0x3d6e17, 0x680a15c1, 0x97f5ea3e, 0, 0 }, /* #25 */
    { 0x220c86, 0x220c86, 0x4c945d95, 0xb36ba26a, 0, 0 }, /* #26 */
    { 0x2c2a02, 0x2c2a02, 0x12d33687, 0xed2cc978, 0, 0 }, /* #27 */
    { 0x274852, 0x274852, 0x842a889e, 0x7bd57761, 0, 0 }, /* #28 */
    { 0x157106, 0x157106, 0x4ae29ae1, 0xb51d651e, 0, 0 }, /* #29 */
    { 0x1225d6, 0x1225d6, 0x7d02efe0, 0x82fd101f, 0, 0 }, /* #30 */
    { 0x0f1bc7, 0x0f1bc7, 0x9b061f9a, 0x64f9e065, 0, 0 }, /* #31 */
    { 0x072116, 0x072116, 0xc6b7b775, 0x3948488a, 0, 0 }, /* #32 */
    { 0x292403, 0x292403, 0x4ac49a4c, 0xb53b65b3, 0, 0 }, /* #33 */
    { 0x222bc3, 0x222bc3, 0x8d982ce1, 0x7267d31e, 0, 0 }, /* #34 */
    { 0x343ec3, 0x343ec3, 0x83ce8343, 0x7c317cbc, 0, 0 }, /* #35 */
    { 0x323382, 0x323382, 0xc754719c, 0x38ab8e63, 0, 0 }, /* #36 */
    { 0x0a5bd3, 0x0a5bd3, 0xac92aa2d, 0x536d55d2, 0, 0 }, /* #37 */
    { 0x0b4f86, 0x0b4f86, 0x9f7aa26b, 0x60855d94, 0, 0 }, /* #38 */
    { 0x197f13, 0x197f13, 0xf85fe698, 0x07a01967, 0, 0 }, /* #39 */
    { 0x297297, 0x297297, 0xcbfe95b9, 0x34016a46, 0, 0 }, /* #40 */
    { 0x0451c2, 0x0451c2, 0xda99ea8a, 0x25661575, 0, 0 }, /* #41 */
    { 0x311ec6, 0x311ec6, 0xe35f2e18, 0x1ca0d1e7, 0, 0 }, /* #42 */
    { 0x1a7613, 0x1a7613, 0x5edcc650, 0xa12339af, 0, 0 }, /* #43 */
    { 0x202ad7, 0x202ad7, 0xb19bab9d, 0x4e645462, 0, 0 }, /* #44 */
    { 0x395003, 0x395003, 0xfbd3719a, 0x042c8e65, 0, 0 }, /* #45 */
    { 0x216597, 0x216597, 0x73e067df, 0x8c1f9820, 0, 0 }, /* #46 */
    { 0x2957d2, 0x2957d2, 0x50f084df, 0xaf0f7b20, 0, 0 }, /* #47 */
    { 0x136216, 0x136216, 0x777dcde9, 0x88823216, 0, 0 }, /* #48 */
    { 0x003e82, 0x003e82, 0xb2aadd04, 0x4d5522fb, 0, 0 }, /* #49 */
    { 0x163893, 0x163893, 0x56f32190, 0xa90cde6f, 0, 0 }, /* #50 */
    { 0x142f17, 0x142f17, 0x844b355c, 0x7bb4caa3, 0, 0 }, /* #51 */
    { 0x3c2f52, 0x3c2f52, 0x0ef7f0e4, 0xf1080f1b, 0, 0 }, /* #52 */
    { 0x0642d2, 0x0642d2, 0x47519b81, 0xb8ae647e, 0, 0 }, /* #53 */
    { 0x3b3506, 0x3b3506, 0xb1581547, 0x4ea7eab8, 0, 0 }, /* #54 */
    { 0x3b5f56, 0x3b5f56, 0x63757f9d, 0x9c8a8062, 0, 0 }, /* #55 */
    { 0x284ac2, 0x284ac2, 0xa71acf2d, 0x58e530d2, 0, 0 }, /* #56 */
    { 0x327102, 0x327102, 0xa3659f7e, 0x5c9a6081, 0, 0 }, /* #57 */
    { 0x256952, 0x256952, 0x834a5407, 0x7cb5abf8, 0, 0 }, /* #58 */
    { 0x025397, 0x025397, 0x1e3068d7, 0xe1cf9728, 0, 0 }, /* #59 */
    { 0x3f4e86, 0x3f4e86, 0x3ad3d9b9, 0xc52c2646, 0, 0 }, /* #60 */
    { 0x047e13, 0x047e13, 0x4afcd423, 0xb5032bdc, 0, 0 }, /* #61 */
    { 0x1b4892, 0x1b4892, 0x41dab4f4, 0xbe254b0b, 0, 0 }, /* #62 */
    { 0x2c7913, 0x2c7913, 0x07760a6e, 0xf889f591, 0, 0 }, /* #63 */
    { 0x0e2153, 0x0e2153, 0x11c0b1f3, 0xee3f4e0c, 0, 0 }, /* #64 */
    { 0x1e0642, 0x1e0642, 0xac4636a5, 0x53b9c95a, 0, 0 }, /* #65 */
    { 0x377a02, 0x377a02, 0xf7d0bb80, 0x082f447f, 0, 0 }, /* #66 */
    { 0x3a4053, 0x3a4053, 0x857dc523, 0x7a823adc, 0, 0 }, /* #67 */
    { 0x380816, 0x380816, 0x5d625aaa, 0xa29da555, 0, 0 }, /* #68 */
    { 0x131846, 0x131846, 0xd2340029, 0x2dcbffd6, 0, 0 }, /* #69 */
    { 0x3e2917, 0x3e2917, 0xa12047ad, 0x5edfb852, 0, 0 }, /* #70 */
    { 0x120ec2, 0x120ec2, 0x23781828, 0xdc87e7d7, 0, 0 }, /* #71 */
    { 0x252502, 0x252502, 0x9eb68a25, 0x614975da, 0, 0 }, /* #72 */
    { 0x0613d7, 0x0613d7, 0x2ccb8f4c, 0xd33470b3, 0, 0 }, /* #73 */
    { 0x2b1213, 0x2b1213, 0x3b337dca, 0xc4cc8235, 0, 0 }, /* #74 */
    { 0x1414c6, 0x1414c6, 0xc2f21552, 0x3d0deaad, 0, 0 }, /* #75 */
    { 0x327c87, 0x327c87, 0x8e7ddffd, 0x71822002, 0, 0 }, /* #76 */
    { 0x222cd3, 0x222cd3, 0x429398b3, 0xbd6c674c, 0, 0 }, /* #77 */
    { 0x0d1c86, 0x0d1c86, 0x1028167b, 0xefd7e984, 0, 0 }, /* #78 */
    { 0x041852, 0x041852, 0x3356745f, 0xcca98ba0, 0, 0 }, /* #79 */
    { 0x1d44c3, 0x1d44c3, 0x57eb5c4c, 0xa814a3b3, 0, 0 }, /* #80 */
    { 0x1d7246, 0x1d7246, 0x4d7f55e2, 0xb280aa1d, 0, 0 }, /* #81 */
    { 0x385346, 0x385346, 0xa20df990, 0x5df2066f, 0, 0 }, /* #82 */
    { 0x254f13, 0x254f13, 0xc2d1eb1c, 0x3d2e14e3, 0, 0 }, /* #83 */
    { 0x3d0587, 0x3d0587, 0x4a24ffd5, 0xb5db002a, 0, 0 }, /* #84 */
    { 0x160513, 0x160513, 0x4f8c96c2, 0xb073693d, 0, 0 }, /* #85 */
    { 0x1530c6, 0x1530c6, 0x031b008f, 0xfce4ff70, 0, 0 }, /* #86 */
    { 0x2d3fd3, 0x2d3fd3, 0xe1b2987d, 0x1e4d6782, 0, 0 }, /* #87 */
    { 0x3831d3, 0x3831d3, 0xd2ae8d40, 0x2d5172bf, 0, 0 }, /* #88 */
    { 0x307892, 0x307892, 0xf869aaf4, 0x0796550b, 0, 0 }, /* #89 */
    { 0x207e92, 0x207e92, 0xab59f7f9, 0x54a60806, 0, 0 }, /* #90 */
    { 0x1a3c82, 0x1a3c82, 0xaf4f1b1f, 0x50b0e4e0, 0, 0 }, /* #91 */
    { 0x2b5a06, 0x2b5a06, 0xd18bd97f, 0x2e742680, 0, 0 }, /* #92 */
    { 0x215406, 0x215406, 0x1fd29094, 0xe02d6f6b, 0, 0 }, /* #93 */
    { 0x097457, 0x097457, 0x2ce2589a, 0xd31da765, 0, 0 }, /* #94 */
    { 0x306313, 0x306313, 0x146f5a5d, 0xeb90a5a2, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_not_u32 = RT_ELEMENTS(g_aTests_not_u32);

BINU32_TEST_T const g_aTests_not_u32_locked[] =
{
    { 0x241f57, 0x241f57, 0x079a8837, 0xf86577c8, 0, 0 }, /* #0 */
    { 0x211453, 0x211453, 0x77050720, 0x88faf8df, 0, 0 }, /* #1 */
    { 0x115112, 0x115112, 0xedf3d252, 0x120c2dad, 0, 0 }, /* #2 */
    { 0x135d93, 0x135d93, 0x042e4d25, 0xfbd1b2da, 0, 0 }, /* #3 */
    { 0x3a0152, 0x3a0152, 0xf2b1152f, 0x0d4eead0, 0, 0 }, /* #4 */
    { 0x2e2a46, 0x2e2a46, 0xf58fdd09, 0x0a7022f6, 0, 0 }, /* #5 */
    { 0x394a96, 0x394a96, 0x2ff50897, 0xd00af768, 0, 0 }, /* #6 */
    { 0x375e96, 0x375e96, 0x7c4c74bb, 0x83b38b44, 0, 0 }, /* #7 */
    { 0x271402, 0x271402, 0xf3dd18d5, 0x0c22e72a, 0, 0 }, /* #8 */
    { 0x273116, 0x273116, 0x05ff567d, 0xfa00a982, 0, 0 }, /* #9 */
    { 0x140a47, 0x140a47, 0x9945953c, 0x66ba6ac3, 0, 0 }, /* #10 */
    { 0x3c3e97, 0x3c3e97, 0x18839f49, 0xe77c60b6, 0, 0 }, /* #11 */
    { 0x1067d3, 0x1067d3, 0xc41c2932, 0x3be3d6cd, 0, 0 }, /* #12 */
    { 0x396982, 0x396982, 0x938d054a, 0x6c72fab5, 0, 0 }, /* #13 */
    { 0x090482, 0x090482, 0x5c3c09f9, 0xa3c3f606, 0, 0 }, /* #14 */
    { 0x3f1612, 0x3f1612, 0x2ec064d4, 0xd13f9b2b, 0, 0 }, /* #15 */
    { 0x2b5986, 0x2b5986, 0xc57b366a, 0x3a84c995, 0, 0 }, /* #16 */
    { 0x056687, 0x056687, 0x40fd0654, 0xbf02f9ab, 0, 0 }, /* #17 */
    { 0x077b17, 0x077b17, 0x11e4ec15, 0xee1b13ea, 0, 0 }, /* #18 */
    { 0x2364c7, 0x2364c7, 0x0c005f64, 0xf3ffa09b, 0, 0 }, /* #19 */
    { 0x2e49c6, 0x2e49c6, 0xa72cd003, 0x58d32ffc, 0, 0 }, /* #20 */
    { 0x224342, 0x224342, 0x8fbdd42b, 0x70422bd4, 0, 0 }, /* #21 */
    { 0x133d17, 0x133d17, 0x5c998ffd, 0xa3667002, 0, 0 }, /* #22 */
    { 0x0f5412, 0x0f5412, 0xf4de7807, 0x0b2187f8, 0, 0 }, /* #23 */
    { 0x1d3287, 0x1d3287, 0xf29832e0, 0x0d67cd1f, 0, 0 }, /* #24 */
    { 0x075f56, 0x075f56, 0x13fcbc1a, 0xec0343e5, 0, 0 }, /* #25 */
    { 0x0d43d2, 0x0d43d2, 0xbfd990d8, 0x40266f27, 0, 0 }, /* #26 */
    { 0x005246, 0x005246, 0xd0cec40f, 0x2f313bf0, 0, 0 }, /* #27 */
    { 0x1f6682, 0x1f6682, 0x53a1aa51, 0xac5e55ae, 0, 0 }, /* #28 */
    { 0x0c5d57, 0x0c5d57, 0x381e260b, 0xc7e1d9f4, 0, 0 }, /* #29 */
    { 0x255606, 0x255606, 0x255d6993, 0xdaa2966c, 0, 0 }, /* #30 */
    { 0x1b0d16, 0x1b0d16, 0x0a0f03da, 0xf5f0fc25, 0, 0 }, /* #31 */
    { 0x3a6bc3, 0x3a6bc3, 0xe2f17abc, 0x1d0e8543, 0, 0 }, /* #32 */
    { 0x124286, 0x124286, 0xe497f8c3, 0x1b68073c, 0, 0 }, /* #33 */
    { 0x197983, 0x197983, 0x0ba41114, 0xf45beeeb, 0, 0 }, /* #34 */
    { 0x0b6ec3, 0x0b6ec3, 0x950d600c, 0x6af29ff3, 0, 0 }, /* #35 */
    { 0x380506, 0x380506, 0xfb35994b, 0x04ca66b4, 0, 0 }, /* #36 */
    { 0x3c3bd3, 0x3c3bd3, 0xe2d5a74d, 0x1d2a58b2, 0, 0 }, /* #37 */
    { 0x3c1497, 0x3c1497, 0x34b0636d, 0xcb4f9c92, 0, 0 }, /* #38 */
    { 0x143546, 0x143546, 0x811bffb2, 0x7ee4004d, 0, 0 }, /* #39 */
    { 0x202c42, 0x202c42, 0xb81af40c, 0x47e50bf3, 0, 0 }, /* #40 */
    { 0x2222d3, 0x2222d3, 0xac0b2658, 0x53f4d9a7, 0, 0 }, /* #41 */
    { 0x3203c3, 0x3203c3, 0xac3e5899, 0x53c1a766, 0, 0 }, /* #42 */
    { 0x0d01d6, 0x0d01d6, 0xcf968d56, 0x306972a9, 0, 0 }, /* #43 */
    { 0x2e6756, 0x2e6756, 0xd469d890, 0x2b96276f, 0, 0 }, /* #44 */
    { 0x236717, 0x236717, 0x56c099cc, 0xa93f6633, 0, 0 }, /* #45 */
    { 0x146b47, 0x146b47, 0xf9d05d96, 0x062fa269, 0, 0 }, /* #46 */
    { 0x315d06, 0x315d06, 0x56c54950, 0xa93ab6af, 0, 0 }, /* #47 */
    { 0x370356, 0x370356, 0x8cd78464, 0x73287b9b, 0, 0 }, /* #48 */
    { 0x366a92, 0x366a92, 0x5a86bff8, 0xa5794007, 0, 0 }, /* #49 */
    { 0x381647, 0x381647, 0x4bc05ede, 0xb43fa121, 0, 0 }, /* #50 */
    { 0x302903, 0x302903, 0xfcd86774, 0x0327988b, 0, 0 }, /* #51 */
    { 0x103343, 0x103343, 0x6bc823ca, 0x9437dc35, 0, 0 }, /* #52 */
    { 0x0f2606, 0x0f2606, 0xbc527123, 0x43ad8edc, 0, 0 }, /* #53 */
    { 0x190206, 0x190206, 0xef0295b3, 0x10fd6a4c, 0, 0 }, /* #54 */
    { 0x035983, 0x035983, 0x638c19f5, 0x9c73e60a, 0, 0 }, /* #55 */
    { 0x133ed3, 0x133ed3, 0x8bb24e4f, 0x744db1b0, 0, 0 }, /* #56 */
    { 0x326056, 0x326056, 0x3d1f87e1, 0xc2e0781e, 0, 0 }, /* #57 */
    { 0x096247, 0x096247, 0xad0a0c63, 0x52f5f39c, 0, 0 }, /* #58 */
    { 0x0f0a53, 0x0f0a53, 0x20707481, 0xdf8f8b7e, 0, 0 }, /* #59 */
    { 0x351e86, 0x351e86, 0xd1072dd6, 0x2ef8d229, 0, 0 }, /* #60 */
    { 0x3c02c6, 0x3c02c6, 0xcb01970c, 0x34fe68f3, 0, 0 }, /* #61 */
    { 0x227f07, 0x227f07, 0x4b58cb34, 0xb4a734cb, 0, 0 }, /* #62 */
    { 0x3a7543, 0x3a7543, 0xf8aa0254, 0x0755fdab, 0, 0 }, /* #63 */
    { 0x2b74d6, 0x2b74d6, 0x46299169, 0xb9d66e96, 0, 0 }, /* #64 */
    { 0x3661d3, 0x3661d3, 0x1760093f, 0xe89ff6c0, 0, 0 }, /* #65 */
    { 0x3e6316, 0x3e6316, 0x963f373e, 0x69c0c8c1, 0, 0 }, /* #66 */
    { 0x3704c6, 0x3704c6, 0x06a92cde, 0xf956d321, 0, 0 }, /* #67 */
    { 0x3d6c97, 0x3d6c97, 0x3c8d9289, 0xc3726d76, 0, 0 }, /* #68 */
    { 0x053c92, 0x053c92, 0xdae53b6f, 0x251ac490, 0, 0 }, /* #69 */
    { 0x201316, 0x201316, 0xc760a206, 0x389f5df9, 0, 0 }, /* #70 */
    { 0x122a82, 0x122a82, 0xc79aad8f, 0x38655270, 0, 0 }, /* #71 */
    { 0x0052c3, 0x0052c3, 0x3545242f, 0xcabadbd0, 0, 0 }, /* #72 */
    { 0x004296, 0x004296, 0x123ea730, 0xedc158cf, 0, 0 }, /* #73 */
    { 0x3e7f16, 0x3e7f16, 0x4ca823db, 0xb357dc24, 0, 0 }, /* #74 */
    { 0x336fd2, 0x336fd2, 0x62a03a9e, 0x9d5fc561, 0, 0 }, /* #75 */
    { 0x0220d2, 0x0220d2, 0xecf1c2b3, 0x130e3d4c, 0, 0 }, /* #76 */
    { 0x1a5742, 0x1a5742, 0x5e35eedb, 0xa1ca1124, 0, 0 }, /* #77 */
    { 0x242517, 0x242517, 0xdc07af01, 0x23f850fe, 0, 0 }, /* #78 */
    { 0x3d1447, 0x3d1447, 0x7538d857, 0x8ac727a8, 0, 0 }, /* #79 */
    { 0x0c53d3, 0x0c53d3, 0xb3ac0835, 0x4c53f7ca, 0, 0 }, /* #80 */
    { 0x0b0083, 0x0b0083, 0xd047b4b5, 0x2fb84b4a, 0, 0 }, /* #81 */
    { 0x085552, 0x085552, 0xfea131fd, 0x015ece02, 0, 0 }, /* #82 */
    { 0x2b4cd6, 0x2b4cd6, 0x35c1acf4, 0xca3e530b, 0, 0 }, /* #83 */
    { 0x163416, 0x163416, 0xdec95c82, 0x2136a37d, 0, 0 }, /* #84 */
    { 0x274797, 0x274797, 0x4f51d504, 0xb0ae2afb, 0, 0 }, /* #85 */
    { 0x335487, 0x335487, 0x0c9e8968, 0xf3617697, 0, 0 }, /* #86 */
    { 0x0463d3, 0x0463d3, 0x54dff964, 0xab20069b, 0, 0 }, /* #87 */
    { 0x3f3f96, 0x3f3f96, 0x0f370e07, 0xf0c8f1f8, 0, 0 }, /* #88 */
    { 0x0d2bc2, 0x0d2bc2, 0xba3e48d5, 0x45c1b72a, 0, 0 }, /* #89 */
    { 0x375502, 0x375502, 0x614090c7, 0x9ebf6f38, 0, 0 }, /* #90 */
    { 0x173ac3, 0x173ac3, 0xa1c003ce, 0x5e3ffc31, 0, 0 }, /* #91 */
    { 0x234bd3, 0x234bd3, 0x5ea7d8ca, 0xa1582735, 0, 0 }, /* #92 */
    { 0x0d4642, 0x0d4642, 0x5dd3a5a4, 0xa22c5a5b, 0, 0 }, /* #93 */
    { 0x185f03, 0x185f03, 0x7dedc952, 0x821236ad, 0, 0 }, /* #94 */
    { 0x1b2807, 0x1b2807, 0xbd4df639, 0x42b209c6, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_not_u32_locked = RT_ELEMENTS(g_aTests_not_u32_locked);

BINU32_TEST_T const g_aTests_neg_u32[] =
{
    { 0x082ac6, 0x082297, 0x39aac819, 0xc65537e7, 0, 0 }, /* #0 */
    { 0x105b43, 0x105393, 0x7fb6f521, 0x80490adf, 0, 0 }, /* #1 */
    { 0x032296, 0x032217, 0xf980096d, 0x067ff693, 0, 0 }, /* #2 */
    { 0x0d7c53, 0x0d7413, 0xe13ead52, 0x1ec152ae, 0, 0 }, /* #3 */
    { 0x2567c3, 0x256793, 0x56666058, 0xa9999fa8, 0, 0 }, /* #4 */
    { 0x335a96, 0x335293, 0x209005c2, 0xdf6ffa3e, 0, 0 }, /* #5 */
    { 0x274dd2, 0x274593, 0x14a5e258, 0xeb5a1da8, 0, 0 }, /* #6 */
    { 0x155c82, 0x155417, 0xc309e507, 0x3cf61af9, 0, 0 }, /* #7 */
    { 0x3c4d87, 0x3c4593, 0x5664770c, 0xa99b88f4, 0, 0 }, /* #8 */
    { 0x1c5a13, 0x1c5297, 0x57745337, 0xa88bacc9, 0, 0 }, /* #9 */
    { 0x016212, 0x016297, 0x35a50c4f, 0xca5af3b1, 0, 0 }, /* #10 */
    { 0x116002, 0x116097, 0x1dc6f86b, 0xe2390795, 0, 0 }, /* #11 */
    { 0x186697, 0x186693, 0x39238165, 0xc6dc7e9b, 0, 0 }, /* #12 */
    { 0x364302, 0x364317, 0x8ac529be, 0x753ad642, 0, 0 }, /* #13 */
    { 0x2d4b07, 0x2d4397, 0x40c7d767, 0xbf382899, 0, 0 }, /* #14 */
    { 0x3b7306, 0x3b7313, 0xab96d23f, 0x54692dc1, 0, 0 }, /* #15 */
    { 0x0b3b42, 0x0b3397, 0x08c11bc1, 0xf73ee43f, 0, 0 }, /* #16 */
    { 0x2544c2, 0x254493, 0x73b32287, 0x8c4cdd79, 0, 0 }, /* #17 */
    { 0x1a6812, 0x1a6013, 0xd1c546f5, 0x2e3ab90b, 0, 0 }, /* #18 */
    { 0x0b2ac7, 0x0b2213, 0xb2c929f5, 0x4d36d60b, 0, 0 }, /* #19 */
    { 0x1415d2, 0x141517, 0x9abdc4d8, 0x65423b28, 0, 0 }, /* #20 */
    { 0x054386, 0x054393, 0x0bd049cc, 0xf42fb634, 0, 0 }, /* #21 */
    { 0x131e82, 0x131693, 0x47f516d4, 0xb80ae92c, 0, 0 }, /* #22 */
    { 0x275e42, 0x275693, 0x5797ccc8, 0xa8683338, 0, 0 }, /* #23 */
    { 0x255303, 0x255397, 0x4e0505c6, 0xb1fafa3a, 0, 0 }, /* #24 */
    { 0x357f53, 0x357793, 0x533291d7, 0xaccd6e29, 0, 0 }, /* #25 */
    { 0x3561c7, 0x356113, 0xc53b0668, 0x3ac4f998, 0, 0 }, /* #26 */
    { 0x191a93, 0x191213, 0xef19dda5, 0x10e6225b, 0, 0 }, /* #27 */
    { 0x3a3e13, 0x3a3617, 0xe6064ccb, 0x19f9b335, 0, 0 }, /* #28 */
    { 0x2c13d2, 0x2c1317, 0xb3c369b5, 0x4c3c964b, 0, 0 }, /* #29 */
    { 0x1f1f93, 0x1f1717, 0x98936537, 0x676c9ac9, 0, 0 }, /* #30 */
    { 0x214ed7, 0x214613, 0xc7f7ed32, 0x380812ce, 0, 0 }, /* #31 */
    { 0x3b5e83, 0x3b5697, 0x22d87dcd, 0xdd278233, 0, 0 }, /* #32 */
    { 0x1e7853, 0x1e7017, 0x995c16cb, 0x66a3e935, 0, 0 }, /* #33 */
    { 0x156a43, 0x156297, 0x054a0894, 0xfab5f76c, 0, 0 }, /* #34 */
    { 0x1c4116, 0x1c4193, 0x4a032d5c, 0xb5fcd2a4, 0, 0 }, /* #35 */
    { 0x0a6057, 0x0a6013, 0xab4ed46e, 0x54b12b92, 0, 0 }, /* #36 */
    { 0x200383, 0x200393, 0x0aeb4a44, 0xf514b5bc, 0, 0 }, /* #37 */
    { 0x1e3056, 0x1e3013, 0xc08ce908, 0x3f7316f8, 0, 0 }, /* #38 */
    { 0x0714d2, 0x071417, 0xb4d9355a, 0x4b26caa6, 0, 0 }, /* #39 */
    { 0x043c87, 0x043417, 0xb486929d, 0x4b796d63, 0, 0 }, /* #40 */
    { 0x303f82, 0x303793, 0x6d1ee581, 0x92e11a7f, 0, 0 }, /* #41 */
    { 0x2141d6, 0x214193, 0x59c3e627, 0xa63c19d9, 0, 0 }, /* #42 */
    { 0x235242, 0x235213, 0xc49045fe, 0x3b6fba02, 0, 0 }, /* #43 */
    { 0x040117, 0x040193, 0x65e01a58, 0x9a1fe5a8, 0, 0 }, /* #44 */
    { 0x351ad7, 0x351217, 0x98e1466b, 0x671eb995, 0, 0 }, /* #45 */
    { 0x0625d3, 0x062517, 0xdba5b58f, 0x245a4a71, 0, 0 }, /* #46 */
    { 0x0856d7, 0x085693, 0x798f5055, 0x8670afab, 0, 0 }, /* #47 */
    { 0x150807, 0x150013, 0xe1177af8, 0x1ee88508, 0, 0 }, /* #48 */
    { 0x0631c6, 0x063193, 0x5ce3f758, 0xa31c08a8, 0, 0 }, /* #49 */
    { 0x224743, 0x224717, 0xe7b72e2e, 0x1848d1d2, 0, 0 }, /* #50 */
    { 0x204b46, 0x204383, 0x3ea4b790, 0xc15b4870, 0, 0 }, /* #51 */
    { 0x1d32c2, 0x1d3213, 0xfd708fd1, 0x028f702f, 0, 0 }, /* #52 */
    { 0x1d1f42, 0x1d1793, 0x3a58fc05, 0xc5a703fb, 0, 0 }, /* #53 */
    { 0x326717, 0x326797, 0x53e07fc1, 0xac1f803f, 0, 0 }, /* #54 */
    { 0x305813, 0x305013, 0xb009478a, 0x4ff6b876, 0, 0 }, /* #55 */
    { 0x2b0dc3, 0x2b0593, 0x4abd61ed, 0xb5429e13, 0, 0 }, /* #56 */
    { 0x2d5093, 0x2d5093, 0x1bf70ca3, 0xe408f35d, 0, 0 }, /* #57 */
    { 0x344907, 0x344193, 0x1298ceb1, 0xed67314f, 0, 0 }, /* #58 */
    { 0x235716, 0x235793, 0x537e2b0e, 0xac81d4f2, 0, 0 }, /* #59 */
    { 0x326d56, 0x326597, 0x304c9951, 0xcfb366af, 0, 0 }, /* #60 */
    { 0x1b2716, 0x1b2713, 0x9e50cff2, 0x61af300e, 0, 0 }, /* #61 */
    { 0x1a7152, 0x1a7193, 0x1aae9a99, 0xe5516567, 0, 0 }, /* #62 */
    { 0x2a7943, 0x2a7197, 0x63145efa, 0x9ceba106, 0, 0 }, /* #63 */
    { 0x226153, 0x226193, 0x57a3b2c3, 0xa85c4d3d, 0, 0 }, /* #64 */
    { 0x335ad7, 0x335297, 0x4611de57, 0xb9ee21a9, 0, 0 }, /* #65 */
    { 0x124b47, 0x124397, 0x6f334ce8, 0x90ccb318, 0, 0 }, /* #66 */
    { 0x3151d2, 0x315113, 0xc440f4c8, 0x3bbf0b38, 0, 0 }, /* #67 */
    { 0x323056, 0x323017, 0xa8e94edf, 0x5716b121, 0, 0 }, /* #68 */
    { 0x166357, 0x166397, 0x352c2636, 0xcad3d9ca, 0, 0 }, /* #69 */
    { 0x1c2d52, 0x1c2513, 0x8948ca95, 0x76b7356b, 0, 0 }, /* #70 */
    { 0x3750d3, 0x375017, 0xaf6dc736, 0x509238ca, 0, 0 }, /* #71 */
    { 0x1d0bc2, 0x1d0393, 0x24fed711, 0xdb0128ef, 0, 0 }, /* #72 */
    { 0x005313, 0x005397, 0x62e1409b, 0x9d1ebf65, 0, 0 }, /* #73 */
    { 0x110192, 0x110113, 0xf98ecc05, 0x067133fb, 0, 0 }, /* #74 */
    { 0x194883, 0x194017, 0xc7c38736, 0x383c78ca, 0, 0 }, /* #75 */
    { 0x274a97, 0x274293, 0x5275ce6c, 0xad8a3194, 0, 0 }, /* #76 */
    { 0x202357, 0x202393, 0x158b06dd, 0xea74f923, 0, 0 }, /* #77 */
    { 0x1f13d7, 0x1f1393, 0x70d647b7, 0x8f29b849, 0, 0 }, /* #78 */
    { 0x0b3e46, 0x0b3683, 0x46ac6680, 0xb9539980, 0, 0 }, /* #79 */
    { 0x3d3446, 0x3d3417, 0x9648dd7e, 0x69b72282, 0, 0 }, /* #80 */
    { 0x155003, 0x155017, 0x97a7b367, 0x68584c99, 0, 0 }, /* #81 */
    { 0x376ac3, 0x376213, 0xe09095c5, 0x1f6f6a3b, 0, 0 }, /* #82 */
    { 0x3a2b16, 0x3a2317, 0xf7e86983, 0x0817967d, 0, 0 }, /* #83 */
    { 0x0f5f83, 0x0f5713, 0xfba584c9, 0x045a7b37, 0, 0 }, /* #84 */
    { 0x263256, 0x263203, 0xcbe989c0, 0x34167640, 0, 0 }, /* #85 */
    { 0x1515c6, 0x151513, 0xbfcf424d, 0x4030bdb3, 0, 0 }, /* #86 */
    { 0x3a3453, 0x3a3493, 0x7377fbf5, 0x8c88040b, 0, 0 }, /* #87 */
    { 0x190817, 0x190097, 0x464cf022, 0xb9b30fde, 0, 0 }, /* #88 */
    { 0x2b1683, 0x2b1613, 0x84a437bb, 0x7b5bc845, 0, 0 }, /* #89 */
    { 0x116243, 0x116217, 0xe4b34b37, 0x1b4cb4c9, 0, 0 }, /* #90 */
    { 0x2e1dc3, 0x2e1513, 0xe65f1355, 0x19a0ecab, 0, 0 }, /* #91 */
    { 0x136b92, 0x136393, 0x3e6c227b, 0xc193dd85, 0, 0 }, /* #92 */
    { 0x054307, 0x054393, 0x47b769a2, 0xb848965e, 0, 0 }, /* #93 */
    { 0x351596, 0x351597, 0x620db67c, 0x9df24984, 0, 0 }, /* #94 */
    { 0x0e4f17, 0x0e4717, 0xde32a35a, 0x21cd5ca6, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_neg_u32 = RT_ELEMENTS(g_aTests_neg_u32);

BINU32_TEST_T const g_aTests_neg_u32_locked[] =
{
    { 0x1c5d87, 0x1c5513, 0xa0d552a5, 0x5f2aad5b, 0, 0 }, /* #0 */
    { 0x073906, 0x073113, 0xb747cff9, 0x48b83007, 0, 0 }, /* #1 */
    { 0x3d4bd2, 0x3d4397, 0x6409d75a, 0x9bf628a6, 0, 0 }, /* #2 */
    { 0x335a53, 0x335293, 0x4f0264f3, 0xb0fd9b0d, 0, 0 }, /* #3 */
    { 0x160712, 0x160717, 0xdfb4a89b, 0x204b5765, 0, 0 }, /* #4 */
    { 0x107382, 0x107317, 0xca82eb43, 0x357d14bd, 0, 0 }, /* #5 */
    { 0x014653, 0x014697, 0x7017afaa, 0x8fe85056, 0, 0 }, /* #6 */
    { 0x1c4196, 0x1c4197, 0x3a5c5767, 0xc5a3a899, 0, 0 }, /* #7 */
    { 0x397dd6, 0x397597, 0x31da5e31, 0xce25a1cf, 0, 0 }, /* #8 */
    { 0x074412, 0x074497, 0x14cc2b1c, 0xeb33d4e4, 0, 0 }, /* #9 */
    { 0x284242, 0x284293, 0x2c84325e, 0xd37bcda2, 0, 0 }, /* #10 */
    { 0x381a57, 0x381207, 0xd91bb1a0, 0x26e44e60, 0, 0 }, /* #11 */
    { 0x321b82, 0x321313, 0xb78bd671, 0x4874298f, 0, 0 }, /* #12 */
    { 0x103247, 0x103217, 0x835678e8, 0x7ca98718, 0, 0 }, /* #13 */
    { 0x134047, 0x134093, 0x79447952, 0x86bb86ae, 0, 0 }, /* #14 */
    { 0x193f87, 0x193707, 0xb83bd8d0, 0x47c42730, 0, 0 }, /* #15 */
    { 0x1a0c06, 0x1a0413, 0xd09d2eeb, 0x2f62d115, 0, 0 }, /* #16 */
    { 0x106443, 0x106407, 0x8f2851a0, 0x70d7ae60, 0, 0 }, /* #17 */
    { 0x312b53, 0x312393, 0x4b53611d, 0xb4ac9ee3, 0, 0 }, /* #18 */
    { 0x045617, 0x045693, 0x7d3345ba, 0x82ccba46, 0, 0 }, /* #19 */
    { 0x3d6247, 0x3d6293, 0x14f586e7, 0xeb0a7919, 0, 0 }, /* #20 */
    { 0x174d96, 0x174593, 0x7b3628f2, 0x84c9d70e, 0, 0 }, /* #21 */
    { 0x312216, 0x312283, 0x089c0230, 0xf763fdd0, 0, 0 }, /* #22 */
    { 0x014203, 0x014293, 0x7365e04a, 0x8c9a1fb6, 0, 0 }, /* #23 */
    { 0x0d6d06, 0x0d6517, 0xea7a98d3, 0x1585672d, 0, 0 }, /* #24 */
    { 0x051b07, 0x051397, 0x28d0e8c1, 0xd72f173f, 0, 0 }, /* #25 */
    { 0x3d7dc7, 0x3d7597, 0x7b9c9c2c, 0x846363d4, 0, 0 }, /* #26 */
    { 0x2c6357, 0x2c6313, 0xec38251b, 0x13c7dae5, 0, 0 }, /* #27 */
    { 0x3b6b96, 0x3b6397, 0x495f87b3, 0xb6a0784d, 0, 0 }, /* #28 */
    { 0x1808d7, 0x180013, 0xc1b5c7af, 0x3e4a3851, 0, 0 }, /* #29 */
    { 0x2b6d97, 0x2b6597, 0x5a58d56d, 0xa5a72a93, 0, 0 }, /* #30 */
    { 0x3e5653, 0x3e5617, 0xbe2cce34, 0x41d331cc, 0, 0 }, /* #31 */
    { 0x0e5ac2, 0x0e5213, 0xc7876771, 0x3878988f, 0, 0 }, /* #32 */
    { 0x0e4a47, 0x0e4293, 0x11cfe53f, 0xee301ac1, 0, 0 }, /* #33 */
    { 0x3e48c3, 0x3e4087, 0x75504a40, 0x8aafb5c0, 0, 0 }, /* #34 */
    { 0x066612, 0x066697, 0x4180a6e8, 0xbe7f5918, 0, 0 }, /* #35 */
    { 0x0d2d83, 0x0d2517, 0xe5a943d2, 0x1a56bc2e, 0, 0 }, /* #36 */
    { 0x3270d7, 0x327013, 0x82e0ad2a, 0x7d1f52d6, 0, 0 }, /* #37 */
    { 0x2e3b42, 0x2e3393, 0x4aafa595, 0xb5505a6b, 0, 0 }, /* #38 */
    { 0x3b5297, 0x3b5283, 0x41156330, 0xbeea9cd0, 0, 0 }, /* #39 */
    { 0x112196, 0x112193, 0x0cfd3233, 0xf302cdcd, 0, 0 }, /* #40 */
    { 0x245706, 0x245717, 0xa75f29a4, 0x58a0d65c, 0, 0 }, /* #41 */
    { 0x3d4107, 0x3d4193, 0x7a2244d4, 0x85ddbb2c, 0, 0 }, /* #42 */
    { 0x371987, 0x371113, 0x9a113c5e, 0x65eec3a2, 0, 0 }, /* #43 */
    { 0x3d16c7, 0x3d1617, 0x9b768179, 0x64897e87, 0, 0 }, /* #44 */
    { 0x1203d7, 0x120313, 0xcb69a7db, 0x34965825, 0, 0 }, /* #45 */
    { 0x0a6ac2, 0x0a6293, 0x2dedab8d, 0xd2125473, 0, 0 }, /* #46 */
    { 0x2f6dd2, 0x2f6517, 0xc12a2501, 0x3ed5daff, 0, 0 }, /* #47 */
    { 0x363256, 0x363293, 0x3589c9c5, 0xca76363b, 0, 0 }, /* #48 */
    { 0x382852, 0x382093, 0x7f3355b7, 0x80ccaa49, 0, 0 }, /* #49 */
    { 0x1c7113, 0x1c7193, 0x3eccab14, 0xc13354ec, 0, 0 }, /* #50 */
    { 0x395717, 0x395793, 0x73790974, 0x8c86f68c, 0, 0 }, /* #51 */
    { 0x215517, 0x215517, 0x9e9a93a6, 0x61656c5a, 0, 0 }, /* #52 */
    { 0x3678c7, 0x367013, 0xef1668cc, 0x10e99734, 0, 0 }, /* #53 */
    { 0x285346, 0x285393, 0x507e0de4, 0xaf81f21c, 0, 0 }, /* #54 */
    { 0x2c3297, 0x2c3287, 0x42b9f610, 0xbd4609f0, 0, 0 }, /* #55 */
    { 0x2b4013, 0x2b4013, 0xfb6d6b14, 0x049294ec, 0, 0 }, /* #56 */
    { 0x254297, 0x254213, 0xa583fd03, 0x5a7c02fd, 0, 0 }, /* #57 */
    { 0x145053, 0x145013, 0xca3bc8fc, 0x35c43704, 0, 0 }, /* #58 */
    { 0x353f12, 0x353787, 0x0e429270, 0xf1bd6d90, 0, 0 }, /* #59 */
    { 0x016f82, 0x016717, 0xfd0cbd37, 0x02f342c9, 0, 0 }, /* #60 */
    { 0x345086, 0x345087, 0x65fe85d0, 0x9a017a30, 0, 0 }, /* #61 */
    { 0x2e21c3, 0x2e2103, 0xfcc0eae0, 0x033f1520, 0, 0 }, /* #62 */
    { 0x294d53, 0x294513, 0x8fe2654d, 0x701d9ab3, 0, 0 }, /* #63 */
    { 0x1b23c3, 0x1b2397, 0x7bee6c3d, 0x841193c3, 0, 0 }, /* #64 */
    { 0x123f82, 0x123797, 0x0180acbf, 0xfe7f5341, 0, 0 }, /* #65 */
    { 0x163493, 0x163417, 0xbe6187bf, 0x419e7841, 0, 0 }, /* #66 */
    { 0x2b0747, 0x2b0717, 0xa7098f51, 0x58f670af, 0, 0 }, /* #67 */
    { 0x1c7f03, 0x1c7713, 0xfa3c786f, 0x05c38791, 0, 0 }, /* #68 */
    { 0x2d5013, 0x2d5097, 0x1f6f560b, 0xe090a9f5, 0, 0 }, /* #69 */
    { 0x2b3a83, 0x2b3293, 0x6548116f, 0x9ab7ee91, 0, 0 }, /* #70 */
    { 0x140fd3, 0x140797, 0x79f4527e, 0x860bad82, 0, 0 }, /* #71 */
    { 0x0b7782, 0x0b7717, 0x991c9cd8, 0x66e36328, 0, 0 }, /* #72 */
    { 0x2732c7, 0x273297, 0x7861d94f, 0x879e26b1, 0, 0 }, /* #73 */
    { 0x0405c7, 0x040513, 0x9d23c3f8, 0x62dc3c08, 0, 0 }, /* #74 */
    { 0x240892, 0x240013, 0x9e8374d7, 0x617c8b29, 0, 0 }, /* #75 */
    { 0x112b12, 0x112313, 0xb95d01a8, 0x46a2fe58, 0, 0 }, /* #76 */
    { 0x3762d7, 0x376213, 0xdce1a226, 0x231e5dda, 0, 0 }, /* #77 */
    { 0x010287, 0x010293, 0x3f716ea8, 0xc08e9158, 0, 0 }, /* #78 */
    { 0x2b0086, 0x2b0013, 0xa7ba200f, 0x5845dff1, 0, 0 }, /* #79 */
    { 0x2c6fd7, 0x2c6717, 0xb02c37d2, 0x4fd3c82e, 0, 0 }, /* #80 */
    { 0x1e6b92, 0x1e6313, 0x9a59c193, 0x65a63e6d, 0, 0 }, /* #81 */
    { 0x271517, 0x271593, 0x782f475c, 0x87d0b8a4, 0, 0 }, /* #82 */
    { 0x290017, 0x290017, 0xfbf05a0d, 0x040fa5f3, 0, 0 }, /* #83 */
    { 0x174803, 0x174093, 0x19e7a6f9, 0xe6185907, 0, 0 }, /* #84 */
    { 0x290e16, 0x290617, 0xb603e7a6, 0x49fc185a, 0, 0 }, /* #85 */
    { 0x245747, 0x245717, 0xd8c7980d, 0x273867f3, 0, 0 }, /* #86 */
    { 0x2d6217, 0x2d6293, 0x41a00998, 0xbe5ff668, 0, 0 }, /* #87 */
    { 0x353046, 0x353097, 0x580a1fb5, 0xa7f5e04b, 0, 0 }, /* #88 */
    { 0x1162c2, 0x116213, 0x98666558, 0x67999aa8, 0, 0 }, /* #89 */
    { 0x124f53, 0x124793, 0x0ad31965, 0xf52ce69b, 0, 0 }, /* #90 */
    { 0x033f92, 0x033793, 0x6cefd7d7, 0x93102829, 0, 0 }, /* #91 */
    { 0x176d03, 0x176517, 0xa444be56, 0x5bbb41aa, 0, 0 }, /* #92 */
    { 0x307756, 0x307717, 0xcbd9829d, 0x34267d63, 0, 0 }, /* #93 */
    { 0x337412, 0x337413, 0x9130123e, 0x6ecfedc2, 0, 0 }, /* #94 */
    { 0x3335d3, 0x333513, 0xa0c46d8b, 0x5f3b9275, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_neg_u32_locked = RT_ELEMENTS(g_aTests_neg_u32_locked);

BINU64_TEST_T const g_aTests_inc_u64[] =
{
    { 0x2a7dc3, 0x2a7587, 0x8b9bbc0c45b53cb6, 0x8b9bbc0c45b53cb7, 0, 0 }, /* #0 */
    { 0x282a96, 0x282286, 0xe4587798cb347a2d, 0xe4587798cb347a2e, 0, 0 }, /* #1 */
    { 0x201ec2, 0x201682, 0x91160985504b4128, 0x91160985504b4129, 0, 0 }, /* #2 */
    { 0x062a03, 0x062283, 0xb054890ec8d7231e, 0xb054890ec8d7231f, 0, 0 }, /* #3 */
    { 0x320816, 0x320002, 0x4a4f02d55aefaa1e, 0x4a4f02d55aefaa1f, 0, 0 }, /* #4 */
    { 0x2d2206, 0x2d2206, 0x503241cd00399686, 0x503241cd00399687, 0, 0 }, /* #5 */
    { 0x1f1cc6, 0x1f1482, 0xca80e8f24560f830, 0xca80e8f24560f831, 0, 0 }, /* #6 */
    { 0x3b0343, 0x3b0307, 0x71f1f3626ff34740, 0x71f1f3626ff34741, 0, 0 }, /* #7 */
    { 0x036382, 0x036382, 0xbfbec6fa0d28bdfc, 0xbfbec6fa0d28bdfd, 0, 0 }, /* #8 */
    { 0x094256, 0x094286, 0xe853230e9122d3a8, 0xe853230e9122d3a9, 0, 0 }, /* #9 */
    { 0x2a3997, 0x2a3187, 0xfa8e43102e8853b6, 0xfa8e43102e8853b7, 0, 0 }, /* #10 */
    { 0x3e7983, 0x3e7107, 0x062ce0cc50235946, 0x062ce0cc50235947, 0, 0 }, /* #11 */
    { 0x0c0502, 0x0c0586, 0xfa59aecc3365d5bc, 0xfa59aecc3365d5bd, 0, 0 }, /* #12 */
    { 0x3d4306, 0x3d4386, 0xf68f2e7d639302d6, 0xf68f2e7d639302d7, 0, 0 }, /* #13 */
    { 0x3c6557, 0x3c6503, 0x4400a9bca8565d30, 0x4400a9bca8565d31, 0, 0 }, /* #14 */
    { 0x190803, 0x190087, 0xb67a85643942d38d, 0xb67a85643942d38e, 0, 0 }, /* #15 */
    { 0x307ac7, 0x307293, 0xbc775d6be08a6bdf, 0xbc775d6be08a6be0, 0, 0 }, /* #16 */
    { 0x202c56, 0x202486, 0xeca7e792db9e70a5, 0xeca7e792db9e70a6, 0, 0 }, /* #17 */
    { 0x282b13, 0x282307, 0x1c7a5f7d1b8ce74c, 0x1c7a5f7d1b8ce74d, 0, 0 }, /* #18 */
    { 0x0c2b97, 0x0c2387, 0xdc2132ee0c3a4fe1, 0xdc2132ee0c3a4fe2, 0, 0 }, /* #19 */
    { 0x3c0c16, 0x3c0486, 0xaae9d69eae70c8b0, 0xaae9d69eae70c8b1, 0, 0 }, /* #20 */
    { 0x260697, 0x260607, 0x2a7185b597e12804, 0x2a7185b597e12805, 0, 0 }, /* #21 */
    { 0x2f4d92, 0x2f4586, 0x800406a195d80df4, 0x800406a195d80df5, 0, 0 }, /* #22 */
    { 0x2a7c17, 0x2a7413, 0x7e22aae72849123f, 0x7e22aae728491240, 0, 0 }, /* #23 */
    { 0x167183, 0x167103, 0x06ff0d31d0916067, 0x06ff0d31d0916068, 0, 0 }, /* #24 */
    { 0x350113, 0x350103, 0x505b2221bfab2961, 0x505b2221bfab2962, 0, 0 }, /* #25 */
    { 0x221b56, 0x221302, 0x4bb509199a843896, 0x4bb509199a843897, 0, 0 }, /* #26 */
    { 0x056503, 0x056503, 0x5670bb023ffa702b, 0x5670bb023ffa702c, 0, 0 }, /* #27 */
    { 0x0f3cc7, 0x0f3487, 0xac8cab8181430199, 0xac8cab818143019a, 0, 0 }, /* #28 */
    { 0x2e62c6, 0x2e6282, 0xc1227f75c6e0c024, 0xc1227f75c6e0c025, 0, 0 }, /* #29 */
    { 0x056bd7, 0x056303, 0x10d74e9346489e28, 0x10d74e9346489e29, 0, 0 }, /* #30 */
    { 0x1c0f97, 0x1c0703, 0x48e2be39851916d4, 0x48e2be39851916d5, 0, 0 }, /* #31 */
    { 0x1c2293, 0x1c2287, 0xd4ba5d2269c04104, 0xd4ba5d2269c04105, 0, 0 }, /* #32 */
    { 0x1d4b97, 0x1d4303, 0x647d8fe1fa47c103, 0x647d8fe1fa47c104, 0, 0 }, /* #33 */
    { 0x0f5c06, 0x0f5482, 0x9398a47a1a075f74, 0x9398a47a1a075f75, 0, 0 }, /* #34 */
    { 0x3f1046, 0x3f1006, 0x65a9bb134e92330e, 0x65a9bb134e92330f, 0, 0 }, /* #35 */
    { 0x392ec3, 0x392603, 0x12f47d7ae6436ffd, 0x12f47d7ae6436ffe, 0, 0 }, /* #36 */
    { 0x211c43, 0x211487, 0x82277d1387922846, 0x82277d1387922847, 0, 0 }, /* #37 */
    { 0x251546, 0x251586, 0xa7bf6ad89e7e7d1d, 0xa7bf6ad89e7e7d1e, 0, 0 }, /* #38 */
    { 0x1277c3, 0x127703, 0x3e59ec91a548e82e, 0x3e59ec91a548e82f, 0, 0 }, /* #39 */
    { 0x176c87, 0x176487, 0xa252baebc8b1370b, 0xa252baebc8b1370c, 0, 0 }, /* #40 */
    { 0x1f2557, 0x1f2507, 0x1a8ff14647bd9f08, 0x1a8ff14647bd9f09, 0, 0 }, /* #41 */
    { 0x0c1496, 0x0c1402, 0x02eeb0944e3d6f96, 0x02eeb0944e3d6f97, 0, 0 }, /* #42 */
    { 0x015902, 0x015182, 0x8bfe336a3394fecd, 0x8bfe336a3394fece, 0, 0 }, /* #43 */
    { 0x0f4a47, 0x0f4207, 0x2fae17d704a7db1d, 0x2fae17d704a7db1e, 0, 0 }, /* #44 */
    { 0x1d0e83, 0x1d0697, 0xc2f8d89d4b5cda4f, 0xc2f8d89d4b5cda50, 0, 0 }, /* #45 */
    { 0x234947, 0x234107, 0x70935fa88d86034a, 0x70935fa88d86034b, 0, 0 }, /* #46 */
    { 0x026e17, 0x026687, 0x8464101d9482f4a9, 0x8464101d9482f4aa, 0, 0 }, /* #47 */
    { 0x0a2d53, 0x0a2507, 0x1ad2b4e77a26e64a, 0x1ad2b4e77a26e64b, 0, 0 }, /* #48 */
    { 0x140993, 0x140103, 0x50dde7ed63142f28, 0x50dde7ed63142f29, 0, 0 }, /* #49 */
    { 0x390b43, 0x390307, 0x0536402e83c62362, 0x0536402e83c62363, 0, 0 }, /* #50 */
    { 0x370e86, 0x370682, 0xe49fddf8df374296, 0xe49fddf8df374297, 0, 0 }, /* #51 */
    { 0x1c2a57, 0x1c2203, 0x7e4e6dd63bf4d257, 0x7e4e6dd63bf4d258, 0, 0 }, /* #52 */
    { 0x1b3497, 0x1b3407, 0x016ea0668696116b, 0x016ea0668696116c, 0, 0 }, /* #53 */
    { 0x1c0697, 0x1c0683, 0xd3cc384cfe217333, 0xd3cc384cfe217334, 0, 0 }, /* #54 */
    { 0x1a2287, 0x1a2283, 0xc092b6a2c8b48c45, 0xc092b6a2c8b48c46, 0, 0 }, /* #55 */
    { 0x2e0293, 0x2e0203, 0x163d26e0d45cb0c6, 0x163d26e0d45cb0c7, 0, 0 }, /* #56 */
    { 0x3f35c3, 0x3f3507, 0x42811251fb19c477, 0x42811251fb19c478, 0, 0 }, /* #57 */
    { 0x217e02, 0x217686, 0xd6b56c0c179a62ce, 0xd6b56c0c179a62cf, 0, 0 }, /* #58 */
    { 0x2b3f13, 0x2b3707, 0x2b6e91e40c244d7a, 0x2b6e91e40c244d7b, 0, 0 }, /* #59 */
    { 0x302346, 0x302306, 0x6401365b4d2a25ed, 0x6401365b4d2a25ee, 0, 0 }, /* #60 */
    { 0x0f3cc6, 0x0f3406, 0x34ff92d908c27aed, 0x34ff92d908c27aee, 0, 0 }, /* #61 */
    { 0x046096, 0x046002, 0x7e427c050313a06a, 0x7e427c050313a06b, 0, 0 }, /* #62 */
    { 0x372457, 0x372483, 0xeb0c046ad40c904e, 0xeb0c046ad40c904f, 0, 0 }, /* #63 */
    { 0x160942, 0x160186, 0xdf765bb88cdf5c43, 0xdf765bb88cdf5c44, 0, 0 }, /* #64 */
    { 0x2c6f42, 0x2c6702, 0x2e1de300e0723caa, 0x2e1de300e0723cab, 0, 0 }, /* #65 */
    { 0x3e7c56, 0x3e7402, 0x2c77697f164ccefc, 0x2c77697f164ccefd, 0, 0 }, /* #66 */
    { 0x231302, 0x231302, 0x7f43868af437ca60, 0x7f43868af437ca61, 0, 0 }, /* #67 */
    { 0x245b07, 0x245307, 0x02a318bef5d29f7d, 0x02a318bef5d29f7e, 0, 0 }, /* #68 */
    { 0x167296, 0x167202, 0x35a0c2c5cdec6282, 0x35a0c2c5cdec6283, 0, 0 }, /* #69 */
    { 0x022fc3, 0x022783, 0xa7456888128150a1, 0xa7456888128150a2, 0, 0 }, /* #70 */
    { 0x257103, 0x257183, 0xf633ef4192261133, 0xf633ef4192261134, 0, 0 }, /* #71 */
    { 0x357a87, 0x357283, 0x94bca1ffa4a6a0fd, 0x94bca1ffa4a6a0fe, 0, 0 }, /* #72 */
    { 0x267bc6, 0x267306, 0x630447302130a19b, 0x630447302130a19c, 0, 0 }, /* #73 */
    { 0x3b47d6, 0x3b4706, 0x5bd84dabdaa75f11, 0x5bd84dabdaa75f12, 0, 0 }, /* #74 */
    { 0x060586, 0x060502, 0x25103fa27df678e2, 0x25103fa27df678e3, 0, 0 }, /* #75 */
    { 0x3c7dd7, 0x3c7587, 0xdaec2921b8749b23, 0xdaec2921b8749b24, 0, 0 }, /* #76 */
    { 0x313d82, 0x313506, 0x34030f8f9c7948dd, 0x34030f8f9c7948de, 0, 0 }, /* #77 */
    { 0x274402, 0x274486, 0xfa9d568076318270, 0xfa9d568076318271, 0, 0 }, /* #78 */
    { 0x053142, 0x053182, 0xbeddf794b4b79b19, 0xbeddf794b4b79b1a, 0, 0 }, /* #79 */
    { 0x3f4f46, 0x3f4702, 0x1ef2c073a11498aa, 0x1ef2c073a11498ab, 0, 0 }, /* #80 */
    { 0x235557, 0x235583, 0xec8a6edcd5429a00, 0xec8a6edcd5429a01, 0, 0 }, /* #81 */
    { 0x200fc7, 0x200787, 0xeb87d7dc2a5f176e, 0xeb87d7dc2a5f176f, 0, 0 }, /* #82 */
    { 0x1f2f86, 0x1f2782, 0xe7914281286865a0, 0xe7914281286865a1, 0, 0 }, /* #83 */
    { 0x1e6246, 0x1e6212, 0x57999642d6b9a86f, 0x57999642d6b9a870, 0, 0 }, /* #84 */
    { 0x1224c6, 0x122402, 0x34d42131c232615d, 0x34d42131c232615e, 0, 0 }, /* #85 */
    { 0x312487, 0x312483, 0xe3c30cd3db6fe6b4, 0xe3c30cd3db6fe6b5, 0, 0 }, /* #86 */
    { 0x1d1952, 0x1d1106, 0x53e55d5c098c9a80, 0x53e55d5c098c9a81, 0, 0 }, /* #87 */
    { 0x187ed3, 0x187683, 0xb691034ef8396844, 0xb691034ef8396845, 0, 0 }, /* #88 */
    { 0x0240c6, 0x024086, 0xde06967f1b26afed, 0xde06967f1b26afee, 0, 0 }, /* #89 */
    { 0x111dc2, 0x111586, 0xd1ffe5ab58263d80, 0xd1ffe5ab58263d81, 0, 0 }, /* #90 */
    { 0x206d43, 0x206503, 0x42ecff50d9db6d60, 0x42ecff50d9db6d61, 0, 0 }, /* #91 */
    { 0x2e6092, 0x2e6002, 0x62effc15560550e9, 0x62effc15560550ea, 0, 0 }, /* #92 */
    { 0x085e12, 0x085686, 0x9c0f8280ff5d4034, 0x9c0f8280ff5d4035, 0, 0 }, /* #93 */
    { 0x2a15d7, 0x2a1587, 0xfd51b53a5bb10ce1, 0xfd51b53a5bb10ce2, 0, 0 }, /* #94 */
    { 0x2a5ad2, 0x2a5206, 0x21b7269123d04a58, 0x21b7269123d04a59, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_inc_u64 = RT_ELEMENTS(g_aTests_inc_u64);

BINU64_TEST_T const g_aTests_inc_u64_locked[] =
{
    { 0x215c16, 0x215482, 0xbb97db449a62af89, 0xbb97db449a62af8a, 0, 0 }, /* #0 */
    { 0x1f3012, 0x1f3082, 0xa3240d49a8a61785, 0xa3240d49a8a61786, 0, 0 }, /* #1 */
    { 0x022552, 0x022582, 0xb43e2baa66c68b5a, 0xb43e2baa66c68b5b, 0, 0 }, /* #2 */
    { 0x0315c2, 0x031502, 0x1a6c5701ee807c97, 0x1a6c5701ee807c98, 0, 0 }, /* #3 */
    { 0x372902, 0x372102, 0x76e73c83f8d9a2a3, 0x76e73c83f8d9a2a4, 0, 0 }, /* #4 */
    { 0x142717, 0x142787, 0xfe3bf5b55fa51140, 0xfe3bf5b55fa51141, 0, 0 }, /* #5 */
    { 0x024d06, 0x024506, 0x1692611df1158d0e, 0x1692611df1158d0f, 0, 0 }, /* #6 */
    { 0x016907, 0x016117, 0x00e53def0409575f, 0x00e53def04095760, 0, 0 }, /* #7 */
    { 0x0c1217, 0x0c1283, 0x865f6f818c7a7d18, 0x865f6f818c7a7d19, 0, 0 }, /* #8 */
    { 0x3029d7, 0x302183, 0xc86ff5e9e521bbe4, 0xc86ff5e9e521bbe5, 0, 0 }, /* #9 */
    { 0x0833d7, 0x083387, 0x8138d820c555af65, 0x8138d820c555af66, 0, 0 }, /* #10 */
    { 0x023cd6, 0x023486, 0x930bcda375bfbbb0, 0x930bcda375bfbbb1, 0, 0 }, /* #11 */
    { 0x2c2942, 0x2c2102, 0x0512da0ef3f98acd, 0x0512da0ef3f98ace, 0, 0 }, /* #12 */
    { 0x3e3b07, 0x3e3303, 0x3e5b72d3b3d41ba7, 0x3e5b72d3b3d41ba8, 0, 0 }, /* #13 */
    { 0x344307, 0x344383, 0x95bf957f758c82f7, 0x95bf957f758c82f8, 0, 0 }, /* #14 */
    { 0x213746, 0x213782, 0xf7a500401586138b, 0xf7a500401586138c, 0, 0 }, /* #15 */
    { 0x395192, 0x395186, 0xc4889259dc24740e, 0xc4889259dc24740f, 0, 0 }, /* #16 */
    { 0x306cd3, 0x306403, 0x07b6103267fddb9c, 0x07b6103267fddb9d, 0, 0 }, /* #17 */
    { 0x240752, 0x240786, 0xbae92eefdddc5305, 0xbae92eefdddc5306, 0, 0 }, /* #18 */
    { 0x3152d3, 0x315203, 0x1ff1ac8b54be9348, 0x1ff1ac8b54be9349, 0, 0 }, /* #19 */
    { 0x2c0947, 0x2c0107, 0x26d8b1e27e44a5bd, 0x26d8b1e27e44a5be, 0, 0 }, /* #20 */
    { 0x3a5113, 0x3a5183, 0x84f63efdcd4167b2, 0x84f63efdcd4167b3, 0, 0 }, /* #21 */
    { 0x150092, 0x150002, 0x4ae7583c8eec3a60, 0x4ae7583c8eec3a61, 0, 0 }, /* #22 */
    { 0x290853, 0x290003, 0x4459bebe064f3a75, 0x4459bebe064f3a76, 0, 0 }, /* #23 */
    { 0x3910c3, 0x391007, 0x7f62d858c7403640, 0x7f62d858c7403641, 0, 0 }, /* #24 */
    { 0x007513, 0x007583, 0xa5c78f164274fbf0, 0xa5c78f164274fbf1, 0, 0 }, /* #25 */
    { 0x210e93, 0x210603, 0x1a52674ab28574db, 0x1a52674ab28574dc, 0, 0 }, /* #26 */
    { 0x0b5fd6, 0x0b5786, 0xb931e33e607a5104, 0xb931e33e607a5105, 0, 0 }, /* #27 */
    { 0x333787, 0x333783, 0xf8daf3f332f01060, 0xf8daf3f332f01061, 0, 0 }, /* #28 */
    { 0x0c6693, 0x0c6607, 0x268a8543071cfcdd, 0x268a8543071cfcde, 0, 0 }, /* #29 */
    { 0x0d7dc7, 0x0d7583, 0xee2ea06a7547a2ca, 0xee2ea06a7547a2cb, 0, 0 }, /* #30 */
    { 0x120e06, 0x120616, 0x45ce4054e43c262f, 0x45ce4054e43c2630, 0, 0 }, /* #31 */
    { 0x217583, 0x217583, 0xd2aec64dac7ed0b2, 0xd2aec64dac7ed0b3, 0, 0 }, /* #32 */
    { 0x321f43, 0x321707, 0x0d7d6a600f16d7a4, 0x0d7d6a600f16d7a5, 0, 0 }, /* #33 */
    { 0x310592, 0x310582, 0xba45bffbb9a78acc, 0xba45bffbb9a78acd, 0, 0 }, /* #34 */
    { 0x020cc7, 0x020407, 0x2f5621c6667ac734, 0x2f5621c6667ac735, 0, 0 }, /* #35 */
    { 0x2b2393, 0x2b2307, 0x23944f0c6ccf4bfe, 0x23944f0c6ccf4bff, 0, 0 }, /* #36 */
    { 0x171fc3, 0x171707, 0x57cfca4843f3cd68, 0x57cfca4843f3cd69, 0, 0 }, /* #37 */
    { 0x0d2dd6, 0x0d2582, 0xf2ccae5bb176fa1b, 0xf2ccae5bb176fa1c, 0, 0 }, /* #38 */
    { 0x2a1153, 0x2a1183, 0xf751d717b8956118, 0xf751d717b8956119, 0, 0 }, /* #39 */
    { 0x053707, 0x053703, 0x572b815e3ec51eee, 0x572b815e3ec51eef, 0, 0 }, /* #40 */
    { 0x227146, 0x227182, 0xb259d0c13749b6d9, 0xb259d0c13749b6da, 0, 0 }, /* #41 */
    { 0x372196, 0x372102, 0x69f52a873c425984, 0x69f52a873c425985, 0, 0 }, /* #42 */
    { 0x210bc6, 0x210382, 0x823d5a7097ac30cc, 0x823d5a7097ac30cd, 0, 0 }, /* #43 */
    { 0x387982, 0x387182, 0xb2093d3cb1723719, 0xb2093d3cb172371a, 0, 0 }, /* #44 */
    { 0x365a93, 0x365203, 0x0d315a5f56075812, 0x0d315a5f56075813, 0, 0 }, /* #45 */
    { 0x2e64c7, 0x2e6403, 0x7101a36d03949a2e, 0x7101a36d03949a2f, 0, 0 }, /* #46 */
    { 0x260286, 0x260202, 0x7162d3a34e17e85c, 0x7162d3a34e17e85d, 0, 0 }, /* #47 */
    { 0x3371c7, 0x337107, 0x08942b8335795f8d, 0x08942b8335795f8e, 0, 0 }, /* #48 */
    { 0x2c2703, 0x2c2783, 0x9568dca9641f3a19, 0x9568dca9641f3a1a, 0, 0 }, /* #49 */
    { 0x331d06, 0x331582, 0x8d15b1658cdf393a, 0x8d15b1658cdf393b, 0, 0 }, /* #50 */
    { 0x2c7bd7, 0x2c7383, 0xaba4b5f54fb890d2, 0xaba4b5f54fb890d3, 0, 0 }, /* #51 */
    { 0x072293, 0x072207, 0x04ca9202df3d531c, 0x04ca9202df3d531d, 0, 0 }, /* #52 */
    { 0x0e43c6, 0x0e4382, 0xc6e86e8f5855705c, 0xc6e86e8f5855705d, 0, 0 }, /* #53 */
    { 0x113543, 0x113507, 0x232d603b43b25a64, 0x232d603b43b25a65, 0, 0 }, /* #54 */
    { 0x080a82, 0x080216, 0x10b3247e77d023bf, 0x10b3247e77d023c0, 0, 0 }, /* #55 */
    { 0x360147, 0x360107, 0x2fdd654f5b5ed46b, 0x2fdd654f5b5ed46c, 0, 0 }, /* #56 */
    { 0x0b2607, 0x0b2607, 0x3a6bf9be6441ba43, 0x3a6bf9be6441ba44, 0, 0 }, /* #57 */
    { 0x2c3a42, 0x2c3282, 0xf0d00e4373da9182, 0xf0d00e4373da9183, 0, 0 }, /* #58 */
    { 0x291e07, 0x291607, 0x30f8112eee235862, 0x30f8112eee235863, 0, 0 }, /* #59 */
    { 0x1b6756, 0x1b6702, 0x14e5e31b07751aca, 0x14e5e31b07751acb, 0, 0 }, /* #60 */
    { 0x122756, 0x122702, 0x595ee7cac39b1456, 0x595ee7cac39b1457, 0, 0 }, /* #61 */
    { 0x0b28d3, 0x0b2003, 0x11cecf6e248aad63, 0x11cecf6e248aad64, 0, 0 }, /* #62 */
    { 0x387356, 0x387386, 0xa2a066d093f73554, 0xa2a066d093f73555, 0, 0 }, /* #63 */
    { 0x1c5b86, 0x1c5386, 0xdecb2898e1c96bec, 0xdecb2898e1c96bed, 0, 0 }, /* #64 */
    { 0x1442c7, 0x144203, 0x7407d4c1fabb4faa, 0x7407d4c1fabb4fab, 0, 0 }, /* #65 */
    { 0x315043, 0x315003, 0x06e7a2965e653678, 0x06e7a2965e653679, 0, 0 }, /* #66 */
    { 0x0159d3, 0x015187, 0x9873b59162da32c5, 0x9873b59162da32c6, 0, 0 }, /* #67 */
    { 0x1b0057, 0x1b0007, 0x1d349d2f85ca1217, 0x1d349d2f85ca1218, 0, 0 }, /* #68 */
    { 0x017817, 0x017083, 0x9ebf06ae893c92a7, 0x9ebf06ae893c92a8, 0, 0 }, /* #69 */
    { 0x017096, 0x017002, 0x107d82eeae34d503, 0x107d82eeae34d504, 0, 0 }, /* #70 */
    { 0x3c6702, 0x3c6796, 0xf36468adedc565ef, 0xf36468adedc565f0, 0, 0 }, /* #71 */
    { 0x203582, 0x203502, 0x0fc92e9ea4031a50, 0x0fc92e9ea4031a51, 0, 0 }, /* #72 */
    { 0x121e56, 0x121686, 0xef284edecc1ab620, 0xef284edecc1ab621, 0, 0 }, /* #73 */
    { 0x3e4b83, 0x3e4307, 0x49385bfab73e572c, 0x49385bfab73e572d, 0, 0 }, /* #74 */
    { 0x0270c3, 0x027083, 0xdd793c8861149bf0, 0xdd793c8861149bf1, 0, 0 }, /* #75 */
    { 0x140f12, 0x140702, 0x694d424bc8e2433c, 0x694d424bc8e2433d, 0, 0 }, /* #76 */
    { 0x1b3316, 0x1b3386, 0x814d26265c6b529b, 0x814d26265c6b529c, 0, 0 }, /* #77 */
    { 0x381c82, 0x381406, 0x775755f79ff97010, 0x775755f79ff97011, 0, 0 }, /* #78 */
    { 0x096c06, 0x096406, 0x7bb671ea85143f95, 0x7bb671ea85143f96, 0, 0 }, /* #79 */
    { 0x160902, 0x160182, 0xa850ff9e437e94a7, 0xa850ff9e437e94a8, 0, 0 }, /* #80 */
    { 0x1776c2, 0x177686, 0x8fd56e36575a8204, 0x8fd56e36575a8205, 0, 0 }, /* #81 */
    { 0x195156, 0x195182, 0x9f332a3a3f74271b, 0x9f332a3a3f74271c, 0, 0 }, /* #82 */
    { 0x117d46, 0x117502, 0x24762a25b4a78fad, 0x24762a25b4a78fae, 0, 0 }, /* #83 */
    { 0x185812, 0x185092, 0xec5c141324bdafaf, 0xec5c141324bdafb0, 0, 0 }, /* #84 */
    { 0x252002, 0x252086, 0xd5179fe99d9e1123, 0xd5179fe99d9e1124, 0, 0 }, /* #85 */
    { 0x3b3452, 0x3b3482, 0xa6a7a5dbf7453991, 0xa6a7a5dbf7453992, 0, 0 }, /* #86 */
    { 0x0c3387, 0x0c3397, 0x99afdee79466f75f, 0x99afdee79466f760, 0, 0 }, /* #87 */
    { 0x3d6212, 0x3d6282, 0x8dfb0e748c667578, 0x8dfb0e748c667579, 0, 0 }, /* #88 */
    { 0x2a2946, 0x2a2106, 0x711731deea8e0b98, 0x711731deea8e0b99, 0, 0 }, /* #89 */
    { 0x3b6147, 0x3b6183, 0xf05aafcae2613cb5, 0xf05aafcae2613cb6, 0, 0 }, /* #90 */
    { 0x0b2f52, 0x0b2702, 0x6ef2a76537a3355a, 0x6ef2a76537a3355b, 0, 0 }, /* #91 */
    { 0x115642, 0x115686, 0xb20fc66aae99ea59, 0xb20fc66aae99ea5a, 0, 0 }, /* #92 */
    { 0x161297, 0x161207, 0x0780e62689d0e9c2, 0x0780e62689d0e9c3, 0, 0 }, /* #93 */
    { 0x2b27c6, 0x2b2786, 0xa378aed13deaf111, 0xa378aed13deaf112, 0, 0 }, /* #94 */
    { 0x187582, 0x187502, 0x0b08e6a9d853783a, 0x0b08e6a9d853783b, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_inc_u64_locked = RT_ELEMENTS(g_aTests_inc_u64_locked);

BINU64_TEST_T const g_aTests_dec_u64[] =
{
    { 0x096317, 0x096303, 0x267c5d41c749da5e, 0x267c5d41c749da5d, 0, 0 }, /* #0 */
    { 0x322cc7, 0x322483, 0x9e7d3eb1062a0517, 0x9e7d3eb1062a0516, 0, 0 }, /* #1 */
    { 0x1b0397, 0x1b0307, 0x078cdf5f6afa16c6, 0x078cdf5f6afa16c5, 0, 0 }, /* #2 */
    { 0x321046, 0x321086, 0x8273b4bbeaaac245, 0x8273b4bbeaaac244, 0, 0 }, /* #3 */
    { 0x2b6303, 0x2b6307, 0x062b257a416e9f4e, 0x062b257a416e9f4d, 0, 0 }, /* #4 */
    { 0x1460c2, 0x146002, 0x1951d5b54a63cce1, 0x1951d5b54a63cce0, 0, 0 }, /* #5 */
    { 0x382887, 0x382087, 0x83af295efd0268b3, 0x83af295efd0268b2, 0, 0 }, /* #6 */
    { 0x0b5e16, 0x0b5686, 0xcd0e6e09f832ac23, 0xcd0e6e09f832ac22, 0, 0 }, /* #7 */
    { 0x3e2892, 0x3e2082, 0x8a79c8699a1bbfb4, 0x8a79c8699a1bbfb3, 0, 0 }, /* #8 */
    { 0x0a7b92, 0x0a7306, 0x4f292277efd33ca7, 0x4f292277efd33ca6, 0, 0 }, /* #9 */
    { 0x0b1247, 0x0b1287, 0xefc199e8b50cbdf4, 0xefc199e8b50cbdf3, 0, 0 }, /* #10 */
    { 0x1e60c3, 0x1e6003, 0x75d3af53b432e165, 0x75d3af53b432e164, 0, 0 }, /* #11 */
    { 0x065086, 0x065002, 0x66de7eb4e5fedd3e, 0x66de7eb4e5fedd3d, 0, 0 }, /* #12 */
    { 0x3a3456, 0x3a3486, 0xd51f9b7663e770b2, 0xd51f9b7663e770b1, 0, 0 }, /* #13 */
    { 0x113616, 0x113682, 0x93fa5914423aa762, 0x93fa5914423aa761, 0, 0 }, /* #14 */
    { 0x3e3f86, 0x3e3782, 0x8272065da24bf4a8, 0x8272065da24bf4a7, 0, 0 }, /* #15 */
    { 0x2f3003, 0x2f3007, 0x4c4906bbe680f23a, 0x4c4906bbe680f239, 0, 0 }, /* #16 */
    { 0x2f5117, 0x2f5113, 0x466a2859261a9ec0, 0x466a2859261a9ebf, 0, 0 }, /* #17 */
    { 0x0e2e07, 0x0e2603, 0x381b3a4f4ed040d6, 0x381b3a4f4ed040d5, 0, 0 }, /* #18 */
    { 0x022686, 0x022686, 0xdb6d2026e1eccd4f, 0xdb6d2026e1eccd4e, 0, 0 }, /* #19 */
    { 0x290702, 0x290702, 0x1fcc0e8061f0f9e4, 0x1fcc0e8061f0f9e3, 0, 0 }, /* #20 */
    { 0x1a6ac6, 0x1a6206, 0x1c0ec47d6adf1d49, 0x1c0ec47d6adf1d48, 0, 0 }, /* #21 */
    { 0x3a4656, 0x3a4682, 0x9cb294409482a253, 0x9cb294409482a252, 0, 0 }, /* #22 */
    { 0x301902, 0x301186, 0xb915011b032ccf43, 0xb915011b032ccf42, 0, 0 }, /* #23 */
    { 0x3a0086, 0x3a0002, 0x6d567285c8bb60a2, 0x6d567285c8bb60a1, 0, 0 }, /* #24 */
    { 0x246b06, 0x246306, 0x133bcffed499fd43, 0x133bcffed499fd42, 0, 0 }, /* #25 */
    { 0x356a16, 0x356282, 0xecf2d33aa8c57e7b, 0xecf2d33aa8c57e7a, 0, 0 }, /* #26 */
    { 0x100852, 0x100086, 0xd12b5cb4a233a796, 0xd12b5cb4a233a795, 0, 0 }, /* #27 */
    { 0x2e0f52, 0x2e0702, 0x389d6ca97351ba87, 0x389d6ca97351ba86, 0, 0 }, /* #28 */
    { 0x143fc6, 0x143782, 0xa8ad57c191be68a5, 0xa8ad57c191be68a4, 0, 0 }, /* #29 */
    { 0x286502, 0x286506, 0x5dbb974786d5d928, 0x5dbb974786d5d927, 0, 0 }, /* #30 */
    { 0x355a03, 0x355283, 0xf463cbbc0c3d727a, 0xf463cbbc0c3d7279, 0, 0 }, /* #31 */
    { 0x0d4212, 0x0d4282, 0xcc093d2c8a177b58, 0xcc093d2c8a177b57, 0, 0 }, /* #32 */
    { 0x1731d6, 0x173102, 0x4bf5b060fedc5bcf, 0x4bf5b060fedc5bce, 0, 0 }, /* #33 */
    { 0x0a6683, 0x0a6683, 0xd447af5de0b90f46, 0xd447af5de0b90f45, 0, 0 }, /* #34 */
    { 0x206707, 0x206703, 0x73b69450b5f27b1d, 0x73b69450b5f27b1c, 0, 0 }, /* #35 */
    { 0x0e6a13, 0x0e6283, 0xab1946fe1f1125d1, 0xab1946fe1f1125d0, 0, 0 }, /* #36 */
    { 0x1c7693, 0x1c7613, 0x1b2f6f0b8e60e690, 0x1b2f6f0b8e60e68f, 0, 0 }, /* #37 */
    { 0x071253, 0x071203, 0x795894167ae31835, 0x795894167ae31834, 0, 0 }, /* #38 */
    { 0x293717, 0x293783, 0xa8df5e7ea5ac0fda, 0xa8df5e7ea5ac0fd9, 0, 0 }, /* #39 */
    { 0x236353, 0x236387, 0xb1556eeddddadfee, 0xb1556eeddddadfed, 0, 0 }, /* #40 */
    { 0x3a6652, 0x3a6606, 0x00f5408a4c0c6cd5, 0x00f5408a4c0c6cd4, 0, 0 }, /* #41 */
    { 0x233dc7, 0x233583, 0x9785efeaacfda826, 0x9785efeaacfda825, 0, 0 }, /* #42 */
    { 0x1e6052, 0x1e6002, 0x402784df04709cea, 0x402784df04709ce9, 0, 0 }, /* #43 */
    { 0x0a4402, 0x0a4486, 0xdb1f4a62a6a4fa23, 0xdb1f4a62a6a4fa22, 0, 0 }, /* #44 */
    { 0x017bd2, 0x017382, 0x93636d001e4c8cba, 0x93636d001e4c8cb9, 0, 0 }, /* #45 */
    { 0x261816, 0x261096, 0xc91b17fa27d0d4a0, 0xc91b17fa27d0d49f, 0, 0 }, /* #46 */
    { 0x164603, 0x164687, 0xbcccec019ee9ad4c, 0xbcccec019ee9ad4b, 0, 0 }, /* #47 */
    { 0x326c57, 0x326407, 0x755dd619e450c582, 0x755dd619e450c581, 0, 0 }, /* #48 */
    { 0x3749c6, 0x374102, 0x26919ed49dcbc924, 0x26919ed49dcbc923, 0, 0 }, /* #49 */
    { 0x377cd6, 0x377402, 0x6989ef28fb106f38, 0x6989ef28fb106f37, 0, 0 }, /* #50 */
    { 0x0a7107, 0x0a7187, 0xa341bd8e33108634, 0xa341bd8e33108633, 0, 0 }, /* #51 */
    { 0x264f96, 0x264786, 0xcad2ebb08b17eb13, 0xcad2ebb08b17eb12, 0, 0 }, /* #52 */
    { 0x162f13, 0x162787, 0xd978921a37a1d9d5, 0xd978921a37a1d9d4, 0, 0 }, /* #53 */
    { 0x3925c2, 0x392582, 0x8956b583160abca8, 0x8956b583160abca7, 0, 0 }, /* #54 */
    { 0x032506, 0x032506, 0x7caae6a19510d5cb, 0x7caae6a19510d5ca, 0, 0 }, /* #55 */
    { 0x306b17, 0x306307, 0x621b51a1a5d5ca04, 0x621b51a1a5d5ca03, 0, 0 }, /* #56 */
    { 0x2d6cc2, 0x2d6406, 0x2cee4685ade2abde, 0x2cee4685ade2abdd, 0, 0 }, /* #57 */
    { 0x1a47d3, 0x1a4787, 0x8350c8477729e631, 0x8350c8477729e630, 0, 0 }, /* #58 */
    { 0x106903, 0x106183, 0x9f72198dd30d60d7, 0x9f72198dd30d60d6, 0, 0 }, /* #59 */
    { 0x3763d3, 0x376387, 0xa8627e8716a73a5d, 0xa8627e8716a73a5c, 0, 0 }, /* #60 */
    { 0x353dc2, 0x353586, 0xeb987d7940c2f0de, 0xeb987d7940c2f0dd, 0, 0 }, /* #61 */
    { 0x185557, 0x185583, 0x9ad94278d4be940e, 0x9ad94278d4be940d, 0, 0 }, /* #62 */
    { 0x391757, 0x391787, 0xd7c3d11917da97ef, 0xd7c3d11917da97ee, 0, 0 }, /* #63 */
    { 0x2d57d3, 0x2d5783, 0xc2799905ba8b84da, 0xc2799905ba8b84d9, 0, 0 }, /* #64 */
    { 0x0526c7, 0x052607, 0x2f1c397e725afd89, 0x2f1c397e725afd88, 0, 0 }, /* #65 */
    { 0x227096, 0x227002, 0x16b852e717100dce, 0x16b852e717100dcd, 0, 0 }, /* #66 */
    { 0x326642, 0x326686, 0xe8bbdff01caaca3d, 0xe8bbdff01caaca3c, 0, 0 }, /* #67 */
    { 0x2c2683, 0x2c2687, 0x8ec77ea37538fb12, 0x8ec77ea37538fb11, 0, 0 }, /* #68 */
    { 0x210903, 0x210193, 0xddf9a3d7adaa2b30, 0xddf9a3d7adaa2b2f, 0, 0 }, /* #69 */
    { 0x3e31d7, 0x3e3107, 0x4a5af0972427ebf7, 0x4a5af0972427ebf6, 0, 0 }, /* #70 */
    { 0x2d5017, 0x2d5007, 0x2e06909ef16febc1, 0x2e06909ef16febc0, 0, 0 }, /* #71 */
    { 0x1e7957, 0x1e7103, 0x120c7660d597bc58, 0x120c7660d597bc57, 0, 0 }, /* #72 */
    { 0x051e83, 0x051687, 0xbb091698bb076cec, 0xbb091698bb076ceb, 0, 0 }, /* #73 */
    { 0x1b0946, 0x1b0186, 0xfc3a6421380a607c, 0xfc3a6421380a607b, 0, 0 }, /* #74 */
    { 0x086856, 0x086086, 0xc35c251fb5d60234, 0xc35c251fb5d60233, 0, 0 }, /* #75 */
    { 0x2e1f57, 0x2e1787, 0xce8d77fbb38e49e3, 0xce8d77fbb38e49e2, 0, 0 }, /* #76 */
    { 0x074807, 0x074087, 0x9213932c084323ad, 0x9213932c084323ac, 0, 0 }, /* #77 */
    { 0x126c57, 0x126497, 0xef24113165994000, 0xef24113165993fff, 0, 0 }, /* #78 */
    { 0x2110d3, 0x211003, 0x2f94f028a0407763, 0x2f94f028a0407762, 0, 0 }, /* #79 */
    { 0x122cd2, 0x122406, 0x1d0f231d0763a29b, 0x1d0f231d0763a29a, 0, 0 }, /* #80 */
    { 0x313912, 0x313116, 0x559c13c0b07e2660, 0x559c13c0b07e265f, 0, 0 }, /* #81 */
    { 0x1e6912, 0x1e6186, 0xcd62d5b7acd07aa1, 0xcd62d5b7acd07aa0, 0, 0 }, /* #82 */
    { 0x283192, 0x283102, 0x1540566cebbb506f, 0x1540566cebbb506e, 0, 0 }, /* #83 */
    { 0x3e6356, 0x3e6382, 0xc3a23a21800faed1, 0xc3a23a21800faed0, 0, 0 }, /* #84 */
    { 0x3255d2, 0x325582, 0xfc3add0e2c6156ba, 0xfc3add0e2c6156b9, 0, 0 }, /* #85 */
    { 0x085b82, 0x085302, 0x12b26f09fceb0f11, 0x12b26f09fceb0f10, 0, 0 }, /* #86 */
    { 0x2d02d7, 0x2d0207, 0x4277d8fa5f4a978e, 0x4277d8fa5f4a978d, 0, 0 }, /* #87 */
    { 0x307e47, 0x307603, 0x68f11f81641f8c71, 0x68f11f81641f8c70, 0, 0 }, /* #88 */
    { 0x122b86, 0x122382, 0xb505beecb25494f9, 0xb505beecb25494f8, 0, 0 }, /* #89 */
    { 0x002bd3, 0x002307, 0x486baa626cbab648, 0x486baa626cbab647, 0, 0 }, /* #90 */
    { 0x2d0dd3, 0x2d0503, 0x5c22b17481f93fba, 0x5c22b17481f93fb9, 0, 0 }, /* #91 */
    { 0x294712, 0x294706, 0x6807609bae325cab, 0x6807609bae325caa, 0, 0 }, /* #92 */
    { 0x330447, 0x330487, 0xf2c4bcdc902f3a22, 0xf2c4bcdc902f3a21, 0, 0 }, /* #93 */
    { 0x235792, 0x235706, 0x0efdfe353833ab25, 0x0efdfe353833ab24, 0, 0 }, /* #94 */
    { 0x3d5243, 0x3d5203, 0x18e85198b8d0c2f3, 0x18e85198b8d0c2f2, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_dec_u64 = RT_ELEMENTS(g_aTests_dec_u64);

BINU64_TEST_T const g_aTests_dec_u64_locked[] =
{
    { 0x211196, 0x211102, 0x1431281b2d004853, 0x1431281b2d004852, 0, 0 }, /* #0 */
    { 0x072213, 0x072203, 0x1332db7b485b9d5c, 0x1332db7b485b9d5b, 0, 0 }, /* #1 */
    { 0x337987, 0x337187, 0x92a46c6de394ffe3, 0x92a46c6de394ffe2, 0, 0 }, /* #2 */
    { 0x3633c3, 0x363387, 0x81f26a7283eb747f, 0x81f26a7283eb747e, 0, 0 }, /* #3 */
    { 0x030b12, 0x030302, 0x557d8446e64db9c3, 0x557d8446e64db9c2, 0, 0 }, /* #4 */
    { 0x3d2786, 0x3d2782, 0x93e9ec9cc590d42b, 0x93e9ec9cc590d42a, 0, 0 }, /* #5 */
    { 0x2467d2, 0x246786, 0xdf1e42a092f8b7fd, 0xdf1e42a092f8b7fc, 0, 0 }, /* #6 */
    { 0x356b83, 0x356387, 0x94e6b7c0df50a5b5, 0x94e6b7c0df50a5b4, 0, 0 }, /* #7 */
    { 0x273616, 0x273686, 0xb6942ff2e49e5501, 0xb6942ff2e49e5500, 0, 0 }, /* #8 */
    { 0x3e7c42, 0x3e7402, 0x7b0465f67fcd8f5f, 0x7b0465f67fcd8f5e, 0, 0 }, /* #9 */
    { 0x0d5482, 0x0d5402, 0x2a847c01ce4ac562, 0x2a847c01ce4ac561, 0, 0 }, /* #10 */
    { 0x240b87, 0x240387, 0x9b4c4d00b9f6de4f, 0x9b4c4d00b9f6de4e, 0, 0 }, /* #11 */
    { 0x217397, 0x217307, 0x7edf4104ad9edd7c, 0x7edf4104ad9edd7b, 0, 0 }, /* #12 */
    { 0x2b14c7, 0x2b1407, 0x54d424d611c70f0b, 0x54d424d611c70f0a, 0, 0 }, /* #13 */
    { 0x135357, 0x135303, 0x20633e353313161b, 0x20633e353313161a, 0, 0 }, /* #14 */
    { 0x3f6007, 0x3f6003, 0x6b7797a9922b74cc, 0x6b7797a9922b74cb, 0, 0 }, /* #15 */
    { 0x2d6f87, 0x2d6707, 0x423562aa85249d4f, 0x423562aa85249d4e, 0, 0 }, /* #16 */
    { 0x236a07, 0x236287, 0x80594039040b54f7, 0x80594039040b54f6, 0, 0 }, /* #17 */
    { 0x246512, 0x246502, 0x6585ef4abb8c144b, 0x6585ef4abb8c144a, 0, 0 }, /* #18 */
    { 0x3c63c3, 0x3c6307, 0x6da3aa559adb1f96, 0x6da3aa559adb1f95, 0, 0 }, /* #19 */
    { 0x082d86, 0x082502, 0x15cc064171f1de74, 0x15cc064171f1de73, 0, 0 }, /* #20 */
    { 0x1511c7, 0x151107, 0x3258d41a7dadad75, 0x3258d41a7dadad74, 0, 0 }, /* #21 */
    { 0x113dd6, 0x113502, 0x4514b960b7d90227, 0x4514b960b7d90226, 0, 0 }, /* #22 */
    { 0x0407c3, 0x040783, 0xcea4df8a85112f6e, 0xcea4df8a85112f6d, 0, 0 }, /* #23 */
    { 0x2b60d6, 0x2b6082, 0xdde55953099541d6, 0xdde55953099541d5, 0, 0 }, /* #24 */
    { 0x352602, 0x352606, 0x67572ac99baa0288, 0x67572ac99baa0287, 0, 0 }, /* #25 */
    { 0x1c1397, 0x1c1383, 0xdaa86466cbd53926, 0xdaa86466cbd53925, 0, 0 }, /* #26 */
    { 0x335517, 0x335507, 0x6186d4e92d61b01c, 0x6186d4e92d61b01b, 0, 0 }, /* #27 */
    { 0x1320c2, 0x132082, 0x9e078aacd58826ac, 0x9e078aacd58826ab, 0, 0 }, /* #28 */
    { 0x184892, 0x184082, 0xb1a65dd2f72fa1f2, 0xb1a65dd2f72fa1f1, 0, 0 }, /* #29 */
    { 0x156456, 0x156412, 0x3e6f4f006c1a3290, 0x3e6f4f006c1a328f, 0, 0 }, /* #30 */
    { 0x070a47, 0x070203, 0x6c60b3afae4bd135, 0x6c60b3afae4bd134, 0, 0 }, /* #31 */
    { 0x007242, 0x007206, 0x0deb3d8845e08954, 0x0deb3d8845e08953, 0, 0 }, /* #32 */
    { 0x353357, 0x353383, 0xf99972ad02dbfbb6, 0xf99972ad02dbfbb5, 0, 0 }, /* #33 */
    { 0x3b5052, 0x3b5086, 0x8010cc1fbfe9551e, 0x8010cc1fbfe9551d, 0, 0 }, /* #34 */
    { 0x2a3906, 0x2a3182, 0xd897f2dd2a8d4768, 0xd897f2dd2a8d4767, 0, 0 }, /* #35 */
    { 0x3c2dd3, 0x3c2583, 0x93d44ab4f2aa722a, 0x93d44ab4f2aa7229, 0, 0 }, /* #36 */
    { 0x1b5042, 0x1b5086, 0x9dd3aa36f8c782ec, 0x9dd3aa36f8c782eb, 0, 0 }, /* #37 */
    { 0x207d06, 0x207506, 0x485db71650bbf00a, 0x485db71650bbf009, 0, 0 }, /* #38 */
    { 0x210956, 0x210106, 0x380928488bf1993a, 0x380928488bf19939, 0, 0 }, /* #39 */
    { 0x2b3a17, 0x2b3287, 0xf7562ba6c52943ec, 0xf7562ba6c52943eb, 0, 0 }, /* #40 */
    { 0x213d47, 0x213507, 0x6eae5dfa53a59382, 0x6eae5dfa53a59381, 0, 0 }, /* #41 */
    { 0x300cd7, 0x300483, 0xb87a3562fc3aab6e, 0xb87a3562fc3aab6d, 0, 0 }, /* #42 */
    { 0x287112, 0x287106, 0x5a191d85baeb71be, 0x5a191d85baeb71bd, 0, 0 }, /* #43 */
    { 0x083393, 0x083387, 0xdb9bb8090c73bb48, 0xdb9bb8090c73bb47, 0, 0 }, /* #44 */
    { 0x0d6457, 0x0d6483, 0xff1ee3847679b84b, 0xff1ee3847679b84a, 0, 0 }, /* #45 */
    { 0x094786, 0x094786, 0xb0146ba3240a29a7, 0xb0146ba3240a29a6, 0, 0 }, /* #46 */
    { 0x395c16, 0x395486, 0xcee7b02485deddd5, 0xcee7b02485deddd4, 0, 0 }, /* #47 */
    { 0x224307, 0x224317, 0x78bd06785e77cf00, 0x78bd06785e77ceff, 0, 0 }, /* #48 */
    { 0x2527c7, 0x252787, 0xa929ad84b87d9751, 0xa929ad84b87d9750, 0, 0 }, /* #49 */
    { 0x373b97, 0x373387, 0xaa4f2ecf1fad77dc, 0xaa4f2ecf1fad77db, 0, 0 }, /* #50 */
    { 0x082ac7, 0x082287, 0xafd06a24d95cb997, 0xafd06a24d95cb996, 0, 0 }, /* #51 */
    { 0x137d93, 0x137503, 0x5f99621d6c42a768, 0x5f99621d6c42a767, 0, 0 }, /* #52 */
    { 0x2e37d3, 0x2e3707, 0x6cd42c382b781cd2, 0x6cd42c382b781cd1, 0, 0 }, /* #53 */
    { 0x391c47, 0x391487, 0xe676a60e79c4c615, 0xe676a60e79c4c614, 0, 0 }, /* #54 */
    { 0x140a07, 0x140203, 0x249e89a4c6ada25c, 0x249e89a4c6ada25b, 0, 0 }, /* #55 */
    { 0x2954c2, 0x295486, 0x83c72f4fb4034bfa, 0x83c72f4fb4034bf9, 0, 0 }, /* #56 */
    { 0x3a2087, 0x3a2087, 0x985e51d9cf6eedc7, 0x985e51d9cf6eedc6, 0, 0 }, /* #57 */
    { 0x165687, 0x165687, 0xf37d62548bc887be, 0xf37d62548bc887bd, 0, 0 }, /* #58 */
    { 0x147652, 0x147602, 0x67475b6d0a5f19fc, 0x67475b6d0a5f19fb, 0, 0 }, /* #59 */
    { 0x2d6a53, 0x2d6283, 0xb2b5763f874bdca2, 0xb2b5763f874bdca1, 0, 0 }, /* #60 */
    { 0x385dc7, 0x385507, 0x17e527b2e3650873, 0x17e527b2e3650872, 0, 0 }, /* #61 */
    { 0x061f86, 0x061702, 0x1477f640fc14dc2b, 0x1477f640fc14dc2a, 0, 0 }, /* #62 */
    { 0x2815c6, 0x281506, 0x69faa73b22518f94, 0x69faa73b22518f93, 0, 0 }, /* #63 */
    { 0x343716, 0x343782, 0xf22e2cb41d8d12a9, 0xf22e2cb41d8d12a8, 0, 0 }, /* #64 */
    { 0x323392, 0x323382, 0x8940258810d7d16f, 0x8940258810d7d16e, 0, 0 }, /* #65 */
    { 0x145ed6, 0x145686, 0xa42f6d8f90fc2c7e, 0xa42f6d8f90fc2c7d, 0, 0 }, /* #66 */
    { 0x0f1ad2, 0x0f1206, 0x2d515cd4fbb8e101, 0x2d515cd4fbb8e100, 0, 0 }, /* #67 */
    { 0x254e12, 0x254606, 0x7e4d31da2884fdc7, 0x7e4d31da2884fdc6, 0, 0 }, /* #68 */
    { 0x3b42d2, 0x3b4206, 0x1185bb9f5b71b8c1, 0x1185bb9f5b71b8c0, 0, 0 }, /* #69 */
    { 0x193c93, 0x193483, 0xc7651dc579ad07a2, 0xc7651dc579ad07a1, 0, 0 }, /* #70 */
    { 0x022942, 0x022106, 0x19bc6b148e3e5f4c, 0x19bc6b148e3e5f4b, 0, 0 }, /* #71 */
    { 0x2432c3, 0x243207, 0x257ffdd5cc1a0c1c, 0x257ffdd5cc1a0c1b, 0, 0 }, /* #72 */
    { 0x0118c2, 0x011006, 0x79b10a59d20c5b9a, 0x79b10a59d20c5b99, 0, 0 }, /* #73 */
    { 0x2a1447, 0x2a1403, 0x5ecdaf7cb1a4ac5f, 0x5ecdaf7cb1a4ac5e, 0, 0 }, /* #74 */
    { 0x1d1a46, 0x1d1282, 0xb7b1a9011fce3a71, 0xb7b1a9011fce3a70, 0, 0 }, /* #75 */
    { 0x131253, 0x131283, 0xf818584b4d85d5f2, 0xf818584b4d85d5f1, 0, 0 }, /* #76 */
    { 0x230903, 0x230107, 0x37de39ac0c11ac2c, 0x37de39ac0c11ac2b, 0, 0 }, /* #77 */
    { 0x056a07, 0x056283, 0xdc8b03259b7868e7, 0xdc8b03259b7868e6, 0, 0 }, /* #78 */
    { 0x1b2412, 0x1b2482, 0x9f7d7358b61da547, 0x9f7d7358b61da546, 0, 0 }, /* #79 */
    { 0x355016, 0x355082, 0xe35e643cab594a05, 0xe35e643cab594a04, 0, 0 }, /* #80 */
    { 0x023396, 0x023382, 0xbe82cde7e58895bb, 0xbe82cde7e58895ba, 0, 0 }, /* #81 */
    { 0x193816, 0x193002, 0x7313bd9a5e09ed8a, 0x7313bd9a5e09ed89, 0, 0 }, /* #82 */
    { 0x162cd2, 0x162482, 0xeb7b333641b8f8f3, 0xeb7b333641b8f8f2, 0, 0 }, /* #83 */
    { 0x1121d7, 0x112103, 0x2447539ab517510e, 0x2447539ab517510d, 0, 0 }, /* #84 */
    { 0x1e1ad2, 0x1e1202, 0x297a7770c75b37db, 0x297a7770c75b37da, 0, 0 }, /* #85 */
    { 0x013186, 0x013102, 0x29a030d9734ffda3, 0x29a030d9734ffda2, 0, 0 }, /* #86 */
    { 0x170546, 0x170582, 0x8c682ab86e937287, 0x8c682ab86e937286, 0, 0 }, /* #87 */
    { 0x272c53, 0x272483, 0xe4ec64595883daa3, 0xe4ec64595883daa2, 0, 0 }, /* #88 */
    { 0x0232d7, 0x023287, 0xd870e269473a7c96, 0xd870e269473a7c95, 0, 0 }, /* #89 */
    { 0x2b3f43, 0x2b3703, 0x54573879632cb602, 0x54573879632cb601, 0, 0 }, /* #90 */
    { 0x294512, 0x294582, 0xb215300c15b270d1, 0xb215300c15b270d0, 0, 0 }, /* #91 */
    { 0x3010c6, 0x301006, 0x14be19170b1aab61, 0x14be19170b1aab60, 0, 0 }, /* #92 */
    { 0x140ec6, 0x140686, 0x9f4eda7df83f5ee8, 0x9f4eda7df83f5ee7, 0, 0 }, /* #93 */
    { 0x303d53, 0x303503, 0x67f60f7c0b4cd4e6, 0x67f60f7c0b4cd4e5, 0, 0 }, /* #94 */
    { 0x3d6283, 0x3d6207, 0x33b6d94ebda2ab37, 0x33b6d94ebda2ab36, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_dec_u64_locked = RT_ELEMENTS(g_aTests_dec_u64_locked);

BINU64_TEST_T const g_aTests_not_u64[] =
{
    { 0x2622d6, 0x2622d6, 0x688ffee37c036d60, 0x9770011c83fc929f, 0, 0 }, /* #0 */
    { 0x0f05c3, 0x0f05c3, 0xf89edb953f788966, 0x0761246ac0877699, 0, 0 }, /* #1 */
    { 0x314b12, 0x314b12, 0x43d34cb9f8b81957, 0xbc2cb3460747e6a8, 0, 0 }, /* #2 */
    { 0x0721d6, 0x0721d6, 0x07aff488c2d735cf, 0xf8500b773d28ca30, 0, 0 }, /* #3 */
    { 0x306052, 0x306052, 0x556788baa6fde64c, 0xaa987745590219b3, 0, 0 }, /* #4 */
    { 0x0f3a92, 0x0f3a92, 0x1b58f7cefe348b42, 0xe4a7083101cb74bd, 0, 0 }, /* #5 */
    { 0x173c12, 0x173c12, 0x939da8bde3d2f2b3, 0x6c6257421c2d0d4c, 0, 0 }, /* #6 */
    { 0x2d3286, 0x2d3286, 0xb70f86150d8ccc9d, 0x48f079eaf2733362, 0, 0 }, /* #7 */
    { 0x141403, 0x141403, 0xb19b9808a1d7049a, 0x4e6467f75e28fb65, 0, 0 }, /* #8 */
    { 0x041d97, 0x041d97, 0x2bbf7e5cc47ce808, 0xd44081a33b8317f7, 0, 0 }, /* #9 */
    { 0x163212, 0x163212, 0x679579213b0473ff, 0x986a86dec4fb8c00, 0, 0 }, /* #10 */
    { 0x0e2092, 0x0e2092, 0xbee6458dadb67585, 0x4119ba7252498a7a, 0, 0 }, /* #11 */
    { 0x0f15c2, 0x0f15c2, 0x4169bed959baf333, 0xbe964126a6450ccc, 0, 0 }, /* #12 */
    { 0x352907, 0x352907, 0xf7c374290660092a, 0x083c8bd6f99ff6d5, 0, 0 }, /* #13 */
    { 0x254396, 0x254396, 0xaf209abd5cc8868b, 0x50df6542a3377974, 0, 0 }, /* #14 */
    { 0x127946, 0x127946, 0x618f3ac3ff728294, 0x9e70c53c008d7d6b, 0, 0 }, /* #15 */
    { 0x0d3182, 0x0d3182, 0x442583ccce91c073, 0xbbda7c33316e3f8c, 0, 0 }, /* #16 */
    { 0x060342, 0x060342, 0x65ec8507c4af5bc9, 0x9a137af83b50a436, 0, 0 }, /* #17 */
    { 0x247d57, 0x247d57, 0x71813a1cb45f8d56, 0x8e7ec5e34ba072a9, 0, 0 }, /* #18 */
    { 0x206712, 0x206712, 0x6856b33657b8ec82, 0x97a94cc9a847137d, 0, 0 }, /* #19 */
    { 0x0012c7, 0x0012c7, 0x8503cbc4bb4401c5, 0x7afc343b44bbfe3a, 0, 0 }, /* #20 */
    { 0x287c17, 0x287c17, 0x84aee6f90051e42f, 0x7b511906ffae1bd0, 0, 0 }, /* #21 */
    { 0x056757, 0x056757, 0x71c113cfd62b146c, 0x8e3eec3029d4eb93, 0, 0 }, /* #22 */
    { 0x284c56, 0x284c56, 0xcdccfe0bfd064cf8, 0x323301f402f9b307, 0, 0 }, /* #23 */
    { 0x376a56, 0x376a56, 0x99cb1db4d2570041, 0x6634e24b2da8ffbe, 0, 0 }, /* #24 */
    { 0x3b7682, 0x3b7682, 0xda5c7cf47a6f1ecf, 0x25a3830b8590e130, 0, 0 }, /* #25 */
    { 0x0c5f06, 0x0c5f06, 0xc87d8e93c120c1cb, 0x3782716c3edf3e34, 0, 0 }, /* #26 */
    { 0x194517, 0x194517, 0x37d2f417b6161119, 0xc82d0be849e9eee6, 0, 0 }, /* #27 */
    { 0x3a54d6, 0x3a54d6, 0xb66c624344a6edbb, 0x49939dbcbb591244, 0, 0 }, /* #28 */
    { 0x196d07, 0x196d07, 0xec1ad745e9d4208f, 0x13e528ba162bdf70, 0, 0 }, /* #29 */
    { 0x3e6816, 0x3e6816, 0x832f38b213acb5cf, 0x7cd0c74dec534a30, 0, 0 }, /* #30 */
    { 0x1d2f17, 0x1d2f17, 0xb108e571da1ae4b6, 0x4ef71a8e25e51b49, 0, 0 }, /* #31 */
    { 0x302cc3, 0x302cc3, 0xd9f2cb04b01b1c2a, 0x260d34fb4fe4e3d5, 0, 0 }, /* #32 */
    { 0x166a02, 0x166a02, 0x9fe37ef447d71e7a, 0x601c810bb828e185, 0, 0 }, /* #33 */
    { 0x365516, 0x365516, 0xfcf1ffa10b0c2407, 0x030e005ef4f3dbf8, 0, 0 }, /* #34 */
    { 0x1d7317, 0x1d7317, 0x5fbb0df9ef46a08d, 0xa044f20610b95f72, 0, 0 }, /* #35 */
    { 0x322593, 0x322593, 0xf8f972f5465f10a7, 0x07068d0ab9a0ef58, 0, 0 }, /* #36 */
    { 0x1b2a47, 0x1b2a47, 0xbe448350f705d77f, 0x41bb7caf08fa2880, 0, 0 }, /* #37 */
    { 0x3b1ad7, 0x3b1ad7, 0x23ef64378fbde9d5, 0xdc109bc87042162a, 0, 0 }, /* #38 */
    { 0x232943, 0x232943, 0xe271fd58f5e4cb9b, 0x1d8e02a70a1b3464, 0, 0 }, /* #39 */
    { 0x155d13, 0x155d13, 0xfb8ae8472fb35d47, 0x047517b8d04ca2b8, 0, 0 }, /* #40 */
    { 0x3a26c7, 0x3a26c7, 0x84de9e3c03d64a95, 0x7b2161c3fc29b56a, 0, 0 }, /* #41 */
    { 0x112d06, 0x112d06, 0x1fcb03a311a61cb9, 0xe034fc5cee59e346, 0, 0 }, /* #42 */
    { 0x192e02, 0x192e02, 0x823a7c3a02a77944, 0x7dc583c5fd5886bb, 0, 0 }, /* #43 */
    { 0x157247, 0x157247, 0x06a73ce63bc68aac, 0xf958c319c4397553, 0, 0 }, /* #44 */
    { 0x1d14c7, 0x1d14c7, 0x63e1e65ee0d9d9ce, 0x9c1e19a11f262631, 0, 0 }, /* #45 */
    { 0x062d83, 0x062d83, 0xf621d5640a86f4e4, 0x09de2a9bf5790b1b, 0, 0 }, /* #46 */
    { 0x187117, 0x187117, 0x4e8fbc3507b10003, 0xb17043caf84efffc, 0, 0 }, /* #47 */
    { 0x2d0442, 0x2d0442, 0x334e315e7d7f43ad, 0xccb1cea18280bc52, 0, 0 }, /* #48 */
    { 0x0a1a02, 0x0a1a02, 0x5a7261226576fb7c, 0xa58d9edd9a890483, 0, 0 }, /* #49 */
    { 0x0d5657, 0x0d5657, 0xa336f327271cf83c, 0x5cc90cd8d8e307c3, 0, 0 }, /* #50 */
    { 0x0a4583, 0x0a4583, 0x8097ad765305a492, 0x7f685289acfa5b6d, 0, 0 }, /* #51 */
    { 0x352102, 0x352102, 0xe1d0ff8313d04763, 0x1e2f007cec2fb89c, 0, 0 }, /* #52 */
    { 0x3a3446, 0x3a3446, 0x01a3d1c831acfc1c, 0xfe5c2e37ce5303e3, 0, 0 }, /* #53 */
    { 0x1e5c53, 0x1e5c53, 0x64402e2e603b9916, 0x9bbfd1d19fc466e9, 0, 0 }, /* #54 */
    { 0x1c7647, 0x1c7647, 0xc2065c8bc5bee90a, 0x3df9a3743a4116f5, 0, 0 }, /* #55 */
    { 0x3b1ac2, 0x3b1ac2, 0x01a477216fc01d79, 0xfe5b88de903fe286, 0, 0 }, /* #56 */
    { 0x1d4a57, 0x1d4a57, 0xc5fdf45d5be5b408, 0x3a020ba2a41a4bf7, 0, 0 }, /* #57 */
    { 0x016993, 0x016993, 0xa8bdce3bf26e2f85, 0x574231c40d91d07a, 0, 0 }, /* #58 */
    { 0x3a3182, 0x3a3182, 0x28cd08fab07eff10, 0xd732f7054f8100ef, 0, 0 }, /* #59 */
    { 0x2e5d13, 0x2e5d13, 0x98679228f661235e, 0x67986dd7099edca1, 0, 0 }, /* #60 */
    { 0x073f86, 0x073f86, 0xd30014e4b8061660, 0x2cffeb1b47f9e99f, 0, 0 }, /* #61 */
    { 0x245907, 0x245907, 0x157156e889fec10e, 0xea8ea91776013ef1, 0, 0 }, /* #62 */
    { 0x0036c6, 0x0036c6, 0xfa2e334f9a8c3ffa, 0x05d1ccb06573c005, 0, 0 }, /* #63 */
    { 0x3170d6, 0x3170d6, 0xe871f1156267212f, 0x178e0eea9d98ded0, 0, 0 }, /* #64 */
    { 0x0a6e93, 0x0a6e93, 0x6b462ec9645952fb, 0x94b9d1369ba6ad04, 0, 0 }, /* #65 */
    { 0x3b7806, 0x3b7806, 0x8ac05ee599118e09, 0x753fa11a66ee71f6, 0, 0 }, /* #66 */
    { 0x0a3e52, 0x0a3e52, 0x077cd30b7fe26ce2, 0xf8832cf4801d931d, 0, 0 }, /* #67 */
    { 0x001dd6, 0x001dd6, 0x79c957e63259a937, 0x8636a819cda656c8, 0, 0 }, /* #68 */
    { 0x015f97, 0x015f97, 0x4fb3d756a369d169, 0xb04c28a95c962e96, 0, 0 }, /* #69 */
    { 0x360012, 0x360012, 0xdb74602fcbd93c56, 0x248b9fd03426c3a9, 0, 0 }, /* #70 */
    { 0x211806, 0x211806, 0x63b26192a447238f, 0x9c4d9e6d5bb8dc70, 0, 0 }, /* #71 */
    { 0x215a12, 0x215a12, 0x418aa4aa4155ef08, 0xbe755b55beaa10f7, 0, 0 }, /* #72 */
    { 0x183112, 0x183112, 0x7a2fafa768b253ef, 0x85d05058974dac10, 0, 0 }, /* #73 */
    { 0x2714c7, 0x2714c7, 0x2b991ab4a4c53e72, 0xd466e54b5b3ac18d, 0, 0 }, /* #74 */
    { 0x0848c7, 0x0848c7, 0x4dc0eced6b230696, 0xb23f131294dcf969, 0, 0 }, /* #75 */
    { 0x3b1f42, 0x3b1f42, 0x44bff8374660bd04, 0xbb4007c8b99f42fb, 0, 0 }, /* #76 */
    { 0x325a07, 0x325a07, 0x4896ca21b552ec06, 0xb76935de4aad13f9, 0, 0 }, /* #77 */
    { 0x0f0d43, 0x0f0d43, 0x91aab5fcaf831dd8, 0x6e554a03507ce227, 0, 0 }, /* #78 */
    { 0x184447, 0x184447, 0x8bcac7020e0b244d, 0x743538fdf1f4dbb2, 0, 0 }, /* #79 */
    { 0x3a75d2, 0x3a75d2, 0x2e13f282c4a17532, 0xd1ec0d7d3b5e8acd, 0, 0 }, /* #80 */
    { 0x3b7e17, 0x3b7e17, 0x87ebdc60b9d7b71c, 0x7814239f462848e3, 0, 0 }, /* #81 */
    { 0x1a5657, 0x1a5657, 0xf9b85b1833bc06be, 0x0647a4e7cc43f941, 0, 0 }, /* #82 */
    { 0x2913c7, 0x2913c7, 0x371546e67927bdff, 0xc8eab91986d84200, 0, 0 }, /* #83 */
    { 0x011856, 0x011856, 0x3a9d4c09d9904ad6, 0xc562b3f6266fb529, 0, 0 }, /* #84 */
    { 0x137e02, 0x137e02, 0xe1e601aa0564c955, 0x1e19fe55fa9b36aa, 0, 0 }, /* #85 */
    { 0x304a53, 0x304a53, 0x1a55e841891b6366, 0xe5aa17be76e49c99, 0, 0 }, /* #86 */
    { 0x1120c7, 0x1120c7, 0x4af7042de2dde018, 0xb508fbd21d221fe7, 0, 0 }, /* #87 */
    { 0x2716c7, 0x2716c7, 0x188bc20be650fb03, 0xe7743df419af04fc, 0, 0 }, /* #88 */
    { 0x1d2f06, 0x1d2f06, 0x5fb1abca7c491de9, 0xa04e543583b6e216, 0, 0 }, /* #89 */
    { 0x357403, 0x357403, 0x1cbc93d581bc5295, 0xe3436c2a7e43ad6a, 0, 0 }, /* #90 */
    { 0x076c03, 0x076c03, 0x7bef0f154ec8f2dd, 0x8410f0eab1370d22, 0, 0 }, /* #91 */
    { 0x377413, 0x377413, 0xa7b4c6a0a4c504cc, 0x584b395f5b3afb33, 0, 0 }, /* #92 */
    { 0x394ec6, 0x394ec6, 0x8c393b32b79177cc, 0x73c6c4cd486e8833, 0, 0 }, /* #93 */
    { 0x2a6096, 0x2a6096, 0x0bfdf9a42861b1c1, 0xf402065bd79e4e3e, 0, 0 }, /* #94 */
    { 0x3c1786, 0x3c1786, 0x57138aa839d4613c, 0xa8ec7557c62b9ec3, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_not_u64 = RT_ELEMENTS(g_aTests_not_u64);

BINU64_TEST_T const g_aTests_not_u64_locked[] =
{
    { 0x1e4587, 0x1e4587, 0x7d84fca697b82bfe, 0x827b03596847d401, 0, 0 }, /* #0 */
    { 0x2f0246, 0x2f0246, 0x48ca1094911d23d6, 0xb735ef6b6ee2dc29, 0, 0 }, /* #1 */
    { 0x277bd3, 0x277bd3, 0x4661859d8572a826, 0xb99e7a627a8d57d9, 0, 0 }, /* #2 */
    { 0x3d6507, 0x3d6507, 0x9bc8a3bbedb9e637, 0x64375c44124619c8, 0, 0 }, /* #3 */
    { 0x283402, 0x283402, 0x8cc75c1f5a663f2f, 0x7338a3e0a599c0d0, 0, 0 }, /* #4 */
    { 0x3d2513, 0x3d2513, 0x786858050603ea5a, 0x8797a7faf9fc15a5, 0, 0 }, /* #5 */
    { 0x087956, 0x087956, 0x363d4530c0abca3c, 0xc9c2bacf3f5435c3, 0, 0 }, /* #6 */
    { 0x222cd6, 0x222cd6, 0x79caadc3422bfefb, 0x8635523cbdd40104, 0, 0 }, /* #7 */
    { 0x3b1493, 0x3b1493, 0xddca581b347b045e, 0x2235a7e4cb84fba1, 0, 0 }, /* #8 */
    { 0x241093, 0x241093, 0x6a027368be10fcdd, 0x95fd8c9741ef0322, 0, 0 }, /* #9 */
    { 0x225606, 0x225606, 0xfc6c2d7682d14415, 0x0393d2897d2ebbea, 0, 0 }, /* #10 */
    { 0x0454c2, 0x0454c2, 0x12b236e530b82b98, 0xed4dc91acf47d467, 0, 0 }, /* #11 */
    { 0x2f5897, 0x2f5897, 0xf149a81143c4c431, 0x0eb657eebc3b3bce, 0, 0 }, /* #12 */
    { 0x275313, 0x275313, 0x33983d3f8935c49b, 0xcc67c2c076ca3b64, 0, 0 }, /* #13 */
    { 0x0d3802, 0x0d3802, 0x61a2eeee0cb8d0ad, 0x9e5d1111f3472f52, 0, 0 }, /* #14 */
    { 0x0a5a83, 0x0a5a83, 0xff36f8541878c8bf, 0x00c907abe7873740, 0, 0 }, /* #15 */
    { 0x391953, 0x391953, 0x00565a3d47d8d7c1, 0xffa9a5c2b827283e, 0, 0 }, /* #16 */
    { 0x0027d3, 0x0027d3, 0xd37546550da88180, 0x2c8ab9aaf2577e7f, 0, 0 }, /* #17 */
    { 0x2365c6, 0x2365c6, 0xb8f3b07cece04a66, 0x470c4f83131fb599, 0, 0 }, /* #18 */
    { 0x1d05d7, 0x1d05d7, 0xa88200cd78404d28, 0x577dff3287bfb2d7, 0, 0 }, /* #19 */
    { 0x002ad7, 0x002ad7, 0x9ed53e91a45d11a7, 0x612ac16e5ba2ee58, 0, 0 }, /* #20 */
    { 0x0a0b02, 0x0a0b02, 0xf11cbf7eb34e6f3f, 0x0ee340814cb190c0, 0, 0 }, /* #21 */
    { 0x352813, 0x352813, 0x2bb8cb3cfaa1d7ff, 0xd44734c3055e2800, 0, 0 }, /* #22 */
    { 0x247e87, 0x247e87, 0xe50fc42d890c4f27, 0x1af03bd276f3b0d8, 0, 0 }, /* #23 */
    { 0x216116, 0x216116, 0x52834014a601142a, 0xad7cbfeb59feebd5, 0, 0 }, /* #24 */
    { 0x1e2f83, 0x1e2f83, 0xc2ee9fcdd0175dfa, 0x3d1160322fe8a205, 0, 0 }, /* #25 */
    { 0x1a5bd2, 0x1a5bd2, 0x0b544ff0dd0f2c17, 0xf4abb00f22f0d3e8, 0, 0 }, /* #26 */
    { 0x0562c3, 0x0562c3, 0x3ba05d6742b43d0c, 0xc45fa298bd4bc2f3, 0, 0 }, /* #27 */
    { 0x0f4f92, 0x0f4f92, 0x4386c994194ec797, 0xbc79366be6b13868, 0, 0 }, /* #28 */
    { 0x072dc7, 0x072dc7, 0x05f72e52bb4ce3ba, 0xfa08d1ad44b31c45, 0, 0 }, /* #29 */
    { 0x1f4dc2, 0x1f4dc2, 0x9365c860abf59948, 0x6c9a379f540a66b7, 0, 0 }, /* #30 */
    { 0x2a0357, 0x2a0357, 0x5d0217361ffe6b8d, 0xa2fde8c9e0019472, 0, 0 }, /* #31 */
    { 0x231cd7, 0x231cd7, 0x269631bc12fd3c5a, 0xd969ce43ed02c3a5, 0, 0 }, /* #32 */
    { 0x057982, 0x057982, 0x2215d231c9303b6e, 0xddea2dce36cfc491, 0, 0 }, /* #33 */
    { 0x3e52d6, 0x3e52d6, 0x75cd57ff165046b2, 0x8a32a800e9afb94d, 0, 0 }, /* #34 */
    { 0x2330c2, 0x2330c2, 0xb5db947b4c2bce61, 0x4a246b84b3d4319e, 0, 0 }, /* #35 */
    { 0x385112, 0x385112, 0x58206357f9a1a8dd, 0xa7df9ca8065e5722, 0, 0 }, /* #36 */
    { 0x195357, 0x195357, 0x877fcfe8d9974e11, 0x788030172668b1ee, 0, 0 }, /* #37 */
    { 0x0132c2, 0x0132c2, 0x2ad367ef2158f5db, 0xd52c9810dea70a24, 0, 0 }, /* #38 */
    { 0x0030c2, 0x0030c2, 0x48a894836755edc0, 0xb7576b7c98aa123f, 0, 0 }, /* #39 */
    { 0x052246, 0x052246, 0xa76d4feca22220b3, 0x5892b0135ddddf4c, 0, 0 }, /* #40 */
    { 0x262bc7, 0x262bc7, 0x0edb14bd650b3ce3, 0xf124eb429af4c31c, 0, 0 }, /* #41 */
    { 0x3a5356, 0x3a5356, 0x19154c4941b877f0, 0xe6eab3b6be47880f, 0, 0 }, /* #42 */
    { 0x103602, 0x103602, 0xdf3dee6658a877e5, 0x20c21199a757881a, 0, 0 }, /* #43 */
    { 0x255857, 0x255857, 0x1bdf5c0406038cc3, 0xe420a3fbf9fc733c, 0, 0 }, /* #44 */
    { 0x2e7c86, 0x2e7c86, 0x7adccf99bfc56748, 0x85233066403a98b7, 0, 0 }, /* #45 */
    { 0x027093, 0x027093, 0x760021ffcc0d7b1b, 0x89ffde0033f284e4, 0, 0 }, /* #46 */
    { 0x0c25d6, 0x0c25d6, 0xc6c20414d18a05b1, 0x393dfbeb2e75fa4e, 0, 0 }, /* #47 */
    { 0x374413, 0x374413, 0x574c41facf07236e, 0xa8b3be0530f8dc91, 0, 0 }, /* #48 */
    { 0x1052d6, 0x1052d6, 0xd84606d437b11025, 0x27b9f92bc84eefda, 0, 0 }, /* #49 */
    { 0x1e1f46, 0x1e1f46, 0x3449db2501d8ea04, 0xcbb624dafe2715fb, 0, 0 }, /* #50 */
    { 0x0a7407, 0x0a7407, 0xa7c3124840e52668, 0x583cedb7bf1ad997, 0, 0 }, /* #51 */
    { 0x2f1057, 0x2f1057, 0x7557943871996101, 0x8aa86bc78e669efe, 0, 0 }, /* #52 */
    { 0x102e53, 0x102e53, 0x0597f1bde354a159, 0xfa680e421cab5ea6, 0, 0 }, /* #53 */
    { 0x087f17, 0x087f17, 0xdc37bf974ff82236, 0x23c84068b007ddc9, 0, 0 }, /* #54 */
    { 0x3a4dc2, 0x3a4dc2, 0x3c64296e0ba928f5, 0xc39bd691f456d70a, 0, 0 }, /* #55 */
    { 0x342fc2, 0x342fc2, 0x70d314be543f5aaa, 0x8f2ceb41abc0a555, 0, 0 }, /* #56 */
    { 0x1b0187, 0x1b0187, 0x3256b65fe292dc3d, 0xcda949a01d6d23c2, 0, 0 }, /* #57 */
    { 0x2f5407, 0x2f5407, 0xb128b50ec8930c2f, 0x4ed74af1376cf3d0, 0, 0 }, /* #58 */
    { 0x0b6bc7, 0x0b6bc7, 0x5308474c3dfeddde, 0xacf7b8b3c2012221, 0, 0 }, /* #59 */
    { 0x176596, 0x176596, 0xd92d3f5fe9797bef, 0x26d2c0a016868410, 0, 0 }, /* #60 */
    { 0x1d4b97, 0x1d4b97, 0x3de34bf286a9c27c, 0xc21cb40d79563d83, 0, 0 }, /* #61 */
    { 0x215842, 0x215842, 0xfb325c50232776c4, 0x04cda3afdcd8893b, 0, 0 }, /* #62 */
    { 0x362ac3, 0x362ac3, 0xc4eceb0700972936, 0x3b1314f8ff68d6c9, 0, 0 }, /* #63 */
    { 0x036906, 0x036906, 0x7aa2c916ae86b556, 0x855d36e951794aa9, 0, 0 }, /* #64 */
    { 0x2c3f53, 0x2c3f53, 0xc5201a804f3cdd5c, 0x3adfe57fb0c322a3, 0, 0 }, /* #65 */
    { 0x275007, 0x275007, 0xd3e458a845b99145, 0x2c1ba757ba466eba, 0, 0 }, /* #66 */
    { 0x347706, 0x347706, 0xf63a72f16ee33767, 0x09c58d0e911cc898, 0, 0 }, /* #67 */
    { 0x0333d6, 0x0333d6, 0x4d442c5d70b12ed3, 0xb2bbd3a28f4ed12c, 0, 0 }, /* #68 */
    { 0x306287, 0x306287, 0x3c24ac1f89170869, 0xc3db53e076e8f796, 0, 0 }, /* #69 */
    { 0x117287, 0x117287, 0x721a96a4a8b96955, 0x8de5695b574696aa, 0, 0 }, /* #70 */
    { 0x291307, 0x291307, 0x78a59fd166118339, 0x875a602e99ee7cc6, 0, 0 }, /* #71 */
    { 0x2b6687, 0x2b6687, 0xb99c72b6fa8ed76a, 0x46638d4905712895, 0, 0 }, /* #72 */
    { 0x265706, 0x265706, 0x9338d85e4ed4852e, 0x6cc727a1b12b7ad1, 0, 0 }, /* #73 */
    { 0x307547, 0x307547, 0xd8a66a981bdeb13a, 0x27599567e4214ec5, 0, 0 }, /* #74 */
    { 0x3e2e87, 0x3e2e87, 0xd1ff0a6281cca2f2, 0x2e00f59d7e335d0d, 0, 0 }, /* #75 */
    { 0x2549d7, 0x2549d7, 0x39861ca65d03394a, 0xc679e359a2fcc6b5, 0, 0 }, /* #76 */
    { 0x3f2f46, 0x3f2f46, 0x49b74c2c39ffa133, 0xb648b3d3c6005ecc, 0, 0 }, /* #77 */
    { 0x305b06, 0x305b06, 0xb7e8fda220541ed0, 0x4817025ddfabe12f, 0, 0 }, /* #78 */
    { 0x323ed2, 0x323ed2, 0x22dc9810b34abc83, 0xdd2367ef4cb5437c, 0, 0 }, /* #79 */
    { 0x364517, 0x364517, 0xf996aa1272352659, 0x066955ed8dcad9a6, 0, 0 }, /* #80 */
    { 0x085b52, 0x085b52, 0xde2d20a04ec35880, 0x21d2df5fb13ca77f, 0, 0 }, /* #81 */
    { 0x270a53, 0x270a53, 0x1780fdd2c7e0dd75, 0xe87f022d381f228a, 0, 0 }, /* #82 */
    { 0x315147, 0x315147, 0xe4c3d2a2ebe5bdcc, 0x1b3c2d5d141a4233, 0, 0 }, /* #83 */
    { 0x303e43, 0x303e43, 0xcf49273660a8778f, 0x30b6d8c99f578870, 0, 0 }, /* #84 */
    { 0x3523d3, 0x3523d3, 0x075df64321c9fed1, 0xf8a209bcde36012e, 0, 0 }, /* #85 */
    { 0x137ac7, 0x137ac7, 0x5f852bdc0ee88a57, 0xa07ad423f11775a8, 0, 0 }, /* #86 */
    { 0x156a06, 0x156a06, 0xe4f9d645f5e0e1ec, 0x1b0629ba0a1f1e13, 0, 0 }, /* #87 */
    { 0x376ec6, 0x376ec6, 0xbe4bff6e908f2efb, 0x41b400916f70d104, 0, 0 }, /* #88 */
    { 0x1d5287, 0x1d5287, 0xe3c6927bb1dd1d3b, 0x1c396d844e22e2c4, 0, 0 }, /* #89 */
    { 0x0125c2, 0x0125c2, 0x959dc2819d19b19f, 0x6a623d7e62e64e60, 0, 0 }, /* #90 */
    { 0x1b36d2, 0x1b36d2, 0xa83884b1719b2f3d, 0x57c77b4e8e64d0c2, 0, 0 }, /* #91 */
    { 0x180a87, 0x180a87, 0x69a630979cdf7a98, 0x9659cf6863208567, 0, 0 }, /* #92 */
    { 0x052202, 0x052202, 0x8796e747f33e7a4f, 0x786918b80cc185b0, 0, 0 }, /* #93 */
    { 0x3d4592, 0x3d4592, 0xe46f60ba3e6dcbdd, 0x1b909f45c1923422, 0, 0 }, /* #94 */
    { 0x367043, 0x367043, 0x48d5fec266c6d051, 0xb72a013d99392fae, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_not_u64_locked = RT_ELEMENTS(g_aTests_not_u64_locked);

BINU64_TEST_T const g_aTests_neg_u64[] =
{
    { 0x186007, 0x186017, 0xab2101ab9ed49da1, 0x54defe54612b625f, 0, 0 }, /* #0 */
    { 0x055596, 0x055517, 0x922ae45584f48bad, 0x6dd51baa7b0b7453, 0, 0 }, /* #1 */
    { 0x096952, 0x096113, 0xf91ad8ae23ad33ce, 0x06e52751dc52cc32, 0, 0 }, /* #2 */
    { 0x020c52, 0x020497, 0x5349dba3650128dc, 0xacb6245c9afed724, 0, 0 }, /* #3 */
    { 0x394b42, 0x394397, 0x7acdd8ad0f9fdfbf, 0x85322752f0602041, 0, 0 }, /* #4 */
    { 0x1c7603, 0x1c7697, 0x6488eb80a3104b18, 0x9b77147f5cefb4e8, 0, 0 }, /* #5 */
    { 0x2b0716, 0x2b0717, 0xd91b5c3c8d4d7b0b, 0x26e4a3c372b284f5, 0, 0 }, /* #6 */
    { 0x1a4053, 0x1a4093, 0x6e6f3828e2be662d, 0x9190c7d71d4199d3, 0, 0 }, /* #7 */
    { 0x370e86, 0x370697, 0x24c6a1ec0f045131, 0xdb395e13f0fbaecf, 0, 0 }, /* #8 */
    { 0x254ed2, 0x254617, 0x8f5d597492cf3088, 0x70a2a68b6d30cf78, 0, 0 }, /* #9 */
    { 0x2b0847, 0x2b0097, 0x7cbbeba0e0e39daa, 0x8344145f1f1c6256, 0, 0 }, /* #10 */
    { 0x082b57, 0x082317, 0xa77110924fe0b69b, 0x588eef6db01f4965, 0, 0 }, /* #11 */
    { 0x315587, 0x315513, 0x9556cd431533b3ea, 0x6aa932bceacc4c16, 0, 0 }, /* #12 */
    { 0x084f86, 0x084797, 0x03bf01457065422c, 0xfc40feba8f9abdd4, 0, 0 }, /* #13 */
    { 0x341487, 0x341493, 0x601bd18191058dff, 0x9fe42e7e6efa7201, 0, 0 }, /* #14 */
    { 0x0b0342, 0x0b0397, 0x19f8a0ff4276d878, 0xe6075f00bd892788, 0, 0 }, /* #15 */
    { 0x080a03, 0x080213, 0xd70f3c21f0bb5614, 0x28f0c3de0f44a9ec, 0, 0 }, /* #16 */
    { 0x3464d6, 0x346413, 0xf8a7d2431eb54e1a, 0x07582dbce14ab1e6, 0, 0 }, /* #17 */
    { 0x210686, 0x210617, 0xea441e72888fd7d9, 0x15bbe18d77702827, 0, 0 }, /* #18 */
    { 0x3c1416, 0x3c1413, 0xf9567409a77dc102, 0x06a98bf658823efe, 0, 0 }, /* #19 */
    { 0x363052, 0x363093, 0x610ae16208ecaccf, 0x9ef51e9df7135331, 0, 0 }, /* #20 */
    { 0x2136c2, 0x213697, 0x3e689cebd11f8d7e, 0xc19763142ee07282, 0, 0 }, /* #21 */
    { 0x3c3f57, 0x3c3793, 0x4aa07d4b1607911d, 0xb55f82b4e9f86ee3, 0, 0 }, /* #22 */
    { 0x1f1983, 0x1f1113, 0xe8596287c81be576, 0x17a69d7837e41a8a, 0, 0 }, /* #23 */
    { 0x2979d2, 0x297113, 0xf0c62a14a81e9ae7, 0x0f39d5eb57e16519, 0, 0 }, /* #24 */
    { 0x120e47, 0x120697, 0x509183f5c3072af7, 0xaf6e7c0a3cf8d509, 0, 0 }, /* #25 */
    { 0x3b7102, 0x3b7193, 0x3336811829d0edb4, 0xccc97ee7d62f124c, 0, 0 }, /* #26 */
    { 0x112242, 0x112297, 0x5d50dd1640a832ab, 0xa2af22e9bf57cd55, 0, 0 }, /* #27 */
    { 0x0b5e83, 0x0b5613, 0xd140a758e59cb768, 0x2ebf58a71a634898, 0, 0 }, /* #28 */
    { 0x204857, 0x204097, 0x75acd844fdced87e, 0x8a5327bb02312782, 0, 0 }, /* #29 */
    { 0x2c03d2, 0x2c0313, 0xd509cde2dc5b04d4, 0x2af6321d23a4fb2c, 0, 0 }, /* #30 */
    { 0x1a7953, 0x1a7117, 0x86b33622f3f5f79d, 0x794cc9dd0c0a0863, 0, 0 }, /* #31 */
    { 0x1c3647, 0x1c3697, 0x139cbc89a1a9a7cd, 0xec6343765e565833, 0, 0 }, /* #32 */
    { 0x066d56, 0x066593, 0x15506e94eed9e452, 0xeaaf916b11261bae, 0, 0 }, /* #33 */
    { 0x276203, 0x276293, 0x4ca9deb153e8eb21, 0xb356214eac1714df, 0, 0 }, /* #34 */
    { 0x092fc2, 0x092797, 0x22e85b09dbca1b3b, 0xdd17a4f62435e4c5, 0, 0 }, /* #35 */
    { 0x330cd3, 0x330417, 0xadc537966bef8fb2, 0x523ac8699410704e, 0, 0 }, /* #36 */
    { 0x2c1913, 0x2c1197, 0x12196cd89457fd28, 0xede693276ba802d8, 0, 0 }, /* #37 */
    { 0x3523c6, 0x352307, 0xa363ba03b528c9d0, 0x5c9c45fc4ad73630, 0, 0 }, /* #38 */
    { 0x1c6ad3, 0x1c6213, 0xddb7ac14c6014281, 0x224853eb39febd7f, 0, 0 }, /* #39 */
    { 0x0776d3, 0x077617, 0xdd25147edfdd922c, 0x22daeb8120226dd4, 0, 0 }, /* #40 */
    { 0x1d1b13, 0x1d1317, 0xa33952b9277e2e25, 0x5cc6ad46d881d1db, 0, 0 }, /* #41 */
    { 0x1c2c57, 0x1c2413, 0xe55b5823254cffa8, 0x1aa4a7dcdab30058, 0, 0 }, /* #42 */
    { 0x1a5a46, 0x1a5217, 0xe90a8cd1c29543d2, 0x16f5732e3d6abc2e, 0, 0 }, /* #43 */
    { 0x1c7057, 0x1c7017, 0x8787eaf8942f9129, 0x787815076bd06ed7, 0, 0 }, /* #44 */
    { 0x380246, 0x380213, 0x82bc948fffbeb30f, 0x7d436b7000414cf1, 0, 0 }, /* #45 */
    { 0x0a4982, 0x0a4117, 0x909789b79951628e, 0x6f68764866ae9d72, 0, 0 }, /* #46 */
    { 0x216157, 0x216193, 0x0144353aeb63b7a5, 0xfebbcac5149c485b, 0, 0 }, /* #47 */
    { 0x115712, 0x115797, 0x102feb1f21d9ecca, 0xefd014e0de261336, 0, 0 }, /* #48 */
    { 0x125fc6, 0x125717, 0x895c237a29c4c842, 0x76a3dc85d63b37be, 0, 0 }, /* #49 */
    { 0x1e6153, 0x1e6117, 0xdbfb34df1aa09688, 0x2404cb20e55f6978, 0, 0 }, /* #50 */
    { 0x3a7086, 0x3a7013, 0xc4ac8aeccbd7d298, 0x3b53751334282d68, 0, 0 }, /* #51 */
    { 0x292917, 0x292103, 0x9152318d5d825e80, 0x6eadce72a27da180, 0, 0 }, /* #52 */
    { 0x297dd7, 0x297597, 0x49c6cfa7fb69a1ee, 0xb639305804965e12, 0, 0 }, /* #53 */
    { 0x083f16, 0x083717, 0xbf5369418758ca6a, 0x40ac96be78a73596, 0, 0 }, /* #54 */
    { 0x266c57, 0x266493, 0x20d646146c87060e, 0xdf29b9eb9378f9f2, 0, 0 }, /* #55 */
    { 0x046e52, 0x046613, 0xf14cf566e812d014, 0x0eb30a9917ed2fec, 0, 0 }, /* #56 */
    { 0x1a0017, 0x1a0097, 0x1ff7c2eba701286d, 0xe0083d1458fed793, 0, 0 }, /* #57 */
    { 0x161c56, 0x161497, 0x586f573c219440c4, 0xa790a8c3de6bbf3c, 0, 0 }, /* #58 */
    { 0x2a72d2, 0x2a7293, 0x45ce9222bf129814, 0xba316ddd40ed67ec, 0, 0 }, /* #59 */
    { 0x2b0f87, 0x2b0717, 0xbc37971b340a939a, 0x43c868e4cbf56c66, 0, 0 }, /* #60 */
    { 0x0b2212, 0x0b2297, 0x6514bcf9475dcfab, 0x9aeb4306b8a23055, 0, 0 }, /* #61 */
    { 0x0f1992, 0x0f1117, 0xdd4ad5e509a55651, 0x22b52a1af65aa9af, 0, 0 }, /* #62 */
    { 0x195fd6, 0x195717, 0xd8e2117b0bb2cc8e, 0x271dee84f44d3372, 0, 0 }, /* #63 */
    { 0x202042, 0x202093, 0x52555e8d1df94027, 0xadaaa172e206bfd9, 0, 0 }, /* #64 */
    { 0x194853, 0x194097, 0x4832b12f9b4830e8, 0xb7cd4ed064b7cf18, 0, 0 }, /* #65 */
    { 0x2b4892, 0x2b4013, 0xb3df1d023791e824, 0x4c20e2fdc86e17dc, 0, 0 }, /* #66 */
    { 0x291bd3, 0x291393, 0x08999e0d48439c5e, 0xf76661f2b7bc63a2, 0, 0 }, /* #67 */
    { 0x175882, 0x175017, 0x83c7df4dffeacc42, 0x7c3820b2001533be, 0, 0 }, /* #68 */
    { 0x0d7d57, 0x0d7513, 0xc03a860b27eba4bb, 0x3fc579f4d8145b45, 0, 0 }, /* #69 */
    { 0x2d2b42, 0x2d2313, 0x995d31bf02aa2c44, 0x66a2ce40fd55d3bc, 0, 0 }, /* #70 */
    { 0x3969d2, 0x396187, 0x0258ce0e8ab4be40, 0xfda731f1754b41c0, 0, 0 }, /* #71 */
    { 0x2c5c06, 0x2c5493, 0x72094efeb690c39f, 0x8df6b101496f3c61, 0, 0 }, /* #72 */
    { 0x2b5292, 0x2b5217, 0x8caf47d1a8a02737, 0x7350b82e575fd8c9, 0, 0 }, /* #73 */
    { 0x253e46, 0x253617, 0xd57ad758c29d711f, 0x2a8528a73d628ee1, 0, 0 }, /* #74 */
    { 0x332193, 0x332113, 0xd2ba8e670131943c, 0x2d457198fece6bc4, 0, 0 }, /* #75 */
    { 0x264356, 0x264393, 0x07bfef302f35423f, 0xf84010cfd0cabdc1, 0, 0 }, /* #76 */
    { 0x1c0803, 0x1c0097, 0x3b765003d5d6e0b8, 0xc489affc2a291f48, 0, 0 }, /* #77 */
    { 0x334202, 0x334217, 0x8020fe3bacf01512, 0x7fdf01c4530feaee, 0, 0 }, /* #78 */
    { 0x1226d7, 0x122617, 0x98fd5c40c0826fb5, 0x6702a3bf3f7d904b, 0, 0 }, /* #79 */
    { 0x331ad3, 0x331217, 0xb4090c7132f567a1, 0x4bf6f38ecd0a985f, 0, 0 }, /* #80 */
    { 0x190cd3, 0x190417, 0xdcd65927fd2db11f, 0x2329a6d802d24ee1, 0, 0 }, /* #81 */
    { 0x394a47, 0x394213, 0xa5df881586ded9c2, 0x5a2077ea7921263e, 0, 0 }, /* #82 */
    { 0x256306, 0x256393, 0x4b2dea4cdeeed1e7, 0xb4d215b321112e19, 0, 0 }, /* #83 */
    { 0x290b92, 0x290397, 0x0951bdf1eb877a22, 0xf6ae420e147885de, 0, 0 }, /* #84 */
    { 0x066a07, 0x066293, 0x4d861a9845bc355f, 0xb279e567ba43caa1, 0, 0 }, /* #85 */
    { 0x2778d3, 0x277093, 0x023a7b775ae4db9c, 0xfdc58488a51b2464, 0, 0 }, /* #86 */
    { 0x145007, 0x145017, 0xbc8f1aa8f9477567, 0x4370e55706b88a99, 0, 0 }, /* #87 */
    { 0x037ad2, 0x037297, 0x0065a7136a55ec34, 0xff9a58ec95aa13cc, 0, 0 }, /* #88 */
    { 0x010443, 0x010493, 0x0ff523a759b6ea26, 0xf00adc58a64915da, 0, 0 }, /* #89 */
    { 0x3d2b46, 0x3d2393, 0x73c57120626d3065, 0x8c3a8edf9d92cf9b, 0, 0 }, /* #90 */
    { 0x357d52, 0x357513, 0xa1ea927bc663941b, 0x5e156d84399c6be5, 0, 0 }, /* #91 */
    { 0x1f4493, 0x1f4417, 0xf566ad722b6f0925, 0x0a99528dd490f6db, 0, 0 }, /* #92 */
    { 0x0d67c3, 0x0d6713, 0xeb5b82a65b70c0b7, 0x14a47d59a48f3f49, 0, 0 }, /* #93 */
    { 0x0a62d3, 0x0a6297, 0x56c1251b2be3301f, 0xa93edae4d41ccfe1, 0, 0 }, /* #94 */
    { 0x235f12, 0x235793, 0x3968a5ba62109068, 0xc6975a459def6f98, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_neg_u64 = RT_ELEMENTS(g_aTests_neg_u64);

BINU64_TEST_T const g_aTests_neg_u64_locked[] =
{
    { 0x3c3346, 0x3c3393, 0x3d4ede6c35be7202, 0xc2b12193ca418dfe, 0, 0 }, /* #0 */
    { 0x2324d7, 0x232413, 0x9a051a5b31b524e4, 0x65fae5a4ce4adb1c, 0, 0 }, /* #1 */
    { 0x2237d3, 0x223793, 0x7203c8104c440159, 0x8dfc37efb3bbfea7, 0, 0 }, /* #2 */
    { 0x1e66d3, 0x1e6617, 0x9f1c363f58a31983, 0x60e3c9c0a75ce67d, 0, 0 }, /* #3 */
    { 0x145b96, 0x145317, 0xfa5f8d33d5c31d31, 0x05a072cc2a3ce2cf, 0, 0 }, /* #4 */
    { 0x010c03, 0x010493, 0x22a1a256fb2b9cc3, 0xdd5e5da904d4633d, 0, 0 }, /* #5 */
    { 0x194346, 0x194317, 0xf6241b9ae91b64fb, 0x09dbe46516e49b05, 0, 0 }, /* #6 */
    { 0x127247, 0x127297, 0x3c85271a9c9a74a1, 0xc37ad8e563658b5f, 0, 0 }, /* #7 */
    { 0x1234c3, 0x123497, 0x21e9907bfd813831, 0xde166f84027ec7cf, 0, 0 }, /* #8 */
    { 0x072117, 0x072113, 0xc990cbbeec8d25b4, 0x366f34411372da4c, 0, 0 }, /* #9 */
    { 0x010fd6, 0x010713, 0xe5831655a3110c87, 0x1a7ce9aa5ceef379, 0, 0 }, /* #10 */
    { 0x1f12d6, 0x1f1297, 0x023c1c7bce5b36ab, 0xfdc3e38431a4c955, 0, 0 }, /* #11 */
    { 0x395ad6, 0x395297, 0x27bb5758632ee2bc, 0xd844a8a79cd11d44, 0, 0 }, /* #12 */
    { 0x386347, 0x386397, 0x61abdc1f0c600fad, 0x9e5423e0f39ff053, 0, 0 }, /* #13 */
    { 0x272e57, 0x272613, 0x8e0d9a42ffe69169, 0x71f265bd00196e97, 0, 0 }, /* #14 */
    { 0x0560d7, 0x056017, 0xa9d8b5afc2e83fb2, 0x56274a503d17c04e, 0, 0 }, /* #15 */
    { 0x1f2e93, 0x1f2613, 0x842a4618dc274d02, 0x7bd5b9e723d8b2fe, 0, 0 }, /* #16 */
    { 0x267043, 0x267097, 0x5f1e7efe5e8df906, 0xa0e18101a17206fa, 0, 0 }, /* #17 */
    { 0x270fd6, 0x270797, 0x4e9c21a994f0ae43, 0xb163de566b0f51bd, 0, 0 }, /* #18 */
    { 0x097bc6, 0x097397, 0x1554f3bd42dd09ad, 0xeaab0c42bd22f653, 0, 0 }, /* #19 */
    { 0x102486, 0x102417, 0xe27e4b2df58def1e, 0x1d81b4d20a7210e2, 0, 0 }, /* #20 */
    { 0x3178d7, 0x317093, 0x38fd7b51792aa7ba, 0xc70284ae86d55846, 0, 0 }, /* #21 */
    { 0x142c16, 0x142417, 0x9f55f771cde58d8e, 0x60aa088e321a7272, 0, 0 }, /* #22 */
    { 0x3d7092, 0x3d7093, 0x72efd21ec7589e7a, 0x8d102de138a76186, 0, 0 }, /* #23 */
    { 0x021946, 0x021113, 0x93e6653a453cc853, 0x6c199ac5bac337ad, 0, 0 }, /* #24 */
    { 0x0a5f87, 0x0a5713, 0xc29e1794d6c20b9c, 0x3d61e86b293df464, 0, 0 }, /* #25 */
    { 0x1c3087, 0x1c3097, 0x44ccd37283865c9b, 0xbb332c8d7c79a365, 0, 0 }, /* #26 */
    { 0x120282, 0x120293, 0x00dc1740bd0d8e02, 0xff23e8bf42f271fe, 0, 0 }, /* #27 */
    { 0x371957, 0x371117, 0xc7b757d7a0815c12, 0x3848a8285f7ea3ee, 0, 0 }, /* #28 */
    { 0x2b4012, 0x2b4013, 0xfb3e01663f9d7552, 0x04c1fe99c0628aae, 0, 0 }, /* #29 */
    { 0x3f5503, 0x3f5517, 0x949d1170f17f9bde, 0x6b62ee8f0e806422, 0, 0 }, /* #30 */
    { 0x147906, 0x147117, 0xb18a3918127606cb, 0x4e75c6e7ed89f935, 0, 0 }, /* #31 */
    { 0x3a0506, 0x3a0513, 0xd7f25bb14953b763, 0x280da44eb6ac489d, 0, 0 }, /* #32 */
    { 0x0545c3, 0x054513, 0xa726cef51661e853, 0x58d9310ae99e17ad, 0, 0 }, /* #33 */
    { 0x031183, 0x031117, 0xa52db9fa1773e0d8, 0x5ad24605e88c1f28, 0, 0 }, /* #34 */
    { 0x302757, 0x302797, 0x759ab800132970cd, 0x8a6547ffecd68f33, 0, 0 }, /* #35 */
    { 0x003b03, 0x003317, 0xcae694eda225eab5, 0x35196b125dda154b, 0, 0 }, /* #36 */
    { 0x2603d7, 0x260313, 0xf5be3edc477628c8, 0x0a41c123b889d738, 0, 0 }, /* #37 */
    { 0x3e4a12, 0x3e4293, 0x444f6408086b932a, 0xbbb09bf7f7946cd6, 0, 0 }, /* #38 */
    { 0x2d7246, 0x2d7297, 0x6ee72a3dbba65ac4, 0x9118d5c24459a53c, 0, 0 }, /* #39 */
    { 0x046f17, 0x046703, 0xd9ee97fa17c86ff0, 0x26116805e8379010, 0, 0 }, /* #40 */
    { 0x3a0302, 0x3a0313, 0xce5e246c6e7a7f58, 0x31a1db93918580a8, 0, 0 }, /* #41 */
    { 0x041d57, 0x041593, 0x38deef43951d7a3c, 0xc72110bc6ae285c4, 0, 0 }, /* #42 */
    { 0x0d71c2, 0x0d7197, 0x584e4a8aa2c11b9d, 0xa7b1b5755d3ee463, 0, 0 }, /* #43 */
    { 0x2705c3, 0x270513, 0xed52be1efbd53638, 0x12ad41e1042ac9c8, 0, 0 }, /* #44 */
    { 0x3974c3, 0x397413, 0xeff1a3bbe7a38641, 0x100e5c44185c79bf, 0, 0 }, /* #45 */
    { 0x091a43, 0x091293, 0x34f0c8e74956a7dd, 0xcb0f3718b6a95823, 0, 0 }, /* #46 */
    { 0x2c27d7, 0x2c2793, 0x26d7f6c3862584b4, 0xd928093c79da7b4c, 0, 0 }, /* #47 */
    { 0x191b02, 0x191397, 0x605b3cff5a81fa82, 0x9fa4c300a57e057e, 0, 0 }, /* #48 */
    { 0x1d7416, 0x1d7497, 0x7c36c9f7dc508089, 0x83c9360823af7f77, 0, 0 }, /* #49 */
    { 0x167f56, 0x167793, 0x160be40538067b1b, 0xe9f41bfac7f984e5, 0, 0 }, /* #50 */
    { 0x2f1fd6, 0x2f1797, 0x5363e98160ddc201, 0xac9c167e9f223dff, 0, 0 }, /* #51 */
    { 0x045d02, 0x045517, 0xbdabb75973d477cd, 0x425448a68c2b8833, 0, 0 }, /* #52 */
    { 0x312403, 0x312493, 0x33ad46850e3e8841, 0xcc52b97af1c177bf, 0, 0 }, /* #53 */
    { 0x135213, 0x135293, 0x709f63135c8a15f5, 0x8f609ceca375ea0b, 0, 0 }, /* #54 */
    { 0x125017, 0x125093, 0x35cb3d5b209cdb7b, 0xca34c2a4df632485, 0, 0 }, /* #55 */
    { 0x225713, 0x225793, 0x5f72fada17117f47, 0xa08d0525e8ee80b9, 0, 0 }, /* #56 */
    { 0x307196, 0x307117, 0xad53ecc4a0fbfa2e, 0x52ac133b5f0405d2, 0, 0 }, /* #57 */
    { 0x003252, 0x003217, 0xd1ba3f9d59fdeba4, 0x2e45c062a602145c, 0, 0 }, /* #58 */
    { 0x235613, 0x235693, 0x213102e305aba858, 0xdecefd1cfa5457a8, 0, 0 }, /* #59 */
    { 0x0225c3, 0x022513, 0xb54ae7c134aa9dda, 0x4ab5183ecb556226, 0, 0 }, /* #60 */
    { 0x026616, 0x026693, 0x61376eaa8516df2a, 0x9ec891557ae920d6, 0, 0 }, /* #61 */
    { 0x2d52c3, 0x2d5217, 0xc77dc589e9132aa4, 0x38823a7616ecd55c, 0, 0 }, /* #62 */
    { 0x393c06, 0x393497, 0x57b85cb39167ef4c, 0xa847a34c6e9810b4, 0, 0 }, /* #63 */
    { 0x084087, 0x084093, 0x55430e8790d965ac, 0xaabcf1786f269a54, 0, 0 }, /* #64 */
    { 0x140f82, 0x140793, 0x7a5dc5e70826e4e6, 0x85a23a18f7d91b1a, 0, 0 }, /* #65 */
    { 0x373f92, 0x373793, 0x7c1e9cb455e9facc, 0x83e1634baa160534, 0, 0 }, /* #66 */
    { 0x381a92, 0x381287, 0x6d80a9eec8fef440, 0x927f561137010bc0, 0, 0 }, /* #67 */
    { 0x2f70d6, 0x2f7097, 0x0bd8c99cc3db662c, 0xf42736633c2499d4, 0, 0 }, /* #68 */
    { 0x187387, 0x187397, 0x43b8a8143b2fb078, 0xbc4757ebc4d04f88, 0, 0 }, /* #69 */
    { 0x0e20c7, 0x0e2017, 0xa2e9bb91a8b53aa7, 0x5d16446e574ac559, 0, 0 }, /* #70 */
    { 0x017ed2, 0x017697, 0x04eeaa6e9c1b3b4f, 0xfb11559163e4c4b1, 0, 0 }, /* #71 */
    { 0x370b86, 0x370397, 0x1852e9275b574d9b, 0xe7ad16d8a4a8b265, 0, 0 }, /* #72 */
    { 0x3f11c2, 0x3f1193, 0x15538bfe73428674, 0xeaac74018cbd798c, 0, 0 }, /* #73 */
    { 0x293012, 0x293097, 0x525f95f573a63672, 0xada06a0a8c59c98e, 0, 0 }, /* #74 */
    { 0x1f3f06, 0x1f3793, 0x5669b21bbbb11c4b, 0xa9964de4444ee3b5, 0, 0 }, /* #75 */
    { 0x3d0597, 0x3d0513, 0xe586147fb3bc14f3, 0x1a79eb804c43eb0d, 0, 0 }, /* #76 */
    { 0x303683, 0x303697, 0x562eaef5028c15a1, 0xa9d1510afd73ea5f, 0, 0 }, /* #77 */
    { 0x1c7442, 0x1c7497, 0x760b2d49fb6ced3a, 0x89f4d2b6049312c6, 0, 0 }, /* #78 */
    { 0x0830d7, 0x083097, 0x315b593df261122c, 0xcea4a6c20d9eedd4, 0, 0 }, /* #79 */
    { 0x3b2807, 0x3b2013, 0xc88f2c8ae36ed2ff, 0x3770d3751c912d01, 0, 0 }, /* #80 */
    { 0x064383, 0x064393, 0x6c7bc5ca2786bbac, 0x93843a35d8794454, 0, 0 }, /* #81 */
    { 0x2a2d87, 0x2a2517, 0xc8dc847e176eacc4, 0x37237b81e891533c, 0, 0 }, /* #82 */
    { 0x203a16, 0x203293, 0x6d127aab4ecd216f, 0x92ed8554b132de91, 0, 0 }, /* #83 */
    { 0x0b1cd3, 0x0b1417, 0xba08efceb9115cb3, 0x45f7103146eea34d, 0, 0 }, /* #84 */
    { 0x0d4916, 0x0d4113, 0x88906f044dbbecb6, 0x776f90fbb244134a, 0, 0 }, /* #85 */
    { 0x1c5e12, 0x1c5613, 0xc87e97d54c673f6c, 0x3781682ab398c094, 0, 0 }, /* #86 */
    { 0x0a7686, 0x0a7617, 0xeb8707ad98b8b33a, 0x1478f85267474cc6, 0, 0 }, /* #87 */
    { 0x0e37d2, 0x0e3797, 0x31cf82db0ee27df4, 0xce307d24f11d820c, 0, 0 }, /* #88 */
    { 0x2b6c82, 0x2b6493, 0x098ccad1e16bbff2, 0xf673352e1e94400e, 0, 0 }, /* #89 */
    { 0x282252, 0x282213, 0x8ae806ead37a2af9, 0x7517f9152c85d507, 0, 0 }, /* #90 */
    { 0x1a1446, 0x1a1493, 0x2d459e212fb7f159, 0xd2ba61ded0480ea7, 0, 0 }, /* #91 */
    { 0x333cc2, 0x333417, 0xaa9e66f42bfa147f, 0x5561990bd405eb81, 0, 0 }, /* #92 */
    { 0x112152, 0x112113, 0xbc687fc40d65f216, 0x4397803bf29a0dea, 0, 0 }, /* #93 */
    { 0x371402, 0x371413, 0x82bc5d50e4f4b8a2, 0x7d43a2af1b0b475e, 0, 0 }, /* #94 */
    { 0x3b7186, 0x3b7197, 0x762714fdb8623806, 0x89d8eb02479dc7fa, 0, 0 }, /* #95 */
};
uint32_t const g_cTests_neg_u64_locked = RT_ELEMENTS(g_aTests_neg_u64_locked);


/* end of file */
