/* $Id: tstIEMAImplDataFpuOther-Intel.cpp $ */
/** @file
 * IEM Assembly Instruction Helper Testcase Data Intel - r150967 on Intel(R) Core(TM) i9-10980XE CPU @ 3.00GHz.
 */

/*
 * Copyright (C) 2022 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#include "tstIEMAImpl.h"

FPU_UNARY_R80_TEST_T const g_aTests_f2xm1_r80_intel[] =
{
    { 0x007f, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/0/0/m = #0 */
    { 0x0000, 0x84e3, 0xbca0, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/0/0/u = #1 */
    { 0x0020, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/0/0/0x20 = #2 */
    { 0x017f, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/0/1/m = #3 */
    { 0x0100, 0x84e3, 0xbca0, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/0/1/u = #4 */
    { 0x0120, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/0/1/0x20 = #5 */
    { 0x027f, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/0/2/m = #6 */
    { 0x0200, 0x84e3, 0xbca0, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/0/2/u = #7 */
    { 0x0220, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/0/2/0x20 = #8 */
    { 0x037f, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/0/3/m = #9 */
    { 0x0300, 0x84e3, 0xbca0, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/0/3/u = #10 */
    { 0x0320, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/0/3/0x20 = #11 */
    { 0x047f, 0x84e3, 0x3e20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d0a,2831) }, /* #0/1/0/m = #12 */
    { 0x0400, 0x84e3, 0xbea0, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d0a,2831) }, /* #0/1/0/u = #13 */
    { 0x0420, 0x84e3, 0x3e20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d0a,2831) }, /* #0/1/0/0x20 = #14 */
    { 0x057f, 0x84e3, 0x3e20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d0a,2831) }, /* #0/1/1/m = #15 */
    { 0x0500, 0x84e3, 0xbea0, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d0a,2831) }, /* #0/1/1/u = #16 */
    { 0x0520, 0x84e3, 0x3e20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d0a,2831) }, /* #0/1/1/0x20 = #17 */
    { 0x067f, 0x84e3, 0x3e20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d0a,2831) }, /* #0/1/2/m = #18 */
    { 0x0600, 0x84e3, 0xbea0, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d0a,2831) }, /* #0/1/2/u = #19 */
    { 0x0620, 0x84e3, 0x3e20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d0a,2831) }, /* #0/1/2/0x20 = #20 */
    { 0x077f, 0x84e3, 0x3e20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d0a,2831) }, /* #0/1/3/m = #21 */
    { 0x0700, 0x84e3, 0xbea0, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d0a,2831) }, /* #0/1/3/u = #22 */
    { 0x0720, 0x84e3, 0x3e20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d0a,2831) }, /* #0/1/3/0x20 = #23 */
    { 0x087f, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/2/0/m = #24 */
    { 0x0800, 0x84e3, 0xbca0, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/2/0/u = #25 */
    { 0x0820, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/2/0/0x20 = #26 */
    { 0x097f, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/2/1/m = #27 */
    { 0x0900, 0x84e3, 0xbca0, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/2/1/u = #28 */
    { 0x0920, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/2/1/0x20 = #29 */
    { 0x0a7f, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/2/2/m = #30 */
    { 0x0a00, 0x84e3, 0xbca0, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/2/2/u = #31 */
    { 0x0a20, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/2/2/0x20 = #32 */
    { 0x0b7f, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/2/3/m = #33 */
    { 0x0b00, 0x84e3, 0xbca0, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/2/3/u = #34 */
    { 0x0b20, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/2/3/0x20 = #35 */
    { 0x0c7f, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/3/0/m = #36 */
    { 0x0c00, 0x84e3, 0xbca0, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/3/0/u = #37 */
    { 0x0c20, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/3/0/0x20 = #38 */
    { 0x0d7f, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/3/1/m = #39 */
    { 0x0d00, 0x84e3, 0xbca0, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/3/1/u = #40 */
    { 0x0d20, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/3/1/0x20 = #41 */
    { 0x0e7f, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/3/2/m = #42 */
    { 0x0e00, 0x84e3, 0xbca0, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/3/2/u = #43 */
    { 0x0e20, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/3/2/0x20 = #44 */
    { 0x0f7f, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/3/3/m = #45 */
    { 0x0f00, 0x84e3, 0xbca0, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/3/3/u = #46 */
    { 0x0f20, 0x84e3, 0x3c20, RTFLOAT80U_INIT_C(1,0xfe11153ef3e59833,2831), RTFLOAT80U_INIT_C(1,0xb01b0b1578485d09,2831) }, /* #0/3/3/0x20 = #47 */
    { 0x007f, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/0/0/m = #48 */
    { 0x0000, 0xe002, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/0/0/u = #49 */
    { 0x0020, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/0/0/0x20 = #50 */
    { 0x017f, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/0/1/m = #51 */
    { 0x0100, 0xe002, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/0/1/u = #52 */
    { 0x0120, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/0/1/0x20 = #53 */
    { 0x027f, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/0/2/m = #54 */
    { 0x0200, 0xe002, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/0/2/u = #55 */
    { 0x0220, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/0/2/0x20 = #56 */
    { 0x037f, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/0/3/m = #57 */
    { 0x0300, 0xe002, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/0/3/u = #58 */
    { 0x0320, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/0/3/0x20 = #59 */
    { 0x047f, 0xe002, 0x7a20, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dae,2391) }, /* #1/1/0/m = #60 */
    { 0x0400, 0xe002, 0xfaa0, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dae,2391) }, /* #1/1/0/u = #61 */
    { 0x0420, 0xe002, 0x7a20, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dae,2391) }, /* #1/1/0/0x20 = #62 */
    { 0x057f, 0xe002, 0x7a20, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dae,2391) }, /* #1/1/1/m = #63 */
    { 0x0500, 0xe002, 0xfaa0, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dae,2391) }, /* #1/1/1/u = #64 */
    { 0x0520, 0xe002, 0x7a20, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dae,2391) }, /* #1/1/1/0x20 = #65 */
    { 0x067f, 0xe002, 0x7a20, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dae,2391) }, /* #1/1/2/m = #66 */
    { 0x0600, 0xe002, 0xfaa0, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dae,2391) }, /* #1/1/2/u = #67 */
    { 0x0620, 0xe002, 0x7a20, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dae,2391) }, /* #1/1/2/0x20 = #68 */
    { 0x077f, 0xe002, 0x7a20, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dae,2391) }, /* #1/1/3/m = #69 */
    { 0x0700, 0xe002, 0xfaa0, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dae,2391) }, /* #1/1/3/u = #70 */
    { 0x0720, 0xe002, 0x7a20, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dae,2391) }, /* #1/1/3/0x20 = #71 */
    { 0x087f, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/2/0/m = #72 */
    { 0x0800, 0xe002, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/2/0/u = #73 */
    { 0x0820, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/2/0/0x20 = #74 */
    { 0x097f, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/2/1/m = #75 */
    { 0x0900, 0xe002, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/2/1/u = #76 */
    { 0x0920, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/2/1/0x20 = #77 */
    { 0x0a7f, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/2/2/m = #78 */
    { 0x0a00, 0xe002, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/2/2/u = #79 */
    { 0x0a20, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/2/2/0x20 = #80 */
    { 0x0b7f, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/2/3/m = #81 */
    { 0x0b00, 0xe002, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/2/3/u = #82 */
    { 0x0b20, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/2/3/0x20 = #83 */
    { 0x0c7f, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/3/0/m = #84 */
    { 0x0c00, 0xe002, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/3/0/u = #85 */
    { 0x0c20, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/3/0/0x20 = #86 */
    { 0x0d7f, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/3/1/m = #87 */
    { 0x0d00, 0xe002, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/3/1/u = #88 */
    { 0x0d20, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/3/1/0x20 = #89 */
    { 0x0e7f, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/3/2/m = #90 */
    { 0x0e00, 0xe002, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/3/2/u = #91 */
    { 0x0e20, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/3/2/0x20 = #92 */
    { 0x0f7f, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/3/3/m = #93 */
    { 0x0f00, 0xe002, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/3/3/u = #94 */
    { 0x0f20, 0xe002, 0x7820, RTFLOAT80U_INIT_C(1,0xe1810aaf1222d3b7,2391), RTFLOAT80U_INIT_C(1,0x9c4eb8f6b1c84dad,2391) }, /* #1/3/3/0x20 = #95 */
    { 0x007f, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/0/0/m = #96 */
    { 0x0000, 0xcc62, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/0/0/u = #97 */
    { 0x0020, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/0/0/0x20 = #98 */
    { 0x017f, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/0/1/m = #99 */
    { 0x0100, 0xcc62, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/0/1/u = #100 */
    { 0x0120, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/0/1/0x20 = #101 */
    { 0x027f, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/0/2/m = #102 */
    { 0x0200, 0xcc62, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/0/2/u = #103 */
    { 0x0220, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/0/2/0x20 = #104 */
    { 0x037f, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/0/3/m = #105 */
    { 0x0300, 0xcc62, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/0/3/u = #106 */
    { 0x0320, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/0/3/0x20 = #107 */
    { 0x047f, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/1/0/m = #108 */
    { 0x0400, 0xcc62, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/1/0/u = #109 */
    { 0x0420, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/1/0/0x20 = #110 */
    { 0x057f, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/1/1/m = #111 */
    { 0x0500, 0xcc62, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/1/1/u = #112 */
    { 0x0520, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/1/1/0x20 = #113 */
    { 0x067f, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/1/2/m = #114 */
    { 0x0600, 0xcc62, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/1/2/u = #115 */
    { 0x0620, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/1/2/0x20 = #116 */
    { 0x077f, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/1/3/m = #117 */
    { 0x0700, 0xcc62, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/1/3/u = #118 */
    { 0x0720, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/1/3/0x20 = #119 */
    { 0x087f, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/2/0/m = #120 */
    { 0x0800, 0xcc62, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/2/0/u = #121 */
    { 0x0820, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/2/0/0x20 = #122 */
    { 0x097f, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/2/1/m = #123 */
    { 0x0900, 0xcc62, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/2/1/u = #124 */
    { 0x0920, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/2/1/0x20 = #125 */
    { 0x0a7f, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/2/2/m = #126 */
    { 0x0a00, 0xcc62, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/2/2/u = #127 */
    { 0x0a20, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/2/2/0x20 = #128 */
    { 0x0b7f, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/2/3/m = #129 */
    { 0x0b00, 0xcc62, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/2/3/u = #130 */
    { 0x0b20, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/2/3/0x20 = #131 */
    { 0x0c7f, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/3/0/m = #132 */
    { 0x0c00, 0xcc62, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/3/0/u = #133 */
    { 0x0c20, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/3/0/0x20 = #134 */
    { 0x0d7f, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/3/1/m = #135 */
    { 0x0d00, 0xcc62, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/3/1/u = #136 */
    { 0x0d20, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/3/1/0x20 = #137 */
    { 0x0e7f, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/3/2/m = #138 */
    { 0x0e00, 0xcc62, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/3/2/u = #139 */
    { 0x0e20, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/3/2/0x20 = #140 */
    { 0x0f7f, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/3/3/m = #141 */
    { 0x0f00, 0xcc62, 0xfca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/3/3/u = #142 */
    { 0x0f20, 0xcc62, 0x7c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766) }, /* #2/3/3/0x20 = #143 */
    { 0x007f, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/0/0/m = #144 */
    { 0x0000, 0xd729, 0xfd81, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_C(1,0xf967,11139) }, /* #3/0/0/u = #145 */
    { 0x0001, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/0/0/0x1 = #146 */
    { 0x017f, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/0/1/m = #147 */
    { 0x0100, 0xd729, 0xfd81, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_C(1,0xf967,11139) }, /* #3/0/1/u = #148 */
    { 0x0101, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/0/1/0x1 = #149 */
    { 0x027f, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/0/2/m = #150 */
    { 0x0200, 0xd729, 0xfd81, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_C(1,0xf967,11139) }, /* #3/0/2/u = #151 */
    { 0x0201, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/0/2/0x1 = #152 */
    { 0x037f, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/0/3/m = #153 */
    { 0x0300, 0xd729, 0xfd81, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_C(1,0xf967,11139) }, /* #3/0/3/u = #154 */
    { 0x0301, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/0/3/0x1 = #155 */
    { 0x047f, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/1/0/m = #156 */
    { 0x0400, 0xd729, 0xfd81, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_C(1,0xf967,11139) }, /* #3/1/0/u = #157 */
    { 0x0401, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/1/0/0x1 = #158 */
    { 0x057f, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/1/1/m = #159 */
    { 0x0500, 0xd729, 0xfd81, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_C(1,0xf967,11139) }, /* #3/1/1/u = #160 */
    { 0x0501, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/1/1/0x1 = #161 */
    { 0x067f, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/1/2/m = #162 */
    { 0x0600, 0xd729, 0xfd81, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_C(1,0xf967,11139) }, /* #3/1/2/u = #163 */
    { 0x0601, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/1/2/0x1 = #164 */
    { 0x077f, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/1/3/m = #165 */
    { 0x0700, 0xd729, 0xfd81, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_C(1,0xf967,11139) }, /* #3/1/3/u = #166 */
    { 0x0701, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/1/3/0x1 = #167 */
    { 0x087f, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/2/0/m = #168 */
    { 0x0800, 0xd729, 0xfd81, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_C(1,0xf967,11139) }, /* #3/2/0/u = #169 */
    { 0x0801, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/2/0/0x1 = #170 */
    { 0x097f, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/2/1/m = #171 */
    { 0x0900, 0xd729, 0xfd81, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_C(1,0xf967,11139) }, /* #3/2/1/u = #172 */
    { 0x0901, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/2/1/0x1 = #173 */
    { 0x0a7f, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/2/2/m = #174 */
    { 0x0a00, 0xd729, 0xfd81, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_C(1,0xf967,11139) }, /* #3/2/2/u = #175 */
    { 0x0a01, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/2/2/0x1 = #176 */
    { 0x0b7f, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/2/3/m = #177 */
    { 0x0b00, 0xd729, 0xfd81, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_C(1,0xf967,11139) }, /* #3/2/3/u = #178 */
    { 0x0b01, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/2/3/0x1 = #179 */
    { 0x0c7f, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/3/0/m = #180 */
    { 0x0c00, 0xd729, 0xfd81, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_C(1,0xf967,11139) }, /* #3/3/0/u = #181 */
    { 0x0c01, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/3/0/0x1 = #182 */
    { 0x0d7f, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/3/1/m = #183 */
    { 0x0d00, 0xd729, 0xfd81, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_C(1,0xf967,11139) }, /* #3/3/1/u = #184 */
    { 0x0d01, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/3/1/0x1 = #185 */
    { 0x0e7f, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/3/2/m = #186 */
    { 0x0e00, 0xd729, 0xfd81, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_C(1,0xf967,11139) }, /* #3/3/2/u = #187 */
    { 0x0e01, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/3/2/0x1 = #188 */
    { 0x0f7f, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/3/3/m = #189 */
    { 0x0f00, 0xd729, 0xfd81, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_C(1,0xf967,11139) }, /* #3/3/3/u = #190 */
    { 0x0f01, 0xd729, 0x7d01, RTFLOAT80U_INIT_C(1,0xf967,11139), RTFLOAT80U_INIT_IND(1) }, /* #3/3/3/0x1 = #191 */
    { 0x007f, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/0/0/m = #192 */
    { 0x0000, 0x3067, 0xb881, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411) }, /* #4/0/0/u = #193 */
    { 0x0001, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/0/0/0x1 = #194 */
    { 0x017f, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/0/1/m = #195 */
    { 0x0100, 0x3067, 0xb881, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411) }, /* #4/0/1/u = #196 */
    { 0x0101, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/0/1/0x1 = #197 */
    { 0x027f, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/0/2/m = #198 */
    { 0x0200, 0x3067, 0xb881, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411) }, /* #4/0/2/u = #199 */
    { 0x0201, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/0/2/0x1 = #200 */
    { 0x037f, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/0/3/m = #201 */
    { 0x0300, 0x3067, 0xb881, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411) }, /* #4/0/3/u = #202 */
    { 0x0301, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/0/3/0x1 = #203 */
    { 0x047f, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/1/0/m = #204 */
    { 0x0400, 0x3067, 0xb881, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411) }, /* #4/1/0/u = #205 */
    { 0x0401, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/1/0/0x1 = #206 */
    { 0x057f, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/1/1/m = #207 */
    { 0x0500, 0x3067, 0xb881, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411) }, /* #4/1/1/u = #208 */
    { 0x0501, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/1/1/0x1 = #209 */
    { 0x067f, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/1/2/m = #210 */
    { 0x0600, 0x3067, 0xb881, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411) }, /* #4/1/2/u = #211 */
    { 0x0601, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/1/2/0x1 = #212 */
    { 0x077f, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/1/3/m = #213 */
    { 0x0700, 0x3067, 0xb881, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411) }, /* #4/1/3/u = #214 */
    { 0x0701, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/1/3/0x1 = #215 */
    { 0x087f, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/2/0/m = #216 */
    { 0x0800, 0x3067, 0xb881, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411) }, /* #4/2/0/u = #217 */
    { 0x0801, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/2/0/0x1 = #218 */
    { 0x097f, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/2/1/m = #219 */
    { 0x0900, 0x3067, 0xb881, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411) }, /* #4/2/1/u = #220 */
    { 0x0901, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/2/1/0x1 = #221 */
    { 0x0a7f, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/2/2/m = #222 */
    { 0x0a00, 0x3067, 0xb881, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411) }, /* #4/2/2/u = #223 */
    { 0x0a01, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/2/2/0x1 = #224 */
    { 0x0b7f, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/2/3/m = #225 */
    { 0x0b00, 0x3067, 0xb881, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411) }, /* #4/2/3/u = #226 */
    { 0x0b01, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/2/3/0x1 = #227 */
    { 0x0c7f, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/3/0/m = #228 */
    { 0x0c00, 0x3067, 0xb881, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411) }, /* #4/3/0/u = #229 */
    { 0x0c01, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/3/0/0x1 = #230 */
    { 0x0d7f, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/3/1/m = #231 */
    { 0x0d00, 0x3067, 0xb881, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411) }, /* #4/3/1/u = #232 */
    { 0x0d01, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/3/1/0x1 = #233 */
    { 0x0e7f, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/3/2/m = #234 */
    { 0x0e00, 0x3067, 0xb881, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411) }, /* #4/3/2/u = #235 */
    { 0x0e01, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/3/2/0x1 = #236 */
    { 0x0f7f, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/3/3/m = #237 */
    { 0x0f00, 0x3067, 0xb881, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411) }, /* #4/3/3/u = #238 */
    { 0x0f01, 0x3067, 0x3801, RTFLOAT80U_INIT_C(1,0x48b21a16464cfb48,29411), RTFLOAT80U_INIT_IND(1) }, /* #4/3/3/0x1 = #239 */
    { 0x007f, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/0/0/m = #240 */
    { 0x0000, 0xe4b3, 0xfc81, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767) }, /* #5/0/0/u = #241 */
    { 0x0001, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/0/0/0x1 = #242 */
    { 0x017f, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/0/1/m = #243 */
    { 0x0100, 0xe4b3, 0xfc81, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767) }, /* #5/0/1/u = #244 */
    { 0x0101, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/0/1/0x1 = #245 */
    { 0x027f, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/0/2/m = #246 */
    { 0x0200, 0xe4b3, 0xfc81, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767) }, /* #5/0/2/u = #247 */
    { 0x0201, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/0/2/0x1 = #248 */
    { 0x037f, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/0/3/m = #249 */
    { 0x0300, 0xe4b3, 0xfc81, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767) }, /* #5/0/3/u = #250 */
    { 0x0301, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/0/3/0x1 = #251 */
    { 0x047f, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/1/0/m = #252 */
    { 0x0400, 0xe4b3, 0xfc81, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767) }, /* #5/1/0/u = #253 */
    { 0x0401, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/1/0/0x1 = #254 */
    { 0x057f, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/1/1/m = #255 */
    { 0x0500, 0xe4b3, 0xfc81, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767) }, /* #5/1/1/u = #256 */
    { 0x0501, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/1/1/0x1 = #257 */
    { 0x067f, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/1/2/m = #258 */
    { 0x0600, 0xe4b3, 0xfc81, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767) }, /* #5/1/2/u = #259 */
    { 0x0601, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/1/2/0x1 = #260 */
    { 0x077f, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/1/3/m = #261 */
    { 0x0700, 0xe4b3, 0xfc81, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767) }, /* #5/1/3/u = #262 */
    { 0x0701, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/1/3/0x1 = #263 */
    { 0x087f, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/2/0/m = #264 */
    { 0x0800, 0xe4b3, 0xfc81, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767) }, /* #5/2/0/u = #265 */
    { 0x0801, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/2/0/0x1 = #266 */
    { 0x097f, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/2/1/m = #267 */
    { 0x0900, 0xe4b3, 0xfc81, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767) }, /* #5/2/1/u = #268 */
    { 0x0901, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/2/1/0x1 = #269 */
    { 0x0a7f, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/2/2/m = #270 */
    { 0x0a00, 0xe4b3, 0xfc81, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767) }, /* #5/2/2/u = #271 */
    { 0x0a01, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/2/2/0x1 = #272 */
    { 0x0b7f, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/2/3/m = #273 */
    { 0x0b00, 0xe4b3, 0xfc81, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767) }, /* #5/2/3/u = #274 */
    { 0x0b01, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/2/3/0x1 = #275 */
    { 0x0c7f, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/3/0/m = #276 */
    { 0x0c00, 0xe4b3, 0xfc81, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767) }, /* #5/3/0/u = #277 */
    { 0x0c01, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/3/0/0x1 = #278 */
    { 0x0d7f, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/3/1/m = #279 */
    { 0x0d00, 0xe4b3, 0xfc81, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767) }, /* #5/3/1/u = #280 */
    { 0x0d01, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/3/1/0x1 = #281 */
    { 0x0e7f, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/3/2/m = #282 */
    { 0x0e00, 0xe4b3, 0xfc81, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767) }, /* #5/3/2/u = #283 */
    { 0x0e01, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/3/2/0x1 = #284 */
    { 0x0f7f, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/3/3/m = #285 */
    { 0x0f00, 0xe4b3, 0xfc81, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767) }, /* #5/3/3/u = #286 */
    { 0x0f01, 0xe4b3, 0x7c01, RTFLOAT80U_INIT_C(1,0x80000000000001fd,32767), RTFLOAT80U_INIT_C(1,0xc0000000000001fd,32767) }, /* #5/3/3/0x1 = #287 */
    { 0x007f, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/0/0/m = #288 */
    { 0x0000, 0x990f, 0xb981, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767) }, /* #6/0/0/u = #289 */
    { 0x0001, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/0/0/0x1 = #290 */
    { 0x017f, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/0/1/m = #291 */
    { 0x0100, 0x990f, 0xb981, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767) }, /* #6/0/1/u = #292 */
    { 0x0101, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/0/1/0x1 = #293 */
    { 0x027f, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/0/2/m = #294 */
    { 0x0200, 0x990f, 0xb981, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767) }, /* #6/0/2/u = #295 */
    { 0x0201, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/0/2/0x1 = #296 */
    { 0x037f, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/0/3/m = #297 */
    { 0x0300, 0x990f, 0xb981, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767) }, /* #6/0/3/u = #298 */
    { 0x0301, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/0/3/0x1 = #299 */
    { 0x047f, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/1/0/m = #300 */
    { 0x0400, 0x990f, 0xb981, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767) }, /* #6/1/0/u = #301 */
    { 0x0401, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/1/0/0x1 = #302 */
    { 0x057f, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/1/1/m = #303 */
    { 0x0500, 0x990f, 0xb981, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767) }, /* #6/1/1/u = #304 */
    { 0x0501, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/1/1/0x1 = #305 */
    { 0x067f, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/1/2/m = #306 */
    { 0x0600, 0x990f, 0xb981, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767) }, /* #6/1/2/u = #307 */
    { 0x0601, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/1/2/0x1 = #308 */
    { 0x077f, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/1/3/m = #309 */
    { 0x0700, 0x990f, 0xb981, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767) }, /* #6/1/3/u = #310 */
    { 0x0701, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/1/3/0x1 = #311 */
    { 0x087f, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/2/0/m = #312 */
    { 0x0800, 0x990f, 0xb981, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767) }, /* #6/2/0/u = #313 */
    { 0x0801, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/2/0/0x1 = #314 */
    { 0x097f, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/2/1/m = #315 */
    { 0x0900, 0x990f, 0xb981, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767) }, /* #6/2/1/u = #316 */
    { 0x0901, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/2/1/0x1 = #317 */
    { 0x0a7f, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/2/2/m = #318 */
    { 0x0a00, 0x990f, 0xb981, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767) }, /* #6/2/2/u = #319 */
    { 0x0a01, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/2/2/0x1 = #320 */
    { 0x0b7f, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/2/3/m = #321 */
    { 0x0b00, 0x990f, 0xb981, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767) }, /* #6/2/3/u = #322 */
    { 0x0b01, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/2/3/0x1 = #323 */
    { 0x0c7f, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/3/0/m = #324 */
    { 0x0c00, 0x990f, 0xb981, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767) }, /* #6/3/0/u = #325 */
    { 0x0c01, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/3/0/0x1 = #326 */
    { 0x0d7f, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/3/1/m = #327 */
    { 0x0d00, 0x990f, 0xb981, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767) }, /* #6/3/1/u = #328 */
    { 0x0d01, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/3/1/0x1 = #329 */
    { 0x0e7f, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/3/2/m = #330 */
    { 0x0e00, 0x990f, 0xb981, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767) }, /* #6/3/2/u = #331 */
    { 0x0e01, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/3/2/0x1 = #332 */
    { 0x0f7f, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/3/3/m = #333 */
    { 0x0f00, 0x990f, 0xb981, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767) }, /* #6/3/3/u = #334 */
    { 0x0f01, 0x990f, 0x3901, RTFLOAT80U_INIT_C(1,0x9e09087f377c3d96,32767), RTFLOAT80U_INIT_C(1,0xde09087f377c3d96,32767) }, /* #6/3/3/0x1 = #335 */
    { 0x007f, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/0/0/m = #336 */
    { 0x0000, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/0/0/u = #337 */
    { 0x017f, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/0/1/m = #338 */
    { 0x0100, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/0/1/u = #339 */
    { 0x027f, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/0/2/m = #340 */
    { 0x0200, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/0/2/u = #341 */
    { 0x037f, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/0/3/m = #342 */
    { 0x0300, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/0/3/u = #343 */
    { 0x047f, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/1/0/m = #344 */
    { 0x0400, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/1/0/u = #345 */
    { 0x057f, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/1/1/m = #346 */
    { 0x0500, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/1/1/u = #347 */
    { 0x067f, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/1/2/m = #348 */
    { 0x0600, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/1/2/u = #349 */
    { 0x077f, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/1/3/m = #350 */
    { 0x0700, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/1/3/u = #351 */
    { 0x087f, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/2/0/m = #352 */
    { 0x0800, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/2/0/u = #353 */
    { 0x097f, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/2/1/m = #354 */
    { 0x0900, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/2/1/u = #355 */
    { 0x0a7f, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/2/2/m = #356 */
    { 0x0a00, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/2/2/u = #357 */
    { 0x0b7f, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/2/3/m = #358 */
    { 0x0b00, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/2/3/u = #359 */
    { 0x0c7f, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/3/0/m = #360 */
    { 0x0c00, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/3/0/u = #361 */
    { 0x0d7f, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/3/1/m = #362 */
    { 0x0d00, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/3/1/u = #363 */
    { 0x0e7f, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/3/2/m = #364 */
    { 0x0e00, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/3/2/u = #365 */
    { 0x0f7f, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/3/3/m = #366 */
    { 0x0f00, 0x3088, 0x3800, RTFLOAT80U_INIT_C(1,0xc000164250679845,32767), RTFLOAT80U_INIT_C(1,0xc000164250679845,32767) }, /* #7/3/3/u = #367 */
    { 0x007f, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/0/0/m = #368 */
    { 0x0000, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/0/0/u = #369 */
    { 0x017f, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/0/1/m = #370 */
    { 0x0100, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/0/1/u = #371 */
    { 0x027f, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/0/2/m = #372 */
    { 0x0200, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/0/2/u = #373 */
    { 0x037f, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/0/3/m = #374 */
    { 0x0300, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/0/3/u = #375 */
    { 0x047f, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/1/0/m = #376 */
    { 0x0400, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/1/0/u = #377 */
    { 0x057f, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/1/1/m = #378 */
    { 0x0500, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/1/1/u = #379 */
    { 0x067f, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/1/2/m = #380 */
    { 0x0600, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/1/2/u = #381 */
    { 0x077f, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/1/3/m = #382 */
    { 0x0700, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/1/3/u = #383 */
    { 0x087f, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/2/0/m = #384 */
    { 0x0800, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/2/0/u = #385 */
    { 0x097f, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/2/1/m = #386 */
    { 0x0900, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/2/1/u = #387 */
    { 0x0a7f, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/2/2/m = #388 */
    { 0x0a00, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/2/2/u = #389 */
    { 0x0b7f, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/2/3/m = #390 */
    { 0x0b00, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/2/3/u = #391 */
    { 0x0c7f, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/3/0/m = #392 */
    { 0x0c00, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/3/0/u = #393 */
    { 0x0d7f, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/3/1/m = #394 */
    { 0x0d00, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/3/1/u = #395 */
    { 0x0e7f, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/3/2/m = #396 */
    { 0x0e00, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/3/2/u = #397 */
    { 0x0f7f, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/3/3/m = #398 */
    { 0x0f00, 0x9c6c, 0x3c00, RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767), RTFLOAT80U_INIT_C(1,0xe005c4fc8de8a108,32767) }, /* #8/3/3/u = #399 */
    { 0x007f, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/0/0/m = #400 */
    { 0x0000, 0xe225, 0xf881, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767) }, /* #9/0/0/u = #401 */
    { 0x0001, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/0/0/0x1 = #402 */
    { 0x017f, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/0/1/m = #403 */
    { 0x0100, 0xe225, 0xf881, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767) }, /* #9/0/1/u = #404 */
    { 0x0101, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/0/1/0x1 = #405 */
    { 0x027f, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/0/2/m = #406 */
    { 0x0200, 0xe225, 0xf881, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767) }, /* #9/0/2/u = #407 */
    { 0x0201, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/0/2/0x1 = #408 */
    { 0x037f, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/0/3/m = #409 */
    { 0x0300, 0xe225, 0xf881, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767) }, /* #9/0/3/u = #410 */
    { 0x0301, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/0/3/0x1 = #411 */
    { 0x047f, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/1/0/m = #412 */
    { 0x0400, 0xe225, 0xf881, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767) }, /* #9/1/0/u = #413 */
    { 0x0401, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/1/0/0x1 = #414 */
    { 0x057f, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/1/1/m = #415 */
    { 0x0500, 0xe225, 0xf881, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767) }, /* #9/1/1/u = #416 */
    { 0x0501, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/1/1/0x1 = #417 */
    { 0x067f, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/1/2/m = #418 */
    { 0x0600, 0xe225, 0xf881, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767) }, /* #9/1/2/u = #419 */
    { 0x0601, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/1/2/0x1 = #420 */
    { 0x077f, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/1/3/m = #421 */
    { 0x0700, 0xe225, 0xf881, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767) }, /* #9/1/3/u = #422 */
    { 0x0701, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/1/3/0x1 = #423 */
    { 0x087f, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/2/0/m = #424 */
    { 0x0800, 0xe225, 0xf881, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767) }, /* #9/2/0/u = #425 */
    { 0x0801, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/2/0/0x1 = #426 */
    { 0x097f, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/2/1/m = #427 */
    { 0x0900, 0xe225, 0xf881, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767) }, /* #9/2/1/u = #428 */
    { 0x0901, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/2/1/0x1 = #429 */
    { 0x0a7f, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/2/2/m = #430 */
    { 0x0a00, 0xe225, 0xf881, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767) }, /* #9/2/2/u = #431 */
    { 0x0a01, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/2/2/0x1 = #432 */
    { 0x0b7f, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/2/3/m = #433 */
    { 0x0b00, 0xe225, 0xf881, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767) }, /* #9/2/3/u = #434 */
    { 0x0b01, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/2/3/0x1 = #435 */
    { 0x0c7f, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/3/0/m = #436 */
    { 0x0c00, 0xe225, 0xf881, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767) }, /* #9/3/0/u = #437 */
    { 0x0c01, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/3/0/0x1 = #438 */
    { 0x0d7f, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/3/1/m = #439 */
    { 0x0d00, 0xe225, 0xf881, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767) }, /* #9/3/1/u = #440 */
    { 0x0d01, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/3/1/0x1 = #441 */
    { 0x0e7f, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/3/2/m = #442 */
    { 0x0e00, 0xe225, 0xf881, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767) }, /* #9/3/2/u = #443 */
    { 0x0e01, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/3/2/0x1 = #444 */
    { 0x0f7f, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/3/3/m = #445 */
    { 0x0f00, 0xe225, 0xf881, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767) }, /* #9/3/3/u = #446 */
    { 0x0f01, 0xe225, 0x7801, RTFLOAT80U_INIT_C(0,0x1d1ef86571b42,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/3/3/0x1 = #447 */
    { 0x007f, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/0/m = #448 */
    { 0x0000, 0x2ac9, 0xb881, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767) }, /* #10/0/0/u = #449 */
    { 0x0001, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/0/0x1 = #450 */
    { 0x017f, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/1/m = #451 */
    { 0x0100, 0x2ac9, 0xb881, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767) }, /* #10/0/1/u = #452 */
    { 0x0101, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/1/0x1 = #453 */
    { 0x027f, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/2/m = #454 */
    { 0x0200, 0x2ac9, 0xb881, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767) }, /* #10/0/2/u = #455 */
    { 0x0201, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/2/0x1 = #456 */
    { 0x037f, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/3/m = #457 */
    { 0x0300, 0x2ac9, 0xb881, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767) }, /* #10/0/3/u = #458 */
    { 0x0301, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/3/0x1 = #459 */
    { 0x047f, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/0/m = #460 */
    { 0x0400, 0x2ac9, 0xb881, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767) }, /* #10/1/0/u = #461 */
    { 0x0401, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/0/0x1 = #462 */
    { 0x057f, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/1/m = #463 */
    { 0x0500, 0x2ac9, 0xb881, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767) }, /* #10/1/1/u = #464 */
    { 0x0501, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/1/0x1 = #465 */
    { 0x067f, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/2/m = #466 */
    { 0x0600, 0x2ac9, 0xb881, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767) }, /* #10/1/2/u = #467 */
    { 0x0601, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/2/0x1 = #468 */
    { 0x077f, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/3/m = #469 */
    { 0x0700, 0x2ac9, 0xb881, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767) }, /* #10/1/3/u = #470 */
    { 0x0701, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/3/0x1 = #471 */
    { 0x087f, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/0/m = #472 */
    { 0x0800, 0x2ac9, 0xb881, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767) }, /* #10/2/0/u = #473 */
    { 0x0801, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/0/0x1 = #474 */
    { 0x097f, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/1/m = #475 */
    { 0x0900, 0x2ac9, 0xb881, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767) }, /* #10/2/1/u = #476 */
    { 0x0901, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/1/0x1 = #477 */
    { 0x0a7f, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/2/m = #478 */
    { 0x0a00, 0x2ac9, 0xb881, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767) }, /* #10/2/2/u = #479 */
    { 0x0a01, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/2/0x1 = #480 */
    { 0x0b7f, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/3/m = #481 */
    { 0x0b00, 0x2ac9, 0xb881, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767) }, /* #10/2/3/u = #482 */
    { 0x0b01, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/3/0x1 = #483 */
    { 0x0c7f, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/0/m = #484 */
    { 0x0c00, 0x2ac9, 0xb881, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767) }, /* #10/3/0/u = #485 */
    { 0x0c01, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/0/0x1 = #486 */
    { 0x0d7f, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/1/m = #487 */
    { 0x0d00, 0x2ac9, 0xb881, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767) }, /* #10/3/1/u = #488 */
    { 0x0d01, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/1/0x1 = #489 */
    { 0x0e7f, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/2/m = #490 */
    { 0x0e00, 0x2ac9, 0xb881, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767) }, /* #10/3/2/u = #491 */
    { 0x0e01, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/2/0x1 = #492 */
    { 0x0f7f, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/3/m = #493 */
    { 0x0f00, 0x2ac9, 0xb881, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767) }, /* #10/3/3/u = #494 */
    { 0x0f01, 0x2ac9, 0x3801, RTFLOAT80U_INIT_C(1,0x1d36ab3cdcb08f85,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/3/0x1 = #495 */
    { 0x007f, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/0/0/m = #496 */
    { 0x0000, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/0/0/u = #497 */
    { 0x0032, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/0/0/0x32 = #498 */
    { 0x0030, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/0/0/u0x2 = #499 */
    { 0x0022, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0xb172196880cfe9ce,24576) }, /* #11/0/0/u0x10 = #500 */
    { 0x0012, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/0/0/u0x20 = #501 */
    { 0x017f, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/0/1/m = #502 */
    { 0x0100, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/0/1/u = #503 */
    { 0x0132, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/0/1/0x32 = #504 */
    { 0x0130, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/0/1/u0x2 = #505 */
    { 0x0122, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0xb172196880cfe9ce,24576) }, /* #11/0/1/u0x10 = #506 */
    { 0x0112, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/0/1/u0x20 = #507 */
    { 0x027f, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/0/2/m = #508 */
    { 0x0200, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/0/2/u = #509 */
    { 0x0232, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/0/2/0x32 = #510 */
    { 0x0230, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/0/2/u0x2 = #511 */
    { 0x0222, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0xb172196880cfe9ce,24576) }, /* #11/0/2/u0x10 = #512 */
    { 0x0212, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/0/2/u0x20 = #513 */
    { 0x037f, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/0/3/m = #514 */
    { 0x0300, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/0/3/u = #515 */
    { 0x0332, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/0/3/0x32 = #516 */
    { 0x0330, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/0/3/u0x2 = #517 */
    { 0x0322, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0xb172196880cfe9ce,24576) }, /* #11/0/3/u0x10 = #518 */
    { 0x0312, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/0/3/u0x20 = #519 */
    { 0x047f, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/1/0/m = #520 */
    { 0x0400, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/1/0/u = #521 */
    { 0x0432, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/1/0/0x32 = #522 */
    { 0x0430, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/1/0/u0x2 = #523 */
    { 0x0422, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0xb172196880cfe9ce,24576) }, /* #11/1/0/u0x10 = #524 */
    { 0x0412, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/1/0/u0x20 = #525 */
    { 0x057f, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/1/1/m = #526 */
    { 0x0500, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/1/1/u = #527 */
    { 0x0532, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/1/1/0x32 = #528 */
    { 0x0530, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/1/1/u0x2 = #529 */
    { 0x0522, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0xb172196880cfe9ce,24576) }, /* #11/1/1/u0x10 = #530 */
    { 0x0512, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/1/1/u0x20 = #531 */
    { 0x067f, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/1/2/m = #532 */
    { 0x0600, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/1/2/u = #533 */
    { 0x0632, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/1/2/0x32 = #534 */
    { 0x0630, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/1/2/u0x2 = #535 */
    { 0x0622, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0xb172196880cfe9ce,24576) }, /* #11/1/2/u0x10 = #536 */
    { 0x0612, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/1/2/u0x20 = #537 */
    { 0x077f, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/1/3/m = #538 */
    { 0x0700, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/1/3/u = #539 */
    { 0x0732, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/1/3/0x32 = #540 */
    { 0x0730, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/1/3/u0x2 = #541 */
    { 0x0722, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0xb172196880cfe9ce,24576) }, /* #11/1/3/u0x10 = #542 */
    { 0x0712, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/1/3/u0x20 = #543 */
    { 0x087f, 0x4db8, 0x7f32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e8,0) }, /* #11/2/0/m = #544 */
    { 0x0800, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/2/0/u = #545 */
    { 0x0832, 0x4db8, 0x7f32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e8,0) }, /* #11/2/0/0x32 = #546 */
    { 0x0830, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/2/0/u0x2 = #547 */
    { 0x0822, 0x4db8, 0xffb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0xb172196880cfe9cf,24576) }, /* #11/2/0/u0x10 = #548 */
    { 0x0812, 0x4db8, 0xffb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e8,0) }, /* #11/2/0/u0x20 = #549 */
    { 0x097f, 0x4db8, 0x7f32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e8,0) }, /* #11/2/1/m = #550 */
    { 0x0900, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/2/1/u = #551 */
    { 0x0932, 0x4db8, 0x7f32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e8,0) }, /* #11/2/1/0x32 = #552 */
    { 0x0930, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/2/1/u0x2 = #553 */
    { 0x0922, 0x4db8, 0xffb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0xb172196880cfe9cf,24576) }, /* #11/2/1/u0x10 = #554 */
    { 0x0912, 0x4db8, 0xffb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e8,0) }, /* #11/2/1/u0x20 = #555 */
    { 0x0a7f, 0x4db8, 0x7f32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e8,0) }, /* #11/2/2/m = #556 */
    { 0x0a00, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/2/2/u = #557 */
    { 0x0a32, 0x4db8, 0x7f32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e8,0) }, /* #11/2/2/0x32 = #558 */
    { 0x0a30, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/2/2/u0x2 = #559 */
    { 0x0a22, 0x4db8, 0xffb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0xb172196880cfe9cf,24576) }, /* #11/2/2/u0x10 = #560 */
    { 0x0a12, 0x4db8, 0xffb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e8,0) }, /* #11/2/2/u0x20 = #561 */
    { 0x0b7f, 0x4db8, 0x7f32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e8,0) }, /* #11/2/3/m = #562 */
    { 0x0b00, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/2/3/u = #563 */
    { 0x0b32, 0x4db8, 0x7f32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e8,0) }, /* #11/2/3/0x32 = #564 */
    { 0x0b30, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/2/3/u0x2 = #565 */
    { 0x0b22, 0x4db8, 0xffb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0xb172196880cfe9cf,24576) }, /* #11/2/3/u0x10 = #566 */
    { 0x0b12, 0x4db8, 0xffb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e8,0) }, /* #11/2/3/u0x20 = #567 */
    { 0x0c7f, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/3/0/m = #568 */
    { 0x0c00, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/3/0/u = #569 */
    { 0x0c32, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/3/0/0x32 = #570 */
    { 0x0c30, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/3/0/u0x2 = #571 */
    { 0x0c22, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0xb172196880cfe9ce,24576) }, /* #11/3/0/u0x10 = #572 */
    { 0x0c12, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/3/0/u0x20 = #573 */
    { 0x0d7f, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/3/1/m = #574 */
    { 0x0d00, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/3/1/u = #575 */
    { 0x0d32, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/3/1/0x32 = #576 */
    { 0x0d30, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/3/1/u0x2 = #577 */
    { 0x0d22, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0xb172196880cfe9ce,24576) }, /* #11/3/1/u0x10 = #578 */
    { 0x0d12, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/3/1/u0x20 = #579 */
    { 0x0e7f, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/3/2/m = #580 */
    { 0x0e00, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/3/2/u = #581 */
    { 0x0e32, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/3/2/0x32 = #582 */
    { 0x0e30, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/3/2/u0x2 = #583 */
    { 0x0e22, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0xb172196880cfe9ce,24576) }, /* #11/3/2/u0x10 = #584 */
    { 0x0e12, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/3/2/u0x20 = #585 */
    { 0x0f7f, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/3/3/m = #586 */
    { 0x0f00, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/3/3/u = #587 */
    { 0x0f32, 0x4db8, 0x7d32, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/3/3/0x32 = #588 */
    { 0x0f30, 0x4db8, 0xfd82, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0) }, /* #11/3/3/u0x2 = #589 */
    { 0x0f22, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0xb172196880cfe9ce,24576) }, /* #11/3/3/u0x10 = #590 */
    { 0x0f12, 0x4db8, 0xfdb2, RTFLOAT80U_INIT_C(0,0x80000109f2f1bac9,0), RTFLOAT80U_INIT_C(0,0x58b90cb44067f4e7,0) }, /* #11/3/3/u0x20 = #591 */
    { 0x007f, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/0/0/m = #592 */
    { 0x0000, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/0/0/u = #593 */
    { 0x0032, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/0/0/0x32 = #594 */
    { 0x0030, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/0/0/u0x2 = #595 */
    { 0x0022, 0x83f9, 0xbbb2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0xcce69bd402f97405,24576) }, /* #12/0/0/u0x10 = #596 */
    { 0x0012, 0x83f9, 0xb9b2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/0/0/u0x20 = #597 */
    { 0x017f, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/0/1/m = #598 */
    { 0x0100, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/0/1/u = #599 */
    { 0x0132, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/0/1/0x32 = #600 */
    { 0x0130, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/0/1/u0x2 = #601 */
    { 0x0122, 0x83f9, 0xbbb2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0xcce69bd402f97405,24576) }, /* #12/0/1/u0x10 = #602 */
    { 0x0112, 0x83f9, 0xb9b2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/0/1/u0x20 = #603 */
    { 0x027f, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/0/2/m = #604 */
    { 0x0200, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/0/2/u = #605 */
    { 0x0232, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/0/2/0x32 = #606 */
    { 0x0230, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/0/2/u0x2 = #607 */
    { 0x0222, 0x83f9, 0xbbb2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0xcce69bd402f97405,24576) }, /* #12/0/2/u0x10 = #608 */
    { 0x0212, 0x83f9, 0xb9b2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/0/2/u0x20 = #609 */
    { 0x037f, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/0/3/m = #610 */
    { 0x0300, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/0/3/u = #611 */
    { 0x0332, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/0/3/0x32 = #612 */
    { 0x0330, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/0/3/u0x2 = #613 */
    { 0x0322, 0x83f9, 0xbbb2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0xcce69bd402f97405,24576) }, /* #12/0/3/u0x10 = #614 */
    { 0x0312, 0x83f9, 0xb9b2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/0/3/u0x20 = #615 */
    { 0x047f, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/1/0/m = #616 */
    { 0x0400, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/1/0/u = #617 */
    { 0x0432, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/1/0/0x32 = #618 */
    { 0x0430, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/1/0/u0x2 = #619 */
    { 0x0422, 0x83f9, 0xb9b2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0xcce69bd402f97404,24576) }, /* #12/1/0/u0x10 = #620 */
    { 0x0412, 0x83f9, 0xb9b2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/1/0/u0x20 = #621 */
    { 0x057f, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/1/1/m = #622 */
    { 0x0500, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/1/1/u = #623 */
    { 0x0532, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/1/1/0x32 = #624 */
    { 0x0530, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/1/1/u0x2 = #625 */
    { 0x0522, 0x83f9, 0xb9b2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0xcce69bd402f97404,24576) }, /* #12/1/1/u0x10 = #626 */
    { 0x0512, 0x83f9, 0xb9b2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/1/1/u0x20 = #627 */
    { 0x067f, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/1/2/m = #628 */
    { 0x0600, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/1/2/u = #629 */
    { 0x0632, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/1/2/0x32 = #630 */
    { 0x0630, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/1/2/u0x2 = #631 */
    { 0x0622, 0x83f9, 0xb9b2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0xcce69bd402f97404,24576) }, /* #12/1/2/u0x10 = #632 */
    { 0x0612, 0x83f9, 0xb9b2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/1/2/u0x20 = #633 */
    { 0x077f, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/1/3/m = #634 */
    { 0x0700, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/1/3/u = #635 */
    { 0x0732, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/1/3/0x32 = #636 */
    { 0x0730, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/1/3/u0x2 = #637 */
    { 0x0722, 0x83f9, 0xb9b2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0xcce69bd402f97404,24576) }, /* #12/1/3/u0x10 = #638 */
    { 0x0712, 0x83f9, 0xb9b2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/1/3/u0x20 = #639 */
    { 0x087f, 0x83f9, 0x3b32, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba03,0) }, /* #12/2/0/m = #640 */
    { 0x0800, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/2/0/u = #641 */
    { 0x0832, 0x83f9, 0x3b32, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba03,0) }, /* #12/2/0/0x32 = #642 */
    { 0x0830, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/2/0/u0x2 = #643 */
    { 0x0822, 0x83f9, 0xbbb2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0xcce69bd402f97405,24576) }, /* #12/2/0/u0x10 = #644 */
    { 0x0812, 0x83f9, 0xbbb2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba03,0) }, /* #12/2/0/u0x20 = #645 */
    { 0x097f, 0x83f9, 0x3b32, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba03,0) }, /* #12/2/1/m = #646 */
    { 0x0900, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/2/1/u = #647 */
    { 0x0932, 0x83f9, 0x3b32, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba03,0) }, /* #12/2/1/0x32 = #648 */
    { 0x0930, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/2/1/u0x2 = #649 */
    { 0x0922, 0x83f9, 0xbbb2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0xcce69bd402f97405,24576) }, /* #12/2/1/u0x10 = #650 */
    { 0x0912, 0x83f9, 0xbbb2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba03,0) }, /* #12/2/1/u0x20 = #651 */
    { 0x0a7f, 0x83f9, 0x3b32, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba03,0) }, /* #12/2/2/m = #652 */
    { 0x0a00, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/2/2/u = #653 */
    { 0x0a32, 0x83f9, 0x3b32, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba03,0) }, /* #12/2/2/0x32 = #654 */
    { 0x0a30, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/2/2/u0x2 = #655 */
    { 0x0a22, 0x83f9, 0xbbb2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0xcce69bd402f97405,24576) }, /* #12/2/2/u0x10 = #656 */
    { 0x0a12, 0x83f9, 0xbbb2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba03,0) }, /* #12/2/2/u0x20 = #657 */
    { 0x0b7f, 0x83f9, 0x3b32, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba03,0) }, /* #12/2/3/m = #658 */
    { 0x0b00, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/2/3/u = #659 */
    { 0x0b32, 0x83f9, 0x3b32, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba03,0) }, /* #12/2/3/0x32 = #660 */
    { 0x0b30, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/2/3/u0x2 = #661 */
    { 0x0b22, 0x83f9, 0xbbb2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0xcce69bd402f97405,24576) }, /* #12/2/3/u0x10 = #662 */
    { 0x0b12, 0x83f9, 0xbbb2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba03,0) }, /* #12/2/3/u0x20 = #663 */
    { 0x0c7f, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/3/0/m = #664 */
    { 0x0c00, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/3/0/u = #665 */
    { 0x0c32, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/3/0/0x32 = #666 */
    { 0x0c30, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/3/0/u0x2 = #667 */
    { 0x0c22, 0x83f9, 0xb9b2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0xcce69bd402f97404,24576) }, /* #12/3/0/u0x10 = #668 */
    { 0x0c12, 0x83f9, 0xb9b2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/3/0/u0x20 = #669 */
    { 0x0d7f, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/3/1/m = #670 */
    { 0x0d00, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/3/1/u = #671 */
    { 0x0d32, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/3/1/0x32 = #672 */
    { 0x0d30, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/3/1/u0x2 = #673 */
    { 0x0d22, 0x83f9, 0xb9b2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0xcce69bd402f97404,24576) }, /* #12/3/1/u0x10 = #674 */
    { 0x0d12, 0x83f9, 0xb9b2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/3/1/u0x20 = #675 */
    { 0x0e7f, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/3/2/m = #676 */
    { 0x0e00, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/3/2/u = #677 */
    { 0x0e32, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/3/2/0x32 = #678 */
    { 0x0e30, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/3/2/u0x2 = #679 */
    { 0x0e22, 0x83f9, 0xb9b2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0xcce69bd402f97404,24576) }, /* #12/3/2/u0x10 = #680 */
    { 0x0e12, 0x83f9, 0xb9b2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/3/2/u0x20 = #681 */
    { 0x0f7f, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/3/3/m = #682 */
    { 0x0f00, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/3/3/u = #683 */
    { 0x0f32, 0x83f9, 0x3932, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/3/3/0x32 = #684 */
    { 0x0f30, 0x83f9, 0xb982, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0) }, /* #12/3/3/u0x2 = #685 */
    { 0x0f22, 0x83f9, 0xb9b2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0xcce69bd402f97404,24576) }, /* #12/3/3/u0x10 = #686 */
    { 0x0f12, 0x83f9, 0xb9b2, RTFLOAT80U_INIT_C(0,0x93ce007e1d7c2015,0), RTFLOAT80U_INIT_C(0,0x66734dea017cba02,0) }, /* #12/3/3/u0x20 = #687 */
    { 0x007f, 0xb9f1, 0x3b32, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/0/0/m = #688 */
    { 0x0000, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/0/0/u = #689 */
    { 0x0032, 0xb9f1, 0x3b32, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/0/0/0x32 = #690 */
    { 0x0030, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/0/0/u0x2 = #691 */
    { 0x0022, 0xb9f1, 0xb9b2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0xc1b73d75fc73f7ed,24554) }, /* #13/0/0/u0x10 = #692 */
    { 0x0012, 0xb9f1, 0xbbb2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/0/0/u0x20 = #693 */
    { 0x017f, 0xb9f1, 0x3b32, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/0/1/m = #694 */
    { 0x0100, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/0/1/u = #695 */
    { 0x0132, 0xb9f1, 0x3b32, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/0/1/0x32 = #696 */
    { 0x0130, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/0/1/u0x2 = #697 */
    { 0x0122, 0xb9f1, 0xb9b2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0xc1b73d75fc73f7ed,24554) }, /* #13/0/1/u0x10 = #698 */
    { 0x0112, 0xb9f1, 0xbbb2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/0/1/u0x20 = #699 */
    { 0x027f, 0xb9f1, 0x3b32, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/0/2/m = #700 */
    { 0x0200, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/0/2/u = #701 */
    { 0x0232, 0xb9f1, 0x3b32, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/0/2/0x32 = #702 */
    { 0x0230, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/0/2/u0x2 = #703 */
    { 0x0222, 0xb9f1, 0xb9b2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0xc1b73d75fc73f7ed,24554) }, /* #13/0/2/u0x10 = #704 */
    { 0x0212, 0xb9f1, 0xbbb2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/0/2/u0x20 = #705 */
    { 0x037f, 0xb9f1, 0x3b32, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/0/3/m = #706 */
    { 0x0300, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/0/3/u = #707 */
    { 0x0332, 0xb9f1, 0x3b32, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/0/3/0x32 = #708 */
    { 0x0330, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/0/3/u0x2 = #709 */
    { 0x0322, 0xb9f1, 0xb9b2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0xc1b73d75fc73f7ed,24554) }, /* #13/0/3/u0x10 = #710 */
    { 0x0312, 0xb9f1, 0xbbb2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/0/3/u0x20 = #711 */
    { 0x047f, 0xb9f1, 0x3b32, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/1/0/m = #712 */
    { 0x0400, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/1/0/u = #713 */
    { 0x0432, 0xb9f1, 0x3b32, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/1/0/0x32 = #714 */
    { 0x0430, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/1/0/u0x2 = #715 */
    { 0x0422, 0xb9f1, 0xbbb2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0xc1b73d75fc73f7ee,24554) }, /* #13/1/0/u0x10 = #716 */
    { 0x0412, 0xb9f1, 0xbbb2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/1/0/u0x20 = #717 */
    { 0x057f, 0xb9f1, 0x3b32, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/1/1/m = #718 */
    { 0x0500, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/1/1/u = #719 */
    { 0x0532, 0xb9f1, 0x3b32, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/1/1/0x32 = #720 */
    { 0x0530, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/1/1/u0x2 = #721 */
    { 0x0522, 0xb9f1, 0xbbb2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0xc1b73d75fc73f7ee,24554) }, /* #13/1/1/u0x10 = #722 */
    { 0x0512, 0xb9f1, 0xbbb2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/1/1/u0x20 = #723 */
    { 0x067f, 0xb9f1, 0x3b32, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/1/2/m = #724 */
    { 0x0600, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/1/2/u = #725 */
    { 0x0632, 0xb9f1, 0x3b32, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/1/2/0x32 = #726 */
    { 0x0630, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/1/2/u0x2 = #727 */
    { 0x0622, 0xb9f1, 0xbbb2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0xc1b73d75fc73f7ee,24554) }, /* #13/1/2/u0x10 = #728 */
    { 0x0612, 0xb9f1, 0xbbb2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/1/2/u0x20 = #729 */
    { 0x077f, 0xb9f1, 0x3b32, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/1/3/m = #730 */
    { 0x0700, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/1/3/u = #731 */
    { 0x0732, 0xb9f1, 0x3b32, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/1/3/0x32 = #732 */
    { 0x0730, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/1/3/u0x2 = #733 */
    { 0x0722, 0xb9f1, 0xbbb2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0xc1b73d75fc73f7ee,24554) }, /* #13/1/3/u0x10 = #734 */
    { 0x0712, 0xb9f1, 0xbbb2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf9,0) }, /* #13/1/3/u0x20 = #735 */
    { 0x087f, 0xb9f1, 0x3932, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/2/0/m = #736 */
    { 0x0800, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/2/0/u = #737 */
    { 0x0832, 0xb9f1, 0x3932, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/2/0/0x32 = #738 */
    { 0x0830, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/2/0/u0x2 = #739 */
    { 0x0822, 0xb9f1, 0xb9b2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0xc1b73d75fc73f7ed,24554) }, /* #13/2/0/u0x10 = #740 */
    { 0x0812, 0xb9f1, 0xb9b2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/2/0/u0x20 = #741 */
    { 0x097f, 0xb9f1, 0x3932, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/2/1/m = #742 */
    { 0x0900, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/2/1/u = #743 */
    { 0x0932, 0xb9f1, 0x3932, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/2/1/0x32 = #744 */
    { 0x0930, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/2/1/u0x2 = #745 */
    { 0x0922, 0xb9f1, 0xb9b2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0xc1b73d75fc73f7ed,24554) }, /* #13/2/1/u0x10 = #746 */
    { 0x0912, 0xb9f1, 0xb9b2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/2/1/u0x20 = #747 */
    { 0x0a7f, 0xb9f1, 0x3932, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/2/2/m = #748 */
    { 0x0a00, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/2/2/u = #749 */
    { 0x0a32, 0xb9f1, 0x3932, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/2/2/0x32 = #750 */
    { 0x0a30, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/2/2/u0x2 = #751 */
    { 0x0a22, 0xb9f1, 0xb9b2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0xc1b73d75fc73f7ed,24554) }, /* #13/2/2/u0x10 = #752 */
    { 0x0a12, 0xb9f1, 0xb9b2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/2/2/u0x20 = #753 */
    { 0x0b7f, 0xb9f1, 0x3932, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/2/3/m = #754 */
    { 0x0b00, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/2/3/u = #755 */
    { 0x0b32, 0xb9f1, 0x3932, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/2/3/0x32 = #756 */
    { 0x0b30, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/2/3/u0x2 = #757 */
    { 0x0b22, 0xb9f1, 0xb9b2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0xc1b73d75fc73f7ed,24554) }, /* #13/2/3/u0x10 = #758 */
    { 0x0b12, 0xb9f1, 0xb9b2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/2/3/u0x20 = #759 */
    { 0x0c7f, 0xb9f1, 0x3932, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/3/0/m = #760 */
    { 0x0c00, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/3/0/u = #761 */
    { 0x0c32, 0xb9f1, 0x3932, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/3/0/0x32 = #762 */
    { 0x0c30, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/3/0/u0x2 = #763 */
    { 0x0c22, 0xb9f1, 0xb9b2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0xc1b73d75fc73f7ed,24554) }, /* #13/3/0/u0x10 = #764 */
    { 0x0c12, 0xb9f1, 0xb9b2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/3/0/u0x20 = #765 */
    { 0x0d7f, 0xb9f1, 0x3932, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/3/1/m = #766 */
    { 0x0d00, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/3/1/u = #767 */
    { 0x0d32, 0xb9f1, 0x3932, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/3/1/0x32 = #768 */
    { 0x0d30, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/3/1/u0x2 = #769 */
    { 0x0d22, 0xb9f1, 0xb9b2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0xc1b73d75fc73f7ed,24554) }, /* #13/3/1/u0x10 = #770 */
    { 0x0d12, 0xb9f1, 0xb9b2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/3/1/u0x20 = #771 */
    { 0x0e7f, 0xb9f1, 0x3932, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/3/2/m = #772 */
    { 0x0e00, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/3/2/u = #773 */
    { 0x0e32, 0xb9f1, 0x3932, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/3/2/0x32 = #774 */
    { 0x0e30, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/3/2/u0x2 = #775 */
    { 0x0e22, 0xb9f1, 0xb9b2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0xc1b73d75fc73f7ed,24554) }, /* #13/3/2/u0x10 = #776 */
    { 0x0e12, 0xb9f1, 0xb9b2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/3/2/u0x20 = #777 */
    { 0x0f7f, 0xb9f1, 0x3932, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/3/3/m = #778 */
    { 0x0f00, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/3/3/u = #779 */
    { 0x0f32, 0xb9f1, 0x3932, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/3/3/0x32 = #780 */
    { 0x0f30, 0xb9f1, 0xb982, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x22ef2128094,0) }, /* #13/3/3/u0x2 = #781 */
    { 0x0f22, 0xb9f1, 0xb9b2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0xc1b73d75fc73f7ed,24554) }, /* #13/3/3/u0x10 = #782 */
    { 0x0f12, 0xb9f1, 0xb9b2, RTFLOAT80U_INIT_C(1,0x22ef2128094,0), RTFLOAT80U_INIT_C(1,0x1836e7aebf8,0) }, /* #13/3/3/u0x20 = #783 */
    { 0x007f, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/0/0/m = #784 */
    { 0x0000, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/0/0/u = #785 */
    { 0x0032, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/0/0/0x32 = #786 */
    { 0x0030, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/0/0/u0x2 = #787 */
    { 0x0022, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0xab07f058697cb135,24575) }, /* #14/0/0/u0x10 = #788 */
    { 0x0012, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/0/0/u0x20 = #789 */
    { 0x017f, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/0/1/m = #790 */
    { 0x0100, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/0/1/u = #791 */
    { 0x0132, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/0/1/0x32 = #792 */
    { 0x0130, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/0/1/u0x2 = #793 */
    { 0x0122, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0xab07f058697cb135,24575) }, /* #14/0/1/u0x10 = #794 */
    { 0x0112, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/0/1/u0x20 = #795 */
    { 0x027f, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/0/2/m = #796 */
    { 0x0200, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/0/2/u = #797 */
    { 0x0232, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/0/2/0x32 = #798 */
    { 0x0230, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/0/2/u0x2 = #799 */
    { 0x0222, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0xab07f058697cb135,24575) }, /* #14/0/2/u0x10 = #800 */
    { 0x0212, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/0/2/u0x20 = #801 */
    { 0x037f, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/0/3/m = #802 */
    { 0x0300, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/0/3/u = #803 */
    { 0x0332, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/0/3/0x32 = #804 */
    { 0x0330, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/0/3/u0x2 = #805 */
    { 0x0322, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0xab07f058697cb135,24575) }, /* #14/0/3/u0x10 = #806 */
    { 0x0312, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/0/3/u0x20 = #807 */
    { 0x047f, 0x2679, 0x3e32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4e,0) }, /* #14/1/0/m = #808 */
    { 0x0400, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/1/0/u = #809 */
    { 0x0432, 0x2679, 0x3e32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4e,0) }, /* #14/1/0/0x32 = #810 */
    { 0x0430, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/1/0/u0x2 = #811 */
    { 0x0422, 0x2679, 0xbeb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0xab07f058697cb136,24575) }, /* #14/1/0/u0x10 = #812 */
    { 0x0412, 0x2679, 0xbeb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4e,0) }, /* #14/1/0/u0x20 = #813 */
    { 0x057f, 0x2679, 0x3e32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4e,0) }, /* #14/1/1/m = #814 */
    { 0x0500, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/1/1/u = #815 */
    { 0x0532, 0x2679, 0x3e32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4e,0) }, /* #14/1/1/0x32 = #816 */
    { 0x0530, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/1/1/u0x2 = #817 */
    { 0x0522, 0x2679, 0xbeb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0xab07f058697cb136,24575) }, /* #14/1/1/u0x10 = #818 */
    { 0x0512, 0x2679, 0xbeb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4e,0) }, /* #14/1/1/u0x20 = #819 */
    { 0x067f, 0x2679, 0x3e32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4e,0) }, /* #14/1/2/m = #820 */
    { 0x0600, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/1/2/u = #821 */
    { 0x0632, 0x2679, 0x3e32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4e,0) }, /* #14/1/2/0x32 = #822 */
    { 0x0630, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/1/2/u0x2 = #823 */
    { 0x0622, 0x2679, 0xbeb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0xab07f058697cb136,24575) }, /* #14/1/2/u0x10 = #824 */
    { 0x0612, 0x2679, 0xbeb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4e,0) }, /* #14/1/2/u0x20 = #825 */
    { 0x077f, 0x2679, 0x3e32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4e,0) }, /* #14/1/3/m = #826 */
    { 0x0700, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/1/3/u = #827 */
    { 0x0732, 0x2679, 0x3e32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4e,0) }, /* #14/1/3/0x32 = #828 */
    { 0x0730, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/1/3/u0x2 = #829 */
    { 0x0722, 0x2679, 0xbeb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0xab07f058697cb136,24575) }, /* #14/1/3/u0x10 = #830 */
    { 0x0712, 0x2679, 0xbeb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4e,0) }, /* #14/1/3/u0x20 = #831 */
    { 0x087f, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/2/0/m = #832 */
    { 0x0800, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/2/0/u = #833 */
    { 0x0832, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/2/0/0x32 = #834 */
    { 0x0830, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/2/0/u0x2 = #835 */
    { 0x0822, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0xab07f058697cb135,24575) }, /* #14/2/0/u0x10 = #836 */
    { 0x0812, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/2/0/u0x20 = #837 */
    { 0x097f, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/2/1/m = #838 */
    { 0x0900, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/2/1/u = #839 */
    { 0x0932, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/2/1/0x32 = #840 */
    { 0x0930, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/2/1/u0x2 = #841 */
    { 0x0922, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0xab07f058697cb135,24575) }, /* #14/2/1/u0x10 = #842 */
    { 0x0912, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/2/1/u0x20 = #843 */
    { 0x0a7f, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/2/2/m = #844 */
    { 0x0a00, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/2/2/u = #845 */
    { 0x0a32, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/2/2/0x32 = #846 */
    { 0x0a30, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/2/2/u0x2 = #847 */
    { 0x0a22, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0xab07f058697cb135,24575) }, /* #14/2/2/u0x10 = #848 */
    { 0x0a12, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/2/2/u0x20 = #849 */
    { 0x0b7f, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/2/3/m = #850 */
    { 0x0b00, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/2/3/u = #851 */
    { 0x0b32, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/2/3/0x32 = #852 */
    { 0x0b30, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/2/3/u0x2 = #853 */
    { 0x0b22, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0xab07f058697cb135,24575) }, /* #14/2/3/u0x10 = #854 */
    { 0x0b12, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/2/3/u0x20 = #855 */
    { 0x0c7f, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/3/0/m = #856 */
    { 0x0c00, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/3/0/u = #857 */
    { 0x0c32, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/3/0/0x32 = #858 */
    { 0x0c30, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/3/0/u0x2 = #859 */
    { 0x0c22, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0xab07f058697cb135,24575) }, /* #14/3/0/u0x10 = #860 */
    { 0x0c12, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/3/0/u0x20 = #861 */
    { 0x0d7f, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/3/1/m = #862 */
    { 0x0d00, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/3/1/u = #863 */
    { 0x0d32, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/3/1/0x32 = #864 */
    { 0x0d30, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/3/1/u0x2 = #865 */
    { 0x0d22, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0xab07f058697cb135,24575) }, /* #14/3/1/u0x10 = #866 */
    { 0x0d12, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/3/1/u0x20 = #867 */
    { 0x0e7f, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/3/2/m = #868 */
    { 0x0e00, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/3/2/u = #869 */
    { 0x0e32, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/3/2/0x32 = #870 */
    { 0x0e30, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/3/2/u0x2 = #871 */
    { 0x0e22, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0xab07f058697cb135,24575) }, /* #14/3/2/u0x10 = #872 */
    { 0x0e12, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/3/2/u0x20 = #873 */
    { 0x0f7f, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/3/3/m = #874 */
    { 0x0f00, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/3/3/u = #875 */
    { 0x0f32, 0x2679, 0x3c32, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/3/3/0x32 = #876 */
    { 0x0f30, 0x2679, 0xbc82, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0) }, /* #14/3/3/u0x2 = #877 */
    { 0x0f22, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0xab07f058697cb135,24575) }, /* #14/3/3/u0x10 = #878 */
    { 0x0f12, 0x2679, 0xbcb2, RTFLOAT80U_INIT_C(1,0x3dafb7c5ce5c31c8,0), RTFLOAT80U_INIT_C(1,0x2ac1fc161a5f2c4d,0) }, /* #14/3/3/u0x20 = #879 */
    { 0x007f, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/0/0/m = #880 */
    { 0x0000, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/0/0/u = #881 */
    { 0x017f, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/0/1/m = #882 */
    { 0x0100, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/0/1/u = #883 */
    { 0x027f, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/0/2/m = #884 */
    { 0x0200, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/0/2/u = #885 */
    { 0x037f, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/0/3/m = #886 */
    { 0x0300, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/0/3/u = #887 */
    { 0x047f, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/1/0/m = #888 */
    { 0x0400, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/1/0/u = #889 */
    { 0x057f, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/1/1/m = #890 */
    { 0x0500, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/1/1/u = #891 */
    { 0x067f, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/1/2/m = #892 */
    { 0x0600, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/1/2/u = #893 */
    { 0x077f, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/1/3/m = #894 */
    { 0x0700, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/1/3/u = #895 */
    { 0x087f, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/2/0/m = #896 */
    { 0x0800, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/2/0/u = #897 */
    { 0x097f, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/2/1/m = #898 */
    { 0x0900, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/2/1/u = #899 */
    { 0x0a7f, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/2/2/m = #900 */
    { 0x0a00, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/2/2/u = #901 */
    { 0x0b7f, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/2/3/m = #902 */
    { 0x0b00, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/2/3/u = #903 */
    { 0x0c7f, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/3/0/m = #904 */
    { 0x0c00, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/3/0/u = #905 */
    { 0x0d7f, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/3/1/m = #906 */
    { 0x0d00, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/3/1/u = #907 */
    { 0x0e7f, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/3/2/m = #908 */
    { 0x0e00, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/3/2/u = #909 */
    { 0x0f7f, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/3/3/m = #910 */
    { 0x0f00, 0x73f8, 0x7900, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/3/3/u = #911 */
    { 0x007f, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/0/0/m = #912 */
    { 0x0000, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/0/0/u = #913 */
    { 0x017f, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/0/1/m = #914 */
    { 0x0100, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/0/1/u = #915 */
    { 0x027f, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/0/2/m = #916 */
    { 0x0200, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/0/2/u = #917 */
    { 0x037f, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/0/3/m = #918 */
    { 0x0300, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/0/3/u = #919 */
    { 0x047f, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/1/0/m = #920 */
    { 0x0400, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/1/0/u = #921 */
    { 0x057f, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/1/1/m = #922 */
    { 0x0500, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/1/1/u = #923 */
    { 0x067f, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/1/2/m = #924 */
    { 0x0600, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/1/2/u = #925 */
    { 0x077f, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/1/3/m = #926 */
    { 0x0700, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/1/3/u = #927 */
    { 0x087f, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/2/0/m = #928 */
    { 0x0800, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/2/0/u = #929 */
    { 0x097f, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/2/1/m = #930 */
    { 0x0900, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/2/1/u = #931 */
    { 0x0a7f, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/2/2/m = #932 */
    { 0x0a00, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/2/2/u = #933 */
    { 0x0b7f, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/2/3/m = #934 */
    { 0x0b00, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/2/3/u = #935 */
    { 0x0c7f, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/3/0/m = #936 */
    { 0x0c00, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/3/0/u = #937 */
    { 0x0d7f, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/3/1/m = #938 */
    { 0x0d00, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/3/1/u = #939 */
    { 0x0e7f, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/3/2/m = #940 */
    { 0x0e00, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/3/2/u = #941 */
    { 0x0f7f, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/3/3/m = #942 */
    { 0x0f00, 0xf8a7, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #16/3/3/u = #943 */
    { 0x007f, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/0/m = #944 */
    { 0x0000, 0x9f96, 0xbd81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/0/0/u = #945 */
    { 0x0001, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/0/0x1 = #946 */
    { 0x017f, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/1/m = #947 */
    { 0x0100, 0x9f96, 0xbd81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/0/1/u = #948 */
    { 0x0101, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/1/0x1 = #949 */
    { 0x027f, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/2/m = #950 */
    { 0x0200, 0x9f96, 0xbd81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/0/2/u = #951 */
    { 0x0201, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/2/0x1 = #952 */
    { 0x037f, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/3/m = #953 */
    { 0x0300, 0x9f96, 0xbd81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/0/3/u = #954 */
    { 0x0301, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/3/0x1 = #955 */
    { 0x047f, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/0/m = #956 */
    { 0x0400, 0x9f96, 0xbd81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/1/0/u = #957 */
    { 0x0401, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/0/0x1 = #958 */
    { 0x057f, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/1/m = #959 */
    { 0x0500, 0x9f96, 0xbd81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/1/1/u = #960 */
    { 0x0501, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/1/0x1 = #961 */
    { 0x067f, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/2/m = #962 */
    { 0x0600, 0x9f96, 0xbd81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/1/2/u = #963 */
    { 0x0601, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/2/0x1 = #964 */
    { 0x077f, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/3/m = #965 */
    { 0x0700, 0x9f96, 0xbd81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/1/3/u = #966 */
    { 0x0701, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/3/0x1 = #967 */
    { 0x087f, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/0/m = #968 */
    { 0x0800, 0x9f96, 0xbd81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/2/0/u = #969 */
    { 0x0801, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/0/0x1 = #970 */
    { 0x097f, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/1/m = #971 */
    { 0x0900, 0x9f96, 0xbd81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/2/1/u = #972 */
    { 0x0901, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/1/0x1 = #973 */
    { 0x0a7f, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/2/m = #974 */
    { 0x0a00, 0x9f96, 0xbd81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/2/2/u = #975 */
    { 0x0a01, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/2/0x1 = #976 */
    { 0x0b7f, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/3/m = #977 */
    { 0x0b00, 0x9f96, 0xbd81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/2/3/u = #978 */
    { 0x0b01, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/3/0x1 = #979 */
    { 0x0c7f, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/0/m = #980 */
    { 0x0c00, 0x9f96, 0xbd81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/3/0/u = #981 */
    { 0x0c01, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/0/0x1 = #982 */
    { 0x0d7f, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/1/m = #983 */
    { 0x0d00, 0x9f96, 0xbd81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/3/1/u = #984 */
    { 0x0d01, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/1/0x1 = #985 */
    { 0x0e7f, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/2/m = #986 */
    { 0x0e00, 0x9f96, 0xbd81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/3/2/u = #987 */
    { 0x0e01, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/2/0x1 = #988 */
    { 0x0f7f, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/3/m = #989 */
    { 0x0f00, 0x9f96, 0xbd81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/3/3/u = #990 */
    { 0x0f01, 0x9f96, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/3/0x1 = #991 */
    { 0x007f, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/0/m = #992 */
    { 0x0000, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/0/u = #993 */
    { 0x017f, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/1/m = #994 */
    { 0x0100, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/1/u = #995 */
    { 0x027f, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/2/m = #996 */
    { 0x0200, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/2/u = #997 */
    { 0x037f, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/3/m = #998 */
    { 0x0300, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/3/u = #999 */
    { 0x047f, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/0/m = #1000 */
    { 0x0400, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/0/u = #1001 */
    { 0x057f, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/1/m = #1002 */
    { 0x0500, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/1/u = #1003 */
    { 0x067f, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/2/m = #1004 */
    { 0x0600, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/2/u = #1005 */
    { 0x077f, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/3/m = #1006 */
    { 0x0700, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/3/u = #1007 */
    { 0x087f, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/0/m = #1008 */
    { 0x0800, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/0/u = #1009 */
    { 0x097f, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/1/m = #1010 */
    { 0x0900, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/1/u = #1011 */
    { 0x0a7f, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/2/m = #1012 */
    { 0x0a00, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/2/u = #1013 */
    { 0x0b7f, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/3/m = #1014 */
    { 0x0b00, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/3/u = #1015 */
    { 0x0c7f, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/0/m = #1016 */
    { 0x0c00, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/0/u = #1017 */
    { 0x0d7f, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/1/m = #1018 */
    { 0x0d00, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/1/u = #1019 */
    { 0x0e7f, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/2/m = #1020 */
    { 0x0e00, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/2/u = #1021 */
    { 0x0f7f, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/3/m = #1022 */
    { 0x0f00, 0x9c5f, 0x3c00, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/3/u = #1023 */
    { 0x007f, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/0/0/m = #1024 */
    { 0x0000, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/0/0/u = #1025 */
    { 0x017f, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/0/1/m = #1026 */
    { 0x0100, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/0/1/u = #1027 */
    { 0x027f, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/0/2/m = #1028 */
    { 0x0200, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/0/2/u = #1029 */
    { 0x037f, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/0/3/m = #1030 */
    { 0x0300, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/0/3/u = #1031 */
    { 0x047f, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/1/0/m = #1032 */
    { 0x0400, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/1/0/u = #1033 */
    { 0x057f, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/1/1/m = #1034 */
    { 0x0500, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/1/1/u = #1035 */
    { 0x067f, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/1/2/m = #1036 */
    { 0x0600, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/1/2/u = #1037 */
    { 0x077f, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/1/3/m = #1038 */
    { 0x0700, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/1/3/u = #1039 */
    { 0x087f, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/2/0/m = #1040 */
    { 0x0800, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/2/0/u = #1041 */
    { 0x097f, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/2/1/m = #1042 */
    { 0x0900, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/2/1/u = #1043 */
    { 0x0a7f, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/2/2/m = #1044 */
    { 0x0a00, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/2/2/u = #1045 */
    { 0x0b7f, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/2/3/m = #1046 */
    { 0x0b00, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/2/3/u = #1047 */
    { 0x0c7f, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/3/0/m = #1048 */
    { 0x0c00, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/3/0/u = #1049 */
    { 0x0d7f, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/3/1/m = #1050 */
    { 0x0d00, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/3/1/u = #1051 */
    { 0x0e7f, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/3/2/m = #1052 */
    { 0x0e00, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/3/2/u = #1053 */
    { 0x0f7f, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/3/3/m = #1054 */
    { 0x0f00, 0x4418, 0x7c00, RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767), RTFLOAT80U_INIT_C(0,0xe1009aef94084e77,32767) }, /* #19/3/3/u = #1055 */
    { 0x007f, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/0/0/m = #1056 */
    { 0x0000, 0x34ec, 0xbc81, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767) }, /* #20/0/0/u = #1057 */
    { 0x0001, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/0/0/0x1 = #1058 */
    { 0x017f, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/0/1/m = #1059 */
    { 0x0100, 0x34ec, 0xbc81, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767) }, /* #20/0/1/u = #1060 */
    { 0x0101, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/0/1/0x1 = #1061 */
    { 0x027f, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/0/2/m = #1062 */
    { 0x0200, 0x34ec, 0xbc81, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767) }, /* #20/0/2/u = #1063 */
    { 0x0201, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/0/2/0x1 = #1064 */
    { 0x037f, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/0/3/m = #1065 */
    { 0x0300, 0x34ec, 0xbc81, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767) }, /* #20/0/3/u = #1066 */
    { 0x0301, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/0/3/0x1 = #1067 */
    { 0x047f, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/1/0/m = #1068 */
    { 0x0400, 0x34ec, 0xbc81, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767) }, /* #20/1/0/u = #1069 */
    { 0x0401, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/1/0/0x1 = #1070 */
    { 0x057f, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/1/1/m = #1071 */
    { 0x0500, 0x34ec, 0xbc81, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767) }, /* #20/1/1/u = #1072 */
    { 0x0501, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/1/1/0x1 = #1073 */
    { 0x067f, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/1/2/m = #1074 */
    { 0x0600, 0x34ec, 0xbc81, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767) }, /* #20/1/2/u = #1075 */
    { 0x0601, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/1/2/0x1 = #1076 */
    { 0x077f, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/1/3/m = #1077 */
    { 0x0700, 0x34ec, 0xbc81, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767) }, /* #20/1/3/u = #1078 */
    { 0x0701, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/1/3/0x1 = #1079 */
    { 0x087f, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/2/0/m = #1080 */
    { 0x0800, 0x34ec, 0xbc81, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767) }, /* #20/2/0/u = #1081 */
    { 0x0801, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/2/0/0x1 = #1082 */
    { 0x097f, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/2/1/m = #1083 */
    { 0x0900, 0x34ec, 0xbc81, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767) }, /* #20/2/1/u = #1084 */
    { 0x0901, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/2/1/0x1 = #1085 */
    { 0x0a7f, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/2/2/m = #1086 */
    { 0x0a00, 0x34ec, 0xbc81, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767) }, /* #20/2/2/u = #1087 */
    { 0x0a01, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/2/2/0x1 = #1088 */
    { 0x0b7f, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/2/3/m = #1089 */
    { 0x0b00, 0x34ec, 0xbc81, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767) }, /* #20/2/3/u = #1090 */
    { 0x0b01, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/2/3/0x1 = #1091 */
    { 0x0c7f, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/3/0/m = #1092 */
    { 0x0c00, 0x34ec, 0xbc81, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767) }, /* #20/3/0/u = #1093 */
    { 0x0c01, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/3/0/0x1 = #1094 */
    { 0x0d7f, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/3/1/m = #1095 */
    { 0x0d00, 0x34ec, 0xbc81, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767) }, /* #20/3/1/u = #1096 */
    { 0x0d01, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/3/1/0x1 = #1097 */
    { 0x0e7f, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/3/2/m = #1098 */
    { 0x0e00, 0x34ec, 0xbc81, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767) }, /* #20/3/2/u = #1099 */
    { 0x0e01, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/3/2/0x1 = #1100 */
    { 0x0f7f, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/3/3/m = #1101 */
    { 0x0f00, 0x34ec, 0xbc81, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767) }, /* #20/3/3/u = #1102 */
    { 0x0f01, 0x34ec, 0x3c01, RTFLOAT80U_INIT_C(0,0x47004e3c9e53957d,32767), RTFLOAT80U_INIT_IND(1) }, /* #20/3/3/0x1 = #1103 */
    { 0x007f, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/0/0/m = #1104 */
    { 0x0000, 0x819e, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/0/0/u = #1105 */
    { 0x0020, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/0/0/0x20 = #1106 */
    { 0x017f, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/0/1/m = #1107 */
    { 0x0100, 0x819e, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/0/1/u = #1108 */
    { 0x0120, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/0/1/0x20 = #1109 */
    { 0x027f, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/0/2/m = #1110 */
    { 0x0200, 0x819e, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/0/2/u = #1111 */
    { 0x0220, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/0/2/0x20 = #1112 */
    { 0x037f, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/0/3/m = #1113 */
    { 0x0300, 0x819e, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/0/3/u = #1114 */
    { 0x0320, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/0/3/0x20 = #1115 */
    { 0x047f, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/1/0/m = #1116 */
    { 0x0400, 0x819e, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/1/0/u = #1117 */
    { 0x0420, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/1/0/0x20 = #1118 */
    { 0x057f, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/1/1/m = #1119 */
    { 0x0500, 0x819e, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/1/1/u = #1120 */
    { 0x0520, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/1/1/0x20 = #1121 */
    { 0x067f, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/1/2/m = #1122 */
    { 0x0600, 0x819e, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/1/2/u = #1123 */
    { 0x0620, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/1/2/0x20 = #1124 */
    { 0x077f, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/1/3/m = #1125 */
    { 0x0700, 0x819e, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/1/3/u = #1126 */
    { 0x0720, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/1/3/0x20 = #1127 */
    { 0x087f, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/2/0/m = #1128 */
    { 0x0800, 0x819e, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/2/0/u = #1129 */
    { 0x0820, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/2/0/0x20 = #1130 */
    { 0x097f, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/2/1/m = #1131 */
    { 0x0900, 0x819e, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/2/1/u = #1132 */
    { 0x0920, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/2/1/0x20 = #1133 */
    { 0x0a7f, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/2/2/m = #1134 */
    { 0x0a00, 0x819e, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/2/2/u = #1135 */
    { 0x0a20, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/2/2/0x20 = #1136 */
    { 0x0b7f, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/2/3/m = #1137 */
    { 0x0b00, 0x819e, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/2/3/u = #1138 */
    { 0x0b20, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/2/3/0x20 = #1139 */
    { 0x0c7f, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/3/0/m = #1140 */
    { 0x0c00, 0x819e, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/3/0/u = #1141 */
    { 0x0c20, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/3/0/0x20 = #1142 */
    { 0x0d7f, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/3/1/m = #1143 */
    { 0x0d00, 0x819e, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/3/1/u = #1144 */
    { 0x0d20, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/3/1/0x20 = #1145 */
    { 0x0e7f, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/3/2/m = #1146 */
    { 0x0e00, 0x819e, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/3/2/u = #1147 */
    { 0x0e20, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/3/2/0x20 = #1148 */
    { 0x0f7f, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/3/3/m = #1149 */
    { 0x0f00, 0x819e, 0xb9a0, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/3/3/u = #1150 */
    { 0x0f20, 0x819e, 0x3920, RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712), RTFLOAT80U_INIT_C(0,0xd0bc5a06d7da51e9,19712) }, /* #21/3/3/0x20 = #1151 */
    { 0x007f, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/0/0/m = #1152 */
    { 0x0000, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/0/0/u = #1153 */
    { 0x0032, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/0/0/0x32 = #1154 */
    { 0x0030, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/0/0/u0x2 = #1155 */
    { 0x0022, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1d60f1a,24576) }, /* #22/0/0/u0x10 = #1156 */
    { 0x0012, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/0/0/u0x20 = #1157 */
    { 0x017f, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/0/1/m = #1158 */
    { 0x0100, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/0/1/u = #1159 */
    { 0x0132, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/0/1/0x32 = #1160 */
    { 0x0130, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/0/1/u0x2 = #1161 */
    { 0x0122, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1d60f1a,24576) }, /* #22/0/1/u0x10 = #1162 */
    { 0x0112, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/0/1/u0x20 = #1163 */
    { 0x027f, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/0/2/m = #1164 */
    { 0x0200, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/0/2/u = #1165 */
    { 0x0232, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/0/2/0x32 = #1166 */
    { 0x0230, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/0/2/u0x2 = #1167 */
    { 0x0222, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1d60f1a,24576) }, /* #22/0/2/u0x10 = #1168 */
    { 0x0212, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/0/2/u0x20 = #1169 */
    { 0x037f, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/0/3/m = #1170 */
    { 0x0300, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/0/3/u = #1171 */
    { 0x0332, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/0/3/0x32 = #1172 */
    { 0x0330, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/0/3/u0x2 = #1173 */
    { 0x0322, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1d60f1a,24576) }, /* #22/0/3/u0x10 = #1174 */
    { 0x0312, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/0/3/u0x20 = #1175 */
    { 0x047f, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/1/0/m = #1176 */
    { 0x0400, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/1/0/u = #1177 */
    { 0x0432, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/1/0/0x32 = #1178 */
    { 0x0430, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/1/0/u0x2 = #1179 */
    { 0x0422, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1d60f1a,24576) }, /* #22/1/0/u0x10 = #1180 */
    { 0x0412, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/1/0/u0x20 = #1181 */
    { 0x057f, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/1/1/m = #1182 */
    { 0x0500, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/1/1/u = #1183 */
    { 0x0532, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/1/1/0x32 = #1184 */
    { 0x0530, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/1/1/u0x2 = #1185 */
    { 0x0522, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1d60f1a,24576) }, /* #22/1/1/u0x10 = #1186 */
    { 0x0512, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/1/1/u0x20 = #1187 */
    { 0x067f, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/1/2/m = #1188 */
    { 0x0600, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/1/2/u = #1189 */
    { 0x0632, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/1/2/0x32 = #1190 */
    { 0x0630, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/1/2/u0x2 = #1191 */
    { 0x0622, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1d60f1a,24576) }, /* #22/1/2/u0x10 = #1192 */
    { 0x0612, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/1/2/u0x20 = #1193 */
    { 0x077f, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/1/3/m = #1194 */
    { 0x0700, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/1/3/u = #1195 */
    { 0x0732, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/1/3/0x32 = #1196 */
    { 0x0730, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/1/3/u0x2 = #1197 */
    { 0x0722, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1d60f1a,24576) }, /* #22/1/3/u0x10 = #1198 */
    { 0x0712, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/1/3/u0x20 = #1199 */
    { 0x087f, 0x5e30, 0x7e32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078e,0) }, /* #22/2/0/m = #1200 */
    { 0x0800, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/2/0/u = #1201 */
    { 0x0832, 0x5e30, 0x7e32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078e,0) }, /* #22/2/0/0x32 = #1202 */
    { 0x0830, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/2/0/u0x2 = #1203 */
    { 0x0822, 0x5e30, 0xfeb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1d60f1b,24576) }, /* #22/2/0/u0x10 = #1204 */
    { 0x0812, 0x5e30, 0xfeb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078e,0) }, /* #22/2/0/u0x20 = #1205 */
    { 0x097f, 0x5e30, 0x7e32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078e,0) }, /* #22/2/1/m = #1206 */
    { 0x0900, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/2/1/u = #1207 */
    { 0x0932, 0x5e30, 0x7e32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078e,0) }, /* #22/2/1/0x32 = #1208 */
    { 0x0930, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/2/1/u0x2 = #1209 */
    { 0x0922, 0x5e30, 0xfeb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1d60f1b,24576) }, /* #22/2/1/u0x10 = #1210 */
    { 0x0912, 0x5e30, 0xfeb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078e,0) }, /* #22/2/1/u0x20 = #1211 */
    { 0x0a7f, 0x5e30, 0x7e32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078e,0) }, /* #22/2/2/m = #1212 */
    { 0x0a00, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/2/2/u = #1213 */
    { 0x0a32, 0x5e30, 0x7e32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078e,0) }, /* #22/2/2/0x32 = #1214 */
    { 0x0a30, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/2/2/u0x2 = #1215 */
    { 0x0a22, 0x5e30, 0xfeb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1d60f1b,24576) }, /* #22/2/2/u0x10 = #1216 */
    { 0x0a12, 0x5e30, 0xfeb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078e,0) }, /* #22/2/2/u0x20 = #1217 */
    { 0x0b7f, 0x5e30, 0x7e32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078e,0) }, /* #22/2/3/m = #1218 */
    { 0x0b00, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/2/3/u = #1219 */
    { 0x0b32, 0x5e30, 0x7e32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078e,0) }, /* #22/2/3/0x32 = #1220 */
    { 0x0b30, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/2/3/u0x2 = #1221 */
    { 0x0b22, 0x5e30, 0xfeb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1d60f1b,24576) }, /* #22/2/3/u0x10 = #1222 */
    { 0x0b12, 0x5e30, 0xfeb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078e,0) }, /* #22/2/3/u0x20 = #1223 */
    { 0x0c7f, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/3/0/m = #1224 */
    { 0x0c00, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/3/0/u = #1225 */
    { 0x0c32, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/3/0/0x32 = #1226 */
    { 0x0c30, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/3/0/u0x2 = #1227 */
    { 0x0c22, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1d60f1a,24576) }, /* #22/3/0/u0x10 = #1228 */
    { 0x0c12, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/3/0/u0x20 = #1229 */
    { 0x0d7f, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/3/1/m = #1230 */
    { 0x0d00, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/3/1/u = #1231 */
    { 0x0d32, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/3/1/0x32 = #1232 */
    { 0x0d30, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/3/1/u0x2 = #1233 */
    { 0x0d22, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1d60f1a,24576) }, /* #22/3/1/u0x10 = #1234 */
    { 0x0d12, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/3/1/u0x20 = #1235 */
    { 0x0e7f, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/3/2/m = #1236 */
    { 0x0e00, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/3/2/u = #1237 */
    { 0x0e32, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/3/2/0x32 = #1238 */
    { 0x0e30, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/3/2/u0x2 = #1239 */
    { 0x0e22, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1d60f1a,24576) }, /* #22/3/2/u0x10 = #1240 */
    { 0x0e12, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/3/2/u0x20 = #1241 */
    { 0x0f7f, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/3/3/m = #1242 */
    { 0x0f00, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/3/3/u = #1243 */
    { 0x0f32, 0x5e30, 0x7c32, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/3/3/0x32 = #1244 */
    { 0x0f30, 0x5e30, 0xfc82, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0) }, /* #22/3/3/u0x2 = #1245 */
    { 0x0f22, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1d60f1a,24576) }, /* #22/3/3/u0x10 = #1246 */
    { 0x0f12, 0x5e30, 0xfcb2, RTFLOAT80U_INIT_C(0,0x800000000004bfc8,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8eb078d,0) }, /* #22/3/3/u0x20 = #1247 */
    { 0x007f, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/0/0/m = #1248 */
    { 0x0000, 0x6d30, 0xfda0, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/0/0/u = #1249 */
    { 0x0020, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/0/0/0x20 = #1250 */
    { 0x017f, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/0/1/m = #1251 */
    { 0x0100, 0x6d30, 0xfda0, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/0/1/u = #1252 */
    { 0x0120, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/0/1/0x20 = #1253 */
    { 0x027f, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/0/2/m = #1254 */
    { 0x0200, 0x6d30, 0xfda0, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/0/2/u = #1255 */
    { 0x0220, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/0/2/0x20 = #1256 */
    { 0x037f, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/0/3/m = #1257 */
    { 0x0300, 0x6d30, 0xfda0, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/0/3/u = #1258 */
    { 0x0320, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/0/3/0x20 = #1259 */
    { 0x047f, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/1/0/m = #1260 */
    { 0x0400, 0x6d30, 0xfda0, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/1/0/u = #1261 */
    { 0x0420, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/1/0/0x20 = #1262 */
    { 0x057f, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/1/1/m = #1263 */
    { 0x0500, 0x6d30, 0xfda0, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/1/1/u = #1264 */
    { 0x0520, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/1/1/0x20 = #1265 */
    { 0x067f, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/1/2/m = #1266 */
    { 0x0600, 0x6d30, 0xfda0, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/1/2/u = #1267 */
    { 0x0620, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/1/2/0x20 = #1268 */
    { 0x077f, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/1/3/m = #1269 */
    { 0x0700, 0x6d30, 0xfda0, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/1/3/u = #1270 */
    { 0x0720, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/1/3/0x20 = #1271 */
    { 0x087f, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/2/0/m = #1272 */
    { 0x0800, 0x6d30, 0xfda0, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/2/0/u = #1273 */
    { 0x0820, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/2/0/0x20 = #1274 */
    { 0x097f, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/2/1/m = #1275 */
    { 0x0900, 0x6d30, 0xfda0, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/2/1/u = #1276 */
    { 0x0920, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/2/1/0x20 = #1277 */
    { 0x0a7f, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/2/2/m = #1278 */
    { 0x0a00, 0x6d30, 0xfda0, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/2/2/u = #1279 */
    { 0x0a20, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/2/2/0x20 = #1280 */
    { 0x0b7f, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/2/3/m = #1281 */
    { 0x0b00, 0x6d30, 0xfda0, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/2/3/u = #1282 */
    { 0x0b20, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/2/3/0x20 = #1283 */
    { 0x0c7f, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/3/0/m = #1284 */
    { 0x0c00, 0x6d30, 0xfda0, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/3/0/u = #1285 */
    { 0x0c20, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/3/0/0x20 = #1286 */
    { 0x0d7f, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/3/1/m = #1287 */
    { 0x0d00, 0x6d30, 0xfda0, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/3/1/u = #1288 */
    { 0x0d20, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/3/1/0x20 = #1289 */
    { 0x0e7f, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/3/2/m = #1290 */
    { 0x0e00, 0x6d30, 0xfda0, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/3/2/u = #1291 */
    { 0x0e20, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/3/2/0x20 = #1292 */
    { 0x0f7f, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/3/3/m = #1293 */
    { 0x0f00, 0x6d30, 0xfda0, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/3/3/u = #1294 */
    { 0x0f20, 0x6d30, 0x7d20, RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715), RTFLOAT80U_INIT_C(0,0xb8bdb297022d5dfe,30715) }, /* #23/3/3/0x20 = #1295 */
    { 0x007f, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/0/0/m = #1296 */
    { 0x0000, 0x15a3, 0xbd81, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767) }, /* #24/0/0/u = #1297 */
    { 0x0001, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/0/0/0x1 = #1298 */
    { 0x017f, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/0/1/m = #1299 */
    { 0x0100, 0x15a3, 0xbd81, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767) }, /* #24/0/1/u = #1300 */
    { 0x0101, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/0/1/0x1 = #1301 */
    { 0x027f, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/0/2/m = #1302 */
    { 0x0200, 0x15a3, 0xbd81, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767) }, /* #24/0/2/u = #1303 */
    { 0x0201, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/0/2/0x1 = #1304 */
    { 0x037f, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/0/3/m = #1305 */
    { 0x0300, 0x15a3, 0xbd81, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767) }, /* #24/0/3/u = #1306 */
    { 0x0301, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/0/3/0x1 = #1307 */
    { 0x047f, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/1/0/m = #1308 */
    { 0x0400, 0x15a3, 0xbd81, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767) }, /* #24/1/0/u = #1309 */
    { 0x0401, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/1/0/0x1 = #1310 */
    { 0x057f, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/1/1/m = #1311 */
    { 0x0500, 0x15a3, 0xbd81, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767) }, /* #24/1/1/u = #1312 */
    { 0x0501, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/1/1/0x1 = #1313 */
    { 0x067f, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/1/2/m = #1314 */
    { 0x0600, 0x15a3, 0xbd81, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767) }, /* #24/1/2/u = #1315 */
    { 0x0601, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/1/2/0x1 = #1316 */
    { 0x077f, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/1/3/m = #1317 */
    { 0x0700, 0x15a3, 0xbd81, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767) }, /* #24/1/3/u = #1318 */
    { 0x0701, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/1/3/0x1 = #1319 */
    { 0x087f, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/2/0/m = #1320 */
    { 0x0800, 0x15a3, 0xbd81, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767) }, /* #24/2/0/u = #1321 */
    { 0x0801, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/2/0/0x1 = #1322 */
    { 0x097f, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/2/1/m = #1323 */
    { 0x0900, 0x15a3, 0xbd81, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767) }, /* #24/2/1/u = #1324 */
    { 0x0901, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/2/1/0x1 = #1325 */
    { 0x0a7f, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/2/2/m = #1326 */
    { 0x0a00, 0x15a3, 0xbd81, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767) }, /* #24/2/2/u = #1327 */
    { 0x0a01, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/2/2/0x1 = #1328 */
    { 0x0b7f, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/2/3/m = #1329 */
    { 0x0b00, 0x15a3, 0xbd81, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767) }, /* #24/2/3/u = #1330 */
    { 0x0b01, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/2/3/0x1 = #1331 */
    { 0x0c7f, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/3/0/m = #1332 */
    { 0x0c00, 0x15a3, 0xbd81, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767) }, /* #24/3/0/u = #1333 */
    { 0x0c01, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/3/0/0x1 = #1334 */
    { 0x0d7f, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/3/1/m = #1335 */
    { 0x0d00, 0x15a3, 0xbd81, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767) }, /* #24/3/1/u = #1336 */
    { 0x0d01, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/3/1/0x1 = #1337 */
    { 0x0e7f, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/3/2/m = #1338 */
    { 0x0e00, 0x15a3, 0xbd81, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767) }, /* #24/3/2/u = #1339 */
    { 0x0e01, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/3/2/0x1 = #1340 */
    { 0x0f7f, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/3/3/m = #1341 */
    { 0x0f00, 0x15a3, 0xbd81, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767) }, /* #24/3/3/u = #1342 */
    { 0x0f01, 0x15a3, 0x3d01, RTFLOAT80U_INIT_C(1,0x80001c6df3c8502c,32767), RTFLOAT80U_INIT_C(1,0xc0001c6df3c8502c,32767) }, /* #24/3/3/0x1 = #1343 */
    { 0x007f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/0/0/m = #1344 */
    { 0x0000, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767) }, /* #25/0/0/u = #1345 */
    { 0x0001, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/0/0/0x1 = #1346 */
    { 0x017f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/0/1/m = #1347 */
    { 0x0100, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767) }, /* #25/0/1/u = #1348 */
    { 0x0101, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/0/1/0x1 = #1349 */
    { 0x027f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/0/2/m = #1350 */
    { 0x0200, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767) }, /* #25/0/2/u = #1351 */
    { 0x0201, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/0/2/0x1 = #1352 */
    { 0x037f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/0/3/m = #1353 */
    { 0x0300, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767) }, /* #25/0/3/u = #1354 */
    { 0x0301, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/0/3/0x1 = #1355 */
    { 0x047f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/1/0/m = #1356 */
    { 0x0400, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767) }, /* #25/1/0/u = #1357 */
    { 0x0401, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/1/0/0x1 = #1358 */
    { 0x057f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/1/1/m = #1359 */
    { 0x0500, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767) }, /* #25/1/1/u = #1360 */
    { 0x0501, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/1/1/0x1 = #1361 */
    { 0x067f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/1/2/m = #1362 */
    { 0x0600, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767) }, /* #25/1/2/u = #1363 */
    { 0x0601, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/1/2/0x1 = #1364 */
    { 0x077f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/1/3/m = #1365 */
    { 0x0700, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767) }, /* #25/1/3/u = #1366 */
    { 0x0701, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/1/3/0x1 = #1367 */
    { 0x087f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/2/0/m = #1368 */
    { 0x0800, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767) }, /* #25/2/0/u = #1369 */
    { 0x0801, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/2/0/0x1 = #1370 */
    { 0x097f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/2/1/m = #1371 */
    { 0x0900, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767) }, /* #25/2/1/u = #1372 */
    { 0x0901, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/2/1/0x1 = #1373 */
    { 0x0a7f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/2/2/m = #1374 */
    { 0x0a00, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767) }, /* #25/2/2/u = #1375 */
    { 0x0a01, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/2/2/0x1 = #1376 */
    { 0x0b7f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/2/3/m = #1377 */
    { 0x0b00, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767) }, /* #25/2/3/u = #1378 */
    { 0x0b01, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/2/3/0x1 = #1379 */
    { 0x0c7f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/3/0/m = #1380 */
    { 0x0c00, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767) }, /* #25/3/0/u = #1381 */
    { 0x0c01, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/3/0/0x1 = #1382 */
    { 0x0d7f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/3/1/m = #1383 */
    { 0x0d00, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767) }, /* #25/3/1/u = #1384 */
    { 0x0d01, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/3/1/0x1 = #1385 */
    { 0x0e7f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/3/2/m = #1386 */
    { 0x0e00, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767) }, /* #25/3/2/u = #1387 */
    { 0x0e01, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/3/2/0x1 = #1388 */
    { 0x0f7f, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/3/3/m = #1389 */
    { 0x0f00, 0x8f50, 0xbd81, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767) }, /* #25/3/3/u = #1390 */
    { 0x0f01, 0x8f50, 0x3d01, RTFLOAT80U_INIT_C(1,0xb4c547c6fc9cee1d,32767), RTFLOAT80U_INIT_C(1,0xf4c547c6fc9cee1d,32767) }, /* #25/3/3/0x1 = #1391 */
    { 0x007f, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/0/0/m = #1392 */
    { 0x0000, 0x1f75, 0xbd81, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901) }, /* #26/0/0/u = #1393 */
    { 0x0001, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/0/0/0x1 = #1394 */
    { 0x017f, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/0/1/m = #1395 */
    { 0x0100, 0x1f75, 0xbd81, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901) }, /* #26/0/1/u = #1396 */
    { 0x0101, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/0/1/0x1 = #1397 */
    { 0x027f, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/0/2/m = #1398 */
    { 0x0200, 0x1f75, 0xbd81, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901) }, /* #26/0/2/u = #1399 */
    { 0x0201, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/0/2/0x1 = #1400 */
    { 0x037f, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/0/3/m = #1401 */
    { 0x0300, 0x1f75, 0xbd81, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901) }, /* #26/0/3/u = #1402 */
    { 0x0301, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/0/3/0x1 = #1403 */
    { 0x047f, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/1/0/m = #1404 */
    { 0x0400, 0x1f75, 0xbd81, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901) }, /* #26/1/0/u = #1405 */
    { 0x0401, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/1/0/0x1 = #1406 */
    { 0x057f, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/1/1/m = #1407 */
    { 0x0500, 0x1f75, 0xbd81, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901) }, /* #26/1/1/u = #1408 */
    { 0x0501, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/1/1/0x1 = #1409 */
    { 0x067f, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/1/2/m = #1410 */
    { 0x0600, 0x1f75, 0xbd81, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901) }, /* #26/1/2/u = #1411 */
    { 0x0601, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/1/2/0x1 = #1412 */
    { 0x077f, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/1/3/m = #1413 */
    { 0x0700, 0x1f75, 0xbd81, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901) }, /* #26/1/3/u = #1414 */
    { 0x0701, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/1/3/0x1 = #1415 */
    { 0x087f, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/2/0/m = #1416 */
    { 0x0800, 0x1f75, 0xbd81, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901) }, /* #26/2/0/u = #1417 */
    { 0x0801, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/2/0/0x1 = #1418 */
    { 0x097f, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/2/1/m = #1419 */
    { 0x0900, 0x1f75, 0xbd81, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901) }, /* #26/2/1/u = #1420 */
    { 0x0901, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/2/1/0x1 = #1421 */
    { 0x0a7f, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/2/2/m = #1422 */
    { 0x0a00, 0x1f75, 0xbd81, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901) }, /* #26/2/2/u = #1423 */
    { 0x0a01, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/2/2/0x1 = #1424 */
    { 0x0b7f, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/2/3/m = #1425 */
    { 0x0b00, 0x1f75, 0xbd81, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901) }, /* #26/2/3/u = #1426 */
    { 0x0b01, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/2/3/0x1 = #1427 */
    { 0x0c7f, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/3/0/m = #1428 */
    { 0x0c00, 0x1f75, 0xbd81, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901) }, /* #26/3/0/u = #1429 */
    { 0x0c01, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/3/0/0x1 = #1430 */
    { 0x0d7f, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/3/1/m = #1431 */
    { 0x0d00, 0x1f75, 0xbd81, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901) }, /* #26/3/1/u = #1432 */
    { 0x0d01, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/3/1/0x1 = #1433 */
    { 0x0e7f, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/3/2/m = #1434 */
    { 0x0e00, 0x1f75, 0xbd81, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901) }, /* #26/3/2/u = #1435 */
    { 0x0e01, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/3/2/0x1 = #1436 */
    { 0x0f7f, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/3/3/m = #1437 */
    { 0x0f00, 0x1f75, 0xbd81, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901) }, /* #26/3/3/u = #1438 */
    { 0x0f01, 0x1f75, 0x3d01, RTFLOAT80U_INIT_C(0,0x6866528dcee52a08,20901), RTFLOAT80U_INIT_IND(1) }, /* #26/3/3/0x1 = #1439 */
    { 0x007f, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/0/m = #1440 */
    { 0x0000, 0xa656, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767) }, /* #27/0/0/u = #1441 */
    { 0x0001, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/0/0x1 = #1442 */
    { 0x017f, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/1/m = #1443 */
    { 0x0100, 0xa656, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767) }, /* #27/0/1/u = #1444 */
    { 0x0101, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/1/0x1 = #1445 */
    { 0x027f, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/2/m = #1446 */
    { 0x0200, 0xa656, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767) }, /* #27/0/2/u = #1447 */
    { 0x0201, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/2/0x1 = #1448 */
    { 0x037f, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/3/m = #1449 */
    { 0x0300, 0xa656, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767) }, /* #27/0/3/u = #1450 */
    { 0x0301, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/0/3/0x1 = #1451 */
    { 0x047f, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/0/m = #1452 */
    { 0x0400, 0xa656, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767) }, /* #27/1/0/u = #1453 */
    { 0x0401, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/0/0x1 = #1454 */
    { 0x057f, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/1/m = #1455 */
    { 0x0500, 0xa656, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767) }, /* #27/1/1/u = #1456 */
    { 0x0501, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/1/0x1 = #1457 */
    { 0x067f, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/2/m = #1458 */
    { 0x0600, 0xa656, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767) }, /* #27/1/2/u = #1459 */
    { 0x0601, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/2/0x1 = #1460 */
    { 0x077f, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/3/m = #1461 */
    { 0x0700, 0xa656, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767) }, /* #27/1/3/u = #1462 */
    { 0x0701, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/1/3/0x1 = #1463 */
    { 0x087f, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/0/m = #1464 */
    { 0x0800, 0xa656, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767) }, /* #27/2/0/u = #1465 */
    { 0x0801, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/0/0x1 = #1466 */
    { 0x097f, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/1/m = #1467 */
    { 0x0900, 0xa656, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767) }, /* #27/2/1/u = #1468 */
    { 0x0901, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/1/0x1 = #1469 */
    { 0x0a7f, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/2/m = #1470 */
    { 0x0a00, 0xa656, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767) }, /* #27/2/2/u = #1471 */
    { 0x0a01, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/2/0x1 = #1472 */
    { 0x0b7f, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/3/m = #1473 */
    { 0x0b00, 0xa656, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767) }, /* #27/2/3/u = #1474 */
    { 0x0b01, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/2/3/0x1 = #1475 */
    { 0x0c7f, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/0/m = #1476 */
    { 0x0c00, 0xa656, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767) }, /* #27/3/0/u = #1477 */
    { 0x0c01, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/0/0x1 = #1478 */
    { 0x0d7f, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/1/m = #1479 */
    { 0x0d00, 0xa656, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767) }, /* #27/3/1/u = #1480 */
    { 0x0d01, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/1/0x1 = #1481 */
    { 0x0e7f, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/2/m = #1482 */
    { 0x0e00, 0xa656, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767) }, /* #27/3/2/u = #1483 */
    { 0x0e01, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/2/0x1 = #1484 */
    { 0x0f7f, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/3/m = #1485 */
    { 0x0f00, 0xa656, 0xbc81, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767) }, /* #27/3/3/u = #1486 */
    { 0x0f01, 0xa656, 0x3c01, RTFLOAT80U_INIT_C(0,0x4000358fd94d32a8,32767), RTFLOAT80U_INIT_IND(1) }, /* #27/3/3/0x1 = #1487 */
    { 0x007f, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/0/0/m = #1488 */
    { 0x0000, 0x83f5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/0/0/u = #1489 */
    { 0x0020, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/0/0/0x20 = #1490 */
    { 0x017f, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/0/1/m = #1491 */
    { 0x0100, 0x83f5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/0/1/u = #1492 */
    { 0x0120, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/0/1/0x20 = #1493 */
    { 0x027f, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/0/2/m = #1494 */
    { 0x0200, 0x83f5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/0/2/u = #1495 */
    { 0x0220, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/0/2/0x20 = #1496 */
    { 0x037f, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/0/3/m = #1497 */
    { 0x0300, 0x83f5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/0/3/u = #1498 */
    { 0x0320, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/0/3/0x20 = #1499 */
    { 0x047f, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/1/0/m = #1500 */
    { 0x0400, 0x83f5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/1/0/u = #1501 */
    { 0x0420, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/1/0/0x20 = #1502 */
    { 0x057f, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/1/1/m = #1503 */
    { 0x0500, 0x83f5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/1/1/u = #1504 */
    { 0x0520, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/1/1/0x20 = #1505 */
    { 0x067f, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/1/2/m = #1506 */
    { 0x0600, 0x83f5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/1/2/u = #1507 */
    { 0x0620, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/1/2/0x20 = #1508 */
    { 0x077f, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/1/3/m = #1509 */
    { 0x0700, 0x83f5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/1/3/u = #1510 */
    { 0x0720, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/1/3/0x20 = #1511 */
    { 0x087f, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/2/0/m = #1512 */
    { 0x0800, 0x83f5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/2/0/u = #1513 */
    { 0x0820, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/2/0/0x20 = #1514 */
    { 0x097f, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/2/1/m = #1515 */
    { 0x0900, 0x83f5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/2/1/u = #1516 */
    { 0x0920, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/2/1/0x20 = #1517 */
    { 0x0a7f, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/2/2/m = #1518 */
    { 0x0a00, 0x83f5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/2/2/u = #1519 */
    { 0x0a20, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/2/2/0x20 = #1520 */
    { 0x0b7f, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/2/3/m = #1521 */
    { 0x0b00, 0x83f5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/2/3/u = #1522 */
    { 0x0b20, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/2/3/0x20 = #1523 */
    { 0x0c7f, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/3/0/m = #1524 */
    { 0x0c00, 0x83f5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/3/0/u = #1525 */
    { 0x0c20, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/3/0/0x20 = #1526 */
    { 0x0d7f, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/3/1/m = #1527 */
    { 0x0d00, 0x83f5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/3/1/u = #1528 */
    { 0x0d20, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/3/1/0x20 = #1529 */
    { 0x0e7f, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/3/2/m = #1530 */
    { 0x0e00, 0x83f5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/3/2/u = #1531 */
    { 0x0e20, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/3/2/0x20 = #1532 */
    { 0x0f7f, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/3/3/m = #1533 */
    { 0x0f00, 0x83f5, 0xb9a0, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/3/3/u = #1534 */
    { 0x0f20, 0x83f5, 0x3920, RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491), RTFLOAT80U_INIT_C(0,0xe9be522a8c493fc6,17491) }, /* #28/3/3/0x20 = #1535 */
    { 0x007f, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/0/0/m = #1536 */
    { 0x0000, 0x7b4e, 0xf981, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_C(1,0x2,19222) }, /* #29/0/0/u = #1537 */
    { 0x0001, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/0/0/0x1 = #1538 */
    { 0x017f, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/0/1/m = #1539 */
    { 0x0100, 0x7b4e, 0xf981, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_C(1,0x2,19222) }, /* #29/0/1/u = #1540 */
    { 0x0101, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/0/1/0x1 = #1541 */
    { 0x027f, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/0/2/m = #1542 */
    { 0x0200, 0x7b4e, 0xf981, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_C(1,0x2,19222) }, /* #29/0/2/u = #1543 */
    { 0x0201, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/0/2/0x1 = #1544 */
    { 0x037f, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/0/3/m = #1545 */
    { 0x0300, 0x7b4e, 0xf981, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_C(1,0x2,19222) }, /* #29/0/3/u = #1546 */
    { 0x0301, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/0/3/0x1 = #1547 */
    { 0x047f, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/1/0/m = #1548 */
    { 0x0400, 0x7b4e, 0xf981, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_C(1,0x2,19222) }, /* #29/1/0/u = #1549 */
    { 0x0401, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/1/0/0x1 = #1550 */
    { 0x057f, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/1/1/m = #1551 */
    { 0x0500, 0x7b4e, 0xf981, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_C(1,0x2,19222) }, /* #29/1/1/u = #1552 */
    { 0x0501, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/1/1/0x1 = #1553 */
    { 0x067f, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/1/2/m = #1554 */
    { 0x0600, 0x7b4e, 0xf981, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_C(1,0x2,19222) }, /* #29/1/2/u = #1555 */
    { 0x0601, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/1/2/0x1 = #1556 */
    { 0x077f, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/1/3/m = #1557 */
    { 0x0700, 0x7b4e, 0xf981, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_C(1,0x2,19222) }, /* #29/1/3/u = #1558 */
    { 0x0701, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/1/3/0x1 = #1559 */
    { 0x087f, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/2/0/m = #1560 */
    { 0x0800, 0x7b4e, 0xf981, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_C(1,0x2,19222) }, /* #29/2/0/u = #1561 */
    { 0x0801, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/2/0/0x1 = #1562 */
    { 0x097f, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/2/1/m = #1563 */
    { 0x0900, 0x7b4e, 0xf981, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_C(1,0x2,19222) }, /* #29/2/1/u = #1564 */
    { 0x0901, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/2/1/0x1 = #1565 */
    { 0x0a7f, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/2/2/m = #1566 */
    { 0x0a00, 0x7b4e, 0xf981, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_C(1,0x2,19222) }, /* #29/2/2/u = #1567 */
    { 0x0a01, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/2/2/0x1 = #1568 */
    { 0x0b7f, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/2/3/m = #1569 */
    { 0x0b00, 0x7b4e, 0xf981, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_C(1,0x2,19222) }, /* #29/2/3/u = #1570 */
    { 0x0b01, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/2/3/0x1 = #1571 */
    { 0x0c7f, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/3/0/m = #1572 */
    { 0x0c00, 0x7b4e, 0xf981, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_C(1,0x2,19222) }, /* #29/3/0/u = #1573 */
    { 0x0c01, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/3/0/0x1 = #1574 */
    { 0x0d7f, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/3/1/m = #1575 */
    { 0x0d00, 0x7b4e, 0xf981, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_C(1,0x2,19222) }, /* #29/3/1/u = #1576 */
    { 0x0d01, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/3/1/0x1 = #1577 */
    { 0x0e7f, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/3/2/m = #1578 */
    { 0x0e00, 0x7b4e, 0xf981, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_C(1,0x2,19222) }, /* #29/3/2/u = #1579 */
    { 0x0e01, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/3/2/0x1 = #1580 */
    { 0x0f7f, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/3/3/m = #1581 */
    { 0x0f00, 0x7b4e, 0xf981, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_C(1,0x2,19222) }, /* #29/3/3/u = #1582 */
    { 0x0f01, 0x7b4e, 0x7901, RTFLOAT80U_INIT_C(1,0x2,19222), RTFLOAT80U_INIT_IND(1) }, /* #29/3/3/0x1 = #1583 */
    { 0x007f, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/0/0/m = #1584 */
    { 0x0000, 0x229a, 0xb8a0, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/0/0/u = #1585 */
    { 0x0020, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/0/0/0x20 = #1586 */
    { 0x017f, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/0/1/m = #1587 */
    { 0x0100, 0x229a, 0xb8a0, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/0/1/u = #1588 */
    { 0x0120, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/0/1/0x20 = #1589 */
    { 0x027f, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/0/2/m = #1590 */
    { 0x0200, 0x229a, 0xb8a0, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/0/2/u = #1591 */
    { 0x0220, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/0/2/0x20 = #1592 */
    { 0x037f, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/0/3/m = #1593 */
    { 0x0300, 0x229a, 0xb8a0, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/0/3/u = #1594 */
    { 0x0320, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/0/3/0x20 = #1595 */
    { 0x047f, 0x229a, 0x3a20, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c551,8069) }, /* #30/1/0/m = #1596 */
    { 0x0400, 0x229a, 0xbaa0, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c551,8069) }, /* #30/1/0/u = #1597 */
    { 0x0420, 0x229a, 0x3a20, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c551,8069) }, /* #30/1/0/0x20 = #1598 */
    { 0x057f, 0x229a, 0x3a20, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c551,8069) }, /* #30/1/1/m = #1599 */
    { 0x0500, 0x229a, 0xbaa0, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c551,8069) }, /* #30/1/1/u = #1600 */
    { 0x0520, 0x229a, 0x3a20, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c551,8069) }, /* #30/1/1/0x20 = #1601 */
    { 0x067f, 0x229a, 0x3a20, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c551,8069) }, /* #30/1/2/m = #1602 */
    { 0x0600, 0x229a, 0xbaa0, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c551,8069) }, /* #30/1/2/u = #1603 */
    { 0x0620, 0x229a, 0x3a20, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c551,8069) }, /* #30/1/2/0x20 = #1604 */
    { 0x077f, 0x229a, 0x3a20, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c551,8069) }, /* #30/1/3/m = #1605 */
    { 0x0700, 0x229a, 0xbaa0, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c551,8069) }, /* #30/1/3/u = #1606 */
    { 0x0720, 0x229a, 0x3a20, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c551,8069) }, /* #30/1/3/0x20 = #1607 */
    { 0x087f, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/2/0/m = #1608 */
    { 0x0800, 0x229a, 0xb8a0, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/2/0/u = #1609 */
    { 0x0820, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/2/0/0x20 = #1610 */
    { 0x097f, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/2/1/m = #1611 */
    { 0x0900, 0x229a, 0xb8a0, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/2/1/u = #1612 */
    { 0x0920, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/2/1/0x20 = #1613 */
    { 0x0a7f, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/2/2/m = #1614 */
    { 0x0a00, 0x229a, 0xb8a0, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/2/2/u = #1615 */
    { 0x0a20, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/2/2/0x20 = #1616 */
    { 0x0b7f, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/2/3/m = #1617 */
    { 0x0b00, 0x229a, 0xb8a0, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/2/3/u = #1618 */
    { 0x0b20, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/2/3/0x20 = #1619 */
    { 0x0c7f, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/3/0/m = #1620 */
    { 0x0c00, 0x229a, 0xb8a0, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/3/0/u = #1621 */
    { 0x0c20, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/3/0/0x20 = #1622 */
    { 0x0d7f, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/3/1/m = #1623 */
    { 0x0d00, 0x229a, 0xb8a0, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/3/1/u = #1624 */
    { 0x0d20, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/3/1/0x20 = #1625 */
    { 0x0e7f, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/3/2/m = #1626 */
    { 0x0e00, 0x229a, 0xb8a0, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/3/2/u = #1627 */
    { 0x0e20, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/3/2/0x20 = #1628 */
    { 0x0f7f, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/3/3/m = #1629 */
    { 0x0f00, 0x229a, 0xb8a0, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/3/3/u = #1630 */
    { 0x0f20, 0x229a, 0x3820, RTFLOAT80U_INIT_C(1,0x9a5e856fbd681b18,8070), RTFLOAT80U_INIT_C(1,0xd6004d9b36d6c550,8069) }, /* #30/3/3/0x20 = #1631 */
    { 0x007f, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/0/0/m = #1632 */
    { 0x0000, 0x2737, 0xbd81, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598) }, /* #31/0/0/u = #1633 */
    { 0x0001, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/0/0/0x1 = #1634 */
    { 0x017f, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/0/1/m = #1635 */
    { 0x0100, 0x2737, 0xbd81, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598) }, /* #31/0/1/u = #1636 */
    { 0x0101, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/0/1/0x1 = #1637 */
    { 0x027f, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/0/2/m = #1638 */
    { 0x0200, 0x2737, 0xbd81, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598) }, /* #31/0/2/u = #1639 */
    { 0x0201, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/0/2/0x1 = #1640 */
    { 0x037f, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/0/3/m = #1641 */
    { 0x0300, 0x2737, 0xbd81, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598) }, /* #31/0/3/u = #1642 */
    { 0x0301, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/0/3/0x1 = #1643 */
    { 0x047f, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/1/0/m = #1644 */
    { 0x0400, 0x2737, 0xbd81, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598) }, /* #31/1/0/u = #1645 */
    { 0x0401, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/1/0/0x1 = #1646 */
    { 0x057f, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/1/1/m = #1647 */
    { 0x0500, 0x2737, 0xbd81, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598) }, /* #31/1/1/u = #1648 */
    { 0x0501, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/1/1/0x1 = #1649 */
    { 0x067f, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/1/2/m = #1650 */
    { 0x0600, 0x2737, 0xbd81, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598) }, /* #31/1/2/u = #1651 */
    { 0x0601, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/1/2/0x1 = #1652 */
    { 0x077f, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/1/3/m = #1653 */
    { 0x0700, 0x2737, 0xbd81, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598) }, /* #31/1/3/u = #1654 */
    { 0x0701, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/1/3/0x1 = #1655 */
    { 0x087f, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/2/0/m = #1656 */
    { 0x0800, 0x2737, 0xbd81, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598) }, /* #31/2/0/u = #1657 */
    { 0x0801, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/2/0/0x1 = #1658 */
    { 0x097f, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/2/1/m = #1659 */
    { 0x0900, 0x2737, 0xbd81, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598) }, /* #31/2/1/u = #1660 */
    { 0x0901, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/2/1/0x1 = #1661 */
    { 0x0a7f, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/2/2/m = #1662 */
    { 0x0a00, 0x2737, 0xbd81, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598) }, /* #31/2/2/u = #1663 */
    { 0x0a01, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/2/2/0x1 = #1664 */
    { 0x0b7f, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/2/3/m = #1665 */
    { 0x0b00, 0x2737, 0xbd81, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598) }, /* #31/2/3/u = #1666 */
    { 0x0b01, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/2/3/0x1 = #1667 */
    { 0x0c7f, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/3/0/m = #1668 */
    { 0x0c00, 0x2737, 0xbd81, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598) }, /* #31/3/0/u = #1669 */
    { 0x0c01, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/3/0/0x1 = #1670 */
    { 0x0d7f, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/3/1/m = #1671 */
    { 0x0d00, 0x2737, 0xbd81, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598) }, /* #31/3/1/u = #1672 */
    { 0x0d01, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/3/1/0x1 = #1673 */
    { 0x0e7f, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/3/2/m = #1674 */
    { 0x0e00, 0x2737, 0xbd81, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598) }, /* #31/3/2/u = #1675 */
    { 0x0e01, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/3/2/0x1 = #1676 */
    { 0x0f7f, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/3/3/m = #1677 */
    { 0x0f00, 0x2737, 0xbd81, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598) }, /* #31/3/3/u = #1678 */
    { 0x0f01, 0x2737, 0x3d01, RTFLOAT80U_INIT_C(0,0x5db13a43b03ef5bd,14598), RTFLOAT80U_INIT_IND(1) }, /* #31/3/3/0x1 = #1679 */
    { 0x007f, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/0/0/m = #1680 */
    { 0x0000, 0xd9d1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/0/0/u = #1681 */
    { 0x0020, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/0/0/0x20 = #1682 */
    { 0x017f, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/0/1/m = #1683 */
    { 0x0100, 0xd9d1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/0/1/u = #1684 */
    { 0x0120, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/0/1/0x20 = #1685 */
    { 0x027f, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/0/2/m = #1686 */
    { 0x0200, 0xd9d1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/0/2/u = #1687 */
    { 0x0220, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/0/2/0x20 = #1688 */
    { 0x037f, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/0/3/m = #1689 */
    { 0x0300, 0xd9d1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/0/3/u = #1690 */
    { 0x0320, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/0/3/0x20 = #1691 */
    { 0x047f, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/1/0/m = #1692 */
    { 0x0400, 0xd9d1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/1/0/u = #1693 */
    { 0x0420, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/1/0/0x20 = #1694 */
    { 0x057f, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/1/1/m = #1695 */
    { 0x0500, 0xd9d1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/1/1/u = #1696 */
    { 0x0520, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/1/1/0x20 = #1697 */
    { 0x067f, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/1/2/m = #1698 */
    { 0x0600, 0xd9d1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/1/2/u = #1699 */
    { 0x0620, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/1/2/0x20 = #1700 */
    { 0x077f, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/1/3/m = #1701 */
    { 0x0700, 0xd9d1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/1/3/u = #1702 */
    { 0x0720, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/1/3/0x20 = #1703 */
    { 0x087f, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/2/0/m = #1704 */
    { 0x0800, 0xd9d1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/2/0/u = #1705 */
    { 0x0820, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/2/0/0x20 = #1706 */
    { 0x097f, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/2/1/m = #1707 */
    { 0x0900, 0xd9d1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/2/1/u = #1708 */
    { 0x0920, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/2/1/0x20 = #1709 */
    { 0x0a7f, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/2/2/m = #1710 */
    { 0x0a00, 0xd9d1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/2/2/u = #1711 */
    { 0x0a20, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/2/2/0x20 = #1712 */
    { 0x0b7f, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/2/3/m = #1713 */
    { 0x0b00, 0xd9d1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/2/3/u = #1714 */
    { 0x0b20, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/2/3/0x20 = #1715 */
    { 0x0c7f, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/3/0/m = #1716 */
    { 0x0c00, 0xd9d1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/3/0/u = #1717 */
    { 0x0c20, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/3/0/0x20 = #1718 */
    { 0x0d7f, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/3/1/m = #1719 */
    { 0x0d00, 0xd9d1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/3/1/u = #1720 */
    { 0x0d20, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/3/1/0x20 = #1721 */
    { 0x0e7f, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/3/2/m = #1722 */
    { 0x0e00, 0xd9d1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/3/2/u = #1723 */
    { 0x0e20, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/3/2/0x20 = #1724 */
    { 0x0f7f, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/3/3/m = #1725 */
    { 0x0f00, 0xd9d1, 0xf9a0, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/3/3/u = #1726 */
    { 0x0f20, 0xd9d1, 0x7920, RTFLOAT80U_INIT_C(1,0x841343c314118676,25035), RTFLOAT80U_INIT_C(1,0x841343c314118676,25035) }, /* #32/3/3/0x20 = #1727 */
    { 0x007f, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/0/0/m = #1728 */
    { 0x0000, 0x1324, 0xb9a0, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/0/0/u = #1729 */
    { 0x0020, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/0/0/0x20 = #1730 */
    { 0x017f, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/0/1/m = #1731 */
    { 0x0100, 0x1324, 0xb9a0, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/0/1/u = #1732 */
    { 0x0120, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/0/1/0x20 = #1733 */
    { 0x027f, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/0/2/m = #1734 */
    { 0x0200, 0x1324, 0xb9a0, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/0/2/u = #1735 */
    { 0x0220, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/0/2/0x20 = #1736 */
    { 0x037f, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/0/3/m = #1737 */
    { 0x0300, 0x1324, 0xb9a0, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/0/3/u = #1738 */
    { 0x0320, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/0/3/0x20 = #1739 */
    { 0x047f, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/1/0/m = #1740 */
    { 0x0400, 0x1324, 0xb9a0, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/1/0/u = #1741 */
    { 0x0420, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/1/0/0x20 = #1742 */
    { 0x057f, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/1/1/m = #1743 */
    { 0x0500, 0x1324, 0xb9a0, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/1/1/u = #1744 */
    { 0x0520, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/1/1/0x20 = #1745 */
    { 0x067f, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/1/2/m = #1746 */
    { 0x0600, 0x1324, 0xb9a0, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/1/2/u = #1747 */
    { 0x0620, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/1/2/0x20 = #1748 */
    { 0x077f, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/1/3/m = #1749 */
    { 0x0700, 0x1324, 0xb9a0, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/1/3/u = #1750 */
    { 0x0720, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/1/3/0x20 = #1751 */
    { 0x087f, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/2/0/m = #1752 */
    { 0x0800, 0x1324, 0xb9a0, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/2/0/u = #1753 */
    { 0x0820, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/2/0/0x20 = #1754 */
    { 0x097f, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/2/1/m = #1755 */
    { 0x0900, 0x1324, 0xb9a0, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/2/1/u = #1756 */
    { 0x0920, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/2/1/0x20 = #1757 */
    { 0x0a7f, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/2/2/m = #1758 */
    { 0x0a00, 0x1324, 0xb9a0, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/2/2/u = #1759 */
    { 0x0a20, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/2/2/0x20 = #1760 */
    { 0x0b7f, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/2/3/m = #1761 */
    { 0x0b00, 0x1324, 0xb9a0, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/2/3/u = #1762 */
    { 0x0b20, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/2/3/0x20 = #1763 */
    { 0x0c7f, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/3/0/m = #1764 */
    { 0x0c00, 0x1324, 0xb9a0, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/3/0/u = #1765 */
    { 0x0c20, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/3/0/0x20 = #1766 */
    { 0x0d7f, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/3/1/m = #1767 */
    { 0x0d00, 0x1324, 0xb9a0, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/3/1/u = #1768 */
    { 0x0d20, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/3/1/0x20 = #1769 */
    { 0x0e7f, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/3/2/m = #1770 */
    { 0x0e00, 0x1324, 0xb9a0, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/3/2/u = #1771 */
    { 0x0e20, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/3/2/0x20 = #1772 */
    { 0x0f7f, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/3/3/m = #1773 */
    { 0x0f00, 0x1324, 0xb9a0, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/3/3/u = #1774 */
    { 0x0f20, 0x1324, 0x3920, RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888), RTFLOAT80U_INIT_C(1,0x93e7e266c2580e85,17888) }, /* #33/3/3/0x20 = #1775 */
    { 0x007f, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/0/0/m = #1776 */
    { 0x0000, 0x64c5, 0xfca0, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/0/0/u = #1777 */
    { 0x0020, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/0/0/0x20 = #1778 */
    { 0x017f, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/0/1/m = #1779 */
    { 0x0100, 0x64c5, 0xfca0, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/0/1/u = #1780 */
    { 0x0120, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/0/1/0x20 = #1781 */
    { 0x027f, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/0/2/m = #1782 */
    { 0x0200, 0x64c5, 0xfca0, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/0/2/u = #1783 */
    { 0x0220, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/0/2/0x20 = #1784 */
    { 0x037f, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/0/3/m = #1785 */
    { 0x0300, 0x64c5, 0xfca0, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/0/3/u = #1786 */
    { 0x0320, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/0/3/0x20 = #1787 */
    { 0x047f, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/1/0/m = #1788 */
    { 0x0400, 0x64c5, 0xfca0, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/1/0/u = #1789 */
    { 0x0420, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/1/0/0x20 = #1790 */
    { 0x057f, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/1/1/m = #1791 */
    { 0x0500, 0x64c5, 0xfca0, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/1/1/u = #1792 */
    { 0x0520, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/1/1/0x20 = #1793 */
    { 0x067f, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/1/2/m = #1794 */
    { 0x0600, 0x64c5, 0xfca0, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/1/2/u = #1795 */
    { 0x0620, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/1/2/0x20 = #1796 */
    { 0x077f, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/1/3/m = #1797 */
    { 0x0700, 0x64c5, 0xfca0, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/1/3/u = #1798 */
    { 0x0720, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/1/3/0x20 = #1799 */
    { 0x087f, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/2/0/m = #1800 */
    { 0x0800, 0x64c5, 0xfca0, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/2/0/u = #1801 */
    { 0x0820, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/2/0/0x20 = #1802 */
    { 0x097f, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/2/1/m = #1803 */
    { 0x0900, 0x64c5, 0xfca0, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/2/1/u = #1804 */
    { 0x0920, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/2/1/0x20 = #1805 */
    { 0x0a7f, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/2/2/m = #1806 */
    { 0x0a00, 0x64c5, 0xfca0, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/2/2/u = #1807 */
    { 0x0a20, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/2/2/0x20 = #1808 */
    { 0x0b7f, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/2/3/m = #1809 */
    { 0x0b00, 0x64c5, 0xfca0, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/2/3/u = #1810 */
    { 0x0b20, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/2/3/0x20 = #1811 */
    { 0x0c7f, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/3/0/m = #1812 */
    { 0x0c00, 0x64c5, 0xfca0, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/3/0/u = #1813 */
    { 0x0c20, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/3/0/0x20 = #1814 */
    { 0x0d7f, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/3/1/m = #1815 */
    { 0x0d00, 0x64c5, 0xfca0, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/3/1/u = #1816 */
    { 0x0d20, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/3/1/0x20 = #1817 */
    { 0x0e7f, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/3/2/m = #1818 */
    { 0x0e00, 0x64c5, 0xfca0, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/3/2/u = #1819 */
    { 0x0e20, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/3/2/0x20 = #1820 */
    { 0x0f7f, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/3/3/m = #1821 */
    { 0x0f00, 0x64c5, 0xfca0, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/3/3/u = #1822 */
    { 0x0f20, 0x64c5, 0x7c20, RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580), RTFLOAT80U_INIT_C(0,0xcfe34f083e5c0373,26580) }, /* #34/3/3/0x20 = #1823 */
    { 0x007f, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/0/0/m = #1824 */
    { 0x0000, 0x2eac, 0xbc81, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767) }, /* #35/0/0/u = #1825 */
    { 0x0001, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/0/0/0x1 = #1826 */
    { 0x017f, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/0/1/m = #1827 */
    { 0x0100, 0x2eac, 0xbc81, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767) }, /* #35/0/1/u = #1828 */
    { 0x0101, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/0/1/0x1 = #1829 */
    { 0x027f, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/0/2/m = #1830 */
    { 0x0200, 0x2eac, 0xbc81, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767) }, /* #35/0/2/u = #1831 */
    { 0x0201, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/0/2/0x1 = #1832 */
    { 0x037f, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/0/3/m = #1833 */
    { 0x0300, 0x2eac, 0xbc81, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767) }, /* #35/0/3/u = #1834 */
    { 0x0301, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/0/3/0x1 = #1835 */
    { 0x047f, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/1/0/m = #1836 */
    { 0x0400, 0x2eac, 0xbc81, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767) }, /* #35/1/0/u = #1837 */
    { 0x0401, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/1/0/0x1 = #1838 */
    { 0x057f, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/1/1/m = #1839 */
    { 0x0500, 0x2eac, 0xbc81, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767) }, /* #35/1/1/u = #1840 */
    { 0x0501, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/1/1/0x1 = #1841 */
    { 0x067f, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/1/2/m = #1842 */
    { 0x0600, 0x2eac, 0xbc81, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767) }, /* #35/1/2/u = #1843 */
    { 0x0601, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/1/2/0x1 = #1844 */
    { 0x077f, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/1/3/m = #1845 */
    { 0x0700, 0x2eac, 0xbc81, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767) }, /* #35/1/3/u = #1846 */
    { 0x0701, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/1/3/0x1 = #1847 */
    { 0x087f, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/2/0/m = #1848 */
    { 0x0800, 0x2eac, 0xbc81, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767) }, /* #35/2/0/u = #1849 */
    { 0x0801, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/2/0/0x1 = #1850 */
    { 0x097f, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/2/1/m = #1851 */
    { 0x0900, 0x2eac, 0xbc81, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767) }, /* #35/2/1/u = #1852 */
    { 0x0901, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/2/1/0x1 = #1853 */
    { 0x0a7f, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/2/2/m = #1854 */
    { 0x0a00, 0x2eac, 0xbc81, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767) }, /* #35/2/2/u = #1855 */
    { 0x0a01, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/2/2/0x1 = #1856 */
    { 0x0b7f, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/2/3/m = #1857 */
    { 0x0b00, 0x2eac, 0xbc81, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767) }, /* #35/2/3/u = #1858 */
    { 0x0b01, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/2/3/0x1 = #1859 */
    { 0x0c7f, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/3/0/m = #1860 */
    { 0x0c00, 0x2eac, 0xbc81, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767) }, /* #35/3/0/u = #1861 */
    { 0x0c01, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/3/0/0x1 = #1862 */
    { 0x0d7f, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/3/1/m = #1863 */
    { 0x0d00, 0x2eac, 0xbc81, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767) }, /* #35/3/1/u = #1864 */
    { 0x0d01, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/3/1/0x1 = #1865 */
    { 0x0e7f, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/3/2/m = #1866 */
    { 0x0e00, 0x2eac, 0xbc81, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767) }, /* #35/3/2/u = #1867 */
    { 0x0e01, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/3/2/0x1 = #1868 */
    { 0x0f7f, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/3/3/m = #1869 */
    { 0x0f00, 0x2eac, 0xbc81, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767) }, /* #35/3/3/u = #1870 */
    { 0x0f01, 0x2eac, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ca9652d05f304ed,32767), RTFLOAT80U_INIT_IND(1) }, /* #35/3/3/0x1 = #1871 */
    { 0x007f, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/0/0/m = #1872 */
    { 0x0000, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/0/0/u = #1873 */
    { 0x017f, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/0/1/m = #1874 */
    { 0x0100, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/0/1/u = #1875 */
    { 0x027f, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/0/2/m = #1876 */
    { 0x0200, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/0/2/u = #1877 */
    { 0x037f, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/0/3/m = #1878 */
    { 0x0300, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/0/3/u = #1879 */
    { 0x047f, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/1/0/m = #1880 */
    { 0x0400, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/1/0/u = #1881 */
    { 0x057f, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/1/1/m = #1882 */
    { 0x0500, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/1/1/u = #1883 */
    { 0x067f, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/1/2/m = #1884 */
    { 0x0600, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/1/2/u = #1885 */
    { 0x077f, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/1/3/m = #1886 */
    { 0x0700, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/1/3/u = #1887 */
    { 0x087f, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/2/0/m = #1888 */
    { 0x0800, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/2/0/u = #1889 */
    { 0x097f, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/2/1/m = #1890 */
    { 0x0900, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/2/1/u = #1891 */
    { 0x0a7f, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/2/2/m = #1892 */
    { 0x0a00, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/2/2/u = #1893 */
    { 0x0b7f, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/2/3/m = #1894 */
    { 0x0b00, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/2/3/u = #1895 */
    { 0x0c7f, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/3/0/m = #1896 */
    { 0x0c00, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/3/0/u = #1897 */
    { 0x0d7f, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/3/1/m = #1898 */
    { 0x0d00, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/3/1/u = #1899 */
    { 0x0e7f, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/3/2/m = #1900 */
    { 0x0e00, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/3/2/u = #1901 */
    { 0x0f7f, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/3/3/m = #1902 */
    { 0x0f00, 0x7595, 0x7d00, RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767), RTFLOAT80U_INIT_C(0,0xdf2e56e18b60f647,32767) }, /* #36/3/3/u = #1903 */
    { 0x007f, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/0/0/m = #1904 */
    { 0x0000, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/0/0/u = #1905 */
    { 0x017f, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/0/1/m = #1906 */
    { 0x0100, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/0/1/u = #1907 */
    { 0x027f, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/0/2/m = #1908 */
    { 0x0200, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/0/2/u = #1909 */
    { 0x037f, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/0/3/m = #1910 */
    { 0x0300, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/0/3/u = #1911 */
    { 0x047f, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/1/0/m = #1912 */
    { 0x0400, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/1/0/u = #1913 */
    { 0x057f, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/1/1/m = #1914 */
    { 0x0500, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/1/1/u = #1915 */
    { 0x067f, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/1/2/m = #1916 */
    { 0x0600, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/1/2/u = #1917 */
    { 0x077f, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/1/3/m = #1918 */
    { 0x0700, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/1/3/u = #1919 */
    { 0x087f, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/2/0/m = #1920 */
    { 0x0800, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/2/0/u = #1921 */
    { 0x097f, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/2/1/m = #1922 */
    { 0x0900, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/2/1/u = #1923 */
    { 0x0a7f, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/2/2/m = #1924 */
    { 0x0a00, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/2/2/u = #1925 */
    { 0x0b7f, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/2/3/m = #1926 */
    { 0x0b00, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/2/3/u = #1927 */
    { 0x0c7f, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/3/0/m = #1928 */
    { 0x0c00, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/3/0/u = #1929 */
    { 0x0d7f, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/3/1/m = #1930 */
    { 0x0d00, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/3/1/u = #1931 */
    { 0x0e7f, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/3/2/m = #1932 */
    { 0x0e00, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/3/2/u = #1933 */
    { 0x0f7f, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/3/3/m = #1934 */
    { 0x0f00, 0xdbee, 0x7900, RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767), RTFLOAT80U_INIT_C(0,0xc0000000002a03f2,32767) }, /* #37/3/3/u = #1935 */
    { 0x007f, 0x9265, 0x3a32, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/0/0/m = #1936 */
    { 0x0000, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/0/0/u = #1937 */
    { 0x0032, 0x9265, 0x3a32, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/0/0/0x32 = #1938 */
    { 0x0030, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/0/0/u0x2 = #1939 */
    { 0x0022, 0x9265, 0xbab2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0xb14bb453af305240,24576) }, /* #38/0/0/u0x10 = #1940 */
    { 0x0012, 0x9265, 0xbab2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/0/0/u0x20 = #1941 */
    { 0x017f, 0x9265, 0x3a32, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/0/1/m = #1942 */
    { 0x0100, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/0/1/u = #1943 */
    { 0x0132, 0x9265, 0x3a32, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/0/1/0x32 = #1944 */
    { 0x0130, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/0/1/u0x2 = #1945 */
    { 0x0122, 0x9265, 0xbab2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0xb14bb453af305240,24576) }, /* #38/0/1/u0x10 = #1946 */
    { 0x0112, 0x9265, 0xbab2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/0/1/u0x20 = #1947 */
    { 0x027f, 0x9265, 0x3a32, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/0/2/m = #1948 */
    { 0x0200, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/0/2/u = #1949 */
    { 0x0232, 0x9265, 0x3a32, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/0/2/0x32 = #1950 */
    { 0x0230, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/0/2/u0x2 = #1951 */
    { 0x0222, 0x9265, 0xbab2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0xb14bb453af305240,24576) }, /* #38/0/2/u0x10 = #1952 */
    { 0x0212, 0x9265, 0xbab2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/0/2/u0x20 = #1953 */
    { 0x037f, 0x9265, 0x3a32, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/0/3/m = #1954 */
    { 0x0300, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/0/3/u = #1955 */
    { 0x0332, 0x9265, 0x3a32, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/0/3/0x32 = #1956 */
    { 0x0330, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/0/3/u0x2 = #1957 */
    { 0x0322, 0x9265, 0xbab2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0xb14bb453af305240,24576) }, /* #38/0/3/u0x10 = #1958 */
    { 0x0312, 0x9265, 0xbab2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/0/3/u0x20 = #1959 */
    { 0x047f, 0x9265, 0x3a32, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/1/0/m = #1960 */
    { 0x0400, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/1/0/u = #1961 */
    { 0x0432, 0x9265, 0x3a32, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/1/0/0x32 = #1962 */
    { 0x0430, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/1/0/u0x2 = #1963 */
    { 0x0422, 0x9265, 0xbab2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0xb14bb453af305240,24576) }, /* #38/1/0/u0x10 = #1964 */
    { 0x0412, 0x9265, 0xbab2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/1/0/u0x20 = #1965 */
    { 0x057f, 0x9265, 0x3a32, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/1/1/m = #1966 */
    { 0x0500, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/1/1/u = #1967 */
    { 0x0532, 0x9265, 0x3a32, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/1/1/0x32 = #1968 */
    { 0x0530, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/1/1/u0x2 = #1969 */
    { 0x0522, 0x9265, 0xbab2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0xb14bb453af305240,24576) }, /* #38/1/1/u0x10 = #1970 */
    { 0x0512, 0x9265, 0xbab2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/1/1/u0x20 = #1971 */
    { 0x067f, 0x9265, 0x3a32, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/1/2/m = #1972 */
    { 0x0600, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/1/2/u = #1973 */
    { 0x0632, 0x9265, 0x3a32, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/1/2/0x32 = #1974 */
    { 0x0630, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/1/2/u0x2 = #1975 */
    { 0x0622, 0x9265, 0xbab2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0xb14bb453af305240,24576) }, /* #38/1/2/u0x10 = #1976 */
    { 0x0612, 0x9265, 0xbab2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/1/2/u0x20 = #1977 */
    { 0x077f, 0x9265, 0x3a32, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/1/3/m = #1978 */
    { 0x0700, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/1/3/u = #1979 */
    { 0x0732, 0x9265, 0x3a32, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/1/3/0x32 = #1980 */
    { 0x0730, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/1/3/u0x2 = #1981 */
    { 0x0722, 0x9265, 0xbab2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0xb14bb453af305240,24576) }, /* #38/1/3/u0x10 = #1982 */
    { 0x0712, 0x9265, 0xbab2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d7982920,0) }, /* #38/1/3/u0x20 = #1983 */
    { 0x087f, 0x9265, 0x3832, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/2/0/m = #1984 */
    { 0x0800, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/2/0/u = #1985 */
    { 0x0832, 0x9265, 0x3832, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/2/0/0x32 = #1986 */
    { 0x0830, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/2/0/u0x2 = #1987 */
    { 0x0822, 0x9265, 0xb8b2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0xb14bb453af30523f,24576) }, /* #38/2/0/u0x10 = #1988 */
    { 0x0812, 0x9265, 0xb8b2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/2/0/u0x20 = #1989 */
    { 0x097f, 0x9265, 0x3832, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/2/1/m = #1990 */
    { 0x0900, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/2/1/u = #1991 */
    { 0x0932, 0x9265, 0x3832, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/2/1/0x32 = #1992 */
    { 0x0930, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/2/1/u0x2 = #1993 */
    { 0x0922, 0x9265, 0xb8b2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0xb14bb453af30523f,24576) }, /* #38/2/1/u0x10 = #1994 */
    { 0x0912, 0x9265, 0xb8b2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/2/1/u0x20 = #1995 */
    { 0x0a7f, 0x9265, 0x3832, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/2/2/m = #1996 */
    { 0x0a00, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/2/2/u = #1997 */
    { 0x0a32, 0x9265, 0x3832, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/2/2/0x32 = #1998 */
    { 0x0a30, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/2/2/u0x2 = #1999 */
    { 0x0a22, 0x9265, 0xb8b2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0xb14bb453af30523f,24576) }, /* #38/2/2/u0x10 = #2000 */
    { 0x0a12, 0x9265, 0xb8b2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/2/2/u0x20 = #2001 */
    { 0x0b7f, 0x9265, 0x3832, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/2/3/m = #2002 */
    { 0x0b00, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/2/3/u = #2003 */
    { 0x0b32, 0x9265, 0x3832, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/2/3/0x32 = #2004 */
    { 0x0b30, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/2/3/u0x2 = #2005 */
    { 0x0b22, 0x9265, 0xb8b2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0xb14bb453af30523f,24576) }, /* #38/2/3/u0x10 = #2006 */
    { 0x0b12, 0x9265, 0xb8b2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/2/3/u0x20 = #2007 */
    { 0x0c7f, 0x9265, 0x3832, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/3/0/m = #2008 */
    { 0x0c00, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/3/0/u = #2009 */
    { 0x0c32, 0x9265, 0x3832, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/3/0/0x32 = #2010 */
    { 0x0c30, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/3/0/u0x2 = #2011 */
    { 0x0c22, 0x9265, 0xb8b2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0xb14bb453af30523f,24576) }, /* #38/3/0/u0x10 = #2012 */
    { 0x0c12, 0x9265, 0xb8b2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/3/0/u0x20 = #2013 */
    { 0x0d7f, 0x9265, 0x3832, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/3/1/m = #2014 */
    { 0x0d00, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/3/1/u = #2015 */
    { 0x0d32, 0x9265, 0x3832, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/3/1/0x32 = #2016 */
    { 0x0d30, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/3/1/u0x2 = #2017 */
    { 0x0d22, 0x9265, 0xb8b2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0xb14bb453af30523f,24576) }, /* #38/3/1/u0x10 = #2018 */
    { 0x0d12, 0x9265, 0xb8b2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/3/1/u0x20 = #2019 */
    { 0x0e7f, 0x9265, 0x3832, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/3/2/m = #2020 */
    { 0x0e00, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/3/2/u = #2021 */
    { 0x0e32, 0x9265, 0x3832, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/3/2/0x32 = #2022 */
    { 0x0e30, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/3/2/u0x2 = #2023 */
    { 0x0e22, 0x9265, 0xb8b2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0xb14bb453af30523f,24576) }, /* #38/3/2/u0x10 = #2024 */
    { 0x0e12, 0x9265, 0xb8b2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/3/2/u0x20 = #2025 */
    { 0x0f7f, 0x9265, 0x3832, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/3/3/m = #2026 */
    { 0x0f00, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/3/3/u = #2027 */
    { 0x0f32, 0x9265, 0x3832, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/3/3/0x32 = #2028 */
    { 0x0f30, 0x9265, 0xb882, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0) }, /* #38/3/3/u0x2 = #2029 */
    { 0x0f22, 0x9265, 0xb8b2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0xb14bb453af30523f,24576) }, /* #38/3/3/u0x10 = #2030 */
    { 0x0f12, 0x9265, 0xb8b2, RTFLOAT80U_INIT_C(1,0x7fe44edafcf40550,0), RTFLOAT80U_INIT_C(1,0x58a5da29d798291f,0) }, /* #38/3/3/u0x20 = #2031 */
    { 0x007f, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/0/0/m = #2032 */
    { 0x0000, 0xaffb, 0xbda0, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/0/0/u = #2033 */
    { 0x0020, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/0/0/0x20 = #2034 */
    { 0x017f, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/0/1/m = #2035 */
    { 0x0100, 0xaffb, 0xbda0, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/0/1/u = #2036 */
    { 0x0120, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/0/1/0x20 = #2037 */
    { 0x027f, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/0/2/m = #2038 */
    { 0x0200, 0xaffb, 0xbda0, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/0/2/u = #2039 */
    { 0x0220, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/0/2/0x20 = #2040 */
    { 0x037f, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/0/3/m = #2041 */
    { 0x0300, 0xaffb, 0xbda0, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/0/3/u = #2042 */
    { 0x0320, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/0/3/0x20 = #2043 */
    { 0x047f, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/1/0/m = #2044 */
    { 0x0400, 0xaffb, 0xbda0, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/1/0/u = #2045 */
    { 0x0420, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/1/0/0x20 = #2046 */
    { 0x057f, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/1/1/m = #2047 */
    { 0x0500, 0xaffb, 0xbda0, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/1/1/u = #2048 */
    { 0x0520, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/1/1/0x20 = #2049 */
    { 0x067f, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/1/2/m = #2050 */
    { 0x0600, 0xaffb, 0xbda0, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/1/2/u = #2051 */
    { 0x0620, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/1/2/0x20 = #2052 */
    { 0x077f, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/1/3/m = #2053 */
    { 0x0700, 0xaffb, 0xbda0, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/1/3/u = #2054 */
    { 0x0720, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/1/3/0x20 = #2055 */
    { 0x087f, 0xaffb, 0x3f20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7b,489) }, /* #39/2/0/m = #2056 */
    { 0x0800, 0xaffb, 0xbfa0, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7b,489) }, /* #39/2/0/u = #2057 */
    { 0x0820, 0xaffb, 0x3f20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7b,489) }, /* #39/2/0/0x20 = #2058 */
    { 0x097f, 0xaffb, 0x3f20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7b,489) }, /* #39/2/1/m = #2059 */
    { 0x0900, 0xaffb, 0xbfa0, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7b,489) }, /* #39/2/1/u = #2060 */
    { 0x0920, 0xaffb, 0x3f20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7b,489) }, /* #39/2/1/0x20 = #2061 */
    { 0x0a7f, 0xaffb, 0x3f20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7b,489) }, /* #39/2/2/m = #2062 */
    { 0x0a00, 0xaffb, 0xbfa0, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7b,489) }, /* #39/2/2/u = #2063 */
    { 0x0a20, 0xaffb, 0x3f20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7b,489) }, /* #39/2/2/0x20 = #2064 */
    { 0x0b7f, 0xaffb, 0x3f20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7b,489) }, /* #39/2/3/m = #2065 */
    { 0x0b00, 0xaffb, 0xbfa0, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7b,489) }, /* #39/2/3/u = #2066 */
    { 0x0b20, 0xaffb, 0x3f20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7b,489) }, /* #39/2/3/0x20 = #2067 */
    { 0x0c7f, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/3/0/m = #2068 */
    { 0x0c00, 0xaffb, 0xbda0, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/3/0/u = #2069 */
    { 0x0c20, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/3/0/0x20 = #2070 */
    { 0x0d7f, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/3/1/m = #2071 */
    { 0x0d00, 0xaffb, 0xbda0, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/3/1/u = #2072 */
    { 0x0d20, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/3/1/0x20 = #2073 */
    { 0x0e7f, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/3/2/m = #2074 */
    { 0x0e00, 0xaffb, 0xbda0, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/3/2/u = #2075 */
    { 0x0e20, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/3/2/0x20 = #2076 */
    { 0x0f7f, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/3/3/m = #2077 */
    { 0x0f00, 0xaffb, 0xbda0, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/3/3/u = #2078 */
    { 0x0f20, 0xaffb, 0x3d20, RTFLOAT80U_INIT_C(0,0x95b0aa14395c0ecc,490), RTFLOAT80U_INIT_C(0,0xcf83b88f00294f7a,489) }, /* #39/3/3/0x20 = #2079 */
    { 0x007f, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/0/0/m = #2080 */
    { 0x0000, 0xbde2, 0xbda0, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/0/0/u = #2081 */
    { 0x0020, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/0/0/0x20 = #2082 */
    { 0x017f, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/0/1/m = #2083 */
    { 0x0100, 0xbde2, 0xbda0, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/0/1/u = #2084 */
    { 0x0120, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/0/1/0x20 = #2085 */
    { 0x027f, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/0/2/m = #2086 */
    { 0x0200, 0xbde2, 0xbda0, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/0/2/u = #2087 */
    { 0x0220, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/0/2/0x20 = #2088 */
    { 0x037f, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/0/3/m = #2089 */
    { 0x0300, 0xbde2, 0xbda0, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/0/3/u = #2090 */
    { 0x0320, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/0/3/0x20 = #2091 */
    { 0x047f, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/1/0/m = #2092 */
    { 0x0400, 0xbde2, 0xbda0, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/1/0/u = #2093 */
    { 0x0420, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/1/0/0x20 = #2094 */
    { 0x057f, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/1/1/m = #2095 */
    { 0x0500, 0xbde2, 0xbda0, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/1/1/u = #2096 */
    { 0x0520, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/1/1/0x20 = #2097 */
    { 0x067f, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/1/2/m = #2098 */
    { 0x0600, 0xbde2, 0xbda0, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/1/2/u = #2099 */
    { 0x0620, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/1/2/0x20 = #2100 */
    { 0x077f, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/1/3/m = #2101 */
    { 0x0700, 0xbde2, 0xbda0, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/1/3/u = #2102 */
    { 0x0720, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/1/3/0x20 = #2103 */
    { 0x087f, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/2/0/m = #2104 */
    { 0x0800, 0xbde2, 0xbda0, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/2/0/u = #2105 */
    { 0x0820, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/2/0/0x20 = #2106 */
    { 0x097f, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/2/1/m = #2107 */
    { 0x0900, 0xbde2, 0xbda0, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/2/1/u = #2108 */
    { 0x0920, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/2/1/0x20 = #2109 */
    { 0x0a7f, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/2/2/m = #2110 */
    { 0x0a00, 0xbde2, 0xbda0, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/2/2/u = #2111 */
    { 0x0a20, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/2/2/0x20 = #2112 */
    { 0x0b7f, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/2/3/m = #2113 */
    { 0x0b00, 0xbde2, 0xbda0, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/2/3/u = #2114 */
    { 0x0b20, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/2/3/0x20 = #2115 */
    { 0x0c7f, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/3/0/m = #2116 */
    { 0x0c00, 0xbde2, 0xbda0, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/3/0/u = #2117 */
    { 0x0c20, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/3/0/0x20 = #2118 */
    { 0x0d7f, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/3/1/m = #2119 */
    { 0x0d00, 0xbde2, 0xbda0, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/3/1/u = #2120 */
    { 0x0d20, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/3/1/0x20 = #2121 */
    { 0x0e7f, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/3/2/m = #2122 */
    { 0x0e00, 0xbde2, 0xbda0, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/3/2/u = #2123 */
    { 0x0e20, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/3/2/0x20 = #2124 */
    { 0x0f7f, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/3/3/m = #2125 */
    { 0x0f00, 0xbde2, 0xbda0, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/3/3/u = #2126 */
    { 0x0f20, 0xbde2, 0x3d20, RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335), RTFLOAT80U_INIT_C(1,0x864cad77836c0b86,28335) }, /* #40/3/3/0x20 = #2127 */
    { 0x007f, 0x240d, 0x3e32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/0/0/m = #2128 */
    { 0x0000, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/0/0/u = #2129 */
    { 0x0032, 0x240d, 0x3e32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/0/0/0x32 = #2130 */
    { 0x0030, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/0/0/u0x2 = #2131 */
    { 0x0022, 0x240d, 0xbcb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xf1e15d4220d29b59,24576) }, /* #41/0/0/u0x10 = #2132 */
    { 0x0012, 0x240d, 0xbeb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/0/0/u0x20 = #2133 */
    { 0x017f, 0x240d, 0x3e32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/0/1/m = #2134 */
    { 0x0100, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/0/1/u = #2135 */
    { 0x0132, 0x240d, 0x3e32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/0/1/0x32 = #2136 */
    { 0x0130, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/0/1/u0x2 = #2137 */
    { 0x0122, 0x240d, 0xbcb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xf1e15d4220d29b59,24576) }, /* #41/0/1/u0x10 = #2138 */
    { 0x0112, 0x240d, 0xbeb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/0/1/u0x20 = #2139 */
    { 0x027f, 0x240d, 0x3e32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/0/2/m = #2140 */
    { 0x0200, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/0/2/u = #2141 */
    { 0x0232, 0x240d, 0x3e32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/0/2/0x32 = #2142 */
    { 0x0230, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/0/2/u0x2 = #2143 */
    { 0x0222, 0x240d, 0xbcb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xf1e15d4220d29b59,24576) }, /* #41/0/2/u0x10 = #2144 */
    { 0x0212, 0x240d, 0xbeb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/0/2/u0x20 = #2145 */
    { 0x037f, 0x240d, 0x3e32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/0/3/m = #2146 */
    { 0x0300, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/0/3/u = #2147 */
    { 0x0332, 0x240d, 0x3e32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/0/3/0x32 = #2148 */
    { 0x0330, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/0/3/u0x2 = #2149 */
    { 0x0322, 0x240d, 0xbcb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xf1e15d4220d29b59,24576) }, /* #41/0/3/u0x10 = #2150 */
    { 0x0312, 0x240d, 0xbeb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/0/3/u0x20 = #2151 */
    { 0x047f, 0x240d, 0x3e32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/1/0/m = #2152 */
    { 0x0400, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/1/0/u = #2153 */
    { 0x0432, 0x240d, 0x3e32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/1/0/0x32 = #2154 */
    { 0x0430, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/1/0/u0x2 = #2155 */
    { 0x0422, 0x240d, 0xbeb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xf1e15d4220d29b5a,24576) }, /* #41/1/0/u0x10 = #2156 */
    { 0x0412, 0x240d, 0xbeb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/1/0/u0x20 = #2157 */
    { 0x057f, 0x240d, 0x3e32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/1/1/m = #2158 */
    { 0x0500, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/1/1/u = #2159 */
    { 0x0532, 0x240d, 0x3e32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/1/1/0x32 = #2160 */
    { 0x0530, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/1/1/u0x2 = #2161 */
    { 0x0522, 0x240d, 0xbeb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xf1e15d4220d29b5a,24576) }, /* #41/1/1/u0x10 = #2162 */
    { 0x0512, 0x240d, 0xbeb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/1/1/u0x20 = #2163 */
    { 0x067f, 0x240d, 0x3e32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/1/2/m = #2164 */
    { 0x0600, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/1/2/u = #2165 */
    { 0x0632, 0x240d, 0x3e32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/1/2/0x32 = #2166 */
    { 0x0630, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/1/2/u0x2 = #2167 */
    { 0x0622, 0x240d, 0xbeb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xf1e15d4220d29b5a,24576) }, /* #41/1/2/u0x10 = #2168 */
    { 0x0612, 0x240d, 0xbeb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/1/2/u0x20 = #2169 */
    { 0x077f, 0x240d, 0x3e32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/1/3/m = #2170 */
    { 0x0700, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/1/3/u = #2171 */
    { 0x0732, 0x240d, 0x3e32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/1/3/0x32 = #2172 */
    { 0x0730, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/1/3/u0x2 = #2173 */
    { 0x0722, 0x240d, 0xbeb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xf1e15d4220d29b5a,24576) }, /* #41/1/3/u0x10 = #2174 */
    { 0x0712, 0x240d, 0xbeb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dad,0) }, /* #41/1/3/u0x20 = #2175 */
    { 0x087f, 0x240d, 0x3c32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/2/0/m = #2176 */
    { 0x0800, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/2/0/u = #2177 */
    { 0x0832, 0x240d, 0x3c32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/2/0/0x32 = #2178 */
    { 0x0830, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/2/0/u0x2 = #2179 */
    { 0x0822, 0x240d, 0xbcb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xf1e15d4220d29b59,24576) }, /* #41/2/0/u0x10 = #2180 */
    { 0x0812, 0x240d, 0xbcb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/2/0/u0x20 = #2181 */
    { 0x097f, 0x240d, 0x3c32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/2/1/m = #2182 */
    { 0x0900, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/2/1/u = #2183 */
    { 0x0932, 0x240d, 0x3c32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/2/1/0x32 = #2184 */
    { 0x0930, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/2/1/u0x2 = #2185 */
    { 0x0922, 0x240d, 0xbcb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xf1e15d4220d29b59,24576) }, /* #41/2/1/u0x10 = #2186 */
    { 0x0912, 0x240d, 0xbcb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/2/1/u0x20 = #2187 */
    { 0x0a7f, 0x240d, 0x3c32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/2/2/m = #2188 */
    { 0x0a00, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/2/2/u = #2189 */
    { 0x0a32, 0x240d, 0x3c32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/2/2/0x32 = #2190 */
    { 0x0a30, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/2/2/u0x2 = #2191 */
    { 0x0a22, 0x240d, 0xbcb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xf1e15d4220d29b59,24576) }, /* #41/2/2/u0x10 = #2192 */
    { 0x0a12, 0x240d, 0xbcb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/2/2/u0x20 = #2193 */
    { 0x0b7f, 0x240d, 0x3c32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/2/3/m = #2194 */
    { 0x0b00, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/2/3/u = #2195 */
    { 0x0b32, 0x240d, 0x3c32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/2/3/0x32 = #2196 */
    { 0x0b30, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/2/3/u0x2 = #2197 */
    { 0x0b22, 0x240d, 0xbcb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xf1e15d4220d29b59,24576) }, /* #41/2/3/u0x10 = #2198 */
    { 0x0b12, 0x240d, 0xbcb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/2/3/u0x20 = #2199 */
    { 0x0c7f, 0x240d, 0x3c32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/3/0/m = #2200 */
    { 0x0c00, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/3/0/u = #2201 */
    { 0x0c32, 0x240d, 0x3c32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/3/0/0x32 = #2202 */
    { 0x0c30, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/3/0/u0x2 = #2203 */
    { 0x0c22, 0x240d, 0xbcb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xf1e15d4220d29b59,24576) }, /* #41/3/0/u0x10 = #2204 */
    { 0x0c12, 0x240d, 0xbcb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/3/0/u0x20 = #2205 */
    { 0x0d7f, 0x240d, 0x3c32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/3/1/m = #2206 */
    { 0x0d00, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/3/1/u = #2207 */
    { 0x0d32, 0x240d, 0x3c32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/3/1/0x32 = #2208 */
    { 0x0d30, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/3/1/u0x2 = #2209 */
    { 0x0d22, 0x240d, 0xbcb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xf1e15d4220d29b59,24576) }, /* #41/3/1/u0x10 = #2210 */
    { 0x0d12, 0x240d, 0xbcb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/3/1/u0x20 = #2211 */
    { 0x0e7f, 0x240d, 0x3c32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/3/2/m = #2212 */
    { 0x0e00, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/3/2/u = #2213 */
    { 0x0e32, 0x240d, 0x3c32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/3/2/0x32 = #2214 */
    { 0x0e30, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/3/2/u0x2 = #2215 */
    { 0x0e22, 0x240d, 0xbcb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xf1e15d4220d29b59,24576) }, /* #41/3/2/u0x10 = #2216 */
    { 0x0e12, 0x240d, 0xbcb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/3/2/u0x20 = #2217 */
    { 0x0f7f, 0x240d, 0x3c32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/3/3/m = #2218 */
    { 0x0f00, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/3/3/u = #2219 */
    { 0x0f32, 0x240d, 0x3c32, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/3/3/0x32 = #2220 */
    { 0x0f30, 0x240d, 0xbc82, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0) }, /* #41/3/3/u0x2 = #2221 */
    { 0x0f22, 0x240d, 0xbcb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0xf1e15d4220d29b59,24576) }, /* #41/3/3/u0x10 = #2222 */
    { 0x0f12, 0x240d, 0xbcb2, RTFLOAT80U_INIT_C(1,0xae7ad2957a1af4e3,0), RTFLOAT80U_INIT_C(1,0x78f0aea110694dac,0) }, /* #41/3/3/u0x20 = #2223 */
    { 0x007f, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/0/0/m = #2224 */
    { 0x0000, 0x70e0, 0xf881, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125) }, /* #42/0/0/u = #2225 */
    { 0x0001, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/0/0/0x1 = #2226 */
    { 0x017f, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/0/1/m = #2227 */
    { 0x0100, 0x70e0, 0xf881, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125) }, /* #42/0/1/u = #2228 */
    { 0x0101, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/0/1/0x1 = #2229 */
    { 0x027f, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/0/2/m = #2230 */
    { 0x0200, 0x70e0, 0xf881, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125) }, /* #42/0/2/u = #2231 */
    { 0x0201, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/0/2/0x1 = #2232 */
    { 0x037f, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/0/3/m = #2233 */
    { 0x0300, 0x70e0, 0xf881, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125) }, /* #42/0/3/u = #2234 */
    { 0x0301, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/0/3/0x1 = #2235 */
    { 0x047f, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/1/0/m = #2236 */
    { 0x0400, 0x70e0, 0xf881, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125) }, /* #42/1/0/u = #2237 */
    { 0x0401, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/1/0/0x1 = #2238 */
    { 0x057f, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/1/1/m = #2239 */
    { 0x0500, 0x70e0, 0xf881, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125) }, /* #42/1/1/u = #2240 */
    { 0x0501, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/1/1/0x1 = #2241 */
    { 0x067f, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/1/2/m = #2242 */
    { 0x0600, 0x70e0, 0xf881, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125) }, /* #42/1/2/u = #2243 */
    { 0x0601, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/1/2/0x1 = #2244 */
    { 0x077f, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/1/3/m = #2245 */
    { 0x0700, 0x70e0, 0xf881, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125) }, /* #42/1/3/u = #2246 */
    { 0x0701, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/1/3/0x1 = #2247 */
    { 0x087f, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/2/0/m = #2248 */
    { 0x0800, 0x70e0, 0xf881, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125) }, /* #42/2/0/u = #2249 */
    { 0x0801, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/2/0/0x1 = #2250 */
    { 0x097f, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/2/1/m = #2251 */
    { 0x0900, 0x70e0, 0xf881, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125) }, /* #42/2/1/u = #2252 */
    { 0x0901, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/2/1/0x1 = #2253 */
    { 0x0a7f, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/2/2/m = #2254 */
    { 0x0a00, 0x70e0, 0xf881, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125) }, /* #42/2/2/u = #2255 */
    { 0x0a01, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/2/2/0x1 = #2256 */
    { 0x0b7f, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/2/3/m = #2257 */
    { 0x0b00, 0x70e0, 0xf881, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125) }, /* #42/2/3/u = #2258 */
    { 0x0b01, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/2/3/0x1 = #2259 */
    { 0x0c7f, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/3/0/m = #2260 */
    { 0x0c00, 0x70e0, 0xf881, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125) }, /* #42/3/0/u = #2261 */
    { 0x0c01, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/3/0/0x1 = #2262 */
    { 0x0d7f, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/3/1/m = #2263 */
    { 0x0d00, 0x70e0, 0xf881, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125) }, /* #42/3/1/u = #2264 */
    { 0x0d01, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/3/1/0x1 = #2265 */
    { 0x0e7f, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/3/2/m = #2266 */
    { 0x0e00, 0x70e0, 0xf881, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125) }, /* #42/3/2/u = #2267 */
    { 0x0e01, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/3/2/0x1 = #2268 */
    { 0x0f7f, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/3/3/m = #2269 */
    { 0x0f00, 0x70e0, 0xf881, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125) }, /* #42/3/3/u = #2270 */
    { 0x0f01, 0x70e0, 0x7801, RTFLOAT80U_INIT_C(1,0x7031ce3b68ea8a18,3125), RTFLOAT80U_INIT_IND(1) }, /* #42/3/3/0x1 = #2271 */
    { 0x007f, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/0/0/m = #2272 */
    { 0x0000, 0x03d4, 0xb981, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767) }, /* #43/0/0/u = #2273 */
    { 0x0001, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/0/0/0x1 = #2274 */
    { 0x017f, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/0/1/m = #2275 */
    { 0x0100, 0x03d4, 0xb981, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767) }, /* #43/0/1/u = #2276 */
    { 0x0101, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/0/1/0x1 = #2277 */
    { 0x027f, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/0/2/m = #2278 */
    { 0x0200, 0x03d4, 0xb981, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767) }, /* #43/0/2/u = #2279 */
    { 0x0201, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/0/2/0x1 = #2280 */
    { 0x037f, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/0/3/m = #2281 */
    { 0x0300, 0x03d4, 0xb981, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767) }, /* #43/0/3/u = #2282 */
    { 0x0301, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/0/3/0x1 = #2283 */
    { 0x047f, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/1/0/m = #2284 */
    { 0x0400, 0x03d4, 0xb981, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767) }, /* #43/1/0/u = #2285 */
    { 0x0401, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/1/0/0x1 = #2286 */
    { 0x057f, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/1/1/m = #2287 */
    { 0x0500, 0x03d4, 0xb981, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767) }, /* #43/1/1/u = #2288 */
    { 0x0501, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/1/1/0x1 = #2289 */
    { 0x067f, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/1/2/m = #2290 */
    { 0x0600, 0x03d4, 0xb981, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767) }, /* #43/1/2/u = #2291 */
    { 0x0601, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/1/2/0x1 = #2292 */
    { 0x077f, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/1/3/m = #2293 */
    { 0x0700, 0x03d4, 0xb981, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767) }, /* #43/1/3/u = #2294 */
    { 0x0701, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/1/3/0x1 = #2295 */
    { 0x087f, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/2/0/m = #2296 */
    { 0x0800, 0x03d4, 0xb981, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767) }, /* #43/2/0/u = #2297 */
    { 0x0801, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/2/0/0x1 = #2298 */
    { 0x097f, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/2/1/m = #2299 */
    { 0x0900, 0x03d4, 0xb981, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767) }, /* #43/2/1/u = #2300 */
    { 0x0901, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/2/1/0x1 = #2301 */
    { 0x0a7f, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/2/2/m = #2302 */
    { 0x0a00, 0x03d4, 0xb981, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767) }, /* #43/2/2/u = #2303 */
    { 0x0a01, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/2/2/0x1 = #2304 */
    { 0x0b7f, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/2/3/m = #2305 */
    { 0x0b00, 0x03d4, 0xb981, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767) }, /* #43/2/3/u = #2306 */
    { 0x0b01, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/2/3/0x1 = #2307 */
    { 0x0c7f, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/3/0/m = #2308 */
    { 0x0c00, 0x03d4, 0xb981, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767) }, /* #43/3/0/u = #2309 */
    { 0x0c01, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/3/0/0x1 = #2310 */
    { 0x0d7f, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/3/1/m = #2311 */
    { 0x0d00, 0x03d4, 0xb981, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767) }, /* #43/3/1/u = #2312 */
    { 0x0d01, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/3/1/0x1 = #2313 */
    { 0x0e7f, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/3/2/m = #2314 */
    { 0x0e00, 0x03d4, 0xb981, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767) }, /* #43/3/2/u = #2315 */
    { 0x0e01, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/3/2/0x1 = #2316 */
    { 0x0f7f, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/3/3/m = #2317 */
    { 0x0f00, 0x03d4, 0xb981, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767) }, /* #43/3/3/u = #2318 */
    { 0x0f01, 0x03d4, 0x3901, RTFLOAT80U_INIT_C(1,0x628ea4fc8cb49924,32767), RTFLOAT80U_INIT_IND(1) }, /* #43/3/3/0x1 = #2319 */
    { 0x007f, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/0/0/m = #2320 */
    { 0x0000, 0x9c1f, 0xbca0, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/0/0/u = #2321 */
    { 0x0020, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/0/0/0x20 = #2322 */
    { 0x017f, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/0/1/m = #2323 */
    { 0x0100, 0x9c1f, 0xbca0, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/0/1/u = #2324 */
    { 0x0120, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/0/1/0x20 = #2325 */
    { 0x027f, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/0/2/m = #2326 */
    { 0x0200, 0x9c1f, 0xbca0, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/0/2/u = #2327 */
    { 0x0220, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/0/2/0x20 = #2328 */
    { 0x037f, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/0/3/m = #2329 */
    { 0x0300, 0x9c1f, 0xbca0, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/0/3/u = #2330 */
    { 0x0320, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/0/3/0x20 = #2331 */
    { 0x047f, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/1/0/m = #2332 */
    { 0x0400, 0x9c1f, 0xbca0, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/1/0/u = #2333 */
    { 0x0420, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/1/0/0x20 = #2334 */
    { 0x057f, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/1/1/m = #2335 */
    { 0x0500, 0x9c1f, 0xbca0, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/1/1/u = #2336 */
    { 0x0520, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/1/1/0x20 = #2337 */
    { 0x067f, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/1/2/m = #2338 */
    { 0x0600, 0x9c1f, 0xbca0, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/1/2/u = #2339 */
    { 0x0620, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/1/2/0x20 = #2340 */
    { 0x077f, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/1/3/m = #2341 */
    { 0x0700, 0x9c1f, 0xbca0, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/1/3/u = #2342 */
    { 0x0720, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/1/3/0x20 = #2343 */
    { 0x087f, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/2/0/m = #2344 */
    { 0x0800, 0x9c1f, 0xbca0, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/2/0/u = #2345 */
    { 0x0820, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/2/0/0x20 = #2346 */
    { 0x097f, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/2/1/m = #2347 */
    { 0x0900, 0x9c1f, 0xbca0, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/2/1/u = #2348 */
    { 0x0920, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/2/1/0x20 = #2349 */
    { 0x0a7f, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/2/2/m = #2350 */
    { 0x0a00, 0x9c1f, 0xbca0, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/2/2/u = #2351 */
    { 0x0a20, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/2/2/0x20 = #2352 */
    { 0x0b7f, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/2/3/m = #2353 */
    { 0x0b00, 0x9c1f, 0xbca0, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/2/3/u = #2354 */
    { 0x0b20, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/2/3/0x20 = #2355 */
    { 0x0c7f, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/3/0/m = #2356 */
    { 0x0c00, 0x9c1f, 0xbca0, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/3/0/u = #2357 */
    { 0x0c20, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/3/0/0x20 = #2358 */
    { 0x0d7f, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/3/1/m = #2359 */
    { 0x0d00, 0x9c1f, 0xbca0, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/3/1/u = #2360 */
    { 0x0d20, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/3/1/0x20 = #2361 */
    { 0x0e7f, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/3/2/m = #2362 */
    { 0x0e00, 0x9c1f, 0xbca0, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/3/2/u = #2363 */
    { 0x0e20, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/3/2/0x20 = #2364 */
    { 0x0f7f, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/3/3/m = #2365 */
    { 0x0f00, 0x9c1f, 0xbca0, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/3/3/u = #2366 */
    { 0x0f20, 0x9c1f, 0x3c20, RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165), RTFLOAT80U_INIT_C(1,0xf95f5bc32f1addfb,30165) }, /* #44/3/3/0x20 = #2367 */
    { 0x007f, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/0/0/m = #2368 */
    { 0x0000, 0x102d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/0/0/u = #2369 */
    { 0x0020, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/0/0/0x20 = #2370 */
    { 0x017f, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/0/1/m = #2371 */
    { 0x0100, 0x102d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/0/1/u = #2372 */
    { 0x0120, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/0/1/0x20 = #2373 */
    { 0x027f, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/0/2/m = #2374 */
    { 0x0200, 0x102d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/0/2/u = #2375 */
    { 0x0220, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/0/2/0x20 = #2376 */
    { 0x037f, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/0/3/m = #2377 */
    { 0x0300, 0x102d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/0/3/u = #2378 */
    { 0x0320, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/0/3/0x20 = #2379 */
    { 0x047f, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/1/0/m = #2380 */
    { 0x0400, 0x102d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/1/0/u = #2381 */
    { 0x0420, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/1/0/0x20 = #2382 */
    { 0x057f, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/1/1/m = #2383 */
    { 0x0500, 0x102d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/1/1/u = #2384 */
    { 0x0520, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/1/1/0x20 = #2385 */
    { 0x067f, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/1/2/m = #2386 */
    { 0x0600, 0x102d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/1/2/u = #2387 */
    { 0x0620, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/1/2/0x20 = #2388 */
    { 0x077f, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/1/3/m = #2389 */
    { 0x0700, 0x102d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/1/3/u = #2390 */
    { 0x0720, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/1/3/0x20 = #2391 */
    { 0x087f, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/2/0/m = #2392 */
    { 0x0800, 0x102d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/2/0/u = #2393 */
    { 0x0820, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/2/0/0x20 = #2394 */
    { 0x097f, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/2/1/m = #2395 */
    { 0x0900, 0x102d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/2/1/u = #2396 */
    { 0x0920, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/2/1/0x20 = #2397 */
    { 0x0a7f, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/2/2/m = #2398 */
    { 0x0a00, 0x102d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/2/2/u = #2399 */
    { 0x0a20, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/2/2/0x20 = #2400 */
    { 0x0b7f, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/2/3/m = #2401 */
    { 0x0b00, 0x102d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/2/3/u = #2402 */
    { 0x0b20, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/2/3/0x20 = #2403 */
    { 0x0c7f, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/3/0/m = #2404 */
    { 0x0c00, 0x102d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/3/0/u = #2405 */
    { 0x0c20, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/3/0/0x20 = #2406 */
    { 0x0d7f, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/3/1/m = #2407 */
    { 0x0d00, 0x102d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/3/1/u = #2408 */
    { 0x0d20, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/3/1/0x20 = #2409 */
    { 0x0e7f, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/3/2/m = #2410 */
    { 0x0e00, 0x102d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/3/2/u = #2411 */
    { 0x0e20, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/3/2/0x20 = #2412 */
    { 0x0f7f, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/3/3/m = #2413 */
    { 0x0f00, 0x102d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/3/3/u = #2414 */
    { 0x0f20, 0x102d, 0x3820, RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645), RTFLOAT80U_INIT_C(1,0xebe0c956423cc752,24645) }, /* #45/3/3/0x20 = #2415 */
    { 0x007f, 0x80d8, 0x3a20, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/0/0/m = #2416 */
    { 0x0000, 0x80d8, 0xbaa0, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/0/0/u = #2417 */
    { 0x0020, 0x80d8, 0x3a20, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/0/0/0x20 = #2418 */
    { 0x017f, 0x80d8, 0x3a20, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/0/1/m = #2419 */
    { 0x0100, 0x80d8, 0xbaa0, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/0/1/u = #2420 */
    { 0x0120, 0x80d8, 0x3a20, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/0/1/0x20 = #2421 */
    { 0x027f, 0x80d8, 0x3a20, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/0/2/m = #2422 */
    { 0x0200, 0x80d8, 0xbaa0, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/0/2/u = #2423 */
    { 0x0220, 0x80d8, 0x3a20, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/0/2/0x20 = #2424 */
    { 0x037f, 0x80d8, 0x3a20, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/0/3/m = #2425 */
    { 0x0300, 0x80d8, 0xbaa0, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/0/3/u = #2426 */
    { 0x0320, 0x80d8, 0x3a20, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/0/3/0x20 = #2427 */
    { 0x047f, 0x80d8, 0x3a20, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/1/0/m = #2428 */
    { 0x0400, 0x80d8, 0xbaa0, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/1/0/u = #2429 */
    { 0x0420, 0x80d8, 0x3a20, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/1/0/0x20 = #2430 */
    { 0x057f, 0x80d8, 0x3a20, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/1/1/m = #2431 */
    { 0x0500, 0x80d8, 0xbaa0, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/1/1/u = #2432 */
    { 0x0520, 0x80d8, 0x3a20, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/1/1/0x20 = #2433 */
    { 0x067f, 0x80d8, 0x3a20, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/1/2/m = #2434 */
    { 0x0600, 0x80d8, 0xbaa0, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/1/2/u = #2435 */
    { 0x0620, 0x80d8, 0x3a20, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/1/2/0x20 = #2436 */
    { 0x077f, 0x80d8, 0x3a20, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/1/3/m = #2437 */
    { 0x0700, 0x80d8, 0xbaa0, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/1/3/u = #2438 */
    { 0x0720, 0x80d8, 0x3a20, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425229,5068) }, /* #46/1/3/0x20 = #2439 */
    { 0x087f, 0x80d8, 0x3820, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/2/0/m = #2440 */
    { 0x0800, 0x80d8, 0xb8a0, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/2/0/u = #2441 */
    { 0x0820, 0x80d8, 0x3820, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/2/0/0x20 = #2442 */
    { 0x097f, 0x80d8, 0x3820, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/2/1/m = #2443 */
    { 0x0900, 0x80d8, 0xb8a0, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/2/1/u = #2444 */
    { 0x0920, 0x80d8, 0x3820, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/2/1/0x20 = #2445 */
    { 0x0a7f, 0x80d8, 0x3820, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/2/2/m = #2446 */
    { 0x0a00, 0x80d8, 0xb8a0, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/2/2/u = #2447 */
    { 0x0a20, 0x80d8, 0x3820, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/2/2/0x20 = #2448 */
    { 0x0b7f, 0x80d8, 0x3820, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/2/3/m = #2449 */
    { 0x0b00, 0x80d8, 0xb8a0, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/2/3/u = #2450 */
    { 0x0b20, 0x80d8, 0x3820, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/2/3/0x20 = #2451 */
    { 0x0c7f, 0x80d8, 0x3820, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/3/0/m = #2452 */
    { 0x0c00, 0x80d8, 0xb8a0, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/3/0/u = #2453 */
    { 0x0c20, 0x80d8, 0x3820, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/3/0/0x20 = #2454 */
    { 0x0d7f, 0x80d8, 0x3820, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/3/1/m = #2455 */
    { 0x0d00, 0x80d8, 0xb8a0, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/3/1/u = #2456 */
    { 0x0d20, 0x80d8, 0x3820, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/3/1/0x20 = #2457 */
    { 0x0e7f, 0x80d8, 0x3820, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/3/2/m = #2458 */
    { 0x0e00, 0x80d8, 0xb8a0, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/3/2/u = #2459 */
    { 0x0e20, 0x80d8, 0x3820, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/3/2/0x20 = #2460 */
    { 0x0f7f, 0x80d8, 0x3820, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/3/3/m = #2461 */
    { 0x0f00, 0x80d8, 0xb8a0, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/3/3/u = #2462 */
    { 0x0f20, 0x80d8, 0x3820, RTFLOAT80U_INIT_C(1,0xa526fddf0b99c923,5069), RTFLOAT80U_INIT_C(1,0xe4f320b54a425228,5068) }, /* #46/3/3/0x20 = #2463 */
    { 0x007f, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/0/0/m = #2464 */
    { 0x0000, 0x7ec6, 0xfc81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #47/0/0/u = #2465 */
    { 0x0001, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/0/0/0x1 = #2466 */
    { 0x017f, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/0/1/m = #2467 */
    { 0x0100, 0x7ec6, 0xfc81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #47/0/1/u = #2468 */
    { 0x0101, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/0/1/0x1 = #2469 */
    { 0x027f, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/0/2/m = #2470 */
    { 0x0200, 0x7ec6, 0xfc81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #47/0/2/u = #2471 */
    { 0x0201, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/0/2/0x1 = #2472 */
    { 0x037f, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/0/3/m = #2473 */
    { 0x0300, 0x7ec6, 0xfc81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #47/0/3/u = #2474 */
    { 0x0301, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/0/3/0x1 = #2475 */
    { 0x047f, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/1/0/m = #2476 */
    { 0x0400, 0x7ec6, 0xfc81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #47/1/0/u = #2477 */
    { 0x0401, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/1/0/0x1 = #2478 */
    { 0x057f, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/1/1/m = #2479 */
    { 0x0500, 0x7ec6, 0xfc81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #47/1/1/u = #2480 */
    { 0x0501, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/1/1/0x1 = #2481 */
    { 0x067f, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/1/2/m = #2482 */
    { 0x0600, 0x7ec6, 0xfc81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #47/1/2/u = #2483 */
    { 0x0601, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/1/2/0x1 = #2484 */
    { 0x077f, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/1/3/m = #2485 */
    { 0x0700, 0x7ec6, 0xfc81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #47/1/3/u = #2486 */
    { 0x0701, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/1/3/0x1 = #2487 */
    { 0x087f, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/2/0/m = #2488 */
    { 0x0800, 0x7ec6, 0xfc81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #47/2/0/u = #2489 */
    { 0x0801, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/2/0/0x1 = #2490 */
    { 0x097f, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/2/1/m = #2491 */
    { 0x0900, 0x7ec6, 0xfc81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #47/2/1/u = #2492 */
    { 0x0901, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/2/1/0x1 = #2493 */
    { 0x0a7f, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/2/2/m = #2494 */
    { 0x0a00, 0x7ec6, 0xfc81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #47/2/2/u = #2495 */
    { 0x0a01, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/2/2/0x1 = #2496 */
    { 0x0b7f, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/2/3/m = #2497 */
    { 0x0b00, 0x7ec6, 0xfc81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #47/2/3/u = #2498 */
    { 0x0b01, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/2/3/0x1 = #2499 */
    { 0x0c7f, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/3/0/m = #2500 */
    { 0x0c00, 0x7ec6, 0xfc81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #47/3/0/u = #2501 */
    { 0x0c01, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/3/0/0x1 = #2502 */
    { 0x0d7f, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/3/1/m = #2503 */
    { 0x0d00, 0x7ec6, 0xfc81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #47/3/1/u = #2504 */
    { 0x0d01, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/3/1/0x1 = #2505 */
    { 0x0e7f, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/3/2/m = #2506 */
    { 0x0e00, 0x7ec6, 0xfc81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #47/3/2/u = #2507 */
    { 0x0e01, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/3/2/0x1 = #2508 */
    { 0x0f7f, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/3/3/m = #2509 */
    { 0x0f00, 0x7ec6, 0xfc81, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #47/3/3/u = #2510 */
    { 0x0f01, 0x7ec6, 0x7c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #47/3/3/0x1 = #2511 */
    { 0x007f, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/0/0/m = #2512 */
    { 0x0000, 0xc374, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #48/0/0/u = #2513 */
    { 0x0001, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/0/0/0x1 = #2514 */
    { 0x017f, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/0/1/m = #2515 */
    { 0x0100, 0xc374, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #48/0/1/u = #2516 */
    { 0x0101, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/0/1/0x1 = #2517 */
    { 0x027f, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/0/2/m = #2518 */
    { 0x0200, 0xc374, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #48/0/2/u = #2519 */
    { 0x0201, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/0/2/0x1 = #2520 */
    { 0x037f, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/0/3/m = #2521 */
    { 0x0300, 0xc374, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #48/0/3/u = #2522 */
    { 0x0301, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/0/3/0x1 = #2523 */
    { 0x047f, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/1/0/m = #2524 */
    { 0x0400, 0xc374, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #48/1/0/u = #2525 */
    { 0x0401, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/1/0/0x1 = #2526 */
    { 0x057f, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/1/1/m = #2527 */
    { 0x0500, 0xc374, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #48/1/1/u = #2528 */
    { 0x0501, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/1/1/0x1 = #2529 */
    { 0x067f, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/1/2/m = #2530 */
    { 0x0600, 0xc374, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #48/1/2/u = #2531 */
    { 0x0601, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/1/2/0x1 = #2532 */
    { 0x077f, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/1/3/m = #2533 */
    { 0x0700, 0xc374, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #48/1/3/u = #2534 */
    { 0x0701, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/1/3/0x1 = #2535 */
    { 0x087f, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/2/0/m = #2536 */
    { 0x0800, 0xc374, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #48/2/0/u = #2537 */
    { 0x0801, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/2/0/0x1 = #2538 */
    { 0x097f, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/2/1/m = #2539 */
    { 0x0900, 0xc374, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #48/2/1/u = #2540 */
    { 0x0901, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/2/1/0x1 = #2541 */
    { 0x0a7f, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/2/2/m = #2542 */
    { 0x0a00, 0xc374, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #48/2/2/u = #2543 */
    { 0x0a01, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/2/2/0x1 = #2544 */
    { 0x0b7f, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/2/3/m = #2545 */
    { 0x0b00, 0xc374, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #48/2/3/u = #2546 */
    { 0x0b01, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/2/3/0x1 = #2547 */
    { 0x0c7f, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/3/0/m = #2548 */
    { 0x0c00, 0xc374, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #48/3/0/u = #2549 */
    { 0x0c01, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/3/0/0x1 = #2550 */
    { 0x0d7f, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/3/1/m = #2551 */
    { 0x0d00, 0xc374, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #48/3/1/u = #2552 */
    { 0x0d01, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/3/1/0x1 = #2553 */
    { 0x0e7f, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/3/2/m = #2554 */
    { 0x0e00, 0xc374, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #48/3/2/u = #2555 */
    { 0x0e01, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/3/2/0x1 = #2556 */
    { 0x0f7f, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/3/3/m = #2557 */
    { 0x0f00, 0xc374, 0xf981, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #48/3/3/u = #2558 */
    { 0x0f01, 0xc374, 0x7901, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #48/3/3/0x1 = #2559 */
    { 0x007f, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/0/0/m = #2560 */
    { 0x0000, 0xf033, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #49/0/0/u = #2561 */
    { 0x0001, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/0/0/0x1 = #2562 */
    { 0x017f, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/0/1/m = #2563 */
    { 0x0100, 0xf033, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #49/0/1/u = #2564 */
    { 0x0101, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/0/1/0x1 = #2565 */
    { 0x027f, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/0/2/m = #2566 */
    { 0x0200, 0xf033, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #49/0/2/u = #2567 */
    { 0x0201, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/0/2/0x1 = #2568 */
    { 0x037f, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/0/3/m = #2569 */
    { 0x0300, 0xf033, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #49/0/3/u = #2570 */
    { 0x0301, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/0/3/0x1 = #2571 */
    { 0x047f, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/1/0/m = #2572 */
    { 0x0400, 0xf033, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #49/1/0/u = #2573 */
    { 0x0401, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/1/0/0x1 = #2574 */
    { 0x057f, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/1/1/m = #2575 */
    { 0x0500, 0xf033, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #49/1/1/u = #2576 */
    { 0x0501, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/1/1/0x1 = #2577 */
    { 0x067f, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/1/2/m = #2578 */
    { 0x0600, 0xf033, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #49/1/2/u = #2579 */
    { 0x0601, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/1/2/0x1 = #2580 */
    { 0x077f, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/1/3/m = #2581 */
    { 0x0700, 0xf033, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #49/1/3/u = #2582 */
    { 0x0701, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/1/3/0x1 = #2583 */
    { 0x087f, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/2/0/m = #2584 */
    { 0x0800, 0xf033, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #49/2/0/u = #2585 */
    { 0x0801, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/2/0/0x1 = #2586 */
    { 0x097f, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/2/1/m = #2587 */
    { 0x0900, 0xf033, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #49/2/1/u = #2588 */
    { 0x0901, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/2/1/0x1 = #2589 */
    { 0x0a7f, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/2/2/m = #2590 */
    { 0x0a00, 0xf033, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #49/2/2/u = #2591 */
    { 0x0a01, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/2/2/0x1 = #2592 */
    { 0x0b7f, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/2/3/m = #2593 */
    { 0x0b00, 0xf033, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #49/2/3/u = #2594 */
    { 0x0b01, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/2/3/0x1 = #2595 */
    { 0x0c7f, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/3/0/m = #2596 */
    { 0x0c00, 0xf033, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #49/3/0/u = #2597 */
    { 0x0c01, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/3/0/0x1 = #2598 */
    { 0x0d7f, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/3/1/m = #2599 */
    { 0x0d00, 0xf033, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #49/3/1/u = #2600 */
    { 0x0d01, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/3/1/0x1 = #2601 */
    { 0x0e7f, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/3/2/m = #2602 */
    { 0x0e00, 0xf033, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #49/3/2/u = #2603 */
    { 0x0e01, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/3/2/0x1 = #2604 */
    { 0x0f7f, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/3/3/m = #2605 */
    { 0x0f00, 0xf033, 0xf881, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #49/3/3/u = #2606 */
    { 0x0f01, 0xf033, 0x7801, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #49/3/3/0x1 = #2607 */
    { 0x007f, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/0/0/m = #2608 */
    { 0x0000, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/0/0/u = #2609 */
    { 0x017f, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/0/1/m = #2610 */
    { 0x0100, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/0/1/u = #2611 */
    { 0x027f, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/0/2/m = #2612 */
    { 0x0200, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/0/2/u = #2613 */
    { 0x037f, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/0/3/m = #2614 */
    { 0x0300, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/0/3/u = #2615 */
    { 0x047f, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/1/0/m = #2616 */
    { 0x0400, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/1/0/u = #2617 */
    { 0x057f, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/1/1/m = #2618 */
    { 0x0500, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/1/1/u = #2619 */
    { 0x067f, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/1/2/m = #2620 */
    { 0x0600, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/1/2/u = #2621 */
    { 0x077f, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/1/3/m = #2622 */
    { 0x0700, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/1/3/u = #2623 */
    { 0x087f, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/2/0/m = #2624 */
    { 0x0800, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/2/0/u = #2625 */
    { 0x097f, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/2/1/m = #2626 */
    { 0x0900, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/2/1/u = #2627 */
    { 0x0a7f, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/2/2/m = #2628 */
    { 0x0a00, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/2/2/u = #2629 */
    { 0x0b7f, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/2/3/m = #2630 */
    { 0x0b00, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/2/3/u = #2631 */
    { 0x0c7f, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/3/0/m = #2632 */
    { 0x0c00, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/3/0/u = #2633 */
    { 0x0d7f, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/3/1/m = #2634 */
    { 0x0d00, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/3/1/u = #2635 */
    { 0x0e7f, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/3/2/m = #2636 */
    { 0x0e00, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/3/2/u = #2637 */
    { 0x0f7f, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/3/3/m = #2638 */
    { 0x0f00, 0x59db, 0x7900, RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767), RTFLOAT80U_INIT_C(1,0xc6152e2348f0f786,32767) }, /* #50/3/3/u = #2639 */
    { 0x007f, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/0/0/m = #2640 */
    { 0x0000, 0x4e2d, 0xfca0, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/0/0/u = #2641 */
    { 0x0020, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/0/0/0x20 = #2642 */
    { 0x017f, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/0/1/m = #2643 */
    { 0x0100, 0x4e2d, 0xfca0, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/0/1/u = #2644 */
    { 0x0120, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/0/1/0x20 = #2645 */
    { 0x027f, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/0/2/m = #2646 */
    { 0x0200, 0x4e2d, 0xfca0, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/0/2/u = #2647 */
    { 0x0220, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/0/2/0x20 = #2648 */
    { 0x037f, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/0/3/m = #2649 */
    { 0x0300, 0x4e2d, 0xfca0, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/0/3/u = #2650 */
    { 0x0320, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/0/3/0x20 = #2651 */
    { 0x047f, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/1/0/m = #2652 */
    { 0x0400, 0x4e2d, 0xfca0, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/1/0/u = #2653 */
    { 0x0420, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/1/0/0x20 = #2654 */
    { 0x057f, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/1/1/m = #2655 */
    { 0x0500, 0x4e2d, 0xfca0, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/1/1/u = #2656 */
    { 0x0520, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/1/1/0x20 = #2657 */
    { 0x067f, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/1/2/m = #2658 */
    { 0x0600, 0x4e2d, 0xfca0, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/1/2/u = #2659 */
    { 0x0620, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/1/2/0x20 = #2660 */
    { 0x077f, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/1/3/m = #2661 */
    { 0x0700, 0x4e2d, 0xfca0, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/1/3/u = #2662 */
    { 0x0720, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/1/3/0x20 = #2663 */
    { 0x087f, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/2/0/m = #2664 */
    { 0x0800, 0x4e2d, 0xfca0, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/2/0/u = #2665 */
    { 0x0820, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/2/0/0x20 = #2666 */
    { 0x097f, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/2/1/m = #2667 */
    { 0x0900, 0x4e2d, 0xfca0, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/2/1/u = #2668 */
    { 0x0920, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/2/1/0x20 = #2669 */
    { 0x0a7f, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/2/2/m = #2670 */
    { 0x0a00, 0x4e2d, 0xfca0, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/2/2/u = #2671 */
    { 0x0a20, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/2/2/0x20 = #2672 */
    { 0x0b7f, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/2/3/m = #2673 */
    { 0x0b00, 0x4e2d, 0xfca0, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/2/3/u = #2674 */
    { 0x0b20, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/2/3/0x20 = #2675 */
    { 0x0c7f, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/3/0/m = #2676 */
    { 0x0c00, 0x4e2d, 0xfca0, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/3/0/u = #2677 */
    { 0x0c20, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/3/0/0x20 = #2678 */
    { 0x0d7f, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/3/1/m = #2679 */
    { 0x0d00, 0x4e2d, 0xfca0, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/3/1/u = #2680 */
    { 0x0d20, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/3/1/0x20 = #2681 */
    { 0x0e7f, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/3/2/m = #2682 */
    { 0x0e00, 0x4e2d, 0xfca0, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/3/2/u = #2683 */
    { 0x0e20, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/3/2/0x20 = #2684 */
    { 0x0f7f, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/3/3/m = #2685 */
    { 0x0f00, 0x4e2d, 0xfca0, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/3/3/u = #2686 */
    { 0x0f20, 0x4e2d, 0x7c20, RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617), RTFLOAT80U_INIT_C(0,0xc84fb7e30c9fbadb,22617) }, /* #51/3/3/0x20 = #2687 */
    { 0x007f, 0x682d, 0x7a20, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/0/0/m = #2688 */
    { 0x0000, 0x682d, 0xfaa0, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/0/0/u = #2689 */
    { 0x0020, 0x682d, 0x7a20, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/0/0/0x20 = #2690 */
    { 0x017f, 0x682d, 0x7a20, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/0/1/m = #2691 */
    { 0x0100, 0x682d, 0xfaa0, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/0/1/u = #2692 */
    { 0x0120, 0x682d, 0x7a20, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/0/1/0x20 = #2693 */
    { 0x027f, 0x682d, 0x7a20, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/0/2/m = #2694 */
    { 0x0200, 0x682d, 0xfaa0, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/0/2/u = #2695 */
    { 0x0220, 0x682d, 0x7a20, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/0/2/0x20 = #2696 */
    { 0x037f, 0x682d, 0x7a20, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/0/3/m = #2697 */
    { 0x0300, 0x682d, 0xfaa0, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/0/3/u = #2698 */
    { 0x0320, 0x682d, 0x7a20, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/0/3/0x20 = #2699 */
    { 0x047f, 0x682d, 0x7820, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/1/0/m = #2700 */
    { 0x0400, 0x682d, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/1/0/u = #2701 */
    { 0x0420, 0x682d, 0x7820, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/1/0/0x20 = #2702 */
    { 0x057f, 0x682d, 0x7820, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/1/1/m = #2703 */
    { 0x0500, 0x682d, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/1/1/u = #2704 */
    { 0x0520, 0x682d, 0x7820, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/1/1/0x20 = #2705 */
    { 0x067f, 0x682d, 0x7820, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/1/2/m = #2706 */
    { 0x0600, 0x682d, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/1/2/u = #2707 */
    { 0x0620, 0x682d, 0x7820, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/1/2/0x20 = #2708 */
    { 0x077f, 0x682d, 0x7820, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/1/3/m = #2709 */
    { 0x0700, 0x682d, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/1/3/u = #2710 */
    { 0x0720, 0x682d, 0x7820, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/1/3/0x20 = #2711 */
    { 0x087f, 0x682d, 0x7a20, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/2/0/m = #2712 */
    { 0x0800, 0x682d, 0xfaa0, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/2/0/u = #2713 */
    { 0x0820, 0x682d, 0x7a20, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/2/0/0x20 = #2714 */
    { 0x097f, 0x682d, 0x7a20, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/2/1/m = #2715 */
    { 0x0900, 0x682d, 0xfaa0, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/2/1/u = #2716 */
    { 0x0920, 0x682d, 0x7a20, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/2/1/0x20 = #2717 */
    { 0x0a7f, 0x682d, 0x7a20, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/2/2/m = #2718 */
    { 0x0a00, 0x682d, 0xfaa0, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/2/2/u = #2719 */
    { 0x0a20, 0x682d, 0x7a20, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/2/2/0x20 = #2720 */
    { 0x0b7f, 0x682d, 0x7a20, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/2/3/m = #2721 */
    { 0x0b00, 0x682d, 0xfaa0, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/2/3/u = #2722 */
    { 0x0b20, 0x682d, 0x7a20, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d4a,2316) }, /* #52/2/3/0x20 = #2723 */
    { 0x0c7f, 0x682d, 0x7820, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/3/0/m = #2724 */
    { 0x0c00, 0x682d, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/3/0/u = #2725 */
    { 0x0c20, 0x682d, 0x7820, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/3/0/0x20 = #2726 */
    { 0x0d7f, 0x682d, 0x7820, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/3/1/m = #2727 */
    { 0x0d00, 0x682d, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/3/1/u = #2728 */
    { 0x0d20, 0x682d, 0x7820, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/3/1/0x20 = #2729 */
    { 0x0e7f, 0x682d, 0x7820, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/3/2/m = #2730 */
    { 0x0e00, 0x682d, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/3/2/u = #2731 */
    { 0x0e20, 0x682d, 0x7820, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/3/2/0x20 = #2732 */
    { 0x0f7f, 0x682d, 0x7820, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/3/3/m = #2733 */
    { 0x0f00, 0x682d, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/3/3/u = #2734 */
    { 0x0f20, 0x682d, 0x7820, RTFLOAT80U_INIT_C(0,0xa8091a49b6c43593,2317), RTFLOAT80U_INIT_C(0,0xe8f25dec501b4d49,2316) }, /* #52/3/3/0x20 = #2735 */
    { 0x007f, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/0/0/m = #2736 */
    { 0x0000, 0x7505, 0xfda0, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/0/0/u = #2737 */
    { 0x0020, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/0/0/0x20 = #2738 */
    { 0x017f, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/0/1/m = #2739 */
    { 0x0100, 0x7505, 0xfda0, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/0/1/u = #2740 */
    { 0x0120, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/0/1/0x20 = #2741 */
    { 0x027f, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/0/2/m = #2742 */
    { 0x0200, 0x7505, 0xfda0, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/0/2/u = #2743 */
    { 0x0220, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/0/2/0x20 = #2744 */
    { 0x037f, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/0/3/m = #2745 */
    { 0x0300, 0x7505, 0xfda0, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/0/3/u = #2746 */
    { 0x0320, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/0/3/0x20 = #2747 */
    { 0x047f, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/1/0/m = #2748 */
    { 0x0400, 0x7505, 0xfda0, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/1/0/u = #2749 */
    { 0x0420, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/1/0/0x20 = #2750 */
    { 0x057f, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/1/1/m = #2751 */
    { 0x0500, 0x7505, 0xfda0, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/1/1/u = #2752 */
    { 0x0520, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/1/1/0x20 = #2753 */
    { 0x067f, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/1/2/m = #2754 */
    { 0x0600, 0x7505, 0xfda0, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/1/2/u = #2755 */
    { 0x0620, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/1/2/0x20 = #2756 */
    { 0x077f, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/1/3/m = #2757 */
    { 0x0700, 0x7505, 0xfda0, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/1/3/u = #2758 */
    { 0x0720, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/1/3/0x20 = #2759 */
    { 0x087f, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/2/0/m = #2760 */
    { 0x0800, 0x7505, 0xfda0, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/2/0/u = #2761 */
    { 0x0820, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/2/0/0x20 = #2762 */
    { 0x097f, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/2/1/m = #2763 */
    { 0x0900, 0x7505, 0xfda0, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/2/1/u = #2764 */
    { 0x0920, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/2/1/0x20 = #2765 */
    { 0x0a7f, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/2/2/m = #2766 */
    { 0x0a00, 0x7505, 0xfda0, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/2/2/u = #2767 */
    { 0x0a20, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/2/2/0x20 = #2768 */
    { 0x0b7f, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/2/3/m = #2769 */
    { 0x0b00, 0x7505, 0xfda0, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/2/3/u = #2770 */
    { 0x0b20, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/2/3/0x20 = #2771 */
    { 0x0c7f, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/3/0/m = #2772 */
    { 0x0c00, 0x7505, 0xfda0, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/3/0/u = #2773 */
    { 0x0c20, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/3/0/0x20 = #2774 */
    { 0x0d7f, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/3/1/m = #2775 */
    { 0x0d00, 0x7505, 0xfda0, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/3/1/u = #2776 */
    { 0x0d20, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/3/1/0x20 = #2777 */
    { 0x0e7f, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/3/2/m = #2778 */
    { 0x0e00, 0x7505, 0xfda0, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/3/2/u = #2779 */
    { 0x0e20, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/3/2/0x20 = #2780 */
    { 0x0f7f, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/3/3/m = #2781 */
    { 0x0f00, 0x7505, 0xfda0, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/3/3/u = #2782 */
    { 0x0f20, 0x7505, 0x7d20, RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032), RTFLOAT80U_INIT_C(0,0xc05f85b947d59337,30032) }, /* #53/3/3/0x20 = #2783 */
    { 0x007f, 0x407f, 0x7a32, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/0/0/m = #2784 */
    { 0x0000, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/0/0/u = #2785 */
    { 0x0032, 0x407f, 0x7a32, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/0/0/0x32 = #2786 */
    { 0x0030, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/0/0/u0x2 = #2787 */
    { 0x0022, 0x407f, 0xf8b2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0xb12cc6f8e6bc2665,24574) }, /* #54/0/0/u0x10 = #2788 */
    { 0x0012, 0x407f, 0xfab2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/0/0/u0x20 = #2789 */
    { 0x017f, 0x407f, 0x7a32, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/0/1/m = #2790 */
    { 0x0100, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/0/1/u = #2791 */
    { 0x0132, 0x407f, 0x7a32, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/0/1/0x32 = #2792 */
    { 0x0130, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/0/1/u0x2 = #2793 */
    { 0x0122, 0x407f, 0xf8b2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0xb12cc6f8e6bc2665,24574) }, /* #54/0/1/u0x10 = #2794 */
    { 0x0112, 0x407f, 0xfab2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/0/1/u0x20 = #2795 */
    { 0x027f, 0x407f, 0x7a32, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/0/2/m = #2796 */
    { 0x0200, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/0/2/u = #2797 */
    { 0x0232, 0x407f, 0x7a32, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/0/2/0x32 = #2798 */
    { 0x0230, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/0/2/u0x2 = #2799 */
    { 0x0222, 0x407f, 0xf8b2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0xb12cc6f8e6bc2665,24574) }, /* #54/0/2/u0x10 = #2800 */
    { 0x0212, 0x407f, 0xfab2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/0/2/u0x20 = #2801 */
    { 0x037f, 0x407f, 0x7a32, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/0/3/m = #2802 */
    { 0x0300, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/0/3/u = #2803 */
    { 0x0332, 0x407f, 0x7a32, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/0/3/0x32 = #2804 */
    { 0x0330, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/0/3/u0x2 = #2805 */
    { 0x0322, 0x407f, 0xf8b2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0xb12cc6f8e6bc2665,24574) }, /* #54/0/3/u0x10 = #2806 */
    { 0x0312, 0x407f, 0xfab2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/0/3/u0x20 = #2807 */
    { 0x047f, 0x407f, 0x7a32, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/1/0/m = #2808 */
    { 0x0400, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/1/0/u = #2809 */
    { 0x0432, 0x407f, 0x7a32, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/1/0/0x32 = #2810 */
    { 0x0430, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/1/0/u0x2 = #2811 */
    { 0x0422, 0x407f, 0xfab2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0xb12cc6f8e6bc2666,24574) }, /* #54/1/0/u0x10 = #2812 */
    { 0x0412, 0x407f, 0xfab2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/1/0/u0x20 = #2813 */
    { 0x057f, 0x407f, 0x7a32, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/1/1/m = #2814 */
    { 0x0500, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/1/1/u = #2815 */
    { 0x0532, 0x407f, 0x7a32, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/1/1/0x32 = #2816 */
    { 0x0530, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/1/1/u0x2 = #2817 */
    { 0x0522, 0x407f, 0xfab2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0xb12cc6f8e6bc2666,24574) }, /* #54/1/1/u0x10 = #2818 */
    { 0x0512, 0x407f, 0xfab2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/1/1/u0x20 = #2819 */
    { 0x067f, 0x407f, 0x7a32, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/1/2/m = #2820 */
    { 0x0600, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/1/2/u = #2821 */
    { 0x0632, 0x407f, 0x7a32, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/1/2/0x32 = #2822 */
    { 0x0630, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/1/2/u0x2 = #2823 */
    { 0x0622, 0x407f, 0xfab2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0xb12cc6f8e6bc2666,24574) }, /* #54/1/2/u0x10 = #2824 */
    { 0x0612, 0x407f, 0xfab2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/1/2/u0x20 = #2825 */
    { 0x077f, 0x407f, 0x7a32, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/1/3/m = #2826 */
    { 0x0700, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/1/3/u = #2827 */
    { 0x0732, 0x407f, 0x7a32, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/1/3/0x32 = #2828 */
    { 0x0730, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/1/3/u0x2 = #2829 */
    { 0x0722, 0x407f, 0xfab2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0xb12cc6f8e6bc2666,24574) }, /* #54/1/3/u0x10 = #2830 */
    { 0x0712, 0x407f, 0xfab2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cd,0) }, /* #54/1/3/u0x20 = #2831 */
    { 0x087f, 0x407f, 0x7832, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/2/0/m = #2832 */
    { 0x0800, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/2/0/u = #2833 */
    { 0x0832, 0x407f, 0x7832, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/2/0/0x32 = #2834 */
    { 0x0830, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/2/0/u0x2 = #2835 */
    { 0x0822, 0x407f, 0xf8b2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0xb12cc6f8e6bc2665,24574) }, /* #54/2/0/u0x10 = #2836 */
    { 0x0812, 0x407f, 0xf8b2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/2/0/u0x20 = #2837 */
    { 0x097f, 0x407f, 0x7832, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/2/1/m = #2838 */
    { 0x0900, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/2/1/u = #2839 */
    { 0x0932, 0x407f, 0x7832, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/2/1/0x32 = #2840 */
    { 0x0930, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/2/1/u0x2 = #2841 */
    { 0x0922, 0x407f, 0xf8b2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0xb12cc6f8e6bc2665,24574) }, /* #54/2/1/u0x10 = #2842 */
    { 0x0912, 0x407f, 0xf8b2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/2/1/u0x20 = #2843 */
    { 0x0a7f, 0x407f, 0x7832, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/2/2/m = #2844 */
    { 0x0a00, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/2/2/u = #2845 */
    { 0x0a32, 0x407f, 0x7832, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/2/2/0x32 = #2846 */
    { 0x0a30, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/2/2/u0x2 = #2847 */
    { 0x0a22, 0x407f, 0xf8b2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0xb12cc6f8e6bc2665,24574) }, /* #54/2/2/u0x10 = #2848 */
    { 0x0a12, 0x407f, 0xf8b2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/2/2/u0x20 = #2849 */
    { 0x0b7f, 0x407f, 0x7832, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/2/3/m = #2850 */
    { 0x0b00, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/2/3/u = #2851 */
    { 0x0b32, 0x407f, 0x7832, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/2/3/0x32 = #2852 */
    { 0x0b30, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/2/3/u0x2 = #2853 */
    { 0x0b22, 0x407f, 0xf8b2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0xb12cc6f8e6bc2665,24574) }, /* #54/2/3/u0x10 = #2854 */
    { 0x0b12, 0x407f, 0xf8b2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/2/3/u0x20 = #2855 */
    { 0x0c7f, 0x407f, 0x7832, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/3/0/m = #2856 */
    { 0x0c00, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/3/0/u = #2857 */
    { 0x0c32, 0x407f, 0x7832, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/3/0/0x32 = #2858 */
    { 0x0c30, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/3/0/u0x2 = #2859 */
    { 0x0c22, 0x407f, 0xf8b2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0xb12cc6f8e6bc2665,24574) }, /* #54/3/0/u0x10 = #2860 */
    { 0x0c12, 0x407f, 0xf8b2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/3/0/u0x20 = #2861 */
    { 0x0d7f, 0x407f, 0x7832, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/3/1/m = #2862 */
    { 0x0d00, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/3/1/u = #2863 */
    { 0x0d32, 0x407f, 0x7832, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/3/1/0x32 = #2864 */
    { 0x0d30, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/3/1/u0x2 = #2865 */
    { 0x0d22, 0x407f, 0xf8b2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0xb12cc6f8e6bc2665,24574) }, /* #54/3/1/u0x10 = #2866 */
    { 0x0d12, 0x407f, 0xf8b2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/3/1/u0x20 = #2867 */
    { 0x0e7f, 0x407f, 0x7832, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/3/2/m = #2868 */
    { 0x0e00, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/3/2/u = #2869 */
    { 0x0e32, 0x407f, 0x7832, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/3/2/0x32 = #2870 */
    { 0x0e30, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/3/2/u0x2 = #2871 */
    { 0x0e22, 0x407f, 0xf8b2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0xb12cc6f8e6bc2665,24574) }, /* #54/3/2/u0x10 = #2872 */
    { 0x0e12, 0x407f, 0xf8b2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/3/2/u0x20 = #2873 */
    { 0x0f7f, 0x407f, 0x7832, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/3/3/m = #2874 */
    { 0x0f00, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/3/3/u = #2875 */
    { 0x0f32, 0x407f, 0x7832, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/3/3/0x32 = #2876 */
    { 0x0f30, 0x407f, 0xf882, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0) }, /* #54/3/3/u0x2 = #2877 */
    { 0x0f22, 0x407f, 0xf8b2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0xb12cc6f8e6bc2665,24574) }, /* #54/3/3/u0x10 = #2878 */
    { 0x0f12, 0x407f, 0xf8b2, RTFLOAT80U_INIT_C(1,0x1ff37fec3e39162e,0), RTFLOAT80U_INIT_C(1,0x162598df1cd784cc,0) }, /* #54/3/3/u0x20 = #2879 */
    { 0x007f, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/0/0/m = #2880 */
    { 0x0000, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/0/0/u = #2881 */
    { 0x017f, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/0/1/m = #2882 */
    { 0x0100, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/0/1/u = #2883 */
    { 0x027f, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/0/2/m = #2884 */
    { 0x0200, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/0/2/u = #2885 */
    { 0x037f, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/0/3/m = #2886 */
    { 0x0300, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/0/3/u = #2887 */
    { 0x047f, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/1/0/m = #2888 */
    { 0x0400, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/1/0/u = #2889 */
    { 0x057f, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/1/1/m = #2890 */
    { 0x0500, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/1/1/u = #2891 */
    { 0x067f, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/1/2/m = #2892 */
    { 0x0600, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/1/2/u = #2893 */
    { 0x077f, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/1/3/m = #2894 */
    { 0x0700, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/1/3/u = #2895 */
    { 0x087f, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/2/0/m = #2896 */
    { 0x0800, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/2/0/u = #2897 */
    { 0x097f, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/2/1/m = #2898 */
    { 0x0900, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/2/1/u = #2899 */
    { 0x0a7f, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/2/2/m = #2900 */
    { 0x0a00, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/2/2/u = #2901 */
    { 0x0b7f, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/2/3/m = #2902 */
    { 0x0b00, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/2/3/u = #2903 */
    { 0x0c7f, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/3/0/m = #2904 */
    { 0x0c00, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/3/0/u = #2905 */
    { 0x0d7f, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/3/1/m = #2906 */
    { 0x0d00, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/3/1/u = #2907 */
    { 0x0e7f, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/3/2/m = #2908 */
    { 0x0e00, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/3/2/u = #2909 */
    { 0x0f7f, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/3/3/m = #2910 */
    { 0x0f00, 0xf5b8, 0x7d00, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_C(1,0x8000000000000000,16383) }, /* #55/3/3/u = #2911 */
    { 0x007f, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/0/0/m = #2912 */
    { 0x0000, 0xd669, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/0/0/u = #2913 */
    { 0x0020, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/0/0/0x20 = #2914 */
    { 0x017f, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/0/1/m = #2915 */
    { 0x0100, 0xd669, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/0/1/u = #2916 */
    { 0x0120, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/0/1/0x20 = #2917 */
    { 0x027f, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/0/2/m = #2918 */
    { 0x0200, 0xd669, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/0/2/u = #2919 */
    { 0x0220, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/0/2/0x20 = #2920 */
    { 0x037f, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/0/3/m = #2921 */
    { 0x0300, 0xd669, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/0/3/u = #2922 */
    { 0x0320, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/0/3/0x20 = #2923 */
    { 0x047f, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/1/0/m = #2924 */
    { 0x0400, 0xd669, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/1/0/u = #2925 */
    { 0x0420, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/1/0/0x20 = #2926 */
    { 0x057f, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/1/1/m = #2927 */
    { 0x0500, 0xd669, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/1/1/u = #2928 */
    { 0x0520, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/1/1/0x20 = #2929 */
    { 0x067f, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/1/2/m = #2930 */
    { 0x0600, 0xd669, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/1/2/u = #2931 */
    { 0x0620, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/1/2/0x20 = #2932 */
    { 0x077f, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/1/3/m = #2933 */
    { 0x0700, 0xd669, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/1/3/u = #2934 */
    { 0x0720, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/1/3/0x20 = #2935 */
    { 0x087f, 0xd669, 0x7e20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c4,14336) }, /* #56/2/0/m = #2936 */
    { 0x0800, 0xd669, 0xfea0, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c4,14336) }, /* #56/2/0/u = #2937 */
    { 0x0820, 0xd669, 0x7e20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c4,14336) }, /* #56/2/0/0x20 = #2938 */
    { 0x097f, 0xd669, 0x7e20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c4,14336) }, /* #56/2/1/m = #2939 */
    { 0x0900, 0xd669, 0xfea0, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c4,14336) }, /* #56/2/1/u = #2940 */
    { 0x0920, 0xd669, 0x7e20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c4,14336) }, /* #56/2/1/0x20 = #2941 */
    { 0x0a7f, 0xd669, 0x7e20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c4,14336) }, /* #56/2/2/m = #2942 */
    { 0x0a00, 0xd669, 0xfea0, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c4,14336) }, /* #56/2/2/u = #2943 */
    { 0x0a20, 0xd669, 0x7e20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c4,14336) }, /* #56/2/2/0x20 = #2944 */
    { 0x0b7f, 0xd669, 0x7e20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c4,14336) }, /* #56/2/3/m = #2945 */
    { 0x0b00, 0xd669, 0xfea0, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c4,14336) }, /* #56/2/3/u = #2946 */
    { 0x0b20, 0xd669, 0x7e20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c4,14336) }, /* #56/2/3/0x20 = #2947 */
    { 0x0c7f, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/3/0/m = #2948 */
    { 0x0c00, 0xd669, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/3/0/u = #2949 */
    { 0x0c20, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/3/0/0x20 = #2950 */
    { 0x0d7f, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/3/1/m = #2951 */
    { 0x0d00, 0xd669, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/3/1/u = #2952 */
    { 0x0d20, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/3/1/0x20 = #2953 */
    { 0x0e7f, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/3/2/m = #2954 */
    { 0x0e00, 0xd669, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/3/2/u = #2955 */
    { 0x0e20, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/3/2/0x20 = #2956 */
    { 0x0f7f, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/3/3/m = #2957 */
    { 0x0f00, 0xd669, 0xfca0, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/3/3/u = #2958 */
    { 0x0f20, 0xd669, 0x7c20, RTFLOAT80U_INIT_C(0,0x9a50eb46baad98e3,14337), RTFLOAT80U_INIT_C(0,0xd5ed724ea88149c3,14336) }, /* #56/3/3/0x20 = #2959 */
    { 0x007f, 0xaa5f, 0x3a20, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/0/0/m = #2960 */
    { 0x0000, 0xaa5f, 0xbaa0, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/0/0/u = #2961 */
    { 0x0020, 0xaa5f, 0x3a20, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/0/0/0x20 = #2962 */
    { 0x017f, 0xaa5f, 0x3a20, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/0/1/m = #2963 */
    { 0x0100, 0xaa5f, 0xbaa0, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/0/1/u = #2964 */
    { 0x0120, 0xaa5f, 0x3a20, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/0/1/0x20 = #2965 */
    { 0x027f, 0xaa5f, 0x3a20, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/0/2/m = #2966 */
    { 0x0200, 0xaa5f, 0xbaa0, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/0/2/u = #2967 */
    { 0x0220, 0xaa5f, 0x3a20, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/0/2/0x20 = #2968 */
    { 0x037f, 0xaa5f, 0x3a20, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/0/3/m = #2969 */
    { 0x0300, 0xaa5f, 0xbaa0, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/0/3/u = #2970 */
    { 0x0320, 0xaa5f, 0x3a20, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/0/3/0x20 = #2971 */
    { 0x047f, 0xaa5f, 0x3a20, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/1/0/m = #2972 */
    { 0x0400, 0xaa5f, 0xbaa0, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/1/0/u = #2973 */
    { 0x0420, 0xaa5f, 0x3a20, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/1/0/0x20 = #2974 */
    { 0x057f, 0xaa5f, 0x3a20, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/1/1/m = #2975 */
    { 0x0500, 0xaa5f, 0xbaa0, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/1/1/u = #2976 */
    { 0x0520, 0xaa5f, 0x3a20, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/1/1/0x20 = #2977 */
    { 0x067f, 0xaa5f, 0x3a20, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/1/2/m = #2978 */
    { 0x0600, 0xaa5f, 0xbaa0, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/1/2/u = #2979 */
    { 0x0620, 0xaa5f, 0x3a20, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/1/2/0x20 = #2980 */
    { 0x077f, 0xaa5f, 0x3a20, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/1/3/m = #2981 */
    { 0x0700, 0xaa5f, 0xbaa0, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/1/3/u = #2982 */
    { 0x0720, 0xaa5f, 0x3a20, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc1,10100) }, /* #57/1/3/0x20 = #2983 */
    { 0x087f, 0xaa5f, 0x3820, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/2/0/m = #2984 */
    { 0x0800, 0xaa5f, 0xb8a0, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/2/0/u = #2985 */
    { 0x0820, 0xaa5f, 0x3820, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/2/0/0x20 = #2986 */
    { 0x097f, 0xaa5f, 0x3820, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/2/1/m = #2987 */
    { 0x0900, 0xaa5f, 0xb8a0, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/2/1/u = #2988 */
    { 0x0920, 0xaa5f, 0x3820, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/2/1/0x20 = #2989 */
    { 0x0a7f, 0xaa5f, 0x3820, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/2/2/m = #2990 */
    { 0x0a00, 0xaa5f, 0xb8a0, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/2/2/u = #2991 */
    { 0x0a20, 0xaa5f, 0x3820, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/2/2/0x20 = #2992 */
    { 0x0b7f, 0xaa5f, 0x3820, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/2/3/m = #2993 */
    { 0x0b00, 0xaa5f, 0xb8a0, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/2/3/u = #2994 */
    { 0x0b20, 0xaa5f, 0x3820, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/2/3/0x20 = #2995 */
    { 0x0c7f, 0xaa5f, 0x3820, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/3/0/m = #2996 */
    { 0x0c00, 0xaa5f, 0xb8a0, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/3/0/u = #2997 */
    { 0x0c20, 0xaa5f, 0x3820, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/3/0/0x20 = #2998 */
    { 0x0d7f, 0xaa5f, 0x3820, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/3/1/m = #2999 */
    { 0x0d00, 0xaa5f, 0xb8a0, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/3/1/u = #3000 */
    { 0x0d20, 0xaa5f, 0x3820, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/3/1/0x20 = #3001 */
    { 0x0e7f, 0xaa5f, 0x3820, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/3/2/m = #3002 */
    { 0x0e00, 0xaa5f, 0xb8a0, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/3/2/u = #3003 */
    { 0x0e20, 0xaa5f, 0x3820, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/3/2/0x20 = #3004 */
    { 0x0f7f, 0xaa5f, 0x3820, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/3/3/m = #3005 */
    { 0x0f00, 0xaa5f, 0xb8a0, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/3/3/u = #3006 */
    { 0x0f20, 0xaa5f, 0x3820, RTFLOAT80U_INIT_C(1,0x90630063ddc9a49a,10101), RTFLOAT80U_INIT_C(1,0xc82999bfc76abfc0,10100) }, /* #57/3/3/0x20 = #3007 */
    { 0x007f, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/0/0/m = #3008 */
    { 0x0000, 0x41fc, 0xf981, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412) }, /* #58/0/0/u = #3009 */
    { 0x0001, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/0/0/0x1 = #3010 */
    { 0x017f, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/0/1/m = #3011 */
    { 0x0100, 0x41fc, 0xf981, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412) }, /* #58/0/1/u = #3012 */
    { 0x0101, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/0/1/0x1 = #3013 */
    { 0x027f, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/0/2/m = #3014 */
    { 0x0200, 0x41fc, 0xf981, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412) }, /* #58/0/2/u = #3015 */
    { 0x0201, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/0/2/0x1 = #3016 */
    { 0x037f, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/0/3/m = #3017 */
    { 0x0300, 0x41fc, 0xf981, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412) }, /* #58/0/3/u = #3018 */
    { 0x0301, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/0/3/0x1 = #3019 */
    { 0x047f, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/1/0/m = #3020 */
    { 0x0400, 0x41fc, 0xf981, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412) }, /* #58/1/0/u = #3021 */
    { 0x0401, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/1/0/0x1 = #3022 */
    { 0x057f, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/1/1/m = #3023 */
    { 0x0500, 0x41fc, 0xf981, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412) }, /* #58/1/1/u = #3024 */
    { 0x0501, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/1/1/0x1 = #3025 */
    { 0x067f, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/1/2/m = #3026 */
    { 0x0600, 0x41fc, 0xf981, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412) }, /* #58/1/2/u = #3027 */
    { 0x0601, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/1/2/0x1 = #3028 */
    { 0x077f, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/1/3/m = #3029 */
    { 0x0700, 0x41fc, 0xf981, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412) }, /* #58/1/3/u = #3030 */
    { 0x0701, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/1/3/0x1 = #3031 */
    { 0x087f, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/2/0/m = #3032 */
    { 0x0800, 0x41fc, 0xf981, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412) }, /* #58/2/0/u = #3033 */
    { 0x0801, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/2/0/0x1 = #3034 */
    { 0x097f, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/2/1/m = #3035 */
    { 0x0900, 0x41fc, 0xf981, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412) }, /* #58/2/1/u = #3036 */
    { 0x0901, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/2/1/0x1 = #3037 */
    { 0x0a7f, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/2/2/m = #3038 */
    { 0x0a00, 0x41fc, 0xf981, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412) }, /* #58/2/2/u = #3039 */
    { 0x0a01, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/2/2/0x1 = #3040 */
    { 0x0b7f, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/2/3/m = #3041 */
    { 0x0b00, 0x41fc, 0xf981, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412) }, /* #58/2/3/u = #3042 */
    { 0x0b01, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/2/3/0x1 = #3043 */
    { 0x0c7f, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/3/0/m = #3044 */
    { 0x0c00, 0x41fc, 0xf981, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412) }, /* #58/3/0/u = #3045 */
    { 0x0c01, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/3/0/0x1 = #3046 */
    { 0x0d7f, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/3/1/m = #3047 */
    { 0x0d00, 0x41fc, 0xf981, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412) }, /* #58/3/1/u = #3048 */
    { 0x0d01, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/3/1/0x1 = #3049 */
    { 0x0e7f, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/3/2/m = #3050 */
    { 0x0e00, 0x41fc, 0xf981, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412) }, /* #58/3/2/u = #3051 */
    { 0x0e01, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/3/2/0x1 = #3052 */
    { 0x0f7f, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/3/3/m = #3053 */
    { 0x0f00, 0x41fc, 0xf981, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412) }, /* #58/3/3/u = #3054 */
    { 0x0f01, 0x41fc, 0x7901, RTFLOAT80U_INIT_C(1,0x10035fc7e1806b13,12412), RTFLOAT80U_INIT_IND(1) }, /* #58/3/3/0x1 = #3055 */
    { 0x007f, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/0/0/m = #3056 */
    { 0x0000, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/0/0/u = #3057 */
    { 0x017f, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/0/1/m = #3058 */
    { 0x0100, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/0/1/u = #3059 */
    { 0x027f, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/0/2/m = #3060 */
    { 0x0200, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/0/2/u = #3061 */
    { 0x037f, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/0/3/m = #3062 */
    { 0x0300, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/0/3/u = #3063 */
    { 0x047f, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/1/0/m = #3064 */
    { 0x0400, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/1/0/u = #3065 */
    { 0x057f, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/1/1/m = #3066 */
    { 0x0500, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/1/1/u = #3067 */
    { 0x067f, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/1/2/m = #3068 */
    { 0x0600, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/1/2/u = #3069 */
    { 0x077f, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/1/3/m = #3070 */
    { 0x0700, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/1/3/u = #3071 */
    { 0x087f, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/2/0/m = #3072 */
    { 0x0800, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/2/0/u = #3073 */
    { 0x097f, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/2/1/m = #3074 */
    { 0x0900, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/2/1/u = #3075 */
    { 0x0a7f, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/2/2/m = #3076 */
    { 0x0a00, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/2/2/u = #3077 */
    { 0x0b7f, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/2/3/m = #3078 */
    { 0x0b00, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/2/3/u = #3079 */
    { 0x0c7f, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/3/0/m = #3080 */
    { 0x0c00, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/3/0/u = #3081 */
    { 0x0d7f, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/3/1/m = #3082 */
    { 0x0d00, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/3/1/u = #3083 */
    { 0x0e7f, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/3/2/m = #3084 */
    { 0x0e00, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/3/2/u = #3085 */
    { 0x0f7f, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/3/3/m = #3086 */
    { 0x0f00, 0xaa41, 0x3800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #59/3/3/u = #3087 */
    { 0x007f, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/0/0/m = #3088 */
    { 0x0000, 0x1c57, 0xbca0, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/0/0/u = #3089 */
    { 0x0020, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/0/0/0x20 = #3090 */
    { 0x017f, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/0/1/m = #3091 */
    { 0x0100, 0x1c57, 0xbca0, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/0/1/u = #3092 */
    { 0x0120, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/0/1/0x20 = #3093 */
    { 0x027f, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/0/2/m = #3094 */
    { 0x0200, 0x1c57, 0xbca0, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/0/2/u = #3095 */
    { 0x0220, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/0/2/0x20 = #3096 */
    { 0x037f, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/0/3/m = #3097 */
    { 0x0300, 0x1c57, 0xbca0, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/0/3/u = #3098 */
    { 0x0320, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/0/3/0x20 = #3099 */
    { 0x047f, 0x1c57, 0x3e20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e47,12238) }, /* #60/1/0/m = #3100 */
    { 0x0400, 0x1c57, 0xbea0, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e47,12238) }, /* #60/1/0/u = #3101 */
    { 0x0420, 0x1c57, 0x3e20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e47,12238) }, /* #60/1/0/0x20 = #3102 */
    { 0x057f, 0x1c57, 0x3e20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e47,12238) }, /* #60/1/1/m = #3103 */
    { 0x0500, 0x1c57, 0xbea0, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e47,12238) }, /* #60/1/1/u = #3104 */
    { 0x0520, 0x1c57, 0x3e20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e47,12238) }, /* #60/1/1/0x20 = #3105 */
    { 0x067f, 0x1c57, 0x3e20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e47,12238) }, /* #60/1/2/m = #3106 */
    { 0x0600, 0x1c57, 0xbea0, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e47,12238) }, /* #60/1/2/u = #3107 */
    { 0x0620, 0x1c57, 0x3e20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e47,12238) }, /* #60/1/2/0x20 = #3108 */
    { 0x077f, 0x1c57, 0x3e20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e47,12238) }, /* #60/1/3/m = #3109 */
    { 0x0700, 0x1c57, 0xbea0, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e47,12238) }, /* #60/1/3/u = #3110 */
    { 0x0720, 0x1c57, 0x3e20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e47,12238) }, /* #60/1/3/0x20 = #3111 */
    { 0x087f, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/2/0/m = #3112 */
    { 0x0800, 0x1c57, 0xbca0, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/2/0/u = #3113 */
    { 0x0820, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/2/0/0x20 = #3114 */
    { 0x097f, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/2/1/m = #3115 */
    { 0x0900, 0x1c57, 0xbca0, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/2/1/u = #3116 */
    { 0x0920, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/2/1/0x20 = #3117 */
    { 0x0a7f, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/2/2/m = #3118 */
    { 0x0a00, 0x1c57, 0xbca0, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/2/2/u = #3119 */
    { 0x0a20, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/2/2/0x20 = #3120 */
    { 0x0b7f, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/2/3/m = #3121 */
    { 0x0b00, 0x1c57, 0xbca0, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/2/3/u = #3122 */
    { 0x0b20, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/2/3/0x20 = #3123 */
    { 0x0c7f, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/3/0/m = #3124 */
    { 0x0c00, 0x1c57, 0xbca0, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/3/0/u = #3125 */
    { 0x0c20, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/3/0/0x20 = #3126 */
    { 0x0d7f, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/3/1/m = #3127 */
    { 0x0d00, 0x1c57, 0xbca0, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/3/1/u = #3128 */
    { 0x0d20, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/3/1/0x20 = #3129 */
    { 0x0e7f, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/3/2/m = #3130 */
    { 0x0e00, 0x1c57, 0xbca0, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/3/2/u = #3131 */
    { 0x0e20, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/3/2/0x20 = #3132 */
    { 0x0f7f, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/3/3/m = #3133 */
    { 0x0f00, 0x1c57, 0xbca0, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/3/3/u = #3134 */
    { 0x0f20, 0x1c57, 0x3c20, RTFLOAT80U_INIT_C(1,0xe026b952f9d16176,12238), RTFLOAT80U_INIT_C(1,0x9b5eac5d5d658e46,12238) }, /* #60/3/3/0x20 = #3135 */
    { 0x007f, 0xc18e, 0x7b32, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/0/0/m = #3136 */
    { 0x0000, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/0/0/u = #3137 */
    { 0x0032, 0xc18e, 0x7b32, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/0/0/0x32 = #3138 */
    { 0x0030, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/0/0/u0x2 = #3139 */
    { 0x0022, 0xc18e, 0xf9b2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0xb8325bcecf20a7f7,24574) }, /* #61/0/0/u0x10 = #3140 */
    { 0x0012, 0xc18e, 0xfbb2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/0/0/u0x20 = #3141 */
    { 0x017f, 0xc18e, 0x7b32, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/0/1/m = #3142 */
    { 0x0100, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/0/1/u = #3143 */
    { 0x0132, 0xc18e, 0x7b32, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/0/1/0x32 = #3144 */
    { 0x0130, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/0/1/u0x2 = #3145 */
    { 0x0122, 0xc18e, 0xf9b2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0xb8325bcecf20a7f7,24574) }, /* #61/0/1/u0x10 = #3146 */
    { 0x0112, 0xc18e, 0xfbb2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/0/1/u0x20 = #3147 */
    { 0x027f, 0xc18e, 0x7b32, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/0/2/m = #3148 */
    { 0x0200, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/0/2/u = #3149 */
    { 0x0232, 0xc18e, 0x7b32, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/0/2/0x32 = #3150 */
    { 0x0230, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/0/2/u0x2 = #3151 */
    { 0x0222, 0xc18e, 0xf9b2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0xb8325bcecf20a7f7,24574) }, /* #61/0/2/u0x10 = #3152 */
    { 0x0212, 0xc18e, 0xfbb2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/0/2/u0x20 = #3153 */
    { 0x037f, 0xc18e, 0x7b32, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/0/3/m = #3154 */
    { 0x0300, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/0/3/u = #3155 */
    { 0x0332, 0xc18e, 0x7b32, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/0/3/0x32 = #3156 */
    { 0x0330, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/0/3/u0x2 = #3157 */
    { 0x0322, 0xc18e, 0xf9b2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0xb8325bcecf20a7f7,24574) }, /* #61/0/3/u0x10 = #3158 */
    { 0x0312, 0xc18e, 0xfbb2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/0/3/u0x20 = #3159 */
    { 0x047f, 0xc18e, 0x7932, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/1/0/m = #3160 */
    { 0x0400, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/1/0/u = #3161 */
    { 0x0432, 0xc18e, 0x7932, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/1/0/0x32 = #3162 */
    { 0x0430, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/1/0/u0x2 = #3163 */
    { 0x0422, 0xc18e, 0xf9b2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0xb8325bcecf20a7f7,24574) }, /* #61/1/0/u0x10 = #3164 */
    { 0x0412, 0xc18e, 0xf9b2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/1/0/u0x20 = #3165 */
    { 0x057f, 0xc18e, 0x7932, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/1/1/m = #3166 */
    { 0x0500, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/1/1/u = #3167 */
    { 0x0532, 0xc18e, 0x7932, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/1/1/0x32 = #3168 */
    { 0x0530, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/1/1/u0x2 = #3169 */
    { 0x0522, 0xc18e, 0xf9b2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0xb8325bcecf20a7f7,24574) }, /* #61/1/1/u0x10 = #3170 */
    { 0x0512, 0xc18e, 0xf9b2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/1/1/u0x20 = #3171 */
    { 0x067f, 0xc18e, 0x7932, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/1/2/m = #3172 */
    { 0x0600, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/1/2/u = #3173 */
    { 0x0632, 0xc18e, 0x7932, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/1/2/0x32 = #3174 */
    { 0x0630, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/1/2/u0x2 = #3175 */
    { 0x0622, 0xc18e, 0xf9b2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0xb8325bcecf20a7f7,24574) }, /* #61/1/2/u0x10 = #3176 */
    { 0x0612, 0xc18e, 0xf9b2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/1/2/u0x20 = #3177 */
    { 0x077f, 0xc18e, 0x7932, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/1/3/m = #3178 */
    { 0x0700, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/1/3/u = #3179 */
    { 0x0732, 0xc18e, 0x7932, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/1/3/0x32 = #3180 */
    { 0x0730, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/1/3/u0x2 = #3181 */
    { 0x0722, 0xc18e, 0xf9b2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0xb8325bcecf20a7f7,24574) }, /* #61/1/3/u0x10 = #3182 */
    { 0x0712, 0xc18e, 0xf9b2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/1/3/u0x20 = #3183 */
    { 0x087f, 0xc18e, 0x7b32, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/2/0/m = #3184 */
    { 0x0800, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/2/0/u = #3185 */
    { 0x0832, 0xc18e, 0x7b32, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/2/0/0x32 = #3186 */
    { 0x0830, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/2/0/u0x2 = #3187 */
    { 0x0822, 0xc18e, 0xfbb2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0xb8325bcecf20a7f8,24574) }, /* #61/2/0/u0x10 = #3188 */
    { 0x0812, 0xc18e, 0xfbb2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/2/0/u0x20 = #3189 */
    { 0x097f, 0xc18e, 0x7b32, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/2/1/m = #3190 */
    { 0x0900, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/2/1/u = #3191 */
    { 0x0932, 0xc18e, 0x7b32, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/2/1/0x32 = #3192 */
    { 0x0930, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/2/1/u0x2 = #3193 */
    { 0x0922, 0xc18e, 0xfbb2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0xb8325bcecf20a7f8,24574) }, /* #61/2/1/u0x10 = #3194 */
    { 0x0912, 0xc18e, 0xfbb2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/2/1/u0x20 = #3195 */
    { 0x0a7f, 0xc18e, 0x7b32, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/2/2/m = #3196 */
    { 0x0a00, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/2/2/u = #3197 */
    { 0x0a32, 0xc18e, 0x7b32, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/2/2/0x32 = #3198 */
    { 0x0a30, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/2/2/u0x2 = #3199 */
    { 0x0a22, 0xc18e, 0xfbb2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0xb8325bcecf20a7f8,24574) }, /* #61/2/2/u0x10 = #3200 */
    { 0x0a12, 0xc18e, 0xfbb2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/2/2/u0x20 = #3201 */
    { 0x0b7f, 0xc18e, 0x7b32, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/2/3/m = #3202 */
    { 0x0b00, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/2/3/u = #3203 */
    { 0x0b32, 0xc18e, 0x7b32, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/2/3/0x32 = #3204 */
    { 0x0b30, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/2/3/u0x2 = #3205 */
    { 0x0b22, 0xc18e, 0xfbb2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0xb8325bcecf20a7f8,24574) }, /* #61/2/3/u0x10 = #3206 */
    { 0x0b12, 0xc18e, 0xfbb2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414ff,0) }, /* #61/2/3/u0x20 = #3207 */
    { 0x0c7f, 0xc18e, 0x7932, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/3/0/m = #3208 */
    { 0x0c00, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/3/0/u = #3209 */
    { 0x0c32, 0xc18e, 0x7932, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/3/0/0x32 = #3210 */
    { 0x0c30, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/3/0/u0x2 = #3211 */
    { 0x0c22, 0xc18e, 0xf9b2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0xb8325bcecf20a7f7,24574) }, /* #61/3/0/u0x10 = #3212 */
    { 0x0c12, 0xc18e, 0xf9b2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/3/0/u0x20 = #3213 */
    { 0x0d7f, 0xc18e, 0x7932, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/3/1/m = #3214 */
    { 0x0d00, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/3/1/u = #3215 */
    { 0x0d32, 0xc18e, 0x7932, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/3/1/0x32 = #3216 */
    { 0x0d30, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/3/1/u0x2 = #3217 */
    { 0x0d22, 0xc18e, 0xf9b2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0xb8325bcecf20a7f7,24574) }, /* #61/3/1/u0x10 = #3218 */
    { 0x0d12, 0xc18e, 0xf9b2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/3/1/u0x20 = #3219 */
    { 0x0e7f, 0xc18e, 0x7932, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/3/2/m = #3220 */
    { 0x0e00, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/3/2/u = #3221 */
    { 0x0e32, 0xc18e, 0x7932, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/3/2/0x32 = #3222 */
    { 0x0e30, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/3/2/u0x2 = #3223 */
    { 0x0e22, 0xc18e, 0xf9b2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0xb8325bcecf20a7f7,24574) }, /* #61/3/2/u0x10 = #3224 */
    { 0x0e12, 0xc18e, 0xf9b2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/3/2/u0x20 = #3225 */
    { 0x0f7f, 0xc18e, 0x7932, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/3/3/m = #3226 */
    { 0x0f00, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/3/3/u = #3227 */
    { 0x0f32, 0xc18e, 0x7932, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/3/3/0x32 = #3228 */
    { 0x0f30, 0xc18e, 0xf982, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0) }, /* #61/3/3/u0x2 = #3229 */
    { 0x0f22, 0xc18e, 0xf9b2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0xb8325bcecf20a7f7,24574) }, /* #61/3/3/u0x10 = #3230 */
    { 0x0f12, 0xc18e, 0xf9b2, RTFLOAT80U_INIT_C(0,0x2137ab7fbe6c6d40,0), RTFLOAT80U_INIT_C(0,0x17064b79d9e414fe,0) }, /* #61/3/3/u0x20 = #3231 */
    { 0x007f, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/0/0/m = #3232 */
    { 0x0000, 0x0070, 0xb8a0, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/0/0/u = #3233 */
    { 0x0020, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/0/0/0x20 = #3234 */
    { 0x017f, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/0/1/m = #3235 */
    { 0x0100, 0x0070, 0xb8a0, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/0/1/u = #3236 */
    { 0x0120, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/0/1/0x20 = #3237 */
    { 0x027f, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/0/2/m = #3238 */
    { 0x0200, 0x0070, 0xb8a0, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/0/2/u = #3239 */
    { 0x0220, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/0/2/0x20 = #3240 */
    { 0x037f, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/0/3/m = #3241 */
    { 0x0300, 0x0070, 0xb8a0, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/0/3/u = #3242 */
    { 0x0320, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/0/3/0x20 = #3243 */
    { 0x047f, 0x0070, 0x3a20, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190f,2361) }, /* #62/1/0/m = #3244 */
    { 0x0400, 0x0070, 0xbaa0, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190f,2361) }, /* #62/1/0/u = #3245 */
    { 0x0420, 0x0070, 0x3a20, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190f,2361) }, /* #62/1/0/0x20 = #3246 */
    { 0x057f, 0x0070, 0x3a20, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190f,2361) }, /* #62/1/1/m = #3247 */
    { 0x0500, 0x0070, 0xbaa0, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190f,2361) }, /* #62/1/1/u = #3248 */
    { 0x0520, 0x0070, 0x3a20, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190f,2361) }, /* #62/1/1/0x20 = #3249 */
    { 0x067f, 0x0070, 0x3a20, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190f,2361) }, /* #62/1/2/m = #3250 */
    { 0x0600, 0x0070, 0xbaa0, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190f,2361) }, /* #62/1/2/u = #3251 */
    { 0x0620, 0x0070, 0x3a20, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190f,2361) }, /* #62/1/2/0x20 = #3252 */
    { 0x077f, 0x0070, 0x3a20, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190f,2361) }, /* #62/1/3/m = #3253 */
    { 0x0700, 0x0070, 0xbaa0, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190f,2361) }, /* #62/1/3/u = #3254 */
    { 0x0720, 0x0070, 0x3a20, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190f,2361) }, /* #62/1/3/0x20 = #3255 */
    { 0x087f, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/2/0/m = #3256 */
    { 0x0800, 0x0070, 0xb8a0, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/2/0/u = #3257 */
    { 0x0820, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/2/0/0x20 = #3258 */
    { 0x097f, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/2/1/m = #3259 */
    { 0x0900, 0x0070, 0xb8a0, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/2/1/u = #3260 */
    { 0x0920, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/2/1/0x20 = #3261 */
    { 0x0a7f, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/2/2/m = #3262 */
    { 0x0a00, 0x0070, 0xb8a0, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/2/2/u = #3263 */
    { 0x0a20, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/2/2/0x20 = #3264 */
    { 0x0b7f, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/2/3/m = #3265 */
    { 0x0b00, 0x0070, 0xb8a0, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/2/3/u = #3266 */
    { 0x0b20, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/2/3/0x20 = #3267 */
    { 0x0c7f, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/3/0/m = #3268 */
    { 0x0c00, 0x0070, 0xb8a0, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/3/0/u = #3269 */
    { 0x0c20, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/3/0/0x20 = #3270 */
    { 0x0d7f, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/3/1/m = #3271 */
    { 0x0d00, 0x0070, 0xb8a0, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/3/1/u = #3272 */
    { 0x0d20, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/3/1/0x20 = #3273 */
    { 0x0e7f, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/3/2/m = #3274 */
    { 0x0e00, 0x0070, 0xb8a0, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/3/2/u = #3275 */
    { 0x0e20, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/3/2/0x20 = #3276 */
    { 0x0f7f, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/3/3/m = #3277 */
    { 0x0f00, 0x0070, 0xb8a0, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/3/3/u = #3278 */
    { 0x0f20, 0x0070, 0x3820, RTFLOAT80U_INIT_C(1,0xd2a78754ada675f6,2361), RTFLOAT80U_INIT_C(1,0x9203b6e4c937190e,2361) }, /* #62/3/3/0x20 = #3279 */
    { 0x007f, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/0/0/m = #3280 */
    { 0x0000, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/0/0/u = #3281 */
    { 0x0032, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/0/0/0x32 = #3282 */
    { 0x0030, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/0/0/u0x2 = #3283 */
    { 0x0022, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x824fc999fe145d5a,24520) }, /* #63/0/0/u0x10 = #3284 */
    { 0x0012, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/0/0/u0x20 = #3285 */
    { 0x017f, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/0/1/m = #3286 */
    { 0x0100, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/0/1/u = #3287 */
    { 0x0132, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/0/1/0x32 = #3288 */
    { 0x0130, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/0/1/u0x2 = #3289 */
    { 0x0122, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x824fc999fe145d5a,24520) }, /* #63/0/1/u0x10 = #3290 */
    { 0x0112, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/0/1/u0x20 = #3291 */
    { 0x027f, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/0/2/m = #3292 */
    { 0x0200, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/0/2/u = #3293 */
    { 0x0232, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/0/2/0x32 = #3294 */
    { 0x0230, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/0/2/u0x2 = #3295 */
    { 0x0222, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x824fc999fe145d5a,24520) }, /* #63/0/2/u0x10 = #3296 */
    { 0x0212, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/0/2/u0x20 = #3297 */
    { 0x037f, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/0/3/m = #3298 */
    { 0x0300, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/0/3/u = #3299 */
    { 0x0332, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/0/3/0x32 = #3300 */
    { 0x0330, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/0/3/u0x2 = #3301 */
    { 0x0322, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x824fc999fe145d5a,24520) }, /* #63/0/3/u0x10 = #3302 */
    { 0x0312, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/0/3/u0x20 = #3303 */
    { 0x047f, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/1/0/m = #3304 */
    { 0x0400, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/1/0/u = #3305 */
    { 0x0432, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/1/0/0x32 = #3306 */
    { 0x0430, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/1/0/u0x2 = #3307 */
    { 0x0422, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x824fc999fe145d5a,24520) }, /* #63/1/0/u0x10 = #3308 */
    { 0x0412, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/1/0/u0x20 = #3309 */
    { 0x057f, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/1/1/m = #3310 */
    { 0x0500, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/1/1/u = #3311 */
    { 0x0532, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/1/1/0x32 = #3312 */
    { 0x0530, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/1/1/u0x2 = #3313 */
    { 0x0522, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x824fc999fe145d5a,24520) }, /* #63/1/1/u0x10 = #3314 */
    { 0x0512, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/1/1/u0x20 = #3315 */
    { 0x067f, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/1/2/m = #3316 */
    { 0x0600, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/1/2/u = #3317 */
    { 0x0632, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/1/2/0x32 = #3318 */
    { 0x0630, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/1/2/u0x2 = #3319 */
    { 0x0622, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x824fc999fe145d5a,24520) }, /* #63/1/2/u0x10 = #3320 */
    { 0x0612, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/1/2/u0x20 = #3321 */
    { 0x077f, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/1/3/m = #3322 */
    { 0x0700, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/1/3/u = #3323 */
    { 0x0732, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/1/3/0x32 = #3324 */
    { 0x0730, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/1/3/u0x2 = #3325 */
    { 0x0722, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x824fc999fe145d5a,24520) }, /* #63/1/3/u0x10 = #3326 */
    { 0x0712, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/1/3/u0x20 = #3327 */
    { 0x087f, 0x8d18, 0x3f32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x42,0) }, /* #63/2/0/m = #3328 */
    { 0x0800, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/2/0/u = #3329 */
    { 0x0832, 0x8d18, 0x3f32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x42,0) }, /* #63/2/0/0x32 = #3330 */
    { 0x0830, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/2/0/u0x2 = #3331 */
    { 0x0822, 0x8d18, 0xbfb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x824fc999fe145d5b,24520) }, /* #63/2/0/u0x10 = #3332 */
    { 0x0812, 0x8d18, 0xbfb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x42,0) }, /* #63/2/0/u0x20 = #3333 */
    { 0x097f, 0x8d18, 0x3f32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x42,0) }, /* #63/2/1/m = #3334 */
    { 0x0900, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/2/1/u = #3335 */
    { 0x0932, 0x8d18, 0x3f32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x42,0) }, /* #63/2/1/0x32 = #3336 */
    { 0x0930, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/2/1/u0x2 = #3337 */
    { 0x0922, 0x8d18, 0xbfb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x824fc999fe145d5b,24520) }, /* #63/2/1/u0x10 = #3338 */
    { 0x0912, 0x8d18, 0xbfb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x42,0) }, /* #63/2/1/u0x20 = #3339 */
    { 0x0a7f, 0x8d18, 0x3f32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x42,0) }, /* #63/2/2/m = #3340 */
    { 0x0a00, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/2/2/u = #3341 */
    { 0x0a32, 0x8d18, 0x3f32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x42,0) }, /* #63/2/2/0x32 = #3342 */
    { 0x0a30, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/2/2/u0x2 = #3343 */
    { 0x0a22, 0x8d18, 0xbfb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x824fc999fe145d5b,24520) }, /* #63/2/2/u0x10 = #3344 */
    { 0x0a12, 0x8d18, 0xbfb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x42,0) }, /* #63/2/2/u0x20 = #3345 */
    { 0x0b7f, 0x8d18, 0x3f32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x42,0) }, /* #63/2/3/m = #3346 */
    { 0x0b00, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/2/3/u = #3347 */
    { 0x0b32, 0x8d18, 0x3f32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x42,0) }, /* #63/2/3/0x32 = #3348 */
    { 0x0b30, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/2/3/u0x2 = #3349 */
    { 0x0b22, 0x8d18, 0xbfb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x824fc999fe145d5b,24520) }, /* #63/2/3/u0x10 = #3350 */
    { 0x0b12, 0x8d18, 0xbfb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x42,0) }, /* #63/2/3/u0x20 = #3351 */
    { 0x0c7f, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/3/0/m = #3352 */
    { 0x0c00, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/3/0/u = #3353 */
    { 0x0c32, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/3/0/0x32 = #3354 */
    { 0x0c30, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/3/0/u0x2 = #3355 */
    { 0x0c22, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x824fc999fe145d5a,24520) }, /* #63/3/0/u0x10 = #3356 */
    { 0x0c12, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/3/0/u0x20 = #3357 */
    { 0x0d7f, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/3/1/m = #3358 */
    { 0x0d00, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/3/1/u = #3359 */
    { 0x0d32, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/3/1/0x32 = #3360 */
    { 0x0d30, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/3/1/u0x2 = #3361 */
    { 0x0d22, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x824fc999fe145d5a,24520) }, /* #63/3/1/u0x10 = #3362 */
    { 0x0d12, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/3/1/u0x20 = #3363 */
    { 0x0e7f, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/3/2/m = #3364 */
    { 0x0e00, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/3/2/u = #3365 */
    { 0x0e32, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/3/2/0x32 = #3366 */
    { 0x0e30, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/3/2/u0x2 = #3367 */
    { 0x0e22, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x824fc999fe145d5a,24520) }, /* #63/3/2/u0x10 = #3368 */
    { 0x0e12, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/3/2/u0x20 = #3369 */
    { 0x0f7f, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/3/3/m = #3370 */
    { 0x0f00, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/3/3/u = #3371 */
    { 0x0f32, 0x8d18, 0x3d32, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/3/3/0x32 = #3372 */
    { 0x0f30, 0x8d18, 0xbd82, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x5e,0) }, /* #63/3/3/u0x2 = #3373 */
    { 0x0f22, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x824fc999fe145d5a,24520) }, /* #63/3/3/u0x10 = #3374 */
    { 0x0f12, 0x8d18, 0xbdb2, RTFLOAT80U_INIT_C(0,0x5e,0), RTFLOAT80U_INIT_C(0,0x41,0) }, /* #63/3/3/u0x20 = #3375 */
    { 0x007f, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/0/0/m = #3376 */
    { 0x0000, 0x156c, 0xbda0, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/0/0/u = #3377 */
    { 0x0020, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/0/0/0x20 = #3378 */
    { 0x017f, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/0/1/m = #3379 */
    { 0x0100, 0x156c, 0xbda0, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/0/1/u = #3380 */
    { 0x0120, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/0/1/0x20 = #3381 */
    { 0x027f, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/0/2/m = #3382 */
    { 0x0200, 0x156c, 0xbda0, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/0/2/u = #3383 */
    { 0x0220, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/0/2/0x20 = #3384 */
    { 0x037f, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/0/3/m = #3385 */
    { 0x0300, 0x156c, 0xbda0, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/0/3/u = #3386 */
    { 0x0320, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/0/3/0x20 = #3387 */
    { 0x047f, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/1/0/m = #3388 */
    { 0x0400, 0x156c, 0xbda0, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/1/0/u = #3389 */
    { 0x0420, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/1/0/0x20 = #3390 */
    { 0x057f, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/1/1/m = #3391 */
    { 0x0500, 0x156c, 0xbda0, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/1/1/u = #3392 */
    { 0x0520, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/1/1/0x20 = #3393 */
    { 0x067f, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/1/2/m = #3394 */
    { 0x0600, 0x156c, 0xbda0, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/1/2/u = #3395 */
    { 0x0620, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/1/2/0x20 = #3396 */
    { 0x077f, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/1/3/m = #3397 */
    { 0x0700, 0x156c, 0xbda0, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/1/3/u = #3398 */
    { 0x0720, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/1/3/0x20 = #3399 */
    { 0x087f, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/2/0/m = #3400 */
    { 0x0800, 0x156c, 0xbda0, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/2/0/u = #3401 */
    { 0x0820, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/2/0/0x20 = #3402 */
    { 0x097f, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/2/1/m = #3403 */
    { 0x0900, 0x156c, 0xbda0, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/2/1/u = #3404 */
    { 0x0920, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/2/1/0x20 = #3405 */
    { 0x0a7f, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/2/2/m = #3406 */
    { 0x0a00, 0x156c, 0xbda0, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/2/2/u = #3407 */
    { 0x0a20, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/2/2/0x20 = #3408 */
    { 0x0b7f, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/2/3/m = #3409 */
    { 0x0b00, 0x156c, 0xbda0, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/2/3/u = #3410 */
    { 0x0b20, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/2/3/0x20 = #3411 */
    { 0x0c7f, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/3/0/m = #3412 */
    { 0x0c00, 0x156c, 0xbda0, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/3/0/u = #3413 */
    { 0x0c20, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/3/0/0x20 = #3414 */
    { 0x0d7f, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/3/1/m = #3415 */
    { 0x0d00, 0x156c, 0xbda0, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/3/1/u = #3416 */
    { 0x0d20, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/3/1/0x20 = #3417 */
    { 0x0e7f, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/3/2/m = #3418 */
    { 0x0e00, 0x156c, 0xbda0, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/3/2/u = #3419 */
    { 0x0e20, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/3/2/0x20 = #3420 */
    { 0x0f7f, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/3/3/m = #3421 */
    { 0x0f00, 0x156c, 0xbda0, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/3/3/u = #3422 */
    { 0x0f20, 0x156c, 0x3d20, RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037), RTFLOAT80U_INIT_C(1,0xedaa6dafc313116a,29037) }, /* #64/3/3/0x20 = #3423 */
    { 0x007f, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/0/0/m = #3424 */
    { 0x0000, 0xf5a7, 0xfda0, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/0/0/u = #3425 */
    { 0x0020, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/0/0/0x20 = #3426 */
    { 0x017f, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/0/1/m = #3427 */
    { 0x0100, 0xf5a7, 0xfda0, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/0/1/u = #3428 */
    { 0x0120, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/0/1/0x20 = #3429 */
    { 0x027f, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/0/2/m = #3430 */
    { 0x0200, 0xf5a7, 0xfda0, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/0/2/u = #3431 */
    { 0x0220, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/0/2/0x20 = #3432 */
    { 0x037f, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/0/3/m = #3433 */
    { 0x0300, 0xf5a7, 0xfda0, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/0/3/u = #3434 */
    { 0x0320, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/0/3/0x20 = #3435 */
    { 0x047f, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/1/0/m = #3436 */
    { 0x0400, 0xf5a7, 0xfda0, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/1/0/u = #3437 */
    { 0x0420, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/1/0/0x20 = #3438 */
    { 0x057f, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/1/1/m = #3439 */
    { 0x0500, 0xf5a7, 0xfda0, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/1/1/u = #3440 */
    { 0x0520, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/1/1/0x20 = #3441 */
    { 0x067f, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/1/2/m = #3442 */
    { 0x0600, 0xf5a7, 0xfda0, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/1/2/u = #3443 */
    { 0x0620, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/1/2/0x20 = #3444 */
    { 0x077f, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/1/3/m = #3445 */
    { 0x0700, 0xf5a7, 0xfda0, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/1/3/u = #3446 */
    { 0x0720, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/1/3/0x20 = #3447 */
    { 0x087f, 0xf5a7, 0x7f20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9e,5620) }, /* #65/2/0/m = #3448 */
    { 0x0800, 0xf5a7, 0xffa0, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9e,5620) }, /* #65/2/0/u = #3449 */
    { 0x0820, 0xf5a7, 0x7f20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9e,5620) }, /* #65/2/0/0x20 = #3450 */
    { 0x097f, 0xf5a7, 0x7f20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9e,5620) }, /* #65/2/1/m = #3451 */
    { 0x0900, 0xf5a7, 0xffa0, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9e,5620) }, /* #65/2/1/u = #3452 */
    { 0x0920, 0xf5a7, 0x7f20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9e,5620) }, /* #65/2/1/0x20 = #3453 */
    { 0x0a7f, 0xf5a7, 0x7f20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9e,5620) }, /* #65/2/2/m = #3454 */
    { 0x0a00, 0xf5a7, 0xffa0, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9e,5620) }, /* #65/2/2/u = #3455 */
    { 0x0a20, 0xf5a7, 0x7f20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9e,5620) }, /* #65/2/2/0x20 = #3456 */
    { 0x0b7f, 0xf5a7, 0x7f20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9e,5620) }, /* #65/2/3/m = #3457 */
    { 0x0b00, 0xf5a7, 0xffa0, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9e,5620) }, /* #65/2/3/u = #3458 */
    { 0x0b20, 0xf5a7, 0x7f20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9e,5620) }, /* #65/2/3/0x20 = #3459 */
    { 0x0c7f, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/3/0/m = #3460 */
    { 0x0c00, 0xf5a7, 0xfda0, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/3/0/u = #3461 */
    { 0x0c20, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/3/0/0x20 = #3462 */
    { 0x0d7f, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/3/1/m = #3463 */
    { 0x0d00, 0xf5a7, 0xfda0, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/3/1/u = #3464 */
    { 0x0d20, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/3/1/0x20 = #3465 */
    { 0x0e7f, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/3/2/m = #3466 */
    { 0x0e00, 0xf5a7, 0xfda0, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/3/2/u = #3467 */
    { 0x0e20, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/3/2/0x20 = #3468 */
    { 0x0f7f, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/3/3/m = #3469 */
    { 0x0f00, 0xf5a7, 0xfda0, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/3/3/u = #3470 */
    { 0x0f20, 0xf5a7, 0x7d20, RTFLOAT80U_INIT_C(0,0x83e9535e0c26e705,5621), RTFLOAT80U_INIT_C(0,0xb6de39c99e032e9d,5620) }, /* #65/3/3/0x20 = #3471 */
    { 0x007f, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/0/0/m = #3472 */
    { 0x0000, 0x2c41, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/0/0/u = #3473 */
    { 0x0020, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/0/0/0x20 = #3474 */
    { 0x017f, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/0/1/m = #3475 */
    { 0x0100, 0x2c41, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/0/1/u = #3476 */
    { 0x0120, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/0/1/0x20 = #3477 */
    { 0x027f, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/0/2/m = #3478 */
    { 0x0200, 0x2c41, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/0/2/u = #3479 */
    { 0x0220, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/0/2/0x20 = #3480 */
    { 0x037f, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/0/3/m = #3481 */
    { 0x0300, 0x2c41, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/0/3/u = #3482 */
    { 0x0320, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/0/3/0x20 = #3483 */
    { 0x047f, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/1/0/m = #3484 */
    { 0x0400, 0x2c41, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/1/0/u = #3485 */
    { 0x0420, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/1/0/0x20 = #3486 */
    { 0x057f, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/1/1/m = #3487 */
    { 0x0500, 0x2c41, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/1/1/u = #3488 */
    { 0x0520, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/1/1/0x20 = #3489 */
    { 0x067f, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/1/2/m = #3490 */
    { 0x0600, 0x2c41, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/1/2/u = #3491 */
    { 0x0620, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/1/2/0x20 = #3492 */
    { 0x077f, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/1/3/m = #3493 */
    { 0x0700, 0x2c41, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/1/3/u = #3494 */
    { 0x0720, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/1/3/0x20 = #3495 */
    { 0x087f, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/2/0/m = #3496 */
    { 0x0800, 0x2c41, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/2/0/u = #3497 */
    { 0x0820, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/2/0/0x20 = #3498 */
    { 0x097f, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/2/1/m = #3499 */
    { 0x0900, 0x2c41, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/2/1/u = #3500 */
    { 0x0920, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/2/1/0x20 = #3501 */
    { 0x0a7f, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/2/2/m = #3502 */
    { 0x0a00, 0x2c41, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/2/2/u = #3503 */
    { 0x0a20, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/2/2/0x20 = #3504 */
    { 0x0b7f, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/2/3/m = #3505 */
    { 0x0b00, 0x2c41, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/2/3/u = #3506 */
    { 0x0b20, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/2/3/0x20 = #3507 */
    { 0x0c7f, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/3/0/m = #3508 */
    { 0x0c00, 0x2c41, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/3/0/u = #3509 */
    { 0x0c20, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/3/0/0x20 = #3510 */
    { 0x0d7f, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/3/1/m = #3511 */
    { 0x0d00, 0x2c41, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/3/1/u = #3512 */
    { 0x0d20, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/3/1/0x20 = #3513 */
    { 0x0e7f, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/3/2/m = #3514 */
    { 0x0e00, 0x2c41, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/3/2/u = #3515 */
    { 0x0e20, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/3/2/0x20 = #3516 */
    { 0x0f7f, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/3/3/m = #3517 */
    { 0x0f00, 0x2c41, 0xbca0, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/3/3/u = #3518 */
    { 0x0f20, 0x2c41, 0x3c20, RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388), RTFLOAT80U_INIT_C(0,0xcc04dee28c27bab0,20388) }, /* #66/3/3/0x20 = #3519 */
    { 0x007f, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/0/0/m = #3520 */
    { 0x0000, 0x2852, 0xb881, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767) }, /* #67/0/0/u = #3521 */
    { 0x0001, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/0/0/0x1 = #3522 */
    { 0x017f, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/0/1/m = #3523 */
    { 0x0100, 0x2852, 0xb881, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767) }, /* #67/0/1/u = #3524 */
    { 0x0101, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/0/1/0x1 = #3525 */
    { 0x027f, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/0/2/m = #3526 */
    { 0x0200, 0x2852, 0xb881, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767) }, /* #67/0/2/u = #3527 */
    { 0x0201, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/0/2/0x1 = #3528 */
    { 0x037f, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/0/3/m = #3529 */
    { 0x0300, 0x2852, 0xb881, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767) }, /* #67/0/3/u = #3530 */
    { 0x0301, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/0/3/0x1 = #3531 */
    { 0x047f, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/1/0/m = #3532 */
    { 0x0400, 0x2852, 0xb881, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767) }, /* #67/1/0/u = #3533 */
    { 0x0401, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/1/0/0x1 = #3534 */
    { 0x057f, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/1/1/m = #3535 */
    { 0x0500, 0x2852, 0xb881, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767) }, /* #67/1/1/u = #3536 */
    { 0x0501, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/1/1/0x1 = #3537 */
    { 0x067f, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/1/2/m = #3538 */
    { 0x0600, 0x2852, 0xb881, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767) }, /* #67/1/2/u = #3539 */
    { 0x0601, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/1/2/0x1 = #3540 */
    { 0x077f, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/1/3/m = #3541 */
    { 0x0700, 0x2852, 0xb881, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767) }, /* #67/1/3/u = #3542 */
    { 0x0701, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/1/3/0x1 = #3543 */
    { 0x087f, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/2/0/m = #3544 */
    { 0x0800, 0x2852, 0xb881, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767) }, /* #67/2/0/u = #3545 */
    { 0x0801, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/2/0/0x1 = #3546 */
    { 0x097f, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/2/1/m = #3547 */
    { 0x0900, 0x2852, 0xb881, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767) }, /* #67/2/1/u = #3548 */
    { 0x0901, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/2/1/0x1 = #3549 */
    { 0x0a7f, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/2/2/m = #3550 */
    { 0x0a00, 0x2852, 0xb881, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767) }, /* #67/2/2/u = #3551 */
    { 0x0a01, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/2/2/0x1 = #3552 */
    { 0x0b7f, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/2/3/m = #3553 */
    { 0x0b00, 0x2852, 0xb881, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767) }, /* #67/2/3/u = #3554 */
    { 0x0b01, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/2/3/0x1 = #3555 */
    { 0x0c7f, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/3/0/m = #3556 */
    { 0x0c00, 0x2852, 0xb881, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767) }, /* #67/3/0/u = #3557 */
    { 0x0c01, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/3/0/0x1 = #3558 */
    { 0x0d7f, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/3/1/m = #3559 */
    { 0x0d00, 0x2852, 0xb881, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767) }, /* #67/3/1/u = #3560 */
    { 0x0d01, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/3/1/0x1 = #3561 */
    { 0x0e7f, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/3/2/m = #3562 */
    { 0x0e00, 0x2852, 0xb881, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767) }, /* #67/3/2/u = #3563 */
    { 0x0e01, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/3/2/0x1 = #3564 */
    { 0x0f7f, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/3/3/m = #3565 */
    { 0x0f00, 0x2852, 0xb881, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767) }, /* #67/3/3/u = #3566 */
    { 0x0f01, 0x2852, 0x3801, RTFLOAT80U_INIT_C(0,0x8ea3e36c2bc285a6,32767), RTFLOAT80U_INIT_C(0,0xcea3e36c2bc285a6,32767) }, /* #67/3/3/0x1 = #3567 */
    { 0x007f, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/0/0/m = #3568 */
    { 0x0000, 0xa338, 0xb981, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614) }, /* #68/0/0/u = #3569 */
    { 0x0001, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/0/0/0x1 = #3570 */
    { 0x017f, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/0/1/m = #3571 */
    { 0x0100, 0xa338, 0xb981, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614) }, /* #68/0/1/u = #3572 */
    { 0x0101, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/0/1/0x1 = #3573 */
    { 0x027f, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/0/2/m = #3574 */
    { 0x0200, 0xa338, 0xb981, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614) }, /* #68/0/2/u = #3575 */
    { 0x0201, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/0/2/0x1 = #3576 */
    { 0x037f, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/0/3/m = #3577 */
    { 0x0300, 0xa338, 0xb981, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614) }, /* #68/0/3/u = #3578 */
    { 0x0301, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/0/3/0x1 = #3579 */
    { 0x047f, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/1/0/m = #3580 */
    { 0x0400, 0xa338, 0xb981, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614) }, /* #68/1/0/u = #3581 */
    { 0x0401, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/1/0/0x1 = #3582 */
    { 0x057f, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/1/1/m = #3583 */
    { 0x0500, 0xa338, 0xb981, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614) }, /* #68/1/1/u = #3584 */
    { 0x0501, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/1/1/0x1 = #3585 */
    { 0x067f, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/1/2/m = #3586 */
    { 0x0600, 0xa338, 0xb981, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614) }, /* #68/1/2/u = #3587 */
    { 0x0601, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/1/2/0x1 = #3588 */
    { 0x077f, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/1/3/m = #3589 */
    { 0x0700, 0xa338, 0xb981, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614) }, /* #68/1/3/u = #3590 */
    { 0x0701, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/1/3/0x1 = #3591 */
    { 0x087f, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/2/0/m = #3592 */
    { 0x0800, 0xa338, 0xb981, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614) }, /* #68/2/0/u = #3593 */
    { 0x0801, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/2/0/0x1 = #3594 */
    { 0x097f, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/2/1/m = #3595 */
    { 0x0900, 0xa338, 0xb981, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614) }, /* #68/2/1/u = #3596 */
    { 0x0901, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/2/1/0x1 = #3597 */
    { 0x0a7f, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/2/2/m = #3598 */
    { 0x0a00, 0xa338, 0xb981, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614) }, /* #68/2/2/u = #3599 */
    { 0x0a01, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/2/2/0x1 = #3600 */
    { 0x0b7f, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/2/3/m = #3601 */
    { 0x0b00, 0xa338, 0xb981, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614) }, /* #68/2/3/u = #3602 */
    { 0x0b01, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/2/3/0x1 = #3603 */
    { 0x0c7f, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/3/0/m = #3604 */
    { 0x0c00, 0xa338, 0xb981, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614) }, /* #68/3/0/u = #3605 */
    { 0x0c01, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/3/0/0x1 = #3606 */
    { 0x0d7f, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/3/1/m = #3607 */
    { 0x0d00, 0xa338, 0xb981, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614) }, /* #68/3/1/u = #3608 */
    { 0x0d01, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/3/1/0x1 = #3609 */
    { 0x0e7f, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/3/2/m = #3610 */
    { 0x0e00, 0xa338, 0xb981, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614) }, /* #68/3/2/u = #3611 */
    { 0x0e01, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/3/2/0x1 = #3612 */
    { 0x0f7f, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/3/3/m = #3613 */
    { 0x0f00, 0xa338, 0xb981, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614) }, /* #68/3/3/u = #3614 */
    { 0x0f01, 0xa338, 0x3901, RTFLOAT80U_INIT_C(1,0x7ce3d056a1b82aa8,18614), RTFLOAT80U_INIT_IND(1) }, /* #68/3/3/0x1 = #3615 */
    { 0x007f, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/0/0/m = #3616 */
    { 0x0000, 0x3216, 0xb8a0, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/0/0/u = #3617 */
    { 0x0020, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/0/0/0x20 = #3618 */
    { 0x017f, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/0/1/m = #3619 */
    { 0x0100, 0x3216, 0xb8a0, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/0/1/u = #3620 */
    { 0x0120, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/0/1/0x20 = #3621 */
    { 0x027f, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/0/2/m = #3622 */
    { 0x0200, 0x3216, 0xb8a0, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/0/2/u = #3623 */
    { 0x0220, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/0/2/0x20 = #3624 */
    { 0x037f, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/0/3/m = #3625 */
    { 0x0300, 0x3216, 0xb8a0, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/0/3/u = #3626 */
    { 0x0320, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/0/3/0x20 = #3627 */
    { 0x047f, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/1/0/m = #3628 */
    { 0x0400, 0x3216, 0xb8a0, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/1/0/u = #3629 */
    { 0x0420, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/1/0/0x20 = #3630 */
    { 0x057f, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/1/1/m = #3631 */
    { 0x0500, 0x3216, 0xb8a0, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/1/1/u = #3632 */
    { 0x0520, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/1/1/0x20 = #3633 */
    { 0x067f, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/1/2/m = #3634 */
    { 0x0600, 0x3216, 0xb8a0, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/1/2/u = #3635 */
    { 0x0620, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/1/2/0x20 = #3636 */
    { 0x077f, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/1/3/m = #3637 */
    { 0x0700, 0x3216, 0xb8a0, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/1/3/u = #3638 */
    { 0x0720, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/1/3/0x20 = #3639 */
    { 0x087f, 0x3216, 0x3a20, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11aff,3605) }, /* #69/2/0/m = #3640 */
    { 0x0800, 0x3216, 0xbaa0, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11aff,3605) }, /* #69/2/0/u = #3641 */
    { 0x0820, 0x3216, 0x3a20, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11aff,3605) }, /* #69/2/0/0x20 = #3642 */
    { 0x097f, 0x3216, 0x3a20, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11aff,3605) }, /* #69/2/1/m = #3643 */
    { 0x0900, 0x3216, 0xbaa0, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11aff,3605) }, /* #69/2/1/u = #3644 */
    { 0x0920, 0x3216, 0x3a20, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11aff,3605) }, /* #69/2/1/0x20 = #3645 */
    { 0x0a7f, 0x3216, 0x3a20, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11aff,3605) }, /* #69/2/2/m = #3646 */
    { 0x0a00, 0x3216, 0xbaa0, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11aff,3605) }, /* #69/2/2/u = #3647 */
    { 0x0a20, 0x3216, 0x3a20, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11aff,3605) }, /* #69/2/2/0x20 = #3648 */
    { 0x0b7f, 0x3216, 0x3a20, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11aff,3605) }, /* #69/2/3/m = #3649 */
    { 0x0b00, 0x3216, 0xbaa0, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11aff,3605) }, /* #69/2/3/u = #3650 */
    { 0x0b20, 0x3216, 0x3a20, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11aff,3605) }, /* #69/2/3/0x20 = #3651 */
    { 0x0c7f, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/3/0/m = #3652 */
    { 0x0c00, 0x3216, 0xb8a0, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/3/0/u = #3653 */
    { 0x0c20, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/3/0/0x20 = #3654 */
    { 0x0d7f, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/3/1/m = #3655 */
    { 0x0d00, 0x3216, 0xb8a0, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/3/1/u = #3656 */
    { 0x0d20, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/3/1/0x20 = #3657 */
    { 0x0e7f, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/3/2/m = #3658 */
    { 0x0e00, 0x3216, 0xb8a0, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/3/2/u = #3659 */
    { 0x0e20, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/3/2/0x20 = #3660 */
    { 0x0f7f, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/3/3/m = #3661 */
    { 0x0f00, 0x3216, 0xb8a0, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/3/3/u = #3662 */
    { 0x0f20, 0x3216, 0x3820, RTFLOAT80U_INIT_C(0,0x9b3968b6f7ebc346,3606), RTFLOAT80U_INIT_C(0,0xd72fbeff1dd11afe,3605) }, /* #69/3/3/0x20 = #3663 */
    { 0x007f, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/0/0/m = #3664 */
    { 0x0000, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/0/0/u = #3665 */
    { 0x0032, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/0/0/0x32 = #3666 */
    { 0x0030, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/0/0/u0x2 = #3667 */
    { 0x0022, 0x29df, 0xbbb2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0xadb16d908a7541f7,24576) }, /* #70/0/0/u0x10 = #3668 */
    { 0x0012, 0x29df, 0xb9b2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/0/0/u0x20 = #3669 */
    { 0x017f, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/0/1/m = #3670 */
    { 0x0100, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/0/1/u = #3671 */
    { 0x0132, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/0/1/0x32 = #3672 */
    { 0x0130, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/0/1/u0x2 = #3673 */
    { 0x0122, 0x29df, 0xbbb2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0xadb16d908a7541f7,24576) }, /* #70/0/1/u0x10 = #3674 */
    { 0x0112, 0x29df, 0xb9b2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/0/1/u0x20 = #3675 */
    { 0x027f, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/0/2/m = #3676 */
    { 0x0200, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/0/2/u = #3677 */
    { 0x0232, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/0/2/0x32 = #3678 */
    { 0x0230, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/0/2/u0x2 = #3679 */
    { 0x0222, 0x29df, 0xbbb2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0xadb16d908a7541f7,24576) }, /* #70/0/2/u0x10 = #3680 */
    { 0x0212, 0x29df, 0xb9b2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/0/2/u0x20 = #3681 */
    { 0x037f, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/0/3/m = #3682 */
    { 0x0300, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/0/3/u = #3683 */
    { 0x0332, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/0/3/0x32 = #3684 */
    { 0x0330, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/0/3/u0x2 = #3685 */
    { 0x0322, 0x29df, 0xbbb2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0xadb16d908a7541f7,24576) }, /* #70/0/3/u0x10 = #3686 */
    { 0x0312, 0x29df, 0xb9b2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/0/3/u0x20 = #3687 */
    { 0x047f, 0x29df, 0x3b32, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fc,0) }, /* #70/1/0/m = #3688 */
    { 0x0400, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/1/0/u = #3689 */
    { 0x0432, 0x29df, 0x3b32, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fc,0) }, /* #70/1/0/0x32 = #3690 */
    { 0x0430, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/1/0/u0x2 = #3691 */
    { 0x0422, 0x29df, 0xbbb2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0xadb16d908a7541f7,24576) }, /* #70/1/0/u0x10 = #3692 */
    { 0x0412, 0x29df, 0xbbb2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fc,0) }, /* #70/1/0/u0x20 = #3693 */
    { 0x057f, 0x29df, 0x3b32, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fc,0) }, /* #70/1/1/m = #3694 */
    { 0x0500, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/1/1/u = #3695 */
    { 0x0532, 0x29df, 0x3b32, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fc,0) }, /* #70/1/1/0x32 = #3696 */
    { 0x0530, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/1/1/u0x2 = #3697 */
    { 0x0522, 0x29df, 0xbbb2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0xadb16d908a7541f7,24576) }, /* #70/1/1/u0x10 = #3698 */
    { 0x0512, 0x29df, 0xbbb2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fc,0) }, /* #70/1/1/u0x20 = #3699 */
    { 0x067f, 0x29df, 0x3b32, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fc,0) }, /* #70/1/2/m = #3700 */
    { 0x0600, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/1/2/u = #3701 */
    { 0x0632, 0x29df, 0x3b32, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fc,0) }, /* #70/1/2/0x32 = #3702 */
    { 0x0630, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/1/2/u0x2 = #3703 */
    { 0x0622, 0x29df, 0xbbb2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0xadb16d908a7541f7,24576) }, /* #70/1/2/u0x10 = #3704 */
    { 0x0612, 0x29df, 0xbbb2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fc,0) }, /* #70/1/2/u0x20 = #3705 */
    { 0x077f, 0x29df, 0x3b32, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fc,0) }, /* #70/1/3/m = #3706 */
    { 0x0700, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/1/3/u = #3707 */
    { 0x0732, 0x29df, 0x3b32, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fc,0) }, /* #70/1/3/0x32 = #3708 */
    { 0x0730, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/1/3/u0x2 = #3709 */
    { 0x0722, 0x29df, 0xbbb2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0xadb16d908a7541f7,24576) }, /* #70/1/3/u0x10 = #3710 */
    { 0x0712, 0x29df, 0xbbb2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fc,0) }, /* #70/1/3/u0x20 = #3711 */
    { 0x087f, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/2/0/m = #3712 */
    { 0x0800, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/2/0/u = #3713 */
    { 0x0832, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/2/0/0x32 = #3714 */
    { 0x0830, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/2/0/u0x2 = #3715 */
    { 0x0822, 0x29df, 0xb9b2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0xadb16d908a7541f6,24576) }, /* #70/2/0/u0x10 = #3716 */
    { 0x0812, 0x29df, 0xb9b2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/2/0/u0x20 = #3717 */
    { 0x097f, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/2/1/m = #3718 */
    { 0x0900, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/2/1/u = #3719 */
    { 0x0932, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/2/1/0x32 = #3720 */
    { 0x0930, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/2/1/u0x2 = #3721 */
    { 0x0922, 0x29df, 0xb9b2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0xadb16d908a7541f6,24576) }, /* #70/2/1/u0x10 = #3722 */
    { 0x0912, 0x29df, 0xb9b2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/2/1/u0x20 = #3723 */
    { 0x0a7f, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/2/2/m = #3724 */
    { 0x0a00, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/2/2/u = #3725 */
    { 0x0a32, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/2/2/0x32 = #3726 */
    { 0x0a30, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/2/2/u0x2 = #3727 */
    { 0x0a22, 0x29df, 0xb9b2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0xadb16d908a7541f6,24576) }, /* #70/2/2/u0x10 = #3728 */
    { 0x0a12, 0x29df, 0xb9b2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/2/2/u0x20 = #3729 */
    { 0x0b7f, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/2/3/m = #3730 */
    { 0x0b00, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/2/3/u = #3731 */
    { 0x0b32, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/2/3/0x32 = #3732 */
    { 0x0b30, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/2/3/u0x2 = #3733 */
    { 0x0b22, 0x29df, 0xb9b2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0xadb16d908a7541f6,24576) }, /* #70/2/3/u0x10 = #3734 */
    { 0x0b12, 0x29df, 0xb9b2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/2/3/u0x20 = #3735 */
    { 0x0c7f, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/3/0/m = #3736 */
    { 0x0c00, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/3/0/u = #3737 */
    { 0x0c32, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/3/0/0x32 = #3738 */
    { 0x0c30, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/3/0/u0x2 = #3739 */
    { 0x0c22, 0x29df, 0xb9b2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0xadb16d908a7541f6,24576) }, /* #70/3/0/u0x10 = #3740 */
    { 0x0c12, 0x29df, 0xb9b2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/3/0/u0x20 = #3741 */
    { 0x0d7f, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/3/1/m = #3742 */
    { 0x0d00, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/3/1/u = #3743 */
    { 0x0d32, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/3/1/0x32 = #3744 */
    { 0x0d30, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/3/1/u0x2 = #3745 */
    { 0x0d22, 0x29df, 0xb9b2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0xadb16d908a7541f6,24576) }, /* #70/3/1/u0x10 = #3746 */
    { 0x0d12, 0x29df, 0xb9b2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/3/1/u0x20 = #3747 */
    { 0x0e7f, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/3/2/m = #3748 */
    { 0x0e00, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/3/2/u = #3749 */
    { 0x0e32, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/3/2/0x32 = #3750 */
    { 0x0e30, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/3/2/u0x2 = #3751 */
    { 0x0e22, 0x29df, 0xb9b2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0xadb16d908a7541f6,24576) }, /* #70/3/2/u0x10 = #3752 */
    { 0x0e12, 0x29df, 0xb9b2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/3/2/u0x20 = #3753 */
    { 0x0f7f, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/3/3/m = #3754 */
    { 0x0f00, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/3/3/u = #3755 */
    { 0x0f32, 0x29df, 0x3932, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/3/3/0x32 = #3756 */
    { 0x0f30, 0x29df, 0xb982, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0) }, /* #70/3/3/u0x2 = #3757 */
    { 0x0f22, 0x29df, 0xb9b2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0xadb16d908a7541f6,24576) }, /* #70/3/3/u0x10 = #3758 */
    { 0x0f12, 0x29df, 0xb9b2, RTFLOAT80U_INIT_C(1,0x7d4b06b699a716fd,0), RTFLOAT80U_INIT_C(1,0x56d8b6c8453aa0fb,0) }, /* #70/3/3/u0x20 = #3759 */
    { 0x007f, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/0/0/m = #3760 */
    { 0x0000, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/0/0/u = #3761 */
    { 0x0022, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/0/0/0x22 = #3762 */
    { 0x0020, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/0/0/u0x2 = #3763 */
    { 0x0002, 0xf01f, 0xf8a2, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/0/0/u0x20 = #3764 */
    { 0x017f, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/0/1/m = #3765 */
    { 0x0100, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/0/1/u = #3766 */
    { 0x0122, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/0/1/0x22 = #3767 */
    { 0x0120, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/0/1/u0x2 = #3768 */
    { 0x0102, 0xf01f, 0xf8a2, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/0/1/u0x20 = #3769 */
    { 0x027f, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/0/2/m = #3770 */
    { 0x0200, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/0/2/u = #3771 */
    { 0x0222, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/0/2/0x22 = #3772 */
    { 0x0220, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/0/2/u0x2 = #3773 */
    { 0x0202, 0xf01f, 0xf8a2, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/0/2/u0x20 = #3774 */
    { 0x037f, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/0/3/m = #3775 */
    { 0x0300, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/0/3/u = #3776 */
    { 0x0322, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/0/3/0x22 = #3777 */
    { 0x0320, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/0/3/u0x2 = #3778 */
    { 0x0302, 0xf01f, 0xf8a2, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/0/3/u0x20 = #3779 */
    { 0x047f, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/1/0/m = #3780 */
    { 0x0400, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/1/0/u = #3781 */
    { 0x0422, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/1/0/0x22 = #3782 */
    { 0x0420, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/1/0/u0x2 = #3783 */
    { 0x0402, 0xf01f, 0xf8a2, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/1/0/u0x20 = #3784 */
    { 0x057f, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/1/1/m = #3785 */
    { 0x0500, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/1/1/u = #3786 */
    { 0x0522, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/1/1/0x22 = #3787 */
    { 0x0520, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/1/1/u0x2 = #3788 */
    { 0x0502, 0xf01f, 0xf8a2, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/1/1/u0x20 = #3789 */
    { 0x067f, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/1/2/m = #3790 */
    { 0x0600, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/1/2/u = #3791 */
    { 0x0622, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/1/2/0x22 = #3792 */
    { 0x0620, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/1/2/u0x2 = #3793 */
    { 0x0602, 0xf01f, 0xf8a2, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/1/2/u0x20 = #3794 */
    { 0x077f, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/1/3/m = #3795 */
    { 0x0700, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/1/3/u = #3796 */
    { 0x0722, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/1/3/0x22 = #3797 */
    { 0x0720, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/1/3/u0x2 = #3798 */
    { 0x0702, 0xf01f, 0xf8a2, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/1/3/u0x20 = #3799 */
    { 0x087f, 0xf01f, 0x7a22, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c664323759a,1) }, /* #71/2/0/m = #3800 */
    { 0x0800, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/2/0/u = #3801 */
    { 0x0822, 0xf01f, 0x7a22, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c664323759a,1) }, /* #71/2/0/0x22 = #3802 */
    { 0x0820, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/2/0/u0x2 = #3803 */
    { 0x0802, 0xf01f, 0xfaa2, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c664323759a,1) }, /* #71/2/0/u0x20 = #3804 */
    { 0x097f, 0xf01f, 0x7a22, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c664323759a,1) }, /* #71/2/1/m = #3805 */
    { 0x0900, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/2/1/u = #3806 */
    { 0x0922, 0xf01f, 0x7a22, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c664323759a,1) }, /* #71/2/1/0x22 = #3807 */
    { 0x0920, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/2/1/u0x2 = #3808 */
    { 0x0902, 0xf01f, 0xfaa2, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c664323759a,1) }, /* #71/2/1/u0x20 = #3809 */
    { 0x0a7f, 0xf01f, 0x7a22, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c664323759a,1) }, /* #71/2/2/m = #3810 */
    { 0x0a00, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/2/2/u = #3811 */
    { 0x0a22, 0xf01f, 0x7a22, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c664323759a,1) }, /* #71/2/2/0x22 = #3812 */
    { 0x0a20, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/2/2/u0x2 = #3813 */
    { 0x0a02, 0xf01f, 0xfaa2, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c664323759a,1) }, /* #71/2/2/u0x20 = #3814 */
    { 0x0b7f, 0xf01f, 0x7a22, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c664323759a,1) }, /* #71/2/3/m = #3815 */
    { 0x0b00, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/2/3/u = #3816 */
    { 0x0b22, 0xf01f, 0x7a22, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c664323759a,1) }, /* #71/2/3/0x22 = #3817 */
    { 0x0b20, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/2/3/u0x2 = #3818 */
    { 0x0b02, 0xf01f, 0xfaa2, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c664323759a,1) }, /* #71/2/3/u0x20 = #3819 */
    { 0x0c7f, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/3/0/m = #3820 */
    { 0x0c00, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/3/0/u = #3821 */
    { 0x0c22, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/3/0/0x22 = #3822 */
    { 0x0c20, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/3/0/u0x2 = #3823 */
    { 0x0c02, 0xf01f, 0xf8a2, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/3/0/u0x20 = #3824 */
    { 0x0d7f, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/3/1/m = #3825 */
    { 0x0d00, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/3/1/u = #3826 */
    { 0x0d22, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/3/1/0x22 = #3827 */
    { 0x0d20, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/3/1/u0x2 = #3828 */
    { 0x0d02, 0xf01f, 0xf8a2, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/3/1/u0x20 = #3829 */
    { 0x0e7f, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/3/2/m = #3830 */
    { 0x0e00, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/3/2/u = #3831 */
    { 0x0e22, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/3/2/0x22 = #3832 */
    { 0x0e20, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/3/2/u0x2 = #3833 */
    { 0x0e02, 0xf01f, 0xf8a2, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/3/2/u0x20 = #3834 */
    { 0x0f7f, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/3/3/m = #3835 */
    { 0x0f00, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/3/3/u = #3836 */
    { 0x0f22, 0xf01f, 0x7822, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/3/3/0x22 = #3837 */
    { 0x0f20, 0xf01f, 0xf882, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0) }, /* #71/3/3/u0x2 = #3838 */
    { 0x0f02, 0xf01f, 0xf8a2, RTFLOAT80U_INIT_C(0,0xed20878a06e535a0,0), RTFLOAT80U_INIT_C(0,0xa45d2c6643237599,1) }, /* #71/3/3/u0x20 = #3839 */
    { 0x007f, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/0/0/m = #3840 */
    { 0x0000, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/0/0/u = #3841 */
    { 0x017f, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/0/1/m = #3842 */
    { 0x0100, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/0/1/u = #3843 */
    { 0x027f, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/0/2/m = #3844 */
    { 0x0200, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/0/2/u = #3845 */
    { 0x037f, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/0/3/m = #3846 */
    { 0x0300, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/0/3/u = #3847 */
    { 0x047f, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/1/0/m = #3848 */
    { 0x0400, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/1/0/u = #3849 */
    { 0x057f, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/1/1/m = #3850 */
    { 0x0500, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/1/1/u = #3851 */
    { 0x067f, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/1/2/m = #3852 */
    { 0x0600, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/1/2/u = #3853 */
    { 0x077f, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/1/3/m = #3854 */
    { 0x0700, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/1/3/u = #3855 */
    { 0x087f, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/2/0/m = #3856 */
    { 0x0800, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/2/0/u = #3857 */
    { 0x097f, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/2/1/m = #3858 */
    { 0x0900, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/2/1/u = #3859 */
    { 0x0a7f, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/2/2/m = #3860 */
    { 0x0a00, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/2/2/u = #3861 */
    { 0x0b7f, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/2/3/m = #3862 */
    { 0x0b00, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/2/3/u = #3863 */
    { 0x0c7f, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/3/0/m = #3864 */
    { 0x0c00, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/3/0/u = #3865 */
    { 0x0d7f, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/3/1/m = #3866 */
    { 0x0d00, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/3/1/u = #3867 */
    { 0x0e7f, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/3/2/m = #3868 */
    { 0x0e00, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/3/2/u = #3869 */
    { 0x0f7f, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/3/3/m = #3870 */
    { 0x0f00, 0x5098, 0x7800, RTFLOAT80U_INIT_INF(0), RTFLOAT80U_INIT_INF(0) }, /* #72/3/3/u = #3871 */
    { 0x007f, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/0/0/m = #3872 */
    { 0x0000, 0xc90f, 0xf981, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440) }, /* #73/0/0/u = #3873 */
    { 0x0001, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/0/0/0x1 = #3874 */
    { 0x017f, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/0/1/m = #3875 */
    { 0x0100, 0xc90f, 0xf981, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440) }, /* #73/0/1/u = #3876 */
    { 0x0101, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/0/1/0x1 = #3877 */
    { 0x027f, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/0/2/m = #3878 */
    { 0x0200, 0xc90f, 0xf981, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440) }, /* #73/0/2/u = #3879 */
    { 0x0201, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/0/2/0x1 = #3880 */
    { 0x037f, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/0/3/m = #3881 */
    { 0x0300, 0xc90f, 0xf981, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440) }, /* #73/0/3/u = #3882 */
    { 0x0301, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/0/3/0x1 = #3883 */
    { 0x047f, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/1/0/m = #3884 */
    { 0x0400, 0xc90f, 0xf981, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440) }, /* #73/1/0/u = #3885 */
    { 0x0401, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/1/0/0x1 = #3886 */
    { 0x057f, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/1/1/m = #3887 */
    { 0x0500, 0xc90f, 0xf981, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440) }, /* #73/1/1/u = #3888 */
    { 0x0501, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/1/1/0x1 = #3889 */
    { 0x067f, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/1/2/m = #3890 */
    { 0x0600, 0xc90f, 0xf981, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440) }, /* #73/1/2/u = #3891 */
    { 0x0601, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/1/2/0x1 = #3892 */
    { 0x077f, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/1/3/m = #3893 */
    { 0x0700, 0xc90f, 0xf981, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440) }, /* #73/1/3/u = #3894 */
    { 0x0701, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/1/3/0x1 = #3895 */
    { 0x087f, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/2/0/m = #3896 */
    { 0x0800, 0xc90f, 0xf981, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440) }, /* #73/2/0/u = #3897 */
    { 0x0801, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/2/0/0x1 = #3898 */
    { 0x097f, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/2/1/m = #3899 */
    { 0x0900, 0xc90f, 0xf981, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440) }, /* #73/2/1/u = #3900 */
    { 0x0901, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/2/1/0x1 = #3901 */
    { 0x0a7f, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/2/2/m = #3902 */
    { 0x0a00, 0xc90f, 0xf981, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440) }, /* #73/2/2/u = #3903 */
    { 0x0a01, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/2/2/0x1 = #3904 */
    { 0x0b7f, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/2/3/m = #3905 */
    { 0x0b00, 0xc90f, 0xf981, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440) }, /* #73/2/3/u = #3906 */
    { 0x0b01, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/2/3/0x1 = #3907 */
    { 0x0c7f, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/3/0/m = #3908 */
    { 0x0c00, 0xc90f, 0xf981, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440) }, /* #73/3/0/u = #3909 */
    { 0x0c01, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/3/0/0x1 = #3910 */
    { 0x0d7f, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/3/1/m = #3911 */
    { 0x0d00, 0xc90f, 0xf981, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440) }, /* #73/3/1/u = #3912 */
    { 0x0d01, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/3/1/0x1 = #3913 */
    { 0x0e7f, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/3/2/m = #3914 */
    { 0x0e00, 0xc90f, 0xf981, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440) }, /* #73/3/2/u = #3915 */
    { 0x0e01, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/3/2/0x1 = #3916 */
    { 0x0f7f, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/3/3/m = #3917 */
    { 0x0f00, 0xc90f, 0xf981, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440) }, /* #73/3/3/u = #3918 */
    { 0x0f01, 0xc90f, 0x7901, RTFLOAT80U_INIT_C(0,0x659e5e558de52e92,3440), RTFLOAT80U_INIT_IND(1) }, /* #73/3/3/0x1 = #3919 */
    { 0x007f, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/0/0/m = #3920 */
    { 0x0000, 0x9a6a, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/0/0/u = #3921 */
    { 0x0020, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/0/0/0x20 = #3922 */
    { 0x017f, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/0/1/m = #3923 */
    { 0x0100, 0x9a6a, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/0/1/u = #3924 */
    { 0x0120, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/0/1/0x20 = #3925 */
    { 0x027f, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/0/2/m = #3926 */
    { 0x0200, 0x9a6a, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/0/2/u = #3927 */
    { 0x0220, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/0/2/0x20 = #3928 */
    { 0x037f, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/0/3/m = #3929 */
    { 0x0300, 0x9a6a, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/0/3/u = #3930 */
    { 0x0320, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/0/3/0x20 = #3931 */
    { 0x047f, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/1/0/m = #3932 */
    { 0x0400, 0x9a6a, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/1/0/u = #3933 */
    { 0x0420, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/1/0/0x20 = #3934 */
    { 0x057f, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/1/1/m = #3935 */
    { 0x0500, 0x9a6a, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/1/1/u = #3936 */
    { 0x0520, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/1/1/0x20 = #3937 */
    { 0x067f, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/1/2/m = #3938 */
    { 0x0600, 0x9a6a, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/1/2/u = #3939 */
    { 0x0620, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/1/2/0x20 = #3940 */
    { 0x077f, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/1/3/m = #3941 */
    { 0x0700, 0x9a6a, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/1/3/u = #3942 */
    { 0x0720, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/1/3/0x20 = #3943 */
    { 0x087f, 0x9a6a, 0x3a20, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db2,14654) }, /* #74/2/0/m = #3944 */
    { 0x0800, 0x9a6a, 0xbaa0, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db2,14654) }, /* #74/2/0/u = #3945 */
    { 0x0820, 0x9a6a, 0x3a20, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db2,14654) }, /* #74/2/0/0x20 = #3946 */
    { 0x097f, 0x9a6a, 0x3a20, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db2,14654) }, /* #74/2/1/m = #3947 */
    { 0x0900, 0x9a6a, 0xbaa0, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db2,14654) }, /* #74/2/1/u = #3948 */
    { 0x0920, 0x9a6a, 0x3a20, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db2,14654) }, /* #74/2/1/0x20 = #3949 */
    { 0x0a7f, 0x9a6a, 0x3a20, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db2,14654) }, /* #74/2/2/m = #3950 */
    { 0x0a00, 0x9a6a, 0xbaa0, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db2,14654) }, /* #74/2/2/u = #3951 */
    { 0x0a20, 0x9a6a, 0x3a20, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db2,14654) }, /* #74/2/2/0x20 = #3952 */
    { 0x0b7f, 0x9a6a, 0x3a20, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db2,14654) }, /* #74/2/3/m = #3953 */
    { 0x0b00, 0x9a6a, 0xbaa0, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db2,14654) }, /* #74/2/3/u = #3954 */
    { 0x0b20, 0x9a6a, 0x3a20, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db2,14654) }, /* #74/2/3/0x20 = #3955 */
    { 0x0c7f, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/3/0/m = #3956 */
    { 0x0c00, 0x9a6a, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/3/0/u = #3957 */
    { 0x0c20, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/3/0/0x20 = #3958 */
    { 0x0d7f, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/3/1/m = #3959 */
    { 0x0d00, 0x9a6a, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/3/1/u = #3960 */
    { 0x0d20, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/3/1/0x20 = #3961 */
    { 0x0e7f, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/3/2/m = #3962 */
    { 0x0e00, 0x9a6a, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/3/2/u = #3963 */
    { 0x0e20, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/3/2/0x20 = #3964 */
    { 0x0f7f, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/3/3/m = #3965 */
    { 0x0f00, 0x9a6a, 0xb8a0, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/3/3/u = #3966 */
    { 0x0f20, 0x9a6a, 0x3820, RTFLOAT80U_INIT_C(0,0xf30503354c732fa1,14654), RTFLOAT80U_INIT_C(0,0xa872c633fbe39db1,14654) }, /* #74/3/3/0x20 = #3967 */
    { 0x007f, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/0/0/m = #3968 */
    { 0x0000, 0x53f9, 0xf981, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0x800000000000009e,32767) }, /* #75/0/0/u = #3969 */
    { 0x0001, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/0/0/0x1 = #3970 */
    { 0x017f, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/0/1/m = #3971 */
    { 0x0100, 0x53f9, 0xf981, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0x800000000000009e,32767) }, /* #75/0/1/u = #3972 */
    { 0x0101, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/0/1/0x1 = #3973 */
    { 0x027f, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/0/2/m = #3974 */
    { 0x0200, 0x53f9, 0xf981, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0x800000000000009e,32767) }, /* #75/0/2/u = #3975 */
    { 0x0201, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/0/2/0x1 = #3976 */
    { 0x037f, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/0/3/m = #3977 */
    { 0x0300, 0x53f9, 0xf981, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0x800000000000009e,32767) }, /* #75/0/3/u = #3978 */
    { 0x0301, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/0/3/0x1 = #3979 */
    { 0x047f, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/1/0/m = #3980 */
    { 0x0400, 0x53f9, 0xf981, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0x800000000000009e,32767) }, /* #75/1/0/u = #3981 */
    { 0x0401, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/1/0/0x1 = #3982 */
    { 0x057f, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/1/1/m = #3983 */
    { 0x0500, 0x53f9, 0xf981, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0x800000000000009e,32767) }, /* #75/1/1/u = #3984 */
    { 0x0501, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/1/1/0x1 = #3985 */
    { 0x067f, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/1/2/m = #3986 */
    { 0x0600, 0x53f9, 0xf981, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0x800000000000009e,32767) }, /* #75/1/2/u = #3987 */
    { 0x0601, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/1/2/0x1 = #3988 */
    { 0x077f, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/1/3/m = #3989 */
    { 0x0700, 0x53f9, 0xf981, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0x800000000000009e,32767) }, /* #75/1/3/u = #3990 */
    { 0x0701, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/1/3/0x1 = #3991 */
    { 0x087f, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/2/0/m = #3992 */
    { 0x0800, 0x53f9, 0xf981, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0x800000000000009e,32767) }, /* #75/2/0/u = #3993 */
    { 0x0801, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/2/0/0x1 = #3994 */
    { 0x097f, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/2/1/m = #3995 */
    { 0x0900, 0x53f9, 0xf981, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0x800000000000009e,32767) }, /* #75/2/1/u = #3996 */
    { 0x0901, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/2/1/0x1 = #3997 */
    { 0x0a7f, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/2/2/m = #3998 */
    { 0x0a00, 0x53f9, 0xf981, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0x800000000000009e,32767) }, /* #75/2/2/u = #3999 */
    { 0x0a01, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/2/2/0x1 = #4000 */
    { 0x0b7f, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/2/3/m = #4001 */
    { 0x0b00, 0x53f9, 0xf981, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0x800000000000009e,32767) }, /* #75/2/3/u = #4002 */
    { 0x0b01, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/2/3/0x1 = #4003 */
    { 0x0c7f, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/3/0/m = #4004 */
    { 0x0c00, 0x53f9, 0xf981, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0x800000000000009e,32767) }, /* #75/3/0/u = #4005 */
    { 0x0c01, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/3/0/0x1 = #4006 */
    { 0x0d7f, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/3/1/m = #4007 */
    { 0x0d00, 0x53f9, 0xf981, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0x800000000000009e,32767) }, /* #75/3/1/u = #4008 */
    { 0x0d01, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/3/1/0x1 = #4009 */
    { 0x0e7f, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/3/2/m = #4010 */
    { 0x0e00, 0x53f9, 0xf981, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0x800000000000009e,32767) }, /* #75/3/2/u = #4011 */
    { 0x0e01, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/3/2/0x1 = #4012 */
    { 0x0f7f, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/3/3/m = #4013 */
    { 0x0f00, 0x53f9, 0xf981, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0x800000000000009e,32767) }, /* #75/3/3/u = #4014 */
    { 0x0f01, 0x53f9, 0x7901, RTFLOAT80U_INIT_C(1,0x800000000000009e,32767), RTFLOAT80U_INIT_C(1,0xc00000000000009e,32767) }, /* #75/3/3/0x1 = #4015 */
    { 0x007f, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/0/0/m = #4016 */
    { 0x0000, 0x6468, 0xfca0, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/0/0/u = #4017 */
    { 0x0020, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/0/0/0x20 = #4018 */
    { 0x017f, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/0/1/m = #4019 */
    { 0x0100, 0x6468, 0xfca0, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/0/1/u = #4020 */
    { 0x0120, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/0/1/0x20 = #4021 */
    { 0x027f, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/0/2/m = #4022 */
    { 0x0200, 0x6468, 0xfca0, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/0/2/u = #4023 */
    { 0x0220, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/0/2/0x20 = #4024 */
    { 0x037f, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/0/3/m = #4025 */
    { 0x0300, 0x6468, 0xfca0, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/0/3/u = #4026 */
    { 0x0320, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/0/3/0x20 = #4027 */
    { 0x047f, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/1/0/m = #4028 */
    { 0x0400, 0x6468, 0xfca0, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/1/0/u = #4029 */
    { 0x0420, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/1/0/0x20 = #4030 */
    { 0x057f, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/1/1/m = #4031 */
    { 0x0500, 0x6468, 0xfca0, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/1/1/u = #4032 */
    { 0x0520, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/1/1/0x20 = #4033 */
    { 0x067f, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/1/2/m = #4034 */
    { 0x0600, 0x6468, 0xfca0, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/1/2/u = #4035 */
    { 0x0620, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/1/2/0x20 = #4036 */
    { 0x077f, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/1/3/m = #4037 */
    { 0x0700, 0x6468, 0xfca0, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/1/3/u = #4038 */
    { 0x0720, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/1/3/0x20 = #4039 */
    { 0x087f, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/2/0/m = #4040 */
    { 0x0800, 0x6468, 0xfca0, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/2/0/u = #4041 */
    { 0x0820, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/2/0/0x20 = #4042 */
    { 0x097f, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/2/1/m = #4043 */
    { 0x0900, 0x6468, 0xfca0, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/2/1/u = #4044 */
    { 0x0920, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/2/1/0x20 = #4045 */
    { 0x0a7f, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/2/2/m = #4046 */
    { 0x0a00, 0x6468, 0xfca0, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/2/2/u = #4047 */
    { 0x0a20, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/2/2/0x20 = #4048 */
    { 0x0b7f, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/2/3/m = #4049 */
    { 0x0b00, 0x6468, 0xfca0, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/2/3/u = #4050 */
    { 0x0b20, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/2/3/0x20 = #4051 */
    { 0x0c7f, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/3/0/m = #4052 */
    { 0x0c00, 0x6468, 0xfca0, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/3/0/u = #4053 */
    { 0x0c20, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/3/0/0x20 = #4054 */
    { 0x0d7f, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/3/1/m = #4055 */
    { 0x0d00, 0x6468, 0xfca0, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/3/1/u = #4056 */
    { 0x0d20, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/3/1/0x20 = #4057 */
    { 0x0e7f, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/3/2/m = #4058 */
    { 0x0e00, 0x6468, 0xfca0, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/3/2/u = #4059 */
    { 0x0e20, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/3/2/0x20 = #4060 */
    { 0x0f7f, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/3/3/m = #4061 */
    { 0x0f00, 0x6468, 0xfca0, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/3/3/u = #4062 */
    { 0x0f20, 0x6468, 0x7c20, RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050), RTFLOAT80U_INIT_C(1,0x803adaff487f3845,23050) }, /* #76/3/3/0x20 = #4063 */
    { 0x007f, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/0/0/m = #4064 */
    { 0x0000, 0x82c2, 0xb8a0, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/0/0/u = #4065 */
    { 0x0020, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/0/0/0x20 = #4066 */
    { 0x017f, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/0/1/m = #4067 */
    { 0x0100, 0x82c2, 0xb8a0, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/0/1/u = #4068 */
    { 0x0120, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/0/1/0x20 = #4069 */
    { 0x027f, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/0/2/m = #4070 */
    { 0x0200, 0x82c2, 0xb8a0, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/0/2/u = #4071 */
    { 0x0220, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/0/2/0x20 = #4072 */
    { 0x037f, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/0/3/m = #4073 */
    { 0x0300, 0x82c2, 0xb8a0, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/0/3/u = #4074 */
    { 0x0320, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/0/3/0x20 = #4075 */
    { 0x047f, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/1/0/m = #4076 */
    { 0x0400, 0x82c2, 0xb8a0, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/1/0/u = #4077 */
    { 0x0420, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/1/0/0x20 = #4078 */
    { 0x057f, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/1/1/m = #4079 */
    { 0x0500, 0x82c2, 0xb8a0, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/1/1/u = #4080 */
    { 0x0520, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/1/1/0x20 = #4081 */
    { 0x067f, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/1/2/m = #4082 */
    { 0x0600, 0x82c2, 0xb8a0, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/1/2/u = #4083 */
    { 0x0620, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/1/2/0x20 = #4084 */
    { 0x077f, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/1/3/m = #4085 */
    { 0x0700, 0x82c2, 0xb8a0, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/1/3/u = #4086 */
    { 0x0720, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/1/3/0x20 = #4087 */
    { 0x087f, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/2/0/m = #4088 */
    { 0x0800, 0x82c2, 0xb8a0, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/2/0/u = #4089 */
    { 0x0820, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/2/0/0x20 = #4090 */
    { 0x097f, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/2/1/m = #4091 */
    { 0x0900, 0x82c2, 0xb8a0, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/2/1/u = #4092 */
    { 0x0920, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/2/1/0x20 = #4093 */
    { 0x0a7f, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/2/2/m = #4094 */
    { 0x0a00, 0x82c2, 0xb8a0, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/2/2/u = #4095 */
    { 0x0a20, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/2/2/0x20 = #4096 */
    { 0x0b7f, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/2/3/m = #4097 */
    { 0x0b00, 0x82c2, 0xb8a0, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/2/3/u = #4098 */
    { 0x0b20, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/2/3/0x20 = #4099 */
    { 0x0c7f, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/3/0/m = #4100 */
    { 0x0c00, 0x82c2, 0xb8a0, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/3/0/u = #4101 */
    { 0x0c20, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/3/0/0x20 = #4102 */
    { 0x0d7f, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/3/1/m = #4103 */
    { 0x0d00, 0x82c2, 0xb8a0, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/3/1/u = #4104 */
    { 0x0d20, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/3/1/0x20 = #4105 */
    { 0x0e7f, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/3/2/m = #4106 */
    { 0x0e00, 0x82c2, 0xb8a0, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/3/2/u = #4107 */
    { 0x0e20, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/3/2/0x20 = #4108 */
    { 0x0f7f, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/3/3/m = #4109 */
    { 0x0f00, 0x82c2, 0xb8a0, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/3/3/u = #4110 */
    { 0x0f20, 0x82c2, 0x3820, RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022), RTFLOAT80U_INIT_C(0,0xde1bc4533f06fd7e,21022) }, /* #77/3/3/0x20 = #4111 */
    { 0x007f, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/0/0/m = #4112 */
    { 0x0000, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/0/0/u = #4113 */
    { 0x017f, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/0/1/m = #4114 */
    { 0x0100, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/0/1/u = #4115 */
    { 0x027f, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/0/2/m = #4116 */
    { 0x0200, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/0/2/u = #4117 */
    { 0x037f, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/0/3/m = #4118 */
    { 0x0300, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/0/3/u = #4119 */
    { 0x047f, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/1/0/m = #4120 */
    { 0x0400, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/1/0/u = #4121 */
    { 0x057f, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/1/1/m = #4122 */
    { 0x0500, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/1/1/u = #4123 */
    { 0x067f, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/1/2/m = #4124 */
    { 0x0600, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/1/2/u = #4125 */
    { 0x077f, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/1/3/m = #4126 */
    { 0x0700, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/1/3/u = #4127 */
    { 0x087f, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/2/0/m = #4128 */
    { 0x0800, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/2/0/u = #4129 */
    { 0x097f, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/2/1/m = #4130 */
    { 0x0900, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/2/1/u = #4131 */
    { 0x0a7f, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/2/2/m = #4132 */
    { 0x0a00, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/2/2/u = #4133 */
    { 0x0b7f, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/2/3/m = #4134 */
    { 0x0b00, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/2/3/u = #4135 */
    { 0x0c7f, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/3/0/m = #4136 */
    { 0x0c00, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/3/0/u = #4137 */
    { 0x0d7f, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/3/1/m = #4138 */
    { 0x0d00, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/3/1/u = #4139 */
    { 0x0e7f, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/3/2/m = #4140 */
    { 0x0e00, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/3/2/u = #4141 */
    { 0x0f7f, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/3/3/m = #4142 */
    { 0x0f00, 0xa8c4, 0x3800, RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767), RTFLOAT80U_INIT_C(0,0xeaa2f103cbe85ae1,32767) }, /* #78/3/3/u = #4143 */
    { 0x007f, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/0/0/m = #4144 */
    { 0x0000, 0x6283, 0xf881, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998) }, /* #79/0/0/u = #4145 */
    { 0x0001, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/0/0/0x1 = #4146 */
    { 0x017f, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/0/1/m = #4147 */
    { 0x0100, 0x6283, 0xf881, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998) }, /* #79/0/1/u = #4148 */
    { 0x0101, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/0/1/0x1 = #4149 */
    { 0x027f, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/0/2/m = #4150 */
    { 0x0200, 0x6283, 0xf881, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998) }, /* #79/0/2/u = #4151 */
    { 0x0201, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/0/2/0x1 = #4152 */
    { 0x037f, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/0/3/m = #4153 */
    { 0x0300, 0x6283, 0xf881, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998) }, /* #79/0/3/u = #4154 */
    { 0x0301, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/0/3/0x1 = #4155 */
    { 0x047f, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/1/0/m = #4156 */
    { 0x0400, 0x6283, 0xf881, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998) }, /* #79/1/0/u = #4157 */
    { 0x0401, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/1/0/0x1 = #4158 */
    { 0x057f, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/1/1/m = #4159 */
    { 0x0500, 0x6283, 0xf881, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998) }, /* #79/1/1/u = #4160 */
    { 0x0501, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/1/1/0x1 = #4161 */
    { 0x067f, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/1/2/m = #4162 */
    { 0x0600, 0x6283, 0xf881, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998) }, /* #79/1/2/u = #4163 */
    { 0x0601, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/1/2/0x1 = #4164 */
    { 0x077f, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/1/3/m = #4165 */
    { 0x0700, 0x6283, 0xf881, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998) }, /* #79/1/3/u = #4166 */
    { 0x0701, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/1/3/0x1 = #4167 */
    { 0x087f, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/2/0/m = #4168 */
    { 0x0800, 0x6283, 0xf881, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998) }, /* #79/2/0/u = #4169 */
    { 0x0801, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/2/0/0x1 = #4170 */
    { 0x097f, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/2/1/m = #4171 */
    { 0x0900, 0x6283, 0xf881, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998) }, /* #79/2/1/u = #4172 */
    { 0x0901, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/2/1/0x1 = #4173 */
    { 0x0a7f, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/2/2/m = #4174 */
    { 0x0a00, 0x6283, 0xf881, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998) }, /* #79/2/2/u = #4175 */
    { 0x0a01, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/2/2/0x1 = #4176 */
    { 0x0b7f, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/2/3/m = #4177 */
    { 0x0b00, 0x6283, 0xf881, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998) }, /* #79/2/3/u = #4178 */
    { 0x0b01, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/2/3/0x1 = #4179 */
    { 0x0c7f, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/3/0/m = #4180 */
    { 0x0c00, 0x6283, 0xf881, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998) }, /* #79/3/0/u = #4181 */
    { 0x0c01, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/3/0/0x1 = #4182 */
    { 0x0d7f, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/3/1/m = #4183 */
    { 0x0d00, 0x6283, 0xf881, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998) }, /* #79/3/1/u = #4184 */
    { 0x0d01, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/3/1/0x1 = #4185 */
    { 0x0e7f, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/3/2/m = #4186 */
    { 0x0e00, 0x6283, 0xf881, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998) }, /* #79/3/2/u = #4187 */
    { 0x0e01, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/3/2/0x1 = #4188 */
    { 0x0f7f, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/3/3/m = #4189 */
    { 0x0f00, 0x6283, 0xf881, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998) }, /* #79/3/3/u = #4190 */
    { 0x0f01, 0x6283, 0x7801, RTFLOAT80U_INIT_C(1,0x2ec224c194b26886,27998), RTFLOAT80U_INIT_IND(1) }, /* #79/3/3/0x1 = #4191 */
    { 0x007f, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/0/0/m = #4192 */
    { 0x0000, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/0/0/u = #4193 */
    { 0x0032, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/0/0/0x32 = #4194 */
    { 0x0030, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/0/0/u0x2 = #4195 */
    { 0x0022, 0xd7a2, 0xffb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0xf2941813a527b345,24575) }, /* #80/0/0/u0x10 = #4196 */
    { 0x0012, 0xd7a2, 0xfdb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/0/0/u0x20 = #4197 */
    { 0x017f, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/0/1/m = #4198 */
    { 0x0100, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/0/1/u = #4199 */
    { 0x0132, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/0/1/0x32 = #4200 */
    { 0x0130, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/0/1/u0x2 = #4201 */
    { 0x0122, 0xd7a2, 0xffb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0xf2941813a527b345,24575) }, /* #80/0/1/u0x10 = #4202 */
    { 0x0112, 0xd7a2, 0xfdb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/0/1/u0x20 = #4203 */
    { 0x027f, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/0/2/m = #4204 */
    { 0x0200, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/0/2/u = #4205 */
    { 0x0232, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/0/2/0x32 = #4206 */
    { 0x0230, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/0/2/u0x2 = #4207 */
    { 0x0222, 0xd7a2, 0xffb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0xf2941813a527b345,24575) }, /* #80/0/2/u0x10 = #4208 */
    { 0x0212, 0xd7a2, 0xfdb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/0/2/u0x20 = #4209 */
    { 0x037f, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/0/3/m = #4210 */
    { 0x0300, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/0/3/u = #4211 */
    { 0x0332, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/0/3/0x32 = #4212 */
    { 0x0330, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/0/3/u0x2 = #4213 */
    { 0x0322, 0xd7a2, 0xffb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0xf2941813a527b345,24575) }, /* #80/0/3/u0x10 = #4214 */
    { 0x0312, 0xd7a2, 0xfdb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/0/3/u0x20 = #4215 */
    { 0x047f, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/1/0/m = #4216 */
    { 0x0400, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/1/0/u = #4217 */
    { 0x0432, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/1/0/0x32 = #4218 */
    { 0x0430, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/1/0/u0x2 = #4219 */
    { 0x0422, 0xd7a2, 0xfdb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0xf2941813a527b344,24575) }, /* #80/1/0/u0x10 = #4220 */
    { 0x0412, 0xd7a2, 0xfdb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/1/0/u0x20 = #4221 */
    { 0x057f, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/1/1/m = #4222 */
    { 0x0500, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/1/1/u = #4223 */
    { 0x0532, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/1/1/0x32 = #4224 */
    { 0x0530, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/1/1/u0x2 = #4225 */
    { 0x0522, 0xd7a2, 0xfdb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0xf2941813a527b344,24575) }, /* #80/1/1/u0x10 = #4226 */
    { 0x0512, 0xd7a2, 0xfdb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/1/1/u0x20 = #4227 */
    { 0x067f, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/1/2/m = #4228 */
    { 0x0600, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/1/2/u = #4229 */
    { 0x0632, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/1/2/0x32 = #4230 */
    { 0x0630, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/1/2/u0x2 = #4231 */
    { 0x0622, 0xd7a2, 0xfdb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0xf2941813a527b344,24575) }, /* #80/1/2/u0x10 = #4232 */
    { 0x0612, 0xd7a2, 0xfdb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/1/2/u0x20 = #4233 */
    { 0x077f, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/1/3/m = #4234 */
    { 0x0700, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/1/3/u = #4235 */
    { 0x0732, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/1/3/0x32 = #4236 */
    { 0x0730, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/1/3/u0x2 = #4237 */
    { 0x0722, 0xd7a2, 0xfdb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0xf2941813a527b344,24575) }, /* #80/1/3/u0x10 = #4238 */
    { 0x0712, 0xd7a2, 0xfdb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/1/3/u0x20 = #4239 */
    { 0x087f, 0xd7a2, 0x7f32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd2,0) }, /* #80/2/0/m = #4240 */
    { 0x0800, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/2/0/u = #4241 */
    { 0x0832, 0xd7a2, 0x7f32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd2,0) }, /* #80/2/0/0x32 = #4242 */
    { 0x0830, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/2/0/u0x2 = #4243 */
    { 0x0822, 0xd7a2, 0xffb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0xf2941813a527b345,24575) }, /* #80/2/0/u0x10 = #4244 */
    { 0x0812, 0xd7a2, 0xffb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd2,0) }, /* #80/2/0/u0x20 = #4245 */
    { 0x097f, 0xd7a2, 0x7f32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd2,0) }, /* #80/2/1/m = #4246 */
    { 0x0900, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/2/1/u = #4247 */
    { 0x0932, 0xd7a2, 0x7f32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd2,0) }, /* #80/2/1/0x32 = #4248 */
    { 0x0930, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/2/1/u0x2 = #4249 */
    { 0x0922, 0xd7a2, 0xffb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0xf2941813a527b345,24575) }, /* #80/2/1/u0x10 = #4250 */
    { 0x0912, 0xd7a2, 0xffb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd2,0) }, /* #80/2/1/u0x20 = #4251 */
    { 0x0a7f, 0xd7a2, 0x7f32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd2,0) }, /* #80/2/2/m = #4252 */
    { 0x0a00, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/2/2/u = #4253 */
    { 0x0a32, 0xd7a2, 0x7f32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd2,0) }, /* #80/2/2/0x32 = #4254 */
    { 0x0a30, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/2/2/u0x2 = #4255 */
    { 0x0a22, 0xd7a2, 0xffb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0xf2941813a527b345,24575) }, /* #80/2/2/u0x10 = #4256 */
    { 0x0a12, 0xd7a2, 0xffb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd2,0) }, /* #80/2/2/u0x20 = #4257 */
    { 0x0b7f, 0xd7a2, 0x7f32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd2,0) }, /* #80/2/3/m = #4258 */
    { 0x0b00, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/2/3/u = #4259 */
    { 0x0b32, 0xd7a2, 0x7f32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd2,0) }, /* #80/2/3/0x32 = #4260 */
    { 0x0b30, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/2/3/u0x2 = #4261 */
    { 0x0b22, 0xd7a2, 0xffb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0xf2941813a527b345,24575) }, /* #80/2/3/u0x10 = #4262 */
    { 0x0b12, 0xd7a2, 0xffb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd2,0) }, /* #80/2/3/u0x20 = #4263 */
    { 0x0c7f, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/3/0/m = #4264 */
    { 0x0c00, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/3/0/u = #4265 */
    { 0x0c32, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/3/0/0x32 = #4266 */
    { 0x0c30, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/3/0/u0x2 = #4267 */
    { 0x0c22, 0xd7a2, 0xfdb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0xf2941813a527b344,24575) }, /* #80/3/0/u0x10 = #4268 */
    { 0x0c12, 0xd7a2, 0xfdb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/3/0/u0x20 = #4269 */
    { 0x0d7f, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/3/1/m = #4270 */
    { 0x0d00, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/3/1/u = #4271 */
    { 0x0d32, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/3/1/0x32 = #4272 */
    { 0x0d30, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/3/1/u0x2 = #4273 */
    { 0x0d22, 0xd7a2, 0xfdb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0xf2941813a527b344,24575) }, /* #80/3/1/u0x10 = #4274 */
    { 0x0d12, 0xd7a2, 0xfdb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/3/1/u0x20 = #4275 */
    { 0x0e7f, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/3/2/m = #4276 */
    { 0x0e00, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/3/2/u = #4277 */
    { 0x0e32, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/3/2/0x32 = #4278 */
    { 0x0e30, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/3/2/u0x2 = #4279 */
    { 0x0e22, 0xd7a2, 0xfdb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0xf2941813a527b344,24575) }, /* #80/3/2/u0x10 = #4280 */
    { 0x0e12, 0xd7a2, 0xfdb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/3/2/u0x20 = #4281 */
    { 0x0f7f, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/3/3/m = #4282 */
    { 0x0f00, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/3/3/u = #4283 */
    { 0x0f32, 0xd7a2, 0x7d32, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/3/3/0x32 = #4284 */
    { 0x0f30, 0xd7a2, 0xfd82, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0) }, /* #80/3/3/u0x2 = #4285 */
    { 0x0f22, 0xd7a2, 0xfdb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0xf2941813a527b344,24575) }, /* #80/3/3/u0x10 = #4286 */
    { 0x0f12, 0xd7a2, 0xfdb2, RTFLOAT80U_INIT_C(0,0x577ddfdab7243fbf,0), RTFLOAT80U_INIT_C(0,0x3ca50604e949ecd1,0) }, /* #80/3/3/u0x20 = #4287 */
    { 0x007f, 0x992c, 0x3b20, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/0/0/m = #4288 */
    { 0x0000, 0x992c, 0xbba0, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/0/0/u = #4289 */
    { 0x0020, 0x992c, 0x3b20, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/0/0/0x20 = #4290 */
    { 0x017f, 0x992c, 0x3b20, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/0/1/m = #4291 */
    { 0x0100, 0x992c, 0xbba0, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/0/1/u = #4292 */
    { 0x0120, 0x992c, 0x3b20, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/0/1/0x20 = #4293 */
    { 0x027f, 0x992c, 0x3b20, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/0/2/m = #4294 */
    { 0x0200, 0x992c, 0xbba0, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/0/2/u = #4295 */
    { 0x0220, 0x992c, 0x3b20, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/0/2/0x20 = #4296 */
    { 0x037f, 0x992c, 0x3b20, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/0/3/m = #4297 */
    { 0x0300, 0x992c, 0xbba0, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/0/3/u = #4298 */
    { 0x0320, 0x992c, 0x3b20, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/0/3/0x20 = #4299 */
    { 0x047f, 0x992c, 0x3920, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/1/0/m = #4300 */
    { 0x0400, 0x992c, 0xb9a0, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/1/0/u = #4301 */
    { 0x0420, 0x992c, 0x3920, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/1/0/0x20 = #4302 */
    { 0x057f, 0x992c, 0x3920, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/1/1/m = #4303 */
    { 0x0500, 0x992c, 0xb9a0, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/1/1/u = #4304 */
    { 0x0520, 0x992c, 0x3920, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/1/1/0x20 = #4305 */
    { 0x067f, 0x992c, 0x3920, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/1/2/m = #4306 */
    { 0x0600, 0x992c, 0xb9a0, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/1/2/u = #4307 */
    { 0x0620, 0x992c, 0x3920, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/1/2/0x20 = #4308 */
    { 0x077f, 0x992c, 0x3920, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/1/3/m = #4309 */
    { 0x0700, 0x992c, 0xb9a0, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/1/3/u = #4310 */
    { 0x0720, 0x992c, 0x3920, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/1/3/0x20 = #4311 */
    { 0x087f, 0x992c, 0x3b20, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/2/0/m = #4312 */
    { 0x0800, 0x992c, 0xbba0, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/2/0/u = #4313 */
    { 0x0820, 0x992c, 0x3b20, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/2/0/0x20 = #4314 */
    { 0x097f, 0x992c, 0x3b20, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/2/1/m = #4315 */
    { 0x0900, 0x992c, 0xbba0, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/2/1/u = #4316 */
    { 0x0920, 0x992c, 0x3b20, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/2/1/0x20 = #4317 */
    { 0x0a7f, 0x992c, 0x3b20, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/2/2/m = #4318 */
    { 0x0a00, 0x992c, 0xbba0, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/2/2/u = #4319 */
    { 0x0a20, 0x992c, 0x3b20, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/2/2/0x20 = #4320 */
    { 0x0b7f, 0x992c, 0x3b20, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/2/3/m = #4321 */
    { 0x0b00, 0x992c, 0xbba0, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/2/3/u = #4322 */
    { 0x0b20, 0x992c, 0x3b20, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778384,519) }, /* #81/2/3/0x20 = #4323 */
    { 0x0c7f, 0x992c, 0x3920, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/3/0/m = #4324 */
    { 0x0c00, 0x992c, 0xb9a0, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/3/0/u = #4325 */
    { 0x0c20, 0x992c, 0x3920, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/3/0/0x20 = #4326 */
    { 0x0d7f, 0x992c, 0x3920, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/3/1/m = #4327 */
    { 0x0d00, 0x992c, 0xb9a0, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/3/1/u = #4328 */
    { 0x0d20, 0x992c, 0x3920, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/3/1/0x20 = #4329 */
    { 0x0e7f, 0x992c, 0x3920, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/3/2/m = #4330 */
    { 0x0e00, 0x992c, 0xb9a0, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/3/2/u = #4331 */
    { 0x0e20, 0x992c, 0x3920, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/3/2/0x20 = #4332 */
    { 0x0f7f, 0x992c, 0x3920, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/3/3/m = #4333 */
    { 0x0f00, 0x992c, 0xb9a0, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/3/3/u = #4334 */
    { 0x0f20, 0x992c, 0x3920, RTFLOAT80U_INIT_C(0,0xece18b2ff1545d2b,519), RTFLOAT80U_INIT_C(0,0xa43183d9b4778383,519) }, /* #81/3/3/0x20 = #4335 */
    { 0x007f, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/0/0/m = #4336 */
    { 0x0000, 0xf437, 0xfc81, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539) }, /* #82/0/0/u = #4337 */
    { 0x0001, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/0/0/0x1 = #4338 */
    { 0x017f, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/0/1/m = #4339 */
    { 0x0100, 0xf437, 0xfc81, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539) }, /* #82/0/1/u = #4340 */
    { 0x0101, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/0/1/0x1 = #4341 */
    { 0x027f, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/0/2/m = #4342 */
    { 0x0200, 0xf437, 0xfc81, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539) }, /* #82/0/2/u = #4343 */
    { 0x0201, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/0/2/0x1 = #4344 */
    { 0x037f, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/0/3/m = #4345 */
    { 0x0300, 0xf437, 0xfc81, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539) }, /* #82/0/3/u = #4346 */
    { 0x0301, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/0/3/0x1 = #4347 */
    { 0x047f, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/1/0/m = #4348 */
    { 0x0400, 0xf437, 0xfc81, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539) }, /* #82/1/0/u = #4349 */
    { 0x0401, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/1/0/0x1 = #4350 */
    { 0x057f, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/1/1/m = #4351 */
    { 0x0500, 0xf437, 0xfc81, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539) }, /* #82/1/1/u = #4352 */
    { 0x0501, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/1/1/0x1 = #4353 */
    { 0x067f, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/1/2/m = #4354 */
    { 0x0600, 0xf437, 0xfc81, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539) }, /* #82/1/2/u = #4355 */
    { 0x0601, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/1/2/0x1 = #4356 */
    { 0x077f, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/1/3/m = #4357 */
    { 0x0700, 0xf437, 0xfc81, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539) }, /* #82/1/3/u = #4358 */
    { 0x0701, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/1/3/0x1 = #4359 */
    { 0x087f, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/2/0/m = #4360 */
    { 0x0800, 0xf437, 0xfc81, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539) }, /* #82/2/0/u = #4361 */
    { 0x0801, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/2/0/0x1 = #4362 */
    { 0x097f, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/2/1/m = #4363 */
    { 0x0900, 0xf437, 0xfc81, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539) }, /* #82/2/1/u = #4364 */
    { 0x0901, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/2/1/0x1 = #4365 */
    { 0x0a7f, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/2/2/m = #4366 */
    { 0x0a00, 0xf437, 0xfc81, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539) }, /* #82/2/2/u = #4367 */
    { 0x0a01, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/2/2/0x1 = #4368 */
    { 0x0b7f, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/2/3/m = #4369 */
    { 0x0b00, 0xf437, 0xfc81, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539) }, /* #82/2/3/u = #4370 */
    { 0x0b01, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/2/3/0x1 = #4371 */
    { 0x0c7f, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/3/0/m = #4372 */
    { 0x0c00, 0xf437, 0xfc81, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539) }, /* #82/3/0/u = #4373 */
    { 0x0c01, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/3/0/0x1 = #4374 */
    { 0x0d7f, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/3/1/m = #4375 */
    { 0x0d00, 0xf437, 0xfc81, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539) }, /* #82/3/1/u = #4376 */
    { 0x0d01, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/3/1/0x1 = #4377 */
    { 0x0e7f, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/3/2/m = #4378 */
    { 0x0e00, 0xf437, 0xfc81, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539) }, /* #82/3/2/u = #4379 */
    { 0x0e01, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/3/2/0x1 = #4380 */
    { 0x0f7f, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/3/3/m = #4381 */
    { 0x0f00, 0xf437, 0xfc81, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539) }, /* #82/3/3/u = #4382 */
    { 0x0f01, 0xf437, 0x7c01, RTFLOAT80U_INIT_C(0,0x565703b3e4269e0b,32539), RTFLOAT80U_INIT_IND(1) }, /* #82/3/3/0x1 = #4383 */
    { 0x007f, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/0/0/m = #4384 */
    { 0x0000, 0xf7a2, 0xfd81, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767) }, /* #83/0/0/u = #4385 */
    { 0x0001, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/0/0/0x1 = #4386 */
    { 0x017f, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/0/1/m = #4387 */
    { 0x0100, 0xf7a2, 0xfd81, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767) }, /* #83/0/1/u = #4388 */
    { 0x0101, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/0/1/0x1 = #4389 */
    { 0x027f, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/0/2/m = #4390 */
    { 0x0200, 0xf7a2, 0xfd81, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767) }, /* #83/0/2/u = #4391 */
    { 0x0201, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/0/2/0x1 = #4392 */
    { 0x037f, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/0/3/m = #4393 */
    { 0x0300, 0xf7a2, 0xfd81, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767) }, /* #83/0/3/u = #4394 */
    { 0x0301, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/0/3/0x1 = #4395 */
    { 0x047f, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/1/0/m = #4396 */
    { 0x0400, 0xf7a2, 0xfd81, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767) }, /* #83/1/0/u = #4397 */
    { 0x0401, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/1/0/0x1 = #4398 */
    { 0x057f, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/1/1/m = #4399 */
    { 0x0500, 0xf7a2, 0xfd81, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767) }, /* #83/1/1/u = #4400 */
    { 0x0501, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/1/1/0x1 = #4401 */
    { 0x067f, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/1/2/m = #4402 */
    { 0x0600, 0xf7a2, 0xfd81, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767) }, /* #83/1/2/u = #4403 */
    { 0x0601, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/1/2/0x1 = #4404 */
    { 0x077f, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/1/3/m = #4405 */
    { 0x0700, 0xf7a2, 0xfd81, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767) }, /* #83/1/3/u = #4406 */
    { 0x0701, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/1/3/0x1 = #4407 */
    { 0x087f, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/2/0/m = #4408 */
    { 0x0800, 0xf7a2, 0xfd81, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767) }, /* #83/2/0/u = #4409 */
    { 0x0801, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/2/0/0x1 = #4410 */
    { 0x097f, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/2/1/m = #4411 */
    { 0x0900, 0xf7a2, 0xfd81, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767) }, /* #83/2/1/u = #4412 */
    { 0x0901, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/2/1/0x1 = #4413 */
    { 0x0a7f, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/2/2/m = #4414 */
    { 0x0a00, 0xf7a2, 0xfd81, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767) }, /* #83/2/2/u = #4415 */
    { 0x0a01, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/2/2/0x1 = #4416 */
    { 0x0b7f, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/2/3/m = #4417 */
    { 0x0b00, 0xf7a2, 0xfd81, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767) }, /* #83/2/3/u = #4418 */
    { 0x0b01, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/2/3/0x1 = #4419 */
    { 0x0c7f, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/3/0/m = #4420 */
    { 0x0c00, 0xf7a2, 0xfd81, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767) }, /* #83/3/0/u = #4421 */
    { 0x0c01, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/3/0/0x1 = #4422 */
    { 0x0d7f, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/3/1/m = #4423 */
    { 0x0d00, 0xf7a2, 0xfd81, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767) }, /* #83/3/1/u = #4424 */
    { 0x0d01, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/3/1/0x1 = #4425 */
    { 0x0e7f, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/3/2/m = #4426 */
    { 0x0e00, 0xf7a2, 0xfd81, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767) }, /* #83/3/2/u = #4427 */
    { 0x0e01, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/3/2/0x1 = #4428 */
    { 0x0f7f, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/3/3/m = #4429 */
    { 0x0f00, 0xf7a2, 0xfd81, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767) }, /* #83/3/3/u = #4430 */
    { 0x0f01, 0xf7a2, 0x7d01, RTFLOAT80U_INIT_C(1,0xa6898dad991b20b6,32767), RTFLOAT80U_INIT_C(1,0xe6898dad991b20b6,32767) }, /* #83/3/3/0x1 = #4431 */
    { 0x00ff, 0xa9de, 0x3b20, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/0/0/m = #4432 */
    { 0x0080, 0xa9de, 0xbba0, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/0/0/u = #4433 */
    { 0x00a0, 0xa9de, 0x3b20, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/0/0/0x20 = #4434 */
    { 0x01ff, 0xa9de, 0x3b20, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/0/1/m = #4435 */
    { 0x0180, 0xa9de, 0xbba0, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/0/1/u = #4436 */
    { 0x01a0, 0xa9de, 0x3b20, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/0/1/0x20 = #4437 */
    { 0x02ff, 0xa9de, 0x3b20, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/0/2/m = #4438 */
    { 0x0280, 0xa9de, 0xbba0, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/0/2/u = #4439 */
    { 0x02a0, 0xa9de, 0x3b20, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/0/2/0x20 = #4440 */
    { 0x03ff, 0xa9de, 0x3b20, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/0/3/m = #4441 */
    { 0x0380, 0xa9de, 0xbba0, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/0/3/u = #4442 */
    { 0x03a0, 0xa9de, 0x3b20, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/0/3/0x20 = #4443 */
    { 0x04ff, 0xa9de, 0x3b20, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/1/0/m = #4444 */
    { 0x0480, 0xa9de, 0xbba0, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/1/0/u = #4445 */
    { 0x04a0, 0xa9de, 0x3b20, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/1/0/0x20 = #4446 */
    { 0x05ff, 0xa9de, 0x3b20, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/1/1/m = #4447 */
    { 0x0580, 0xa9de, 0xbba0, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/1/1/u = #4448 */
    { 0x05a0, 0xa9de, 0x3b20, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/1/1/0x20 = #4449 */
    { 0x06ff, 0xa9de, 0x3b20, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/1/2/m = #4450 */
    { 0x0680, 0xa9de, 0xbba0, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/1/2/u = #4451 */
    { 0x06a0, 0xa9de, 0x3b20, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/1/2/0x20 = #4452 */
    { 0x07ff, 0xa9de, 0x3b20, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/1/3/m = #4453 */
    { 0x0780, 0xa9de, 0xbba0, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/1/3/u = #4454 */
    { 0x07a0, 0xa9de, 0x3b20, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6cb,16329) }, /* #84/1/3/0x20 = #4455 */
    { 0x08ff, 0xa9de, 0x3920, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/2/0/m = #4456 */
    { 0x0880, 0xa9de, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/2/0/u = #4457 */
    { 0x08a0, 0xa9de, 0x3920, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/2/0/0x20 = #4458 */
    { 0x09ff, 0xa9de, 0x3920, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/2/1/m = #4459 */
    { 0x0980, 0xa9de, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/2/1/u = #4460 */
    { 0x09a0, 0xa9de, 0x3920, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/2/1/0x20 = #4461 */
    { 0x0aff, 0xa9de, 0x3920, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/2/2/m = #4462 */
    { 0x0a80, 0xa9de, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/2/2/u = #4463 */
    { 0x0aa0, 0xa9de, 0x3920, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/2/2/0x20 = #4464 */
    { 0x0bff, 0xa9de, 0x3920, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/2/3/m = #4465 */
    { 0x0b80, 0xa9de, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/2/3/u = #4466 */
    { 0x0ba0, 0xa9de, 0x3920, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/2/3/0x20 = #4467 */
    { 0x0cff, 0xa9de, 0x3920, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/3/0/m = #4468 */
    { 0x0c80, 0xa9de, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/3/0/u = #4469 */
    { 0x0ca0, 0xa9de, 0x3920, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/3/0/0x20 = #4470 */
    { 0x0dff, 0xa9de, 0x3920, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/3/1/m = #4471 */
    { 0x0d80, 0xa9de, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/3/1/u = #4472 */
    { 0x0da0, 0xa9de, 0x3920, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/3/1/0x20 = #4473 */
    { 0x0eff, 0xa9de, 0x3920, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/3/2/m = #4474 */
    { 0x0e80, 0xa9de, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/3/2/u = #4475 */
    { 0x0ea0, 0xa9de, 0x3920, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/3/2/0x20 = #4476 */
    { 0x0fff, 0xa9de, 0x3920, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/3/3/m = #4477 */
    { 0x0f80, 0xa9de, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/3/3/u = #4478 */
    { 0x0fa0, 0xa9de, 0x3920, RTFLOAT80U_INIT_C(1,0xd30dddee6882d150,16329), RTFLOAT80U_INIT_C(1,0x924aa66138b7e6ca,16329) }, /* #84/3/3/0x20 = #4479 */
    { 0x00ff, 0x4276, 0x7a20, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/0/0/m = #4480 */
    { 0x0080, 0x4276, 0xfaa0, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/0/0/u = #4481 */
    { 0x00a0, 0x4276, 0x7a20, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/0/0/0x20 = #4482 */
    { 0x01ff, 0x4276, 0x7a20, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/0/1/m = #4483 */
    { 0x0180, 0x4276, 0xfaa0, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/0/1/u = #4484 */
    { 0x01a0, 0x4276, 0x7a20, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/0/1/0x20 = #4485 */
    { 0x02ff, 0x4276, 0x7a20, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/0/2/m = #4486 */
    { 0x0280, 0x4276, 0xfaa0, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/0/2/u = #4487 */
    { 0x02a0, 0x4276, 0x7a20, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/0/2/0x20 = #4488 */
    { 0x03ff, 0x4276, 0x7a20, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/0/3/m = #4489 */
    { 0x0380, 0x4276, 0xfaa0, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/0/3/u = #4490 */
    { 0x03a0, 0x4276, 0x7a20, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/0/3/0x20 = #4491 */
    { 0x04ff, 0x4276, 0x7a20, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/1/0/m = #4492 */
    { 0x0480, 0x4276, 0xfaa0, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/1/0/u = #4493 */
    { 0x04a0, 0x4276, 0x7a20, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/1/0/0x20 = #4494 */
    { 0x05ff, 0x4276, 0x7a20, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/1/1/m = #4495 */
    { 0x0580, 0x4276, 0xfaa0, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/1/1/u = #4496 */
    { 0x05a0, 0x4276, 0x7a20, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/1/1/0x20 = #4497 */
    { 0x06ff, 0x4276, 0x7a20, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/1/2/m = #4498 */
    { 0x0680, 0x4276, 0xfaa0, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/1/2/u = #4499 */
    { 0x06a0, 0x4276, 0x7a20, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/1/2/0x20 = #4500 */
    { 0x07ff, 0x4276, 0x7a20, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/1/3/m = #4501 */
    { 0x0780, 0x4276, 0xfaa0, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/1/3/u = #4502 */
    { 0x07a0, 0x4276, 0x7a20, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1494,16320) }, /* #85/1/3/0x20 = #4503 */
    { 0x08ff, 0x4276, 0x7820, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/2/0/m = #4504 */
    { 0x0880, 0x4276, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/2/0/u = #4505 */
    { 0x08a0, 0x4276, 0x7820, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/2/0/0x20 = #4506 */
    { 0x09ff, 0x4276, 0x7820, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/2/1/m = #4507 */
    { 0x0980, 0x4276, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/2/1/u = #4508 */
    { 0x09a0, 0x4276, 0x7820, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/2/1/0x20 = #4509 */
    { 0x0aff, 0x4276, 0x7820, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/2/2/m = #4510 */
    { 0x0a80, 0x4276, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/2/2/u = #4511 */
    { 0x0aa0, 0x4276, 0x7820, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/2/2/0x20 = #4512 */
    { 0x0bff, 0x4276, 0x7820, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/2/3/m = #4513 */
    { 0x0b80, 0x4276, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/2/3/u = #4514 */
    { 0x0ba0, 0x4276, 0x7820, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/2/3/0x20 = #4515 */
    { 0x0cff, 0x4276, 0x7820, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/3/0/m = #4516 */
    { 0x0c80, 0x4276, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/3/0/u = #4517 */
    { 0x0ca0, 0x4276, 0x7820, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/3/0/0x20 = #4518 */
    { 0x0dff, 0x4276, 0x7820, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/3/1/m = #4519 */
    { 0x0d80, 0x4276, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/3/1/u = #4520 */
    { 0x0da0, 0x4276, 0x7820, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/3/1/0x20 = #4521 */
    { 0x0eff, 0x4276, 0x7820, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/3/2/m = #4522 */
    { 0x0e80, 0x4276, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/3/2/u = #4523 */
    { 0x0ea0, 0x4276, 0x7820, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/3/2/0x20 = #4524 */
    { 0x0fff, 0x4276, 0x7820, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/3/3/m = #4525 */
    { 0x0f80, 0x4276, 0xf8a0, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/3/3/u = #4526 */
    { 0x0fa0, 0x4276, 0x7820, RTFLOAT80U_INIT_C(1,0xe665848ecc67bca6,16320), RTFLOAT80U_INIT_C(1,0x9fb2df6dea9a1493,16320) }, /* #85/3/3/0x20 = #4527 */
    { 0x007f, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/0/0/m = #4528 */
    { 0x0000, 0x163c, 0xbc81, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701) }, /* #86/0/0/u = #4529 */
    { 0x0001, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/0/0/0x1 = #4530 */
    { 0x017f, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/0/1/m = #4531 */
    { 0x0100, 0x163c, 0xbc81, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701) }, /* #86/0/1/u = #4532 */
    { 0x0101, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/0/1/0x1 = #4533 */
    { 0x027f, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/0/2/m = #4534 */
    { 0x0200, 0x163c, 0xbc81, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701) }, /* #86/0/2/u = #4535 */
    { 0x0201, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/0/2/0x1 = #4536 */
    { 0x037f, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/0/3/m = #4537 */
    { 0x0300, 0x163c, 0xbc81, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701) }, /* #86/0/3/u = #4538 */
    { 0x0301, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/0/3/0x1 = #4539 */
    { 0x047f, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/1/0/m = #4540 */
    { 0x0400, 0x163c, 0xbc81, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701) }, /* #86/1/0/u = #4541 */
    { 0x0401, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/1/0/0x1 = #4542 */
    { 0x057f, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/1/1/m = #4543 */
    { 0x0500, 0x163c, 0xbc81, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701) }, /* #86/1/1/u = #4544 */
    { 0x0501, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/1/1/0x1 = #4545 */
    { 0x067f, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/1/2/m = #4546 */
    { 0x0600, 0x163c, 0xbc81, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701) }, /* #86/1/2/u = #4547 */
    { 0x0601, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/1/2/0x1 = #4548 */
    { 0x077f, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/1/3/m = #4549 */
    { 0x0700, 0x163c, 0xbc81, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701) }, /* #86/1/3/u = #4550 */
    { 0x0701, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/1/3/0x1 = #4551 */
    { 0x087f, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/2/0/m = #4552 */
    { 0x0800, 0x163c, 0xbc81, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701) }, /* #86/2/0/u = #4553 */
    { 0x0801, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/2/0/0x1 = #4554 */
    { 0x097f, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/2/1/m = #4555 */
    { 0x0900, 0x163c, 0xbc81, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701) }, /* #86/2/1/u = #4556 */
    { 0x0901, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/2/1/0x1 = #4557 */
    { 0x0a7f, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/2/2/m = #4558 */
    { 0x0a00, 0x163c, 0xbc81, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701) }, /* #86/2/2/u = #4559 */
    { 0x0a01, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/2/2/0x1 = #4560 */
    { 0x0b7f, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/2/3/m = #4561 */
    { 0x0b00, 0x163c, 0xbc81, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701) }, /* #86/2/3/u = #4562 */
    { 0x0b01, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/2/3/0x1 = #4563 */
    { 0x0c7f, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/3/0/m = #4564 */
    { 0x0c00, 0x163c, 0xbc81, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701) }, /* #86/3/0/u = #4565 */
    { 0x0c01, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/3/0/0x1 = #4566 */
    { 0x0d7f, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/3/1/m = #4567 */
    { 0x0d00, 0x163c, 0xbc81, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701) }, /* #86/3/1/u = #4568 */
    { 0x0d01, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/3/1/0x1 = #4569 */
    { 0x0e7f, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/3/2/m = #4570 */
    { 0x0e00, 0x163c, 0xbc81, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701) }, /* #86/3/2/u = #4571 */
    { 0x0e01, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/3/2/0x1 = #4572 */
    { 0x0f7f, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/3/3/m = #4573 */
    { 0x0f00, 0x163c, 0xbc81, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701) }, /* #86/3/3/u = #4574 */
    { 0x0f01, 0x163c, 0x3c01, RTFLOAT80U_INIT_C(1,0x21923b5dcc7a1a20,10701), RTFLOAT80U_INIT_IND(1) }, /* #86/3/3/0x1 = #4575 */
    { 0x007f, 0x2818, 0x3a32, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/0/0/m = #4576 */
    { 0x0000, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/0/0/u = #4577 */
    { 0x0032, 0x2818, 0x3a32, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/0/0/0x32 = #4578 */
    { 0x0030, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/0/0/u0x2 = #4579 */
    { 0x0022, 0x2818, 0xb8b2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x8f6c140f1fb0886f,24576) }, /* #87/0/0/u0x10 = #4580 */
    { 0x0012, 0x2818, 0xbab2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/0/0/u0x20 = #4581 */
    { 0x017f, 0x2818, 0x3a32, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/0/1/m = #4582 */
    { 0x0100, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/0/1/u = #4583 */
    { 0x0132, 0x2818, 0x3a32, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/0/1/0x32 = #4584 */
    { 0x0130, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/0/1/u0x2 = #4585 */
    { 0x0122, 0x2818, 0xb8b2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x8f6c140f1fb0886f,24576) }, /* #87/0/1/u0x10 = #4586 */
    { 0x0112, 0x2818, 0xbab2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/0/1/u0x20 = #4587 */
    { 0x027f, 0x2818, 0x3a32, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/0/2/m = #4588 */
    { 0x0200, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/0/2/u = #4589 */
    { 0x0232, 0x2818, 0x3a32, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/0/2/0x32 = #4590 */
    { 0x0230, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/0/2/u0x2 = #4591 */
    { 0x0222, 0x2818, 0xb8b2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x8f6c140f1fb0886f,24576) }, /* #87/0/2/u0x10 = #4592 */
    { 0x0212, 0x2818, 0xbab2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/0/2/u0x20 = #4593 */
    { 0x037f, 0x2818, 0x3a32, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/0/3/m = #4594 */
    { 0x0300, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/0/3/u = #4595 */
    { 0x0332, 0x2818, 0x3a32, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/0/3/0x32 = #4596 */
    { 0x0330, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/0/3/u0x2 = #4597 */
    { 0x0322, 0x2818, 0xb8b2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x8f6c140f1fb0886f,24576) }, /* #87/0/3/u0x10 = #4598 */
    { 0x0312, 0x2818, 0xbab2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/0/3/u0x20 = #4599 */
    { 0x047f, 0x2818, 0x3832, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/1/0/m = #4600 */
    { 0x0400, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/1/0/u = #4601 */
    { 0x0432, 0x2818, 0x3832, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/1/0/0x32 = #4602 */
    { 0x0430, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/1/0/u0x2 = #4603 */
    { 0x0422, 0x2818, 0xb8b2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x8f6c140f1fb0886f,24576) }, /* #87/1/0/u0x10 = #4604 */
    { 0x0412, 0x2818, 0xb8b2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/1/0/u0x20 = #4605 */
    { 0x057f, 0x2818, 0x3832, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/1/1/m = #4606 */
    { 0x0500, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/1/1/u = #4607 */
    { 0x0532, 0x2818, 0x3832, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/1/1/0x32 = #4608 */
    { 0x0530, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/1/1/u0x2 = #4609 */
    { 0x0522, 0x2818, 0xb8b2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x8f6c140f1fb0886f,24576) }, /* #87/1/1/u0x10 = #4610 */
    { 0x0512, 0x2818, 0xb8b2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/1/1/u0x20 = #4611 */
    { 0x067f, 0x2818, 0x3832, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/1/2/m = #4612 */
    { 0x0600, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/1/2/u = #4613 */
    { 0x0632, 0x2818, 0x3832, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/1/2/0x32 = #4614 */
    { 0x0630, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/1/2/u0x2 = #4615 */
    { 0x0622, 0x2818, 0xb8b2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x8f6c140f1fb0886f,24576) }, /* #87/1/2/u0x10 = #4616 */
    { 0x0612, 0x2818, 0xb8b2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/1/2/u0x20 = #4617 */
    { 0x077f, 0x2818, 0x3832, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/1/3/m = #4618 */
    { 0x0700, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/1/3/u = #4619 */
    { 0x0732, 0x2818, 0x3832, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/1/3/0x32 = #4620 */
    { 0x0730, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/1/3/u0x2 = #4621 */
    { 0x0722, 0x2818, 0xb8b2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x8f6c140f1fb0886f,24576) }, /* #87/1/3/u0x10 = #4622 */
    { 0x0712, 0x2818, 0xb8b2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/1/3/u0x20 = #4623 */
    { 0x087f, 0x2818, 0x3a32, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/2/0/m = #4624 */
    { 0x0800, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/2/0/u = #4625 */
    { 0x0832, 0x2818, 0x3a32, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/2/0/0x32 = #4626 */
    { 0x0830, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/2/0/u0x2 = #4627 */
    { 0x0822, 0x2818, 0xbab2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x8f6c140f1fb08870,24576) }, /* #87/2/0/u0x10 = #4628 */
    { 0x0812, 0x2818, 0xbab2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/2/0/u0x20 = #4629 */
    { 0x097f, 0x2818, 0x3a32, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/2/1/m = #4630 */
    { 0x0900, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/2/1/u = #4631 */
    { 0x0932, 0x2818, 0x3a32, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/2/1/0x32 = #4632 */
    { 0x0930, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/2/1/u0x2 = #4633 */
    { 0x0922, 0x2818, 0xbab2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x8f6c140f1fb08870,24576) }, /* #87/2/1/u0x10 = #4634 */
    { 0x0912, 0x2818, 0xbab2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/2/1/u0x20 = #4635 */
    { 0x0a7f, 0x2818, 0x3a32, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/2/2/m = #4636 */
    { 0x0a00, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/2/2/u = #4637 */
    { 0x0a32, 0x2818, 0x3a32, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/2/2/0x32 = #4638 */
    { 0x0a30, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/2/2/u0x2 = #4639 */
    { 0x0a22, 0x2818, 0xbab2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x8f6c140f1fb08870,24576) }, /* #87/2/2/u0x10 = #4640 */
    { 0x0a12, 0x2818, 0xbab2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/2/2/u0x20 = #4641 */
    { 0x0b7f, 0x2818, 0x3a32, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/2/3/m = #4642 */
    { 0x0b00, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/2/3/u = #4643 */
    { 0x0b32, 0x2818, 0x3a32, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/2/3/0x32 = #4644 */
    { 0x0b30, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/2/3/u0x2 = #4645 */
    { 0x0b22, 0x2818, 0xbab2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x8f6c140f1fb08870,24576) }, /* #87/2/3/u0x10 = #4646 */
    { 0x0b12, 0x2818, 0xbab2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84438,0) }, /* #87/2/3/u0x20 = #4647 */
    { 0x0c7f, 0x2818, 0x3832, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/3/0/m = #4648 */
    { 0x0c00, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/3/0/u = #4649 */
    { 0x0c32, 0x2818, 0x3832, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/3/0/0x32 = #4650 */
    { 0x0c30, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/3/0/u0x2 = #4651 */
    { 0x0c22, 0x2818, 0xb8b2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x8f6c140f1fb0886f,24576) }, /* #87/3/0/u0x10 = #4652 */
    { 0x0c12, 0x2818, 0xb8b2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/3/0/u0x20 = #4653 */
    { 0x0d7f, 0x2818, 0x3832, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/3/1/m = #4654 */
    { 0x0d00, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/3/1/u = #4655 */
    { 0x0d32, 0x2818, 0x3832, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/3/1/0x32 = #4656 */
    { 0x0d30, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/3/1/u0x2 = #4657 */
    { 0x0d22, 0x2818, 0xb8b2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x8f6c140f1fb0886f,24576) }, /* #87/3/1/u0x10 = #4658 */
    { 0x0d12, 0x2818, 0xb8b2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/3/1/u0x20 = #4659 */
    { 0x0e7f, 0x2818, 0x3832, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/3/2/m = #4660 */
    { 0x0e00, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/3/2/u = #4661 */
    { 0x0e32, 0x2818, 0x3832, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/3/2/0x32 = #4662 */
    { 0x0e30, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/3/2/u0x2 = #4663 */
    { 0x0e22, 0x2818, 0xb8b2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x8f6c140f1fb0886f,24576) }, /* #87/3/2/u0x10 = #4664 */
    { 0x0e12, 0x2818, 0xb8b2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/3/2/u0x20 = #4665 */
    { 0x0f7f, 0x2818, 0x3832, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/3/3/m = #4666 */
    { 0x0f00, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/3/3/u = #4667 */
    { 0x0f32, 0x2818, 0x3832, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/3/3/0x32 = #4668 */
    { 0x0f30, 0x2818, 0xb882, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0) }, /* #87/3/3/u0x2 = #4669 */
    { 0x0f22, 0x2818, 0xb8b2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x8f6c140f1fb0886f,24576) }, /* #87/3/3/u0x10 = #4670 */
    { 0x0f12, 0x2818, 0xb8b2, RTFLOAT80U_INIT_C(0,0x67750d554558e0ce,0), RTFLOAT80U_INIT_C(0,0x47b60a078fd84437,0) }, /* #87/3/3/u0x20 = #4671 */
    { 0x007f, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/0/0/m = #4672 */
    { 0x0000, 0xfc12, 0xfc81, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465) }, /* #88/0/0/u = #4673 */
    { 0x0001, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/0/0/0x1 = #4674 */
    { 0x017f, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/0/1/m = #4675 */
    { 0x0100, 0xfc12, 0xfc81, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465) }, /* #88/0/1/u = #4676 */
    { 0x0101, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/0/1/0x1 = #4677 */
    { 0x027f, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/0/2/m = #4678 */
    { 0x0200, 0xfc12, 0xfc81, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465) }, /* #88/0/2/u = #4679 */
    { 0x0201, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/0/2/0x1 = #4680 */
    { 0x037f, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/0/3/m = #4681 */
    { 0x0300, 0xfc12, 0xfc81, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465) }, /* #88/0/3/u = #4682 */
    { 0x0301, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/0/3/0x1 = #4683 */
    { 0x047f, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/1/0/m = #4684 */
    { 0x0400, 0xfc12, 0xfc81, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465) }, /* #88/1/0/u = #4685 */
    { 0x0401, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/1/0/0x1 = #4686 */
    { 0x057f, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/1/1/m = #4687 */
    { 0x0500, 0xfc12, 0xfc81, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465) }, /* #88/1/1/u = #4688 */
    { 0x0501, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/1/1/0x1 = #4689 */
    { 0x067f, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/1/2/m = #4690 */
    { 0x0600, 0xfc12, 0xfc81, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465) }, /* #88/1/2/u = #4691 */
    { 0x0601, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/1/2/0x1 = #4692 */
    { 0x077f, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/1/3/m = #4693 */
    { 0x0700, 0xfc12, 0xfc81, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465) }, /* #88/1/3/u = #4694 */
    { 0x0701, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/1/3/0x1 = #4695 */
    { 0x087f, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/2/0/m = #4696 */
    { 0x0800, 0xfc12, 0xfc81, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465) }, /* #88/2/0/u = #4697 */
    { 0x0801, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/2/0/0x1 = #4698 */
    { 0x097f, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/2/1/m = #4699 */
    { 0x0900, 0xfc12, 0xfc81, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465) }, /* #88/2/1/u = #4700 */
    { 0x0901, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/2/1/0x1 = #4701 */
    { 0x0a7f, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/2/2/m = #4702 */
    { 0x0a00, 0xfc12, 0xfc81, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465) }, /* #88/2/2/u = #4703 */
    { 0x0a01, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/2/2/0x1 = #4704 */
    { 0x0b7f, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/2/3/m = #4705 */
    { 0x0b00, 0xfc12, 0xfc81, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465) }, /* #88/2/3/u = #4706 */
    { 0x0b01, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/2/3/0x1 = #4707 */
    { 0x0c7f, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/3/0/m = #4708 */
    { 0x0c00, 0xfc12, 0xfc81, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465) }, /* #88/3/0/u = #4709 */
    { 0x0c01, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/3/0/0x1 = #4710 */
    { 0x0d7f, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/3/1/m = #4711 */
    { 0x0d00, 0xfc12, 0xfc81, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465) }, /* #88/3/1/u = #4712 */
    { 0x0d01, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/3/1/0x1 = #4713 */
    { 0x0e7f, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/3/2/m = #4714 */
    { 0x0e00, 0xfc12, 0xfc81, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465) }, /* #88/3/2/u = #4715 */
    { 0x0e01, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/3/2/0x1 = #4716 */
    { 0x0f7f, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/3/3/m = #4717 */
    { 0x0f00, 0xfc12, 0xfc81, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465) }, /* #88/3/3/u = #4718 */
    { 0x0f01, 0xfc12, 0x7c01, RTFLOAT80U_INIT_C(0,0x3c9f6af33cdf2453,7465), RTFLOAT80U_INIT_IND(1) }, /* #88/3/3/0x1 = #4719 */
    { 0x00ff, 0x2152, 0x3b20, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/0/0/m = #4720 */
    { 0x0080, 0x2152, 0xbba0, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/0/0/u = #4721 */
    { 0x00a0, 0x2152, 0x3b20, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/0/0/0x20 = #4722 */
    { 0x01ff, 0x2152, 0x3b20, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/0/1/m = #4723 */
    { 0x0180, 0x2152, 0xbba0, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/0/1/u = #4724 */
    { 0x01a0, 0x2152, 0x3b20, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/0/1/0x20 = #4725 */
    { 0x02ff, 0x2152, 0x3b20, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/0/2/m = #4726 */
    { 0x0280, 0x2152, 0xbba0, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/0/2/u = #4727 */
    { 0x02a0, 0x2152, 0x3b20, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/0/2/0x20 = #4728 */
    { 0x03ff, 0x2152, 0x3b20, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/0/3/m = #4729 */
    { 0x0380, 0x2152, 0xbba0, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/0/3/u = #4730 */
    { 0x03a0, 0x2152, 0x3b20, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/0/3/0x20 = #4731 */
    { 0x04ff, 0x2152, 0x3920, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/1/0/m = #4732 */
    { 0x0480, 0x2152, 0xb9a0, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/1/0/u = #4733 */
    { 0x04a0, 0x2152, 0x3920, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/1/0/0x20 = #4734 */
    { 0x05ff, 0x2152, 0x3920, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/1/1/m = #4735 */
    { 0x0580, 0x2152, 0xb9a0, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/1/1/u = #4736 */
    { 0x05a0, 0x2152, 0x3920, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/1/1/0x20 = #4737 */
    { 0x06ff, 0x2152, 0x3920, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/1/2/m = #4738 */
    { 0x0680, 0x2152, 0xb9a0, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/1/2/u = #4739 */
    { 0x06a0, 0x2152, 0x3920, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/1/2/0x20 = #4740 */
    { 0x07ff, 0x2152, 0x3920, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/1/3/m = #4741 */
    { 0x0780, 0x2152, 0xb9a0, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/1/3/u = #4742 */
    { 0x07a0, 0x2152, 0x3920, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/1/3/0x20 = #4743 */
    { 0x08ff, 0x2152, 0x3b20, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/2/0/m = #4744 */
    { 0x0880, 0x2152, 0xbba0, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/2/0/u = #4745 */
    { 0x08a0, 0x2152, 0x3b20, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/2/0/0x20 = #4746 */
    { 0x09ff, 0x2152, 0x3b20, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/2/1/m = #4747 */
    { 0x0980, 0x2152, 0xbba0, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/2/1/u = #4748 */
    { 0x09a0, 0x2152, 0x3b20, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/2/1/0x20 = #4749 */
    { 0x0aff, 0x2152, 0x3b20, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/2/2/m = #4750 */
    { 0x0a80, 0x2152, 0xbba0, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/2/2/u = #4751 */
    { 0x0aa0, 0x2152, 0x3b20, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/2/2/0x20 = #4752 */
    { 0x0bff, 0x2152, 0x3b20, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/2/3/m = #4753 */
    { 0x0b80, 0x2152, 0xbba0, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/2/3/u = #4754 */
    { 0x0ba0, 0x2152, 0x3b20, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe793,16373) }, /* #89/2/3/0x20 = #4755 */
    { 0x0cff, 0x2152, 0x3920, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/3/0/m = #4756 */
    { 0x0c80, 0x2152, 0xb9a0, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/3/0/u = #4757 */
    { 0x0ca0, 0x2152, 0x3920, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/3/0/0x20 = #4758 */
    { 0x0dff, 0x2152, 0x3920, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/3/1/m = #4759 */
    { 0x0d80, 0x2152, 0xb9a0, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/3/1/u = #4760 */
    { 0x0da0, 0x2152, 0x3920, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/3/1/0x20 = #4761 */
    { 0x0eff, 0x2152, 0x3920, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/3/2/m = #4762 */
    { 0x0e80, 0x2152, 0xb9a0, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/3/2/u = #4763 */
    { 0x0ea0, 0x2152, 0x3920, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/3/2/0x20 = #4764 */
    { 0x0fff, 0x2152, 0x3920, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/3/3/m = #4765 */
    { 0x0f80, 0x2152, 0xb9a0, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/3/3/u = #4766 */
    { 0x0fa0, 0x2152, 0x3920, RTFLOAT80U_INIT_C(0,0x847e33de6369f170,16374), RTFLOAT80U_INIT_C(0,0xb7cd92eefedbe792,16373) }, /* #89/3/3/0x20 = #4767 */
    { 0x00ff, 0x66ea, 0x7e20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/0/0/m = #4768 */
    { 0x0080, 0x66ea, 0xfea0, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/0/0/u = #4769 */
    { 0x00a0, 0x66ea, 0x7e20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/0/0/0x20 = #4770 */
    { 0x01ff, 0x66ea, 0x7e20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/0/1/m = #4771 */
    { 0x0180, 0x66ea, 0xfea0, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/0/1/u = #4772 */
    { 0x01a0, 0x66ea, 0x7e20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/0/1/0x20 = #4773 */
    { 0x02ff, 0x66ea, 0x7e20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/0/2/m = #4774 */
    { 0x0280, 0x66ea, 0xfea0, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/0/2/u = #4775 */
    { 0x02a0, 0x66ea, 0x7e20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/0/2/0x20 = #4776 */
    { 0x03ff, 0x66ea, 0x7e20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/0/3/m = #4777 */
    { 0x0380, 0x66ea, 0xfea0, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/0/3/u = #4778 */
    { 0x03a0, 0x66ea, 0x7e20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/0/3/0x20 = #4779 */
    { 0x04ff, 0x66ea, 0x7c20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/1/0/m = #4780 */
    { 0x0480, 0x66ea, 0xfca0, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/1/0/u = #4781 */
    { 0x04a0, 0x66ea, 0x7c20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/1/0/0x20 = #4782 */
    { 0x05ff, 0x66ea, 0x7c20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/1/1/m = #4783 */
    { 0x0580, 0x66ea, 0xfca0, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/1/1/u = #4784 */
    { 0x05a0, 0x66ea, 0x7c20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/1/1/0x20 = #4785 */
    { 0x06ff, 0x66ea, 0x7c20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/1/2/m = #4786 */
    { 0x0680, 0x66ea, 0xfca0, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/1/2/u = #4787 */
    { 0x06a0, 0x66ea, 0x7c20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/1/2/0x20 = #4788 */
    { 0x07ff, 0x66ea, 0x7c20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/1/3/m = #4789 */
    { 0x0780, 0x66ea, 0xfca0, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/1/3/u = #4790 */
    { 0x07a0, 0x66ea, 0x7c20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/1/3/0x20 = #4791 */
    { 0x08ff, 0x66ea, 0x7e20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/2/0/m = #4792 */
    { 0x0880, 0x66ea, 0xfea0, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/2/0/u = #4793 */
    { 0x08a0, 0x66ea, 0x7e20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/2/0/0x20 = #4794 */
    { 0x09ff, 0x66ea, 0x7e20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/2/1/m = #4795 */
    { 0x0980, 0x66ea, 0xfea0, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/2/1/u = #4796 */
    { 0x09a0, 0x66ea, 0x7e20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/2/1/0x20 = #4797 */
    { 0x0aff, 0x66ea, 0x7e20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/2/2/m = #4798 */
    { 0x0a80, 0x66ea, 0xfea0, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/2/2/u = #4799 */
    { 0x0aa0, 0x66ea, 0x7e20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/2/2/0x20 = #4800 */
    { 0x0bff, 0x66ea, 0x7e20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/2/3/m = #4801 */
    { 0x0b80, 0x66ea, 0xfea0, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/2/3/u = #4802 */
    { 0x0ba0, 0x66ea, 0x7e20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002d,16326) }, /* #90/2/3/0x20 = #4803 */
    { 0x0cff, 0x66ea, 0x7c20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/3/0/m = #4804 */
    { 0x0c80, 0x66ea, 0xfca0, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/3/0/u = #4805 */
    { 0x0ca0, 0x66ea, 0x7c20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/3/0/0x20 = #4806 */
    { 0x0dff, 0x66ea, 0x7c20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/3/1/m = #4807 */
    { 0x0d80, 0x66ea, 0xfca0, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/3/1/u = #4808 */
    { 0x0da0, 0x66ea, 0x7c20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/3/1/0x20 = #4809 */
    { 0x0eff, 0x66ea, 0x7c20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/3/2/m = #4810 */
    { 0x0e80, 0x66ea, 0xfca0, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/3/2/u = #4811 */
    { 0x0ea0, 0x66ea, 0x7c20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/3/2/0x20 = #4812 */
    { 0x0fff, 0x66ea, 0x7c20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/3/3/m = #4813 */
    { 0x0f80, 0x66ea, 0xfca0, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/3/3/u = #4814 */
    { 0x0fa0, 0x66ea, 0x7c20, RTFLOAT80U_INIT_C(0,0xcdb3029eabb78821,16326), RTFLOAT80U_INIT_C(0,0x8e9471c914ec002c,16326) }, /* #90/3/3/0x20 = #4815 */
    { 0x00ff, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/0/0/m = #4816 */
    { 0x0080, 0x2449, 0xbca0, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/0/0/u = #4817 */
    { 0x00a0, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/0/0/0x20 = #4818 */
    { 0x01ff, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/0/1/m = #4819 */
    { 0x0180, 0x2449, 0xbca0, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/0/1/u = #4820 */
    { 0x01a0, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/0/1/0x20 = #4821 */
    { 0x02ff, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/0/2/m = #4822 */
    { 0x0280, 0x2449, 0xbca0, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/0/2/u = #4823 */
    { 0x02a0, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/0/2/0x20 = #4824 */
    { 0x03ff, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/0/3/m = #4825 */
    { 0x0380, 0x2449, 0xbca0, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/0/3/u = #4826 */
    { 0x03a0, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/0/3/0x20 = #4827 */
    { 0x04ff, 0x2449, 0x3e20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b1,16350) }, /* #91/1/0/m = #4828 */
    { 0x0480, 0x2449, 0xbea0, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b1,16350) }, /* #91/1/0/u = #4829 */
    { 0x04a0, 0x2449, 0x3e20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b1,16350) }, /* #91/1/0/0x20 = #4830 */
    { 0x05ff, 0x2449, 0x3e20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b1,16350) }, /* #91/1/1/m = #4831 */
    { 0x0580, 0x2449, 0xbea0, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b1,16350) }, /* #91/1/1/u = #4832 */
    { 0x05a0, 0x2449, 0x3e20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b1,16350) }, /* #91/1/1/0x20 = #4833 */
    { 0x06ff, 0x2449, 0x3e20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b1,16350) }, /* #91/1/2/m = #4834 */
    { 0x0680, 0x2449, 0xbea0, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b1,16350) }, /* #91/1/2/u = #4835 */
    { 0x06a0, 0x2449, 0x3e20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b1,16350) }, /* #91/1/2/0x20 = #4836 */
    { 0x07ff, 0x2449, 0x3e20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b1,16350) }, /* #91/1/3/m = #4837 */
    { 0x0780, 0x2449, 0xbea0, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b1,16350) }, /* #91/1/3/u = #4838 */
    { 0x07a0, 0x2449, 0x3e20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b1,16350) }, /* #91/1/3/0x20 = #4839 */
    { 0x08ff, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/2/0/m = #4840 */
    { 0x0880, 0x2449, 0xbca0, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/2/0/u = #4841 */
    { 0x08a0, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/2/0/0x20 = #4842 */
    { 0x09ff, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/2/1/m = #4843 */
    { 0x0980, 0x2449, 0xbca0, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/2/1/u = #4844 */
    { 0x09a0, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/2/1/0x20 = #4845 */
    { 0x0aff, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/2/2/m = #4846 */
    { 0x0a80, 0x2449, 0xbca0, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/2/2/u = #4847 */
    { 0x0aa0, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/2/2/0x20 = #4848 */
    { 0x0bff, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/2/3/m = #4849 */
    { 0x0b80, 0x2449, 0xbca0, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/2/3/u = #4850 */
    { 0x0ba0, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/2/3/0x20 = #4851 */
    { 0x0cff, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/3/0/m = #4852 */
    { 0x0c80, 0x2449, 0xbca0, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/3/0/u = #4853 */
    { 0x0ca0, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/3/0/0x20 = #4854 */
    { 0x0dff, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/3/1/m = #4855 */
    { 0x0d80, 0x2449, 0xbca0, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/3/1/u = #4856 */
    { 0x0da0, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/3/1/0x20 = #4857 */
    { 0x0eff, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/3/2/m = #4858 */
    { 0x0e80, 0x2449, 0xbca0, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/3/2/u = #4859 */
    { 0x0ea0, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/3/2/0x20 = #4860 */
    { 0x0fff, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/3/3/m = #4861 */
    { 0x0f80, 0x2449, 0xbca0, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/3/3/u = #4862 */
    { 0x0fa0, 0x2449, 0x3c20, RTFLOAT80U_INIT_C(1,0xa7ce44d96edfc1bc,16351), RTFLOAT80U_INIT_C(1,0xe8a0ce5586bcf4b0,16350) }, /* #91/3/3/0x20 = #4863 */
    { 0x00ff, 0xc463, 0x7e20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/0/0/m = #4864 */
    { 0x0080, 0xc463, 0xfea0, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/0/0/u = #4865 */
    { 0x00a0, 0xc463, 0x7e20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/0/0/0x20 = #4866 */
    { 0x01ff, 0xc463, 0x7e20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/0/1/m = #4867 */
    { 0x0180, 0xc463, 0xfea0, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/0/1/u = #4868 */
    { 0x01a0, 0xc463, 0x7e20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/0/1/0x20 = #4869 */
    { 0x02ff, 0xc463, 0x7e20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/0/2/m = #4870 */
    { 0x0280, 0xc463, 0xfea0, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/0/2/u = #4871 */
    { 0x02a0, 0xc463, 0x7e20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/0/2/0x20 = #4872 */
    { 0x03ff, 0xc463, 0x7e20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/0/3/m = #4873 */
    { 0x0380, 0xc463, 0xfea0, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/0/3/u = #4874 */
    { 0x03a0, 0xc463, 0x7e20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/0/3/0x20 = #4875 */
    { 0x04ff, 0xc463, 0x7e20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/1/0/m = #4876 */
    { 0x0480, 0xc463, 0xfea0, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/1/0/u = #4877 */
    { 0x04a0, 0xc463, 0x7e20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/1/0/0x20 = #4878 */
    { 0x05ff, 0xc463, 0x7e20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/1/1/m = #4879 */
    { 0x0580, 0xc463, 0xfea0, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/1/1/u = #4880 */
    { 0x05a0, 0xc463, 0x7e20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/1/1/0x20 = #4881 */
    { 0x06ff, 0xc463, 0x7e20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/1/2/m = #4882 */
    { 0x0680, 0xc463, 0xfea0, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/1/2/u = #4883 */
    { 0x06a0, 0xc463, 0x7e20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/1/2/0x20 = #4884 */
    { 0x07ff, 0xc463, 0x7e20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/1/3/m = #4885 */
    { 0x0780, 0xc463, 0xfea0, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/1/3/u = #4886 */
    { 0x07a0, 0xc463, 0x7e20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a36988a,16314) }, /* #92/1/3/0x20 = #4887 */
    { 0x08ff, 0xc463, 0x7c20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/2/0/m = #4888 */
    { 0x0880, 0xc463, 0xfca0, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/2/0/u = #4889 */
    { 0x08a0, 0xc463, 0x7c20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/2/0/0x20 = #4890 */
    { 0x09ff, 0xc463, 0x7c20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/2/1/m = #4891 */
    { 0x0980, 0xc463, 0xfca0, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/2/1/u = #4892 */
    { 0x09a0, 0xc463, 0x7c20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/2/1/0x20 = #4893 */
    { 0x0aff, 0xc463, 0x7c20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/2/2/m = #4894 */
    { 0x0a80, 0xc463, 0xfca0, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/2/2/u = #4895 */
    { 0x0aa0, 0xc463, 0x7c20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/2/2/0x20 = #4896 */
    { 0x0bff, 0xc463, 0x7c20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/2/3/m = #4897 */
    { 0x0b80, 0xc463, 0xfca0, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/2/3/u = #4898 */
    { 0x0ba0, 0xc463, 0x7c20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/2/3/0x20 = #4899 */
    { 0x0cff, 0xc463, 0x7c20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/3/0/m = #4900 */
    { 0x0c80, 0xc463, 0xfca0, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/3/0/u = #4901 */
    { 0x0ca0, 0xc463, 0x7c20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/3/0/0x20 = #4902 */
    { 0x0dff, 0xc463, 0x7c20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/3/1/m = #4903 */
    { 0x0d80, 0xc463, 0xfca0, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/3/1/u = #4904 */
    { 0x0da0, 0xc463, 0x7c20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/3/1/0x20 = #4905 */
    { 0x0eff, 0xc463, 0x7c20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/3/2/m = #4906 */
    { 0x0e80, 0xc463, 0xfca0, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/3/2/u = #4907 */
    { 0x0ea0, 0xc463, 0x7c20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/3/2/0x20 = #4908 */
    { 0x0fff, 0xc463, 0x7c20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/3/3/m = #4909 */
    { 0x0f80, 0xc463, 0xfca0, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/3/3/u = #4910 */
    { 0x0fa0, 0xc463, 0x7c20, RTFLOAT80U_INIT_C(1,0xbc1ec94c26171b10,16314), RTFLOAT80U_INIT_C(1,0x826520802a369889,16314) }, /* #92/3/3/0x20 = #4911 */
    { 0x00ff, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/0/0/m = #4912 */
    { 0x0080, 0x5f04, 0xfda0, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/0/0/u = #4913 */
    { 0x00a0, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/0/0/0x20 = #4914 */
    { 0x01ff, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/0/1/m = #4915 */
    { 0x0180, 0x5f04, 0xfda0, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/0/1/u = #4916 */
    { 0x01a0, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/0/1/0x20 = #4917 */
    { 0x02ff, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/0/2/m = #4918 */
    { 0x0280, 0x5f04, 0xfda0, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/0/2/u = #4919 */
    { 0x02a0, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/0/2/0x20 = #4920 */
    { 0x03ff, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/0/3/m = #4921 */
    { 0x0380, 0x5f04, 0xfda0, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/0/3/u = #4922 */
    { 0x03a0, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/0/3/0x20 = #4923 */
    { 0x04ff, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/1/0/m = #4924 */
    { 0x0480, 0x5f04, 0xfda0, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/1/0/u = #4925 */
    { 0x04a0, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/1/0/0x20 = #4926 */
    { 0x05ff, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/1/1/m = #4927 */
    { 0x0580, 0x5f04, 0xfda0, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/1/1/u = #4928 */
    { 0x05a0, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/1/1/0x20 = #4929 */
    { 0x06ff, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/1/2/m = #4930 */
    { 0x0680, 0x5f04, 0xfda0, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/1/2/u = #4931 */
    { 0x06a0, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/1/2/0x20 = #4932 */
    { 0x07ff, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/1/3/m = #4933 */
    { 0x0780, 0x5f04, 0xfda0, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/1/3/u = #4934 */
    { 0x07a0, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/1/3/0x20 = #4935 */
    { 0x08ff, 0x5f04, 0x7f20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec70,16340) }, /* #93/2/0/m = #4936 */
    { 0x0880, 0x5f04, 0xffa0, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec70,16340) }, /* #93/2/0/u = #4937 */
    { 0x08a0, 0x5f04, 0x7f20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec70,16340) }, /* #93/2/0/0x20 = #4938 */
    { 0x09ff, 0x5f04, 0x7f20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec70,16340) }, /* #93/2/1/m = #4939 */
    { 0x0980, 0x5f04, 0xffa0, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec70,16340) }, /* #93/2/1/u = #4940 */
    { 0x09a0, 0x5f04, 0x7f20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec70,16340) }, /* #93/2/1/0x20 = #4941 */
    { 0x0aff, 0x5f04, 0x7f20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec70,16340) }, /* #93/2/2/m = #4942 */
    { 0x0a80, 0x5f04, 0xffa0, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec70,16340) }, /* #93/2/2/u = #4943 */
    { 0x0aa0, 0x5f04, 0x7f20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec70,16340) }, /* #93/2/2/0x20 = #4944 */
    { 0x0bff, 0x5f04, 0x7f20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec70,16340) }, /* #93/2/3/m = #4945 */
    { 0x0b80, 0x5f04, 0xffa0, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec70,16340) }, /* #93/2/3/u = #4946 */
    { 0x0ba0, 0x5f04, 0x7f20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec70,16340) }, /* #93/2/3/0x20 = #4947 */
    { 0x0cff, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/3/0/m = #4948 */
    { 0x0c80, 0x5f04, 0xfda0, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/3/0/u = #4949 */
    { 0x0ca0, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/3/0/0x20 = #4950 */
    { 0x0dff, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/3/1/m = #4951 */
    { 0x0d80, 0x5f04, 0xfda0, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/3/1/u = #4952 */
    { 0x0da0, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/3/1/0x20 = #4953 */
    { 0x0eff, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/3/2/m = #4954 */
    { 0x0e80, 0x5f04, 0xfda0, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/3/2/u = #4955 */
    { 0x0ea0, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/3/2/0x20 = #4956 */
    { 0x0fff, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/3/3/m = #4957 */
    { 0x0f80, 0x5f04, 0xfda0, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/3/3/u = #4958 */
    { 0x0fa0, 0x5f04, 0x7d20, RTFLOAT80U_INIT_C(0,0xbf1c7568f3c78b31,16340), RTFLOAT80U_INIT_C(0,0x8477d9be68f4ec6f,16340) }, /* #93/3/3/0x20 = #4959 */
    { 0x00ff, 0xf5ea, 0x7f20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/0/0/m = #4960 */
    { 0x0080, 0xf5ea, 0xffa0, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/0/0/u = #4961 */
    { 0x00a0, 0xf5ea, 0x7f20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/0/0/0x20 = #4962 */
    { 0x01ff, 0xf5ea, 0x7f20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/0/1/m = #4963 */
    { 0x0180, 0xf5ea, 0xffa0, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/0/1/u = #4964 */
    { 0x01a0, 0xf5ea, 0x7f20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/0/1/0x20 = #4965 */
    { 0x02ff, 0xf5ea, 0x7f20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/0/2/m = #4966 */
    { 0x0280, 0xf5ea, 0xffa0, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/0/2/u = #4967 */
    { 0x02a0, 0xf5ea, 0x7f20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/0/2/0x20 = #4968 */
    { 0x03ff, 0xf5ea, 0x7f20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/0/3/m = #4969 */
    { 0x0380, 0xf5ea, 0xffa0, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/0/3/u = #4970 */
    { 0x03a0, 0xf5ea, 0x7f20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/0/3/0x20 = #4971 */
    { 0x04ff, 0xf5ea, 0x7d20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/1/0/m = #4972 */
    { 0x0480, 0xf5ea, 0xfda0, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/1/0/u = #4973 */
    { 0x04a0, 0xf5ea, 0x7d20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/1/0/0x20 = #4974 */
    { 0x05ff, 0xf5ea, 0x7d20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/1/1/m = #4975 */
    { 0x0580, 0xf5ea, 0xfda0, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/1/1/u = #4976 */
    { 0x05a0, 0xf5ea, 0x7d20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/1/1/0x20 = #4977 */
    { 0x06ff, 0xf5ea, 0x7d20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/1/2/m = #4978 */
    { 0x0680, 0xf5ea, 0xfda0, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/1/2/u = #4979 */
    { 0x06a0, 0xf5ea, 0x7d20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/1/2/0x20 = #4980 */
    { 0x07ff, 0xf5ea, 0x7d20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/1/3/m = #4981 */
    { 0x0780, 0xf5ea, 0xfda0, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/1/3/u = #4982 */
    { 0x07a0, 0xf5ea, 0x7d20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/1/3/0x20 = #4983 */
    { 0x08ff, 0xf5ea, 0x7f20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/2/0/m = #4984 */
    { 0x0880, 0xf5ea, 0xffa0, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/2/0/u = #4985 */
    { 0x08a0, 0xf5ea, 0x7f20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/2/0/0x20 = #4986 */
    { 0x09ff, 0xf5ea, 0x7f20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/2/1/m = #4987 */
    { 0x0980, 0xf5ea, 0xffa0, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/2/1/u = #4988 */
    { 0x09a0, 0xf5ea, 0x7f20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/2/1/0x20 = #4989 */
    { 0x0aff, 0xf5ea, 0x7f20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/2/2/m = #4990 */
    { 0x0a80, 0xf5ea, 0xffa0, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/2/2/u = #4991 */
    { 0x0aa0, 0xf5ea, 0x7f20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/2/2/0x20 = #4992 */
    { 0x0bff, 0xf5ea, 0x7f20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/2/3/m = #4993 */
    { 0x0b80, 0xf5ea, 0xffa0, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/2/3/u = #4994 */
    { 0x0ba0, 0xf5ea, 0x7f20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a5,16369) }, /* #94/2/3/0x20 = #4995 */
    { 0x0cff, 0xf5ea, 0x7d20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/3/0/m = #4996 */
    { 0x0c80, 0xf5ea, 0xfda0, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/3/0/u = #4997 */
    { 0x0ca0, 0xf5ea, 0x7d20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/3/0/0x20 = #4998 */
    { 0x0dff, 0xf5ea, 0x7d20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/3/1/m = #4999 */
    { 0x0d80, 0xf5ea, 0xfda0, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/3/1/u = #5000 */
    { 0x0da0, 0xf5ea, 0x7d20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/3/1/0x20 = #5001 */
    { 0x0eff, 0xf5ea, 0x7d20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/3/2/m = #5002 */
    { 0x0e80, 0xf5ea, 0xfda0, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/3/2/u = #5003 */
    { 0x0ea0, 0xf5ea, 0x7d20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/3/2/0x20 = #5004 */
    { 0x0fff, 0xf5ea, 0x7d20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/3/3/m = #5005 */
    { 0x0f80, 0xf5ea, 0xfda0, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/3/3/u = #5006 */
    { 0x0fa0, 0xf5ea, 0x7d20, RTFLOAT80U_INIT_C(0,0xa75450ea7736c7cd,16370), RTFLOAT80U_INIT_C(0,0xe7fb071d7bb009a4,16369) }, /* #94/3/3/0x20 = #5007 */
    { 0x007f, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/0/0/m = #5008 */
    { 0x0000, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/0/0/u = #5009 */
    { 0x017f, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/0/1/m = #5010 */
    { 0x0100, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/0/1/u = #5011 */
    { 0x027f, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/0/2/m = #5012 */
    { 0x0200, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/0/2/u = #5013 */
    { 0x037f, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/0/3/m = #5014 */
    { 0x0300, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/0/3/u = #5015 */
    { 0x047f, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/1/0/m = #5016 */
    { 0x0400, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/1/0/u = #5017 */
    { 0x057f, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/1/1/m = #5018 */
    { 0x0500, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/1/1/u = #5019 */
    { 0x067f, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/1/2/m = #5020 */
    { 0x0600, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/1/2/u = #5021 */
    { 0x077f, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/1/3/m = #5022 */
    { 0x0700, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/1/3/u = #5023 */
    { 0x087f, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/2/0/m = #5024 */
    { 0x0800, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/2/0/u = #5025 */
    { 0x097f, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/2/1/m = #5026 */
    { 0x0900, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/2/1/u = #5027 */
    { 0x0a7f, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/2/2/m = #5028 */
    { 0x0a00, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/2/2/u = #5029 */
    { 0x0b7f, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/2/3/m = #5030 */
    { 0x0b00, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/2/3/u = #5031 */
    { 0x0c7f, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/3/0/m = #5032 */
    { 0x0c00, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/3/0/u = #5033 */
    { 0x0d7f, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/3/1/m = #5034 */
    { 0x0d00, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/3/1/u = #5035 */
    { 0x0e7f, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/3/2/m = #5036 */
    { 0x0e00, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/3/2/u = #5037 */
    { 0x0f7f, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/3/3/m = #5038 */
    { 0x0f00, 0xcf8b, 0x7d00, RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767), RTFLOAT80U_INIT_C(0,0xc00000000000001b,32767) }, /* #95/3/3/u = #5039 */
    { 0x00ff, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/0/0/m = #5040 */
    { 0x0080, 0x4d7d, 0xfda0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/0/0/u = #5041 */
    { 0x00a0, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/0/0/0x20 = #5042 */
    { 0x01ff, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/0/1/m = #5043 */
    { 0x0180, 0x4d7d, 0xfda0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/0/1/u = #5044 */
    { 0x01a0, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/0/1/0x20 = #5045 */
    { 0x02ff, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/0/2/m = #5046 */
    { 0x0280, 0x4d7d, 0xfda0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/0/2/u = #5047 */
    { 0x02a0, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/0/2/0x20 = #5048 */
    { 0x03ff, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/0/3/m = #5049 */
    { 0x0380, 0x4d7d, 0xfda0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/0/3/u = #5050 */
    { 0x03a0, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/0/3/0x20 = #5051 */
    { 0x04ff, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/1/0/m = #5052 */
    { 0x0480, 0x4d7d, 0xfda0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/1/0/u = #5053 */
    { 0x04a0, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/1/0/0x20 = #5054 */
    { 0x05ff, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/1/1/m = #5055 */
    { 0x0580, 0x4d7d, 0xfda0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/1/1/u = #5056 */
    { 0x05a0, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/1/1/0x20 = #5057 */
    { 0x06ff, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/1/2/m = #5058 */
    { 0x0680, 0x4d7d, 0xfda0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/1/2/u = #5059 */
    { 0x06a0, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/1/2/0x20 = #5060 */
    { 0x07ff, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/1/3/m = #5061 */
    { 0x0780, 0x4d7d, 0xfda0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/1/3/u = #5062 */
    { 0x07a0, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/1/3/0x20 = #5063 */
    { 0x08ff, 0x4d7d, 0x7f20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799212,16381) }, /* #96/2/0/m = #5064 */
    { 0x0880, 0x4d7d, 0xffa0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799212,16381) }, /* #96/2/0/u = #5065 */
    { 0x08a0, 0x4d7d, 0x7f20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799212,16381) }, /* #96/2/0/0x20 = #5066 */
    { 0x09ff, 0x4d7d, 0x7f20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799212,16381) }, /* #96/2/1/m = #5067 */
    { 0x0980, 0x4d7d, 0xffa0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799212,16381) }, /* #96/2/1/u = #5068 */
    { 0x09a0, 0x4d7d, 0x7f20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799212,16381) }, /* #96/2/1/0x20 = #5069 */
    { 0x0aff, 0x4d7d, 0x7f20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799212,16381) }, /* #96/2/2/m = #5070 */
    { 0x0a80, 0x4d7d, 0xffa0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799212,16381) }, /* #96/2/2/u = #5071 */
    { 0x0aa0, 0x4d7d, 0x7f20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799212,16381) }, /* #96/2/2/0x20 = #5072 */
    { 0x0bff, 0x4d7d, 0x7f20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799212,16381) }, /* #96/2/3/m = #5073 */
    { 0x0b80, 0x4d7d, 0xffa0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799212,16381) }, /* #96/2/3/u = #5074 */
    { 0x0ba0, 0x4d7d, 0x7f20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799212,16381) }, /* #96/2/3/0x20 = #5075 */
    { 0x0cff, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/3/0/m = #5076 */
    { 0x0c80, 0x4d7d, 0xfda0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/3/0/u = #5077 */
    { 0x0ca0, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/3/0/0x20 = #5078 */
    { 0x0dff, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/3/1/m = #5079 */
    { 0x0d80, 0x4d7d, 0xfda0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/3/1/u = #5080 */
    { 0x0da0, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/3/1/0x20 = #5081 */
    { 0x0eff, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/3/2/m = #5082 */
    { 0x0e80, 0x4d7d, 0xfda0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/3/2/u = #5083 */
    { 0x0ea0, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/3/2/0x20 = #5084 */
    { 0x0fff, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/3/3/m = #5085 */
    { 0x0f80, 0x4d7d, 0xfda0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/3/3/u = #5086 */
    { 0x0fa0, 0x4d7d, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,16382), RTFLOAT80U_INIT_C(0,0xd413cccfe7799211,16381) }, /* #96/3/3/0x20 = #5087 */
    { 0x00ff, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/0/0/m = #5088 */
    { 0x0080, 0x45c7, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/0/0/u = #5089 */
    { 0x00a0, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/0/0/0x20 = #5090 */
    { 0x01ff, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/0/1/m = #5091 */
    { 0x0180, 0x45c7, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/0/1/u = #5092 */
    { 0x01a0, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/0/1/0x20 = #5093 */
    { 0x02ff, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/0/2/m = #5094 */
    { 0x0280, 0x45c7, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/0/2/u = #5095 */
    { 0x02a0, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/0/2/0x20 = #5096 */
    { 0x03ff, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/0/3/m = #5097 */
    { 0x0380, 0x45c7, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/0/3/u = #5098 */
    { 0x03a0, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/0/3/0x20 = #5099 */
    { 0x04ff, 0x45c7, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f8,16381) }, /* #97/1/0/m = #5100 */
    { 0x0480, 0x45c7, 0xffa0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f8,16381) }, /* #97/1/0/u = #5101 */
    { 0x04a0, 0x45c7, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f8,16381) }, /* #97/1/0/0x20 = #5102 */
    { 0x05ff, 0x45c7, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f8,16381) }, /* #97/1/1/m = #5103 */
    { 0x0580, 0x45c7, 0xffa0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f8,16381) }, /* #97/1/1/u = #5104 */
    { 0x05a0, 0x45c7, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f8,16381) }, /* #97/1/1/0x20 = #5105 */
    { 0x06ff, 0x45c7, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f8,16381) }, /* #97/1/2/m = #5106 */
    { 0x0680, 0x45c7, 0xffa0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f8,16381) }, /* #97/1/2/u = #5107 */
    { 0x06a0, 0x45c7, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f8,16381) }, /* #97/1/2/0x20 = #5108 */
    { 0x07ff, 0x45c7, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f8,16381) }, /* #97/1/3/m = #5109 */
    { 0x0780, 0x45c7, 0xffa0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f8,16381) }, /* #97/1/3/u = #5110 */
    { 0x07a0, 0x45c7, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f8,16381) }, /* #97/1/3/0x20 = #5111 */
    { 0x08ff, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/2/0/m = #5112 */
    { 0x0880, 0x45c7, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/2/0/u = #5113 */
    { 0x08a0, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/2/0/0x20 = #5114 */
    { 0x09ff, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/2/1/m = #5115 */
    { 0x0980, 0x45c7, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/2/1/u = #5116 */
    { 0x09a0, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/2/1/0x20 = #5117 */
    { 0x0aff, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/2/2/m = #5118 */
    { 0x0a80, 0x45c7, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/2/2/u = #5119 */
    { 0x0aa0, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/2/2/0x20 = #5120 */
    { 0x0bff, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/2/3/m = #5121 */
    { 0x0b80, 0x45c7, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/2/3/u = #5122 */
    { 0x0ba0, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/2/3/0x20 = #5123 */
    { 0x0cff, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/3/0/m = #5124 */
    { 0x0c80, 0x45c7, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/3/0/u = #5125 */
    { 0x0ca0, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/3/0/0x20 = #5126 */
    { 0x0dff, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/3/1/m = #5127 */
    { 0x0d80, 0x45c7, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/3/1/u = #5128 */
    { 0x0da0, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/3/1/0x20 = #5129 */
    { 0x0eff, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/3/2/m = #5130 */
    { 0x0e80, 0x45c7, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/3/2/u = #5131 */
    { 0x0ea0, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/3/2/0x20 = #5132 */
    { 0x0fff, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/3/3/m = #5133 */
    { 0x0f80, 0x45c7, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/3/3/u = #5134 */
    { 0x0fa0, 0x45c7, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,16382), RTFLOAT80U_INIT_C(1,0x95f619980c4336f7,16381) }, /* #97/3/3/0x20 = #5135 */
    { 0x007f, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/0/0/m = #5136 */
    { 0x0000, 0x281e, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/0/0/u = #5137 */
    { 0x0020, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/0/0/0x20 = #5138 */
    { 0x017f, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/0/1/m = #5139 */
    { 0x0100, 0x281e, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/0/1/u = #5140 */
    { 0x0120, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/0/1/0x20 = #5141 */
    { 0x027f, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/0/2/m = #5142 */
    { 0x0200, 0x281e, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/0/2/u = #5143 */
    { 0x0220, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/0/2/0x20 = #5144 */
    { 0x037f, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/0/3/m = #5145 */
    { 0x0300, 0x281e, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/0/3/u = #5146 */
    { 0x0320, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/0/3/0x20 = #5147 */
    { 0x047f, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/1/0/m = #5148 */
    { 0x0400, 0x281e, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/1/0/u = #5149 */
    { 0x0420, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/1/0/0x20 = #5150 */
    { 0x057f, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/1/1/m = #5151 */
    { 0x0500, 0x281e, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/1/1/u = #5152 */
    { 0x0520, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/1/1/0x20 = #5153 */
    { 0x067f, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/1/2/m = #5154 */
    { 0x0600, 0x281e, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/1/2/u = #5155 */
    { 0x0620, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/1/2/0x20 = #5156 */
    { 0x077f, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/1/3/m = #5157 */
    { 0x0700, 0x281e, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/1/3/u = #5158 */
    { 0x0720, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/1/3/0x20 = #5159 */
    { 0x087f, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/2/0/m = #5160 */
    { 0x0800, 0x281e, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/2/0/u = #5161 */
    { 0x0820, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/2/0/0x20 = #5162 */
    { 0x097f, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/2/1/m = #5163 */
    { 0x0900, 0x281e, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/2/1/u = #5164 */
    { 0x0920, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/2/1/0x20 = #5165 */
    { 0x0a7f, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/2/2/m = #5166 */
    { 0x0a00, 0x281e, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/2/2/u = #5167 */
    { 0x0a20, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/2/2/0x20 = #5168 */
    { 0x0b7f, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/2/3/m = #5169 */
    { 0x0b00, 0x281e, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/2/3/u = #5170 */
    { 0x0b20, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/2/3/0x20 = #5171 */
    { 0x0c7f, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/3/0/m = #5172 */
    { 0x0c00, 0x281e, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/3/0/u = #5173 */
    { 0x0c20, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/3/0/0x20 = #5174 */
    { 0x0d7f, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/3/1/m = #5175 */
    { 0x0d00, 0x281e, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/3/1/u = #5176 */
    { 0x0d20, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/3/1/0x20 = #5177 */
    { 0x0e7f, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/3/2/m = #5178 */
    { 0x0e00, 0x281e, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/3/2/u = #5179 */
    { 0x0e20, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/3/2/0x20 = #5180 */
    { 0x0f7f, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/3/3/m = #5181 */
    { 0x0f00, 0x281e, 0xb8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/3/3/u = #5182 */
    { 0x0f20, 0x281e, 0x3820, RTFLOAT80U_INIT_C(0,0x8000000000000000,16383), RTFLOAT80U_INIT_C(0,0x8000000000000000,16383) }, /* #98/3/3/0x20 = #5183 */
    { 0x007f, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/0/0/m = #5184 */
    { 0x0000, 0x383b, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/0/0/u = #5185 */
    { 0x0020, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/0/0/0x20 = #5186 */
    { 0x017f, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/0/1/m = #5187 */
    { 0x0100, 0x383b, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/0/1/u = #5188 */
    { 0x0120, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/0/1/0x20 = #5189 */
    { 0x027f, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/0/2/m = #5190 */
    { 0x0200, 0x383b, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/0/2/u = #5191 */
    { 0x0220, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/0/2/0x20 = #5192 */
    { 0x037f, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/0/3/m = #5193 */
    { 0x0300, 0x383b, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/0/3/u = #5194 */
    { 0x0320, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/0/3/0x20 = #5195 */
    { 0x047f, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/1/0/m = #5196 */
    { 0x0400, 0x383b, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/1/0/u = #5197 */
    { 0x0420, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/1/0/0x20 = #5198 */
    { 0x057f, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/1/1/m = #5199 */
    { 0x0500, 0x383b, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/1/1/u = #5200 */
    { 0x0520, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/1/1/0x20 = #5201 */
    { 0x067f, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/1/2/m = #5202 */
    { 0x0600, 0x383b, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/1/2/u = #5203 */
    { 0x0620, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/1/2/0x20 = #5204 */
    { 0x077f, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/1/3/m = #5205 */
    { 0x0700, 0x383b, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/1/3/u = #5206 */
    { 0x0720, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/1/3/0x20 = #5207 */
    { 0x087f, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/2/0/m = #5208 */
    { 0x0800, 0x383b, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/2/0/u = #5209 */
    { 0x0820, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/2/0/0x20 = #5210 */
    { 0x097f, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/2/1/m = #5211 */
    { 0x0900, 0x383b, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/2/1/u = #5212 */
    { 0x0920, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/2/1/0x20 = #5213 */
    { 0x0a7f, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/2/2/m = #5214 */
    { 0x0a00, 0x383b, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/2/2/u = #5215 */
    { 0x0a20, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/2/2/0x20 = #5216 */
    { 0x0b7f, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/2/3/m = #5217 */
    { 0x0b00, 0x383b, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/2/3/u = #5218 */
    { 0x0b20, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/2/3/0x20 = #5219 */
    { 0x0c7f, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/3/0/m = #5220 */
    { 0x0c00, 0x383b, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/3/0/u = #5221 */
    { 0x0c20, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/3/0/0x20 = #5222 */
    { 0x0d7f, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/3/1/m = #5223 */
    { 0x0d00, 0x383b, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/3/1/u = #5224 */
    { 0x0d20, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/3/1/0x20 = #5225 */
    { 0x0e7f, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/3/2/m = #5226 */
    { 0x0e00, 0x383b, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/3/2/u = #5227 */
    { 0x0e20, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/3/2/0x20 = #5228 */
    { 0x0f7f, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/3/3/m = #5229 */
    { 0x0f00, 0x383b, 0xb8a0, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/3/3/u = #5230 */
    { 0x0f20, 0x383b, 0x3820, RTFLOAT80U_INIT_C(1,0x8000000000000000,16383), RTFLOAT80U_INIT_C(1,0x8000000000000000,16382) }, /* #99/3/3/0x20 = #5231 */
    { 0x007f, 0x7014, 0x7a32, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/0/0/m = #5232 */
    { 0x0000, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/0/0/u = #5233 */
    { 0x0032, 0x7014, 0x7a32, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/0/0/0x32 = #5234 */
    { 0x0030, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/0/0/u0x2 = #5235 */
    { 0x0022, 0x7014, 0xfab2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,24576) }, /* #100/0/0/u0x10 = #5236 */
    { 0x0012, 0x7014, 0xfab2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/0/0/u0x20 = #5237 */
    { 0x017f, 0x7014, 0x7a32, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/0/1/m = #5238 */
    { 0x0100, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/0/1/u = #5239 */
    { 0x0132, 0x7014, 0x7a32, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/0/1/0x32 = #5240 */
    { 0x0130, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/0/1/u0x2 = #5241 */
    { 0x0122, 0x7014, 0xfab2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,24576) }, /* #100/0/1/u0x10 = #5242 */
    { 0x0112, 0x7014, 0xfab2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/0/1/u0x20 = #5243 */
    { 0x027f, 0x7014, 0x7a32, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/0/2/m = #5244 */
    { 0x0200, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/0/2/u = #5245 */
    { 0x0232, 0x7014, 0x7a32, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/0/2/0x32 = #5246 */
    { 0x0230, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/0/2/u0x2 = #5247 */
    { 0x0222, 0x7014, 0xfab2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,24576) }, /* #100/0/2/u0x10 = #5248 */
    { 0x0212, 0x7014, 0xfab2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/0/2/u0x20 = #5249 */
    { 0x037f, 0x7014, 0x7a32, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/0/3/m = #5250 */
    { 0x0300, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/0/3/u = #5251 */
    { 0x0332, 0x7014, 0x7a32, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/0/3/0x32 = #5252 */
    { 0x0330, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/0/3/u0x2 = #5253 */
    { 0x0322, 0x7014, 0xfab2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,24576) }, /* #100/0/3/u0x10 = #5254 */
    { 0x0312, 0x7014, 0xfab2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/0/3/u0x20 = #5255 */
    { 0x047f, 0x7014, 0x7832, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/1/0/m = #5256 */
    { 0x0400, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/1/0/u = #5257 */
    { 0x0432, 0x7014, 0x7832, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/1/0/0x32 = #5258 */
    { 0x0430, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/1/0/u0x2 = #5259 */
    { 0x0422, 0x7014, 0xf8b2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,24576) }, /* #100/1/0/u0x10 = #5260 */
    { 0x0412, 0x7014, 0xf8b2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/1/0/u0x20 = #5261 */
    { 0x057f, 0x7014, 0x7832, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/1/1/m = #5262 */
    { 0x0500, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/1/1/u = #5263 */
    { 0x0532, 0x7014, 0x7832, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/1/1/0x32 = #5264 */
    { 0x0530, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/1/1/u0x2 = #5265 */
    { 0x0522, 0x7014, 0xf8b2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,24576) }, /* #100/1/1/u0x10 = #5266 */
    { 0x0512, 0x7014, 0xf8b2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/1/1/u0x20 = #5267 */
    { 0x067f, 0x7014, 0x7832, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/1/2/m = #5268 */
    { 0x0600, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/1/2/u = #5269 */
    { 0x0632, 0x7014, 0x7832, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/1/2/0x32 = #5270 */
    { 0x0630, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/1/2/u0x2 = #5271 */
    { 0x0622, 0x7014, 0xf8b2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,24576) }, /* #100/1/2/u0x10 = #5272 */
    { 0x0612, 0x7014, 0xf8b2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/1/2/u0x20 = #5273 */
    { 0x077f, 0x7014, 0x7832, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/1/3/m = #5274 */
    { 0x0700, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/1/3/u = #5275 */
    { 0x0732, 0x7014, 0x7832, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/1/3/0x32 = #5276 */
    { 0x0730, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/1/3/u0x2 = #5277 */
    { 0x0722, 0x7014, 0xf8b2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,24576) }, /* #100/1/3/u0x10 = #5278 */
    { 0x0712, 0x7014, 0xf8b2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/1/3/u0x20 = #5279 */
    { 0x087f, 0x7014, 0x7a32, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/2/0/m = #5280 */
    { 0x0800, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/2/0/u = #5281 */
    { 0x0832, 0x7014, 0x7a32, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/2/0/0x32 = #5282 */
    { 0x0830, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/2/0/u0x2 = #5283 */
    { 0x0822, 0x7014, 0xfab2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,24576) }, /* #100/2/0/u0x10 = #5284 */
    { 0x0812, 0x7014, 0xfab2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/2/0/u0x20 = #5285 */
    { 0x097f, 0x7014, 0x7a32, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/2/1/m = #5286 */
    { 0x0900, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/2/1/u = #5287 */
    { 0x0932, 0x7014, 0x7a32, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/2/1/0x32 = #5288 */
    { 0x0930, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/2/1/u0x2 = #5289 */
    { 0x0922, 0x7014, 0xfab2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,24576) }, /* #100/2/1/u0x10 = #5290 */
    { 0x0912, 0x7014, 0xfab2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/2/1/u0x20 = #5291 */
    { 0x0a7f, 0x7014, 0x7a32, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/2/2/m = #5292 */
    { 0x0a00, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/2/2/u = #5293 */
    { 0x0a32, 0x7014, 0x7a32, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/2/2/0x32 = #5294 */
    { 0x0a30, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/2/2/u0x2 = #5295 */
    { 0x0a22, 0x7014, 0xfab2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,24576) }, /* #100/2/2/u0x10 = #5296 */
    { 0x0a12, 0x7014, 0xfab2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/2/2/u0x20 = #5297 */
    { 0x0b7f, 0x7014, 0x7a32, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/2/3/m = #5298 */
    { 0x0b00, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/2/3/u = #5299 */
    { 0x0b32, 0x7014, 0x7a32, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/2/3/0x32 = #5300 */
    { 0x0b30, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/2/3/u0x2 = #5301 */
    { 0x0b22, 0x7014, 0xfab2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ac,24576) }, /* #100/2/3/u0x10 = #5302 */
    { 0x0b12, 0x7014, 0xfab2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd6,0) }, /* #100/2/3/u0x20 = #5303 */
    { 0x0c7f, 0x7014, 0x7832, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/3/0/m = #5304 */
    { 0x0c00, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/3/0/u = #5305 */
    { 0x0c32, 0x7014, 0x7832, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/3/0/0x32 = #5306 */
    { 0x0c30, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/3/0/u0x2 = #5307 */
    { 0x0c22, 0x7014, 0xf8b2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,24576) }, /* #100/3/0/u0x10 = #5308 */
    { 0x0c12, 0x7014, 0xf8b2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/3/0/u0x20 = #5309 */
    { 0x0d7f, 0x7014, 0x7832, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/3/1/m = #5310 */
    { 0x0d00, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/3/1/u = #5311 */
    { 0x0d32, 0x7014, 0x7832, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/3/1/0x32 = #5312 */
    { 0x0d30, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/3/1/u0x2 = #5313 */
    { 0x0d22, 0x7014, 0xf8b2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,24576) }, /* #100/3/1/u0x10 = #5314 */
    { 0x0d12, 0x7014, 0xf8b2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/3/1/u0x20 = #5315 */
    { 0x0e7f, 0x7014, 0x7832, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/3/2/m = #5316 */
    { 0x0e00, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/3/2/u = #5317 */
    { 0x0e32, 0x7014, 0x7832, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/3/2/0x32 = #5318 */
    { 0x0e30, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/3/2/u0x2 = #5319 */
    { 0x0e22, 0x7014, 0xf8b2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,24576) }, /* #100/3/2/u0x10 = #5320 */
    { 0x0e12, 0x7014, 0xf8b2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/3/2/u0x20 = #5321 */
    { 0x0f7f, 0x7014, 0x7832, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/3/3/m = #5322 */
    { 0x0f00, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/3/3/u = #5323 */
    { 0x0f32, 0x7014, 0x7832, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/3/3/0x32 = #5324 */
    { 0x0f30, 0x7014, 0xf882, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x8000000000000000,0) }, /* #100/3/3/u0x2 = #5325 */
    { 0x0f22, 0x7014, 0xf8b2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0xb17217f7d1cf79ab,24576) }, /* #100/3/3/u0x10 = #5326 */
    { 0x0f12, 0x7014, 0xf8b2, RTFLOAT80U_INIT_C(0,0x8000000000000000,0), RTFLOAT80U_INIT_C(0,0x58b90bfbe8e7bcd5,0) }, /* #100/3/3/u0x20 = #5327 */
    { 0x007f, 0x38f5, 0x3a32, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/0/0/m = #5328 */
    { 0x0000, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/0/0/u = #5329 */
    { 0x0032, 0x38f5, 0x3a32, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/0/0/0x32 = #5330 */
    { 0x0030, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/0/0/u0x2 = #5331 */
    { 0x0022, 0x38f5, 0xbab2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0xb17217f7d1cf79ac,24576) }, /* #101/0/0/u0x10 = #5332 */
    { 0x0012, 0x38f5, 0xbab2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/0/0/u0x20 = #5333 */
    { 0x017f, 0x38f5, 0x3a32, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/0/1/m = #5334 */
    { 0x0100, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/0/1/u = #5335 */
    { 0x0132, 0x38f5, 0x3a32, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/0/1/0x32 = #5336 */
    { 0x0130, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/0/1/u0x2 = #5337 */
    { 0x0122, 0x38f5, 0xbab2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0xb17217f7d1cf79ac,24576) }, /* #101/0/1/u0x10 = #5338 */
    { 0x0112, 0x38f5, 0xbab2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/0/1/u0x20 = #5339 */
    { 0x027f, 0x38f5, 0x3a32, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/0/2/m = #5340 */
    { 0x0200, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/0/2/u = #5341 */
    { 0x0232, 0x38f5, 0x3a32, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/0/2/0x32 = #5342 */
    { 0x0230, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/0/2/u0x2 = #5343 */
    { 0x0222, 0x38f5, 0xbab2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0xb17217f7d1cf79ac,24576) }, /* #101/0/2/u0x10 = #5344 */
    { 0x0212, 0x38f5, 0xbab2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/0/2/u0x20 = #5345 */
    { 0x037f, 0x38f5, 0x3a32, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/0/3/m = #5346 */
    { 0x0300, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/0/3/u = #5347 */
    { 0x0332, 0x38f5, 0x3a32, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/0/3/0x32 = #5348 */
    { 0x0330, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/0/3/u0x2 = #5349 */
    { 0x0322, 0x38f5, 0xbab2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0xb17217f7d1cf79ac,24576) }, /* #101/0/3/u0x10 = #5350 */
    { 0x0312, 0x38f5, 0xbab2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/0/3/u0x20 = #5351 */
    { 0x047f, 0x38f5, 0x3a32, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/1/0/m = #5352 */
    { 0x0400, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/1/0/u = #5353 */
    { 0x0432, 0x38f5, 0x3a32, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/1/0/0x32 = #5354 */
    { 0x0430, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/1/0/u0x2 = #5355 */
    { 0x0422, 0x38f5, 0xbab2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0xb17217f7d1cf79ac,24576) }, /* #101/1/0/u0x10 = #5356 */
    { 0x0412, 0x38f5, 0xbab2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/1/0/u0x20 = #5357 */
    { 0x057f, 0x38f5, 0x3a32, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/1/1/m = #5358 */
    { 0x0500, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/1/1/u = #5359 */
    { 0x0532, 0x38f5, 0x3a32, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/1/1/0x32 = #5360 */
    { 0x0530, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/1/1/u0x2 = #5361 */
    { 0x0522, 0x38f5, 0xbab2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0xb17217f7d1cf79ac,24576) }, /* #101/1/1/u0x10 = #5362 */
    { 0x0512, 0x38f5, 0xbab2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/1/1/u0x20 = #5363 */
    { 0x067f, 0x38f5, 0x3a32, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/1/2/m = #5364 */
    { 0x0600, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/1/2/u = #5365 */
    { 0x0632, 0x38f5, 0x3a32, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/1/2/0x32 = #5366 */
    { 0x0630, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/1/2/u0x2 = #5367 */
    { 0x0622, 0x38f5, 0xbab2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0xb17217f7d1cf79ac,24576) }, /* #101/1/2/u0x10 = #5368 */
    { 0x0612, 0x38f5, 0xbab2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/1/2/u0x20 = #5369 */
    { 0x077f, 0x38f5, 0x3a32, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/1/3/m = #5370 */
    { 0x0700, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/1/3/u = #5371 */
    { 0x0732, 0x38f5, 0x3a32, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/1/3/0x32 = #5372 */
    { 0x0730, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/1/3/u0x2 = #5373 */
    { 0x0722, 0x38f5, 0xbab2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0xb17217f7d1cf79ac,24576) }, /* #101/1/3/u0x10 = #5374 */
    { 0x0712, 0x38f5, 0xbab2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd6,0) }, /* #101/1/3/u0x20 = #5375 */
    { 0x087f, 0x38f5, 0x3832, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/2/0/m = #5376 */
    { 0x0800, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/2/0/u = #5377 */
    { 0x0832, 0x38f5, 0x3832, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/2/0/0x32 = #5378 */
    { 0x0830, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/2/0/u0x2 = #5379 */
    { 0x0822, 0x38f5, 0xb8b2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0xb17217f7d1cf79ab,24576) }, /* #101/2/0/u0x10 = #5380 */
    { 0x0812, 0x38f5, 0xb8b2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/2/0/u0x20 = #5381 */
    { 0x097f, 0x38f5, 0x3832, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/2/1/m = #5382 */
    { 0x0900, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/2/1/u = #5383 */
    { 0x0932, 0x38f5, 0x3832, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/2/1/0x32 = #5384 */
    { 0x0930, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/2/1/u0x2 = #5385 */
    { 0x0922, 0x38f5, 0xb8b2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0xb17217f7d1cf79ab,24576) }, /* #101/2/1/u0x10 = #5386 */
    { 0x0912, 0x38f5, 0xb8b2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/2/1/u0x20 = #5387 */
    { 0x0a7f, 0x38f5, 0x3832, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/2/2/m = #5388 */
    { 0x0a00, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/2/2/u = #5389 */
    { 0x0a32, 0x38f5, 0x3832, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/2/2/0x32 = #5390 */
    { 0x0a30, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/2/2/u0x2 = #5391 */
    { 0x0a22, 0x38f5, 0xb8b2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0xb17217f7d1cf79ab,24576) }, /* #101/2/2/u0x10 = #5392 */
    { 0x0a12, 0x38f5, 0xb8b2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/2/2/u0x20 = #5393 */
    { 0x0b7f, 0x38f5, 0x3832, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/2/3/m = #5394 */
    { 0x0b00, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/2/3/u = #5395 */
    { 0x0b32, 0x38f5, 0x3832, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/2/3/0x32 = #5396 */
    { 0x0b30, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/2/3/u0x2 = #5397 */
    { 0x0b22, 0x38f5, 0xb8b2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0xb17217f7d1cf79ab,24576) }, /* #101/2/3/u0x10 = #5398 */
    { 0x0b12, 0x38f5, 0xb8b2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/2/3/u0x20 = #5399 */
    { 0x0c7f, 0x38f5, 0x3832, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/3/0/m = #5400 */
    { 0x0c00, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/3/0/u = #5401 */
    { 0x0c32, 0x38f5, 0x3832, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/3/0/0x32 = #5402 */
    { 0x0c30, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/3/0/u0x2 = #5403 */
    { 0x0c22, 0x38f5, 0xb8b2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0xb17217f7d1cf79ab,24576) }, /* #101/3/0/u0x10 = #5404 */
    { 0x0c12, 0x38f5, 0xb8b2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/3/0/u0x20 = #5405 */
    { 0x0d7f, 0x38f5, 0x3832, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/3/1/m = #5406 */
    { 0x0d00, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/3/1/u = #5407 */
    { 0x0d32, 0x38f5, 0x3832, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/3/1/0x32 = #5408 */
    { 0x0d30, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/3/1/u0x2 = #5409 */
    { 0x0d22, 0x38f5, 0xb8b2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0xb17217f7d1cf79ab,24576) }, /* #101/3/1/u0x10 = #5410 */
    { 0x0d12, 0x38f5, 0xb8b2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/3/1/u0x20 = #5411 */
    { 0x0e7f, 0x38f5, 0x3832, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/3/2/m = #5412 */
    { 0x0e00, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/3/2/u = #5413 */
    { 0x0e32, 0x38f5, 0x3832, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/3/2/0x32 = #5414 */
    { 0x0e30, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/3/2/u0x2 = #5415 */
    { 0x0e22, 0x38f5, 0xb8b2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0xb17217f7d1cf79ab,24576) }, /* #101/3/2/u0x10 = #5416 */
    { 0x0e12, 0x38f5, 0xb8b2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/3/2/u0x20 = #5417 */
    { 0x0f7f, 0x38f5, 0x3832, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/3/3/m = #5418 */
    { 0x0f00, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/3/3/u = #5419 */
    { 0x0f32, 0x38f5, 0x3832, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/3/3/0x32 = #5420 */
    { 0x0f30, 0x38f5, 0xb882, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x8000000000000000,0) }, /* #101/3/3/u0x2 = #5421 */
    { 0x0f22, 0x38f5, 0xb8b2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0xb17217f7d1cf79ab,24576) }, /* #101/3/3/u0x10 = #5422 */
    { 0x0f12, 0x38f5, 0xb8b2, RTFLOAT80U_INIT_C(1,0x8000000000000000,0), RTFLOAT80U_INIT_C(1,0x58b90bfbe8e7bcd5,0) }, /* #101/3/3/u0x20 = #5423 */
    { 0x007f, 0xe84d, 0x7a22, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/0/0/m = #5424 */
    { 0x0000, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/0/0/u = #5425 */
    { 0x0022, 0xe84d, 0x7a22, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/0/0/0x22 = #5426 */
    { 0x0020, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/0/0/u0x2 = #5427 */
    { 0x0002, 0xe84d, 0xfaa2, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/0/0/u0x20 = #5428 */
    { 0x017f, 0xe84d, 0x7a22, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/0/1/m = #5429 */
    { 0x0100, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/0/1/u = #5430 */
    { 0x0122, 0xe84d, 0x7a22, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/0/1/0x22 = #5431 */
    { 0x0120, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/0/1/u0x2 = #5432 */
    { 0x0102, 0xe84d, 0xfaa2, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/0/1/u0x20 = #5433 */
    { 0x027f, 0xe84d, 0x7a22, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/0/2/m = #5434 */
    { 0x0200, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/0/2/u = #5435 */
    { 0x0222, 0xe84d, 0x7a22, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/0/2/0x22 = #5436 */
    { 0x0220, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/0/2/u0x2 = #5437 */
    { 0x0202, 0xe84d, 0xfaa2, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/0/2/u0x20 = #5438 */
    { 0x037f, 0xe84d, 0x7a22, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/0/3/m = #5439 */
    { 0x0300, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/0/3/u = #5440 */
    { 0x0322, 0xe84d, 0x7a22, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/0/3/0x22 = #5441 */
    { 0x0320, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/0/3/u0x2 = #5442 */
    { 0x0302, 0xe84d, 0xfaa2, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/0/3/u0x20 = #5443 */
    { 0x047f, 0xe84d, 0x7822, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/1/0/m = #5444 */
    { 0x0400, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/1/0/u = #5445 */
    { 0x0422, 0xe84d, 0x7822, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/1/0/0x22 = #5446 */
    { 0x0420, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/1/0/u0x2 = #5447 */
    { 0x0402, 0xe84d, 0xf8a2, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/1/0/u0x20 = #5448 */
    { 0x057f, 0xe84d, 0x7822, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/1/1/m = #5449 */
    { 0x0500, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/1/1/u = #5450 */
    { 0x0522, 0xe84d, 0x7822, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/1/1/0x22 = #5451 */
    { 0x0520, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/1/1/u0x2 = #5452 */
    { 0x0502, 0xe84d, 0xf8a2, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/1/1/u0x20 = #5453 */
    { 0x067f, 0xe84d, 0x7822, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/1/2/m = #5454 */
    { 0x0600, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/1/2/u = #5455 */
    { 0x0622, 0xe84d, 0x7822, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/1/2/0x22 = #5456 */
    { 0x0620, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/1/2/u0x2 = #5457 */
    { 0x0602, 0xe84d, 0xf8a2, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/1/2/u0x20 = #5458 */
    { 0x077f, 0xe84d, 0x7822, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/1/3/m = #5459 */
    { 0x0700, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/1/3/u = #5460 */
    { 0x0722, 0xe84d, 0x7822, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/1/3/0x22 = #5461 */
    { 0x0720, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/1/3/u0x2 = #5462 */
    { 0x0702, 0xe84d, 0xf8a2, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/1/3/u0x20 = #5463 */
    { 0x087f, 0xe84d, 0x7a22, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/2/0/m = #5464 */
    { 0x0800, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/2/0/u = #5465 */
    { 0x0822, 0xe84d, 0x7a22, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/2/0/0x22 = #5466 */
    { 0x0820, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/2/0/u0x2 = #5467 */
    { 0x0802, 0xe84d, 0xfaa2, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/2/0/u0x20 = #5468 */
    { 0x097f, 0xe84d, 0x7a22, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/2/1/m = #5469 */
    { 0x0900, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/2/1/u = #5470 */
    { 0x0922, 0xe84d, 0x7a22, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/2/1/0x22 = #5471 */
    { 0x0920, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/2/1/u0x2 = #5472 */
    { 0x0902, 0xe84d, 0xfaa2, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/2/1/u0x20 = #5473 */
    { 0x0a7f, 0xe84d, 0x7a22, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/2/2/m = #5474 */
    { 0x0a00, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/2/2/u = #5475 */
    { 0x0a22, 0xe84d, 0x7a22, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/2/2/0x22 = #5476 */
    { 0x0a20, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/2/2/u0x2 = #5477 */
    { 0x0a02, 0xe84d, 0xfaa2, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/2/2/u0x20 = #5478 */
    { 0x0b7f, 0xe84d, 0x7a22, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/2/3/m = #5479 */
    { 0x0b00, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/2/3/u = #5480 */
    { 0x0b22, 0xe84d, 0x7a22, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/2/3/0x22 = #5481 */
    { 0x0b20, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/2/3/u0x2 = #5482 */
    { 0x0b02, 0xe84d, 0xfaa2, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b41,1) }, /* #102/2/3/u0x20 = #5483 */
    { 0x0c7f, 0xe84d, 0x7822, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/3/0/m = #5484 */
    { 0x0c00, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/3/0/u = #5485 */
    { 0x0c22, 0xe84d, 0x7822, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/3/0/0x22 = #5486 */
    { 0x0c20, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/3/0/u0x2 = #5487 */
    { 0x0c02, 0xe84d, 0xf8a2, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/3/0/u0x20 = #5488 */
    { 0x0d7f, 0xe84d, 0x7822, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/3/1/m = #5489 */
    { 0x0d00, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/3/1/u = #5490 */
    { 0x0d22, 0xe84d, 0x7822, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/3/1/0x22 = #5491 */
    { 0x0d20, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/3/1/u0x2 = #5492 */
    { 0x0d02, 0xe84d, 0xf8a2, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/3/1/u0x20 = #5493 */
    { 0x0e7f, 0xe84d, 0x7822, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/3/2/m = #5494 */
    { 0x0e00, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/3/2/u = #5495 */
    { 0x0e22, 0xe84d, 0x7822, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/3/2/0x22 = #5496 */
    { 0x0e20, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/3/2/u0x2 = #5497 */
    { 0x0e02, 0xe84d, 0xf8a2, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/3/2/u0x20 = #5498 */
    { 0x0f7f, 0xe84d, 0x7822, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/3/3/m = #5499 */
    { 0x0f00, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/3/3/u = #5500 */
    { 0x0f22, 0xe84d, 0x7822, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/3/3/0x22 = #5501 */
    { 0x0f20, 0xe84d, 0xf882, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,0) }, /* #102/3/3/u0x2 = #5502 */
    { 0x0f02, 0xe84d, 0xf8a2, RTFLOAT80U_INIT_C(0,0xc000000000000000,0), RTFLOAT80U_INIT_C(0,0x851591f9dd5b9b40,1) }, /* #102/3/3/u0x20 = #5503 */
    { 0x007f, 0xe480, 0x7e22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/0/0/m = #5504 */
    { 0x0000, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/0/0/u = #5505 */
    { 0x0022, 0xe480, 0x7e22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/0/0/0x22 = #5506 */
    { 0x0020, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/0/0/u0x2 = #5507 */
    { 0x0002, 0xe480, 0xfea2, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/0/0/u0x20 = #5508 */
    { 0x017f, 0xe480, 0x7e22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/0/1/m = #5509 */
    { 0x0100, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/0/1/u = #5510 */
    { 0x0122, 0xe480, 0x7e22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/0/1/0x22 = #5511 */
    { 0x0120, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/0/1/u0x2 = #5512 */
    { 0x0102, 0xe480, 0xfea2, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/0/1/u0x20 = #5513 */
    { 0x027f, 0xe480, 0x7e22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/0/2/m = #5514 */
    { 0x0200, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/0/2/u = #5515 */
    { 0x0222, 0xe480, 0x7e22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/0/2/0x22 = #5516 */
    { 0x0220, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/0/2/u0x2 = #5517 */
    { 0x0202, 0xe480, 0xfea2, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/0/2/u0x20 = #5518 */
    { 0x037f, 0xe480, 0x7e22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/0/3/m = #5519 */
    { 0x0300, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/0/3/u = #5520 */
    { 0x0322, 0xe480, 0x7e22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/0/3/0x22 = #5521 */
    { 0x0320, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/0/3/u0x2 = #5522 */
    { 0x0302, 0xe480, 0xfea2, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/0/3/u0x20 = #5523 */
    { 0x047f, 0xe480, 0x7e22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/1/0/m = #5524 */
    { 0x0400, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/1/0/u = #5525 */
    { 0x0422, 0xe480, 0x7e22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/1/0/0x22 = #5526 */
    { 0x0420, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/1/0/u0x2 = #5527 */
    { 0x0402, 0xe480, 0xfea2, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/1/0/u0x20 = #5528 */
    { 0x057f, 0xe480, 0x7e22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/1/1/m = #5529 */
    { 0x0500, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/1/1/u = #5530 */
    { 0x0522, 0xe480, 0x7e22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/1/1/0x22 = #5531 */
    { 0x0520, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/1/1/u0x2 = #5532 */
    { 0x0502, 0xe480, 0xfea2, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/1/1/u0x20 = #5533 */
    { 0x067f, 0xe480, 0x7e22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/1/2/m = #5534 */
    { 0x0600, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/1/2/u = #5535 */
    { 0x0622, 0xe480, 0x7e22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/1/2/0x22 = #5536 */
    { 0x0620, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/1/2/u0x2 = #5537 */
    { 0x0602, 0xe480, 0xfea2, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/1/2/u0x20 = #5538 */
    { 0x077f, 0xe480, 0x7e22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/1/3/m = #5539 */
    { 0x0700, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/1/3/u = #5540 */
    { 0x0722, 0xe480, 0x7e22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/1/3/0x22 = #5541 */
    { 0x0720, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/1/3/u0x2 = #5542 */
    { 0x0702, 0xe480, 0xfea2, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b41,1) }, /* #103/1/3/u0x20 = #5543 */
    { 0x087f, 0xe480, 0x7c22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/2/0/m = #5544 */
    { 0x0800, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/2/0/u = #5545 */
    { 0x0822, 0xe480, 0x7c22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/2/0/0x22 = #5546 */
    { 0x0820, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/2/0/u0x2 = #5547 */
    { 0x0802, 0xe480, 0xfca2, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/2/0/u0x20 = #5548 */
    { 0x097f, 0xe480, 0x7c22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/2/1/m = #5549 */
    { 0x0900, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/2/1/u = #5550 */
    { 0x0922, 0xe480, 0x7c22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/2/1/0x22 = #5551 */
    { 0x0920, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/2/1/u0x2 = #5552 */
    { 0x0902, 0xe480, 0xfca2, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/2/1/u0x20 = #5553 */
    { 0x0a7f, 0xe480, 0x7c22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/2/2/m = #5554 */
    { 0x0a00, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/2/2/u = #5555 */
    { 0x0a22, 0xe480, 0x7c22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/2/2/0x22 = #5556 */
    { 0x0a20, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/2/2/u0x2 = #5557 */
    { 0x0a02, 0xe480, 0xfca2, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/2/2/u0x20 = #5558 */
    { 0x0b7f, 0xe480, 0x7c22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/2/3/m = #5559 */
    { 0x0b00, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/2/3/u = #5560 */
    { 0x0b22, 0xe480, 0x7c22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/2/3/0x22 = #5561 */
    { 0x0b20, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/2/3/u0x2 = #5562 */
    { 0x0b02, 0xe480, 0xfca2, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/2/3/u0x20 = #5563 */
    { 0x0c7f, 0xe480, 0x7c22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/3/0/m = #5564 */
    { 0x0c00, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/3/0/u = #5565 */
    { 0x0c22, 0xe480, 0x7c22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/3/0/0x22 = #5566 */
    { 0x0c20, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/3/0/u0x2 = #5567 */
    { 0x0c02, 0xe480, 0xfca2, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/3/0/u0x20 = #5568 */
    { 0x0d7f, 0xe480, 0x7c22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/3/1/m = #5569 */
    { 0x0d00, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/3/1/u = #5570 */
    { 0x0d22, 0xe480, 0x7c22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/3/1/0x22 = #5571 */
    { 0x0d20, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/3/1/u0x2 = #5572 */
    { 0x0d02, 0xe480, 0xfca2, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/3/1/u0x20 = #5573 */
    { 0x0e7f, 0xe480, 0x7c22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/3/2/m = #5574 */
    { 0x0e00, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/3/2/u = #5575 */
    { 0x0e22, 0xe480, 0x7c22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/3/2/0x22 = #5576 */
    { 0x0e20, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/3/2/u0x2 = #5577 */
    { 0x0e02, 0xe480, 0xfca2, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/3/2/u0x20 = #5578 */
    { 0x0f7f, 0xe480, 0x7c22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/3/3/m = #5579 */
    { 0x0f00, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/3/3/u = #5580 */
    { 0x0f22, 0xe480, 0x7c22, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/3/3/0x22 = #5581 */
    { 0x0f20, 0xe480, 0xfc82, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,0) }, /* #103/3/3/u0x2 = #5582 */
    { 0x0f02, 0xe480, 0xfca2, RTFLOAT80U_INIT_C(1,0xc000000000000000,0), RTFLOAT80U_INIT_C(1,0x851591f9dd5b9b40,1) }, /* #103/3/3/u0x20 = #5583 */
    { 0x007f, 0x6646, 0x7e22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/0/0/m = #5584 */
    { 0x0000, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/0/0/u = #5585 */
    { 0x0022, 0x6646, 0x7e22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/0/0/0x22 = #5586 */
    { 0x0020, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/0/0/u0x2 = #5587 */
    { 0x0002, 0x6646, 0xfea2, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/0/0/u0x20 = #5588 */
    { 0x017f, 0x6646, 0x7e22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/0/1/m = #5589 */
    { 0x0100, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/0/1/u = #5590 */
    { 0x0122, 0x6646, 0x7e22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/0/1/0x22 = #5591 */
    { 0x0120, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/0/1/u0x2 = #5592 */
    { 0x0102, 0x6646, 0xfea2, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/0/1/u0x20 = #5593 */
    { 0x027f, 0x6646, 0x7e22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/0/2/m = #5594 */
    { 0x0200, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/0/2/u = #5595 */
    { 0x0222, 0x6646, 0x7e22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/0/2/0x22 = #5596 */
    { 0x0220, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/0/2/u0x2 = #5597 */
    { 0x0202, 0x6646, 0xfea2, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/0/2/u0x20 = #5598 */
    { 0x037f, 0x6646, 0x7e22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/0/3/m = #5599 */
    { 0x0300, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/0/3/u = #5600 */
    { 0x0322, 0x6646, 0x7e22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/0/3/0x22 = #5601 */
    { 0x0320, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/0/3/u0x2 = #5602 */
    { 0x0302, 0x6646, 0xfea2, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/0/3/u0x20 = #5603 */
    { 0x047f, 0x6646, 0x7c22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/1/0/m = #5604 */
    { 0x0400, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/1/0/u = #5605 */
    { 0x0422, 0x6646, 0x7c22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/1/0/0x22 = #5606 */
    { 0x0420, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/1/0/u0x2 = #5607 */
    { 0x0402, 0x6646, 0xfca2, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/1/0/u0x20 = #5608 */
    { 0x057f, 0x6646, 0x7c22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/1/1/m = #5609 */
    { 0x0500, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/1/1/u = #5610 */
    { 0x0522, 0x6646, 0x7c22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/1/1/0x22 = #5611 */
    { 0x0520, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/1/1/u0x2 = #5612 */
    { 0x0502, 0x6646, 0xfca2, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/1/1/u0x20 = #5613 */
    { 0x067f, 0x6646, 0x7c22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/1/2/m = #5614 */
    { 0x0600, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/1/2/u = #5615 */
    { 0x0622, 0x6646, 0x7c22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/1/2/0x22 = #5616 */
    { 0x0620, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/1/2/u0x2 = #5617 */
    { 0x0602, 0x6646, 0xfca2, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/1/2/u0x20 = #5618 */
    { 0x077f, 0x6646, 0x7c22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/1/3/m = #5619 */
    { 0x0700, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/1/3/u = #5620 */
    { 0x0722, 0x6646, 0x7c22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/1/3/0x22 = #5621 */
    { 0x0720, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/1/3/u0x2 = #5622 */
    { 0x0702, 0x6646, 0xfca2, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/1/3/u0x20 = #5623 */
    { 0x087f, 0x6646, 0x7e22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/2/0/m = #5624 */
    { 0x0800, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/2/0/u = #5625 */
    { 0x0822, 0x6646, 0x7e22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/2/0/0x22 = #5626 */
    { 0x0820, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/2/0/u0x2 = #5627 */
    { 0x0802, 0x6646, 0xfea2, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/2/0/u0x20 = #5628 */
    { 0x097f, 0x6646, 0x7e22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/2/1/m = #5629 */
    { 0x0900, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/2/1/u = #5630 */
    { 0x0922, 0x6646, 0x7e22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/2/1/0x22 = #5631 */
    { 0x0920, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/2/1/u0x2 = #5632 */
    { 0x0902, 0x6646, 0xfea2, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/2/1/u0x20 = #5633 */
    { 0x0a7f, 0x6646, 0x7e22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/2/2/m = #5634 */
    { 0x0a00, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/2/2/u = #5635 */
    { 0x0a22, 0x6646, 0x7e22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/2/2/0x22 = #5636 */
    { 0x0a20, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/2/2/u0x2 = #5637 */
    { 0x0a02, 0x6646, 0xfea2, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/2/2/u0x20 = #5638 */
    { 0x0b7f, 0x6646, 0x7e22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/2/3/m = #5639 */
    { 0x0b00, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/2/3/u = #5640 */
    { 0x0b22, 0x6646, 0x7e22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/2/3/0x22 = #5641 */
    { 0x0b20, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/2/3/u0x2 = #5642 */
    { 0x0b02, 0x6646, 0xfea2, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185e,1) }, /* #104/2/3/u0x20 = #5643 */
    { 0x0c7f, 0x6646, 0x7c22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/3/0/m = #5644 */
    { 0x0c00, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/3/0/u = #5645 */
    { 0x0c22, 0x6646, 0x7c22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/3/0/0x22 = #5646 */
    { 0x0c20, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/3/0/u0x2 = #5647 */
    { 0x0c02, 0x6646, 0xfca2, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/3/0/u0x20 = #5648 */
    { 0x0d7f, 0x6646, 0x7c22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/3/1/m = #5649 */
    { 0x0d00, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/3/1/u = #5650 */
    { 0x0d22, 0x6646, 0x7c22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/3/1/0x22 = #5651 */
    { 0x0d20, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/3/1/u0x2 = #5652 */
    { 0x0d02, 0x6646, 0xfca2, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/3/1/u0x20 = #5653 */
    { 0x0e7f, 0x6646, 0x7c22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/3/2/m = #5654 */
    { 0x0e00, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/3/2/u = #5655 */
    { 0x0e22, 0x6646, 0x7c22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/3/2/0x22 = #5656 */
    { 0x0e20, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/3/2/u0x2 = #5657 */
    { 0x0e02, 0x6646, 0xfca2, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/3/2/u0x20 = #5658 */
    { 0x0f7f, 0x6646, 0x7c22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/3/3/m = #5659 */
    { 0x0f00, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/3/3/u = #5660 */
    { 0x0f22, 0x6646, 0x7c22, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/3/3/0x22 = #5661 */
    { 0x0f20, 0x6646, 0xfc82, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0xc000100000000000,0) }, /* #104/3/3/u0x2 = #5662 */
    { 0x0f02, 0x6646, 0xfca2, RTFLOAT80U_INIT_C(0,0xc000100000000000,0), RTFLOAT80U_INIT_C(0,0x85159d10fedb185d,1) }, /* #104/3/3/u0x20 = #5663 */
    { 0x007f, 0xf8f2, 0x7a22, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/0/0/m = #5664 */
    { 0x0000, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/0/0/u = #5665 */
    { 0x0022, 0xf8f2, 0x7a22, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/0/0/0x22 = #5666 */
    { 0x0020, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/0/0/u0x2 = #5667 */
    { 0x0002, 0xf8f2, 0xfaa2, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/0/0/u0x20 = #5668 */
    { 0x017f, 0xf8f2, 0x7a22, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/0/1/m = #5669 */
    { 0x0100, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/0/1/u = #5670 */
    { 0x0122, 0xf8f2, 0x7a22, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/0/1/0x22 = #5671 */
    { 0x0120, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/0/1/u0x2 = #5672 */
    { 0x0102, 0xf8f2, 0xfaa2, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/0/1/u0x20 = #5673 */
    { 0x027f, 0xf8f2, 0x7a22, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/0/2/m = #5674 */
    { 0x0200, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/0/2/u = #5675 */
    { 0x0222, 0xf8f2, 0x7a22, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/0/2/0x22 = #5676 */
    { 0x0220, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/0/2/u0x2 = #5677 */
    { 0x0202, 0xf8f2, 0xfaa2, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/0/2/u0x20 = #5678 */
    { 0x037f, 0xf8f2, 0x7a22, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/0/3/m = #5679 */
    { 0x0300, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/0/3/u = #5680 */
    { 0x0322, 0xf8f2, 0x7a22, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/0/3/0x22 = #5681 */
    { 0x0320, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/0/3/u0x2 = #5682 */
    { 0x0302, 0xf8f2, 0xfaa2, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/0/3/u0x20 = #5683 */
    { 0x047f, 0xf8f2, 0x7a22, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/1/0/m = #5684 */
    { 0x0400, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/1/0/u = #5685 */
    { 0x0422, 0xf8f2, 0x7a22, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/1/0/0x22 = #5686 */
    { 0x0420, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/1/0/u0x2 = #5687 */
    { 0x0402, 0xf8f2, 0xfaa2, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/1/0/u0x20 = #5688 */
    { 0x057f, 0xf8f2, 0x7a22, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/1/1/m = #5689 */
    { 0x0500, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/1/1/u = #5690 */
    { 0x0522, 0xf8f2, 0x7a22, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/1/1/0x22 = #5691 */
    { 0x0520, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/1/1/u0x2 = #5692 */
    { 0x0502, 0xf8f2, 0xfaa2, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/1/1/u0x20 = #5693 */
    { 0x067f, 0xf8f2, 0x7a22, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/1/2/m = #5694 */
    { 0x0600, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/1/2/u = #5695 */
    { 0x0622, 0xf8f2, 0x7a22, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/1/2/0x22 = #5696 */
    { 0x0620, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/1/2/u0x2 = #5697 */
    { 0x0602, 0xf8f2, 0xfaa2, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/1/2/u0x20 = #5698 */
    { 0x077f, 0xf8f2, 0x7a22, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/1/3/m = #5699 */
    { 0x0700, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/1/3/u = #5700 */
    { 0x0722, 0xf8f2, 0x7a22, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/1/3/0x22 = #5701 */
    { 0x0720, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/1/3/u0x2 = #5702 */
    { 0x0702, 0xf8f2, 0xfaa2, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185e,1) }, /* #105/1/3/u0x20 = #5703 */
    { 0x087f, 0xf8f2, 0x7822, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/2/0/m = #5704 */
    { 0x0800, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/2/0/u = #5705 */
    { 0x0822, 0xf8f2, 0x7822, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/2/0/0x22 = #5706 */
    { 0x0820, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/2/0/u0x2 = #5707 */
    { 0x0802, 0xf8f2, 0xf8a2, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/2/0/u0x20 = #5708 */
    { 0x097f, 0xf8f2, 0x7822, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/2/1/m = #5709 */
    { 0x0900, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/2/1/u = #5710 */
    { 0x0922, 0xf8f2, 0x7822, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/2/1/0x22 = #5711 */
    { 0x0920, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/2/1/u0x2 = #5712 */
    { 0x0902, 0xf8f2, 0xf8a2, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/2/1/u0x20 = #5713 */
    { 0x0a7f, 0xf8f2, 0x7822, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/2/2/m = #5714 */
    { 0x0a00, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/2/2/u = #5715 */
    { 0x0a22, 0xf8f2, 0x7822, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/2/2/0x22 = #5716 */
    { 0x0a20, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/2/2/u0x2 = #5717 */
    { 0x0a02, 0xf8f2, 0xf8a2, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/2/2/u0x20 = #5718 */
    { 0x0b7f, 0xf8f2, 0x7822, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/2/3/m = #5719 */
    { 0x0b00, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/2/3/u = #5720 */
    { 0x0b22, 0xf8f2, 0x7822, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/2/3/0x22 = #5721 */
    { 0x0b20, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/2/3/u0x2 = #5722 */
    { 0x0b02, 0xf8f2, 0xf8a2, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/2/3/u0x20 = #5723 */
    { 0x0c7f, 0xf8f2, 0x7822, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/3/0/m = #5724 */
    { 0x0c00, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/3/0/u = #5725 */
    { 0x0c22, 0xf8f2, 0x7822, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/3/0/0x22 = #5726 */
    { 0x0c20, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/3/0/u0x2 = #5727 */
    { 0x0c02, 0xf8f2, 0xf8a2, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/3/0/u0x20 = #5728 */
    { 0x0d7f, 0xf8f2, 0x7822, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/3/1/m = #5729 */
    { 0x0d00, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/3/1/u = #5730 */
    { 0x0d22, 0xf8f2, 0x7822, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/3/1/0x22 = #5731 */
    { 0x0d20, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/3/1/u0x2 = #5732 */
    { 0x0d02, 0xf8f2, 0xf8a2, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/3/1/u0x20 = #5733 */
    { 0x0e7f, 0xf8f2, 0x7822, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/3/2/m = #5734 */
    { 0x0e00, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/3/2/u = #5735 */
    { 0x0e22, 0xf8f2, 0x7822, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/3/2/0x22 = #5736 */
    { 0x0e20, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/3/2/u0x2 = #5737 */
    { 0x0e02, 0xf8f2, 0xf8a2, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/3/2/u0x20 = #5738 */
    { 0x0f7f, 0xf8f2, 0x7822, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/3/3/m = #5739 */
    { 0x0f00, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/3/3/u = #5740 */
    { 0x0f22, 0xf8f2, 0x7822, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/3/3/0x22 = #5741 */
    { 0x0f20, 0xf8f2, 0xf882, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0xc000100000000000,0) }, /* #105/3/3/u0x2 = #5742 */
    { 0x0f02, 0xf8f2, 0xf8a2, RTFLOAT80U_INIT_C(1,0xc000100000000000,0), RTFLOAT80U_INIT_C(1,0x85159d10fedb185d,1) }, /* #105/3/3/u0x20 = #5743 */
};
uint32_t const g_cTests_f2xm1_r80_intel = RT_ELEMENTS(g_aTests_f2xm1_r80_intel);

FPU_UNARY_R80_TEST_T const g_aTests_fsin_r80_intel[] =
{
    { 0x007f, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/0/0/m = #0 */
    { 0x0000, 0x139f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/0/0/u = #1 */
    { 0x0020, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/0/0/0x20 = #2 */
    { 0x017f, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/0/1/m = #3 */
    { 0x0100, 0x139f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/0/1/u = #4 */
    { 0x0120, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/0/1/0x20 = #5 */
    { 0x027f, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/0/2/m = #6 */
    { 0x0200, 0x139f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/0/2/u = #7 */
    { 0x0220, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/0/2/0x20 = #8 */
    { 0x037f, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/0/3/m = #9 */
    { 0x0300, 0x139f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/0/3/u = #10 */
    { 0x0320, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/0/3/0x20 = #11 */
    { 0x047f, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/1/0/m = #12 */
    { 0x0400, 0x139f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/1/0/u = #13 */
    { 0x0420, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/1/0/0x20 = #14 */
    { 0x057f, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/1/1/m = #15 */
    { 0x0500, 0x139f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/1/1/u = #16 */
    { 0x0520, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/1/1/0x20 = #17 */
    { 0x067f, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/1/2/m = #18 */
    { 0x0600, 0x139f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/1/2/u = #19 */
    { 0x0620, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/1/2/0x20 = #20 */
    { 0x077f, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/1/3/m = #21 */
    { 0x0700, 0x139f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/1/3/u = #22 */
    { 0x0720, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/1/3/0x20 = #23 */
    { 0x087f, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/2/0/m = #24 */
    { 0x0800, 0x139f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/2/0/u = #25 */
    { 0x0820, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/2/0/0x20 = #26 */
    { 0x097f, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/2/1/m = #27 */
    { 0x0900, 0x139f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/2/1/u = #28 */
    { 0x0920, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/2/1/0x20 = #29 */
    { 0x0a7f, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/2/2/m = #30 */
    { 0x0a00, 0x139f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/2/2/u = #31 */
    { 0x0a20, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/2/2/0x20 = #32 */
    { 0x0b7f, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/2/3/m = #33 */
    { 0x0b00, 0x139f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/2/3/u = #34 */
    { 0x0b20, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/2/3/0x20 = #35 */
    { 0x0c7f, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/3/0/m = #36 */
    { 0x0c00, 0x139f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/3/0/u = #37 */
    { 0x0c20, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/3/0/0x20 = #38 */
    { 0x0d7f, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/3/1/m = #39 */
    { 0x0d00, 0x139f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/3/1/u = #40 */
    { 0x0d20, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/3/1/0x20 = #41 */
    { 0x0e7f, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/3/2/m = #42 */
    { 0x0e00, 0x139f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/3/2/u = #43 */
    { 0x0e20, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/3/2/0x20 = #44 */
    { 0x0f7f, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/3/3/m = #45 */
    { 0x0f00, 0x139f, 0xb9a0, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/3/3/u = #46 */
    { 0x0f20, 0x139f, 0x3920, RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297), RTFLOAT80U_INIT_C(0,0xdb876bbe095c8c45,5297) }, /* #0/3/3/0x20 = #47 */
    { 0x007f, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/0/0/m = #48 */
    { 0x0000, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/0/0/u = #49 */
    { 0x017f, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/0/1/m = #50 */
    { 0x0100, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/0/1/u = #51 */
    { 0x027f, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/0/2/m = #52 */
    { 0x0200, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/0/2/u = #53 */
    { 0x037f, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/0/3/m = #54 */
    { 0x0300, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/0/3/u = #55 */
    { 0x047f, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/1/0/m = #56 */
    { 0x0400, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/1/0/u = #57 */
    { 0x057f, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/1/1/m = #58 */
    { 0x0500, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/1/1/u = #59 */
    { 0x067f, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/1/2/m = #60 */
    { 0x0600, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/1/2/u = #61 */
    { 0x077f, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/1/3/m = #62 */
    { 0x0700, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/1/3/u = #63 */
    { 0x087f, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/2/0/m = #64 */
    { 0x0800, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/2/0/u = #65 */
    { 0x097f, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/2/1/m = #66 */
    { 0x0900, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/2/1/u = #67 */
    { 0x0a7f, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/2/2/m = #68 */
    { 0x0a00, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/2/2/u = #69 */
    { 0x0b7f, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/2/3/m = #70 */
    { 0x0b00, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/2/3/u = #71 */
    { 0x0c7f, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/3/0/m = #72 */
    { 0x0c00, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/3/0/u = #73 */
    { 0x0d7f, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/3/1/m = #74 */
    { 0x0d00, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/3/1/u = #75 */
    { 0x0e7f, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/3/2/m = #76 */
    { 0x0e00, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/3/2/u = #77 */
    { 0x0f7f, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/3/3/m = #78 */
    { 0x0f00, 0x74dd, 0x7c00, RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130), RTFLOAT80U_INIT_C(1,0xdbb837339be04c15,29130) }, /* #1/3/3/u = #79 */
    { 0x007f, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/0/0/m = #80 */
    { 0x0000, 0x0e0d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/0/0/u = #81 */
    { 0x0020, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/0/0/0x20 = #82 */
    { 0x017f, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/0/1/m = #83 */
    { 0x0100, 0x0e0d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/0/1/u = #84 */
    { 0x0120, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/0/1/0x20 = #85 */
    { 0x027f, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/0/2/m = #86 */
    { 0x0200, 0x0e0d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/0/2/u = #87 */
    { 0x0220, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/0/2/0x20 = #88 */
    { 0x037f, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/0/3/m = #89 */
    { 0x0300, 0x0e0d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/0/3/u = #90 */
    { 0x0320, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/0/3/0x20 = #91 */
    { 0x047f, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/1/0/m = #92 */
    { 0x0400, 0x0e0d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/1/0/u = #93 */
    { 0x0420, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/1/0/0x20 = #94 */
    { 0x057f, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/1/1/m = #95 */
    { 0x0500, 0x0e0d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/1/1/u = #96 */
    { 0x0520, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/1/1/0x20 = #97 */
    { 0x067f, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/1/2/m = #98 */
    { 0x0600, 0x0e0d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/1/2/u = #99 */
    { 0x0620, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/1/2/0x20 = #100 */
    { 0x077f, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/1/3/m = #101 */
    { 0x0700, 0x0e0d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/1/3/u = #102 */
    { 0x0720, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/1/3/0x20 = #103 */
    { 0x087f, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/2/0/m = #104 */
    { 0x0800, 0x0e0d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/2/0/u = #105 */
    { 0x0820, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/2/0/0x20 = #106 */
    { 0x097f, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/2/1/m = #107 */
    { 0x0900, 0x0e0d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/2/1/u = #108 */
    { 0x0920, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/2/1/0x20 = #109 */
    { 0x0a7f, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/2/2/m = #110 */
    { 0x0a00, 0x0e0d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/2/2/u = #111 */
    { 0x0a20, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/2/2/0x20 = #112 */
    { 0x0b7f, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/2/3/m = #113 */
    { 0x0b00, 0x0e0d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/2/3/u = #114 */
    { 0x0b20, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/2/3/0x20 = #115 */
    { 0x0c7f, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/3/0/m = #116 */
    { 0x0c00, 0x0e0d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/3/0/u = #117 */
    { 0x0c20, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/3/0/0x20 = #118 */
    { 0x0d7f, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/3/1/m = #119 */
    { 0x0d00, 0x0e0d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/3/1/u = #120 */
    { 0x0d20, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/3/1/0x20 = #121 */
    { 0x0e7f, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/3/2/m = #122 */
    { 0x0e00, 0x0e0d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/3/2/u = #123 */
    { 0x0e20, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/3/2/0x20 = #124 */
    { 0x0f7f, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/3/3/m = #125 */
    { 0x0f00, 0x0e0d, 0xb8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/3/3/u = #126 */
    { 0x0f20, 0x0e0d, 0x3820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #2/3/3/0x20 = #127 */
    { 0x007f, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/0/0/m = #128 */
    { 0x0000, 0xa973, 0xb981, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_C(0,0x1fb,23343) }, /* #3/0/0/u = #129 */
    { 0x0001, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/0/0/0x1 = #130 */
    { 0x017f, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/0/1/m = #131 */
    { 0x0100, 0xa973, 0xb981, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_C(0,0x1fb,23343) }, /* #3/0/1/u = #132 */
    { 0x0101, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/0/1/0x1 = #133 */
    { 0x027f, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/0/2/m = #134 */
    { 0x0200, 0xa973, 0xb981, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_C(0,0x1fb,23343) }, /* #3/0/2/u = #135 */
    { 0x0201, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/0/2/0x1 = #136 */
    { 0x037f, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/0/3/m = #137 */
    { 0x0300, 0xa973, 0xb981, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_C(0,0x1fb,23343) }, /* #3/0/3/u = #138 */
    { 0x0301, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/0/3/0x1 = #139 */
    { 0x047f, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/1/0/m = #140 */
    { 0x0400, 0xa973, 0xb981, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_C(0,0x1fb,23343) }, /* #3/1/0/u = #141 */
    { 0x0401, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/1/0/0x1 = #142 */
    { 0x057f, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/1/1/m = #143 */
    { 0x0500, 0xa973, 0xb981, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_C(0,0x1fb,23343) }, /* #3/1/1/u = #144 */
    { 0x0501, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/1/1/0x1 = #145 */
    { 0x067f, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/1/2/m = #146 */
    { 0x0600, 0xa973, 0xb981, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_C(0,0x1fb,23343) }, /* #3/1/2/u = #147 */
    { 0x0601, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/1/2/0x1 = #148 */
    { 0x077f, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/1/3/m = #149 */
    { 0x0700, 0xa973, 0xb981, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_C(0,0x1fb,23343) }, /* #3/1/3/u = #150 */
    { 0x0701, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/1/3/0x1 = #151 */
    { 0x087f, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/2/0/m = #152 */
    { 0x0800, 0xa973, 0xb981, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_C(0,0x1fb,23343) }, /* #3/2/0/u = #153 */
    { 0x0801, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/2/0/0x1 = #154 */
    { 0x097f, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/2/1/m = #155 */
    { 0x0900, 0xa973, 0xb981, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_C(0,0x1fb,23343) }, /* #3/2/1/u = #156 */
    { 0x0901, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/2/1/0x1 = #157 */
    { 0x0a7f, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/2/2/m = #158 */
    { 0x0a00, 0xa973, 0xb981, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_C(0,0x1fb,23343) }, /* #3/2/2/u = #159 */
    { 0x0a01, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/2/2/0x1 = #160 */
    { 0x0b7f, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/2/3/m = #161 */
    { 0x0b00, 0xa973, 0xb981, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_C(0,0x1fb,23343) }, /* #3/2/3/u = #162 */
    { 0x0b01, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/2/3/0x1 = #163 */
    { 0x0c7f, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/3/0/m = #164 */
    { 0x0c00, 0xa973, 0xb981, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_C(0,0x1fb,23343) }, /* #3/3/0/u = #165 */
    { 0x0c01, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/3/0/0x1 = #166 */
    { 0x0d7f, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/3/1/m = #167 */
    { 0x0d00, 0xa973, 0xb981, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_C(0,0x1fb,23343) }, /* #3/3/1/u = #168 */
    { 0x0d01, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/3/1/0x1 = #169 */
    { 0x0e7f, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/3/2/m = #170 */
    { 0x0e00, 0xa973, 0xb981, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_C(0,0x1fb,23343) }, /* #3/3/2/u = #171 */
    { 0x0e01, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/3/2/0x1 = #172 */
    { 0x0f7f, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/3/3/m = #173 */
    { 0x0f00, 0xa973, 0xb981, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_C(0,0x1fb,23343) }, /* #3/3/3/u = #174 */
    { 0x0f01, 0xa973, 0x3901, RTFLOAT80U_INIT_C(0,0x1fb,23343), RTFLOAT80U_INIT_IND(1) }, /* #3/3/3/0x1 = #175 */
    { 0x007f, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/0/0/m = #176 */
    { 0x0000, 0x062d, 0xb881, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114) }, /* #4/0/0/u = #177 */
    { 0x0001, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/0/0/0x1 = #178 */
    { 0x017f, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/0/1/m = #179 */
    { 0x0100, 0x062d, 0xb881, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114) }, /* #4/0/1/u = #180 */
    { 0x0101, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/0/1/0x1 = #181 */
    { 0x027f, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/0/2/m = #182 */
    { 0x0200, 0x062d, 0xb881, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114) }, /* #4/0/2/u = #183 */
    { 0x0201, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/0/2/0x1 = #184 */
    { 0x037f, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/0/3/m = #185 */
    { 0x0300, 0x062d, 0xb881, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114) }, /* #4/0/3/u = #186 */
    { 0x0301, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/0/3/0x1 = #187 */
    { 0x047f, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/1/0/m = #188 */
    { 0x0400, 0x062d, 0xb881, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114) }, /* #4/1/0/u = #189 */
    { 0x0401, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/1/0/0x1 = #190 */
    { 0x057f, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/1/1/m = #191 */
    { 0x0500, 0x062d, 0xb881, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114) }, /* #4/1/1/u = #192 */
    { 0x0501, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/1/1/0x1 = #193 */
    { 0x067f, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/1/2/m = #194 */
    { 0x0600, 0x062d, 0xb881, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114) }, /* #4/1/2/u = #195 */
    { 0x0601, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/1/2/0x1 = #196 */
    { 0x077f, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/1/3/m = #197 */
    { 0x0700, 0x062d, 0xb881, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114) }, /* #4/1/3/u = #198 */
    { 0x0701, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/1/3/0x1 = #199 */
    { 0x087f, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/2/0/m = #200 */
    { 0x0800, 0x062d, 0xb881, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114) }, /* #4/2/0/u = #201 */
    { 0x0801, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/2/0/0x1 = #202 */
    { 0x097f, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/2/1/m = #203 */
    { 0x0900, 0x062d, 0xb881, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114) }, /* #4/2/1/u = #204 */
    { 0x0901, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/2/1/0x1 = #205 */
    { 0x0a7f, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/2/2/m = #206 */
    { 0x0a00, 0x062d, 0xb881, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114) }, /* #4/2/2/u = #207 */
    { 0x0a01, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/2/2/0x1 = #208 */
    { 0x0b7f, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/2/3/m = #209 */
    { 0x0b00, 0x062d, 0xb881, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114) }, /* #4/2/3/u = #210 */
    { 0x0b01, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/2/3/0x1 = #211 */
    { 0x0c7f, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/3/0/m = #212 */
    { 0x0c00, 0x062d, 0xb881, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114) }, /* #4/3/0/u = #213 */
    { 0x0c01, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/3/0/0x1 = #214 */
    { 0x0d7f, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/3/1/m = #215 */
    { 0x0d00, 0x062d, 0xb881, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114) }, /* #4/3/1/u = #216 */
    { 0x0d01, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/3/1/0x1 = #217 */
    { 0x0e7f, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/3/2/m = #218 */
    { 0x0e00, 0x062d, 0xb881, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114) }, /* #4/3/2/u = #219 */
    { 0x0e01, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/3/2/0x1 = #220 */
    { 0x0f7f, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/3/3/m = #221 */
    { 0x0f00, 0x062d, 0xb881, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114) }, /* #4/3/3/u = #222 */
    { 0x0f01, 0x062d, 0x3801, RTFLOAT80U_INIT_C(0,0x7d61bd60e60733e,17114), RTFLOAT80U_INIT_IND(1) }, /* #4/3/3/0x1 = #223 */
    { 0x007f, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/0/0/m = #224 */
    { 0x0000, 0x4398, 0xf981, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767) }, /* #5/0/0/u = #225 */
    { 0x0001, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/0/0/0x1 = #226 */
    { 0x017f, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/0/1/m = #227 */
    { 0x0100, 0x4398, 0xf981, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767) }, /* #5/0/1/u = #228 */
    { 0x0101, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/0/1/0x1 = #229 */
    { 0x027f, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/0/2/m = #230 */
    { 0x0200, 0x4398, 0xf981, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767) }, /* #5/0/2/u = #231 */
    { 0x0201, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/0/2/0x1 = #232 */
    { 0x037f, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/0/3/m = #233 */
    { 0x0300, 0x4398, 0xf981, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767) }, /* #5/0/3/u = #234 */
    { 0x0301, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/0/3/0x1 = #235 */
    { 0x047f, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/1/0/m = #236 */
    { 0x0400, 0x4398, 0xf981, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767) }, /* #5/1/0/u = #237 */
    { 0x0401, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/1/0/0x1 = #238 */
    { 0x057f, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/1/1/m = #239 */
    { 0x0500, 0x4398, 0xf981, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767) }, /* #5/1/1/u = #240 */
    { 0x0501, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/1/1/0x1 = #241 */
    { 0x067f, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/1/2/m = #242 */
    { 0x0600, 0x4398, 0xf981, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767) }, /* #5/1/2/u = #243 */
    { 0x0601, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/1/2/0x1 = #244 */
    { 0x077f, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/1/3/m = #245 */
    { 0x0700, 0x4398, 0xf981, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767) }, /* #5/1/3/u = #246 */
    { 0x0701, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/1/3/0x1 = #247 */
    { 0x087f, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/2/0/m = #248 */
    { 0x0800, 0x4398, 0xf981, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767) }, /* #5/2/0/u = #249 */
    { 0x0801, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/2/0/0x1 = #250 */
    { 0x097f, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/2/1/m = #251 */
    { 0x0900, 0x4398, 0xf981, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767) }, /* #5/2/1/u = #252 */
    { 0x0901, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/2/1/0x1 = #253 */
    { 0x0a7f, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/2/2/m = #254 */
    { 0x0a00, 0x4398, 0xf981, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767) }, /* #5/2/2/u = #255 */
    { 0x0a01, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/2/2/0x1 = #256 */
    { 0x0b7f, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/2/3/m = #257 */
    { 0x0b00, 0x4398, 0xf981, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767) }, /* #5/2/3/u = #258 */
    { 0x0b01, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/2/3/0x1 = #259 */
    { 0x0c7f, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/3/0/m = #260 */
    { 0x0c00, 0x4398, 0xf981, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767) }, /* #5/3/0/u = #261 */
    { 0x0c01, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/3/0/0x1 = #262 */
    { 0x0d7f, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/3/1/m = #263 */
    { 0x0d00, 0x4398, 0xf981, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767) }, /* #5/3/1/u = #264 */
    { 0x0d01, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/3/1/0x1 = #265 */
    { 0x0e7f, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/3/2/m = #266 */
    { 0x0e00, 0x4398, 0xf981, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767) }, /* #5/3/2/u = #267 */
    { 0x0e01, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/3/2/0x1 = #268 */
    { 0x0f7f, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/3/3/m = #269 */
    { 0x0f00, 0x4398, 0xf981, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767) }, /* #5/3/3/u = #270 */
    { 0x0f01, 0x4398, 0x7901, RTFLOAT80U_INIT_C(1,0x80000000016aaa12,32767), RTFLOAT80U_INIT_C(1,0xc0000000016aaa12,32767) }, /* #5/3/3/0x1 = #271 */
    { 0x007f, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/0/0/m = #272 */
    { 0x0000, 0x8be9, 0xb981, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767) }, /* #6/0/0/u = #273 */
    { 0x0001, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/0/0/0x1 = #274 */
    { 0x017f, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/0/1/m = #275 */
    { 0x0100, 0x8be9, 0xb981, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767) }, /* #6/0/1/u = #276 */
    { 0x0101, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/0/1/0x1 = #277 */
    { 0x027f, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/0/2/m = #278 */
    { 0x0200, 0x8be9, 0xb981, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767) }, /* #6/0/2/u = #279 */
    { 0x0201, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/0/2/0x1 = #280 */
    { 0x037f, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/0/3/m = #281 */
    { 0x0300, 0x8be9, 0xb981, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767) }, /* #6/0/3/u = #282 */
    { 0x0301, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/0/3/0x1 = #283 */
    { 0x047f, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/1/0/m = #284 */
    { 0x0400, 0x8be9, 0xb981, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767) }, /* #6/1/0/u = #285 */
    { 0x0401, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/1/0/0x1 = #286 */
    { 0x057f, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/1/1/m = #287 */
    { 0x0500, 0x8be9, 0xb981, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767) }, /* #6/1/1/u = #288 */
    { 0x0501, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/1/1/0x1 = #289 */
    { 0x067f, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/1/2/m = #290 */
    { 0x0600, 0x8be9, 0xb981, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767) }, /* #6/1/2/u = #291 */
    { 0x0601, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/1/2/0x1 = #292 */
    { 0x077f, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/1/3/m = #293 */
    { 0x0700, 0x8be9, 0xb981, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767) }, /* #6/1/3/u = #294 */
    { 0x0701, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/1/3/0x1 = #295 */
    { 0x087f, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/2/0/m = #296 */
    { 0x0800, 0x8be9, 0xb981, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767) }, /* #6/2/0/u = #297 */
    { 0x0801, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/2/0/0x1 = #298 */
    { 0x097f, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/2/1/m = #299 */
    { 0x0900, 0x8be9, 0xb981, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767) }, /* #6/2/1/u = #300 */
    { 0x0901, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/2/1/0x1 = #301 */
    { 0x0a7f, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/2/2/m = #302 */
    { 0x0a00, 0x8be9, 0xb981, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767) }, /* #6/2/2/u = #303 */
    { 0x0a01, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/2/2/0x1 = #304 */
    { 0x0b7f, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/2/3/m = #305 */
    { 0x0b00, 0x8be9, 0xb981, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767) }, /* #6/2/3/u = #306 */
    { 0x0b01, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/2/3/0x1 = #307 */
    { 0x0c7f, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/3/0/m = #308 */
    { 0x0c00, 0x8be9, 0xb981, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767) }, /* #6/3/0/u = #309 */
    { 0x0c01, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/3/0/0x1 = #310 */
    { 0x0d7f, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/3/1/m = #311 */
    { 0x0d00, 0x8be9, 0xb981, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767) }, /* #6/3/1/u = #312 */
    { 0x0d01, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/3/1/0x1 = #313 */
    { 0x0e7f, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/3/2/m = #314 */
    { 0x0e00, 0x8be9, 0xb981, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767) }, /* #6/3/2/u = #315 */
    { 0x0e01, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/3/2/0x1 = #316 */
    { 0x0f7f, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/3/3/m = #317 */
    { 0x0f00, 0x8be9, 0xb981, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767) }, /* #6/3/3/u = #318 */
    { 0x0f01, 0x8be9, 0x3901, RTFLOAT80U_INIT_C(1,0xad105f5b7a3079fe,32767), RTFLOAT80U_INIT_C(1,0xed105f5b7a3079fe,32767) }, /* #6/3/3/0x1 = #319 */
    { 0x007f, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/0/0/m = #320 */
    { 0x0000, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/0/0/u = #321 */
    { 0x017f, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/0/1/m = #322 */
    { 0x0100, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/0/1/u = #323 */
    { 0x027f, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/0/2/m = #324 */
    { 0x0200, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/0/2/u = #325 */
    { 0x037f, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/0/3/m = #326 */
    { 0x0300, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/0/3/u = #327 */
    { 0x047f, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/1/0/m = #328 */
    { 0x0400, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/1/0/u = #329 */
    { 0x057f, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/1/1/m = #330 */
    { 0x0500, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/1/1/u = #331 */
    { 0x067f, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/1/2/m = #332 */
    { 0x0600, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/1/2/u = #333 */
    { 0x077f, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/1/3/m = #334 */
    { 0x0700, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/1/3/u = #335 */
    { 0x087f, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/2/0/m = #336 */
    { 0x0800, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/2/0/u = #337 */
    { 0x097f, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/2/1/m = #338 */
    { 0x0900, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/2/1/u = #339 */
    { 0x0a7f, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/2/2/m = #340 */
    { 0x0a00, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/2/2/u = #341 */
    { 0x0b7f, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/2/3/m = #342 */
    { 0x0b00, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/2/3/u = #343 */
    { 0x0c7f, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/3/0/m = #344 */
    { 0x0c00, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/3/0/u = #345 */
    { 0x0d7f, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/3/1/m = #346 */
    { 0x0d00, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/3/1/u = #347 */
    { 0x0e7f, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/3/2/m = #348 */
    { 0x0e00, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/3/2/u = #349 */
    { 0x0f7f, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/3/3/m = #350 */
    { 0x0f00, 0x7056, 0x7800, RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767), RTFLOAT80U_INIT_C(1,0xc00000008fbd958d,32767) }, /* #7/3/3/u = #351 */
    { 0x007f, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/0/0/m = #352 */
    { 0x0000, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/0/0/u = #353 */
    { 0x017f, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/0/1/m = #354 */
    { 0x0100, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/0/1/u = #355 */
    { 0x027f, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/0/2/m = #356 */
    { 0x0200, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/0/2/u = #357 */
    { 0x037f, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/0/3/m = #358 */
    { 0x0300, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/0/3/u = #359 */
    { 0x047f, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/1/0/m = #360 */
    { 0x0400, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/1/0/u = #361 */
    { 0x057f, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/1/1/m = #362 */
    { 0x0500, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/1/1/u = #363 */
    { 0x067f, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/1/2/m = #364 */
    { 0x0600, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/1/2/u = #365 */
    { 0x077f, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/1/3/m = #366 */
    { 0x0700, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/1/3/u = #367 */
    { 0x087f, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/2/0/m = #368 */
    { 0x0800, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/2/0/u = #369 */
    { 0x097f, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/2/1/m = #370 */
    { 0x0900, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/2/1/u = #371 */
    { 0x0a7f, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/2/2/m = #372 */
    { 0x0a00, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/2/2/u = #373 */
    { 0x0b7f, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/2/3/m = #374 */
    { 0x0b00, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/2/3/u = #375 */
    { 0x0c7f, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/3/0/m = #376 */
    { 0x0c00, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/3/0/u = #377 */
    { 0x0d7f, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/3/1/m = #378 */
    { 0x0d00, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/3/1/u = #379 */
    { 0x0e7f, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/3/2/m = #380 */
    { 0x0e00, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/3/2/u = #381 */
    { 0x0f7f, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/3/3/m = #382 */
    { 0x0f00, 0xb21c, 0x3800, RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767), RTFLOAT80U_INIT_C(1,0xc8753e01f2936f9a,32767) }, /* #8/3/3/u = #383 */
    { 0x007f, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/0/0/m = #384 */
    { 0x0000, 0x5c65, 0xf881, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767) }, /* #9/0/0/u = #385 */
    { 0x0001, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/0/0/0x1 = #386 */
    { 0x017f, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/0/1/m = #387 */
    { 0x0100, 0x5c65, 0xf881, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767) }, /* #9/0/1/u = #388 */
    { 0x0101, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/0/1/0x1 = #389 */
    { 0x027f, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/0/2/m = #390 */
    { 0x0200, 0x5c65, 0xf881, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767) }, /* #9/0/2/u = #391 */
    { 0x0201, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/0/2/0x1 = #392 */
    { 0x037f, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/0/3/m = #393 */
    { 0x0300, 0x5c65, 0xf881, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767) }, /* #9/0/3/u = #394 */
    { 0x0301, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/0/3/0x1 = #395 */
    { 0x047f, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/1/0/m = #396 */
    { 0x0400, 0x5c65, 0xf881, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767) }, /* #9/1/0/u = #397 */
    { 0x0401, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/1/0/0x1 = #398 */
    { 0x057f, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/1/1/m = #399 */
    { 0x0500, 0x5c65, 0xf881, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767) }, /* #9/1/1/u = #400 */
    { 0x0501, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/1/1/0x1 = #401 */
    { 0x067f, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/1/2/m = #402 */
    { 0x0600, 0x5c65, 0xf881, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767) }, /* #9/1/2/u = #403 */
    { 0x0601, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/1/2/0x1 = #404 */
    { 0x077f, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/1/3/m = #405 */
    { 0x0700, 0x5c65, 0xf881, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767) }, /* #9/1/3/u = #406 */
    { 0x0701, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/1/3/0x1 = #407 */
    { 0x087f, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/2/0/m = #408 */
    { 0x0800, 0x5c65, 0xf881, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767) }, /* #9/2/0/u = #409 */
    { 0x0801, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/2/0/0x1 = #410 */
    { 0x097f, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/2/1/m = #411 */
    { 0x0900, 0x5c65, 0xf881, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767) }, /* #9/2/1/u = #412 */
    { 0x0901, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/2/1/0x1 = #413 */
    { 0x0a7f, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/2/2/m = #414 */
    { 0x0a00, 0x5c65, 0xf881, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767) }, /* #9/2/2/u = #415 */
    { 0x0a01, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/2/2/0x1 = #416 */
    { 0x0b7f, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/2/3/m = #417 */
    { 0x0b00, 0x5c65, 0xf881, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767) }, /* #9/2/3/u = #418 */
    { 0x0b01, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/2/3/0x1 = #419 */
    { 0x0c7f, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/3/0/m = #420 */
    { 0x0c00, 0x5c65, 0xf881, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767) }, /* #9/3/0/u = #421 */
    { 0x0c01, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/3/0/0x1 = #422 */
    { 0x0d7f, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/3/1/m = #423 */
    { 0x0d00, 0x5c65, 0xf881, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767) }, /* #9/3/1/u = #424 */
    { 0x0d01, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/3/1/0x1 = #425 */
    { 0x0e7f, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/3/2/m = #426 */
    { 0x0e00, 0x5c65, 0xf881, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767) }, /* #9/3/2/u = #427 */
    { 0x0e01, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/3/2/0x1 = #428 */
    { 0x0f7f, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/3/3/m = #429 */
    { 0x0f00, 0x5c65, 0xf881, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767) }, /* #9/3/3/u = #430 */
    { 0x0f01, 0x5c65, 0x7801, RTFLOAT80U_INIT_C(1,0x40001f3df2cee923,32767), RTFLOAT80U_INIT_IND(1) }, /* #9/3/3/0x1 = #431 */
    { 0x007f, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/0/m = #432 */
    { 0x0000, 0x5f5a, 0xf981, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767) }, /* #10/0/0/u = #433 */
    { 0x0001, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/0/0x1 = #434 */
    { 0x017f, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/1/m = #435 */
    { 0x0100, 0x5f5a, 0xf981, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767) }, /* #10/0/1/u = #436 */
    { 0x0101, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/1/0x1 = #437 */
    { 0x027f, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/2/m = #438 */
    { 0x0200, 0x5f5a, 0xf981, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767) }, /* #10/0/2/u = #439 */
    { 0x0201, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/2/0x1 = #440 */
    { 0x037f, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/3/m = #441 */
    { 0x0300, 0x5f5a, 0xf981, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767) }, /* #10/0/3/u = #442 */
    { 0x0301, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/0/3/0x1 = #443 */
    { 0x047f, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/0/m = #444 */
    { 0x0400, 0x5f5a, 0xf981, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767) }, /* #10/1/0/u = #445 */
    { 0x0401, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/0/0x1 = #446 */
    { 0x057f, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/1/m = #447 */
    { 0x0500, 0x5f5a, 0xf981, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767) }, /* #10/1/1/u = #448 */
    { 0x0501, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/1/0x1 = #449 */
    { 0x067f, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/2/m = #450 */
    { 0x0600, 0x5f5a, 0xf981, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767) }, /* #10/1/2/u = #451 */
    { 0x0601, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/2/0x1 = #452 */
    { 0x077f, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/3/m = #453 */
    { 0x0700, 0x5f5a, 0xf981, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767) }, /* #10/1/3/u = #454 */
    { 0x0701, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/1/3/0x1 = #455 */
    { 0x087f, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/0/m = #456 */
    { 0x0800, 0x5f5a, 0xf981, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767) }, /* #10/2/0/u = #457 */
    { 0x0801, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/0/0x1 = #458 */
    { 0x097f, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/1/m = #459 */
    { 0x0900, 0x5f5a, 0xf981, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767) }, /* #10/2/1/u = #460 */
    { 0x0901, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/1/0x1 = #461 */
    { 0x0a7f, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/2/m = #462 */
    { 0x0a00, 0x5f5a, 0xf981, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767) }, /* #10/2/2/u = #463 */
    { 0x0a01, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/2/0x1 = #464 */
    { 0x0b7f, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/3/m = #465 */
    { 0x0b00, 0x5f5a, 0xf981, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767) }, /* #10/2/3/u = #466 */
    { 0x0b01, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/2/3/0x1 = #467 */
    { 0x0c7f, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/0/m = #468 */
    { 0x0c00, 0x5f5a, 0xf981, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767) }, /* #10/3/0/u = #469 */
    { 0x0c01, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/0/0x1 = #470 */
    { 0x0d7f, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/1/m = #471 */
    { 0x0d00, 0x5f5a, 0xf981, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767) }, /* #10/3/1/u = #472 */
    { 0x0d01, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/1/0x1 = #473 */
    { 0x0e7f, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/2/m = #474 */
    { 0x0e00, 0x5f5a, 0xf981, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767) }, /* #10/3/2/u = #475 */
    { 0x0e01, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/2/0x1 = #476 */
    { 0x0f7f, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/3/m = #477 */
    { 0x0f00, 0x5f5a, 0xf981, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767) }, /* #10/3/3/u = #478 */
    { 0x0f01, 0x5f5a, 0x7901, RTFLOAT80U_INIT_C(1,0x9ea2b6e4a2f1b7c,32767), RTFLOAT80U_INIT_IND(1) }, /* #10/3/3/0x1 = #479 */
    { 0x007f, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/0/0/m = #480 */
    { 0x0000, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/0/0/u = #481 */
    { 0x0022, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/0/0/0x22 = #482 */
    { 0x0020, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/0/0/u0x2 = #483 */
    { 0x0002, 0x94c2, 0xb8a2, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/0/0/u0x20 = #484 */
    { 0x017f, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/0/1/m = #485 */
    { 0x0100, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/0/1/u = #486 */
    { 0x0122, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/0/1/0x22 = #487 */
    { 0x0120, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/0/1/u0x2 = #488 */
    { 0x0102, 0x94c2, 0xb8a2, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/0/1/u0x20 = #489 */
    { 0x027f, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/0/2/m = #490 */
    { 0x0200, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/0/2/u = #491 */
    { 0x0222, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/0/2/0x22 = #492 */
    { 0x0220, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/0/2/u0x2 = #493 */
    { 0x0202, 0x94c2, 0xb8a2, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/0/2/u0x20 = #494 */
    { 0x037f, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/0/3/m = #495 */
    { 0x0300, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/0/3/u = #496 */
    { 0x0322, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/0/3/0x22 = #497 */
    { 0x0320, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/0/3/u0x2 = #498 */
    { 0x0302, 0x94c2, 0xb8a2, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/0/3/u0x20 = #499 */
    { 0x047f, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/1/0/m = #500 */
    { 0x0400, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/1/0/u = #501 */
    { 0x0422, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/1/0/0x22 = #502 */
    { 0x0420, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/1/0/u0x2 = #503 */
    { 0x0402, 0x94c2, 0xb8a2, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/1/0/u0x20 = #504 */
    { 0x057f, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/1/1/m = #505 */
    { 0x0500, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/1/1/u = #506 */
    { 0x0522, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/1/1/0x22 = #507 */
    { 0x0520, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/1/1/u0x2 = #508 */
    { 0x0502, 0x94c2, 0xb8a2, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/1/1/u0x20 = #509 */
    { 0x067f, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/1/2/m = #510 */
    { 0x0600, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/1/2/u = #511 */
    { 0x0622, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/1/2/0x22 = #512 */
    { 0x0620, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/1/2/u0x2 = #513 */
    { 0x0602, 0x94c2, 0xb8a2, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/1/2/u0x20 = #514 */
    { 0x077f, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/1/3/m = #515 */
    { 0x0700, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/1/3/u = #516 */
    { 0x0722, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/1/3/0x22 = #517 */
    { 0x0720, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/1/3/u0x2 = #518 */
    { 0x0702, 0x94c2, 0xb8a2, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/1/3/u0x20 = #519 */
    { 0x087f, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/2/0/m = #520 */
    { 0x0800, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/2/0/u = #521 */
    { 0x0822, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/2/0/0x22 = #522 */
    { 0x0820, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/2/0/u0x2 = #523 */
    { 0x0802, 0x94c2, 0xb8a2, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/2/0/u0x20 = #524 */
    { 0x097f, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/2/1/m = #525 */
    { 0x0900, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/2/1/u = #526 */
    { 0x0922, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/2/1/0x22 = #527 */
    { 0x0920, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/2/1/u0x2 = #528 */
    { 0x0902, 0x94c2, 0xb8a2, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/2/1/u0x20 = #529 */
    { 0x0a7f, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/2/2/m = #530 */
    { 0x0a00, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/2/2/u = #531 */
    { 0x0a22, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/2/2/0x22 = #532 */
    { 0x0a20, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/2/2/u0x2 = #533 */
    { 0x0a02, 0x94c2, 0xb8a2, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/2/2/u0x20 = #534 */
    { 0x0b7f, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/2/3/m = #535 */
    { 0x0b00, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/2/3/u = #536 */
    { 0x0b22, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/2/3/0x22 = #537 */
    { 0x0b20, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/2/3/u0x2 = #538 */
    { 0x0b02, 0x94c2, 0xb8a2, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/2/3/u0x20 = #539 */
    { 0x0c7f, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/3/0/m = #540 */
    { 0x0c00, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/3/0/u = #541 */
    { 0x0c22, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/3/0/0x22 = #542 */
    { 0x0c20, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/3/0/u0x2 = #543 */
    { 0x0c02, 0x94c2, 0xb8a2, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/3/0/u0x20 = #544 */
    { 0x0d7f, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/3/1/m = #545 */
    { 0x0d00, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/3/1/u = #546 */
    { 0x0d22, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/3/1/0x22 = #547 */
    { 0x0d20, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/3/1/u0x2 = #548 */
    { 0x0d02, 0x94c2, 0xb8a2, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/3/1/u0x20 = #549 */
    { 0x0e7f, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/3/2/m = #550 */
    { 0x0e00, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/3/2/u = #551 */
    { 0x0e22, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/3/2/0x22 = #552 */
    { 0x0e20, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/3/2/u0x2 = #553 */
    { 0x0e02, 0x94c2, 0xb8a2, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/3/2/u0x20 = #554 */
    { 0x0f7f, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/3/3/m = #555 */
    { 0x0f00, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/3/3/u = #556 */
    { 0x0f22, 0x94c2, 0x3822, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/3/3/0x22 = #557 */
    { 0x0f20, 0x94c2, 0xb882, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,0) }, /* #11/3/3/u0x2 = #558 */
    { 0x0f02, 0x94c2, 0xb8a2, RTFLOAT80U_INIT_C(0,0x80000000000350b1,0), RTFLOAT80U_INIT_C(0,0x80000000000350b1,1) }, /* #11/3/3/u0x20 = #559 */
    { 0x007f, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/0/0/m = #560 */
    { 0x0000, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/0/0/u = #561 */
    { 0x0022, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/0/0/0x22 = #562 */
    { 0x0020, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/0/0/u0x2 = #563 */
    { 0x0002, 0x3e33, 0xb8a2, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/0/0/u0x20 = #564 */
    { 0x017f, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/0/1/m = #565 */
    { 0x0100, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/0/1/u = #566 */
    { 0x0122, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/0/1/0x22 = #567 */
    { 0x0120, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/0/1/u0x2 = #568 */
    { 0x0102, 0x3e33, 0xb8a2, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/0/1/u0x20 = #569 */
    { 0x027f, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/0/2/m = #570 */
    { 0x0200, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/0/2/u = #571 */
    { 0x0222, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/0/2/0x22 = #572 */
    { 0x0220, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/0/2/u0x2 = #573 */
    { 0x0202, 0x3e33, 0xb8a2, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/0/2/u0x20 = #574 */
    { 0x037f, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/0/3/m = #575 */
    { 0x0300, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/0/3/u = #576 */
    { 0x0322, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/0/3/0x22 = #577 */
    { 0x0320, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/0/3/u0x2 = #578 */
    { 0x0302, 0x3e33, 0xb8a2, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/0/3/u0x20 = #579 */
    { 0x047f, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/1/0/m = #580 */
    { 0x0400, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/1/0/u = #581 */
    { 0x0422, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/1/0/0x22 = #582 */
    { 0x0420, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/1/0/u0x2 = #583 */
    { 0x0402, 0x3e33, 0xb8a2, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/1/0/u0x20 = #584 */
    { 0x057f, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/1/1/m = #585 */
    { 0x0500, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/1/1/u = #586 */
    { 0x0522, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/1/1/0x22 = #587 */
    { 0x0520, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/1/1/u0x2 = #588 */
    { 0x0502, 0x3e33, 0xb8a2, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/1/1/u0x20 = #589 */
    { 0x067f, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/1/2/m = #590 */
    { 0x0600, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/1/2/u = #591 */
    { 0x0622, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/1/2/0x22 = #592 */
    { 0x0620, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/1/2/u0x2 = #593 */
    { 0x0602, 0x3e33, 0xb8a2, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/1/2/u0x20 = #594 */
    { 0x077f, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/1/3/m = #595 */
    { 0x0700, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/1/3/u = #596 */
    { 0x0722, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/1/3/0x22 = #597 */
    { 0x0720, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/1/3/u0x2 = #598 */
    { 0x0702, 0x3e33, 0xb8a2, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/1/3/u0x20 = #599 */
    { 0x087f, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/2/0/m = #600 */
    { 0x0800, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/2/0/u = #601 */
    { 0x0822, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/2/0/0x22 = #602 */
    { 0x0820, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/2/0/u0x2 = #603 */
    { 0x0802, 0x3e33, 0xb8a2, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/2/0/u0x20 = #604 */
    { 0x097f, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/2/1/m = #605 */
    { 0x0900, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/2/1/u = #606 */
    { 0x0922, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/2/1/0x22 = #607 */
    { 0x0920, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/2/1/u0x2 = #608 */
    { 0x0902, 0x3e33, 0xb8a2, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/2/1/u0x20 = #609 */
    { 0x0a7f, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/2/2/m = #610 */
    { 0x0a00, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/2/2/u = #611 */
    { 0x0a22, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/2/2/0x22 = #612 */
    { 0x0a20, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/2/2/u0x2 = #613 */
    { 0x0a02, 0x3e33, 0xb8a2, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/2/2/u0x20 = #614 */
    { 0x0b7f, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/2/3/m = #615 */
    { 0x0b00, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/2/3/u = #616 */
    { 0x0b22, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/2/3/0x22 = #617 */
    { 0x0b20, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/2/3/u0x2 = #618 */
    { 0x0b02, 0x3e33, 0xb8a2, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/2/3/u0x20 = #619 */
    { 0x0c7f, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/3/0/m = #620 */
    { 0x0c00, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/3/0/u = #621 */
    { 0x0c22, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/3/0/0x22 = #622 */
    { 0x0c20, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/3/0/u0x2 = #623 */
    { 0x0c02, 0x3e33, 0xb8a2, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/3/0/u0x20 = #624 */
    { 0x0d7f, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/3/1/m = #625 */
    { 0x0d00, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/3/1/u = #626 */
    { 0x0d22, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/3/1/0x22 = #627 */
    { 0x0d20, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/3/1/u0x2 = #628 */
    { 0x0d02, 0x3e33, 0xb8a2, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/3/1/u0x20 = #629 */
    { 0x0e7f, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/3/2/m = #630 */
    { 0x0e00, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/3/2/u = #631 */
    { 0x0e22, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/3/2/0x22 = #632 */
    { 0x0e20, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/3/2/u0x2 = #633 */
    { 0x0e02, 0x3e33, 0xb8a2, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/3/2/u0x20 = #634 */
    { 0x0f7f, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/3/3/m = #635 */
    { 0x0f00, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/3/3/u = #636 */
    { 0x0f22, 0x3e33, 0x3822, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/3/3/0x22 = #637 */
    { 0x0f20, 0x3e33, 0xb882, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0) }, /* #12/3/3/u0x2 = #638 */
    { 0x0f02, 0x3e33, 0xb8a2, RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,0), RTFLOAT80U_INIT_C(0,0x9d42611a7c406133,1) }, /* #12/3/3/u0x20 = #639 */
    { 0x007f, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/0/0/m = #640 */
    { 0x0000, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/0/0/u = #641 */
    { 0x0032, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/0/0/0x32 = #642 */
    { 0x0030, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/0/0/u0x2 = #643 */
    { 0x0022, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0xa64537232fd80000,24558) }, /* #13/0/0/u0x10 = #644 */
    { 0x0012, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/0/0/u0x20 = #645 */
    { 0x017f, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/0/1/m = #646 */
    { 0x0100, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/0/1/u = #647 */
    { 0x0132, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/0/1/0x32 = #648 */
    { 0x0130, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/0/1/u0x2 = #649 */
    { 0x0122, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0xa64537232fd80000,24558) }, /* #13/0/1/u0x10 = #650 */
    { 0x0112, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/0/1/u0x20 = #651 */
    { 0x027f, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/0/2/m = #652 */
    { 0x0200, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/0/2/u = #653 */
    { 0x0232, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/0/2/0x32 = #654 */
    { 0x0230, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/0/2/u0x2 = #655 */
    { 0x0222, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0xa64537232fd80000,24558) }, /* #13/0/2/u0x10 = #656 */
    { 0x0212, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/0/2/u0x20 = #657 */
    { 0x037f, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/0/3/m = #658 */
    { 0x0300, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/0/3/u = #659 */
    { 0x0332, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/0/3/0x32 = #660 */
    { 0x0330, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/0/3/u0x2 = #661 */
    { 0x0322, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0xa64537232fd80000,24558) }, /* #13/0/3/u0x10 = #662 */
    { 0x0312, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/0/3/u0x20 = #663 */
    { 0x047f, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/1/0/m = #664 */
    { 0x0400, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/1/0/u = #665 */
    { 0x0432, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/1/0/0x32 = #666 */
    { 0x0430, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/1/0/u0x2 = #667 */
    { 0x0422, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0xa64537232fd80000,24558) }, /* #13/1/0/u0x10 = #668 */
    { 0x0412, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/1/0/u0x20 = #669 */
    { 0x057f, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/1/1/m = #670 */
    { 0x0500, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/1/1/u = #671 */
    { 0x0532, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/1/1/0x32 = #672 */
    { 0x0530, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/1/1/u0x2 = #673 */
    { 0x0522, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0xa64537232fd80000,24558) }, /* #13/1/1/u0x10 = #674 */
    { 0x0512, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/1/1/u0x20 = #675 */
    { 0x067f, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/1/2/m = #676 */
    { 0x0600, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/1/2/u = #677 */
    { 0x0632, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/1/2/0x32 = #678 */
    { 0x0630, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/1/2/u0x2 = #679 */
    { 0x0622, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0xa64537232fd80000,24558) }, /* #13/1/2/u0x10 = #680 */
    { 0x0612, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/1/2/u0x20 = #681 */
    { 0x077f, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/1/3/m = #682 */
    { 0x0700, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/1/3/u = #683 */
    { 0x0732, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/1/3/0x32 = #684 */
    { 0x0730, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/1/3/u0x2 = #685 */
    { 0x0722, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0xa64537232fd80000,24558) }, /* #13/1/3/u0x10 = #686 */
    { 0x0712, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/1/3/u0x20 = #687 */
    { 0x087f, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/2/0/m = #688 */
    { 0x0800, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/2/0/u = #689 */
    { 0x0832, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/2/0/0x32 = #690 */
    { 0x0830, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/2/0/u0x2 = #691 */
    { 0x0822, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0xa64537232fd80000,24558) }, /* #13/2/0/u0x10 = #692 */
    { 0x0812, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/2/0/u0x20 = #693 */
    { 0x097f, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/2/1/m = #694 */
    { 0x0900, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/2/1/u = #695 */
    { 0x0932, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/2/1/0x32 = #696 */
    { 0x0930, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/2/1/u0x2 = #697 */
    { 0x0922, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0xa64537232fd80000,24558) }, /* #13/2/1/u0x10 = #698 */
    { 0x0912, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/2/1/u0x20 = #699 */
    { 0x0a7f, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/2/2/m = #700 */
    { 0x0a00, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/2/2/u = #701 */
    { 0x0a32, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/2/2/0x32 = #702 */
    { 0x0a30, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/2/2/u0x2 = #703 */
    { 0x0a22, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0xa64537232fd80000,24558) }, /* #13/2/2/u0x10 = #704 */
    { 0x0a12, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/2/2/u0x20 = #705 */
    { 0x0b7f, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/2/3/m = #706 */
    { 0x0b00, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/2/3/u = #707 */
    { 0x0b32, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/2/3/0x32 = #708 */
    { 0x0b30, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/2/3/u0x2 = #709 */
    { 0x0b22, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0xa64537232fd80000,24558) }, /* #13/2/3/u0x10 = #710 */
    { 0x0b12, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/2/3/u0x20 = #711 */
    { 0x0c7f, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/3/0/m = #712 */
    { 0x0c00, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/3/0/u = #713 */
    { 0x0c32, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/3/0/0x32 = #714 */
    { 0x0c30, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/3/0/u0x2 = #715 */
    { 0x0c22, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0xa64537232fd80000,24558) }, /* #13/3/0/u0x10 = #716 */
    { 0x0c12, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/3/0/u0x20 = #717 */
    { 0x0d7f, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/3/1/m = #718 */
    { 0x0d00, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/3/1/u = #719 */
    { 0x0d32, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/3/1/0x32 = #720 */
    { 0x0d30, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/3/1/u0x2 = #721 */
    { 0x0d22, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0xa64537232fd80000,24558) }, /* #13/3/1/u0x10 = #722 */
    { 0x0d12, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/3/1/u0x20 = #723 */
    { 0x0e7f, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/3/2/m = #724 */
    { 0x0e00, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/3/2/u = #725 */
    { 0x0e32, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/3/2/0x32 = #726 */
    { 0x0e30, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/3/2/u0x2 = #727 */
    { 0x0e22, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0xa64537232fd80000,24558) }, /* #13/3/2/u0x10 = #728 */
    { 0x0e12, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/3/2/u0x20 = #729 */
    { 0x0f7f, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/3/3/m = #730 */
    { 0x0f00, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/3/3/u = #731 */
    { 0x0f32, 0xbcf5, 0x3832, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/3/3/0x32 = #732 */
    { 0x0f30, 0xbcf5, 0xb882, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/3/3/u0x2 = #733 */
    { 0x0f22, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0xa64537232fd80000,24558) }, /* #13/3/3/u0x10 = #734 */
    { 0x0f12, 0xbcf5, 0xb8b2, RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0), RTFLOAT80U_INIT_C(0,0x14c8a6e465fb,0) }, /* #13/3/3/u0x20 = #735 */
    { 0x007f, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/0/0/m = #736 */
    { 0x0000, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/0/0/u = #737 */
    { 0x0032, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/0/0/0x32 = #738 */
    { 0x0030, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/0/0/u0x2 = #739 */
    { 0x0022, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d0,24573) }, /* #14/0/0/u0x10 = #740 */
    { 0x0012, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/0/0/u0x20 = #741 */
    { 0x017f, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/0/1/m = #742 */
    { 0x0100, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/0/1/u = #743 */
    { 0x0132, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/0/1/0x32 = #744 */
    { 0x0130, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/0/1/u0x2 = #745 */
    { 0x0122, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d0,24573) }, /* #14/0/1/u0x10 = #746 */
    { 0x0112, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/0/1/u0x20 = #747 */
    { 0x027f, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/0/2/m = #748 */
    { 0x0200, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/0/2/u = #749 */
    { 0x0232, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/0/2/0x32 = #750 */
    { 0x0230, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/0/2/u0x2 = #751 */
    { 0x0222, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d0,24573) }, /* #14/0/2/u0x10 = #752 */
    { 0x0212, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/0/2/u0x20 = #753 */
    { 0x037f, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/0/3/m = #754 */
    { 0x0300, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/0/3/u = #755 */
    { 0x0332, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/0/3/0x32 = #756 */
    { 0x0330, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/0/3/u0x2 = #757 */
    { 0x0322, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d0,24573) }, /* #14/0/3/u0x10 = #758 */
    { 0x0312, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/0/3/u0x20 = #759 */
    { 0x047f, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/1/0/m = #760 */
    { 0x0400, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/1/0/u = #761 */
    { 0x0432, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/1/0/0x32 = #762 */
    { 0x0430, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/1/0/u0x2 = #763 */
    { 0x0422, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d0,24573) }, /* #14/1/0/u0x10 = #764 */
    { 0x0412, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/1/0/u0x20 = #765 */
    { 0x057f, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/1/1/m = #766 */
    { 0x0500, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/1/1/u = #767 */
    { 0x0532, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/1/1/0x32 = #768 */
    { 0x0530, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/1/1/u0x2 = #769 */
    { 0x0522, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d0,24573) }, /* #14/1/1/u0x10 = #770 */
    { 0x0512, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/1/1/u0x20 = #771 */
    { 0x067f, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/1/2/m = #772 */
    { 0x0600, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/1/2/u = #773 */
    { 0x0632, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/1/2/0x32 = #774 */
    { 0x0630, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/1/2/u0x2 = #775 */
    { 0x0622, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d0,24573) }, /* #14/1/2/u0x10 = #776 */
    { 0x0612, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/1/2/u0x20 = #777 */
    { 0x077f, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/1/3/m = #778 */
    { 0x0700, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/1/3/u = #779 */
    { 0x0732, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/1/3/0x32 = #780 */
    { 0x0730, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/1/3/u0x2 = #781 */
    { 0x0722, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d0,24573) }, /* #14/1/3/u0x10 = #782 */
    { 0x0712, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/1/3/u0x20 = #783 */
    { 0x087f, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/2/0/m = #784 */
    { 0x0800, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/2/0/u = #785 */
    { 0x0832, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/2/0/0x32 = #786 */
    { 0x0830, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/2/0/u0x2 = #787 */
    { 0x0822, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d0,24573) }, /* #14/2/0/u0x10 = #788 */
    { 0x0812, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/2/0/u0x20 = #789 */
    { 0x097f, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/2/1/m = #790 */
    { 0x0900, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/2/1/u = #791 */
    { 0x0932, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/2/1/0x32 = #792 */
    { 0x0930, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/2/1/u0x2 = #793 */
    { 0x0922, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d0,24573) }, /* #14/2/1/u0x10 = #794 */
    { 0x0912, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/2/1/u0x20 = #795 */
    { 0x0a7f, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/2/2/m = #796 */
    { 0x0a00, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/2/2/u = #797 */
    { 0x0a32, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/2/2/0x32 = #798 */
    { 0x0a30, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/2/2/u0x2 = #799 */
    { 0x0a22, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d0,24573) }, /* #14/2/2/u0x10 = #800 */
    { 0x0a12, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/2/2/u0x20 = #801 */
    { 0x0b7f, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/2/3/m = #802 */
    { 0x0b00, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/2/3/u = #803 */
    { 0x0b32, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/2/3/0x32 = #804 */
    { 0x0b30, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/2/3/u0x2 = #805 */
    { 0x0b22, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d0,24573) }, /* #14/2/3/u0x10 = #806 */
    { 0x0b12, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/2/3/u0x20 = #807 */
    { 0x0c7f, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/3/0/m = #808 */
    { 0x0c00, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/3/0/u = #809 */
    { 0x0c32, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/3/0/0x32 = #810 */
    { 0x0c30, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/3/0/u0x2 = #811 */
    { 0x0c22, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d0,24573) }, /* #14/3/0/u0x10 = #812 */
    { 0x0c12, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/3/0/u0x20 = #813 */
    { 0x0d7f, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/3/1/m = #814 */
    { 0x0d00, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/3/1/u = #815 */
    { 0x0d32, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/3/1/0x32 = #816 */
    { 0x0d30, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/3/1/u0x2 = #817 */
    { 0x0d22, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d0,24573) }, /* #14/3/1/u0x10 = #818 */
    { 0x0d12, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/3/1/u0x20 = #819 */
    { 0x0e7f, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/3/2/m = #820 */
    { 0x0e00, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/3/2/u = #821 */
    { 0x0e32, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/3/2/0x32 = #822 */
    { 0x0e30, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/3/2/u0x2 = #823 */
    { 0x0e22, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d0,24573) }, /* #14/3/2/u0x10 = #824 */
    { 0x0e12, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/3/2/u0x20 = #825 */
    { 0x0f7f, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/3/3/m = #826 */
    { 0x0f00, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/3/3/u = #827 */
    { 0x0f32, 0x4593, 0x7932, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/3/3/0x32 = #828 */
    { 0x0f30, 0x4593, 0xf982, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/3/3/u0x2 = #829 */
    { 0x0f22, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d0,24573) }, /* #14/3/3/u0x10 = #830 */
    { 0x0f12, 0x4593, 0xf9b2, RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0), RTFLOAT80U_INIT_C(0,0xbc8930eaffd702d,0) }, /* #14/3/3/u0x20 = #831 */
    { 0x007f, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/0/0/m = #832 */
    { 0x0000, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/0/0/u = #833 */
    { 0x017f, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/0/1/m = #834 */
    { 0x0100, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/0/1/u = #835 */
    { 0x027f, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/0/2/m = #836 */
    { 0x0200, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/0/2/u = #837 */
    { 0x037f, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/0/3/m = #838 */
    { 0x0300, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/0/3/u = #839 */
    { 0x047f, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/1/0/m = #840 */
    { 0x0400, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/1/0/u = #841 */
    { 0x057f, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/1/1/m = #842 */
    { 0x0500, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/1/1/u = #843 */
    { 0x067f, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/1/2/m = #844 */
    { 0x0600, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/1/2/u = #845 */
    { 0x077f, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/1/3/m = #846 */
    { 0x0700, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/1/3/u = #847 */
    { 0x087f, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/2/0/m = #848 */
    { 0x0800, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/2/0/u = #849 */
    { 0x097f, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/2/1/m = #850 */
    { 0x0900, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/2/1/u = #851 */
    { 0x0a7f, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/2/2/m = #852 */
    { 0x0a00, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/2/2/u = #853 */
    { 0x0b7f, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/2/3/m = #854 */
    { 0x0b00, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/2/3/u = #855 */
    { 0x0c7f, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/3/0/m = #856 */
    { 0x0c00, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/3/0/u = #857 */
    { 0x0d7f, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/3/1/m = #858 */
    { 0x0d00, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/3/1/u = #859 */
    { 0x0e7f, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/3/2/m = #860 */
    { 0x0e00, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/3/2/u = #861 */
    { 0x0f7f, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/3/3/m = #862 */
    { 0x0f00, 0x6aeb, 0x7800, RTFLOAT80U_INIT_IND(1), RTFLOAT80U_INIT_IND(1) }, /* #15/3/3/u = #863 */
    { 0x007f, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/0/0/m = #864 */
    { 0x0000, 0x40d4, 0xf881, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #16/0/0/u = #865 */
    { 0x0001, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/0/0/0x1 = #866 */
    { 0x017f, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/0/1/m = #867 */
    { 0x0100, 0x40d4, 0xf881, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #16/0/1/u = #868 */
    { 0x0101, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/0/1/0x1 = #869 */
    { 0x027f, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/0/2/m = #870 */
    { 0x0200, 0x40d4, 0xf881, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #16/0/2/u = #871 */
    { 0x0201, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/0/2/0x1 = #872 */
    { 0x037f, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/0/3/m = #873 */
    { 0x0300, 0x40d4, 0xf881, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #16/0/3/u = #874 */
    { 0x0301, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/0/3/0x1 = #875 */
    { 0x047f, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/1/0/m = #876 */
    { 0x0400, 0x40d4, 0xf881, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #16/1/0/u = #877 */
    { 0x0401, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/1/0/0x1 = #878 */
    { 0x057f, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/1/1/m = #879 */
    { 0x0500, 0x40d4, 0xf881, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #16/1/1/u = #880 */
    { 0x0501, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/1/1/0x1 = #881 */
    { 0x067f, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/1/2/m = #882 */
    { 0x0600, 0x40d4, 0xf881, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #16/1/2/u = #883 */
    { 0x0601, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/1/2/0x1 = #884 */
    { 0x077f, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/1/3/m = #885 */
    { 0x0700, 0x40d4, 0xf881, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #16/1/3/u = #886 */
    { 0x0701, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/1/3/0x1 = #887 */
    { 0x087f, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/2/0/m = #888 */
    { 0x0800, 0x40d4, 0xf881, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #16/2/0/u = #889 */
    { 0x0801, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/2/0/0x1 = #890 */
    { 0x097f, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/2/1/m = #891 */
    { 0x0900, 0x40d4, 0xf881, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #16/2/1/u = #892 */
    { 0x0901, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/2/1/0x1 = #893 */
    { 0x0a7f, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/2/2/m = #894 */
    { 0x0a00, 0x40d4, 0xf881, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #16/2/2/u = #895 */
    { 0x0a01, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/2/2/0x1 = #896 */
    { 0x0b7f, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/2/3/m = #897 */
    { 0x0b00, 0x40d4, 0xf881, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #16/2/3/u = #898 */
    { 0x0b01, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/2/3/0x1 = #899 */
    { 0x0c7f, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/3/0/m = #900 */
    { 0x0c00, 0x40d4, 0xf881, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #16/3/0/u = #901 */
    { 0x0c01, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/3/0/0x1 = #902 */
    { 0x0d7f, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/3/1/m = #903 */
    { 0x0d00, 0x40d4, 0xf881, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #16/3/1/u = #904 */
    { 0x0d01, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/3/1/0x1 = #905 */
    { 0x0e7f, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/3/2/m = #906 */
    { 0x0e00, 0x40d4, 0xf881, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #16/3/2/u = #907 */
    { 0x0e01, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/3/2/0x1 = #908 */
    { 0x0f7f, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/3/3/m = #909 */
    { 0x0f00, 0x40d4, 0xf881, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_INF(1) }, /* #16/3/3/u = #910 */
    { 0x0f01, 0x40d4, 0x7801, RTFLOAT80U_INIT_INF(1), RTFLOAT80U_INIT_IND(1) }, /* #16/3/3/0x1 = #911 */
    { 0x007f, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/0/m = #912 */
    { 0x0000, 0xccc2, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/0/0/u = #913 */
    { 0x0001, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/0/0x1 = #914 */
    { 0x017f, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/1/m = #915 */
    { 0x0100, 0xccc2, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/0/1/u = #916 */
    { 0x0101, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/1/0x1 = #917 */
    { 0x027f, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/2/m = #918 */
    { 0x0200, 0xccc2, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/0/2/u = #919 */
    { 0x0201, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/2/0x1 = #920 */
    { 0x037f, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/3/m = #921 */
    { 0x0300, 0xccc2, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/0/3/u = #922 */
    { 0x0301, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/0/3/0x1 = #923 */
    { 0x047f, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/0/m = #924 */
    { 0x0400, 0xccc2, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/1/0/u = #925 */
    { 0x0401, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/0/0x1 = #926 */
    { 0x057f, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/1/m = #927 */
    { 0x0500, 0xccc2, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/1/1/u = #928 */
    { 0x0501, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/1/0x1 = #929 */
    { 0x067f, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/2/m = #930 */
    { 0x0600, 0xccc2, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/1/2/u = #931 */
    { 0x0601, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/2/0x1 = #932 */
    { 0x077f, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/3/m = #933 */
    { 0x0700, 0xccc2, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/1/3/u = #934 */
    { 0x0701, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/1/3/0x1 = #935 */
    { 0x087f, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/0/m = #936 */
    { 0x0800, 0xccc2, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/2/0/u = #937 */
    { 0x0801, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/0/0x1 = #938 */
    { 0x097f, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/1/m = #939 */
    { 0x0900, 0xccc2, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/2/1/u = #940 */
    { 0x0901, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/1/0x1 = #941 */
    { 0x0a7f, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/2/m = #942 */
    { 0x0a00, 0xccc2, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/2/2/u = #943 */
    { 0x0a01, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/2/0x1 = #944 */
    { 0x0b7f, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/3/m = #945 */
    { 0x0b00, 0xccc2, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/2/3/u = #946 */
    { 0x0b01, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/2/3/0x1 = #947 */
    { 0x0c7f, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/0/m = #948 */
    { 0x0c00, 0xccc2, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/3/0/u = #949 */
    { 0x0c01, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/0/0x1 = #950 */
    { 0x0d7f, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/1/m = #951 */
    { 0x0d00, 0xccc2, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/3/1/u = #952 */
    { 0x0d01, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/1/0x1 = #953 */
    { 0x0e7f, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/2/m = #954 */
    { 0x0e00, 0xccc2, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/3/2/u = #955 */
    { 0x0e01, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/2/0x1 = #956 */
    { 0x0f7f, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/3/m = #957 */
    { 0x0f00, 0xccc2, 0xf881, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #17/3/3/u = #958 */
    { 0x0f01, 0xccc2, 0x7801, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_IND(1) }, /* #17/3/3/0x1 = #959 */
    { 0x007f, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/0/m = #960 */
    { 0x0000, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/0/u = #961 */
    { 0x017f, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/1/m = #962 */
    { 0x0100, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/1/u = #963 */
    { 0x027f, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/2/m = #964 */
    { 0x0200, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/2/u = #965 */
    { 0x037f, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/3/m = #966 */
    { 0x0300, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/0/3/u = #967 */
    { 0x047f, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/0/m = #968 */
    { 0x0400, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/0/u = #969 */
    { 0x057f, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/1/m = #970 */
    { 0x0500, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/1/u = #971 */
    { 0x067f, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/2/m = #972 */
    { 0x0600, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/2/u = #973 */
    { 0x077f, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/3/m = #974 */
    { 0x0700, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/1/3/u = #975 */
    { 0x087f, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/0/m = #976 */
    { 0x0800, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/0/u = #977 */
    { 0x097f, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/1/m = #978 */
    { 0x0900, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/1/u = #979 */
    { 0x0a7f, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/2/m = #980 */
    { 0x0a00, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/2/u = #981 */
    { 0x0b7f, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/3/m = #982 */
    { 0x0b00, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/2/3/u = #983 */
    { 0x0c7f, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/0/m = #984 */
    { 0x0c00, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/0/u = #985 */
    { 0x0d7f, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/1/m = #986 */
    { 0x0d00, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/1/u = #987 */
    { 0x0e7f, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/2/m = #988 */
    { 0x0e00, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/2/u = #989 */
    { 0x0f7f, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/3/m = #990 */
    { 0x0f00, 0xd522, 0x7900, RTFLOAT80U_INIT_ZERO(1), RTFLOAT80U_INIT_ZERO(1) }, /* #18/3/3/u = #991 */
    { 0x007f, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/0/0/m = #992 */
    { 0x0000, 0xfd2c, 0xf9a0, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/0/0/u = #993 */
    { 0x0020, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/0/0/0x20 = #994 */
    { 0x017f, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/0/1/m = #995 */
    { 0x0100, 0xfd2c, 0xf9a0, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/0/1/u = #996 */
    { 0x0120, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/0/1/0x20 = #997 */
    { 0x027f, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/0/2/m = #998 */
    { 0x0200, 0xfd2c, 0xf9a0, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/0/2/u = #999 */
    { 0x0220, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/0/2/0x20 = #1000 */
    { 0x037f, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/0/3/m = #1001 */
    { 0x0300, 0xfd2c, 0xf9a0, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/0/3/u = #1002 */
    { 0x0320, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/0/3/0x20 = #1003 */
    { 0x047f, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/1/0/m = #1004 */
    { 0x0400, 0xfd2c, 0xf9a0, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/1/0/u = #1005 */
    { 0x0420, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/1/0/0x20 = #1006 */
    { 0x057f, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/1/1/m = #1007 */
    { 0x0500, 0xfd2c, 0xf9a0, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/1/1/u = #1008 */
    { 0x0520, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/1/1/0x20 = #1009 */
    { 0x067f, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/1/2/m = #1010 */
    { 0x0600, 0xfd2c, 0xf9a0, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/1/2/u = #1011 */
    { 0x0620, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/1/2/0x20 = #1012 */
    { 0x077f, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/1/3/m = #1013 */
    { 0x0700, 0xfd2c, 0xf9a0, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/1/3/u = #1014 */
    { 0x0720, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/1/3/0x20 = #1015 */
    { 0x087f, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/2/0/m = #1016 */
    { 0x0800, 0xfd2c, 0xf9a0, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/2/0/u = #1017 */
    { 0x0820, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/2/0/0x20 = #1018 */
    { 0x097f, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/2/1/m = #1019 */
    { 0x0900, 0xfd2c, 0xf9a0, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/2/1/u = #1020 */
    { 0x0920, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/2/1/0x20 = #1021 */
    { 0x0a7f, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/2/2/m = #1022 */
    { 0x0a00, 0xfd2c, 0xf9a0, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/2/2/u = #1023 */
    { 0x0a20, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/2/2/0x20 = #1024 */
    { 0x0b7f, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/2/3/m = #1025 */
    { 0x0b00, 0xfd2c, 0xf9a0, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/2/3/u = #1026 */
    { 0x0b20, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/2/3/0x20 = #1027 */
    { 0x0c7f, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/3/0/m = #1028 */
    { 0x0c00, 0xfd2c, 0xf9a0, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/3/0/u = #1029 */
    { 0x0c20, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/3/0/0x20 = #1030 */
    { 0x0d7f, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/3/1/m = #1031 */
    { 0x0d00, 0xfd2c, 0xf9a0, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/3/1/u = #1032 */
    { 0x0d20, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/3/1/0x20 = #1033 */
    { 0x0e7f, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/3/2/m = #1034 */
    { 0x0e00, 0xfd2c, 0xf9a0, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/3/2/u = #1035 */
    { 0x0e20, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/3/2/0x20 = #1036 */
    { 0x0f7f, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/3/3/m = #1037 */
    { 0x0f00, 0xfd2c, 0xf9a0, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/3/3/u = #1038 */
    { 0x0f20, 0xfd2c, 0x7920, RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325), RTFLOAT80U_INIT_C(1,0x8cb5f9c4c88b20ac,3325) }, /* #19/3/3/0x20 = #1039 */
    { 0x007f, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/0/0/m = #1040 */
    { 0x0000, 0xf585, 0xf981, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755) }, /* #20/0/0/u = #1041 */
    { 0x0001, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/0/0/0x1 = #1042 */
    { 0x017f, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/0/1/m = #1043 */
    { 0x0100, 0xf585, 0xf981, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755) }, /* #20/0/1/u = #1044 */
    { 0x0101, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/0/1/0x1 = #1045 */
    { 0x027f, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/0/2/m = #1046 */
    { 0x0200, 0xf585, 0xf981, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755) }, /* #20/0/2/u = #1047 */
    { 0x0201, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/0/2/0x1 = #1048 */
    { 0x037f, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/0/3/m = #1049 */
    { 0x0300, 0xf585, 0xf981, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755) }, /* #20/0/3/u = #1050 */
    { 0x0301, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/0/3/0x1 = #1051 */
    { 0x047f, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/1/0/m = #1052 */
    { 0x0400, 0xf585, 0xf981, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755) }, /* #20/1/0/u = #1053 */
    { 0x0401, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/1/0/0x1 = #1054 */
    { 0x057f, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/1/1/m = #1055 */
    { 0x0500, 0xf585, 0xf981, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755) }, /* #20/1/1/u = #1056 */
    { 0x0501, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/1/1/0x1 = #1057 */
    { 0x067f, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/1/2/m = #1058 */
    { 0x0600, 0xf585, 0xf981, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755) }, /* #20/1/2/u = #1059 */
    { 0x0601, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/1/2/0x1 = #1060 */
    { 0x077f, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/1/3/m = #1061 */
    { 0x0700, 0xf585, 0xf981, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755) }, /* #20/1/3/u = #1062 */
    { 0x0701, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/1/3/0x1 = #1063 */
    { 0x087f, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/2/0/m = #1064 */
    { 0x0800, 0xf585, 0xf981, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755) }, /* #20/2/0/u = #1065 */
    { 0x0801, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/2/0/0x1 = #1066 */
    { 0x097f, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/2/1/m = #1067 */
    { 0x0900, 0xf585, 0xf981, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755) }, /* #20/2/1/u = #1068 */
    { 0x0901, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/2/1/0x1 = #1069 */
    { 0x0a7f, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/2/2/m = #1070 */
    { 0x0a00, 0xf585, 0xf981, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755) }, /* #20/2/2/u = #1071 */
    { 0x0a01, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/2/2/0x1 = #1072 */
    { 0x0b7f, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/2/3/m = #1073 */
    { 0x0b00, 0xf585, 0xf981, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755) }, /* #20/2/3/u = #1074 */
    { 0x0b01, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/2/3/0x1 = #1075 */
    { 0x0c7f, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/3/0/m = #1076 */
    { 0x0c00, 0xf585, 0xf981, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755) }, /* #20/3/0/u = #1077 */
    { 0x0c01, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/3/0/0x1 = #1078 */
    { 0x0d7f, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/3/1/m = #1079 */
    { 0x0d00, 0xf585, 0xf981, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755) }, /* #20/3/1/u = #1080 */
    { 0x0d01, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/3/1/0x1 = #1081 */
    { 0x0e7f, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/3/2/m = #1082 */
    { 0x0e00, 0xf585, 0xf981, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755) }, /* #20/3/2/u = #1083 */
    { 0x0e01, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/3/2/0x1 = #1084 */
    { 0x0f7f, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/3/3/m = #1085 */
    { 0x0f00, 0xf585, 0xf981, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755) }, /* #20/3/3/u = #1086 */
    { 0x0f01, 0xf585, 0x7901, RTFLOAT80U_INIT_C(1,0x153b525a36f1a5ae,3755), RTFLOAT80U_INIT_IND(1) }, /* #20/3/3/0x1 = #1087 */
    { 0x007f, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/0/0/m = #1088 */
    { 0x0000, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/0/0/u = #1089 */
    { 0x017f, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/0/1/m = #1090 */
    { 0x0100, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/0/1/u = #1091 */
    { 0x027f, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/0/2/m = #1092 */
    { 0x0200, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/0/2/u = #1093 */
    { 0x037f, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/0/3/m = #1094 */
    { 0x0300, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/0/3/u = #1095 */
    { 0x047f, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/1/0/m = #1096 */
    { 0x0400, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/1/0/u = #1097 */
    { 0x057f, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/1/1/m = #1098 */
    { 0x0500, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/1/1/u = #1099 */
    { 0x067f, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/1/2/m = #1100 */
    { 0x0600, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/1/2/u = #1101 */
    { 0x077f, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/1/3/m = #1102 */
    { 0x0700, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/1/3/u = #1103 */
    { 0x087f, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/2/0/m = #1104 */
    { 0x0800, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/2/0/u = #1105 */
    { 0x097f, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/2/1/m = #1106 */
    { 0x0900, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/2/1/u = #1107 */
    { 0x0a7f, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/2/2/m = #1108 */
    { 0x0a00, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/2/2/u = #1109 */
    { 0x0b7f, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/2/3/m = #1110 */
    { 0x0b00, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/2/3/u = #1111 */
    { 0x0c7f, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/3/0/m = #1112 */
    { 0x0c00, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/3/0/u = #1113 */
    { 0x0d7f, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/3/1/m = #1114 */
    { 0x0d00, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/3/1/u = #1115 */
    { 0x0e7f, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/3/2/m = #1116 */
    { 0x0e00, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/3/2/u = #1117 */
    { 0x0f7f, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/3/3/m = #1118 */
    { 0x0f00, 0x1797, 0x3d00, RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710), RTFLOAT80U_INIT_C(1,0xaceb25647b68fa62,20710) }, /* #21/3/3/u = #1119 */
    { 0x007f, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/0/m = #1120 */
    { 0x0000, 0x7e21, 0xf881, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_C(1,0x63bab807fe,32767) }, /* #22/0/0/u = #1121 */
    { 0x0001, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/0/0x1 = #1122 */
    { 0x017f, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/1/m = #1123 */
    { 0x0100, 0x7e21, 0xf881, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_C(1,0x63bab807fe,32767) }, /* #22/0/1/u = #1124 */
    { 0x0101, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/1/0x1 = #1125 */
    { 0x027f, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/2/m = #1126 */
    { 0x0200, 0x7e21, 0xf881, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_C(1,0x63bab807fe,32767) }, /* #22/0/2/u = #1127 */
    { 0x0201, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/2/0x1 = #1128 */
    { 0x037f, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/3/m = #1129 */
    { 0x0300, 0x7e21, 0xf881, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_C(1,0x63bab807fe,32767) }, /* #22/0/3/u = #1130 */
    { 0x0301, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/0/3/0x1 = #1131 */
    { 0x047f, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/0/m = #1132 */
    { 0x0400, 0x7e21, 0xf881, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_C(1,0x63bab807fe,32767) }, /* #22/1/0/u = #1133 */
    { 0x0401, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/0/0x1 = #1134 */
    { 0x057f, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/1/m = #1135 */
    { 0x0500, 0x7e21, 0xf881, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_C(1,0x63bab807fe,32767) }, /* #22/1/1/u = #1136 */
    { 0x0501, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/1/0x1 = #1137 */
    { 0x067f, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/2/m = #1138 */
    { 0x0600, 0x7e21, 0xf881, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_C(1,0x63bab807fe,32767) }, /* #22/1/2/u = #1139 */
    { 0x0601, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/2/0x1 = #1140 */
    { 0x077f, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/3/m = #1141 */
    { 0x0700, 0x7e21, 0xf881, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_C(1,0x63bab807fe,32767) }, /* #22/1/3/u = #1142 */
    { 0x0701, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/1/3/0x1 = #1143 */
    { 0x087f, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/0/m = #1144 */
    { 0x0800, 0x7e21, 0xf881, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_C(1,0x63bab807fe,32767) }, /* #22/2/0/u = #1145 */
    { 0x0801, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/0/0x1 = #1146 */
    { 0x097f, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/1/m = #1147 */
    { 0x0900, 0x7e21, 0xf881, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_C(1,0x63bab807fe,32767) }, /* #22/2/1/u = #1148 */
    { 0x0901, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/1/0x1 = #1149 */
    { 0x0a7f, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/2/m = #1150 */
    { 0x0a00, 0x7e21, 0xf881, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_C(1,0x63bab807fe,32767) }, /* #22/2/2/u = #1151 */
    { 0x0a01, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/2/0x1 = #1152 */
    { 0x0b7f, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/3/m = #1153 */
    { 0x0b00, 0x7e21, 0xf881, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_C(1,0x63bab807fe,32767) }, /* #22/2/3/u = #1154 */
    { 0x0b01, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/2/3/0x1 = #1155 */
    { 0x0c7f, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/0/m = #1156 */
    { 0x0c00, 0x7e21, 0xf881, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_C(1,0x63bab807fe,32767) }, /* #22/3/0/u = #1157 */
    { 0x0c01, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/0/0x1 = #1158 */
    { 0x0d7f, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/1/m = #1159 */
    { 0x0d00, 0x7e21, 0xf881, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_C(1,0x63bab807fe,32767) }, /* #22/3/1/u = #1160 */
    { 0x0d01, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/1/0x1 = #1161 */
    { 0x0e7f, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/2/m = #1162 */
    { 0x0e00, 0x7e21, 0xf881, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_C(1,0x63bab807fe,32767) }, /* #22/3/2/u = #1163 */
    { 0x0e01, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/2/0x1 = #1164 */
    { 0x0f7f, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/3/m = #1165 */
    { 0x0f00, 0x7e21, 0xf881, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_C(1,0x63bab807fe,32767) }, /* #22/3/3/u = #1166 */
    { 0x0f01, 0x7e21, 0x7801, RTFLOAT80U_INIT_C(1,0x63bab807fe,32767), RTFLOAT80U_INIT_IND(1) }, /* #22/3/3/0x1 = #1167 */
    { 0x007f, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/0/0/m = #1168 */
    { 0x0000, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/0/0/u = #1169 */
    { 0x017f, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/0/1/m = #1170 */
    { 0x0100, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/0/1/u = #1171 */
    { 0x027f, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/0/2/m = #1172 */
    { 0x0200, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/0/2/u = #1173 */
    { 0x037f, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/0/3/m = #1174 */
    { 0x0300, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/0/3/u = #1175 */
    { 0x047f, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/1/0/m = #1176 */
    { 0x0400, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/1/0/u = #1177 */
    { 0x057f, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/1/1/m = #1178 */
    { 0x0500, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/1/1/u = #1179 */
    { 0x067f, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/1/2/m = #1180 */
    { 0x0600, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/1/2/u = #1181 */
    { 0x077f, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/1/3/m = #1182 */
    { 0x0700, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/1/3/u = #1183 */
    { 0x087f, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/2/0/m = #1184 */
    { 0x0800, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/2/0/u = #1185 */
    { 0x097f, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/2/1/m = #1186 */
    { 0x0900, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/2/1/u = #1187 */
    { 0x0a7f, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/2/2/m = #1188 */
    { 0x0a00, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/2/2/u = #1189 */
    { 0x0b7f, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/2/3/m = #1190 */
    { 0x0b00, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/2/3/u = #1191 */
    { 0x0c7f, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/3/0/m = #1192 */
    { 0x0c00, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/3/0/u = #1193 */
    { 0x0d7f, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/3/1/m = #1194 */
    { 0x0d00, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/3/1/u = #1195 */
    { 0x0e7f, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/3/2/m = #1196 */
    { 0x0e00, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/3/2/u = #1197 */
    { 0x0f7f, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/3/3/m = #1198 */
    { 0x0f00, 0x1062, 0x3c00, RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114), RTFLOAT80U_INIT_C(0,0x93f85eff842ff345,24114) }, /* #23/3/3/u = #1199 */
    { 0x007f, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/0/0/m = #1200 */
    { 0x0000, 0xb3b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/0/0/u = #1201 */
    { 0x0020, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/0/0/0x20 = #1202 */
    { 0x017f, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/0/1/m = #1203 */
    { 0x0100, 0xb3b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/0/1/u = #1204 */
    { 0x0120, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/0/1/0x20 = #1205 */
    { 0x027f, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/0/2/m = #1206 */
    { 0x0200, 0xb3b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/0/2/u = #1207 */
    { 0x0220, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/0/2/0x20 = #1208 */
    { 0x037f, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/0/3/m = #1209 */
    { 0x0300, 0xb3b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/0/3/u = #1210 */
    { 0x0320, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/0/3/0x20 = #1211 */
    { 0x047f, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/1/0/m = #1212 */
    { 0x0400, 0xb3b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/1/0/u = #1213 */
    { 0x0420, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/1/0/0x20 = #1214 */
    { 0x057f, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/1/1/m = #1215 */
    { 0x0500, 0xb3b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/1/1/u = #1216 */
    { 0x0520, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/1/1/0x20 = #1217 */
    { 0x067f, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/1/2/m = #1218 */
    { 0x0600, 0xb3b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/1/2/u = #1219 */
    { 0x0620, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/1/2/0x20 = #1220 */
    { 0x077f, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/1/3/m = #1221 */
    { 0x0700, 0xb3b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/1/3/u = #1222 */
    { 0x0720, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/1/3/0x20 = #1223 */
    { 0x087f, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/2/0/m = #1224 */
    { 0x0800, 0xb3b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/2/0/u = #1225 */
    { 0x0820, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/2/0/0x20 = #1226 */
    { 0x097f, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/2/1/m = #1227 */
    { 0x0900, 0xb3b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/2/1/u = #1228 */
    { 0x0920, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/2/1/0x20 = #1229 */
    { 0x0a7f, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/2/2/m = #1230 */
    { 0x0a00, 0xb3b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/2/2/u = #1231 */
    { 0x0a20, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/2/2/0x20 = #1232 */
    { 0x0b7f, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/2/3/m = #1233 */
    { 0x0b00, 0xb3b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/2/3/u = #1234 */
    { 0x0b20, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/2/3/0x20 = #1235 */
    { 0x0c7f, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/3/0/m = #1236 */
    { 0x0c00, 0xb3b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/3/0/u = #1237 */
    { 0x0c20, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/3/0/0x20 = #1238 */
    { 0x0d7f, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/3/1/m = #1239 */
    { 0x0d00, 0xb3b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/3/1/u = #1240 */
    { 0x0d20, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/3/1/0x20 = #1241 */
    { 0x0e7f, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/3/2/m = #1242 */
    { 0x0e00, 0xb3b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/3/2/u = #1243 */
    { 0x0e20, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/3/2/0x20 = #1244 */
    { 0x0f7f, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/3/3/m = #1245 */
    { 0x0f00, 0xb3b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/3/3/u = #1246 */
    { 0x0f20, 0xb3b8, 0x3920, RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673), RTFLOAT80U_INIT_C(1,0xb5b7571e9a17dd9e,2673) }, /* #24/3/3/0x20 = #1247 */
    { 0x007f, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/0/0/m = #1248 */
    { 0x0000, 0xacc7, 0xb8a0, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/0/0/u = #1249 */
    { 0x0020, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/0/0/0x20 = #1250 */
    { 0x017f, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/0/1/m = #1251 */
    { 0x0100, 0xacc7, 0xb8a0, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/0/1/u = #1252 */
    { 0x0120, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/0/1/0x20 = #1253 */
    { 0x027f, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/0/2/m = #1254 */
    { 0x0200, 0xacc7, 0xb8a0, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/0/2/u = #1255 */
    { 0x0220, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/0/2/0x20 = #1256 */
    { 0x037f, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/0/3/m = #1257 */
    { 0x0300, 0xacc7, 0xb8a0, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/0/3/u = #1258 */
    { 0x0320, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/0/3/0x20 = #1259 */
    { 0x047f, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/1/0/m = #1260 */
    { 0x0400, 0xacc7, 0xb8a0, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/1/0/u = #1261 */
    { 0x0420, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/1/0/0x20 = #1262 */
    { 0x057f, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/1/1/m = #1263 */
    { 0x0500, 0xacc7, 0xb8a0, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/1/1/u = #1264 */
    { 0x0520, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/1/1/0x20 = #1265 */
    { 0x067f, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/1/2/m = #1266 */
    { 0x0600, 0xacc7, 0xb8a0, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/1/2/u = #1267 */
    { 0x0620, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/1/2/0x20 = #1268 */
    { 0x077f, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/1/3/m = #1269 */
    { 0x0700, 0xacc7, 0xb8a0, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/1/3/u = #1270 */
    { 0x0720, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/1/3/0x20 = #1271 */
    { 0x087f, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/2/0/m = #1272 */
    { 0x0800, 0xacc7, 0xb8a0, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/2/0/u = #1273 */
    { 0x0820, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/2/0/0x20 = #1274 */
    { 0x097f, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/2/1/m = #1275 */
    { 0x0900, 0xacc7, 0xb8a0, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/2/1/u = #1276 */
    { 0x0920, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/2/1/0x20 = #1277 */
    { 0x0a7f, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/2/2/m = #1278 */
    { 0x0a00, 0xacc7, 0xb8a0, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/2/2/u = #1279 */
    { 0x0a20, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/2/2/0x20 = #1280 */
    { 0x0b7f, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/2/3/m = #1281 */
    { 0x0b00, 0xacc7, 0xb8a0, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/2/3/u = #1282 */
    { 0x0b20, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/2/3/0x20 = #1283 */
    { 0x0c7f, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/3/0/m = #1284 */
    { 0x0c00, 0xacc7, 0xb8a0, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/3/0/u = #1285 */
    { 0x0c20, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/3/0/0x20 = #1286 */
    { 0x0d7f, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/3/1/m = #1287 */
    { 0x0d00, 0xacc7, 0xb8a0, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/3/1/u = #1288 */
    { 0x0d20, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/3/1/0x20 = #1289 */
    { 0x0e7f, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/3/2/m = #1290 */
    { 0x0e00, 0xacc7, 0xb8a0, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/3/2/u = #1291 */
    { 0x0e20, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/3/2/0x20 = #1292 */
    { 0x0f7f, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/3/3/m = #1293 */
    { 0x0f00, 0xacc7, 0xb8a0, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/3/3/u = #1294 */
    { 0x0f20, 0xacc7, 0x3820, RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035), RTFLOAT80U_INIT_C(0,0xb358b16357f2c472,8035) }, /* #25/3/3/0x20 = #1295 */
    { 0x007f, 0x2e67, 0x3801, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_IND(1) }, /* #26/0/0/m = #1296 */
    { 0x0000, 0x2e67, 0xb881, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_C(1,0x71eacd2,3423) }, /* #26/0/0/u = #1297 */
    { 0x0001, 0x2e67, 0x3801, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_IND(1) }, /* #26/0/0/0x1 = #1298 */
    { 0x017f, 0x2e67, 0x3801, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_IND(1) }, /* #26/0/1/m = #1299 */
    { 0x0100, 0x2e67, 0xb881, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_C(1,0x71eacd2,3423) }, /* #26/0/1/u = #1300 */
    { 0x0101, 0x2e67, 0x3801, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_IND(1) }, /* #26/0/1/0x1 = #1301 */
    { 0x027f, 0x2e67, 0x3801, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_IND(1) }, /* #26/0/2/m = #1302 */
    { 0x0200, 0x2e67, 0xb881, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_C(1,0x71eacd2,3423) }, /* #26/0/2/u = #1303 */
    { 0x0201, 0x2e67, 0x3801, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_IND(1) }, /* #26/0/2/0x1 = #1304 */
    { 0x037f, 0x2e67, 0x3801, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_IND(1) }, /* #26/0/3/m = #1305 */
    { 0x0300, 0x2e67, 0xb881, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_C(1,0x71eacd2,3423) }, /* #26/0/3/u = #1306 */
    { 0x0301, 0x2e67, 0x3801, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_IND(1) }, /* #26/0/3/0x1 = #1307 */
    { 0x047f, 0x2e67, 0x3801, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_IND(1) }, /* #26/1/0/m = #1308 */
    { 0x0400, 0x2e67, 0xb881, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_C(1,0x71eacd2,3423) }, /* #26/1/0/u = #1309 */
    { 0x0401, 0x2e67, 0x3801, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_IND(1) }, /* #26/1/0/0x1 = #1310 */
    { 0x057f, 0x2e67, 0x3801, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_IND(1) }, /* #26/1/1/m = #1311 */
    { 0x0500, 0x2e67, 0xb881, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_C(1,0x71eacd2,3423) }, /* #26/1/1/u = #1312 */
    { 0x0501, 0x2e67, 0x3801, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_IND(1) }, /* #26/1/1/0x1 = #1313 */
    { 0x067f, 0x2e67, 0x3801, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_IND(1) }, /* #26/1/2/m = #1314 */
    { 0x0600, 0x2e67, 0xb881, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_C(1,0x71eacd2,3423) }, /* #26/1/2/u = #1315 */
    { 0x0601, 0x2e67, 0x3801, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_IND(1) }, /* #26/1/2/0x1 = #1316 */
    { 0x077f, 0x2e67, 0x3801, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_IND(1) }, /* #26/1/3/m = #1317 */
    { 0x0700, 0x2e67, 0xb881, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_C(1,0x71eacd2,3423) }, /* #26/1/3/u = #1318 */
    { 0x0701, 0x2e67, 0x3801, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_IND(1) }, /* #26/1/3/0x1 = #1319 */
    { 0x087f, 0x2e67, 0x3801, RTFLOAT80U_INIT_C(1,0x71eacd2,3423), RTFLOAT80U_INIT_IND(1