# -*- coding: utf-8 -*-
# $Id: itgTableDaa.py $

"""
DAA (instruction) result table.
"""


__copyright__ = \
"""
Copyright (C) 2012-2022 Oracle and/or its affiliates.

This file is part of VirtualBox base platform packages, as
available from https://www.virtualbox.org.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, in version 3 of the
License.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, see <https://www.gnu.org/licenses>.

SPDX-License-Identifier: GPL-3.0-only
"""
__version__ = "$Revision: 153224 $";


## The 32-bit GCC (C99) program that produced the table below.
g_sItgCProgramDaa = \
"""
#include <stdio.h>

int main()
{
    for (unsigned uInputAL = 0; uInputAL < 256; uInputAL++)
        for (unsigned fAux = 0; fAux < 2; fAux++)
            for (unsigned fCarry = 0; fCarry < 2; fCarry++)
            {
                unsigned uInputEFlags = fCarry | (fAux << 4);
                unsigned uResultAL;
                unsigned uResultEFlags;
                __asm__ __volatile__("pushl %1\\n"
                                     "popfl\\n"
                                     "daa\\n"
                                     "pushf\\n"
                                     "pop   %1\\n"
                                     : "=a" (uResultAL),
                                       "=r" (uResultEFlags)
                                     : "0" (uInputAL),
                                       "1" (uInputEFlags)
                                     : "memory"
                                     );
                printf("    ( 0x%02x, 0x%02x ), # AL=0x%02x, AF=%u CF=%u\\n",
                       uResultAL, uResultEFlags & 0xd5, uInputAL, fAux, fCarry);
                       /* 0xd5 = CF, PF, AF, ZF, SF */
            }
    return 0;
}
""";


#
# Compile and run the above program if requested to do so.
#
if __name__ == '__main__':
    import sys;
    if len(sys.argv) > 1 and sys.argv[1] == 'gen':
        import subprocess;
        oProc = subprocess.Popen(['gcc', '-x', 'c', '-std=gnu99', '-m32', '-o', './itgTableDaa', '-'], stdin = subprocess.PIPE);
        oProc.communicate(g_sItgCProgramDaa);
        oProc.wait();
        oProc = subprocess.Popen(['./itgTableDaa',]).wait();
        sys.exit(0);



##
# The DAA results.
#
# The index / input relation is: index = (AL << 2) | (CF << 1) | AF
#
g_aItgDaaResults = \
[
    ( 0x00, 0x44 ), # AL=0x00, AF=0 CF=0
    ( 0x60, 0x05 ), # AL=0x00, AF=0 CF=1
    ( 0x06, 0x14 ), # AL=0x00, AF=1 CF=0
    ( 0x66, 0x15 ), # AL=0x00, AF=1 CF=1
    ( 0x01, 0x00 ), # AL=0x01, AF=0 CF=0
    ( 0x61, 0x01 ), # AL=0x01, AF=0 CF=1
    ( 0x07, 0x10 ), # AL=0x01, AF=1 CF=0
    ( 0x67, 0x11 ), # AL=0x01, AF=1 CF=1
    ( 0x02, 0x00 ), # AL=0x02, AF=0 CF=0
    ( 0x62, 0x01 ), # AL=0x02, AF=0 CF=1
    ( 0x08, 0x10 ), # AL=0x02, AF=1 CF=0
    ( 0x68, 0x11 ), # AL=0x02, AF=1 CF=1
    ( 0x03, 0x04 ), # AL=0x03, AF=0 CF=0
    ( 0x63, 0x05 ), # AL=0x03, AF=0 CF=1
    ( 0x09, 0x14 ), # AL=0x03, AF=1 CF=0
    ( 0x69, 0x15 ), # AL=0x03, AF=1 CF=1
    ( 0x04, 0x00 ), # AL=0x04, AF=0 CF=0
    ( 0x64, 0x01 ), # AL=0x04, AF=0 CF=1
    ( 0x0a, 0x14 ), # AL=0x04, AF=1 CF=0
    ( 0x6a, 0x15 ), # AL=0x04, AF=1 CF=1
    ( 0x05, 0x04 ), # AL=0x05, AF=0 CF=0
    ( 0x65, 0x05 ), # AL=0x05, AF=0 CF=1
    ( 0x0b, 0x10 ), # AL=0x05, AF=1 CF=0
    ( 0x6b, 0x11 ), # AL=0x05, AF=1 CF=1
    ( 0x06, 0x04 ), # AL=0x06, AF=0 CF=0
    ( 0x66, 0x05 ), # AL=0x06, AF=0 CF=1
    ( 0x0c, 0x14 ), # AL=0x06, AF=1 CF=0
    ( 0x6c, 0x15 ), # AL=0x06, AF=1 CF=1
    ( 0x07, 0x00 ), # AL=0x07, AF=0 CF=0
    ( 0x67, 0x01 ), # AL=0x07, AF=0 CF=1
    ( 0x0d, 0x10 ), # AL=0x07, AF=1 CF=0
    ( 0x6d, 0x11 ), # AL=0x07, AF=1 CF=1
    ( 0x08, 0x00 ), # AL=0x08, AF=0 CF=0
    ( 0x68, 0x01 ), # AL=0x08, AF=0 CF=1
    ( 0x0e, 0x10 ), # AL=0x08, AF=1 CF=0
    ( 0x6e, 0x11 ), # AL=0x08, AF=1 CF=1
    ( 0x09, 0x04 ), # AL=0x09, AF=0 CF=0
    ( 0x69, 0x05 ), # AL=0x09, AF=0 CF=1
    ( 0x0f, 0x14 ), # AL=0x09, AF=1 CF=0
    ( 0x6f, 0x15 ), # AL=0x09, AF=1 CF=1
    ( 0x10, 0x10 ), # AL=0x0a, AF=0 CF=0
    ( 0x70, 0x11 ), # AL=0x0a, AF=0 CF=1
    ( 0x10, 0x10 ), # AL=0x0a, AF=1 CF=0
    ( 0x70, 0x11 ), # AL=0x0a, AF=1 CF=1
    ( 0x11, 0x14 ), # AL=0x0b, AF=0 CF=0
    ( 0x71, 0x15 ), # AL=0x0b, AF=0 CF=1
    ( 0x11, 0x14 ), # AL=0x0b, AF=1 CF=0
    ( 0x71, 0x15 ), # AL=0x0b, AF=1 CF=1
    ( 0x12, 0x14 ), # AL=0x0c, AF=0 CF=0
    ( 0x72, 0x15 ), # AL=0x0c, AF=0 CF=1
    ( 0x12, 0x14 ), # AL=0x0c, AF=1 CF=0
    ( 0x72, 0x15 ), # AL=0x0c, AF=1 CF=1
    ( 0x13, 0x10 ), # AL=0x0d, AF=0 CF=0
    ( 0x73, 0x11 ), # AL=0x0d, AF=0 CF=1
    ( 0x13, 0x10 ), # AL=0x0d, AF=1 CF=0
    ( 0x73, 0x11 ), # AL=0x0d, AF=1 CF=1
    ( 0x14, 0x14 ), # AL=0x0e, AF=0 CF=0
    ( 0x74, 0x15 ), # AL=0x0e, AF=0 CF=1
    ( 0x14, 0x14 ), # AL=0x0e, AF=1 CF=0
    ( 0x74, 0x15 ), # AL=0x0e, AF=1 CF=1
    ( 0x15, 0x10 ), # AL=0x0f, AF=0 CF=0
    ( 0x75, 0x11 ), # AL=0x0f, AF=0 CF=1
    ( 0x15, 0x10 ), # AL=0x0f, AF=1 CF=0
    ( 0x75, 0x11 ), # AL=0x0f, AF=1 CF=1
    ( 0x10, 0x00 ), # AL=0x10, AF=0 CF=0
    ( 0x70, 0x01 ), # AL=0x10, AF=0 CF=1
    ( 0x16, 0x10 ), # AL=0x10, AF=1 CF=0
    ( 0x76, 0x11 ), # AL=0x10, AF=1 CF=1
    ( 0x11, 0x04 ), # AL=0x11, AF=0 CF=0
    ( 0x71, 0x05 ), # AL=0x11, AF=0 CF=1
    ( 0x17, 0x14 ), # AL=0x11, AF=1 CF=0
    ( 0x77, 0x15 ), # AL=0x11, AF=1 CF=1
    ( 0x12, 0x04 ), # AL=0x12, AF=0 CF=0
    ( 0x72, 0x05 ), # AL=0x12, AF=0 CF=1
    ( 0x18, 0x14 ), # AL=0x12, AF=1 CF=0
    ( 0x78, 0x15 ), # AL=0x12, AF=1 CF=1
    ( 0x13, 0x00 ), # AL=0x13, AF=0 CF=0
    ( 0x73, 0x01 ), # AL=0x13, AF=0 CF=1
    ( 0x19, 0x10 ), # AL=0x13, AF=1 CF=0
    ( 0x79, 0x11 ), # AL=0x13, AF=1 CF=1
    ( 0x14, 0x04 ), # AL=0x14, AF=0 CF=0
    ( 0x74, 0x05 ), # AL=0x14, AF=0 CF=1
    ( 0x1a, 0x10 ), # AL=0x14, AF=1 CF=0
    ( 0x7a, 0x11 ), # AL=0x14, AF=1 CF=1
    ( 0x15, 0x00 ), # AL=0x15, AF=0 CF=0
    ( 0x75, 0x01 ), # AL=0x15, AF=0 CF=1
    ( 0x1b, 0x14 ), # AL=0x15, AF=1 CF=0
    ( 0x7b, 0x15 ), # AL=0x15, AF=1 CF=1
    ( 0x16, 0x00 ), # AL=0x16, AF=0 CF=0
    ( 0x76, 0x01 ), # AL=0x16, AF=0 CF=1
    ( 0x1c, 0x10 ), # AL=0x16, AF=1 CF=0
    ( 0x7c, 0x11 ), # AL=0x16, AF=1 CF=1
    ( 0x17, 0x04 ), # AL=0x17, AF=0 CF=0
    ( 0x77, 0x05 ), # AL=0x17, AF=0 CF=1
    ( 0x1d, 0x14 ), # AL=0x17, AF=1 CF=0
    ( 0x7d, 0x15 ), # AL=0x17, AF=1 CF=1
    ( 0x18, 0x04 ), # AL=0x18, AF=0 CF=0
    ( 0x78, 0x05 ), # AL=0x18, AF=0 CF=1
    ( 0x1e, 0x14 ), # AL=0x18, AF=1 CF=0
    ( 0x7e, 0x15 ), # AL=0x18, AF=1 CF=1
    ( 0x19, 0x00 ), # AL=0x19, AF=0 CF=0
    ( 0x79, 0x01 ), # AL=0x19, AF=0 CF=1
    ( 0x1f, 0x10 ), # AL=0x19, AF=1 CF=0
    ( 0x7f, 0x11 ), # AL=0x19, AF=1 CF=1
    ( 0x20, 0x10 ), # AL=0x1a, AF=0 CF=0
    ( 0x80, 0x91 ), # AL=0x1a, AF=0 CF=1
    ( 0x20, 0x10 ), # AL=0x1a, AF=1 CF=0
    ( 0x80, 0x91 ), # AL=0x1a, AF=1 CF=1
    ( 0x21, 0x14 ), # AL=0x1b, AF=0 CF=0
    ( 0x81, 0x95 ), # AL=0x1b, AF=0 CF=1
    ( 0x21, 0x14 ), # AL=0x1b, AF=1 CF=0
    ( 0x81, 0x95 ), # AL=0x1b, AF=1 CF=1
    ( 0x22, 0x14 ), # AL=0x1c, AF=0 CF=0
    ( 0x82, 0x95 ), # AL=0x1c, AF=0 CF=1
    ( 0x22, 0x14 ), # AL=0x1c, AF=1 CF=0
    ( 0x82, 0x95 ), # AL=0x1c, AF=1 CF=1
    ( 0x23, 0x10 ), # AL=0x1d, AF=0 CF=0
    ( 0x83, 0x91 ), # AL=0x1d, AF=0 CF=1
    ( 0x23, 0x10 ), # AL=0x1d, AF=1 CF=0
    ( 0x83, 0x91 ), # AL=0x1d, AF=1 CF=1
    ( 0x24, 0x14 ), # AL=0x1e, AF=0 CF=0
    ( 0x84, 0x95 ), # AL=0x1e, AF=0 CF=1
    ( 0x24, 0x14 ), # AL=0x1e, AF=1 CF=0
    ( 0x84, 0x95 ), # AL=0x1e, AF=1 CF=1
    ( 0x25, 0x10 ), # AL=0x1f, AF=0 CF=0
    ( 0x85, 0x91 ), # AL=0x1f, AF=0 CF=1
    ( 0x25, 0x10 ), # AL=0x1f, AF=1 CF=0
    ( 0x85, 0x91 ), # AL=0x1f, AF=1 CF=1
    ( 0x20, 0x00 ), # AL=0x20, AF=0 CF=0
    ( 0x80, 0x81 ), # AL=0x20, AF=0 CF=1
    ( 0x26, 0x10 ), # AL=0x20, AF=1 CF=0
    ( 0x86, 0x91 ), # AL=0x20, AF=1 CF=1
    ( 0x21, 0x04 ), # AL=0x21, AF=0 CF=0
    ( 0x81, 0x85 ), # AL=0x21, AF=0 CF=1
    ( 0x27, 0x14 ), # AL=0x21, AF=1 CF=0
    ( 0x87, 0x95 ), # AL=0x21, AF=1 CF=1
    ( 0x22, 0x04 ), # AL=0x22, AF=0 CF=0
    ( 0x82, 0x85 ), # AL=0x22, AF=0 CF=1
    ( 0x28, 0x14 ), # AL=0x22, AF=1 CF=0
    ( 0x88, 0x95 ), # AL=0x22, AF=1 CF=1
    ( 0x23, 0x00 ), # AL=0x23, AF=0 CF=0
    ( 0x83, 0x81 ), # AL=0x23, AF=0 CF=1
    ( 0x29, 0x10 ), # AL=0x23, AF=1 CF=0
    ( 0x89, 0x91 ), # AL=0x23, AF=1 CF=1
    ( 0x24, 0x04 ), # AL=0x24, AF=0 CF=0
    ( 0x84, 0x85 ), # AL=0x24, AF=0 CF=1
    ( 0x2a, 0x10 ), # AL=0x24, AF=1 CF=0
    ( 0x8a, 0x91 ), # AL=0x24, AF=1 CF=1
    ( 0x25, 0x00 ), # AL=0x25, AF=0 CF=0
    ( 0x85, 0x81 ), # AL=0x25, AF=0 CF=1
    ( 0x2b, 0x14 ), # AL=0x25, AF=1 CF=0
    ( 0x8b, 0x95 ), # AL=0x25, AF=1 CF=1
    ( 0x26, 0x00 ), # AL=0x26, AF=0 CF=0
    ( 0x86, 0x81 ), # AL=0x26, AF=0 CF=1
    ( 0x2c, 0x10 ), # AL=0x26, AF=1 CF=0
    ( 0x8c, 0x91 ), # AL=0x26, AF=1 CF=1
    ( 0x27, 0x04 ), # AL=0x27, AF=0 CF=0
    ( 0x87, 0x85 ), # AL=0x27, AF=0 CF=1
    ( 0x2d, 0x14 ), # AL=0x27, AF=1 CF=0
    ( 0x8d, 0x95 ), # AL=0x27, AF=1 CF=1
    ( 0x28, 0x04 ), # AL=0x28, AF=0 CF=0
    ( 0x88, 0x85 ), # AL=0x28, AF=0 CF=1
    ( 0x2e, 0x14 ), # AL=0x28, AF=1 CF=0
    ( 0x8e, 0x95 ), # AL=0x28, AF=1 CF=1
    ( 0x29, 0x00 ), # AL=0x29, AF=0 CF=0
    ( 0x89, 0x81 ), # AL=0x29, AF=0 CF=1
    ( 0x2f, 0x10 ), # AL=0x29, AF=1 CF=0
    ( 0x8f, 0x91 ), # AL=0x29, AF=1 CF=1
    ( 0x30, 0x14 ), # AL=0x2a, AF=0 CF=0
    ( 0x90, 0x95 ), # AL=0x2a, AF=0 CF=1
    ( 0x30, 0x14 ), # AL=0x2a, AF=1 CF=0
    ( 0x90, 0x95 ), # AL=0x2a, AF=1 CF=1
    ( 0x31, 0x10 ), # AL=0x2b, AF=0 CF=0
    ( 0x91, 0x91 ), # AL=0x2b, AF=0 CF=1
    ( 0x31, 0x10 ), # AL=0x2b, AF=1 CF=0
    ( 0x91, 0x91 ), # AL=0x2b, AF=1 CF=1
    ( 0x32, 0x10 ), # AL=0x2c, AF=0 CF=0
    ( 0x92, 0x91 ), # AL=0x2c, AF=0 CF=1
    ( 0x32, 0x10 ), # AL=0x2c, AF=1 CF=0
    ( 0x92, 0x91 ), # AL=0x2c, AF=1 CF=1
    ( 0x33, 0x14 ), # AL=0x2d, AF=0 CF=0
    ( 0x93, 0x95 ), # AL=0x2d, AF=0 CF=1
    ( 0x33, 0x14 ), # AL=0x2d, AF=1 CF=0
    ( 0x93, 0x95 ), # AL=0x2d, AF=1 CF=1
    ( 0x34, 0x10 ), # AL=0x2e, AF=0 CF=0
    ( 0x94, 0x91 ), # AL=0x2e, AF=0 CF=1
    ( 0x34, 0x10 ), # AL=0x2e, AF=1 CF=0
    ( 0x94, 0x91 ), # AL=0x2e, AF=1 CF=1
    ( 0x35, 0x14 ), # AL=0x2f, AF=0 CF=0
    ( 0x95, 0x95 ), # AL=0x2f, AF=0 CF=1
    ( 0x35, 0x14 ), # AL=0x2f, AF=1 CF=0
    ( 0x95, 0x95 ), # AL=0x2f, AF=1 CF=1
    ( 0x30, 0x04 ), # AL=0x30, AF=0 CF=0
    ( 0x90, 0x85 ), # AL=0x30, AF=0 CF=1
    ( 0x36, 0x14 ), # AL=0x30, AF=1 CF=0
    ( 0x96, 0x95 ), # AL=0x30, AF=1 CF=1
    ( 0x31, 0x00 ), # AL=0x31, AF=0 CF=0
    ( 0x91, 0x81 ), # AL=0x31, AF=0 CF=1
    ( 0x37, 0x10 ), # AL=0x31, AF=1 CF=0
    ( 0x97, 0x91 ), # AL=0x31, AF=1 CF=1
    ( 0x32, 0x00 ), # AL=0x32, AF=0 CF=0
    ( 0x92, 0x81 ), # AL=0x32, AF=0 CF=1
    ( 0x38, 0x10 ), # AL=0x32, AF=1 CF=0
    ( 0x98, 0x91 ), # AL=0x32, AF=1 CF=1
    ( 0x33, 0x04 ), # AL=0x33, AF=0 CF=0
    ( 0x93, 0x85 ), # AL=0x33, AF=0 CF=1
    ( 0x39, 0x14 ), # AL=0x33, AF=1 CF=0
    ( 0x99, 0x95 ), # AL=0x33, AF=1 CF=1
    ( 0x34, 0x00 ), # AL=0x34, AF=0 CF=0
    ( 0x94, 0x81 ), # AL=0x34, AF=0 CF=1
    ( 0x3a, 0x14 ), # AL=0x34, AF=1 CF=0
    ( 0x9a, 0x95 ), # AL=0x34, AF=1 CF=1
    ( 0x35, 0x04 ), # AL=0x35, AF=0 CF=0
    ( 0x95, 0x85 ), # AL=0x35, AF=0 CF=1
    ( 0x3b, 0x10 ), # AL=0x35, AF=1 CF=0
    ( 0x9b, 0x91 ), # AL=0x35, AF=1 CF=1
    ( 0x36, 0x04 ), # AL=0x36, AF=0 CF=0
    ( 0x96, 0x85 ), # AL=0x36, AF=0 CF=1
    ( 0x3c, 0x14 ), # AL=0x36, AF=1 CF=0
    ( 0x9c, 0x95 ), # AL=0x36, AF=1 CF=1
    ( 0x37, 0x00 ), # AL=0x37, AF=0 CF=0
    ( 0x97, 0x81 ), # AL=0x37, AF=0 CF=1
    ( 0x3d, 0x10 ), # AL=0x37, AF=1 CF=0
    ( 0x9d, 0x91 ), # AL=0x37, AF=1 CF=1
    ( 0x38, 0x00 ), # AL=0x38, AF=0 CF=0
    ( 0x98, 0x81 ), # AL=0x38, AF=0 CF=1
    ( 0x3e, 0x10 ), # AL=0x38, AF=1 CF=0
    ( 0x9e, 0x91 ), # AL=0x38, AF=1 CF=1
    ( 0x39, 0x04 ), # AL=0x39, AF=0 CF=0
    ( 0x99, 0x85 ), # AL=0x39, AF=0 CF=1
    ( 0x3f, 0x14 ), # AL=0x39, AF=1 CF=0
    ( 0x9f, 0x95 ), # AL=0x39, AF=1 CF=1
    ( 0x40, 0x10 ), # AL=0x3a, AF=0 CF=0
    ( 0xa0, 0x95 ), # AL=0x3a, AF=0 CF=1
    ( 0x40, 0x10 ), # AL=0x3a, AF=1 CF=0
    ( 0xa0, 0x95 ), # AL=0x3a, AF=1 CF=1
    ( 0x41, 0x14 ), # AL=0x3b, AF=0 CF=0
    ( 0xa1, 0x91 ), # AL=0x3b, AF=0 CF=1
    ( 0x41, 0x14 ), # AL=0x3b, AF=1 CF=0
    ( 0xa1, 0x91 ), # AL=0x3b, AF=1 CF=1
    ( 0x42, 0x14 ), # AL=0x3c, AF=0 CF=0
    ( 0xa2, 0x91 ), # AL=0x3c, AF=0 CF=1
    ( 0x42, 0x14 ), # AL=0x3c, AF=1 CF=0
    ( 0xa2, 0x91 ), # AL=0x3c, AF=1 CF=1
    ( 0x43, 0x10 ), # AL=0x3d, AF=0 CF=0
    ( 0xa3, 0x95 ), # AL=0x3d, AF=0 CF=1
    ( 0x43, 0x10 ), # AL=0x3d, AF=1 CF=0
    ( 0xa3, 0x95 ), # AL=0x3d, AF=1 CF=1
    ( 0x44, 0x14 ), # AL=0x3e, AF=0 CF=0
    ( 0xa4, 0x91 ), # AL=0x3e, AF=0 CF=1
    ( 0x44, 0x14 ), # AL=0x3e, AF=1 CF=0
    ( 0xa4, 0x91 ), # AL=0x3e, AF=1 CF=1
    ( 0x45, 0x10 ), # AL=0x3f, AF=0 CF=0
    ( 0xa5, 0x95 ), # AL=0x3f, AF=0 CF=1
    ( 0x45, 0x10 ), # AL=0x3f, AF=1 CF=0
    ( 0xa5, 0x95 ), # AL=0x3f, AF=1 CF=1
    ( 0x40, 0x00 ), # AL=0x40, AF=0 CF=0
    ( 0xa0, 0x85 ), # AL=0x40, AF=0 CF=1
    ( 0x46, 0x10 ), # AL=0x40, AF=1 CF=0
    ( 0xa6, 0x95 ), # AL=0x40, AF=1 CF=1
    ( 0x41, 0x04 ), # AL=0x41, AF=0 CF=0
    ( 0xa1, 0x81 ), # AL=0x41, AF=0 CF=1
    ( 0x47, 0x14 ), # AL=0x41, AF=1 CF=0
    ( 0xa7, 0x91 ), # AL=0x41, AF=1 CF=1
    ( 0x42, 0x04 ), # AL=0x42, AF=0 CF=0
    ( 0xa2, 0x81 ), # AL=0x42, AF=0 CF=1
    ( 0x48, 0x14 ), # AL=0x42, AF=1 CF=0
    ( 0xa8, 0x91 ), # AL=0x42, AF=1 CF=1
    ( 0x43, 0x00 ), # AL=0x43, AF=0 CF=0
    ( 0xa3, 0x85 ), # AL=0x43, AF=0 CF=1
    ( 0x49, 0x10 ), # AL=0x43, AF=1 CF=0
    ( 0xa9, 0x95 ), # AL=0x43, AF=1 CF=1
    ( 0x44, 0x04 ), # AL=0x44, AF=0 CF=0
    ( 0xa4, 0x81 ), # AL=0x44, AF=0 CF=1
    ( 0x4a, 0x10 ), # AL=0x44, AF=1 CF=0
    ( 0xaa, 0x95 ), # AL=0x44, AF=1 CF=1
    ( 0x45, 0x00 ), # AL=0x45, AF=0 CF=0
    ( 0xa5, 0x85 ), # AL=0x45, AF=0 CF=1
    ( 0x4b, 0x14 ), # AL=0x45, AF=1 CF=0
    ( 0xab, 0x91 ), # AL=0x45, AF=1 CF=1
    ( 0x46, 0x00 ), # AL=0x46, AF=0 CF=0
    ( 0xa6, 0x85 ), # AL=0x46, AF=0 CF=1
    ( 0x4c, 0x10 ), # AL=0x46, AF=1 CF=0
    ( 0xac, 0x95 ), # AL=0x46, AF=1 CF=1
    ( 0x47, 0x04 ), # AL=0x47, AF=0 CF=0
    ( 0xa7, 0x81 ), # AL=0x47, AF=0 CF=1
    ( 0x4d, 0x14 ), # AL=0x47, AF=1 CF=0
    ( 0xad, 0x91 ), # AL=0x47, AF=1 CF=1
    ( 0x48, 0x04 ), # AL=0x48, AF=0 CF=0
    ( 0xa8, 0x81 ), # AL=0x48, AF=0 CF=1
    ( 0x4e, 0x14 ), # AL=0x48, AF=1 CF=0
    ( 0xae, 0x91 ), # AL=0x48, AF=1 CF=1
    ( 0x49, 0x00 ), # AL=0x49, AF=0 CF=0
    ( 0xa9, 0x85 ), # AL=0x49, AF=0 CF=1
    ( 0x4f, 0x10 ), # AL=0x49, AF=1 CF=0
    ( 0xaf, 0x95 ), # AL=0x49, AF=1 CF=1
    ( 0x50, 0x14 ), # AL=0x4a, AF=0 CF=0
    ( 0xb0, 0x91 ), # AL=0x4a, AF=0 CF=1
    ( 0x50, 0x14 ), # AL=0x4a, AF=1 CF=0
    ( 0xb0, 0x91 ), # AL=0x4a, AF=1 CF=1
    ( 0x51, 0x10 ), # AL=0x4b, AF=0 CF=0
    ( 0xb1, 0x95 ), # AL=0x4b, AF=0 CF=1
    ( 0x51, 0x10 ), # AL=0x4b, AF=1 CF=0
    ( 0xb1, 0x95 ), # AL=0x4b, AF=1 CF=1
    ( 0x52, 0x10 ), # AL=0x4c, AF=0 CF=0
    ( 0xb2, 0x95 ), # AL=0x4c, AF=0 CF=1
    ( 0x52, 0x10 ), # AL=0x4c, AF=1 CF=0
    ( 0xb2, 0x95 ), # AL=0x4c, AF=1 CF=1
    ( 0x53, 0x14 ), # AL=0x4d, AF=0 CF=0
    ( 0xb3, 0x91 ), # AL=0x4d, AF=0 CF=1
    ( 0x53, 0x14 ), # AL=0x4d, AF=1 CF=0
    ( 0xb3, 0x91 ), # AL=0x4d, AF=1 CF=1
    ( 0x54, 0x10 ), # AL=0x4e, AF=0 CF=0
    ( 0xb4, 0x95 ), # AL=0x4e, AF=0 CF=1
    ( 0x54, 0x10 ), # AL=0x4e, AF=1 CF=0
    ( 0xb4, 0x95 ), # AL=0x4e, AF=1 CF=1
    ( 0x55, 0x14 ), # AL=0x4f, AF=0 CF=0
    ( 0xb5, 0x91 ), # AL=0x4f, AF=0 CF=1
    ( 0x55, 0x14 ), # AL=0x4f, AF=1 CF=0
    ( 0xb5, 0x91 ), # AL=0x4f, AF=1 CF=1
    ( 0x50, 0x04 ), # AL=0x50, AF=0 CF=0
    ( 0xb0, 0x81 ), # AL=0x50, AF=0 CF=1
    ( 0x56, 0x14 ), # AL=0x50, AF=1 CF=0
    ( 0xb6, 0x91 ), # AL=0x50, AF=1 CF=1
    ( 0x51, 0x00 ), # AL=0x51, AF=0 CF=0
    ( 0xb1, 0x85 ), # AL=0x51, AF=0 CF=1
    ( 0x57, 0x10 ), # AL=0x51, AF=1 CF=0
    ( 0xb7, 0x95 ), # AL=0x51, AF=1 CF=1
    ( 0x52, 0x00 ), # AL=0x52, AF=0 CF=0
    ( 0xb2, 0x85 ), # AL=0x52, AF=0 CF=1
    ( 0x58, 0x10 ), # AL=0x52, AF=1 CF=0
    ( 0xb8, 0x95 ), # AL=0x52, AF=1 CF=1
    ( 0x53, 0x04 ), # AL=0x53, AF=0 CF=0
    ( 0xb3, 0x81 ), # AL=0x53, AF=0 CF=1
    ( 0x59, 0x14 ), # AL=0x53, AF=1 CF=0
    ( 0xb9, 0x91 ), # AL=0x53, AF=1 CF=1
    ( 0x54, 0x00 ), # AL=0x54, AF=0 CF=0
    ( 0xb4, 0x85 ), # AL=0x54, AF=0 CF=1
    ( 0x5a, 0x14 ), # AL=0x54, AF=1 CF=0
    ( 0xba, 0x91 ), # AL=0x54, AF=1 CF=1
    ( 0x55, 0x04 ), # AL=0x55, AF=0 CF=0
    ( 0xb5, 0x81 ), # AL=0x55, AF=0 CF=1
    ( 0x5b, 0x10 ), # AL=0x55, AF=1 CF=0
    ( 0xbb, 0x95 ), # AL=0x55, AF=1 CF=1
    ( 0x56, 0x04 ), # AL=0x56, AF=0 CF=0
    ( 0xb6, 0x81 ), # AL=0x56, AF=0 CF=1
    ( 0x5c, 0x14 ), # AL=0x56, AF=1 CF=0
    ( 0xbc, 0x91 ), # AL=0x56, AF=1 CF=1
    ( 0x57, 0x00 ), # AL=0x57, AF=0 CF=0
    ( 0xb7, 0x85 ), # AL=0x57, AF=0 CF=1
    ( 0x5d, 0x10 ), # AL=0x57, AF=1 CF=0
    ( 0xbd, 0x95 ), # AL=0x57, AF=1 CF=1
    ( 0x58, 0x00 ), # AL=0x58, AF=0 CF=0
    ( 0xb8, 0x85 ), # AL=0x58, AF=0 CF=1
    ( 0x5e, 0x10 ), # AL=0x58, AF=1 CF=0
    ( 0xbe, 0x95 ), # AL=0x58, AF=1 CF=1
    ( 0x59, 0x04 ), # AL=0x59, AF=0 CF=0
    ( 0xb9, 0x81 ), # AL=0x59, AF=0 CF=1
    ( 0x5f, 0x14 ), # AL=0x59, AF=1 CF=0
    ( 0xbf, 0x91 ), # AL=0x59, AF=1 CF=1
    ( 0x60, 0x14 ), # AL=0x5a, AF=0 CF=0
    ( 0xc0, 0x95 ), # AL=0x5a, AF=0 CF=1
    ( 0x60, 0x14 ), # AL=0x5a, AF=1 CF=0
    ( 0xc0, 0x95 ), # AL=0x5a, AF=1 CF=1
    ( 0x61, 0x10 ), # AL=0x5b, AF=0 CF=0
    ( 0xc1, 0x91 ), # AL=0x5b, AF=0 CF=1
    ( 0x61, 0x10 ), # AL=0x5b, AF=1 CF=0
    ( 0xc1, 0x91 ), # AL=0x5b, AF=1 CF=1
    ( 0x62, 0x10 ), # AL=0x5c, AF=0 CF=0
    ( 0xc2, 0x91 ), # AL=0x5c, AF=0 CF=1
    ( 0x62, 0x10 ), # AL=0x5c, AF=1 CF=0
    ( 0xc2, 0x91 ), # AL=0x5c, AF=1 CF=1
    ( 0x63, 0x14 ), # AL=0x5d, AF=0 CF=0
    ( 0xc3, 0x95 ), # AL=0x5d, AF=0 CF=1
    ( 0x63, 0x14 ), # AL=0x5d, AF=1 CF=0
    ( 0xc3, 0x95 ), # AL=0x5d, AF=1 CF=1
    ( 0x64, 0x10 ), # AL=0x5e, AF=0 CF=0
    ( 0xc4, 0x91 ), # AL=0x5e, AF=0 CF=1
    ( 0x64, 0x10 ), # AL=0x5e, AF=1 CF=0
    ( 0xc4, 0x91 ), # AL=0x5e, AF=1 CF=1
    ( 0x65, 0x14 ), # AL=0x5f, AF=0 CF=0
    ( 0xc5, 0x95 ), # AL=0x5f, AF=0 CF=1
    ( 0x65, 0x14 ), # AL=0x5f, AF=1 CF=0
    ( 0xc5, 0x95 ), # AL=0x5f, AF=1 CF=1
    ( 0x60, 0x04 ), # AL=0x60, AF=0 CF=0
    ( 0xc0, 0x85 ), # AL=0x60, AF=0 CF=1
    ( 0x66, 0x14 ), # AL=0x60, AF=1 CF=0
    ( 0xc6, 0x95 ), # AL=0x60, AF=1 CF=1
    ( 0x61, 0x00 ), # AL=0x61, AF=0 CF=0
    ( 0xc1, 0x81 ), # AL=0x61, AF=0 CF=1
    ( 0x67, 0x10 ), # AL=0x61, AF=1 CF=0
    ( 0xc7, 0x91 ), # AL=0x61, AF=1 CF=1
    ( 0x62, 0x00 ), # AL=0x62, AF=0 CF=0
    ( 0xc2, 0x81 ), # AL=0x62, AF=0 CF=1
    ( 0x68, 0x10 ), # AL=0x62, AF=1 CF=0
    ( 0xc8, 0x91 ), # AL=0x62, AF=1 CF=1
    ( 0x63, 0x04 ), # AL=0x63, AF=0 CF=0
    ( 0xc3, 0x85 ), # AL=0x63, AF=0 CF=1
    ( 0x69, 0x14 ), # AL=0x63, AF=1 CF=0
    ( 0xc9, 0x95 ), # AL=0x63, AF=1 CF=1
    ( 0x64, 0x00 ), # AL=0x64, AF=0 CF=0
    ( 0xc4, 0x81 ), # AL=0x64, AF=0 CF=1
    ( 0x6a, 0x14 ), # AL=0x64, AF=1 CF=0
    ( 0xca, 0x95 ), # AL=0x64, AF=1 CF=1
    ( 0x65, 0x04 ), # AL=0x65, AF=0 CF=0
    ( 0xc5, 0x85 ), # AL=0x65, AF=0 CF=1
    ( 0x6b, 0x10 ), # AL=0x65, AF=1 CF=0
    ( 0xcb, 0x91 ), # AL=0x65, AF=1 CF=1
    ( 0x66, 0x04 ), # AL=0x66, AF=0 CF=0
    ( 0xc6, 0x85 ), # AL=0x66, AF=0 CF=1
    ( 0x6c, 0x14 ), # AL=0x66, AF=1 CF=0
    ( 0xcc, 0x95 ), # AL=0x66, AF=1 CF=1
    ( 0x67, 0x00 ), # AL=0x67, AF=0 CF=0
    ( 0xc7, 0x81 ), # AL=0x67, AF=0 CF=1
    ( 0x6d, 0x10 ), # AL=0x67, AF=1 CF=0
    ( 0xcd, 0x91 ), # AL=0x67, AF=1 CF=1
    ( 0x68, 0x00 ), # AL=0x68, AF=0 CF=0
    ( 0xc8, 0x81 ), # AL=0x68, AF=0 CF=1
    ( 0x6e, 0x10 ), # AL=0x68, AF=1 CF=0
    ( 0xce, 0x91 ), # AL=0x68, AF=1 CF=1
    ( 0x69, 0x04 ), # AL=0x69, AF=0 CF=0
    ( 0xc9, 0x85 ), # AL=0x69, AF=0 CF=1
    ( 0x6f, 0x14 ), # AL=0x69, AF=1 CF=0
    ( 0xcf, 0x95 ), # AL=0x69, AF=1 CF=1
    ( 0x70, 0x10 ), # AL=0x6a, AF=0 CF=0
    ( 0xd0, 0x91 ), # AL=0x6a, AF=0 CF=1
    ( 0x70, 0x10 ), # AL=0x6a, AF=1 CF=0
    ( 0xd0, 0x91 ), # AL=0x6a, AF=1 CF=1
    ( 0x71, 0x14 ), # AL=0x6b, AF=0 CF=0
    ( 0xd1, 0x95 ), # AL=0x6b, AF=0 CF=1
    ( 0x71, 0x14 ), # AL=0x6b, AF=1 CF=0
    ( 0xd1, 0x95 ), # AL=0x6b, AF=1 CF=1
    ( 0x72, 0x14 ), # AL=0x6c, AF=0 CF=0
    ( 0xd2, 0x95 ), # AL=0x6c, AF=0 CF=1
    ( 0x72, 0x14 ), # AL=0x6c, AF=1 CF=0
    ( 0xd2, 0x95 ), # AL=0x6c, AF=1 CF=1
    ( 0x73, 0x10 ), # AL=0x6d, AF=0 CF=0
    ( 0xd3, 0x91 ), # AL=0x6d, AF=0 CF=1
    ( 0x73, 0x10 ), # AL=0x6d, AF=1 CF=0
    ( 0xd3, 0x91 ), # AL=0x6d, AF=1 CF=1
    ( 0x74, 0x14 ), # AL=0x6e, AF=0 CF=0
    ( 0xd4, 0x95 ), # AL=0x6e, AF=0 CF=1
    ( 0x74, 0x14 ), # AL=0x6e, AF=1 CF=0
    ( 0xd4, 0x95 ), # AL=0x6e, AF=1 CF=1
    ( 0x75, 0x10 ), # AL=0x6f, AF=0 CF=0
    ( 0xd5, 0x91 ), # AL=0x6f, AF=0 CF=1
    ( 0x75, 0x10 ), # AL=0x6f, AF=1 CF=0
    ( 0xd5, 0x91 ), # AL=0x6f, AF=1 CF=1
    ( 0x70, 0x00 ), # AL=0x70, AF=0 CF=0
    ( 0xd0, 0x81 ), # AL=0x70, AF=0 CF=1
    ( 0x76, 0x10 ), # AL=0x70, AF=1 CF=0
    ( 0xd6, 0x91 ), # AL=0x70, AF=1 CF=1
    ( 0x71, 0x04 ), # AL=0x71, AF=0 CF=0
    ( 0xd1, 0x85 ), # AL=0x71, AF=0 CF=1
    ( 0x77, 0x14 ), # AL=0x71, AF=1 CF=0
    ( 0xd7, 0x95 ), # AL=0x71, AF=1 CF=1
    ( 0x72, 0x04 ), # AL=0x72, AF=0 CF=0
    ( 0xd2, 0x85 ), # AL=0x72, AF=0 CF=1
    ( 0x78, 0x14 ), # AL=0x72, AF=1 CF=0
    ( 0xd8, 0x95 ), # AL=0x72, AF=1 CF=1
    ( 0x73, 0x00 ), # AL=0x73, AF=0 CF=0
    ( 0xd3, 0x81 ), # AL=0x73, AF=0 CF=1
    ( 0x79, 0x10 ), # AL=0x73, AF=1 CF=0
    ( 0xd9, 0x91 ), # AL=0x73, AF=1 CF=1
    ( 0x74, 0x04 ), # AL=0x74, AF=0 CF=0
    ( 0xd4, 0x85 ), # AL=0x74, AF=0 CF=1
    ( 0x7a, 0x10 ), # AL=0x74, AF=1 CF=0
    ( 0xda, 0x91 ), # AL=0x74, AF=1 CF=1
    ( 0x75, 0x00 ), # AL=0x75, AF=0 CF=0
    ( 0xd5, 0x81 ), # AL=0x75, AF=0 CF=1
    ( 0x7b, 0x14 ), # AL=0x75, AF=1 CF=0
    ( 0xdb, 0x95 ), # AL=0x75, AF=1 CF=1
    ( 0x76, 0x00 ), # AL=0x76, AF=0 CF=0
    ( 0xd6, 0x81 ), # AL=0x76, AF=0 CF=1
    ( 0x7c, 0x10 ), # AL=0x76, AF=1 CF=0
    ( 0xdc, 0x91 ), # AL=0x76, AF=1 CF=1
    ( 0x77, 0x04 ), # AL=0x77, AF=0 CF=0
    ( 0xd7, 0x85 ), # AL=0x77, AF=0 CF=1
    ( 0x7d, 0x14 ), # AL=0x77, AF=1 CF=0
    ( 0xdd, 0x95 ), # AL=0x77, AF=1 CF=1
    ( 0x78, 0x04 ), # AL=0x78, AF=0 CF=0
    ( 0xd8, 0x85 ), # AL=0x78, AF=0 CF=1
    ( 0x7e, 0x14 ), # AL=0x78, AF=1 CF=0
    ( 0xde, 0x95 ), # AL=0x78, AF=1 CF=1
    ( 0x79, 0x00 ), # AL=0x79, AF=0 CF=0
    ( 0xd9, 0x81 ), # AL=0x79, AF=0 CF=1
    ( 0x7f, 0x10 ), # AL=0x79, AF=1 CF=0
    ( 0xdf, 0x91 ), # AL=0x79, AF=1 CF=1
    ( 0x80, 0x90 ), # AL=0x7a, AF=0 CF=0
    ( 0xe0, 0x91 ), # AL=0x7a, AF=0 CF=1
    ( 0x80, 0x90 ), # AL=0x7a, AF=1 CF=0
    ( 0xe0, 0x91 ), # AL=0x7a, AF=1 CF=1
    ( 0x81, 0x94 ), # AL=0x7b, AF=0 CF=0
    ( 0xe1, 0x95 ), # AL=0x7b, AF=0 CF=1
    ( 0x81, 0x94 ), # AL=0x7b, AF=1 CF=0
    ( 0xe1, 0x95 ), # AL=0x7b, AF=1 CF=1
    ( 0x82, 0x94 ), # AL=0x7c, AF=0 CF=0
    ( 0xe2, 0x95 ), # AL=0x7c, AF=0 CF=1
    ( 0x82, 0x94 ), # AL=0x7c, AF=1 CF=0
    ( 0xe2, 0x95 ), # AL=0x7c, AF=1 CF=1
    ( 0x83, 0x90 ), # AL=0x7d, AF=0 CF=0
    ( 0xe3, 0x91 ), # AL=0x7d, AF=0 CF=1
    ( 0x83, 0x90 ), # AL=0x7d, AF=1 CF=0
    ( 0xe3, 0x91 ), # AL=0x7d, AF=1 CF=1
    ( 0x84, 0x94 ), # AL=0x7e, AF=0 CF=0
    ( 0xe4, 0x95 ), # AL=0x7e, AF=0 CF=1
    ( 0x84, 0x94 ), # AL=0x7e, AF=1 CF=0
    ( 0xe4, 0x95 ), # AL=0x7e, AF=1 CF=1
    ( 0x85, 0x90 ), # AL=0x7f, AF=0 CF=0
    ( 0xe5, 0x91 ), # AL=0x7f, AF=0 CF=1
    ( 0x85, 0x90 ), # AL=0x7f, AF=1 CF=0
    ( 0xe5, 0x91 ), # AL=0x7f, AF=1 CF=1
    ( 0x80, 0x80 ), # AL=0x80, AF=0 CF=0
    ( 0xe0, 0x81 ), # AL=0x80, AF=0 CF=1
    ( 0x86, 0x90 ), # AL=0x80, AF=1 CF=0
    ( 0xe6, 0x91 ), # AL=0x80, AF=1 CF=1
    ( 0x81, 0x84 ), # AL=0x81, AF=0 CF=0
    ( 0xe1, 0x85 ), # AL=0x81, AF=0 CF=1
    ( 0x87, 0x94 ), # AL=0x81, AF=1 CF=0
    ( 0xe7, 0x95 ), # AL=0x81, AF=1 CF=1
    ( 0x82, 0x84 ), # AL=0x82, AF=0 CF=0
    ( 0xe2, 0x85 ), # AL=0x82, AF=0 CF=1
    ( 0x88, 0x94 ), # AL=0x82, AF=1 CF=0
    ( 0xe8, 0x95 ), # AL=0x82, AF=1 CF=1
    ( 0x83, 0x80 ), # AL=0x83, AF=0 CF=0
    ( 0xe3, 0x81 ), # AL=0x83, AF=0 CF=1
    ( 0x89, 0x90 ), # AL=0x83, AF=1 CF=0
    ( 0xe9, 0x91 ), # AL=0x83, AF=1 CF=1
    ( 0x84, 0x84 ), # AL=0x84, AF=0 CF=0
    ( 0xe4, 0x85 ), # AL=0x84, AF=0 CF=1
    ( 0x8a, 0x90 ), # AL=0x84, AF=1 CF=0
    ( 0xea, 0x91 ), # AL=0x84, AF=1 CF=1
    ( 0x85, 0x80 ), # AL=0x85, AF=0 CF=0
    ( 0xe5, 0x81 ), # AL=0x85, AF=0 CF=1
    ( 0x8b, 0x94 ), # AL=0x85, AF=1 CF=0
    ( 0xeb, 0x95 ), # AL=0x85, AF=1 CF=1
    ( 0x86, 0x80 ), # AL=0x86, AF=0 CF=0
    ( 0xe6, 0x81 ), # AL=0x86, AF=0 CF=1
    ( 0x8c, 0x90 ), # AL=0x86, AF=1 CF=0
    ( 0xec, 0x91 ), # AL=0x86, AF=1 CF=1
    ( 0x87, 0x84 ), # AL=0x87, AF=0 CF=0
    ( 0xe7, 0x85 ), # AL=0x87, AF=0 CF=1
    ( 0x8d, 0x94 ), # AL=0x87, AF=1 CF=0
    ( 0xed, 0x95 ), # AL=0x87, AF=1 CF=1
    ( 0x88, 0x84 ), # AL=0x88, AF=0 CF=0
    ( 0xe8, 0x85 ), # AL=0x88, AF=0 CF=1
    ( 0x8e, 0x94 ), # AL=0x88, AF=1 CF=0
    ( 0xee, 0x95 ), # AL=0x88, AF=1 CF=1
    ( 0x89, 0x80 ), # AL=0x89, AF=0 CF=0
    ( 0xe9, 0x81 ), # AL=0x89, AF=0 CF=1
    ( 0x8f, 0x90 ), # AL=0x89, AF=1 CF=0
    ( 0xef, 0x91 ), # AL=0x89, AF=1 CF=1
    ( 0x90, 0x94 ), # AL=0x8a, AF=0 CF=0
    ( 0xf0, 0x95 ), # AL=0x8a, AF=0 CF=1
    ( 0x90, 0x94 ), # AL=0x8a, AF=1 CF=0
    ( 0xf0, 0x95 ), # AL=0x8a, AF=1 CF=1
    ( 0x91, 0x90 ), # AL=0x8b, AF=0 CF=0
    ( 0xf1, 0x91 ), # AL=0x8b, AF=0 CF=1
    ( 0x91, 0x90 ), # AL=0x8b, AF=1 CF=0
    ( 0xf1, 0x91 ), # AL=0x8b, AF=1 CF=1
    ( 0x92, 0x90 ), # AL=0x8c, AF=0 CF=0
    ( 0xf2, 0x91 ), # AL=0x8c, AF=0 CF=1
    ( 0x92, 0x90 ), # AL=0x8c, AF=1 CF=0
    ( 0xf2, 0x91 ), # AL=0x8c, AF=1 CF=1
    ( 0x93, 0x94 ), # AL=0x8d, AF=0 CF=0
    ( 0xf3, 0x95 ), # AL=0x8d, AF=0 CF=1
    ( 0x93, 0x94 ), # AL=0x8d, AF=1 CF=0
    ( 0xf3, 0x95 ), # AL=0x8d, AF=1 CF=1
    ( 0x94, 0x90 ), # AL=0x8e, AF=0 CF=0
    ( 0xf4, 0x91 ), # AL=0x8e, AF=0 CF=1
    ( 0x94, 0x90 ), # AL=0x8e, AF=1 CF=0
    ( 0xf4, 0x91 ), # AL=0x8e, AF=1 CF=1
    ( 0x95, 0x94 ), # AL=0x8f, AF=0 CF=0
    ( 0xf5, 0x95 ), # AL=0x8f, AF=0 CF=1
    ( 0x95, 0x94 ), # AL=0x8f, AF=1 CF=0
    ( 0xf5, 0x95 ), # AL=0x8f, AF=1 CF=1
    ( 0x90, 0x84 ), # AL=0x90, AF=0 CF=0
    ( 0xf0, 0x85 ), # AL=0x90, AF=0 CF=1
    ( 0x96, 0x94 ), # AL=0x90, AF=1 CF=0
    ( 0xf6, 0x95 ), # AL=0x90, AF=1 CF=1
    ( 0x91, 0x80 ), # AL=0x91, AF=0 CF=0
    ( 0xf1, 0x81 ), # AL=0x91, AF=0 CF=1
    ( 0x97, 0x90 ), # AL=0x91, AF=1 CF=0
    ( 0xf7, 0x91 ), # AL=0x91, AF=1 CF=1
    ( 0x92, 0x80 ), # AL=0x92, AF=0 CF=0
    ( 0xf2, 0x81 ), # AL=0x92, AF=0 CF=1
    ( 0x98, 0x90 ), # AL=0x92, AF=1 CF=0
    ( 0xf8, 0x91 ), # AL=0x92, AF=1 CF=1
    ( 0x93, 0x84 ), # AL=0x93, AF=0 CF=0
    ( 0xf3, 0x85 ), # AL=0x93, AF=0 CF=1
    ( 0x99, 0x94 ), # AL=0x93, AF=1 CF=0
    ( 0xf9, 0x95 ), # AL=0x93, AF=1 CF=1
    ( 0x94, 0x80 ), # AL=0x94, AF=0 CF=0
    ( 0xf4, 0x81 ), # AL=0x94, AF=0 CF=1
    ( 0x9a, 0x94 ), # AL=0x94, AF=1 CF=0
    ( 0xfa, 0x95 ), # AL=0x94, AF=1 CF=1
    ( 0x95, 0x84 ), # AL=0x95, AF=0 CF=0
    ( 0xf5, 0x85 ), # AL=0x95, AF=0 CF=1
    ( 0x9b, 0x90 ), # AL=0x95, AF=1 CF=0
    ( 0xfb, 0x91 ), # AL=0x95, AF=1 CF=1
    ( 0x96, 0x84 ), # AL=0x96, AF=0 CF=0
    ( 0xf6, 0x85 ), # AL=0x96, AF=0 CF=1
    ( 0x9c, 0x94 ), # AL=0x96, AF=1 CF=0
    ( 0xfc, 0x95 ), # AL=0x96, AF=1 CF=1
    ( 0x97, 0x80 ), # AL=0x97, AF=0 CF=0
    ( 0xf7, 0x81 ), # AL=0x97, AF=0 CF=1
    ( 0x9d, 0x90 ), # AL=0x97, AF=1 CF=0
    ( 0xfd, 0x91 ), # AL=0x97, AF=1 CF=1
    ( 0x98, 0x80 ), # AL=0x98, AF=0 CF=0
    ( 0xf8, 0x81 ), # AL=0x98, AF=0 CF=1
    ( 0x9e, 0x90 ), # AL=0x98, AF=1 CF=0
    ( 0xfe, 0x91 ), # AL=0x98, AF=1 CF=1
    ( 0x99, 0x84 ), # AL=0x99, AF=0 CF=0
    ( 0xf9, 0x85 ), # AL=0x99, AF=0 CF=1
    ( 0x9f, 0x94 ), # AL=0x99, AF=1 CF=0
    ( 0xff, 0x95 ), # AL=0x99, AF=1 CF=1
    ( 0x00, 0x55 ), # AL=0x9a, AF=0 CF=0
    ( 0x00, 0x55 ), # AL=0x9a, AF=0 CF=1
    ( 0x00, 0x55 ), # AL=0x9a, AF=1 CF=0
    ( 0x00, 0x55 ), # AL=0x9a, AF=1 CF=1
    ( 0x01, 0x11 ), # AL=0x9b, AF=0 CF=0
    ( 0x01, 0x11 ), # AL=0x9b, AF=0 CF=1
    ( 0x01, 0x11 ), # AL=0x9b, AF=1 CF=0
    ( 0x01, 0x11 ), # AL=0x9b, AF=1 CF=1
    ( 0x02, 0x11 ), # AL=0x9c, AF=0 CF=0
    ( 0x02, 0x11 ), # AL=0x9c, AF=0 CF=1
    ( 0x02, 0x11 ), # AL=0x9c, AF=1 CF=0
    ( 0x02, 0x11 ), # AL=0x9c, AF=1 CF=1
    ( 0x03, 0x15 ), # AL=0x9d, AF=0 CF=0
    ( 0x03, 0x15 ), # AL=0x9d, AF=0 CF=1
    ( 0x03, 0x15 ), # AL=0x9d, AF=1 CF=0
    ( 0x03, 0x15 ), # AL=0x9d, AF=1 CF=1
    ( 0x04, 0x11 ), # AL=0x9e, AF=0 CF=0
    ( 0x04, 0x11 ), # AL=0x9e, AF=0 CF=1
    ( 0x04, 0x11 ), # AL=0x9e, AF=1 CF=0
    ( 0x04, 0x11 ), # AL=0x9e, AF=1 CF=1
    ( 0x05, 0x15 ), # AL=0x9f, AF=0 CF=0
    ( 0x05, 0x15 ), # AL=0x9f, AF=0 CF=1
    ( 0x05, 0x15 ), # AL=0x9f, AF=1 CF=0
    ( 0x05, 0x15 ), # AL=0x9f, AF=1 CF=1
    ( 0x00, 0x45 ), # AL=0xa0, AF=0 CF=0
    ( 0x00, 0x45 ), # AL=0xa0, AF=0 CF=1
    ( 0x06, 0x15 ), # AL=0xa0, AF=1 CF=0
    ( 0x06, 0x15 ), # AL=0xa0, AF=1 CF=1
    ( 0x01, 0x01 ), # AL=0xa1, AF=0 CF=0
    ( 0x01, 0x01 ), # AL=0xa1, AF=0 CF=1
    ( 0x07, 0x11 ), # AL=0xa1, AF=1 CF=0
    ( 0x07, 0x11 ), # AL=0xa1, AF=1 CF=1
    ( 0x02, 0x01 ), # AL=0xa2, AF=0 CF=0
    ( 0x02, 0x01 ), # AL=0xa2, AF=0 CF=1
    ( 0x08, 0x11 ), # AL=0xa2, AF=1 CF=0
    ( 0x08, 0x11 ), # AL=0xa2, AF=1 CF=1
    ( 0x03, 0x05 ), # AL=0xa3, AF=0 CF=0
    ( 0x03, 0x05 ), # AL=0xa3, AF=0 CF=1
    ( 0x09, 0x15 ), # AL=0xa3, AF=1 CF=0
    ( 0x09, 0x15 ), # AL=0xa3, AF=1 CF=1
    ( 0x04, 0x01 ), # AL=0xa4, AF=0 CF=0
    ( 0x04, 0x01 ), # AL=0xa4, AF=0 CF=1
    ( 0x0a, 0x15 ), # AL=0xa4, AF=1 CF=0
    ( 0x0a, 0x15 ), # AL=0xa4, AF=1 CF=1
    ( 0x05, 0x05 ), # AL=0xa5, AF=0 CF=0
    ( 0x05, 0x05 ), # AL=0xa5, AF=0 CF=1
    ( 0x0b, 0x11 ), # AL=0xa5, AF=1 CF=0
    ( 0x0b, 0x11 ), # AL=0xa5, AF=1 CF=1
    ( 0x06, 0x05 ), # AL=0xa6, AF=0 CF=0
    ( 0x06, 0x05 ), # AL=0xa6, AF=0 CF=1
    ( 0x0c, 0x15 ), # AL=0xa6, AF=1 CF=0
    ( 0x0c, 0x15 ), # AL=0xa6, AF=1 CF=1
    ( 0x07, 0x01 ), # AL=0xa7, AF=0 CF=0
    ( 0x07, 0x01 ), # AL=0xa7, AF=0 CF=1
    ( 0x0d, 0x11 ), # AL=0xa7, AF=1 CF=0
    ( 0x0d, 0x11 ), # AL=0xa7, AF=1 CF=1
    ( 0x08, 0x01 ), # AL=0xa8, AF=0 CF=0
    ( 0x08, 0x01 ), # AL=0xa8, AF=0 CF=1
    ( 0x0e, 0x11 ), # AL=0xa8, AF=1 CF=0
    ( 0x0e, 0x11 ), # AL=0xa8, AF=1 CF=1
    ( 0x09, 0x05 ), # AL=0xa9, AF=0 CF=0
    ( 0x09, 0x05 ), # AL=0xa9, AF=0 CF=1
    ( 0x0f, 0x15 ), # AL=0xa9, AF=1 CF=0
    ( 0x0f, 0x15 ), # AL=0xa9, AF=1 CF=1
    ( 0x10, 0x11 ), # AL=0xaa, AF=0 CF=0
    ( 0x10, 0x11 ), # AL=0xaa, AF=0 CF=1
    ( 0x10, 0x11 ), # AL=0xaa, AF=1 CF=0
    ( 0x10, 0x11 ), # AL=0xaa, AF=1 CF=1
    ( 0x11, 0x15 ), # AL=0xab, AF=0 CF=0
    ( 0x11, 0x15 ), # AL=0xab, AF=0 CF=1
    ( 0x11, 0x15 ), # AL=0xab, AF=1 CF=0
    ( 0x11, 0x15 ), # AL=0xab, AF=1 CF=1
    ( 0x12, 0x15 ), # AL=0xac, AF=0 CF=0
    ( 0x12, 0x15 ), # AL=0xac, AF=0 CF=1
    ( 0x12, 0x15 ), # AL=0xac, AF=1 CF=0
    ( 0x12, 0x15 ), # AL=0xac, AF=1 CF=1
    ( 0x13, 0x11 ), # AL=0xad, AF=0 CF=0
    ( 0x13, 0x11 ), # AL=0xad, AF=0 CF=1
    ( 0x13, 0x11 ), # AL=0xad, AF=1 CF=0
    ( 0x13, 0x11 ), # AL=0xad, AF=1 CF=1
    ( 0x14, 0x15 ), # AL=0xae, AF=0 CF=0
    ( 0x14, 0x15 ), # AL=0xae, AF=0 CF=1
    ( 0x14, 0x15 ), # AL=0xae, AF=1 CF=0
    ( 0x14, 0x15 ), # AL=0xae, AF=1 CF=1
    ( 0x15, 0x11 ), # AL=0xaf, AF=0 CF=0
    ( 0x15, 0x11 ), # AL=0xaf, AF=0 CF=1
    ( 0x15, 0x11 ), # AL=0xaf, AF=1 CF=0
    ( 0x15, 0x11 ), # AL=0xaf, AF=1 CF=1
    ( 0x10, 0x01 ), # AL=0xb0, AF=0 CF=0
    ( 0x10, 0x01 ), # AL=0xb0, AF=0 CF=1
    ( 0x16, 0x11 ), # AL=0xb0, AF=1 CF=0
    ( 0x16, 0x11 ), # AL=0xb0, AF=1 CF=1
    ( 0x11, 0x05 ), # AL=0xb1, AF=0 CF=0
    ( 0x11, 0x05 ), # AL=0xb1, AF=0 CF=1
    ( 0x17, 0x15 ), # AL=0xb1, AF=1 CF=0
    ( 0x17, 0x15 ), # AL=0xb1, AF=1 CF=1
    ( 0x12, 0x05 ), # AL=0xb2, AF=0 CF=0
    ( 0x12, 0x05 ), # AL=0xb2, AF=0 CF=1
    ( 0x18, 0x15 ), # AL=0xb2, AF=1 CF=0
    ( 0x18, 0x15 ), # AL=0xb2, AF=1 CF=1
    ( 0x13, 0x01 ), # AL=0xb3, AF=0 CF=0
    ( 0x13, 0x01 ), # AL=0xb3, AF=0 CF=1
    ( 0x19, 0x11 ), # AL=0xb3, AF=1 CF=0
    ( 0x19, 0x11 ), # AL=0xb3, AF=1 CF=1
    ( 0x14, 0x05 ), # AL=0xb4, AF=0 CF=0
    ( 0x14, 0x05 ), # AL=0xb4, AF=0 CF=1
    ( 0x1a, 0x11 ), # AL=0xb4, AF=1 CF=0
    ( 0x1a, 0x11 ), # AL=0xb4, AF=1 CF=1
    ( 0x15, 0x01 ), # AL=0xb5, AF=0 CF=0
    ( 0x15, 0x01 ), # AL=0xb5, AF=0 CF=1
    ( 0x1b, 0x15 ), # AL=0xb5, AF=1 CF=0
    ( 0x1b, 0x15 ), # AL=0xb5, AF=1 CF=1
    ( 0x16, 0x01 ), # AL=0xb6, AF=0 CF=0
    ( 0x16, 0x01 ), # AL=0xb6, AF=0 CF=1
    ( 0x1c, 0x11 ), # AL=0xb6, AF=1 CF=0
    ( 0x1c, 0x11 ), # AL=0xb6, AF=1 CF=1
    ( 0x17, 0x05 ), # AL=0xb7, AF=0 CF=0
    ( 0x17, 0x05 ), # AL=0xb7, AF=0 CF=1
    ( 0x1d, 0x15 ), # AL=0xb7, AF=1 CF=0
    ( 0x1d, 0x15 ), # AL=0xb7, AF=1 CF=1
    ( 0x18, 0x05 ), # AL=0xb8, AF=0 CF=0
    ( 0x18, 0x05 ), # AL=0xb8, AF=0 CF=1
    ( 0x1e, 0x15 ), # AL=0xb8, AF=1 CF=0
    ( 0x1e, 0x15 ), # AL=0xb8, AF=1 CF=1
    ( 0x19, 0x01 ), # AL=0xb9, AF=0 CF=0
    ( 0x19, 0x01 ), # AL=0xb9, AF=0 CF=1
    ( 0x1f, 0x11 ), # AL=0xb9, AF=1 CF=0
    ( 0x1f, 0x11 ), # AL=0xb9, AF=1 CF=1
    ( 0x20, 0x11 ), # AL=0xba, AF=0 CF=0
    ( 0x20, 0x11 ), # AL=0xba, AF=0 CF=1
    ( 0x20, 0x11 ), # AL=0xba, AF=1 CF=0
    ( 0x20, 0x11 ), # AL=0xba, AF=1 CF=1
    ( 0x21, 0x15 ), # AL=0xbb, AF=0 CF=0
    ( 0x21, 0x15 ), # AL=0xbb, AF=0 CF=1
    ( 0x21, 0x15 ), # AL=0xbb, AF=1 CF=0
    ( 0x21, 0x15 ), # AL=0xbb, AF=1 CF=1
    ( 0x22, 0x15 ), # AL=0xbc, AF=0 CF=0
    ( 0x22, 0x15 ), # AL=0xbc, AF=0 CF=1
    ( 0x22, 0x15 ), # AL=0xbc, AF=1 CF=0
    ( 0x22, 0x15 ), # AL=0xbc, AF=1 CF=1
    ( 0x23, 0x11 ), # AL=0xbd, AF=0 CF=0
    ( 0x23, 0x11 ), # AL=0xbd, AF=0 CF=1
    ( 0x23, 0x11 ), # AL=0xbd, AF=1 CF=0
    ( 0x23, 0x11 ), # AL=0xbd, AF=1 CF=1
    ( 0x24, 0x15 ), # AL=0xbe, AF=0 CF=0
    ( 0x24, 0x15 ), # AL=0xbe, AF=0 CF=1
    ( 0x24, 0x15 ), # AL=0xbe, AF=1 CF=0
    ( 0x24, 0x15 ), # AL=0xbe, AF=1 CF=1
    ( 0x25, 0x11 ), # AL=0xbf, AF=0 CF=0
    ( 0x25, 0x11 ), # AL=0xbf, AF=0 CF=1
    ( 0x25, 0x11 ), # AL=0xbf, AF=1 CF=0
    ( 0x25, 0x11 ), # AL=0xbf, AF=1 CF=1
    ( 0x20, 0x01 ), # AL=0xc0, AF=0 CF=0
    ( 0x20, 0x01 ), # AL=0xc0, AF=0 CF=1
    ( 0x26, 0x11 ), # AL=0xc0, AF=1 CF=0
    ( 0x26, 0x11 ), # AL=0xc0, AF=1 CF=1
    ( 0x21, 0x05 ), # AL=0xc1, AF=0 CF=0
    ( 0x21, 0x05 ), # AL=0xc1, AF=0 CF=1
    ( 0x27, 0x15 ), # AL=0xc1, AF=1 CF=0
    ( 0x27, 0x15 ), # AL=0xc1, AF=1 CF=1
    ( 0x22, 0x05 ), # AL=0xc2, AF=0 CF=0
    ( 0x22, 0x05 ), # AL=0xc2, AF=0 CF=1
    ( 0x28, 0x15 ), # AL=0xc2, AF=1 CF=0
    ( 0x28, 0x15 ), # AL=0xc2, AF=1 CF=1
    ( 0x23, 0x01 ), # AL=0xc3, AF=0 CF=0
    ( 0x23, 0x01 ), # AL=0xc3, AF=0 CF=1
    ( 0x29, 0x11 ), # AL=0xc3, AF=1 CF=0
    ( 0x29, 0x11 ), # AL=0xc3, AF=1 CF=1
    ( 0x24, 0x05 ), # AL=0xc4, AF=0 CF=0
    ( 0x24, 0x05 ), # AL=0xc4, AF=0 CF=1
    ( 0x2a, 0x11 ), # AL=0xc4, AF=1 CF=0
    ( 0x2a, 0x11 ), # AL=0xc4, AF=1 CF=1
    ( 0x25, 0x01 ), # AL=0xc5, AF=0 CF=0
    ( 0x25, 0x01 ), # AL=0xc5, AF=0 CF=1
    ( 0x2b, 0x15 ), # AL=0xc5, AF=1 CF=0
    ( 0x2b, 0x15 ), # AL=0xc5, AF=1 CF=1
    ( 0x26, 0x01 ), # AL=0xc6, AF=0 CF=0
    ( 0x26, 0x01 ), # AL=0xc6, AF=0 CF=1
    ( 0x2c, 0x11 ), # AL=0xc6, AF=1 CF=0
    ( 0x2c, 0x11 ), # AL=0xc6, AF=1 CF=1
    ( 0x27, 0x05 ), # AL=0xc7, AF=0 CF=0
    ( 0x27, 0x05 ), # AL=0xc7, AF=0 CF=1
    ( 0x2d, 0x15 ), # AL=0xc7, AF=1 CF=0
    ( 0x2d, 0x15 ), # AL=0xc7, AF=1 CF=1
    ( 0x28, 0x05 ), # AL=0xc8, AF=0 CF=0
    ( 0x28, 0x05 ), # AL=0xc8, AF=0 CF=1
    ( 0x2e, 0x15 ), # AL=0xc8, AF=1 CF=0
    ( 0x2e, 0x15 ), # AL=0xc8, AF=1 CF=1
    ( 0x29, 0x01 ), # AL=0xc9, AF=0 CF=0
    ( 0x29, 0x01 ), # AL=0xc9, AF=0 CF=1
    ( 0x2f, 0x11 ), # AL=0xc9, AF=1 CF=0
    ( 0x2f, 0x11 ), # AL=0xc9, AF=1 CF=1
    ( 0x30, 0x15 ), # AL=0xca, AF=0 CF=0
    ( 0x30, 0x15 ), # AL=0xca, AF=0 CF=1
    ( 0x30, 0x15 ), # AL=0xca, AF=1 CF=0
    ( 0x30, 0x15 ), # AL=0xca, AF=1 CF=1
    ( 0x31, 0x11 ), # AL=0xcb, AF=0 CF=0
    ( 0x31, 0x11 ), # AL=0xcb, AF=0 CF=1
    ( 0x31, 0x11 ), # AL=0xcb, AF=1 CF=0
    ( 0x31, 0x11 ), # AL=0xcb, AF=1 CF=1
    ( 0x32, 0x11 ), # AL=0xcc, AF=0 CF=0
    ( 0x32, 0x11 ), # AL=0xcc, AF=0 CF=1
    ( 0x32, 0x11 ), # AL=0xcc, AF=1 CF=0
    ( 0x32, 0x11 ), # AL=0xcc, AF=1 CF=1
    ( 0x33, 0x15 ), # AL=0xcd, AF=0 CF=0
    ( 0x33, 0x15 ), # AL=0xcd, AF=0 CF=1
    ( 0x33, 0x15 ), # AL=0xcd, AF=1 CF=0
    ( 0x33, 0x15 ), # AL=0xcd, AF=1 CF=1
    ( 0x34, 0x11 ), # AL=0xce, AF=0 CF=0
    ( 0x34, 0x11 ), # AL=0xce, AF=0 CF=1
    ( 0x34, 0x11 ), # AL=0xce, AF=1 CF=0
    ( 0x34, 0x11 ), # AL=0xce, AF=1 CF=1
    ( 0x35, 0x15 ), # AL=0xcf, AF=0 CF=0
    ( 0x35, 0x15 ), # AL=0xcf, AF=0 CF=1
    ( 0x35, 0x15 ), # AL=0xcf, AF=1 CF=0
    ( 0x35, 0x15 ), # AL=0xcf, AF=1 CF=1
    ( 0x30, 0x05 ), # AL=0xd0, AF=0 CF=0
    ( 0x30, 0x05 ), # AL=0xd0, AF=0 CF=1
    ( 0x36, 0x15 ), # AL=0xd0, AF=1 CF=0
    ( 0x36, 0x15 ), # AL=0xd0, AF=1 CF=1
    ( 0x31, 0x01 ), # AL=0xd1, AF=0 CF=0
    ( 0x31, 0x01 ), # AL=0xd1, AF=0 CF=1
    ( 0x37, 0x11 ), # AL=0xd1, AF=1 CF=0
    ( 0x37, 0x11 ), # AL=0xd1, AF=1 CF=1
    ( 0x32, 0x01 ), # AL=0xd2, AF=0 CF=0
    ( 0x32, 0x01 ), # AL=0xd2, AF=0 CF=1
    ( 0x38, 0x11 ), # AL=0xd2, AF=1 CF=0
    ( 0x38, 0x11 ), # AL=0xd2, AF=1 CF=1
    ( 0x33, 0x05 ), # AL=0xd3, AF=0 CF=0
    ( 0x33, 0x05 ), # AL=0xd3, AF=0 CF=1
    ( 0x39, 0x15 ), # AL=0xd3, AF=1 CF=0
    ( 0x39, 0x15 ), # AL=0xd3, AF=1 CF=1
    ( 0x34, 0x01 ), # AL=0xd4, AF=0 CF=0
    ( 0x34, 0x01 ), # AL=0xd4, AF=0 CF=1
    ( 0x3a, 0x15 ), # AL=0xd4, AF=1 CF=0
    ( 0x3a, 0x15 ), # AL=0xd4, AF=1 CF=1
    ( 0x35, 0x05 ), # AL=0xd5, AF=0 CF=0
    ( 0x35, 0x05 ), # AL=0xd5, AF=0 CF=1
    ( 0x3b, 0x11 ), # AL=0xd5, AF=1 CF=0
    ( 0x3b, 0x11 ), # AL=0xd5, AF=1 CF=1
    ( 0x36, 0x05 ), # AL=0xd6, AF=0 CF=0
    ( 0x36, 0x05 ), # AL=0xd6, AF=0 CF=1
    ( 0x3c, 0x15 ), # AL=0xd6, AF=1 CF=0
    ( 0x3c, 0x15 ), # AL=0xd6, AF=1 CF=1
    ( 0x37, 0x01 ), # AL=0xd7, AF=0 CF=0
    ( 0x37, 0x01 ), # AL=0xd7, AF=0 CF=1
    ( 0x3d, 0x11 ), # AL=0xd7, AF=1 CF=0
    ( 0x3d, 0x11 ), # AL=0xd7, AF=1 CF=1
    ( 0x38, 0x01 ), # AL=0xd8, AF=0 CF=0
    ( 0x38, 0x01 ), # AL=0xd8, AF=0 CF=1
    ( 0x3e, 0x11 ), # AL=0xd8, AF=1 CF=0
    ( 0x3e, 0x11 ), # AL=0xd8, AF=1 CF=1
    ( 0x39, 0x05 ), # AL=0xd9, AF=0 CF=0
    ( 0x39, 0x05 ), # AL=0xd9, AF=0 CF=1
    ( 0x3f, 0x15 ), # AL=0xd9, AF=1 CF=0
    ( 0x3f, 0x15 ), # AL=0xd9, AF=1 CF=1
    ( 0x40, 0x11 ), # AL=0xda, AF=0 CF=0
    ( 0x40, 0x11 ), # AL=0xda, AF=0 CF=1
    ( 0x40, 0x11 ), # AL=0xda, AF=1 CF=0
    ( 0x40, 0x11 ), # AL=0xda, AF=1 CF=1
    ( 0x41, 0x15 ), # AL=0xdb, AF=0 CF=0
    ( 0x41, 0x15 ), # AL=0xdb, AF=0 CF=1
    ( 0x41, 0x15 ), # AL=0xdb, AF=1 CF=0
    ( 0x41, 0x15 ), # AL=0xdb, AF=1 CF=1
    ( 0x42, 0x15 ), # AL=0xdc, AF=0 CF=0
    ( 0x42, 0x15 ), # AL=0xdc, AF=0 CF=1
    ( 0x42, 0x15 ), # AL=0xdc, AF=1 CF=0
    ( 0x42, 0x15 ), # AL=0xdc, AF=1 CF=1
    ( 0x43, 0x11 ), # AL=0xdd, AF=0 CF=0
    ( 0x43, 0x11 ), # AL=0xdd, AF=0 CF=1
    ( 0x43, 0x11 ), # AL=0xdd, AF=1 CF=0
    ( 0x43, 0x11 ), # AL=0xdd, AF=1 CF=1
    ( 0x44, 0x15 ), # AL=0xde, AF=0 CF=0
    ( 0x44, 0x15 ), # AL=0xde, AF=0 CF=1
    ( 0x44, 0x15 ), # AL=0xde, AF=1 CF=0
    ( 0x44, 0x15 ), # AL=0xde, AF=1 CF=1
    ( 0x45, 0x11 ), # AL=0xdf, AF=0 CF=0
    ( 0x45, 0x11 ), # AL=0xdf, AF=0 CF=1
    ( 0x45, 0x11 ), # AL=0xdf, AF=1 CF=0
    ( 0x45, 0x11 ), # AL=0xdf, AF=1 CF=1
    ( 0x40, 0x01 ), # AL=0xe0, AF=0 CF=0
    ( 0x40, 0x01 ), # AL=0xe0, AF=0 CF=1
    ( 0x46, 0x11 ), # AL=0xe0, AF=1 CF=0
    ( 0x46, 0x11 ), # AL=0xe0, AF=1 CF=1
    ( 0x41, 0x05 ), # AL=0xe1, AF=0 CF=0
    ( 0x41, 0x05 ), # AL=0xe1, AF=0 CF=1
    ( 0x47, 0x15 ), # AL=0xe1, AF=1 CF=0
    ( 0x47, 0x15 ), # AL=0xe1, AF=1 CF=1
    ( 0x42, 0x05 ), # AL=0xe2, AF=0 CF=0
    ( 0x42, 0x05 ), # AL=0xe2, AF=0 CF=1
    ( 0x48, 0x15 ), # AL=0xe2, AF=1 CF=0
    ( 0x48, 0x15 ), # AL=0xe2, AF=1 CF=1
    ( 0x43, 0x01 ), # AL=0xe3, AF=0 CF=0
    ( 0x43, 0x01 ), # AL=0xe3, AF=0 CF=1
    ( 0x49, 0x11 ), # AL=0xe3, AF=1 CF=0
    ( 0x49, 0x11 ), # AL=0xe3, AF=1 CF=1
    ( 0x44, 0x05 ), # AL=0xe4, AF=0 CF=0
    ( 0x44, 0x05 ), # AL=0xe4, AF=0 CF=1
    ( 0x4a, 0x11 ), # AL=0xe4, AF=1 CF=0
    ( 0x4a, 0x11 ), # AL=0xe4, AF=1 CF=1
    ( 0x45, 0x01 ), # AL=0xe5, AF=0 CF=0
    ( 0x45, 0x01 ), # AL=0xe5, AF=0 CF=1
    ( 0x4b, 0x15 ), # AL=0xe5, AF=1 CF=0
    ( 0x4b, 0x15 ), # AL=0xe5, AF=1 CF=1
    ( 0x46, 0x01 ), # AL=0xe6, AF=0 CF=0
    ( 0x46, 0x01 ), # AL=0xe6, AF=0 CF=1
    ( 0x4c, 0x11 ), # AL=0xe6, AF=1 CF=0
    ( 0x4c, 0x11 ), # AL=0xe6, AF=1 CF=1
    ( 0x47, 0x05 ), # AL=0xe7, AF=0 CF=0
    ( 0x47, 0x05 ), # AL=0xe7, AF=0 CF=1
    ( 0x4d, 0x15 ), # AL=0xe7, AF=1 CF=0
    ( 0x4d, 0x15 ), # AL=0xe7, AF=1 CF=1
    ( 0x48, 0x05 ), # AL=0xe8, AF=0 CF=0
    ( 0x48, 0x05 ), # AL=0xe8, AF=0 CF=1
    ( 0x4e, 0x15 ), # AL=0xe8, AF=1 CF=0
    ( 0x4e, 0x15 ), # AL=0xe8, AF=1 CF=1
    ( 0x49, 0x01 ), # AL=0xe9, AF=0 CF=0
    ( 0x49, 0x01 ), # AL=0xe9, AF=0 CF=1
    ( 0x4f, 0x11 ), # AL=0xe9, AF=1 CF=0
    ( 0x4f, 0x11 ), # AL=0xe9, AF=1 CF=1
    ( 0x50, 0x15 ), # AL=0xea, AF=0 CF=0
    ( 0x50, 0x15 ), # AL=0xea, AF=0 CF=1
    ( 0x50, 0x15 ), # AL=0xea, AF=1 CF=0
    ( 0x50, 0x15 ), # AL=0xea, AF=1 CF=1
    ( 0x51, 0x11 ), # AL=0xeb, AF=0 CF=0
    ( 0x51, 0x11 ), # AL=0xeb, AF=0 CF=1
    ( 0x51, 0x11 ), # AL=0xeb, AF=1 CF=0
    ( 0x51, 0x11 ), # AL=0xeb, AF=1 CF=1
    ( 0x52, 0x11 ), # AL=0xec, AF=0 CF=0
    ( 0x52, 0x11 ), # AL=0xec, AF=0 CF=1
    ( 0x52, 0x11 ), # AL=0xec, AF=1 CF=0
    ( 0x52, 0x11 ), # AL=0xec, AF=1 CF=1
    ( 0x53, 0x15 ), # AL=0xed, AF=0 CF=0
    ( 0x53, 0x15 ), # AL=0xed, AF=0 CF=1
    ( 0x53, 0x15 ), # AL=0xed, AF=1 CF=0
    ( 0x53, 0x15 ), # AL=0xed, AF=1 CF=1
    ( 0x54, 0x11 ), # AL=0xee, AF=0 CF=0
    ( 0x54, 0x11 ), # AL=0xee, AF=0 CF=1
    ( 0x54, 0x11 ), # AL=0xee, AF=1 CF=0
    ( 0x54, 0x11 ), # AL=0xee, AF=1 CF=1
    ( 0x55, 0x15 ), # AL=0xef, AF=0 CF=0
    ( 0x55, 0x15 ), # AL=0xef, AF=0 CF=1
    ( 0x55, 0x15 ), # AL=0xef, AF=1 CF=0
    ( 0x55, 0x15 ), # AL=0xef, AF=1 CF=1
    ( 0x50, 0x05 ), # AL=0xf0, AF=0 CF=0
    ( 0x50, 0x05 ), # AL=0xf0, AF=0 CF=1
    ( 0x56, 0x15 ), # AL=0xf0, AF=1 CF=0
    ( 0x56, 0x15 ), # AL=0xf0, AF=1 CF=1
    ( 0x51, 0x01 ), # AL=0xf1, AF=0 CF=0
    ( 0x51, 0x01 ), # AL=0xf1, AF=0 CF=1
    ( 0x57, 0x11 ), # AL=0xf1, AF=1 CF=0
    ( 0x57, 0x11 ), # AL=0xf1, AF=1 CF=1
    ( 0x52, 0x01 ), # AL=0xf2, AF=0 CF=0
    ( 0x52, 0x01 ), # AL=0xf2, AF=0 CF=1
    ( 0x58, 0x11 ), # AL=0xf2, AF=1 CF=0
    ( 0x58, 0x11 ), # AL=0xf2, AF=1 CF=1
    ( 0x53, 0x05 ), # AL=0xf3, AF=0 CF=0
    ( 0x53, 0x05 ), # AL=0xf3, AF=0 CF=1
    ( 0x59, 0x15 ), # AL=0xf3, AF=1 CF=0
    ( 0x59, 0x15 ), # AL=0xf3, AF=1 CF=1
    ( 0x54, 0x01 ), # AL=0xf4, AF=0 CF=0
    ( 0x54, 0x01 ), # AL=0xf4, AF=0 CF=1
    ( 0x5a, 0x15 ), # AL=0xf4, AF=1 CF=0
    ( 0x5a, 0x15 ), # AL=0xf4, AF=1 CF=1
    ( 0x55, 0x05 ), # AL=0xf5, AF=0 CF=0
    ( 0x55, 0x05 ), # AL=0xf5, AF=0 CF=1
    ( 0x5b, 0x11 ), # AL=0xf5, AF=1 CF=0
    ( 0x5b, 0x11 ), # AL=0xf5, AF=1 CF=1
    ( 0x56, 0x05 ), # AL=0xf6, AF=0 CF=0
    ( 0x56, 0x05 ), # AL=0xf6, AF=0 CF=1
    ( 0x5c, 0x15 ), # AL=0xf6, AF=1 CF=0
    ( 0x5c, 0x15 ), # AL=0xf6, AF=1 CF=1
    ( 0x57, 0x01 ), # AL=0xf7, AF=0 CF=0
    ( 0x57, 0x01 ), # AL=0xf7, AF=0 CF=1
    ( 0x5d, 0x11 ), # AL=0xf7, AF=1 CF=0
    ( 0x5d, 0x11 ), # AL=0xf7, AF=1 CF=1
    ( 0x58, 0x01 ), # AL=0xf8, AF=0 CF=0
    ( 0x58, 0x01 ), # AL=0xf8, AF=0 CF=1
    ( 0x5e, 0x11 ), # AL=0xf8, AF=1 CF=0
    ( 0x5e, 0x11 ), # AL=0xf8, AF=1 CF=1
    ( 0x59, 0x05 ), # AL=0xf9, AF=0 CF=0
    ( 0x59, 0x05 ), # AL=0xf9, AF=0 CF=1
    ( 0x5f, 0x15 ), # AL=0xf9, AF=1 CF=0
    ( 0x5f, 0x15 ), # AL=0xf9, AF=1 CF=1
    ( 0x60, 0x15 ), # AL=0xfa, AF=0 CF=0
    ( 0x60, 0x15 ), # AL=0xfa, AF=0 CF=1
    ( 0x60, 0x15 ), # AL=0xfa, AF=1 CF=0
    ( 0x60, 0x15 ), # AL=0xfa, AF=1 CF=1
    ( 0x61, 0x11 ), # AL=0xfb, AF=0 CF=0
    ( 0x61, 0x11 ), # AL=0xfb, AF=0 CF=1
    ( 0x61, 0x11 ), # AL=0xfb, AF=1 CF=0
    ( 0x61, 0x11 ), # AL=0xfb, AF=1 CF=1
    ( 0x62, 0x11 ), # AL=0xfc, AF=0 CF=0
    ( 0x62, 0x11 ), # AL=0xfc, AF=0 CF=1
    ( 0x62, 0x11 ), # AL=0xfc, AF=1 CF=0
    ( 0x62, 0x11 ), # AL=0xfc, AF=1 CF=1
    ( 0x63, 0x15 ), # AL=0xfd, AF=0 CF=0
    ( 0x63, 0x15 ), # AL=0xfd, AF=0 CF=1
    ( 0x63, 0x15 ), # AL=0xfd, AF=1 CF=0
    ( 0x63, 0x15 ), # AL=0xfd, AF=1 CF=1
    ( 0x64, 0x11 ), # AL=0xfe, AF=0 CF=0
    ( 0x64, 0x11 ), # AL=0xfe, AF=0 CF=1
    ( 0x64, 0x11 ), # AL=0xfe, AF=1 CF=0
    ( 0x64, 0x11 ), # AL=0xfe, AF=1 CF=1
    ( 0x65, 0x15 ), # AL=0xff, AF=0 CF=0
    ( 0x65, 0x15 ), # AL=0xff, AF=0 CF=1
    ( 0x65, 0x15 ), # AL=0xff, AF=1 CF=0
    ( 0x65, 0x15 ), # AL=0xff, AF=1 CF=1
];

