/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.IOException;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.StandardErrorHandler;
import net.sf.saxon.event.DocumentSender;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.NamePoolConverter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.om.AllElementStripper;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.PullPushCopier;
import net.sf.saxon.pull.PullSource;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class Sender {
    PipelineConfiguration pipe;

    public Sender(PipelineConfiguration pipe) {
        this.pipe = pipe;
    }

    public void send(Source source, Receiver receiver) throws XPathException {
        this.send(source, receiver, false);
    }

    public void send(Source source, Receiver receiver, boolean isFinal) throws XPathException {
        Source newSource;
        Controller controller;
        int dtdValidation;
        Configuration config = this.pipe.getConfiguration();
        receiver.setPipelineConfiguration(this.pipe);
        receiver.setSystemId(source.getSystemId());
        Receiver next = receiver;
        int stripSpace = 3;
        boolean xInclude = config.isXIncludeAware();
        int schemaValidation = config.getSchemaValidationMode();
        int topLevelNameCode = -1;
        int n = dtdValidation = config.isValidation() ? 1 : 4;
        if (isFinal) {
            schemaValidation |= 0x10000;
        }
        XMLReader parser = null;
        SchemaType topLevelType = null;
        if (source instanceof AugmentedSource) {
            stripSpace = ((AugmentedSource)source).getStripSpace();
        }
        if (stripSpace == 3) {
            stripSpace = config.getStripsWhiteSpace();
        }
        if (stripSpace == 2) {
            AllElementStripper s = new AllElementStripper();
            s.setStripAll();
            s.setPipelineConfiguration(this.pipe);
            s.setUnderlyingReceiver(receiver);
            next = s;
        } else if (stripSpace == 4 && (controller = this.pipe.getController()) != null) {
            next = controller.makeStripper(next);
        }
        if (source instanceof AugmentedSource) {
            int localDTDValidate;
            xInclude = ((AugmentedSource)source).isXIncludeAwareSet() ? ((AugmentedSource)source).isXIncludeAware() : config.isXIncludeAware();
            int localValidate = ((AugmentedSource)source).getSchemaValidation();
            if (localValidate != 0) {
                schemaValidation = localValidate;
            }
            topLevelType = ((AugmentedSource)source).getTopLevelType();
            StructuredQName topLevelName = ((AugmentedSource)source).getTopLevelElement();
            if (topLevelName != null) {
                topLevelNameCode = config.getNamePool().allocate(topLevelName.getPrefix(), topLevelName.getNamespaceURI(), topLevelName.getLocalName());
            }
            if ((localDTDValidate = ((AugmentedSource)source).getDTDValidation()) != 0) {
                dtdValidation = localDTDValidate;
            }
            parser = ((AugmentedSource)source).getXMLReader();
            List filters = ((AugmentedSource)source).getFilters();
            if (filters != null) {
                for (int i = filters.size() - 1; i >= 0; --i) {
                    ProxyReceiver filter = (ProxyReceiver)filters.get(i);
                    filter.setPipelineConfiguration(this.pipe);
                    filter.setSystemId(source.getSystemId());
                    filter.setUnderlyingReceiver(next);
                    next = filter;
                }
            }
            source = ((AugmentedSource)source).getContainedSource();
        }
        if (source instanceof NodeInfo) {
            int kind;
            NodeInfo ns = (NodeInfo)source;
            String baseURI = ns.getBaseURI();
            int val = schemaValidation & 0xFF;
            if (val != 3) {
                next = config.getDocumentValidator(next, baseURI, val, stripSpace, topLevelType, topLevelNameCode);
            }
            if ((kind = ns.getNodeKind()) != 9 && kind != 1) {
                throw new IllegalArgumentException("Sender can only handle document or element nodes");
            }
            next.setSystemId(baseURI);
            this.sendDocumentInfo(ns, next);
            return;
        }
        if (source instanceof PullSource) {
            if (xInclude) {
                throw new XPathException("XInclude processing is not supported with a pull parser");
            }
            this.sendPullSource((PullSource)source, next, schemaValidation, stripSpace);
            return;
        }
        if (source instanceof SAXSource) {
            this.sendSAXSource((SAXSource)source, next, schemaValidation, topLevelNameCode, stripSpace, xInclude, topLevelType);
            return;
        }
        if (source instanceof StreamSource) {
            StreamSource ss = (StreamSource)source;
            Source ps = Configuration.getPlatform().getParserSource(config, ss, schemaValidation, dtdValidation == 1, stripSpace);
            if (ps == ss) {
                String url = source.getSystemId();
                InputSource is = new InputSource(url);
                is.setCharacterStream(ss.getReader());
                is.setByteStream(ss.getInputStream());
                boolean reuseParser = false;
                if (parser == null) {
                    parser = config.getSourceParser();
                    reuseParser = true;
                }
                SAXSource sax = new SAXSource(parser, is);
                sax.setSystemId(source.getSystemId());
                this.sendSAXSource(sax, next, schemaValidation, topLevelNameCode, stripSpace, xInclude, topLevelType);
                if (reuseParser) {
                    config.reuseSourceParser(parser);
                }
            } else {
                this.send(ps, next, isFinal);
            }
            return;
        }
        if ((schemaValidation & 0xFF) != 3) {
            next = config.getDocumentValidator(next, source.getSystemId(), schemaValidation, stripSpace, topLevelType, topLevelNameCode);
        }
        if ((newSource = config.getSourceResolver().resolveSource(source, config)) instanceof StreamSource || newSource instanceof SAXSource || newSource instanceof NodeInfo || newSource instanceof PullSource || newSource instanceof AugmentedSource) {
            this.send(newSource, next, isFinal);
        }
        List externalObjectModels = config.getExternalObjectModels();
        for (int m = 0; m < externalObjectModels.size(); ++m) {
            ExternalObjectModel model = (ExternalObjectModel)externalObjectModels.get(m);
            boolean done = model.sendSource(source, next, this.pipe);
            if (!done) continue;
            return;
        }
        if (source instanceof DOMSource) {
            throw new XPathException("DOMSource cannot be processed: check that saxon9-dom.jar is on the classpath");
        }
        throw new XPathException("A source of type " + source.getClass().getName() + " is not supported in this environment");
    }

    private void sendDocumentInfo(NodeInfo top, Receiver receiver) throws XPathException {
        NamePool targetNamePool = this.pipe.getConfiguration().getNamePool();
        if (top.getNamePool() != targetNamePool) {
            NamePoolConverter converter = new NamePoolConverter(top.getNamePool(), targetNamePool);
            converter.setUnderlyingReceiver(receiver);
            converter.setPipelineConfiguration(receiver.getPipelineConfiguration());
            receiver = converter;
        }
        DocumentSender sender = new DocumentSender(top);
        sender.send(receiver);
    }

    private void sendSAXSource(SAXSource source, Receiver receiver, int validation, int topLevelElement, int stripSpace, boolean xInclude, SchemaType topLevelType) throws XPathException {
        ReceivingContentHandler ce;
        ContentHandler ch;
        XMLReader parser = source.getXMLReader();
        boolean reuseParser = false;
        Configuration config = this.pipe.getConfiguration();
        if (parser == null) {
            SAXSource ss = new SAXSource();
            ss.setInputSource(source.getInputSource());
            ss.setSystemId(source.getSystemId());
            parser = config.getSourceParser();
            ss.setXMLReader(parser);
            source = ss;
            reuseParser = true;
        } else {
            Sender.configureParser(parser);
        }
        if (!this.pipe.isExpandAttributeDefaults()) {
            try {
                parser.setFeature("http://xml.org/sax/features/use-attributes2", true);
            }
            catch (SAXNotRecognizedException err) {
            }
            catch (SAXNotSupportedException err) {
                // empty catch block
            }
        }
        if (xInclude) {
            boolean tryAgain = false;
            try {
                parser.setFeature("http://apache.org/xml/features/xinclude-aware", true);
            }
            catch (SAXNotRecognizedException err) {
                tryAgain = true;
            }
            catch (SAXNotSupportedException err) {
                tryAgain = true;
            }
            if (tryAgain) {
                try {
                    parser.setFeature("http://apache.org/xml/features/xinclude", true);
                }
                catch (SAXNotRecognizedException err) {
                    throw new XPathException("Selected XML parser " + parser.getClass().getName() + " does not recognize request for XInclude processing");
                }
                catch (SAXNotSupportedException err) {
                    throw new XPathException("Selected XML parser " + parser.getClass().getName() + " does not support XInclude processing");
                }
            }
        }
        parser.setErrorHandler(new StandardErrorHandler(this.pipe.getErrorListener()));
        if ((validation & 0xFF) != 3) {
            receiver = config.getDocumentValidator(receiver, source.getSystemId(), validation, stripSpace, topLevelType, topLevelElement);
        }
        if ((ch = parser.getContentHandler()) instanceof ReceivingContentHandler) {
            ce = (ReceivingContentHandler)ch;
            ce.reset();
        } else {
            ce = new ReceivingContentHandler();
            parser.setContentHandler(ce);
            parser.setDTDHandler(ce);
            try {
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", ce);
            }
            catch (SAXNotSupportedException err) {
            }
            catch (SAXNotRecognizedException err) {
                // empty catch block
            }
        }
        ce.setReceiver(receiver);
        ce.setPipelineConfiguration(this.pipe);
        try {
            parser.parse(source.getInputSource());
        }
        catch (SAXException err) {
            Exception nested = err.getException();
            if (nested instanceof XPathException) {
                throw (XPathException)nested;
            }
            if (nested instanceof RuntimeException) {
                throw (RuntimeException)nested;
            }
            XPathException de = new XPathException(err);
            de.setHasBeenReported();
            throw de;
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
        if (reuseParser) {
            config.reuseSourceParser(parser);
        }
    }

    private void sendPullSource(PullSource source, Receiver receiver, int validation, int stripSpace) throws XPathException {
        PullProvider provider;
        if ((validation & 0xFF) != 3) {
            Configuration config = this.pipe.getConfiguration();
            receiver = config.getDocumentValidator(receiver, source.getSystemId(), validation, stripSpace, null, -1);
        }
        if ((provider = source.getPullProvider()) instanceof LocationProvider) {
            this.pipe.setLocationProvider((LocationProvider)((Object)provider));
        }
        provider.setPipelineConfiguration(this.pipe);
        receiver.setPipelineConfiguration(this.pipe);
        PullPushCopier copier = new PullPushCopier(provider, receiver);
        copier.copy();
    }

    public static void configureParser(XMLReader parser) throws XPathException {
        try {
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (SAXNotSupportedException err) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not recognize the 'namespaces' feature");
        }
        catch (SAXNotRecognizedException err) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not support setting the 'namespaces' feature to true");
        }
        try {
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotSupportedException err) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not recognize the 'namespace-prefixes' feature");
        }
        catch (SAXNotRecognizedException err) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not support setting the 'namespace-prefixes' feature to false");
        }
    }
}

