#
# PySNMP MIB module NHRP-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/NHRP-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:22:48 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( Integer, OctetString, ObjectIdentifier, ) = mibBuilder.importSymbols("ASN1", "Integer", "OctetString", "ObjectIdentifier")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, SingleValueConstraint, ValueRangeConstraint, ConstraintsUnion, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "SingleValueConstraint", "ValueRangeConstraint", "ConstraintsUnion", "ValueSizeConstraint")
( AddressFamilyNumbers, ) = mibBuilder.importSymbols("IANA-ADDRESS-FAMILY-NUMBERS-MIB", "AddressFamilyNumbers")
( ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "ifIndex")
( ModuleCompliance, ObjectGroup, NotificationGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup", "NotificationGroup")
( Unsigned32, NotificationType, MibScalar, MibTable, MibTableRow, MibTableColumn, ObjectIdentity, IpAddress, Counter32, Integer32, Counter64, TimeTicks, ModuleIdentity, Bits, Gauge32, mib_2, iso, MibIdentifier, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Unsigned32", "NotificationType", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "ObjectIdentity", "IpAddress", "Counter32", "Integer32", "Counter64", "TimeTicks", "ModuleIdentity", "Bits", "Gauge32", "mib-2", "iso", "MibIdentifier")
( DisplayString, StorageType, TimeStamp, TextualConvention, TruthValue, RowStatus, ) = mibBuilder.importSymbols("SNMPv2-TC", "DisplayString", "StorageType", "TimeStamp", "TextualConvention", "TruthValue", "RowStatus")
nhrpMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 71)).setRevisions(("1999-08-26 00:00",))
if mibBuilder.loadTexts: nhrpMIB.setLastUpdated('9908260000Z')
if mibBuilder.loadTexts: nhrpMIB.setOrganization('Internetworking Over NBMA (ion) Working Group')
if mibBuilder.loadTexts: nhrpMIB.setContactInfo('Maria Greene (maria@xedia.com)\n            Contractor\n\n            Joan Cucchiara (joan@ironbridgenetworks.com)\n            IronBridge Networks\n\n            James V. Luciani (luciani@baynetworks.com)\n            Bay Networks')
if mibBuilder.loadTexts: nhrpMIB.setDescription('This MIB contains managed object definitions for the Next\n           Hop Resolution Procol, NHRP, as defined in RFC 2332 [17].')
class NhrpGenAddr(OctetString, TextualConvention):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,64)

nhrpObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 71, 1))
nhrpGeneralObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 71, 1, 1))
nhrpNextIndex = MibScalar((1, 3, 6, 1, 2, 1, 71, 1, 1, 1), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpNextIndex.setDescription("This scalar is used for creating rows in the\n            nhrpClientTable and the nhrpServerTable.\n            The value of this variable is a currently unused value\n            for nhrpClientIndex and nhrpServerIndex.\n            The value returned when reading this variable must be\n            unique for the NHC's and NHS's indices associated with\n            this row. Subsequent attempts to read this variable\n            must return different values.\n\n            NOTE:  this object exists in the General Group because\n            it is to be used in establishing rows in the\n            nhrpClientTable and the nhrpServerTable.  In other words,\n            the value retrieved from this object could become the\n            value of nhrpClientIndex and nhprServerIndex.\n\n            In the situation of an agent re-initialization the value\n            of this object must be saved in non-volatile storage.\n\n            This variable will return the special value 0 if no new\n            rows can be created.")
nhrpCacheTable = MibTable((1, 3, 6, 1, 2, 1, 71, 1, 1, 2), )
if mibBuilder.loadTexts: nhrpCacheTable.setDescription('This table contains mappings between internetwork layer\n           addresses and NBMA subnetwork layer addresses.')
nhrpCacheEntry = MibTableRow((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1), ).setIndexNames((0, "NHRP-MIB", "nhrpCacheInternetworkAddrType"), (0, "NHRP-MIB", "nhrpCacheInternetworkAddr"), (0, "IF-MIB", "ifIndex"), (0, "NHRP-MIB", "nhrpCacheIndex"))
if mibBuilder.loadTexts: nhrpCacheEntry.setDescription('A cached mapping between an internetwork layer address\n           and an NBMA address. Entries can be created by the\n           network administrator using the nhrpCacheRowStatus\n           column, or they may be added dynamically based on\n           protocol operation (including NHRP, SCSP, and others,\n           such as ATMARP).\n\n           When created based by NHRP protocol operations\n           this entry is largely based on contents contained in\n           the Client Information Entry (CIE).\n           Zero or more Client Information Entries (CIEs) may be\n           included in the NHRP Packet. For a complete description\n           of the CIE, refer to Section 5.2.0.1 of\n           RFC 2332 [17].')
nhrpCacheInternetworkAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 1), AddressFamilyNumbers())
if mibBuilder.loadTexts: nhrpCacheInternetworkAddrType.setDescription('The internetwork layer address type of this Next Hop\n           Resolution Cache entry. The value of this object indicates\n           how to interpret the values of nhrpCacheInternetworkAddr\n           and nhrpCacheNextHopInternetworkAddr.')
nhrpCacheInternetworkAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 2), NhrpGenAddr())
if mibBuilder.loadTexts: nhrpCacheInternetworkAddr.setDescription('The value of the internetwork address of the\n           destination.')
nhrpCacheIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: nhrpCacheIndex.setDescription("An identifier for this entry that has local\n           significance within the scope of the General\n           Group.  This identifier is used here to\n           uniquely identify this row, and also used\n           in the 'nhrpPurgeTable' for the value of\n           the 'nhrpPurgeCacheIdentifier'.")
nhrpCachePrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpCachePrefixLength.setDescription('The number of bits that define the internetwork layer\n           prefix associated with the nhrpCacheInternetworkAddr.')
nhrpCacheNextHopInternetworkAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 5), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpCacheNextHopInternetworkAddr.setDescription('The value of the internetwork address of the next hop.')
nhrpCacheNbmaAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 6), AddressFamilyNumbers()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpCacheNbmaAddrType.setDescription('The NBMA address type. The value of this\n           object indicates how to interpret\n           the values of nhrpCacheNbmaAddr and\n           nhrpCacheNbmaSubaddr.')
nhrpCacheNbmaAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 7), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpCacheNbmaAddr.setDescription('The value of the NBMA subnetwork address of the next\n           hop.')
nhrpCacheNbmaSubaddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 8), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpCacheNbmaSubaddr.setDescription('The value of the NBMA subaddress of the next hop. If\n           there is no subaddress concept for the NBMA address\n           family, this value will be a zero-length OCTET STRING.')
nhrpCacheType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 9), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8,))).clone(namedValues=NamedValues(("other", 1), ("register", 2), ("resolveAuthoritative", 3), ("resoveNonauthoritative", 4), ("transit", 5), ("administrativelyAdded", 6), ("atmarp", 7), ("scsp", 8),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpCacheType.setDescription("An indication of how this cache entry\n           was created. The values are:\n\n           'other(1)'                   The entry was added by some\n                                        other means.\n\n           'register(2)'                In a server, added based on a\n                                        client registration.\n\n           'resolveAuthoritative(3)'    In a client, added based on\n                                        receiving an Authoritative\n                                        NHRP Resolution Reply.\n\n           'resolveNonauthoritative(4)' In a client, added based on\n                                        receiving a Nonauthoritative\n                                        NHRP Resolution Reply.\n\n           'transit(5)'                 In a transit server, added by\n                                        examining a forwarded NHRP\n                                        packet.\n\n           'administrativelyAdded(6)'   In a client or server,\n                                        manually added by the\n                                        administrator. The\n                                        StorageType of this entry is\n                                        reflected in\n                                        'nhrpCacheStorageType'.\n\n           'atmarp(7)'                  The entry was added due to an\n                                        ATMARP.\n\n           'scsp(8)'                    The entry was added due to\n                                        SCSP.\n\n\n           When the entry is under creation using the\n           nhrpCacheRowStatus column, the only value that can be\n           specified by the administrator is 'administrativelyAdded'.\n           Attempting to set any other value will cause an\n           'inconsistentValue' error.\n\n           The value cannot be modified once the entry is active.")
nhrpCacheState = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 10), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("incomplete", 1), ("ackReply", 2), ("nakReply", 3),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpCacheState.setDescription("An indication of the state of this entry. The values are:\n\n               'incomplete(1)' The client has sent a NHRP Resolution\n                               Request but has not yet received the\n                               NHRP Resolution Reply.\n\n               'ackReply(2)'   For a client or server, this is a\n                               cached valid mapping.\n\n               'nakReply(3)'   For a client or server, this is a\n                               cached NAK mapping.")
nhrpCacheHoldingTimeValid = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 11), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpCacheHoldingTimeValid.setDescription("True(1) is returned if the value of\n           'nhrpCacheType' is not\n           'administrativelyAdded'.  Since the\n           value of 'nhrpCacheType' was not\n           configured by a user, the value of\n           'nhrpCacheHoldingTime' is\n           considered valid.  In other words, the value of\n           'nhrpCacheHoldingTime' represents\n           the Holding Time for the cache Entry.\n\n           If 'nhrpCacheType has been configured by a\n           user, (i.e. the value of 'nhrpCacheType' is\n           'administrativelyAdded') then false(2) will be returned.\n           This indicates that the value of\n           'nhrpCacheHoldingTime' is undefined because this row\n           could possibly be backed up in nonvolatile storage.")
nhrpCacheHoldingTime = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 12), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setUnits('seconds').setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpCacheHoldingTime.setDescription("If the value of 'nhrpCacheHoldingTimeValid is\n           true(1) then this object represents the number\n           of seconds that the cache entry will remain in this\n           table.  When this value reaches 0 (zero) the row should\n           be deleted.\n\n           If the value of 'nhrpCacheHoldingTimeValid is\n           false(2) then this object is undefined.")
nhrpCacheNegotiatedMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 13), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpCacheNegotiatedMtu.setDescription('The maximum transmission unit (MTU) that was negotiated\n           or registered for this entity. In other words, this is the\n           actual MTU being used.')
nhrpCachePreference = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 14), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpCachePreference.setDescription('An object which reflects the Preference value of the\n           Client Information Entry (CIE).\n\n           Zero or more Client Information Entries (CIEs) may be\n           included in the NHRP Packet.  One of the fields in the\n           CIE is the Preference.  For a complete description of\n           the CIE, refer to Section 5.2.0.1 of  RFC 2332 [17].')
nhrpCacheStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 15), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpCacheStorageType.setDescription("This value only has meaning when the 'nhrpCacheType'\n           has the value of 'administrativelyAdded'.\n\n           When the row is created due to being\n           'administrativelyAdded', this object reflects whether\n           this row is kept in volatile storage\n           and lost upon reboot or if this row is backed up by\n           non-volatile or permanent storage.\n\n           If the value of 'nhrpCacheType' has a value which\n           is not 'administrativelyAdded, then the value of this\n           object is 'other(1)'.")
nhrpCacheRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 2, 1, 16), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpCacheRowStatus.setDescription('An object that allows entries in this table to be\n           created and deleted using the RowStatus convention.')
nhrpPurgeReqTable = MibTable((1, 3, 6, 1, 2, 1, 71, 1, 1, 3), )
if mibBuilder.loadTexts: nhrpPurgeReqTable.setDescription('This table will track Purge Request Information.')
nhrpPurgeReqEntry = MibTableRow((1, 3, 6, 1, 2, 1, 71, 1, 1, 3, 1), ).setIndexNames((0, "NHRP-MIB", "nhrpPurgeIndex"))
if mibBuilder.loadTexts: nhrpPurgeReqEntry.setDescription('Information regarding a Purge Request.')
nhrpPurgeIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 3, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: nhrpPurgeIndex.setDescription('An index for this entry that has local significance\n           within the scope of this table.')
nhrpPurgeCacheIdentifier = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 3, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpPurgeCacheIdentifier.setDescription("This object identifies which row in\n           'nhrpCacheTable' is being purged.  This object\n           should have the same value as the 'nhrpCacheIndex'\n           in the 'nhrpCacheTable'.")
nhrpPurgePrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 3, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpPurgePrefixLength.setDescription("In the case of NHRP Purge Requests, this specifies the\n           equivalence class of addresses which match the first\n           'Prefix Length' bit positions of the Client Protocol\n           Address specified in the Client Information Entry (CIE).")
nhrpPurgeRequestID = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 3, 1, 4), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpPurgeRequestID.setDescription('The Request ID used in the purge request.')
nhrpPurgeReplyExpected = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 3, 1, 5), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpPurgeReplyExpected.setDescription("An indication of whether this Purge Request has the\n           'N' Bit cleared (off).")
nhrpPurgeRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 1, 3, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpPurgeRowStatus.setDescription('An object that allows entries in this table to be\n           created and deleted using the RowStatus convention.')
nhrpClientObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 71, 1, 2))
nhrpClientTable = MibTable((1, 3, 6, 1, 2, 1, 71, 1, 2, 1), )
if mibBuilder.loadTexts: nhrpClientTable.setDescription('Information about NHRP clients (NHCs) managed by this\n           agent.')
nhrpClientEntry = MibTableRow((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1), ).setIndexNames((0, "NHRP-MIB", "nhrpClientIndex"))
if mibBuilder.loadTexts: nhrpClientEntry.setDescription('Information about a single NHC.')
nhrpClientIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: nhrpClientIndex.setDescription("An identifier for the NHRP client that is unique within\n           the scope of this agent.  The 'nhrpNextIndex' value\n           should be consulted (read), prior to creating a row in\n           this table, and the value returned from reading\n           'nhrpNextIndex' should be used as this object's value.")
nhrpClientInternetworkAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 2), AddressFamilyNumbers()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientInternetworkAddrType.setDescription('The type of the internetwork layer address of this\n           client. This object indicates how the value of\n           nhrpClientInternetworkAddr is to be interpreted.')
nhrpClientInternetworkAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 3), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientInternetworkAddr.setDescription('The value of the internetwork layer address of this\n           client.')
nhrpClientNbmaAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 4), AddressFamilyNumbers()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientNbmaAddrType.setDescription('The type of the NBMA subnetwork address of this client.\n           This object indicates how the values of\n           nhrpClientNbmaAddr and nhrpClientNbmaSubaddr are to be\n           interpreted.')
nhrpClientNbmaAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 5), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientNbmaAddr.setDescription('The NBMA subnetwork address of this client.')
nhrpClientNbmaSubaddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 6), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientNbmaSubaddr.setDescription('The NBMA subaddress of this client. For NBMA address\n           families without a subaddress concept, this will be a\n           zero-length OCTET STRING.')
nhrpClientInitialRequestTimeout = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,900)).clone(10)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientInitialRequestTimeout.setDescription('The number of seconds that the client will wait before\n           timing out an NHRP initial request.  This object only has\n           meaning for the initial timeout period.')
nhrpClientRegistrationRequestRetries = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 8), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535)).clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientRegistrationRequestRetries.setDescription("The number of times the client will retry the\n           registration request before failure. A value of\n           0 means don't retry. A value of 65535 means\n           retry forever.")
nhrpClientResolutionRequestRetries = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 9), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535)).clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientResolutionRequestRetries.setDescription("The number of times the client will retry the resolution\n           request before failure. A value of 0 means don't retry.\n           A value of 65535 means retry forever.")
nhrpClientPurgeRequestRetries = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 10), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,65535)).clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientPurgeRequestRetries.setDescription("The number of times the client will retry a purge request\n           before failure. A value of 0 means don't retry. A value of\n           65535 means retry forever.")
nhrpClientDefaultMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 11), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,65535)).clone(9180)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientDefaultMtu.setDescription('The default maximum transmission unit (MTU) of the\n           LIS/LAG which this client should use. This object\n           will be initialized by the agent to the default MTU\n           of the LIS/LAG (which is 9180) unless a different MTU\n           value is specified during creation of this Client.')
nhrpClientHoldTime = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 12), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,65535)).clone(900)).setUnits('seconds').setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientHoldTime.setDescription('The hold time the client will register.')
nhrpClientRequestID = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 13), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientRequestID.setDescription('The Request ID used to register this client with its\n           server. According to Section 5.2.3 of the NHRP\n           Specification, RFC 2332 [17], the Request ID must\n           be kept in non-volatile storage, so that if an NHC\n           crashes and  re-initializes, it will use a different\n           Request ID during the registration process\n           when reregistering with the same NHS.')
nhrpClientStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 14), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientStorageType.setDescription('This object defines whether this row is kept in\n           volatile storage and lost upon a Client crash or\n           reboot situation, or if this row is backed up by\n           nonvolatile or permanent storage.')
nhrpClientRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 1, 1, 15), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientRowStatus.setDescription('An object that allows entries in this table to be\n           created and deleted using the RowStatus convention.')
nhrpClientRegistrationTable = MibTable((1, 3, 6, 1, 2, 1, 71, 1, 2, 2), )
if mibBuilder.loadTexts: nhrpClientRegistrationTable.setDescription('A table of Registration Request Information that\n           needs to be maintained by the NHCs (clients).')
nhrpClientRegistrationEntry = MibTableRow((1, 3, 6, 1, 2, 1, 71, 1, 2, 2, 1), ).setIndexNames((0, "NHRP-MIB", "nhrpClientIndex"), (0, "NHRP-MIB", "nhrpClientRegIndex"))
if mibBuilder.loadTexts: nhrpClientRegistrationEntry.setDescription('An NHC needs to maintain registration request information\n           between the NHC and the NHS.  An entry in this table\n           represents information for a single registration request.')
nhrpClientRegIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 2, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: nhrpClientRegIndex.setDescription('An identifier for this entry such that it\n           identifies a specific Registration Request from\n           the NHC represented by the nhrpClientIndex.')
nhrpClientRegUniqueness = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 2, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("requestUnique", 1), ("requestNotUnique", 2),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientRegUniqueness.setDescription('The Uniqueness indicator for this Registration Request.\n           If this object has the value of requestUnique(1), then\n           the Uniqueness bit is set in the the NHRP Registration\n           Request represented by this row.  The value cannot\n           be changed once the row is created.')
nhrpClientRegState = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 2, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("other", 1), ("registering", 2), ("ackRegisterReply", 3), ("nakRegisterReply", 4),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientRegState.setDescription("The registration state of this client. The values are:\n               'other(1)'             The state of the registration\n                                      request is not one of\n                                      'registering',\n                                      'ackRegisterReply' or\n                                      'nakRegisterReply'.\n\n               'registering(2)'        A registration request has\n                                       been issued and a registration\n                                       reply is expected.\n\n               'ackRegisterReply(3)'   A positive registration reply\n                                       has been received.\n\n               'nakRegisterReply(4)'   The client has received a\n                                       negative registration\n                                       reply (NAK).")
nhrpClientRegRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 2, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientRegRowStatus.setDescription('An object that allows entries in this table to be\n           created and deleted using the RowStatus convention.')
nhrpClientNhsTable = MibTable((1, 3, 6, 1, 2, 1, 71, 1, 2, 3), )
if mibBuilder.loadTexts: nhrpClientNhsTable.setDescription("A table of NHSes that are available for use by this NHC\n           (client). By default, the agent will add an entry to this\n           table that corresponds to the client's default router.")
nhrpClientNhsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 71, 1, 2, 3, 1), ).setIndexNames((0, "NHRP-MIB", "nhrpClientIndex"), (0, "NHRP-MIB", "nhrpClientNhsIndex"))
if mibBuilder.loadTexts: nhrpClientNhsEntry.setDescription('An NHS that may be used by an NHC.')
nhrpClientNhsIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 3, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: nhrpClientNhsIndex.setDescription('An identifier for an NHS available to an NHC.')
nhrpClientNhsInternetworkAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 3, 1, 2), AddressFamilyNumbers()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientNhsInternetworkAddrType.setDescription('The type of the internetwork layer address of the\n           NHRP server represented in this entry. This object\n           indicates how the value of\n           nhrpClientNhsInternetworkAddr is to be interpreted.')
nhrpClientNhsInternetworkAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 3, 1, 3), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientNhsInternetworkAddr.setDescription('The value of the destination internetwork layer\n           address of the NHRP server represented by this\n           entry.  If this value is not known, this will be\n           a zero-length OCTET STRING.')
nhrpClientNhsNbmaAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 3, 1, 4), AddressFamilyNumbers()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientNhsNbmaAddrType.setDescription('The type of the NBMA subnetwork address of the NHRP\n           Server represented by this entry. This object indicates\n           how the values of nhrpClientNhsNbmaAddr and\n           nhrpClientNhsNbmaSubaddr are to be interpreted.')
nhrpClientNhsNbmaAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 3, 1, 5), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientNhsNbmaAddr.setDescription('The NBMA subnetwork address of the NHS. The type of\n           the address is indicated by the corresponding value of\n           nhrpClientNhsNbmaAddrType.')
nhrpClientNhsNbmaSubaddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 3, 1, 6), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientNhsNbmaSubaddr.setDescription('The NBMA subaddress of the NHS. For NMBA address\n           families that do not have the concept of subaddress,\n                this will be a zero-length OCTET STRING.')
nhrpClientNhsInUse = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 3, 1, 7), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientNhsInUse.setDescription('An indication of whether this NHS is in use by the NHC.')
nhrpClientNhsRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 3, 1, 8), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpClientNhsRowStatus.setDescription('An object that allows entries in this table to be\n           created and deleted using the RowStatus convention.')
nhrpClientStatTable = MibTable((1, 3, 6, 1, 2, 1, 71, 1, 2, 4), )
if mibBuilder.loadTexts: nhrpClientStatTable.setDescription('This table contains statistics collected by NHRP\n           clients.')
nhrpClientStatEntry = MibTableRow((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1), ).setIndexNames((0, "NHRP-MIB", "nhrpClientIndex"))
if mibBuilder.loadTexts: nhrpClientStatEntry.setDescription('Statistics collected by a NHRP client.')
nhrpClientStatTxResolveReq = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatTxResolveReq.setDescription('The number of NHRP Resolution Requests transmitted\n           by this client.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.')
nhrpClientStatRxResolveReplyAck = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxResolveReplyAck.setDescription('The number of positively acknowledged NHRP Resolution\n           Replies received by this client.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.')
nhrpClientStatRxResolveReplyNakProhibited = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxResolveReplyNakProhibited.setDescription("The number of NAKed NHRP Resolution Replies received\n           by this client that contained the code indicating\n           'Administratively Prohibited'.\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.")
nhrpClientStatRxResolveReplyNakInsufResources = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxResolveReplyNakInsufResources.setDescription("The number of NAKed NHRP Resolution Replies received\n           by this client that contained the code indicating\n           'Insufficient Resources'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.")
nhrpClientStatRxResolveReplyNakNoBinding = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxResolveReplyNakNoBinding.setDescription("The number of NAKed NHRP Resolution Replies received\n           by this client that contained the code indicating\n           'No Internetworking Layer Address to NBMA Address\n           Binding Exists'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.")
nhrpClientStatRxResolveReplyNakNotUnique = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxResolveReplyNakNotUnique.setDescription("The number of NAKed NHRP Resolution Replies received\n           by this client that contained the code indicating\n           'Binding Exists But Is Not Unique'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.")
nhrpClientStatTxRegisterReq = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatTxRegisterReq.setDescription('The number of NHRP Registration Requests transmitted\n           by this client.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.')
nhrpClientStatRxRegisterAck = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxRegisterAck.setDescription('The number of positively acknowledged NHRP Registration\n           Replies received by this client.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.')
nhrpClientStatRxRegisterNakProhibited = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxRegisterNakProhibited.setDescription("The number of NAKed NHRP Registration Replies received\n           by this client that contained the code indicating\n           'Administratively Prohibited'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.")
nhrpClientStatRxRegisterNakInsufResources = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxRegisterNakInsufResources.setDescription("The number of NAKed NHRP Registration Replies received\n           by this client that contained the code indicating\n           'Insufficient Resources'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.")
nhrpClientStatRxRegisterNakAlreadyReg = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxRegisterNakAlreadyReg.setDescription("The number of NAKed NHRP Registration Replies received\n           by this client that contained the code indicating 'Unique\n           Internetworking Layer Address Already Registered'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.")
nhrpClientStatRxPurgeReq = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxPurgeReq.setDescription('The number of NHRP Purge Requests received by this\n           client.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.')
nhrpClientStatTxPurgeReq = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatTxPurgeReq.setDescription('The number of NHRP Purge Requests transmitted by this\n           client.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.')
nhrpClientStatRxPurgeReply = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxPurgeReply.setDescription('The number of NHRP Purge Replies received by this\n           client.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.')
nhrpClientStatTxPurgeReply = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatTxPurgeReply.setDescription('The number of NHRP Purge Replies transmitted by this\n           client.\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.')
nhrpClientStatTxErrorIndication = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatTxErrorIndication.setDescription('The number of NHRP Error Indication packets transmitted\n           by this client.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.')
nhrpClientStatRxErrUnrecognizedExtension = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxErrUnrecognizedExtension.setDescription("The number of NHRP Error Indication packets received\n           by this client with the error code\n           'Unrecognized Extension'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.")
nhrpClientStatRxErrLoopDetected = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxErrLoopDetected.setDescription("The number of NHRP Error Indication packets received\n           by this client with the error code 'NHRP Loop Detected'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.")
nhrpClientStatRxErrProtoAddrUnreachable = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxErrProtoAddrUnreachable.setDescription("The number of NHRP Error Indication packets received\n           by this client with the error code 'Protocol Address\n           Unreachable'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.")
nhrpClientStatRxErrProtoError = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxErrProtoError.setDescription("The number of NHRP Error Indication packets received\n           by this client with the error code 'Protocol Error'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.")
nhrpClientStatRxErrSduSizeExceeded = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxErrSduSizeExceeded.setDescription("The number of NHRP Error Indication packets received\n           by this client with the error code 'NHRP SDU Size\n\n           Exceeded'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.")
nhrpClientStatRxErrInvalidExtension = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxErrInvalidExtension.setDescription("The number of NHRP Error Indication packets received\n           by this client with the error code 'Invalid Extension'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.")
nhrpClientStatRxErrAuthenticationFailure = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxErrAuthenticationFailure.setDescription("The number of NHRP Error Indication packets received\n           by this client with the error code 'Authentication\n           Failure'.\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.")
nhrpClientStatRxErrHopCountExceeded = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 24), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatRxErrHopCountExceeded.setDescription("The number of NHRP Error Indication packets received\n           by this client with the error code 'Hop Count Exceeded'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Client re-initialization and at\n           other times as indicated by the value of\n           nhrpClientStatDiscontinuityTime.")
nhrpClientStatDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 2, 4, 1, 25), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpClientStatDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion at\n           which any one or more of this Client's counters\n           suffered a discontinuity.  If no such discontinuities\n           have occurred since the last re-initialization of the\n           local management subsystem or the NHRP Client\n           re-initialization associated with this entry, then\n           this object contains a zero value.")
nhrpServerObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 71, 1, 3))
nhrpServerTable = MibTable((1, 3, 6, 1, 2, 1, 71, 1, 3, 1), )
if mibBuilder.loadTexts: nhrpServerTable.setDescription('This table contains information for a set of NHSes\n           associated with this agent.')
nhrpServerEntry = MibTableRow((1, 3, 6, 1, 2, 1, 71, 1, 3, 1, 1), ).setIndexNames((0, "NHRP-MIB", "nhrpServerIndex"))
if mibBuilder.loadTexts: nhrpServerEntry.setDescription('Information about a single NHS.')
nhrpServerIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 1, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: nhrpServerIndex.setDescription('An identifier for the server that is unique within the\n           scope of this agent.')
nhrpServerInternetworkAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 1, 1, 2), AddressFamilyNumbers()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerInternetworkAddrType.setDescription('The type of the internetwork layer address of this\n           server. This object is used to interpret the value of\n           nhrpServerInternetworkAddr.')
nhrpServerInternetworkAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 1, 1, 3), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerInternetworkAddr.setDescription('The value of the internetwork layer address of this\n           server.')
nhrpServerNbmaAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 1, 1, 4), AddressFamilyNumbers()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerNbmaAddrType.setDescription('The type of the NBMA subnetwork address of this server.\n           This object is used to interpret the value of\n           nhrpServerNbmaAddr.')
nhrpServerNbmaAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 1, 1, 5), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerNbmaAddr.setDescription('The value of the NBMA subnetwork address of this\n           server.')
nhrpServerNbmaSubaddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 1, 1, 6), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerNbmaSubaddr.setDescription('The value of the NBMA subaddress of this server.\n           For NBMA address families without a subaddress\n           concept, this will be a zero-length OCTET STRING.')
nhrpServerStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 1, 1, 7), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerStorageType.setDescription('This object defines whether this row is kept in\n           volatile storage and lost upon a Server crash or\n           reboot situation, or if this row is backed up by\n           nonvolatile or permanent storage.')
nhrpServerRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 1, 1, 8), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerRowStatus.setDescription('An object that allows entries in this table to be\n           created and deleted using the RowStatus convention.')
nhrpServerCacheTable = MibTable((1, 3, 6, 1, 2, 1, 71, 1, 3, 2), )
if mibBuilder.loadTexts: nhrpServerCacheTable.setDescription('This table extends the nhrpCacheTable for\n           NHSes.  If the nhrpCacheTable has a row added due to\n           an NHS or based on information regarding an NHS then\n           a row is also added in this table.\n\n           The rows in this table will be created when rows in\n           the nhrpCacheTable are created.  However, there may\n           be rows created in the nhrpCacheTable which do not\n           have corresponding rows in this table.  For example,\n           if the nhrpCacheTable has a row added due to a Next\n           Hop Client which is co-resident on the same device\n           as the NHS, a row will not be added to this table.')
nhrpServerCacheEntry = MibTableRow((1, 3, 6, 1, 2, 1, 71, 1, 3, 2, 1), ).setIndexNames((0, "NHRP-MIB", "nhrpCacheInternetworkAddrType"), (0, "NHRP-MIB", "nhrpCacheInternetworkAddr"), (0, "IF-MIB", "ifIndex"), (0, "NHRP-MIB", "nhrpCacheIndex"))
if mibBuilder.loadTexts: nhrpServerCacheEntry.setDescription('Additional information kept by a NHS for a relevant\n           Next Hop Resolution Cache entry.')
nhrpServerCacheAuthoritative = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 2, 1, 1), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerCacheAuthoritative.setDescription('An indication of whether this cache entry is\n           authoritative, which means the entry was added because\n           of a direct registration request with this server or\n           by Server Cache Synchronization Protocol (SCSP) from\n           an authoritative source.')
nhrpServerCacheUniqueness = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 2, 1, 2), TruthValue()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerCacheUniqueness.setDescription('The Uniqueness indicator for this cache\n           entry used in duplicate address detection. This value\n           cannot be changed after the entry is active.')
nhrpServerNhcTable = MibTable((1, 3, 6, 1, 2, 1, 71, 1, 3, 3), )
if mibBuilder.loadTexts: nhrpServerNhcTable.setDescription('A table of NHCs that are available for use by this NHS\n           (Server).')
nhrpServerNhcEntry = MibTableRow((1, 3, 6, 1, 2, 1, 71, 1, 3, 3, 1), ).setIndexNames((0, "NHRP-MIB", "nhrpServerIndex"), (0, "NHRP-MIB", "nhrpServerNhcIndex"))
if mibBuilder.loadTexts: nhrpServerNhcEntry.setDescription('An NHC that may be used by an NHS.')
nhrpServerNhcIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 3, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,4294967295)))
if mibBuilder.loadTexts: nhrpServerNhcIndex.setDescription('An identifier for an NHC available to an NHS.')
nhrpServerNhcPrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 3, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerNhcPrefixLength.setDescription('The number of bits that define the internetwork\n           layer prefix associated with the\n           nhrpServerNhcInternetworkAddr.')
nhrpServerNhcInternetworkAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 3, 1, 3), AddressFamilyNumbers()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerNhcInternetworkAddrType.setDescription('The type of the internetwork layer address of the\n           NHRP Client represented in this entry. This object\n           indicates how the value of nhrpServerNhcInternetworkAddr\n           is to be interpreted.')
nhrpServerNhcInternetworkAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 3, 1, 4), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerNhcInternetworkAddr.setDescription('The value of the internetwork layer address of\n           the NHRP Client represented by this entry.  If this\n           value is not known, this will be a zero-length\n           OCTET STRING.')
nhrpServerNhcNbmaAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 3, 1, 5), AddressFamilyNumbers()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerNhcNbmaAddrType.setDescription('The type of the NBMA subnetwork address of the NHRP\n           Client represented by this entry. This object indicates\n           how the values of nhrpServerNhcNbmaAddr and\n           nhrpServerNhcNbmaSubaddr are to be interpreted.')
nhrpServerNhcNbmaAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 3, 1, 6), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerNhcNbmaAddr.setDescription('The NBMA subnetwork address of the NHC. The type of the\n           address is indicated by the corresponding value of\n           nhrpServerNbmaAddrType.')
nhrpServerNhcNbmaSubaddr = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 3, 1, 7), NhrpGenAddr()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerNhcNbmaSubaddr.setDescription('The NBMA subaddress of the NHC. For NMBA address familes\n           that do not have the concept of subaddress, this will\n           be a zero-length OCTET STRING.')
nhrpServerNhcInUse = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 3, 1, 8), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerNhcInUse.setDescription('An indication of whether this NHC is in use by the NHS.')
nhrpServerNhcRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 3, 1, 9), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: nhrpServerNhcRowStatus.setDescription('An object that allows entries in this table to be\n           created and deleted using the RowStatus convention.')
nhrpServerStatTable = MibTable((1, 3, 6, 1, 2, 1, 71, 1, 3, 4), )
if mibBuilder.loadTexts: nhrpServerStatTable.setDescription('Statistics collected by Next Hop Servers.')
nhrpServerStatEntry = MibTableRow((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1), ).setIndexNames((0, "NHRP-MIB", "nhrpServerIndex"))
if mibBuilder.loadTexts: nhrpServerStatEntry.setDescription('Statistics for a particular NHS. The statistics are\n           broken into received (Rx), transmitted (Tx)\n           and forwarded (Fw).  Forwarded (Fw) would be done\n           by a transit NHS.')
nhrpServerStatRxResolveReq = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxResolveReq.setDescription('The number of NHRP Resolution Requests received by this\n           server.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.')
nhrpServerStatTxResolveReplyAck = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxResolveReplyAck.setDescription('The number of positively acknowledged NHRP\n           Resolution Replies transmitted by this server.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.')
nhrpServerStatTxResolveReplyNakProhibited = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxResolveReplyNakProhibited.setDescription("The number of NAKed NHRP Resolution Replies\n           transmitted by this server with the code\n           'Administratively Prohibited'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatTxResolveReplyNakInsufResources = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxResolveReplyNakInsufResources.setDescription("The number of NAKed NHRP Resolution Replies\n           transmitted by this server with the code\n           'Insufficient Resources'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatTxResolveReplyNakNoBinding = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxResolveReplyNakNoBinding.setDescription("The number of NAKed NHRP Resolution Replies\n           transmitted by this server with the code\n           'No Internetworking Layer Address to NBMA\n           Address Binding Exists'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatTxResolveReplyNakNotUnique = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxResolveReplyNakNotUnique.setDescription("The number of NAKed NHRP Resolution Replies\n           transmitted by this server with the code\n           'Binding Exists But Is Not Unique'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatRxRegisterReq = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxRegisterReq.setDescription('The number of NHRP Registration Requests received\n           by this server.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.')
nhrpServerStatTxRegisterAck = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxRegisterAck.setDescription('The number of positively acknowledged NHRP Registration\n           Replies transmitted by this server.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.')
nhrpServerStatTxRegisterNakProhibited = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxRegisterNakProhibited.setDescription("The number of NAKed NHRP Registration Replies\n           transmitted by this server with the code\n           'Administratively Prohibited'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatTxRegisterNakInsufResources = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxRegisterNakInsufResources.setDescription("The number of NAKed NHRP Registration Replies\n           transmitted by this server with the code\n           'Insufficient Resources'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatTxRegisterNakAlreadyReg = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxRegisterNakAlreadyReg.setDescription("The number of NAKed NHRP Registration Replies\n           transmitted by this server with the code\n           'Unique Internetworking Layer Address Already\n           Registered'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatRxPurgeReq = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxPurgeReq.setDescription('The number of NHRP Purge Requests received by\n           this server.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.')
nhrpServerStatTxPurgeReq = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxPurgeReq.setDescription('The number of NHRP Purge Requests transmitted by this\n           server.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.')
nhrpServerStatRxPurgeReply = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxPurgeReply.setDescription('The number of NHRP Purge Replies received by this\n           server.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.')
nhrpServerStatTxPurgeReply = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxPurgeReply.setDescription('The number of NHRP Purge Replies transmitted by\n           this server.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.')
nhrpServerStatRxErrUnrecognizedExtension = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxErrUnrecognizedExtension.setDescription("The number of NHRP Error Indication packets received\n           by this server with the error code\n\n           'Unrecognized Extension'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatRxErrLoopDetected = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxErrLoopDetected.setDescription("The number of NHRP Error Indication packets received\n           by this server with the error code 'NHRP Loop Detected'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatRxErrProtoAddrUnreachable = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxErrProtoAddrUnreachable.setDescription("The number of NHRP Error Indication packets received\n           by this server with the error code 'Protocol Address\n           Unreachable'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatRxErrProtoError = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxErrProtoError.setDescription("The number of NHRP Error Indication packets received\n           by this server with the error code 'Protocol Error'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatRxErrSduSizeExceeded = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxErrSduSizeExceeded.setDescription("The number of NHRP Error Indication packets received\n           by this server with the error code 'NHRP SDU Size\n           Exceeded'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatRxErrInvalidExtension = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxErrInvalidExtension.setDescription("The number of NHRP Error Indication packets received\n           by this server with the error code 'Invalid Extension'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatRxErrInvalidResReplyReceived = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxErrInvalidResReplyReceived.setDescription("The number of NHRP Error Indication packets received\n           by this server with the error code 'Invalid Resolution\n           Reply Received'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatRxErrAuthenticationFailure = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxErrAuthenticationFailure.setDescription("The number of NHRP Error Indication packets\n           received by this server with the error code\n           'Authentication Failure'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatRxErrHopCountExceeded = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 24), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatRxErrHopCountExceeded.setDescription("The number of NHRP Error Indication packets\n           received by this server with the error code\n           'Hop Count Exceeded'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatTxErrUnrecognizedExtension = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxErrUnrecognizedExtension.setDescription("The number of NHRP Error Indication packets\n           transmitted by this server with the error code\n           'Unrecognized Extension'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatTxErrLoopDetected = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 26), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxErrLoopDetected.setDescription("The number of NHRP Error Indication packets\n           transmitted by this server with the error code\n           'NHRP Loop Detected'.\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatTxErrProtoAddrUnreachable = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 27), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxErrProtoAddrUnreachable.setDescription("The number of NHRP Error Indication packets\n           transmitted by this server with the error code\n           'Protocol Address Unreachable'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatTxErrProtoError = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 28), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxErrProtoError.setDescription("The number of NHRP Error Indication packets\n           transmitted by this server with the error\n           code 'Protocol Error'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatTxErrSduSizeExceeded = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 29), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxErrSduSizeExceeded.setDescription("The number of NHRP Error Indication packets\n           transmitted by this server with the error code\n           'NHRP SDU Size Exceeded'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatTxErrInvalidExtension = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 30), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxErrInvalidExtension.setDescription("The number of NHRP Error Indication packets\n           transmitted by this server with the error code\n\n           'Invalid Extension'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatTxErrAuthenticationFailure = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 31), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxErrAuthenticationFailure.setDescription("The number of NHRP Error Indication packets\n           transmitted by this server with the error code\n           'Authentication Failure'.\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatTxErrHopCountExceeded = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 32), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatTxErrHopCountExceeded.setDescription("The number of NHRP Error Indication packets\n           transmitted by this server with the error\n           code 'Hop Count Exceeded'.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.")
nhrpServerStatFwResolveReq = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 33), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatFwResolveReq.setDescription('The number of NHRP Resolution Requests\n           forwarded by this server acting as a transit NHS.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.')
nhrpServerStatFwResolveReply = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 34), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatFwResolveReply.setDescription('The number of NHRP Resolution Replies forwarded\n           by this server acting as a transit NHS.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.')
nhrpServerStatFwRegisterReq = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 35), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatFwRegisterReq.setDescription('The number of NHRP Registration Requests forwarded\n           by this server acting as a transit NHS.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.')
nhrpServerStatFwRegisterReply = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 36), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatFwRegisterReply.setDescription('The number of NHRP Registration Replies forwarded\n           by this server acting as a transit NHS.\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.')
nhrpServerStatFwPurgeReq = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 37), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatFwPurgeReq.setDescription('The number of NHRP Purge Requests forwarded\n           by this server acting as a transit NHS.\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.')
nhrpServerStatFwPurgeReply = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 38), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatFwPurgeReply.setDescription('The number of NHRP Purge Replies forwarded by this\n           server acting as a transit NHS.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.')
nhrpServerStatFwErrorIndication = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 39), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatFwErrorIndication.setDescription('The number of NHRP Error Indication packets forwarded\n           by this server acting as a transit NHS.\n\n           Discontinuities in the value of this counter can occur\n           at re-initialization of the management system, at\n           NHRP Server re-initialization and at\n           other times as indicated by the value of\n           nhrpServerStatDiscontinuityTime.')
nhrpServerStatDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 71, 1, 3, 4, 1, 40), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: nhrpServerStatDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion at\n           which any one or more of this Server's counters\n           suffered a discontinuity.  If no such discontinuities\n           have occurred since the last re-initialization of the\n           local management subsystem or the NHRP Server\n           re-initialization associated with this entry, then\n           this object contains a zero value.")
nhrpConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 71, 2))
nhrpCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 71, 2, 1))
nhrpGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 71, 2, 2))
nhrpModuleCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 71, 2, 1, 1)).setObjects(*(("NHRP-MIB", "nhrpGeneralGroup"), ("NHRP-MIB", "nhrpClientGroup"), ("NHRP-MIB", "nhrpServerGroup"),))
if mibBuilder.loadTexts: nhrpModuleCompliance.setDescription('The compliance statement for the NHRP MIB.')
nhrpGeneralGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 71, 2, 2, 1)).setObjects(*(("NHRP-MIB", "nhrpNextIndex"), ("NHRP-MIB", "nhrpCachePrefixLength"), ("NHRP-MIB", "nhrpCacheNextHopInternetworkAddr"), ("NHRP-MIB", "nhrpCacheNbmaAddrType"), ("NHRP-MIB", "nhrpCacheNbmaAddr"), ("NHRP-MIB", "nhrpCacheNbmaSubaddr"), ("NHRP-MIB", "nhrpCacheType"), ("NHRP-MIB", "nhrpCacheState"), ("NHRP-MIB", "nhrpCacheHoldingTimeValid"), ("NHRP-MIB", "nhrpCacheHoldingTime"), ("NHRP-MIB", "nhrpCacheNegotiatedMtu"), ("NHRP-MIB", "nhrpCachePreference"), ("NHRP-MIB", "nhrpCacheStorageType"), ("NHRP-MIB", "nhrpCacheRowStatus"), ("NHRP-MIB", "nhrpPurgeCacheIdentifier"), ("NHRP-MIB", "nhrpPurgePrefixLength"), ("NHRP-MIB", "nhrpPurgeRequestID"), ("NHRP-MIB", "nhrpPurgeReplyExpected"), ("NHRP-MIB", "nhrpPurgeRowStatus"),))
if mibBuilder.loadTexts: nhrpGeneralGroup.setDescription('Objects that apply to both NHRP clients and NHRP\n           servers.')
nhrpClientGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 71, 2, 2, 2)).setObjects(*(("NHRP-MIB", "nhrpClientInternetworkAddrType"), ("NHRP-MIB", "nhrpClientInternetworkAddr"), ("NHRP-MIB", "nhrpClientNbmaAddrType"), ("NHRP-MIB", "nhrpClientNbmaAddr"), ("NHRP-MIB", "nhrpClientNbmaSubaddr"), ("NHRP-MIB", "nhrpClientInitialRequestTimeout"), ("NHRP-MIB", "nhrpClientRegistrationRequestRetries"), ("NHRP-MIB", "nhrpClientResolutionRequestRetries"), ("NHRP-MIB", "nhrpClientPurgeRequestRetries"), ("NHRP-MIB", "nhrpClientDefaultMtu"), ("NHRP-MIB", "nhrpClientHoldTime"), ("NHRP-MIB", "nhrpClientRequestID"), ("NHRP-MIB", "nhrpClientStorageType"), ("NHRP-MIB", "nhrpClientRowStatus"), ("NHRP-MIB", "nhrpClientRegUniqueness"), ("NHRP-MIB", "nhrpClientRegState"), ("NHRP-MIB", "nhrpClientRegRowStatus"), ("NHRP-MIB", "nhrpClientNhsInternetworkAddrType"), ("NHRP-MIB", "nhrpClientNhsInternetworkAddr"), ("NHRP-MIB", "nhrpClientNhsNbmaAddrType"), ("NHRP-MIB", "nhrpClientNhsNbmaAddr"), ("NHRP-MIB", "nhrpClientNhsNbmaSubaddr"), ("NHRP-MIB", "nhrpClientNhsInUse"), ("NHRP-MIB", "nhrpClientNhsRowStatus"), ("NHRP-MIB", "nhrpClientStatTxResolveReq"), ("NHRP-MIB", "nhrpClientStatRxResolveReplyAck"), ("NHRP-MIB", "nhrpClientStatRxResolveReplyNakProhibited"), ("NHRP-MIB", "nhrpClientStatRxResolveReplyNakInsufResources"), ("NHRP-MIB", "nhrpClientStatRxResolveReplyNakNoBinding"), ("NHRP-MIB", "nhrpClientStatRxResolveReplyNakNotUnique"), ("NHRP-MIB", "nhrpClientStatTxRegisterReq"), ("NHRP-MIB", "nhrpClientStatRxRegisterAck"), ("NHRP-MIB", "nhrpClientStatRxRegisterNakProhibited"), ("NHRP-MIB", "nhrpClientStatRxRegisterNakInsufResources"), ("NHRP-MIB", "nhrpClientStatRxRegisterNakAlreadyReg"), ("NHRP-MIB", "nhrpClientStatRxPurgeReq"), ("NHRP-MIB", "nhrpClientStatTxPurgeReq"), ("NHRP-MIB", "nhrpClientStatRxPurgeReply"), ("NHRP-MIB", "nhrpClientStatTxPurgeReply"), ("NHRP-MIB", "nhrpClientStatTxErrorIndication"), ("NHRP-MIB", "nhrpClientStatRxErrUnrecognizedExtension"), ("NHRP-MIB", "nhrpClientStatRxErrLoopDetected"), ("NHRP-MIB", "nhrpClientStatRxErrProtoAddrUnreachable"), ("NHRP-MIB", "nhrpClientStatRxErrProtoError"), ("NHRP-MIB", "nhrpClientStatRxErrSduSizeExceeded"), ("NHRP-MIB", "nhrpClientStatRxErrInvalidExtension"), ("NHRP-MIB", "nhrpClientStatRxErrAuthenticationFailure"), ("NHRP-MIB", "nhrpClientStatRxErrHopCountExceeded"), ("NHRP-MIB", "nhrpClientStatDiscontinuityTime"),))
if mibBuilder.loadTexts: nhrpClientGroup.setDescription('Objects that apply only to NHRP clients.')
nhrpServerGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 71, 2, 2, 3)).setObjects(*(("NHRP-MIB", "nhrpServerInternetworkAddrType"), ("NHRP-MIB", "nhrpServerInternetworkAddr"), ("NHRP-MIB", "nhrpServerNbmaAddrType"), ("NHRP-MIB", "nhrpServerNbmaAddr"), ("NHRP-MIB", "nhrpServerNbmaSubaddr"), ("NHRP-MIB", "nhrpServerStorageType"), ("NHRP-MIB", "nhrpServerRowStatus"), ("NHRP-MIB", "nhrpServerCacheAuthoritative"), ("NHRP-MIB", "nhrpServerCacheUniqueness"), ("NHRP-MIB", "nhrpServerNhcPrefixLength"), ("NHRP-MIB", "nhrpServerNhcInternetworkAddrType"), ("NHRP-MIB", "nhrpServerNhcInternetworkAddr"), ("NHRP-MIB", "nhrpServerNhcNbmaAddrType"), ("NHRP-MIB", "nhrpServerNhcNbmaAddr"), ("NHRP-MIB", "nhrpServerNhcNbmaSubaddr"), ("NHRP-MIB", "nhrpServerNhcInUse"), ("NHRP-MIB", "nhrpServerNhcRowStatus"), ("NHRP-MIB", "nhrpServerStatRxResolveReq"), ("NHRP-MIB", "nhrpServerStatTxResolveReplyAck"), ("NHRP-MIB", "nhrpServerStatTxResolveReplyNakProhibited"), ("NHRP-MIB", "nhrpServerStatTxResolveReplyNakInsufResources"), ("NHRP-MIB", "nhrpServerStatTxResolveReplyNakNoBinding"), ("NHRP-MIB", "nhrpServerStatTxResolveReplyNakNotUnique"), ("NHRP-MIB", "nhrpServerStatRxRegisterReq"), ("NHRP-MIB", "nhrpServerStatTxRegisterAck"), ("NHRP-MIB", "nhrpServerStatTxRegisterNakProhibited"), ("NHRP-MIB", "nhrpServerStatTxRegisterNakInsufResources"), ("NHRP-MIB", "nhrpServerStatTxRegisterNakAlreadyReg"), ("NHRP-MIB", "nhrpServerStatRxPurgeReq"), ("NHRP-MIB", "nhrpServerStatTxPurgeReq"), ("NHRP-MIB", "nhrpServerStatRxPurgeReply"), ("NHRP-MIB", "nhrpServerStatTxPurgeReply"), ("NHRP-MIB", "nhrpServerStatRxErrUnrecognizedExtension"), ("NHRP-MIB", "nhrpServerStatRxErrLoopDetected"), ("NHRP-MIB", "nhrpServerStatRxErrProtoAddrUnreachable"), ("NHRP-MIB", "nhrpServerStatRxErrProtoError"), ("NHRP-MIB", "nhrpServerStatRxErrSduSizeExceeded"), ("NHRP-MIB", "nhrpServerStatRxErrInvalidExtension"), ("NHRP-MIB", "nhrpServerStatRxErrInvalidResReplyReceived"), ("NHRP-MIB", "nhrpServerStatRxErrAuthenticationFailure"), ("NHRP-MIB", "nhrpServerStatRxErrHopCountExceeded"), ("NHRP-MIB", "nhrpServerStatTxErrUnrecognizedExtension"), ("NHRP-MIB", "nhrpServerStatTxErrLoopDetected"), ("NHRP-MIB", "nhrpServerStatTxErrProtoAddrUnreachable"), ("NHRP-MIB", "nhrpServerStatTxErrProtoError"), ("NHRP-MIB", "nhrpServerStatTxErrSduSizeExceeded"), ("NHRP-MIB", "nhrpServerStatTxErrInvalidExtension"), ("NHRP-MIB", "nhrpServerStatTxErrAuthenticationFailure"), ("NHRP-MIB", "nhrpServerStatTxErrHopCountExceeded"), ("NHRP-MIB", "nhrpServerStatFwResolveReq"), ("NHRP-MIB", "nhrpServerStatFwResolveReply"), ("NHRP-MIB", "nhrpServerStatFwRegisterReq"), ("NHRP-MIB", "nhrpServerStatFwRegisterReply"), ("NHRP-MIB", "nhrpServerStatFwPurgeReq"), ("NHRP-MIB", "nhrpServerStatFwPurgeReply"), ("NHRP-MIB", "nhrpServerStatFwErrorIndication"), ("NHRP-MIB", "nhrpServerStatDiscontinuityTime"),))
if mibBuilder.loadTexts: nhrpServerGroup.setDescription('Objects that apply only to NHRP servers.')
mibBuilder.exportSymbols("NHRP-MIB", nhrpClientNhsIndex=nhrpClientNhsIndex, nhrpClientNbmaAddr=nhrpClientNbmaAddr, nhrpClientRegistrationEntry=nhrpClientRegistrationEntry, nhrpServerStatTxErrSduSizeExceeded=nhrpServerStatTxErrSduSizeExceeded, nhrpServerStatTxErrProtoAddrUnreachable=nhrpServerStatTxErrProtoAddrUnreachable, nhrpGroups=nhrpGroups, nhrpServerStatRxErrInvalidResReplyReceived=nhrpServerStatRxErrInvalidResReplyReceived, nhrpClientStatRxErrInvalidExtension=nhrpClientStatRxErrInvalidExtension, nhrpObjects=nhrpObjects, nhrpClientStatRxErrHopCountExceeded=nhrpClientStatRxErrHopCountExceeded, nhrpPurgeCacheIdentifier=nhrpPurgeCacheIdentifier, nhrpServerNhcNbmaAddr=nhrpServerNhcNbmaAddr, nhrpCacheIndex=nhrpCacheIndex, nhrpCacheHoldingTime=nhrpCacheHoldingTime, nhrpServerStatFwResolveReply=nhrpServerStatFwResolveReply, nhrpServerNhcInternetworkAddrType=nhrpServerNhcInternetworkAddrType, nhrpPurgePrefixLength=nhrpPurgePrefixLength, nhrpServerStatTable=nhrpServerStatTable, nhrpClientPurgeRequestRetries=nhrpClientPurgeRequestRetries, nhrpClientRegState=nhrpClientRegState, nhrpServerStatTxResolveReplyNakInsufResources=nhrpServerStatTxResolveReplyNakInsufResources, nhrpServerStatTxRegisterAck=nhrpServerStatTxRegisterAck, nhrpServerStatRxErrProtoAddrUnreachable=nhrpServerStatRxErrProtoAddrUnreachable, nhrpConformance=nhrpConformance, nhrpMIB=nhrpMIB, nhrpClientStatTxErrorIndication=nhrpClientStatTxErrorIndication, nhrpClientDefaultMtu=nhrpClientDefaultMtu, nhrpGeneralGroup=nhrpGeneralGroup, nhrpServerCacheTable=nhrpServerCacheTable, nhrpClientNhsInUse=nhrpClientNhsInUse, nhrpClientRegIndex=nhrpClientRegIndex, nhrpServerGroup=nhrpServerGroup, nhrpClientRegistrationRequestRetries=nhrpClientRegistrationRequestRetries, nhrpClientResolutionRequestRetries=nhrpClientResolutionRequestRetries, nhrpClientEntry=nhrpClientEntry, nhrpClientStatRxRegisterNakInsufResources=nhrpClientStatRxRegisterNakInsufResources, nhrpServerTable=nhrpServerTable, nhrpClientInternetworkAddrType=nhrpClientInternetworkAddrType, nhrpClientObjects=nhrpClientObjects, nhrpClientStatRxErrLoopDetected=nhrpClientStatRxErrLoopDetected, nhrpServerNhcRowStatus=nhrpServerNhcRowStatus, nhrpClientRegRowStatus=nhrpClientRegRowStatus, nhrpClientStatRxRegisterAck=nhrpClientStatRxRegisterAck, nhrpServerStatTxResolveReplyNakNoBinding=nhrpServerStatTxResolveReplyNakNoBinding, nhrpServerStatTxPurgeReply=nhrpServerStatTxPurgeReply, nhrpServerCacheUniqueness=nhrpServerCacheUniqueness, nhrpServerStatFwPurgeReply=nhrpServerStatFwPurgeReply, nhrpClientStatRxPurgeReply=nhrpClientStatRxPurgeReply, nhrpClientRowStatus=nhrpClientRowStatus, nhrpServerStatTxPurgeReq=nhrpServerStatTxPurgeReq, nhrpServerStatRxErrHopCountExceeded=nhrpServerStatRxErrHopCountExceeded, nhrpServerStatTxResolveReplyNakProhibited=nhrpServerStatTxResolveReplyNakProhibited, nhrpClientGroup=nhrpClientGroup, nhrpPurgeReplyExpected=nhrpPurgeReplyExpected, nhrpServerStatFwPurgeReq=nhrpServerStatFwPurgeReq, nhrpClientStatRxErrProtoError=nhrpClientStatRxErrProtoError, nhrpClientInitialRequestTimeout=nhrpClientInitialRequestTimeout, nhrpServerStatFwRegisterReq=nhrpServerStatFwRegisterReq, nhrpClientStatDiscontinuityTime=nhrpClientStatDiscontinuityTime, nhrpServerNhcInternetworkAddr=nhrpServerNhcInternetworkAddr, nhrpClientNhsNbmaAddr=nhrpClientNhsNbmaAddr, nhrpServerStatRxRegisterReq=nhrpServerStatRxRegisterReq, nhrpServerStatFwResolveReq=nhrpServerStatFwResolveReq, nhrpClientStatTable=nhrpClientStatTable, nhrpCacheState=nhrpCacheState, nhrpClientStatEntry=nhrpClientStatEntry, nhrpServerStatFwRegisterReply=nhrpServerStatFwRegisterReply, nhrpPurgeRequestID=nhrpPurgeRequestID, nhrpServerNhcNbmaSubaddr=nhrpServerNhcNbmaSubaddr, nhrpCacheStorageType=nhrpCacheStorageType, PYSNMP_MODULE_ID=nhrpMIB, nhrpCacheInternetworkAddrType=nhrpCacheInternetworkAddrType, nhrpClientStatRxResolveReplyNakNotUnique=nhrpClientStatRxResolveReplyNakNotUnique, nhrpServerStatTxRegisterNakProhibited=nhrpServerStatTxRegisterNakProhibited, nhrpModuleCompliance=nhrpModuleCompliance, nhrpCacheNegotiatedMtu=nhrpCacheNegotiatedMtu, nhrpServerInternetworkAddrType=nhrpServerInternetworkAddrType, nhrpServerNbmaAddrType=nhrpServerNbmaAddrType, nhrpServerCacheEntry=nhrpServerCacheEntry, nhrpCacheRowStatus=nhrpCacheRowStatus, nhrpServerInternetworkAddr=nhrpServerInternetworkAddr, nhrpServerCacheAuthoritative=nhrpServerCacheAuthoritative, nhrpClientStatTxRegisterReq=nhrpClientStatTxRegisterReq, nhrpServerNhcEntry=nhrpServerNhcEntry, nhrpServerStatTxErrUnrecognizedExtension=nhrpServerStatTxErrUnrecognizedExtension, nhrpServerNhcTable=nhrpServerNhcTable, nhrpServerStatTxErrAuthenticationFailure=nhrpServerStatTxErrAuthenticationFailure, nhrpCacheTable=nhrpCacheTable, nhrpClientNhsNbmaAddrType=nhrpClientNhsNbmaAddrType, nhrpServerNhcInUse=nhrpServerNhcInUse, nhrpServerStatTxRegisterNakInsufResources=nhrpServerStatTxRegisterNakInsufResources, nhrpServerEntry=nhrpServerEntry, nhrpServerNbmaAddr=nhrpServerNbmaAddr, nhrpClientNhsRowStatus=nhrpClientNhsRowStatus, nhrpServerStatTxErrHopCountExceeded=nhrpServerStatTxErrHopCountExceeded, nhrpCacheNbmaAddr=nhrpCacheNbmaAddr, nhrpCompliances=nhrpCompliances, nhrpServerStatRxPurgeReply=nhrpServerStatRxPurgeReply, nhrpClientNhsNbmaSubaddr=nhrpClientNhsNbmaSubaddr, nhrpServerStatRxErrLoopDetected=nhrpServerStatRxErrLoopDetected, nhrpServerStatTxResolveReplyAck=nhrpServerStatTxResolveReplyAck, nhrpClientNbmaAddrType=nhrpClientNbmaAddrType, nhrpClientNhsTable=nhrpClientNhsTable, nhrpServerStatRxErrSduSizeExceeded=nhrpServerStatRxErrSduSizeExceeded, nhrpServerStatRxResolveReq=nhrpServerStatRxResolveReq, nhrpClientHoldTime=nhrpClientHoldTime, nhrpClientStatTxPurgeReply=nhrpClientStatTxPurgeReply, nhrpServerNhcPrefixLength=nhrpServerNhcPrefixLength, nhrpServerRowStatus=nhrpServerRowStatus, nhrpGeneralObjects=nhrpGeneralObjects, nhrpServerStatDiscontinuityTime=nhrpServerStatDiscontinuityTime, nhrpServerNhcIndex=nhrpServerNhcIndex, nhrpPurgeReqEntry=nhrpPurgeReqEntry, nhrpClientStatTxResolveReq=nhrpClientStatTxResolveReq, nhrpNextIndex=nhrpNextIndex, nhrpServerStatFwErrorIndication=nhrpServerStatFwErrorIndication, nhrpClientIndex=nhrpClientIndex, nhrpCachePrefixLength=nhrpCachePrefixLength, nhrpClientStatRxErrUnrecognizedExtension=nhrpClientStatRxErrUnrecognizedExtension, NhrpGenAddr=NhrpGenAddr, nhrpServerStatTxResolveReplyNakNotUnique=nhrpServerStatTxResolveReplyNakNotUnique, nhrpClientRequestID=nhrpClientRequestID, nhrpServerStatEntry=nhrpServerStatEntry, nhrpClientNhsInternetworkAddr=nhrpClientNhsInternetworkAddr, nhrpClientStatRxResolveReplyNakProhibited=nhrpClientStatRxResolveReplyNakProhibited, nhrpCacheInternetworkAddr=nhrpCacheInternetworkAddr, nhrpCacheNbmaSubaddr=nhrpCacheNbmaSubaddr, nhrpServerObjects=nhrpServerObjects, nhrpServerStatTxRegisterNakAlreadyReg=nhrpServerStatTxRegisterNakAlreadyReg, nhrpClientStatRxResolveReplyNakInsufResources=nhrpClientStatRxResolveReplyNakInsufResources, nhrpClientStatRxErrProtoAddrUnreachable=nhrpClientStatRxErrProtoAddrUnreachable, nhrpClientStatTxPurgeReq=nhrpClientStatTxPurgeReq, nhrpServerStatRxErrUnrecognizedExtension=nhrpServerStatRxErrUnrecognizedExtension, nhrpPurgeRowStatus=nhrpPurgeRowStatus, nhrpServerStatTxErrProtoError=nhrpServerStatTxErrProtoError, nhrpClientStatRxPurgeReq=nhrpClientStatRxPurgeReq, nhrpServerStatRxErrProtoError=nhrpServerStatRxErrProtoError, nhrpServerStorageType=nhrpServerStorageType, nhrpClientStatRxResolveReplyNakNoBinding=nhrpClientStatRxResolveReplyNakNoBinding, nhrpServerStatTxErrLoopDetected=nhrpServerStatTxErrLoopDetected, nhrpClientStorageType=nhrpClientStorageType, nhrpClientStatRxErrSduSizeExceeded=nhrpClientStatRxErrSduSizeExceeded, nhrpClientNhsInternetworkAddrType=nhrpClientNhsInternetworkAddrType, nhrpClientStatRxRegisterNakProhibited=nhrpClientStatRxRegisterNakProhibited, nhrpCacheEntry=nhrpCacheEntry, nhrpClientInternetworkAddr=nhrpClientInternetworkAddr, nhrpCacheNextHopInternetworkAddr=nhrpCacheNextHopInternetworkAddr, nhrpServerNbmaSubaddr=nhrpServerNbmaSubaddr, nhrpCacheType=nhrpCacheType, nhrpServerStatTxErrInvalidExtension=nhrpServerStatTxErrInvalidExtension, nhrpClientNbmaSubaddr=nhrpClientNbmaSubaddr, nhrpCacheHoldingTimeValid=nhrpCacheHoldingTimeValid, nhrpCacheNbmaAddrType=nhrpCacheNbmaAddrType, nhrpPurgeReqTable=nhrpPurgeReqTable, nhrpClientTable=nhrpClientTable, nhrpClientNhsEntry=nhrpClientNhsEntry, nhrpClientStatRxResolveReplyAck=nhrpClientStatRxResolveReplyAck, nhrpServerStatRxErrInvalidExtension=nhrpServerStatRxErrInvalidExtension, nhrpCachePreference=nhrpCachePreference, nhrpServerStatRxErrAuthenticationFailure=nhrpServerStatRxErrAuthenticationFailure, nhrpClientStatRxErrAuthenticationFailure=nhrpClientStatRxErrAuthenticationFailure, nhrpClientRegUniqueness=nhrpClientRegUniqueness, nhrpPurgeIndex=nhrpPurgeIndex, nhrpServerNhcNbmaAddrType=nhrpServerNhcNbmaAddrType, nhrpServerIndex=nhrpServerIndex, nhrpClientRegistrationTable=nhrpClientRegistrationTable, nhrpServerStatRxPurgeReq=nhrpServerStatRxPurgeReq, nhrpClientStatRxRegisterNakAlreadyReg=nhrpClientStatRxRegisterNakAlreadyReg)
