# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class LinkedIntegrationRuntime(Model):
    """The linked integration runtime information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The name of the linked integration runtime.
    :vartype name: str
    :ivar subscription_id: The subscription ID for which the linked
     integration runtime belong to.
    :vartype subscription_id: str
    :ivar data_factory_name: The name of the data factory for which the linked
     integration runtime belong to.
    :vartype data_factory_name: str
    :ivar data_factory_location: The location of the data factory for which
     the linked integration runtime belong to.
    :vartype data_factory_location: str
    :ivar create_time: The creating time of the linked integration runtime.
    :vartype create_time: datetime
    """

    _validation = {
        'name': {'readonly': True},
        'subscription_id': {'readonly': True},
        'data_factory_name': {'readonly': True},
        'data_factory_location': {'readonly': True},
        'create_time': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'data_factory_name': {'key': 'dataFactoryName', 'type': 'str'},
        'data_factory_location': {'key': 'dataFactoryLocation', 'type': 'str'},
        'create_time': {'key': 'createTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(LinkedIntegrationRuntime, self).__init__(**kwargs)
        self.name = None
        self.subscription_id = None
        self.data_factory_name = None
        self.data_factory_location = None
        self.create_time = None
