**Works for:**

  - booleans
  - functions
  - numbers (pass `true` as the last arg to treat zero as a value instead of falsey)
  - strings
  - nulls
  - object
  - arrays

## Usage
Works with nested object paths or a single value:

```js
var hasValue = require('{%= name %}');

hasValue({a: {b: {c: 'foo'}}} 'a.b.c');
//=> true

hasValue('a');
//=> true

hasValue('');
//=> false

hasValue(1);
//=> true

hasValue(0);
//=> false

hasValue(0, true); // pass `true` as the last arg to treat zero as a value
//=> true

hasValue({a: 'a'}});
//=> true

hasValue({}});
//=> false

hasValue(['a']);
//=> true

hasValue([]);
//=> false

hasValue(function(foo) {}); // function length/arity
//=> true

hasValue(function() {});
//=> false

hasValue(true);
hasValue(false);
//=> true
```

## isEmpty

To do the opposite and test for empty values, do:

```js
function isEmpty(o, isZero) {
  return !hasValue.apply(hasValue, arguments);
}
```
