/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d.intermediate.filters;

import de.erichseifert.vectorgraphics2d.intermediate.CommandSequence;
import de.erichseifert.vectorgraphics2d.intermediate.commands.AffineTransformCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.Command;
import de.erichseifert.vectorgraphics2d.intermediate.commands.CreateCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.DisposeCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.SetTransformCommand;
import de.erichseifert.vectorgraphics2d.intermediate.commands.TransformCommand;
import de.erichseifert.vectorgraphics2d.intermediate.filters.StreamingFilter;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;

public class AbsoluteToRelativeTransformsFilter
extends StreamingFilter {
    private Stack<AffineTransform> transforms = new Stack();

    public AbsoluteToRelativeTransformsFilter(CommandSequence commandSequence) {
        super(commandSequence);
    }

    @Override
    public Command<?> next() {
        Object object = super.next();
        if (object instanceof AffineTransformCommand) {
            AffineTransformCommand affineTransformCommand = (AffineTransformCommand)object;
            this.getCurrentTransform().concatenate((AffineTransform)affineTransformCommand.getValue());
        } else if (object instanceof CreateCommand) {
            AffineTransform affineTransform = this.transforms.isEmpty() ? new AffineTransform() : new AffineTransform(this.getCurrentTransform());
            this.transforms.push(affineTransform);
        } else if (object instanceof DisposeCommand) {
            this.transforms.pop();
        }
        return object;
    }

    @Override
    protected List<Command<?>> filter(Command<?> command) {
        if (command instanceof SetTransformCommand) {
            Object object;
            SetTransformCommand setTransformCommand = (SetTransformCommand)command;
            AffineTransform affineTransform = (AffineTransform)setTransformCommand.getValue();
            AffineTransform affineTransform2 = new AffineTransform();
            try {
                object = this.getCurrentTransform().createInverse();
                affineTransform2.concatenate((AffineTransform)object);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                noninvertibleTransformException.printStackTrace();
            }
            affineTransform2.concatenate(affineTransform);
            object = new TransformCommand(affineTransform2);
            return Arrays.asList(object);
        }
        return Arrays.asList(command);
    }

    private AffineTransform getCurrentTransform() {
        return this.transforms.peek();
    }
}

