// $Id: LockingException.java 5671 2008-04-24 15:41:25Z manik.surtani@jboss.com $

/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.cache.lock;

import org.jboss.cache.CacheException;

import java.util.Map;


/**
 * Used for all locking-related exceptions, e.g. when  a lock could not be
 * acquired within the timeout, or when a deadlock was detected or an upgrade failed.
 *
 * @author <a href="mailto:bela@jboss.org">Bela Ban</a>.
 */

public class LockingException extends CacheException
{

   private static final long serialVersionUID = 5551396474793902133L;

   /**
    * A list of all nodes that failed to acquire a lock
    */
   Map failed_lockers = null;

   public LockingException()
   {
      super();
   }

   public LockingException(Map failed_lockers)
   {
      super();
      this.failed_lockers = failed_lockers;
   }

   public LockingException(String msg)
   {
      super(msg);
   }

   public LockingException(String msg, Map failed_lockers)
   {
      super(msg);
      this.failed_lockers = failed_lockers;
   }

   public LockingException(String msg, Throwable cause)
   {
      super(msg, cause);
   }

   public LockingException(String msg, Throwable cause, Map failed_lockers)
   {
      super(msg, cause);
      this.failed_lockers = failed_lockers;
   }

   @Override
   public String toString()
   {
      String retval = super.toString();
      if (failed_lockers != null && failed_lockers.size() > 0)
         retval = retval + ", failed lockers: " + failed_lockers;
      return retval;
   }

}
