
// -*- mode: c++; c-basic-offset:4 -*-

// This file is part of libdap, A C++ implementation of the OPeNDAP Data
// Access Protocol.

// Copyright (c) 2012 OPeNDAP, Inc.
// Author: James Gallagher <jgallagher@opendap.org>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
//
// You can contact OPeNDAP, Inc. at PO Box 112, Saunderstown, RI. 02874-0112.

#ifndef d4_parse_error_h
#define d4_parse_error_h

#ifndef _error_h
#include "Error.h"
#endif

namespace libdap
{

/** Thrown when the DDX response cannot be parsed.. */
class D4ParseError : public Error
{
public:
    D4ParseError() : Error("The DDX response document parse failed.")
    {}
    D4ParseError(const string &msg) :
            Error(string("The DDX response document parse failed: ") + msg)
    {}
};

} // namespace libdap

#endif // d4_parse_error_h
