/*
 *  preferences_c.h
 *  Atari800MacX
 *
 *  Created by Mark Grebe on Fri Sep 13 2002.
 *  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
 *
 */

#ifndef INCLUDE_PREFERENCESCH
#define INCLUDE_PREFERENCESCH

#include "stdio.h"

typedef struct ATARI800MACX_PREF {
                int fullScreen; 
                int lockFullscreenSize;
                int doubleSize; 
                int scaleFactor;
                int widthMode; 
                int tvMode; 
                int refreshRatio; 
                int artifactingMode;
                int useBuiltinPalette;
                int blackLevel;
                int whiteLevel;
                int intensity;
                int colorShift;
                int adjustPalette;
                char paletteFile[FILENAME_MAX]; 
                int showFPS;
                int atariType; 
                int disableBasic; 
                int enableSioPatch; 
                int enableHPatch; 
                int enablePPatch;
                int enableRPatch;
                int rPatchPort;
                char printCommand[FILENAME_MAX];
                int bootFromCassette; 
                int speedLimit; 
                int enableSound; 
                int enableHifiSound; 
                int ignoreHeaderWriteprotect; 
                char hardDiskDir[4][FILENAME_MAX]; 
                int hardDrivesReadOnly;
                char hPath[FILENAME_MAX];
                char osARomFile[FILENAME_MAX]; 
                char osBRomFile[FILENAME_MAX]; 
                char xlRomFile[FILENAME_MAX]; 
                char basicRomFile[FILENAME_MAX];
                char a5200RomFile[FILENAME_MAX];
                char diskImageDir[FILENAME_MAX];
                char diskSetDir[FILENAME_MAX];
                char cartImageDir[FILENAME_MAX];
                char cassImageDir[FILENAME_MAX];
                char exeFileDir[FILENAME_MAX];
                char savedStateDir[FILENAME_MAX]; 
                char dFile[8][FILENAME_MAX]; 
                char cartFile[FILENAME_MAX]; 
                char exeFile[FILENAME_MAX]; 
                char cassFile[FILENAME_MAX]; 
                int dFileEnabled[8];
                int cartFileEnabled;
                int exeFileEnabled;
                int cassFileEnabled;
                int joystickMode[4];
                int joystickAutofire[4];
                int enableMultijoy;
                int mouseDevice;
                int mouseSpeed;
                int mouseMinVal;
                int mouseMaxVal;
                int mouseHOffset;
                int mouseVOffset;
                int mouseInertia;
                int joystick1Type;
                int joystick2Type;
                int joystick3Type;
                int joystick4Type;
                int joystick1Num;
                int joystick2Num;
                int joystick3Num;
                int joystick4Num;
                int buttonAssignment[4][24];
                int button5200Assignment[4][24];
                int paddlesXAxisOnly;
                int leftJoyUp;
                int leftJoyDown;
                int leftJoyLeft;
                int leftJoyRight;
                int leftJoyUpLeft;
                int leftJoyUpRight;
                int leftJoyDownLeft;
                int leftJoyDownRight;
                int leftJoyFire;
                int leftJoyAltFire;
                int padJoyUp;
                int padJoyDown;
                int padJoyLeft;
                int padJoyRight;
                int padJoyUpLeft;
                int padJoyUpRight;
                int padJoyDownLeft;
                int padJoyDownRight;
                int padJoyFire;
                int padJoyAltFire;
} ATARI800MACX_PREF;

ATARI800MACX_PREF *getPrefStorage(void);
void commitPrefs(void);
#endif
