/* window-monitor.c generated by valac 0.56.17, the Vala compiler
 * generated from window-monitor.vala, do not modify */

/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (c) 2009-2010  Mike Massonnet <mmassonnet@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "libnotes.h"
#include <gio/gio.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	XNP_WINDOW_MONITOR_0_PROPERTY,
	XNP_WINDOW_MONITOR_NUM_PROPERTIES
};
static GParamSpec* xnp_window_monitor_properties[XNP_WINDOW_MONITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	XNP_WINDOW_MONITOR_WINDOW_UPDATED_SIGNAL,
	XNP_WINDOW_MONITOR_NOTE_UPDATED_SIGNAL,
	XNP_WINDOW_MONITOR_NOTE_DELETED_SIGNAL,
	XNP_WINDOW_MONITOR_NOTE_CREATED_SIGNAL,
	XNP_WINDOW_MONITOR_NUM_SIGNALS
};
static guint xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NUM_SIGNALS] = {0};

struct _XnpWindowMonitorPrivate {
	GFileMonitor* monitor;
	guint monitor_timeout;
};

static gint XnpWindowMonitor_private_offset;
static gpointer xnp_window_monitor_parent_class = NULL;

static void xnp_window_monitor_monitor_change_cb (XnpWindowMonitor* self,
                                           GFile* file,
                                           GFile* other_file,
                                           GFileMonitorEvent event);
static void _xnp_window_monitor_monitor_change_cb_g_file_monitor_changed (GFileMonitor* _sender,
                                                                   GFile* file,
                                                                   GFile* other_file,
                                                                   GFileMonitorEvent event_type,
                                                                   gpointer self);
static void xnp_window_monitor_window_updated_cb (XnpWindowMonitor* self);
static gboolean __lambda43_ (XnpWindowMonitor* self);
static gboolean ___lambda43__gsource_func (gpointer self);
static void xnp_window_monitor_finalize (GObject * obj);
static GType xnp_window_monitor_get_type_once (void);

static inline gpointer
xnp_window_monitor_get_instance_private (XnpWindowMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, XnpWindowMonitor_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_xnp_window_monitor_monitor_change_cb_g_file_monitor_changed (GFileMonitor* _sender,
                                                              GFile* file,
                                                              GFile* other_file,
                                                              GFileMonitorEvent event_type,
                                                              gpointer self)
{
	xnp_window_monitor_monitor_change_cb ((XnpWindowMonitor*) self, file, other_file, event_type);
}

XnpWindowMonitor*
xnp_window_monitor_construct (GType object_type,
                              XnpWindow* window,
                              GFile* file)
{
	XnpWindowMonitor * self = NULL;
	XnpWindow* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	self = (XnpWindowMonitor*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (self->window);
	self->window = _tmp0_;
	{
		GFileMonitor* _tmp1_ = NULL;
		GFileMonitor* _tmp2_;
		GFileMonitor* _tmp3_;
		GFileMonitor* _tmp4_;
		GFileMonitor* _tmp5_;
		_tmp2_ = g_file_monitor_directory (file, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (self->priv->monitor);
		self->priv->monitor = _tmp3_;
		_tmp4_ = self->priv->monitor;
		g_file_monitor_set_rate_limit (_tmp4_, 1000);
		_tmp5_ = self->priv->monitor;
		g_signal_connect_object (_tmp5_, "changed", (GCallback) _xnp_window_monitor_monitor_change_cb_g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_message ("window-monitor.vala:41: Unable to create a directory monitor: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

XnpWindowMonitor*
xnp_window_monitor_new (XnpWindow* window,
                        GFile* file)
{
	return xnp_window_monitor_construct (XNP_TYPE_WINDOW_MONITOR, window, file);
}

static void
xnp_window_monitor_monitor_change_cb (XnpWindowMonitor* self,
                                      GFile* file,
                                      GFile* other_file,
                                      GFileMonitorEvent event)
{
	gchar* note_name = NULL;
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_get_basename (file);
	note_name = _tmp0_;
	switch (event) {
		case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
		{
			const gchar* _tmp1_;
			_tmp1_ = note_name;
			g_signal_emit (self, xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NOTE_UPDATED_SIGNAL], 0, _tmp1_);
			xnp_window_monitor_window_updated_cb (self);
			break;
		}
		case G_FILE_MONITOR_EVENT_DELETED:
		{
			const gchar* _tmp2_;
			_tmp2_ = note_name;
			g_signal_emit (self, xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NOTE_DELETED_SIGNAL], 0, _tmp2_);
			xnp_window_monitor_window_updated_cb (self);
			break;
		}
		case G_FILE_MONITOR_EVENT_CREATED:
		{
			const gchar* _tmp3_;
			_tmp3_ = note_name;
			g_signal_emit (self, xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NOTE_CREATED_SIGNAL], 0, _tmp3_);
			break;
		}
		default:
		{
			break;
		}
	}
	_g_free0 (note_name);
}

static gboolean
__lambda43_ (XnpWindowMonitor* self)
{
	XnpWindow* _tmp0_;
	gboolean result;
	_tmp0_ = self->window;
	g_signal_emit (self, xnp_window_monitor_signals[XNP_WINDOW_MONITOR_WINDOW_UPDATED_SIGNAL], 0, _tmp0_);
	self->priv->monitor_timeout = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
___lambda43__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda43_ ((XnpWindowMonitor*) self);
	return result;
}

static void
xnp_window_monitor_window_updated_cb (XnpWindowMonitor* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->monitor_timeout != ((guint) 0)) {
		g_source_remove (self->priv->monitor_timeout);
	}
	self->priv->monitor_timeout = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, ___lambda43__gsource_func, g_object_ref (self), g_object_unref);
}

static void
xnp_window_monitor_class_init (XnpWindowMonitorClass * klass,
                               gpointer klass_data)
{
	xnp_window_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &XnpWindowMonitor_private_offset);
	G_OBJECT_CLASS (klass)->finalize = xnp_window_monitor_finalize;
	xnp_window_monitor_signals[XNP_WINDOW_MONITOR_WINDOW_UPDATED_SIGNAL] = g_signal_new ("window-updated", XNP_TYPE_WINDOW_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, XNP_TYPE_WINDOW);
	xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NOTE_UPDATED_SIGNAL] = g_signal_new ("note-updated", XNP_TYPE_WINDOW_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NOTE_DELETED_SIGNAL] = g_signal_new ("note-deleted", XNP_TYPE_WINDOW_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	xnp_window_monitor_signals[XNP_WINDOW_MONITOR_NOTE_CREATED_SIGNAL] = g_signal_new ("note-created", XNP_TYPE_WINDOW_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
xnp_window_monitor_instance_init (XnpWindowMonitor * self,
                                  gpointer klass)
{
	self->priv = xnp_window_monitor_get_instance_private (self);
	self->priv->monitor_timeout = (guint) 0;
}

static void
xnp_window_monitor_finalize (GObject * obj)
{
	XnpWindowMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, XNP_TYPE_WINDOW_MONITOR, XnpWindowMonitor);
	_g_object_unref0 (self->window);
	_g_object_unref0 (self->priv->monitor);
	G_OBJECT_CLASS (xnp_window_monitor_parent_class)->finalize (obj);
}

static GType
xnp_window_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (XnpWindowMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnp_window_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnpWindowMonitor), 0, (GInstanceInitFunc) xnp_window_monitor_instance_init, NULL };
	GType xnp_window_monitor_type_id;
	xnp_window_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "XnpWindowMonitor", &g_define_type_info, 0);
	XnpWindowMonitor_private_offset = g_type_add_instance_private (xnp_window_monitor_type_id, sizeof (XnpWindowMonitorPrivate));
	return xnp_window_monitor_type_id;
}

GType
xnp_window_monitor_get_type (void)
{
	static volatile gsize xnp_window_monitor_type_id__once = 0;
	if (g_once_init_enter (&xnp_window_monitor_type_id__once)) {
		GType xnp_window_monitor_type_id;
		xnp_window_monitor_type_id = xnp_window_monitor_get_type_once ();
		g_once_init_leave (&xnp_window_monitor_type_id__once, xnp_window_monitor_type_id);
	}
	return xnp_window_monitor_type_id__once;
}

