/* $Id: HplPXA27xDMAInfo.nc,v 1.5 2008-06-11 00:42:14 razvanm Exp $ */
/*
 * Copyright (c) 2005 Arched Rock Corporation 
 * All rights reserved. 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *	Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *	Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *  
 *   Neither the name of the Arched Rock Corporation nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE ARCHED
 * ROCK OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
/*
 * This interface is to be PROVIDED by peripheral HPL components that
 * are DMA-able. It is used to provide information to higher level 
 * components (e.g. HalX) that may implement higher level peripheral
 * functions using DMA. 
 *
 * Instantiate the interface multiple times according to how many
 * I/O addresses a peripheral has that may be assigned to a DMA
 * src/tgt address register.
 *
 * Authors:             Phil Buonadonna
 *
 */


interface HplPXA27xDMAInfo
{
  /**
   * Returns a single DMAable address for a peripheral. 
   *
   * @return addr The 32 bit address of the peripheral register
   * of interest.
   */
  async command uint32_t getAddr();

  /**
   * Returns the DMA map index that is associated with the getAddr()
   * function. 
   *
   * @return index The DMA map register index that is  associated with
   * the getAddr function.
   */
  async command uint8_t getMapIndex();
}
