% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress-client.R
\name{cli_progress_bar}
\alias{cli_progress_bar}
\alias{__cli_update_due}
\alias{cli_tick_reset}
\alias{ccli_tick_reset}
\alias{ticking}
\alias{cli_progress_update}
\alias{cli_progress_done}
\title{cli progress bars}
\usage{
cli_progress_bar(
  name = NULL,
  status = NULL,
  type = c("iterator", "tasks", "download", "custom"),
  total = NA,
  format = NULL,
  format_done = NULL,
  format_failed = NULL,
  clear = getOption("cli.progress_clear", TRUE),
  current = TRUE,
  auto_terminate = type != "download",
  extra = NULL,
  .auto_close = TRUE,
  .envir = parent.frame()
)

cli_progress_update(
  inc = NULL,
  set = NULL,
  total = NULL,
  status = NULL,
  extra = NULL,
  id = NULL,
  force = FALSE,
  .envir = parent.frame()
)

cli_progress_done(id = NULL, .envir = parent.frame(), result = "done")
}
\arguments{
\item{name}{This is typically used as a label, and should be short,
at most 20 characters.}

\item{status}{New status string of the progress bar, if not \code{NULL}.}

\item{type}{Type of the progress bar. It is used to select a default
display if \code{format} is not specified. Currently supported types:
\itemize{
\item \code{iterator}: e.g. a for loop or a mapping function,
\item \code{tasks}: a (typically small) number of tasks,
\item \code{download}: download of one file,
\item \code{custom}: custom type, \code{format} must not be \code{NULL} for this type.
}}

\item{total}{Total number of progress units, or \code{NA} if it is unknown.
\code{cli_progress_update()} can update the total number of units. This is
handy if you don't know the size of a download at the beginning, and
also in some other cases. If \code{format} is set to \code{NULL}, \code{format} (plus
\code{format_done} and \code{format_failed}) will be updated when you change
\code{total} from \code{NA} to a number. I.e. default format strings will be
updated, custom ones won't be.}

\item{format}{Format string. It has to be specified for custom progress
bars, otherwise it is optional, and a default display is selected
based on the progress bat type and whether the number of total units
is known. Format strings may contain glue substitution, the support
pluralization and cli styling. See \link{progress-variables} for special
variables that you can use in the custom format.}

\item{format_done}{Format string for successful termination. By default
the same as \code{format}.}

\item{format_failed}{Format string for unsuccessful termination. By
default the same as \code{format}.}

\item{clear}{Whether to remove the progress bar from the screen after
it has terminated. Defaults to the \code{cli.progress_clear} option, or
\code{TRUE} if unset.}

\item{current}{Whether to use this progress bar as the current progress
bar of the calling function. See more at 'The current progress bar'
below.}

\item{auto_terminate}{Whether to terminate the progress bar if the
number of current units reaches the number of total units.}

\item{extra}{Extra data to add to the progress bar. This can be
used in custom format strings for example. It should be a named list.
\code{cli_progress_update()} can update the extra data. Often you can get
away with referring to local variables in the format string, and
then you don't need to use this argument. Explicitly including these
constants or variables in \code{extra} can result in cleaner code. In
the rare cases when you need to refer to the same progress bar from
multiple functions, and you can them to \code{extra}.}

\item{.auto_close}{Whether to terminate the progress bar when the
calling function (or the one with execution environment in \code{.envir}
exits. (Auto termination does not work for progress bars created
from the global environment, e.g. from a script.)}

\item{.envir}{The environment to use for auto-termination and for glue
substitution. It is also used to find and set the current progress bar.}

\item{inc}{Increment in progress units. This is ignored if \code{set} is
not \code{NULL}.}

\item{set}{Set the current number of progress units to this value.
Ignored if \code{NULL}.}

\item{id}{Progress bar to update or terminate. If \code{NULL}, then the
current progress bar of the calling function (or \code{.envir} if
specified) is updated or terminated.}

\item{force}{Whether to force a display update, even if no update is
due.}

\item{result}{String to select successful or unsuccessful termination.
It is only used if the progress bar is not cleared from the screen.
It can be one of \code{"done"}, \code{"failed"}, \code{"clear"}, and \code{"auto"}.}
}
\value{
\code{cli_progress_bar()} returns the id of the new progress bar.
The id is a string constant.

\code{cli_progress_update()} returns the id of the progress bar,
invisibly.

\code{cli_progress_done()} returns \code{TRUE}, invisibly, always.
}
\description{
This is the reference manual of the three functions that create,
update and terminate progress bars. For a tutorial see the
\href{https://cli.r-lib.org/articles/progress.html}{cli progress bars}.

\code{cli_progress_bar()} creates a new progress bar.

\code{cli_progress_update()} updates the state of a progress bar, and
potentially the display as well.

\code{cli_progress_done()} terminates a progress bar.
}
\details{
\subsection{Basic usage}{

\code{cli_progress_bar()} creates a progress bar, \code{cli_progress_update()}
updates an existing progress bar, and \code{cli_progress_done()} terminates
it.

It is good practice to always set the \code{name} argument, to make the
progress bar more informative.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{clean <- function() \{
  cli_progress_bar("Cleaning data", total = 100)
  for (i in 1:100) \{
    Sys.sleep(5/100)
    cli_progress_update()
  \}
  cli_progress_done()
\}
clean()
}\if{html}{\out{</div>}}

\if{html}{\figure{progress-1.svg}}
}

\subsection{Progress bar types}{

There are three builtin types of progress bars, and a custom type.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tasks <- function() \{
  cli_progress_bar("Tasks", total = 3, type = "tasks")
  for (i in 1:3) \{
    Sys.sleep(1)
    cli_progress_update()
  \}
  cli_progress_done()
\}
tasks()
}\if{html}{\out{</div>}}

\if{html}{\figure{progress-tasks.svg}}
}

\subsection{Unknown \code{total}}{

If \code{total} is not known, then cli shows a different progress bar.
Note that you can also set \code{total} in \code{cli_progress_update()}, if it
not known when the progress bar is created, but you learn it later.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{nototal <- function() \{
  cli_progress_bar("Parameter tuning")
  for (i in 1:100) \{
    Sys.sleep(3/100)
    cli_progress_update()
  \}
  cli_progress_done()
\}
nototal()
}\if{html}{\out{</div>}}

\if{html}{\figure{progress-natotal.svg}}
}

\subsection{Clearing the progress bar}{

By default cli removes terminated progress bars from the screen, if
the terminal supports this. If you want to change this, use the
\code{clear} argument of \code{cli_progress_bar()}, or the \code{cli.progress_clear}
global option (see \link{cli-config}) to change this.

(In the cli documentation we usually set \code{cli.progress_clear} to \code{FALSE},
so users can see how finished progress bars look.)

In this example the first progress bar is cleared, the second is not.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fun <- function() \{
  cli_progress_bar("Data cleaning", total = 100, clear = TRUE)
  for (i in 1:100) \{
    Sys.sleep(3/100)
    cli_progress_update()
  \}
  cli_progress_bar("Parameter tuning", total = 100, clear = FALSE)
  for (i in 1:100) \{
    Sys.sleep(3/100)
    cli_progress_update()
  \}
\}
fun()
}\if{html}{\out{</div>}}

\if{html}{\figure{progress-clear.svg}}
}

\subsection{Initial delay}{

Updating a progress bar on the screen is costly, so cli tries to avoid
it for quick loops. By default a progress bar is only shown after two
seconds, or after half of that if less than 50\% of the iterations are
complete. You can change the two second default with the
\code{cli.progress_show_after} global option (see \link{cli-config}).

(In the cli documentation we usually set \code{cli.progress_show_after} to
\code{0} (zero seconds), so progress bars are shown immediately.)

In this example we only show the progress bar after one second, because
more than 50\% of the iterations remain after one second.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fun <- function() \{
  cli_alert("Starting now, at \{Sys.time()\}")
  cli_progress_bar(
    total = 100,
    format = "\{cli::pb_bar\} \{pb_percent\} @ \{Sys.time()\}"
  )
  for (i in 1:100) \{
    Sys.sleep(4/100)
    cli_progress_update()
  \}
\}
options(cli.progress_show_after = 2)
fun()
}\if{html}{\out{</div>}}

\if{html}{\figure{progress-after.svg}}
}

\subsection{The \emph{current} progress bar}{

By default cli sets the new progress bar as the \emph{current} progress bar
of the calling function. The current progress bar is the default one
in cli progress bar operations. E.g. if no progress bar id is supplied
in \code{cli_progress_update()}, then the current progress bar is updated.

Every function can only have a single \emph{current} progress bar, and if a
new one is created, then the previous one (if any) is automatically
terminated. The current progress bar is also terminated when the function
that created it exits. Thanks to these rules, most often you don't need
to explicitly deal with progress bar ids, and you don't need to
explicitly call \code{cli_progress_done()}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fun <- function() \{
  cli_progress_bar("First step ", total = 100)
  for (i in 1:100) \{
    Sys.sleep(2/100)
    cli_progress_update()
  \}
  cli_progress_bar("Second step", total = 100)
  for (i in 1:100) \{
    Sys.sleep(2/100)
    cli_progress_update()
  \}
\}
fun()
}\if{html}{\out{</div>}}

\if{html}{\figure{progress-current.svg}}
}

\subsection{cli output while the progress bar is active}{

cli allows emitting regular cli output (alerts, headers, lists, etc.)
while a progress bar is active. On terminals that support this, cli
will remove the progress bar temporarily, emit the output, and then
restores the progress bar.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fun <- function() \{
  cli_alert_info("Before the progress bar")
  cli_progress_bar("Calculating", total = 100)
  for (i in 1:50) \{
    Sys.sleep(4/100)
    cli_progress_update()
  \}
  cli_alert_info("Already half way!")
  for (i in 1:50) \{
    Sys.sleep(4/100)
    cli_progress_update()
  \}
  cli_alert_info("All done")
\}
fun()
}\if{html}{\out{</div>}}

\if{html}{\figure{progress-output.svg}}

See also \code{\link[=cli_progress_output]{cli_progress_output()}}, which sends text for the current
progress handler. E.g. in a Shiny app it will send the output to the
Shiny progress bar, as opposed to the \code{cli_alert()} etc. cli functions
which will print the text to the console.
}

\subsection{Custom formats}{

In addition to the builtin types, you can also specify a custom
format string. In this case \link[=progress-variables]{progress variables}
are probably useful to avoid calculating some progress bar quantities
like the elapsed time, of the ETA manually. You can also use your own
variables in the calling function:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fun <- function(urls) \{
  cli_progress_bar(
    format = paste0(
      "\{pb_spin\} Downloading \{.path \{basename(url)\}\} ",
      "[\{pb_current\}/\{pb_total\}]   ETA:\{pb_eta\}"
    ),
    format_done = paste0(
      "\{col_green(symbol$tick)\} Downloaded \{pb_total\} files ",
      "in \{pb_elapsed\}."
    ),,
    total = length(urls)
  )
  for (url in urls) \{
    cli_progress_update()
    Sys.sleep(5/10)
  \}
\}
fun(paste0("https://acme.com/data-", 1:10, ".zip"))
}\if{html}{\out{</div>}}

\if{html}{\figure{progress-format.svg}}
}
}
\seealso{
These functions support \link[=inline-markup]{inline markup}.

\code{\link[=cli_progress_message]{cli_progress_message()}} and \code{\link[=cli_progress_step]{cli_progress_step()}} for simpler
progress messages.

Other progress bar functions: 
\code{\link{cli_progress_along}()},
\code{\link{cli_progress_builtin_handlers}()},
\code{\link{cli_progress_message}()},
\code{\link{cli_progress_num}()},
\code{\link{cli_progress_output}()},
\code{\link{cli_progress_step}()},
\code{\link{cli_progress_styles}()},
\code{\link{progress-variables}}

Other functions supporting inline markup: 
\code{\link{cli_abort}()},
\code{\link{cli_alert}()},
\code{\link{cli_blockquote}()},
\code{\link{cli_bullets_raw}()},
\code{\link{cli_bullets}()},
\code{\link{cli_dl}()},
\code{\link{cli_h1}()},
\code{\link{cli_li}()},
\code{\link{cli_ol}()},
\code{\link{cli_process_start}()},
\code{\link{cli_progress_along}()},
\code{\link{cli_progress_message}()},
\code{\link{cli_progress_output}()},
\code{\link{cli_progress_step}()},
\code{\link{cli_rule}},
\code{\link{cli_status_update}()},
\code{\link{cli_status}()},
\code{\link{cli_text}()},
\code{\link{cli_ul}()},
\code{\link{format_error}()},
\code{\link{format_inline}()}
}
\concept{functions supporting inline markup}
\concept{progress bar functions}
