<!--
Please do not combine multiple features or fix actions that are not
directly dependent on one another. Please open multiple PRs instead because
one may be merged while the other is denied or has requested changes. This
will slow down the process of merging the accepted changes as reviews are
also more difficult to evaluate for edge cases.
-->

## Purpose
<!-- Reason for the PR (solves an issue/problem, adds a feature, etc) -->



## Rationale
<!-- How did you come to this conclusion as the solution? What was your reasoning? What were you trying to do? What problems did you find and avoid? -->



## How did you test?
<!--
Please explain the methodology for how you verified this solution. It helps to
describe the primary case and the possible edge cases that you considered and
ultimately how you tested them. If you didn't rule out any edge cases, please
mention the rationale here.
-->



## How to Verify
<!-- Please provide a list of steps to validate your solution -->



---

## PR Completion Checklist

- [ ] Reviewed & followed the [Contributor Guidelines](https://python-semantic-release.readthedocs.io/en/latest/contributing.html)

- [ ] Changes Implemented & Validation pipeline succeeds

- [ ] Commits follow the [Conventional Commits](https://www.conventionalcommits.org/en/v1.0.0/) standard
  and are separated into the proper commit type and scope (recommended order: test, build, feat/fix, docs)

- [ ] Appropriate Unit tests added/updated

- [ ] Appropriate End-to-End tests added/updated

- [ ] Appropriate Documentation added/updated and syntax validated for sphinx build (see Contributor Guidelines)
