###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_uebimiau_webmail_detect.nasl 4797 2009-09-18 16:25:36Z sep $
#
# Uebimiau Webmail Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c)2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901023);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("Uebimiau Webmail Version Detection");
  desc = "
  Overview: This script finds the Uebimiau Webmail version and saves
  the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Set the version of Uebimiau Webmail in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

uwebPort = get_http_port(default:80);
if(!uwebPort){
  exit(0);
}

foreach path (make_list("/", "/uebimiau", "/webmail",  cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/index.php"), port:uwebPort);
  rcvRes = http_send_recv(port:uwebPort, data:sndReq);

  if("Uebimiau Webmail" >< rcvRes)
  {
    uwebVer = eregmatch(pattern:"Webmail v(([0-9.]+)(-[0-9.]+)?)", string:rcvRes);
    if(uwebVer[1] != NULL)
    {
      uwebVer = ereg_replace(pattern:"-", string:uwebVer[1], replace: ".");
      set_kb_item(name:"www/" + uwebPort + "/Uebimiau/Webmail", value:uwebVer
                                                          + " under " + path);
      security_note(data:"Uebimiau Webmail version " + uwebVer +
                         " running at location " + path +
                         " was detected on the host");
    }
  }
}
