###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_blender_cmd_exec_lin.nasl 5657 2009-11-18 14:47:29Z nov $
#
# Blender .blend File Command Execution Vulnerability
#
# Authors:
# Maneesh KB <kmaneesh@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900252);
  script_version("$Revision: 1.1 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-3850");
  script_bugtraq_id(36838);
  script_name("Blender .blend File Command Execution Vulnerability");
  desc = "
  Overview: This host is installed with blender and is prone to Remote
  Command Execution Vulnerability.

  Vulnerability Insight:
  This flaw is generated because Blender allows .blend project files to be
  modified to execute arbitrary commands without user intervention by design.

  Impact:
  Successful exploitation will allow attackers to execute arbitrary commands by
  sending a specially crafted .blend file that contains Python statements in
  the onLoad action of a ScriptLink SDNA.

  Impact Level: Application

  Affected Software/OS:
  Blender 2.49b, 2.40, 2.35a, 2.34 and prior.

  Fix: No solution or patch is available as on 18th November,2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.blender.org/

  References:
  http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2009-3850
  http://www.coresecurity.com/content/blender-scripting-injection

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Blender");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("General");
  script_dependencies("secpod_blender_detect_lin.nasl");
  script_require_keys("Blender/Lin/Ver");
  exit(0);
}


include("version_func.inc");

blendVer = get_kb_item("Blender/Lin/Ver");
if(!blendVer){
  exit(0);
}

#Check if version is equal to 2.49b(2.49.2), 2.40, 2.35a(2.35.1), 2.34 or prior
if(version_is_equal(version:blendVer, test_version:"2.49.2")||
   version_is_equal(version:blendVer, test_version:"2.40")  ||
   version_is_equal(version:blendVer, test_version:"2.35.1")||
   version_is_less_equal(version:blendVer, test_version:"2.34")){
  security_hole(0);
}
