###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_phpx_sql_inj_vuln_nov08.nasl 0459 2008-11-13 15:11:27Z nov $
#
# PHPX news_id SQL Injection Vulnerability - Nov08
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800134);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.8");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2008-5000");
  script_bugtraq_id(23033);
  script_name("PHPX news_id SQL Injection Vulnerability - Nov08");
  desc = "

  Overview: The host is running PHPX, which is prone to SQL Injection
  Vulnerability.

  Vulnerability Insight:
  The flaw is caused due to sql commands with uppercase characters passed
  with the news_id parameter to includes/news.inc.php which is not properly
  sanitised before being used.

  Impact:
  Successful attack could lead to execution of arbitrary sql commands.

  NOTE: Vulnerability exists only when magic_quotes_gpc is disabled.

  Impact Level: Application

  Affected Software/OS:
  PHPX Version 3.5.16 and prior on all running platform.

  Fix: No solution/patch is available as on 13th November, 2008. Information
  regarding this issue will updated once the solution details are available.
  For updates refer, http://phpx.thisrand.com/project.php

  References:
  http://secunia.com/advisories/32564
  http://www.milw0rm.com/exploits/6996

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of PHPX");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Web application abuses");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

dirs = make_list("/phpx", cgi_dirs());
foreach dir (dirs)
{
  sndReq = http_get(item:string(dir + "/index.php"), port:port);
  rcvRes = http_keepalive_send_recv(port:port,data:sndReq,bodyonly:1);
  if(rcvRes == NULL){
    exit(0);
  }

  if(rcvRes =~ "Powered by.+PHPX")
  {
    phpxVer = eregmatch(pattern:"PHPX ([0-9.]+)", string:rcvRes);
    if(phpxVer != NULL)
    {
      # Check for PXPX Version <= 3.5.16
      if(version_is_less_equal(version:phpxVer[1], test_version:"3.5.16")){
        security_hole(0);
      }
    }
    exit(0);
  }
}
