#
#VID ae7124ff-547c-11db-8f1a-000a48049292
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57460);
 script_cve_id("CVE-2006-4600");
 script_bugtraq_id(19832);
 script_version ("$");
 script_tag(name:"cvss_base", value:"2.3");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: openldap-server, openldap-sasl-server";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   openldap-server openldap-sasl-server

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.openldap.org/its/index.cgi/Software%20Bugs?id=4587
http://www.openldap.org/lists/openldap-announce/200608/msg00000.html
http://secunia.com/advisories/21721
http://securitytracker.com/alerts/2006/Sep/1016783.html
http://www.vuxml.org/freebsd/ae7124ff-547c-11db-8f1a-000a48049292.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: openldap-server, openldap-sasl-server";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"openldap-server");
if(!isnull(bver) && revcomp(a:bver, b:"2.3.25")<0) {
    security_note(0, data:"Package openldap-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"openldap-sasl-server");
if(!isnull(bver) && revcomp(a:bver, b:"2.3.25")<0) {
    security_note(0, data:"Package openldap-sasl-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
