# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-3599 (wireshark)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63990);
 script_cve_id("CVE-2009-1210", "CVE-2009-1268", "CVE-2009-1269");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Fedora Core 10 FEDORA-2009-3599 (wireshark)";
 script_name(name);

 desc = "The remote host is missing an update to wireshark
announced via advisory FEDORA-2009-3599.

Update Information:

upgrade to wireshark-1.0.7 fixes various security flaws.
http://www.wireshark.org/security/wnpa-sec-2009-02.html

ChangeLog:

* Fri Apr 10 2009 Radek Vokal  1.0.7-1
- upgrade to 1.0.7
- Several security vulnerabilities have been fixed
(Profinet, CPHAP and LDAP dissectors could crash)

References:

[ 1 ] Bug #493973 - CVE-2009-1210 wireshark: format string in PROFINET dissector
https://bugzilla.redhat.com/show_bug.cgi?id=493973
[ 2 ] Bug #495119 - CVE-2009-1268 Wireshark CHAP dissector crash
https://bugzilla.redhat.com/show_bug.cgi?id=495119
[ 3 ] Bug #495121 - CVE-2009-1269 Wireshark Tektronix .rf5 file crash
https://bugzilla.redhat.com/show_bug.cgi?id=495121

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update wireshark' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-3599

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-3599 (wireshark)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"wireshark", rpm:"wireshark~1.0.7~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark-gnome", rpm:"wireshark-gnome~1.0.7~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark-debuginfo", rpm:"wireshark-debuginfo~1.0.7~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
