# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-2247 (curl)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63494);
 script_cve_id("CVE-2009-0037");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 10 FEDORA-2009-2247 (curl)";
 script_name(name);

 desc = "The remote host is missing an update to curl
announced via advisory FEDORA-2009-2247.

Update Information:

Update to curl-7.19.4 fixes CVE-2009-0037.

ChangeLog:

* Tue Mar  3 2009 Jindrich Novy  7.19.4-1
- update to 7.19.4 (fixes CVE-2009-0037)
- fix leak in curl_easy* functions, thanks to Kamil Dudka
- drop nss-proxy, sslgen, nss-init patches
- update badsocket patch
* Mon Dec 15 2008 Jindrich Novy  7.18.2-9
- release++ because of tag conflict caused by f10/rawhide branch split
* Sun Dec 14 2008 Jindrich Novy  7.18.2-8
- use improved NSS patch, thanks to Rob Crittenden (#472489)

References:

[ 1 ] Bug #485271 - CVE-2009-0037 curl: local file access via unsafe redirects
https://bugzilla.redhat.com/show_bug.cgi?id=485271

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update curl' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-2247

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-2247 (curl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"curl", rpm:"curl~7.19.4~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcurl", rpm:"libcurl~7.19.4~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcurl-devel", rpm:"libcurl-devel~7.19.4~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"curl-debuginfo", rpm:"curl-debuginfo~7.19.4~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
