# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 752-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(54324);
 script_cve_id("CVE-2005-0988", "CVE-2005-1228");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 752-1 (gzip)";
 script_name(name);

 desc = "The remote host is missing an update to gzip
announced via advisory DSA 752-1.

Two problems have been discovered in gzip, the GNU compression
utility.  The Common Vulnerabilities and Exposures project identifies
the following problems.

CVE-2005-0988

Imran Ghory discovered a race condition in the permissions setting
code in gzip.  When decompressing a file in a directory an
attacker has access to, gunzip could be tricked to set the file
permissions to a different file the user has permissions to.

CVE-2005-1228

Ulf Hrnhammar discovered a path traversal vulnerability in
gunzip.  When gunzip is used with the -N option an attacker could
this vulnerability to create files in an arbitrary directory with
the permissions of the user.

For the oldstable distribution (woody) these problems have been fixed in
version 1.3.2-3woody5.

For the stable distribution (sarge) these problems have been fixed in
version 1.3.5-10.

For the unstable distribution (sid) these problems have been fixed in
version 1.3.5-10.

We recommend that you upgrade your gzip package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20752-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 752-1 (gzip)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"gzip", ver:"1.3.2-3woody5", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
