# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1664-1 (ekg)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61854);
 script_cve_id("CVE-2008-4776");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1664-1 (ekg)";
 script_name(name);

 desc = "The remote host is missing an update to ekg
announced via advisory DSA 1664-1.

It was discovered that ekg, a console Gadu Gadu client performs
insufficient input sanitising in the code to parse contact descriptions,
which may result in denial of service.

For the stable distribution (etch), this problem has been fixed in
version 1:1.7~rc2-1etch2.

For the unstable distribution (sid) and the upcoming stable distribution
(lenny), this problem has been fixed in version 1:1.8~rc1-2 of libgadu.

We recommend that you upgrade your ekg package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201664-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1664-1 (ekg)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libgadu3", ver:"1.7~rc2-1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgadu-dev", ver:"1.7~rc2-1etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ekg", ver:"1.7~rc2-1etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
