SUBROUTINE ABOR1(CDTEXT)

USE PARKIND1  ,ONLY : JPIM     ,JPRB
USE YOMLUN_IFSAUX, ONLY : NULOUT,NULERR
USE MPL_MODULE, ONLY : MPL_ABORT, MPL_RANK, MPL_NUMPROC
USE SDL_MOD, ONLY : SDL_TRACEBACK, SDL_SRLABORT

IMPLICIT NONE

CHARACTER(LEN=*), INTENT(IN) :: CDTEXT
INTEGER(KIND=JPIM) :: ILEN

ILEN=LEN(CDTEXT)
IF (NULOUT >= 0) WRITE(NULOUT,'(1X,A)') 'ABOR1 CALLED'

IF(ILEN <= 512) THEN
  IF (NULOUT >= 0) WRITE(NULOUT,'(1X,A)') CDTEXT
  IF (NULERR >= 0) WRITE(NULERR,'(1X,A,1X,I3,1X,A)') 'ABORT! ',MPL_RANK,CDTEXT
ELSE
  IF (NULERR >= 0) WRITE(NULERR,'(1X,A,1X,I3,1X,A)') 'ABORT! ',MPL_RANK,&
   & 'ABOR1 CALLED WITHOUT TEXT STRING'  
ENDIF

IF (NULOUT >= 0) THEN
  CALL FLUSH(NULOUT)
  IF (NULOUT /= 0 .and. NULOUT /= 6) CLOSE(NULOUT)
ENDIF

IF (MPL_NUMPROC > 1) THEN
  IF(ILEN <= 512) THEN
    CALL MPL_ABORT(CDTEXT)
  ELSE
    CALL MPL_ABORT
  ENDIF
ELSE
  CALL SDL_TRACEBACK
  CALL FLUSH(0)
  CALL SDL_SRLABORT
ENDIF

END SUBROUTINE ABOR1

SUBROUTINE ABOR1FL(CDFILE, KLINENUM, CDTEXT)
USE PARKIND1  ,ONLY : JPIM
USE YOMLUN_IFSAUX, ONLY : NULOUT,NULERR
IMPLICIT NONE
CHARACTER(LEN=*), INTENT(IN) :: CDFILE,CDTEXT
INTEGER(KIND=JPIM), INTENT(IN) :: KLINENUM
IF (LEN(CDFILE) > 0 .AND. KLINENUM > 0 .AND. NULERR >= 0) THEN
 1000 FORMAT(1X,A,A,":",I6.6)
  WRITE(NULERR,1000) 'ABOR1FL HAS BEEN CALLED AT ',CDFILE,KLINENUM
  CALL FLUSH(NULERR)
ENDIF
CALL ABOR1(CDTEXT)
END SUBROUTINE ABOR1FL
