/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Glaisher-Kinkelin constant.
*
* @module @stdlib/constants/float64/glaisher-kinkelin
* @type {number}
*
* @example
* var A = require( '@stdlib/constants/float64/glaisher-kinkelin' );
* // returns 1.2824271291006226
*/


// MAIN //

/**
* Glaisher-Kinkelin constant.
*
* @constant
* @type {number}
* @default 1.2824271291006226
* @see [OEIS]{@link https://oeis.org/A074962}
* @see [Wikipedia]{@link https://en.wikipedia.org/wiki/Glaisher%E2%80%93Kinkelin_constant}
*/
var A = 1.28242712910062263687534256886979172776768892732500119206374002174040630885882646112973649195820237439420646120; // eslint-disable-line max-len


// EXPORTS //

module.exports = A;
