game.codepage="UTF-8"
game.err = "Ошибка!"
game.dsc = [[Команды:^
    look(или просто ввод), act <на что> (или просто на что), use <что> [на что], go <куда>,^
    back, inv, way, obj, quit, save <fname>, load <fname>. Работает автодополнение по табуляции.^^]];

main = room {
	nam = 'Обучение',
	act = function()
		return goto('r1');
	end,
	dsc = [[Добро пожаловать в режим обучения instead (readline версия).
Ввод команд в игре осуществляется с клавиатуры. Каждая сцена игры представляет собой 
описание статической и динамической части. Для просмотра сцены вы можете набрать look
и нажать ввод или просто нажать ввод. При наборе команд работает режим автодополнения по табуляции,
например, вы можете набрать l и нажать tab. ^^

Данный текст также является сценой, так что вы можете попробовать команду look прямо сейчас.

Динамическая часть сцены состоит из объектов, персонажей и т.д. С динамической частью
игрок может взаимодействовать с помощью команды act <объект>. При этом, так как это наиболее
часто используемая команда, слово act можно пропускать. В данной сцене единственным объектом
является объект "Дальше" -- который вы видите внизу текста. Итак, для продолжения обучения вы можете:
нажать табуляцию (при этом выберется единственный объект сцены) или набрать act табуляция -- 
и нажать ввод.
]],
	obj = { 
		vobj(1, 'Дальше', '{Дальше}'),
	},
};
apple = obj {
	nam = 'яблоко',
	dsc = 'На полу лежит {яблоко}.',
	tak = 'Вы взяли яблоко.',
	inv = function(s)
		s._seen = true;
		if s._knife then
			inv():del('apple');
			return 'Яблоко почищено! Вы его съели.';
		end
		return 'Выглядит аппетитно!';
	end,
	used = function(s, w)
		if w == 'knife' and not s._knife and here() == r4 then
			s._knife = true;
			return 'Вы чистите яблоко.';
		end
	end,
};
knife = obj {
	nam = 'нож',
	dsc = 'На полу лежит {нож}.',
	tak = 'Вы взяли нож.',
	inv = function(s)
		s._seen = true;
		return 'Острый нож.';
	end,
};

r1 = room {
	enter = function()
		lifeon('r1');
	end,
	exit = function()
		lifeoff('r1');
	end,
	life = function()
		if have('apple') and have('knife') then
			return goto('r2');
		end
	end,
	nam = 'урок 1',
	dsc = [[Продолжим урок. Сейчас вы находитесь в комнате. Возьмите оба предмета, которые вы видите в этой комнате.
Напомним, что для этого вы можете нажать таб и выбрать предмет по первой букве или цифре, или начать с команды act.]],
	obj = { 'apple', 'knife' },
};

r2 = room {
	nam = 'урок 2',
	enter = function()
		lifeon('r2');
	end,
	exit = function()
		lifeoff('r2');
	end,
	life = function()
		if apple._seen and knife._seen then
			return goto('r3');
		end
	end,
	dsc = [[Отлично!! Теперь у вас появились предметы, которые вы можете использовать или изучать.
Для этого используется команда use. Не забывайте про автодополнение по tab. Вы можете смотреть свой инвентарь 
с помощью команды inv или просто use и табуляция. Итак, посмотрите на ножик. Начните с команды use, потом нажмите табуляцию
и выберете среди предметов нож. Затем, повторите эту операцию с яблоком.]],
};

tabl = obj {
	nam = 'стол',
	dsc = 'На этом уроке вы видите деревянный {стол}.',
	act = function(s)
		if s._knife then
			s._seen = true;
			return 'На столе стоит ваш автограф.';
		end
		return 'Обычный стол, из дуба.';
	end,
	used = function(s, w)
		if w == 'knife' and not s._knife then
			s._knife = true;
			return 'Вы вырезаете что-то ножиком на столе.';
		end
	end,
	obj = { 'vasa' },
};

vasa = obj {
	nam = 'ваза',
	dsc = 'На столе стоит {ваза}.';
	act = 'Ваза как ваза.';
}

r3 = room {
	nam = 'урок 3',
	enter = function()
		lifeon('r3');
	end,
	exit = function()
		lifeoff('r3');
	end,
	life = function()
		if tabl._seen then
			return goto('r4');
		end
	end,
	dsc = [[Хорошо! Как вы заметили, возле предметов инвентаря стоит символ (*). Вы можете действовать
предметами инвентаря на другие предметы сцены или инвентаря. Попробуйте использовать нож на стол. 
Для этого наберите use, нажмите табуляцию и выберите нож, затем опять нажмите табуляцию и выберите стол. Затем 
посмотрите на стол командой act табуляция стол или просто нажав табуляцию и выбрав стол.]],
	obj = { 'tabl' },
};

r4 = room {
	nam = 'урок 4',
	enter = function()
		apple._knife = false;
		lifeon('r4');
	end,
	exit = function()
		lifeoff('r4');
	end,
	life = function()
		if not have('apple') then
			return goto('r5');
		end
	end,
	dsc = [[Ладно, а теперь -- почистите яблоко. Для этого используйте команду use. Затем съешьте яблоко.]],
};

r5 = room {
	nam = 'урок 5',
	dsc = [[Хорошо. Изучаем команду go -- идти. Наберите go и нажмите табуляцию. Идите на урок 6.]],
	exit = function(s, t)
		if t ~= 'r6' then
			return 'Я просил идти на урок 6...', false;
		end
	end,
	way = { 'r1', 'r2', 'r3', 'r4', 'r6'},
};

r6 = room {
	nam = 'урок 6',
	dsc = [[Вы можете посмотреть все пути с помощью команды way или go табуляция. Идите на последний урок.]],
	exit = function(s, t)
		if t ~= 'theend' then
			return 'Я просил идти на последний урок...', false;
		end
	end,
	way = { 'r1', 'r2', 'r3', 'r4', 'r6', 'theend'},
};

theend = room {
	nam = 'последний урок',
	dsc = [[Вы можете сохранять игру: save имяфайла и считывать игру: load имяфайла. Для выхода наберите quit
Вы можете нажимать control-u для use, control-a для act, control-g для go. Удачи!!!]],
};

