#!/bin/sh

#BEGIN DEPEND------------------------------------------------------------------
INPUT_MODULE=src/lib/perl5/COD/CIF/DDL/DDLm.pm
#END DEPEND--------------------------------------------------------------------

IMPORT_MODULE=$(\
    echo ${INPUT_MODULE} | \
    perl -pe "s|^src/lib/perl5/||; s/[.]pm$//; s|/|::|g;" \
)

TEST_SCRIPT=$(cat <<'END_SCRIPT'
#------------------------------------------------------------------------------
#$Author: antanas $
#$Date: 2024-05-26 16:42:43 +0300 (Sun, 26 May 2024) $ 
#$Revision: 10064 $
#$URL: svn+ssh://www.crystallography.net/home/coder/svn-repositories/cod-tools/tags/v3.11.0/tests/shtests/get_type_content_006.sh $
#------------------------------------------------------------------------------
#*
#* Unit test for the COD::CIF::DDL::DDLm::get_type_contents() subroutine.
#* Tests the way a specific sequence of 'Implied' and 'ByReference'
#* types is handled ('Implied' -> 'ByReference').
#**

use strict;
use warnings;

# use COD::CIF::DDL::DDLm qw( get_type_contents );

my $data_name = '_test_type.implied';
my $data_frame = {
    'values' => {
        '_definition.id' => [ '_test_type.by_reference' ],
        '_type.contents' => [ 'ByReference' ]
    }
};
my $dictionary = {
    'Item' => {
        $data_name => {
            'values' => {
                '_type.contents' => [ 'Implied' ],
            }
        },
        '_test_type.by_reference' => {
            'values' => {
                '_type.contents' => [ 'ByReference' ],
                '_type.contents_referenced_id' =>
                    [ '_test_type.by_reference_final' ]
            }
        },
        '_test_type.by_reference_final' => {
            'values' => {
                '_type.contents' => [ 'Real' ]
            }
        },
    }
};

# Resolution of the 'ByReference' type disabled
# Resolution of the 'Implied' type disabled
my $options = {
    'resolve_byreference_type' => 0,
    'resolve_implied_type'     => 0,
};
print 'Resolution of the \'ByReference\' type disabled, ' .
      'resolution of the \'Implied\' type disabled:';
print "\n    '";
print get_type_contents(
            $data_name,
            $data_frame,
            $dictionary,
            $options,
      );
print "'\n\n";

# Resolution of the 'ByReference' type enabled
# Resolution of the 'Implied' type enabled
$options = {
    'resolve_byreference_type' => 1,
    'resolve_implied_type'     => 1,
};
print 'Resolution of the \'ByReference\' type enabled, ' .
      'resolution of the \'Implied\' type enabled:';
print "\n    '";
print get_type_contents(
            $data_name,
            $data_frame,
            $dictionary,
            $options,
      );
print "'\n\n";

# Resolution of the 'ByReference' type enabled
# Resolution of the 'Implied' type disabled
$options = {
    'resolve_byreference_type' => 1,
    'resolve_implied_type'     => 0,
};
print 'Resolution of the \'ByReference\' type enabled, ' .
      'resolution of the \'Implied\' type enabled:';
print "\n    '";
print get_type_contents(
            $data_name,
            $data_frame,
            $dictionary,
            $options,
      );
print "'\n\n";

# Resolution of the 'ByReference' type disabled
# Resolution of the 'Implied' type enabled
$options = {
    'resolve_byreference_type' => 0,
    'resolve_implied_type'     => 1,
};
print 'Resolution of the \'ByReference\' type disabled, ' .
      'resolution of the \'Implied\' type enabled:';
print "\n    '";
print get_type_contents(
            $data_name,
            $data_frame,
            $dictionary,
            $options,
      );
print "'\n\n";

END_SCRIPT
)

perl -M"${IMPORT_MODULE} qw( get_type_contents )" \
     -e "${TEST_SCRIPT}" | \
perl -0777 -lne 'print $_;'
