# Print Debian packages providing sibling packages list.
# USAGE: dependencies_siblings_list_debian $dependencies_siblings
dependencies_siblings_list_debian() {
	local dependencies_siblings
	dependencies_siblings="$1"

	local dependency_sibling
	while read -r dependency_sibling; do
		dependencies_sibling_single_debian "$dependency_sibling"
	done <<- EOL
	$(printf '%s' "$dependencies_siblings")
	EOL
}

# Print Debian package providing given single sibling package.
# USAGE: dependencies_sibling_single_debian $dependency_sibling
dependencies_sibling_single_debian() {
	local dependency_sibling
	dependency_sibling="$1"

	local package_id
	package_id=$(package_id "$dependency_sibling")
	printf '%s\n' "$package_id"
}

