/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.Reservation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeInstancesResult {
    private List<Reservation> reservations;
    private String nextToken;

    public List<Reservation> getReservations() {
        if (this.reservations == null) {
            this.reservations = new ArrayList<Reservation>();
        }
        return this.reservations;
    }

    public void setReservations(Collection<Reservation> reservations) {
        if (reservations == null) {
            this.reservations = null;
            return;
        }
        ArrayList<Reservation> reservationsCopy = new ArrayList<Reservation>(reservations.size());
        reservationsCopy.addAll(reservations);
        this.reservations = reservationsCopy;
    }

    public DescribeInstancesResult withReservations(Reservation ... reservations) {
        if (this.getReservations() == null) {
            this.setReservations(new ArrayList<Reservation>(reservations.length));
        }
        for (Reservation value : reservations) {
            this.getReservations().add(value);
        }
        return this;
    }

    public DescribeInstancesResult withReservations(Collection<Reservation> reservations) {
        if (reservations == null) {
            this.reservations = null;
        } else {
            ArrayList<Reservation> reservationsCopy = new ArrayList<Reservation>(reservations.size());
            reservationsCopy.addAll(reservations);
            this.reservations = reservationsCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeInstancesResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.reservations != null) {
            sb.append("Reservations: " + this.reservations + ", ");
        }
        if (this.nextToken != null) {
            sb.append("NextToken: " + this.nextToken + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReservations() == null ? 0 : ((Object)this.getReservations()).hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesResult)) {
            return false;
        }
        DescribeInstancesResult other = (DescribeInstancesResult)obj;
        if (other.getReservations() == null ^ this.getReservations() == null) {
            return false;
        }
        if (other.getReservations() != null && !((Object)other.getReservations()).equals(this.getReservations())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }
}

